use std::sync::atomic::{
    AtomicI16, AtomicI32, AtomicI64, AtomicI8, AtomicIsize, AtomicU16,
    AtomicU32, AtomicU64, AtomicU8, AtomicUsize, Ordering,
};

/// A permissible metric value type
pub trait Value: crate::Sealed {
    /// Convert the value to a string that Prometheus can understand
    fn to_prometheus_string(&self, order: Ordering) -> String;
}

macro_rules! impl_value {
    ($name:ident, $non_atomic:ident) => {
        impl Value for $name {
            fn to_prometheus_string(&self, order: Ordering) -> String {
                self.load(order).to_string()
            }
        }
    };
}

impl_value!(AtomicI8, i8);
impl_value!(AtomicI16, i16);
impl_value!(AtomicI32, i32);
impl_value!(AtomicI64, i64);
impl_value!(AtomicIsize, isize);

impl_value!(AtomicU8, u8);
impl_value!(AtomicU16, u16);
impl_value!(AtomicU32, u32);
impl_value!(AtomicU64, u64);
impl_value!(AtomicUsize, usize);
