use std::sync::atomic::Ordering;

pub mod counter;
pub mod gauge;

/// A kind of metric
pub trait Metric<W>: crate::sealed::Sealed
where
    W: std::fmt::Write,
{
    /// Convert the metric to lines that Prometheus can understand
    fn to_prometheus_lines(&self, buf: &mut W, order: Ordering);
}
