use std::sync::atomic::{AtomicU8, Ordering};

use hesione::{Gauge, Hesione};

#[derive(Hesione)]
struct Metrics {
    up: Gauge<AtomicU8>,
}

fn main() {
    let m = Metrics::default();

    let actual = m.to_prometheus_lines(Ordering::SeqCst, Some(32));

    let expected = "# TYPE up gauge\n\n";

    assert_eq!(actual, expected);
}
