use crate::handler::Handler;

pub struct State<StateId: Copy + Clone, Input> {
    id: StateId,
    handler: Box<dyn Handler<StateId, Input>>,
}

impl<StateId: Copy, Input> State<StateId, Input> {
    pub fn new(id: StateId, handler: Box<dyn Handler<StateId, Input>>) -> Self {
        Self { id, handler }
    }

    pub fn id(&self) -> StateId {
        self.id
    }

    pub fn handle_input(&mut self, input: &Input) -> Option<StateId> {
        self.handler.handle_input(input)
    }
}