# hep

 use HEP Network Protocol Specification

 HEP v3 (Homer Encapsulation Protocol Version 3) transmits packets over UDP/TCP/SCTP connections.

 Support HEP v1 HEP v2 HEP v3.

HEP v2 just support ipv4.

hep v1 format:

| index | remark         |
| ----- | -------------- |
| 0     | hep version    |
| 1..   | packet payload |



hep v2 format:

| index | remark                          |
| ----- | ------------------------------- |
| 0     | hep version, static value: 2    |
| 1     | hep header length               |
| 2     | ip protocol family              |
| 3     | translation type                |
| 4-5   | source port                     |
| 6-7   | destination port                |
| 8-11  | source ip                       |
| 12-15 | destination ip                  |
| 16-19 | time-stamp seconds              |
| 20-23 | time-stamp micro seconds offset |
| 24-27 | capture id                      |
| 28..  | packet payload                  |



hep v3 format:

please see https://github.com/sipcapture/HEP



## Examples

```
use hep::parse_packet;
use std::net::UdpSocket;

fn main() -> std::io::Result<()> {

    let socket = UdpSocket::bind("169.254.165.11:9060").expect("couldn't bind to address");
    loop {
        let mut buffer = [0x0; 0xdbba0];
        let (number_of_bytes, src_addr) =
            socket.recv_from(&mut buffer).expect("Didn't receive data");
        let filled_buf = &mut buffer[..number_of_bytes];

        /// data allways return Hep v3 format.
        ///     :if hep v1 or v2, futrue is default value.
        ///     :Hep v3 format,see sturct Chunk
        let data = parse_packet(&filled_buf);
        
        match data {
            Ok(chunk) => {
                println!("Message length:{}", &chunk.packet_payload.len());
                if chunk.packet_payload.len() > 6 {
                    println!(
                        "Received Hep(sip) Message from IP:{}, CaptureId:{}\n{}",
                        src_addr, 
                        chunk.capture_agent_id, 
                        chunk.packet_payload
                    );
                } else {
                    println!(
                        "Received Hep(Keepalive) Message from IP:{}, CaptureId:{}.\n",
                        src_addr, 
                        chunk.capture_agent_id
                    );
                }
            }
            Err(_) => {
                println!(
                    "Received Hep Message from IP:{}\n ignore data.\r\n\r\n",
                    src_addr
                );
            }
        }
    }
}

```



upgrade version:

0.1.0:

create version.



0.1.1:

publish version, add readme.md.



0.1.2:

fix readme.md.

