pub fn get_level_data(level: &str) -> Option<u8> {
    match level {
        "유" | "유치" | "유치원" => Some(1),
        "초" | "초등" | "초등학교" => Some(2),
        "중" | "중등" | "중학교" => Some(3),
        "고" | "고등" | "고등학교" => Some(4),
        "특" | "특수" | "특수학교" => Some(5),
        _ => None,
    }
}

pub fn get_area_data(area: &str) -> Option<(&str, &str)> {
    match area {
        "서울" | "서울시" | "서울특별시" => Some(("01", "sen")),
        "부산" | "부산시" | "부산광역시" => Some(("02", "pen")),
        "대구" | "대구시" | "대구광역시" => Some(("03", "dge")),
        "인천" | "인천시" | "인천광역시" => Some(("04", "ice")),
        "광주" | "광주시" | "광주광역시" => Some(("05", "gen")),
        "대전" | "대전시" | "대전광역시" => Some(("06", "dje")),
        "울산" | "울산시" | "울산광역시" => Some(("07", "use")),
        "세종" | "세종시" | "세종특별시" => Some(("08", "sje")),
        "경기" | "경기도" => Some(("10", "goe")),
        "강원" | "강원도" => Some(("11", "kwe")),
        "충북" | "충청북도" => Some(("12", "cbe")),
        "충남" | "충청남도" => Some(("13", "cne")),
        "전북" | "전라북도" => Some(("14", "jbe")),
        "전남" | "전라남도" => Some(("15", "jne")),
        "경북" | "경상북도" => Some(("16", "gbe")),
        "경남" | "경상남도" => Some(("17", "gne")),
        "제주" | "제주도" | "제주특별자치도" => Some(("18", "jje")),
        _ => None,
    }
}