/*
 * Hetzner Cloud API
 *
 * Copied from the official API documentation for the Public Hetzner Cloud.
 *
 * The version of the OpenAPI document: 0.6.0
 * 
 * Generated by: https://openapi-generator.tech
 */

/// Location : Location the Floating IP was created in. Routing is optimized for this Location. | Location of the Volume. Volume can only be attached to Servers in the same Location.



#[derive(Clone, Debug, PartialEq, Default, Serialize, Deserialize)]
pub struct Location {
    /// City the Location is closest to
    #[serde(rename = "city")]
    pub city: String,
    /// ISO 3166-1 alpha-2 code of the country the Location resides in
    #[serde(rename = "country")]
    pub country: String,
    /// Description of the Location
    #[serde(rename = "description")]
    pub description: String,
    /// ID of the Location
    #[serde(rename = "id")]
    pub id: i32,
    /// Latitude of the city closest to the Location
    #[serde(rename = "latitude")]
    pub latitude: f32,
    /// Longitude of the city closest to the Location
    #[serde(rename = "longitude")]
    pub longitude: f32,
    /// Unique identifier of the Location
    #[serde(rename = "name")]
    pub name: String,
    /// Name of network zone this Location resides in
    #[serde(rename = "network_zone")]
    pub network_zone: String,
}

impl Location {
    /// Location the Floating IP was created in. Routing is optimized for this Location. | Location of the Volume. Volume can only be attached to Servers in the same Location.
    pub fn new(city: String, country: String, description: String, id: i32, latitude: f32, longitude: f32, name: String, network_zone: String) -> Location {
        Location {
            city,
            country,
            description,
            id,
            latitude,
            longitude,
            name,
            network_zone,
        }
    }
}


