/*
 * Hetzner Cloud API
 *
 * Copied from the official API documentation for the Public Hetzner Cloud.
 *
 * The version of the OpenAPI document: 0.6.0
 * 
 * Generated by: https://openapi-generator.tech
 */

/// Firewall : Firewalls can limit the network access to or from your resources.



#[derive(Clone, Debug, PartialEq, Default, Serialize, Deserialize)]
pub struct Firewall {
    #[serde(rename = "applied_to")]
    pub applied_to: Vec<crate::models::FirewallResourceId>,
    /// Point in time when the Resource was created (in ISO-8601 format)
    #[serde(rename = "created")]
    pub created: String,
    /// ID of the Resource
    #[serde(rename = "id")]
    pub id: i32,
    /// User-defined labels (key-value pairs)
    #[serde(rename = "labels", skip_serializing_if = "Option::is_none")]
    pub labels: Option<::std::collections::HashMap<String, String>>,
    /// Name of the Resource. Must be unique per Project.
    #[serde(rename = "name")]
    pub name: String,
    #[serde(rename = "rules")]
    pub rules: Vec<crate::models::Rule>,
}

impl Firewall {
    /// Firewalls can limit the network access to or from your resources.
    pub fn new(applied_to: Vec<crate::models::FirewallResourceId>, created: String, id: i32, name: String, rules: Vec<crate::models::Rule>) -> Firewall {
        Firewall {
            applied_to,
            created,
            id,
            labels: None,
            name,
            rules,
        }
    }
}


