/*
 * Hetzner Cloud API
 *
 * Copied from the official API documentation for the Public Hetzner Cloud.
 *
 * The version of the OpenAPI document: 0.6.0
 * 
 * Generated by: https://openapi-generator.tech
 */


use reqwest;

use crate::apis::ResponseContent;
use super::{Error, configuration};

/// struct for passing parameters to the method [`add_service`]
#[derive(Clone, Debug, Default)]
pub struct AddServiceParams {
    /// ID of the Load Balancer
    pub id: i32,
    pub body: Option<crate::models::LoadBalancerService>
}

/// struct for passing parameters to the method [`add_target`]
#[derive(Clone, Debug, Default)]
pub struct AddTargetParams {
    /// ID of the Load Balancer
    pub id: i32,
    pub add_target_request: Option<crate::models::AddTargetRequest>
}

/// struct for passing parameters to the method [`attach_load_balancer_to_network`]
#[derive(Clone, Debug, Default)]
pub struct AttachLoadBalancerToNetworkParams {
    /// ID of the Load Balancer
    pub id: i32,
    pub attach_load_balancer_to_network_request: Option<crate::models::AttachLoadBalancerToNetworkRequest>
}

/// struct for passing parameters to the method [`change_algorithm`]
#[derive(Clone, Debug, Default)]
pub struct ChangeAlgorithmParams {
    /// ID of the Load Balancer
    pub id: i32,
    pub body: Option<crate::models::LoadBalancerAlgorithm>
}

/// struct for passing parameters to the method [`change_load_balancer_protection`]
#[derive(Clone, Debug, Default)]
pub struct ChangeLoadBalancerProtectionParams {
    /// ID of the Load Balancer
    pub id: i32,
    pub change_load_balancer_protection_request: Option<crate::models::ChangeLoadBalancerProtectionRequest>
}

/// struct for passing parameters to the method [`change_reverse_dns_entry_for_this_load_balancer`]
#[derive(Clone, Debug, Default)]
pub struct ChangeReverseDnsEntryForThisLoadBalancerParams {
    /// ID of the Load Balancer
    pub id: i32,
    /// Select the IP address for which to change the DNS entry by passing `ip`. It can be either IPv4 or IPv6. The target hostname is set by passing `dns_ptr`.
    pub change_reverse_dns_entry_for_this_load_balancer_request: Option<crate::models::ChangeReverseDnsEntryForThisLoadBalancerRequest>
}

/// struct for passing parameters to the method [`change_type_of_load_balancer`]
#[derive(Clone, Debug, Default)]
pub struct ChangeTypeOfLoadBalancerParams {
    /// ID of the Load Balancer
    pub id: i32,
    pub change_type_of_load_balancer_request: Option<crate::models::ChangeTypeOfLoadBalancerRequest>
}

/// struct for passing parameters to the method [`create_load_balancer`]
#[derive(Clone, Debug, Default)]
pub struct CreateLoadBalancerParams {
    pub create_load_balancer_request: Option<crate::models::CreateLoadBalancerRequest>
}

/// struct for passing parameters to the method [`delete_load_balancer`]
#[derive(Clone, Debug, Default)]
pub struct DeleteLoadBalancerParams {
    /// ID of the Load Balancer
    pub id: i32
}

/// struct for passing parameters to the method [`delete_service`]
#[derive(Clone, Debug, Default)]
pub struct DeleteServiceParams {
    /// ID of the Load Balancer
    pub id: i32,
    pub delete_service_request: Option<crate::models::DeleteServiceRequest>
}

/// struct for passing parameters to the method [`detach_load_balancer_from_network`]
#[derive(Clone, Debug, Default)]
pub struct DetachLoadBalancerFromNetworkParams {
    /// ID of the Load Balancer
    pub id: i32,
    pub detach_load_balancer_from_network_request: Option<crate::models::DetachLoadBalancerFromNetworkRequest>
}

/// struct for passing parameters to the method [`disable_public_interface_of_load_balancer`]
#[derive(Clone, Debug, Default)]
pub struct DisablePublicInterfaceOfLoadBalancerParams {
    /// ID of the Load Balancer
    pub id: i32
}

/// struct for passing parameters to the method [`enable_public_interface_of_load_balancer`]
#[derive(Clone, Debug, Default)]
pub struct EnablePublicInterfaceOfLoadBalancerParams {
    /// ID of the Load Balancer
    pub id: i32
}

/// struct for passing parameters to the method [`get_action_for_load_balancer`]
#[derive(Clone, Debug, Default)]
pub struct GetActionForLoadBalancerParams {
    /// ID of the Load Balancer
    pub id: i32,
    /// ID of the Action
    pub action_id: i32
}

/// struct for passing parameters to the method [`get_load_balancer`]
#[derive(Clone, Debug, Default)]
pub struct GetLoadBalancerParams {
    /// ID of the Load Balancer
    pub id: i32
}

/// struct for passing parameters to the method [`get_metrics_for_loadbalancer`]
#[derive(Clone, Debug, Default)]
pub struct GetMetricsForLoadbalancerParams {
    /// ID of the Load Balancer
    pub id: i32,
    /// Type of metrics to get
    pub _type: String,
    /// Start of period to get Metrics for (in ISO-8601 format)
    pub start: String,
    /// End of period to get Metrics for (in ISO-8601 format)
    pub end: String,
    /// Resolution of results in seconds
    pub step: Option<String>
}

/// struct for passing parameters to the method [`list_actions_for_load_balancer`]
#[derive(Clone, Debug, Default)]
pub struct ListActionsForLoadBalancerParams {
    /// ID of the Load Balancer
    pub id: i32,
    /// Can be used multiple times.
    pub sort: Option<String>,
    /// Can be used multiple times, the response will contain only Actions with specified statuses
    pub status: Option<String>,
    /// Specifies the page to fetch. The number of the first page is 1
    pub page: Option<i32>,
    /// Specifies the number of items returned per page. The default value is 25, the maximum value is 50 except otherwise specified in the documentation.
    pub per_page: Option<i32>
}

/// struct for passing parameters to the method [`list_load_balancers`]
#[derive(Clone, Debug, Default)]
pub struct ListLoadBalancersParams {
    /// Can be used multiple times.
    pub sort: Option<String>,
    /// Can be used to filter resources by their name. The response will only contain the resources matching the specified name
    pub name: Option<String>,
    /// Can be used to filter resources by labels. The response will only contain resources matching the label selector.
    pub label_selector: Option<String>,
    /// Specifies the page to fetch. The number of the first page is 1
    pub page: Option<i32>,
    /// Specifies the number of items returned per page. The default value is 25, the maximum value is 50 except otherwise specified in the documentation.
    pub per_page: Option<i32>
}

/// struct for passing parameters to the method [`remove_target`]
#[derive(Clone, Debug, Default)]
pub struct RemoveTargetParams {
    /// ID of the Load Balancer
    pub id: i32,
    pub remove_target_request: Option<crate::models::RemoveTargetRequest>
}

/// struct for passing parameters to the method [`replace_load_balancer`]
#[derive(Clone, Debug, Default)]
pub struct ReplaceLoadBalancerParams {
    /// ID of the Load Balancer
    pub id: i32,
    pub replace_load_balancer_request: Option<crate::models::ReplaceLoadBalancerRequest>
}

/// struct for passing parameters to the method [`update_service`]
#[derive(Clone, Debug, Default)]
pub struct UpdateServiceParams {
    /// ID of the Load Balancer
    pub id: i32,
    pub body: Option<crate::models::LoadBalancerService>
}


/// struct for typed errors of method [`add_service`]
#[derive(Debug, Clone, Serialize, Deserialize)]
#[serde(untagged)]
pub enum AddServiceError {
    UnknownValue(serde_json::Value),
}

/// struct for typed errors of method [`add_target`]
#[derive(Debug, Clone, Serialize, Deserialize)]
#[serde(untagged)]
pub enum AddTargetError {
    UnknownValue(serde_json::Value),
}

/// struct for typed errors of method [`attach_load_balancer_to_network`]
#[derive(Debug, Clone, Serialize, Deserialize)]
#[serde(untagged)]
pub enum AttachLoadBalancerToNetworkError {
    UnknownValue(serde_json::Value),
}

/// struct for typed errors of method [`change_algorithm`]
#[derive(Debug, Clone, Serialize, Deserialize)]
#[serde(untagged)]
pub enum ChangeAlgorithmError {
    UnknownValue(serde_json::Value),
}

/// struct for typed errors of method [`change_load_balancer_protection`]
#[derive(Debug, Clone, Serialize, Deserialize)]
#[serde(untagged)]
pub enum ChangeLoadBalancerProtectionError {
    UnknownValue(serde_json::Value),
}

/// struct for typed errors of method [`change_reverse_dns_entry_for_this_load_balancer`]
#[derive(Debug, Clone, Serialize, Deserialize)]
#[serde(untagged)]
pub enum ChangeReverseDnsEntryForThisLoadBalancerError {
    UnknownValue(serde_json::Value),
}

/// struct for typed errors of method [`change_type_of_load_balancer`]
#[derive(Debug, Clone, Serialize, Deserialize)]
#[serde(untagged)]
pub enum ChangeTypeOfLoadBalancerError {
    UnknownValue(serde_json::Value),
}

/// struct for typed errors of method [`create_load_balancer`]
#[derive(Debug, Clone, Serialize, Deserialize)]
#[serde(untagged)]
pub enum CreateLoadBalancerError {
    UnknownValue(serde_json::Value),
}

/// struct for typed errors of method [`delete_load_balancer`]
#[derive(Debug, Clone, Serialize, Deserialize)]
#[serde(untagged)]
pub enum DeleteLoadBalancerError {
    UnknownValue(serde_json::Value),
}

/// struct for typed errors of method [`delete_service`]
#[derive(Debug, Clone, Serialize, Deserialize)]
#[serde(untagged)]
pub enum DeleteServiceError {
    UnknownValue(serde_json::Value),
}

/// struct for typed errors of method [`detach_load_balancer_from_network`]
#[derive(Debug, Clone, Serialize, Deserialize)]
#[serde(untagged)]
pub enum DetachLoadBalancerFromNetworkError {
    UnknownValue(serde_json::Value),
}

/// struct for typed errors of method [`disable_public_interface_of_load_balancer`]
#[derive(Debug, Clone, Serialize, Deserialize)]
#[serde(untagged)]
pub enum DisablePublicInterfaceOfLoadBalancerError {
    UnknownValue(serde_json::Value),
}

/// struct for typed errors of method [`enable_public_interface_of_load_balancer`]
#[derive(Debug, Clone, Serialize, Deserialize)]
#[serde(untagged)]
pub enum EnablePublicInterfaceOfLoadBalancerError {
    UnknownValue(serde_json::Value),
}

/// struct for typed errors of method [`get_action_for_load_balancer`]
#[derive(Debug, Clone, Serialize, Deserialize)]
#[serde(untagged)]
pub enum GetActionForLoadBalancerError {
    UnknownValue(serde_json::Value),
}

/// struct for typed errors of method [`get_load_balancer`]
#[derive(Debug, Clone, Serialize, Deserialize)]
#[serde(untagged)]
pub enum GetLoadBalancerError {
    UnknownValue(serde_json::Value),
}

/// struct for typed errors of method [`get_metrics_for_loadbalancer`]
#[derive(Debug, Clone, Serialize, Deserialize)]
#[serde(untagged)]
pub enum GetMetricsForLoadbalancerError {
    UnknownValue(serde_json::Value),
}

/// struct for typed errors of method [`list_actions_for_load_balancer`]
#[derive(Debug, Clone, Serialize, Deserialize)]
#[serde(untagged)]
pub enum ListActionsForLoadBalancerError {
    UnknownValue(serde_json::Value),
}

/// struct for typed errors of method [`list_load_balancers`]
#[derive(Debug, Clone, Serialize, Deserialize)]
#[serde(untagged)]
pub enum ListLoadBalancersError {
    UnknownValue(serde_json::Value),
}

/// struct for typed errors of method [`remove_target`]
#[derive(Debug, Clone, Serialize, Deserialize)]
#[serde(untagged)]
pub enum RemoveTargetError {
    UnknownValue(serde_json::Value),
}

/// struct for typed errors of method [`replace_load_balancer`]
#[derive(Debug, Clone, Serialize, Deserialize)]
#[serde(untagged)]
pub enum ReplaceLoadBalancerError {
    UnknownValue(serde_json::Value),
}

/// struct for typed errors of method [`update_service`]
#[derive(Debug, Clone, Serialize, Deserialize)]
#[serde(untagged)]
pub enum UpdateServiceError {
    UnknownValue(serde_json::Value),
}


/// Adds a service to a Load Balancer.  #### Call specific error codes  | Code                       | Description                                             | |----------------------------|---------------------------------------------------------| | `source_port_already_used` | The source port you are trying to add is already in use | 
pub async fn add_service(configuration: &configuration::Configuration, params: AddServiceParams) -> Result<crate::models::AddServiceResponse, Error<AddServiceError>> {
    let local_var_configuration = configuration;

    // unbox the parameters
    let id = params.id;
    let body = params.body;


    let local_var_client = &local_var_configuration.client;

    let local_var_uri_str = format!("{}/load_balancers/{id}/actions/add_service", local_var_configuration.base_path, id=id);
    let mut local_var_req_builder = local_var_client.request(reqwest::Method::POST, local_var_uri_str.as_str());

    if let Some(ref local_var_user_agent) = local_var_configuration.user_agent {
        local_var_req_builder = local_var_req_builder.header(reqwest::header::USER_AGENT, local_var_user_agent.clone());
    }
    if let Some(ref local_var_token) = local_var_configuration.bearer_access_token {
        local_var_req_builder = local_var_req_builder.bearer_auth(local_var_token.to_owned());
    };
    local_var_req_builder = local_var_req_builder.json(&body);

    let local_var_req = local_var_req_builder.build()?;
    let local_var_resp = local_var_client.execute(local_var_req).await?;

    let local_var_status = local_var_resp.status();
    let local_var_content = local_var_resp.text().await?;

    if !local_var_status.is_client_error() && !local_var_status.is_server_error() {
        serde_json::from_str(&local_var_content).map_err(Error::from)
    } else {
        let local_var_entity: Option<AddServiceError> = serde_json::from_str(&local_var_content).ok();
        let local_var_error = ResponseContent { status: local_var_status, content: local_var_content, entity: local_var_entity };
        Err(Error::ResponseError(local_var_error))
    }
}

/// Adds a target to a Load Balancer.  #### Call specific error codes  | Code                                    | Description                                                                                           | |-----------------------------------------|-------------------------------------------------------------------------------------------------------| | `cloud_resource_ip_not_allowed`         | The IP you are trying to add as a target belongs to a Hetzner Cloud resource                          | | `ip_not_owned`                          | The IP you are trying to add as a target is not owned by the Project owner                            | | `load_balancer_not_attached_to_network` | The Load Balancer is not attached to a network                                                        | | `robot_unavailable`                     | Robot was not available. The caller may retry the operation after a short delay.                      | | `server_not_attached_to_network`        | The server you are trying to add as a target is not attached to the same network as the Load Balancer | | `target_already_defined`                | The Load Balancer target you are trying to define is already defined                                  | 
pub async fn add_target(configuration: &configuration::Configuration, params: AddTargetParams) -> Result<crate::models::AddTargetResponse, Error<AddTargetError>> {
    let local_var_configuration = configuration;

    // unbox the parameters
    let id = params.id;
    let add_target_request = params.add_target_request;


    let local_var_client = &local_var_configuration.client;

    let local_var_uri_str = format!("{}/load_balancers/{id}/actions/add_target", local_var_configuration.base_path, id=id);
    let mut local_var_req_builder = local_var_client.request(reqwest::Method::POST, local_var_uri_str.as_str());

    if let Some(ref local_var_user_agent) = local_var_configuration.user_agent {
        local_var_req_builder = local_var_req_builder.header(reqwest::header::USER_AGENT, local_var_user_agent.clone());
    }
    if let Some(ref local_var_token) = local_var_configuration.bearer_access_token {
        local_var_req_builder = local_var_req_builder.bearer_auth(local_var_token.to_owned());
    };
    local_var_req_builder = local_var_req_builder.json(&add_target_request);

    let local_var_req = local_var_req_builder.build()?;
    let local_var_resp = local_var_client.execute(local_var_req).await?;

    let local_var_status = local_var_resp.status();
    let local_var_content = local_var_resp.text().await?;

    if !local_var_status.is_client_error() && !local_var_status.is_server_error() {
        serde_json::from_str(&local_var_content).map_err(Error::from)
    } else {
        let local_var_entity: Option<AddTargetError> = serde_json::from_str(&local_var_content).ok();
        let local_var_error = ResponseContent { status: local_var_status, content: local_var_content, entity: local_var_entity };
        Err(Error::ResponseError(local_var_error))
    }
}

/// Attach a Load Balancer to a Network.  **Call specific error codes**  | Code                             | Description                                                           | |----------------------------------|-----------------------------------------------------------------------| | `load_balancer_already_attached` | The Load Balancer is already attached to a network                    | | `ip_not_available`               | The provided Network IP is not available                              | | `no_subnet_available`            | No Subnet or IP is available for the Load Balancer within the network | 
pub async fn attach_load_balancer_to_network(configuration: &configuration::Configuration, params: AttachLoadBalancerToNetworkParams) -> Result<crate::models::AttachLoadBalancerToNetworkResponse, Error<AttachLoadBalancerToNetworkError>> {
    let local_var_configuration = configuration;

    // unbox the parameters
    let id = params.id;
    let attach_load_balancer_to_network_request = params.attach_load_balancer_to_network_request;


    let local_var_client = &local_var_configuration.client;

    let local_var_uri_str = format!("{}/load_balancers/{id}/actions/attach_to_network", local_var_configuration.base_path, id=id);
    let mut local_var_req_builder = local_var_client.request(reqwest::Method::POST, local_var_uri_str.as_str());

    if let Some(ref local_var_user_agent) = local_var_configuration.user_agent {
        local_var_req_builder = local_var_req_builder.header(reqwest::header::USER_AGENT, local_var_user_agent.clone());
    }
    if let Some(ref local_var_token) = local_var_configuration.bearer_access_token {
        local_var_req_builder = local_var_req_builder.bearer_auth(local_var_token.to_owned());
    };
    local_var_req_builder = local_var_req_builder.json(&attach_load_balancer_to_network_request);

    let local_var_req = local_var_req_builder.build()?;
    let local_var_resp = local_var_client.execute(local_var_req).await?;

    let local_var_status = local_var_resp.status();
    let local_var_content = local_var_resp.text().await?;

    if !local_var_status.is_client_error() && !local_var_status.is_server_error() {
        serde_json::from_str(&local_var_content).map_err(Error::from)
    } else {
        let local_var_entity: Option<AttachLoadBalancerToNetworkError> = serde_json::from_str(&local_var_content).ok();
        let local_var_error = ResponseContent { status: local_var_status, content: local_var_content, entity: local_var_entity };
        Err(Error::ResponseError(local_var_error))
    }
}

/// Change the algorithm that determines to which target new requests are sent.
pub async fn change_algorithm(configuration: &configuration::Configuration, params: ChangeAlgorithmParams) -> Result<crate::models::ChangeAlgorithmResponse, Error<ChangeAlgorithmError>> {
    let local_var_configuration = configuration;

    // unbox the parameters
    let id = params.id;
    let body = params.body;


    let local_var_client = &local_var_configuration.client;

    let local_var_uri_str = format!("{}/load_balancers/{id}/actions/change_algorithm", local_var_configuration.base_path, id=id);
    let mut local_var_req_builder = local_var_client.request(reqwest::Method::POST, local_var_uri_str.as_str());

    if let Some(ref local_var_user_agent) = local_var_configuration.user_agent {
        local_var_req_builder = local_var_req_builder.header(reqwest::header::USER_AGENT, local_var_user_agent.clone());
    }
    if let Some(ref local_var_token) = local_var_configuration.bearer_access_token {
        local_var_req_builder = local_var_req_builder.bearer_auth(local_var_token.to_owned());
    };
    local_var_req_builder = local_var_req_builder.json(&body);

    let local_var_req = local_var_req_builder.build()?;
    let local_var_resp = local_var_client.execute(local_var_req).await?;

    let local_var_status = local_var_resp.status();
    let local_var_content = local_var_resp.text().await?;

    if !local_var_status.is_client_error() && !local_var_status.is_server_error() {
        serde_json::from_str(&local_var_content).map_err(Error::from)
    } else {
        let local_var_entity: Option<ChangeAlgorithmError> = serde_json::from_str(&local_var_content).ok();
        let local_var_error = ResponseContent { status: local_var_status, content: local_var_content, entity: local_var_entity };
        Err(Error::ResponseError(local_var_error))
    }
}

/// Changes the protection configuration of a Load Balancer.
pub async fn change_load_balancer_protection(configuration: &configuration::Configuration, params: ChangeLoadBalancerProtectionParams) -> Result<crate::models::ChangeLoadBalancerProtectionResponse, Error<ChangeLoadBalancerProtectionError>> {
    let local_var_configuration = configuration;

    // unbox the parameters
    let id = params.id;
    let change_load_balancer_protection_request = params.change_load_balancer_protection_request;


    let local_var_client = &local_var_configuration.client;

    let local_var_uri_str = format!("{}/load_balancers/{id}/actions/change_protection", local_var_configuration.base_path, id=id);
    let mut local_var_req_builder = local_var_client.request(reqwest::Method::POST, local_var_uri_str.as_str());

    if let Some(ref local_var_user_agent) = local_var_configuration.user_agent {
        local_var_req_builder = local_var_req_builder.header(reqwest::header::USER_AGENT, local_var_user_agent.clone());
    }
    if let Some(ref local_var_token) = local_var_configuration.bearer_access_token {
        local_var_req_builder = local_var_req_builder.bearer_auth(local_var_token.to_owned());
    };
    local_var_req_builder = local_var_req_builder.json(&change_load_balancer_protection_request);

    let local_var_req = local_var_req_builder.build()?;
    let local_var_resp = local_var_client.execute(local_var_req).await?;

    let local_var_status = local_var_resp.status();
    let local_var_content = local_var_resp.text().await?;

    if !local_var_status.is_client_error() && !local_var_status.is_server_error() {
        serde_json::from_str(&local_var_content).map_err(Error::from)
    } else {
        let local_var_entity: Option<ChangeLoadBalancerProtectionError> = serde_json::from_str(&local_var_content).ok();
        let local_var_error = ResponseContent { status: local_var_status, content: local_var_content, entity: local_var_entity };
        Err(Error::ResponseError(local_var_error))
    }
}

/// Changes the hostname that will appear when getting the hostname belonging to the public IPs (IPv4 and IPv6) of this Load Balancer.  Floating IPs assigned to the Server are not affected by this. 
pub async fn change_reverse_dns_entry_for_this_load_balancer(configuration: &configuration::Configuration, params: ChangeReverseDnsEntryForThisLoadBalancerParams) -> Result<crate::models::ChangeReverseDnsEntryForThisLoadBalancerResponse, Error<ChangeReverseDnsEntryForThisLoadBalancerError>> {
    let local_var_configuration = configuration;

    // unbox the parameters
    let id = params.id;
    let change_reverse_dns_entry_for_this_load_balancer_request = params.change_reverse_dns_entry_for_this_load_balancer_request;


    let local_var_client = &local_var_configuration.client;

    let local_var_uri_str = format!("{}/load_balancers/{id}/actions/change_dns_ptr", local_var_configuration.base_path, id=id);
    let mut local_var_req_builder = local_var_client.request(reqwest::Method::POST, local_var_uri_str.as_str());

    if let Some(ref local_var_user_agent) = local_var_configuration.user_agent {
        local_var_req_builder = local_var_req_builder.header(reqwest::header::USER_AGENT, local_var_user_agent.clone());
    }
    if let Some(ref local_var_token) = local_var_configuration.bearer_access_token {
        local_var_req_builder = local_var_req_builder.bearer_auth(local_var_token.to_owned());
    };
    local_var_req_builder = local_var_req_builder.json(&change_reverse_dns_entry_for_this_load_balancer_request);

    let local_var_req = local_var_req_builder.build()?;
    let local_var_resp = local_var_client.execute(local_var_req).await?;

    let local_var_status = local_var_resp.status();
    let local_var_content = local_var_resp.text().await?;

    if !local_var_status.is_client_error() && !local_var_status.is_server_error() {
        serde_json::from_str(&local_var_content).map_err(Error::from)
    } else {
        let local_var_entity: Option<ChangeReverseDnsEntryForThisLoadBalancerError> = serde_json::from_str(&local_var_content).ok();
        let local_var_error = ResponseContent { status: local_var_status, content: local_var_content, entity: local_var_entity };
        Err(Error::ResponseError(local_var_error))
    }
}

/// Changes the type (Max Services, Max Targets and Max Connections) of a Load Balancer.  **Call specific error codes**  | Code                         | Description                                                     | |------------------------------|-----------------------------------------------------------------| | `invalid_load_balancer_type` | The Load Balancer type does not fit for the given Load Balancer | 
pub async fn change_type_of_load_balancer(configuration: &configuration::Configuration, params: ChangeTypeOfLoadBalancerParams) -> Result<crate::models::ChangeTypeOfLoadBalancerResponse, Error<ChangeTypeOfLoadBalancerError>> {
    let local_var_configuration = configuration;

    // unbox the parameters
    let id = params.id;
    let change_type_of_load_balancer_request = params.change_type_of_load_balancer_request;


    let local_var_client = &local_var_configuration.client;

    let local_var_uri_str = format!("{}/load_balancers/{id}/actions/change_type", local_var_configuration.base_path, id=id);
    let mut local_var_req_builder = local_var_client.request(reqwest::Method::POST, local_var_uri_str.as_str());

    if let Some(ref local_var_user_agent) = local_var_configuration.user_agent {
        local_var_req_builder = local_var_req_builder.header(reqwest::header::USER_AGENT, local_var_user_agent.clone());
    }
    if let Some(ref local_var_token) = local_var_configuration.bearer_access_token {
        local_var_req_builder = local_var_req_builder.bearer_auth(local_var_token.to_owned());
    };
    local_var_req_builder = local_var_req_builder.json(&change_type_of_load_balancer_request);

    let local_var_req = local_var_req_builder.build()?;
    let local_var_resp = local_var_client.execute(local_var_req).await?;

    let local_var_status = local_var_resp.status();
    let local_var_content = local_var_resp.text().await?;

    if !local_var_status.is_client_error() && !local_var_status.is_server_error() {
        serde_json::from_str(&local_var_content).map_err(Error::from)
    } else {
        let local_var_entity: Option<ChangeTypeOfLoadBalancerError> = serde_json::from_str(&local_var_content).ok();
        let local_var_error = ResponseContent { status: local_var_status, content: local_var_content, entity: local_var_entity };
        Err(Error::ResponseError(local_var_error))
    }
}

/// Creates a Load Balancer.  #### Call specific error codes  | Code                                    | Description                                                                                           | |-----------------------------------------|-------------------------------------------------------------------------------------------------------| | `cloud_resource_ip_not_allowed`         | The IP you are trying to add as a target belongs to a Hetzner Cloud resource                          | | `ip_not_owned`                          | The IP is not owned by the owner of the project of the Load Balancer                                  | | `load_balancer_not_attached_to_network` | The Load Balancer is not attached to a network                                                        | | `robot_unavailable`                     | Robot was not available. The caller may retry the operation after a short delay.                      | | `server_not_attached_to_network`        | The server you are trying to add as a target is not attached to the same network as the Load Balancer | | `source_port_already_used`              | The source port you are trying to add is already in use                                               | | `target_already_defined`                | The Load Balancer target you are trying to define is already defined                                  | 
pub async fn create_load_balancer(configuration: &configuration::Configuration, params: CreateLoadBalancerParams) -> Result<crate::models::CreateLoadBalancerResponse, Error<CreateLoadBalancerError>> {
    let local_var_configuration = configuration;

    // unbox the parameters
    let create_load_balancer_request = params.create_load_balancer_request;


    let local_var_client = &local_var_configuration.client;

    let local_var_uri_str = format!("{}/load_balancers", local_var_configuration.base_path);
    let mut local_var_req_builder = local_var_client.request(reqwest::Method::POST, local_var_uri_str.as_str());

    if let Some(ref local_var_user_agent) = local_var_configuration.user_agent {
        local_var_req_builder = local_var_req_builder.header(reqwest::header::USER_AGENT, local_var_user_agent.clone());
    }
    if let Some(ref local_var_token) = local_var_configuration.bearer_access_token {
        local_var_req_builder = local_var_req_builder.bearer_auth(local_var_token.to_owned());
    };
    local_var_req_builder = local_var_req_builder.json(&create_load_balancer_request);

    let local_var_req = local_var_req_builder.build()?;
    let local_var_resp = local_var_client.execute(local_var_req).await?;

    let local_var_status = local_var_resp.status();
    let local_var_content = local_var_resp.text().await?;

    if !local_var_status.is_client_error() && !local_var_status.is_server_error() {
        serde_json::from_str(&local_var_content).map_err(Error::from)
    } else {
        let local_var_entity: Option<CreateLoadBalancerError> = serde_json::from_str(&local_var_content).ok();
        let local_var_error = ResponseContent { status: local_var_status, content: local_var_content, entity: local_var_entity };
        Err(Error::ResponseError(local_var_error))
    }
}

/// Deletes a Load Balancer.
pub async fn delete_load_balancer(configuration: &configuration::Configuration, params: DeleteLoadBalancerParams) -> Result<(), Error<DeleteLoadBalancerError>> {
    let local_var_configuration = configuration;

    // unbox the parameters
    let id = params.id;


    let local_var_client = &local_var_configuration.client;

    let local_var_uri_str = format!("{}/load_balancers/{id}", local_var_configuration.base_path, id=id);
    let mut local_var_req_builder = local_var_client.request(reqwest::Method::DELETE, local_var_uri_str.as_str());

    if let Some(ref local_var_user_agent) = local_var_configuration.user_agent {
        local_var_req_builder = local_var_req_builder.header(reqwest::header::USER_AGENT, local_var_user_agent.clone());
    }
    if let Some(ref local_var_token) = local_var_configuration.bearer_access_token {
        local_var_req_builder = local_var_req_builder.bearer_auth(local_var_token.to_owned());
    };

    let local_var_req = local_var_req_builder.build()?;
    let local_var_resp = local_var_client.execute(local_var_req).await?;

    let local_var_status = local_var_resp.status();
    let local_var_content = local_var_resp.text().await?;

    if !local_var_status.is_client_error() && !local_var_status.is_server_error() {
        Ok(())
    } else {
        let local_var_entity: Option<DeleteLoadBalancerError> = serde_json::from_str(&local_var_content).ok();
        let local_var_error = ResponseContent { status: local_var_status, content: local_var_content, entity: local_var_entity };
        Err(Error::ResponseError(local_var_error))
    }
}

/// Delete a service of a Load Balancer.
pub async fn delete_service(configuration: &configuration::Configuration, params: DeleteServiceParams) -> Result<crate::models::DeleteServiceResponse, Error<DeleteServiceError>> {
    let local_var_configuration = configuration;

    // unbox the parameters
    let id = params.id;
    let delete_service_request = params.delete_service_request;


    let local_var_client = &local_var_configuration.client;

    let local_var_uri_str = format!("{}/load_balancers/{id}/actions/delete_service", local_var_configuration.base_path, id=id);
    let mut local_var_req_builder = local_var_client.request(reqwest::Method::POST, local_var_uri_str.as_str());

    if let Some(ref local_var_user_agent) = local_var_configuration.user_agent {
        local_var_req_builder = local_var_req_builder.header(reqwest::header::USER_AGENT, local_var_user_agent.clone());
    }
    if let Some(ref local_var_token) = local_var_configuration.bearer_access_token {
        local_var_req_builder = local_var_req_builder.bearer_auth(local_var_token.to_owned());
    };
    local_var_req_builder = local_var_req_builder.json(&delete_service_request);

    let local_var_req = local_var_req_builder.build()?;
    let local_var_resp = local_var_client.execute(local_var_req).await?;

    let local_var_status = local_var_resp.status();
    let local_var_content = local_var_resp.text().await?;

    if !local_var_status.is_client_error() && !local_var_status.is_server_error() {
        serde_json::from_str(&local_var_content).map_err(Error::from)
    } else {
        let local_var_entity: Option<DeleteServiceError> = serde_json::from_str(&local_var_content).ok();
        let local_var_error = ResponseContent { status: local_var_status, content: local_var_content, entity: local_var_entity };
        Err(Error::ResponseError(local_var_error))
    }
}

/// Detaches a Load Balancer from a network.
pub async fn detach_load_balancer_from_network(configuration: &configuration::Configuration, params: DetachLoadBalancerFromNetworkParams) -> Result<crate::models::DetachLoadBalancerFromNetworkResponse, Error<DetachLoadBalancerFromNetworkError>> {
    let local_var_configuration = configuration;

    // unbox the parameters
    let id = params.id;
    let detach_load_balancer_from_network_request = params.detach_load_balancer_from_network_request;


    let local_var_client = &local_var_configuration.client;

    let local_var_uri_str = format!("{}/load_balancers/{id}/actions/detach_from_network", local_var_configuration.base_path, id=id);
    let mut local_var_req_builder = local_var_client.request(reqwest::Method::POST, local_var_uri_str.as_str());

    if let Some(ref local_var_user_agent) = local_var_configuration.user_agent {
        local_var_req_builder = local_var_req_builder.header(reqwest::header::USER_AGENT, local_var_user_agent.clone());
    }
    if let Some(ref local_var_token) = local_var_configuration.bearer_access_token {
        local_var_req_builder = local_var_req_builder.bearer_auth(local_var_token.to_owned());
    };
    local_var_req_builder = local_var_req_builder.json(&detach_load_balancer_from_network_request);

    let local_var_req = local_var_req_builder.build()?;
    let local_var_resp = local_var_client.execute(local_var_req).await?;

    let local_var_status = local_var_resp.status();
    let local_var_content = local_var_resp.text().await?;

    if !local_var_status.is_client_error() && !local_var_status.is_server_error() {
        serde_json::from_str(&local_var_content).map_err(Error::from)
    } else {
        let local_var_entity: Option<DetachLoadBalancerFromNetworkError> = serde_json::from_str(&local_var_content).ok();
        let local_var_error = ResponseContent { status: local_var_status, content: local_var_content, entity: local_var_entity };
        Err(Error::ResponseError(local_var_error))
    }
}

/// Disable the public interface of a Load Balancer. The Load Balancer will be not accessible from the internet via its public IPs.  #### Call specific error codes  | Code                                      | Description                                                                    | |-------------------------------------------|--------------------------------------------------------------------------------| | `load_balancer_not_attached_to_network`   |  The Load Balancer is not attached to a network                                | | `targets_without_use_private_ip`          | The Load Balancer has targets that use the public IP instead of the private IP | 
pub async fn disable_public_interface_of_load_balancer(configuration: &configuration::Configuration, params: DisablePublicInterfaceOfLoadBalancerParams) -> Result<crate::models::DisablePublicInterfaceOfLoadBalancerResponse, Error<DisablePublicInterfaceOfLoadBalancerError>> {
    let local_var_configuration = configuration;

    // unbox the parameters
    let id = params.id;


    let local_var_client = &local_var_configuration.client;

    let local_var_uri_str = format!("{}/load_balancers/{id}/actions/disable_public_interface", local_var_configuration.base_path, id=id);
    let mut local_var_req_builder = local_var_client.request(reqwest::Method::POST, local_var_uri_str.as_str());

    if let Some(ref local_var_user_agent) = local_var_configuration.user_agent {
        local_var_req_builder = local_var_req_builder.header(reqwest::header::USER_AGENT, local_var_user_agent.clone());
    }
    if let Some(ref local_var_token) = local_var_configuration.bearer_access_token {
        local_var_req_builder = local_var_req_builder.bearer_auth(local_var_token.to_owned());
    };

    let local_var_req = local_var_req_builder.build()?;
    let local_var_resp = local_var_client.execute(local_var_req).await?;

    let local_var_status = local_var_resp.status();
    let local_var_content = local_var_resp.text().await?;

    if !local_var_status.is_client_error() && !local_var_status.is_server_error() {
        serde_json::from_str(&local_var_content).map_err(Error::from)
    } else {
        let local_var_entity: Option<DisablePublicInterfaceOfLoadBalancerError> = serde_json::from_str(&local_var_content).ok();
        let local_var_error = ResponseContent { status: local_var_status, content: local_var_content, entity: local_var_entity };
        Err(Error::ResponseError(local_var_error))
    }
}

/// Enable the public interface of a Load Balancer. The Load Balancer will be accessible from the internet via its public IPs.
pub async fn enable_public_interface_of_load_balancer(configuration: &configuration::Configuration, params: EnablePublicInterfaceOfLoadBalancerParams) -> Result<crate::models::EnablePublicInterfaceOfLoadBalancerResponse, Error<EnablePublicInterfaceOfLoadBalancerError>> {
    let local_var_configuration = configuration;

    // unbox the parameters
    let id = params.id;


    let local_var_client = &local_var_configuration.client;

    let local_var_uri_str = format!("{}/load_balancers/{id}/actions/enable_public_interface", local_var_configuration.base_path, id=id);
    let mut local_var_req_builder = local_var_client.request(reqwest::Method::POST, local_var_uri_str.as_str());

    if let Some(ref local_var_user_agent) = local_var_configuration.user_agent {
        local_var_req_builder = local_var_req_builder.header(reqwest::header::USER_AGENT, local_var_user_agent.clone());
    }
    if let Some(ref local_var_token) = local_var_configuration.bearer_access_token {
        local_var_req_builder = local_var_req_builder.bearer_auth(local_var_token.to_owned());
    };

    let local_var_req = local_var_req_builder.build()?;
    let local_var_resp = local_var_client.execute(local_var_req).await?;

    let local_var_status = local_var_resp.status();
    let local_var_content = local_var_resp.text().await?;

    if !local_var_status.is_client_error() && !local_var_status.is_server_error() {
        serde_json::from_str(&local_var_content).map_err(Error::from)
    } else {
        let local_var_entity: Option<EnablePublicInterfaceOfLoadBalancerError> = serde_json::from_str(&local_var_content).ok();
        let local_var_error = ResponseContent { status: local_var_status, content: local_var_content, entity: local_var_entity };
        Err(Error::ResponseError(local_var_error))
    }
}

/// Returns a specific Action for a Load Balancer.
pub async fn get_action_for_load_balancer(configuration: &configuration::Configuration, params: GetActionForLoadBalancerParams) -> Result<crate::models::GetActionForLoadBalancerResponse, Error<GetActionForLoadBalancerError>> {
    let local_var_configuration = configuration;

    // unbox the parameters
    let id = params.id;
    let action_id = params.action_id;


    let local_var_client = &local_var_configuration.client;

    let local_var_uri_str = format!("{}/load_balancers/{id}/actions/{action_id}", local_var_configuration.base_path, id=id, action_id=action_id);
    let mut local_var_req_builder = local_var_client.request(reqwest::Method::GET, local_var_uri_str.as_str());

    if let Some(ref local_var_user_agent) = local_var_configuration.user_agent {
        local_var_req_builder = local_var_req_builder.header(reqwest::header::USER_AGENT, local_var_user_agent.clone());
    }
    if let Some(ref local_var_token) = local_var_configuration.bearer_access_token {
        local_var_req_builder = local_var_req_builder.bearer_auth(local_var_token.to_owned());
    };

    let local_var_req = local_var_req_builder.build()?;
    let local_var_resp = local_var_client.execute(local_var_req).await?;

    let local_var_status = local_var_resp.status();
    let local_var_content = local_var_resp.text().await?;

    if !local_var_status.is_client_error() && !local_var_status.is_server_error() {
        serde_json::from_str(&local_var_content).map_err(Error::from)
    } else {
        let local_var_entity: Option<GetActionForLoadBalancerError> = serde_json::from_str(&local_var_content).ok();
        let local_var_error = ResponseContent { status: local_var_status, content: local_var_content, entity: local_var_entity };
        Err(Error::ResponseError(local_var_error))
    }
}

/// Gets a specific Load Balancer object.
pub async fn get_load_balancer(configuration: &configuration::Configuration, params: GetLoadBalancerParams) -> Result<crate::models::GetLoadBalancerResponse, Error<GetLoadBalancerError>> {
    let local_var_configuration = configuration;

    // unbox the parameters
    let id = params.id;


    let local_var_client = &local_var_configuration.client;

    let local_var_uri_str = format!("{}/load_balancers/{id}", local_var_configuration.base_path, id=id);
    let mut local_var_req_builder = local_var_client.request(reqwest::Method::GET, local_var_uri_str.as_str());

    if let Some(ref local_var_user_agent) = local_var_configuration.user_agent {
        local_var_req_builder = local_var_req_builder.header(reqwest::header::USER_AGENT, local_var_user_agent.clone());
    }
    if let Some(ref local_var_token) = local_var_configuration.bearer_access_token {
        local_var_req_builder = local_var_req_builder.bearer_auth(local_var_token.to_owned());
    };

    let local_var_req = local_var_req_builder.build()?;
    let local_var_resp = local_var_client.execute(local_var_req).await?;

    let local_var_status = local_var_resp.status();
    let local_var_content = local_var_resp.text().await?;

    if !local_var_status.is_client_error() && !local_var_status.is_server_error() {
        serde_json::from_str(&local_var_content).map_err(Error::from)
    } else {
        let local_var_entity: Option<GetLoadBalancerError> = serde_json::from_str(&local_var_content).ok();
        let local_var_error = ResponseContent { status: local_var_status, content: local_var_content, entity: local_var_entity };
        Err(Error::ResponseError(local_var_error))
    }
}

/// You must specify the type of metric to get: `open_connections`, `connections_per_second`, `requests_per_second` or `bandwidth`. You can also specify more than one type by comma separation, e.g. `requests_per_second,bandwidth`.  Depending on the type you will get different time series data:  |Type | Timeseries | Unit | Description | |---- |------------|------|-------------| | open_connections | open_connections | number | Open connections | | connections_per_second | connections_per_second | connections/s | Connections per second | | requests_per_second | requests_per_second | requests/s | Requests per second | | bandwidth | bandwidth.in | bytes/s | Ingress bandwidth | || bandwidth.out | bytes/s | Egress bandwidth |  Metrics are available for the last 30 days only.  If you do not provide the step argument we will automatically adjust it so that 200 samples are returned.  We limit the number of samples to a maximum of 500 and will adjust the step parameter accordingly. 
pub async fn get_metrics_for_loadbalancer(configuration: &configuration::Configuration, params: GetMetricsForLoadbalancerParams) -> Result<crate::models::GetMetricsForLoadbalancerResponse, Error<GetMetricsForLoadbalancerError>> {
    let local_var_configuration = configuration;

    // unbox the parameters
    let id = params.id;
    let _type = params._type;
    let start = params.start;
    let end = params.end;
    let step = params.step;


    let local_var_client = &local_var_configuration.client;

    let local_var_uri_str = format!("{}/load_balancers/{id}/metrics", local_var_configuration.base_path, id=id);
    let mut local_var_req_builder = local_var_client.request(reqwest::Method::GET, local_var_uri_str.as_str());

    local_var_req_builder = local_var_req_builder.query(&[("type", &_type.to_string())]);
    local_var_req_builder = local_var_req_builder.query(&[("start", &start.to_string())]);
    local_var_req_builder = local_var_req_builder.query(&[("end", &end.to_string())]);
    if let Some(ref local_var_str) = step {
        local_var_req_builder = local_var_req_builder.query(&[("step", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_user_agent) = local_var_configuration.user_agent {
        local_var_req_builder = local_var_req_builder.header(reqwest::header::USER_AGENT, local_var_user_agent.clone());
    }
    if let Some(ref local_var_token) = local_var_configuration.bearer_access_token {
        local_var_req_builder = local_var_req_builder.bearer_auth(local_var_token.to_owned());
    };

    let local_var_req = local_var_req_builder.build()?;
    let local_var_resp = local_var_client.execute(local_var_req).await?;

    let local_var_status = local_var_resp.status();
    let local_var_content = local_var_resp.text().await?;

    if !local_var_status.is_client_error() && !local_var_status.is_server_error() {
        serde_json::from_str(&local_var_content).map_err(Error::from)
    } else {
        let local_var_entity: Option<GetMetricsForLoadbalancerError> = serde_json::from_str(&local_var_content).ok();
        let local_var_error = ResponseContent { status: local_var_status, content: local_var_content, entity: local_var_entity };
        Err(Error::ResponseError(local_var_error))
    }
}

/// Returns all Action objects for a Load Balancer. You can sort the results by using the `sort` URI parameter, and filter them with the `status` parameter.
pub async fn list_actions_for_load_balancer(configuration: &configuration::Configuration, params: ListActionsForLoadBalancerParams) -> Result<crate::models::ListActionsForLoadBalancerResponse, Error<ListActionsForLoadBalancerError>> {
    let local_var_configuration = configuration;

    // unbox the parameters
    let id = params.id;
    let sort = params.sort;
    let status = params.status;
    let page = params.page;
    let per_page = params.per_page;


    let local_var_client = &local_var_configuration.client;

    let local_var_uri_str = format!("{}/load_balancers/{id}/actions", local_var_configuration.base_path, id=id);
    let mut local_var_req_builder = local_var_client.request(reqwest::Method::GET, local_var_uri_str.as_str());

    if let Some(ref local_var_str) = sort {
        local_var_req_builder = local_var_req_builder.query(&[("sort", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = status {
        local_var_req_builder = local_var_req_builder.query(&[("status", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = page {
        local_var_req_builder = local_var_req_builder.query(&[("page", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = per_page {
        local_var_req_builder = local_var_req_builder.query(&[("per_page", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_user_agent) = local_var_configuration.user_agent {
        local_var_req_builder = local_var_req_builder.header(reqwest::header::USER_AGENT, local_var_user_agent.clone());
    }
    if let Some(ref local_var_token) = local_var_configuration.bearer_access_token {
        local_var_req_builder = local_var_req_builder.bearer_auth(local_var_token.to_owned());
    };

    let local_var_req = local_var_req_builder.build()?;
    let local_var_resp = local_var_client.execute(local_var_req).await?;

    let local_var_status = local_var_resp.status();
    let local_var_content = local_var_resp.text().await?;

    if !local_var_status.is_client_error() && !local_var_status.is_server_error() {
        serde_json::from_str(&local_var_content).map_err(Error::from)
    } else {
        let local_var_entity: Option<ListActionsForLoadBalancerError> = serde_json::from_str(&local_var_content).ok();
        let local_var_error = ResponseContent { status: local_var_status, content: local_var_content, entity: local_var_entity };
        Err(Error::ResponseError(local_var_error))
    }
}

/// Gets all existing Load Balancers that you have available.
pub async fn list_load_balancers(configuration: &configuration::Configuration, params: ListLoadBalancersParams) -> Result<crate::models::ListLoadBalancersResponse, Error<ListLoadBalancersError>> {
    let local_var_configuration = configuration;

    // unbox the parameters
    let sort = params.sort;
    let name = params.name;
    let label_selector = params.label_selector;
    let page = params.page;
    let per_page = params.per_page;


    let local_var_client = &local_var_configuration.client;

    let local_var_uri_str = format!("{}/load_balancers", local_var_configuration.base_path);
    let mut local_var_req_builder = local_var_client.request(reqwest::Method::GET, local_var_uri_str.as_str());

    if let Some(ref local_var_str) = sort {
        local_var_req_builder = local_var_req_builder.query(&[("sort", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = name {
        local_var_req_builder = local_var_req_builder.query(&[("name", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = label_selector {
        local_var_req_builder = local_var_req_builder.query(&[("label_selector", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = page {
        local_var_req_builder = local_var_req_builder.query(&[("page", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = per_page {
        local_var_req_builder = local_var_req_builder.query(&[("per_page", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_user_agent) = local_var_configuration.user_agent {
        local_var_req_builder = local_var_req_builder.header(reqwest::header::USER_AGENT, local_var_user_agent.clone());
    }
    if let Some(ref local_var_token) = local_var_configuration.bearer_access_token {
        local_var_req_builder = local_var_req_builder.bearer_auth(local_var_token.to_owned());
    };

    let local_var_req = local_var_req_builder.build()?;
    let local_var_resp = local_var_client.execute(local_var_req).await?;

    let local_var_status = local_var_resp.status();
    let local_var_content = local_var_resp.text().await?;

    if !local_var_status.is_client_error() && !local_var_status.is_server_error() {
        serde_json::from_str(&local_var_content).map_err(Error::from)
    } else {
        let local_var_entity: Option<ListLoadBalancersError> = serde_json::from_str(&local_var_content).ok();
        let local_var_error = ResponseContent { status: local_var_status, content: local_var_content, entity: local_var_entity };
        Err(Error::ResponseError(local_var_error))
    }
}

/// Removes a target from a Load Balancer.
pub async fn remove_target(configuration: &configuration::Configuration, params: RemoveTargetParams) -> Result<crate::models::RemoveTargetResponse, Error<RemoveTargetError>> {
    let local_var_configuration = configuration;

    // unbox the parameters
    let id = params.id;
    let remove_target_request = params.remove_target_request;


    let local_var_client = &local_var_configuration.client;

    let local_var_uri_str = format!("{}/load_balancers/{id}/actions/remove_target", local_var_configuration.base_path, id=id);
    let mut local_var_req_builder = local_var_client.request(reqwest::Method::POST, local_var_uri_str.as_str());

    if let Some(ref local_var_user_agent) = local_var_configuration.user_agent {
        local_var_req_builder = local_var_req_builder.header(reqwest::header::USER_AGENT, local_var_user_agent.clone());
    }
    if let Some(ref local_var_token) = local_var_configuration.bearer_access_token {
        local_var_req_builder = local_var_req_builder.bearer_auth(local_var_token.to_owned());
    };
    local_var_req_builder = local_var_req_builder.json(&remove_target_request);

    let local_var_req = local_var_req_builder.build()?;
    let local_var_resp = local_var_client.execute(local_var_req).await?;

    let local_var_status = local_var_resp.status();
    let local_var_content = local_var_resp.text().await?;

    if !local_var_status.is_client_error() && !local_var_status.is_server_error() {
        serde_json::from_str(&local_var_content).map_err(Error::from)
    } else {
        let local_var_entity: Option<RemoveTargetError> = serde_json::from_str(&local_var_content).ok();
        let local_var_error = ResponseContent { status: local_var_status, content: local_var_content, entity: local_var_entity };
        Err(Error::ResponseError(local_var_error))
    }
}

/// Updates a Load Balancer. You can update a Load Balancer’s name and a Load Balancer’s labels.  Note that when updating labels, the Load Balancer’s current set of labels will be replaced with the labels provided in the request body. So, for example, if you want to add a new label, you have to provide all existing labels plus the new label in the request body.  Note: if the Load Balancer object changes during the request, the response will be a “conflict” error. 
pub async fn replace_load_balancer(configuration: &configuration::Configuration, params: ReplaceLoadBalancerParams) -> Result<crate::models::ReplaceLoadBalancerResponse, Error<ReplaceLoadBalancerError>> {
    let local_var_configuration = configuration;

    // unbox the parameters
    let id = params.id;
    let replace_load_balancer_request = params.replace_load_balancer_request;


    let local_var_client = &local_var_configuration.client;

    let local_var_uri_str = format!("{}/load_balancers/{id}", local_var_configuration.base_path, id=id);
    let mut local_var_req_builder = local_var_client.request(reqwest::Method::PUT, local_var_uri_str.as_str());

    if let Some(ref local_var_user_agent) = local_var_configuration.user_agent {
        local_var_req_builder = local_var_req_builder.header(reqwest::header::USER_AGENT, local_var_user_agent.clone());
    }
    if let Some(ref local_var_token) = local_var_configuration.bearer_access_token {
        local_var_req_builder = local_var_req_builder.bearer_auth(local_var_token.to_owned());
    };
    local_var_req_builder = local_var_req_builder.json(&replace_load_balancer_request);

    let local_var_req = local_var_req_builder.build()?;
    let local_var_resp = local_var_client.execute(local_var_req).await?;

    let local_var_status = local_var_resp.status();
    let local_var_content = local_var_resp.text().await?;

    if !local_var_status.is_client_error() && !local_var_status.is_server_error() {
        serde_json::from_str(&local_var_content).map_err(Error::from)
    } else {
        let local_var_entity: Option<ReplaceLoadBalancerError> = serde_json::from_str(&local_var_content).ok();
        let local_var_error = ResponseContent { status: local_var_status, content: local_var_content, entity: local_var_entity };
        Err(Error::ResponseError(local_var_error))
    }
}

/// Updates a Load Balancer Service.  #### Call specific error codes  | Code                       | Description                                             | |----------------------------|---------------------------------------------------------| | `source_port_already_used` | The source port you are trying to add is already in use | 
pub async fn update_service(configuration: &configuration::Configuration, params: UpdateServiceParams) -> Result<crate::models::UpdateServiceResponse, Error<UpdateServiceError>> {
    let local_var_configuration = configuration;

    // unbox the parameters
    let id = params.id;
    let body = params.body;


    let local_var_client = &local_var_configuration.client;

    let local_var_uri_str = format!("{}/load_balancers/{id}/actions/update_service", local_var_configuration.base_path, id=id);
    let mut local_var_req_builder = local_var_client.request(reqwest::Method::POST, local_var_uri_str.as_str());

    if let Some(ref local_var_user_agent) = local_var_configuration.user_agent {
        local_var_req_builder = local_var_req_builder.header(reqwest::header::USER_AGENT, local_var_user_agent.clone());
    }
    if let Some(ref local_var_token) = local_var_configuration.bearer_access_token {
        local_var_req_builder = local_var_req_builder.bearer_auth(local_var_token.to_owned());
    };
    local_var_req_builder = local_var_req_builder.json(&body);

    let local_var_req = local_var_req_builder.build()?;
    let local_var_resp = local_var_client.execute(local_var_req).await?;

    let local_var_status = local_var_resp.status();
    let local_var_content = local_var_resp.text().await?;

    if !local_var_status.is_client_error() && !local_var_status.is_server_error() {
        serde_json::from_str(&local_var_content).map_err(Error::from)
    } else {
        let local_var_entity: Option<UpdateServiceError> = serde_json::from_str(&local_var_content).ok();
        let local_var_error = ResponseContent { status: local_var_status, content: local_var_content, entity: local_var_entity };
        Err(Error::ResponseError(local_var_error))
    }
}

