/*
 * Hetzner Cloud API
 *
 * Copied from the official API documentation for the Public Hetzner Cloud.
 *
 * The version of the OpenAPI document: 0.7.0
 * 
 * Generated by: https://openapi-generator.tech
 */

/// LoadBalancerService : A service for a Load Balancer.



#[derive(Clone, Debug, PartialEq, Default, Serialize, Deserialize)]
pub struct LoadBalancerService {
    /// Port the Load Balancer will balance to
    #[serde(rename = "destination_port")]
    pub destination_port: i32,
    #[serde(rename = "health_check")]
    pub health_check: Box<crate::models::LoadBalancerServiceHealthCheck>,
    #[serde(rename = "http", skip_serializing_if = "Option::is_none")]
    pub http: Option<Box<crate::models::Http>>,
    /// Port the Load Balancer listens on
    #[serde(rename = "listen_port")]
    pub listen_port: i32,
    /// Protocol of the Load Balancer
    #[serde(rename = "protocol")]
    pub protocol: Protocol,
    /// Is Proxyprotocol enabled or not
    #[serde(rename = "proxyprotocol")]
    pub proxyprotocol: bool,
}

impl LoadBalancerService {
    /// A service for a Load Balancer.
    pub fn new(destination_port: i32, health_check: crate::models::LoadBalancerServiceHealthCheck, listen_port: i32, protocol: Protocol, proxyprotocol: bool) -> LoadBalancerService {
        LoadBalancerService {
            destination_port,
            health_check: Box::new(health_check),
            http: None,
            listen_port,
            protocol,
            proxyprotocol,
        }
    }
}

/// Protocol of the Load Balancer
#[derive(Clone, Copy, Debug, Eq, PartialEq, Ord, PartialOrd, Hash, Serialize, Deserialize)]
pub enum Protocol {
    #[serde(rename = "http")]
    Http,
    #[serde(rename = "https")]
    Https,
    #[serde(rename = "tcp")]
    Tcp,
}

impl Default for Protocol {
    fn default() -> Protocol {
        Self::Http
    }
}

