// Autogenerated by Thrift Compiler (0.15.0)
// DO NOT EDIT UNLESS YOU ARE SURE THAT YOU KNOW WHAT YOU ARE DOING

#![allow(unused_imports)]
#![allow(unused_extern_crates)]
#![allow(clippy::too_many_arguments, clippy::type_complexity, clippy::vec_box)]
#![cfg_attr(rustfmt, rustfmt_skip)]

use std::cell::RefCell;
use std::collections::{BTreeMap, BTreeSet};
use std::convert::{From, TryFrom};
use std::default::Default;
use std::error::Error;
use std::fmt;
use std::fmt::{Display, Formatter};
use std::rc::Rc;

use thrift::OrderedFloat;
use thrift::{ApplicationError, ApplicationErrorKind, ProtocolError, ProtocolErrorKind, TThriftClient};
use thrift::protocol::{TFieldIdentifier, TListIdentifier, TMapIdentifier, TMessageIdentifier, TMessageType, TInputProtocol, TOutputProtocol, TSetIdentifier, TStructIdentifier, TType};
use thrift::protocol::field_id;
use thrift::protocol::verify_expected_message_type;
use thrift::protocol::verify_expected_sequence_number;
use thrift::protocol::verify_expected_service_call;
use thrift::protocol::verify_required_field_exists;
use thrift::server::TProcessor;

/// Specify type of thrift server: thrift and thrift2
#[derive(Copy, Clone, Debug, Eq, Hash, Ord, PartialEq, PartialOrd)]
pub struct TThriftServerType(pub i32);

impl TThriftServerType {
  pub const ONE: TThriftServerType = TThriftServerType(1);
  pub const TWO: TThriftServerType = TThriftServerType(2);
  pub const ENUM_VALUES: &'static [Self] = &[
    Self::ONE,
    Self::TWO,
  ];
  #[allow(clippy::trivially_copy_pass_by_ref)]
  pub fn write_to_out_protocol(&self, o_prot: &mut dyn TOutputProtocol) -> thrift::Result<()> {
    o_prot.write_i32(self.0)
  }
  pub fn read_from_in_protocol(i_prot: &mut dyn TInputProtocol) -> thrift::Result<TThriftServerType> {
    let enum_value = i_prot.read_i32()?;
    Ok(TThriftServerType::from(enum_value))
  }
}

impl From<i32> for TThriftServerType {
  fn from(i: i32) -> Self {
    match i {
      1 => TThriftServerType::ONE,
      2 => TThriftServerType::TWO,
      _ => TThriftServerType(i)
    }
  }
}

impl From<&i32> for TThriftServerType {
  fn from(i: &i32) -> Self {
    TThriftServerType::from(*i)
  }
}

impl From<TThriftServerType> for i32 {
  fn from(e: TThriftServerType) -> i32 {
    e.0
  }
}

impl From<&TThriftServerType> for i32 {
  fn from(e: &TThriftServerType) -> i32 {
    e.0
  }
}

#[derive(Copy, Clone, Debug, Eq, Hash, Ord, PartialEq, PartialOrd)]
pub struct TPermissionScope(pub i32);

impl TPermissionScope {
  pub const TABLE: TPermissionScope = TPermissionScope(0);
  pub const NAMESPACE: TPermissionScope = TPermissionScope(1);
  pub const ENUM_VALUES: &'static [Self] = &[
    Self::TABLE,
    Self::NAMESPACE,
  ];
  #[allow(clippy::trivially_copy_pass_by_ref)]
  pub fn write_to_out_protocol(&self, o_prot: &mut dyn TOutputProtocol) -> thrift::Result<()> {
    o_prot.write_i32(self.0)
  }
  pub fn read_from_in_protocol(i_prot: &mut dyn TInputProtocol) -> thrift::Result<TPermissionScope> {
    let enum_value = i_prot.read_i32()?;
    Ok(TPermissionScope::from(enum_value))
  }
}

impl From<i32> for TPermissionScope {
  fn from(i: i32) -> Self {
    match i {
      0 => TPermissionScope::TABLE,
      1 => TPermissionScope::NAMESPACE,
      _ => TPermissionScope(i)
    }
  }
}

impl From<&i32> for TPermissionScope {
  fn from(i: &i32) -> Self {
    TPermissionScope::from(*i)
  }
}

impl From<TPermissionScope> for i32 {
  fn from(e: TPermissionScope) -> i32 {
    e.0
  }
}

impl From<&TPermissionScope> for i32 {
  fn from(e: &TPermissionScope) -> i32 {
    e.0
  }
}

pub type Text = Vec<u8>;

pub type Bytes = Vec<u8>;

pub type ScannerID = i32;

//
// TCell
//

/// TCell - Used to transport a cell value (byte[]) and the timestamp it was
/// stored with together as a result for get and getRow methods. This promotes
/// the timestamp of a cell to a first-class value, making it easy to take
/// note of temporal data. Cell is used all the way from HStore up to HTable.
#[derive(Clone, Debug, Eq, Hash, Ord, PartialEq, PartialOrd)]
pub struct TCell {
  pub value: Option<Bytes>,
  pub timestamp: Option<i64>,
}

impl TCell {
  pub fn new<F1, F2>(value: F1, timestamp: F2) -> TCell where F1: Into<Option<Bytes>>, F2: Into<Option<i64>> {
    TCell {
      value: value.into(),
      timestamp: timestamp.into(),
    }
  }
  pub fn read_from_in_protocol(i_prot: &mut dyn TInputProtocol) -> thrift::Result<TCell> {
    i_prot.read_struct_begin()?;
    let mut f_1: Option<Bytes> = Some(Vec::new());
    let mut f_2: Option<i64> = Some(0);
    loop {
      let field_ident = i_prot.read_field_begin()?;
      if field_ident.field_type == TType::Stop {
        break;
      }
      let field_id = field_id(&field_ident)?;
      match field_id {
        1 => {
          let val = i_prot.read_bytes()?;
          f_1 = Some(val);
        },
        2 => {
          let val = i_prot.read_i64()?;
          f_2 = Some(val);
        },
        _ => {
          i_prot.skip(field_ident.field_type)?;
        },
      };
      i_prot.read_field_end()?;
    }
    i_prot.read_struct_end()?;
    let ret = TCell {
      value: f_1,
      timestamp: f_2,
    };
    Ok(ret)
  }
  pub fn write_to_out_protocol(&self, o_prot: &mut dyn TOutputProtocol) -> thrift::Result<()> {
    let struct_ident = TStructIdentifier::new("TCell");
    o_prot.write_struct_begin(&struct_ident)?;
    if let Some(ref fld_var) = self.value {
      o_prot.write_field_begin(&TFieldIdentifier::new("value", TType::String, 1))?;
      o_prot.write_bytes(fld_var)?;
      o_prot.write_field_end()?
    }
    if let Some(fld_var) = self.timestamp {
      o_prot.write_field_begin(&TFieldIdentifier::new("timestamp", TType::I64, 2))?;
      o_prot.write_i64(fld_var)?;
      o_prot.write_field_end()?
    }
    o_prot.write_field_stop()?;
    o_prot.write_struct_end()
  }
}

impl Default for TCell {
  fn default() -> Self {
    TCell{
      value: Some(Vec::new()),
      timestamp: Some(0),
    }
  }
}

//
// ColumnDescriptor
//

/// An HColumnDescriptor contains information about a column family
/// such as the number of versions, compression settings, etc. It is
/// used as input when creating a table or adding a column.
#[derive(Clone, Debug, Eq, Hash, Ord, PartialEq, PartialOrd)]
pub struct ColumnDescriptor {
  pub name: Option<Text>,
  pub max_versions: Option<i32>,
  pub compression: Option<String>,
  pub in_memory: Option<bool>,
  pub bloom_filter_type: Option<String>,
  pub bloom_filter_vector_size: Option<i32>,
  pub bloom_filter_nb_hashes: Option<i32>,
  pub block_cache_enabled: Option<bool>,
  pub time_to_live: Option<i32>,
}

impl ColumnDescriptor {
  pub fn new<F1, F2, F3, F4, F5, F6, F7, F8, F9>(name: F1, max_versions: F2, compression: F3, in_memory: F4, bloom_filter_type: F5, bloom_filter_vector_size: F6, bloom_filter_nb_hashes: F7, block_cache_enabled: F8, time_to_live: F9) -> ColumnDescriptor where F1: Into<Option<Text>>, F2: Into<Option<i32>>, F3: Into<Option<String>>, F4: Into<Option<bool>>, F5: Into<Option<String>>, F6: Into<Option<i32>>, F7: Into<Option<i32>>, F8: Into<Option<bool>>, F9: Into<Option<i32>> {
    ColumnDescriptor {
      name: name.into(),
      max_versions: max_versions.into(),
      compression: compression.into(),
      in_memory: in_memory.into(),
      bloom_filter_type: bloom_filter_type.into(),
      bloom_filter_vector_size: bloom_filter_vector_size.into(),
      bloom_filter_nb_hashes: bloom_filter_nb_hashes.into(),
      block_cache_enabled: block_cache_enabled.into(),
      time_to_live: time_to_live.into(),
    }
  }
  pub fn read_from_in_protocol(i_prot: &mut dyn TInputProtocol) -> thrift::Result<ColumnDescriptor> {
    i_prot.read_struct_begin()?;
    let mut f_1: Option<Text> = Some(Vec::new());
    let mut f_2: Option<i32> = Some(0);
    let mut f_3: Option<String> = Some("".to_owned());
    let mut f_4: Option<bool> = Some(false);
    let mut f_5: Option<String> = Some("".to_owned());
    let mut f_6: Option<i32> = Some(0);
    let mut f_7: Option<i32> = Some(0);
    let mut f_8: Option<bool> = Some(false);
    let mut f_9: Option<i32> = Some(0);
    loop {
      let field_ident = i_prot.read_field_begin()?;
      if field_ident.field_type == TType::Stop {
        break;
      }
      let field_id = field_id(&field_ident)?;
      match field_id {
        1 => {
          let val = i_prot.read_bytes()?;
          f_1 = Some(val);
        },
        2 => {
          let val = i_prot.read_i32()?;
          f_2 = Some(val);
        },
        3 => {
          let val = i_prot.read_string()?;
          f_3 = Some(val);
        },
        4 => {
          let val = i_prot.read_bool()?;
          f_4 = Some(val);
        },
        5 => {
          let val = i_prot.read_string()?;
          f_5 = Some(val);
        },
        6 => {
          let val = i_prot.read_i32()?;
          f_6 = Some(val);
        },
        7 => {
          let val = i_prot.read_i32()?;
          f_7 = Some(val);
        },
        8 => {
          let val = i_prot.read_bool()?;
          f_8 = Some(val);
        },
        9 => {
          let val = i_prot.read_i32()?;
          f_9 = Some(val);
        },
        _ => {
          i_prot.skip(field_ident.field_type)?;
        },
      };
      i_prot.read_field_end()?;
    }
    i_prot.read_struct_end()?;
    let ret = ColumnDescriptor {
      name: f_1,
      max_versions: f_2,
      compression: f_3,
      in_memory: f_4,
      bloom_filter_type: f_5,
      bloom_filter_vector_size: f_6,
      bloom_filter_nb_hashes: f_7,
      block_cache_enabled: f_8,
      time_to_live: f_9,
    };
    Ok(ret)
  }
  pub fn write_to_out_protocol(&self, o_prot: &mut dyn TOutputProtocol) -> thrift::Result<()> {
    let struct_ident = TStructIdentifier::new("ColumnDescriptor");
    o_prot.write_struct_begin(&struct_ident)?;
    if let Some(ref fld_var) = self.name {
      o_prot.write_field_begin(&TFieldIdentifier::new("name", TType::String, 1))?;
      o_prot.write_bytes(fld_var)?;
      o_prot.write_field_end()?
    }
    if let Some(fld_var) = self.max_versions {
      o_prot.write_field_begin(&TFieldIdentifier::new("maxVersions", TType::I32, 2))?;
      o_prot.write_i32(fld_var)?;
      o_prot.write_field_end()?
    }
    if let Some(ref fld_var) = self.compression {
      o_prot.write_field_begin(&TFieldIdentifier::new("compression", TType::String, 3))?;
      o_prot.write_string(fld_var)?;
      o_prot.write_field_end()?
    }
    if let Some(fld_var) = self.in_memory {
      o_prot.write_field_begin(&TFieldIdentifier::new("inMemory", TType::Bool, 4))?;
      o_prot.write_bool(fld_var)?;
      o_prot.write_field_end()?
    }
    if let Some(ref fld_var) = self.bloom_filter_type {
      o_prot.write_field_begin(&TFieldIdentifier::new("bloomFilterType", TType::String, 5))?;
      o_prot.write_string(fld_var)?;
      o_prot.write_field_end()?
    }
    if let Some(fld_var) = self.bloom_filter_vector_size {
      o_prot.write_field_begin(&TFieldIdentifier::new("bloomFilterVectorSize", TType::I32, 6))?;
      o_prot.write_i32(fld_var)?;
      o_prot.write_field_end()?
    }
    if let Some(fld_var) = self.bloom_filter_nb_hashes {
      o_prot.write_field_begin(&TFieldIdentifier::new("bloomFilterNbHashes", TType::I32, 7))?;
      o_prot.write_i32(fld_var)?;
      o_prot.write_field_end()?
    }
    if let Some(fld_var) = self.block_cache_enabled {
      o_prot.write_field_begin(&TFieldIdentifier::new("blockCacheEnabled", TType::Bool, 8))?;
      o_prot.write_bool(fld_var)?;
      o_prot.write_field_end()?
    }
    if let Some(fld_var) = self.time_to_live {
      o_prot.write_field_begin(&TFieldIdentifier::new("timeToLive", TType::I32, 9))?;
      o_prot.write_i32(fld_var)?;
      o_prot.write_field_end()?
    }
    o_prot.write_field_stop()?;
    o_prot.write_struct_end()
  }
}

impl Default for ColumnDescriptor {
  fn default() -> Self {
    ColumnDescriptor{
      name: Some(Vec::new()),
      max_versions: Some(0),
      compression: Some("".to_owned()),
      in_memory: Some(false),
      bloom_filter_type: Some("".to_owned()),
      bloom_filter_vector_size: Some(0),
      bloom_filter_nb_hashes: Some(0),
      block_cache_enabled: Some(false),
      time_to_live: Some(0),
    }
  }
}

//
// TRegionInfo
//

/// A TRegionInfo contains information about an HTable region.
#[derive(Clone, Debug, Eq, Hash, Ord, PartialEq, PartialOrd)]
pub struct TRegionInfo {
  pub start_key: Option<Text>,
  pub end_key: Option<Text>,
  pub id: Option<i64>,
  pub name: Option<Text>,
  pub version: Option<i8>,
  pub server_name: Option<Text>,
  pub port: Option<i32>,
}

impl TRegionInfo {
  pub fn new<F1, F2, F3, F4, F5, F6, F7>(start_key: F1, end_key: F2, id: F3, name: F4, version: F5, server_name: F6, port: F7) -> TRegionInfo where F1: Into<Option<Text>>, F2: Into<Option<Text>>, F3: Into<Option<i64>>, F4: Into<Option<Text>>, F5: Into<Option<i8>>, F6: Into<Option<Text>>, F7: Into<Option<i32>> {
    TRegionInfo {
      start_key: start_key.into(),
      end_key: end_key.into(),
      id: id.into(),
      name: name.into(),
      version: version.into(),
      server_name: server_name.into(),
      port: port.into(),
    }
  }
  pub fn read_from_in_protocol(i_prot: &mut dyn TInputProtocol) -> thrift::Result<TRegionInfo> {
    i_prot.read_struct_begin()?;
    let mut f_1: Option<Text> = Some(Vec::new());
    let mut f_2: Option<Text> = Some(Vec::new());
    let mut f_3: Option<i64> = Some(0);
    let mut f_4: Option<Text> = Some(Vec::new());
    let mut f_5: Option<i8> = Some(0);
    let mut f_6: Option<Text> = Some(Vec::new());
    let mut f_7: Option<i32> = Some(0);
    loop {
      let field_ident = i_prot.read_field_begin()?;
      if field_ident.field_type == TType::Stop {
        break;
      }
      let field_id = field_id(&field_ident)?;
      match field_id {
        1 => {
          let val = i_prot.read_bytes()?;
          f_1 = Some(val);
        },
        2 => {
          let val = i_prot.read_bytes()?;
          f_2 = Some(val);
        },
        3 => {
          let val = i_prot.read_i64()?;
          f_3 = Some(val);
        },
        4 => {
          let val = i_prot.read_bytes()?;
          f_4 = Some(val);
        },
        5 => {
          let val = i_prot.read_i8()?;
          f_5 = Some(val);
        },
        6 => {
          let val = i_prot.read_bytes()?;
          f_6 = Some(val);
        },
        7 => {
          let val = i_prot.read_i32()?;
          f_7 = Some(val);
        },
        _ => {
          i_prot.skip(field_ident.field_type)?;
        },
      };
      i_prot.read_field_end()?;
    }
    i_prot.read_struct_end()?;
    let ret = TRegionInfo {
      start_key: f_1,
      end_key: f_2,
      id: f_3,
      name: f_4,
      version: f_5,
      server_name: f_6,
      port: f_7,
    };
    Ok(ret)
  }
  pub fn write_to_out_protocol(&self, o_prot: &mut dyn TOutputProtocol) -> thrift::Result<()> {
    let struct_ident = TStructIdentifier::new("TRegionInfo");
    o_prot.write_struct_begin(&struct_ident)?;
    if let Some(ref fld_var) = self.start_key {
      o_prot.write_field_begin(&TFieldIdentifier::new("startKey", TType::String, 1))?;
      o_prot.write_bytes(fld_var)?;
      o_prot.write_field_end()?
    }
    if let Some(ref fld_var) = self.end_key {
      o_prot.write_field_begin(&TFieldIdentifier::new("endKey", TType::String, 2))?;
      o_prot.write_bytes(fld_var)?;
      o_prot.write_field_end()?
    }
    if let Some(fld_var) = self.id {
      o_prot.write_field_begin(&TFieldIdentifier::new("id", TType::I64, 3))?;
      o_prot.write_i64(fld_var)?;
      o_prot.write_field_end()?
    }
    if let Some(ref fld_var) = self.name {
      o_prot.write_field_begin(&TFieldIdentifier::new("name", TType::String, 4))?;
      o_prot.write_bytes(fld_var)?;
      o_prot.write_field_end()?
    }
    if let Some(fld_var) = self.version {
      o_prot.write_field_begin(&TFieldIdentifier::new("version", TType::I08, 5))?;
      o_prot.write_i8(fld_var)?;
      o_prot.write_field_end()?
    }
    if let Some(ref fld_var) = self.server_name {
      o_prot.write_field_begin(&TFieldIdentifier::new("serverName", TType::String, 6))?;
      o_prot.write_bytes(fld_var)?;
      o_prot.write_field_end()?
    }
    if let Some(fld_var) = self.port {
      o_prot.write_field_begin(&TFieldIdentifier::new("port", TType::I32, 7))?;
      o_prot.write_i32(fld_var)?;
      o_prot.write_field_end()?
    }
    o_prot.write_field_stop()?;
    o_prot.write_struct_end()
  }
}

impl Default for TRegionInfo {
  fn default() -> Self {
    TRegionInfo{
      start_key: Some(Vec::new()),
      end_key: Some(Vec::new()),
      id: Some(0),
      name: Some(Vec::new()),
      version: Some(0),
      server_name: Some(Vec::new()),
      port: Some(0),
    }
  }
}

//
// Mutation
//

/// A Mutation object is used to either update or delete a column-value.
#[derive(Clone, Debug, Eq, Hash, Ord, PartialEq, PartialOrd)]
pub struct Mutation {
  pub is_delete: Option<bool>,
  pub column: Option<Text>,
  pub value: Option<Text>,
  pub write_to_w_a_l: Option<bool>,
}

impl Mutation {
  pub fn new<F1, F2, F3, F4>(is_delete: F1, column: F2, value: F3, write_to_w_a_l: F4) -> Mutation where F1: Into<Option<bool>>, F2: Into<Option<Text>>, F3: Into<Option<Text>>, F4: Into<Option<bool>> {
    Mutation {
      is_delete: is_delete.into(),
      column: column.into(),
      value: value.into(),
      write_to_w_a_l: write_to_w_a_l.into(),
    }
  }
  pub fn read_from_in_protocol(i_prot: &mut dyn TInputProtocol) -> thrift::Result<Mutation> {
    i_prot.read_struct_begin()?;
    let mut f_1: Option<bool> = Some(false);
    let mut f_2: Option<Text> = Some(Vec::new());
    let mut f_3: Option<Text> = Some(Vec::new());
    let mut f_4: Option<bool> = Some(false);
    loop {
      let field_ident = i_prot.read_field_begin()?;
      if field_ident.field_type == TType::Stop {
        break;
      }
      let field_id = field_id(&field_ident)?;
      match field_id {
        1 => {
          let val = i_prot.read_bool()?;
          f_1 = Some(val);
        },
        2 => {
          let val = i_prot.read_bytes()?;
          f_2 = Some(val);
        },
        3 => {
          let val = i_prot.read_bytes()?;
          f_3 = Some(val);
        },
        4 => {
          let val = i_prot.read_bool()?;
          f_4 = Some(val);
        },
        _ => {
          i_prot.skip(field_ident.field_type)?;
        },
      };
      i_prot.read_field_end()?;
    }
    i_prot.read_struct_end()?;
    let ret = Mutation {
      is_delete: f_1,
      column: f_2,
      value: f_3,
      write_to_w_a_l: f_4,
    };
    Ok(ret)
  }
  pub fn write_to_out_protocol(&self, o_prot: &mut dyn TOutputProtocol) -> thrift::Result<()> {
    let struct_ident = TStructIdentifier::new("Mutation");
    o_prot.write_struct_begin(&struct_ident)?;
    if let Some(fld_var) = self.is_delete {
      o_prot.write_field_begin(&TFieldIdentifier::new("isDelete", TType::Bool, 1))?;
      o_prot.write_bool(fld_var)?;
      o_prot.write_field_end()?
    }
    if let Some(ref fld_var) = self.column {
      o_prot.write_field_begin(&TFieldIdentifier::new("column", TType::String, 2))?;
      o_prot.write_bytes(fld_var)?;
      o_prot.write_field_end()?
    }
    if let Some(ref fld_var) = self.value {
      o_prot.write_field_begin(&TFieldIdentifier::new("value", TType::String, 3))?;
      o_prot.write_bytes(fld_var)?;
      o_prot.write_field_end()?
    }
    if let Some(fld_var) = self.write_to_w_a_l {
      o_prot.write_field_begin(&TFieldIdentifier::new("writeToWAL", TType::Bool, 4))?;
      o_prot.write_bool(fld_var)?;
      o_prot.write_field_end()?
    }
    o_prot.write_field_stop()?;
    o_prot.write_struct_end()
  }
}

impl Default for Mutation {
  fn default() -> Self {
    Mutation{
      is_delete: Some(false),
      column: Some(Vec::new()),
      value: Some(Vec::new()),
      write_to_w_a_l: Some(false),
    }
  }
}

//
// BatchMutation
//

/// A BatchMutation object is used to apply a number of Mutations to a single row.
#[derive(Clone, Debug, Eq, Hash, Ord, PartialEq, PartialOrd)]
pub struct BatchMutation {
  pub row: Option<Text>,
  pub mutations: Option<Vec<Mutation>>,
}

impl BatchMutation {
  pub fn new<F1, F2>(row: F1, mutations: F2) -> BatchMutation where F1: Into<Option<Text>>, F2: Into<Option<Vec<Mutation>>> {
    BatchMutation {
      row: row.into(),
      mutations: mutations.into(),
    }
  }
  pub fn read_from_in_protocol(i_prot: &mut dyn TInputProtocol) -> thrift::Result<BatchMutation> {
    i_prot.read_struct_begin()?;
    let mut f_1: Option<Text> = Some(Vec::new());
    let mut f_2: Option<Vec<Mutation>> = Some(Vec::new());
    loop {
      let field_ident = i_prot.read_field_begin()?;
      if field_ident.field_type == TType::Stop {
        break;
      }
      let field_id = field_id(&field_ident)?;
      match field_id {
        1 => {
          let val = i_prot.read_bytes()?;
          f_1 = Some(val);
        },
        2 => {
          let list_ident = i_prot.read_list_begin()?;
          let mut val: Vec<Mutation> = Vec::with_capacity(list_ident.size as usize);
          for _ in 0..list_ident.size {
            let list_elem_0 = Mutation::read_from_in_protocol(i_prot)?;
            val.push(list_elem_0);
          }
          i_prot.read_list_end()?;
          f_2 = Some(val);
        },
        _ => {
          i_prot.skip(field_ident.field_type)?;
        },
      };
      i_prot.read_field_end()?;
    }
    i_prot.read_struct_end()?;
    let ret = BatchMutation {
      row: f_1,
      mutations: f_2,
    };
    Ok(ret)
  }
  pub fn write_to_out_protocol(&self, o_prot: &mut dyn TOutputProtocol) -> thrift::Result<()> {
    let struct_ident = TStructIdentifier::new("BatchMutation");
    o_prot.write_struct_begin(&struct_ident)?;
    if let Some(ref fld_var) = self.row {
      o_prot.write_field_begin(&TFieldIdentifier::new("row", TType::String, 1))?;
      o_prot.write_bytes(fld_var)?;
      o_prot.write_field_end()?
    }
    if let Some(ref fld_var) = self.mutations {
      o_prot.write_field_begin(&TFieldIdentifier::new("mutations", TType::List, 2))?;
      o_prot.write_list_begin(&TListIdentifier::new(TType::Struct, fld_var.len() as i32))?;
      for e in fld_var {
        e.write_to_out_protocol(o_prot)?;
      }
      o_prot.write_list_end()?;
      o_prot.write_field_end()?
    }
    o_prot.write_field_stop()?;
    o_prot.write_struct_end()
  }
}

impl Default for BatchMutation {
  fn default() -> Self {
    BatchMutation{
      row: Some(Vec::new()),
      mutations: Some(Vec::new()),
    }
  }
}

//
// TIncrement
//

/// For increments that are not incrementColumnValue
/// equivalents.
#[derive(Clone, Debug, Eq, Hash, Ord, PartialEq, PartialOrd)]
pub struct TIncrement {
  pub table: Option<Text>,
  pub row: Option<Text>,
  pub column: Option<Text>,
  pub ammount: Option<i64>,
}

impl TIncrement {
  pub fn new<F1, F2, F3, F4>(table: F1, row: F2, column: F3, ammount: F4) -> TIncrement where F1: Into<Option<Text>>, F2: Into<Option<Text>>, F3: Into<Option<Text>>, F4: Into<Option<i64>> {
    TIncrement {
      table: table.into(),
      row: row.into(),
      column: column.into(),
      ammount: ammount.into(),
    }
  }
  pub fn read_from_in_protocol(i_prot: &mut dyn TInputProtocol) -> thrift::Result<TIncrement> {
    i_prot.read_struct_begin()?;
    let mut f_1: Option<Text> = Some(Vec::new());
    let mut f_2: Option<Text> = Some(Vec::new());
    let mut f_3: Option<Text> = Some(Vec::new());
    let mut f_4: Option<i64> = Some(0);
    loop {
      let field_ident = i_prot.read_field_begin()?;
      if field_ident.field_type == TType::Stop {
        break;
      }
      let field_id = field_id(&field_ident)?;
      match field_id {
        1 => {
          let val = i_prot.read_bytes()?;
          f_1 = Some(val);
        },
        2 => {
          let val = i_prot.read_bytes()?;
          f_2 = Some(val);
        },
        3 => {
          let val = i_prot.read_bytes()?;
          f_3 = Some(val);
        },
        4 => {
          let val = i_prot.read_i64()?;
          f_4 = Some(val);
        },
        _ => {
          i_prot.skip(field_ident.field_type)?;
        },
      };
      i_prot.read_field_end()?;
    }
    i_prot.read_struct_end()?;
    let ret = TIncrement {
      table: f_1,
      row: f_2,
      column: f_3,
      ammount: f_4,
    };
    Ok(ret)
  }
  pub fn write_to_out_protocol(&self, o_prot: &mut dyn TOutputProtocol) -> thrift::Result<()> {
    let struct_ident = TStructIdentifier::new("TIncrement");
    o_prot.write_struct_begin(&struct_ident)?;
    if let Some(ref fld_var) = self.table {
      o_prot.write_field_begin(&TFieldIdentifier::new("table", TType::String, 1))?;
      o_prot.write_bytes(fld_var)?;
      o_prot.write_field_end()?
    }
    if let Some(ref fld_var) = self.row {
      o_prot.write_field_begin(&TFieldIdentifier::new("row", TType::String, 2))?;
      o_prot.write_bytes(fld_var)?;
      o_prot.write_field_end()?
    }
    if let Some(ref fld_var) = self.column {
      o_prot.write_field_begin(&TFieldIdentifier::new("column", TType::String, 3))?;
      o_prot.write_bytes(fld_var)?;
      o_prot.write_field_end()?
    }
    if let Some(fld_var) = self.ammount {
      o_prot.write_field_begin(&TFieldIdentifier::new("ammount", TType::I64, 4))?;
      o_prot.write_i64(fld_var)?;
      o_prot.write_field_end()?
    }
    o_prot.write_field_stop()?;
    o_prot.write_struct_end()
  }
}

impl Default for TIncrement {
  fn default() -> Self {
    TIncrement{
      table: Some(Vec::new()),
      row: Some(Vec::new()),
      column: Some(Vec::new()),
      ammount: Some(0),
    }
  }
}

//
// TColumn
//

/// Holds column name and the cell.
#[derive(Clone, Debug, Eq, Hash, Ord, PartialEq, PartialOrd)]
pub struct TColumn {
  pub column_name: Option<Text>,
  pub cell: Option<TCell>,
}

impl TColumn {
  pub fn new<F1, F2>(column_name: F1, cell: F2) -> TColumn where F1: Into<Option<Text>>, F2: Into<Option<TCell>> {
    TColumn {
      column_name: column_name.into(),
      cell: cell.into(),
    }
  }
  pub fn read_from_in_protocol(i_prot: &mut dyn TInputProtocol) -> thrift::Result<TColumn> {
    i_prot.read_struct_begin()?;
    let mut f_1: Option<Text> = Some(Vec::new());
    let mut f_2: Option<TCell> = None;
    loop {
      let field_ident = i_prot.read_field_begin()?;
      if field_ident.field_type == TType::Stop {
        break;
      }
      let field_id = field_id(&field_ident)?;
      match field_id {
        1 => {
          let val = i_prot.read_bytes()?;
          f_1 = Some(val);
        },
        2 => {
          let val = TCell::read_from_in_protocol(i_prot)?;
          f_2 = Some(val);
        },
        _ => {
          i_prot.skip(field_ident.field_type)?;
        },
      };
      i_prot.read_field_end()?;
    }
    i_prot.read_struct_end()?;
    let ret = TColumn {
      column_name: f_1,
      cell: f_2,
    };
    Ok(ret)
  }
  pub fn write_to_out_protocol(&self, o_prot: &mut dyn TOutputProtocol) -> thrift::Result<()> {
    let struct_ident = TStructIdentifier::new("TColumn");
    o_prot.write_struct_begin(&struct_ident)?;
    if let Some(ref fld_var) = self.column_name {
      o_prot.write_field_begin(&TFieldIdentifier::new("columnName", TType::String, 1))?;
      o_prot.write_bytes(fld_var)?;
      o_prot.write_field_end()?
    }
    if let Some(ref fld_var) = self.cell {
      o_prot.write_field_begin(&TFieldIdentifier::new("cell", TType::Struct, 2))?;
      fld_var.write_to_out_protocol(o_prot)?;
      o_prot.write_field_end()?
    }
    o_prot.write_field_stop()?;
    o_prot.write_struct_end()
  }
}

impl Default for TColumn {
  fn default() -> Self {
    TColumn{
      column_name: Some(Vec::new()),
      cell: None,
    }
  }
}

//
// TRowResult
//

/// Holds row name and then a map of columns to cells.
#[derive(Clone, Debug, Eq, Hash, Ord, PartialEq, PartialOrd)]
pub struct TRowResult {
  pub row: Option<Text>,
  pub columns: Option<BTreeMap<Text, TCell>>,
  pub sorted_columns: Option<Vec<TColumn>>,
}

impl TRowResult {
  pub fn new<F1, F2, F3>(row: F1, columns: F2, sorted_columns: F3) -> TRowResult where F1: Into<Option<Text>>, F2: Into<Option<BTreeMap<Text, TCell>>>, F3: Into<Option<Vec<TColumn>>> {
    TRowResult {
      row: row.into(),
      columns: columns.into(),
      sorted_columns: sorted_columns.into(),
    }
  }
  pub fn read_from_in_protocol(i_prot: &mut dyn TInputProtocol) -> thrift::Result<TRowResult> {
    i_prot.read_struct_begin()?;
    let mut f_1: Option<Text> = Some(Vec::new());
    let mut f_2: Option<BTreeMap<Text, TCell>> = None;
    let mut f_3: Option<Vec<TColumn>> = None;
    loop {
      let field_ident = i_prot.read_field_begin()?;
      if field_ident.field_type == TType::Stop {
        break;
      }
      let field_id = field_id(&field_ident)?;
      match field_id {
        1 => {
          let val = i_prot.read_bytes()?;
          f_1 = Some(val);
        },
        2 => {
          let map_ident = i_prot.read_map_begin()?;
          let mut val: BTreeMap<Text, TCell> = BTreeMap::new();
          for _ in 0..map_ident.size {
            let map_key_1 = i_prot.read_bytes()?;
            let map_val_2 = TCell::read_from_in_protocol(i_prot)?;
            val.insert(map_key_1, map_val_2);
          }
          i_prot.read_map_end()?;
          f_2 = Some(val);
        },
        3 => {
          let list_ident = i_prot.read_list_begin()?;
          let mut val: Vec<TColumn> = Vec::with_capacity(list_ident.size as usize);
          for _ in 0..list_ident.size {
            let list_elem_3 = TColumn::read_from_in_protocol(i_prot)?;
            val.push(list_elem_3);
          }
          i_prot.read_list_end()?;
          f_3 = Some(val);
        },
        _ => {
          i_prot.skip(field_ident.field_type)?;
        },
      };
      i_prot.read_field_end()?;
    }
    i_prot.read_struct_end()?;
    let ret = TRowResult {
      row: f_1,
      columns: f_2,
      sorted_columns: f_3,
    };
    Ok(ret)
  }
  pub fn write_to_out_protocol(&self, o_prot: &mut dyn TOutputProtocol) -> thrift::Result<()> {
    let struct_ident = TStructIdentifier::new("TRowResult");
    o_prot.write_struct_begin(&struct_ident)?;
    if let Some(ref fld_var) = self.row {
      o_prot.write_field_begin(&TFieldIdentifier::new("row", TType::String, 1))?;
      o_prot.write_bytes(fld_var)?;
      o_prot.write_field_end()?
    }
    if let Some(ref fld_var) = self.columns {
      o_prot.write_field_begin(&TFieldIdentifier::new("columns", TType::Map, 2))?;
      o_prot.write_map_begin(&TMapIdentifier::new(TType::String, TType::Struct, fld_var.len() as i32))?;
      for (k, v) in fld_var {
        o_prot.write_bytes(k)?;
        v.write_to_out_protocol(o_prot)?;
      }
      o_prot.write_map_end()?;
      o_prot.write_field_end()?
    }
    if let Some(ref fld_var) = self.sorted_columns {
      o_prot.write_field_begin(&TFieldIdentifier::new("sortedColumns", TType::List, 3))?;
      o_prot.write_list_begin(&TListIdentifier::new(TType::Struct, fld_var.len() as i32))?;
      for e in fld_var {
        e.write_to_out_protocol(o_prot)?;
      }
      o_prot.write_list_end()?;
      o_prot.write_field_end()?
    }
    o_prot.write_field_stop()?;
    o_prot.write_struct_end()
  }
}

impl Default for TRowResult {
  fn default() -> Self {
    TRowResult{
      row: Some(Vec::new()),
      columns: Some(BTreeMap::new()),
      sorted_columns: Some(Vec::new()),
    }
  }
}

//
// TScan
//

/// A Scan object is used to specify scanner parameters when opening a scanner.
#[derive(Clone, Debug, Eq, Hash, Ord, PartialEq, PartialOrd)]
pub struct TScan {
  pub start_row: Option<Text>,
  pub stop_row: Option<Text>,
  pub timestamp: Option<i64>,
  pub columns: Option<Vec<Text>>,
  pub caching: Option<i32>,
  pub filter_string: Option<Text>,
  pub batch_size: Option<i32>,
  pub sort_columns: Option<bool>,
  pub reversed: Option<bool>,
  pub cache_blocks: Option<bool>,
}

impl TScan {
  pub fn new<F1, F2, F3, F4, F5, F6, F7, F8, F9, F10>(start_row: F1, stop_row: F2, timestamp: F3, columns: F4, caching: F5, filter_string: F6, batch_size: F7, sort_columns: F8, reversed: F9, cache_blocks: F10) -> TScan where F1: Into<Option<Text>>, F2: Into<Option<Text>>, F3: Into<Option<i64>>, F4: Into<Option<Vec<Text>>>, F5: Into<Option<i32>>, F6: Into<Option<Text>>, F7: Into<Option<i32>>, F8: Into<Option<bool>>, F9: Into<Option<bool>>, F10: Into<Option<bool>> {
    TScan {
      start_row: start_row.into(),
      stop_row: stop_row.into(),
      timestamp: timestamp.into(),
      columns: columns.into(),
      caching: caching.into(),
      filter_string: filter_string.into(),
      batch_size: batch_size.into(),
      sort_columns: sort_columns.into(),
      reversed: reversed.into(),
      cache_blocks: cache_blocks.into(),
    }
  }
  pub fn read_from_in_protocol(i_prot: &mut dyn TInputProtocol) -> thrift::Result<TScan> {
    i_prot.read_struct_begin()?;
    let mut f_1: Option<Text> = None;
    let mut f_2: Option<Text> = None;
    let mut f_3: Option<i64> = None;
    let mut f_4: Option<Vec<Text>> = None;
    let mut f_5: Option<i32> = None;
    let mut f_6: Option<Text> = None;
    let mut f_7: Option<i32> = None;
    let mut f_8: Option<bool> = None;
    let mut f_9: Option<bool> = None;
    let mut f_10: Option<bool> = None;
    loop {
      let field_ident = i_prot.read_field_begin()?;
      if field_ident.field_type == TType::Stop {
        break;
      }
      let field_id = field_id(&field_ident)?;
      match field_id {
        1 => {
          let val = i_prot.read_bytes()?;
          f_1 = Some(val);
        },
        2 => {
          let val = i_prot.read_bytes()?;
          f_2 = Some(val);
        },
        3 => {
          let val = i_prot.read_i64()?;
          f_3 = Some(val);
        },
        4 => {
          let list_ident = i_prot.read_list_begin()?;
          let mut val: Vec<Text> = Vec::with_capacity(list_ident.size as usize);
          for _ in 0..list_ident.size {
            let list_elem_4 = i_prot.read_bytes()?;
            val.push(list_elem_4);
          }
          i_prot.read_list_end()?;
          f_4 = Some(val);
        },
        5 => {
          let val = i_prot.read_i32()?;
          f_5 = Some(val);
        },
        6 => {
          let val = i_prot.read_bytes()?;
          f_6 = Some(val);
        },
        7 => {
          let val = i_prot.read_i32()?;
          f_7 = Some(val);
        },
        8 => {
          let val = i_prot.read_bool()?;
          f_8 = Some(val);
        },
        9 => {
          let val = i_prot.read_bool()?;
          f_9 = Some(val);
        },
        10 => {
          let val = i_prot.read_bool()?;
          f_10 = Some(val);
        },
        _ => {
          i_prot.skip(field_ident.field_type)?;
        },
      };
      i_prot.read_field_end()?;
    }
    i_prot.read_struct_end()?;
    let ret = TScan {
      start_row: f_1,
      stop_row: f_2,
      timestamp: f_3,
      columns: f_4,
      caching: f_5,
      filter_string: f_6,
      batch_size: f_7,
      sort_columns: f_8,
      reversed: f_9,
      cache_blocks: f_10,
    };
    Ok(ret)
  }
  pub fn write_to_out_protocol(&self, o_prot: &mut dyn TOutputProtocol) -> thrift::Result<()> {
    let struct_ident = TStructIdentifier::new("TScan");
    o_prot.write_struct_begin(&struct_ident)?;
    if let Some(ref fld_var) = self.start_row {
      o_prot.write_field_begin(&TFieldIdentifier::new("startRow", TType::String, 1))?;
      o_prot.write_bytes(fld_var)?;
      o_prot.write_field_end()?
    }
    if let Some(ref fld_var) = self.stop_row {
      o_prot.write_field_begin(&TFieldIdentifier::new("stopRow", TType::String, 2))?;
      o_prot.write_bytes(fld_var)?;
      o_prot.write_field_end()?
    }
    if let Some(fld_var) = self.timestamp {
      o_prot.write_field_begin(&TFieldIdentifier::new("timestamp", TType::I64, 3))?;
      o_prot.write_i64(fld_var)?;
      o_prot.write_field_end()?
    }
    if let Some(ref fld_var) = self.columns {
      o_prot.write_field_begin(&TFieldIdentifier::new("columns", TType::List, 4))?;
      o_prot.write_list_begin(&TListIdentifier::new(TType::String, fld_var.len() as i32))?;
      for e in fld_var {
        o_prot.write_bytes(e)?;
      }
      o_prot.write_list_end()?;
      o_prot.write_field_end()?
    }
    if let Some(fld_var) = self.caching {
      o_prot.write_field_begin(&TFieldIdentifier::new("caching", TType::I32, 5))?;
      o_prot.write_i32(fld_var)?;
      o_prot.write_field_end()?
    }
    if let Some(ref fld_var) = self.filter_string {
      o_prot.write_field_begin(&TFieldIdentifier::new("filterString", TType::String, 6))?;
      o_prot.write_bytes(fld_var)?;
      o_prot.write_field_end()?
    }
    if let Some(fld_var) = self.batch_size {
      o_prot.write_field_begin(&TFieldIdentifier::new("batchSize", TType::I32, 7))?;
      o_prot.write_i32(fld_var)?;
      o_prot.write_field_end()?
    }
    if let Some(fld_var) = self.sort_columns {
      o_prot.write_field_begin(&TFieldIdentifier::new("sortColumns", TType::Bool, 8))?;
      o_prot.write_bool(fld_var)?;
      o_prot.write_field_end()?
    }
    if let Some(fld_var) = self.reversed {
      o_prot.write_field_begin(&TFieldIdentifier::new("reversed", TType::Bool, 9))?;
      o_prot.write_bool(fld_var)?;
      o_prot.write_field_end()?
    }
    if let Some(fld_var) = self.cache_blocks {
      o_prot.write_field_begin(&TFieldIdentifier::new("cacheBlocks", TType::Bool, 10))?;
      o_prot.write_bool(fld_var)?;
      o_prot.write_field_end()?
    }
    o_prot.write_field_stop()?;
    o_prot.write_struct_end()
  }
}

impl Default for TScan {
  fn default() -> Self {
    TScan{
      start_row: Some(Vec::new()),
      stop_row: Some(Vec::new()),
      timestamp: Some(0),
      columns: Some(Vec::new()),
      caching: Some(0),
      filter_string: Some(Vec::new()),
      batch_size: Some(0),
      sort_columns: Some(false),
      reversed: Some(false),
      cache_blocks: Some(false),
    }
  }
}

//
// TAppend
//

/// An Append object is used to specify the parameters for performing the append operation.
#[derive(Clone, Debug, Eq, Hash, Ord, PartialEq, PartialOrd)]
pub struct TAppend {
  pub table: Option<Text>,
  pub row: Option<Text>,
  pub columns: Option<Vec<Text>>,
  pub values: Option<Vec<Text>>,
}

impl TAppend {
  pub fn new<F1, F2, F3, F4>(table: F1, row: F2, columns: F3, values: F4) -> TAppend where F1: Into<Option<Text>>, F2: Into<Option<Text>>, F3: Into<Option<Vec<Text>>>, F4: Into<Option<Vec<Text>>> {
    TAppend {
      table: table.into(),
      row: row.into(),
      columns: columns.into(),
      values: values.into(),
    }
  }
  pub fn read_from_in_protocol(i_prot: &mut dyn TInputProtocol) -> thrift::Result<TAppend> {
    i_prot.read_struct_begin()?;
    let mut f_1: Option<Text> = Some(Vec::new());
    let mut f_2: Option<Text> = Some(Vec::new());
    let mut f_3: Option<Vec<Text>> = Some(Vec::new());
    let mut f_4: Option<Vec<Text>> = Some(Vec::new());
    loop {
      let field_ident = i_prot.read_field_begin()?;
      if field_ident.field_type == TType::Stop {
        break;
      }
      let field_id = field_id(&field_ident)?;
      match field_id {
        1 => {
          let val = i_prot.read_bytes()?;
          f_1 = Some(val);
        },
        2 => {
          let val = i_prot.read_bytes()?;
          f_2 = Some(val);
        },
        3 => {
          let list_ident = i_prot.read_list_begin()?;
          let mut val: Vec<Text> = Vec::with_capacity(list_ident.size as usize);
          for _ in 0..list_ident.size {
            let list_elem_5 = i_prot.read_bytes()?;
            val.push(list_elem_5);
          }
          i_prot.read_list_end()?;
          f_3 = Some(val);
        },
        4 => {
          let list_ident = i_prot.read_list_begin()?;
          let mut val: Vec<Text> = Vec::with_capacity(list_ident.size as usize);
          for _ in 0..list_ident.size {
            let list_elem_6 = i_prot.read_bytes()?;
            val.push(list_elem_6);
          }
          i_prot.read_list_end()?;
          f_4 = Some(val);
        },
        _ => {
          i_prot.skip(field_ident.field_type)?;
        },
      };
      i_prot.read_field_end()?;
    }
    i_prot.read_struct_end()?;
    let ret = TAppend {
      table: f_1,
      row: f_2,
      columns: f_3,
      values: f_4,
    };
    Ok(ret)
  }
  pub fn write_to_out_protocol(&self, o_prot: &mut dyn TOutputProtocol) -> thrift::Result<()> {
    let struct_ident = TStructIdentifier::new("TAppend");
    o_prot.write_struct_begin(&struct_ident)?;
    if let Some(ref fld_var) = self.table {
      o_prot.write_field_begin(&TFieldIdentifier::new("table", TType::String, 1))?;
      o_prot.write_bytes(fld_var)?;
      o_prot.write_field_end()?
    }
    if let Some(ref fld_var) = self.row {
      o_prot.write_field_begin(&TFieldIdentifier::new("row", TType::String, 2))?;
      o_prot.write_bytes(fld_var)?;
      o_prot.write_field_end()?
    }
    if let Some(ref fld_var) = self.columns {
      o_prot.write_field_begin(&TFieldIdentifier::new("columns", TType::List, 3))?;
      o_prot.write_list_begin(&TListIdentifier::new(TType::String, fld_var.len() as i32))?;
      for e in fld_var {
        o_prot.write_bytes(e)?;
      }
      o_prot.write_list_end()?;
      o_prot.write_field_end()?
    }
    if let Some(ref fld_var) = self.values {
      o_prot.write_field_begin(&TFieldIdentifier::new("values", TType::List, 4))?;
      o_prot.write_list_begin(&TListIdentifier::new(TType::String, fld_var.len() as i32))?;
      for e in fld_var {
        o_prot.write_bytes(e)?;
      }
      o_prot.write_list_end()?;
      o_prot.write_field_end()?
    }
    o_prot.write_field_stop()?;
    o_prot.write_struct_end()
  }
}

impl Default for TAppend {
  fn default() -> Self {
    TAppend{
      table: Some(Vec::new()),
      row: Some(Vec::new()),
      columns: Some(Vec::new()),
      values: Some(Vec::new()),
    }
  }
}

//
// IOError
//

/// An IOError exception signals that an error occurred communicating
/// to the Hbase master or an Hbase region server.  Also used to return
/// more general Hbase error conditions.
#[derive(Clone, Debug, Eq, Hash, Ord, PartialEq, PartialOrd)]
pub struct IOError {
  pub message: Option<String>,
  pub can_retry: Option<bool>,
}

impl IOError {
  pub fn new<F1, F2>(message: F1, can_retry: F2) -> IOError where F1: Into<Option<String>>, F2: Into<Option<bool>> {
    IOError {
      message: message.into(),
      can_retry: can_retry.into(),
    }
  }
  pub fn read_from_in_protocol(i_prot: &mut dyn TInputProtocol) -> thrift::Result<IOError> {
    i_prot.read_struct_begin()?;
    let mut f_1: Option<String> = Some("".to_owned());
    let mut f_2: Option<bool> = Some(false);
    loop {
      let field_ident = i_prot.read_field_begin()?;
      if field_ident.field_type == TType::Stop {
        break;
      }
      let field_id = field_id(&field_ident)?;
      match field_id {
        1 => {
          let val = i_prot.read_string()?;
          f_1 = Some(val);
        },
        2 => {
          let val = i_prot.read_bool()?;
          f_2 = Some(val);
        },
        _ => {
          i_prot.skip(field_ident.field_type)?;
        },
      };
      i_prot.read_field_end()?;
    }
    i_prot.read_struct_end()?;
    let ret = IOError {
      message: f_1,
      can_retry: f_2,
    };
    Ok(ret)
  }
  pub fn write_to_out_protocol(&self, o_prot: &mut dyn TOutputProtocol) -> thrift::Result<()> {
    let struct_ident = TStructIdentifier::new("IOError");
    o_prot.write_struct_begin(&struct_ident)?;
    if let Some(ref fld_var) = self.message {
      o_prot.write_field_begin(&TFieldIdentifier::new("message", TType::String, 1))?;
      o_prot.write_string(fld_var)?;
      o_prot.write_field_end()?
    }
    if let Some(fld_var) = self.can_retry {
      o_prot.write_field_begin(&TFieldIdentifier::new("canRetry", TType::Bool, 2))?;
      o_prot.write_bool(fld_var)?;
      o_prot.write_field_end()?
    }
    o_prot.write_field_stop()?;
    o_prot.write_struct_end()
  }
}

impl Default for IOError {
  fn default() -> Self {
    IOError{
      message: Some("".to_owned()),
      can_retry: Some(false),
    }
  }
}

impl Error for IOError {}

impl From<IOError> for thrift::Error {
  fn from(e: IOError) -> Self {
    thrift::Error::User(Box::new(e))
  }
}

impl Display for IOError {
  fn fmt(&self, f: &mut Formatter) -> fmt::Result {
    write!(f, "remote service threw IOError")
  }
}

//
// IllegalArgument
//

/// An IllegalArgument exception indicates an illegal or invalid
/// argument was passed into a procedure.
#[derive(Clone, Debug, Eq, Hash, Ord, PartialEq, PartialOrd)]
pub struct IllegalArgument {
  pub message: Option<String>,
}

impl IllegalArgument {
  pub fn new<F1>(message: F1) -> IllegalArgument where F1: Into<Option<String>> {
    IllegalArgument {
      message: message.into(),
    }
  }
  pub fn read_from_in_protocol(i_prot: &mut dyn TInputProtocol) -> thrift::Result<IllegalArgument> {
    i_prot.read_struct_begin()?;
    let mut f_1: Option<String> = Some("".to_owned());
    loop {
      let field_ident = i_prot.read_field_begin()?;
      if field_ident.field_type == TType::Stop {
        break;
      }
      let field_id = field_id(&field_ident)?;
      match field_id {
        1 => {
          let val = i_prot.read_string()?;
          f_1 = Some(val);
        },
        _ => {
          i_prot.skip(field_ident.field_type)?;
        },
      };
      i_prot.read_field_end()?;
    }
    i_prot.read_struct_end()?;
    let ret = IllegalArgument {
      message: f_1,
    };
    Ok(ret)
  }
  pub fn write_to_out_protocol(&self, o_prot: &mut dyn TOutputProtocol) -> thrift::Result<()> {
    let struct_ident = TStructIdentifier::new("IllegalArgument");
    o_prot.write_struct_begin(&struct_ident)?;
    if let Some(ref fld_var) = self.message {
      o_prot.write_field_begin(&TFieldIdentifier::new("message", TType::String, 1))?;
      o_prot.write_string(fld_var)?;
      o_prot.write_field_end()?
    }
    o_prot.write_field_stop()?;
    o_prot.write_struct_end()
  }
}

impl Default for IllegalArgument {
  fn default() -> Self {
    IllegalArgument{
      message: Some("".to_owned()),
    }
  }
}

impl Error for IllegalArgument {}

impl From<IllegalArgument> for thrift::Error {
  fn from(e: IllegalArgument) -> Self {
    thrift::Error::User(Box::new(e))
  }
}

impl Display for IllegalArgument {
  fn fmt(&self, f: &mut Formatter) -> fmt::Result {
    write!(f, "remote service threw IllegalArgument")
  }
}

//
// AlreadyExists
//

/// An AlreadyExists exceptions signals that a table with the specified
/// name already exists
#[derive(Clone, Debug, Eq, Hash, Ord, PartialEq, PartialOrd)]
pub struct AlreadyExists {
  pub message: Option<String>,
}

impl AlreadyExists {
  pub fn new<F1>(message: F1) -> AlreadyExists where F1: Into<Option<String>> {
    AlreadyExists {
      message: message.into(),
    }
  }
  pub fn read_from_in_protocol(i_prot: &mut dyn TInputProtocol) -> thrift::Result<AlreadyExists> {
    i_prot.read_struct_begin()?;
    let mut f_1: Option<String> = Some("".to_owned());
    loop {
      let field_ident = i_prot.read_field_begin()?;
      if field_ident.field_type == TType::Stop {
        break;
      }
      let field_id = field_id(&field_ident)?;
      match field_id {
        1 => {
          let val = i_prot.read_string()?;
          f_1 = Some(val);
        },
        _ => {
          i_prot.skip(field_ident.field_type)?;
        },
      };
      i_prot.read_field_end()?;
    }
    i_prot.read_struct_end()?;
    let ret = AlreadyExists {
      message: f_1,
    };
    Ok(ret)
  }
  pub fn write_to_out_protocol(&self, o_prot: &mut dyn TOutputProtocol) -> thrift::Result<()> {
    let struct_ident = TStructIdentifier::new("AlreadyExists");
    o_prot.write_struct_begin(&struct_ident)?;
    if let Some(ref fld_var) = self.message {
      o_prot.write_field_begin(&TFieldIdentifier::new("message", TType::String, 1))?;
      o_prot.write_string(fld_var)?;
      o_prot.write_field_end()?
    }
    o_prot.write_field_stop()?;
    o_prot.write_struct_end()
  }
}

impl Default for AlreadyExists {
  fn default() -> Self {
    AlreadyExists{
      message: Some("".to_owned()),
    }
  }
}

impl Error for AlreadyExists {}

impl From<AlreadyExists> for thrift::Error {
  fn from(e: AlreadyExists) -> Self {
    thrift::Error::User(Box::new(e))
  }
}

impl Display for AlreadyExists {
  fn fmt(&self, f: &mut Formatter) -> fmt::Result {
    write!(f, "remote service threw AlreadyExists")
  }
}

//
// TAccessControlEntity
//

/// TAccessControlEntity for permission control
#[derive(Clone, Debug, Eq, Hash, Ord, PartialEq, PartialOrd)]
pub struct TAccessControlEntity {
  pub username: String,
  pub scope: TPermissionScope,
  pub actions: String,
  pub table_name: Option<Bytes>,
  pub ns_name: Option<String>,
}

impl TAccessControlEntity {
  pub fn new<F5, F6>(username: String, scope: TPermissionScope, actions: String, table_name: F5, ns_name: F6) -> TAccessControlEntity where F5: Into<Option<Bytes>>, F6: Into<Option<String>> {
    TAccessControlEntity {
      username,
      scope,
      actions,
      table_name: table_name.into(),
      ns_name: ns_name.into(),
    }
  }
  pub fn read_from_in_protocol(i_prot: &mut dyn TInputProtocol) -> thrift::Result<TAccessControlEntity> {
    i_prot.read_struct_begin()?;
    let mut f_1: Option<String> = None;
    let mut f_2: Option<TPermissionScope> = None;
    let mut f_4: Option<String> = None;
    let mut f_5: Option<Bytes> = None;
    let mut f_6: Option<String> = None;
    loop {
      let field_ident = i_prot.read_field_begin()?;
      if field_ident.field_type == TType::Stop {
        break;
      }
      let field_id = field_id(&field_ident)?;
      match field_id {
        1 => {
          let val = i_prot.read_string()?;
          f_1 = Some(val);
        },
        2 => {
          let val = TPermissionScope::read_from_in_protocol(i_prot)?;
          f_2 = Some(val);
        },
        4 => {
          let val = i_prot.read_string()?;
          f_4 = Some(val);
        },
        5 => {
          let val = i_prot.read_bytes()?;
          f_5 = Some(val);
        },
        6 => {
          let val = i_prot.read_string()?;
          f_6 = Some(val);
        },
        _ => {
          i_prot.skip(field_ident.field_type)?;
        },
      };
      i_prot.read_field_end()?;
    }
    i_prot.read_struct_end()?;
    verify_required_field_exists("TAccessControlEntity.username", &f_1)?;
    verify_required_field_exists("TAccessControlEntity.scope", &f_2)?;
    verify_required_field_exists("TAccessControlEntity.actions", &f_4)?;
    let ret = TAccessControlEntity {
      username: f_1.expect("auto-generated code should have checked for presence of required fields"),
      scope: f_2.expect("auto-generated code should have checked for presence of required fields"),
      actions: f_4.expect("auto-generated code should have checked for presence of required fields"),
      table_name: f_5,
      ns_name: f_6,
    };
    Ok(ret)
  }
  pub fn write_to_out_protocol(&self, o_prot: &mut dyn TOutputProtocol) -> thrift::Result<()> {
    let struct_ident = TStructIdentifier::new("TAccessControlEntity");
    o_prot.write_struct_begin(&struct_ident)?;
    o_prot.write_field_begin(&TFieldIdentifier::new("username", TType::String, 1))?;
    o_prot.write_string(&self.username)?;
    o_prot.write_field_end()?;
    o_prot.write_field_begin(&TFieldIdentifier::new("scope", TType::I32, 2))?;
    self.scope.write_to_out_protocol(o_prot)?;
    o_prot.write_field_end()?;
    o_prot.write_field_begin(&TFieldIdentifier::new("actions", TType::String, 4))?;
    o_prot.write_string(&self.actions)?;
    o_prot.write_field_end()?;
    if let Some(ref fld_var) = self.table_name {
      o_prot.write_field_begin(&TFieldIdentifier::new("tableName", TType::String, 5))?;
      o_prot.write_bytes(fld_var)?;
      o_prot.write_field_end()?
    }
    if let Some(ref fld_var) = self.ns_name {
      o_prot.write_field_begin(&TFieldIdentifier::new("nsName", TType::String, 6))?;
      o_prot.write_string(fld_var)?;
      o_prot.write_field_end()?
    }
    o_prot.write_field_stop()?;
    o_prot.write_struct_end()
  }
}

//
// Hbase service client
//

pub trait THbaseSyncClient {
  /// Brings a table on-line (enables it)
  fn enable_table(&mut self, table_name: Bytes) -> thrift::Result<()>;
  /// Disables a table (takes it off-line) If it is being served, the master
  /// will tell the servers to stop serving it.
  fn disable_table(&mut self, table_name: Bytes) -> thrift::Result<()>;
  /// @return true if table is on-line
  fn is_table_enabled(&mut self, table_name: Bytes) -> thrift::Result<bool>;
  fn compact(&mut self, table_name_or_region_name: Bytes) -> thrift::Result<()>;
  fn major_compact(&mut self, table_name_or_region_name: Bytes) -> thrift::Result<()>;
  /// List all the userspace tables.
  /// 
  /// @return returns a list of names
  fn get_table_names(&mut self) -> thrift::Result<Vec<Text>>;
  /// List all the userspace tables and their enabled or disabled flags.
  /// 
  /// @return list of tables with is enabled flags
  fn get_table_names_with_is_table_enabled(&mut self) -> thrift::Result<BTreeMap<Text, bool>>;
  /// List all the column families assoicated with a table.
  /// 
  /// @return list of column family descriptors
  fn get_column_descriptors(&mut self, table_name: Text) -> thrift::Result<BTreeMap<Text, ColumnDescriptor>>;
  /// List the regions associated with a table.
  /// 
  /// @return list of region descriptors
  fn get_table_regions(&mut self, table_name: Text) -> thrift::Result<Vec<TRegionInfo>>;
  /// Create a table with the specified column families.  The name
  /// field for each ColumnDescriptor must be set and must end in a
  /// colon (:). All other fields are optional and will get default
  /// values if not explicitly specified.
  /// 
  /// @throws IllegalArgument if an input parameter is invalid
  /// 
  /// @throws AlreadyExists if the table name already exists
  fn create_table(&mut self, table_name: Text, column_families: Vec<ColumnDescriptor>) -> thrift::Result<()>;
  /// Deletes a table
  /// 
  /// @throws IOError if table doesn't exist on server or there was some other
  /// problem
  fn delete_table(&mut self, table_name: Text) -> thrift::Result<()>;
  /// Get a single TCell for the specified table, row, and column at the
  /// latest timestamp. Returns an empty list if no such value exists.
  /// 
  /// @return value for specified row/column
  fn get(&mut self, table_name: Text, row: Text, column: Text, attributes: BTreeMap<Text, Text>) -> thrift::Result<Vec<TCell>>;
  /// Get the specified number of versions for the specified table,
  /// row, and column.
  /// 
  /// @return list of cells for specified row/column
  fn get_ver(&mut self, table_name: Text, row: Text, column: Text, num_versions: i32, attributes: BTreeMap<Text, Text>) -> thrift::Result<Vec<TCell>>;
  /// Get the specified number of versions for the specified table,
  /// row, and column.  Only versions less than or equal to the specified
  /// timestamp will be returned.
  /// 
  /// @return list of cells for specified row/column
  fn get_ver_ts(&mut self, table_name: Text, row: Text, column: Text, timestamp: i64, num_versions: i32, attributes: BTreeMap<Text, Text>) -> thrift::Result<Vec<TCell>>;
  /// Get all the data for the specified table and row at the latest
  /// timestamp. Returns an empty list if the row does not exist.
  /// 
  /// @return TRowResult containing the row and map of columns to TCells
  fn get_row(&mut self, table_name: Text, row: Text, attributes: BTreeMap<Text, Text>) -> thrift::Result<Vec<TRowResult>>;
  /// Get the specified columns for the specified table and row at the latest
  /// timestamp. Returns an empty list if the row does not exist.
  /// 
  /// @return TRowResult containing the row and map of columns to TCells
  fn get_row_with_columns(&mut self, table_name: Text, row: Text, columns: Vec<Text>, attributes: BTreeMap<Text, Text>) -> thrift::Result<Vec<TRowResult>>;
  /// Get all the data for the specified table and row at the specified
  /// timestamp. Returns an empty list if the row does not exist.
  /// 
  /// @return TRowResult containing the row and map of columns to TCells
  fn get_row_ts(&mut self, table_name: Text, row: Text, timestamp: i64, attributes: BTreeMap<Text, Text>) -> thrift::Result<Vec<TRowResult>>;
  /// Get the specified columns for the specified table and row at the specified
  /// timestamp. Returns an empty list if the row does not exist.
  /// 
  /// @return TRowResult containing the row and map of columns to TCells
  fn get_row_with_columns_ts(&mut self, table_name: Text, row: Text, columns: Vec<Text>, timestamp: i64, attributes: BTreeMap<Text, Text>) -> thrift::Result<Vec<TRowResult>>;
  /// Get all the data for the specified table and rows at the latest
  /// timestamp. Returns an empty list if no rows exist.
  /// 
  /// @return TRowResult containing the rows and map of columns to TCells
  fn get_rows(&mut self, table_name: Text, rows: Vec<Text>, attributes: BTreeMap<Text, Text>) -> thrift::Result<Vec<TRowResult>>;
  /// Get the specified columns for the specified table and rows at the latest
  /// timestamp. Returns an empty list if no rows exist.
  /// 
  /// @return TRowResult containing the rows and map of columns to TCells
  fn get_rows_with_columns(&mut self, table_name: Text, rows: Vec<Text>, columns: Vec<Text>, attributes: BTreeMap<Text, Text>) -> thrift::Result<Vec<TRowResult>>;
  /// Get all the data for the specified table and rows at the specified
  /// timestamp. Returns an empty list if no rows exist.
  /// 
  /// @return TRowResult containing the rows and map of columns to TCells
  fn get_rows_ts(&mut self, table_name: Text, rows: Vec<Text>, timestamp: i64, attributes: BTreeMap<Text, Text>) -> thrift::Result<Vec<TRowResult>>;
  /// Get the specified columns for the specified table and rows at the specified
  /// timestamp. Returns an empty list if no rows exist.
  /// 
  /// @return TRowResult containing the rows and map of columns to TCells
  fn get_rows_with_columns_ts(&mut self, table_name: Text, rows: Vec<Text>, columns: Vec<Text>, timestamp: i64, attributes: BTreeMap<Text, Text>) -> thrift::Result<Vec<TRowResult>>;
  /// Apply a series of mutations (updates/deletes) to a row in a
  /// single transaction.  If an exception is thrown, then the
  /// transaction is aborted.  Default current timestamp is used, and
  /// all entries will have an identical timestamp.
  fn mutate_row(&mut self, table_name: Text, row: Text, mutations: Vec<Mutation>, attributes: BTreeMap<Text, Text>) -> thrift::Result<()>;
  /// Apply a series of mutations (updates/deletes) to a row in a
  /// single transaction.  If an exception is thrown, then the
  /// transaction is aborted.  The specified timestamp is used, and
  /// all entries will have an identical timestamp.
  fn mutate_row_ts(&mut self, table_name: Text, row: Text, mutations: Vec<Mutation>, timestamp: i64, attributes: BTreeMap<Text, Text>) -> thrift::Result<()>;
  /// Apply a series of batches (each a series of mutations on a single row)
  /// in a single transaction.  If an exception is thrown, then the
  /// transaction is aborted.  Default current timestamp is used, and
  /// all entries will have an identical timestamp.
  fn mutate_rows(&mut self, table_name: Text, row_batches: Vec<BatchMutation>, attributes: BTreeMap<Text, Text>) -> thrift::Result<()>;
  /// Apply a series of batches (each a series of mutations on a single row)
  /// in a single transaction.  If an exception is thrown, then the
  /// transaction is aborted.  The specified timestamp is used, and
  /// all entries will have an identical timestamp.
  fn mutate_rows_ts(&mut self, table_name: Text, row_batches: Vec<BatchMutation>, timestamp: i64, attributes: BTreeMap<Text, Text>) -> thrift::Result<()>;
  /// Atomically increment the column value specified.  Returns the next value post increment.
  fn atomic_increment(&mut self, table_name: Text, row: Text, column: Text, value: i64) -> thrift::Result<i64>;
  /// Delete all cells that match the passed row and column.
  fn delete_all(&mut self, table_name: Text, row: Text, column: Text, attributes: BTreeMap<Text, Text>) -> thrift::Result<()>;
  /// Delete all cells that match the passed row and column and whose
  /// timestamp is equal-to or older than the passed timestamp.
  fn delete_all_ts(&mut self, table_name: Text, row: Text, column: Text, timestamp: i64, attributes: BTreeMap<Text, Text>) -> thrift::Result<()>;
  /// Completely delete the row's cells.
  fn delete_all_row(&mut self, table_name: Text, row: Text, attributes: BTreeMap<Text, Text>) -> thrift::Result<()>;
  /// Increment a cell by the ammount.
  /// Increments can be applied async if hbase.regionserver.thrift.coalesceIncrement is set to true.
  /// False is the default.  Turn to true if you need the extra performance and can accept some
  /// data loss if a thrift server dies with increments still in the queue.
  fn increment(&mut self, increment: TIncrement) -> thrift::Result<()>;
  fn increment_rows(&mut self, increments: Vec<TIncrement>) -> thrift::Result<()>;
  /// Completely delete the row's cells marked with a timestamp
  /// equal-to or older than the passed timestamp.
  fn delete_all_row_ts(&mut self, table_name: Text, row: Text, timestamp: i64, attributes: BTreeMap<Text, Text>) -> thrift::Result<()>;
  /// Get a scanner on the current table, using the Scan instance
  /// for the scan parameters.
  fn scanner_open_with_scan(&mut self, table_name: Text, scan: TScan, attributes: BTreeMap<Text, Text>) -> thrift::Result<ScannerID>;
  /// Get a scanner on the current table starting at the specified row and
  /// ending at the last row in the table.  Return the specified columns.
  /// 
  /// @return scanner id to be used with other scanner procedures
  fn scanner_open(&mut self, table_name: Text, start_row: Text, columns: Vec<Text>, attributes: BTreeMap<Text, Text>) -> thrift::Result<ScannerID>;
  /// Get a scanner on the current table starting and stopping at the
  /// specified rows.  ending at the last row in the table.  Return the
  /// specified columns.
  /// 
  /// @return scanner id to be used with other scanner procedures
  fn scanner_open_with_stop(&mut self, table_name: Text, start_row: Text, stop_row: Text, columns: Vec<Text>, attributes: BTreeMap<Text, Text>) -> thrift::Result<ScannerID>;
  /// Open a scanner for a given prefix.  That is all rows will have the specified
  /// prefix. No other rows will be returned.
  /// 
  /// @return scanner id to use with other scanner calls
  fn scanner_open_with_prefix(&mut self, table_name: Text, start_and_prefix: Text, columns: Vec<Text>, attributes: BTreeMap<Text, Text>) -> thrift::Result<ScannerID>;
  /// Get a scanner on the current table starting at the specified row and
  /// ending at the last row in the table.  Return the specified columns.
  /// Only values with the specified timestamp are returned.
  /// 
  /// @return scanner id to be used with other scanner procedures
  fn scanner_open_ts(&mut self, table_name: Text, start_row: Text, columns: Vec<Text>, timestamp: i64, attributes: BTreeMap<Text, Text>) -> thrift::Result<ScannerID>;
  /// Get a scanner on the current table starting and stopping at the
  /// specified rows.  ending at the last row in the table.  Return the
  /// specified columns.  Only values with the specified timestamp are
  /// returned.
  /// 
  /// @return scanner id to be used with other scanner procedures
  fn scanner_open_with_stop_ts(&mut self, table_name: Text, start_row: Text, stop_row: Text, columns: Vec<Text>, timestamp: i64, attributes: BTreeMap<Text, Text>) -> thrift::Result<ScannerID>;
  /// Returns the scanner's current row value and advances to the next
  /// row in the table.  When there are no more rows in the table, or a key
  /// greater-than-or-equal-to the scanner's specified stopRow is reached,
  /// an empty list is returned.
  /// 
  /// @return a TRowResult containing the current row and a map of the columns to TCells.
  /// 
  /// @throws IllegalArgument if ScannerID is invalid
  /// 
  /// @throws NotFound when the scanner reaches the end
  fn scanner_get(&mut self, id: ScannerID) -> thrift::Result<Vec<TRowResult>>;
  /// Returns, starting at the scanner's current row value nbRows worth of
  /// rows and advances to the next row in the table.  When there are no more
  /// rows in the table, or a key greater-than-or-equal-to the scanner's
  /// specified stopRow is reached,  an empty list is returned.
  /// 
  /// @return a TRowResult containing the current row and a map of the columns to TCells.
  /// 
  /// @throws IllegalArgument if ScannerID is invalid
  /// 
  /// @throws NotFound when the scanner reaches the end
  fn scanner_get_list(&mut self, id: ScannerID, nb_rows: i32) -> thrift::Result<Vec<TRowResult>>;
  /// Closes the server-state associated with an open scanner.
  /// 
  /// @throws IllegalArgument if ScannerID is invalid
  fn scanner_close(&mut self, id: ScannerID) -> thrift::Result<()>;
  /// Get the regininfo for the specified row. It scans
  /// the metatable to find region's start and end keys.
  /// 
  /// @return value for specified row/column
  fn get_region_info(&mut self, row: Text) -> thrift::Result<TRegionInfo>;
  /// Appends values to one or more columns within a single row.
  /// 
  /// @return values of columns after the append operation.
  fn append(&mut self, append: TAppend) -> thrift::Result<Vec<TCell>>;
  /// Atomically checks if a row/family/qualifier value matches the expected
  /// value. If it does, it adds the corresponding mutation operation for put.
  /// 
  /// @return true if the new put was executed, false otherwise
  fn check_and_put(&mut self, table_name: Text, row: Text, column: Text, value: Text, mput: Mutation, attributes: BTreeMap<Text, Text>) -> thrift::Result<bool>;
  /// Get the type of this thrift server.
  /// 
  /// @return the type of this thrift server
  fn get_thrift_server_type(&mut self) -> thrift::Result<TThriftServerType>;
  /// Returns the cluster ID for this cluster.
  fn get_cluster_id(&mut self) -> thrift::Result<String>;
  /// Grant permissions in namespace or table level.
  fn grant(&mut self, info: TAccessControlEntity) -> thrift::Result<bool>;
  /// Revoke permissions in namespace or table level.
  fn revoke(&mut self, info: TAccessControlEntity) -> thrift::Result<bool>;
}

pub trait THbaseSyncClientMarker {}

pub struct HbaseSyncClient<IP, OP> where IP: TInputProtocol, OP: TOutputProtocol {
  _i_prot: IP,
  _o_prot: OP,
  _sequence_number: i32,
}

impl <IP, OP> HbaseSyncClient<IP, OP> where IP: TInputProtocol, OP: TOutputProtocol {
  pub fn new(input_protocol: IP, output_protocol: OP) -> HbaseSyncClient<IP, OP> {
    HbaseSyncClient { _i_prot: input_protocol, _o_prot: output_protocol, _sequence_number: 0 }
  }
}

impl <IP, OP> TThriftClient for HbaseSyncClient<IP, OP> where IP: TInputProtocol, OP: TOutputProtocol {
  fn i_prot_mut(&mut self) -> &mut dyn TInputProtocol { &mut self._i_prot }
  fn o_prot_mut(&mut self) -> &mut dyn TOutputProtocol { &mut self._o_prot }
  fn sequence_number(&self) -> i32 { self._sequence_number }
  fn increment_sequence_number(&mut self) -> i32 { self._sequence_number += 1; self._sequence_number }
}

impl <IP, OP> THbaseSyncClientMarker for HbaseSyncClient<IP, OP> where IP: TInputProtocol, OP: TOutputProtocol {}

impl <C: TThriftClient + THbaseSyncClientMarker> THbaseSyncClient for C {
  fn enable_table(&mut self, table_name: Bytes) -> thrift::Result<()> {
    (
      {
        self.increment_sequence_number();
        let message_ident = TMessageIdentifier::new("enableTable", TMessageType::Call, self.sequence_number());
        let call_args = HbaseEnableTableArgs { table_name };
        self.o_prot_mut().write_message_begin(&message_ident)?;
        call_args.write_to_out_protocol(self.o_prot_mut())?;
        self.o_prot_mut().write_message_end()?;
        self.o_prot_mut().flush()
      }
    )?;
    {
      let message_ident = self.i_prot_mut().read_message_begin()?;
      verify_expected_sequence_number(self.sequence_number(), message_ident.sequence_number)?;
      verify_expected_service_call("enableTable", &message_ident.name)?;
      if message_ident.message_type == TMessageType::Exception {
        let remote_error = thrift::Error::read_application_error_from_in_protocol(self.i_prot_mut())?;
        self.i_prot_mut().read_message_end()?;
        return Err(thrift::Error::Application(remote_error))
      }
      verify_expected_message_type(TMessageType::Reply, message_ident.message_type)?;
      let result = HbaseEnableTableResult::read_from_in_protocol(self.i_prot_mut())?;
      self.i_prot_mut().read_message_end()?;
      result.ok_or()
    }
  }
  fn disable_table(&mut self, table_name: Bytes) -> thrift::Result<()> {
    (
      {
        self.increment_sequence_number();
        let message_ident = TMessageIdentifier::new("disableTable", TMessageType::Call, self.sequence_number());
        let call_args = HbaseDisableTableArgs { table_name };
        self.o_prot_mut().write_message_begin(&message_ident)?;
        call_args.write_to_out_protocol(self.o_prot_mut())?;
        self.o_prot_mut().write_message_end()?;
        self.o_prot_mut().flush()
      }
    )?;
    {
      let message_ident = self.i_prot_mut().read_message_begin()?;
      verify_expected_sequence_number(self.sequence_number(), message_ident.sequence_number)?;
      verify_expected_service_call("disableTable", &message_ident.name)?;
      if message_ident.message_type == TMessageType::Exception {
        let remote_error = thrift::Error::read_application_error_from_in_protocol(self.i_prot_mut())?;
        self.i_prot_mut().read_message_end()?;
        return Err(thrift::Error::Application(remote_error))
      }
      verify_expected_message_type(TMessageType::Reply, message_ident.message_type)?;
      let result = HbaseDisableTableResult::read_from_in_protocol(self.i_prot_mut())?;
      self.i_prot_mut().read_message_end()?;
      result.ok_or()
    }
  }
  fn is_table_enabled(&mut self, table_name: Bytes) -> thrift::Result<bool> {
    (
      {
        self.increment_sequence_number();
        let message_ident = TMessageIdentifier::new("isTableEnabled", TMessageType::Call, self.sequence_number());
        let call_args = HbaseIsTableEnabledArgs { table_name };
        self.o_prot_mut().write_message_begin(&message_ident)?;
        call_args.write_to_out_protocol(self.o_prot_mut())?;
        self.o_prot_mut().write_message_end()?;
        self.o_prot_mut().flush()
      }
    )?;
    {
      let message_ident = self.i_prot_mut().read_message_begin()?;
      verify_expected_sequence_number(self.sequence_number(), message_ident.sequence_number)?;
      verify_expected_service_call("isTableEnabled", &message_ident.name)?;
      if message_ident.message_type == TMessageType::Exception {
        let remote_error = thrift::Error::read_application_error_from_in_protocol(self.i_prot_mut())?;
        self.i_prot_mut().read_message_end()?;
        return Err(thrift::Error::Application(remote_error))
      }
      verify_expected_message_type(TMessageType::Reply, message_ident.message_type)?;
      let result = HbaseIsTableEnabledResult::read_from_in_protocol(self.i_prot_mut())?;
      self.i_prot_mut().read_message_end()?;
      result.ok_or()
    }
  }
  fn compact(&mut self, table_name_or_region_name: Bytes) -> thrift::Result<()> {
    (
      {
        self.increment_sequence_number();
        let message_ident = TMessageIdentifier::new("compact", TMessageType::Call, self.sequence_number());
        let call_args = HbaseCompactArgs { table_name_or_region_name };
        self.o_prot_mut().write_message_begin(&message_ident)?;
        call_args.write_to_out_protocol(self.o_prot_mut())?;
        self.o_prot_mut().write_message_end()?;
        self.o_prot_mut().flush()
      }
    )?;
    {
      let message_ident = self.i_prot_mut().read_message_begin()?;
      verify_expected_sequence_number(self.sequence_number(), message_ident.sequence_number)?;
      verify_expected_service_call("compact", &message_ident.name)?;
      if message_ident.message_type == TMessageType::Exception {
        let remote_error = thrift::Error::read_application_error_from_in_protocol(self.i_prot_mut())?;
        self.i_prot_mut().read_message_end()?;
        return Err(thrift::Error::Application(remote_error))
      }
      verify_expected_message_type(TMessageType::Reply, message_ident.message_type)?;
      let result = HbaseCompactResult::read_from_in_protocol(self.i_prot_mut())?;
      self.i_prot_mut().read_message_end()?;
      result.ok_or()
    }
  }
  fn major_compact(&mut self, table_name_or_region_name: Bytes) -> thrift::Result<()> {
    (
      {
        self.increment_sequence_number();
        let message_ident = TMessageIdentifier::new("majorCompact", TMessageType::Call, self.sequence_number());
        let call_args = HbaseMajorCompactArgs { table_name_or_region_name };
        self.o_prot_mut().write_message_begin(&message_ident)?;
        call_args.write_to_out_protocol(self.o_prot_mut())?;
        self.o_prot_mut().write_message_end()?;
        self.o_prot_mut().flush()
      }
    )?;
    {
      let message_ident = self.i_prot_mut().read_message_begin()?;
      verify_expected_sequence_number(self.sequence_number(), message_ident.sequence_number)?;
      verify_expected_service_call("majorCompact", &message_ident.name)?;
      if message_ident.message_type == TMessageType::Exception {
        let remote_error = thrift::Error::read_application_error_from_in_protocol(self.i_prot_mut())?;
        self.i_prot_mut().read_message_end()?;
        return Err(thrift::Error::Application(remote_error))
      }
      verify_expected_message_type(TMessageType::Reply, message_ident.message_type)?;
      let result = HbaseMajorCompactResult::read_from_in_protocol(self.i_prot_mut())?;
      self.i_prot_mut().read_message_end()?;
      result.ok_or()
    }
  }
  fn get_table_names(&mut self) -> thrift::Result<Vec<Text>> {
    (
      {
        self.increment_sequence_number();
        let message_ident = TMessageIdentifier::new("getTableNames", TMessageType::Call, self.sequence_number());
        let call_args = HbaseGetTableNamesArgs {  };
        self.o_prot_mut().write_message_begin(&message_ident)?;
        call_args.write_to_out_protocol(self.o_prot_mut())?;
        self.o_prot_mut().write_message_end()?;
        self.o_prot_mut().flush()
      }
    )?;
    {
      let message_ident = self.i_prot_mut().read_message_begin()?;
      verify_expected_sequence_number(self.sequence_number(), message_ident.sequence_number)?;
      verify_expected_service_call("getTableNames", &message_ident.name)?;
      if message_ident.message_type == TMessageType::Exception {
        let remote_error = thrift::Error::read_application_error_from_in_protocol(self.i_prot_mut())?;
        self.i_prot_mut().read_message_end()?;
        return Err(thrift::Error::Application(remote_error))
      }
      verify_expected_message_type(TMessageType::Reply, message_ident.message_type)?;
      let result = HbaseGetTableNamesResult::read_from_in_protocol(self.i_prot_mut())?;
      self.i_prot_mut().read_message_end()?;
      result.ok_or()
    }
  }
  fn get_table_names_with_is_table_enabled(&mut self) -> thrift::Result<BTreeMap<Text, bool>> {
    (
      {
        self.increment_sequence_number();
        let message_ident = TMessageIdentifier::new("getTableNamesWithIsTableEnabled", TMessageType::Call, self.sequence_number());
        let call_args = HbaseGetTableNamesWithIsTableEnabledArgs {  };
        self.o_prot_mut().write_message_begin(&message_ident)?;
        call_args.write_to_out_protocol(self.o_prot_mut())?;
        self.o_prot_mut().write_message_end()?;
        self.o_prot_mut().flush()
      }
    )?;
    {
      let message_ident = self.i_prot_mut().read_message_begin()?;
      verify_expected_sequence_number(self.sequence_number(), message_ident.sequence_number)?;
      verify_expected_service_call("getTableNamesWithIsTableEnabled", &message_ident.name)?;
      if message_ident.message_type == TMessageType::Exception {
        let remote_error = thrift::Error::read_application_error_from_in_protocol(self.i_prot_mut())?;
        self.i_prot_mut().read_message_end()?;
        return Err(thrift::Error::Application(remote_error))
      }
      verify_expected_message_type(TMessageType::Reply, message_ident.message_type)?;
      let result = HbaseGetTableNamesWithIsTableEnabledResult::read_from_in_protocol(self.i_prot_mut())?;
      self.i_prot_mut().read_message_end()?;
      result.ok_or()
    }
  }
  fn get_column_descriptors(&mut self, table_name: Text) -> thrift::Result<BTreeMap<Text, ColumnDescriptor>> {
    (
      {
        self.increment_sequence_number();
        let message_ident = TMessageIdentifier::new("getColumnDescriptors", TMessageType::Call, self.sequence_number());
        let call_args = HbaseGetColumnDescriptorsArgs { table_name };
        self.o_prot_mut().write_message_begin(&message_ident)?;
        call_args.write_to_out_protocol(self.o_prot_mut())?;
        self.o_prot_mut().write_message_end()?;
        self.o_prot_mut().flush()
      }
    )?;
    {
      let message_ident = self.i_prot_mut().read_message_begin()?;
      verify_expected_sequence_number(self.sequence_number(), message_ident.sequence_number)?;
      verify_expected_service_call("getColumnDescriptors", &message_ident.name)?;
      if message_ident.message_type == TMessageType::Exception {
        let remote_error = thrift::Error::read_application_error_from_in_protocol(self.i_prot_mut())?;
        self.i_prot_mut().read_message_end()?;
        return Err(thrift::Error::Application(remote_error))
      }
      verify_expected_message_type(TMessageType::Reply, message_ident.message_type)?;
      let result = HbaseGetColumnDescriptorsResult::read_from_in_protocol(self.i_prot_mut())?;
      self.i_prot_mut().read_message_end()?;
      result.ok_or()
    }
  }
  fn get_table_regions(&mut self, table_name: Text) -> thrift::Result<Vec<TRegionInfo>> {
    (
      {
        self.increment_sequence_number();
        let message_ident = TMessageIdentifier::new("getTableRegions", TMessageType::Call, self.sequence_number());
        let call_args = HbaseGetTableRegionsArgs { table_name };
        self.o_prot_mut().write_message_begin(&message_ident)?;
        call_args.write_to_out_protocol(self.o_prot_mut())?;
        self.o_prot_mut().write_message_end()?;
        self.o_prot_mut().flush()
      }
    )?;
    {
      let message_ident = self.i_prot_mut().read_message_begin()?;
      verify_expected_sequence_number(self.sequence_number(), message_ident.sequence_number)?;
      verify_expected_service_call("getTableRegions", &message_ident.name)?;
      if message_ident.message_type == TMessageType::Exception {
        let remote_error = thrift::Error::read_application_error_from_in_protocol(self.i_prot_mut())?;
        self.i_prot_mut().read_message_end()?;
        return Err(thrift::Error::Application(remote_error))
      }
      verify_expected_message_type(TMessageType::Reply, message_ident.message_type)?;
      let result = HbaseGetTableRegionsResult::read_from_in_protocol(self.i_prot_mut())?;
      self.i_prot_mut().read_message_end()?;
      result.ok_or()
    }
  }
  fn create_table(&mut self, table_name: Text, column_families: Vec<ColumnDescriptor>) -> thrift::Result<()> {
    (
      {
        self.increment_sequence_number();
        let message_ident = TMessageIdentifier::new("createTable", TMessageType::Call, self.sequence_number());
        let call_args = HbaseCreateTableArgs { table_name, column_families };
        self.o_prot_mut().write_message_begin(&message_ident)?;
        call_args.write_to_out_protocol(self.o_prot_mut())?;
        self.o_prot_mut().write_message_end()?;
        self.o_prot_mut().flush()
      }
    )?;
    {
      let message_ident = self.i_prot_mut().read_message_begin()?;
      verify_expected_sequence_number(self.sequence_number(), message_ident.sequence_number)?;
      verify_expected_service_call("createTable", &message_ident.name)?;
      if message_ident.message_type == TMessageType::Exception {
        let remote_error = thrift::Error::read_application_error_from_in_protocol(self.i_prot_mut())?;
        self.i_prot_mut().read_message_end()?;
        return Err(thrift::Error::Application(remote_error))
      }
      verify_expected_message_type(TMessageType::Reply, message_ident.message_type)?;
      let result = HbaseCreateTableResult::read_from_in_protocol(self.i_prot_mut())?;
      self.i_prot_mut().read_message_end()?;
      result.ok_or()
    }
  }
  fn delete_table(&mut self, table_name: Text) -> thrift::Result<()> {
    (
      {
        self.increment_sequence_number();
        let message_ident = TMessageIdentifier::new("deleteTable", TMessageType::Call, self.sequence_number());
        let call_args = HbaseDeleteTableArgs { table_name };
        self.o_prot_mut().write_message_begin(&message_ident)?;
        call_args.write_to_out_protocol(self.o_prot_mut())?;
        self.o_prot_mut().write_message_end()?;
        self.o_prot_mut().flush()
      }
    )?;
    {
      let message_ident = self.i_prot_mut().read_message_begin()?;
      verify_expected_sequence_number(self.sequence_number(), message_ident.sequence_number)?;
      verify_expected_service_call("deleteTable", &message_ident.name)?;
      if message_ident.message_type == TMessageType::Exception {
        let remote_error = thrift::Error::read_application_error_from_in_protocol(self.i_prot_mut())?;
        self.i_prot_mut().read_message_end()?;
        return Err(thrift::Error::Application(remote_error))
      }
      verify_expected_message_type(TMessageType::Reply, message_ident.message_type)?;
      let result = HbaseDeleteTableResult::read_from_in_protocol(self.i_prot_mut())?;
      self.i_prot_mut().read_message_end()?;
      result.ok_or()
    }
  }
  fn get(&mut self, table_name: Text, row: Text, column: Text, attributes: BTreeMap<Text, Text>) -> thrift::Result<Vec<TCell>> {
    (
      {
        self.increment_sequence_number();
        let message_ident = TMessageIdentifier::new("get", TMessageType::Call, self.sequence_number());
        let call_args = HbaseGetArgs { table_name, row, column, attributes };
        self.o_prot_mut().write_message_begin(&message_ident)?;
        call_args.write_to_out_protocol(self.o_prot_mut())?;
        self.o_prot_mut().write_message_end()?;
        self.o_prot_mut().flush()
      }
    )?;
    {
      let message_ident = self.i_prot_mut().read_message_begin()?;
      verify_expected_sequence_number(self.sequence_number(), message_ident.sequence_number)?;
      verify_expected_service_call("get", &message_ident.name)?;
      if message_ident.message_type == TMessageType::Exception {
        let remote_error = thrift::Error::read_application_error_from_in_protocol(self.i_prot_mut())?;
        self.i_prot_mut().read_message_end()?;
        return Err(thrift::Error::Application(remote_error))
      }
      verify_expected_message_type(TMessageType::Reply, message_ident.message_type)?;
      let result = HbaseGetResult::read_from_in_protocol(self.i_prot_mut())?;
      self.i_prot_mut().read_message_end()?;
      result.ok_or()
    }
  }
  fn get_ver(&mut self, table_name: Text, row: Text, column: Text, num_versions: i32, attributes: BTreeMap<Text, Text>) -> thrift::Result<Vec<TCell>> {
    (
      {
        self.increment_sequence_number();
        let message_ident = TMessageIdentifier::new("getVer", TMessageType::Call, self.sequence_number());
        let call_args = HbaseGetVerArgs { table_name, row, column, num_versions, attributes };
        self.o_prot_mut().write_message_begin(&message_ident)?;
        call_args.write_to_out_protocol(self.o_prot_mut())?;
        self.o_prot_mut().write_message_end()?;
        self.o_prot_mut().flush()
      }
    )?;
    {
      let message_ident = self.i_prot_mut().read_message_begin()?;
      verify_expected_sequence_number(self.sequence_number(), message_ident.sequence_number)?;
      verify_expected_service_call("getVer", &message_ident.name)?;
      if message_ident.message_type == TMessageType::Exception {
        let remote_error = thrift::Error::read_application_error_from_in_protocol(self.i_prot_mut())?;
        self.i_prot_mut().read_message_end()?;
        return Err(thrift::Error::Application(remote_error))
      }
      verify_expected_message_type(TMessageType::Reply, message_ident.message_type)?;
      let result = HbaseGetVerResult::read_from_in_protocol(self.i_prot_mut())?;
      self.i_prot_mut().read_message_end()?;
      result.ok_or()
    }
  }
  fn get_ver_ts(&mut self, table_name: Text, row: Text, column: Text, timestamp: i64, num_versions: i32, attributes: BTreeMap<Text, Text>) -> thrift::Result<Vec<TCell>> {
    (
      {
        self.increment_sequence_number();
        let message_ident = TMessageIdentifier::new("getVerTs", TMessageType::Call, self.sequence_number());
        let call_args = HbaseGetVerTsArgs { table_name, row, column, timestamp, num_versions, attributes };
        self.o_prot_mut().write_message_begin(&message_ident)?;
        call_args.write_to_out_protocol(self.o_prot_mut())?;
        self.o_prot_mut().write_message_end()?;
        self.o_prot_mut().flush()
      }
    )?;
    {
      let message_ident = self.i_prot_mut().read_message_begin()?;
      verify_expected_sequence_number(self.sequence_number(), message_ident.sequence_number)?;
      verify_expected_service_call("getVerTs", &message_ident.name)?;
      if message_ident.message_type == TMessageType::Exception {
        let remote_error = thrift::Error::read_application_error_from_in_protocol(self.i_prot_mut())?;
        self.i_prot_mut().read_message_end()?;
        return Err(thrift::Error::Application(remote_error))
      }
      verify_expected_message_type(TMessageType::Reply, message_ident.message_type)?;
      let result = HbaseGetVerTsResult::read_from_in_protocol(self.i_prot_mut())?;
      self.i_prot_mut().read_message_end()?;
      result.ok_or()
    }
  }
  fn get_row(&mut self, table_name: Text, row: Text, attributes: BTreeMap<Text, Text>) -> thrift::Result<Vec<TRowResult>> {
    (
      {
        self.increment_sequence_number();
        let message_ident = TMessageIdentifier::new("getRow", TMessageType::Call, self.sequence_number());
        let call_args = HbaseGetRowArgs { table_name, row, attributes };
        self.o_prot_mut().write_message_begin(&message_ident)?;
        call_args.write_to_out_protocol(self.o_prot_mut())?;
        self.o_prot_mut().write_message_end()?;
        self.o_prot_mut().flush()
      }
    )?;
    {
      let message_ident = self.i_prot_mut().read_message_begin()?;
      verify_expected_sequence_number(self.sequence_number(), message_ident.sequence_number)?;
      verify_expected_service_call("getRow", &message_ident.name)?;
      if message_ident.message_type == TMessageType::Exception {
        let remote_error = thrift::Error::read_application_error_from_in_protocol(self.i_prot_mut())?;
        self.i_prot_mut().read_message_end()?;
        return Err(thrift::Error::Application(remote_error))
      }
      verify_expected_message_type(TMessageType::Reply, message_ident.message_type)?;
      let result = HbaseGetRowResult::read_from_in_protocol(self.i_prot_mut())?;
      self.i_prot_mut().read_message_end()?;
      result.ok_or()
    }
  }
  fn get_row_with_columns(&mut self, table_name: Text, row: Text, columns: Vec<Text>, attributes: BTreeMap<Text, Text>) -> thrift::Result<Vec<TRowResult>> {
    (
      {
        self.increment_sequence_number();
        let message_ident = TMessageIdentifier::new("getRowWithColumns", TMessageType::Call, self.sequence_number());
        let call_args = HbaseGetRowWithColumnsArgs { table_name, row, columns, attributes };
        self.o_prot_mut().write_message_begin(&message_ident)?;
        call_args.write_to_out_protocol(self.o_prot_mut())?;
        self.o_prot_mut().write_message_end()?;
        self.o_prot_mut().flush()
      }
    )?;
    {
      let message_ident = self.i_prot_mut().read_message_begin()?;
      verify_expected_sequence_number(self.sequence_number(), message_ident.sequence_number)?;
      verify_expected_service_call("getRowWithColumns", &message_ident.name)?;
      if message_ident.message_type == TMessageType::Exception {
        let remote_error = thrift::Error::read_application_error_from_in_protocol(self.i_prot_mut())?;
        self.i_prot_mut().read_message_end()?;
        return Err(thrift::Error::Application(remote_error))
      }
      verify_expected_message_type(TMessageType::Reply, message_ident.message_type)?;
      let result = HbaseGetRowWithColumnsResult::read_from_in_protocol(self.i_prot_mut())?;
      self.i_prot_mut().read_message_end()?;
      result.ok_or()
    }
  }
  fn get_row_ts(&mut self, table_name: Text, row: Text, timestamp: i64, attributes: BTreeMap<Text, Text>) -> thrift::Result<Vec<TRowResult>> {
    (
      {
        self.increment_sequence_number();
        let message_ident = TMessageIdentifier::new("getRowTs", TMessageType::Call, self.sequence_number());
        let call_args = HbaseGetRowTsArgs { table_name, row, timestamp, attributes };
        self.o_prot_mut().write_message_begin(&message_ident)?;
        call_args.write_to_out_protocol(self.o_prot_mut())?;
        self.o_prot_mut().write_message_end()?;
        self.o_prot_mut().flush()
      }
    )?;
    {
      let message_ident = self.i_prot_mut().read_message_begin()?;
      verify_expected_sequence_number(self.sequence_number(), message_ident.sequence_number)?;
      verify_expected_service_call("getRowTs", &message_ident.name)?;
      if message_ident.message_type == TMessageType::Exception {
        let remote_error = thrift::Error::read_application_error_from_in_protocol(self.i_prot_mut())?;
        self.i_prot_mut().read_message_end()?;
        return Err(thrift::Error::Application(remote_error))
      }
      verify_expected_message_type(TMessageType::Reply, message_ident.message_type)?;
      let result = HbaseGetRowTsResult::read_from_in_protocol(self.i_prot_mut())?;
      self.i_prot_mut().read_message_end()?;
      result.ok_or()
    }
  }
  fn get_row_with_columns_ts(&mut self, table_name: Text, row: Text, columns: Vec<Text>, timestamp: i64, attributes: BTreeMap<Text, Text>) -> thrift::Result<Vec<TRowResult>> {
    (
      {
        self.increment_sequence_number();
        let message_ident = TMessageIdentifier::new("getRowWithColumnsTs", TMessageType::Call, self.sequence_number());
        let call_args = HbaseGetRowWithColumnsTsArgs { table_name, row, columns, timestamp, attributes };
        self.o_prot_mut().write_message_begin(&message_ident)?;
        call_args.write_to_out_protocol(self.o_prot_mut())?;
        self.o_prot_mut().write_message_end()?;
        self.o_prot_mut().flush()
      }
    )?;
    {
      let message_ident = self.i_prot_mut().read_message_begin()?;
      verify_expected_sequence_number(self.sequence_number(), message_ident.sequence_number)?;
      verify_expected_service_call("getRowWithColumnsTs", &message_ident.name)?;
      if message_ident.message_type == TMessageType::Exception {
        let remote_error = thrift::Error::read_application_error_from_in_protocol(self.i_prot_mut())?;
        self.i_prot_mut().read_message_end()?;
        return Err(thrift::Error::Application(remote_error))
      }
      verify_expected_message_type(TMessageType::Reply, message_ident.message_type)?;
      let result = HbaseGetRowWithColumnsTsResult::read_from_in_protocol(self.i_prot_mut())?;
      self.i_prot_mut().read_message_end()?;
      result.ok_or()
    }
  }
  fn get_rows(&mut self, table_name: Text, rows: Vec<Text>, attributes: BTreeMap<Text, Text>) -> thrift::Result<Vec<TRowResult>> {
    (
      {
        self.increment_sequence_number();
        let message_ident = TMessageIdentifier::new("getRows", TMessageType::Call, self.sequence_number());
        let call_args = HbaseGetRowsArgs { table_name, rows, attributes };
        self.o_prot_mut().write_message_begin(&message_ident)?;
        call_args.write_to_out_protocol(self.o_prot_mut())?;
        self.o_prot_mut().write_message_end()?;
        self.o_prot_mut().flush()
      }
    )?;
    {
      let message_ident = self.i_prot_mut().read_message_begin()?;
      verify_expected_sequence_number(self.sequence_number(), message_ident.sequence_number)?;
      verify_expected_service_call("getRows", &message_ident.name)?;
      if message_ident.message_type == TMessageType::Exception {
        let remote_error = thrift::Error::read_application_error_from_in_protocol(self.i_prot_mut())?;
        self.i_prot_mut().read_message_end()?;
        return Err(thrift::Error::Application(remote_error))
      }
      verify_expected_message_type(TMessageType::Reply, message_ident.message_type)?;
      let result = HbaseGetRowsResult::read_from_in_protocol(self.i_prot_mut())?;
      self.i_prot_mut().read_message_end()?;
      result.ok_or()
    }
  }
  fn get_rows_with_columns(&mut self, table_name: Text, rows: Vec<Text>, columns: Vec<Text>, attributes: BTreeMap<Text, Text>) -> thrift::Result<Vec<TRowResult>> {
    (
      {
        self.increment_sequence_number();
        let message_ident = TMessageIdentifier::new("getRowsWithColumns", TMessageType::Call, self.sequence_number());
        let call_args = HbaseGetRowsWithColumnsArgs { table_name, rows, columns, attributes };
        self.o_prot_mut().write_message_begin(&message_ident)?;
        call_args.write_to_out_protocol(self.o_prot_mut())?;
        self.o_prot_mut().write_message_end()?;
        self.o_prot_mut().flush()
      }
    )?;
    {
      let message_ident = self.i_prot_mut().read_message_begin()?;
      verify_expected_sequence_number(self.sequence_number(), message_ident.sequence_number)?;
      verify_expected_service_call("getRowsWithColumns", &message_ident.name)?;
      if message_ident.message_type == TMessageType::Exception {
        let remote_error = thrift::Error::read_application_error_from_in_protocol(self.i_prot_mut())?;
        self.i_prot_mut().read_message_end()?;
        return Err(thrift::Error::Application(remote_error))
      }
      verify_expected_message_type(TMessageType::Reply, message_ident.message_type)?;
      let result = HbaseGetRowsWithColumnsResult::read_from_in_protocol(self.i_prot_mut())?;
      self.i_prot_mut().read_message_end()?;
      result.ok_or()
    }
  }
  fn get_rows_ts(&mut self, table_name: Text, rows: Vec<Text>, timestamp: i64, attributes: BTreeMap<Text, Text>) -> thrift::Result<Vec<TRowResult>> {
    (
      {
        self.increment_sequence_number();
        let message_ident = TMessageIdentifier::new("getRowsTs", TMessageType::Call, self.sequence_number());
        let call_args = HbaseGetRowsTsArgs { table_name, rows, timestamp, attributes };
        self.o_prot_mut().write_message_begin(&message_ident)?;
        call_args.write_to_out_protocol(self.o_prot_mut())?;
        self.o_prot_mut().write_message_end()?;
        self.o_prot_mut().flush()
      }
    )?;
    {
      let message_ident = self.i_prot_mut().read_message_begin()?;
      verify_expected_sequence_number(self.sequence_number(), message_ident.sequence_number)?;
      verify_expected_service_call("getRowsTs", &message_ident.name)?;
      if message_ident.message_type == TMessageType::Exception {
        let remote_error = thrift::Error::read_application_error_from_in_protocol(self.i_prot_mut())?;
        self.i_prot_mut().read_message_end()?;
        return Err(thrift::Error::Application(remote_error))
      }
      verify_expected_message_type(TMessageType::Reply, message_ident.message_type)?;
      let result = HbaseGetRowsTsResult::read_from_in_protocol(self.i_prot_mut())?;
      self.i_prot_mut().read_message_end()?;
      result.ok_or()
    }
  }
  fn get_rows_with_columns_ts(&mut self, table_name: Text, rows: Vec<Text>, columns: Vec<Text>, timestamp: i64, attributes: BTreeMap<Text, Text>) -> thrift::Result<Vec<TRowResult>> {
    (
      {
        self.increment_sequence_number();
        let message_ident = TMessageIdentifier::new("getRowsWithColumnsTs", TMessageType::Call, self.sequence_number());
        let call_args = HbaseGetRowsWithColumnsTsArgs { table_name, rows, columns, timestamp, attributes };
        self.o_prot_mut().write_message_begin(&message_ident)?;
        call_args.write_to_out_protocol(self.o_prot_mut())?;
        self.o_prot_mut().write_message_end()?;
        self.o_prot_mut().flush()
      }
    )?;
    {
      let message_ident = self.i_prot_mut().read_message_begin()?;
      verify_expected_sequence_number(self.sequence_number(), message_ident.sequence_number)?;
      verify_expected_service_call("getRowsWithColumnsTs", &message_ident.name)?;
      if message_ident.message_type == TMessageType::Exception {
        let remote_error = thrift::Error::read_application_error_from_in_protocol(self.i_prot_mut())?;
        self.i_prot_mut().read_message_end()?;
        return Err(thrift::Error::Application(remote_error))
      }
      verify_expected_message_type(TMessageType::Reply, message_ident.message_type)?;
      let result = HbaseGetRowsWithColumnsTsResult::read_from_in_protocol(self.i_prot_mut())?;
      self.i_prot_mut().read_message_end()?;
      result.ok_or()
    }
  }
  fn mutate_row(&mut self, table_name: Text, row: Text, mutations: Vec<Mutation>, attributes: BTreeMap<Text, Text>) -> thrift::Result<()> {
    (
      {
        self.increment_sequence_number();
        let message_ident = TMessageIdentifier::new("mutateRow", TMessageType::Call, self.sequence_number());
        let call_args = HbaseMutateRowArgs { table_name, row, mutations, attributes };
        self.o_prot_mut().write_message_begin(&message_ident)?;
        call_args.write_to_out_protocol(self.o_prot_mut())?;
        self.o_prot_mut().write_message_end()?;
        self.o_prot_mut().flush()
      }
    )?;
    {
      let message_ident = self.i_prot_mut().read_message_begin()?;
      verify_expected_sequence_number(self.sequence_number(), message_ident.sequence_number)?;
      verify_expected_service_call("mutateRow", &message_ident.name)?;
      if message_ident.message_type == TMessageType::Exception {
        let remote_error = thrift::Error::read_application_error_from_in_protocol(self.i_prot_mut())?;
        self.i_prot_mut().read_message_end()?;
        return Err(thrift::Error::Application(remote_error))
      }
      verify_expected_message_type(TMessageType::Reply, message_ident.message_type)?;
      let result = HbaseMutateRowResult::read_from_in_protocol(self.i_prot_mut())?;
      self.i_prot_mut().read_message_end()?;
      result.ok_or()
    }
  }
  fn mutate_row_ts(&mut self, table_name: Text, row: Text, mutations: Vec<Mutation>, timestamp: i64, attributes: BTreeMap<Text, Text>) -> thrift::Result<()> {
    (
      {
        self.increment_sequence_number();
        let message_ident = TMessageIdentifier::new("mutateRowTs", TMessageType::Call, self.sequence_number());
        let call_args = HbaseMutateRowTsArgs { table_name, row, mutations, timestamp, attributes };
        self.o_prot_mut().write_message_begin(&message_ident)?;
        call_args.write_to_out_protocol(self.o_prot_mut())?;
        self.o_prot_mut().write_message_end()?;
        self.o_prot_mut().flush()
      }
    )?;
    {
      let message_ident = self.i_prot_mut().read_message_begin()?;
      verify_expected_sequence_number(self.sequence_number(), message_ident.sequence_number)?;
      verify_expected_service_call("mutateRowTs", &message_ident.name)?;
      if message_ident.message_type == TMessageType::Exception {
        let remote_error = thrift::Error::read_application_error_from_in_protocol(self.i_prot_mut())?;
        self.i_prot_mut().read_message_end()?;
        return Err(thrift::Error::Application(remote_error))
      }
      verify_expected_message_type(TMessageType::Reply, message_ident.message_type)?;
      let result = HbaseMutateRowTsResult::read_from_in_protocol(self.i_prot_mut())?;
      self.i_prot_mut().read_message_end()?;
      result.ok_or()
    }
  }
  fn mutate_rows(&mut self, table_name: Text, row_batches: Vec<BatchMutation>, attributes: BTreeMap<Text, Text>) -> thrift::Result<()> {
    (
      {
        self.increment_sequence_number();
        let message_ident = TMessageIdentifier::new("mutateRows", TMessageType::Call, self.sequence_number());
        let call_args = HbaseMutateRowsArgs { table_name, row_batches, attributes };
        self.o_prot_mut().write_message_begin(&message_ident)?;
        call_args.write_to_out_protocol(self.o_prot_mut())?;
        self.o_prot_mut().write_message_end()?;
        self.o_prot_mut().flush()
      }
    )?;
    {
      let message_ident = self.i_prot_mut().read_message_begin()?;
      verify_expected_sequence_number(self.sequence_number(), message_ident.sequence_number)?;
      verify_expected_service_call("mutateRows", &message_ident.name)?;
      if message_ident.message_type == TMessageType::Exception {
        let remote_error = thrift::Error::read_application_error_from_in_protocol(self.i_prot_mut())?;
        self.i_prot_mut().read_message_end()?;
        return Err(thrift::Error::Application(remote_error))
      }
      verify_expected_message_type(TMessageType::Reply, message_ident.message_type)?;
      let result = HbaseMutateRowsResult::read_from_in_protocol(self.i_prot_mut())?;
      self.i_prot_mut().read_message_end()?;
      result.ok_or()
    }
  }
  fn mutate_rows_ts(&mut self, table_name: Text, row_batches: Vec<BatchMutation>, timestamp: i64, attributes: BTreeMap<Text, Text>) -> thrift::Result<()> {
    (
      {
        self.increment_sequence_number();
        let message_ident = TMessageIdentifier::new("mutateRowsTs", TMessageType::Call, self.sequence_number());
        let call_args = HbaseMutateRowsTsArgs { table_name, row_batches, timestamp, attributes };
        self.o_prot_mut().write_message_begin(&message_ident)?;
        call_args.write_to_out_protocol(self.o_prot_mut())?;
        self.o_prot_mut().write_message_end()?;
        self.o_prot_mut().flush()
      }
    )?;
    {
      let message_ident = self.i_prot_mut().read_message_begin()?;
      verify_expected_sequence_number(self.sequence_number(), message_ident.sequence_number)?;
      verify_expected_service_call("mutateRowsTs", &message_ident.name)?;
      if message_ident.message_type == TMessageType::Exception {
        let remote_error = thrift::Error::read_application_error_from_in_protocol(self.i_prot_mut())?;
        self.i_prot_mut().read_message_end()?;
        return Err(thrift::Error::Application(remote_error))
      }
      verify_expected_message_type(TMessageType::Reply, message_ident.message_type)?;
      let result = HbaseMutateRowsTsResult::read_from_in_protocol(self.i_prot_mut())?;
      self.i_prot_mut().read_message_end()?;
      result.ok_or()
    }
  }
  fn atomic_increment(&mut self, table_name: Text, row: Text, column: Text, value: i64) -> thrift::Result<i64> {
    (
      {
        self.increment_sequence_number();
        let message_ident = TMessageIdentifier::new("atomicIncrement", TMessageType::Call, self.sequence_number());
        let call_args = HbaseAtomicIncrementArgs { table_name, row, column, value };
        self.o_prot_mut().write_message_begin(&message_ident)?;
        call_args.write_to_out_protocol(self.o_prot_mut())?;
        self.o_prot_mut().write_message_end()?;
        self.o_prot_mut().flush()
      }
    )?;
    {
      let message_ident = self.i_prot_mut().read_message_begin()?;
      verify_expected_sequence_number(self.sequence_number(), message_ident.sequence_number)?;
      verify_expected_service_call("atomicIncrement", &message_ident.name)?;
      if message_ident.message_type == TMessageType::Exception {
        let remote_error = thrift::Error::read_application_error_from_in_protocol(self.i_prot_mut())?;
        self.i_prot_mut().read_message_end()?;
        return Err(thrift::Error::Application(remote_error))
      }
      verify_expected_message_type(TMessageType::Reply, message_ident.message_type)?;
      let result = HbaseAtomicIncrementResult::read_from_in_protocol(self.i_prot_mut())?;
      self.i_prot_mut().read_message_end()?;
      result.ok_or()
    }
  }
  fn delete_all(&mut self, table_name: Text, row: Text, column: Text, attributes: BTreeMap<Text, Text>) -> thrift::Result<()> {
    (
      {
        self.increment_sequence_number();
        let message_ident = TMessageIdentifier::new("deleteAll", TMessageType::Call, self.sequence_number());
        let call_args = HbaseDeleteAllArgs { table_name, row, column, attributes };
        self.o_prot_mut().write_message_begin(&message_ident)?;
        call_args.write_to_out_protocol(self.o_prot_mut())?;
        self.o_prot_mut().write_message_end()?;
        self.o_prot_mut().flush()
      }
    )?;
    {
      let message_ident = self.i_prot_mut().read_message_begin()?;
      verify_expected_sequence_number(self.sequence_number(), message_ident.sequence_number)?;
      verify_expected_service_call("deleteAll", &message_ident.name)?;
      if message_ident.message_type == TMessageType::Exception {
        let remote_error = thrift::Error::read_application_error_from_in_protocol(self.i_prot_mut())?;
        self.i_prot_mut().read_message_end()?;
        return Err(thrift::Error::Application(remote_error))
      }
      verify_expected_message_type(TMessageType::Reply, message_ident.message_type)?;
      let result = HbaseDeleteAllResult::read_from_in_protocol(self.i_prot_mut())?;
      self.i_prot_mut().read_message_end()?;
      result.ok_or()
    }
  }
  fn delete_all_ts(&mut self, table_name: Text, row: Text, column: Text, timestamp: i64, attributes: BTreeMap<Text, Text>) -> thrift::Result<()> {
    (
      {
        self.increment_sequence_number();
        let message_ident = TMessageIdentifier::new("deleteAllTs", TMessageType::Call, self.sequence_number());
        let call_args = HbaseDeleteAllTsArgs { table_name, row, column, timestamp, attributes };
        self.o_prot_mut().write_message_begin(&message_ident)?;
        call_args.write_to_out_protocol(self.o_prot_mut())?;
        self.o_prot_mut().write_message_end()?;
        self.o_prot_mut().flush()
      }
    )?;
    {
      let message_ident = self.i_prot_mut().read_message_begin()?;
      verify_expected_sequence_number(self.sequence_number(), message_ident.sequence_number)?;
      verify_expected_service_call("deleteAllTs", &message_ident.name)?;
      if message_ident.message_type == TMessageType::Exception {
        let remote_error = thrift::Error::read_application_error_from_in_protocol(self.i_prot_mut())?;
        self.i_prot_mut().read_message_end()?;
        return Err(thrift::Error::Application(remote_error))
      }
      verify_expected_message_type(TMessageType::Reply, message_ident.message_type)?;
      let result = HbaseDeleteAllTsResult::read_from_in_protocol(self.i_prot_mut())?;
      self.i_prot_mut().read_message_end()?;
      result.ok_or()
    }
  }
  fn delete_all_row(&mut self, table_name: Text, row: Text, attributes: BTreeMap<Text, Text>) -> thrift::Result<()> {
    (
      {
        self.increment_sequence_number();
        let message_ident = TMessageIdentifier::new("deleteAllRow", TMessageType::Call, self.sequence_number());
        let call_args = HbaseDeleteAllRowArgs { table_name, row, attributes };
        self.o_prot_mut().write_message_begin(&message_ident)?;
        call_args.write_to_out_protocol(self.o_prot_mut())?;
        self.o_prot_mut().write_message_end()?;
        self.o_prot_mut().flush()
      }
    )?;
    {
      let message_ident = self.i_prot_mut().read_message_begin()?;
      verify_expected_sequence_number(self.sequence_number(), message_ident.sequence_number)?;
      verify_expected_service_call("deleteAllRow", &message_ident.name)?;
      if message_ident.message_type == TMessageType::Exception {
        let remote_error = thrift::Error::read_application_error_from_in_protocol(self.i_prot_mut())?;
        self.i_prot_mut().read_message_end()?;
        return Err(thrift::Error::Application(remote_error))
      }
      verify_expected_message_type(TMessageType::Reply, message_ident.message_type)?;
      let result = HbaseDeleteAllRowResult::read_from_in_protocol(self.i_prot_mut())?;
      self.i_prot_mut().read_message_end()?;
      result.ok_or()
    }
  }
  fn increment(&mut self, increment: TIncrement) -> thrift::Result<()> {
    (
      {
        self.increment_sequence_number();
        let message_ident = TMessageIdentifier::new("increment", TMessageType::Call, self.sequence_number());
        let call_args = HbaseIncrementArgs { increment };
        self.o_prot_mut().write_message_begin(&message_ident)?;
        call_args.write_to_out_protocol(self.o_prot_mut())?;
        self.o_prot_mut().write_message_end()?;
        self.o_prot_mut().flush()
      }
    )?;
    {
      let message_ident = self.i_prot_mut().read_message_begin()?;
      verify_expected_sequence_number(self.sequence_number(), message_ident.sequence_number)?;
      verify_expected_service_call("increment", &message_ident.name)?;
      if message_ident.message_type == TMessageType::Exception {
        let remote_error = thrift::Error::read_application_error_from_in_protocol(self.i_prot_mut())?;
        self.i_prot_mut().read_message_end()?;
        return Err(thrift::Error::Application(remote_error))
      }
      verify_expected_message_type(TMessageType::Reply, message_ident.message_type)?;
      let result = HbaseIncrementResult::read_from_in_protocol(self.i_prot_mut())?;
      self.i_prot_mut().read_message_end()?;
      result.ok_or()
    }
  }
  fn increment_rows(&mut self, increments: Vec<TIncrement>) -> thrift::Result<()> {
    (
      {
        self.increment_sequence_number();
        let message_ident = TMessageIdentifier::new("incrementRows", TMessageType::Call, self.sequence_number());
        let call_args = HbaseIncrementRowsArgs { increments };
        self.o_prot_mut().write_message_begin(&message_ident)?;
        call_args.write_to_out_protocol(self.o_prot_mut())?;
        self.o_prot_mut().write_message_end()?;
        self.o_prot_mut().flush()
      }
    )?;
    {
      let message_ident = self.i_prot_mut().read_message_begin()?;
      verify_expected_sequence_number(self.sequence_number(), message_ident.sequence_number)?;
      verify_expected_service_call("incrementRows", &message_ident.name)?;
      if message_ident.message_type == TMessageType::Exception {
        let remote_error = thrift::Error::read_application_error_from_in_protocol(self.i_prot_mut())?;
        self.i_prot_mut().read_message_end()?;
        return Err(thrift::Error::Application(remote_error))
      }
      verify_expected_message_type(TMessageType::Reply, message_ident.message_type)?;
      let result = HbaseIncrementRowsResult::read_from_in_protocol(self.i_prot_mut())?;
      self.i_prot_mut().read_message_end()?;
      result.ok_or()
    }
  }
  fn delete_all_row_ts(&mut self, table_name: Text, row: Text, timestamp: i64, attributes: BTreeMap<Text, Text>) -> thrift::Result<()> {
    (
      {
        self.increment_sequence_number();
        let message_ident = TMessageIdentifier::new("deleteAllRowTs", TMessageType::Call, self.sequence_number());
        let call_args = HbaseDeleteAllRowTsArgs { table_name, row, timestamp, attributes };
        self.o_prot_mut().write_message_begin(&message_ident)?;
        call_args.write_to_out_protocol(self.o_prot_mut())?;
        self.o_prot_mut().write_message_end()?;
        self.o_prot_mut().flush()
      }
    )?;
    {
      let message_ident = self.i_prot_mut().read_message_begin()?;
      verify_expected_sequence_number(self.sequence_number(), message_ident.sequence_number)?;
      verify_expected_service_call("deleteAllRowTs", &message_ident.name)?;
      if message_ident.message_type == TMessageType::Exception {
        let remote_error = thrift::Error::read_application_error_from_in_protocol(self.i_prot_mut())?;
        self.i_prot_mut().read_message_end()?;
        return Err(thrift::Error::Application(remote_error))
      }
      verify_expected_message_type(TMessageType::Reply, message_ident.message_type)?;
      let result = HbaseDeleteAllRowTsResult::read_from_in_protocol(self.i_prot_mut())?;
      self.i_prot_mut().read_message_end()?;
      result.ok_or()
    }
  }
  fn scanner_open_with_scan(&mut self, table_name: Text, scan: TScan, attributes: BTreeMap<Text, Text>) -> thrift::Result<ScannerID> {
    (
      {
        self.increment_sequence_number();
        let message_ident = TMessageIdentifier::new("scannerOpenWithScan", TMessageType::Call, self.sequence_number());
        let call_args = HbaseScannerOpenWithScanArgs { table_name, scan, attributes };
        self.o_prot_mut().write_message_begin(&message_ident)?;
        call_args.write_to_out_protocol(self.o_prot_mut())?;
        self.o_prot_mut().write_message_end()?;
        self.o_prot_mut().flush()
      }
    )?;
    {
      let message_ident = self.i_prot_mut().read_message_begin()?;
      verify_expected_sequence_number(self.sequence_number(), message_ident.sequence_number)?;
      verify_expected_service_call("scannerOpenWithScan", &message_ident.name)?;
      if message_ident.message_type == TMessageType::Exception {
        let remote_error = thrift::Error::read_application_error_from_in_protocol(self.i_prot_mut())?;
        self.i_prot_mut().read_message_end()?;
        return Err(thrift::Error::Application(remote_error))
      }
      verify_expected_message_type(TMessageType::Reply, message_ident.message_type)?;
      let result = HbaseScannerOpenWithScanResult::read_from_in_protocol(self.i_prot_mut())?;
      self.i_prot_mut().read_message_end()?;
      result.ok_or()
    }
  }
  fn scanner_open(&mut self, table_name: Text, start_row: Text, columns: Vec<Text>, attributes: BTreeMap<Text, Text>) -> thrift::Result<ScannerID> {
    (
      {
        self.increment_sequence_number();
        let message_ident = TMessageIdentifier::new("scannerOpen", TMessageType::Call, self.sequence_number());
        let call_args = HbaseScannerOpenArgs { table_name, start_row, columns, attributes };
        self.o_prot_mut().write_message_begin(&message_ident)?;
        call_args.write_to_out_protocol(self.o_prot_mut())?;
        self.o_prot_mut().write_message_end()?;
        self.o_prot_mut().flush()
      }
    )?;
    {
      let message_ident = self.i_prot_mut().read_message_begin()?;
      verify_expected_sequence_number(self.sequence_number(), message_ident.sequence_number)?;
      verify_expected_service_call("scannerOpen", &message_ident.name)?;
      if message_ident.message_type == TMessageType::Exception {
        let remote_error = thrift::Error::read_application_error_from_in_protocol(self.i_prot_mut())?;
        self.i_prot_mut().read_message_end()?;
        return Err(thrift::Error::Application(remote_error))
      }
      verify_expected_message_type(TMessageType::Reply, message_ident.message_type)?;
      let result = HbaseScannerOpenResult::read_from_in_protocol(self.i_prot_mut())?;
      self.i_prot_mut().read_message_end()?;
      result.ok_or()
    }
  }
  fn scanner_open_with_stop(&mut self, table_name: Text, start_row: Text, stop_row: Text, columns: Vec<Text>, attributes: BTreeMap<Text, Text>) -> thrift::Result<ScannerID> {
    (
      {
        self.increment_sequence_number();
        let message_ident = TMessageIdentifier::new("scannerOpenWithStop", TMessageType::Call, self.sequence_number());
        let call_args = HbaseScannerOpenWithStopArgs { table_name, start_row, stop_row, columns, attributes };
        self.o_prot_mut().write_message_begin(&message_ident)?;
        call_args.write_to_out_protocol(self.o_prot_mut())?;
        self.o_prot_mut().write_message_end()?;
        self.o_prot_mut().flush()
      }
    )?;
    {
      let message_ident = self.i_prot_mut().read_message_begin()?;
      verify_expected_sequence_number(self.sequence_number(), message_ident.sequence_number)?;
      verify_expected_service_call("scannerOpenWithStop", &message_ident.name)?;
      if message_ident.message_type == TMessageType::Exception {
        let remote_error = thrift::Error::read_application_error_from_in_protocol(self.i_prot_mut())?;
        self.i_prot_mut().read_message_end()?;
        return Err(thrift::Error::Application(remote_error))
      }
      verify_expected_message_type(TMessageType::Reply, message_ident.message_type)?;
      let result = HbaseScannerOpenWithStopResult::read_from_in_protocol(self.i_prot_mut())?;
      self.i_prot_mut().read_message_end()?;
      result.ok_or()
    }
  }
  fn scanner_open_with_prefix(&mut self, table_name: Text, start_and_prefix: Text, columns: Vec<Text>, attributes: BTreeMap<Text, Text>) -> thrift::Result<ScannerID> {
    (
      {
        self.increment_sequence_number();
        let message_ident = TMessageIdentifier::new("scannerOpenWithPrefix", TMessageType::Call, self.sequence_number());
        let call_args = HbaseScannerOpenWithPrefixArgs { table_name, start_and_prefix, columns, attributes };
        self.o_prot_mut().write_message_begin(&message_ident)?;
        call_args.write_to_out_protocol(self.o_prot_mut())?;
        self.o_prot_mut().write_message_end()?;
        self.o_prot_mut().flush()
      }
    )?;
    {
      let message_ident = self.i_prot_mut().read_message_begin()?;
      verify_expected_sequence_number(self.sequence_number(), message_ident.sequence_number)?;
      verify_expected_service_call("scannerOpenWithPrefix", &message_ident.name)?;
      if message_ident.message_type == TMessageType::Exception {
        let remote_error = thrift::Error::read_application_error_from_in_protocol(self.i_prot_mut())?;
        self.i_prot_mut().read_message_end()?;
        return Err(thrift::Error::Application(remote_error))
      }
      verify_expected_message_type(TMessageType::Reply, message_ident.message_type)?;
      let result = HbaseScannerOpenWithPrefixResult::read_from_in_protocol(self.i_prot_mut())?;
      self.i_prot_mut().read_message_end()?;
      result.ok_or()
    }
  }
  fn scanner_open_ts(&mut self, table_name: Text, start_row: Text, columns: Vec<Text>, timestamp: i64, attributes: BTreeMap<Text, Text>) -> thrift::Result<ScannerID> {
    (
      {
        self.increment_sequence_number();
        let message_ident = TMessageIdentifier::new("scannerOpenTs", TMessageType::Call, self.sequence_number());
        let call_args = HbaseScannerOpenTsArgs { table_name, start_row, columns, timestamp, attributes };
        self.o_prot_mut().write_message_begin(&message_ident)?;
        call_args.write_to_out_protocol(self.o_prot_mut())?;
        self.o_prot_mut().write_message_end()?;
        self.o_prot_mut().flush()
      }
    )?;
    {
      let message_ident = self.i_prot_mut().read_message_begin()?;
      verify_expected_sequence_number(self.sequence_number(), message_ident.sequence_number)?;
      verify_expected_service_call("scannerOpenTs", &message_ident.name)?;
      if message_ident.message_type == TMessageType::Exception {
        let remote_error = thrift::Error::read_application_error_from_in_protocol(self.i_prot_mut())?;
        self.i_prot_mut().read_message_end()?;
        return Err(thrift::Error::Application(remote_error))
      }
      verify_expected_message_type(TMessageType::Reply, message_ident.message_type)?;
      let result = HbaseScannerOpenTsResult::read_from_in_protocol(self.i_prot_mut())?;
      self.i_prot_mut().read_message_end()?;
      result.ok_or()
    }
  }
  fn scanner_open_with_stop_ts(&mut self, table_name: Text, start_row: Text, stop_row: Text, columns: Vec<Text>, timestamp: i64, attributes: BTreeMap<Text, Text>) -> thrift::Result<ScannerID> {
    (
      {
        self.increment_sequence_number();
        let message_ident = TMessageIdentifier::new("scannerOpenWithStopTs", TMessageType::Call, self.sequence_number());
        let call_args = HbaseScannerOpenWithStopTsArgs { table_name, start_row, stop_row, columns, timestamp, attributes };
        self.o_prot_mut().write_message_begin(&message_ident)?;
        call_args.write_to_out_protocol(self.o_prot_mut())?;
        self.o_prot_mut().write_message_end()?;
        self.o_prot_mut().flush()
      }
    )?;
    {
      let message_ident = self.i_prot_mut().read_message_begin()?;
      verify_expected_sequence_number(self.sequence_number(), message_ident.sequence_number)?;
      verify_expected_service_call("scannerOpenWithStopTs", &message_ident.name)?;
      if message_ident.message_type == TMessageType::Exception {
        let remote_error = thrift::Error::read_application_error_from_in_protocol(self.i_prot_mut())?;
        self.i_prot_mut().read_message_end()?;
        return Err(thrift::Error::Application(remote_error))
      }
      verify_expected_message_type(TMessageType::Reply, message_ident.message_type)?;
      let result = HbaseScannerOpenWithStopTsResult::read_from_in_protocol(self.i_prot_mut())?;
      self.i_prot_mut().read_message_end()?;
      result.ok_or()
    }
  }
  fn scanner_get(&mut self, id: ScannerID) -> thrift::Result<Vec<TRowResult>> {
    (
      {
        self.increment_sequence_number();
        let message_ident = TMessageIdentifier::new("scannerGet", TMessageType::Call, self.sequence_number());
        let call_args = HbaseScannerGetArgs { id };
        self.o_prot_mut().write_message_begin(&message_ident)?;
        call_args.write_to_out_protocol(self.o_prot_mut())?;
        self.o_prot_mut().write_message_end()?;
        self.o_prot_mut().flush()
      }
    )?;
    {
      let message_ident = self.i_prot_mut().read_message_begin()?;
      verify_expected_sequence_number(self.sequence_number(), message_ident.sequence_number)?;
      verify_expected_service_call("scannerGet", &message_ident.name)?;
      if message_ident.message_type == TMessageType::Exception {
        let remote_error = thrift::Error::read_application_error_from_in_protocol(self.i_prot_mut())?;
        self.i_prot_mut().read_message_end()?;
        return Err(thrift::Error::Application(remote_error))
      }
      verify_expected_message_type(TMessageType::Reply, message_ident.message_type)?;
      let result = HbaseScannerGetResult::read_from_in_protocol(self.i_prot_mut())?;
      self.i_prot_mut().read_message_end()?;
      result.ok_or()
    }
  }
  fn scanner_get_list(&mut self, id: ScannerID, nb_rows: i32) -> thrift::Result<Vec<TRowResult>> {
    (
      {
        self.increment_sequence_number();
        let message_ident = TMessageIdentifier::new("scannerGetList", TMessageType::Call, self.sequence_number());
        let call_args = HbaseScannerGetListArgs { id, nb_rows };
        self.o_prot_mut().write_message_begin(&message_ident)?;
        call_args.write_to_out_protocol(self.o_prot_mut())?;
        self.o_prot_mut().write_message_end()?;
        self.o_prot_mut().flush()
      }
    )?;
    {
      let message_ident = self.i_prot_mut().read_message_begin()?;
      verify_expected_sequence_number(self.sequence_number(), message_ident.sequence_number)?;
      verify_expected_service_call("scannerGetList", &message_ident.name)?;
      if message_ident.message_type == TMessageType::Exception {
        let remote_error = thrift::Error::read_application_error_from_in_protocol(self.i_prot_mut())?;
        self.i_prot_mut().read_message_end()?;
        return Err(thrift::Error::Application(remote_error))
      }
      verify_expected_message_type(TMessageType::Reply, message_ident.message_type)?;
      let result = HbaseScannerGetListResult::read_from_in_protocol(self.i_prot_mut())?;
      self.i_prot_mut().read_message_end()?;
      result.ok_or()
    }
  }
  fn scanner_close(&mut self, id: ScannerID) -> thrift::Result<()> {
    (
      {
        self.increment_sequence_number();
        let message_ident = TMessageIdentifier::new("scannerClose", TMessageType::Call, self.sequence_number());
        let call_args = HbaseScannerCloseArgs { id };
        self.o_prot_mut().write_message_begin(&message_ident)?;
        call_args.write_to_out_protocol(self.o_prot_mut())?;
        self.o_prot_mut().write_message_end()?;
        self.o_prot_mut().flush()
      }
    )?;
    {
      let message_ident = self.i_prot_mut().read_message_begin()?;
      verify_expected_sequence_number(self.sequence_number(), message_ident.sequence_number)?;
      verify_expected_service_call("scannerClose", &message_ident.name)?;
      if message_ident.message_type == TMessageType::Exception {
        let remote_error = thrift::Error::read_application_error_from_in_protocol(self.i_prot_mut())?;
        self.i_prot_mut().read_message_end()?;
        return Err(thrift::Error::Application(remote_error))
      }
      verify_expected_message_type(TMessageType::Reply, message_ident.message_type)?;
      let result = HbaseScannerCloseResult::read_from_in_protocol(self.i_prot_mut())?;
      self.i_prot_mut().read_message_end()?;
      result.ok_or()
    }
  }
  fn get_region_info(&mut self, row: Text) -> thrift::Result<TRegionInfo> {
    (
      {
        self.increment_sequence_number();
        let message_ident = TMessageIdentifier::new("getRegionInfo", TMessageType::Call, self.sequence_number());
        let call_args = HbaseGetRegionInfoArgs { row };
        self.o_prot_mut().write_message_begin(&message_ident)?;
        call_args.write_to_out_protocol(self.o_prot_mut())?;
        self.o_prot_mut().write_message_end()?;
        self.o_prot_mut().flush()
      }
    )?;
    {
      let message_ident = self.i_prot_mut().read_message_begin()?;
      verify_expected_sequence_number(self.sequence_number(), message_ident.sequence_number)?;
      verify_expected_service_call("getRegionInfo", &message_ident.name)?;
      if message_ident.message_type == TMessageType::Exception {
        let remote_error = thrift::Error::read_application_error_from_in_protocol(self.i_prot_mut())?;
        self.i_prot_mut().read_message_end()?;
        return Err(thrift::Error::Application(remote_error))
      }
      verify_expected_message_type(TMessageType::Reply, message_ident.message_type)?;
      let result = HbaseGetRegionInfoResult::read_from_in_protocol(self.i_prot_mut())?;
      self.i_prot_mut().read_message_end()?;
      result.ok_or()
    }
  }
  fn append(&mut self, append: TAppend) -> thrift::Result<Vec<TCell>> {
    (
      {
        self.increment_sequence_number();
        let message_ident = TMessageIdentifier::new("append", TMessageType::Call, self.sequence_number());
        let call_args = HbaseAppendArgs { append };
        self.o_prot_mut().write_message_begin(&message_ident)?;
        call_args.write_to_out_protocol(self.o_prot_mut())?;
        self.o_prot_mut().write_message_end()?;
        self.o_prot_mut().flush()
      }
    )?;
    {
      let message_ident = self.i_prot_mut().read_message_begin()?;
      verify_expected_sequence_number(self.sequence_number(), message_ident.sequence_number)?;
      verify_expected_service_call("append", &message_ident.name)?;
      if message_ident.message_type == TMessageType::Exception {
        let remote_error = thrift::Error::read_application_error_from_in_protocol(self.i_prot_mut())?;
        self.i_prot_mut().read_message_end()?;
        return Err(thrift::Error::Application(remote_error))
      }
      verify_expected_message_type(TMessageType::Reply, message_ident.message_type)?;
      let result = HbaseAppendResult::read_from_in_protocol(self.i_prot_mut())?;
      self.i_prot_mut().read_message_end()?;
      result.ok_or()
    }
  }
  fn check_and_put(&mut self, table_name: Text, row: Text, column: Text, value: Text, mput: Mutation, attributes: BTreeMap<Text, Text>) -> thrift::Result<bool> {
    (
      {
        self.increment_sequence_number();
        let message_ident = TMessageIdentifier::new("checkAndPut", TMessageType::Call, self.sequence_number());
        let call_args = HbaseCheckAndPutArgs { table_name, row, column, value, mput, attributes };
        self.o_prot_mut().write_message_begin(&message_ident)?;
        call_args.write_to_out_protocol(self.o_prot_mut())?;
        self.o_prot_mut().write_message_end()?;
        self.o_prot_mut().flush()
      }
    )?;
    {
      let message_ident = self.i_prot_mut().read_message_begin()?;
      verify_expected_sequence_number(self.sequence_number(), message_ident.sequence_number)?;
      verify_expected_service_call("checkAndPut", &message_ident.name)?;
      if message_ident.message_type == TMessageType::Exception {
        let remote_error = thrift::Error::read_application_error_from_in_protocol(self.i_prot_mut())?;
        self.i_prot_mut().read_message_end()?;
        return Err(thrift::Error::Application(remote_error))
      }
      verify_expected_message_type(TMessageType::Reply, message_ident.message_type)?;
      let result = HbaseCheckAndPutResult::read_from_in_protocol(self.i_prot_mut())?;
      self.i_prot_mut().read_message_end()?;
      result.ok_or()
    }
  }
  fn get_thrift_server_type(&mut self) -> thrift::Result<TThriftServerType> {
    (
      {
        self.increment_sequence_number();
        let message_ident = TMessageIdentifier::new("getThriftServerType", TMessageType::Call, self.sequence_number());
        let call_args = HbaseGetThriftServerTypeArgs {  };
        self.o_prot_mut().write_message_begin(&message_ident)?;
        call_args.write_to_out_protocol(self.o_prot_mut())?;
        self.o_prot_mut().write_message_end()?;
        self.o_prot_mut().flush()
      }
    )?;
    {
      let message_ident = self.i_prot_mut().read_message_begin()?;
      verify_expected_sequence_number(self.sequence_number(), message_ident.sequence_number)?;
      verify_expected_service_call("getThriftServerType", &message_ident.name)?;
      if message_ident.message_type == TMessageType::Exception {
        let remote_error = thrift::Error::read_application_error_from_in_protocol(self.i_prot_mut())?;
        self.i_prot_mut().read_message_end()?;
        return Err(thrift::Error::Application(remote_error))
      }
      verify_expected_message_type(TMessageType::Reply, message_ident.message_type)?;
      let result = HbaseGetThriftServerTypeResult::read_from_in_protocol(self.i_prot_mut())?;
      self.i_prot_mut().read_message_end()?;
      result.ok_or()
    }
  }
  fn get_cluster_id(&mut self) -> thrift::Result<String> {
    (
      {
        self.increment_sequence_number();
        let message_ident = TMessageIdentifier::new("getClusterId", TMessageType::Call, self.sequence_number());
        let call_args = HbaseGetClusterIdArgs {  };
        self.o_prot_mut().write_message_begin(&message_ident)?;
        call_args.write_to_out_protocol(self.o_prot_mut())?;
        self.o_prot_mut().write_message_end()?;
        self.o_prot_mut().flush()
      }
    )?;
    {
      let message_ident = self.i_prot_mut().read_message_begin()?;
      verify_expected_sequence_number(self.sequence_number(), message_ident.sequence_number)?;
      verify_expected_service_call("getClusterId", &message_ident.name)?;
      if message_ident.message_type == TMessageType::Exception {
        let remote_error = thrift::Error::read_application_error_from_in_protocol(self.i_prot_mut())?;
        self.i_prot_mut().read_message_end()?;
        return Err(thrift::Error::Application(remote_error))
      }
      verify_expected_message_type(TMessageType::Reply, message_ident.message_type)?;
      let result = HbaseGetClusterIdResult::read_from_in_protocol(self.i_prot_mut())?;
      self.i_prot_mut().read_message_end()?;
      result.ok_or()
    }
  }
  fn grant(&mut self, info: TAccessControlEntity) -> thrift::Result<bool> {
    (
      {
        self.increment_sequence_number();
        let message_ident = TMessageIdentifier::new("grant", TMessageType::Call, self.sequence_number());
        let call_args = HbaseGrantArgs { info };
        self.o_prot_mut().write_message_begin(&message_ident)?;
        call_args.write_to_out_protocol(self.o_prot_mut())?;
        self.o_prot_mut().write_message_end()?;
        self.o_prot_mut().flush()
      }
    )?;
    {
      let message_ident = self.i_prot_mut().read_message_begin()?;
      verify_expected_sequence_number(self.sequence_number(), message_ident.sequence_number)?;
      verify_expected_service_call("grant", &message_ident.name)?;
      if message_ident.message_type == TMessageType::Exception {
        let remote_error = thrift::Error::read_application_error_from_in_protocol(self.i_prot_mut())?;
        self.i_prot_mut().read_message_end()?;
        return Err(thrift::Error::Application(remote_error))
      }
      verify_expected_message_type(TMessageType::Reply, message_ident.message_type)?;
      let result = HbaseGrantResult::read_from_in_protocol(self.i_prot_mut())?;
      self.i_prot_mut().read_message_end()?;
      result.ok_or()
    }
  }
  fn revoke(&mut self, info: TAccessControlEntity) -> thrift::Result<bool> {
    (
      {
        self.increment_sequence_number();
        let message_ident = TMessageIdentifier::new("revoke", TMessageType::Call, self.sequence_number());
        let call_args = HbaseRevokeArgs { info };
        self.o_prot_mut().write_message_begin(&message_ident)?;
        call_args.write_to_out_protocol(self.o_prot_mut())?;
        self.o_prot_mut().write_message_end()?;
        self.o_prot_mut().flush()
      }
    )?;
    {
      let message_ident = self.i_prot_mut().read_message_begin()?;
      verify_expected_sequence_number(self.sequence_number(), message_ident.sequence_number)?;
      verify_expected_service_call("revoke", &message_ident.name)?;
      if message_ident.message_type == TMessageType::Exception {
        let remote_error = thrift::Error::read_application_error_from_in_protocol(self.i_prot_mut())?;
        self.i_prot_mut().read_message_end()?;
        return Err(thrift::Error::Application(remote_error))
      }
      verify_expected_message_type(TMessageType::Reply, message_ident.message_type)?;
      let result = HbaseRevokeResult::read_from_in_protocol(self.i_prot_mut())?;
      self.i_prot_mut().read_message_end()?;
      result.ok_or()
    }
  }
}

//
// Hbase service processor
//

pub trait HbaseSyncHandler {
  /// Brings a table on-line (enables it)
  fn handle_enable_table(&self, table_name: Bytes) -> thrift::Result<()>;
  /// Disables a table (takes it off-line) If it is being served, the master
  /// will tell the servers to stop serving it.
  fn handle_disable_table(&self, table_name: Bytes) -> thrift::Result<()>;
  /// @return true if table is on-line
  fn handle_is_table_enabled(&self, table_name: Bytes) -> thrift::Result<bool>;
  fn handle_compact(&self, table_name_or_region_name: Bytes) -> thrift::Result<()>;
  fn handle_major_compact(&self, table_name_or_region_name: Bytes) -> thrift::Result<()>;
  /// List all the userspace tables.
  /// 
  /// @return returns a list of names
  fn handle_get_table_names(&self) -> thrift::Result<Vec<Text>>;
  /// List all the userspace tables and their enabled or disabled flags.
  /// 
  /// @return list of tables with is enabled flags
  fn handle_get_table_names_with_is_table_enabled(&self) -> thrift::Result<BTreeMap<Text, bool>>;
  /// List all the column families assoicated with a table.
  /// 
  /// @return list of column family descriptors
  fn handle_get_column_descriptors(&self, table_name: Text) -> thrift::Result<BTreeMap<Text, ColumnDescriptor>>;
  /// List the regions associated with a table.
  /// 
  /// @return list of region descriptors
  fn handle_get_table_regions(&self, table_name: Text) -> thrift::Result<Vec<TRegionInfo>>;
  /// Create a table with the specified column families.  The name
  /// field for each ColumnDescriptor must be set and must end in a
  /// colon (:). All other fields are optional and will get default
  /// values if not explicitly specified.
  /// 
  /// @throws IllegalArgument if an input parameter is invalid
  /// 
  /// @throws AlreadyExists if the table name already exists
  fn handle_create_table(&self, table_name: Text, column_families: Vec<ColumnDescriptor>) -> thrift::Result<()>;
  /// Deletes a table
  /// 
  /// @throws IOError if table doesn't exist on server or there was some other
  /// problem
  fn handle_delete_table(&self, table_name: Text) -> thrift::Result<()>;
  /// Get a single TCell for the specified table, row, and column at the
  /// latest timestamp. Returns an empty list if no such value exists.
  /// 
  /// @return value for specified row/column
  fn handle_get(&self, table_name: Text, row: Text, column: Text, attributes: BTreeMap<Text, Text>) -> thrift::Result<Vec<TCell>>;
  /// Get the specified number of versions for the specified table,
  /// row, and column.
  /// 
  /// @return list of cells for specified row/column
  fn handle_get_ver(&self, table_name: Text, row: Text, column: Text, num_versions: i32, attributes: BTreeMap<Text, Text>) -> thrift::Result<Vec<TCell>>;
  /// Get the specified number of versions for the specified table,
  /// row, and column.  Only versions less than or equal to the specified
  /// timestamp will be returned.
  /// 
  /// @return list of cells for specified row/column
  fn handle_get_ver_ts(&self, table_name: Text, row: Text, column: Text, timestamp: i64, num_versions: i32, attributes: BTreeMap<Text, Text>) -> thrift::Result<Vec<TCell>>;
  /// Get all the data for the specified table and row at the latest
  /// timestamp. Returns an empty list if the row does not exist.
  /// 
  /// @return TRowResult containing the row and map of columns to TCells
  fn handle_get_row(&self, table_name: Text, row: Text, attributes: BTreeMap<Text, Text>) -> thrift::Result<Vec<TRowResult>>;
  /// Get the specified columns for the specified table and row at the latest
  /// timestamp. Returns an empty list if the row does not exist.
  /// 
  /// @return TRowResult containing the row and map of columns to TCells
  fn handle_get_row_with_columns(&self, table_name: Text, row: Text, columns: Vec<Text>, attributes: BTreeMap<Text, Text>) -> thrift::Result<Vec<TRowResult>>;
  /// Get all the data for the specified table and row at the specified
  /// timestamp. Returns an empty list if the row does not exist.
  /// 
  /// @return TRowResult containing the row and map of columns to TCells
  fn handle_get_row_ts(&self, table_name: Text, row: Text, timestamp: i64, attributes: BTreeMap<Text, Text>) -> thrift::Result<Vec<TRowResult>>;
  /// Get the specified columns for the specified table and row at the specified
  /// timestamp. Returns an empty list if the row does not exist.
  /// 
  /// @return TRowResult containing the row and map of columns to TCells
  fn handle_get_row_with_columns_ts(&self, table_name: Text, row: Text, columns: Vec<Text>, timestamp: i64, attributes: BTreeMap<Text, Text>) -> thrift::Result<Vec<TRowResult>>;
  /// Get all the data for the specified table and rows at the latest
  /// timestamp. Returns an empty list if no rows exist.
  /// 
  /// @return TRowResult containing the rows and map of columns to TCells
  fn handle_get_rows(&self, table_name: Text, rows: Vec<Text>, attributes: BTreeMap<Text, Text>) -> thrift::Result<Vec<TRowResult>>;
  /// Get the specified columns for the specified table and rows at the latest
  /// timestamp. Returns an empty list if no rows exist.
  /// 
  /// @return TRowResult containing the rows and map of columns to TCells
  fn handle_get_rows_with_columns(&self, table_name: Text, rows: Vec<Text>, columns: Vec<Text>, attributes: BTreeMap<Text, Text>) -> thrift::Result<Vec<TRowResult>>;
  /// Get all the data for the specified table and rows at the specified
  /// timestamp. Returns an empty list if no rows exist.
  /// 
  /// @return TRowResult containing the rows and map of columns to TCells
  fn handle_get_rows_ts(&self, table_name: Text, rows: Vec<Text>, timestamp: i64, attributes: BTreeMap<Text, Text>) -> thrift::Result<Vec<TRowResult>>;
  /// Get the specified columns for the specified table and rows at the specified
  /// timestamp. Returns an empty list if no rows exist.
  /// 
  /// @return TRowResult containing the rows and map of columns to TCells
  fn handle_get_rows_with_columns_ts(&self, table_name: Text, rows: Vec<Text>, columns: Vec<Text>, timestamp: i64, attributes: BTreeMap<Text, Text>) -> thrift::Result<Vec<TRowResult>>;
  /// Apply a series of mutations (updates/deletes) to a row in a
  /// single transaction.  If an exception is thrown, then the
  /// transaction is aborted.  Default current timestamp is used, and
  /// all entries will have an identical timestamp.
  fn handle_mutate_row(&self, table_name: Text, row: Text, mutations: Vec<Mutation>, attributes: BTreeMap<Text, Text>) -> thrift::Result<()>;
  /// Apply a series of mutations (updates/deletes) to a row in a
  /// single transaction.  If an exception is thrown, then the
  /// transaction is aborted.  The specified timestamp is used, and
  /// all entries will have an identical timestamp.
  fn handle_mutate_row_ts(&self, table_name: Text, row: Text, mutations: Vec<Mutation>, timestamp: i64, attributes: BTreeMap<Text, Text>) -> thrift::Result<()>;
  /// Apply a series of batches (each a series of mutations on a single row)
  /// in a single transaction.  If an exception is thrown, then the
  /// transaction is aborted.  Default current timestamp is used, and
  /// all entries will have an identical timestamp.
  fn handle_mutate_rows(&self, table_name: Text, row_batches: Vec<BatchMutation>, attributes: BTreeMap<Text, Text>) -> thrift::Result<()>;
  /// Apply a series of batches (each a series of mutations on a single row)
  /// in a single transaction.  If an exception is thrown, then the
  /// transaction is aborted.  The specified timestamp is used, and
  /// all entries will have an identical timestamp.
  fn handle_mutate_rows_ts(&self, table_name: Text, row_batches: Vec<BatchMutation>, timestamp: i64, attributes: BTreeMap<Text, Text>) -> thrift::Result<()>;
  /// Atomically increment the column value specified.  Returns the next value post increment.
  fn handle_atomic_increment(&self, table_name: Text, row: Text, column: Text, value: i64) -> thrift::Result<i64>;
  /// Delete all cells that match the passed row and column.
  fn handle_delete_all(&self, table_name: Text, row: Text, column: Text, attributes: BTreeMap<Text, Text>) -> thrift::Result<()>;
  /// Delete all cells that match the passed row and column and whose
  /// timestamp is equal-to or older than the passed timestamp.
  fn handle_delete_all_ts(&self, table_name: Text, row: Text, column: Text, timestamp: i64, attributes: BTreeMap<Text, Text>) -> thrift::Result<()>;
  /// Completely delete the row's cells.
  fn handle_delete_all_row(&self, table_name: Text, row: Text, attributes: BTreeMap<Text, Text>) -> thrift::Result<()>;
  /// Increment a cell by the ammount.
  /// Increments can be applied async if hbase.regionserver.thrift.coalesceIncrement is set to true.
  /// False is the default.  Turn to true if you need the extra performance and can accept some
  /// data loss if a thrift server dies with increments still in the queue.
  fn handle_increment(&self, increment: TIncrement) -> thrift::Result<()>;
  fn handle_increment_rows(&self, increments: Vec<TIncrement>) -> thrift::Result<()>;
  /// Completely delete the row's cells marked with a timestamp
  /// equal-to or older than the passed timestamp.
  fn handle_delete_all_row_ts(&self, table_name: Text, row: Text, timestamp: i64, attributes: BTreeMap<Text, Text>) -> thrift::Result<()>;
  /// Get a scanner on the current table, using the Scan instance
  /// for the scan parameters.
  fn handle_scanner_open_with_scan(&self, table_name: Text, scan: TScan, attributes: BTreeMap<Text, Text>) -> thrift::Result<ScannerID>;
  /// Get a scanner on the current table starting at the specified row and
  /// ending at the last row in the table.  Return the specified columns.
  /// 
  /// @return scanner id to be used with other scanner procedures
  fn handle_scanner_open(&self, table_name: Text, start_row: Text, columns: Vec<Text>, attributes: BTreeMap<Text, Text>) -> thrift::Result<ScannerID>;
  /// Get a scanner on the current table starting and stopping at the
  /// specified rows.  ending at the last row in the table.  Return the
  /// specified columns.
  /// 
  /// @return scanner id to be used with other scanner procedures
  fn handle_scanner_open_with_stop(&self, table_name: Text, start_row: Text, stop_row: Text, columns: Vec<Text>, attributes: BTreeMap<Text, Text>) -> thrift::Result<ScannerID>;
  /// Open a scanner for a given prefix.  That is all rows will have the specified
  /// prefix. No other rows will be returned.
  /// 
  /// @return scanner id to use with other scanner calls
  fn handle_scanner_open_with_prefix(&self, table_name: Text, start_and_prefix: Text, columns: Vec<Text>, attributes: BTreeMap<Text, Text>) -> thrift::Result<ScannerID>;
  /// Get a scanner on the current table starting at the specified row and
  /// ending at the last row in the table.  Return the specified columns.
  /// Only values with the specified timestamp are returned.
  /// 
  /// @return scanner id to be used with other scanner procedures
  fn handle_scanner_open_ts(&self, table_name: Text, start_row: Text, columns: Vec<Text>, timestamp: i64, attributes: BTreeMap<Text, Text>) -> thrift::Result<ScannerID>;
  /// Get a scanner on the current table starting and stopping at the
  /// specified rows.  ending at the last row in the table.  Return the
  /// specified columns.  Only values with the specified timestamp are
  /// returned.
  /// 
  /// @return scanner id to be used with other scanner procedures
  fn handle_scanner_open_with_stop_ts(&self, table_name: Text, start_row: Text, stop_row: Text, columns: Vec<Text>, timestamp: i64, attributes: BTreeMap<Text, Text>) -> thrift::Result<ScannerID>;
  /// Returns the scanner's current row value and advances to the next
  /// row in the table.  When there are no more rows in the table, or a key
  /// greater-than-or-equal-to the scanner's specified stopRow is reached,
  /// an empty list is returned.
  /// 
  /// @return a TRowResult containing the current row and a map of the columns to TCells.
  /// 
  /// @throws IllegalArgument if ScannerID is invalid
  /// 
  /// @throws NotFound when the scanner reaches the end
  fn handle_scanner_get(&self, id: ScannerID) -> thrift::Result<Vec<TRowResult>>;
  /// Returns, starting at the scanner's current row value nbRows worth of
  /// rows and advances to the next row in the table.  When there are no more
  /// rows in the table, or a key greater-than-or-equal-to the scanner's
  /// specified stopRow is reached,  an empty list is returned.
  /// 
  /// @return a TRowResult containing the current row and a map of the columns to TCells.
  /// 
  /// @throws IllegalArgument if ScannerID is invalid
  /// 
  /// @throws NotFound when the scanner reaches the end
  fn handle_scanner_get_list(&self, id: ScannerID, nb_rows: i32) -> thrift::Result<Vec<TRowResult>>;
  /// Closes the server-state associated with an open scanner.
  /// 
  /// @throws IllegalArgument if ScannerID is invalid
  fn handle_scanner_close(&self, id: ScannerID) -> thrift::Result<()>;
  /// Get the regininfo for the specified row. It scans
  /// the metatable to find region's start and end keys.
  /// 
  /// @return value for specified row/column
  fn handle_get_region_info(&self, row: Text) -> thrift::Result<TRegionInfo>;
  /// Appends values to one or more columns within a single row.
  /// 
  /// @return values of columns after the append operation.
  fn handle_append(&self, append: TAppend) -> thrift::Result<Vec<TCell>>;
  /// Atomically checks if a row/family/qualifier value matches the expected
  /// value. If it does, it adds the corresponding mutation operation for put.
  /// 
  /// @return true if the new put was executed, false otherwise
  fn handle_check_and_put(&self, table_name: Text, row: Text, column: Text, value: Text, mput: Mutation, attributes: BTreeMap<Text, Text>) -> thrift::Result<bool>;
  /// Get the type of this thrift server.
  /// 
  /// @return the type of this thrift server
  fn handle_get_thrift_server_type(&self) -> thrift::Result<TThriftServerType>;
  /// Returns the cluster ID for this cluster.
  fn handle_get_cluster_id(&self) -> thrift::Result<String>;
  /// Grant permissions in namespace or table level.
  fn handle_grant(&self, info: TAccessControlEntity) -> thrift::Result<bool>;
  /// Revoke permissions in namespace or table level.
  fn handle_revoke(&self, info: TAccessControlEntity) -> thrift::Result<bool>;
}

pub struct HbaseSyncProcessor<H: HbaseSyncHandler> {
  handler: H,
}

impl <H: HbaseSyncHandler> HbaseSyncProcessor<H> {
  pub fn new(handler: H) -> HbaseSyncProcessor<H> {
    HbaseSyncProcessor {
      handler,
    }
  }
  fn process_enable_table(&self, incoming_sequence_number: i32, i_prot: &mut dyn TInputProtocol, o_prot: &mut dyn TOutputProtocol) -> thrift::Result<()> {
    THbaseProcessFunctions::process_enable_table(&self.handler, incoming_sequence_number, i_prot, o_prot)
  }
  fn process_disable_table(&self, incoming_sequence_number: i32, i_prot: &mut dyn TInputProtocol, o_prot: &mut dyn TOutputProtocol) -> thrift::Result<()> {
    THbaseProcessFunctions::process_disable_table(&self.handler, incoming_sequence_number, i_prot, o_prot)
  }
  fn process_is_table_enabled(&self, incoming_sequence_number: i32, i_prot: &mut dyn TInputProtocol, o_prot: &mut dyn TOutputProtocol) -> thrift::Result<()> {
    THbaseProcessFunctions::process_is_table_enabled(&self.handler, incoming_sequence_number, i_prot, o_prot)
  }
  fn process_compact(&self, incoming_sequence_number: i32, i_prot: &mut dyn TInputProtocol, o_prot: &mut dyn TOutputProtocol) -> thrift::Result<()> {
    THbaseProcessFunctions::process_compact(&self.handler, incoming_sequence_number, i_prot, o_prot)
  }
  fn process_major_compact(&self, incoming_sequence_number: i32, i_prot: &mut dyn TInputProtocol, o_prot: &mut dyn TOutputProtocol) -> thrift::Result<()> {
    THbaseProcessFunctions::process_major_compact(&self.handler, incoming_sequence_number, i_prot, o_prot)
  }
  fn process_get_table_names(&self, incoming_sequence_number: i32, i_prot: &mut dyn TInputProtocol, o_prot: &mut dyn TOutputProtocol) -> thrift::Result<()> {
    THbaseProcessFunctions::process_get_table_names(&self.handler, incoming_sequence_number, i_prot, o_prot)
  }
  fn process_get_table_names_with_is_table_enabled(&self, incoming_sequence_number: i32, i_prot: &mut dyn TInputProtocol, o_prot: &mut dyn TOutputProtocol) -> thrift::Result<()> {
    THbaseProcessFunctions::process_get_table_names_with_is_table_enabled(&self.handler, incoming_sequence_number, i_prot, o_prot)
  }
  fn process_get_column_descriptors(&self, incoming_sequence_number: i32, i_prot: &mut dyn TInputProtocol, o_prot: &mut dyn TOutputProtocol) -> thrift::Result<()> {
    THbaseProcessFunctions::process_get_column_descriptors(&self.handler, incoming_sequence_number, i_prot, o_prot)
  }
  fn process_get_table_regions(&self, incoming_sequence_number: i32, i_prot: &mut dyn TInputProtocol, o_prot: &mut dyn TOutputProtocol) -> thrift::Result<()> {
    THbaseProcessFunctions::process_get_table_regions(&self.handler, incoming_sequence_number, i_prot, o_prot)
  }
  fn process_create_table(&self, incoming_sequence_number: i32, i_prot: &mut dyn TInputProtocol, o_prot: &mut dyn TOutputProtocol) -> thrift::Result<()> {
    THbaseProcessFunctions::process_create_table(&self.handler, incoming_sequence_number, i_prot, o_prot)
  }
  fn process_delete_table(&self, incoming_sequence_number: i32, i_prot: &mut dyn TInputProtocol, o_prot: &mut dyn TOutputProtocol) -> thrift::Result<()> {
    THbaseProcessFunctions::process_delete_table(&self.handler, incoming_sequence_number, i_prot, o_prot)
  }
  fn process_get(&self, incoming_sequence_number: i32, i_prot: &mut dyn TInputProtocol, o_prot: &mut dyn TOutputProtocol) -> thrift::Result<()> {
    THbaseProcessFunctions::process_get(&self.handler, incoming_sequence_number, i_prot, o_prot)
  }
  fn process_get_ver(&self, incoming_sequence_number: i32, i_prot: &mut dyn TInputProtocol, o_prot: &mut dyn TOutputProtocol) -> thrift::Result<()> {
    THbaseProcessFunctions::process_get_ver(&self.handler, incoming_sequence_number, i_prot, o_prot)
  }
  fn process_get_ver_ts(&self, incoming_sequence_number: i32, i_prot: &mut dyn TInputProtocol, o_prot: &mut dyn TOutputProtocol) -> thrift::Result<()> {
    THbaseProcessFunctions::process_get_ver_ts(&self.handler, incoming_sequence_number, i_prot, o_prot)
  }
  fn process_get_row(&self, incoming_sequence_number: i32, i_prot: &mut dyn TInputProtocol, o_prot: &mut dyn TOutputProtocol) -> thrift::Result<()> {
    THbaseProcessFunctions::process_get_row(&self.handler, incoming_sequence_number, i_prot, o_prot)
  }
  fn process_get_row_with_columns(&self, incoming_sequence_number: i32, i_prot: &mut dyn TInputProtocol, o_prot: &mut dyn TOutputProtocol) -> thrift::Result<()> {
    THbaseProcessFunctions::process_get_row_with_columns(&self.handler, incoming_sequence_number, i_prot, o_prot)
  }
  fn process_get_row_ts(&self, incoming_sequence_number: i32, i_prot: &mut dyn TInputProtocol, o_prot: &mut dyn TOutputProtocol) -> thrift::Result<()> {
    THbaseProcessFunctions::process_get_row_ts(&self.handler, incoming_sequence_number, i_prot, o_prot)
  }
  fn process_get_row_with_columns_ts(&self, incoming_sequence_number: i32, i_prot: &mut dyn TInputProtocol, o_prot: &mut dyn TOutputProtocol) -> thrift::Result<()> {
    THbaseProcessFunctions::process_get_row_with_columns_ts(&self.handler, incoming_sequence_number, i_prot, o_prot)
  }
  fn process_get_rows(&self, incoming_sequence_number: i32, i_prot: &mut dyn TInputProtocol, o_prot: &mut dyn TOutputProtocol) -> thrift::Result<()> {
    THbaseProcessFunctions::process_get_rows(&self.handler, incoming_sequence_number, i_prot, o_prot)
  }
  fn process_get_rows_with_columns(&self, incoming_sequence_number: i32, i_prot: &mut dyn TInputProtocol, o_prot: &mut dyn TOutputProtocol) -> thrift::Result<()> {
    THbaseProcessFunctions::process_get_rows_with_columns(&self.handler, incoming_sequence_number, i_prot, o_prot)
  }
  fn process_get_rows_ts(&self, incoming_sequence_number: i32, i_prot: &mut dyn TInputProtocol, o_prot: &mut dyn TOutputProtocol) -> thrift::Result<()> {
    THbaseProcessFunctions::process_get_rows_ts(&self.handler, incoming_sequence_number, i_prot, o_prot)
  }
  fn process_get_rows_with_columns_ts(&self, incoming_sequence_number: i32, i_prot: &mut dyn TInputProtocol, o_prot: &mut dyn TOutputProtocol) -> thrift::Result<()> {
    THbaseProcessFunctions::process_get_rows_with_columns_ts(&self.handler, incoming_sequence_number, i_prot, o_prot)
  }
  fn process_mutate_row(&self, incoming_sequence_number: i32, i_prot: &mut dyn TInputProtocol, o_prot: &mut dyn TOutputProtocol) -> thrift::Result<()> {
    THbaseProcessFunctions::process_mutate_row(&self.handler, incoming_sequence_number, i_prot, o_prot)
  }
  fn process_mutate_row_ts(&self, incoming_sequence_number: i32, i_prot: &mut dyn TInputProtocol, o_prot: &mut dyn TOutputProtocol) -> thrift::Result<()> {
    THbaseProcessFunctions::process_mutate_row_ts(&self.handler, incoming_sequence_number, i_prot, o_prot)
  }
  fn process_mutate_rows(&self, incoming_sequence_number: i32, i_prot: &mut dyn TInputProtocol, o_prot: &mut dyn TOutputProtocol) -> thrift::Result<()> {
    THbaseProcessFunctions::process_mutate_rows(&self.handler, incoming_sequence_number, i_prot, o_prot)
  }
  fn process_mutate_rows_ts(&self, incoming_sequence_number: i32, i_prot: &mut dyn TInputProtocol, o_prot: &mut dyn TOutputProtocol) -> thrift::Result<()> {
    THbaseProcessFunctions::process_mutate_rows_ts(&self.handler, incoming_sequence_number, i_prot, o_prot)
  }
  fn process_atomic_increment(&self, incoming_sequence_number: i32, i_prot: &mut dyn TInputProtocol, o_prot: &mut dyn TOutputProtocol) -> thrift::Result<()> {
    THbaseProcessFunctions::process_atomic_increment(&self.handler, incoming_sequence_number, i_prot, o_prot)
  }
  fn process_delete_all(&self, incoming_sequence_number: i32, i_prot: &mut dyn TInputProtocol, o_prot: &mut dyn TOutputProtocol) -> thrift::Result<()> {
    THbaseProcessFunctions::process_delete_all(&self.handler, incoming_sequence_number, i_prot, o_prot)
  }
  fn process_delete_all_ts(&self, incoming_sequence_number: i32, i_prot: &mut dyn TInputProtocol, o_prot: &mut dyn TOutputProtocol) -> thrift::Result<()> {
    THbaseProcessFunctions::process_delete_all_ts(&self.handler, incoming_sequence_number, i_prot, o_prot)
  }
  fn process_delete_all_row(&self, incoming_sequence_number: i32, i_prot: &mut dyn TInputProtocol, o_prot: &mut dyn TOutputProtocol) -> thrift::Result<()> {
    THbaseProcessFunctions::process_delete_all_row(&self.handler, incoming_sequence_number, i_prot, o_prot)
  }
  fn process_increment(&self, incoming_sequence_number: i32, i_prot: &mut dyn TInputProtocol, o_prot: &mut dyn TOutputProtocol) -> thrift::Result<()> {
    THbaseProcessFunctions::process_increment(&self.handler, incoming_sequence_number, i_prot, o_prot)
  }
  fn process_increment_rows(&self, incoming_sequence_number: i32, i_prot: &mut dyn TInputProtocol, o_prot: &mut dyn TOutputProtocol) -> thrift::Result<()> {
    THbaseProcessFunctions::process_increment_rows(&self.handler, incoming_sequence_number, i_prot, o_prot)
  }
  fn process_delete_all_row_ts(&self, incoming_sequence_number: i32, i_prot: &mut dyn TInputProtocol, o_prot: &mut dyn TOutputProtocol) -> thrift::Result<()> {
    THbaseProcessFunctions::process_delete_all_row_ts(&self.handler, incoming_sequence_number, i_prot, o_prot)
  }
  fn process_scanner_open_with_scan(&self, incoming_sequence_number: i32, i_prot: &mut dyn TInputProtocol, o_prot: &mut dyn TOutputProtocol) -> thrift::Result<()> {
    THbaseProcessFunctions::process_scanner_open_with_scan(&self.handler, incoming_sequence_number, i_prot, o_prot)
  }
  fn process_scanner_open(&self, incoming_sequence_number: i32, i_prot: &mut dyn TInputProtocol, o_prot: &mut dyn TOutputProtocol) -> thrift::Result<()> {
    THbaseProcessFunctions::process_scanner_open(&self.handler, incoming_sequence_number, i_prot, o_prot)
  }
  fn process_scanner_open_with_stop(&self, incoming_sequence_number: i32, i_prot: &mut dyn TInputProtocol, o_prot: &mut dyn TOutputProtocol) -> thrift::Result<()> {
    THbaseProcessFunctions::process_scanner_open_with_stop(&self.handler, incoming_sequence_number, i_prot, o_prot)
  }
  fn process_scanner_open_with_prefix(&self, incoming_sequence_number: i32, i_prot: &mut dyn TInputProtocol, o_prot: &mut dyn TOutputProtocol) -> thrift::Result<()> {
    THbaseProcessFunctions::process_scanner_open_with_prefix(&self.handler, incoming_sequence_number, i_prot, o_prot)
  }
  fn process_scanner_open_ts(&self, incoming_sequence_number: i32, i_prot: &mut dyn TInputProtocol, o_prot: &mut dyn TOutputProtocol) -> thrift::Result<()> {
    THbaseProcessFunctions::process_scanner_open_ts(&self.handler, incoming_sequence_number, i_prot, o_prot)
  }
  fn process_scanner_open_with_stop_ts(&self, incoming_sequence_number: i32, i_prot: &mut dyn TInputProtocol, o_prot: &mut dyn TOutputProtocol) -> thrift::Result<()> {
    THbaseProcessFunctions::process_scanner_open_with_stop_ts(&self.handler, incoming_sequence_number, i_prot, o_prot)
  }
  fn process_scanner_get(&self, incoming_sequence_number: i32, i_prot: &mut dyn TInputProtocol, o_prot: &mut dyn TOutputProtocol) -> thrift::Result<()> {
    THbaseProcessFunctions::process_scanner_get(&self.handler, incoming_sequence_number, i_prot, o_prot)
  }
  fn process_scanner_get_list(&self, incoming_sequence_number: i32, i_prot: &mut dyn TInputProtocol, o_prot: &mut dyn TOutputProtocol) -> thrift::Result<()> {
    THbaseProcessFunctions::process_scanner_get_list(&self.handler, incoming_sequence_number, i_prot, o_prot)
  }
  fn process_scanner_close(&self, incoming_sequence_number: i32, i_prot: &mut dyn TInputProtocol, o_prot: &mut dyn TOutputProtocol) -> thrift::Result<()> {
    THbaseProcessFunctions::process_scanner_close(&self.handler, incoming_sequence_number, i_prot, o_prot)
  }
  fn process_get_region_info(&self, incoming_sequence_number: i32, i_prot: &mut dyn TInputProtocol, o_prot: &mut dyn TOutputProtocol) -> thrift::Result<()> {
    THbaseProcessFunctions::process_get_region_info(&self.handler, incoming_sequence_number, i_prot, o_prot)
  }
  fn process_append(&self, incoming_sequence_number: i32, i_prot: &mut dyn TInputProtocol, o_prot: &mut dyn TOutputProtocol) -> thrift::Result<()> {
    THbaseProcessFunctions::process_append(&self.handler, incoming_sequence_number, i_prot, o_prot)
  }
  fn process_check_and_put(&self, incoming_sequence_number: i32, i_prot: &mut dyn TInputProtocol, o_prot: &mut dyn TOutputProtocol) -> thrift::Result<()> {
    THbaseProcessFunctions::process_check_and_put(&self.handler, incoming_sequence_number, i_prot, o_prot)
  }
  fn process_get_thrift_server_type(&self, incoming_sequence_number: i32, i_prot: &mut dyn TInputProtocol, o_prot: &mut dyn TOutputProtocol) -> thrift::Result<()> {
    THbaseProcessFunctions::process_get_thrift_server_type(&self.handler, incoming_sequence_number, i_prot, o_prot)
  }
  fn process_get_cluster_id(&self, incoming_sequence_number: i32, i_prot: &mut dyn TInputProtocol, o_prot: &mut dyn TOutputProtocol) -> thrift::Result<()> {
    THbaseProcessFunctions::process_get_cluster_id(&self.handler, incoming_sequence_number, i_prot, o_prot)
  }
  fn process_grant(&self, incoming_sequence_number: i32, i_prot: &mut dyn TInputProtocol, o_prot: &mut dyn TOutputProtocol) -> thrift::Result<()> {
    THbaseProcessFunctions::process_grant(&self.handler, incoming_sequence_number, i_prot, o_prot)
  }
  fn process_revoke(&self, incoming_sequence_number: i32, i_prot: &mut dyn TInputProtocol, o_prot: &mut dyn TOutputProtocol) -> thrift::Result<()> {
    THbaseProcessFunctions::process_revoke(&self.handler, incoming_sequence_number, i_prot, o_prot)
  }
}

pub struct THbaseProcessFunctions;

impl THbaseProcessFunctions {
  pub fn process_enable_table<H: HbaseSyncHandler>(handler: &H, incoming_sequence_number: i32, i_prot: &mut dyn TInputProtocol, o_prot: &mut dyn TOutputProtocol) -> thrift::Result<()> {
    let args = HbaseEnableTableArgs::read_from_in_protocol(i_prot)?;
    match handler.handle_enable_table(args.table_name) {
      Ok(_) => {
        let message_ident = TMessageIdentifier::new("enableTable", TMessageType::Reply, incoming_sequence_number);
        o_prot.write_message_begin(&message_ident)?;
        let ret = HbaseEnableTableResult { io: None };
        ret.write_to_out_protocol(o_prot)?;
        o_prot.write_message_end()?;
        o_prot.flush()
      },
      Err(e) => {
        match e {
          thrift::Error::User(usr_err) => {
            if usr_err.downcast_ref::<IOError>().is_some() {
              let err = usr_err.downcast::<IOError>().expect("downcast already checked");
              let ret_err = HbaseEnableTableResult{ io: Some(*err) };
              let message_ident = TMessageIdentifier::new("enableTable", TMessageType::Reply, incoming_sequence_number);
              o_prot.write_message_begin(&message_ident)?;
              ret_err.write_to_out_protocol(o_prot)?;
              o_prot.write_message_end()?;
              o_prot.flush()
            } else {
              let ret_err = {
                ApplicationError::new(
                  ApplicationErrorKind::Unknown,
                  usr_err.to_string()
                )
              };
              let message_ident = TMessageIdentifier::new("enableTable", TMessageType::Exception, incoming_sequence_number);
              o_prot.write_message_begin(&message_ident)?;
              thrift::Error::write_application_error_to_out_protocol(&ret_err, o_prot)?;
              o_prot.write_message_end()?;
              o_prot.flush()
            }
          },
          thrift::Error::Application(app_err) => {
            let message_ident = TMessageIdentifier::new("enableTable", TMessageType::Exception, incoming_sequence_number);
            o_prot.write_message_begin(&message_ident)?;
            thrift::Error::write_application_error_to_out_protocol(&app_err, o_prot)?;
            o_prot.write_message_end()?;
            o_prot.flush()
          },
          _ => {
            let ret_err = {
              ApplicationError::new(
                ApplicationErrorKind::Unknown,
                e.to_string()
              )
            };
            let message_ident = TMessageIdentifier::new("enableTable", TMessageType::Exception, incoming_sequence_number);
            o_prot.write_message_begin(&message_ident)?;
            thrift::Error::write_application_error_to_out_protocol(&ret_err, o_prot)?;
            o_prot.write_message_end()?;
            o_prot.flush()
          },
        }
      },
    }
  }
  pub fn process_disable_table<H: HbaseSyncHandler>(handler: &H, incoming_sequence_number: i32, i_prot: &mut dyn TInputProtocol, o_prot: &mut dyn TOutputProtocol) -> thrift::Result<()> {
    let args = HbaseDisableTableArgs::read_from_in_protocol(i_prot)?;
    match handler.handle_disable_table(args.table_name) {
      Ok(_) => {
        let message_ident = TMessageIdentifier::new("disableTable", TMessageType::Reply, incoming_sequence_number);
        o_prot.write_message_begin(&message_ident)?;
        let ret = HbaseDisableTableResult { io: None };
        ret.write_to_out_protocol(o_prot)?;
        o_prot.write_message_end()?;
        o_prot.flush()
      },
      Err(e) => {
        match e {
          thrift::Error::User(usr_err) => {
            if usr_err.downcast_ref::<IOError>().is_some() {
              let err = usr_err.downcast::<IOError>().expect("downcast already checked");
              let ret_err = HbaseDisableTableResult{ io: Some(*err) };
              let message_ident = TMessageIdentifier::new("disableTable", TMessageType::Reply, incoming_sequence_number);
              o_prot.write_message_begin(&message_ident)?;
              ret_err.write_to_out_protocol(o_prot)?;
              o_prot.write_message_end()?;
              o_prot.flush()
            } else {
              let ret_err = {
                ApplicationError::new(
                  ApplicationErrorKind::Unknown,
                  usr_err.to_string()
                )
              };
              let message_ident = TMessageIdentifier::new("disableTable", TMessageType::Exception, incoming_sequence_number);
              o_prot.write_message_begin(&message_ident)?;
              thrift::Error::write_application_error_to_out_protocol(&ret_err, o_prot)?;
              o_prot.write_message_end()?;
              o_prot.flush()
            }
          },
          thrift::Error::Application(app_err) => {
            let message_ident = TMessageIdentifier::new("disableTable", TMessageType::Exception, incoming_sequence_number);
            o_prot.write_message_begin(&message_ident)?;
            thrift::Error::write_application_error_to_out_protocol(&app_err, o_prot)?;
            o_prot.write_message_end()?;
            o_prot.flush()
          },
          _ => {
            let ret_err = {
              ApplicationError::new(
                ApplicationErrorKind::Unknown,
                e.to_string()
              )
            };
            let message_ident = TMessageIdentifier::new("disableTable", TMessageType::Exception, incoming_sequence_number);
            o_prot.write_message_begin(&message_ident)?;
            thrift::Error::write_application_error_to_out_protocol(&ret_err, o_prot)?;
            o_prot.write_message_end()?;
            o_prot.flush()
          },
        }
      },
    }
  }
  pub fn process_is_table_enabled<H: HbaseSyncHandler>(handler: &H, incoming_sequence_number: i32, i_prot: &mut dyn TInputProtocol, o_prot: &mut dyn TOutputProtocol) -> thrift::Result<()> {
    let args = HbaseIsTableEnabledArgs::read_from_in_protocol(i_prot)?;
    match handler.handle_is_table_enabled(args.table_name) {
      Ok(handler_return) => {
        let message_ident = TMessageIdentifier::new("isTableEnabled", TMessageType::Reply, incoming_sequence_number);
        o_prot.write_message_begin(&message_ident)?;
        let ret = HbaseIsTableEnabledResult { result_value: Some(handler_return), io: None };
        ret.write_to_out_protocol(o_prot)?;
        o_prot.write_message_end()?;
        o_prot.flush()
      },
      Err(e) => {
        match e {
          thrift::Error::User(usr_err) => {
            if usr_err.downcast_ref::<IOError>().is_some() {
              let err = usr_err.downcast::<IOError>().expect("downcast already checked");
              let ret_err = HbaseIsTableEnabledResult{ result_value: None, io: Some(*err) };
              let message_ident = TMessageIdentifier::new("isTableEnabled", TMessageType::Reply, incoming_sequence_number);
              o_prot.write_message_begin(&message_ident)?;
              ret_err.write_to_out_protocol(o_prot)?;
              o_prot.write_message_end()?;
              o_prot.flush()
            } else {
              let ret_err = {
                ApplicationError::new(
                  ApplicationErrorKind::Unknown,
                  usr_err.to_string()
                )
              };
              let message_ident = TMessageIdentifier::new("isTableEnabled", TMessageType::Exception, incoming_sequence_number);
              o_prot.write_message_begin(&message_ident)?;
              thrift::Error::write_application_error_to_out_protocol(&ret_err, o_prot)?;
              o_prot.write_message_end()?;
              o_prot.flush()
            }
          },
          thrift::Error::Application(app_err) => {
            let message_ident = TMessageIdentifier::new("isTableEnabled", TMessageType::Exception, incoming_sequence_number);
            o_prot.write_message_begin(&message_ident)?;
            thrift::Error::write_application_error_to_out_protocol(&app_err, o_prot)?;
            o_prot.write_message_end()?;
            o_prot.flush()
          },
          _ => {
            let ret_err = {
              ApplicationError::new(
                ApplicationErrorKind::Unknown,
                e.to_string()
              )
            };
            let message_ident = TMessageIdentifier::new("isTableEnabled", TMessageType::Exception, incoming_sequence_number);
            o_prot.write_message_begin(&message_ident)?;
            thrift::Error::write_application_error_to_out_protocol(&ret_err, o_prot)?;
            o_prot.write_message_end()?;
            o_prot.flush()
          },
        }
      },
    }
  }
  pub fn process_compact<H: HbaseSyncHandler>(handler: &H, incoming_sequence_number: i32, i_prot: &mut dyn TInputProtocol, o_prot: &mut dyn TOutputProtocol) -> thrift::Result<()> {
    let args = HbaseCompactArgs::read_from_in_protocol(i_prot)?;
    match handler.handle_compact(args.table_name_or_region_name) {
      Ok(_) => {
        let message_ident = TMessageIdentifier::new("compact", TMessageType::Reply, incoming_sequence_number);
        o_prot.write_message_begin(&message_ident)?;
        let ret = HbaseCompactResult { io: None };
        ret.write_to_out_protocol(o_prot)?;
        o_prot.write_message_end()?;
        o_prot.flush()
      },
      Err(e) => {
        match e {
          thrift::Error::User(usr_err) => {
            if usr_err.downcast_ref::<IOError>().is_some() {
              let err = usr_err.downcast::<IOError>().expect("downcast already checked");
              let ret_err = HbaseCompactResult{ io: Some(*err) };
              let message_ident = TMessageIdentifier::new("compact", TMessageType::Reply, incoming_sequence_number);
              o_prot.write_message_begin(&message_ident)?;
              ret_err.write_to_out_protocol(o_prot)?;
              o_prot.write_message_end()?;
              o_prot.flush()
            } else {
              let ret_err = {
                ApplicationError::new(
                  ApplicationErrorKind::Unknown,
                  usr_err.to_string()
                )
              };
              let message_ident = TMessageIdentifier::new("compact", TMessageType::Exception, incoming_sequence_number);
              o_prot.write_message_begin(&message_ident)?;
              thrift::Error::write_application_error_to_out_protocol(&ret_err, o_prot)?;
              o_prot.write_message_end()?;
              o_prot.flush()
            }
          },
          thrift::Error::Application(app_err) => {
            let message_ident = TMessageIdentifier::new("compact", TMessageType::Exception, incoming_sequence_number);
            o_prot.write_message_begin(&message_ident)?;
            thrift::Error::write_application_error_to_out_protocol(&app_err, o_prot)?;
            o_prot.write_message_end()?;
            o_prot.flush()
          },
          _ => {
            let ret_err = {
              ApplicationError::new(
                ApplicationErrorKind::Unknown,
                e.to_string()
              )
            };
            let message_ident = TMessageIdentifier::new("compact", TMessageType::Exception, incoming_sequence_number);
            o_prot.write_message_begin(&message_ident)?;
            thrift::Error::write_application_error_to_out_protocol(&ret_err, o_prot)?;
            o_prot.write_message_end()?;
            o_prot.flush()
          },
        }
      },
    }
  }
  pub fn process_major_compact<H: HbaseSyncHandler>(handler: &H, incoming_sequence_number: i32, i_prot: &mut dyn TInputProtocol, o_prot: &mut dyn TOutputProtocol) -> thrift::Result<()> {
    let args = HbaseMajorCompactArgs::read_from_in_protocol(i_prot)?;
    match handler.handle_major_compact(args.table_name_or_region_name) {
      Ok(_) => {
        let message_ident = TMessageIdentifier::new("majorCompact", TMessageType::Reply, incoming_sequence_number);
        o_prot.write_message_begin(&message_ident)?;
        let ret = HbaseMajorCompactResult { io: None };
        ret.write_to_out_protocol(o_prot)?;
        o_prot.write_message_end()?;
        o_prot.flush()
      },
      Err(e) => {
        match e {
          thrift::Error::User(usr_err) => {
            if usr_err.downcast_ref::<IOError>().is_some() {
              let err = usr_err.downcast::<IOError>().expect("downcast already checked");
              let ret_err = HbaseMajorCompactResult{ io: Some(*err) };
              let message_ident = TMessageIdentifier::new("majorCompact", TMessageType::Reply, incoming_sequence_number);
              o_prot.write_message_begin(&message_ident)?;
              ret_err.write_to_out_protocol(o_prot)?;
              o_prot.write_message_end()?;
              o_prot.flush()
            } else {
              let ret_err = {
                ApplicationError::new(
                  ApplicationErrorKind::Unknown,
                  usr_err.to_string()
                )
              };
              let message_ident = TMessageIdentifier::new("majorCompact", TMessageType::Exception, incoming_sequence_number);
              o_prot.write_message_begin(&message_ident)?;
              thrift::Error::write_application_error_to_out_protocol(&ret_err, o_prot)?;
              o_prot.write_message_end()?;
              o_prot.flush()
            }
          },
          thrift::Error::Application(app_err) => {
            let message_ident = TMessageIdentifier::new("majorCompact", TMessageType::Exception, incoming_sequence_number);
            o_prot.write_message_begin(&message_ident)?;
            thrift::Error::write_application_error_to_out_protocol(&app_err, o_prot)?;
            o_prot.write_message_end()?;
            o_prot.flush()
          },
          _ => {
            let ret_err = {
              ApplicationError::new(
                ApplicationErrorKind::Unknown,
                e.to_string()
              )
            };
            let message_ident = TMessageIdentifier::new("majorCompact", TMessageType::Exception, incoming_sequence_number);
            o_prot.write_message_begin(&message_ident)?;
            thrift::Error::write_application_error_to_out_protocol(&ret_err, o_prot)?;
            o_prot.write_message_end()?;
            o_prot.flush()
          },
        }
      },
    }
  }
  pub fn process_get_table_names<H: HbaseSyncHandler>(handler: &H, incoming_sequence_number: i32, i_prot: &mut dyn TInputProtocol, o_prot: &mut dyn TOutputProtocol) -> thrift::Result<()> {
    let _ = HbaseGetTableNamesArgs::read_from_in_protocol(i_prot)?;
    match handler.handle_get_table_names() {
      Ok(handler_return) => {
        let message_ident = TMessageIdentifier::new("getTableNames", TMessageType::Reply, incoming_sequence_number);
        o_prot.write_message_begin(&message_ident)?;
        let ret = HbaseGetTableNamesResult { result_value: Some(handler_return), io: None };
        ret.write_to_out_protocol(o_prot)?;
        o_prot.write_message_end()?;
        o_prot.flush()
      },
      Err(e) => {
        match e {
          thrift::Error::User(usr_err) => {
            if usr_err.downcast_ref::<IOError>().is_some() {
              let err = usr_err.downcast::<IOError>().expect("downcast already checked");
              let ret_err = HbaseGetTableNamesResult{ result_value: None, io: Some(*err) };
              let message_ident = TMessageIdentifier::new("getTableNames", TMessageType::Reply, incoming_sequence_number);
              o_prot.write_message_begin(&message_ident)?;
              ret_err.write_to_out_protocol(o_prot)?;
              o_prot.write_message_end()?;
              o_prot.flush()
            } else {
              let ret_err = {
                ApplicationError::new(
                  ApplicationErrorKind::Unknown,
                  usr_err.to_string()
                )
              };
              let message_ident = TMessageIdentifier::new("getTableNames", TMessageType::Exception, incoming_sequence_number);
              o_prot.write_message_begin(&message_ident)?;
              thrift::Error::write_application_error_to_out_protocol(&ret_err, o_prot)?;
              o_prot.write_message_end()?;
              o_prot.flush()
            }
          },
          thrift::Error::Application(app_err) => {
            let message_ident = TMessageIdentifier::new("getTableNames", TMessageType::Exception, incoming_sequence_number);
            o_prot.write_message_begin(&message_ident)?;
            thrift::Error::write_application_error_to_out_protocol(&app_err, o_prot)?;
            o_prot.write_message_end()?;
            o_prot.flush()
          },
          _ => {
            let ret_err = {
              ApplicationError::new(
                ApplicationErrorKind::Unknown,
                e.to_string()
              )
            };
            let message_ident = TMessageIdentifier::new("getTableNames", TMessageType::Exception, incoming_sequence_number);
            o_prot.write_message_begin(&message_ident)?;
            thrift::Error::write_application_error_to_out_protocol(&ret_err, o_prot)?;
            o_prot.write_message_end()?;
            o_prot.flush()
          },
        }
      },
    }
  }
  pub fn process_get_table_names_with_is_table_enabled<H: HbaseSyncHandler>(handler: &H, incoming_sequence_number: i32, i_prot: &mut dyn TInputProtocol, o_prot: &mut dyn TOutputProtocol) -> thrift::Result<()> {
    let _ = HbaseGetTableNamesWithIsTableEnabledArgs::read_from_in_protocol(i_prot)?;
    match handler.handle_get_table_names_with_is_table_enabled() {
      Ok(handler_return) => {
        let message_ident = TMessageIdentifier::new("getTableNamesWithIsTableEnabled", TMessageType::Reply, incoming_sequence_number);
        o_prot.write_message_begin(&message_ident)?;
        let ret = HbaseGetTableNamesWithIsTableEnabledResult { result_value: Some(handler_return), io: None };
        ret.write_to_out_protocol(o_prot)?;
        o_prot.write_message_end()?;
        o_prot.flush()
      },
      Err(e) => {
        match e {
          thrift::Error::User(usr_err) => {
            if usr_err.downcast_ref::<IOError>().is_some() {
              let err = usr_err.downcast::<IOError>().expect("downcast already checked");
              let ret_err = HbaseGetTableNamesWithIsTableEnabledResult{ result_value: None, io: Some(*err) };
              let message_ident = TMessageIdentifier::new("getTableNamesWithIsTableEnabled", TMessageType::Reply, incoming_sequence_number);
              o_prot.write_message_begin(&message_ident)?;
              ret_err.write_to_out_protocol(o_prot)?;
              o_prot.write_message_end()?;
              o_prot.flush()
            } else {
              let ret_err = {
                ApplicationError::new(
                  ApplicationErrorKind::Unknown,
                  usr_err.to_string()
                )
              };
              let message_ident = TMessageIdentifier::new("getTableNamesWithIsTableEnabled", TMessageType::Exception, incoming_sequence_number);
              o_prot.write_message_begin(&message_ident)?;
              thrift::Error::write_application_error_to_out_protocol(&ret_err, o_prot)?;
              o_prot.write_message_end()?;
              o_prot.flush()
            }
          },
          thrift::Error::Application(app_err) => {
            let message_ident = TMessageIdentifier::new("getTableNamesWithIsTableEnabled", TMessageType::Exception, incoming_sequence_number);
            o_prot.write_message_begin(&message_ident)?;
            thrift::Error::write_application_error_to_out_protocol(&app_err, o_prot)?;
            o_prot.write_message_end()?;
            o_prot.flush()
          },
          _ => {
            let ret_err = {
              ApplicationError::new(
                ApplicationErrorKind::Unknown,
                e.to_string()
              )
            };
            let message_ident = TMessageIdentifier::new("getTableNamesWithIsTableEnabled", TMessageType::Exception, incoming_sequence_number);
            o_prot.write_message_begin(&message_ident)?;
            thrift::Error::write_application_error_to_out_protocol(&ret_err, o_prot)?;
            o_prot.write_message_end()?;
            o_prot.flush()
          },
        }
      },
    }
  }
  pub fn process_get_column_descriptors<H: HbaseSyncHandler>(handler: &H, incoming_sequence_number: i32, i_prot: &mut dyn TInputProtocol, o_prot: &mut dyn TOutputProtocol) -> thrift::Result<()> {
    let args = HbaseGetColumnDescriptorsArgs::read_from_in_protocol(i_prot)?;
    match handler.handle_get_column_descriptors(args.table_name) {
      Ok(handler_return) => {
        let message_ident = TMessageIdentifier::new("getColumnDescriptors", TMessageType::Reply, incoming_sequence_number);
        o_prot.write_message_begin(&message_ident)?;
        let ret = HbaseGetColumnDescriptorsResult { result_value: Some(handler_return), io: None };
        ret.write_to_out_protocol(o_prot)?;
        o_prot.write_message_end()?;
        o_prot.flush()
      },
      Err(e) => {
        match e {
          thrift::Error::User(usr_err) => {
            if usr_err.downcast_ref::<IOError>().is_some() {
              let err = usr_err.downcast::<IOError>().expect("downcast already checked");
              let ret_err = HbaseGetColumnDescriptorsResult{ result_value: None, io: Some(*err) };
              let message_ident = TMessageIdentifier::new("getColumnDescriptors", TMessageType::Reply, incoming_sequence_number);
              o_prot.write_message_begin(&message_ident)?;
              ret_err.write_to_out_protocol(o_prot)?;
              o_prot.write_message_end()?;
              o_prot.flush()
            } else {
              let ret_err = {
                ApplicationError::new(
                  ApplicationErrorKind::Unknown,
                  usr_err.to_string()
                )
              };
              let message_ident = TMessageIdentifier::new("getColumnDescriptors", TMessageType::Exception, incoming_sequence_number);
              o_prot.write_message_begin(&message_ident)?;
              thrift::Error::write_application_error_to_out_protocol(&ret_err, o_prot)?;
              o_prot.write_message_end()?;
              o_prot.flush()
            }
          },
          thrift::Error::Application(app_err) => {
            let message_ident = TMessageIdentifier::new("getColumnDescriptors", TMessageType::Exception, incoming_sequence_number);
            o_prot.write_message_begin(&message_ident)?;
            thrift::Error::write_application_error_to_out_protocol(&app_err, o_prot)?;
            o_prot.write_message_end()?;
            o_prot.flush()
          },
          _ => {
            let ret_err = {
              ApplicationError::new(
                ApplicationErrorKind::Unknown,
                e.to_string()
              )
            };
            let message_ident = TMessageIdentifier::new("getColumnDescriptors", TMessageType::Exception, incoming_sequence_number);
            o_prot.write_message_begin(&message_ident)?;
            thrift::Error::write_application_error_to_out_protocol(&ret_err, o_prot)?;
            o_prot.write_message_end()?;
            o_prot.flush()
          },
        }
      },
    }
  }
  pub fn process_get_table_regions<H: HbaseSyncHandler>(handler: &H, incoming_sequence_number: i32, i_prot: &mut dyn TInputProtocol, o_prot: &mut dyn TOutputProtocol) -> thrift::Result<()> {
    let args = HbaseGetTableRegionsArgs::read_from_in_protocol(i_prot)?;
    match handler.handle_get_table_regions(args.table_name) {
      Ok(handler_return) => {
        let message_ident = TMessageIdentifier::new("getTableRegions", TMessageType::Reply, incoming_sequence_number);
        o_prot.write_message_begin(&message_ident)?;
        let ret = HbaseGetTableRegionsResult { result_value: Some(handler_return), io: None };
        ret.write_to_out_protocol(o_prot)?;
        o_prot.write_message_end()?;
        o_prot.flush()
      },
      Err(e) => {
        match e {
          thrift::Error::User(usr_err) => {
            if usr_err.downcast_ref::<IOError>().is_some() {
              let err = usr_err.downcast::<IOError>().expect("downcast already checked");
              let ret_err = HbaseGetTableRegionsResult{ result_value: None, io: Some(*err) };
              let message_ident = TMessageIdentifier::new("getTableRegions", TMessageType::Reply, incoming_sequence_number);
              o_prot.write_message_begin(&message_ident)?;
              ret_err.write_to_out_protocol(o_prot)?;
              o_prot.write_message_end()?;
              o_prot.flush()
            } else {
              let ret_err = {
                ApplicationError::new(
                  ApplicationErrorKind::Unknown,
                  usr_err.to_string()
                )
              };
              let message_ident = TMessageIdentifier::new("getTableRegions", TMessageType::Exception, incoming_sequence_number);
              o_prot.write_message_begin(&message_ident)?;
              thrift::Error::write_application_error_to_out_protocol(&ret_err, o_prot)?;
              o_prot.write_message_end()?;
              o_prot.flush()
            }
          },
          thrift::Error::Application(app_err) => {
            let message_ident = TMessageIdentifier::new("getTableRegions", TMessageType::Exception, incoming_sequence_number);
            o_prot.write_message_begin(&message_ident)?;
            thrift::Error::write_application_error_to_out_protocol(&app_err, o_prot)?;
            o_prot.write_message_end()?;
            o_prot.flush()
          },
          _ => {
            let ret_err = {
              ApplicationError::new(
                ApplicationErrorKind::Unknown,
                e.to_string()
              )
            };
            let message_ident = TMessageIdentifier::new("getTableRegions", TMessageType::Exception, incoming_sequence_number);
            o_prot.write_message_begin(&message_ident)?;
            thrift::Error::write_application_error_to_out_protocol(&ret_err, o_prot)?;
            o_prot.write_message_end()?;
            o_prot.flush()
          },
        }
      },
    }
  }
  pub fn process_create_table<H: HbaseSyncHandler>(handler: &H, incoming_sequence_number: i32, i_prot: &mut dyn TInputProtocol, o_prot: &mut dyn TOutputProtocol) -> thrift::Result<()> {
    let args = HbaseCreateTableArgs::read_from_in_protocol(i_prot)?;
    match handler.handle_create_table(args.table_name, args.column_families) {
      Ok(_) => {
        let message_ident = TMessageIdentifier::new("createTable", TMessageType::Reply, incoming_sequence_number);
        o_prot.write_message_begin(&message_ident)?;
        let ret = HbaseCreateTableResult { io: None, ia: None, exist: None };
        ret.write_to_out_protocol(o_prot)?;
        o_prot.write_message_end()?;
        o_prot.flush()
      },
      Err(e) => {
        match e {
          thrift::Error::User(usr_err) => {
            if usr_err.downcast_ref::<IOError>().is_some() {
              let err = usr_err.downcast::<IOError>().expect("downcast already checked");
              let ret_err = HbaseCreateTableResult{ io: Some(*err), ia: None, exist: None };
              let message_ident = TMessageIdentifier::new("createTable", TMessageType::Reply, incoming_sequence_number);
              o_prot.write_message_begin(&message_ident)?;
              ret_err.write_to_out_protocol(o_prot)?;
              o_prot.write_message_end()?;
              o_prot.flush()
            } else if usr_err.downcast_ref::<IllegalArgument>().is_some() {
              let err = usr_err.downcast::<IllegalArgument>().expect("downcast already checked");
              let ret_err = HbaseCreateTableResult{ io: None, ia: Some(*err), exist: None };
              let message_ident = TMessageIdentifier::new("createTable", TMessageType::Reply, incoming_sequence_number);
              o_prot.write_message_begin(&message_ident)?;
              ret_err.write_to_out_protocol(o_prot)?;
              o_prot.write_message_end()?;
              o_prot.flush()
            } else if usr_err.downcast_ref::<AlreadyExists>().is_some() {
              let err = usr_err.downcast::<AlreadyExists>().expect("downcast already checked");
              let ret_err = HbaseCreateTableResult{ io: None, ia: None, exist: Some(*err) };
              let message_ident = TMessageIdentifier::new("createTable", TMessageType::Reply, incoming_sequence_number);
              o_prot.write_message_begin(&message_ident)?;
              ret_err.write_to_out_protocol(o_prot)?;
              o_prot.write_message_end()?;
              o_prot.flush()
            } else {
              let ret_err = {
                ApplicationError::new(
                  ApplicationErrorKind::Unknown,
                  usr_err.to_string()
                )
              };
              let message_ident = TMessageIdentifier::new("createTable", TMessageType::Exception, incoming_sequence_number);
              o_prot.write_message_begin(&message_ident)?;
              thrift::Error::write_application_error_to_out_protocol(&ret_err, o_prot)?;
              o_prot.write_message_end()?;
              o_prot.flush()
            }
          },
          thrift::Error::Application(app_err) => {
            let message_ident = TMessageIdentifier::new("createTable", TMessageType::Exception, incoming_sequence_number);
            o_prot.write_message_begin(&message_ident)?;
            thrift::Error::write_application_error_to_out_protocol(&app_err, o_prot)?;
            o_prot.write_message_end()?;
            o_prot.flush()
          },
          _ => {
            let ret_err = {
              ApplicationError::new(
                ApplicationErrorKind::Unknown,
                e.to_string()
              )
            };
            let message_ident = TMessageIdentifier::new("createTable", TMessageType::Exception, incoming_sequence_number);
            o_prot.write_message_begin(&message_ident)?;
            thrift::Error::write_application_error_to_out_protocol(&ret_err, o_prot)?;
            o_prot.write_message_end()?;
            o_prot.flush()
          },
        }
      },
    }
  }
  pub fn process_delete_table<H: HbaseSyncHandler>(handler: &H, incoming_sequence_number: i32, i_prot: &mut dyn TInputProtocol, o_prot: &mut dyn TOutputProtocol) -> thrift::Result<()> {
    let args = HbaseDeleteTableArgs::read_from_in_protocol(i_prot)?;
    match handler.handle_delete_table(args.table_name) {
      Ok(_) => {
        let message_ident = TMessageIdentifier::new("deleteTable", TMessageType::Reply, incoming_sequence_number);
        o_prot.write_message_begin(&message_ident)?;
        let ret = HbaseDeleteTableResult { io: None };
        ret.write_to_out_protocol(o_prot)?;
        o_prot.write_message_end()?;
        o_prot.flush()
      },
      Err(e) => {
        match e {
          thrift::Error::User(usr_err) => {
            if usr_err.downcast_ref::<IOError>().is_some() {
              let err = usr_err.downcast::<IOError>().expect("downcast already checked");
              let ret_err = HbaseDeleteTableResult{ io: Some(*err) };
              let message_ident = TMessageIdentifier::new("deleteTable", TMessageType::Reply, incoming_sequence_number);
              o_prot.write_message_begin(&message_ident)?;
              ret_err.write_to_out_protocol(o_prot)?;
              o_prot.write_message_end()?;
              o_prot.flush()
            } else {
              let ret_err = {
                ApplicationError::new(
                  ApplicationErrorKind::Unknown,
                  usr_err.to_string()
                )
              };
              let message_ident = TMessageIdentifier::new("deleteTable", TMessageType::Exception, incoming_sequence_number);
              o_prot.write_message_begin(&message_ident)?;
              thrift::Error::write_application_error_to_out_protocol(&ret_err, o_prot)?;
              o_prot.write_message_end()?;
              o_prot.flush()
            }
          },
          thrift::Error::Application(app_err) => {
            let message_ident = TMessageIdentifier::new("deleteTable", TMessageType::Exception, incoming_sequence_number);
            o_prot.write_message_begin(&message_ident)?;
            thrift::Error::write_application_error_to_out_protocol(&app_err, o_prot)?;
            o_prot.write_message_end()?;
            o_prot.flush()
          },
          _ => {
            let ret_err = {
              ApplicationError::new(
                ApplicationErrorKind::Unknown,
                e.to_string()
              )
            };
            let message_ident = TMessageIdentifier::new("deleteTable", TMessageType::Exception, incoming_sequence_number);
            o_prot.write_message_begin(&message_ident)?;
            thrift::Error::write_application_error_to_out_protocol(&ret_err, o_prot)?;
            o_prot.write_message_end()?;
            o_prot.flush()
          },
        }
      },
    }
  }
  pub fn process_get<H: HbaseSyncHandler>(handler: &H, incoming_sequence_number: i32, i_prot: &mut dyn TInputProtocol, o_prot: &mut dyn TOutputProtocol) -> thrift::Result<()> {
    let args = HbaseGetArgs::read_from_in_protocol(i_prot)?;
    match handler.handle_get(args.table_name, args.row, args.column, args.attributes) {
      Ok(handler_return) => {
        let message_ident = TMessageIdentifier::new("get", TMessageType::Reply, incoming_sequence_number);
        o_prot.write_message_begin(&message_ident)?;
        let ret = HbaseGetResult { result_value: Some(handler_return), io: None };
        ret.write_to_out_protocol(o_prot)?;
        o_prot.write_message_end()?;
        o_prot.flush()
      },
      Err(e) => {
        match e {
          thrift::Error::User(usr_err) => {
            if usr_err.downcast_ref::<IOError>().is_some() {
              let err = usr_err.downcast::<IOError>().expect("downcast already checked");
              let ret_err = HbaseGetResult{ result_value: None, io: Some(*err) };
              let message_ident = TMessageIdentifier::new("get", TMessageType::Reply, incoming_sequence_number);
              o_prot.write_message_begin(&message_ident)?;
              ret_err.write_to_out_protocol(o_prot)?;
              o_prot.write_message_end()?;
              o_prot.flush()
            } else {
              let ret_err = {
                ApplicationError::new(
                  ApplicationErrorKind::Unknown,
                  usr_err.to_string()
                )
              };
              let message_ident = TMessageIdentifier::new("get", TMessageType::Exception, incoming_sequence_number);
              o_prot.write_message_begin(&message_ident)?;
              thrift::Error::write_application_error_to_out_protocol(&ret_err, o_prot)?;
              o_prot.write_message_end()?;
              o_prot.flush()
            }
          },
          thrift::Error::Application(app_err) => {
            let message_ident = TMessageIdentifier::new("get", TMessageType::Exception, incoming_sequence_number);
            o_prot.write_message_begin(&message_ident)?;
            thrift::Error::write_application_error_to_out_protocol(&app_err, o_prot)?;
            o_prot.write_message_end()?;
            o_prot.flush()
          },
          _ => {
            let ret_err = {
              ApplicationError::new(
                ApplicationErrorKind::Unknown,
                e.to_string()
              )
            };
            let message_ident = TMessageIdentifier::new("get", TMessageType::Exception, incoming_sequence_number);
            o_prot.write_message_begin(&message_ident)?;
            thrift::Error::write_application_error_to_out_protocol(&ret_err, o_prot)?;
            o_prot.write_message_end()?;
            o_prot.flush()
          },
        }
      },
    }
  }
  pub fn process_get_ver<H: HbaseSyncHandler>(handler: &H, incoming_sequence_number: i32, i_prot: &mut dyn TInputProtocol, o_prot: &mut dyn TOutputProtocol) -> thrift::Result<()> {
    let args = HbaseGetVerArgs::read_from_in_protocol(i_prot)?;
    match handler.handle_get_ver(args.table_name, args.row, args.column, args.num_versions, args.attributes) {
      Ok(handler_return) => {
        let message_ident = TMessageIdentifier::new("getVer", TMessageType::Reply, incoming_sequence_number);
        o_prot.write_message_begin(&message_ident)?;
        let ret = HbaseGetVerResult { result_value: Some(handler_return), io: None };
        ret.write_to_out_protocol(o_prot)?;
        o_prot.write_message_end()?;
        o_prot.flush()
      },
      Err(e) => {
        match e {
          thrift::Error::User(usr_err) => {
            if usr_err.downcast_ref::<IOError>().is_some() {
              let err = usr_err.downcast::<IOError>().expect("downcast already checked");
              let ret_err = HbaseGetVerResult{ result_value: None, io: Some(*err) };
              let message_ident = TMessageIdentifier::new("getVer", TMessageType::Reply, incoming_sequence_number);
              o_prot.write_message_begin(&message_ident)?;
              ret_err.write_to_out_protocol(o_prot)?;
              o_prot.write_message_end()?;
              o_prot.flush()
            } else {
              let ret_err = {
                ApplicationError::new(
                  ApplicationErrorKind::Unknown,
                  usr_err.to_string()
                )
              };
              let message_ident = TMessageIdentifier::new("getVer", TMessageType::Exception, incoming_sequence_number);
              o_prot.write_message_begin(&message_ident)?;
              thrift::Error::write_application_error_to_out_protocol(&ret_err, o_prot)?;
              o_prot.write_message_end()?;
              o_prot.flush()
            }
          },
          thrift::Error::Application(app_err) => {
            let message_ident = TMessageIdentifier::new("getVer", TMessageType::Exception, incoming_sequence_number);
            o_prot.write_message_begin(&message_ident)?;
            thrift::Error::write_application_error_to_out_protocol(&app_err, o_prot)?;
            o_prot.write_message_end()?;
            o_prot.flush()
          },
          _ => {
            let ret_err = {
              ApplicationError::new(
                ApplicationErrorKind::Unknown,
                e.to_string()
              )
            };
            let message_ident = TMessageIdentifier::new("getVer", TMessageType::Exception, incoming_sequence_number);
            o_prot.write_message_begin(&message_ident)?;
            thrift::Error::write_application_error_to_out_protocol(&ret_err, o_prot)?;
            o_prot.write_message_end()?;
            o_prot.flush()
          },
        }
      },
    }
  }
  pub fn process_get_ver_ts<H: HbaseSyncHandler>(handler: &H, incoming_sequence_number: i32, i_prot: &mut dyn TInputProtocol, o_prot: &mut dyn TOutputProtocol) -> thrift::Result<()> {
    let args = HbaseGetVerTsArgs::read_from_in_protocol(i_prot)?;
    match handler.handle_get_ver_ts(args.table_name, args.row, args.column, args.timestamp, args.num_versions, args.attributes) {
      Ok(handler_return) => {
        let message_ident = TMessageIdentifier::new("getVerTs", TMessageType::Reply, incoming_sequence_number);
        o_prot.write_message_begin(&message_ident)?;
        let ret = HbaseGetVerTsResult { result_value: Some(handler_return), io: None };
        ret.write_to_out_protocol(o_prot)?;
        o_prot.write_message_end()?;
        o_prot.flush()
      },
      Err(e) => {
        match e {
          thrift::Error::User(usr_err) => {
            if usr_err.downcast_ref::<IOError>().is_some() {
              let err = usr_err.downcast::<IOError>().expect("downcast already checked");
              let ret_err = HbaseGetVerTsResult{ result_value: None, io: Some(*err) };
              let message_ident = TMessageIdentifier::new("getVerTs", TMessageType::Reply, incoming_sequence_number);
              o_prot.write_message_begin(&message_ident)?;
              ret_err.write_to_out_protocol(o_prot)?;
              o_prot.write_message_end()?;
              o_prot.flush()
            } else {
              let ret_err = {
                ApplicationError::new(
                  ApplicationErrorKind::Unknown,
                  usr_err.to_string()
                )
              };
              let message_ident = TMessageIdentifier::new("getVerTs", TMessageType::Exception, incoming_sequence_number);
              o_prot.write_message_begin(&message_ident)?;
              thrift::Error::write_application_error_to_out_protocol(&ret_err, o_prot)?;
              o_prot.write_message_end()?;
              o_prot.flush()
            }
          },
          thrift::Error::Application(app_err) => {
            let message_ident = TMessageIdentifier::new("getVerTs", TMessageType::Exception, incoming_sequence_number);
            o_prot.write_message_begin(&message_ident)?;
            thrift::Error::write_application_error_to_out_protocol(&app_err, o_prot)?;
            o_prot.write_message_end()?;
            o_prot.flush()
          },
          _ => {
            let ret_err = {
              ApplicationError::new(
                ApplicationErrorKind::Unknown,
                e.to_string()
              )
            };
            let message_ident = TMessageIdentifier::new("getVerTs", TMessageType::Exception, incoming_sequence_number);
            o_prot.write_message_begin(&message_ident)?;
            thrift::Error::write_application_error_to_out_protocol(&ret_err, o_prot)?;
            o_prot.write_message_end()?;
            o_prot.flush()
          },
        }
      },
    }
  }
  pub fn process_get_row<H: HbaseSyncHandler>(handler: &H, incoming_sequence_number: i32, i_prot: &mut dyn TInputProtocol, o_prot: &mut dyn TOutputProtocol) -> thrift::Result<()> {
    let args = HbaseGetRowArgs::read_from_in_protocol(i_prot)?;
    match handler.handle_get_row(args.table_name, args.row, args.attributes) {
      Ok(handler_return) => {
        let message_ident = TMessageIdentifier::new("getRow", TMessageType::Reply, incoming_sequence_number);
        o_prot.write_message_begin(&message_ident)?;
        let ret = HbaseGetRowResult { result_value: Some(handler_return), io: None };
        ret.write_to_out_protocol(o_prot)?;
        o_prot.write_message_end()?;
        o_prot.flush()
      },
      Err(e) => {
        match e {
          thrift::Error::User(usr_err) => {
            if usr_err.downcast_ref::<IOError>().is_some() {
              let err = usr_err.downcast::<IOError>().expect("downcast already checked");
              let ret_err = HbaseGetRowResult{ result_value: None, io: Some(*err) };
              let message_ident = TMessageIdentifier::new("getRow", TMessageType::Reply, incoming_sequence_number);
              o_prot.write_message_begin(&message_ident)?;
              ret_err.write_to_out_protocol(o_prot)?;
              o_prot.write_message_end()?;
              o_prot.flush()
            } else {
              let ret_err = {
                ApplicationError::new(
                  ApplicationErrorKind::Unknown,
                  usr_err.to_string()
                )
              };
              let message_ident = TMessageIdentifier::new("getRow", TMessageType::Exception, incoming_sequence_number);
              o_prot.write_message_begin(&message_ident)?;
              thrift::Error::write_application_error_to_out_protocol(&ret_err, o_prot)?;
              o_prot.write_message_end()?;
              o_prot.flush()
            }
          },
          thrift::Error::Application(app_err) => {
            let message_ident = TMessageIdentifier::new("getRow", TMessageType::Exception, incoming_sequence_number);
            o_prot.write_message_begin(&message_ident)?;
            thrift::Error::write_application_error_to_out_protocol(&app_err, o_prot)?;
            o_prot.write_message_end()?;
            o_prot.flush()
          },
          _ => {
            let ret_err = {
              ApplicationError::new(
                ApplicationErrorKind::Unknown,
                e.to_string()
              )
            };
            let message_ident = TMessageIdentifier::new("getRow", TMessageType::Exception, incoming_sequence_number);
            o_prot.write_message_begin(&message_ident)?;
            thrift::Error::write_application_error_to_out_protocol(&ret_err, o_prot)?;
            o_prot.write_message_end()?;
            o_prot.flush()
          },
        }
      },
    }
  }
  pub fn process_get_row_with_columns<H: HbaseSyncHandler>(handler: &H, incoming_sequence_number: i32, i_prot: &mut dyn TInputProtocol, o_prot: &mut dyn TOutputProtocol) -> thrift::Result<()> {
    let args = HbaseGetRowWithColumnsArgs::read_from_in_protocol(i_prot)?;
    match handler.handle_get_row_with_columns(args.table_name, args.row, args.columns, args.attributes) {
      Ok(handler_return) => {
        let message_ident = TMessageIdentifier::new("getRowWithColumns", TMessageType::Reply, incoming_sequence_number);
        o_prot.write_message_begin(&message_ident)?;
        let ret = HbaseGetRowWithColumnsResult { result_value: Some(handler_return), io: None };
        ret.write_to_out_protocol(o_prot)?;
        o_prot.write_message_end()?;
        o_prot.flush()
      },
      Err(e) => {
        match e {
          thrift::Error::User(usr_err) => {
            if usr_err.downcast_ref::<IOError>().is_some() {
              let err = usr_err.downcast::<IOError>().expect("downcast already checked");
              let ret_err = HbaseGetRowWithColumnsResult{ result_value: None, io: Some(*err) };
              let message_ident = TMessageIdentifier::new("getRowWithColumns", TMessageType::Reply, incoming_sequence_number);
              o_prot.write_message_begin(&message_ident)?;
              ret_err.write_to_out_protocol(o_prot)?;
              o_prot.write_message_end()?;
              o_prot.flush()
            } else {
              let ret_err = {
                ApplicationError::new(
                  ApplicationErrorKind::Unknown,
                  usr_err.to_string()
                )
              };
              let message_ident = TMessageIdentifier::new("getRowWithColumns", TMessageType::Exception, incoming_sequence_number);
              o_prot.write_message_begin(&message_ident)?;
              thrift::Error::write_application_error_to_out_protocol(&ret_err, o_prot)?;
              o_prot.write_message_end()?;
              o_prot.flush()
            }
          },
          thrift::Error::Application(app_err) => {
            let message_ident = TMessageIdentifier::new("getRowWithColumns", TMessageType::Exception, incoming_sequence_number);
            o_prot.write_message_begin(&message_ident)?;
            thrift::Error::write_application_error_to_out_protocol(&app_err, o_prot)?;
            o_prot.write_message_end()?;
            o_prot.flush()
          },
          _ => {
            let ret_err = {
              ApplicationError::new(
                ApplicationErrorKind::Unknown,
                e.to_string()
              )
            };
            let message_ident = TMessageIdentifier::new("getRowWithColumns", TMessageType::Exception, incoming_sequence_number);
            o_prot.write_message_begin(&message_ident)?;
            thrift::Error::write_application_error_to_out_protocol(&ret_err, o_prot)?;
            o_prot.write_message_end()?;
            o_prot.flush()
          },
        }
      },
    }
  }
  pub fn process_get_row_ts<H: HbaseSyncHandler>(handler: &H, incoming_sequence_number: i32, i_prot: &mut dyn TInputProtocol, o_prot: &mut dyn TOutputProtocol) -> thrift::Result<()> {
    let args = HbaseGetRowTsArgs::read_from_in_protocol(i_prot)?;
    match handler.handle_get_row_ts(args.table_name, args.row, args.timestamp, args.attributes) {
      Ok(handler_return) => {
        let message_ident = TMessageIdentifier::new("getRowTs", TMessageType::Reply, incoming_sequence_number);
        o_prot.write_message_begin(&message_ident)?;
        let ret = HbaseGetRowTsResult { result_value: Some(handler_return), io: None };
        ret.write_to_out_protocol(o_prot)?;
        o_prot.write_message_end()?;
        o_prot.flush()
      },
      Err(e) => {
        match e {
          thrift::Error::User(usr_err) => {
            if usr_err.downcast_ref::<IOError>().is_some() {
              let err = usr_err.downcast::<IOError>().expect("downcast already checked");
              let ret_err = HbaseGetRowTsResult{ result_value: None, io: Some(*err) };
              let message_ident = TMessageIdentifier::new("getRowTs", TMessageType::Reply, incoming_sequence_number);
              o_prot.write_message_begin(&message_ident)?;
              ret_err.write_to_out_protocol(o_prot)?;
              o_prot.write_message_end()?;
              o_prot.flush()
            } else {
              let ret_err = {
                ApplicationError::new(
                  ApplicationErrorKind::Unknown,
                  usr_err.to_string()
                )
              };
              let message_ident = TMessageIdentifier::new("getRowTs", TMessageType::Exception, incoming_sequence_number);
              o_prot.write_message_begin(&message_ident)?;
              thrift::Error::write_application_error_to_out_protocol(&ret_err, o_prot)?;
              o_prot.write_message_end()?;
              o_prot.flush()
            }
          },
          thrift::Error::Application(app_err) => {
            let message_ident = TMessageIdentifier::new("getRowTs", TMessageType::Exception, incoming_sequence_number);
            o_prot.write_message_begin(&message_ident)?;
            thrift::Error::write_application_error_to_out_protocol(&app_err, o_prot)?;
            o_prot.write_message_end()?;
            o_prot.flush()
          },
          _ => {
            let ret_err = {
              ApplicationError::new(
                ApplicationErrorKind::Unknown,
                e.to_string()
              )
            };
            let message_ident = TMessageIdentifier::new("getRowTs", TMessageType::Exception, incoming_sequence_number);
            o_prot.write_message_begin(&message_ident)?;
            thrift::Error::write_application_error_to_out_protocol(&ret_err, o_prot)?;
            o_prot.write_message_end()?;
            o_prot.flush()
          },
        }
      },
    }
  }
  pub fn process_get_row_with_columns_ts<H: HbaseSyncHandler>(handler: &H, incoming_sequence_number: i32, i_prot: &mut dyn TInputProtocol, o_prot: &mut dyn TOutputProtocol) -> thrift::Result<()> {
    let args = HbaseGetRowWithColumnsTsArgs::read_from_in_protocol(i_prot)?;
    match handler.handle_get_row_with_columns_ts(args.table_name, args.row, args.columns, args.timestamp, args.attributes) {
      Ok(handler_return) => {
        let message_ident = TMessageIdentifier::new("getRowWithColumnsTs", TMessageType::Reply, incoming_sequence_number);
        o_prot.write_message_begin(&message_ident)?;
        let ret = HbaseGetRowWithColumnsTsResult { result_value: Some(handler_return), io: None };
        ret.write_to_out_protocol(o_prot)?;
        o_prot.write_message_end()?;
        o_prot.flush()
      },
      Err(e) => {
        match e {
          thrift::Error::User(usr_err) => {
            if usr_err.downcast_ref::<IOError>().is_some() {
              let err = usr_err.downcast::<IOError>().expect("downcast already checked");
              let ret_err = HbaseGetRowWithColumnsTsResult{ result_value: None, io: Some(*err) };
              let message_ident = TMessageIdentifier::new("getRowWithColumnsTs", TMessageType::Reply, incoming_sequence_number);
              o_prot.write_message_begin(&message_ident)?;
              ret_err.write_to_out_protocol(o_prot)?;
              o_prot.write_message_end()?;
              o_prot.flush()
            } else {
              let ret_err = {
                ApplicationError::new(
                  ApplicationErrorKind::Unknown,
                  usr_err.to_string()
                )
              };
              let message_ident = TMessageIdentifier::new("getRowWithColumnsTs", TMessageType::Exception, incoming_sequence_number);
              o_prot.write_message_begin(&message_ident)?;
              thrift::Error::write_application_error_to_out_protocol(&ret_err, o_prot)?;
              o_prot.write_message_end()?;
              o_prot.flush()
            }
          },
          thrift::Error::Application(app_err) => {
            let message_ident = TMessageIdentifier::new("getRowWithColumnsTs", TMessageType::Exception, incoming_sequence_number);
            o_prot.write_message_begin(&message_ident)?;
            thrift::Error::write_application_error_to_out_protocol(&app_err, o_prot)?;
            o_prot.write_message_end()?;
            o_prot.flush()
          },
          _ => {
            let ret_err = {
              ApplicationError::new(
                ApplicationErrorKind::Unknown,
                e.to_string()
              )
            };
            let message_ident = TMessageIdentifier::new("getRowWithColumnsTs", TMessageType::Exception, incoming_sequence_number);
            o_prot.write_message_begin(&message_ident)?;
            thrift::Error::write_application_error_to_out_protocol(&ret_err, o_prot)?;
            o_prot.write_message_end()?;
            o_prot.flush()
          },
        }
      },
    }
  }
  pub fn process_get_rows<H: HbaseSyncHandler>(handler: &H, incoming_sequence_number: i32, i_prot: &mut dyn TInputProtocol, o_prot: &mut dyn TOutputProtocol) -> thrift::Result<()> {
    let args = HbaseGetRowsArgs::read_from_in_protocol(i_prot)?;
    match handler.handle_get_rows(args.table_name, args.rows, args.attributes) {
      Ok(handler_return) => {
        let message_ident = TMessageIdentifier::new("getRows", TMessageType::Reply, incoming_sequence_number);
        o_prot.write_message_begin(&message_ident)?;
        let ret = HbaseGetRowsResult { result_value: Some(handler_return), io: None };
        ret.write_to_out_protocol(o_prot)?;
        o_prot.write_message_end()?;
        o_prot.flush()
      },
      Err(e) => {
        match e {
          thrift::Error::User(usr_err) => {
            if usr_err.downcast_ref::<IOError>().is_some() {
              let err = usr_err.downcast::<IOError>().expect("downcast already checked");
              let ret_err = HbaseGetRowsResult{ result_value: None, io: Some(*err) };
              let message_ident = TMessageIdentifier::new("getRows", TMessageType::Reply, incoming_sequence_number);
              o_prot.write_message_begin(&message_ident)?;
              ret_err.write_to_out_protocol(o_prot)?;
              o_prot.write_message_end()?;
              o_prot.flush()
            } else {
              let ret_err = {
                ApplicationError::new(
                  ApplicationErrorKind::Unknown,
                  usr_err.to_string()
                )
              };
              let message_ident = TMessageIdentifier::new("getRows", TMessageType::Exception, incoming_sequence_number);
              o_prot.write_message_begin(&message_ident)?;
              thrift::Error::write_application_error_to_out_protocol(&ret_err, o_prot)?;
              o_prot.write_message_end()?;
              o_prot.flush()
            }
          },
          thrift::Error::Application(app_err) => {
            let message_ident = TMessageIdentifier::new("getRows", TMessageType::Exception, incoming_sequence_number);
            o_prot.write_message_begin(&message_ident)?;
            thrift::Error::write_application_error_to_out_protocol(&app_err, o_prot)?;
            o_prot.write_message_end()?;
            o_prot.flush()
          },
          _ => {
            let ret_err = {
              ApplicationError::new(
                ApplicationErrorKind::Unknown,
                e.to_string()
              )
            };
            let message_ident = TMessageIdentifier::new("getRows", TMessageType::Exception, incoming_sequence_number);
            o_prot.write_message_begin(&message_ident)?;
            thrift::Error::write_application_error_to_out_protocol(&ret_err, o_prot)?;
            o_prot.write_message_end()?;
            o_prot.flush()
          },
        }
      },
    }
  }
  pub fn process_get_rows_with_columns<H: HbaseSyncHandler>(handler: &H, incoming_sequence_number: i32, i_prot: &mut dyn TInputProtocol, o_prot: &mut dyn TOutputProtocol) -> thrift::Result<()> {
    let args = HbaseGetRowsWithColumnsArgs::read_from_in_protocol(i_prot)?;
    match handler.handle_get_rows_with_columns(args.table_name, args.rows, args.columns, args.attributes) {
      Ok(handler_return) => {
        let message_ident = TMessageIdentifier::new("getRowsWithColumns", TMessageType::Reply, incoming_sequence_number);
        o_prot.write_message_begin(&message_ident)?;
        let ret = HbaseGetRowsWithColumnsResult { result_value: Some(handler_return), io: None };
        ret.write_to_out_protocol(o_prot)?;
        o_prot.write_message_end()?;
        o_prot.flush()
      },
      Err(e) => {
        match e {
          thrift::Error::User(usr_err) => {
            if usr_err.downcast_ref::<IOError>().is_some() {
              let err = usr_err.downcast::<IOError>().expect("downcast already checked");
              let ret_err = HbaseGetRowsWithColumnsResult{ result_value: None, io: Some(*err) };
              let message_ident = TMessageIdentifier::new("getRowsWithColumns", TMessageType::Reply, incoming_sequence_number);
              o_prot.write_message_begin(&message_ident)?;
              ret_err.write_to_out_protocol(o_prot)?;
              o_prot.write_message_end()?;
              o_prot.flush()
            } else {
              let ret_err = {
                ApplicationError::new(
                  ApplicationErrorKind::Unknown,
                  usr_err.to_string()
                )
              };
              let message_ident = TMessageIdentifier::new("getRowsWithColumns", TMessageType::Exception, incoming_sequence_number);
              o_prot.write_message_begin(&message_ident)?;
              thrift::Error::write_application_error_to_out_protocol(&ret_err, o_prot)?;
              o_prot.write_message_end()?;
              o_prot.flush()
            }
          },
          thrift::Error::Application(app_err) => {
            let message_ident = TMessageIdentifier::new("getRowsWithColumns", TMessageType::Exception, incoming_sequence_number);
            o_prot.write_message_begin(&message_ident)?;
            thrift::Error::write_application_error_to_out_protocol(&app_err, o_prot)?;
            o_prot.write_message_end()?;
            o_prot.flush()
          },
          _ => {
            let ret_err = {
              ApplicationError::new(
                ApplicationErrorKind::Unknown,
                e.to_string()
              )
            };
            let message_ident = TMessageIdentifier::new("getRowsWithColumns", TMessageType::Exception, incoming_sequence_number);
            o_prot.write_message_begin(&message_ident)?;
            thrift::Error::write_application_error_to_out_protocol(&ret_err, o_prot)?;
            o_prot.write_message_end()?;
            o_prot.flush()
          },
        }
      },
    }
  }
  pub fn process_get_rows_ts<H: HbaseSyncHandler>(handler: &H, incoming_sequence_number: i32, i_prot: &mut dyn TInputProtocol, o_prot: &mut dyn TOutputProtocol) -> thrift::Result<()> {
    let args = HbaseGetRowsTsArgs::read_from_in_protocol(i_prot)?;
    match handler.handle_get_rows_ts(args.table_name, args.rows, args.timestamp, args.attributes) {
      Ok(handler_return) => {
        let message_ident = TMessageIdentifier::new("getRowsTs", TMessageType::Reply, incoming_sequence_number);
        o_prot.write_message_begin(&message_ident)?;
        let ret = HbaseGetRowsTsResult { result_value: Some(handler_return), io: None };
        ret.write_to_out_protocol(o_prot)?;
        o_prot.write_message_end()?;
        o_prot.flush()
      },
      Err(e) => {
        match e {
          thrift::Error::User(usr_err) => {
            if usr_err.downcast_ref::<IOError>().is_some() {
              let err = usr_err.downcast::<IOError>().expect("downcast already checked");
              let ret_err = HbaseGetRowsTsResult{ result_value: None, io: Some(*err) };
              let message_ident = TMessageIdentifier::new("getRowsTs", TMessageType::Reply, incoming_sequence_number);
              o_prot.write_message_begin(&message_ident)?;
              ret_err.write_to_out_protocol(o_prot)?;
              o_prot.write_message_end()?;
              o_prot.flush()
            } else {
              let ret_err = {
                ApplicationError::new(
                  ApplicationErrorKind::Unknown,
                  usr_err.to_string()
                )
              };
              let message_ident = TMessageIdentifier::new("getRowsTs", TMessageType::Exception, incoming_sequence_number);
              o_prot.write_message_begin(&message_ident)?;
              thrift::Error::write_application_error_to_out_protocol(&ret_err, o_prot)?;
              o_prot.write_message_end()?;
              o_prot.flush()
            }
          },
          thrift::Error::Application(app_err) => {
            let message_ident = TMessageIdentifier::new("getRowsTs", TMessageType::Exception, incoming_sequence_number);
            o_prot.write_message_begin(&message_ident)?;
            thrift::Error::write_application_error_to_out_protocol(&app_err, o_prot)?;
            o_prot.write_message_end()?;
            o_prot.flush()
          },
          _ => {
            let ret_err = {
              ApplicationError::new(
                ApplicationErrorKind::Unknown,
                e.to_string()
              )
            };
            let message_ident = TMessageIdentifier::new("getRowsTs", TMessageType::Exception, incoming_sequence_number);
            o_prot.write_message_begin(&message_ident)?;
            thrift::Error::write_application_error_to_out_protocol(&ret_err, o_prot)?;
            o_prot.write_message_end()?;
            o_prot.flush()
          },
        }
      },
    }
  }
  pub fn process_get_rows_with_columns_ts<H: HbaseSyncHandler>(handler: &H, incoming_sequence_number: i32, i_prot: &mut dyn TInputProtocol, o_prot: &mut dyn TOutputProtocol) -> thrift::Result<()> {
    let args = HbaseGetRowsWithColumnsTsArgs::read_from_in_protocol(i_prot)?;
    match handler.handle_get_rows_with_columns_ts(args.table_name, args.rows, args.columns, args.timestamp, args.attributes) {
      Ok(handler_return) => {
        let message_ident = TMessageIdentifier::new("getRowsWithColumnsTs", TMessageType::Reply, incoming_sequence_number);
        o_prot.write_message_begin(&message_ident)?;
        let ret = HbaseGetRowsWithColumnsTsResult { result_value: Some(handler_return), io: None };
        ret.write_to_out_protocol(o_prot)?;
        o_prot.write_message_end()?;
        o_prot.flush()
      },
      Err(e) => {
        match e {
          thrift::Error::User(usr_err) => {
            if usr_err.downcast_ref::<IOError>().is_some() {
              let err = usr_err.downcast::<IOError>().expect("downcast already checked");
              let ret_err = HbaseGetRowsWithColumnsTsResult{ result_value: None, io: Some(*err) };
              let message_ident = TMessageIdentifier::new("getRowsWithColumnsTs", TMessageType::Reply, incoming_sequence_number);
              o_prot.write_message_begin(&message_ident)?;
              ret_err.write_to_out_protocol(o_prot)?;
              o_prot.write_message_end()?;
              o_prot.flush()
            } else {
              let ret_err = {
                ApplicationError::new(
                  ApplicationErrorKind::Unknown,
                  usr_err.to_string()
                )
              };
              let message_ident = TMessageIdentifier::new("getRowsWithColumnsTs", TMessageType::Exception, incoming_sequence_number);
              o_prot.write_message_begin(&message_ident)?;
              thrift::Error::write_application_error_to_out_protocol(&ret_err, o_prot)?;
              o_prot.write_message_end()?;
              o_prot.flush()
            }
          },
          thrift::Error::Application(app_err) => {
            let message_ident = TMessageIdentifier::new("getRowsWithColumnsTs", TMessageType::Exception, incoming_sequence_number);
            o_prot.write_message_begin(&message_ident)?;
            thrift::Error::write_application_error_to_out_protocol(&app_err, o_prot)?;
            o_prot.write_message_end()?;
            o_prot.flush()
          },
          _ => {
            let ret_err = {
              ApplicationError::new(
                ApplicationErrorKind::Unknown,
                e.to_string()
              )
            };
            let message_ident = TMessageIdentifier::new("getRowsWithColumnsTs", TMessageType::Exception, incoming_sequence_number);
            o_prot.write_message_begin(&message_ident)?;
            thrift::Error::write_application_error_to_out_protocol(&ret_err, o_prot)?;
            o_prot.write_message_end()?;
            o_prot.flush()
          },
        }
      },
    }
  }
  pub fn process_mutate_row<H: HbaseSyncHandler>(handler: &H, incoming_sequence_number: i32, i_prot: &mut dyn TInputProtocol, o_prot: &mut dyn TOutputProtocol) -> thrift::Result<()> {
    let args = HbaseMutateRowArgs::read_from_in_protocol(i_prot)?;
    match handler.handle_mutate_row(args.table_name, args.row, args.mutations, args.attributes) {
      Ok(_) => {
        let message_ident = TMessageIdentifier::new("mutateRow", TMessageType::Reply, incoming_sequence_number);
        o_prot.write_message_begin(&message_ident)?;
        let ret = HbaseMutateRowResult { io: None, ia: None };
        ret.write_to_out_protocol(o_prot)?;
        o_prot.write_message_end()?;
        o_prot.flush()
      },
      Err(e) => {
        match e {
          thrift::Error::User(usr_err) => {
            if usr_err.downcast_ref::<IOError>().is_some() {
              let err = usr_err.downcast::<IOError>().expect("downcast already checked");
              let ret_err = HbaseMutateRowResult{ io: Some(*err), ia: None };
              let message_ident = TMessageIdentifier::new("mutateRow", TMessageType::Reply, incoming_sequence_number);
              o_prot.write_message_begin(&message_ident)?;
              ret_err.write_to_out_protocol(o_prot)?;
              o_prot.write_message_end()?;
              o_prot.flush()
            } else if usr_err.downcast_ref::<IllegalArgument>().is_some() {
              let err = usr_err.downcast::<IllegalArgument>().expect("downcast already checked");
              let ret_err = HbaseMutateRowResult{ io: None, ia: Some(*err) };
              let message_ident = TMessageIdentifier::new("mutateRow", TMessageType::Reply, incoming_sequence_number);
              o_prot.write_message_begin(&message_ident)?;
              ret_err.write_to_out_protocol(o_prot)?;
              o_prot.write_message_end()?;
              o_prot.flush()
            } else {
              let ret_err = {
                ApplicationError::new(
                  ApplicationErrorKind::Unknown,
                  usr_err.to_string()
                )
              };
              let message_ident = TMessageIdentifier::new("mutateRow", TMessageType::Exception, incoming_sequence_number);
              o_prot.write_message_begin(&message_ident)?;
              thrift::Error::write_application_error_to_out_protocol(&ret_err, o_prot)?;
              o_prot.write_message_end()?;
              o_prot.flush()
            }
          },
          thrift::Error::Application(app_err) => {
            let message_ident = TMessageIdentifier::new("mutateRow", TMessageType::Exception, incoming_sequence_number);
            o_prot.write_message_begin(&message_ident)?;
            thrift::Error::write_application_error_to_out_protocol(&app_err, o_prot)?;
            o_prot.write_message_end()?;
            o_prot.flush()
          },
          _ => {
            let ret_err = {
              ApplicationError::new(
                ApplicationErrorKind::Unknown,
                e.to_string()
              )
            };
            let message_ident = TMessageIdentifier::new("mutateRow", TMessageType::Exception, incoming_sequence_number);
            o_prot.write_message_begin(&message_ident)?;
            thrift::Error::write_application_error_to_out_protocol(&ret_err, o_prot)?;
            o_prot.write_message_end()?;
            o_prot.flush()
          },
        }
      },
    }
  }
  pub fn process_mutate_row_ts<H: HbaseSyncHandler>(handler: &H, incoming_sequence_number: i32, i_prot: &mut dyn TInputProtocol, o_prot: &mut dyn TOutputProtocol) -> thrift::Result<()> {
    let args = HbaseMutateRowTsArgs::read_from_in_protocol(i_prot)?;
    match handler.handle_mutate_row_ts(args.table_name, args.row, args.mutations, args.timestamp, args.attributes) {
      Ok(_) => {
        let message_ident = TMessageIdentifier::new("mutateRowTs", TMessageType::Reply, incoming_sequence_number);
        o_prot.write_message_begin(&message_ident)?;
        let ret = HbaseMutateRowTsResult { io: None, ia: None };
        ret.write_to_out_protocol(o_prot)?;
        o_prot.write_message_end()?;
        o_prot.flush()
      },
      Err(e) => {
        match e {
          thrift::Error::User(usr_err) => {
            if usr_err.downcast_ref::<IOError>().is_some() {
              let err = usr_err.downcast::<IOError>().expect("downcast already checked");
              let ret_err = HbaseMutateRowTsResult{ io: Some(*err), ia: None };
              let message_ident = TMessageIdentifier::new("mutateRowTs", TMessageType::Reply, incoming_sequence_number);
              o_prot.write_message_begin(&message_ident)?;
              ret_err.write_to_out_protocol(o_prot)?;
              o_prot.write_message_end()?;
              o_prot.flush()
            } else if usr_err.downcast_ref::<IllegalArgument>().is_some() {
              let err = usr_err.downcast::<IllegalArgument>().expect("downcast already checked");
              let ret_err = HbaseMutateRowTsResult{ io: None, ia: Some(*err) };
              let message_ident = TMessageIdentifier::new("mutateRowTs", TMessageType::Reply, incoming_sequence_number);
              o_prot.write_message_begin(&message_ident)?;
              ret_err.write_to_out_protocol(o_prot)?;
              o_prot.write_message_end()?;
              o_prot.flush()
            } else {
              let ret_err = {
                ApplicationError::new(
                  ApplicationErrorKind::Unknown,
                  usr_err.to_string()
                )
              };
              let message_ident = TMessageIdentifier::new("mutateRowTs", TMessageType::Exception, incoming_sequence_number);
              o_prot.write_message_begin(&message_ident)?;
              thrift::Error::write_application_error_to_out_protocol(&ret_err, o_prot)?;
              o_prot.write_message_end()?;
              o_prot.flush()
            }
          },
          thrift::Error::Application(app_err) => {
            let message_ident = TMessageIdentifier::new("mutateRowTs", TMessageType::Exception, incoming_sequence_number);
            o_prot.write_message_begin(&message_ident)?;
            thrift::Error::write_application_error_to_out_protocol(&app_err, o_prot)?;
            o_prot.write_message_end()?;
            o_prot.flush()
          },
          _ => {
            let ret_err = {
              ApplicationError::new(
                ApplicationErrorKind::Unknown,
                e.to_string()
              )
            };
            let message_ident = TMessageIdentifier::new("mutateRowTs", TMessageType::Exception, incoming_sequence_number);
            o_prot.write_message_begin(&message_ident)?;
            thrift::Error::write_application_error_to_out_protocol(&ret_err, o_prot)?;
            o_prot.write_message_end()?;
            o_prot.flush()
          },
        }
      },
    }
  }
  pub fn process_mutate_rows<H: HbaseSyncHandler>(handler: &H, incoming_sequence_number: i32, i_prot: &mut dyn TInputProtocol, o_prot: &mut dyn TOutputProtocol) -> thrift::Result<()> {
    let args = HbaseMutateRowsArgs::read_from_in_protocol(i_prot)?;
    match handler.handle_mutate_rows(args.table_name, args.row_batches, args.attributes) {
      Ok(_) => {
        let message_ident = TMessageIdentifier::new("mutateRows", TMessageType::Reply, incoming_sequence_number);
        o_prot.write_message_begin(&message_ident)?;
        let ret = HbaseMutateRowsResult { io: None, ia: None };
        ret.write_to_out_protocol(o_prot)?;
        o_prot.write_message_end()?;
        o_prot.flush()
      },
      Err(e) => {
        match e {
          thrift::Error::User(usr_err) => {
            if usr_err.downcast_ref::<IOError>().is_some() {
              let err = usr_err.downcast::<IOError>().expect("downcast already checked");
              let ret_err = HbaseMutateRowsResult{ io: Some(*err), ia: None };
              let message_ident = TMessageIdentifier::new("mutateRows", TMessageType::Reply, incoming_sequence_number);
              o_prot.write_message_begin(&message_ident)?;
              ret_err.write_to_out_protocol(o_prot)?;
              o_prot.write_message_end()?;
              o_prot.flush()
            } else if usr_err.downcast_ref::<IllegalArgument>().is_some() {
              let err = usr_err.downcast::<IllegalArgument>().expect("downcast already checked");
              let ret_err = HbaseMutateRowsResult{ io: None, ia: Some(*err) };
              let message_ident = TMessageIdentifier::new("mutateRows", TMessageType::Reply, incoming_sequence_number);
              o_prot.write_message_begin(&message_ident)?;
              ret_err.write_to_out_protocol(o_prot)?;
              o_prot.write_message_end()?;
              o_prot.flush()
            } else {
              let ret_err = {
                ApplicationError::new(
                  ApplicationErrorKind::Unknown,
                  usr_err.to_string()
                )
              };
              let message_ident = TMessageIdentifier::new("mutateRows", TMessageType::Exception, incoming_sequence_number);
              o_prot.write_message_begin(&message_ident)?;
              thrift::Error::write_application_error_to_out_protocol(&ret_err, o_prot)?;
              o_prot.write_message_end()?;
              o_prot.flush()
            }
          },
          thrift::Error::Application(app_err) => {
            let message_ident = TMessageIdentifier::new("mutateRows", TMessageType::Exception, incoming_sequence_number);
            o_prot.write_message_begin(&message_ident)?;
            thrift::Error::write_application_error_to_out_protocol(&app_err, o_prot)?;
            o_prot.write_message_end()?;
            o_prot.flush()
          },
          _ => {
            let ret_err = {
              ApplicationError::new(
                ApplicationErrorKind::Unknown,
                e.to_string()
              )
            };
            let message_ident = TMessageIdentifier::new("mutateRows", TMessageType::Exception, incoming_sequence_number);
            o_prot.write_message_begin(&message_ident)?;
            thrift::Error::write_application_error_to_out_protocol(&ret_err, o_prot)?;
            o_prot.write_message_end()?;
            o_prot.flush()
          },
        }
      },
    }
  }
  pub fn process_mutate_rows_ts<H: HbaseSyncHandler>(handler: &H, incoming_sequence_number: i32, i_prot: &mut dyn TInputProtocol, o_prot: &mut dyn TOutputProtocol) -> thrift::Result<()> {
    let args = HbaseMutateRowsTsArgs::read_from_in_protocol(i_prot)?;
    match handler.handle_mutate_rows_ts(args.table_name, args.row_batches, args.timestamp, args.attributes) {
      Ok(_) => {
        let message_ident = TMessageIdentifier::new("mutateRowsTs", TMessageType::Reply, incoming_sequence_number);
        o_prot.write_message_begin(&message_ident)?;
        let ret = HbaseMutateRowsTsResult { io: None, ia: None };
        ret.write_to_out_protocol(o_prot)?;
        o_prot.write_message_end()?;
        o_prot.flush()
      },
      Err(e) => {
        match e {
          thrift::Error::User(usr_err) => {
            if usr_err.downcast_ref::<IOError>().is_some() {
              let err = usr_err.downcast::<IOError>().expect("downcast already checked");
              let ret_err = HbaseMutateRowsTsResult{ io: Some(*err), ia: None };
              let message_ident = TMessageIdentifier::new("mutateRowsTs", TMessageType::Reply, incoming_sequence_number);
              o_prot.write_message_begin(&message_ident)?;
              ret_err.write_to_out_protocol(o_prot)?;
              o_prot.write_message_end()?;
              o_prot.flush()
            } else if usr_err.downcast_ref::<IllegalArgument>().is_some() {
              let err = usr_err.downcast::<IllegalArgument>().expect("downcast already checked");
              let ret_err = HbaseMutateRowsTsResult{ io: None, ia: Some(*err) };
              let message_ident = TMessageIdentifier::new("mutateRowsTs", TMessageType::Reply, incoming_sequence_number);
              o_prot.write_message_begin(&message_ident)?;
              ret_err.write_to_out_protocol(o_prot)?;
              o_prot.write_message_end()?;
              o_prot.flush()
            } else {
              let ret_err = {
                ApplicationError::new(
                  ApplicationErrorKind::Unknown,
                  usr_err.to_string()
                )
              };
              let message_ident = TMessageIdentifier::new("mutateRowsTs", TMessageType::Exception, incoming_sequence_number);
              o_prot.write_message_begin(&message_ident)?;
              thrift::Error::write_application_error_to_out_protocol(&ret_err, o_prot)?;
              o_prot.write_message_end()?;
              o_prot.flush()
            }
          },
          thrift::Error::Application(app_err) => {
            let message_ident = TMessageIdentifier::new("mutateRowsTs", TMessageType::Exception, incoming_sequence_number);
            o_prot.write_message_begin(&message_ident)?;
            thrift::Error::write_application_error_to_out_protocol(&app_err, o_prot)?;
            o_prot.write_message_end()?;
            o_prot.flush()
          },
          _ => {
            let ret_err = {
              ApplicationError::new(
                ApplicationErrorKind::Unknown,
                e.to_string()
              )
            };
            let message_ident = TMessageIdentifier::new("mutateRowsTs", TMessageType::Exception, incoming_sequence_number);
            o_prot.write_message_begin(&message_ident)?;
            thrift::Error::write_application_error_to_out_protocol(&ret_err, o_prot)?;
            o_prot.write_message_end()?;
            o_prot.flush()
          },
        }
      },
    }
  }
  pub fn process_atomic_increment<H: HbaseSyncHandler>(handler: &H, incoming_sequence_number: i32, i_prot: &mut dyn TInputProtocol, o_prot: &mut dyn TOutputProtocol) -> thrift::Result<()> {
    let args = HbaseAtomicIncrementArgs::read_from_in_protocol(i_prot)?;
    match handler.handle_atomic_increment(args.table_name, args.row, args.column, args.value) {
      Ok(handler_return) => {
        let message_ident = TMessageIdentifier::new("atomicIncrement", TMessageType::Reply, incoming_sequence_number);
        o_prot.write_message_begin(&message_ident)?;
        let ret = HbaseAtomicIncrementResult { result_value: Some(handler_return), io: None, ia: None };
        ret.write_to_out_protocol(o_prot)?;
        o_prot.write_message_end()?;
        o_prot.flush()
      },
      Err(e) => {
        match e {
          thrift::Error::User(usr_err) => {
            if usr_err.downcast_ref::<IOError>().is_some() {
              let err = usr_err.downcast::<IOError>().expect("downcast already checked");
              let ret_err = HbaseAtomicIncrementResult{ result_value: None, io: Some(*err), ia: None };
              let message_ident = TMessageIdentifier::new("atomicIncrement", TMessageType::Reply, incoming_sequence_number);
              o_prot.write_message_begin(&message_ident)?;
              ret_err.write_to_out_protocol(o_prot)?;
              o_prot.write_message_end()?;
              o_prot.flush()
            } else if usr_err.downcast_ref::<IllegalArgument>().is_some() {
              let err = usr_err.downcast::<IllegalArgument>().expect("downcast already checked");
              let ret_err = HbaseAtomicIncrementResult{ result_value: None, io: None, ia: Some(*err) };
              let message_ident = TMessageIdentifier::new("atomicIncrement", TMessageType::Reply, incoming_sequence_number);
              o_prot.write_message_begin(&message_ident)?;
              ret_err.write_to_out_protocol(o_prot)?;
              o_prot.write_message_end()?;
              o_prot.flush()
            } else {
              let ret_err = {
                ApplicationError::new(
                  ApplicationErrorKind::Unknown,
                  usr_err.to_string()
                )
              };
              let message_ident = TMessageIdentifier::new("atomicIncrement", TMessageType::Exception, incoming_sequence_number);
              o_prot.write_message_begin(&message_ident)?;
              thrift::Error::write_application_error_to_out_protocol(&ret_err, o_prot)?;
              o_prot.write_message_end()?;
              o_prot.flush()
            }
          },
          thrift::Error::Application(app_err) => {
            let message_ident = TMessageIdentifier::new("atomicIncrement", TMessageType::Exception, incoming_sequence_number);
            o_prot.write_message_begin(&message_ident)?;
            thrift::Error::write_application_error_to_out_protocol(&app_err, o_prot)?;
            o_prot.write_message_end()?;
            o_prot.flush()
          },
          _ => {
            let ret_err = {
              ApplicationError::new(
                ApplicationErrorKind::Unknown,
                e.to_string()
              )
            };
            let message_ident = TMessageIdentifier::new("atomicIncrement", TMessageType::Exception, incoming_sequence_number);
            o_prot.write_message_begin(&message_ident)?;
            thrift::Error::write_application_error_to_out_protocol(&ret_err, o_prot)?;
            o_prot.write_message_end()?;
            o_prot.flush()
          },
        }
      },
    }
  }
  pub fn process_delete_all<H: HbaseSyncHandler>(handler: &H, incoming_sequence_number: i32, i_prot: &mut dyn TInputProtocol, o_prot: &mut dyn TOutputProtocol) -> thrift::Result<()> {
    let args = HbaseDeleteAllArgs::read_from_in_protocol(i_prot)?;
    match handler.handle_delete_all(args.table_name, args.row, args.column, args.attributes) {
      Ok(_) => {
        let message_ident = TMessageIdentifier::new("deleteAll", TMessageType::Reply, incoming_sequence_number);
        o_prot.write_message_begin(&message_ident)?;
        let ret = HbaseDeleteAllResult { io: None };
        ret.write_to_out_protocol(o_prot)?;
        o_prot.write_message_end()?;
        o_prot.flush()
      },
      Err(e) => {
        match e {
          thrift::Error::User(usr_err) => {
            if usr_err.downcast_ref::<IOError>().is_some() {
              let err = usr_err.downcast::<IOError>().expect("downcast already checked");
              let ret_err = HbaseDeleteAllResult{ io: Some(*err) };
              let message_ident = TMessageIdentifier::new("deleteAll", TMessageType::Reply, incoming_sequence_number);
              o_prot.write_message_begin(&message_ident)?;
              ret_err.write_to_out_protocol(o_prot)?;
              o_prot.write_message_end()?;
              o_prot.flush()
            } else {
              let ret_err = {
                ApplicationError::new(
                  ApplicationErrorKind::Unknown,
                  usr_err.to_string()
                )
              };
              let message_ident = TMessageIdentifier::new("deleteAll", TMessageType::Exception, incoming_sequence_number);
              o_prot.write_message_begin(&message_ident)?;
              thrift::Error::write_application_error_to_out_protocol(&ret_err, o_prot)?;
              o_prot.write_message_end()?;
              o_prot.flush()
            }
          },
          thrift::Error::Application(app_err) => {
            let message_ident = TMessageIdentifier::new("deleteAll", TMessageType::Exception, incoming_sequence_number);
            o_prot.write_message_begin(&message_ident)?;
            thrift::Error::write_application_error_to_out_protocol(&app_err, o_prot)?;
            o_prot.write_message_end()?;
            o_prot.flush()
          },
          _ => {
            let ret_err = {
              ApplicationError::new(
                ApplicationErrorKind::Unknown,
                e.to_string()
              )
            };
            let message_ident = TMessageIdentifier::new("deleteAll", TMessageType::Exception, incoming_sequence_number);
            o_prot.write_message_begin(&message_ident)?;
            thrift::Error::write_application_error_to_out_protocol(&ret_err, o_prot)?;
            o_prot.write_message_end()?;
            o_prot.flush()
          },
        }
      },
    }
  }
  pub fn process_delete_all_ts<H: HbaseSyncHandler>(handler: &H, incoming_sequence_number: i32, i_prot: &mut dyn TInputProtocol, o_prot: &mut dyn TOutputProtocol) -> thrift::Result<()> {
    let args = HbaseDeleteAllTsArgs::read_from_in_protocol(i_prot)?;
    match handler.handle_delete_all_ts(args.table_name, args.row, args.column, args.timestamp, args.attributes) {
      Ok(_) => {
        let message_ident = TMessageIdentifier::new("deleteAllTs", TMessageType::Reply, incoming_sequence_number);
        o_prot.write_message_begin(&message_ident)?;
        let ret = HbaseDeleteAllTsResult { io: None };
        ret.write_to_out_protocol(o_prot)?;
        o_prot.write_message_end()?;
        o_prot.flush()
      },
      Err(e) => {
        match e {
          thrift::Error::User(usr_err) => {
            if usr_err.downcast_ref::<IOError>().is_some() {
              let err = usr_err.downcast::<IOError>().expect("downcast already checked");
              let ret_err = HbaseDeleteAllTsResult{ io: Some(*err) };
              let message_ident = TMessageIdentifier::new("deleteAllTs", TMessageType::Reply, incoming_sequence_number);
              o_prot.write_message_begin(&message_ident)?;
              ret_err.write_to_out_protocol(o_prot)?;
              o_prot.write_message_end()?;
              o_prot.flush()
            } else {
              let ret_err = {
                ApplicationError::new(
                  ApplicationErrorKind::Unknown,
                  usr_err.to_string()
                )
              };
              let message_ident = TMessageIdentifier::new("deleteAllTs", TMessageType::Exception, incoming_sequence_number);
              o_prot.write_message_begin(&message_ident)?;
              thrift::Error::write_application_error_to_out_protocol(&ret_err, o_prot)?;
              o_prot.write_message_end()?;
              o_prot.flush()
            }
          },
          thrift::Error::Application(app_err) => {
            let message_ident = TMessageIdentifier::new("deleteAllTs", TMessageType::Exception, incoming_sequence_number);
            o_prot.write_message_begin(&message_ident)?;
            thrift::Error::write_application_error_to_out_protocol(&app_err, o_prot)?;
            o_prot.write_message_end()?;
            o_prot.flush()
          },
          _ => {
            let ret_err = {
              ApplicationError::new(
                ApplicationErrorKind::Unknown,
                e.to_string()
              )
            };
            let message_ident = TMessageIdentifier::new("deleteAllTs", TMessageType::Exception, incoming_sequence_number);
            o_prot.write_message_begin(&message_ident)?;
            thrift::Error::write_application_error_to_out_protocol(&ret_err, o_prot)?;
            o_prot.write_message_end()?;
            o_prot.flush()
          },
        }
      },
    }
  }
  pub fn process_delete_all_row<H: HbaseSyncHandler>(handler: &H, incoming_sequence_number: i32, i_prot: &mut dyn TInputProtocol, o_prot: &mut dyn TOutputProtocol) -> thrift::Result<()> {
    let args = HbaseDeleteAllRowArgs::read_from_in_protocol(i_prot)?;
    match handler.handle_delete_all_row(args.table_name, args.row, args.attributes) {
      Ok(_) => {
        let message_ident = TMessageIdentifier::new("deleteAllRow", TMessageType::Reply, incoming_sequence_number);
        o_prot.write_message_begin(&message_ident)?;
        let ret = HbaseDeleteAllRowResult { io: None };
        ret.write_to_out_protocol(o_prot)?;
        o_prot.write_message_end()?;
        o_prot.flush()
      },
      Err(e) => {
        match e {
          thrift::Error::User(usr_err) => {
            if usr_err.downcast_ref::<IOError>().is_some() {
              let err = usr_err.downcast::<IOError>().expect("downcast already checked");
              let ret_err = HbaseDeleteAllRowResult{ io: Some(*err) };
              let message_ident = TMessageIdentifier::new("deleteAllRow", TMessageType::Reply, incoming_sequence_number);
              o_prot.write_message_begin(&message_ident)?;
              ret_err.write_to_out_protocol(o_prot)?;
              o_prot.write_message_end()?;
              o_prot.flush()
            } else {
              let ret_err = {
                ApplicationError::new(
                  ApplicationErrorKind::Unknown,
                  usr_err.to_string()
                )
              };
              let message_ident = TMessageIdentifier::new("deleteAllRow", TMessageType::Exception, incoming_sequence_number);
              o_prot.write_message_begin(&message_ident)?;
              thrift::Error::write_application_error_to_out_protocol(&ret_err, o_prot)?;
              o_prot.write_message_end()?;
              o_prot.flush()
            }
          },
          thrift::Error::Application(app_err) => {
            let message_ident = TMessageIdentifier::new("deleteAllRow", TMessageType::Exception, incoming_sequence_number);
            o_prot.write_message_begin(&message_ident)?;
            thrift::Error::write_application_error_to_out_protocol(&app_err, o_prot)?;
            o_prot.write_message_end()?;
            o_prot.flush()
          },
          _ => {
            let ret_err = {
              ApplicationError::new(
                ApplicationErrorKind::Unknown,
                e.to_string()
              )
            };
            let message_ident = TMessageIdentifier::new("deleteAllRow", TMessageType::Exception, incoming_sequence_number);
            o_prot.write_message_begin(&message_ident)?;
            thrift::Error::write_application_error_to_out_protocol(&ret_err, o_prot)?;
            o_prot.write_message_end()?;
            o_prot.flush()
          },
        }
      },
    }
  }
  pub fn process_increment<H: HbaseSyncHandler>(handler: &H, incoming_sequence_number: i32, i_prot: &mut dyn TInputProtocol, o_prot: &mut dyn TOutputProtocol) -> thrift::Result<()> {
    let args = HbaseIncrementArgs::read_from_in_protocol(i_prot)?;
    match handler.handle_increment(args.increment) {
      Ok(_) => {
        let message_ident = TMessageIdentifier::new("increment", TMessageType::Reply, incoming_sequence_number);
        o_prot.write_message_begin(&message_ident)?;
        let ret = HbaseIncrementResult { io: None };
        ret.write_to_out_protocol(o_prot)?;
        o_prot.write_message_end()?;
        o_prot.flush()
      },
      Err(e) => {
        match e {
          thrift::Error::User(usr_err) => {
            if usr_err.downcast_ref::<IOError>().is_some() {
              let err = usr_err.downcast::<IOError>().expect("downcast already checked");
              let ret_err = HbaseIncrementResult{ io: Some(*err) };
              let message_ident = TMessageIdentifier::new("increment", TMessageType::Reply, incoming_sequence_number);
              o_prot.write_message_begin(&message_ident)?;
              ret_err.write_to_out_protocol(o_prot)?;
              o_prot.write_message_end()?;
              o_prot.flush()
            } else {
              let ret_err = {
                ApplicationError::new(
                  ApplicationErrorKind::Unknown,
                  usr_err.to_string()
                )
              };
              let message_ident = TMessageIdentifier::new("increment", TMessageType::Exception, incoming_sequence_number);
              o_prot.write_message_begin(&message_ident)?;
              thrift::Error::write_application_error_to_out_protocol(&ret_err, o_prot)?;
              o_prot.write_message_end()?;
              o_prot.flush()
            }
          },
          thrift::Error::Application(app_err) => {
            let message_ident = TMessageIdentifier::new("increment", TMessageType::Exception, incoming_sequence_number);
            o_prot.write_message_begin(&message_ident)?;
            thrift::Error::write_application_error_to_out_protocol(&app_err, o_prot)?;
            o_prot.write_message_end()?;
            o_prot.flush()
          },
          _ => {
            let ret_err = {
              ApplicationError::new(
                ApplicationErrorKind::Unknown,
                e.to_string()
              )
            };
            let message_ident = TMessageIdentifier::new("increment", TMessageType::Exception, incoming_sequence_number);
            o_prot.write_message_begin(&message_ident)?;
            thrift::Error::write_application_error_to_out_protocol(&ret_err, o_prot)?;
            o_prot.write_message_end()?;
            o_prot.flush()
          },
        }
      },
    }
  }
  pub fn process_increment_rows<H: HbaseSyncHandler>(handler: &H, incoming_sequence_number: i32, i_prot: &mut dyn TInputProtocol, o_prot: &mut dyn TOutputProtocol) -> thrift::Result<()> {
    let args = HbaseIncrementRowsArgs::read_from_in_protocol(i_prot)?;
    match handler.handle_increment_rows(args.increments) {
      Ok(_) => {
        let message_ident = TMessageIdentifier::new("incrementRows", TMessageType::Reply, incoming_sequence_number);
        o_prot.write_message_begin(&message_ident)?;
        let ret = HbaseIncrementRowsResult { io: None };
        ret.write_to_out_protocol(o_prot)?;
        o_prot.write_message_end()?;
        o_prot.flush()
      },
      Err(e) => {
        match e {
          thrift::Error::User(usr_err) => {
            if usr_err.downcast_ref::<IOError>().is_some() {
              let err = usr_err.downcast::<IOError>().expect("downcast already checked");
              let ret_err = HbaseIncrementRowsResult{ io: Some(*err) };
              let message_ident = TMessageIdentifier::new("incrementRows", TMessageType::Reply, incoming_sequence_number);
              o_prot.write_message_begin(&message_ident)?;
              ret_err.write_to_out_protocol(o_prot)?;
              o_prot.write_message_end()?;
              o_prot.flush()
            } else {
              let ret_err = {
                ApplicationError::new(
                  ApplicationErrorKind::Unknown,
                  usr_err.to_string()
                )
              };
              let message_ident = TMessageIdentifier::new("incrementRows", TMessageType::Exception, incoming_sequence_number);
              o_prot.write_message_begin(&message_ident)?;
              thrift::Error::write_application_error_to_out_protocol(&ret_err, o_prot)?;
              o_prot.write_message_end()?;
              o_prot.flush()
            }
          },
          thrift::Error::Application(app_err) => {
            let message_ident = TMessageIdentifier::new("incrementRows", TMessageType::Exception, incoming_sequence_number);
            o_prot.write_message_begin(&message_ident)?;
            thrift::Error::write_application_error_to_out_protocol(&app_err, o_prot)?;
            o_prot.write_message_end()?;
            o_prot.flush()
          },
          _ => {
            let ret_err = {
              ApplicationError::new(
                ApplicationErrorKind::Unknown,
                e.to_string()
              )
            };
            let message_ident = TMessageIdentifier::new("incrementRows", TMessageType::Exception, incoming_sequence_number);
            o_prot.write_message_begin(&message_ident)?;
            thrift::Error::write_application_error_to_out_protocol(&ret_err, o_prot)?;
            o_prot.write_message_end()?;
            o_prot.flush()
          },
        }
      },
    }
  }
  pub fn process_delete_all_row_ts<H: HbaseSyncHandler>(handler: &H, incoming_sequence_number: i32, i_prot: &mut dyn TInputProtocol, o_prot: &mut dyn TOutputProtocol) -> thrift::Result<()> {
    let args = HbaseDeleteAllRowTsArgs::read_from_in_protocol(i_prot)?;
    match handler.handle_delete_all_row_ts(args.table_name, args.row, args.timestamp, args.attributes) {
      Ok(_) => {
        let message_ident = TMessageIdentifier::new("deleteAllRowTs", TMessageType::Reply, incoming_sequence_number);
        o_prot.write_message_begin(&message_ident)?;
        let ret = HbaseDeleteAllRowTsResult { io: None };
        ret.write_to_out_protocol(o_prot)?;
        o_prot.write_message_end()?;
        o_prot.flush()
      },
      Err(e) => {
        match e {
          thrift::Error::User(usr_err) => {
            if usr_err.downcast_ref::<IOError>().is_some() {
              let err = usr_err.downcast::<IOError>().expect("downcast already checked");
              let ret_err = HbaseDeleteAllRowTsResult{ io: Some(*err) };
              let message_ident = TMessageIdentifier::new("deleteAllRowTs", TMessageType::Reply, incoming_sequence_number);
              o_prot.write_message_begin(&message_ident)?;
              ret_err.write_to_out_protocol(o_prot)?;
              o_prot.write_message_end()?;
              o_prot.flush()
            } else {
              let ret_err = {
                ApplicationError::new(
                  ApplicationErrorKind::Unknown,
                  usr_err.to_string()
                )
              };
              let message_ident = TMessageIdentifier::new("deleteAllRowTs", TMessageType::Exception, incoming_sequence_number);
              o_prot.write_message_begin(&message_ident)?;
              thrift::Error::write_application_error_to_out_protocol(&ret_err, o_prot)?;
              o_prot.write_message_end()?;
              o_prot.flush()
            }
          },
          thrift::Error::Application(app_err) => {
            let message_ident = TMessageIdentifier::new("deleteAllRowTs", TMessageType::Exception, incoming_sequence_number);
            o_prot.write_message_begin(&message_ident)?;
            thrift::Error::write_application_error_to_out_protocol(&app_err, o_prot)?;
            o_prot.write_message_end()?;
            o_prot.flush()
          },
          _ => {
            let ret_err = {
              ApplicationError::new(
                ApplicationErrorKind::Unknown,
                e.to_string()
              )
            };
            let message_ident = TMessageIdentifier::new("deleteAllRowTs", TMessageType::Exception, incoming_sequence_number);
            o_prot.write_message_begin(&message_ident)?;
            thrift::Error::write_application_error_to_out_protocol(&ret_err, o_prot)?;
            o_prot.write_message_end()?;
            o_prot.flush()
          },
        }
      },
    }
  }
  pub fn process_scanner_open_with_scan<H: HbaseSyncHandler>(handler: &H, incoming_sequence_number: i32, i_prot: &mut dyn TInputProtocol, o_prot: &mut dyn TOutputProtocol) -> thrift::Result<()> {
    let args = HbaseScannerOpenWithScanArgs::read_from_in_protocol(i_prot)?;
    match handler.handle_scanner_open_with_scan(args.table_name, args.scan, args.attributes) {
      Ok(handler_return) => {
        let message_ident = TMessageIdentifier::new("scannerOpenWithScan", TMessageType::Reply, incoming_sequence_number);
        o_prot.write_message_begin(&message_ident)?;
        let ret = HbaseScannerOpenWithScanResult { result_value: Some(handler_return), io: None };
        ret.write_to_out_protocol(o_prot)?;
        o_prot.write_message_end()?;
        o_prot.flush()
      },
      Err(e) => {
        match e {
          thrift::Error::User(usr_err) => {
            if usr_err.downcast_ref::<IOError>().is_some() {
              let err = usr_err.downcast::<IOError>().expect("downcast already checked");
              let ret_err = HbaseScannerOpenWithScanResult{ result_value: None, io: Some(*err) };
              let message_ident = TMessageIdentifier::new("scannerOpenWithScan", TMessageType::Reply, incoming_sequence_number);
              o_prot.write_message_begin(&message_ident)?;
              ret_err.write_to_out_protocol(o_prot)?;
              o_prot.write_message_end()?;
              o_prot.flush()
            } else {
              let ret_err = {
                ApplicationError::new(
                  ApplicationErrorKind::Unknown,
                  usr_err.to_string()
                )
              };
              let message_ident = TMessageIdentifier::new("scannerOpenWithScan", TMessageType::Exception, incoming_sequence_number);
              o_prot.write_message_begin(&message_ident)?;
              thrift::Error::write_application_error_to_out_protocol(&ret_err, o_prot)?;
              o_prot.write_message_end()?;
              o_prot.flush()
            }
          },
          thrift::Error::Application(app_err) => {
            let message_ident = TMessageIdentifier::new("scannerOpenWithScan", TMessageType::Exception, incoming_sequence_number);
            o_prot.write_message_begin(&message_ident)?;
            thrift::Error::write_application_error_to_out_protocol(&app_err, o_prot)?;
            o_prot.write_message_end()?;
            o_prot.flush()
          },
          _ => {
            let ret_err = {
              ApplicationError::new(
                ApplicationErrorKind::Unknown,
                e.to_string()
              )
            };
            let message_ident = TMessageIdentifier::new("scannerOpenWithScan", TMessageType::Exception, incoming_sequence_number);
            o_prot.write_message_begin(&message_ident)?;
            thrift::Error::write_application_error_to_out_protocol(&ret_err, o_prot)?;
            o_prot.write_message_end()?;
            o_prot.flush()
          },
        }
      },
    }
  }
  pub fn process_scanner_open<H: HbaseSyncHandler>(handler: &H, incoming_sequence_number: i32, i_prot: &mut dyn TInputProtocol, o_prot: &mut dyn TOutputProtocol) -> thrift::Result<()> {
    let args = HbaseScannerOpenArgs::read_from_in_protocol(i_prot)?;
    match handler.handle_scanner_open(args.table_name, args.start_row, args.columns, args.attributes) {
      Ok(handler_return) => {
        let message_ident = TMessageIdentifier::new("scannerOpen", TMessageType::Reply, incoming_sequence_number);
        o_prot.write_message_begin(&message_ident)?;
        let ret = HbaseScannerOpenResult { result_value: Some(handler_return), io: None };
        ret.write_to_out_protocol(o_prot)?;
        o_prot.write_message_end()?;
        o_prot.flush()
      },
      Err(e) => {
        match e {
          thrift::Error::User(usr_err) => {
            if usr_err.downcast_ref::<IOError>().is_some() {
              let err = usr_err.downcast::<IOError>().expect("downcast already checked");
              let ret_err = HbaseScannerOpenResult{ result_value: None, io: Some(*err) };
              let message_ident = TMessageIdentifier::new("scannerOpen", TMessageType::Reply, incoming_sequence_number);
              o_prot.write_message_begin(&message_ident)?;
              ret_err.write_to_out_protocol(o_prot)?;
              o_prot.write_message_end()?;
              o_prot.flush()
            } else {
              let ret_err = {
                ApplicationError::new(
                  ApplicationErrorKind::Unknown,
                  usr_err.to_string()
                )
              };
              let message_ident = TMessageIdentifier::new("scannerOpen", TMessageType::Exception, incoming_sequence_number);
              o_prot.write_message_begin(&message_ident)?;
              thrift::Error::write_application_error_to_out_protocol(&ret_err, o_prot)?;
              o_prot.write_message_end()?;
              o_prot.flush()
            }
          },
          thrift::Error::Application(app_err) => {
            let message_ident = TMessageIdentifier::new("scannerOpen", TMessageType::Exception, incoming_sequence_number);
            o_prot.write_message_begin(&message_ident)?;
            thrift::Error::write_application_error_to_out_protocol(&app_err, o_prot)?;
            o_prot.write_message_end()?;
            o_prot.flush()
          },
          _ => {
            let ret_err = {
              ApplicationError::new(
                ApplicationErrorKind::Unknown,
                e.to_string()
              )
            };
            let message_ident = TMessageIdentifier::new("scannerOpen", TMessageType::Exception, incoming_sequence_number);
            o_prot.write_message_begin(&message_ident)?;
            thrift::Error::write_application_error_to_out_protocol(&ret_err, o_prot)?;
            o_prot.write_message_end()?;
            o_prot.flush()
          },
        }
      },
    }
  }
  pub fn process_scanner_open_with_stop<H: HbaseSyncHandler>(handler: &H, incoming_sequence_number: i32, i_prot: &mut dyn TInputProtocol, o_prot: &mut dyn TOutputProtocol) -> thrift::Result<()> {
    let args = HbaseScannerOpenWithStopArgs::read_from_in_protocol(i_prot)?;
    match handler.handle_scanner_open_with_stop(args.table_name, args.start_row, args.stop_row, args.columns, args.attributes) {
      Ok(handler_return) => {
        let message_ident = TMessageIdentifier::new("scannerOpenWithStop", TMessageType::Reply, incoming_sequence_number);
        o_prot.write_message_begin(&message_ident)?;
        let ret = HbaseScannerOpenWithStopResult { result_value: Some(handler_return), io: None };
        ret.write_to_out_protocol(o_prot)?;
        o_prot.write_message_end()?;
        o_prot.flush()
      },
      Err(e) => {
        match e {
          thrift::Error::User(usr_err) => {
            if usr_err.downcast_ref::<IOError>().is_some() {
              let err = usr_err.downcast::<IOError>().expect("downcast already checked");
              let ret_err = HbaseScannerOpenWithStopResult{ result_value: None, io: Some(*err) };
              let message_ident = TMessageIdentifier::new("scannerOpenWithStop", TMessageType::Reply, incoming_sequence_number);
              o_prot.write_message_begin(&message_ident)?;
              ret_err.write_to_out_protocol(o_prot)?;
              o_prot.write_message_end()?;
              o_prot.flush()
            } else {
              let ret_err = {
                ApplicationError::new(
                  ApplicationErrorKind::Unknown,
                  usr_err.to_string()
                )
              };
              let message_ident = TMessageIdentifier::new("scannerOpenWithStop", TMessageType::Exception, incoming_sequence_number);
              o_prot.write_message_begin(&message_ident)?;
              thrift::Error::write_application_error_to_out_protocol(&ret_err, o_prot)?;
              o_prot.write_message_end()?;
              o_prot.flush()
            }
          },
          thrift::Error::Application(app_err) => {
            let message_ident = TMessageIdentifier::new("scannerOpenWithStop", TMessageType::Exception, incoming_sequence_number);
            o_prot.write_message_begin(&message_ident)?;
            thrift::Error::write_application_error_to_out_protocol(&app_err, o_prot)?;
            o_prot.write_message_end()?;
            o_prot.flush()
          },
          _ => {
            let ret_err = {
              ApplicationError::new(
                ApplicationErrorKind::Unknown,
                e.to_string()
              )
            };
            let message_ident = TMessageIdentifier::new("scannerOpenWithStop", TMessageType::Exception, incoming_sequence_number);
            o_prot.write_message_begin(&message_ident)?;
            thrift::Error::write_application_error_to_out_protocol(&ret_err, o_prot)?;
            o_prot.write_message_end()?;
            o_prot.flush()
          },
        }
      },
    }
  }
  pub fn process_scanner_open_with_prefix<H: HbaseSyncHandler>(handler: &H, incoming_sequence_number: i32, i_prot: &mut dyn TInputProtocol, o_prot: &mut dyn TOutputProtocol) -> thrift::Result<()> {
    let args = HbaseScannerOpenWithPrefixArgs::read_from_in_protocol(i_prot)?;
    match handler.handle_scanner_open_with_prefix(args.table_name, args.start_and_prefix, args.columns, args.attributes) {
      Ok(handler_return) => {
        let message_ident = TMessageIdentifier::new("scannerOpenWithPrefix", TMessageType::Reply, incoming_sequence_number);
        o_prot.write_message_begin(&message_ident)?;
        let ret = HbaseScannerOpenWithPrefixResult { result_value: Some(handler_return), io: None };
        ret.write_to_out_protocol(o_prot)?;
        o_prot.write_message_end()?;
        o_prot.flush()
      },
      Err(e) => {
        match e {
          thrift::Error::User(usr_err) => {
            if usr_err.downcast_ref::<IOError>().is_some() {
              let err = usr_err.downcast::<IOError>().expect("downcast already checked");
              let ret_err = HbaseScannerOpenWithPrefixResult{ result_value: None, io: Some(*err) };
              let message_ident = TMessageIdentifier::new("scannerOpenWithPrefix", TMessageType::Reply, incoming_sequence_number);
              o_prot.write_message_begin(&message_ident)?;
              ret_err.write_to_out_protocol(o_prot)?;
              o_prot.write_message_end()?;
              o_prot.flush()
            } else {
              let ret_err = {
                ApplicationError::new(
                  ApplicationErrorKind::Unknown,
                  usr_err.to_string()
                )
              };
              let message_ident = TMessageIdentifier::new("scannerOpenWithPrefix", TMessageType::Exception, incoming_sequence_number);
              o_prot.write_message_begin(&message_ident)?;
              thrift::Error::write_application_error_to_out_protocol(&ret_err, o_prot)?;
              o_prot.write_message_end()?;
              o_prot.flush()
            }
          },
          thrift::Error::Application(app_err) => {
            let message_ident = TMessageIdentifier::new("scannerOpenWithPrefix", TMessageType::Exception, incoming_sequence_number);
            o_prot.write_message_begin(&message_ident)?;
            thrift::Error::write_application_error_to_out_protocol(&app_err, o_prot)?;
            o_prot.write_message_end()?;
            o_prot.flush()
          },
          _ => {
            let ret_err = {
              ApplicationError::new(
                ApplicationErrorKind::Unknown,
                e.to_string()
              )
            };
            let message_ident = TMessageIdentifier::new("scannerOpenWithPrefix", TMessageType::Exception, incoming_sequence_number);
            o_prot.write_message_begin(&message_ident)?;
            thrift::Error::write_application_error_to_out_protocol(&ret_err, o_prot)?;
            o_prot.write_message_end()?;
            o_prot.flush()
          },
        }
      },
    }
  }
  pub fn process_scanner_open_ts<H: HbaseSyncHandler>(handler: &H, incoming_sequence_number: i32, i_prot: &mut dyn TInputProtocol, o_prot: &mut dyn TOutputProtocol) -> thrift::Result<()> {
    let args = HbaseScannerOpenTsArgs::read_from_in_protocol(i_prot)?;
    match handler.handle_scanner_open_ts(args.table_name, args.start_row, args.columns, args.timestamp, args.attributes) {
      Ok(handler_return) => {
        let message_ident = TMessageIdentifier::new("scannerOpenTs", TMessageType::Reply, incoming_sequence_number);
        o_prot.write_message_begin(&message_ident)?;
        let ret = HbaseScannerOpenTsResult { result_value: Some(handler_return), io: None };
        ret.write_to_out_protocol(o_prot)?;
        o_prot.write_message_end()?;
        o_prot.flush()
      },
      Err(e) => {
        match e {
          thrift::Error::User(usr_err) => {
            if usr_err.downcast_ref::<IOError>().is_some() {
              let err = usr_err.downcast::<IOError>().expect("downcast already checked");
              let ret_err = HbaseScannerOpenTsResult{ result_value: None, io: Some(*err) };
              let message_ident = TMessageIdentifier::new("scannerOpenTs", TMessageType::Reply, incoming_sequence_number);
              o_prot.write_message_begin(&message_ident)?;
              ret_err.write_to_out_protocol(o_prot)?;
              o_prot.write_message_end()?;
              o_prot.flush()
            } else {
              let ret_err = {
                ApplicationError::new(
                  ApplicationErrorKind::Unknown,
                  usr_err.to_string()
                )
              };
              let message_ident = TMessageIdentifier::new("scannerOpenTs", TMessageType::Exception, incoming_sequence_number);
              o_prot.write_message_begin(&message_ident)?;
              thrift::Error::write_application_error_to_out_protocol(&ret_err, o_prot)?;
              o_prot.write_message_end()?;
              o_prot.flush()
            }
          },
          thrift::Error::Application(app_err) => {
            let message_ident = TMessageIdentifier::new("scannerOpenTs", TMessageType::Exception, incoming_sequence_number);
            o_prot.write_message_begin(&message_ident)?;
            thrift::Error::write_application_error_to_out_protocol(&app_err, o_prot)?;
            o_prot.write_message_end()?;
            o_prot.flush()
          },
          _ => {
            let ret_err = {
              ApplicationError::new(
                ApplicationErrorKind::Unknown,
                e.to_string()
              )
            };
            let message_ident = TMessageIdentifier::new("scannerOpenTs", TMessageType::Exception, incoming_sequence_number);
            o_prot.write_message_begin(&message_ident)?;
            thrift::Error::write_application_error_to_out_protocol(&ret_err, o_prot)?;
            o_prot.write_message_end()?;
            o_prot.flush()
          },
        }
      },
    }
  }
  pub fn process_scanner_open_with_stop_ts<H: HbaseSyncHandler>(handler: &H, incoming_sequence_number: i32, i_prot: &mut dyn TInputProtocol, o_prot: &mut dyn TOutputProtocol) -> thrift::Result<()> {
    let args = HbaseScannerOpenWithStopTsArgs::read_from_in_protocol(i_prot)?;
    match handler.handle_scanner_open_with_stop_ts(args.table_name, args.start_row, args.stop_row, args.columns, args.timestamp, args.attributes) {
      Ok(handler_return) => {
        let message_ident = TMessageIdentifier::new("scannerOpenWithStopTs", TMessageType::Reply, incoming_sequence_number);
        o_prot.write_message_begin(&message_ident)?;
        let ret = HbaseScannerOpenWithStopTsResult { result_value: Some(handler_return), io: None };
        ret.write_to_out_protocol(o_prot)?;
        o_prot.write_message_end()?;
        o_prot.flush()
      },
      Err(e) => {
        match e {
          thrift::Error::User(usr_err) => {
            if usr_err.downcast_ref::<IOError>().is_some() {
              let err = usr_err.downcast::<IOError>().expect("downcast already checked");
              let ret_err = HbaseScannerOpenWithStopTsResult{ result_value: None, io: Some(*err) };
              let message_ident = TMessageIdentifier::new("scannerOpenWithStopTs", TMessageType::Reply, incoming_sequence_number);
              o_prot.write_message_begin(&message_ident)?;
              ret_err.write_to_out_protocol(o_prot)?;
              o_prot.write_message_end()?;
              o_prot.flush()
            } else {
              let ret_err = {
                ApplicationError::new(
                  ApplicationErrorKind::Unknown,
                  usr_err.to_string()
                )
              };
              let message_ident = TMessageIdentifier::new("scannerOpenWithStopTs", TMessageType::Exception, incoming_sequence_number);
              o_prot.write_message_begin(&message_ident)?;
              thrift::Error::write_application_error_to_out_protocol(&ret_err, o_prot)?;
              o_prot.write_message_end()?;
              o_prot.flush()
            }
          },
          thrift::Error::Application(app_err) => {
            let message_ident = TMessageIdentifier::new("scannerOpenWithStopTs", TMessageType::Exception, incoming_sequence_number);
            o_prot.write_message_begin(&message_ident)?;
            thrift::Error::write_application_error_to_out_protocol(&app_err, o_prot)?;
            o_prot.write_message_end()?;
            o_prot.flush()
          },
          _ => {
            let ret_err = {
              ApplicationError::new(
                ApplicationErrorKind::Unknown,
                e.to_string()
              )
            };
            let message_ident = TMessageIdentifier::new("scannerOpenWithStopTs", TMessageType::Exception, incoming_sequence_number);
            o_prot.write_message_begin(&message_ident)?;
            thrift::Error::write_application_error_to_out_protocol(&ret_err, o_prot)?;
            o_prot.write_message_end()?;
            o_prot.flush()
          },
        }
      },
    }
  }
  pub fn process_scanner_get<H: HbaseSyncHandler>(handler: &H, incoming_sequence_number: i32, i_prot: &mut dyn TInputProtocol, o_prot: &mut dyn TOutputProtocol) -> thrift::Result<()> {
    let args = HbaseScannerGetArgs::read_from_in_protocol(i_prot)?;
    match handler.handle_scanner_get(args.id) {
      Ok(handler_return) => {
        let message_ident = TMessageIdentifier::new("scannerGet", TMessageType::Reply, incoming_sequence_number);
        o_prot.write_message_begin(&message_ident)?;
        let ret = HbaseScannerGetResult { result_value: Some(handler_return), io: None, ia: None };
        ret.write_to_out_protocol(o_prot)?;
        o_prot.write_message_end()?;
        o_prot.flush()
      },
      Err(e) => {
        match e {
          thrift::Error::User(usr_err) => {
            if usr_err.downcast_ref::<IOError>().is_some() {
              let err = usr_err.downcast::<IOError>().expect("downcast already checked");
              let ret_err = HbaseScannerGetResult{ result_value: None, io: Some(*err), ia: None };
              let message_ident = TMessageIdentifier::new("scannerGet", TMessageType::Reply, incoming_sequence_number);
              o_prot.write_message_begin(&message_ident)?;
              ret_err.write_to_out_protocol(o_prot)?;
              o_prot.write_message_end()?;
              o_prot.flush()
            } else if usr_err.downcast_ref::<IllegalArgument>().is_some() {
              let err = usr_err.downcast::<IllegalArgument>().expect("downcast already checked");
              let ret_err = HbaseScannerGetResult{ result_value: None, io: None, ia: Some(*err) };
              let message_ident = TMessageIdentifier::new("scannerGet", TMessageType::Reply, incoming_sequence_number);
              o_prot.write_message_begin(&message_ident)?;
              ret_err.write_to_out_protocol(o_prot)?;
              o_prot.write_message_end()?;
              o_prot.flush()
            } else {
              let ret_err = {
                ApplicationError::new(
                  ApplicationErrorKind::Unknown,
                  usr_err.to_string()
                )
              };
              let message_ident = TMessageIdentifier::new("scannerGet", TMessageType::Exception, incoming_sequence_number);
              o_prot.write_message_begin(&message_ident)?;
              thrift::Error::write_application_error_to_out_protocol(&ret_err, o_prot)?;
              o_prot.write_message_end()?;
              o_prot.flush()
            }
          },
          thrift::Error::Application(app_err) => {
            let message_ident = TMessageIdentifier::new("scannerGet", TMessageType::Exception, incoming_sequence_number);
            o_prot.write_message_begin(&message_ident)?;
            thrift::Error::write_application_error_to_out_protocol(&app_err, o_prot)?;
            o_prot.write_message_end()?;
            o_prot.flush()
          },
          _ => {
            let ret_err = {
              ApplicationError::new(
                ApplicationErrorKind::Unknown,
                e.to_string()
              )
            };
            let message_ident = TMessageIdentifier::new("scannerGet", TMessageType::Exception, incoming_sequence_number);
            o_prot.write_message_begin(&message_ident)?;
            thrift::Error::write_application_error_to_out_protocol(&ret_err, o_prot)?;
            o_prot.write_message_end()?;
            o_prot.flush()
          },
        }
      },
    }
  }
  pub fn process_scanner_get_list<H: HbaseSyncHandler>(handler: &H, incoming_sequence_number: i32, i_prot: &mut dyn TInputProtocol, o_prot: &mut dyn TOutputProtocol) -> thrift::Result<()> {
    let args = HbaseScannerGetListArgs::read_from_in_protocol(i_prot)?;
    match handler.handle_scanner_get_list(args.id, args.nb_rows) {
      Ok(handler_return) => {
        let message_ident = TMessageIdentifier::new("scannerGetList", TMessageType::Reply, incoming_sequence_number);
        o_prot.write_message_begin(&message_ident)?;
        let ret = HbaseScannerGetListResult { result_value: Some(handler_return), io: None, ia: None };
        ret.write_to_out_protocol(o_prot)?;
        o_prot.write_message_end()?;
        o_prot.flush()
      },
      Err(e) => {
        match e {
          thrift::Error::User(usr_err) => {
            if usr_err.downcast_ref::<IOError>().is_some() {
              let err = usr_err.downcast::<IOError>().expect("downcast already checked");
              let ret_err = HbaseScannerGetListResult{ result_value: None, io: Some(*err), ia: None };
              let message_ident = TMessageIdentifier::new("scannerGetList", TMessageType::Reply, incoming_sequence_number);
              o_prot.write_message_begin(&message_ident)?;
              ret_err.write_to_out_protocol(o_prot)?;
              o_prot.write_message_end()?;
              o_prot.flush()
            } else if usr_err.downcast_ref::<IllegalArgument>().is_some() {
              let err = usr_err.downcast::<IllegalArgument>().expect("downcast already checked");
              let ret_err = HbaseScannerGetListResult{ result_value: None, io: None, ia: Some(*err) };
              let message_ident = TMessageIdentifier::new("scannerGetList", TMessageType::Reply, incoming_sequence_number);
              o_prot.write_message_begin(&message_ident)?;
              ret_err.write_to_out_protocol(o_prot)?;
              o_prot.write_message_end()?;
              o_prot.flush()
            } else {
              let ret_err = {
                ApplicationError::new(
                  ApplicationErrorKind::Unknown,
                  usr_err.to_string()
                )
              };
              let message_ident = TMessageIdentifier::new("scannerGetList", TMessageType::Exception, incoming_sequence_number);
              o_prot.write_message_begin(&message_ident)?;
              thrift::Error::write_application_error_to_out_protocol(&ret_err, o_prot)?;
              o_prot.write_message_end()?;
              o_prot.flush()
            }
          },
          thrift::Error::Application(app_err) => {
            let message_ident = TMessageIdentifier::new("scannerGetList", TMessageType::Exception, incoming_sequence_number);
            o_prot.write_message_begin(&message_ident)?;
            thrift::Error::write_application_error_to_out_protocol(&app_err, o_prot)?;
            o_prot.write_message_end()?;
            o_prot.flush()
          },
          _ => {
            let ret_err = {
              ApplicationError::new(
                ApplicationErrorKind::Unknown,
                e.to_string()
              )
            };
            let message_ident = TMessageIdentifier::new("scannerGetList", TMessageType::Exception, incoming_sequence_number);
            o_prot.write_message_begin(&message_ident)?;
            thrift::Error::write_application_error_to_out_protocol(&ret_err, o_prot)?;
            o_prot.write_message_end()?;
            o_prot.flush()
          },
        }
      },
    }
  }
  pub fn process_scanner_close<H: HbaseSyncHandler>(handler: &H, incoming_sequence_number: i32, i_prot: &mut dyn TInputProtocol, o_prot: &mut dyn TOutputProtocol) -> thrift::Result<()> {
    let args = HbaseScannerCloseArgs::read_from_in_protocol(i_prot)?;
    match handler.handle_scanner_close(args.id) {
      Ok(_) => {
        let message_ident = TMessageIdentifier::new("scannerClose", TMessageType::Reply, incoming_sequence_number);
        o_prot.write_message_begin(&message_ident)?;
        let ret = HbaseScannerCloseResult { io: None, ia: None };
        ret.write_to_out_protocol(o_prot)?;
        o_prot.write_message_end()?;
        o_prot.flush()
      },
      Err(e) => {
        match e {
          thrift::Error::User(usr_err) => {
            if usr_err.downcast_ref::<IOError>().is_some() {
              let err = usr_err.downcast::<IOError>().expect("downcast already checked");
              let ret_err = HbaseScannerCloseResult{ io: Some(*err), ia: None };
              let message_ident = TMessageIdentifier::new("scannerClose", TMessageType::Reply, incoming_sequence_number);
              o_prot.write_message_begin(&message_ident)?;
              ret_err.write_to_out_protocol(o_prot)?;
              o_prot.write_message_end()?;
              o_prot.flush()
            } else if usr_err.downcast_ref::<IllegalArgument>().is_some() {
              let err = usr_err.downcast::<IllegalArgument>().expect("downcast already checked");
              let ret_err = HbaseScannerCloseResult{ io: None, ia: Some(*err) };
              let message_ident = TMessageIdentifier::new("scannerClose", TMessageType::Reply, incoming_sequence_number);
              o_prot.write_message_begin(&message_ident)?;
              ret_err.write_to_out_protocol(o_prot)?;
              o_prot.write_message_end()?;
              o_prot.flush()
            } else {
              let ret_err = {
                ApplicationError::new(
                  ApplicationErrorKind::Unknown,
                  usr_err.to_string()
                )
              };
              let message_ident = TMessageIdentifier::new("scannerClose", TMessageType::Exception, incoming_sequence_number);
              o_prot.write_message_begin(&message_ident)?;
              thrift::Error::write_application_error_to_out_protocol(&ret_err, o_prot)?;
              o_prot.write_message_end()?;
              o_prot.flush()
            }
          },
          thrift::Error::Application(app_err) => {
            let message_ident = TMessageIdentifier::new("scannerClose", TMessageType::Exception, incoming_sequence_number);
            o_prot.write_message_begin(&message_ident)?;
            thrift::Error::write_application_error_to_out_protocol(&app_err, o_prot)?;
            o_prot.write_message_end()?;
            o_prot.flush()
          },
          _ => {
            let ret_err = {
              ApplicationError::new(
                ApplicationErrorKind::Unknown,
                e.to_string()
              )
            };
            let message_ident = TMessageIdentifier::new("scannerClose", TMessageType::Exception, incoming_sequence_number);
            o_prot.write_message_begin(&message_ident)?;
            thrift::Error::write_application_error_to_out_protocol(&ret_err, o_prot)?;
            o_prot.write_message_end()?;
            o_prot.flush()
          },
        }
      },
    }
  }
  pub fn process_get_region_info<H: HbaseSyncHandler>(handler: &H, incoming_sequence_number: i32, i_prot: &mut dyn TInputProtocol, o_prot: &mut dyn TOutputProtocol) -> thrift::Result<()> {
    let args = HbaseGetRegionInfoArgs::read_from_in_protocol(i_prot)?;
    match handler.handle_get_region_info(args.row) {
      Ok(handler_return) => {
        let message_ident = TMessageIdentifier::new("getRegionInfo", TMessageType::Reply, incoming_sequence_number);
        o_prot.write_message_begin(&message_ident)?;
        let ret = HbaseGetRegionInfoResult { result_value: Some(handler_return), io: None };
        ret.write_to_out_protocol(o_prot)?;
        o_prot.write_message_end()?;
        o_prot.flush()
      },
      Err(e) => {
        match e {
          thrift::Error::User(usr_err) => {
            if usr_err.downcast_ref::<IOError>().is_some() {
              let err = usr_err.downcast::<IOError>().expect("downcast already checked");
              let ret_err = HbaseGetRegionInfoResult{ result_value: None, io: Some(*err) };
              let message_ident = TMessageIdentifier::new("getRegionInfo", TMessageType::Reply, incoming_sequence_number);
              o_prot.write_message_begin(&message_ident)?;
              ret_err.write_to_out_protocol(o_prot)?;
              o_prot.write_message_end()?;
              o_prot.flush()
            } else {
              let ret_err = {
                ApplicationError::new(
                  ApplicationErrorKind::Unknown,
                  usr_err.to_string()
                )
              };
              let message_ident = TMessageIdentifier::new("getRegionInfo", TMessageType::Exception, incoming_sequence_number);
              o_prot.write_message_begin(&message_ident)?;
              thrift::Error::write_application_error_to_out_protocol(&ret_err, o_prot)?;
              o_prot.write_message_end()?;
              o_prot.flush()
            }
          },
          thrift::Error::Application(app_err) => {
            let message_ident = TMessageIdentifier::new("getRegionInfo", TMessageType::Exception, incoming_sequence_number);
            o_prot.write_message_begin(&message_ident)?;
            thrift::Error::write_application_error_to_out_protocol(&app_err, o_prot)?;
            o_prot.write_message_end()?;
            o_prot.flush()
          },
          _ => {
            let ret_err = {
              ApplicationError::new(
                ApplicationErrorKind::Unknown,
                e.to_string()
              )
            };
            let message_ident = TMessageIdentifier::new("getRegionInfo", TMessageType::Exception, incoming_sequence_number);
            o_prot.write_message_begin(&message_ident)?;
            thrift::Error::write_application_error_to_out_protocol(&ret_err, o_prot)?;
            o_prot.write_message_end()?;
            o_prot.flush()
          },
        }
      },
    }
  }
  pub fn process_append<H: HbaseSyncHandler>(handler: &H, incoming_sequence_number: i32, i_prot: &mut dyn TInputProtocol, o_prot: &mut dyn TOutputProtocol) -> thrift::Result<()> {
    let args = HbaseAppendArgs::read_from_in_protocol(i_prot)?;
    match handler.handle_append(args.append) {
      Ok(handler_return) => {
        let message_ident = TMessageIdentifier::new("append", TMessageType::Reply, incoming_sequence_number);
        o_prot.write_message_begin(&message_ident)?;
        let ret = HbaseAppendResult { result_value: Some(handler_return), io: None };
        ret.write_to_out_protocol(o_prot)?;
        o_prot.write_message_end()?;
        o_prot.flush()
      },
      Err(e) => {
        match e {
          thrift::Error::User(usr_err) => {
            if usr_err.downcast_ref::<IOError>().is_some() {
              let err = usr_err.downcast::<IOError>().expect("downcast already checked");
              let ret_err = HbaseAppendResult{ result_value: None, io: Some(*err) };
              let message_ident = TMessageIdentifier::new("append", TMessageType::Reply, incoming_sequence_number);
              o_prot.write_message_begin(&message_ident)?;
              ret_err.write_to_out_protocol(o_prot)?;
              o_prot.write_message_end()?;
              o_prot.flush()
            } else {
              let ret_err = {
                ApplicationError::new(
                  ApplicationErrorKind::Unknown,
                  usr_err.to_string()
                )
              };
              let message_ident = TMessageIdentifier::new("append", TMessageType::Exception, incoming_sequence_number);
              o_prot.write_message_begin(&message_ident)?;
              thrift::Error::write_application_error_to_out_protocol(&ret_err, o_prot)?;
              o_prot.write_message_end()?;
              o_prot.flush()
            }
          },
          thrift::Error::Application(app_err) => {
            let message_ident = TMessageIdentifier::new("append", TMessageType::Exception, incoming_sequence_number);
            o_prot.write_message_begin(&message_ident)?;
            thrift::Error::write_application_error_to_out_protocol(&app_err, o_prot)?;
            o_prot.write_message_end()?;
            o_prot.flush()
          },
          _ => {
            let ret_err = {
              ApplicationError::new(
                ApplicationErrorKind::Unknown,
                e.to_string()
              )
            };
            let message_ident = TMessageIdentifier::new("append", TMessageType::Exception, incoming_sequence_number);
            o_prot.write_message_begin(&message_ident)?;
            thrift::Error::write_application_error_to_out_protocol(&ret_err, o_prot)?;
            o_prot.write_message_end()?;
            o_prot.flush()
          },
        }
      },
    }
  }
  pub fn process_check_and_put<H: HbaseSyncHandler>(handler: &H, incoming_sequence_number: i32, i_prot: &mut dyn TInputProtocol, o_prot: &mut dyn TOutputProtocol) -> thrift::Result<()> {
    let args = HbaseCheckAndPutArgs::read_from_in_protocol(i_prot)?;
    match handler.handle_check_and_put(args.table_name, args.row, args.column, args.value, args.mput, args.attributes) {
      Ok(handler_return) => {
        let message_ident = TMessageIdentifier::new("checkAndPut", TMessageType::Reply, incoming_sequence_number);
        o_prot.write_message_begin(&message_ident)?;
        let ret = HbaseCheckAndPutResult { result_value: Some(handler_return), io: None, ia: None };
        ret.write_to_out_protocol(o_prot)?;
        o_prot.write_message_end()?;
        o_prot.flush()
      },
      Err(e) => {
        match e {
          thrift::Error::User(usr_err) => {
            if usr_err.downcast_ref::<IOError>().is_some() {
              let err = usr_err.downcast::<IOError>().expect("downcast already checked");
              let ret_err = HbaseCheckAndPutResult{ result_value: None, io: Some(*err), ia: None };
              let message_ident = TMessageIdentifier::new("checkAndPut", TMessageType::Reply, incoming_sequence_number);
              o_prot.write_message_begin(&message_ident)?;
              ret_err.write_to_out_protocol(o_prot)?;
              o_prot.write_message_end()?;
              o_prot.flush()
            } else if usr_err.downcast_ref::<IllegalArgument>().is_some() {
              let err = usr_err.downcast::<IllegalArgument>().expect("downcast already checked");
              let ret_err = HbaseCheckAndPutResult{ result_value: None, io: None, ia: Some(*err) };
              let message_ident = TMessageIdentifier::new("checkAndPut", TMessageType::Reply, incoming_sequence_number);
              o_prot.write_message_begin(&message_ident)?;
              ret_err.write_to_out_protocol(o_prot)?;
              o_prot.write_message_end()?;
              o_prot.flush()
            } else {
              let ret_err = {
                ApplicationError::new(
                  ApplicationErrorKind::Unknown,
                  usr_err.to_string()
                )
              };
              let message_ident = TMessageIdentifier::new("checkAndPut", TMessageType::Exception, incoming_sequence_number);
              o_prot.write_message_begin(&message_ident)?;
              thrift::Error::write_application_error_to_out_protocol(&ret_err, o_prot)?;
              o_prot.write_message_end()?;
              o_prot.flush()
            }
          },
          thrift::Error::Application(app_err) => {
            let message_ident = TMessageIdentifier::new("checkAndPut", TMessageType::Exception, incoming_sequence_number);
            o_prot.write_message_begin(&message_ident)?;
            thrift::Error::write_application_error_to_out_protocol(&app_err, o_prot)?;
            o_prot.write_message_end()?;
            o_prot.flush()
          },
          _ => {
            let ret_err = {
              ApplicationError::new(
                ApplicationErrorKind::Unknown,
                e.to_string()
              )
            };
            let message_ident = TMessageIdentifier::new("checkAndPut", TMessageType::Exception, incoming_sequence_number);
            o_prot.write_message_begin(&message_ident)?;
            thrift::Error::write_application_error_to_out_protocol(&ret_err, o_prot)?;
            o_prot.write_message_end()?;
            o_prot.flush()
          },
        }
      },
    }
  }
  pub fn process_get_thrift_server_type<H: HbaseSyncHandler>(handler: &H, incoming_sequence_number: i32, i_prot: &mut dyn TInputProtocol, o_prot: &mut dyn TOutputProtocol) -> thrift::Result<()> {
    let _ = HbaseGetThriftServerTypeArgs::read_from_in_protocol(i_prot)?;
    match handler.handle_get_thrift_server_type() {
      Ok(handler_return) => {
        let message_ident = TMessageIdentifier::new("getThriftServerType", TMessageType::Reply, incoming_sequence_number);
        o_prot.write_message_begin(&message_ident)?;
        let ret = HbaseGetThriftServerTypeResult { result_value: Some(handler_return) };
        ret.write_to_out_protocol(o_prot)?;
        o_prot.write_message_end()?;
        o_prot.flush()
      },
      Err(e) => {
        match e {
          thrift::Error::Application(app_err) => {
            let message_ident = TMessageIdentifier::new("getThriftServerType", TMessageType::Exception, incoming_sequence_number);
            o_prot.write_message_begin(&message_ident)?;
            thrift::Error::write_application_error_to_out_protocol(&app_err, o_prot)?;
            o_prot.write_message_end()?;
            o_prot.flush()
          },
          _ => {
            let ret_err = {
              ApplicationError::new(
                ApplicationErrorKind::Unknown,
                e.to_string()
              )
            };
            let message_ident = TMessageIdentifier::new("getThriftServerType", TMessageType::Exception, incoming_sequence_number);
            o_prot.write_message_begin(&message_ident)?;
            thrift::Error::write_application_error_to_out_protocol(&ret_err, o_prot)?;
            o_prot.write_message_end()?;
            o_prot.flush()
          },
        }
      },
    }
  }
  pub fn process_get_cluster_id<H: HbaseSyncHandler>(handler: &H, incoming_sequence_number: i32, i_prot: &mut dyn TInputProtocol, o_prot: &mut dyn TOutputProtocol) -> thrift::Result<()> {
    let _ = HbaseGetClusterIdArgs::read_from_in_protocol(i_prot)?;
    match handler.handle_get_cluster_id() {
      Ok(handler_return) => {
        let message_ident = TMessageIdentifier::new("getClusterId", TMessageType::Reply, incoming_sequence_number);
        o_prot.write_message_begin(&message_ident)?;
        let ret = HbaseGetClusterIdResult { result_value: Some(handler_return) };
        ret.write_to_out_protocol(o_prot)?;
        o_prot.write_message_end()?;
        o_prot.flush()
      },
      Err(e) => {
        match e {
          thrift::Error::Application(app_err) => {
            let message_ident = TMessageIdentifier::new("getClusterId", TMessageType::Exception, incoming_sequence_number);
            o_prot.write_message_begin(&message_ident)?;
            thrift::Error::write_application_error_to_out_protocol(&app_err, o_prot)?;
            o_prot.write_message_end()?;
            o_prot.flush()
          },
          _ => {
            let ret_err = {
              ApplicationError::new(
                ApplicationErrorKind::Unknown,
                e.to_string()
              )
            };
            let message_ident = TMessageIdentifier::new("getClusterId", TMessageType::Exception, incoming_sequence_number);
            o_prot.write_message_begin(&message_ident)?;
            thrift::Error::write_application_error_to_out_protocol(&ret_err, o_prot)?;
            o_prot.write_message_end()?;
            o_prot.flush()
          },
        }
      },
    }
  }
  pub fn process_grant<H: HbaseSyncHandler>(handler: &H, incoming_sequence_number: i32, i_prot: &mut dyn TInputProtocol, o_prot: &mut dyn TOutputProtocol) -> thrift::Result<()> {
    let args = HbaseGrantArgs::read_from_in_protocol(i_prot)?;
    match handler.handle_grant(args.info) {
      Ok(handler_return) => {
        let message_ident = TMessageIdentifier::new("grant", TMessageType::Reply, incoming_sequence_number);
        o_prot.write_message_begin(&message_ident)?;
        let ret = HbaseGrantResult { result_value: Some(handler_return), io: None };
        ret.write_to_out_protocol(o_prot)?;
        o_prot.write_message_end()?;
        o_prot.flush()
      },
      Err(e) => {
        match e {
          thrift::Error::User(usr_err) => {
            if usr_err.downcast_ref::<IOError>().is_some() {
              let err = usr_err.downcast::<IOError>().expect("downcast already checked");
              let ret_err = HbaseGrantResult{ result_value: None, io: Some(*err) };
              let message_ident = TMessageIdentifier::new("grant", TMessageType::Reply, incoming_sequence_number);
              o_prot.write_message_begin(&message_ident)?;
              ret_err.write_to_out_protocol(o_prot)?;
              o_prot.write_message_end()?;
              o_prot.flush()
            } else {
              let ret_err = {
                ApplicationError::new(
                  ApplicationErrorKind::Unknown,
                  usr_err.to_string()
                )
              };
              let message_ident = TMessageIdentifier::new("grant", TMessageType::Exception, incoming_sequence_number);
              o_prot.write_message_begin(&message_ident)?;
              thrift::Error::write_application_error_to_out_protocol(&ret_err, o_prot)?;
              o_prot.write_message_end()?;
              o_prot.flush()
            }
          },
          thrift::Error::Application(app_err) => {
            let message_ident = TMessageIdentifier::new("grant", TMessageType::Exception, incoming_sequence_number);
            o_prot.write_message_begin(&message_ident)?;
            thrift::Error::write_application_error_to_out_protocol(&app_err, o_prot)?;
            o_prot.write_message_end()?;
            o_prot.flush()
          },
          _ => {
            let ret_err = {
              ApplicationError::new(
                ApplicationErrorKind::Unknown,
                e.to_string()
              )
            };
            let message_ident = TMessageIdentifier::new("grant", TMessageType::Exception, incoming_sequence_number);
            o_prot.write_message_begin(&message_ident)?;
            thrift::Error::write_application_error_to_out_protocol(&ret_err, o_prot)?;
            o_prot.write_message_end()?;
            o_prot.flush()
          },
        }
      },
    }
  }
  pub fn process_revoke<H: HbaseSyncHandler>(handler: &H, incoming_sequence_number: i32, i_prot: &mut dyn TInputProtocol, o_prot: &mut dyn TOutputProtocol) -> thrift::Result<()> {
    let args = HbaseRevokeArgs::read_from_in_protocol(i_prot)?;
    match handler.handle_revoke(args.info) {
      Ok(handler_return) => {
        let message_ident = TMessageIdentifier::new("revoke", TMessageType::Reply, incoming_sequence_number);
        o_prot.write_message_begin(&message_ident)?;
        let ret = HbaseRevokeResult { result_value: Some(handler_return), io: None };
        ret.write_to_out_protocol(o_prot)?;
        o_prot.write_message_end()?;
        o_prot.flush()
      },
      Err(e) => {
        match e {
          thrift::Error::User(usr_err) => {
            if usr_err.downcast_ref::<IOError>().is_some() {
              let err = usr_err.downcast::<IOError>().expect("downcast already checked");
              let ret_err = HbaseRevokeResult{ result_value: None, io: Some(*err) };
              let message_ident = TMessageIdentifier::new("revoke", TMessageType::Reply, incoming_sequence_number);
              o_prot.write_message_begin(&message_ident)?;
              ret_err.write_to_out_protocol(o_prot)?;
              o_prot.write_message_end()?;
              o_prot.flush()
            } else {
              let ret_err = {
                ApplicationError::new(
                  ApplicationErrorKind::Unknown,
                  usr_err.to_string()
                )
              };
              let message_ident = TMessageIdentifier::new("revoke", TMessageType::Exception, incoming_sequence_number);
              o_prot.write_message_begin(&message_ident)?;
              thrift::Error::write_application_error_to_out_protocol(&ret_err, o_prot)?;
              o_prot.write_message_end()?;
              o_prot.flush()
            }
          },
          thrift::Error::Application(app_err) => {
            let message_ident = TMessageIdentifier::new("revoke", TMessageType::Exception, incoming_sequence_number);
            o_prot.write_message_begin(&message_ident)?;
            thrift::Error::write_application_error_to_out_protocol(&app_err, o_prot)?;
            o_prot.write_message_end()?;
            o_prot.flush()
          },
          _ => {
            let ret_err = {
              ApplicationError::new(
                ApplicationErrorKind::Unknown,
                e.to_string()
              )
            };
            let message_ident = TMessageIdentifier::new("revoke", TMessageType::Exception, incoming_sequence_number);
            o_prot.write_message_begin(&message_ident)?;
            thrift::Error::write_application_error_to_out_protocol(&ret_err, o_prot)?;
            o_prot.write_message_end()?;
            o_prot.flush()
          },
        }
      },
    }
  }
}

impl <H: HbaseSyncHandler> TProcessor for HbaseSyncProcessor<H> {
  fn process(&self, i_prot: &mut dyn TInputProtocol, o_prot: &mut dyn TOutputProtocol) -> thrift::Result<()> {
    let message_ident = i_prot.read_message_begin()?;
    let res = match &*message_ident.name {
      "enableTable" => {
        self.process_enable_table(message_ident.sequence_number, i_prot, o_prot)
      },
      "disableTable" => {
        self.process_disable_table(message_ident.sequence_number, i_prot, o_prot)
      },
      "isTableEnabled" => {
        self.process_is_table_enabled(message_ident.sequence_number, i_prot, o_prot)
      },
      "compact" => {
        self.process_compact(message_ident.sequence_number, i_prot, o_prot)
      },
      "majorCompact" => {
        self.process_major_compact(message_ident.sequence_number, i_prot, o_prot)
      },
      "getTableNames" => {
        self.process_get_table_names(message_ident.sequence_number, i_prot, o_prot)
      },
      "getTableNamesWithIsTableEnabled" => {
        self.process_get_table_names_with_is_table_enabled(message_ident.sequence_number, i_prot, o_prot)
      },
      "getColumnDescriptors" => {
        self.process_get_column_descriptors(message_ident.sequence_number, i_prot, o_prot)
      },
      "getTableRegions" => {
        self.process_get_table_regions(message_ident.sequence_number, i_prot, o_prot)
      },
      "createTable" => {
        self.process_create_table(message_ident.sequence_number, i_prot, o_prot)
      },
      "deleteTable" => {
        self.process_delete_table(message_ident.sequence_number, i_prot, o_prot)
      },
      "get" => {
        self.process_get(message_ident.sequence_number, i_prot, o_prot)
      },
      "getVer" => {
        self.process_get_ver(message_ident.sequence_number, i_prot, o_prot)
      },
      "getVerTs" => {
        self.process_get_ver_ts(message_ident.sequence_number, i_prot, o_prot)
      },
      "getRow" => {
        self.process_get_row(message_ident.sequence_number, i_prot, o_prot)
      },
      "getRowWithColumns" => {
        self.process_get_row_with_columns(message_ident.sequence_number, i_prot, o_prot)
      },
      "getRowTs" => {
        self.process_get_row_ts(message_ident.sequence_number, i_prot, o_prot)
      },
      "getRowWithColumnsTs" => {
        self.process_get_row_with_columns_ts(message_ident.sequence_number, i_prot, o_prot)
      },
      "getRows" => {
        self.process_get_rows(message_ident.sequence_number, i_prot, o_prot)
      },
      "getRowsWithColumns" => {
        self.process_get_rows_with_columns(message_ident.sequence_number, i_prot, o_prot)
      },
      "getRowsTs" => {
        self.process_get_rows_ts(message_ident.sequence_number, i_prot, o_prot)
      },
      "getRowsWithColumnsTs" => {
        self.process_get_rows_with_columns_ts(message_ident.sequence_number, i_prot, o_prot)
      },
      "mutateRow" => {
        self.process_mutate_row(message_ident.sequence_number, i_prot, o_prot)
      },
      "mutateRowTs" => {
        self.process_mutate_row_ts(message_ident.sequence_number, i_prot, o_prot)
      },
      "mutateRows" => {
        self.process_mutate_rows(message_ident.sequence_number, i_prot, o_prot)
      },
      "mutateRowsTs" => {
        self.process_mutate_rows_ts(message_ident.sequence_number, i_prot, o_prot)
      },
      "atomicIncrement" => {
        self.process_atomic_increment(message_ident.sequence_number, i_prot, o_prot)
      },
      "deleteAll" => {
        self.process_delete_all(message_ident.sequence_number, i_prot, o_prot)
      },
      "deleteAllTs" => {
        self.process_delete_all_ts(message_ident.sequence_number, i_prot, o_prot)
      },
      "deleteAllRow" => {
        self.process_delete_all_row(message_ident.sequence_number, i_prot, o_prot)
      },
      "increment" => {
        self.process_increment(message_ident.sequence_number, i_prot, o_prot)
      },
      "incrementRows" => {
        self.process_increment_rows(message_ident.sequence_number, i_prot, o_prot)
      },
      "deleteAllRowTs" => {
        self.process_delete_all_row_ts(message_ident.sequence_number, i_prot, o_prot)
      },
      "scannerOpenWithScan" => {
        self.process_scanner_open_with_scan(message_ident.sequence_number, i_prot, o_prot)
      },
      "scannerOpen" => {
        self.process_scanner_open(message_ident.sequence_number, i_prot, o_prot)
      },
      "scannerOpenWithStop" => {
        self.process_scanner_open_with_stop(message_ident.sequence_number, i_prot, o_prot)
      },
      "scannerOpenWithPrefix" => {
        self.process_scanner_open_with_prefix(message_ident.sequence_number, i_prot, o_prot)
      },
      "scannerOpenTs" => {
        self.process_scanner_open_ts(message_ident.sequence_number, i_prot, o_prot)
      },
      "scannerOpenWithStopTs" => {
        self.process_scanner_open_with_stop_ts(message_ident.sequence_number, i_prot, o_prot)
      },
      "scannerGet" => {
        self.process_scanner_get(message_ident.sequence_number, i_prot, o_prot)
      },
      "scannerGetList" => {
        self.process_scanner_get_list(message_ident.sequence_number, i_prot, o_prot)
      },
      "scannerClose" => {
        self.process_scanner_close(message_ident.sequence_number, i_prot, o_prot)
      },
      "getRegionInfo" => {
        self.process_get_region_info(message_ident.sequence_number, i_prot, o_prot)
      },
      "append" => {
        self.process_append(message_ident.sequence_number, i_prot, o_prot)
      },
      "checkAndPut" => {
        self.process_check_and_put(message_ident.sequence_number, i_prot, o_prot)
      },
      "getThriftServerType" => {
        self.process_get_thrift_server_type(message_ident.sequence_number, i_prot, o_prot)
      },
      "getClusterId" => {
        self.process_get_cluster_id(message_ident.sequence_number, i_prot, o_prot)
      },
      "grant" => {
        self.process_grant(message_ident.sequence_number, i_prot, o_prot)
      },
      "revoke" => {
        self.process_revoke(message_ident.sequence_number, i_prot, o_prot)
      },
      method => {
        Err(
          thrift::Error::Application(
            ApplicationError::new(
              ApplicationErrorKind::UnknownMethod,
              format!("unknown method {}", method)
            )
          )
        )
      },
    };
    thrift::server::handle_process_result(&message_ident, res, o_prot)
  }
}

//
// HbaseEnableTableArgs
//

#[derive(Clone, Debug, Eq, Hash, Ord, PartialEq, PartialOrd)]
struct HbaseEnableTableArgs {
  /// name of the table
  table_name: Bytes,
}

impl HbaseEnableTableArgs {
  fn read_from_in_protocol(i_prot: &mut dyn TInputProtocol) -> thrift::Result<HbaseEnableTableArgs> {
    i_prot.read_struct_begin()?;
    let mut f_1: Option<Bytes> = None;
    loop {
      let field_ident = i_prot.read_field_begin()?;
      if field_ident.field_type == TType::Stop {
        break;
      }
      let field_id = field_id(&field_ident)?;
      match field_id {
        1 => {
          let val = i_prot.read_bytes()?;
          f_1 = Some(val);
        },
        _ => {
          i_prot.skip(field_ident.field_type)?;
        },
      };
      i_prot.read_field_end()?;
    }
    i_prot.read_struct_end()?;
    verify_required_field_exists("HbaseEnableTableArgs.table_name", &f_1)?;
    let ret = HbaseEnableTableArgs {
      table_name: f_1.expect("auto-generated code should have checked for presence of required fields"),
    };
    Ok(ret)
  }
  fn write_to_out_protocol(&self, o_prot: &mut dyn TOutputProtocol) -> thrift::Result<()> {
    let struct_ident = TStructIdentifier::new("enableTable_args");
    o_prot.write_struct_begin(&struct_ident)?;
    o_prot.write_field_begin(&TFieldIdentifier::new("tableName", TType::String, 1))?;
    o_prot.write_bytes(&self.table_name)?;
    o_prot.write_field_end()?;
    o_prot.write_field_stop()?;
    o_prot.write_struct_end()
  }
}

//
// HbaseEnableTableResult
//

#[derive(Clone, Debug, Eq, Hash, Ord, PartialEq, PartialOrd)]
struct HbaseEnableTableResult {
  io: Option<IOError>,
}

impl HbaseEnableTableResult {
  fn read_from_in_protocol(i_prot: &mut dyn TInputProtocol) -> thrift::Result<HbaseEnableTableResult> {
    i_prot.read_struct_begin()?;
    let mut f_1: Option<IOError> = None;
    loop {
      let field_ident = i_prot.read_field_begin()?;
      if field_ident.field_type == TType::Stop {
        break;
      }
      let field_id = field_id(&field_ident)?;
      match field_id {
        1 => {
          let val = IOError::read_from_in_protocol(i_prot)?;
          f_1 = Some(val);
        },
        _ => {
          i_prot.skip(field_ident.field_type)?;
        },
      };
      i_prot.read_field_end()?;
    }
    i_prot.read_struct_end()?;
    let ret = HbaseEnableTableResult {
      io: f_1,
    };
    Ok(ret)
  }
  fn write_to_out_protocol(&self, o_prot: &mut dyn TOutputProtocol) -> thrift::Result<()> {
    let struct_ident = TStructIdentifier::new("HbaseEnableTableResult");
    o_prot.write_struct_begin(&struct_ident)?;
    if let Some(ref fld_var) = self.io {
      o_prot.write_field_begin(&TFieldIdentifier::new("io", TType::Struct, 1))?;
      fld_var.write_to_out_protocol(o_prot)?;
      o_prot.write_field_end()?
    }
    o_prot.write_field_stop()?;
    o_prot.write_struct_end()
  }
  fn ok_or(self) -> thrift::Result<()> {
    if self.io.is_some() {
      Err(thrift::Error::User(Box::new(self.io.unwrap())))
    } else {
      Ok(())
    }
  }
}

//
// HbaseDisableTableArgs
//

#[derive(Clone, Debug, Eq, Hash, Ord, PartialEq, PartialOrd)]
struct HbaseDisableTableArgs {
  /// name of the table
  table_name: Bytes,
}

impl HbaseDisableTableArgs {
  fn read_from_in_protocol(i_prot: &mut dyn TInputProtocol) -> thrift::Result<HbaseDisableTableArgs> {
    i_prot.read_struct_begin()?;
    let mut f_1: Option<Bytes> = None;
    loop {
      let field_ident = i_prot.read_field_begin()?;
      if field_ident.field_type == TType::Stop {
        break;
      }
      let field_id = field_id(&field_ident)?;
      match field_id {
        1 => {
          let val = i_prot.read_bytes()?;
          f_1 = Some(val);
        },
        _ => {
          i_prot.skip(field_ident.field_type)?;
        },
      };
      i_prot.read_field_end()?;
    }
    i_prot.read_struct_end()?;
    verify_required_field_exists("HbaseDisableTableArgs.table_name", &f_1)?;
    let ret = HbaseDisableTableArgs {
      table_name: f_1.expect("auto-generated code should have checked for presence of required fields"),
    };
    Ok(ret)
  }
  fn write_to_out_protocol(&self, o_prot: &mut dyn TOutputProtocol) -> thrift::Result<()> {
    let struct_ident = TStructIdentifier::new("disableTable_args");
    o_prot.write_struct_begin(&struct_ident)?;
    o_prot.write_field_begin(&TFieldIdentifier::new("tableName", TType::String, 1))?;
    o_prot.write_bytes(&self.table_name)?;
    o_prot.write_field_end()?;
    o_prot.write_field_stop()?;
    o_prot.write_struct_end()
  }
}

//
// HbaseDisableTableResult
//

#[derive(Clone, Debug, Eq, Hash, Ord, PartialEq, PartialOrd)]
struct HbaseDisableTableResult {
  io: Option<IOError>,
}

impl HbaseDisableTableResult {
  fn read_from_in_protocol(i_prot: &mut dyn TInputProtocol) -> thrift::Result<HbaseDisableTableResult> {
    i_prot.read_struct_begin()?;
    let mut f_1: Option<IOError> = None;
    loop {
      let field_ident = i_prot.read_field_begin()?;
      if field_ident.field_type == TType::Stop {
        break;
      }
      let field_id = field_id(&field_ident)?;
      match field_id {
        1 => {
          let val = IOError::read_from_in_protocol(i_prot)?;
          f_1 = Some(val);
        },
        _ => {
          i_prot.skip(field_ident.field_type)?;
        },
      };
      i_prot.read_field_end()?;
    }
    i_prot.read_struct_end()?;
    let ret = HbaseDisableTableResult {
      io: f_1,
    };
    Ok(ret)
  }
  fn write_to_out_protocol(&self, o_prot: &mut dyn TOutputProtocol) -> thrift::Result<()> {
    let struct_ident = TStructIdentifier::new("HbaseDisableTableResult");
    o_prot.write_struct_begin(&struct_ident)?;
    if let Some(ref fld_var) = self.io {
      o_prot.write_field_begin(&TFieldIdentifier::new("io", TType::Struct, 1))?;
      fld_var.write_to_out_protocol(o_prot)?;
      o_prot.write_field_end()?
    }
    o_prot.write_field_stop()?;
    o_prot.write_struct_end()
  }
  fn ok_or(self) -> thrift::Result<()> {
    if self.io.is_some() {
      Err(thrift::Error::User(Box::new(self.io.unwrap())))
    } else {
      Ok(())
    }
  }
}

//
// HbaseIsTableEnabledArgs
//

#[derive(Clone, Debug, Eq, Hash, Ord, PartialEq, PartialOrd)]
struct HbaseIsTableEnabledArgs {
  /// name of the table to check
  table_name: Bytes,
}

impl HbaseIsTableEnabledArgs {
  fn read_from_in_protocol(i_prot: &mut dyn TInputProtocol) -> thrift::Result<HbaseIsTableEnabledArgs> {
    i_prot.read_struct_begin()?;
    let mut f_1: Option<Bytes> = None;
    loop {
      let field_ident = i_prot.read_field_begin()?;
      if field_ident.field_type == TType::Stop {
        break;
      }
      let field_id = field_id(&field_ident)?;
      match field_id {
        1 => {
          let val = i_prot.read_bytes()?;
          f_1 = Some(val);
        },
        _ => {
          i_prot.skip(field_ident.field_type)?;
        },
      };
      i_prot.read_field_end()?;
    }
    i_prot.read_struct_end()?;
    verify_required_field_exists("HbaseIsTableEnabledArgs.table_name", &f_1)?;
    let ret = HbaseIsTableEnabledArgs {
      table_name: f_1.expect("auto-generated code should have checked for presence of required fields"),
    };
    Ok(ret)
  }
  fn write_to_out_protocol(&self, o_prot: &mut dyn TOutputProtocol) -> thrift::Result<()> {
    let struct_ident = TStructIdentifier::new("isTableEnabled_args");
    o_prot.write_struct_begin(&struct_ident)?;
    o_prot.write_field_begin(&TFieldIdentifier::new("tableName", TType::String, 1))?;
    o_prot.write_bytes(&self.table_name)?;
    o_prot.write_field_end()?;
    o_prot.write_field_stop()?;
    o_prot.write_struct_end()
  }
}

//
// HbaseIsTableEnabledResult
//

#[derive(Clone, Debug, Eq, Hash, Ord, PartialEq, PartialOrd)]
struct HbaseIsTableEnabledResult {
  result_value: Option<bool>,
  io: Option<IOError>,
}

impl HbaseIsTableEnabledResult {
  fn read_from_in_protocol(i_prot: &mut dyn TInputProtocol) -> thrift::Result<HbaseIsTableEnabledResult> {
    i_prot.read_struct_begin()?;
    let mut f_0: Option<bool> = None;
    let mut f_1: Option<IOError> = None;
    loop {
      let field_ident = i_prot.read_field_begin()?;
      if field_ident.field_type == TType::Stop {
        break;
      }
      let field_id = field_id(&field_ident)?;
      match field_id {
        0 => {
          let val = i_prot.read_bool()?;
          f_0 = Some(val);
        },
        1 => {
          let val = IOError::read_from_in_protocol(i_prot)?;
          f_1 = Some(val);
        },
        _ => {
          i_prot.skip(field_ident.field_type)?;
        },
      };
      i_prot.read_field_end()?;
    }
    i_prot.read_struct_end()?;
    let ret = HbaseIsTableEnabledResult {
      result_value: f_0,
      io: f_1,
    };
    Ok(ret)
  }
  fn write_to_out_protocol(&self, o_prot: &mut dyn TOutputProtocol) -> thrift::Result<()> {
    let struct_ident = TStructIdentifier::new("HbaseIsTableEnabledResult");
    o_prot.write_struct_begin(&struct_ident)?;
    if let Some(fld_var) = self.result_value {
      o_prot.write_field_begin(&TFieldIdentifier::new("result_value", TType::Bool, 0))?;
      o_prot.write_bool(fld_var)?;
      o_prot.write_field_end()?
    }
    if let Some(ref fld_var) = self.io {
      o_prot.write_field_begin(&TFieldIdentifier::new("io", TType::Struct, 1))?;
      fld_var.write_to_out_protocol(o_prot)?;
      o_prot.write_field_end()?
    }
    o_prot.write_field_stop()?;
    o_prot.write_struct_end()
  }
  fn ok_or(self) -> thrift::Result<bool> {
    if self.io.is_some() {
      Err(thrift::Error::User(Box::new(self.io.unwrap())))
    } else if self.result_value.is_some() {
      Ok(self.result_value.unwrap())
    } else {
      Err(
        thrift::Error::Application(
          ApplicationError::new(
            ApplicationErrorKind::MissingResult,
            "no result received for HbaseIsTableEnabled"
          )
        )
      )
    }
  }
}

//
// HbaseCompactArgs
//

#[derive(Clone, Debug, Eq, Hash, Ord, PartialEq, PartialOrd)]
struct HbaseCompactArgs {
  table_name_or_region_name: Bytes,
}

impl HbaseCompactArgs {
  fn read_from_in_protocol(i_prot: &mut dyn TInputProtocol) -> thrift::Result<HbaseCompactArgs> {
    i_prot.read_struct_begin()?;
    let mut f_1: Option<Bytes> = None;
    loop {
      let field_ident = i_prot.read_field_begin()?;
      if field_ident.field_type == TType::Stop {
        break;
      }
      let field_id = field_id(&field_ident)?;
      match field_id {
        1 => {
          let val = i_prot.read_bytes()?;
          f_1 = Some(val);
        },
        _ => {
          i_prot.skip(field_ident.field_type)?;
        },
      };
      i_prot.read_field_end()?;
    }
    i_prot.read_struct_end()?;
    verify_required_field_exists("HbaseCompactArgs.table_name_or_region_name", &f_1)?;
    let ret = HbaseCompactArgs {
      table_name_or_region_name: f_1.expect("auto-generated code should have checked for presence of required fields"),
    };
    Ok(ret)
  }
  fn write_to_out_protocol(&self, o_prot: &mut dyn TOutputProtocol) -> thrift::Result<()> {
    let struct_ident = TStructIdentifier::new("compact_args");
    o_prot.write_struct_begin(&struct_ident)?;
    o_prot.write_field_begin(&TFieldIdentifier::new("tableNameOrRegionName", TType::String, 1))?;
    o_prot.write_bytes(&self.table_name_or_region_name)?;
    o_prot.write_field_end()?;
    o_prot.write_field_stop()?;
    o_prot.write_struct_end()
  }
}

//
// HbaseCompactResult
//

#[derive(Clone, Debug, Eq, Hash, Ord, PartialEq, PartialOrd)]
struct HbaseCompactResult {
  io: Option<IOError>,
}

impl HbaseCompactResult {
  fn read_from_in_protocol(i_prot: &mut dyn TInputProtocol) -> thrift::Result<HbaseCompactResult> {
    i_prot.read_struct_begin()?;
    let mut f_1: Option<IOError> = None;
    loop {
      let field_ident = i_prot.read_field_begin()?;
      if field_ident.field_type == TType::Stop {
        break;
      }
      let field_id = field_id(&field_ident)?;
      match field_id {
        1 => {
          let val = IOError::read_from_in_protocol(i_prot)?;
          f_1 = Some(val);
        },
        _ => {
          i_prot.skip(field_ident.field_type)?;
        },
      };
      i_prot.read_field_end()?;
    }
    i_prot.read_struct_end()?;
    let ret = HbaseCompactResult {
      io: f_1,
    };
    Ok(ret)
  }
  fn write_to_out_protocol(&self, o_prot: &mut dyn TOutputProtocol) -> thrift::Result<()> {
    let struct_ident = TStructIdentifier::new("HbaseCompactResult");
    o_prot.write_struct_begin(&struct_ident)?;
    if let Some(ref fld_var) = self.io {
      o_prot.write_field_begin(&TFieldIdentifier::new("io", TType::Struct, 1))?;
      fld_var.write_to_out_protocol(o_prot)?;
      o_prot.write_field_end()?
    }
    o_prot.write_field_stop()?;
    o_prot.write_struct_end()
  }
  fn ok_or(self) -> thrift::Result<()> {
    if self.io.is_some() {
      Err(thrift::Error::User(Box::new(self.io.unwrap())))
    } else {
      Ok(())
    }
  }
}

//
// HbaseMajorCompactArgs
//

#[derive(Clone, Debug, Eq, Hash, Ord, PartialEq, PartialOrd)]
struct HbaseMajorCompactArgs {
  table_name_or_region_name: Bytes,
}

impl HbaseMajorCompactArgs {
  fn read_from_in_protocol(i_prot: &mut dyn TInputProtocol) -> thrift::Result<HbaseMajorCompactArgs> {
    i_prot.read_struct_begin()?;
    let mut f_1: Option<Bytes> = None;
    loop {
      let field_ident = i_prot.read_field_begin()?;
      if field_ident.field_type == TType::Stop {
        break;
      }
      let field_id = field_id(&field_ident)?;
      match field_id {
        1 => {
          let val = i_prot.read_bytes()?;
          f_1 = Some(val);
        },
        _ => {
          i_prot.skip(field_ident.field_type)?;
        },
      };
      i_prot.read_field_end()?;
    }
    i_prot.read_struct_end()?;
    verify_required_field_exists("HbaseMajorCompactArgs.table_name_or_region_name", &f_1)?;
    let ret = HbaseMajorCompactArgs {
      table_name_or_region_name: f_1.expect("auto-generated code should have checked for presence of required fields"),
    };
    Ok(ret)
  }
  fn write_to_out_protocol(&self, o_prot: &mut dyn TOutputProtocol) -> thrift::Result<()> {
    let struct_ident = TStructIdentifier::new("majorCompact_args");
    o_prot.write_struct_begin(&struct_ident)?;
    o_prot.write_field_begin(&TFieldIdentifier::new("tableNameOrRegionName", TType::String, 1))?;
    o_prot.write_bytes(&self.table_name_or_region_name)?;
    o_prot.write_field_end()?;
    o_prot.write_field_stop()?;
    o_prot.write_struct_end()
  }
}

//
// HbaseMajorCompactResult
//

#[derive(Clone, Debug, Eq, Hash, Ord, PartialEq, PartialOrd)]
struct HbaseMajorCompactResult {
  io: Option<IOError>,
}

impl HbaseMajorCompactResult {
  fn read_from_in_protocol(i_prot: &mut dyn TInputProtocol) -> thrift::Result<HbaseMajorCompactResult> {
    i_prot.read_struct_begin()?;
    let mut f_1: Option<IOError> = None;
    loop {
      let field_ident = i_prot.read_field_begin()?;
      if field_ident.field_type == TType::Stop {
        break;
      }
      let field_id = field_id(&field_ident)?;
      match field_id {
        1 => {
          let val = IOError::read_from_in_protocol(i_prot)?;
          f_1 = Some(val);
        },
        _ => {
          i_prot.skip(field_ident.field_type)?;
        },
      };
      i_prot.read_field_end()?;
    }
    i_prot.read_struct_end()?;
    let ret = HbaseMajorCompactResult {
      io: f_1,
    };
    Ok(ret)
  }
  fn write_to_out_protocol(&self, o_prot: &mut dyn TOutputProtocol) -> thrift::Result<()> {
    let struct_ident = TStructIdentifier::new("HbaseMajorCompactResult");
    o_prot.write_struct_begin(&struct_ident)?;
    if let Some(ref fld_var) = self.io {
      o_prot.write_field_begin(&TFieldIdentifier::new("io", TType::Struct, 1))?;
      fld_var.write_to_out_protocol(o_prot)?;
      o_prot.write_field_end()?
    }
    o_prot.write_field_stop()?;
    o_prot.write_struct_end()
  }
  fn ok_or(self) -> thrift::Result<()> {
    if self.io.is_some() {
      Err(thrift::Error::User(Box::new(self.io.unwrap())))
    } else {
      Ok(())
    }
  }
}

//
// HbaseGetTableNamesArgs
//

#[derive(Clone, Debug, Eq, Hash, Ord, PartialEq, PartialOrd)]
struct HbaseGetTableNamesArgs {
}

impl HbaseGetTableNamesArgs {
  fn read_from_in_protocol(i_prot: &mut dyn TInputProtocol) -> thrift::Result<HbaseGetTableNamesArgs> {
    i_prot.read_struct_begin()?;
    loop {
      let field_ident = i_prot.read_field_begin()?;
      if field_ident.field_type == TType::Stop {
        break;
      }
      let field_id = field_id(&field_ident)?;
      match field_id {
        _ => {
          i_prot.skip(field_ident.field_type)?;
        },
      };
      i_prot.read_field_end()?;
    }
    i_prot.read_struct_end()?;
    let ret = HbaseGetTableNamesArgs {};
    Ok(ret)
  }
  fn write_to_out_protocol(&self, o_prot: &mut dyn TOutputProtocol) -> thrift::Result<()> {
    let struct_ident = TStructIdentifier::new("getTableNames_args");
    o_prot.write_struct_begin(&struct_ident)?;
    o_prot.write_field_stop()?;
    o_prot.write_struct_end()
  }
}

//
// HbaseGetTableNamesResult
//

#[derive(Clone, Debug, Eq, Hash, Ord, PartialEq, PartialOrd)]
struct HbaseGetTableNamesResult {
  result_value: Option<Vec<Text>>,
  io: Option<IOError>,
}

impl HbaseGetTableNamesResult {
  fn read_from_in_protocol(i_prot: &mut dyn TInputProtocol) -> thrift::Result<HbaseGetTableNamesResult> {
    i_prot.read_struct_begin()?;
    let mut f_0: Option<Vec<Text>> = None;
    let mut f_1: Option<IOError> = None;
    loop {
      let field_ident = i_prot.read_field_begin()?;
      if field_ident.field_type == TType::Stop {
        break;
      }
      let field_id = field_id(&field_ident)?;
      match field_id {
        0 => {
          let list_ident = i_prot.read_list_begin()?;
          let mut val: Vec<Text> = Vec::with_capacity(list_ident.size as usize);
          for _ in 0..list_ident.size {
            let list_elem_7 = i_prot.read_bytes()?;
            val.push(list_elem_7);
          }
          i_prot.read_list_end()?;
          f_0 = Some(val);
        },
        1 => {
          let val = IOError::read_from_in_protocol(i_prot)?;
          f_1 = Some(val);
        },
        _ => {
          i_prot.skip(field_ident.field_type)?;
        },
      };
      i_prot.read_field_end()?;
    }
    i_prot.read_struct_end()?;
    let ret = HbaseGetTableNamesResult {
      result_value: f_0,
      io: f_1,
    };
    Ok(ret)
  }
  fn write_to_out_protocol(&self, o_prot: &mut dyn TOutputProtocol) -> thrift::Result<()> {
    let struct_ident = TStructIdentifier::new("HbaseGetTableNamesResult");
    o_prot.write_struct_begin(&struct_ident)?;
    if let Some(ref fld_var) = self.result_value {
      o_prot.write_field_begin(&TFieldIdentifier::new("result_value", TType::List, 0))?;
      o_prot.write_list_begin(&TListIdentifier::new(TType::String, fld_var.len() as i32))?;
      for e in fld_var {
        o_prot.write_bytes(e)?;
      }
      o_prot.write_list_end()?;
      o_prot.write_field_end()?
    }
    if let Some(ref fld_var) = self.io {
      o_prot.write_field_begin(&TFieldIdentifier::new("io", TType::Struct, 1))?;
      fld_var.write_to_out_protocol(o_prot)?;
      o_prot.write_field_end()?
    }
    o_prot.write_field_stop()?;
    o_prot.write_struct_end()
  }
  fn ok_or(self) -> thrift::Result<Vec<Text>> {
    if self.io.is_some() {
      Err(thrift::Error::User(Box::new(self.io.unwrap())))
    } else if self.result_value.is_some() {
      Ok(self.result_value.unwrap())
    } else {
      Err(
        thrift::Error::Application(
          ApplicationError::new(
            ApplicationErrorKind::MissingResult,
            "no result received for HbaseGetTableNames"
          )
        )
      )
    }
  }
}

//
// HbaseGetTableNamesWithIsTableEnabledArgs
//

#[derive(Clone, Debug, Eq, Hash, Ord, PartialEq, PartialOrd)]
struct HbaseGetTableNamesWithIsTableEnabledArgs {
}

impl HbaseGetTableNamesWithIsTableEnabledArgs {
  fn read_from_in_protocol(i_prot: &mut dyn TInputProtocol) -> thrift::Result<HbaseGetTableNamesWithIsTableEnabledArgs> {
    i_prot.read_struct_begin()?;
    loop {
      let field_ident = i_prot.read_field_begin()?;
      if field_ident.field_type == TType::Stop {
        break;
      }
      let field_id = field_id(&field_ident)?;
      match field_id {
        _ => {
          i_prot.skip(field_ident.field_type)?;
        },
      };
      i_prot.read_field_end()?;
    }
    i_prot.read_struct_end()?;
    let ret = HbaseGetTableNamesWithIsTableEnabledArgs {};
    Ok(ret)
  }
  fn write_to_out_protocol(&self, o_prot: &mut dyn TOutputProtocol) -> thrift::Result<()> {
    let struct_ident = TStructIdentifier::new("getTableNamesWithIsTableEnabled_args");
    o_prot.write_struct_begin(&struct_ident)?;
    o_prot.write_field_stop()?;
    o_prot.write_struct_end()
  }
}

//
// HbaseGetTableNamesWithIsTableEnabledResult
//

#[derive(Clone, Debug, Eq, Hash, Ord, PartialEq, PartialOrd)]
struct HbaseGetTableNamesWithIsTableEnabledResult {
  result_value: Option<BTreeMap<Text, bool>>,
  io: Option<IOError>,
}

impl HbaseGetTableNamesWithIsTableEnabledResult {
  fn read_from_in_protocol(i_prot: &mut dyn TInputProtocol) -> thrift::Result<HbaseGetTableNamesWithIsTableEnabledResult> {
    i_prot.read_struct_begin()?;
    let mut f_0: Option<BTreeMap<Text, bool>> = None;
    let mut f_1: Option<IOError> = None;
    loop {
      let field_ident = i_prot.read_field_begin()?;
      if field_ident.field_type == TType::Stop {
        break;
      }
      let field_id = field_id(&field_ident)?;
      match field_id {
        0 => {
          let map_ident = i_prot.read_map_begin()?;
          let mut val: BTreeMap<Text, bool> = BTreeMap::new();
          for _ in 0..map_ident.size {
            let map_key_8 = i_prot.read_bytes()?;
            let map_val_9 = i_prot.read_bool()?;
            val.insert(map_key_8, map_val_9);
          }
          i_prot.read_map_end()?;
          f_0 = Some(val);
        },
        1 => {
          let val = IOError::read_from_in_protocol(i_prot)?;
          f_1 = Some(val);
        },
        _ => {
          i_prot.skip(field_ident.field_type)?;
        },
      };
      i_prot.read_field_end()?;
    }
    i_prot.read_struct_end()?;
    let ret = HbaseGetTableNamesWithIsTableEnabledResult {
      result_value: f_0,
      io: f_1,
    };
    Ok(ret)
  }
  fn write_to_out_protocol(&self, o_prot: &mut dyn TOutputProtocol) -> thrift::Result<()> {
    let struct_ident = TStructIdentifier::new("HbaseGetTableNamesWithIsTableEnabledResult");
    o_prot.write_struct_begin(&struct_ident)?;
    if let Some(ref fld_var) = self.result_value {
      o_prot.write_field_begin(&TFieldIdentifier::new("result_value", TType::Map, 0))?;
      o_prot.write_map_begin(&TMapIdentifier::new(TType::String, TType::Bool, fld_var.len() as i32))?;
      for (k, v) in fld_var {
        o_prot.write_bytes(k)?;
        o_prot.write_bool(*v)?;
      }
      o_prot.write_map_end()?;
      o_prot.write_field_end()?
    }
    if let Some(ref fld_var) = self.io {
      o_prot.write_field_begin(&TFieldIdentifier::new("io", TType::Struct, 1))?;
      fld_var.write_to_out_protocol(o_prot)?;
      o_prot.write_field_end()?
    }
    o_prot.write_field_stop()?;
    o_prot.write_struct_end()
  }
  fn ok_or(self) -> thrift::Result<BTreeMap<Text, bool>> {
    if self.io.is_some() {
      Err(thrift::Error::User(Box::new(self.io.unwrap())))
    } else if self.result_value.is_some() {
      Ok(self.result_value.unwrap())
    } else {
      Err(
        thrift::Error::Application(
          ApplicationError::new(
            ApplicationErrorKind::MissingResult,
            "no result received for HbaseGetTableNamesWithIsTableEnabled"
          )
        )
      )
    }
  }
}

//
// HbaseGetColumnDescriptorsArgs
//

#[derive(Clone, Debug, Eq, Hash, Ord, PartialEq, PartialOrd)]
struct HbaseGetColumnDescriptorsArgs {
  /// table name
  table_name: Text,
}

impl HbaseGetColumnDescriptorsArgs {
  fn read_from_in_protocol(i_prot: &mut dyn TInputProtocol) -> thrift::Result<HbaseGetColumnDescriptorsArgs> {
    i_prot.read_struct_begin()?;
    let mut f_1: Option<Text> = None;
    loop {
      let field_ident = i_prot.read_field_begin()?;
      if field_ident.field_type == TType::Stop {
        break;
      }
      let field_id = field_id(&field_ident)?;
      match field_id {
        1 => {
          let val = i_prot.read_bytes()?;
          f_1 = Some(val);
        },
        _ => {
          i_prot.skip(field_ident.field_type)?;
        },
      };
      i_prot.read_field_end()?;
    }
    i_prot.read_struct_end()?;
    verify_required_field_exists("HbaseGetColumnDescriptorsArgs.table_name", &f_1)?;
    let ret = HbaseGetColumnDescriptorsArgs {
      table_name: f_1.expect("auto-generated code should have checked for presence of required fields"),
    };
    Ok(ret)
  }
  fn write_to_out_protocol(&self, o_prot: &mut dyn TOutputProtocol) -> thrift::Result<()> {
    let struct_ident = TStructIdentifier::new("getColumnDescriptors_args");
    o_prot.write_struct_begin(&struct_ident)?;
    o_prot.write_field_begin(&TFieldIdentifier::new("tableName", TType::String, 1))?;
    o_prot.write_bytes(&self.table_name)?;
    o_prot.write_field_end()?;
    o_prot.write_field_stop()?;
    o_prot.write_struct_end()
  }
}

//
// HbaseGetColumnDescriptorsResult
//

#[derive(Clone, Debug, Eq, Hash, Ord, PartialEq, PartialOrd)]
struct HbaseGetColumnDescriptorsResult {
  result_value: Option<BTreeMap<Text, ColumnDescriptor>>,
  io: Option<IOError>,
}

impl HbaseGetColumnDescriptorsResult {
  fn read_from_in_protocol(i_prot: &mut dyn TInputProtocol) -> thrift::Result<HbaseGetColumnDescriptorsResult> {
    i_prot.read_struct_begin()?;
    let mut f_0: Option<BTreeMap<Text, ColumnDescriptor>> = None;
    let mut f_1: Option<IOError> = None;
    loop {
      let field_ident = i_prot.read_field_begin()?;
      if field_ident.field_type == TType::Stop {
        break;
      }
      let field_id = field_id(&field_ident)?;
      match field_id {
        0 => {
          let map_ident = i_prot.read_map_begin()?;
          let mut val: BTreeMap<Text, ColumnDescriptor> = BTreeMap::new();
          for _ in 0..map_ident.size {
            let map_key_10 = i_prot.read_bytes()?;
            let map_val_11 = ColumnDescriptor::read_from_in_protocol(i_prot)?;
            val.insert(map_key_10, map_val_11);
          }
          i_prot.read_map_end()?;
          f_0 = Some(val);
        },
        1 => {
          let val = IOError::read_from_in_protocol(i_prot)?;
          f_1 = Some(val);
        },
        _ => {
          i_prot.skip(field_ident.field_type)?;
        },
      };
      i_prot.read_field_end()?;
    }
    i_prot.read_struct_end()?;
    let ret = HbaseGetColumnDescriptorsResult {
      result_value: f_0,
      io: f_1,
    };
    Ok(ret)
  }
  fn write_to_out_protocol(&self, o_prot: &mut dyn TOutputProtocol) -> thrift::Result<()> {
    let struct_ident = TStructIdentifier::new("HbaseGetColumnDescriptorsResult");
    o_prot.write_struct_begin(&struct_ident)?;
    if let Some(ref fld_var) = self.result_value {
      o_prot.write_field_begin(&TFieldIdentifier::new("result_value", TType::Map, 0))?;
      o_prot.write_map_begin(&TMapIdentifier::new(TType::String, TType::Struct, fld_var.len() as i32))?;
      for (k, v) in fld_var {
        o_prot.write_bytes(k)?;
        v.write_to_out_protocol(o_prot)?;
      }
      o_prot.write_map_end()?;
      o_prot.write_field_end()?
    }
    if let Some(ref fld_var) = self.io {
      o_prot.write_field_begin(&TFieldIdentifier::new("io", TType::Struct, 1))?;
      fld_var.write_to_out_protocol(o_prot)?;
      o_prot.write_field_end()?
    }
    o_prot.write_field_stop()?;
    o_prot.write_struct_end()
  }
  fn ok_or(self) -> thrift::Result<BTreeMap<Text, ColumnDescriptor>> {
    if self.io.is_some() {
      Err(thrift::Error::User(Box::new(self.io.unwrap())))
    } else if self.result_value.is_some() {
      Ok(self.result_value.unwrap())
    } else {
      Err(
        thrift::Error::Application(
          ApplicationError::new(
            ApplicationErrorKind::MissingResult,
            "no result received for HbaseGetColumnDescriptors"
          )
        )
      )
    }
  }
}

//
// HbaseGetTableRegionsArgs
//

#[derive(Clone, Debug, Eq, Hash, Ord, PartialEq, PartialOrd)]
struct HbaseGetTableRegionsArgs {
  /// table name
  table_name: Text,
}

impl HbaseGetTableRegionsArgs {
  fn read_from_in_protocol(i_prot: &mut dyn TInputProtocol) -> thrift::Result<HbaseGetTableRegionsArgs> {
    i_prot.read_struct_begin()?;
    let mut f_1: Option<Text> = None;
    loop {
      let field_ident = i_prot.read_field_begin()?;
      if field_ident.field_type == TType::Stop {
        break;
      }
      let field_id = field_id(&field_ident)?;
      match field_id {
        1 => {
          let val = i_prot.read_bytes()?;
          f_1 = Some(val);
        },
        _ => {
          i_prot.skip(field_ident.field_type)?;
        },
      };
      i_prot.read_field_end()?;
    }
    i_prot.read_struct_end()?;
    verify_required_field_exists("HbaseGetTableRegionsArgs.table_name", &f_1)?;
    let ret = HbaseGetTableRegionsArgs {
      table_name: f_1.expect("auto-generated code should have checked for presence of required fields"),
    };
    Ok(ret)
  }
  fn write_to_out_protocol(&self, o_prot: &mut dyn TOutputProtocol) -> thrift::Result<()> {
    let struct_ident = TStructIdentifier::new("getTableRegions_args");
    o_prot.write_struct_begin(&struct_ident)?;
    o_prot.write_field_begin(&TFieldIdentifier::new("tableName", TType::String, 1))?;
    o_prot.write_bytes(&self.table_name)?;
    o_prot.write_field_end()?;
    o_prot.write_field_stop()?;
    o_prot.write_struct_end()
  }
}

//
// HbaseGetTableRegionsResult
//

#[derive(Clone, Debug, Eq, Hash, Ord, PartialEq, PartialOrd)]
struct HbaseGetTableRegionsResult {
  result_value: Option<Vec<TRegionInfo>>,
  io: Option<IOError>,
}

impl HbaseGetTableRegionsResult {
  fn read_from_in_protocol(i_prot: &mut dyn TInputProtocol) -> thrift::Result<HbaseGetTableRegionsResult> {
    i_prot.read_struct_begin()?;
    let mut f_0: Option<Vec<TRegionInfo>> = None;
    let mut f_1: Option<IOError> = None;
    loop {
      let field_ident = i_prot.read_field_begin()?;
      if field_ident.field_type == TType::Stop {
        break;
      }
      let field_id = field_id(&field_ident)?;
      match field_id {
        0 => {
          let list_ident = i_prot.read_list_begin()?;
          let mut val: Vec<TRegionInfo> = Vec::with_capacity(list_ident.size as usize);
          for _ in 0..list_ident.size {
            let list_elem_12 = TRegionInfo::read_from_in_protocol(i_prot)?;
            val.push(list_elem_12);
          }
          i_prot.read_list_end()?;
          f_0 = Some(val);
        },
        1 => {
          let val = IOError::read_from_in_protocol(i_prot)?;
          f_1 = Some(val);
        },
        _ => {
          i_prot.skip(field_ident.field_type)?;
        },
      };
      i_prot.read_field_end()?;
    }
    i_prot.read_struct_end()?;
    let ret = HbaseGetTableRegionsResult {
      result_value: f_0,
      io: f_1,
    };
    Ok(ret)
  }
  fn write_to_out_protocol(&self, o_prot: &mut dyn TOutputProtocol) -> thrift::Result<()> {
    let struct_ident = TStructIdentifier::new("HbaseGetTableRegionsResult");
    o_prot.write_struct_begin(&struct_ident)?;
    if let Some(ref fld_var) = self.result_value {
      o_prot.write_field_begin(&TFieldIdentifier::new("result_value", TType::List, 0))?;
      o_prot.write_list_begin(&TListIdentifier::new(TType::Struct, fld_var.len() as i32))?;
      for e in fld_var {
        e.write_to_out_protocol(o_prot)?;
      }
      o_prot.write_list_end()?;
      o_prot.write_field_end()?
    }
    if let Some(ref fld_var) = self.io {
      o_prot.write_field_begin(&TFieldIdentifier::new("io", TType::Struct, 1))?;
      fld_var.write_to_out_protocol(o_prot)?;
      o_prot.write_field_end()?
    }
    o_prot.write_field_stop()?;
    o_prot.write_struct_end()
  }
  fn ok_or(self) -> thrift::Result<Vec<TRegionInfo>> {
    if self.io.is_some() {
      Err(thrift::Error::User(Box::new(self.io.unwrap())))
    } else if self.result_value.is_some() {
      Ok(self.result_value.unwrap())
    } else {
      Err(
        thrift::Error::Application(
          ApplicationError::new(
            ApplicationErrorKind::MissingResult,
            "no result received for HbaseGetTableRegions"
          )
        )
      )
    }
  }
}

//
// HbaseCreateTableArgs
//

#[derive(Clone, Debug, Eq, Hash, Ord, PartialEq, PartialOrd)]
struct HbaseCreateTableArgs {
  /// name of table to create
  table_name: Text,
  /// list of column family descriptors
  column_families: Vec<ColumnDescriptor>,
}

impl HbaseCreateTableArgs {
  fn read_from_in_protocol(i_prot: &mut dyn TInputProtocol) -> thrift::Result<HbaseCreateTableArgs> {
    i_prot.read_struct_begin()?;
    let mut f_1: Option<Text> = None;
    let mut f_2: Option<Vec<ColumnDescriptor>> = None;
    loop {
      let field_ident = i_prot.read_field_begin()?;
      if field_ident.field_type == TType::Stop {
        break;
      }
      let field_id = field_id(&field_ident)?;
      match field_id {
        1 => {
          let val = i_prot.read_bytes()?;
          f_1 = Some(val);
        },
        2 => {
          let list_ident = i_prot.read_list_begin()?;
          let mut val: Vec<ColumnDescriptor> = Vec::with_capacity(list_ident.size as usize);
          for _ in 0..list_ident.size {
            let list_elem_13 = ColumnDescriptor::read_from_in_protocol(i_prot)?;
            val.push(list_elem_13);
          }
          i_prot.read_list_end()?;
          f_2 = Some(val);
        },
        _ => {
          i_prot.skip(field_ident.field_type)?;
        },
      };
      i_prot.read_field_end()?;
    }
    i_prot.read_struct_end()?;
    verify_required_field_exists("HbaseCreateTableArgs.table_name", &f_1)?;
    verify_required_field_exists("HbaseCreateTableArgs.column_families", &f_2)?;
    let ret = HbaseCreateTableArgs {
      table_name: f_1.expect("auto-generated code should have checked for presence of required fields"),
      column_families: f_2.expect("auto-generated code should have checked for presence of required fields"),
    };
    Ok(ret)
  }
  fn write_to_out_protocol(&self, o_prot: &mut dyn TOutputProtocol) -> thrift::Result<()> {
    let struct_ident = TStructIdentifier::new("createTable_args");
    o_prot.write_struct_begin(&struct_ident)?;
    o_prot.write_field_begin(&TFieldIdentifier::new("tableName", TType::String, 1))?;
    o_prot.write_bytes(&self.table_name)?;
    o_prot.write_field_end()?;
    o_prot.write_field_begin(&TFieldIdentifier::new("columnFamilies", TType::List, 2))?;
    o_prot.write_list_begin(&TListIdentifier::new(TType::Struct, self.column_families.len() as i32))?;
    for e in &self.column_families {
      e.write_to_out_protocol(o_prot)?;
    }
    o_prot.write_list_end()?;
    o_prot.write_field_end()?;
    o_prot.write_field_stop()?;
    o_prot.write_struct_end()
  }
}

//
// HbaseCreateTableResult
//

#[derive(Clone, Debug, Eq, Hash, Ord, PartialEq, PartialOrd)]
struct HbaseCreateTableResult {
  io: Option<IOError>,
  ia: Option<IllegalArgument>,
  exist: Option<AlreadyExists>,
}

impl HbaseCreateTableResult {
  fn read_from_in_protocol(i_prot: &mut dyn TInputProtocol) -> thrift::Result<HbaseCreateTableResult> {
    i_prot.read_struct_begin()?;
    let mut f_1: Option<IOError> = None;
    let mut f_2: Option<IllegalArgument> = None;
    let mut f_3: Option<AlreadyExists> = None;
    loop {
      let field_ident = i_prot.read_field_begin()?;
      if field_ident.field_type == TType::Stop {
        break;
      }
      let field_id = field_id(&field_ident)?;
      match field_id {
        1 => {
          let val = IOError::read_from_in_protocol(i_prot)?;
          f_1 = Some(val);
        },
        2 => {
          let val = IllegalArgument::read_from_in_protocol(i_prot)?;
          f_2 = Some(val);
        },
        3 => {
          let val = AlreadyExists::read_from_in_protocol(i_prot)?;
          f_3 = Some(val);
        },
        _ => {
          i_prot.skip(field_ident.field_type)?;
        },
      };
      i_prot.read_field_end()?;
    }
    i_prot.read_struct_end()?;
    let ret = HbaseCreateTableResult {
      io: f_1,
      ia: f_2,
      exist: f_3,
    };
    Ok(ret)
  }
  fn write_to_out_protocol(&self, o_prot: &mut dyn TOutputProtocol) -> thrift::Result<()> {
    let struct_ident = TStructIdentifier::new("HbaseCreateTableResult");
    o_prot.write_struct_begin(&struct_ident)?;
    if let Some(ref fld_var) = self.io {
      o_prot.write_field_begin(&TFieldIdentifier::new("io", TType::Struct, 1))?;
      fld_var.write_to_out_protocol(o_prot)?;
      o_prot.write_field_end()?
    }
    if let Some(ref fld_var) = self.ia {
      o_prot.write_field_begin(&TFieldIdentifier::new("ia", TType::Struct, 2))?;
      fld_var.write_to_out_protocol(o_prot)?;
      o_prot.write_field_end()?
    }
    if let Some(ref fld_var) = self.exist {
      o_prot.write_field_begin(&TFieldIdentifier::new("exist", TType::Struct, 3))?;
      fld_var.write_to_out_protocol(o_prot)?;
      o_prot.write_field_end()?
    }
    o_prot.write_field_stop()?;
    o_prot.write_struct_end()
  }
  fn ok_or(self) -> thrift::Result<()> {
    if self.io.is_some() {
      Err(thrift::Error::User(Box::new(self.io.unwrap())))
    } else if self.ia.is_some() {
      Err(thrift::Error::User(Box::new(self.ia.unwrap())))
    } else if self.exist.is_some() {
      Err(thrift::Error::User(Box::new(self.exist.unwrap())))
    } else {
      Ok(())
    }
  }
}

//
// HbaseDeleteTableArgs
//

#[derive(Clone, Debug, Eq, Hash, Ord, PartialEq, PartialOrd)]
struct HbaseDeleteTableArgs {
  /// name of table to delete
  table_name: Text,
}

impl HbaseDeleteTableArgs {
  fn read_from_in_protocol(i_prot: &mut dyn TInputProtocol) -> thrift::Result<HbaseDeleteTableArgs> {
    i_prot.read_struct_begin()?;
    let mut f_1: Option<Text> = None;
    loop {
      let field_ident = i_prot.read_field_begin()?;
      if field_ident.field_type == TType::Stop {
        break;
      }
      let field_id = field_id(&field_ident)?;
      match field_id {
        1 => {
          let val = i_prot.read_bytes()?;
          f_1 = Some(val);
        },
        _ => {
          i_prot.skip(field_ident.field_type)?;
        },
      };
      i_prot.read_field_end()?;
    }
    i_prot.read_struct_end()?;
    verify_required_field_exists("HbaseDeleteTableArgs.table_name", &f_1)?;
    let ret = HbaseDeleteTableArgs {
      table_name: f_1.expect("auto-generated code should have checked for presence of required fields"),
    };
    Ok(ret)
  }
  fn write_to_out_protocol(&self, o_prot: &mut dyn TOutputProtocol) -> thrift::Result<()> {
    let struct_ident = TStructIdentifier::new("deleteTable_args");
    o_prot.write_struct_begin(&struct_ident)?;
    o_prot.write_field_begin(&TFieldIdentifier::new("tableName", TType::String, 1))?;
    o_prot.write_bytes(&self.table_name)?;
    o_prot.write_field_end()?;
    o_prot.write_field_stop()?;
    o_prot.write_struct_end()
  }
}

//
// HbaseDeleteTableResult
//

#[derive(Clone, Debug, Eq, Hash, Ord, PartialEq, PartialOrd)]
struct HbaseDeleteTableResult {
  io: Option<IOError>,
}

impl HbaseDeleteTableResult {
  fn read_from_in_protocol(i_prot: &mut dyn TInputProtocol) -> thrift::Result<HbaseDeleteTableResult> {
    i_prot.read_struct_begin()?;
    let mut f_1: Option<IOError> = None;
    loop {
      let field_ident = i_prot.read_field_begin()?;
      if field_ident.field_type == TType::Stop {
        break;
      }
      let field_id = field_id(&field_ident)?;
      match field_id {
        1 => {
          let val = IOError::read_from_in_protocol(i_prot)?;
          f_1 = Some(val);
        },
        _ => {
          i_prot.skip(field_ident.field_type)?;
        },
      };
      i_prot.read_field_end()?;
    }
    i_prot.read_struct_end()?;
    let ret = HbaseDeleteTableResult {
      io: f_1,
    };
    Ok(ret)
  }
  fn write_to_out_protocol(&self, o_prot: &mut dyn TOutputProtocol) -> thrift::Result<()> {
    let struct_ident = TStructIdentifier::new("HbaseDeleteTableResult");
    o_prot.write_struct_begin(&struct_ident)?;
    if let Some(ref fld_var) = self.io {
      o_prot.write_field_begin(&TFieldIdentifier::new("io", TType::Struct, 1))?;
      fld_var.write_to_out_protocol(o_prot)?;
      o_prot.write_field_end()?
    }
    o_prot.write_field_stop()?;
    o_prot.write_struct_end()
  }
  fn ok_or(self) -> thrift::Result<()> {
    if self.io.is_some() {
      Err(thrift::Error::User(Box::new(self.io.unwrap())))
    } else {
      Ok(())
    }
  }
}

//
// HbaseGetArgs
//

#[derive(Clone, Debug, Eq, Hash, Ord, PartialEq, PartialOrd)]
struct HbaseGetArgs {
  /// name of table
  table_name: Text,
  /// row key
  row: Text,
  /// column name
  column: Text,
  /// Get attributes
  attributes: BTreeMap<Text, Text>,
}

impl HbaseGetArgs {
  fn read_from_in_protocol(i_prot: &mut dyn TInputProtocol) -> thrift::Result<HbaseGetArgs> {
    i_prot.read_struct_begin()?;
    let mut f_1: Option<Text> = None;
    let mut f_2: Option<Text> = None;
    let mut f_3: Option<Text> = None;
    let mut f_4: Option<BTreeMap<Text, Text>> = None;
    loop {
      let field_ident = i_prot.read_field_begin()?;
      if field_ident.field_type == TType::Stop {
        break;
      }
      let field_id = field_id(&field_ident)?;
      match field_id {
        1 => {
          let val = i_prot.read_bytes()?;
          f_1 = Some(val);
        },
        2 => {
          let val = i_prot.read_bytes()?;
          f_2 = Some(val);
        },
        3 => {
          let val = i_prot.read_bytes()?;
          f_3 = Some(val);
        },
        4 => {
          let map_ident = i_prot.read_map_begin()?;
          let mut val: BTreeMap<Text, Text> = BTreeMap::new();
          for _ in 0..map_ident.size {
            let map_key_14 = i_prot.read_bytes()?;
            let map_val_15 = i_prot.read_bytes()?;
            val.insert(map_key_14, map_val_15);
          }
          i_prot.read_map_end()?;
          f_4 = Some(val);
        },
        _ => {
          i_prot.skip(field_ident.field_type)?;
        },
      };
      i_prot.read_field_end()?;
    }
    i_prot.read_struct_end()?;
    verify_required_field_exists("HbaseGetArgs.table_name", &f_1)?;
    verify_required_field_exists("HbaseGetArgs.row", &f_2)?;
    verify_required_field_exists("HbaseGetArgs.column", &f_3)?;
    verify_required_field_exists("HbaseGetArgs.attributes", &f_4)?;
    let ret = HbaseGetArgs {
      table_name: f_1.expect("auto-generated code should have checked for presence of required fields"),
      row: f_2.expect("auto-generated code should have checked for presence of required fields"),
      column: f_3.expect("auto-generated code should have checked for presence of required fields"),
      attributes: f_4.expect("auto-generated code should have checked for presence of required fields"),
    };
    Ok(ret)
  }
  fn write_to_out_protocol(&self, o_prot: &mut dyn TOutputProtocol) -> thrift::Result<()> {
    let struct_ident = TStructIdentifier::new("get_args");
    o_prot.write_struct_begin(&struct_ident)?;
    o_prot.write_field_begin(&TFieldIdentifier::new("tableName", TType::String, 1))?;
    o_prot.write_bytes(&self.table_name)?;
    o_prot.write_field_end()?;
    o_prot.write_field_begin(&TFieldIdentifier::new("row", TType::String, 2))?;
    o_prot.write_bytes(&self.row)?;
    o_prot.write_field_end()?;
    o_prot.write_field_begin(&TFieldIdentifier::new("column", TType::String, 3))?;
    o_prot.write_bytes(&self.column)?;
    o_prot.write_field_end()?;
    o_prot.write_field_begin(&TFieldIdentifier::new("attributes", TType::Map, 4))?;
    o_prot.write_map_begin(&TMapIdentifier::new(TType::String, TType::String, self.attributes.len() as i32))?;
    for (k, v) in &self.attributes {
      o_prot.write_bytes(k)?;
      o_prot.write_bytes(v)?;
    }
    o_prot.write_map_end()?;
    o_prot.write_field_end()?;
    o_prot.write_field_stop()?;
    o_prot.write_struct_end()
  }
}

//
// HbaseGetResult
//

#[derive(Clone, Debug, Eq, Hash, Ord, PartialEq, PartialOrd)]
struct HbaseGetResult {
  result_value: Option<Vec<TCell>>,
  io: Option<IOError>,
}

impl HbaseGetResult {
  fn read_from_in_protocol(i_prot: &mut dyn TInputProtocol) -> thrift::Result<HbaseGetResult> {
    i_prot.read_struct_begin()?;
    let mut f_0: Option<Vec<TCell>> = None;
    let mut f_1: Option<IOError> = None;
    loop {
      let field_ident = i_prot.read_field_begin()?;
      if field_ident.field_type == TType::Stop {
        break;
      }
      let field_id = field_id(&field_ident)?;
      match field_id {
        0 => {
          let list_ident = i_prot.read_list_begin()?;
          let mut val: Vec<TCell> = Vec::with_capacity(list_ident.size as usize);
          for _ in 0..list_ident.size {
            let list_elem_16 = TCell::read_from_in_protocol(i_prot)?;
            val.push(list_elem_16);
          }
          i_prot.read_list_end()?;
          f_0 = Some(val);
        },
        1 => {
          let val = IOError::read_from_in_protocol(i_prot)?;
          f_1 = Some(val);
        },
        _ => {
          i_prot.skip(field_ident.field_type)?;
        },
      };
      i_prot.read_field_end()?;
    }
    i_prot.read_struct_end()?;
    let ret = HbaseGetResult {
      result_value: f_0,
      io: f_1,
    };
    Ok(ret)
  }
  fn write_to_out_protocol(&self, o_prot: &mut dyn TOutputProtocol) -> thrift::Result<()> {
    let struct_ident = TStructIdentifier::new("HbaseGetResult");
    o_prot.write_struct_begin(&struct_ident)?;
    if let Some(ref fld_var) = self.result_value {
      o_prot.write_field_begin(&TFieldIdentifier::new("result_value", TType::List, 0))?;
      o_prot.write_list_begin(&TListIdentifier::new(TType::Struct, fld_var.len() as i32))?;
      for e in fld_var {
        e.write_to_out_protocol(o_prot)?;
      }
      o_prot.write_list_end()?;
      o_prot.write_field_end()?
    }
    if let Some(ref fld_var) = self.io {
      o_prot.write_field_begin(&TFieldIdentifier::new("io", TType::Struct, 1))?;
      fld_var.write_to_out_protocol(o_prot)?;
      o_prot.write_field_end()?
    }
    o_prot.write_field_stop()?;
    o_prot.write_struct_end()
  }
  fn ok_or(self) -> thrift::Result<Vec<TCell>> {
    if self.io.is_some() {
      Err(thrift::Error::User(Box::new(self.io.unwrap())))
    } else if self.result_value.is_some() {
      Ok(self.result_value.unwrap())
    } else {
      Err(
        thrift::Error::Application(
          ApplicationError::new(
            ApplicationErrorKind::MissingResult,
            "no result received for HbaseGet"
          )
        )
      )
    }
  }
}

//
// HbaseGetVerArgs
//

#[derive(Clone, Debug, Eq, Hash, Ord, PartialEq, PartialOrd)]
struct HbaseGetVerArgs {
  /// name of table
  table_name: Text,
  /// row key
  row: Text,
  /// column name
  column: Text,
  /// number of versions to retrieve
  num_versions: i32,
  /// Get attributes
  attributes: BTreeMap<Text, Text>,
}

impl HbaseGetVerArgs {
  fn read_from_in_protocol(i_prot: &mut dyn TInputProtocol) -> thrift::Result<HbaseGetVerArgs> {
    i_prot.read_struct_begin()?;
    let mut f_1: Option<Text> = None;
    let mut f_2: Option<Text> = None;
    let mut f_3: Option<Text> = None;
    let mut f_4: Option<i32> = None;
    let mut f_5: Option<BTreeMap<Text, Text>> = None;
    loop {
      let field_ident = i_prot.read_field_begin()?;
      if field_ident.field_type == TType::Stop {
        break;
      }
      let field_id = field_id(&field_ident)?;
      match field_id {
        1 => {
          let val = i_prot.read_bytes()?;
          f_1 = Some(val);
        },
        2 => {
          let val = i_prot.read_bytes()?;
          f_2 = Some(val);
        },
        3 => {
          let val = i_prot.read_bytes()?;
          f_3 = Some(val);
        },
        4 => {
          let val = i_prot.read_i32()?;
          f_4 = Some(val);
        },
        5 => {
          let map_ident = i_prot.read_map_begin()?;
          let mut val: BTreeMap<Text, Text> = BTreeMap::new();
          for _ in 0..map_ident.size {
            let map_key_17 = i_prot.read_bytes()?;
            let map_val_18 = i_prot.read_bytes()?;
            val.insert(map_key_17, map_val_18);
          }
          i_prot.read_map_end()?;
          f_5 = Some(val);
        },
        _ => {
          i_prot.skip(field_ident.field_type)?;
        },
      };
      i_prot.read_field_end()?;
    }
    i_prot.read_struct_end()?;
    verify_required_field_exists("HbaseGetVerArgs.table_name", &f_1)?;
    verify_required_field_exists("HbaseGetVerArgs.row", &f_2)?;
    verify_required_field_exists("HbaseGetVerArgs.column", &f_3)?;
    verify_required_field_exists("HbaseGetVerArgs.num_versions", &f_4)?;
    verify_required_field_exists("HbaseGetVerArgs.attributes", &f_5)?;
    let ret = HbaseGetVerArgs {
      table_name: f_1.expect("auto-generated code should have checked for presence of required fields"),
      row: f_2.expect("auto-generated code should have checked for presence of required fields"),
      column: f_3.expect("auto-generated code should have checked for presence of required fields"),
      num_versions: f_4.expect("auto-generated code should have checked for presence of required fields"),
      attributes: f_5.expect("auto-generated code should have checked for presence of required fields"),
    };
    Ok(ret)
  }
  fn write_to_out_protocol(&self, o_prot: &mut dyn TOutputProtocol) -> thrift::Result<()> {
    let struct_ident = TStructIdentifier::new("getVer_args");
    o_prot.write_struct_begin(&struct_ident)?;
    o_prot.write_field_begin(&TFieldIdentifier::new("tableName", TType::String, 1))?;
    o_prot.write_bytes(&self.table_name)?;
    o_prot.write_field_end()?;
    o_prot.write_field_begin(&TFieldIdentifier::new("row", TType::String, 2))?;
    o_prot.write_bytes(&self.row)?;
    o_prot.write_field_end()?;
    o_prot.write_field_begin(&TFieldIdentifier::new("column", TType::String, 3))?;
    o_prot.write_bytes(&self.column)?;
    o_prot.write_field_end()?;
    o_prot.write_field_begin(&TFieldIdentifier::new("numVersions", TType::I32, 4))?;
    o_prot.write_i32(self.num_versions)?;
    o_prot.write_field_end()?;
    o_prot.write_field_begin(&TFieldIdentifier::new("attributes", TType::Map, 5))?;
    o_prot.write_map_begin(&TMapIdentifier::new(TType::String, TType::String, self.attributes.len() as i32))?;
    for (k, v) in &self.attributes {
      o_prot.write_bytes(k)?;
      o_prot.write_bytes(v)?;
    }
    o_prot.write_map_end()?;
    o_prot.write_field_end()?;
    o_prot.write_field_stop()?;
    o_prot.write_struct_end()
  }
}

//
// HbaseGetVerResult
//

#[derive(Clone, Debug, Eq, Hash, Ord, PartialEq, PartialOrd)]
struct HbaseGetVerResult {
  result_value: Option<Vec<TCell>>,
  io: Option<IOError>,
}

impl HbaseGetVerResult {
  fn read_from_in_protocol(i_prot: &mut dyn TInputProtocol) -> thrift::Result<HbaseGetVerResult> {
    i_prot.read_struct_begin()?;
    let mut f_0: Option<Vec<TCell>> = None;
    let mut f_1: Option<IOError> = None;
    loop {
      let field_ident = i_prot.read_field_begin()?;
      if field_ident.field_type == TType::Stop {
        break;
      }
      let field_id = field_id(&field_ident)?;
      match field_id {
        0 => {
          let list_ident = i_prot.read_list_begin()?;
          let mut val: Vec<TCell> = Vec::with_capacity(list_ident.size as usize);
          for _ in 0..list_ident.size {
            let list_elem_19 = TCell::read_from_in_protocol(i_prot)?;
            val.push(list_elem_19);
          }
          i_prot.read_list_end()?;
          f_0 = Some(val);
        },
        1 => {
          let val = IOError::read_from_in_protocol(i_prot)?;
          f_1 = Some(val);
        },
        _ => {
          i_prot.skip(field_ident.field_type)?;
        },
      };
      i_prot.read_field_end()?;
    }
    i_prot.read_struct_end()?;
    let ret = HbaseGetVerResult {
      result_value: f_0,
      io: f_1,
    };
    Ok(ret)
  }
  fn write_to_out_protocol(&self, o_prot: &mut dyn TOutputProtocol) -> thrift::Result<()> {
    let struct_ident = TStructIdentifier::new("HbaseGetVerResult");
    o_prot.write_struct_begin(&struct_ident)?;
    if let Some(ref fld_var) = self.result_value {
      o_prot.write_field_begin(&TFieldIdentifier::new("result_value", TType::List, 0))?;
      o_prot.write_list_begin(&TListIdentifier::new(TType::Struct, fld_var.len() as i32))?;
      for e in fld_var {
        e.write_to_out_protocol(o_prot)?;
      }
      o_prot.write_list_end()?;
      o_prot.write_field_end()?
    }
    if let Some(ref fld_var) = self.io {
      o_prot.write_field_begin(&TFieldIdentifier::new("io", TType::Struct, 1))?;
      fld_var.write_to_out_protocol(o_prot)?;
      o_prot.write_field_end()?
    }
    o_prot.write_field_stop()?;
    o_prot.write_struct_end()
  }
  fn ok_or(self) -> thrift::Result<Vec<TCell>> {
    if self.io.is_some() {
      Err(thrift::Error::User(Box::new(self.io.unwrap())))
    } else if self.result_value.is_some() {
      Ok(self.result_value.unwrap())
    } else {
      Err(
        thrift::Error::Application(
          ApplicationError::new(
            ApplicationErrorKind::MissingResult,
            "no result received for HbaseGetVer"
          )
        )
      )
    }
  }
}

//
// HbaseGetVerTsArgs
//

#[derive(Clone, Debug, Eq, Hash, Ord, PartialEq, PartialOrd)]
struct HbaseGetVerTsArgs {
  /// name of table
  table_name: Text,
  /// row key
  row: Text,
  /// column name
  column: Text,
  /// timestamp
  timestamp: i64,
  /// number of versions to retrieve
  num_versions: i32,
  /// Get attributes
  attributes: BTreeMap<Text, Text>,
}

impl HbaseGetVerTsArgs {
  fn read_from_in_protocol(i_prot: &mut dyn TInputProtocol) -> thrift::Result<HbaseGetVerTsArgs> {
    i_prot.read_struct_begin()?;
    let mut f_1: Option<Text> = None;
    let mut f_2: Option<Text> = None;
    let mut f_3: Option<Text> = None;
    let mut f_4: Option<i64> = None;
    let mut f_5: Option<i32> = None;
    let mut f_6: Option<BTreeMap<Text, Text>> = None;
    loop {
      let field_ident = i_prot.read_field_begin()?;
      if field_ident.field_type == TType::Stop {
        break;
      }
      let field_id = field_id(&field_ident)?;
      match field_id {
        1 => {
          let val = i_prot.read_bytes()?;
          f_1 = Some(val);
        },
        2 => {
          let val = i_prot.read_bytes()?;
          f_2 = Some(val);
        },
        3 => {
          let val = i_prot.read_bytes()?;
          f_3 = Some(val);
        },
        4 => {
          let val = i_prot.read_i64()?;
          f_4 = Some(val);
        },
        5 => {
          let val = i_prot.read_i32()?;
          f_5 = Some(val);
        },
        6 => {
          let map_ident = i_prot.read_map_begin()?;
          let mut val: BTreeMap<Text, Text> = BTreeMap::new();
          for _ in 0..map_ident.size {
            let map_key_20 = i_prot.read_bytes()?;
            let map_val_21 = i_prot.read_bytes()?;
            val.insert(map_key_20, map_val_21);
          }
          i_prot.read_map_end()?;
          f_6 = Some(val);
        },
        _ => {
          i_prot.skip(field_ident.field_type)?;
        },
      };
      i_prot.read_field_end()?;
    }
    i_prot.read_struct_end()?;
    verify_required_field_exists("HbaseGetVerTsArgs.table_name", &f_1)?;
    verify_required_field_exists("HbaseGetVerTsArgs.row", &f_2)?;
    verify_required_field_exists("HbaseGetVerTsArgs.column", &f_3)?;
    verify_required_field_exists("HbaseGetVerTsArgs.timestamp", &f_4)?;
    verify_required_field_exists("HbaseGetVerTsArgs.num_versions", &f_5)?;
    verify_required_field_exists("HbaseGetVerTsArgs.attributes", &f_6)?;
    let ret = HbaseGetVerTsArgs {
      table_name: f_1.expect("auto-generated code should have checked for presence of required fields"),
      row: f_2.expect("auto-generated code should have checked for presence of required fields"),
      column: f_3.expect("auto-generated code should have checked for presence of required fields"),
      timestamp: f_4.expect("auto-generated code should have checked for presence of required fields"),
      num_versions: f_5.expect("auto-generated code should have checked for presence of required fields"),
      attributes: f_6.expect("auto-generated code should have checked for presence of required fields"),
    };
    Ok(ret)
  }
  fn write_to_out_protocol(&self, o_prot: &mut dyn TOutputProtocol) -> thrift::Result<()> {
    let struct_ident = TStructIdentifier::new("getVerTs_args");
    o_prot.write_struct_begin(&struct_ident)?;
    o_prot.write_field_begin(&TFieldIdentifier::new("tableName", TType::String, 1))?;
    o_prot.write_bytes(&self.table_name)?;
    o_prot.write_field_end()?;
    o_prot.write_field_begin(&TFieldIdentifier::new("row", TType::String, 2))?;
    o_prot.write_bytes(&self.row)?;
    o_prot.write_field_end()?;
    o_prot.write_field_begin(&TFieldIdentifier::new("column", TType::String, 3))?;
    o_prot.write_bytes(&self.column)?;
    o_prot.write_field_end()?;
    o_prot.write_field_begin(&TFieldIdentifier::new("timestamp", TType::I64, 4))?;
    o_prot.write_i64(self.timestamp)?;
    o_prot.write_field_end()?;
    o_prot.write_field_begin(&TFieldIdentifier::new("numVersions", TType::I32, 5))?;
    o_prot.write_i32(self.num_versions)?;
    o_prot.write_field_end()?;
    o_prot.write_field_begin(&TFieldIdentifier::new("attributes", TType::Map, 6))?;
    o_prot.write_map_begin(&TMapIdentifier::new(TType::String, TType::String, self.attributes.len() as i32))?;
    for (k, v) in &self.attributes {
      o_prot.write_bytes(k)?;
      o_prot.write_bytes(v)?;
    }
    o_prot.write_map_end()?;
    o_prot.write_field_end()?;
    o_prot.write_field_stop()?;
    o_prot.write_struct_end()
  }
}

//
// HbaseGetVerTsResult
//

#[derive(Clone, Debug, Eq, Hash, Ord, PartialEq, PartialOrd)]
struct HbaseGetVerTsResult {
  result_value: Option<Vec<TCell>>,
  io: Option<IOError>,
}

impl HbaseGetVerTsResult {
  fn read_from_in_protocol(i_prot: &mut dyn TInputProtocol) -> thrift::Result<HbaseGetVerTsResult> {
    i_prot.read_struct_begin()?;
    let mut f_0: Option<Vec<TCell>> = None;
    let mut f_1: Option<IOError> = None;
    loop {
      let field_ident = i_prot.read_field_begin()?;
      if field_ident.field_type == TType::Stop {
        break;
      }
      let field_id = field_id(&field_ident)?;
      match field_id {
        0 => {
          let list_ident = i_prot.read_list_begin()?;
          let mut val: Vec<TCell> = Vec::with_capacity(list_ident.size as usize);
          for _ in 0..list_ident.size {
            let list_elem_22 = TCell::read_from_in_protocol(i_prot)?;
            val.push(list_elem_22);
          }
          i_prot.read_list_end()?;
          f_0 = Some(val);
        },
        1 => {
          let val = IOError::read_from_in_protocol(i_prot)?;
          f_1 = Some(val);
        },
        _ => {
          i_prot.skip(field_ident.field_type)?;
        },
      };
      i_prot.read_field_end()?;
    }
    i_prot.read_struct_end()?;
    let ret = HbaseGetVerTsResult {
      result_value: f_0,
      io: f_1,
    };
    Ok(ret)
  }
  fn write_to_out_protocol(&self, o_prot: &mut dyn TOutputProtocol) -> thrift::Result<()> {
    let struct_ident = TStructIdentifier::new("HbaseGetVerTsResult");
    o_prot.write_struct_begin(&struct_ident)?;
    if let Some(ref fld_var) = self.result_value {
      o_prot.write_field_begin(&TFieldIdentifier::new("result_value", TType::List, 0))?;
      o_prot.write_list_begin(&TListIdentifier::new(TType::Struct, fld_var.len() as i32))?;
      for e in fld_var {
        e.write_to_out_protocol(o_prot)?;
      }
      o_prot.write_list_end()?;
      o_prot.write_field_end()?
    }
    if let Some(ref fld_var) = self.io {
      o_prot.write_field_begin(&TFieldIdentifier::new("io", TType::Struct, 1))?;
      fld_var.write_to_out_protocol(o_prot)?;
      o_prot.write_field_end()?
    }
    o_prot.write_field_stop()?;
    o_prot.write_struct_end()
  }
  fn ok_or(self) -> thrift::Result<Vec<TCell>> {
    if self.io.is_some() {
      Err(thrift::Error::User(Box::new(self.io.unwrap())))
    } else if self.result_value.is_some() {
      Ok(self.result_value.unwrap())
    } else {
      Err(
        thrift::Error::Application(
          ApplicationError::new(
            ApplicationErrorKind::MissingResult,
            "no result received for HbaseGetVerTs"
          )
        )
      )
    }
  }
}

//
// HbaseGetRowArgs
//

#[derive(Clone, Debug, Eq, Hash, Ord, PartialEq, PartialOrd)]
struct HbaseGetRowArgs {
  /// name of table
  table_name: Text,
  /// row key
  row: Text,
  /// Get attributes
  attributes: BTreeMap<Text, Text>,
}

impl HbaseGetRowArgs {
  fn read_from_in_protocol(i_prot: &mut dyn TInputProtocol) -> thrift::Result<HbaseGetRowArgs> {
    i_prot.read_struct_begin()?;
    let mut f_1: Option<Text> = None;
    let mut f_2: Option<Text> = None;
    let mut f_3: Option<BTreeMap<Text, Text>> = None;
    loop {
      let field_ident = i_prot.read_field_begin()?;
      if field_ident.field_type == TType::Stop {
        break;
      }
      let field_id = field_id(&field_ident)?;
      match field_id {
        1 => {
          let val = i_prot.read_bytes()?;
          f_1 = Some(val);
        },
        2 => {
          let val = i_prot.read_bytes()?;
          f_2 = Some(val);
        },
        3 => {
          let map_ident = i_prot.read_map_begin()?;
          let mut val: BTreeMap<Text, Text> = BTreeMap::new();
          for _ in 0..map_ident.size {
            let map_key_23 = i_prot.read_bytes()?;
            let map_val_24 = i_prot.read_bytes()?;
            val.insert(map_key_23, map_val_24);
          }
          i_prot.read_map_end()?;
          f_3 = Some(val);
        },
        _ => {
          i_prot.skip(field_ident.field_type)?;
        },
      };
      i_prot.read_field_end()?;
    }
    i_prot.read_struct_end()?;
    verify_required_field_exists("HbaseGetRowArgs.table_name", &f_1)?;
    verify_required_field_exists("HbaseGetRowArgs.row", &f_2)?;
    verify_required_field_exists("HbaseGetRowArgs.attributes", &f_3)?;
    let ret = HbaseGetRowArgs {
      table_name: f_1.expect("auto-generated code should have checked for presence of required fields"),
      row: f_2.expect("auto-generated code should have checked for presence of required fields"),
      attributes: f_3.expect("auto-generated code should have checked for presence of required fields"),
    };
    Ok(ret)
  }
  fn write_to_out_protocol(&self, o_prot: &mut dyn TOutputProtocol) -> thrift::Result<()> {
    let struct_ident = TStructIdentifier::new("getRow_args");
    o_prot.write_struct_begin(&struct_ident)?;
    o_prot.write_field_begin(&TFieldIdentifier::new("tableName", TType::String, 1))?;
    o_prot.write_bytes(&self.table_name)?;
    o_prot.write_field_end()?;
    o_prot.write_field_begin(&TFieldIdentifier::new("row", TType::String, 2))?;
    o_prot.write_bytes(&self.row)?;
    o_prot.write_field_end()?;
    o_prot.write_field_begin(&TFieldIdentifier::new("attributes", TType::Map, 3))?;
    o_prot.write_map_begin(&TMapIdentifier::new(TType::String, TType::String, self.attributes.len() as i32))?;
    for (k, v) in &self.attributes {
      o_prot.write_bytes(k)?;
      o_prot.write_bytes(v)?;
    }
    o_prot.write_map_end()?;
    o_prot.write_field_end()?;
    o_prot.write_field_stop()?;
    o_prot.write_struct_end()
  }
}

//
// HbaseGetRowResult
//

#[derive(Clone, Debug, Eq, Hash, Ord, PartialEq, PartialOrd)]
struct HbaseGetRowResult {
  result_value: Option<Vec<TRowResult>>,
  io: Option<IOError>,
}

impl HbaseGetRowResult {
  fn read_from_in_protocol(i_prot: &mut dyn TInputProtocol) -> thrift::Result<HbaseGetRowResult> {
    i_prot.read_struct_begin()?;
    let mut f_0: Option<Vec<TRowResult>> = None;
    let mut f_1: Option<IOError> = None;
    loop {
      let field_ident = i_prot.read_field_begin()?;
      if field_ident.field_type == TType::Stop {
        break;
      }
      let field_id = field_id(&field_ident)?;
      match field_id {
        0 => {
          let list_ident = i_prot.read_list_begin()?;
          let mut val: Vec<TRowResult> = Vec::with_capacity(list_ident.size as usize);
          for _ in 0..list_ident.size {
            let list_elem_25 = TRowResult::read_from_in_protocol(i_prot)?;
            val.push(list_elem_25);
          }
          i_prot.read_list_end()?;
          f_0 = Some(val);
        },
        1 => {
          let val = IOError::read_from_in_protocol(i_prot)?;
          f_1 = Some(val);
        },
        _ => {
          i_prot.skip(field_ident.field_type)?;
        },
      };
      i_prot.read_field_end()?;
    }
    i_prot.read_struct_end()?;
    let ret = HbaseGetRowResult {
      result_value: f_0,
      io: f_1,
    };
    Ok(ret)
  }
  fn write_to_out_protocol(&self, o_prot: &mut dyn TOutputProtocol) -> thrift::Result<()> {
    let struct_ident = TStructIdentifier::new("HbaseGetRowResult");
    o_prot.write_struct_begin(&struct_ident)?;
    if let Some(ref fld_var) = self.result_value {
      o_prot.write_field_begin(&TFieldIdentifier::new("result_value", TType::List, 0))?;
      o_prot.write_list_begin(&TListIdentifier::new(TType::Struct, fld_var.len() as i32))?;
      for e in fld_var {
        e.write_to_out_protocol(o_prot)?;
      }
      o_prot.write_list_end()?;
      o_prot.write_field_end()?
    }
    if let Some(ref fld_var) = self.io {
      o_prot.write_field_begin(&TFieldIdentifier::new("io", TType::Struct, 1))?;
      fld_var.write_to_out_protocol(o_prot)?;
      o_prot.write_field_end()?
    }
    o_prot.write_field_stop()?;
    o_prot.write_struct_end()
  }
  fn ok_or(self) -> thrift::Result<Vec<TRowResult>> {
    if self.io.is_some() {
      Err(thrift::Error::User(Box::new(self.io.unwrap())))
    } else if self.result_value.is_some() {
      Ok(self.result_value.unwrap())
    } else {
      Err(
        thrift::Error::Application(
          ApplicationError::new(
            ApplicationErrorKind::MissingResult,
            "no result received for HbaseGetRow"
          )
        )
      )
    }
  }
}

//
// HbaseGetRowWithColumnsArgs
//

#[derive(Clone, Debug, Eq, Hash, Ord, PartialEq, PartialOrd)]
struct HbaseGetRowWithColumnsArgs {
  /// name of table
  table_name: Text,
  /// row key
  row: Text,
  /// List of columns to return, null for all columns
  columns: Vec<Text>,
  /// Get attributes
  attributes: BTreeMap<Text, Text>,
}

impl HbaseGetRowWithColumnsArgs {
  fn read_from_in_protocol(i_prot: &mut dyn TInputProtocol) -> thrift::Result<HbaseGetRowWithColumnsArgs> {
    i_prot.read_struct_begin()?;
    let mut f_1: Option<Text> = None;
    let mut f_2: Option<Text> = None;
    let mut f_3: Option<Vec<Text>> = None;
    let mut f_4: Option<BTreeMap<Text, Text>> = None;
    loop {
      let field_ident = i_prot.read_field_begin()?;
      if field_ident.field_type == TType::Stop {
        break;
      }
      let field_id = field_id(&field_ident)?;
      match field_id {
        1 => {
          let val = i_prot.read_bytes()?;
          f_1 = Some(val);
        },
        2 => {
          let val = i_prot.read_bytes()?;
          f_2 = Some(val);
        },
        3 => {
          let list_ident = i_prot.read_list_begin()?;
          let mut val: Vec<Text> = Vec::with_capacity(list_ident.size as usize);
          for _ in 0..list_ident.size {
            let list_elem_26 = i_prot.read_bytes()?;
            val.push(list_elem_26);
          }
          i_prot.read_list_end()?;
          f_3 = Some(val);
        },
        4 => {
          let map_ident = i_prot.read_map_begin()?;
          let mut val: BTreeMap<Text, Text> = BTreeMap::new();
          for _ in 0..map_ident.size {
            let map_key_27 = i_prot.read_bytes()?;
            let map_val_28 = i_prot.read_bytes()?;
            val.insert(map_key_27, map_val_28);
          }
          i_prot.read_map_end()?;
          f_4 = Some(val);
        },
        _ => {
          i_prot.skip(field_ident.field_type)?;
        },
      };
      i_prot.read_field_end()?;
    }
    i_prot.read_struct_end()?;
    verify_required_field_exists("HbaseGetRowWithColumnsArgs.table_name", &f_1)?;
    verify_required_field_exists("HbaseGetRowWithColumnsArgs.row", &f_2)?;
    verify_required_field_exists("HbaseGetRowWithColumnsArgs.columns", &f_3)?;
    verify_required_field_exists("HbaseGetRowWithColumnsArgs.attributes", &f_4)?;
    let ret = HbaseGetRowWithColumnsArgs {
      table_name: f_1.expect("auto-generated code should have checked for presence of required fields"),
      row: f_2.expect("auto-generated code should have checked for presence of required fields"),
      columns: f_3.expect("auto-generated code should have checked for presence of required fields"),
      attributes: f_4.expect("auto-generated code should have checked for presence of required fields"),
    };
    Ok(ret)
  }
  fn write_to_out_protocol(&self, o_prot: &mut dyn TOutputProtocol) -> thrift::Result<()> {
    let struct_ident = TStructIdentifier::new("getRowWithColumns_args");
    o_prot.write_struct_begin(&struct_ident)?;
    o_prot.write_field_begin(&TFieldIdentifier::new("tableName", TType::String, 1))?;
    o_prot.write_bytes(&self.table_name)?;
    o_prot.write_field_end()?;
    o_prot.write_field_begin(&TFieldIdentifier::new("row", TType::String, 2))?;
    o_prot.write_bytes(&self.row)?;
    o_prot.write_field_end()?;
    o_prot.write_field_begin(&TFieldIdentifier::new("columns", TType::List, 3))?;
    o_prot.write_list_begin(&TListIdentifier::new(TType::String, self.columns.len() as i32))?;
    for e in &self.columns {
      o_prot.write_bytes(e)?;
    }
    o_prot.write_list_end()?;
    o_prot.write_field_end()?;
    o_prot.write_field_begin(&TFieldIdentifier::new("attributes", TType::Map, 4))?;
    o_prot.write_map_begin(&TMapIdentifier::new(TType::String, TType::String, self.attributes.len() as i32))?;
    for (k, v) in &self.attributes {
      o_prot.write_bytes(k)?;
      o_prot.write_bytes(v)?;
    }
    o_prot.write_map_end()?;
    o_prot.write_field_end()?;
    o_prot.write_field_stop()?;
    o_prot.write_struct_end()
  }
}

//
// HbaseGetRowWithColumnsResult
//

#[derive(Clone, Debug, Eq, Hash, Ord, PartialEq, PartialOrd)]
struct HbaseGetRowWithColumnsResult {
  result_value: Option<Vec<TRowResult>>,
  io: Option<IOError>,
}

impl HbaseGetRowWithColumnsResult {
  fn read_from_in_protocol(i_prot: &mut dyn TInputProtocol) -> thrift::Result<HbaseGetRowWithColumnsResult> {
    i_prot.read_struct_begin()?;
    let mut f_0: Option<Vec<TRowResult>> = None;
    let mut f_1: Option<IOError> = None;
    loop {
      let field_ident = i_prot.read_field_begin()?;
      if field_ident.field_type == TType::Stop {
        break;
      }
      let field_id = field_id(&field_ident)?;
      match field_id {
        0 => {
          let list_ident = i_prot.read_list_begin()?;
          let mut val: Vec<TRowResult> = Vec::with_capacity(list_ident.size as usize);
          for _ in 0..list_ident.size {
            let list_elem_29 = TRowResult::read_from_in_protocol(i_prot)?;
            val.push(list_elem_29);
          }
          i_prot.read_list_end()?;
          f_0 = Some(val);
        },
        1 => {
          let val = IOError::read_from_in_protocol(i_prot)?;
          f_1 = Some(val);
        },
        _ => {
          i_prot.skip(field_ident.field_type)?;
        },
      };
      i_prot.read_field_end()?;
    }
    i_prot.read_struct_end()?;
    let ret = HbaseGetRowWithColumnsResult {
      result_value: f_0,
      io: f_1,
    };
    Ok(ret)
  }
  fn write_to_out_protocol(&self, o_prot: &mut dyn TOutputProtocol) -> thrift::Result<()> {
    let struct_ident = TStructIdentifier::new("HbaseGetRowWithColumnsResult");
    o_prot.write_struct_begin(&struct_ident)?;
    if let Some(ref fld_var) = self.result_value {
      o_prot.write_field_begin(&TFieldIdentifier::new("result_value", TType::List, 0))?;
      o_prot.write_list_begin(&TListIdentifier::new(TType::Struct, fld_var.len() as i32))?;
      for e in fld_var {
        e.write_to_out_protocol(o_prot)?;
      }
      o_prot.write_list_end()?;
      o_prot.write_field_end()?
    }
    if let Some(ref fld_var) = self.io {
      o_prot.write_field_begin(&TFieldIdentifier::new("io", TType::Struct, 1))?;
      fld_var.write_to_out_protocol(o_prot)?;
      o_prot.write_field_end()?
    }
    o_prot.write_field_stop()?;
    o_prot.write_struct_end()
  }
  fn ok_or(self) -> thrift::Result<Vec<TRowResult>> {
    if self.io.is_some() {
      Err(thrift::Error::User(Box::new(self.io.unwrap())))
    } else if self.result_value.is_some() {
      Ok(self.result_value.unwrap())
    } else {
      Err(
        thrift::Error::Application(
          ApplicationError::new(
            ApplicationErrorKind::MissingResult,
            "no result received for HbaseGetRowWithColumns"
          )
        )
      )
    }
  }
}

//
// HbaseGetRowTsArgs
//

#[derive(Clone, Debug, Eq, Hash, Ord, PartialEq, PartialOrd)]
struct HbaseGetRowTsArgs {
  /// name of the table
  table_name: Text,
  /// row key
  row: Text,
  /// timestamp
  timestamp: i64,
  /// Get attributes
  attributes: BTreeMap<Text, Text>,
}

impl HbaseGetRowTsArgs {
  fn read_from_in_protocol(i_prot: &mut dyn TInputProtocol) -> thrift::Result<HbaseGetRowTsArgs> {
    i_prot.read_struct_begin()?;
    let mut f_1: Option<Text> = None;
    let mut f_2: Option<Text> = None;
    let mut f_3: Option<i64> = None;
    let mut f_4: Option<BTreeMap<Text, Text>> = None;
    loop {
      let field_ident = i_prot.read_field_begin()?;
      if field_ident.field_type == TType::Stop {
        break;
      }
      let field_id = field_id(&field_ident)?;
      match field_id {
        1 => {
          let val = i_prot.read_bytes()?;
          f_1 = Some(val);
        },
        2 => {
          let val = i_prot.read_bytes()?;
          f_2 = Some(val);
        },
        3 => {
          let val = i_prot.read_i64()?;
          f_3 = Some(val);
        },
        4 => {
          let map_ident = i_prot.read_map_begin()?;
          let mut val: BTreeMap<Text, Text> = BTreeMap::new();
          for _ in 0..map_ident.size {
            let map_key_30 = i_prot.read_bytes()?;
            let map_val_31 = i_prot.read_bytes()?;
            val.insert(map_key_30, map_val_31);
          }
          i_prot.read_map_end()?;
          f_4 = Some(val);
        },
        _ => {
          i_prot.skip(field_ident.field_type)?;
        },
      };
      i_prot.read_field_end()?;
    }
    i_prot.read_struct_end()?;
    verify_required_field_exists("HbaseGetRowTsArgs.table_name", &f_1)?;
    verify_required_field_exists("HbaseGetRowTsArgs.row", &f_2)?;
    verify_required_field_exists("HbaseGetRowTsArgs.timestamp", &f_3)?;
    verify_required_field_exists("HbaseGetRowTsArgs.attributes", &f_4)?;
    let ret = HbaseGetRowTsArgs {
      table_name: f_1.expect("auto-generated code should have checked for presence of required fields"),
      row: f_2.expect("auto-generated code should have checked for presence of required fields"),
      timestamp: f_3.expect("auto-generated code should have checked for presence of required fields"),
      attributes: f_4.expect("auto-generated code should have checked for presence of required fields"),
    };
    Ok(ret)
  }
  fn write_to_out_protocol(&self, o_prot: &mut dyn TOutputProtocol) -> thrift::Result<()> {
    let struct_ident = TStructIdentifier::new("getRowTs_args");
    o_prot.write_struct_begin(&struct_ident)?;
    o_prot.write_field_begin(&TFieldIdentifier::new("tableName", TType::String, 1))?;
    o_prot.write_bytes(&self.table_name)?;
    o_prot.write_field_end()?;
    o_prot.write_field_begin(&TFieldIdentifier::new("row", TType::String, 2))?;
    o_prot.write_bytes(&self.row)?;
    o_prot.write_field_end()?;
    o_prot.write_field_begin(&TFieldIdentifier::new("timestamp", TType::I64, 3))?;
    o_prot.write_i64(self.timestamp)?;
    o_prot.write_field_end()?;
    o_prot.write_field_begin(&TFieldIdentifier::new("attributes", TType::Map, 4))?;
    o_prot.write_map_begin(&TMapIdentifier::new(TType::String, TType::String, self.attributes.len() as i32))?;
    for (k, v) in &self.attributes {
      o_prot.write_bytes(k)?;
      o_prot.write_bytes(v)?;
    }
    o_prot.write_map_end()?;
    o_prot.write_field_end()?;
    o_prot.write_field_stop()?;
    o_prot.write_struct_end()
  }
}

//
// HbaseGetRowTsResult
//

#[derive(Clone, Debug, Eq, Hash, Ord, PartialEq, PartialOrd)]
struct HbaseGetRowTsResult {
  result_value: Option<Vec<TRowResult>>,
  io: Option<IOError>,
}

impl HbaseGetRowTsResult {
  fn read_from_in_protocol(i_prot: &mut dyn TInputProtocol) -> thrift::Result<HbaseGetRowTsResult> {
    i_prot.read_struct_begin()?;
    let mut f_0: Option<Vec<TRowResult>> = None;
    let mut f_1: Option<IOError> = None;
    loop {
      let field_ident = i_prot.read_field_begin()?;
      if field_ident.field_type == TType::Stop {
        break;
      }
      let field_id = field_id(&field_ident)?;
      match field_id {
        0 => {
          let list_ident = i_prot.read_list_begin()?;
          let mut val: Vec<TRowResult> = Vec::with_capacity(list_ident.size as usize);
          for _ in 0..list_ident.size {
            let list_elem_32 = TRowResult::read_from_in_protocol(i_prot)?;
            val.push(list_elem_32);
          }
          i_prot.read_list_end()?;
          f_0 = Some(val);
        },
        1 => {
          let val = IOError::read_from_in_protocol(i_prot)?;
          f_1 = Some(val);
        },
        _ => {
          i_prot.skip(field_ident.field_type)?;
        },
      };
      i_prot.read_field_end()?;
    }
    i_prot.read_struct_end()?;
    let ret = HbaseGetRowTsResult {
      result_value: f_0,
      io: f_1,
    };
    Ok(ret)
  }
  fn write_to_out_protocol(&self, o_prot: &mut dyn TOutputProtocol) -> thrift::Result<()> {
    let struct_ident = TStructIdentifier::new("HbaseGetRowTsResult");
    o_prot.write_struct_begin(&struct_ident)?;
    if let Some(ref fld_var) = self.result_value {
      o_prot.write_field_begin(&TFieldIdentifier::new("result_value", TType::List, 0))?;
      o_prot.write_list_begin(&TListIdentifier::new(TType::Struct, fld_var.len() as i32))?;
      for e in fld_var {
        e.write_to_out_protocol(o_prot)?;
      }
      o_prot.write_list_end()?;
      o_prot.write_field_end()?
    }
    if let Some(ref fld_var) = self.io {
      o_prot.write_field_begin(&TFieldIdentifier::new("io", TType::Struct, 1))?;
      fld_var.write_to_out_protocol(o_prot)?;
      o_prot.write_field_end()?
    }
    o_prot.write_field_stop()?;
    o_prot.write_struct_end()
  }
  fn ok_or(self) -> thrift::Result<Vec<TRowResult>> {
    if self.io.is_some() {
      Err(thrift::Error::User(Box::new(self.io.unwrap())))
    } else if self.result_value.is_some() {
      Ok(self.result_value.unwrap())
    } else {
      Err(
        thrift::Error::Application(
          ApplicationError::new(
            ApplicationErrorKind::MissingResult,
            "no result received for HbaseGetRowTs"
          )
        )
      )
    }
  }
}

//
// HbaseGetRowWithColumnsTsArgs
//

#[derive(Clone, Debug, Eq, Hash, Ord, PartialEq, PartialOrd)]
struct HbaseGetRowWithColumnsTsArgs {
  /// name of table
  table_name: Text,
  /// row key
  row: Text,
  /// List of columns to return, null for all columns
  columns: Vec<Text>,
  timestamp: i64,
  /// Get attributes
  attributes: BTreeMap<Text, Text>,
}

impl HbaseGetRowWithColumnsTsArgs {
  fn read_from_in_protocol(i_prot: &mut dyn TInputProtocol) -> thrift::Result<HbaseGetRowWithColumnsTsArgs> {
    i_prot.read_struct_begin()?;
    let mut f_1: Option<Text> = None;
    let mut f_2: Option<Text> = None;
    let mut f_3: Option<Vec<Text>> = None;
    let mut f_4: Option<i64> = None;
    let mut f_5: Option<BTreeMap<Text, Text>> = None;
    loop {
      let field_ident = i_prot.read_field_begin()?;
      if field_ident.field_type == TType::Stop {
        break;
      }
      let field_id = field_id(&field_ident)?;
      match field_id {
        1 => {
          let val = i_prot.read_bytes()?;
          f_1 = Some(val);
        },
        2 => {
          let val = i_prot.read_bytes()?;
          f_2 = Some(val);
        },
        3 => {
          let list_ident = i_prot.read_list_begin()?;
          let mut val: Vec<Text> = Vec::with_capacity(list_ident.size as usize);
          for _ in 0..list_ident.size {
            let list_elem_33 = i_prot.read_bytes()?;
            val.push(list_elem_33);
          }
          i_prot.read_list_end()?;
          f_3 = Some(val);
        },
        4 => {
          let val = i_prot.read_i64()?;
          f_4 = Some(val);
        },
        5 => {
          let map_ident = i_prot.read_map_begin()?;
          let mut val: BTreeMap<Text, Text> = BTreeMap::new();
          for _ in 0..map_ident.size {
            let map_key_34 = i_prot.read_bytes()?;
            let map_val_35 = i_prot.read_bytes()?;
            val.insert(map_key_34, map_val_35);
          }
          i_prot.read_map_end()?;
          f_5 = Some(val);
        },
        _ => {
          i_prot.skip(field_ident.field_type)?;
        },
      };
      i_prot.read_field_end()?;
    }
    i_prot.read_struct_end()?;
    verify_required_field_exists("HbaseGetRowWithColumnsTsArgs.table_name", &f_1)?;
    verify_required_field_exists("HbaseGetRowWithColumnsTsArgs.row", &f_2)?;
    verify_required_field_exists("HbaseGetRowWithColumnsTsArgs.columns", &f_3)?;
    verify_required_field_exists("HbaseGetRowWithColumnsTsArgs.timestamp", &f_4)?;
    verify_required_field_exists("HbaseGetRowWithColumnsTsArgs.attributes", &f_5)?;
    let ret = HbaseGetRowWithColumnsTsArgs {
      table_name: f_1.expect("auto-generated code should have checked for presence of required fields"),
      row: f_2.expect("auto-generated code should have checked for presence of required fields"),
      columns: f_3.expect("auto-generated code should have checked for presence of required fields"),
      timestamp: f_4.expect("auto-generated code should have checked for presence of required fields"),
      attributes: f_5.expect("auto-generated code should have checked for presence of required fields"),
    };
    Ok(ret)
  }
  fn write_to_out_protocol(&self, o_prot: &mut dyn TOutputProtocol) -> thrift::Result<()> {
    let struct_ident = TStructIdentifier::new("getRowWithColumnsTs_args");
    o_prot.write_struct_begin(&struct_ident)?;
    o_prot.write_field_begin(&TFieldIdentifier::new("tableName", TType::String, 1))?;
    o_prot.write_bytes(&self.table_name)?;
    o_prot.write_field_end()?;
    o_prot.write_field_begin(&TFieldIdentifier::new("row", TType::String, 2))?;
    o_prot.write_bytes(&self.row)?;
    o_prot.write_field_end()?;
    o_prot.write_field_begin(&TFieldIdentifier::new("columns", TType::List, 3))?;
    o_prot.write_list_begin(&TListIdentifier::new(TType::String, self.columns.len() as i32))?;
    for e in &self.columns {
      o_prot.write_bytes(e)?;
    }
    o_prot.write_list_end()?;
    o_prot.write_field_end()?;
    o_prot.write_field_begin(&TFieldIdentifier::new("timestamp", TType::I64, 4))?;
    o_prot.write_i64(self.timestamp)?;
    o_prot.write_field_end()?;
    o_prot.write_field_begin(&TFieldIdentifier::new("attributes", TType::Map, 5))?;
    o_prot.write_map_begin(&TMapIdentifier::new(TType::String, TType::String, self.attributes.len() as i32))?;
    for (k, v) in &self.attributes {
      o_prot.write_bytes(k)?;
      o_prot.write_bytes(v)?;
    }
    o_prot.write_map_end()?;
    o_prot.write_field_end()?;
    o_prot.write_field_stop()?;
    o_prot.write_struct_end()
  }
}

//
// HbaseGetRowWithColumnsTsResult
//

#[derive(Clone, Debug, Eq, Hash, Ord, PartialEq, PartialOrd)]
struct HbaseGetRowWithColumnsTsResult {
  result_value: Option<Vec<TRowResult>>,
  io: Option<IOError>,
}

impl HbaseGetRowWithColumnsTsResult {
  fn read_from_in_protocol(i_prot: &mut dyn TInputProtocol) -> thrift::Result<HbaseGetRowWithColumnsTsResult> {
    i_prot.read_struct_begin()?;
    let mut f_0: Option<Vec<TRowResult>> = None;
    let mut f_1: Option<IOError> = None;
    loop {
      let field_ident = i_prot.read_field_begin()?;
      if field_ident.field_type == TType::Stop {
        break;
      }
      let field_id = field_id(&field_ident)?;
      match field_id {
        0 => {
          let list_ident = i_prot.read_list_begin()?;
          let mut val: Vec<TRowResult> = Vec::with_capacity(list_ident.size as usize);
          for _ in 0..list_ident.size {
            let list_elem_36 = TRowResult::read_from_in_protocol(i_prot)?;
            val.push(list_elem_36);
          }
          i_prot.read_list_end()?;
          f_0 = Some(val);
        },
        1 => {
          let val = IOError::read_from_in_protocol(i_prot)?;
          f_1 = Some(val);
        },
        _ => {
          i_prot.skip(field_ident.field_type)?;
        },
      };
      i_prot.read_field_end()?;
    }
    i_prot.read_struct_end()?;
    let ret = HbaseGetRowWithColumnsTsResult {
      result_value: f_0,
      io: f_1,
    };
    Ok(ret)
  }
  fn write_to_out_protocol(&self, o_prot: &mut dyn TOutputProtocol) -> thrift::Result<()> {
    let struct_ident = TStructIdentifier::new("HbaseGetRowWithColumnsTsResult");
    o_prot.write_struct_begin(&struct_ident)?;
    if let Some(ref fld_var) = self.result_value {
      o_prot.write_field_begin(&TFieldIdentifier::new("result_value", TType::List, 0))?;
      o_prot.write_list_begin(&TListIdentifier::new(TType::Struct, fld_var.len() as i32))?;
      for e in fld_var {
        e.write_to_out_protocol(o_prot)?;
      }
      o_prot.write_list_end()?;
      o_prot.write_field_end()?
    }
    if let Some(ref fld_var) = self.io {
      o_prot.write_field_begin(&TFieldIdentifier::new("io", TType::Struct, 1))?;
      fld_var.write_to_out_protocol(o_prot)?;
      o_prot.write_field_end()?
    }
    o_prot.write_field_stop()?;
    o_prot.write_struct_end()
  }
  fn ok_or(self) -> thrift::Result<Vec<TRowResult>> {
    if self.io.is_some() {
      Err(thrift::Error::User(Box::new(self.io.unwrap())))
    } else if self.result_value.is_some() {
      Ok(self.result_value.unwrap())
    } else {
      Err(
        thrift::Error::Application(
          ApplicationError::new(
            ApplicationErrorKind::MissingResult,
            "no result received for HbaseGetRowWithColumnsTs"
          )
        )
      )
    }
  }
}

//
// HbaseGetRowsArgs
//

#[derive(Clone, Debug, Eq, Hash, Ord, PartialEq, PartialOrd)]
struct HbaseGetRowsArgs {
  /// name of table
  table_name: Text,
  /// row keys
  rows: Vec<Text>,
  /// Get attributes
  attributes: BTreeMap<Text, Text>,
}

impl HbaseGetRowsArgs {
  fn read_from_in_protocol(i_prot: &mut dyn TInputProtocol) -> thrift::Result<HbaseGetRowsArgs> {
    i_prot.read_struct_begin()?;
    let mut f_1: Option<Text> = None;
    let mut f_2: Option<Vec<Text>> = None;
    let mut f_3: Option<BTreeMap<Text, Text>> = None;
    loop {
      let field_ident = i_prot.read_field_begin()?;
      if field_ident.field_type == TType::Stop {
        break;
      }
      let field_id = field_id(&field_ident)?;
      match field_id {
        1 => {
          let val = i_prot.read_bytes()?;
          f_1 = Some(val);
        },
        2 => {
          let list_ident = i_prot.read_list_begin()?;
          let mut val: Vec<Text> = Vec::with_capacity(list_ident.size as usize);
          for _ in 0..list_ident.size {
            let list_elem_37 = i_prot.read_bytes()?;
            val.push(list_elem_37);
          }
          i_prot.read_list_end()?;
          f_2 = Some(val);
        },
        3 => {
          let map_ident = i_prot.read_map_begin()?;
          let mut val: BTreeMap<Text, Text> = BTreeMap::new();
          for _ in 0..map_ident.size {
            let map_key_38 = i_prot.read_bytes()?;
            let map_val_39 = i_prot.read_bytes()?;
            val.insert(map_key_38, map_val_39);
          }
          i_prot.read_map_end()?;
          f_3 = Some(val);
        },
        _ => {
          i_prot.skip(field_ident.field_type)?;
        },
      };
      i_prot.read_field_end()?;
    }
    i_prot.read_struct_end()?;
    verify_required_field_exists("HbaseGetRowsArgs.table_name", &f_1)?;
    verify_required_field_exists("HbaseGetRowsArgs.rows", &f_2)?;
    verify_required_field_exists("HbaseGetRowsArgs.attributes", &f_3)?;
    let ret = HbaseGetRowsArgs {
      table_name: f_1.expect("auto-generated code should have checked for presence of required fields"),
      rows: f_2.expect("auto-generated code should have checked for presence of required fields"),
      attributes: f_3.expect("auto-generated code should have checked for presence of required fields"),
    };
    Ok(ret)
  }
  fn write_to_out_protocol(&self, o_prot: &mut dyn TOutputProtocol) -> thrift::Result<()> {
    let struct_ident = TStructIdentifier::new("getRows_args");
    o_prot.write_struct_begin(&struct_ident)?;
    o_prot.write_field_begin(&TFieldIdentifier::new("tableName", TType::String, 1))?;
    o_prot.write_bytes(&self.table_name)?;
    o_prot.write_field_end()?;
    o_prot.write_field_begin(&TFieldIdentifier::new("rows", TType::List, 2))?;
    o_prot.write_list_begin(&TListIdentifier::new(TType::String, self.rows.len() as i32))?;
    for e in &self.rows {
      o_prot.write_bytes(e)?;
    }
    o_prot.write_list_end()?;
    o_prot.write_field_end()?;
    o_prot.write_field_begin(&TFieldIdentifier::new("attributes", TType::Map, 3))?;
    o_prot.write_map_begin(&TMapIdentifier::new(TType::String, TType::String, self.attributes.len() as i32))?;
    for (k, v) in &self.attributes {
      o_prot.write_bytes(k)?;
      o_prot.write_bytes(v)?;
    }
    o_prot.write_map_end()?;
    o_prot.write_field_end()?;
    o_prot.write_field_stop()?;
    o_prot.write_struct_end()
  }
}

//
// HbaseGetRowsResult
//

#[derive(Clone, Debug, Eq, Hash, Ord, PartialEq, PartialOrd)]
struct HbaseGetRowsResult {
  result_value: Option<Vec<TRowResult>>,
  io: Option<IOError>,
}

impl HbaseGetRowsResult {
  fn read_from_in_protocol(i_prot: &mut dyn TInputProtocol) -> thrift::Result<HbaseGetRowsResult> {
    i_prot.read_struct_begin()?;
    let mut f_0: Option<Vec<TRowResult>> = None;
    let mut f_1: Option<IOError> = None;
    loop {
      let field_ident = i_prot.read_field_begin()?;
      if field_ident.field_type == TType::Stop {
        break;
      }
      let field_id = field_id(&field_ident)?;
      match field_id {
        0 => {
          let list_ident = i_prot.read_list_begin()?;
          let mut val: Vec<TRowResult> = Vec::with_capacity(list_ident.size as usize);
          for _ in 0..list_ident.size {
            let list_elem_40 = TRowResult::read_from_in_protocol(i_prot)?;
            val.push(list_elem_40);
          }
          i_prot.read_list_end()?;
          f_0 = Some(val);
        },
        1 => {
          let val = IOError::read_from_in_protocol(i_prot)?;
          f_1 = Some(val);
        },
        _ => {
          i_prot.skip(field_ident.field_type)?;
        },
      };
      i_prot.read_field_end()?;
    }
    i_prot.read_struct_end()?;
    let ret = HbaseGetRowsResult {
      result_value: f_0,
      io: f_1,
    };
    Ok(ret)
  }
  fn write_to_out_protocol(&self, o_prot: &mut dyn TOutputProtocol) -> thrift::Result<()> {
    let struct_ident = TStructIdentifier::new("HbaseGetRowsResult");
    o_prot.write_struct_begin(&struct_ident)?;
    if let Some(ref fld_var) = self.result_value {
      o_prot.write_field_begin(&TFieldIdentifier::new("result_value", TType::List, 0))?;
      o_prot.write_list_begin(&TListIdentifier::new(TType::Struct, fld_var.len() as i32))?;
      for e in fld_var {
        e.write_to_out_protocol(o_prot)?;
      }
      o_prot.write_list_end()?;
      o_prot.write_field_end()?
    }
    if let Some(ref fld_var) = self.io {
      o_prot.write_field_begin(&TFieldIdentifier::new("io", TType::Struct, 1))?;
      fld_var.write_to_out_protocol(o_prot)?;
      o_prot.write_field_end()?
    }
    o_prot.write_field_stop()?;
    o_prot.write_struct_end()
  }
  fn ok_or(self) -> thrift::Result<Vec<TRowResult>> {
    if self.io.is_some() {
      Err(thrift::Error::User(Box::new(self.io.unwrap())))
    } else if self.result_value.is_some() {
      Ok(self.result_value.unwrap())
    } else {
      Err(
        thrift::Error::Application(
          ApplicationError::new(
            ApplicationErrorKind::MissingResult,
            "no result received for HbaseGetRows"
          )
        )
      )
    }
  }
}

//
// HbaseGetRowsWithColumnsArgs
//

#[derive(Clone, Debug, Eq, Hash, Ord, PartialEq, PartialOrd)]
struct HbaseGetRowsWithColumnsArgs {
  /// name of table
  table_name: Text,
  /// row keys
  rows: Vec<Text>,
  /// List of columns to return, null for all columns
  columns: Vec<Text>,
  /// Get attributes
  attributes: BTreeMap<Text, Text>,
}

impl HbaseGetRowsWithColumnsArgs {
  fn read_from_in_protocol(i_prot: &mut dyn TInputProtocol) -> thrift::Result<HbaseGetRowsWithColumnsArgs> {
    i_prot.read_struct_begin()?;
    let mut f_1: Option<Text> = None;
    let mut f_2: Option<Vec<Text>> = None;
    let mut f_3: Option<Vec<Text>> = None;
    let mut f_4: Option<BTreeMap<Text, Text>> = None;
    loop {
      let field_ident = i_prot.read_field_begin()?;
      if field_ident.field_type == TType::Stop {
        break;
      }
      let field_id = field_id(&field_ident)?;
      match field_id {
        1 => {
          let val = i_prot.read_bytes()?;
          f_1 = Some(val);
        },
        2 => {
          let list_ident = i_prot.read_list_begin()?;
          let mut val: Vec<Text> = Vec::with_capacity(list_ident.size as usize);
          for _ in 0..list_ident.size {
            let list_elem_41 = i_prot.read_bytes()?;
            val.push(list_elem_41);
          }
          i_prot.read_list_end()?;
          f_2 = Some(val);
        },
        3 => {
          let list_ident = i_prot.read_list_begin()?;
          let mut val: Vec<Text> = Vec::with_capacity(list_ident.size as usize);
          for _ in 0..list_ident.size {
            let list_elem_42 = i_prot.read_bytes()?;
            val.push(list_elem_42);
          }
          i_prot.read_list_end()?;
          f_3 = Some(val);
        },
        4 => {
          let map_ident = i_prot.read_map_begin()?;
          let mut val: BTreeMap<Text, Text> = BTreeMap::new();
          for _ in 0..map_ident.size {
            let map_key_43 = i_prot.read_bytes()?;
            let map_val_44 = i_prot.read_bytes()?;
            val.insert(map_key_43, map_val_44);
          }
          i_prot.read_map_end()?;
          f_4 = Some(val);
        },
        _ => {
          i_prot.skip(field_ident.field_type)?;
        },
      };
      i_prot.read_field_end()?;
    }
    i_prot.read_struct_end()?;
    verify_required_field_exists("HbaseGetRowsWithColumnsArgs.table_name", &f_1)?;
    verify_required_field_exists("HbaseGetRowsWithColumnsArgs.rows", &f_2)?;
    verify_required_field_exists("HbaseGetRowsWithColumnsArgs.columns", &f_3)?;
    verify_required_field_exists("HbaseGetRowsWithColumnsArgs.attributes", &f_4)?;
    let ret = HbaseGetRowsWithColumnsArgs {
      table_name: f_1.expect("auto-generated code should have checked for presence of required fields"),
      rows: f_2.expect("auto-generated code should have checked for presence of required fields"),
      columns: f_3.expect("auto-generated code should have checked for presence of required fields"),
      attributes: f_4.expect("auto-generated code should have checked for presence of required fields"),
    };
    Ok(ret)
  }
  fn write_to_out_protocol(&self, o_prot: &mut dyn TOutputProtocol) -> thrift::Result<()> {
    let struct_ident = TStructIdentifier::new("getRowsWithColumns_args");
    o_prot.write_struct_begin(&struct_ident)?;
    o_prot.write_field_begin(&TFieldIdentifier::new("tableName", TType::String, 1))?;
    o_prot.write_bytes(&self.table_name)?;
    o_prot.write_field_end()?;
    o_prot.write_field_begin(&TFieldIdentifier::new("rows", TType::List, 2))?;
    o_prot.write_list_begin(&TListIdentifier::new(TType::String, self.rows.len() as i32))?;
    for e in &self.rows {
      o_prot.write_bytes(e)?;
    }
    o_prot.write_list_end()?;
    o_prot.write_field_end()?;
    o_prot.write_field_begin(&TFieldIdentifier::new("columns", TType::List, 3))?;
    o_prot.write_list_begin(&TListIdentifier::new(TType::String, self.columns.len() as i32))?;
    for e in &self.columns {
      o_prot.write_bytes(e)?;
    }
    o_prot.write_list_end()?;
    o_prot.write_field_end()?;
    o_prot.write_field_begin(&TFieldIdentifier::new("attributes", TType::Map, 4))?;
    o_prot.write_map_begin(&TMapIdentifier::new(TType::String, TType::String, self.attributes.len() as i32))?;
    for (k, v) in &self.attributes {
      o_prot.write_bytes(k)?;
      o_prot.write_bytes(v)?;
    }
    o_prot.write_map_end()?;
    o_prot.write_field_end()?;
    o_prot.write_field_stop()?;
    o_prot.write_struct_end()
  }
}

//
// HbaseGetRowsWithColumnsResult
//

#[derive(Clone, Debug, Eq, Hash, Ord, PartialEq, PartialOrd)]
struct HbaseGetRowsWithColumnsResult {
  result_value: Option<Vec<TRowResult>>,
  io: Option<IOError>,
}

impl HbaseGetRowsWithColumnsResult {
  fn read_from_in_protocol(i_prot: &mut dyn TInputProtocol) -> thrift::Result<HbaseGetRowsWithColumnsResult> {
    i_prot.read_struct_begin()?;
    let mut f_0: Option<Vec<TRowResult>> = None;
    let mut f_1: Option<IOError> = None;
    loop {
      let field_ident = i_prot.read_field_begin()?;
      if field_ident.field_type == TType::Stop {
        break;
      }
      let field_id = field_id(&field_ident)?;
      match field_id {
        0 => {
          let list_ident = i_prot.read_list_begin()?;
          let mut val: Vec<TRowResult> = Vec::with_capacity(list_ident.size as usize);
          for _ in 0..list_ident.size {
            let list_elem_45 = TRowResult::read_from_in_protocol(i_prot)?;
            val.push(list_elem_45);
          }
          i_prot.read_list_end()?;
          f_0 = Some(val);
        },
        1 => {
          let val = IOError::read_from_in_protocol(i_prot)?;
          f_1 = Some(val);
        },
        _ => {
          i_prot.skip(field_ident.field_type)?;
        },
      };
      i_prot.read_field_end()?;
    }
    i_prot.read_struct_end()?;
    let ret = HbaseGetRowsWithColumnsResult {
      result_value: f_0,
      io: f_1,
    };
    Ok(ret)
  }
  fn write_to_out_protocol(&self, o_prot: &mut dyn TOutputProtocol) -> thrift::Result<()> {
    let struct_ident = TStructIdentifier::new("HbaseGetRowsWithColumnsResult");
    o_prot.write_struct_begin(&struct_ident)?;
    if let Some(ref fld_var) = self.result_value {
      o_prot.write_field_begin(&TFieldIdentifier::new("result_value", TType::List, 0))?;
      o_prot.write_list_begin(&TListIdentifier::new(TType::Struct, fld_var.len() as i32))?;
      for e in fld_var {
        e.write_to_out_protocol(o_prot)?;
      }
      o_prot.write_list_end()?;
      o_prot.write_field_end()?
    }
    if let Some(ref fld_var) = self.io {
      o_prot.write_field_begin(&TFieldIdentifier::new("io", TType::Struct, 1))?;
      fld_var.write_to_out_protocol(o_prot)?;
      o_prot.write_field_end()?
    }
    o_prot.write_field_stop()?;
    o_prot.write_struct_end()
  }
  fn ok_or(self) -> thrift::Result<Vec<TRowResult>> {
    if self.io.is_some() {
      Err(thrift::Error::User(Box::new(self.io.unwrap())))
    } else if self.result_value.is_some() {
      Ok(self.result_value.unwrap())
    } else {
      Err(
        thrift::Error::Application(
          ApplicationError::new(
            ApplicationErrorKind::MissingResult,
            "no result received for HbaseGetRowsWithColumns"
          )
        )
      )
    }
  }
}

//
// HbaseGetRowsTsArgs
//

#[derive(Clone, Debug, Eq, Hash, Ord, PartialEq, PartialOrd)]
struct HbaseGetRowsTsArgs {
  /// name of the table
  table_name: Text,
  /// row keys
  rows: Vec<Text>,
  /// timestamp
  timestamp: i64,
  /// Get attributes
  attributes: BTreeMap<Text, Text>,
}

impl HbaseGetRowsTsArgs {
  fn read_from_in_protocol(i_prot: &mut dyn TInputProtocol) -> thrift::Result<HbaseGetRowsTsArgs> {
    i_prot.read_struct_begin()?;
    let mut f_1: Option<Text> = None;
    let mut f_2: Option<Vec<Text>> = None;
    let mut f_3: Option<i64> = None;
    let mut f_4: Option<BTreeMap<Text, Text>> = None;
    loop {
      let field_ident = i_prot.read_field_begin()?;
      if field_ident.field_type == TType::Stop {
        break;
      }
      let field_id = field_id(&field_ident)?;
      match field_id {
        1 => {
          let val = i_prot.read_bytes()?;
          f_1 = Some(val);
        },
        2 => {
          let list_ident = i_prot.read_list_begin()?;
          let mut val: Vec<Text> = Vec::with_capacity(list_ident.size as usize);
          for _ in 0..list_ident.size {
            let list_elem_46 = i_prot.read_bytes()?;
            val.push(list_elem_46);
          }
          i_prot.read_list_end()?;
          f_2 = Some(val);
        },
        3 => {
          let val = i_prot.read_i64()?;
          f_3 = Some(val);
        },
        4 => {
          let map_ident = i_prot.read_map_begin()?;
          let mut val: BTreeMap<Text, Text> = BTreeMap::new();
          for _ in 0..map_ident.size {
            let map_key_47 = i_prot.read_bytes()?;
            let map_val_48 = i_prot.read_bytes()?;
            val.insert(map_key_47, map_val_48);
          }
          i_prot.read_map_end()?;
          f_4 = Some(val);
        },
        _ => {
          i_prot.skip(field_ident.field_type)?;
        },
      };
      i_prot.read_field_end()?;
    }
    i_prot.read_struct_end()?;
    verify_required_field_exists("HbaseGetRowsTsArgs.table_name", &f_1)?;
    verify_required_field_exists("HbaseGetRowsTsArgs.rows", &f_2)?;
    verify_required_field_exists("HbaseGetRowsTsArgs.timestamp", &f_3)?;
    verify_required_field_exists("HbaseGetRowsTsArgs.attributes", &f_4)?;
    let ret = HbaseGetRowsTsArgs {
      table_name: f_1.expect("auto-generated code should have checked for presence of required fields"),
      rows: f_2.expect("auto-generated code should have checked for presence of required fields"),
      timestamp: f_3.expect("auto-generated code should have checked for presence of required fields"),
      attributes: f_4.expect("auto-generated code should have checked for presence of required fields"),
    };
    Ok(ret)
  }
  fn write_to_out_protocol(&self, o_prot: &mut dyn TOutputProtocol) -> thrift::Result<()> {
    let struct_ident = TStructIdentifier::new("getRowsTs_args");
    o_prot.write_struct_begin(&struct_ident)?;
    o_prot.write_field_begin(&TFieldIdentifier::new("tableName", TType::String, 1))?;
    o_prot.write_bytes(&self.table_name)?;
    o_prot.write_field_end()?;
    o_prot.write_field_begin(&TFieldIdentifier::new("rows", TType::List, 2))?;
    o_prot.write_list_begin(&TListIdentifier::new(TType::String, self.rows.len() as i32))?;
    for e in &self.rows {
      o_prot.write_bytes(e)?;
    }
    o_prot.write_list_end()?;
    o_prot.write_field_end()?;
    o_prot.write_field_begin(&TFieldIdentifier::new("timestamp", TType::I64, 3))?;
    o_prot.write_i64(self.timestamp)?;
    o_prot.write_field_end()?;
    o_prot.write_field_begin(&TFieldIdentifier::new("attributes", TType::Map, 4))?;
    o_prot.write_map_begin(&TMapIdentifier::new(TType::String, TType::String, self.attributes.len() as i32))?;
    for (k, v) in &self.attributes {
      o_prot.write_bytes(k)?;
      o_prot.write_bytes(v)?;
    }
    o_prot.write_map_end()?;
    o_prot.write_field_end()?;
    o_prot.write_field_stop()?;
    o_prot.write_struct_end()
  }
}

//
// HbaseGetRowsTsResult
//

#[derive(Clone, Debug, Eq, Hash, Ord, PartialEq, PartialOrd)]
struct HbaseGetRowsTsResult {
  result_value: Option<Vec<TRowResult>>,
  io: Option<IOError>,
}

impl HbaseGetRowsTsResult {
  fn read_from_in_protocol(i_prot: &mut dyn TInputProtocol) -> thrift::Result<HbaseGetRowsTsResult> {
    i_prot.read_struct_begin()?;
    let mut f_0: Option<Vec<TRowResult>> = None;
    let mut f_1: Option<IOError> = None;
    loop {
      let field_ident = i_prot.read_field_begin()?;
      if field_ident.field_type == TType::Stop {
        break;
      }
      let field_id = field_id(&field_ident)?;
      match field_id {
        0 => {
          let list_ident = i_prot.read_list_begin()?;
          let mut val: Vec<TRowResult> = Vec::with_capacity(list_ident.size as usize);
          for _ in 0..list_ident.size {
            let list_elem_49 = TRowResult::read_from_in_protocol(i_prot)?;
            val.push(list_elem_49);
          }
          i_prot.read_list_end()?;
          f_0 = Some(val);
        },
        1 => {
          let val = IOError::read_from_in_protocol(i_prot)?;
          f_1 = Some(val);
        },
        _ => {
          i_prot.skip(field_ident.field_type)?;
        },
      };
      i_prot.read_field_end()?;
    }
    i_prot.read_struct_end()?;
    let ret = HbaseGetRowsTsResult {
      result_value: f_0,
      io: f_1,
    };
    Ok(ret)
  }
  fn write_to_out_protocol(&self, o_prot: &mut dyn TOutputProtocol) -> thrift::Result<()> {
    let struct_ident = TStructIdentifier::new("HbaseGetRowsTsResult");
    o_prot.write_struct_begin(&struct_ident)?;
    if let Some(ref fld_var) = self.result_value {
      o_prot.write_field_begin(&TFieldIdentifier::new("result_value", TType::List, 0))?;
      o_prot.write_list_begin(&TListIdentifier::new(TType::Struct, fld_var.len() as i32))?;
      for e in fld_var {
        e.write_to_out_protocol(o_prot)?;
      }
      o_prot.write_list_end()?;
      o_prot.write_field_end()?
    }
    if let Some(ref fld_var) = self.io {
      o_prot.write_field_begin(&TFieldIdentifier::new("io", TType::Struct, 1))?;
      fld_var.write_to_out_protocol(o_prot)?;
      o_prot.write_field_end()?
    }
    o_prot.write_field_stop()?;
    o_prot.write_struct_end()
  }
  fn ok_or(self) -> thrift::Result<Vec<TRowResult>> {
    if self.io.is_some() {
      Err(thrift::Error::User(Box::new(self.io.unwrap())))
    } else if self.result_value.is_some() {
      Ok(self.result_value.unwrap())
    } else {
      Err(
        thrift::Error::Application(
          ApplicationError::new(
            ApplicationErrorKind::MissingResult,
            "no result received for HbaseGetRowsTs"
          )
        )
      )
    }
  }
}

//
// HbaseGetRowsWithColumnsTsArgs
//

#[derive(Clone, Debug, Eq, Hash, Ord, PartialEq, PartialOrd)]
struct HbaseGetRowsWithColumnsTsArgs {
  /// name of table
  table_name: Text,
  /// row keys
  rows: Vec<Text>,
  /// List of columns to return, null for all columns
  columns: Vec<Text>,
  timestamp: i64,
  /// Get attributes
  attributes: BTreeMap<Text, Text>,
}

impl HbaseGetRowsWithColumnsTsArgs {
  fn read_from_in_protocol(i_prot: &mut dyn TInputProtocol) -> thrift::Result<HbaseGetRowsWithColumnsTsArgs> {
    i_prot.read_struct_begin()?;
    let mut f_1: Option<Text> = None;
    let mut f_2: Option<Vec<Text>> = None;
    let mut f_3: Option<Vec<Text>> = None;
    let mut f_4: Option<i64> = None;
    let mut f_5: Option<BTreeMap<Text, Text>> = None;
    loop {
      let field_ident = i_prot.read_field_begin()?;
      if field_ident.field_type == TType::Stop {
        break;
      }
      let field_id = field_id(&field_ident)?;
      match field_id {
        1 => {
          let val = i_prot.read_bytes()?;
          f_1 = Some(val);
        },
        2 => {
          let list_ident = i_prot.read_list_begin()?;
          let mut val: Vec<Text> = Vec::with_capacity(list_ident.size as usize);
          for _ in 0..list_ident.size {
            let list_elem_50 = i_prot.read_bytes()?;
            val.push(list_elem_50);
          }
          i_prot.read_list_end()?;
          f_2 = Some(val);
        },
        3 => {
          let list_ident = i_prot.read_list_begin()?;
          let mut val: Vec<Text> = Vec::with_capacity(list_ident.size as usize);
          for _ in 0..list_ident.size {
            let list_elem_51 = i_prot.read_bytes()?;
            val.push(list_elem_51);
          }
          i_prot.read_list_end()?;
          f_3 = Some(val);
        },
        4 => {
          let val = i_prot.read_i64()?;
          f_4 = Some(val);
        },
        5 => {
          let map_ident = i_prot.read_map_begin()?;
          let mut val: BTreeMap<Text, Text> = BTreeMap::new();
          for _ in 0..map_ident.size {
            let map_key_52 = i_prot.read_bytes()?;
            let map_val_53 = i_prot.read_bytes()?;
            val.insert(map_key_52, map_val_53);
          }
          i_prot.read_map_end()?;
          f_5 = Some(val);
        },
        _ => {
          i_prot.skip(field_ident.field_type)?;
        },
      };
      i_prot.read_field_end()?;
    }
    i_prot.read_struct_end()?;
    verify_required_field_exists("HbaseGetRowsWithColumnsTsArgs.table_name", &f_1)?;
    verify_required_field_exists("HbaseGetRowsWithColumnsTsArgs.rows", &f_2)?;
    verify_required_field_exists("HbaseGetRowsWithColumnsTsArgs.columns", &f_3)?;
    verify_required_field_exists("HbaseGetRowsWithColumnsTsArgs.timestamp", &f_4)?;
    verify_required_field_exists("HbaseGetRowsWithColumnsTsArgs.attributes", &f_5)?;
    let ret = HbaseGetRowsWithColumnsTsArgs {
      table_name: f_1.expect("auto-generated code should have checked for presence of required fields"),
      rows: f_2.expect("auto-generated code should have checked for presence of required fields"),
      columns: f_3.expect("auto-generated code should have checked for presence of required fields"),
      timestamp: f_4.expect("auto-generated code should have checked for presence of required fields"),
      attributes: f_5.expect("auto-generated code should have checked for presence of required fields"),
    };
    Ok(ret)
  }
  fn write_to_out_protocol(&self, o_prot: &mut dyn TOutputProtocol) -> thrift::Result<()> {
    let struct_ident = TStructIdentifier::new("getRowsWithColumnsTs_args");
    o_prot.write_struct_begin(&struct_ident)?;
    o_prot.write_field_begin(&TFieldIdentifier::new("tableName", TType::String, 1))?;
    o_prot.write_bytes(&self.table_name)?;
    o_prot.write_field_end()?;
    o_prot.write_field_begin(&TFieldIdentifier::new("rows", TType::List, 2))?;
    o_prot.write_list_begin(&TListIdentifier::new(TType::String, self.rows.len() as i32))?;
    for e in &self.rows {
      o_prot.write_bytes(e)?;
    }
    o_prot.write_list_end()?;
    o_prot.write_field_end()?;
    o_prot.write_field_begin(&TFieldIdentifier::new("columns", TType::List, 3))?;
    o_prot.write_list_begin(&TListIdentifier::new(TType::String, self.columns.len() as i32))?;
    for e in &self.columns {
      o_prot.write_bytes(e)?;
    }
    o_prot.write_list_end()?;
    o_prot.write_field_end()?;
    o_prot.write_field_begin(&TFieldIdentifier::new("timestamp", TType::I64, 4))?;
    o_prot.write_i64(self.timestamp)?;
    o_prot.write_field_end()?;
    o_prot.write_field_begin(&TFieldIdentifier::new("attributes", TType::Map, 5))?;
    o_prot.write_map_begin(&TMapIdentifier::new(TType::String, TType::String, self.attributes.len() as i32))?;
    for (k, v) in &self.attributes {
      o_prot.write_bytes(k)?;
      o_prot.write_bytes(v)?;
    }
    o_prot.write_map_end()?;
    o_prot.write_field_end()?;
    o_prot.write_field_stop()?;
    o_prot.write_struct_end()
  }
}

//
// HbaseGetRowsWithColumnsTsResult
//

#[derive(Clone, Debug, Eq, Hash, Ord, PartialEq, PartialOrd)]
struct HbaseGetRowsWithColumnsTsResult {
  result_value: Option<Vec<TRowResult>>,
  io: Option<IOError>,
}

impl HbaseGetRowsWithColumnsTsResult {
  fn read_from_in_protocol(i_prot: &mut dyn TInputProtocol) -> thrift::Result<HbaseGetRowsWithColumnsTsResult> {
    i_prot.read_struct_begin()?;
    let mut f_0: Option<Vec<TRowResult>> = None;
    let mut f_1: Option<IOError> = None;
    loop {
      let field_ident = i_prot.read_field_begin()?;
      if field_ident.field_type == TType::Stop {
        break;
      }
      let field_id = field_id(&field_ident)?;
      match field_id {
        0 => {
          let list_ident = i_prot.read_list_begin()?;
          let mut val: Vec<TRowResult> = Vec::with_capacity(list_ident.size as usize);
          for _ in 0..list_ident.size {
            let list_elem_54 = TRowResult::read_from_in_protocol(i_prot)?;
            val.push(list_elem_54);
          }
          i_prot.read_list_end()?;
          f_0 = Some(val);
        },
        1 => {
          let val = IOError::read_from_in_protocol(i_prot)?;
          f_1 = Some(val);
        },
        _ => {
          i_prot.skip(field_ident.field_type)?;
        },
      };
      i_prot.read_field_end()?;
    }
    i_prot.read_struct_end()?;
    let ret = HbaseGetRowsWithColumnsTsResult {
      result_value: f_0,
      io: f_1,
    };
    Ok(ret)
  }
  fn write_to_out_protocol(&self, o_prot: &mut dyn TOutputProtocol) -> thrift::Result<()> {
    let struct_ident = TStructIdentifier::new("HbaseGetRowsWithColumnsTsResult");
    o_prot.write_struct_begin(&struct_ident)?;
    if let Some(ref fld_var) = self.result_value {
      o_prot.write_field_begin(&TFieldIdentifier::new("result_value", TType::List, 0))?;
      o_prot.write_list_begin(&TListIdentifier::new(TType::Struct, fld_var.len() as i32))?;
      for e in fld_var {
        e.write_to_out_protocol(o_prot)?;
      }
      o_prot.write_list_end()?;
      o_prot.write_field_end()?
    }
    if let Some(ref fld_var) = self.io {
      o_prot.write_field_begin(&TFieldIdentifier::new("io", TType::Struct, 1))?;
      fld_var.write_to_out_protocol(o_prot)?;
      o_prot.write_field_end()?
    }
    o_prot.write_field_stop()?;
    o_prot.write_struct_end()
  }
  fn ok_or(self) -> thrift::Result<Vec<TRowResult>> {
    if self.io.is_some() {
      Err(thrift::Error::User(Box::new(self.io.unwrap())))
    } else if self.result_value.is_some() {
      Ok(self.result_value.unwrap())
    } else {
      Err(
        thrift::Error::Application(
          ApplicationError::new(
            ApplicationErrorKind::MissingResult,
            "no result received for HbaseGetRowsWithColumnsTs"
          )
        )
      )
    }
  }
}

//
// HbaseMutateRowArgs
//

#[derive(Clone, Debug, Eq, Hash, Ord, PartialEq, PartialOrd)]
struct HbaseMutateRowArgs {
  /// name of table
  table_name: Text,
  /// row key
  row: Text,
  /// list of mutation commands
  mutations: Vec<Mutation>,
  /// Mutation attributes
  attributes: BTreeMap<Text, Text>,
}

impl HbaseMutateRowArgs {
  fn read_from_in_protocol(i_prot: &mut dyn TInputProtocol) -> thrift::Result<HbaseMutateRowArgs> {
    i_prot.read_struct_begin()?;
    let mut f_1: Option<Text> = None;
    let mut f_2: Option<Text> = None;
    let mut f_3: Option<Vec<Mutation>> = None;
    let mut f_4: Option<BTreeMap<Text, Text>> = None;
    loop {
      let field_ident = i_prot.read_field_begin()?;
      if field_ident.field_type == TType::Stop {
        break;
      }
      let field_id = field_id(&field_ident)?;
      match field_id {
        1 => {
          let val = i_prot.read_bytes()?;
          f_1 = Some(val);
        },
        2 => {
          let val = i_prot.read_bytes()?;
          f_2 = Some(val);
        },
        3 => {
          let list_ident = i_prot.read_list_begin()?;
          let mut val: Vec<Mutation> = Vec::with_capacity(list_ident.size as usize);
          for _ in 0..list_ident.size {
            let list_elem_55 = Mutation::read_from_in_protocol(i_prot)?;
            val.push(list_elem_55);
          }
          i_prot.read_list_end()?;
          f_3 = Some(val);
        },
        4 => {
          let map_ident = i_prot.read_map_begin()?;
          let mut val: BTreeMap<Text, Text> = BTreeMap::new();
          for _ in 0..map_ident.size {
            let map_key_56 = i_prot.read_bytes()?;
            let map_val_57 = i_prot.read_bytes()?;
            val.insert(map_key_56, map_val_57);
          }
          i_prot.read_map_end()?;
          f_4 = Some(val);
        },
        _ => {
          i_prot.skip(field_ident.field_type)?;
        },
      };
      i_prot.read_field_end()?;
    }
    i_prot.read_struct_end()?;
    verify_required_field_exists("HbaseMutateRowArgs.table_name", &f_1)?;
    verify_required_field_exists("HbaseMutateRowArgs.row", &f_2)?;
    verify_required_field_exists("HbaseMutateRowArgs.mutations", &f_3)?;
    verify_required_field_exists("HbaseMutateRowArgs.attributes", &f_4)?;
    let ret = HbaseMutateRowArgs {
      table_name: f_1.expect("auto-generated code should have checked for presence of required fields"),
      row: f_2.expect("auto-generated code should have checked for presence of required fields"),
      mutations: f_3.expect("auto-generated code should have checked for presence of required fields"),
      attributes: f_4.expect("auto-generated code should have checked for presence of required fields"),
    };
    Ok(ret)
  }
  fn write_to_out_protocol(&self, o_prot: &mut dyn TOutputProtocol) -> thrift::Result<()> {
    let struct_ident = TStructIdentifier::new("mutateRow_args");
    o_prot.write_struct_begin(&struct_ident)?;
    o_prot.write_field_begin(&TFieldIdentifier::new("tableName", TType::String, 1))?;
    o_prot.write_bytes(&self.table_name)?;
    o_prot.write_field_end()?;
    o_prot.write_field_begin(&TFieldIdentifier::new("row", TType::String, 2))?;
    o_prot.write_bytes(&self.row)?;
    o_prot.write_field_end()?;
    o_prot.write_field_begin(&TFieldIdentifier::new("mutations", TType::List, 3))?;
    o_prot.write_list_begin(&TListIdentifier::new(TType::Struct, self.mutations.len() as i32))?;
    for e in &self.mutations {
      e.write_to_out_protocol(o_prot)?;
    }
    o_prot.write_list_end()?;
    o_prot.write_field_end()?;
    o_prot.write_field_begin(&TFieldIdentifier::new("attributes", TType::Map, 4))?;
    o_prot.write_map_begin(&TMapIdentifier::new(TType::String, TType::String, self.attributes.len() as i32))?;
    for (k, v) in &self.attributes {
      o_prot.write_bytes(k)?;
      o_prot.write_bytes(v)?;
    }
    o_prot.write_map_end()?;
    o_prot.write_field_end()?;
    o_prot.write_field_stop()?;
    o_prot.write_struct_end()
  }
}

//
// HbaseMutateRowResult
//

#[derive(Clone, Debug, Eq, Hash, Ord, PartialEq, PartialOrd)]
struct HbaseMutateRowResult {
  io: Option<IOError>,
  ia: Option<IllegalArgument>,
}

impl HbaseMutateRowResult {
  fn read_from_in_protocol(i_prot: &mut dyn TInputProtocol) -> thrift::Result<HbaseMutateRowResult> {
    i_prot.read_struct_begin()?;
    let mut f_1: Option<IOError> = None;
    let mut f_2: Option<IllegalArgument> = None;
    loop {
      let field_ident = i_prot.read_field_begin()?;
      if field_ident.field_type == TType::Stop {
        break;
      }
      let field_id = field_id(&field_ident)?;
      match field_id {
        1 => {
          let val = IOError::read_from_in_protocol(i_prot)?;
          f_1 = Some(val);
        },
        2 => {
          let val = IllegalArgument::read_from_in_protocol(i_prot)?;
          f_2 = Some(val);
        },
        _ => {
          i_prot.skip(field_ident.field_type)?;
        },
      };
      i_prot.read_field_end()?;
    }
    i_prot.read_struct_end()?;
    let ret = HbaseMutateRowResult {
      io: f_1,
      ia: f_2,
    };
    Ok(ret)
  }
  fn write_to_out_protocol(&self, o_prot: &mut dyn TOutputProtocol) -> thrift::Result<()> {
    let struct_ident = TStructIdentifier::new("HbaseMutateRowResult");
    o_prot.write_struct_begin(&struct_ident)?;
    if let Some(ref fld_var) = self.io {
      o_prot.write_field_begin(&TFieldIdentifier::new("io", TType::Struct, 1))?;
      fld_var.write_to_out_protocol(o_prot)?;
      o_prot.write_field_end()?
    }
    if let Some(ref fld_var) = self.ia {
      o_prot.write_field_begin(&TFieldIdentifier::new("ia", TType::Struct, 2))?;
      fld_var.write_to_out_protocol(o_prot)?;
      o_prot.write_field_end()?
    }
    o_prot.write_field_stop()?;
    o_prot.write_struct_end()
  }
  fn ok_or(self) -> thrift::Result<()> {
    if self.io.is_some() {
      Err(thrift::Error::User(Box::new(self.io.unwrap())))
    } else if self.ia.is_some() {
      Err(thrift::Error::User(Box::new(self.ia.unwrap())))
    } else {
      Ok(())
    }
  }
}

//
// HbaseMutateRowTsArgs
//

#[derive(Clone, Debug, Eq, Hash, Ord, PartialEq, PartialOrd)]
struct HbaseMutateRowTsArgs {
  /// name of table
  table_name: Text,
  /// row key
  row: Text,
  /// list of mutation commands
  mutations: Vec<Mutation>,
  /// timestamp
  timestamp: i64,
  /// Mutation attributes
  attributes: BTreeMap<Text, Text>,
}

impl HbaseMutateRowTsArgs {
  fn read_from_in_protocol(i_prot: &mut dyn TInputProtocol) -> thrift::Result<HbaseMutateRowTsArgs> {
    i_prot.read_struct_begin()?;
    let mut f_1: Option<Text> = None;
    let mut f_2: Option<Text> = None;
    let mut f_3: Option<Vec<Mutation>> = None;
    let mut f_4: Option<i64> = None;
    let mut f_5: Option<BTreeMap<Text, Text>> = None;
    loop {
      let field_ident = i_prot.read_field_begin()?;
      if field_ident.field_type == TType::Stop {
        break;
      }
      let field_id = field_id(&field_ident)?;
      match field_id {
        1 => {
          let val = i_prot.read_bytes()?;
          f_1 = Some(val);
        },
        2 => {
          let val = i_prot.read_bytes()?;
          f_2 = Some(val);
        },
        3 => {
          let list_ident = i_prot.read_list_begin()?;
          let mut val: Vec<Mutation> = Vec::with_capacity(list_ident.size as usize);
          for _ in 0..list_ident.size {
            let list_elem_58 = Mutation::read_from_in_protocol(i_prot)?;
            val.push(list_elem_58);
          }
          i_prot.read_list_end()?;
          f_3 = Some(val);
        },
        4 => {
          let val = i_prot.read_i64()?;
          f_4 = Some(val);
        },
        5 => {
          let map_ident = i_prot.read_map_begin()?;
          let mut val: BTreeMap<Text, Text> = BTreeMap::new();
          for _ in 0..map_ident.size {
            let map_key_59 = i_prot.read_bytes()?;
            let map_val_60 = i_prot.read_bytes()?;
            val.insert(map_key_59, map_val_60);
          }
          i_prot.read_map_end()?;
          f_5 = Some(val);
        },
        _ => {
          i_prot.skip(field_ident.field_type)?;
        },
      };
      i_prot.read_field_end()?;
    }
    i_prot.read_struct_end()?;
    verify_required_field_exists("HbaseMutateRowTsArgs.table_name", &f_1)?;
    verify_required_field_exists("HbaseMutateRowTsArgs.row", &f_2)?;
    verify_required_field_exists("HbaseMutateRowTsArgs.mutations", &f_3)?;
    verify_required_field_exists("HbaseMutateRowTsArgs.timestamp", &f_4)?;
    verify_required_field_exists("HbaseMutateRowTsArgs.attributes", &f_5)?;
    let ret = HbaseMutateRowTsArgs {
      table_name: f_1.expect("auto-generated code should have checked for presence of required fields"),
      row: f_2.expect("auto-generated code should have checked for presence of required fields"),
      mutations: f_3.expect("auto-generated code should have checked for presence of required fields"),
      timestamp: f_4.expect("auto-generated code should have checked for presence of required fields"),
      attributes: f_5.expect("auto-generated code should have checked for presence of required fields"),
    };
    Ok(ret)
  }
  fn write_to_out_protocol(&self, o_prot: &mut dyn TOutputProtocol) -> thrift::Result<()> {
    let struct_ident = TStructIdentifier::new("mutateRowTs_args");
    o_prot.write_struct_begin(&struct_ident)?;
    o_prot.write_field_begin(&TFieldIdentifier::new("tableName", TType::String, 1))?;
    o_prot.write_bytes(&self.table_name)?;
    o_prot.write_field_end()?;
    o_prot.write_field_begin(&TFieldIdentifier::new("row", TType::String, 2))?;
    o_prot.write_bytes(&self.row)?;
    o_prot.write_field_end()?;
    o_prot.write_field_begin(&TFieldIdentifier::new("mutations", TType::List, 3))?;
    o_prot.write_list_begin(&TListIdentifier::new(TType::Struct, self.mutations.len() as i32))?;
    for e in &self.mutations {
      e.write_to_out_protocol(o_prot)?;
    }
    o_prot.write_list_end()?;
    o_prot.write_field_end()?;
    o_prot.write_field_begin(&TFieldIdentifier::new("timestamp", TType::I64, 4))?;
    o_prot.write_i64(self.timestamp)?;
    o_prot.write_field_end()?;
    o_prot.write_field_begin(&TFieldIdentifier::new("attributes", TType::Map, 5))?;
    o_prot.write_map_begin(&TMapIdentifier::new(TType::String, TType::String, self.attributes.len() as i32))?;
    for (k, v) in &self.attributes {
      o_prot.write_bytes(k)?;
      o_prot.write_bytes(v)?;
    }
    o_prot.write_map_end()?;
    o_prot.write_field_end()?;
    o_prot.write_field_stop()?;
    o_prot.write_struct_end()
  }
}

//
// HbaseMutateRowTsResult
//

#[derive(Clone, Debug, Eq, Hash, Ord, PartialEq, PartialOrd)]
struct HbaseMutateRowTsResult {
  io: Option<IOError>,
  ia: Option<IllegalArgument>,
}

impl HbaseMutateRowTsResult {
  fn read_from_in_protocol(i_prot: &mut dyn TInputProtocol) -> thrift::Result<HbaseMutateRowTsResult> {
    i_prot.read_struct_begin()?;
    let mut f_1: Option<IOError> = None;
    let mut f_2: Option<IllegalArgument> = None;
    loop {
      let field_ident = i_prot.read_field_begin()?;
      if field_ident.field_type == TType::Stop {
        break;
      }
      let field_id = field_id(&field_ident)?;
      match field_id {
        1 => {
          let val = IOError::read_from_in_protocol(i_prot)?;
          f_1 = Some(val);
        },
        2 => {
          let val = IllegalArgument::read_from_in_protocol(i_prot)?;
          f_2 = Some(val);
        },
        _ => {
          i_prot.skip(field_ident.field_type)?;
        },
      };
      i_prot.read_field_end()?;
    }
    i_prot.read_struct_end()?;
    let ret = HbaseMutateRowTsResult {
      io: f_1,
      ia: f_2,
    };
    Ok(ret)
  }
  fn write_to_out_protocol(&self, o_prot: &mut dyn TOutputProtocol) -> thrift::Result<()> {
    let struct_ident = TStructIdentifier::new("HbaseMutateRowTsResult");
    o_prot.write_struct_begin(&struct_ident)?;
    if let Some(ref fld_var) = self.io {
      o_prot.write_field_begin(&TFieldIdentifier::new("io", TType::Struct, 1))?;
      fld_var.write_to_out_protocol(o_prot)?;
      o_prot.write_field_end()?
    }
    if let Some(ref fld_var) = self.ia {
      o_prot.write_field_begin(&TFieldIdentifier::new("ia", TType::Struct, 2))?;
      fld_var.write_to_out_protocol(o_prot)?;
      o_prot.write_field_end()?
    }
    o_prot.write_field_stop()?;
    o_prot.write_struct_end()
  }
  fn ok_or(self) -> thrift::Result<()> {
    if self.io.is_some() {
      Err(thrift::Error::User(Box::new(self.io.unwrap())))
    } else if self.ia.is_some() {
      Err(thrift::Error::User(Box::new(self.ia.unwrap())))
    } else {
      Ok(())
    }
  }
}

//
// HbaseMutateRowsArgs
//

#[derive(Clone, Debug, Eq, Hash, Ord, PartialEq, PartialOrd)]
struct HbaseMutateRowsArgs {
  /// name of table
  table_name: Text,
  /// list of row batches
  row_batches: Vec<BatchMutation>,
  /// Mutation attributes
  attributes: BTreeMap<Text, Text>,
}

impl HbaseMutateRowsArgs {
  fn read_from_in_protocol(i_prot: &mut dyn TInputProtocol) -> thrift::Result<HbaseMutateRowsArgs> {
    i_prot.read_struct_begin()?;
    let mut f_1: Option<Text> = None;
    let mut f_2: Option<Vec<BatchMutation>> = None;
    let mut f_3: Option<BTreeMap<Text, Text>> = None;
    loop {
      let field_ident = i_prot.read_field_begin()?;
      if field_ident.field_type == TType::Stop {
        break;
      }
      let field_id = field_id(&field_ident)?;
      match field_id {
        1 => {
          let val = i_prot.read_bytes()?;
          f_1 = Some(val);
        },
        2 => {
          let list_ident = i_prot.read_list_begin()?;
          let mut val: Vec<BatchMutation> = Vec::with_capacity(list_ident.size as usize);
          for _ in 0..list_ident.size {
            let list_elem_61 = BatchMutation::read_from_in_protocol(i_prot)?;
            val.push(list_elem_61);
          }
          i_prot.read_list_end()?;
          f_2 = Some(val);
        },
        3 => {
          let map_ident = i_prot.read_map_begin()?;
          let mut val: BTreeMap<Text, Text> = BTreeMap::new();
          for _ in 0..map_ident.size {
            let map_key_62 = i_prot.read_bytes()?;
            let map_val_63 = i_prot.read_bytes()?;
            val.insert(map_key_62, map_val_63);
          }
          i_prot.read_map_end()?;
          f_3 = Some(val);
        },
        _ => {
          i_prot.skip(field_ident.field_type)?;
        },
      };
      i_prot.read_field_end()?;
    }
    i_prot.read_struct_end()?;
    verify_required_field_exists("HbaseMutateRowsArgs.table_name", &f_1)?;
    verify_required_field_exists("HbaseMutateRowsArgs.row_batches", &f_2)?;
    verify_required_field_exists("HbaseMutateRowsArgs.attributes", &f_3)?;
    let ret = HbaseMutateRowsArgs {
      table_name: f_1.expect("auto-generated code should have checked for presence of required fields"),
      row_batches: f_2.expect("auto-generated code should have checked for presence of required fields"),
      attributes: f_3.expect("auto-generated code should have checked for presence of required fields"),
    };
    Ok(ret)
  }
  fn write_to_out_protocol(&self, o_prot: &mut dyn TOutputProtocol) -> thrift::Result<()> {
    let struct_ident = TStructIdentifier::new("mutateRows_args");
    o_prot.write_struct_begin(&struct_ident)?;
    o_prot.write_field_begin(&TFieldIdentifier::new("tableName", TType::String, 1))?;
    o_prot.write_bytes(&self.table_name)?;
    o_prot.write_field_end()?;
    o_prot.write_field_begin(&TFieldIdentifier::new("rowBatches", TType::List, 2))?;
    o_prot.write_list_begin(&TListIdentifier::new(TType::Struct, self.row_batches.len() as i32))?;
    for e in &self.row_batches {
      e.write_to_out_protocol(o_prot)?;
    }
    o_prot.write_list_end()?;
    o_prot.write_field_end()?;
    o_prot.write_field_begin(&TFieldIdentifier::new("attributes", TType::Map, 3))?;
    o_prot.write_map_begin(&TMapIdentifier::new(TType::String, TType::String, self.attributes.len() as i32))?;
    for (k, v) in &self.attributes {
      o_prot.write_bytes(k)?;
      o_prot.write_bytes(v)?;
    }
    o_prot.write_map_end()?;
    o_prot.write_field_end()?;
    o_prot.write_field_stop()?;
    o_prot.write_struct_end()
  }
}

//
// HbaseMutateRowsResult
//

#[derive(Clone, Debug, Eq, Hash, Ord, PartialEq, PartialOrd)]
struct HbaseMutateRowsResult {
  io: Option<IOError>,
  ia: Option<IllegalArgument>,
}

impl HbaseMutateRowsResult {
  fn read_from_in_protocol(i_prot: &mut dyn TInputProtocol) -> thrift::Result<HbaseMutateRowsResult> {
    i_prot.read_struct_begin()?;
    let mut f_1: Option<IOError> = None;
    let mut f_2: Option<IllegalArgument> = None;
    loop {
      let field_ident = i_prot.read_field_begin()?;
      if field_ident.field_type == TType::Stop {
        break;
      }
      let field_id = field_id(&field_ident)?;
      match field_id {
        1 => {
          let val = IOError::read_from_in_protocol(i_prot)?;
          f_1 = Some(val);
        },
        2 => {
          let val = IllegalArgument::read_from_in_protocol(i_prot)?;
          f_2 = Some(val);
        },
        _ => {
          i_prot.skip(field_ident.field_type)?;
        },
      };
      i_prot.read_field_end()?;
    }
    i_prot.read_struct_end()?;
    let ret = HbaseMutateRowsResult {
      io: f_1,
      ia: f_2,
    };
    Ok(ret)
  }
  fn write_to_out_protocol(&self, o_prot: &mut dyn TOutputProtocol) -> thrift::Result<()> {
    let struct_ident = TStructIdentifier::new("HbaseMutateRowsResult");
    o_prot.write_struct_begin(&struct_ident)?;
    if let Some(ref fld_var) = self.io {
      o_prot.write_field_begin(&TFieldIdentifier::new("io", TType::Struct, 1))?;
      fld_var.write_to_out_protocol(o_prot)?;
      o_prot.write_field_end()?
    }
    if let Some(ref fld_var) = self.ia {
      o_prot.write_field_begin(&TFieldIdentifier::new("ia", TType::Struct, 2))?;
      fld_var.write_to_out_protocol(o_prot)?;
      o_prot.write_field_end()?
    }
    o_prot.write_field_stop()?;
    o_prot.write_struct_end()
  }
  fn ok_or(self) -> thrift::Result<()> {
    if self.io.is_some() {
      Err(thrift::Error::User(Box::new(self.io.unwrap())))
    } else if self.ia.is_some() {
      Err(thrift::Error::User(Box::new(self.ia.unwrap())))
    } else {
      Ok(())
    }
  }
}

//
// HbaseMutateRowsTsArgs
//

#[derive(Clone, Debug, Eq, Hash, Ord, PartialEq, PartialOrd)]
struct HbaseMutateRowsTsArgs {
  /// name of table
  table_name: Text,
  /// list of row batches
  row_batches: Vec<BatchMutation>,
  /// timestamp
  timestamp: i64,
  /// Mutation attributes
  attributes: BTreeMap<Text, Text>,
}

impl HbaseMutateRowsTsArgs {
  fn read_from_in_protocol(i_prot: &mut dyn TInputProtocol) -> thrift::Result<HbaseMutateRowsTsArgs> {
    i_prot.read_struct_begin()?;
    let mut f_1: Option<Text> = None;
    let mut f_2: Option<Vec<BatchMutation>> = None;
    let mut f_3: Option<i64> = None;
    let mut f_4: Option<BTreeMap<Text, Text>> = None;
    loop {
      let field_ident = i_prot.read_field_begin()?;
      if field_ident.field_type == TType::Stop {
        break;
      }
      let field_id = field_id(&field_ident)?;
      match field_id {
        1 => {
          let val = i_prot.read_bytes()?;
          f_1 = Some(val);
        },
        2 => {
          let list_ident = i_prot.read_list_begin()?;
          let mut val: Vec<BatchMutation> = Vec::with_capacity(list_ident.size as usize);
          for _ in 0..list_ident.size {
            let list_elem_64 = BatchMutation::read_from_in_protocol(i_prot)?;
            val.push(list_elem_64);
          }
          i_prot.read_list_end()?;
          f_2 = Some(val);
        },
        3 => {
          let val = i_prot.read_i64()?;
          f_3 = Some(val);
        },
        4 => {
          let map_ident = i_prot.read_map_begin()?;
          let mut val: BTreeMap<Text, Text> = BTreeMap::new();
          for _ in 0..map_ident.size {
            let map_key_65 = i_prot.read_bytes()?;
            let map_val_66 = i_prot.read_bytes()?;
            val.insert(map_key_65, map_val_66);
          }
          i_prot.read_map_end()?;
          f_4 = Some(val);
        },
        _ => {
          i_prot.skip(field_ident.field_type)?;
        },
      };
      i_prot.read_field_end()?;
    }
    i_prot.read_struct_end()?;
    verify_required_field_exists("HbaseMutateRowsTsArgs.table_name", &f_1)?;
    verify_required_field_exists("HbaseMutateRowsTsArgs.row_batches", &f_2)?;
    verify_required_field_exists("HbaseMutateRowsTsArgs.timestamp", &f_3)?;
    verify_required_field_exists("HbaseMutateRowsTsArgs.attributes", &f_4)?;
    let ret = HbaseMutateRowsTsArgs {
      table_name: f_1.expect("auto-generated code should have checked for presence of required fields"),
      row_batches: f_2.expect("auto-generated code should have checked for presence of required fields"),
      timestamp: f_3.expect("auto-generated code should have checked for presence of required fields"),
      attributes: f_4.expect("auto-generated code should have checked for presence of required fields"),
    };
    Ok(ret)
  }
  fn write_to_out_protocol(&self, o_prot: &mut dyn TOutputProtocol) -> thrift::Result<()> {
    let struct_ident = TStructIdentifier::new("mutateRowsTs_args");
    o_prot.write_struct_begin(&struct_ident)?;
    o_prot.write_field_begin(&TFieldIdentifier::new("tableName", TType::String, 1))?;
    o_prot.write_bytes(&self.table_name)?;
    o_prot.write_field_end()?;
    o_prot.write_field_begin(&TFieldIdentifier::new("rowBatches", TType::List, 2))?;
    o_prot.write_list_begin(&TListIdentifier::new(TType::Struct, self.row_batches.len() as i32))?;
    for e in &self.row_batches {
      e.write_to_out_protocol(o_prot)?;
    }
    o_prot.write_list_end()?;
    o_prot.write_field_end()?;
    o_prot.write_field_begin(&TFieldIdentifier::new("timestamp", TType::I64, 3))?;
    o_prot.write_i64(self.timestamp)?;
    o_prot.write_field_end()?;
    o_prot.write_field_begin(&TFieldIdentifier::new("attributes", TType::Map, 4))?;
    o_prot.write_map_begin(&TMapIdentifier::new(TType::String, TType::String, self.attributes.len() as i32))?;
    for (k, v) in &self.attributes {
      o_prot.write_bytes(k)?;
      o_prot.write_bytes(v)?;
    }
    o_prot.write_map_end()?;
    o_prot.write_field_end()?;
    o_prot.write_field_stop()?;
    o_prot.write_struct_end()
  }
}

//
// HbaseMutateRowsTsResult
//

#[derive(Clone, Debug, Eq, Hash, Ord, PartialEq, PartialOrd)]
struct HbaseMutateRowsTsResult {
  io: Option<IOError>,
  ia: Option<IllegalArgument>,
}

impl HbaseMutateRowsTsResult {
  fn read_from_in_protocol(i_prot: &mut dyn TInputProtocol) -> thrift::Result<HbaseMutateRowsTsResult> {
    i_prot.read_struct_begin()?;
    let mut f_1: Option<IOError> = None;
    let mut f_2: Option<IllegalArgument> = None;
    loop {
      let field_ident = i_prot.read_field_begin()?;
      if field_ident.field_type == TType::Stop {
        break;
      }
      let field_id = field_id(&field_ident)?;
      match field_id {
        1 => {
          let val = IOError::read_from_in_protocol(i_prot)?;
          f_1 = Some(val);
        },
        2 => {
          let val = IllegalArgument::read_from_in_protocol(i_prot)?;
          f_2 = Some(val);
        },
        _ => {
          i_prot.skip(field_ident.field_type)?;
        },
      };
      i_prot.read_field_end()?;
    }
    i_prot.read_struct_end()?;
    let ret = HbaseMutateRowsTsResult {
      io: f_1,
      ia: f_2,
    };
    Ok(ret)
  }
  fn write_to_out_protocol(&self, o_prot: &mut dyn TOutputProtocol) -> thrift::Result<()> {
    let struct_ident = TStructIdentifier::new("HbaseMutateRowsTsResult");
    o_prot.write_struct_begin(&struct_ident)?;
    if let Some(ref fld_var) = self.io {
      o_prot.write_field_begin(&TFieldIdentifier::new("io", TType::Struct, 1))?;
      fld_var.write_to_out_protocol(o_prot)?;
      o_prot.write_field_end()?
    }
    if let Some(ref fld_var) = self.ia {
      o_prot.write_field_begin(&TFieldIdentifier::new("ia", TType::Struct, 2))?;
      fld_var.write_to_out_protocol(o_prot)?;
      o_prot.write_field_end()?
    }
    o_prot.write_field_stop()?;
    o_prot.write_struct_end()
  }
  fn ok_or(self) -> thrift::Result<()> {
    if self.io.is_some() {
      Err(thrift::Error::User(Box::new(self.io.unwrap())))
    } else if self.ia.is_some() {
      Err(thrift::Error::User(Box::new(self.ia.unwrap())))
    } else {
      Ok(())
    }
  }
}

//
// HbaseAtomicIncrementArgs
//

#[derive(Clone, Debug, Eq, Hash, Ord, PartialEq, PartialOrd)]
struct HbaseAtomicIncrementArgs {
  /// name of table
  table_name: Text,
  /// row to increment
  row: Text,
  /// name of column
  column: Text,
  /// amount to increment by
  value: i64,
}

impl HbaseAtomicIncrementArgs {
  fn read_from_in_protocol(i_prot: &mut dyn TInputProtocol) -> thrift::Result<HbaseAtomicIncrementArgs> {
    i_prot.read_struct_begin()?;
    let mut f_1: Option<Text> = None;
    let mut f_2: Option<Text> = None;
    let mut f_3: Option<Text> = None;
    let mut f_4: Option<i64> = None;
    loop {
      let field_ident = i_prot.read_field_begin()?;
      if field_ident.field_type == TType::Stop {
        break;
      }
      let field_id = field_id(&field_ident)?;
      match field_id {
        1 => {
          let val = i_prot.read_bytes()?;
          f_1 = Some(val);
        },
        2 => {
          let val = i_prot.read_bytes()?;
          f_2 = Some(val);
        },
        3 => {
          let val = i_prot.read_bytes()?;
          f_3 = Some(val);
        },
        4 => {
          let val = i_prot.read_i64()?;
          f_4 = Some(val);
        },
        _ => {
          i_prot.skip(field_ident.field_type)?;
        },
      };
      i_prot.read_field_end()?;
    }
    i_prot.read_struct_end()?;
    verify_required_field_exists("HbaseAtomicIncrementArgs.table_name", &f_1)?;
    verify_required_field_exists("HbaseAtomicIncrementArgs.row", &f_2)?;
    verify_required_field_exists("HbaseAtomicIncrementArgs.column", &f_3)?;
    verify_required_field_exists("HbaseAtomicIncrementArgs.value", &f_4)?;
    let ret = HbaseAtomicIncrementArgs {
      table_name: f_1.expect("auto-generated code should have checked for presence of required fields"),
      row: f_2.expect("auto-generated code should have checked for presence of required fields"),
      column: f_3.expect("auto-generated code should have checked for presence of required fields"),
      value: f_4.expect("auto-generated code should have checked for presence of required fields"),
    };
    Ok(ret)
  }
  fn write_to_out_protocol(&self, o_prot: &mut dyn TOutputProtocol) -> thrift::Result<()> {
    let struct_ident = TStructIdentifier::new("atomicIncrement_args");
    o_prot.write_struct_begin(&struct_ident)?;
    o_prot.write_field_begin(&TFieldIdentifier::new("tableName", TType::String, 1))?;
    o_prot.write_bytes(&self.table_name)?;
    o_prot.write_field_end()?;
    o_prot.write_field_begin(&TFieldIdentifier::new("row", TType::String, 2))?;
    o_prot.write_bytes(&self.row)?;
    o_prot.write_field_end()?;
    o_prot.write_field_begin(&TFieldIdentifier::new("column", TType::String, 3))?;
    o_prot.write_bytes(&self.column)?;
    o_prot.write_field_end()?;
    o_prot.write_field_begin(&TFieldIdentifier::new("value", TType::I64, 4))?;
    o_prot.write_i64(self.value)?;
    o_prot.write_field_end()?;
    o_prot.write_field_stop()?;
    o_prot.write_struct_end()
  }
}

//
// HbaseAtomicIncrementResult
//

#[derive(Clone, Debug, Eq, Hash, Ord, PartialEq, PartialOrd)]
struct HbaseAtomicIncrementResult {
  result_value: Option<i64>,
  io: Option<IOError>,
  ia: Option<IllegalArgument>,
}

impl HbaseAtomicIncrementResult {
  fn read_from_in_protocol(i_prot: &mut dyn TInputProtocol) -> thrift::Result<HbaseAtomicIncrementResult> {
    i_prot.read_struct_begin()?;
    let mut f_0: Option<i64> = None;
    let mut f_1: Option<IOError> = None;
    let mut f_2: Option<IllegalArgument> = None;
    loop {
      let field_ident = i_prot.read_field_begin()?;
      if field_ident.field_type == TType::Stop {
        break;
      }
      let field_id = field_id(&field_ident)?;
      match field_id {
        0 => {
          let val = i_prot.read_i64()?;
          f_0 = Some(val);
        },
        1 => {
          let val = IOError::read_from_in_protocol(i_prot)?;
          f_1 = Some(val);
        },
        2 => {
          let val = IllegalArgument::read_from_in_protocol(i_prot)?;
          f_2 = Some(val);
        },
        _ => {
          i_prot.skip(field_ident.field_type)?;
        },
      };
      i_prot.read_field_end()?;
    }
    i_prot.read_struct_end()?;
    let ret = HbaseAtomicIncrementResult {
      result_value: f_0,
      io: f_1,
      ia: f_2,
    };
    Ok(ret)
  }
  fn write_to_out_protocol(&self, o_prot: &mut dyn TOutputProtocol) -> thrift::Result<()> {
    let struct_ident = TStructIdentifier::new("HbaseAtomicIncrementResult");
    o_prot.write_struct_begin(&struct_ident)?;
    if let Some(fld_var) = self.result_value {
      o_prot.write_field_begin(&TFieldIdentifier::new("result_value", TType::I64, 0))?;
      o_prot.write_i64(fld_var)?;
      o_prot.write_field_end()?
    }
    if let Some(ref fld_var) = self.io {
      o_prot.write_field_begin(&TFieldIdentifier::new("io", TType::Struct, 1))?;
      fld_var.write_to_out_protocol(o_prot)?;
      o_prot.write_field_end()?
    }
    if let Some(ref fld_var) = self.ia {
      o_prot.write_field_begin(&TFieldIdentifier::new("ia", TType::Struct, 2))?;
      fld_var.write_to_out_protocol(o_prot)?;
      o_prot.write_field_end()?
    }
    o_prot.write_field_stop()?;
    o_prot.write_struct_end()
  }
  fn ok_or(self) -> thrift::Result<i64> {
    if self.io.is_some() {
      Err(thrift::Error::User(Box::new(self.io.unwrap())))
    } else if self.ia.is_some() {
      Err(thrift::Error::User(Box::new(self.ia.unwrap())))
    } else if self.result_value.is_some() {
      Ok(self.result_value.unwrap())
    } else {
      Err(
        thrift::Error::Application(
          ApplicationError::new(
            ApplicationErrorKind::MissingResult,
            "no result received for HbaseAtomicIncrement"
          )
        )
      )
    }
  }
}

//
// HbaseDeleteAllArgs
//

#[derive(Clone, Debug, Eq, Hash, Ord, PartialEq, PartialOrd)]
struct HbaseDeleteAllArgs {
  /// name of table
  table_name: Text,
  /// Row to update
  row: Text,
  /// name of column whose value is to be deleted
  column: Text,
  /// Delete attributes
  attributes: BTreeMap<Text, Text>,
}

impl HbaseDeleteAllArgs {
  fn read_from_in_protocol(i_prot: &mut dyn TInputProtocol) -> thrift::Result<HbaseDeleteAllArgs> {
    i_prot.read_struct_begin()?;
    let mut f_1: Option<Text> = None;
    let mut f_2: Option<Text> = None;
    let mut f_3: Option<Text> = None;
    let mut f_4: Option<BTreeMap<Text, Text>> = None;
    loop {
      let field_ident = i_prot.read_field_begin()?;
      if field_ident.field_type == TType::Stop {
        break;
      }
      let field_id = field_id(&field_ident)?;
      match field_id {
        1 => {
          let val = i_prot.read_bytes()?;
          f_1 = Some(val);
        },
        2 => {
          let val = i_prot.read_bytes()?;
          f_2 = Some(val);
        },
        3 => {
          let val = i_prot.read_bytes()?;
          f_3 = Some(val);
        },
        4 => {
          let map_ident = i_prot.read_map_begin()?;
          let mut val: BTreeMap<Text, Text> = BTreeMap::new();
          for _ in 0..map_ident.size {
            let map_key_67 = i_prot.read_bytes()?;
            let map_val_68 = i_prot.read_bytes()?;
            val.insert(map_key_67, map_val_68);
          }
          i_prot.read_map_end()?;
          f_4 = Some(val);
        },
        _ => {
          i_prot.skip(field_ident.field_type)?;
        },
      };
      i_prot.read_field_end()?;
    }
    i_prot.read_struct_end()?;
    verify_required_field_exists("HbaseDeleteAllArgs.table_name", &f_1)?;
    verify_required_field_exists("HbaseDeleteAllArgs.row", &f_2)?;
    verify_required_field_exists("HbaseDeleteAllArgs.column", &f_3)?;
    verify_required_field_exists("HbaseDeleteAllArgs.attributes", &f_4)?;
    let ret = HbaseDeleteAllArgs {
      table_name: f_1.expect("auto-generated code should have checked for presence of required fields"),
      row: f_2.expect("auto-generated code should have checked for presence of required fields"),
      column: f_3.expect("auto-generated code should have checked for presence of required fields"),
      attributes: f_4.expect("auto-generated code should have checked for presence of required fields"),
    };
    Ok(ret)
  }
  fn write_to_out_protocol(&self, o_prot: &mut dyn TOutputProtocol) -> thrift::Result<()> {
    let struct_ident = TStructIdentifier::new("deleteAll_args");
    o_prot.write_struct_begin(&struct_ident)?;
    o_prot.write_field_begin(&TFieldIdentifier::new("tableName", TType::String, 1))?;
    o_prot.write_bytes(&self.table_name)?;
    o_prot.write_field_end()?;
    o_prot.write_field_begin(&TFieldIdentifier::new("row", TType::String, 2))?;
    o_prot.write_bytes(&self.row)?;
    o_prot.write_field_end()?;
    o_prot.write_field_begin(&TFieldIdentifier::new("column", TType::String, 3))?;
    o_prot.write_bytes(&self.column)?;
    o_prot.write_field_end()?;
    o_prot.write_field_begin(&TFieldIdentifier::new("attributes", TType::Map, 4))?;
    o_prot.write_map_begin(&TMapIdentifier::new(TType::String, TType::String, self.attributes.len() as i32))?;
    for (k, v) in &self.attributes {
      o_prot.write_bytes(k)?;
      o_prot.write_bytes(v)?;
    }
    o_prot.write_map_end()?;
    o_prot.write_field_end()?;
    o_prot.write_field_stop()?;
    o_prot.write_struct_end()
  }
}

//
// HbaseDeleteAllResult
//

#[derive(Clone, Debug, Eq, Hash, Ord, PartialEq, PartialOrd)]
struct HbaseDeleteAllResult {
  io: Option<IOError>,
}

impl HbaseDeleteAllResult {
  fn read_from_in_protocol(i_prot: &mut dyn TInputProtocol) -> thrift::Result<HbaseDeleteAllResult> {
    i_prot.read_struct_begin()?;
    let mut f_1: Option<IOError> = None;
    loop {
      let field_ident = i_prot.read_field_begin()?;
      if field_ident.field_type == TType::Stop {
        break;
      }
      let field_id = field_id(&field_ident)?;
      match field_id {
        1 => {
          let val = IOError::read_from_in_protocol(i_prot)?;
          f_1 = Some(val);
        },
        _ => {
          i_prot.skip(field_ident.field_type)?;
        },
      };
      i_prot.read_field_end()?;
    }
    i_prot.read_struct_end()?;
    let ret = HbaseDeleteAllResult {
      io: f_1,
    };
    Ok(ret)
  }
  fn write_to_out_protocol(&self, o_prot: &mut dyn TOutputProtocol) -> thrift::Result<()> {
    let struct_ident = TStructIdentifier::new("HbaseDeleteAllResult");
    o_prot.write_struct_begin(&struct_ident)?;
    if let Some(ref fld_var) = self.io {
      o_prot.write_field_begin(&TFieldIdentifier::new("io", TType::Struct, 1))?;
      fld_var.write_to_out_protocol(o_prot)?;
      o_prot.write_field_end()?
    }
    o_prot.write_field_stop()?;
    o_prot.write_struct_end()
  }
  fn ok_or(self) -> thrift::Result<()> {
    if self.io.is_some() {
      Err(thrift::Error::User(Box::new(self.io.unwrap())))
    } else {
      Ok(())
    }
  }
}

//
// HbaseDeleteAllTsArgs
//

#[derive(Clone, Debug, Eq, Hash, Ord, PartialEq, PartialOrd)]
struct HbaseDeleteAllTsArgs {
  /// name of table
  table_name: Text,
  /// Row to update
  row: Text,
  /// name of column whose value is to be deleted
  column: Text,
  /// timestamp
  timestamp: i64,
  /// Delete attributes
  attributes: BTreeMap<Text, Text>,
}

impl HbaseDeleteAllTsArgs {
  fn read_from_in_protocol(i_prot: &mut dyn TInputProtocol) -> thrift::Result<HbaseDeleteAllTsArgs> {
    i_prot.read_struct_begin()?;
    let mut f_1: Option<Text> = None;
    let mut f_2: Option<Text> = None;
    let mut f_3: Option<Text> = None;
    let mut f_4: Option<i64> = None;
    let mut f_5: Option<BTreeMap<Text, Text>> = None;
    loop {
      let field_ident = i_prot.read_field_begin()?;
      if field_ident.field_type == TType::Stop {
        break;
      }
      let field_id = field_id(&field_ident)?;
      match field_id {
        1 => {
          let val = i_prot.read_bytes()?;
          f_1 = Some(val);
        },
        2 => {
          let val = i_prot.read_bytes()?;
          f_2 = Some(val);
        },
        3 => {
          let val = i_prot.read_bytes()?;
          f_3 = Some(val);
        },
        4 => {
          let val = i_prot.read_i64()?;
          f_4 = Some(val);
        },
        5 => {
          let map_ident = i_prot.read_map_begin()?;
          let mut val: BTreeMap<Text, Text> = BTreeMap::new();
          for _ in 0..map_ident.size {
            let map_key_69 = i_prot.read_bytes()?;
            let map_val_70 = i_prot.read_bytes()?;
            val.insert(map_key_69, map_val_70);
          }
          i_prot.read_map_end()?;
          f_5 = Some(val);
        },
        _ => {
          i_prot.skip(field_ident.field_type)?;
        },
      };
      i_prot.read_field_end()?;
    }
    i_prot.read_struct_end()?;
    verify_required_field_exists("HbaseDeleteAllTsArgs.table_name", &f_1)?;
    verify_required_field_exists("HbaseDeleteAllTsArgs.row", &f_2)?;
    verify_required_field_exists("HbaseDeleteAllTsArgs.column", &f_3)?;
    verify_required_field_exists("HbaseDeleteAllTsArgs.timestamp", &f_4)?;
    verify_required_field_exists("HbaseDeleteAllTsArgs.attributes", &f_5)?;
    let ret = HbaseDeleteAllTsArgs {
      table_name: f_1.expect("auto-generated code should have checked for presence of required fields"),
      row: f_2.expect("auto-generated code should have checked for presence of required fields"),
      column: f_3.expect("auto-generated code should have checked for presence of required fields"),
      timestamp: f_4.expect("auto-generated code should have checked for presence of required fields"),
      attributes: f_5.expect("auto-generated code should have checked for presence of required fields"),
    };
    Ok(ret)
  }
  fn write_to_out_protocol(&self, o_prot: &mut dyn TOutputProtocol) -> thrift::Result<()> {
    let struct_ident = TStructIdentifier::new("deleteAllTs_args");
    o_prot.write_struct_begin(&struct_ident)?;
    o_prot.write_field_begin(&TFieldIdentifier::new("tableName", TType::String, 1))?;
    o_prot.write_bytes(&self.table_name)?;
    o_prot.write_field_end()?;
    o_prot.write_field_begin(&TFieldIdentifier::new("row", TType::String, 2))?;
    o_prot.write_bytes(&self.row)?;
    o_prot.write_field_end()?;
    o_prot.write_field_begin(&TFieldIdentifier::new("column", TType::String, 3))?;
    o_prot.write_bytes(&self.column)?;
    o_prot.write_field_end()?;
    o_prot.write_field_begin(&TFieldIdentifier::new("timestamp", TType::I64, 4))?;
    o_prot.write_i64(self.timestamp)?;
    o_prot.write_field_end()?;
    o_prot.write_field_begin(&TFieldIdentifier::new("attributes", TType::Map, 5))?;
    o_prot.write_map_begin(&TMapIdentifier::new(TType::String, TType::String, self.attributes.len() as i32))?;
    for (k, v) in &self.attributes {
      o_prot.write_bytes(k)?;
      o_prot.write_bytes(v)?;
    }
    o_prot.write_map_end()?;
    o_prot.write_field_end()?;
    o_prot.write_field_stop()?;
    o_prot.write_struct_end()
  }
}

//
// HbaseDeleteAllTsResult
//

#[derive(Clone, Debug, Eq, Hash, Ord, PartialEq, PartialOrd)]
struct HbaseDeleteAllTsResult {
  io: Option<IOError>,
}

impl HbaseDeleteAllTsResult {
  fn read_from_in_protocol(i_prot: &mut dyn TInputProtocol) -> thrift::Result<HbaseDeleteAllTsResult> {
    i_prot.read_struct_begin()?;
    let mut f_1: Option<IOError> = None;
    loop {
      let field_ident = i_prot.read_field_begin()?;
      if field_ident.field_type == TType::Stop {
        break;
      }
      let field_id = field_id(&field_ident)?;
      match field_id {
        1 => {
          let val = IOError::read_from_in_protocol(i_prot)?;
          f_1 = Some(val);
        },
        _ => {
          i_prot.skip(field_ident.field_type)?;
        },
      };
      i_prot.read_field_end()?;
    }
    i_prot.read_struct_end()?;
    let ret = HbaseDeleteAllTsResult {
      io: f_1,
    };
    Ok(ret)
  }
  fn write_to_out_protocol(&self, o_prot: &mut dyn TOutputProtocol) -> thrift::Result<()> {
    let struct_ident = TStructIdentifier::new("HbaseDeleteAllTsResult");
    o_prot.write_struct_begin(&struct_ident)?;
    if let Some(ref fld_var) = self.io {
      o_prot.write_field_begin(&TFieldIdentifier::new("io", TType::Struct, 1))?;
      fld_var.write_to_out_protocol(o_prot)?;
      o_prot.write_field_end()?
    }
    o_prot.write_field_stop()?;
    o_prot.write_struct_end()
  }
  fn ok_or(self) -> thrift::Result<()> {
    if self.io.is_some() {
      Err(thrift::Error::User(Box::new(self.io.unwrap())))
    } else {
      Ok(())
    }
  }
}

//
// HbaseDeleteAllRowArgs
//

#[derive(Clone, Debug, Eq, Hash, Ord, PartialEq, PartialOrd)]
struct HbaseDeleteAllRowArgs {
  /// name of table
  table_name: Text,
  /// key of the row to be completely deleted.
  row: Text,
  /// Delete attributes
  attributes: BTreeMap<Text, Text>,
}

impl HbaseDeleteAllRowArgs {
  fn read_from_in_protocol(i_prot: &mut dyn TInputProtocol) -> thrift::Result<HbaseDeleteAllRowArgs> {
    i_prot.read_struct_begin()?;
    let mut f_1: Option<Text> = None;
    let mut f_2: Option<Text> = None;
    let mut f_3: Option<BTreeMap<Text, Text>> = None;
    loop {
      let field_ident = i_prot.read_field_begin()?;
      if field_ident.field_type == TType::Stop {
        break;
      }
      let field_id = field_id(&field_ident)?;
      match field_id {
        1 => {
          let val = i_prot.read_bytes()?;
          f_1 = Some(val);
        },
        2 => {
          let val = i_prot.read_bytes()?;
          f_2 = Some(val);
        },
        3 => {
          let map_ident = i_prot.read_map_begin()?;
          let mut val: BTreeMap<Text, Text> = BTreeMap::new();
          for _ in 0..map_ident.size {
            let map_key_71 = i_prot.read_bytes()?;
            let map_val_72 = i_prot.read_bytes()?;
            val.insert(map_key_71, map_val_72);
          }
          i_prot.read_map_end()?;
          f_3 = Some(val);
        },
        _ => {
          i_prot.skip(field_ident.field_type)?;
        },
      };
      i_prot.read_field_end()?;
    }
    i_prot.read_struct_end()?;
    verify_required_field_exists("HbaseDeleteAllRowArgs.table_name", &f_1)?;
    verify_required_field_exists("HbaseDeleteAllRowArgs.row", &f_2)?;
    verify_required_field_exists("HbaseDeleteAllRowArgs.attributes", &f_3)?;
    let ret = HbaseDeleteAllRowArgs {
      table_name: f_1.expect("auto-generated code should have checked for presence of required fields"),
      row: f_2.expect("auto-generated code should have checked for presence of required fields"),
      attributes: f_3.expect("auto-generated code should have checked for presence of required fields"),
    };
    Ok(ret)
  }
  fn write_to_out_protocol(&self, o_prot: &mut dyn TOutputProtocol) -> thrift::Result<()> {
    let struct_ident = TStructIdentifier::new("deleteAllRow_args");
    o_prot.write_struct_begin(&struct_ident)?;
    o_prot.write_field_begin(&TFieldIdentifier::new("tableName", TType::String, 1))?;
    o_prot.write_bytes(&self.table_name)?;
    o_prot.write_field_end()?;
    o_prot.write_field_begin(&TFieldIdentifier::new("row", TType::String, 2))?;
    o_prot.write_bytes(&self.row)?;
    o_prot.write_field_end()?;
    o_prot.write_field_begin(&TFieldIdentifier::new("attributes", TType::Map, 3))?;
    o_prot.write_map_begin(&TMapIdentifier::new(TType::String, TType::String, self.attributes.len() as i32))?;
    for (k, v) in &self.attributes {
      o_prot.write_bytes(k)?;
      o_prot.write_bytes(v)?;
    }
    o_prot.write_map_end()?;
    o_prot.write_field_end()?;
    o_prot.write_field_stop()?;
    o_prot.write_struct_end()
  }
}

//
// HbaseDeleteAllRowResult
//

#[derive(Clone, Debug, Eq, Hash, Ord, PartialEq, PartialOrd)]
struct HbaseDeleteAllRowResult {
  io: Option<IOError>,
}

impl HbaseDeleteAllRowResult {
  fn read_from_in_protocol(i_prot: &mut dyn TInputProtocol) -> thrift::Result<HbaseDeleteAllRowResult> {
    i_prot.read_struct_begin()?;
    let mut f_1: Option<IOError> = None;
    loop {
      let field_ident = i_prot.read_field_begin()?;
      if field_ident.field_type == TType::Stop {
        break;
      }
      let field_id = field_id(&field_ident)?;
      match field_id {
        1 => {
          let val = IOError::read_from_in_protocol(i_prot)?;
          f_1 = Some(val);
        },
        _ => {
          i_prot.skip(field_ident.field_type)?;
        },
      };
      i_prot.read_field_end()?;
    }
    i_prot.read_struct_end()?;
    let ret = HbaseDeleteAllRowResult {
      io: f_1,
    };
    Ok(ret)
  }
  fn write_to_out_protocol(&self, o_prot: &mut dyn TOutputProtocol) -> thrift::Result<()> {
    let struct_ident = TStructIdentifier::new("HbaseDeleteAllRowResult");
    o_prot.write_struct_begin(&struct_ident)?;
    if let Some(ref fld_var) = self.io {
      o_prot.write_field_begin(&TFieldIdentifier::new("io", TType::Struct, 1))?;
      fld_var.write_to_out_protocol(o_prot)?;
      o_prot.write_field_end()?
    }
    o_prot.write_field_stop()?;
    o_prot.write_struct_end()
  }
  fn ok_or(self) -> thrift::Result<()> {
    if self.io.is_some() {
      Err(thrift::Error::User(Box::new(self.io.unwrap())))
    } else {
      Ok(())
    }
  }
}

//
// HbaseIncrementArgs
//

#[derive(Clone, Debug, Eq, Hash, Ord, PartialEq, PartialOrd)]
struct HbaseIncrementArgs {
  /// The single increment to apply
  increment: TIncrement,
}

impl HbaseIncrementArgs {
  fn read_from_in_protocol(i_prot: &mut dyn TInputProtocol) -> thrift::Result<HbaseIncrementArgs> {
    i_prot.read_struct_begin()?;
    let mut f_1: Option<TIncrement> = None;
    loop {
      let field_ident = i_prot.read_field_begin()?;
      if field_ident.field_type == TType::Stop {
        break;
      }
      let field_id = field_id(&field_ident)?;
      match field_id {
        1 => {
          let val = TIncrement::read_from_in_protocol(i_prot)?;
          f_1 = Some(val);
        },
        _ => {
          i_prot.skip(field_ident.field_type)?;
        },
      };
      i_prot.read_field_end()?;
    }
    i_prot.read_struct_end()?;
    verify_required_field_exists("HbaseIncrementArgs.increment", &f_1)?;
    let ret = HbaseIncrementArgs {
      increment: f_1.expect("auto-generated code should have checked for presence of required fields"),
    };
    Ok(ret)
  }
  fn write_to_out_protocol(&self, o_prot: &mut dyn TOutputProtocol) -> thrift::Result<()> {
    let struct_ident = TStructIdentifier::new("increment_args");
    o_prot.write_struct_begin(&struct_ident)?;
    o_prot.write_field_begin(&TFieldIdentifier::new("increment", TType::Struct, 1))?;
    self.increment.write_to_out_protocol(o_prot)?;
    o_prot.write_field_end()?;
    o_prot.write_field_stop()?;
    o_prot.write_struct_end()
  }
}

//
// HbaseIncrementResult
//

#[derive(Clone, Debug, Eq, Hash, Ord, PartialEq, PartialOrd)]
struct HbaseIncrementResult {
  io: Option<IOError>,
}

impl HbaseIncrementResult {
  fn read_from_in_protocol(i_prot: &mut dyn TInputProtocol) -> thrift::Result<HbaseIncrementResult> {
    i_prot.read_struct_begin()?;
    let mut f_1: Option<IOError> = None;
    loop {
      let field_ident = i_prot.read_field_begin()?;
      if field_ident.field_type == TType::Stop {
        break;
      }
      let field_id = field_id(&field_ident)?;
      match field_id {
        1 => {
          let val = IOError::read_from_in_protocol(i_prot)?;
          f_1 = Some(val);
        },
        _ => {
          i_prot.skip(field_ident.field_type)?;
        },
      };
      i_prot.read_field_end()?;
    }
    i_prot.read_struct_end()?;
    let ret = HbaseIncrementResult {
      io: f_1,
    };
    Ok(ret)
  }
  fn write_to_out_protocol(&self, o_prot: &mut dyn TOutputProtocol) -> thrift::Result<()> {
    let struct_ident = TStructIdentifier::new("HbaseIncrementResult");
    o_prot.write_struct_begin(&struct_ident)?;
    if let Some(ref fld_var) = self.io {
      o_prot.write_field_begin(&TFieldIdentifier::new("io", TType::Struct, 1))?;
      fld_var.write_to_out_protocol(o_prot)?;
      o_prot.write_field_end()?
    }
    o_prot.write_field_stop()?;
    o_prot.write_struct_end()
  }
  fn ok_or(self) -> thrift::Result<()> {
    if self.io.is_some() {
      Err(thrift::Error::User(Box::new(self.io.unwrap())))
    } else {
      Ok(())
    }
  }
}

//
// HbaseIncrementRowsArgs
//

#[derive(Clone, Debug, Eq, Hash, Ord, PartialEq, PartialOrd)]
struct HbaseIncrementRowsArgs {
  /// The list of increments
  increments: Vec<TIncrement>,
}

impl HbaseIncrementRowsArgs {
  fn read_from_in_protocol(i_prot: &mut dyn TInputProtocol) -> thrift::Result<HbaseIncrementRowsArgs> {
    i_prot.read_struct_begin()?;
    let mut f_1: Option<Vec<TIncrement>> = None;
    loop {
      let field_ident = i_prot.read_field_begin()?;
      if field_ident.field_type == TType::Stop {
        break;
      }
      let field_id = field_id(&field_ident)?;
      match field_id {
        1 => {
          let list_ident = i_prot.read_list_begin()?;
          let mut val: Vec<TIncrement> = Vec::with_capacity(list_ident.size as usize);
          for _ in 0..list_ident.size {
            let list_elem_73 = TIncrement::read_from_in_protocol(i_prot)?;
            val.push(list_elem_73);
          }
          i_prot.read_list_end()?;
          f_1 = Some(val);
        },
        _ => {
          i_prot.skip(field_ident.field_type)?;
        },
      };
      i_prot.read_field_end()?;
    }
    i_prot.read_struct_end()?;
    verify_required_field_exists("HbaseIncrementRowsArgs.increments", &f_1)?;
    let ret = HbaseIncrementRowsArgs {
      increments: f_1.expect("auto-generated code should have checked for presence of required fields"),
    };
    Ok(ret)
  }
  fn write_to_out_protocol(&self, o_prot: &mut dyn TOutputProtocol) -> thrift::Result<()> {
    let struct_ident = TStructIdentifier::new("incrementRows_args");
    o_prot.write_struct_begin(&struct_ident)?;
    o_prot.write_field_begin(&TFieldIdentifier::new("increments", TType::List, 1))?;
    o_prot.write_list_begin(&TListIdentifier::new(TType::Struct, self.increments.len() as i32))?;
    for e in &self.increments {
      e.write_to_out_protocol(o_prot)?;
    }
    o_prot.write_list_end()?;
    o_prot.write_field_end()?;
    o_prot.write_field_stop()?;
    o_prot.write_struct_end()
  }
}

//
// HbaseIncrementRowsResult
//

#[derive(Clone, Debug, Eq, Hash, Ord, PartialEq, PartialOrd)]
struct HbaseIncrementRowsResult {
  io: Option<IOError>,
}

impl HbaseIncrementRowsResult {
  fn read_from_in_protocol(i_prot: &mut dyn TInputProtocol) -> thrift::Result<HbaseIncrementRowsResult> {
    i_prot.read_struct_begin()?;
    let mut f_1: Option<IOError> = None;
    loop {
      let field_ident = i_prot.read_field_begin()?;
      if field_ident.field_type == TType::Stop {
        break;
      }
      let field_id = field_id(&field_ident)?;
      match field_id {
        1 => {
          let val = IOError::read_from_in_protocol(i_prot)?;
          f_1 = Some(val);
        },
        _ => {
          i_prot.skip(field_ident.field_type)?;
        },
      };
      i_prot.read_field_end()?;
    }
    i_prot.read_struct_end()?;
    let ret = HbaseIncrementRowsResult {
      io: f_1,
    };
    Ok(ret)
  }
  fn write_to_out_protocol(&self, o_prot: &mut dyn TOutputProtocol) -> thrift::Result<()> {
    let struct_ident = TStructIdentifier::new("HbaseIncrementRowsResult");
    o_prot.write_struct_begin(&struct_ident)?;
    if let Some(ref fld_var) = self.io {
      o_prot.write_field_begin(&TFieldIdentifier::new("io", TType::Struct, 1))?;
      fld_var.write_to_out_protocol(o_prot)?;
      o_prot.write_field_end()?
    }
    o_prot.write_field_stop()?;
    o_prot.write_struct_end()
  }
  fn ok_or(self) -> thrift::Result<()> {
    if self.io.is_some() {
      Err(thrift::Error::User(Box::new(self.io.unwrap())))
    } else {
      Ok(())
    }
  }
}

//
// HbaseDeleteAllRowTsArgs
//

#[derive(Clone, Debug, Eq, Hash, Ord, PartialEq, PartialOrd)]
struct HbaseDeleteAllRowTsArgs {
  /// name of table
  table_name: Text,
  /// key of the row to be completely deleted.
  row: Text,
  /// timestamp
  timestamp: i64,
  /// Delete attributes
  attributes: BTreeMap<Text, Text>,
}

impl HbaseDeleteAllRowTsArgs {
  fn read_from_in_protocol(i_prot: &mut dyn TInputProtocol) -> thrift::Result<HbaseDeleteAllRowTsArgs> {
    i_prot.read_struct_begin()?;
    let mut f_1: Option<Text> = None;
    let mut f_2: Option<Text> = None;
    let mut f_3: Option<i64> = None;
    let mut f_4: Option<BTreeMap<Text, Text>> = None;
    loop {
      let field_ident = i_prot.read_field_begin()?;
      if field_ident.field_type == TType::Stop {
        break;
      }
      let field_id = field_id(&field_ident)?;
      match field_id {
        1 => {
          let val = i_prot.read_bytes()?;
          f_1 = Some(val);
        },
        2 => {
          let val = i_prot.read_bytes()?;
          f_2 = Some(val);
        },
        3 => {
          let val = i_prot.read_i64()?;
          f_3 = Some(val);
        },
        4 => {
          let map_ident = i_prot.read_map_begin()?;
          let mut val: BTreeMap<Text, Text> = BTreeMap::new();
          for _ in 0..map_ident.size {
            let map_key_74 = i_prot.read_bytes()?;
            let map_val_75 = i_prot.read_bytes()?;
            val.insert(map_key_74, map_val_75);
          }
          i_prot.read_map_end()?;
          f_4 = Some(val);
        },
        _ => {
          i_prot.skip(field_ident.field_type)?;
        },
      };
      i_prot.read_field_end()?;
    }
    i_prot.read_struct_end()?;
    verify_required_field_exists("HbaseDeleteAllRowTsArgs.table_name", &f_1)?;
    verify_required_field_exists("HbaseDeleteAllRowTsArgs.row", &f_2)?;
    verify_required_field_exists("HbaseDeleteAllRowTsArgs.timestamp", &f_3)?;
    verify_required_field_exists("HbaseDeleteAllRowTsArgs.attributes", &f_4)?;
    let ret = HbaseDeleteAllRowTsArgs {
      table_name: f_1.expect("auto-generated code should have checked for presence of required fields"),
      row: f_2.expect("auto-generated code should have checked for presence of required fields"),
      timestamp: f_3.expect("auto-generated code should have checked for presence of required fields"),
      attributes: f_4.expect("auto-generated code should have checked for presence of required fields"),
    };
    Ok(ret)
  }
  fn write_to_out_protocol(&self, o_prot: &mut dyn TOutputProtocol) -> thrift::Result<()> {
    let struct_ident = TStructIdentifier::new("deleteAllRowTs_args");
    o_prot.write_struct_begin(&struct_ident)?;
    o_prot.write_field_begin(&TFieldIdentifier::new("tableName", TType::String, 1))?;
    o_prot.write_bytes(&self.table_name)?;
    o_prot.write_field_end()?;
    o_prot.write_field_begin(&TFieldIdentifier::new("row", TType::String, 2))?;
    o_prot.write_bytes(&self.row)?;
    o_prot.write_field_end()?;
    o_prot.write_field_begin(&TFieldIdentifier::new("timestamp", TType::I64, 3))?;
    o_prot.write_i64(self.timestamp)?;
    o_prot.write_field_end()?;
    o_prot.write_field_begin(&TFieldIdentifier::new("attributes", TType::Map, 4))?;
    o_prot.write_map_begin(&TMapIdentifier::new(TType::String, TType::String, self.attributes.len() as i32))?;
    for (k, v) in &self.attributes {
      o_prot.write_bytes(k)?;
      o_prot.write_bytes(v)?;
    }
    o_prot.write_map_end()?;
    o_prot.write_field_end()?;
    o_prot.write_field_stop()?;
    o_prot.write_struct_end()
  }
}

//
// HbaseDeleteAllRowTsResult
//

#[derive(Clone, Debug, Eq, Hash, Ord, PartialEq, PartialOrd)]
struct HbaseDeleteAllRowTsResult {
  io: Option<IOError>,
}

impl HbaseDeleteAllRowTsResult {
  fn read_from_in_protocol(i_prot: &mut dyn TInputProtocol) -> thrift::Result<HbaseDeleteAllRowTsResult> {
    i_prot.read_struct_begin()?;
    let mut f_1: Option<IOError> = None;
    loop {
      let field_ident = i_prot.read_field_begin()?;
      if field_ident.field_type == TType::Stop {
        break;
      }
      let field_id = field_id(&field_ident)?;
      match field_id {
        1 => {
          let val = IOError::read_from_in_protocol(i_prot)?;
          f_1 = Some(val);
        },
        _ => {
          i_prot.skip(field_ident.field_type)?;
        },
      };
      i_prot.read_field_end()?;
    }
    i_prot.read_struct_end()?;
    let ret = HbaseDeleteAllRowTsResult {
      io: f_1,
    };
    Ok(ret)
  }
  fn write_to_out_protocol(&self, o_prot: &mut dyn TOutputProtocol) -> thrift::Result<()> {
    let struct_ident = TStructIdentifier::new("HbaseDeleteAllRowTsResult");
    o_prot.write_struct_begin(&struct_ident)?;
    if let Some(ref fld_var) = self.io {
      o_prot.write_field_begin(&TFieldIdentifier::new("io", TType::Struct, 1))?;
      fld_var.write_to_out_protocol(o_prot)?;
      o_prot.write_field_end()?
    }
    o_prot.write_field_stop()?;
    o_prot.write_struct_end()
  }
  fn ok_or(self) -> thrift::Result<()> {
    if self.io.is_some() {
      Err(thrift::Error::User(Box::new(self.io.unwrap())))
    } else {
      Ok(())
    }
  }
}

//
// HbaseScannerOpenWithScanArgs
//

#[derive(Clone, Debug, Eq, Hash, Ord, PartialEq, PartialOrd)]
struct HbaseScannerOpenWithScanArgs {
  /// name of table
  table_name: Text,
  /// Scan instance
  scan: TScan,
  /// Scan attributes
  attributes: BTreeMap<Text, Text>,
}

impl HbaseScannerOpenWithScanArgs {
  fn read_from_in_protocol(i_prot: &mut dyn TInputProtocol) -> thrift::Result<HbaseScannerOpenWithScanArgs> {
    i_prot.read_struct_begin()?;
    let mut f_1: Option<Text> = None;
    let mut f_2: Option<TScan> = None;
    let mut f_3: Option<BTreeMap<Text, Text>> = None;
    loop {
      let field_ident = i_prot.read_field_begin()?;
      if field_ident.field_type == TType::Stop {
        break;
      }
      let field_id = field_id(&field_ident)?;
      match field_id {
        1 => {
          let val = i_prot.read_bytes()?;
          f_1 = Some(val);
        },
        2 => {
          let val = TScan::read_from_in_protocol(i_prot)?;
          f_2 = Some(val);
        },
        3 => {
          let map_ident = i_prot.read_map_begin()?;
          let mut val: BTreeMap<Text, Text> = BTreeMap::new();
          for _ in 0..map_ident.size {
            let map_key_76 = i_prot.read_bytes()?;
            let map_val_77 = i_prot.read_bytes()?;
            val.insert(map_key_76, map_val_77);
          }
          i_prot.read_map_end()?;
          f_3 = Some(val);
        },
        _ => {
          i_prot.skip(field_ident.field_type)?;
        },
      };
      i_prot.read_field_end()?;
    }
    i_prot.read_struct_end()?;
    verify_required_field_exists("HbaseScannerOpenWithScanArgs.table_name", &f_1)?;
    verify_required_field_exists("HbaseScannerOpenWithScanArgs.scan", &f_2)?;
    verify_required_field_exists("HbaseScannerOpenWithScanArgs.attributes", &f_3)?;
    let ret = HbaseScannerOpenWithScanArgs {
      table_name: f_1.expect("auto-generated code should have checked for presence of required fields"),
      scan: f_2.expect("auto-generated code should have checked for presence of required fields"),
      attributes: f_3.expect("auto-generated code should have checked for presence of required fields"),
    };
    Ok(ret)
  }
  fn write_to_out_protocol(&self, o_prot: &mut dyn TOutputProtocol) -> thrift::Result<()> {
    let struct_ident = TStructIdentifier::new("scannerOpenWithScan_args");
    o_prot.write_struct_begin(&struct_ident)?;
    o_prot.write_field_begin(&TFieldIdentifier::new("tableName", TType::String, 1))?;
    o_prot.write_bytes(&self.table_name)?;
    o_prot.write_field_end()?;
    o_prot.write_field_begin(&TFieldIdentifier::new("scan", TType::Struct, 2))?;
    self.scan.write_to_out_protocol(o_prot)?;
    o_prot.write_field_end()?;
    o_prot.write_field_begin(&TFieldIdentifier::new("attributes", TType::Map, 3))?;
    o_prot.write_map_begin(&TMapIdentifier::new(TType::String, TType::String, self.attributes.len() as i32))?;
    for (k, v) in &self.attributes {
      o_prot.write_bytes(k)?;
      o_prot.write_bytes(v)?;
    }
    o_prot.write_map_end()?;
    o_prot.write_field_end()?;
    o_prot.write_field_stop()?;
    o_prot.write_struct_end()
  }
}

//
// HbaseScannerOpenWithScanResult
//

#[derive(Clone, Debug, Eq, Hash, Ord, PartialEq, PartialOrd)]
struct HbaseScannerOpenWithScanResult {
  result_value: Option<ScannerID>,
  io: Option<IOError>,
}

impl HbaseScannerOpenWithScanResult {
  fn read_from_in_protocol(i_prot: &mut dyn TInputProtocol) -> thrift::Result<HbaseScannerOpenWithScanResult> {
    i_prot.read_struct_begin()?;
    let mut f_0: Option<ScannerID> = None;
    let mut f_1: Option<IOError> = None;
    loop {
      let field_ident = i_prot.read_field_begin()?;
      if field_ident.field_type == TType::Stop {
        break;
      }
      let field_id = field_id(&field_ident)?;
      match field_id {
        0 => {
          let val = i_prot.read_i32()?;
          f_0 = Some(val);
        },
        1 => {
          let val = IOError::read_from_in_protocol(i_prot)?;
          f_1 = Some(val);
        },
        _ => {
          i_prot.skip(field_ident.field_type)?;
        },
      };
      i_prot.read_field_end()?;
    }
    i_prot.read_struct_end()?;
    let ret = HbaseScannerOpenWithScanResult {
      result_value: f_0,
      io: f_1,
    };
    Ok(ret)
  }
  fn write_to_out_protocol(&self, o_prot: &mut dyn TOutputProtocol) -> thrift::Result<()> {
    let struct_ident = TStructIdentifier::new("HbaseScannerOpenWithScanResult");
    o_prot.write_struct_begin(&struct_ident)?;
    if let Some(fld_var) = self.result_value {
      o_prot.write_field_begin(&TFieldIdentifier::new("result_value", TType::I32, 0))?;
      o_prot.write_i32(fld_var)?;
      o_prot.write_field_end()?
    }
    if let Some(ref fld_var) = self.io {
      o_prot.write_field_begin(&TFieldIdentifier::new("io", TType::Struct, 1))?;
      fld_var.write_to_out_protocol(o_prot)?;
      o_prot.write_field_end()?
    }
    o_prot.write_field_stop()?;
    o_prot.write_struct_end()
  }
  fn ok_or(self) -> thrift::Result<ScannerID> {
    if self.io.is_some() {
      Err(thrift::Error::User(Box::new(self.io.unwrap())))
    } else if self.result_value.is_some() {
      Ok(self.result_value.unwrap())
    } else {
      Err(
        thrift::Error::Application(
          ApplicationError::new(
            ApplicationErrorKind::MissingResult,
            "no result received for HbaseScannerOpenWithScan"
          )
        )
      )
    }
  }
}

//
// HbaseScannerOpenArgs
//

#[derive(Clone, Debug, Eq, Hash, Ord, PartialEq, PartialOrd)]
struct HbaseScannerOpenArgs {
  /// name of table
  table_name: Text,
  /// Starting row in table to scan.
  /// Send "" (empty string) to start at the first row.
  start_row: Text,
  /// columns to scan. If column name is a column family, all
  /// columns of the specified column family are returned. It's also possible
  /// to pass a regex in the column qualifier.
  columns: Vec<Text>,
  /// Scan attributes
  attributes: BTreeMap<Text, Text>,
}

impl HbaseScannerOpenArgs {
  fn read_from_in_protocol(i_prot: &mut dyn TInputProtocol) -> thrift::Result<HbaseScannerOpenArgs> {
    i_prot.read_struct_begin()?;
    let mut f_1: Option<Text> = None;
    let mut f_2: Option<Text> = None;
    let mut f_3: Option<Vec<Text>> = None;
    let mut f_4: Option<BTreeMap<Text, Text>> = None;
    loop {
      let field_ident = i_prot.read_field_begin()?;
      if field_ident.field_type == TType::Stop {
        break;
      }
      let field_id = field_id(&field_ident)?;
      match field_id {
        1 => {
          let val = i_prot.read_bytes()?;
          f_1 = Some(val);
        },
        2 => {
          let val = i_prot.read_bytes()?;
          f_2 = Some(val);
        },
        3 => {
          let list_ident = i_prot.read_list_begin()?;
          let mut val: Vec<Text> = Vec::with_capacity(list_ident.size as usize);
          for _ in 0..list_ident.size {
            let list_elem_78 = i_prot.read_bytes()?;
            val.push(list_elem_78);
          }
          i_prot.read_list_end()?;
          f_3 = Some(val);
        },
        4 => {
          let map_ident = i_prot.read_map_begin()?;
          let mut val: BTreeMap<Text, Text> = BTreeMap::new();
          for _ in 0..map_ident.size {
            let map_key_79 = i_prot.read_bytes()?;
            let map_val_80 = i_prot.read_bytes()?;
            val.insert(map_key_79, map_val_80);
          }
          i_prot.read_map_end()?;
          f_4 = Some(val);
        },
        _ => {
          i_prot.skip(field_ident.field_type)?;
        },
      };
      i_prot.read_field_end()?;
    }
    i_prot.read_struct_end()?;
    verify_required_field_exists("HbaseScannerOpenArgs.table_name", &f_1)?;
    verify_required_field_exists("HbaseScannerOpenArgs.start_row", &f_2)?;
    verify_required_field_exists("HbaseScannerOpenArgs.columns", &f_3)?;
    verify_required_field_exists("HbaseScannerOpenArgs.attributes", &f_4)?;
    let ret = HbaseScannerOpenArgs {
      table_name: f_1.expect("auto-generated code should have checked for presence of required fields"),
      start_row: f_2.expect("auto-generated code should have checked for presence of required fields"),
      columns: f_3.expect("auto-generated code should have checked for presence of required fields"),
      attributes: f_4.expect("auto-generated code should have checked for presence of required fields"),
    };
    Ok(ret)
  }
  fn write_to_out_protocol(&self, o_prot: &mut dyn TOutputProtocol) -> thrift::Result<()> {
    let struct_ident = TStructIdentifier::new("scannerOpen_args");
    o_prot.write_struct_begin(&struct_ident)?;
    o_prot.write_field_begin(&TFieldIdentifier::new("tableName", TType::String, 1))?;
    o_prot.write_bytes(&self.table_name)?;
    o_prot.write_field_end()?;
    o_prot.write_field_begin(&TFieldIdentifier::new("startRow", TType::String, 2))?;
    o_prot.write_bytes(&self.start_row)?;
    o_prot.write_field_end()?;
    o_prot.write_field_begin(&TFieldIdentifier::new("columns", TType::List, 3))?;
    o_prot.write_list_begin(&TListIdentifier::new(TType::String, self.columns.len() as i32))?;
    for e in &self.columns {
      o_prot.write_bytes(e)?;
    }
    o_prot.write_list_end()?;
    o_prot.write_field_end()?;
    o_prot.write_field_begin(&TFieldIdentifier::new("attributes", TType::Map, 4))?;
    o_prot.write_map_begin(&TMapIdentifier::new(TType::String, TType::String, self.attributes.len() as i32))?;
    for (k, v) in &self.attributes {
      o_prot.write_bytes(k)?;
      o_prot.write_bytes(v)?;
    }
    o_prot.write_map_end()?;
    o_prot.write_field_end()?;
    o_prot.write_field_stop()?;
    o_prot.write_struct_end()
  }
}

//
// HbaseScannerOpenResult
//

#[derive(Clone, Debug, Eq, Hash, Ord, PartialEq, PartialOrd)]
struct HbaseScannerOpenResult {
  result_value: Option<ScannerID>,
  io: Option<IOError>,
}

impl HbaseScannerOpenResult {
  fn read_from_in_protocol(i_prot: &mut dyn TInputProtocol) -> thrift::Result<HbaseScannerOpenResult> {
    i_prot.read_struct_begin()?;
    let mut f_0: Option<ScannerID> = None;
    let mut f_1: Option<IOError> = None;
    loop {
      let field_ident = i_prot.read_field_begin()?;
      if field_ident.field_type == TType::Stop {
        break;
      }
      let field_id = field_id(&field_ident)?;
      match field_id {
        0 => {
          let val = i_prot.read_i32()?;
          f_0 = Some(val);
        },
        1 => {
          let val = IOError::read_from_in_protocol(i_prot)?;
          f_1 = Some(val);
        },
        _ => {
          i_prot.skip(field_ident.field_type)?;
        },
      };
      i_prot.read_field_end()?;
    }
    i_prot.read_struct_end()?;
    let ret = HbaseScannerOpenResult {
      result_value: f_0,
      io: f_1,
    };
    Ok(ret)
  }
  fn write_to_out_protocol(&self, o_prot: &mut dyn TOutputProtocol) -> thrift::Result<()> {
    let struct_ident = TStructIdentifier::new("HbaseScannerOpenResult");
    o_prot.write_struct_begin(&struct_ident)?;
    if let Some(fld_var) = self.result_value {
      o_prot.write_field_begin(&TFieldIdentifier::new("result_value", TType::I32, 0))?;
      o_prot.write_i32(fld_var)?;
      o_prot.write_field_end()?
    }
    if let Some(ref fld_var) = self.io {
      o_prot.write_field_begin(&TFieldIdentifier::new("io", TType::Struct, 1))?;
      fld_var.write_to_out_protocol(o_prot)?;
      o_prot.write_field_end()?
    }
    o_prot.write_field_stop()?;
    o_prot.write_struct_end()
  }
  fn ok_or(self) -> thrift::Result<ScannerID> {
    if self.io.is_some() {
      Err(thrift::Error::User(Box::new(self.io.unwrap())))
    } else if self.result_value.is_some() {
      Ok(self.result_value.unwrap())
    } else {
      Err(
        thrift::Error::Application(
          ApplicationError::new(
            ApplicationErrorKind::MissingResult,
            "no result received for HbaseScannerOpen"
          )
        )
      )
    }
  }
}

//
// HbaseScannerOpenWithStopArgs
//

#[derive(Clone, Debug, Eq, Hash, Ord, PartialEq, PartialOrd)]
struct HbaseScannerOpenWithStopArgs {
  /// name of table
  table_name: Text,
  /// Starting row in table to scan.
  /// Send "" (empty string) to start at the first row.
  start_row: Text,
  /// row to stop scanning on. This row is *not* included in the
  /// scanner's results
  stop_row: Text,
  /// columns to scan. If column name is a column family, all
  /// columns of the specified column family are returned. It's also possible
  /// to pass a regex in the column qualifier.
  columns: Vec<Text>,
  /// Scan attributes
  attributes: BTreeMap<Text, Text>,
}

impl HbaseScannerOpenWithStopArgs {
  fn read_from_in_protocol(i_prot: &mut dyn TInputProtocol) -> thrift::Result<HbaseScannerOpenWithStopArgs> {
    i_prot.read_struct_begin()?;
    let mut f_1: Option<Text> = None;
    let mut f_2: Option<Text> = None;
    let mut f_3: Option<Text> = None;
    let mut f_4: Option<Vec<Text>> = None;
    let mut f_5: Option<BTreeMap<Text, Text>> = None;
    loop {
      let field_ident = i_prot.read_field_begin()?;
      if field_ident.field_type == TType::Stop {
        break;
      }
      let field_id = field_id(&field_ident)?;
      match field_id {
        1 => {
          let val = i_prot.read_bytes()?;
          f_1 = Some(val);
        },
        2 => {
          let val = i_prot.read_bytes()?;
          f_2 = Some(val);
        },
        3 => {
          let val = i_prot.read_bytes()?;
          f_3 = Some(val);
        },
        4 => {
          let list_ident = i_prot.read_list_begin()?;
          let mut val: Vec<Text> = Vec::with_capacity(list_ident.size as usize);
          for _ in 0..list_ident.size {
            let list_elem_81 = i_prot.read_bytes()?;
            val.push(list_elem_81);
          }
          i_prot.read_list_end()?;
          f_4 = Some(val);
        },
        5 => {
          let map_ident = i_prot.read_map_begin()?;
          let mut val: BTreeMap<Text, Text> = BTreeMap::new();
          for _ in 0..map_ident.size {
            let map_key_82 = i_prot.read_bytes()?;
            let map_val_83 = i_prot.read_bytes()?;
            val.insert(map_key_82, map_val_83);
          }
          i_prot.read_map_end()?;
          f_5 = Some(val);
        },
        _ => {
          i_prot.skip(field_ident.field_type)?;
        },
      };
      i_prot.read_field_end()?;
    }
    i_prot.read_struct_end()?;
    verify_required_field_exists("HbaseScannerOpenWithStopArgs.table_name", &f_1)?;
    verify_required_field_exists("HbaseScannerOpenWithStopArgs.start_row", &f_2)?;
    verify_required_field_exists("HbaseScannerOpenWithStopArgs.stop_row", &f_3)?;
    verify_required_field_exists("HbaseScannerOpenWithStopArgs.columns", &f_4)?;
    verify_required_field_exists("HbaseScannerOpenWithStopArgs.attributes", &f_5)?;
    let ret = HbaseScannerOpenWithStopArgs {
      table_name: f_1.expect("auto-generated code should have checked for presence of required fields"),
      start_row: f_2.expect("auto-generated code should have checked for presence of required fields"),
      stop_row: f_3.expect("auto-generated code should have checked for presence of required fields"),
      columns: f_4.expect("auto-generated code should have checked for presence of required fields"),
      attributes: f_5.expect("auto-generated code should have checked for presence of required fields"),
    };
    Ok(ret)
  }
  fn write_to_out_protocol(&self, o_prot: &mut dyn TOutputProtocol) -> thrift::Result<()> {
    let struct_ident = TStructIdentifier::new("scannerOpenWithStop_args");
    o_prot.write_struct_begin(&struct_ident)?;
    o_prot.write_field_begin(&TFieldIdentifier::new("tableName", TType::String, 1))?;
    o_prot.write_bytes(&self.table_name)?;
    o_prot.write_field_end()?;
    o_prot.write_field_begin(&TFieldIdentifier::new("startRow", TType::String, 2))?;
    o_prot.write_bytes(&self.start_row)?;
    o_prot.write_field_end()?;
    o_prot.write_field_begin(&TFieldIdentifier::new("stopRow", TType::String, 3))?;
    o_prot.write_bytes(&self.stop_row)?;
    o_prot.write_field_end()?;
    o_prot.write_field_begin(&TFieldIdentifier::new("columns", TType::List, 4))?;
    o_prot.write_list_begin(&TListIdentifier::new(TType::String, self.columns.len() as i32))?;
    for e in &self.columns {
      o_prot.write_bytes(e)?;
    }
    o_prot.write_list_end()?;
    o_prot.write_field_end()?;
    o_prot.write_field_begin(&TFieldIdentifier::new("attributes", TType::Map, 5))?;
    o_prot.write_map_begin(&TMapIdentifier::new(TType::String, TType::String, self.attributes.len() as i32))?;
    for (k, v) in &self.attributes {
      o_prot.write_bytes(k)?;
      o_prot.write_bytes(v)?;
    }
    o_prot.write_map_end()?;
    o_prot.write_field_end()?;
    o_prot.write_field_stop()?;
    o_prot.write_struct_end()
  }
}

//
// HbaseScannerOpenWithStopResult
//

#[derive(Clone, Debug, Eq, Hash, Ord, PartialEq, PartialOrd)]
struct HbaseScannerOpenWithStopResult {
  result_value: Option<ScannerID>,
  io: Option<IOError>,
}

impl HbaseScannerOpenWithStopResult {
  fn read_from_in_protocol(i_prot: &mut dyn TInputProtocol) -> thrift::Result<HbaseScannerOpenWithStopResult> {
    i_prot.read_struct_begin()?;
    let mut f_0: Option<ScannerID> = None;
    let mut f_1: Option<IOError> = None;
    loop {
      let field_ident = i_prot.read_field_begin()?;
      if field_ident.field_type == TType::Stop {
        break;
      }
      let field_id = field_id(&field_ident)?;
      match field_id {
        0 => {
          let val = i_prot.read_i32()?;
          f_0 = Some(val);
        },
        1 => {
          let val = IOError::read_from_in_protocol(i_prot)?;
          f_1 = Some(val);
        },
        _ => {
          i_prot.skip(field_ident.field_type)?;
        },
      };
      i_prot.read_field_end()?;
    }
    i_prot.read_struct_end()?;
    let ret = HbaseScannerOpenWithStopResult {
      result_value: f_0,
      io: f_1,
    };
    Ok(ret)
  }
  fn write_to_out_protocol(&self, o_prot: &mut dyn TOutputProtocol) -> thrift::Result<()> {
    let struct_ident = TStructIdentifier::new("HbaseScannerOpenWithStopResult");
    o_prot.write_struct_begin(&struct_ident)?;
    if let Some(fld_var) = self.result_value {
      o_prot.write_field_begin(&TFieldIdentifier::new("result_value", TType::I32, 0))?;
      o_prot.write_i32(fld_var)?;
      o_prot.write_field_end()?
    }
    if let Some(ref fld_var) = self.io {
      o_prot.write_field_begin(&TFieldIdentifier::new("io", TType::Struct, 1))?;
      fld_var.write_to_out_protocol(o_prot)?;
      o_prot.write_field_end()?
    }
    o_prot.write_field_stop()?;
    o_prot.write_struct_end()
  }
  fn ok_or(self) -> thrift::Result<ScannerID> {
    if self.io.is_some() {
      Err(thrift::Error::User(Box::new(self.io.unwrap())))
    } else if self.result_value.is_some() {
      Ok(self.result_value.unwrap())
    } else {
      Err(
        thrift::Error::Application(
          ApplicationError::new(
            ApplicationErrorKind::MissingResult,
            "no result received for HbaseScannerOpenWithStop"
          )
        )
      )
    }
  }
}

//
// HbaseScannerOpenWithPrefixArgs
//

#[derive(Clone, Debug, Eq, Hash, Ord, PartialEq, PartialOrd)]
struct HbaseScannerOpenWithPrefixArgs {
  /// name of table
  table_name: Text,
  /// the prefix (and thus start row) of the keys you want
  start_and_prefix: Text,
  /// the columns you want returned
  columns: Vec<Text>,
  /// Scan attributes
  attributes: BTreeMap<Text, Text>,
}

impl HbaseScannerOpenWithPrefixArgs {
  fn read_from_in_protocol(i_prot: &mut dyn TInputProtocol) -> thrift::Result<HbaseScannerOpenWithPrefixArgs> {
    i_prot.read_struct_begin()?;
    let mut f_1: Option<Text> = None;
    let mut f_2: Option<Text> = None;
    let mut f_3: Option<Vec<Text>> = None;
    let mut f_4: Option<BTreeMap<Text, Text>> = None;
    loop {
      let field_ident = i_prot.read_field_begin()?;
      if field_ident.field_type == TType::Stop {
        break;
      }
      let field_id = field_id(&field_ident)?;
      match field_id {
        1 => {
          let val = i_prot.read_bytes()?;
          f_1 = Some(val);
        },
        2 => {
          let val = i_prot.read_bytes()?;
          f_2 = Some(val);
        },
        3 => {
          let list_ident = i_prot.read_list_begin()?;
          let mut val: Vec<Text> = Vec::with_capacity(list_ident.size as usize);
          for _ in 0..list_ident.size {
            let list_elem_84 = i_prot.read_bytes()?;
            val.push(list_elem_84);
          }
          i_prot.read_list_end()?;
          f_3 = Some(val);
        },
        4 => {
          let map_ident = i_prot.read_map_begin()?;
          let mut val: BTreeMap<Text, Text> = BTreeMap::new();
          for _ in 0..map_ident.size {
            let map_key_85 = i_prot.read_bytes()?;
            let map_val_86 = i_prot.read_bytes()?;
            val.insert(map_key_85, map_val_86);
          }
          i_prot.read_map_end()?;
          f_4 = Some(val);
        },
        _ => {
          i_prot.skip(field_ident.field_type)?;
        },
      };
      i_prot.read_field_end()?;
    }
    i_prot.read_struct_end()?;
    verify_required_field_exists("HbaseScannerOpenWithPrefixArgs.table_name", &f_1)?;
    verify_required_field_exists("HbaseScannerOpenWithPrefixArgs.start_and_prefix", &f_2)?;
    verify_required_field_exists("HbaseScannerOpenWithPrefixArgs.columns", &f_3)?;
    verify_required_field_exists("HbaseScannerOpenWithPrefixArgs.attributes", &f_4)?;
    let ret = HbaseScannerOpenWithPrefixArgs {
      table_name: f_1.expect("auto-generated code should have checked for presence of required fields"),
      start_and_prefix: f_2.expect("auto-generated code should have checked for presence of required fields"),
      columns: f_3.expect("auto-generated code should have checked for presence of required fields"),
      attributes: f_4.expect("auto-generated code should have checked for presence of required fields"),
    };
    Ok(ret)
  }
  fn write_to_out_protocol(&self, o_prot: &mut dyn TOutputProtocol) -> thrift::Result<()> {
    let struct_ident = TStructIdentifier::new("scannerOpenWithPrefix_args");
    o_prot.write_struct_begin(&struct_ident)?;
    o_prot.write_field_begin(&TFieldIdentifier::new("tableName", TType::String, 1))?;
    o_prot.write_bytes(&self.table_name)?;
    o_prot.write_field_end()?;
    o_prot.write_field_begin(&TFieldIdentifier::new("startAndPrefix", TType::String, 2))?;
    o_prot.write_bytes(&self.start_and_prefix)?;
    o_prot.write_field_end()?;
    o_prot.write_field_begin(&TFieldIdentifier::new("columns", TType::List, 3))?;
    o_prot.write_list_begin(&TListIdentifier::new(TType::String, self.columns.len() as i32))?;
    for e in &self.columns {
      o_prot.write_bytes(e)?;
    }
    o_prot.write_list_end()?;
    o_prot.write_field_end()?;
    o_prot.write_field_begin(&TFieldIdentifier::new("attributes", TType::Map, 4))?;
    o_prot.write_map_begin(&TMapIdentifier::new(TType::String, TType::String, self.attributes.len() as i32))?;
    for (k, v) in &self.attributes {
      o_prot.write_bytes(k)?;
      o_prot.write_bytes(v)?;
    }
    o_prot.write_map_end()?;
    o_prot.write_field_end()?;
    o_prot.write_field_stop()?;
    o_prot.write_struct_end()
  }
}

//
// HbaseScannerOpenWithPrefixResult
//

#[derive(Clone, Debug, Eq, Hash, Ord, PartialEq, PartialOrd)]
struct HbaseScannerOpenWithPrefixResult {
  result_value: Option<ScannerID>,
  io: Option<IOError>,
}

impl HbaseScannerOpenWithPrefixResult {
  fn read_from_in_protocol(i_prot: &mut dyn TInputProtocol) -> thrift::Result<HbaseScannerOpenWithPrefixResult> {
    i_prot.read_struct_begin()?;
    let mut f_0: Option<ScannerID> = None;
    let mut f_1: Option<IOError> = None;
    loop {
      let field_ident = i_prot.read_field_begin()?;
      if field_ident.field_type == TType::Stop {
        break;
      }
      let field_id = field_id(&field_ident)?;
      match field_id {
        0 => {
          let val = i_prot.read_i32()?;
          f_0 = Some(val);
        },
        1 => {
          let val = IOError::read_from_in_protocol(i_prot)?;
          f_1 = Some(val);
        },
        _ => {
          i_prot.skip(field_ident.field_type)?;
        },
      };
      i_prot.read_field_end()?;
    }
    i_prot.read_struct_end()?;
    let ret = HbaseScannerOpenWithPrefixResult {
      result_value: f_0,
      io: f_1,
    };
    Ok(ret)
  }
  fn write_to_out_protocol(&self, o_prot: &mut dyn TOutputProtocol) -> thrift::Result<()> {
    let struct_ident = TStructIdentifier::new("HbaseScannerOpenWithPrefixResult");
    o_prot.write_struct_begin(&struct_ident)?;
    if let Some(fld_var) = self.result_value {
      o_prot.write_field_begin(&TFieldIdentifier::new("result_value", TType::I32, 0))?;
      o_prot.write_i32(fld_var)?;
      o_prot.write_field_end()?
    }
    if let Some(ref fld_var) = self.io {
      o_prot.write_field_begin(&TFieldIdentifier::new("io", TType::Struct, 1))?;
      fld_var.write_to_out_protocol(o_prot)?;
      o_prot.write_field_end()?
    }
    o_prot.write_field_stop()?;
    o_prot.write_struct_end()
  }
  fn ok_or(self) -> thrift::Result<ScannerID> {
    if self.io.is_some() {
      Err(thrift::Error::User(Box::new(self.io.unwrap())))
    } else if self.result_value.is_some() {
      Ok(self.result_value.unwrap())
    } else {
      Err(
        thrift::Error::Application(
          ApplicationError::new(
            ApplicationErrorKind::MissingResult,
            "no result received for HbaseScannerOpenWithPrefix"
          )
        )
      )
    }
  }
}

//
// HbaseScannerOpenTsArgs
//

#[derive(Clone, Debug, Eq, Hash, Ord, PartialEq, PartialOrd)]
struct HbaseScannerOpenTsArgs {
  /// name of table
  table_name: Text,
  /// Starting row in table to scan.
  /// Send "" (empty string) to start at the first row.
  start_row: Text,
  /// columns to scan. If column name is a column family, all
  /// columns of the specified column family are returned. It's also possible
  /// to pass a regex in the column qualifier.
  columns: Vec<Text>,
  /// timestamp
  timestamp: i64,
  /// Scan attributes
  attributes: BTreeMap<Text, Text>,
}

impl HbaseScannerOpenTsArgs {
  fn read_from_in_protocol(i_prot: &mut dyn TInputProtocol) -> thrift::Result<HbaseScannerOpenTsArgs> {
    i_prot.read_struct_begin()?;
    let mut f_1: Option<Text> = None;
    let mut f_2: Option<Text> = None;
    let mut f_3: Option<Vec<Text>> = None;
    let mut f_4: Option<i64> = None;
    let mut f_5: Option<BTreeMap<Text, Text>> = None;
    loop {
      let field_ident = i_prot.read_field_begin()?;
      if field_ident.field_type == TType::Stop {
        break;
      }
      let field_id = field_id(&field_ident)?;
      match field_id {
        1 => {
          let val = i_prot.read_bytes()?;
          f_1 = Some(val);
        },
        2 => {
          let val = i_prot.read_bytes()?;
          f_2 = Some(val);
        },
        3 => {
          let list_ident = i_prot.read_list_begin()?;
          let mut val: Vec<Text> = Vec::with_capacity(list_ident.size as usize);
          for _ in 0..list_ident.size {
            let list_elem_87 = i_prot.read_bytes()?;
            val.push(list_elem_87);
          }
          i_prot.read_list_end()?;
          f_3 = Some(val);
        },
        4 => {
          let val = i_prot.read_i64()?;
          f_4 = Some(val);
        },
        5 => {
          let map_ident = i_prot.read_map_begin()?;
          let mut val: BTreeMap<Text, Text> = BTreeMap::new();
          for _ in 0..map_ident.size {
            let map_key_88 = i_prot.read_bytes()?;
            let map_val_89 = i_prot.read_bytes()?;
            val.insert(map_key_88, map_val_89);
          }
          i_prot.read_map_end()?;
          f_5 = Some(val);
        },
        _ => {
          i_prot.skip(field_ident.field_type)?;
        },
      };
      i_prot.read_field_end()?;
    }
    i_prot.read_struct_end()?;
    verify_required_field_exists("HbaseScannerOpenTsArgs.table_name", &f_1)?;
    verify_required_field_exists("HbaseScannerOpenTsArgs.start_row", &f_2)?;
    verify_required_field_exists("HbaseScannerOpenTsArgs.columns", &f_3)?;
    verify_required_field_exists("HbaseScannerOpenTsArgs.timestamp", &f_4)?;
    verify_required_field_exists("HbaseScannerOpenTsArgs.attributes", &f_5)?;
    let ret = HbaseScannerOpenTsArgs {
      table_name: f_1.expect("auto-generated code should have checked for presence of required fields"),
      start_row: f_2.expect("auto-generated code should have checked for presence of required fields"),
      columns: f_3.expect("auto-generated code should have checked for presence of required fields"),
      timestamp: f_4.expect("auto-generated code should have checked for presence of required fields"),
      attributes: f_5.expect("auto-generated code should have checked for presence of required fields"),
    };
    Ok(ret)
  }
  fn write_to_out_protocol(&self, o_prot: &mut dyn TOutputProtocol) -> thrift::Result<()> {
    let struct_ident = TStructIdentifier::new("scannerOpenTs_args");
    o_prot.write_struct_begin(&struct_ident)?;
    o_prot.write_field_begin(&TFieldIdentifier::new("tableName", TType::String, 1))?;
    o_prot.write_bytes(&self.table_name)?;
    o_prot.write_field_end()?;
    o_prot.write_field_begin(&TFieldIdentifier::new("startRow", TType::String, 2))?;
    o_prot.write_bytes(&self.start_row)?;
    o_prot.write_field_end()?;
    o_prot.write_field_begin(&TFieldIdentifier::new("columns", TType::List, 3))?;
    o_prot.write_list_begin(&TListIdentifier::new(TType::String, self.columns.len() as i32))?;
    for e in &self.columns {
      o_prot.write_bytes(e)?;
    }
    o_prot.write_list_end()?;
    o_prot.write_field_end()?;
    o_prot.write_field_begin(&TFieldIdentifier::new("timestamp", TType::I64, 4))?;
    o_prot.write_i64(self.timestamp)?;
    o_prot.write_field_end()?;
    o_prot.write_field_begin(&TFieldIdentifier::new("attributes", TType::Map, 5))?;
    o_prot.write_map_begin(&TMapIdentifier::new(TType::String, TType::String, self.attributes.len() as i32))?;
    for (k, v) in &self.attributes {
      o_prot.write_bytes(k)?;
      o_prot.write_bytes(v)?;
    }
    o_prot.write_map_end()?;
    o_prot.write_field_end()?;
    o_prot.write_field_stop()?;
    o_prot.write_struct_end()
  }
}

//
// HbaseScannerOpenTsResult
//

#[derive(Clone, Debug, Eq, Hash, Ord, PartialEq, PartialOrd)]
struct HbaseScannerOpenTsResult {
  result_value: Option<ScannerID>,
  io: Option<IOError>,
}

impl HbaseScannerOpenTsResult {
  fn read_from_in_protocol(i_prot: &mut dyn TInputProtocol) -> thrift::Result<HbaseScannerOpenTsResult> {
    i_prot.read_struct_begin()?;
    let mut f_0: Option<ScannerID> = None;
    let mut f_1: Option<IOError> = None;
    loop {
      let field_ident = i_prot.read_field_begin()?;
      if field_ident.field_type == TType::Stop {
        break;
      }
      let field_id = field_id(&field_ident)?;
      match field_id {
        0 => {
          let val = i_prot.read_i32()?;
          f_0 = Some(val);
        },
        1 => {
          let val = IOError::read_from_in_protocol(i_prot)?;
          f_1 = Some(val);
        },
        _ => {
          i_prot.skip(field_ident.field_type)?;
        },
      };
      i_prot.read_field_end()?;
    }
    i_prot.read_struct_end()?;
    let ret = HbaseScannerOpenTsResult {
      result_value: f_0,
      io: f_1,
    };
    Ok(ret)
  }
  fn write_to_out_protocol(&self, o_prot: &mut dyn TOutputProtocol) -> thrift::Result<()> {
    let struct_ident = TStructIdentifier::new("HbaseScannerOpenTsResult");
    o_prot.write_struct_begin(&struct_ident)?;
    if let Some(fld_var) = self.result_value {
      o_prot.write_field_begin(&TFieldIdentifier::new("result_value", TType::I32, 0))?;
      o_prot.write_i32(fld_var)?;
      o_prot.write_field_end()?
    }
    if let Some(ref fld_var) = self.io {
      o_prot.write_field_begin(&TFieldIdentifier::new("io", TType::Struct, 1))?;
      fld_var.write_to_out_protocol(o_prot)?;
      o_prot.write_field_end()?
    }
    o_prot.write_field_stop()?;
    o_prot.write_struct_end()
  }
  fn ok_or(self) -> thrift::Result<ScannerID> {
    if self.io.is_some() {
      Err(thrift::Error::User(Box::new(self.io.unwrap())))
    } else if self.result_value.is_some() {
      Ok(self.result_value.unwrap())
    } else {
      Err(
        thrift::Error::Application(
          ApplicationError::new(
            ApplicationErrorKind::MissingResult,
            "no result received for HbaseScannerOpenTs"
          )
        )
      )
    }
  }
}

//
// HbaseScannerOpenWithStopTsArgs
//

#[derive(Clone, Debug, Eq, Hash, Ord, PartialEq, PartialOrd)]
struct HbaseScannerOpenWithStopTsArgs {
  /// name of table
  table_name: Text,
  /// Starting row in table to scan.
  /// Send "" (empty string) to start at the first row.
  start_row: Text,
  /// row to stop scanning on. This row is *not* included in the
  /// scanner's results
  stop_row: Text,
  /// columns to scan. If column name is a column family, all
  /// columns of the specified column family are returned. It's also possible
  /// to pass a regex in the column qualifier.
  columns: Vec<Text>,
  /// timestamp
  timestamp: i64,
  /// Scan attributes
  attributes: BTreeMap<Text, Text>,
}

impl HbaseScannerOpenWithStopTsArgs {
  fn read_from_in_protocol(i_prot: &mut dyn TInputProtocol) -> thrift::Result<HbaseScannerOpenWithStopTsArgs> {
    i_prot.read_struct_begin()?;
    let mut f_1: Option<Text> = None;
    let mut f_2: Option<Text> = None;
    let mut f_3: Option<Text> = None;
    let mut f_4: Option<Vec<Text>> = None;
    let mut f_5: Option<i64> = None;
    let mut f_6: Option<BTreeMap<Text, Text>> = None;
    loop {
      let field_ident = i_prot.read_field_begin()?;
      if field_ident.field_type == TType::Stop {
        break;
      }
      let field_id = field_id(&field_ident)?;
      match field_id {
        1 => {
          let val = i_prot.read_bytes()?;
          f_1 = Some(val);
        },
        2 => {
          let val = i_prot.read_bytes()?;
          f_2 = Some(val);
        },
        3 => {
          let val = i_prot.read_bytes()?;
          f_3 = Some(val);
        },
        4 => {
          let list_ident = i_prot.read_list_begin()?;
          let mut val: Vec<Text> = Vec::with_capacity(list_ident.size as usize);
          for _ in 0..list_ident.size {
            let list_elem_90 = i_prot.read_bytes()?;
            val.push(list_elem_90);
          }
          i_prot.read_list_end()?;
          f_4 = Some(val);
        },
        5 => {
          let val = i_prot.read_i64()?;
          f_5 = Some(val);
        },
        6 => {
          let map_ident = i_prot.read_map_begin()?;
          let mut val: BTreeMap<Text, Text> = BTreeMap::new();
          for _ in 0..map_ident.size {
            let map_key_91 = i_prot.read_bytes()?;
            let map_val_92 = i_prot.read_bytes()?;
            val.insert(map_key_91, map_val_92);
          }
          i_prot.read_map_end()?;
          f_6 = Some(val);
        },
        _ => {
          i_prot.skip(field_ident.field_type)?;
        },
      };
      i_prot.read_field_end()?;
    }
    i_prot.read_struct_end()?;
    verify_required_field_exists("HbaseScannerOpenWithStopTsArgs.table_name", &f_1)?;
    verify_required_field_exists("HbaseScannerOpenWithStopTsArgs.start_row", &f_2)?;
    verify_required_field_exists("HbaseScannerOpenWithStopTsArgs.stop_row", &f_3)?;
    verify_required_field_exists("HbaseScannerOpenWithStopTsArgs.columns", &f_4)?;
    verify_required_field_exists("HbaseScannerOpenWithStopTsArgs.timestamp", &f_5)?;
    verify_required_field_exists("HbaseScannerOpenWithStopTsArgs.attributes", &f_6)?;
    let ret = HbaseScannerOpenWithStopTsArgs {
      table_name: f_1.expect("auto-generated code should have checked for presence of required fields"),
      start_row: f_2.expect("auto-generated code should have checked for presence of required fields"),
      stop_row: f_3.expect("auto-generated code should have checked for presence of required fields"),
      columns: f_4.expect("auto-generated code should have checked for presence of required fields"),
      timestamp: f_5.expect("auto-generated code should have checked for presence of required fields"),
      attributes: f_6.expect("auto-generated code should have checked for presence of required fields"),
    };
    Ok(ret)
  }
  fn write_to_out_protocol(&self, o_prot: &mut dyn TOutputProtocol) -> thrift::Result<()> {
    let struct_ident = TStructIdentifier::new("scannerOpenWithStopTs_args");
    o_prot.write_struct_begin(&struct_ident)?;
    o_prot.write_field_begin(&TFieldIdentifier::new("tableName", TType::String, 1))?;
    o_prot.write_bytes(&self.table_name)?;
    o_prot.write_field_end()?;
    o_prot.write_field_begin(&TFieldIdentifier::new("startRow", TType::String, 2))?;
    o_prot.write_bytes(&self.start_row)?;
    o_prot.write_field_end()?;
    o_prot.write_field_begin(&TFieldIdentifier::new("stopRow", TType::String, 3))?;
    o_prot.write_bytes(&self.stop_row)?;
    o_prot.write_field_end()?;
    o_prot.write_field_begin(&TFieldIdentifier::new("columns", TType::List, 4))?;
    o_prot.write_list_begin(&TListIdentifier::new(TType::String, self.columns.len() as i32))?;
    for e in &self.columns {
      o_prot.write_bytes(e)?;
    }
    o_prot.write_list_end()?;
    o_prot.write_field_end()?;
    o_prot.write_field_begin(&TFieldIdentifier::new("timestamp", TType::I64, 5))?;
    o_prot.write_i64(self.timestamp)?;
    o_prot.write_field_end()?;
    o_prot.write_field_begin(&TFieldIdentifier::new("attributes", TType::Map, 6))?;
    o_prot.write_map_begin(&TMapIdentifier::new(TType::String, TType::String, self.attributes.len() as i32))?;
    for (k, v) in &self.attributes {
      o_prot.write_bytes(k)?;
      o_prot.write_bytes(v)?;
    }
    o_prot.write_map_end()?;
    o_prot.write_field_end()?;
    o_prot.write_field_stop()?;
    o_prot.write_struct_end()
  }
}

//
// HbaseScannerOpenWithStopTsResult
//

#[derive(Clone, Debug, Eq, Hash, Ord, PartialEq, PartialOrd)]
struct HbaseScannerOpenWithStopTsResult {
  result_value: Option<ScannerID>,
  io: Option<IOError>,
}

impl HbaseScannerOpenWithStopTsResult {
  fn read_from_in_protocol(i_prot: &mut dyn TInputProtocol) -> thrift::Result<HbaseScannerOpenWithStopTsResult> {
    i_prot.read_struct_begin()?;
    let mut f_0: Option<ScannerID> = None;
    let mut f_1: Option<IOError> = None;
    loop {
      let field_ident = i_prot.read_field_begin()?;
      if field_ident.field_type == TType::Stop {
        break;
      }
      let field_id = field_id(&field_ident)?;
      match field_id {
        0 => {
          let val = i_prot.read_i32()?;
          f_0 = Some(val);
        },
        1 => {
          let val = IOError::read_from_in_protocol(i_prot)?;
          f_1 = Some(val);
        },
        _ => {
          i_prot.skip(field_ident.field_type)?;
        },
      };
      i_prot.read_field_end()?;
    }
    i_prot.read_struct_end()?;
    let ret = HbaseScannerOpenWithStopTsResult {
      result_value: f_0,
      io: f_1,
    };
    Ok(ret)
  }
  fn write_to_out_protocol(&self, o_prot: &mut dyn TOutputProtocol) -> thrift::Result<()> {
    let struct_ident = TStructIdentifier::new("HbaseScannerOpenWithStopTsResult");
    o_prot.write_struct_begin(&struct_ident)?;
    if let Some(fld_var) = self.result_value {
      o_prot.write_field_begin(&TFieldIdentifier::new("result_value", TType::I32, 0))?;
      o_prot.write_i32(fld_var)?;
      o_prot.write_field_end()?
    }
    if let Some(ref fld_var) = self.io {
      o_prot.write_field_begin(&TFieldIdentifier::new("io", TType::Struct, 1))?;
      fld_var.write_to_out_protocol(o_prot)?;
      o_prot.write_field_end()?
    }
    o_prot.write_field_stop()?;
    o_prot.write_struct_end()
  }
  fn ok_or(self) -> thrift::Result<ScannerID> {
    if self.io.is_some() {
      Err(thrift::Error::User(Box::new(self.io.unwrap())))
    } else if self.result_value.is_some() {
      Ok(self.result_value.unwrap())
    } else {
      Err(
        thrift::Error::Application(
          ApplicationError::new(
            ApplicationErrorKind::MissingResult,
            "no result received for HbaseScannerOpenWithStopTs"
          )
        )
      )
    }
  }
}

//
// HbaseScannerGetArgs
//

#[derive(Clone, Debug, Eq, Hash, Ord, PartialEq, PartialOrd)]
struct HbaseScannerGetArgs {
  /// id of a scanner returned by scannerOpen
  id: ScannerID,
}

impl HbaseScannerGetArgs {
  fn read_from_in_protocol(i_prot: &mut dyn TInputProtocol) -> thrift::Result<HbaseScannerGetArgs> {
    i_prot.read_struct_begin()?;
    let mut f_1: Option<ScannerID> = None;
    loop {
      let field_ident = i_prot.read_field_begin()?;
      if field_ident.field_type == TType::Stop {
        break;
      }
      let field_id = field_id(&field_ident)?;
      match field_id {
        1 => {
          let val = i_prot.read_i32()?;
          f_1 = Some(val);
        },
        _ => {
          i_prot.skip(field_ident.field_type)?;
        },
      };
      i_prot.read_field_end()?;
    }
    i_prot.read_struct_end()?;
    verify_required_field_exists("HbaseScannerGetArgs.id", &f_1)?;
    let ret = HbaseScannerGetArgs {
      id: f_1.expect("auto-generated code should have checked for presence of required fields"),
    };
    Ok(ret)
  }
  fn write_to_out_protocol(&self, o_prot: &mut dyn TOutputProtocol) -> thrift::Result<()> {
    let struct_ident = TStructIdentifier::new("scannerGet_args");
    o_prot.write_struct_begin(&struct_ident)?;
    o_prot.write_field_begin(&TFieldIdentifier::new("id", TType::I32, 1))?;
    o_prot.write_i32(self.id)?;
    o_prot.write_field_end()?;
    o_prot.write_field_stop()?;
    o_prot.write_struct_end()
  }
}

//
// HbaseScannerGetResult
//

#[derive(Clone, Debug, Eq, Hash, Ord, PartialEq, PartialOrd)]
struct HbaseScannerGetResult {
  result_value: Option<Vec<TRowResult>>,
  io: Option<IOError>,
  ia: Option<IllegalArgument>,
}

impl HbaseScannerGetResult {
  fn read_from_in_protocol(i_prot: &mut dyn TInputProtocol) -> thrift::Result<HbaseScannerGetResult> {
    i_prot.read_struct_begin()?;
    let mut f_0: Option<Vec<TRowResult>> = None;
    let mut f_1: Option<IOError> = None;
    let mut f_2: Option<IllegalArgument> = None;
    loop {
      let field_ident = i_prot.read_field_begin()?;
      if field_ident.field_type == TType::Stop {
        break;
      }
      let field_id = field_id(&field_ident)?;
      match field_id {
        0 => {
          let list_ident = i_prot.read_list_begin()?;
          let mut val: Vec<TRowResult> = Vec::with_capacity(list_ident.size as usize);
          for _ in 0..list_ident.size {
            let list_elem_93 = TRowResult::read_from_in_protocol(i_prot)?;
            val.push(list_elem_93);
          }
          i_prot.read_list_end()?;
          f_0 = Some(val);
        },
        1 => {
          let val = IOError::read_from_in_protocol(i_prot)?;
          f_1 = Some(val);
        },
        2 => {
          let val = IllegalArgument::read_from_in_protocol(i_prot)?;
          f_2 = Some(val);
        },
        _ => {
          i_prot.skip(field_ident.field_type)?;
        },
      };
      i_prot.read_field_end()?;
    }
    i_prot.read_struct_end()?;
    let ret = HbaseScannerGetResult {
      result_value: f_0,
      io: f_1,
      ia: f_2,
    };
    Ok(ret)
  }
  fn write_to_out_protocol(&self, o_prot: &mut dyn TOutputProtocol) -> thrift::Result<()> {
    let struct_ident = TStructIdentifier::new("HbaseScannerGetResult");
    o_prot.write_struct_begin(&struct_ident)?;
    if let Some(ref fld_var) = self.result_value {
      o_prot.write_field_begin(&TFieldIdentifier::new("result_value", TType::List, 0))?;
      o_prot.write_list_begin(&TListIdentifier::new(TType::Struct, fld_var.len() as i32))?;
      for e in fld_var {
        e.write_to_out_protocol(o_prot)?;
      }
      o_prot.write_list_end()?;
      o_prot.write_field_end()?
    }
    if let Some(ref fld_var) = self.io {
      o_prot.write_field_begin(&TFieldIdentifier::new("io", TType::Struct, 1))?;
      fld_var.write_to_out_protocol(o_prot)?;
      o_prot.write_field_end()?
    }
    if let Some(ref fld_var) = self.ia {
      o_prot.write_field_begin(&TFieldIdentifier::new("ia", TType::Struct, 2))?;
      fld_var.write_to_out_protocol(o_prot)?;
      o_prot.write_field_end()?
    }
    o_prot.write_field_stop()?;
    o_prot.write_struct_end()
  }
  fn ok_or(self) -> thrift::Result<Vec<TRowResult>> {
    if self.io.is_some() {
      Err(thrift::Error::User(Box::new(self.io.unwrap())))
    } else if self.ia.is_some() {
      Err(thrift::Error::User(Box::new(self.ia.unwrap())))
    } else if self.result_value.is_some() {
      Ok(self.result_value.unwrap())
    } else {
      Err(
        thrift::Error::Application(
          ApplicationError::new(
            ApplicationErrorKind::MissingResult,
            "no result received for HbaseScannerGet"
          )
        )
      )
    }
  }
}

//
// HbaseScannerGetListArgs
//

#[derive(Clone, Debug, Eq, Hash, Ord, PartialEq, PartialOrd)]
struct HbaseScannerGetListArgs {
  /// id of a scanner returned by scannerOpen
  id: ScannerID,
  /// number of results to return
  nb_rows: i32,
}

impl HbaseScannerGetListArgs {
  fn read_from_in_protocol(i_prot: &mut dyn TInputProtocol) -> thrift::Result<HbaseScannerGetListArgs> {
    i_prot.read_struct_begin()?;
    let mut f_1: Option<ScannerID> = None;
    let mut f_2: Option<i32> = None;
    loop {
      let field_ident = i_prot.read_field_begin()?;
      if field_ident.field_type == TType::Stop {
        break;
      }
      let field_id = field_id(&field_ident)?;
      match field_id {
        1 => {
          let val = i_prot.read_i32()?;
          f_1 = Some(val);
        },
        2 => {
          let val = i_prot.read_i32()?;
          f_2 = Some(val);
        },
        _ => {
          i_prot.skip(field_ident.field_type)?;
        },
      };
      i_prot.read_field_end()?;
    }
    i_prot.read_struct_end()?;
    verify_required_field_exists("HbaseScannerGetListArgs.id", &f_1)?;
    verify_required_field_exists("HbaseScannerGetListArgs.nb_rows", &f_2)?;
    let ret = HbaseScannerGetListArgs {
      id: f_1.expect("auto-generated code should have checked for presence of required fields"),
      nb_rows: f_2.expect("auto-generated code should have checked for presence of required fields"),
    };
    Ok(ret)
  }
  fn write_to_out_protocol(&self, o_prot: &mut dyn TOutputProtocol) -> thrift::Result<()> {
    let struct_ident = TStructIdentifier::new("scannerGetList_args");
    o_prot.write_struct_begin(&struct_ident)?;
    o_prot.write_field_begin(&TFieldIdentifier::new("id", TType::I32, 1))?;
    o_prot.write_i32(self.id)?;
    o_prot.write_field_end()?;
    o_prot.write_field_begin(&TFieldIdentifier::new("nbRows", TType::I32, 2))?;
    o_prot.write_i32(self.nb_rows)?;
    o_prot.write_field_end()?;
    o_prot.write_field_stop()?;
    o_prot.write_struct_end()
  }
}

//
// HbaseScannerGetListResult
//

#[derive(Clone, Debug, Eq, Hash, Ord, PartialEq, PartialOrd)]
struct HbaseScannerGetListResult {
  result_value: Option<Vec<TRowResult>>,
  io: Option<IOError>,
  ia: Option<IllegalArgument>,
}

impl HbaseScannerGetListResult {
  fn read_from_in_protocol(i_prot: &mut dyn TInputProtocol) -> thrift::Result<HbaseScannerGetListResult> {
    i_prot.read_struct_begin()?;
    let mut f_0: Option<Vec<TRowResult>> = None;
    let mut f_1: Option<IOError> = None;
    let mut f_2: Option<IllegalArgument> = None;
    loop {
      let field_ident = i_prot.read_field_begin()?;
      if field_ident.field_type == TType::Stop {
        break;
      }
      let field_id = field_id(&field_ident)?;
      match field_id {
        0 => {
          let list_ident = i_prot.read_list_begin()?;
          let mut val: Vec<TRowResult> = Vec::with_capacity(list_ident.size as usize);
          for _ in 0..list_ident.size {
            let list_elem_94 = TRowResult::read_from_in_protocol(i_prot)?;
            val.push(list_elem_94);
          }
          i_prot.read_list_end()?;
          f_0 = Some(val);
        },
        1 => {
          let val = IOError::read_from_in_protocol(i_prot)?;
          f_1 = Some(val);
        },
        2 => {
          let val = IllegalArgument::read_from_in_protocol(i_prot)?;
          f_2 = Some(val);
        },
        _ => {
          i_prot.skip(field_ident.field_type)?;
        },
      };
      i_prot.read_field_end()?;
    }
    i_prot.read_struct_end()?;
    let ret = HbaseScannerGetListResult {
      result_value: f_0,
      io: f_1,
      ia: f_2,
    };
    Ok(ret)
  }
  fn write_to_out_protocol(&self, o_prot: &mut dyn TOutputProtocol) -> thrift::Result<()> {
    let struct_ident = TStructIdentifier::new("HbaseScannerGetListResult");
    o_prot.write_struct_begin(&struct_ident)?;
    if let Some(ref fld_var) = self.result_value {
      o_prot.write_field_begin(&TFieldIdentifier::new("result_value", TType::List, 0))?;
      o_prot.write_list_begin(&TListIdentifier::new(TType::Struct, fld_var.len() as i32))?;
      for e in fld_var {
        e.write_to_out_protocol(o_prot)?;
      }
      o_prot.write_list_end()?;
      o_prot.write_field_end()?
    }
    if let Some(ref fld_var) = self.io {
      o_prot.write_field_begin(&TFieldIdentifier::new("io", TType::Struct, 1))?;
      fld_var.write_to_out_protocol(o_prot)?;
      o_prot.write_field_end()?
    }
    if let Some(ref fld_var) = self.ia {
      o_prot.write_field_begin(&TFieldIdentifier::new("ia", TType::Struct, 2))?;
      fld_var.write_to_out_protocol(o_prot)?;
      o_prot.write_field_end()?
    }
    o_prot.write_field_stop()?;
    o_prot.write_struct_end()
  }
  fn ok_or(self) -> thrift::Result<Vec<TRowResult>> {
    if self.io.is_some() {
      Err(thrift::Error::User(Box::new(self.io.unwrap())))
    } else if self.ia.is_some() {
      Err(thrift::Error::User(Box::new(self.ia.unwrap())))
    } else if self.result_value.is_some() {
      Ok(self.result_value.unwrap())
    } else {
      Err(
        thrift::Error::Application(
          ApplicationError::new(
            ApplicationErrorKind::MissingResult,
            "no result received for HbaseScannerGetList"
          )
        )
      )
    }
  }
}

//
// HbaseScannerCloseArgs
//

#[derive(Clone, Debug, Eq, Hash, Ord, PartialEq, PartialOrd)]
struct HbaseScannerCloseArgs {
  /// id of a scanner returned by scannerOpen
  id: ScannerID,
}

impl HbaseScannerCloseArgs {
  fn read_from_in_protocol(i_prot: &mut dyn TInputProtocol) -> thrift::Result<HbaseScannerCloseArgs> {
    i_prot.read_struct_begin()?;
    let mut f_1: Option<ScannerID> = None;
    loop {
      let field_ident = i_prot.read_field_begin()?;
      if field_ident.field_type == TType::Stop {
        break;
      }
      let field_id = field_id(&field_ident)?;
      match field_id {
        1 => {
          let val = i_prot.read_i32()?;
          f_1 = Some(val);
        },
        _ => {
          i_prot.skip(field_ident.field_type)?;
        },
      };
      i_prot.read_field_end()?;
    }
    i_prot.read_struct_end()?;
    verify_required_field_exists("HbaseScannerCloseArgs.id", &f_1)?;
    let ret = HbaseScannerCloseArgs {
      id: f_1.expect("auto-generated code should have checked for presence of required fields"),
    };
    Ok(ret)
  }
  fn write_to_out_protocol(&self, o_prot: &mut dyn TOutputProtocol) -> thrift::Result<()> {
    let struct_ident = TStructIdentifier::new("scannerClose_args");
    o_prot.write_struct_begin(&struct_ident)?;
    o_prot.write_field_begin(&TFieldIdentifier::new("id", TType::I32, 1))?;
    o_prot.write_i32(self.id)?;
    o_prot.write_field_end()?;
    o_prot.write_field_stop()?;
    o_prot.write_struct_end()
  }
}

//
// HbaseScannerCloseResult
//

#[derive(Clone, Debug, Eq, Hash, Ord, PartialEq, PartialOrd)]
struct HbaseScannerCloseResult {
  io: Option<IOError>,
  ia: Option<IllegalArgument>,
}

impl HbaseScannerCloseResult {
  fn read_from_in_protocol(i_prot: &mut dyn TInputProtocol) -> thrift::Result<HbaseScannerCloseResult> {
    i_prot.read_struct_begin()?;
    let mut f_1: Option<IOError> = None;
    let mut f_2: Option<IllegalArgument> = None;
    loop {
      let field_ident = i_prot.read_field_begin()?;
      if field_ident.field_type == TType::Stop {
        break;
      }
      let field_id = field_id(&field_ident)?;
      match field_id {
        1 => {
          let val = IOError::read_from_in_protocol(i_prot)?;
          f_1 = Some(val);
        },
        2 => {
          let val = IllegalArgument::read_from_in_protocol(i_prot)?;
          f_2 = Some(val);
        },
        _ => {
          i_prot.skip(field_ident.field_type)?;
        },
      };
      i_prot.read_field_end()?;
    }
    i_prot.read_struct_end()?;
    let ret = HbaseScannerCloseResult {
      io: f_1,
      ia: f_2,
    };
    Ok(ret)
  }
  fn write_to_out_protocol(&self, o_prot: &mut dyn TOutputProtocol) -> thrift::Result<()> {
    let struct_ident = TStructIdentifier::new("HbaseScannerCloseResult");
    o_prot.write_struct_begin(&struct_ident)?;
    if let Some(ref fld_var) = self.io {
      o_prot.write_field_begin(&TFieldIdentifier::new("io", TType::Struct, 1))?;
      fld_var.write_to_out_protocol(o_prot)?;
      o_prot.write_field_end()?
    }
    if let Some(ref fld_var) = self.ia {
      o_prot.write_field_begin(&TFieldIdentifier::new("ia", TType::Struct, 2))?;
      fld_var.write_to_out_protocol(o_prot)?;
      o_prot.write_field_end()?
    }
    o_prot.write_field_stop()?;
    o_prot.write_struct_end()
  }
  fn ok_or(self) -> thrift::Result<()> {
    if self.io.is_some() {
      Err(thrift::Error::User(Box::new(self.io.unwrap())))
    } else if self.ia.is_some() {
      Err(thrift::Error::User(Box::new(self.ia.unwrap())))
    } else {
      Ok(())
    }
  }
}

//
// HbaseGetRegionInfoArgs
//

#[derive(Clone, Debug, Eq, Hash, Ord, PartialEq, PartialOrd)]
struct HbaseGetRegionInfoArgs {
  /// row key
  row: Text,
}

impl HbaseGetRegionInfoArgs {
  fn read_from_in_protocol(i_prot: &mut dyn TInputProtocol) -> thrift::Result<HbaseGetRegionInfoArgs> {
    i_prot.read_struct_begin()?;
    let mut f_1: Option<Text> = None;
    loop {
      let field_ident = i_prot.read_field_begin()?;
      if field_ident.field_type == TType::Stop {
        break;
      }
      let field_id = field_id(&field_ident)?;
      match field_id {
        1 => {
          let val = i_prot.read_bytes()?;
          f_1 = Some(val);
        },
        _ => {
          i_prot.skip(field_ident.field_type)?;
        },
      };
      i_prot.read_field_end()?;
    }
    i_prot.read_struct_end()?;
    verify_required_field_exists("HbaseGetRegionInfoArgs.row", &f_1)?;
    let ret = HbaseGetRegionInfoArgs {
      row: f_1.expect("auto-generated code should have checked for presence of required fields"),
    };
    Ok(ret)
  }
  fn write_to_out_protocol(&self, o_prot: &mut dyn TOutputProtocol) -> thrift::Result<()> {
    let struct_ident = TStructIdentifier::new("getRegionInfo_args");
    o_prot.write_struct_begin(&struct_ident)?;
    o_prot.write_field_begin(&TFieldIdentifier::new("row", TType::String, 1))?;
    o_prot.write_bytes(&self.row)?;
    o_prot.write_field_end()?;
    o_prot.write_field_stop()?;
    o_prot.write_struct_end()
  }
}

//
// HbaseGetRegionInfoResult
//

#[derive(Clone, Debug, Eq, Hash, Ord, PartialEq, PartialOrd)]
struct HbaseGetRegionInfoResult {
  result_value: Option<TRegionInfo>,
  io: Option<IOError>,
}

impl HbaseGetRegionInfoResult {
  fn read_from_in_protocol(i_prot: &mut dyn TInputProtocol) -> thrift::Result<HbaseGetRegionInfoResult> {
    i_prot.read_struct_begin()?;
    let mut f_0: Option<TRegionInfo> = None;
    let mut f_1: Option<IOError> = None;
    loop {
      let field_ident = i_prot.read_field_begin()?;
      if field_ident.field_type == TType::Stop {
        break;
      }
      let field_id = field_id(&field_ident)?;
      match field_id {
        0 => {
          let val = TRegionInfo::read_from_in_protocol(i_prot)?;
          f_0 = Some(val);
        },
        1 => {
          let val = IOError::read_from_in_protocol(i_prot)?;
          f_1 = Some(val);
        },
        _ => {
          i_prot.skip(field_ident.field_type)?;
        },
      };
      i_prot.read_field_end()?;
    }
    i_prot.read_struct_end()?;
    let ret = HbaseGetRegionInfoResult {
      result_value: f_0,
      io: f_1,
    };
    Ok(ret)
  }
  fn write_to_out_protocol(&self, o_prot: &mut dyn TOutputProtocol) -> thrift::Result<()> {
    let struct_ident = TStructIdentifier::new("HbaseGetRegionInfoResult");
    o_prot.write_struct_begin(&struct_ident)?;
    if let Some(ref fld_var) = self.result_value {
      o_prot.write_field_begin(&TFieldIdentifier::new("result_value", TType::Struct, 0))?;
      fld_var.write_to_out_protocol(o_prot)?;
      o_prot.write_field_end()?
    }
    if let Some(ref fld_var) = self.io {
      o_prot.write_field_begin(&TFieldIdentifier::new("io", TType::Struct, 1))?;
      fld_var.write_to_out_protocol(o_prot)?;
      o_prot.write_field_end()?
    }
    o_prot.write_field_stop()?;
    o_prot.write_struct_end()
  }
  fn ok_or(self) -> thrift::Result<TRegionInfo> {
    if self.io.is_some() {
      Err(thrift::Error::User(Box::new(self.io.unwrap())))
    } else if self.result_value.is_some() {
      Ok(self.result_value.unwrap())
    } else {
      Err(
        thrift::Error::Application(
          ApplicationError::new(
            ApplicationErrorKind::MissingResult,
            "no result received for HbaseGetRegionInfo"
          )
        )
      )
    }
  }
}

//
// HbaseAppendArgs
//

#[derive(Clone, Debug, Eq, Hash, Ord, PartialEq, PartialOrd)]
struct HbaseAppendArgs {
  /// The single append operation to apply
  append: TAppend,
}

impl HbaseAppendArgs {
  fn read_from_in_protocol(i_prot: &mut dyn TInputProtocol) -> thrift::Result<HbaseAppendArgs> {
    i_prot.read_struct_begin()?;
    let mut f_1: Option<TAppend> = None;
    loop {
      let field_ident = i_prot.read_field_begin()?;
      if field_ident.field_type == TType::Stop {
        break;
      }
      let field_id = field_id(&field_ident)?;
      match field_id {
        1 => {
          let val = TAppend::read_from_in_protocol(i_prot)?;
          f_1 = Some(val);
        },
        _ => {
          i_prot.skip(field_ident.field_type)?;
        },
      };
      i_prot.read_field_end()?;
    }
    i_prot.read_struct_end()?;
    verify_required_field_exists("HbaseAppendArgs.append", &f_1)?;
    let ret = HbaseAppendArgs {
      append: f_1.expect("auto-generated code should have checked for presence of required fields"),
    };
    Ok(ret)
  }
  fn write_to_out_protocol(&self, o_prot: &mut dyn TOutputProtocol) -> thrift::Result<()> {
    let struct_ident = TStructIdentifier::new("append_args");
    o_prot.write_struct_begin(&struct_ident)?;
    o_prot.write_field_begin(&TFieldIdentifier::new("append", TType::Struct, 1))?;
    self.append.write_to_out_protocol(o_prot)?;
    o_prot.write_field_end()?;
    o_prot.write_field_stop()?;
    o_prot.write_struct_end()
  }
}

//
// HbaseAppendResult
//

#[derive(Clone, Debug, Eq, Hash, Ord, PartialEq, PartialOrd)]
struct HbaseAppendResult {
  result_value: Option<Vec<TCell>>,
  io: Option<IOError>,
}

impl HbaseAppendResult {
  fn read_from_in_protocol(i_prot: &mut dyn TInputProtocol) -> thrift::Result<HbaseAppendResult> {
    i_prot.read_struct_begin()?;
    let mut f_0: Option<Vec<TCell>> = None;
    let mut f_1: Option<IOError> = None;
    loop {
      let field_ident = i_prot.read_field_begin()?;
      if field_ident.field_type == TType::Stop {
        break;
      }
      let field_id = field_id(&field_ident)?;
      match field_id {
        0 => {
          let list_ident = i_prot.read_list_begin()?;
          let mut val: Vec<TCell> = Vec::with_capacity(list_ident.size as usize);
          for _ in 0..list_ident.size {
            let list_elem_95 = TCell::read_from_in_protocol(i_prot)?;
            val.push(list_elem_95);
          }
          i_prot.read_list_end()?;
          f_0 = Some(val);
        },
        1 => {
          let val = IOError::read_from_in_protocol(i_prot)?;
          f_1 = Some(val);
        },
        _ => {
          i_prot.skip(field_ident.field_type)?;
        },
      };
      i_prot.read_field_end()?;
    }
    i_prot.read_struct_end()?;
    let ret = HbaseAppendResult {
      result_value: f_0,
      io: f_1,
    };
    Ok(ret)
  }
  fn write_to_out_protocol(&self, o_prot: &mut dyn TOutputProtocol) -> thrift::Result<()> {
    let struct_ident = TStructIdentifier::new("HbaseAppendResult");
    o_prot.write_struct_begin(&struct_ident)?;
    if let Some(ref fld_var) = self.result_value {
      o_prot.write_field_begin(&TFieldIdentifier::new("result_value", TType::List, 0))?;
      o_prot.write_list_begin(&TListIdentifier::new(TType::Struct, fld_var.len() as i32))?;
      for e in fld_var {
        e.write_to_out_protocol(o_prot)?;
      }
      o_prot.write_list_end()?;
      o_prot.write_field_end()?
    }
    if let Some(ref fld_var) = self.io {
      o_prot.write_field_begin(&TFieldIdentifier::new("io", TType::Struct, 1))?;
      fld_var.write_to_out_protocol(o_prot)?;
      o_prot.write_field_end()?
    }
    o_prot.write_field_stop()?;
    o_prot.write_struct_end()
  }
  fn ok_or(self) -> thrift::Result<Vec<TCell>> {
    if self.io.is_some() {
      Err(thrift::Error::User(Box::new(self.io.unwrap())))
    } else if self.result_value.is_some() {
      Ok(self.result_value.unwrap())
    } else {
      Err(
        thrift::Error::Application(
          ApplicationError::new(
            ApplicationErrorKind::MissingResult,
            "no result received for HbaseAppend"
          )
        )
      )
    }
  }
}

//
// HbaseCheckAndPutArgs
//

#[derive(Clone, Debug, Eq, Hash, Ord, PartialEq, PartialOrd)]
struct HbaseCheckAndPutArgs {
  /// name of table
  table_name: Text,
  /// row key
  row: Text,
  /// column name
  column: Text,
  /// the expected value for the column parameter, if not
  /// provided the check is for the non-existence of the
  /// column in question
  value: Text,
  /// mutation for the put
  mput: Mutation,
  /// Mutation attributes
  attributes: BTreeMap<Text, Text>,
}

impl HbaseCheckAndPutArgs {
  fn read_from_in_protocol(i_prot: &mut dyn TInputProtocol) -> thrift::Result<HbaseCheckAndPutArgs> {
    i_prot.read_struct_begin()?;
    let mut f_1: Option<Text> = None;
    let mut f_2: Option<Text> = None;
    let mut f_3: Option<Text> = None;
    let mut f_5: Option<Text> = None;
    let mut f_6: Option<Mutation> = None;
    let mut f_7: Option<BTreeMap<Text, Text>> = None;
    loop {
      let field_ident = i_prot.read_field_begin()?;
      if field_ident.field_type == TType::Stop {
        break;
      }
      let field_id = field_id(&field_ident)?;
      match field_id {
        1 => {
          let val = i_prot.read_bytes()?;
          f_1 = Some(val);
        },
        2 => {
          let val = i_prot.read_bytes()?;
          f_2 = Some(val);
        },
        3 => {
          let val = i_prot.read_bytes()?;
          f_3 = Some(val);
        },
        5 => {
          let val = i_prot.read_bytes()?;
          f_5 = Some(val);
        },
        6 => {
          let val = Mutation::read_from_in_protocol(i_prot)?;
          f_6 = Some(val);
        },
        7 => {
          let map_ident = i_prot.read_map_begin()?;
          let mut val: BTreeMap<Text, Text> = BTreeMap::new();
          for _ in 0..map_ident.size {
            let map_key_96 = i_prot.read_bytes()?;
            let map_val_97 = i_prot.read_bytes()?;
            val.insert(map_key_96, map_val_97);
          }
          i_prot.read_map_end()?;
          f_7 = Some(val);
        },
        _ => {
          i_prot.skip(field_ident.field_type)?;
        },
      };
      i_prot.read_field_end()?;
    }
    i_prot.read_struct_end()?;
    verify_required_field_exists("HbaseCheckAndPutArgs.table_name", &f_1)?;
    verify_required_field_exists("HbaseCheckAndPutArgs.row", &f_2)?;
    verify_required_field_exists("HbaseCheckAndPutArgs.column", &f_3)?;
    verify_required_field_exists("HbaseCheckAndPutArgs.value", &f_5)?;
    verify_required_field_exists("HbaseCheckAndPutArgs.mput", &f_6)?;
    verify_required_field_exists("HbaseCheckAndPutArgs.attributes", &f_7)?;
    let ret = HbaseCheckAndPutArgs {
      table_name: f_1.expect("auto-generated code should have checked for presence of required fields"),
      row: f_2.expect("auto-generated code should have checked for presence of required fields"),
      column: f_3.expect("auto-generated code should have checked for presence of required fields"),
      value: f_5.expect("auto-generated code should have checked for presence of required fields"),
      mput: f_6.expect("auto-generated code should have checked for presence of required fields"),
      attributes: f_7.expect("auto-generated code should have checked for presence of required fields"),
    };
    Ok(ret)
  }
  fn write_to_out_protocol(&self, o_prot: &mut dyn TOutputProtocol) -> thrift::Result<()> {
    let struct_ident = TStructIdentifier::new("checkAndPut_args");
    o_prot.write_struct_begin(&struct_ident)?;
    o_prot.write_field_begin(&TFieldIdentifier::new("tableName", TType::String, 1))?;
    o_prot.write_bytes(&self.table_name)?;
    o_prot.write_field_end()?;
    o_prot.write_field_begin(&TFieldIdentifier::new("row", TType::String, 2))?;
    o_prot.write_bytes(&self.row)?;
    o_prot.write_field_end()?;
    o_prot.write_field_begin(&TFieldIdentifier::new("column", TType::String, 3))?;
    o_prot.write_bytes(&self.column)?;
    o_prot.write_field_end()?;
    o_prot.write_field_begin(&TFieldIdentifier::new("value", TType::String, 5))?;
    o_prot.write_bytes(&self.value)?;
    o_prot.write_field_end()?;
    o_prot.write_field_begin(&TFieldIdentifier::new("mput", TType::Struct, 6))?;
    self.mput.write_to_out_protocol(o_prot)?;
    o_prot.write_field_end()?;
    o_prot.write_field_begin(&TFieldIdentifier::new("attributes", TType::Map, 7))?;
    o_prot.write_map_begin(&TMapIdentifier::new(TType::String, TType::String, self.attributes.len() as i32))?;
    for (k, v) in &self.attributes {
      o_prot.write_bytes(k)?;
      o_prot.write_bytes(v)?;
    }
    o_prot.write_map_end()?;
    o_prot.write_field_end()?;
    o_prot.write_field_stop()?;
    o_prot.write_struct_end()
  }
}

//
// HbaseCheckAndPutResult
//

#[derive(Clone, Debug, Eq, Hash, Ord, PartialEq, PartialOrd)]
struct HbaseCheckAndPutResult {
  result_value: Option<bool>,
  io: Option<IOError>,
  ia: Option<IllegalArgument>,
}

impl HbaseCheckAndPutResult {
  fn read_from_in_protocol(i_prot: &mut dyn TInputProtocol) -> thrift::Result<HbaseCheckAndPutResult> {
    i_prot.read_struct_begin()?;
    let mut f_0: Option<bool> = None;
    let mut f_1: Option<IOError> = None;
    let mut f_2: Option<IllegalArgument> = None;
    loop {
      let field_ident = i_prot.read_field_begin()?;
      if field_ident.field_type == TType::Stop {
        break;
      }
      let field_id = field_id(&field_ident)?;
      match field_id {
        0 => {
          let val = i_prot.read_bool()?;
          f_0 = Some(val);
        },
        1 => {
          let val = IOError::read_from_in_protocol(i_prot)?;
          f_1 = Some(val);
        },
        2 => {
          let val = IllegalArgument::read_from_in_protocol(i_prot)?;
          f_2 = Some(val);
        },
        _ => {
          i_prot.skip(field_ident.field_type)?;
        },
      };
      i_prot.read_field_end()?;
    }
    i_prot.read_struct_end()?;
    let ret = HbaseCheckAndPutResult {
      result_value: f_0,
      io: f_1,
      ia: f_2,
    };
    Ok(ret)
  }
  fn write_to_out_protocol(&self, o_prot: &mut dyn TOutputProtocol) -> thrift::Result<()> {
    let struct_ident = TStructIdentifier::new("HbaseCheckAndPutResult");
    o_prot.write_struct_begin(&struct_ident)?;
    if let Some(fld_var) = self.result_value {
      o_prot.write_field_begin(&TFieldIdentifier::new("result_value", TType::Bool, 0))?;
      o_prot.write_bool(fld_var)?;
      o_prot.write_field_end()?
    }
    if let Some(ref fld_var) = self.io {
      o_prot.write_field_begin(&TFieldIdentifier::new("io", TType::Struct, 1))?;
      fld_var.write_to_out_protocol(o_prot)?;
      o_prot.write_field_end()?
    }
    if let Some(ref fld_var) = self.ia {
      o_prot.write_field_begin(&TFieldIdentifier::new("ia", TType::Struct, 2))?;
      fld_var.write_to_out_protocol(o_prot)?;
      o_prot.write_field_end()?
    }
    o_prot.write_field_stop()?;
    o_prot.write_struct_end()
  }
  fn ok_or(self) -> thrift::Result<bool> {
    if self.io.is_some() {
      Err(thrift::Error::User(Box::new(self.io.unwrap())))
    } else if self.ia.is_some() {
      Err(thrift::Error::User(Box::new(self.ia.unwrap())))
    } else if self.result_value.is_some() {
      Ok(self.result_value.unwrap())
    } else {
      Err(
        thrift::Error::Application(
          ApplicationError::new(
            ApplicationErrorKind::MissingResult,
            "no result received for HbaseCheckAndPut"
          )
        )
      )
    }
  }
}

//
// HbaseGetThriftServerTypeArgs
//

#[derive(Clone, Debug, Eq, Hash, Ord, PartialEq, PartialOrd)]
struct HbaseGetThriftServerTypeArgs {
}

impl HbaseGetThriftServerTypeArgs {
  fn read_from_in_protocol(i_prot: &mut dyn TInputProtocol) -> thrift::Result<HbaseGetThriftServerTypeArgs> {
    i_prot.read_struct_begin()?;
    loop {
      let field_ident = i_prot.read_field_begin()?;
      if field_ident.field_type == TType::Stop {
        break;
      }
      let field_id = field_id(&field_ident)?;
      match field_id {
        _ => {
          i_prot.skip(field_ident.field_type)?;
        },
      };
      i_prot.read_field_end()?;
    }
    i_prot.read_struct_end()?;
    let ret = HbaseGetThriftServerTypeArgs {};
    Ok(ret)
  }
  fn write_to_out_protocol(&self, o_prot: &mut dyn TOutputProtocol) -> thrift::Result<()> {
    let struct_ident = TStructIdentifier::new("getThriftServerType_args");
    o_prot.write_struct_begin(&struct_ident)?;
    o_prot.write_field_stop()?;
    o_prot.write_struct_end()
  }
}

//
// HbaseGetThriftServerTypeResult
//

#[derive(Clone, Debug, Eq, Hash, Ord, PartialEq, PartialOrd)]
struct HbaseGetThriftServerTypeResult {
  result_value: Option<TThriftServerType>,
}

impl HbaseGetThriftServerTypeResult {
  fn read_from_in_protocol(i_prot: &mut dyn TInputProtocol) -> thrift::Result<HbaseGetThriftServerTypeResult> {
    i_prot.read_struct_begin()?;
    let mut f_0: Option<TThriftServerType> = None;
    loop {
      let field_ident = i_prot.read_field_begin()?;
      if field_ident.field_type == TType::Stop {
        break;
      }
      let field_id = field_id(&field_ident)?;
      match field_id {
        0 => {
          let val = TThriftServerType::read_from_in_protocol(i_prot)?;
          f_0 = Some(val);
        },
        _ => {
          i_prot.skip(field_ident.field_type)?;
        },
      };
      i_prot.read_field_end()?;
    }
    i_prot.read_struct_end()?;
    let ret = HbaseGetThriftServerTypeResult {
      result_value: f_0,
    };
    Ok(ret)
  }
  fn write_to_out_protocol(&self, o_prot: &mut dyn TOutputProtocol) -> thrift::Result<()> {
    let struct_ident = TStructIdentifier::new("HbaseGetThriftServerTypeResult");
    o_prot.write_struct_begin(&struct_ident)?;
    if let Some(ref fld_var) = self.result_value {
      o_prot.write_field_begin(&TFieldIdentifier::new("result_value", TType::I32, 0))?;
      fld_var.write_to_out_protocol(o_prot)?;
      o_prot.write_field_end()?
    }
    o_prot.write_field_stop()?;
    o_prot.write_struct_end()
  }
  fn ok_or(self) -> thrift::Result<TThriftServerType> {
    if self.result_value.is_some() {
      Ok(self.result_value.unwrap())
    } else {
      Err(
        thrift::Error::Application(
          ApplicationError::new(
            ApplicationErrorKind::MissingResult,
            "no result received for HbaseGetThriftServerType"
          )
        )
      )
    }
  }
}

//
// HbaseGetClusterIdArgs
//

#[derive(Clone, Debug, Eq, Hash, Ord, PartialEq, PartialOrd)]
struct HbaseGetClusterIdArgs {
}

impl HbaseGetClusterIdArgs {
  fn read_from_in_protocol(i_prot: &mut dyn TInputProtocol) -> thrift::Result<HbaseGetClusterIdArgs> {
    i_prot.read_struct_begin()?;
    loop {
      let field_ident = i_prot.read_field_begin()?;
      if field_ident.field_type == TType::Stop {
        break;
      }
      let field_id = field_id(&field_ident)?;
      match field_id {
        _ => {
          i_prot.skip(field_ident.field_type)?;
        },
      };
      i_prot.read_field_end()?;
    }
    i_prot.read_struct_end()?;
    let ret = HbaseGetClusterIdArgs {};
    Ok(ret)
  }
  fn write_to_out_protocol(&self, o_prot: &mut dyn TOutputProtocol) -> thrift::Result<()> {
    let struct_ident = TStructIdentifier::new("getClusterId_args");
    o_prot.write_struct_begin(&struct_ident)?;
    o_prot.write_field_stop()?;
    o_prot.write_struct_end()
  }
}

//
// HbaseGetClusterIdResult
//

#[derive(Clone, Debug, Eq, Hash, Ord, PartialEq, PartialOrd)]
struct HbaseGetClusterIdResult {
  result_value: Option<String>,
}

impl HbaseGetClusterIdResult {
  fn read_from_in_protocol(i_prot: &mut dyn TInputProtocol) -> thrift::Result<HbaseGetClusterIdResult> {
    i_prot.read_struct_begin()?;
    let mut f_0: Option<String> = None;
    loop {
      let field_ident = i_prot.read_field_begin()?;
      if field_ident.field_type == TType::Stop {
        break;
      }
      let field_id = field_id(&field_ident)?;
      match field_id {
        0 => {
          let val = i_prot.read_string()?;
          f_0 = Some(val);
        },
        _ => {
          i_prot.skip(field_ident.field_type)?;
        },
      };
      i_prot.read_field_end()?;
    }
    i_prot.read_struct_end()?;
    let ret = HbaseGetClusterIdResult {
      result_value: f_0,
    };
    Ok(ret)
  }
  fn write_to_out_protocol(&self, o_prot: &mut dyn TOutputProtocol) -> thrift::Result<()> {
    let struct_ident = TStructIdentifier::new("HbaseGetClusterIdResult");
    o_prot.write_struct_begin(&struct_ident)?;
    if let Some(ref fld_var) = self.result_value {
      o_prot.write_field_begin(&TFieldIdentifier::new("result_value", TType::String, 0))?;
      o_prot.write_string(fld_var)?;
      o_prot.write_field_end()?
    }
    o_prot.write_field_stop()?;
    o_prot.write_struct_end()
  }
  fn ok_or(self) -> thrift::Result<String> {
    if self.result_value.is_some() {
      Ok(self.result_value.unwrap())
    } else {
      Err(
        thrift::Error::Application(
          ApplicationError::new(
            ApplicationErrorKind::MissingResult,
            "no result received for HbaseGetClusterId"
          )
        )
      )
    }
  }
}

//
// HbaseGrantArgs
//

#[derive(Clone, Debug, Eq, Hash, Ord, PartialEq, PartialOrd)]
struct HbaseGrantArgs {
  info: TAccessControlEntity,
}

impl HbaseGrantArgs {
  fn read_from_in_protocol(i_prot: &mut dyn TInputProtocol) -> thrift::Result<HbaseGrantArgs> {
    i_prot.read_struct_begin()?;
    let mut f_1: Option<TAccessControlEntity> = None;
    loop {
      let field_ident = i_prot.read_field_begin()?;
      if field_ident.field_type == TType::Stop {
        break;
      }
      let field_id = field_id(&field_ident)?;
      match field_id {
        1 => {
          let val = TAccessControlEntity::read_from_in_protocol(i_prot)?;
          f_1 = Some(val);
        },
        _ => {
          i_prot.skip(field_ident.field_type)?;
        },
      };
      i_prot.read_field_end()?;
    }
    i_prot.read_struct_end()?;
    verify_required_field_exists("HbaseGrantArgs.info", &f_1)?;
    let ret = HbaseGrantArgs {
      info: f_1.expect("auto-generated code should have checked for presence of required fields"),
    };
    Ok(ret)
  }
  fn write_to_out_protocol(&self, o_prot: &mut dyn TOutputProtocol) -> thrift::Result<()> {
    let struct_ident = TStructIdentifier::new("grant_args");
    o_prot.write_struct_begin(&struct_ident)?;
    o_prot.write_field_begin(&TFieldIdentifier::new("info", TType::Struct, 1))?;
    self.info.write_to_out_protocol(o_prot)?;
    o_prot.write_field_end()?;
    o_prot.write_field_stop()?;
    o_prot.write_struct_end()
  }
}

//
// HbaseGrantResult
//

#[derive(Clone, Debug, Eq, Hash, Ord, PartialEq, PartialOrd)]
struct HbaseGrantResult {
  result_value: Option<bool>,
  io: Option<IOError>,
}

impl HbaseGrantResult {
  fn read_from_in_protocol(i_prot: &mut dyn TInputProtocol) -> thrift::Result<HbaseGrantResult> {
    i_prot.read_struct_begin()?;
    let mut f_0: Option<bool> = None;
    let mut f_1: Option<IOError> = None;
    loop {
      let field_ident = i_prot.read_field_begin()?;
      if field_ident.field_type == TType::Stop {
        break;
      }
      let field_id = field_id(&field_ident)?;
      match field_id {
        0 => {
          let val = i_prot.read_bool()?;
          f_0 = Some(val);
        },
        1 => {
          let val = IOError::read_from_in_protocol(i_prot)?;
          f_1 = Some(val);
        },
        _ => {
          i_prot.skip(field_ident.field_type)?;
        },
      };
      i_prot.read_field_end()?;
    }
    i_prot.read_struct_end()?;
    let ret = HbaseGrantResult {
      result_value: f_0,
      io: f_1,
    };
    Ok(ret)
  }
  fn write_to_out_protocol(&self, o_prot: &mut dyn TOutputProtocol) -> thrift::Result<()> {
    let struct_ident = TStructIdentifier::new("HbaseGrantResult");
    o_prot.write_struct_begin(&struct_ident)?;
    if let Some(fld_var) = self.result_value {
      o_prot.write_field_begin(&TFieldIdentifier::new("result_value", TType::Bool, 0))?;
      o_prot.write_bool(fld_var)?;
      o_prot.write_field_end()?
    }
    if let Some(ref fld_var) = self.io {
      o_prot.write_field_begin(&TFieldIdentifier::new("io", TType::Struct, 1))?;
      fld_var.write_to_out_protocol(o_prot)?;
      o_prot.write_field_end()?
    }
    o_prot.write_field_stop()?;
    o_prot.write_struct_end()
  }
  fn ok_or(self) -> thrift::Result<bool> {
    if self.io.is_some() {
      Err(thrift::Error::User(Box::new(self.io.unwrap())))
    } else if self.result_value.is_some() {
      Ok(self.result_value.unwrap())
    } else {
      Err(
        thrift::Error::Application(
          ApplicationError::new(
            ApplicationErrorKind::MissingResult,
            "no result received for HbaseGrant"
          )
        )
      )
    }
  }
}

//
// HbaseRevokeArgs
//

#[derive(Clone, Debug, Eq, Hash, Ord, PartialEq, PartialOrd)]
struct HbaseRevokeArgs {
  info: TAccessControlEntity,
}

impl HbaseRevokeArgs {
  fn read_from_in_protocol(i_prot: &mut dyn TInputProtocol) -> thrift::Result<HbaseRevokeArgs> {
    i_prot.read_struct_begin()?;
    let mut f_1: Option<TAccessControlEntity> = None;
    loop {
      let field_ident = i_prot.read_field_begin()?;
      if field_ident.field_type == TType::Stop {
        break;
      }
      let field_id = field_id(&field_ident)?;
      match field_id {
        1 => {
          let val = TAccessControlEntity::read_from_in_protocol(i_prot)?;
          f_1 = Some(val);
        },
        _ => {
          i_prot.skip(field_ident.field_type)?;
        },
      };
      i_prot.read_field_end()?;
    }
    i_prot.read_struct_end()?;
    verify_required_field_exists("HbaseRevokeArgs.info", &f_1)?;
    let ret = HbaseRevokeArgs {
      info: f_1.expect("auto-generated code should have checked for presence of required fields"),
    };
    Ok(ret)
  }
  fn write_to_out_protocol(&self, o_prot: &mut dyn TOutputProtocol) -> thrift::Result<()> {
    let struct_ident = TStructIdentifier::new("revoke_args");
    o_prot.write_struct_begin(&struct_ident)?;
    o_prot.write_field_begin(&TFieldIdentifier::new("info", TType::Struct, 1))?;
    self.info.write_to_out_protocol(o_prot)?;
    o_prot.write_field_end()?;
    o_prot.write_field_stop()?;
    o_prot.write_struct_end()
  }
}

//
// HbaseRevokeResult
//

#[derive(Clone, Debug, Eq, Hash, Ord, PartialEq, PartialOrd)]
struct HbaseRevokeResult {
  result_value: Option<bool>,
  io: Option<IOError>,
}

impl HbaseRevokeResult {
  fn read_from_in_protocol(i_prot: &mut dyn TInputProtocol) -> thrift::Result<HbaseRevokeResult> {
    i_prot.read_struct_begin()?;
    let mut f_0: Option<bool> = None;
    let mut f_1: Option<IOError> = None;
    loop {
      let field_ident = i_prot.read_field_begin()?;
      if field_ident.field_type == TType::Stop {
        break;
      }
      let field_id = field_id(&field_ident)?;
      match field_id {
        0 => {
          let val = i_prot.read_bool()?;
          f_0 = Some(val);
        },
        1 => {
          let val = IOError::read_from_in_protocol(i_prot)?;
          f_1 = Some(val);
        },
        _ => {
          i_prot.skip(field_ident.field_type)?;
        },
      };
      i_prot.read_field_end()?;
    }
    i_prot.read_struct_end()?;
    let ret = HbaseRevokeResult {
      result_value: f_0,
      io: f_1,
    };
    Ok(ret)
  }
  fn write_to_out_protocol(&self, o_prot: &mut dyn TOutputProtocol) -> thrift::Result<()> {
    let struct_ident = TStructIdentifier::new("HbaseRevokeResult");
    o_prot.write_struct_begin(&struct_ident)?;
    if let Some(fld_var) = self.result_value {
      o_prot.write_field_begin(&TFieldIdentifier::new("result_value", TType::Bool, 0))?;
      o_prot.write_bool(fld_var)?;
      o_prot.write_field_end()?
    }
    if let Some(ref fld_var) = self.io {
      o_prot.write_field_begin(&TFieldIdentifier::new("io", TType::Struct, 1))?;
      fld_var.write_to_out_protocol(o_prot)?;
      o_prot.write_field_end()?
    }
    o_prot.write_field_stop()?;
    o_prot.write_struct_end()
  }
  fn ok_or(self) -> thrift::Result<bool> {
    if self.io.is_some() {
      Err(thrift::Error::User(Box::new(self.io.unwrap())))
    } else if self.result_value.is_some() {
      Ok(self.result_value.unwrap())
    } else {
      Err(
        thrift::Error::Application(
          ApplicationError::new(
            ApplicationErrorKind::MissingResult,
            "no result received for HbaseRevoke"
          )
        )
      )
    }
  }
}
