// Autogenerated by Thrift Compiler (0.15.0)
// DO NOT EDIT UNLESS YOU ARE SURE THAT YOU KNOW WHAT YOU ARE DOING

#![allow(unused_imports)]
#![allow(unused_extern_crates)]
#![allow(clippy::too_many_arguments, clippy::type_complexity, clippy::vec_box)]
#![cfg_attr(rustfmt, rustfmt_skip)]

use std::cell::RefCell;
use std::collections::{BTreeMap, BTreeSet};
use std::convert::{From, TryFrom};
use std::default::Default;
use std::error::Error;
use std::fmt;
use std::fmt::{Display, Formatter};
use std::rc::Rc;

use thrift::OrderedFloat;
use thrift::{ApplicationError, ApplicationErrorKind, ProtocolError, ProtocolErrorKind, TThriftClient};
use thrift::protocol::{TFieldIdentifier, TListIdentifier, TMapIdentifier, TMessageIdentifier, TMessageType, TInputProtocol, TOutputProtocol, TSetIdentifier, TStructIdentifier, TType};
use thrift::protocol::field_id;
use thrift::protocol::verify_expected_message_type;
use thrift::protocol::verify_expected_sequence_number;
use thrift::protocol::verify_expected_service_call;
use thrift::protocol::verify_required_field_exists;
use thrift::server::TProcessor;

/// Specify type of delete:
///  - DELETE_COLUMN means exactly one version will be removed,
///  - DELETE_COLUMNS means previous versions will also be removed.
#[derive(Copy, Clone, Debug, Eq, Hash, Ord, PartialEq, PartialOrd)]
pub struct TDeleteType(pub i32);

impl TDeleteType {
  pub const DELETE_COLUMN: TDeleteType = TDeleteType(0);
  pub const DELETE_COLUMNS: TDeleteType = TDeleteType(1);
  pub const DELETE_FAMILY: TDeleteType = TDeleteType(2);
  pub const DELETE_FAMILY_VERSION: TDeleteType = TDeleteType(3);
  pub const ENUM_VALUES: &'static [Self] = &[
    Self::DELETE_COLUMN,
    Self::DELETE_COLUMNS,
    Self::DELETE_FAMILY,
    Self::DELETE_FAMILY_VERSION,
  ];
  #[allow(clippy::trivially_copy_pass_by_ref)]
  pub fn write_to_out_protocol(&self, o_prot: &mut dyn TOutputProtocol) -> thrift::Result<()> {
    o_prot.write_i32(self.0)
  }
  pub fn read_from_in_protocol(i_prot: &mut dyn TInputProtocol) -> thrift::Result<TDeleteType> {
    let enum_value = i_prot.read_i32()?;
    Ok(TDeleteType::from(enum_value))
  }
}

impl From<i32> for TDeleteType {
  fn from(i: i32) -> Self {
    match i {
      0 => TDeleteType::DELETE_COLUMN,
      1 => TDeleteType::DELETE_COLUMNS,
      2 => TDeleteType::DELETE_FAMILY,
      3 => TDeleteType::DELETE_FAMILY_VERSION,
      _ => TDeleteType(i)
    }
  }
}

impl From<&i32> for TDeleteType {
  fn from(i: &i32) -> Self {
    TDeleteType::from(*i)
  }
}

impl From<TDeleteType> for i32 {
  fn from(e: TDeleteType) -> i32 {
    e.0
  }
}

impl From<&TDeleteType> for i32 {
  fn from(e: &TDeleteType) -> i32 {
    e.0
  }
}

/// Specify Durability:
///  - SKIP_WAL means do not write the Mutation to the WAL.
///  - ASYNC_WAL means write the Mutation to the WAL asynchronously,
///  - SYNC_WAL means write the Mutation to the WAL synchronously,
///  - FSYNC_WAL means Write the Mutation to the WAL synchronously and force the entries to disk.
#[derive(Copy, Clone, Debug, Eq, Hash, Ord, PartialEq, PartialOrd)]
pub struct TDurability(pub i32);

impl TDurability {
  pub const USE_DEFAULT: TDurability = TDurability(0);
  pub const SKIP_WAL: TDurability = TDurability(1);
  pub const ASYNC_WAL: TDurability = TDurability(2);
  pub const SYNC_WAL: TDurability = TDurability(3);
  pub const FSYNC_WAL: TDurability = TDurability(4);
  pub const ENUM_VALUES: &'static [Self] = &[
    Self::USE_DEFAULT,
    Self::SKIP_WAL,
    Self::ASYNC_WAL,
    Self::SYNC_WAL,
    Self::FSYNC_WAL,
  ];
  #[allow(clippy::trivially_copy_pass_by_ref)]
  pub fn write_to_out_protocol(&self, o_prot: &mut dyn TOutputProtocol) -> thrift::Result<()> {
    o_prot.write_i32(self.0)
  }
  pub fn read_from_in_protocol(i_prot: &mut dyn TInputProtocol) -> thrift::Result<TDurability> {
    let enum_value = i_prot.read_i32()?;
    Ok(TDurability::from(enum_value))
  }
}

impl From<i32> for TDurability {
  fn from(i: i32) -> Self {
    match i {
      0 => TDurability::USE_DEFAULT,
      1 => TDurability::SKIP_WAL,
      2 => TDurability::ASYNC_WAL,
      3 => TDurability::SYNC_WAL,
      4 => TDurability::FSYNC_WAL,
      _ => TDurability(i)
    }
  }
}

impl From<&i32> for TDurability {
  fn from(i: &i32) -> Self {
    TDurability::from(*i)
  }
}

impl From<TDurability> for i32 {
  fn from(e: TDurability) -> i32 {
    e.0
  }
}

impl From<&TDurability> for i32 {
  fn from(e: &TDurability) -> i32 {
    e.0
  }
}

/// Specify Consistency:
///  - STRONG means reads only from primary region
///  - TIMELINE means reads might return values from secondary region replicas
#[derive(Copy, Clone, Debug, Eq, Hash, Ord, PartialEq, PartialOrd)]
pub struct TConsistency(pub i32);

impl TConsistency {
  pub const STRONG: TConsistency = TConsistency(1);
  pub const TIMELINE: TConsistency = TConsistency(2);
  pub const ENUM_VALUES: &'static [Self] = &[
    Self::STRONG,
    Self::TIMELINE,
  ];
  #[allow(clippy::trivially_copy_pass_by_ref)]
  pub fn write_to_out_protocol(&self, o_prot: &mut dyn TOutputProtocol) -> thrift::Result<()> {
    o_prot.write_i32(self.0)
  }
  pub fn read_from_in_protocol(i_prot: &mut dyn TInputProtocol) -> thrift::Result<TConsistency> {
    let enum_value = i_prot.read_i32()?;
    Ok(TConsistency::from(enum_value))
  }
}

impl From<i32> for TConsistency {
  fn from(i: i32) -> Self {
    match i {
      1 => TConsistency::STRONG,
      2 => TConsistency::TIMELINE,
      _ => TConsistency(i)
    }
  }
}

impl From<&i32> for TConsistency {
  fn from(i: &i32) -> Self {
    TConsistency::from(*i)
  }
}

impl From<TConsistency> for i32 {
  fn from(e: TConsistency) -> i32 {
    e.0
  }
}

impl From<&TConsistency> for i32 {
  fn from(e: &TConsistency) -> i32 {
    e.0
  }
}

#[derive(Copy, Clone, Debug, Eq, Hash, Ord, PartialEq, PartialOrd)]
pub struct TReadType(pub i32);

impl TReadType {
  pub const DEFAULT: TReadType = TReadType(1);
  pub const STREAM: TReadType = TReadType(2);
  pub const PREAD: TReadType = TReadType(3);
  pub const ENUM_VALUES: &'static [Self] = &[
    Self::DEFAULT,
    Self::STREAM,
    Self::PREAD,
  ];
  #[allow(clippy::trivially_copy_pass_by_ref)]
  pub fn write_to_out_protocol(&self, o_prot: &mut dyn TOutputProtocol) -> thrift::Result<()> {
    o_prot.write_i32(self.0)
  }
  pub fn read_from_in_protocol(i_prot: &mut dyn TInputProtocol) -> thrift::Result<TReadType> {
    let enum_value = i_prot.read_i32()?;
    Ok(TReadType::from(enum_value))
  }
}

impl From<i32> for TReadType {
  fn from(i: i32) -> Self {
    match i {
      1 => TReadType::DEFAULT,
      2 => TReadType::STREAM,
      3 => TReadType::PREAD,
      _ => TReadType(i)
    }
  }
}

impl From<&i32> for TReadType {
  fn from(i: &i32) -> Self {
    TReadType::from(*i)
  }
}

impl From<TReadType> for i32 {
  fn from(e: TReadType) -> i32 {
    e.0
  }
}

impl From<&TReadType> for i32 {
  fn from(e: &TReadType) -> i32 {
    e.0
  }
}

/// Thrift wrapper around
/// org.apache.hadoop.hbase.CompareOperator.
#[derive(Copy, Clone, Debug, Eq, Hash, Ord, PartialEq, PartialOrd)]
pub struct TCompareOperator(pub i32);

impl TCompareOperator {
  pub const LESS: TCompareOperator = TCompareOperator(0);
  pub const LESS_OR_EQUAL: TCompareOperator = TCompareOperator(1);
  pub const EQUAL: TCompareOperator = TCompareOperator(2);
  pub const NOT_EQUAL: TCompareOperator = TCompareOperator(3);
  pub const GREATER_OR_EQUAL: TCompareOperator = TCompareOperator(4);
  pub const GREATER: TCompareOperator = TCompareOperator(5);
  pub const NO_OP: TCompareOperator = TCompareOperator(6);
  pub const ENUM_VALUES: &'static [Self] = &[
    Self::LESS,
    Self::LESS_OR_EQUAL,
    Self::EQUAL,
    Self::NOT_EQUAL,
    Self::GREATER_OR_EQUAL,
    Self::GREATER,
    Self::NO_OP,
  ];
  #[allow(clippy::trivially_copy_pass_by_ref)]
  pub fn write_to_out_protocol(&self, o_prot: &mut dyn TOutputProtocol) -> thrift::Result<()> {
    o_prot.write_i32(self.0)
  }
  pub fn read_from_in_protocol(i_prot: &mut dyn TInputProtocol) -> thrift::Result<TCompareOperator> {
    let enum_value = i_prot.read_i32()?;
    Ok(TCompareOperator::from(enum_value))
  }
}

impl From<i32> for TCompareOperator {
  fn from(i: i32) -> Self {
    match i {
      0 => TCompareOperator::LESS,
      1 => TCompareOperator::LESS_OR_EQUAL,
      2 => TCompareOperator::EQUAL,
      3 => TCompareOperator::NOT_EQUAL,
      4 => TCompareOperator::GREATER_OR_EQUAL,
      5 => TCompareOperator::GREATER,
      6 => TCompareOperator::NO_OP,
      _ => TCompareOperator(i)
    }
  }
}

impl From<&i32> for TCompareOperator {
  fn from(i: &i32) -> Self {
    TCompareOperator::from(*i)
  }
}

impl From<TCompareOperator> for i32 {
  fn from(e: TCompareOperator) -> i32 {
    e.0
  }
}

impl From<&TCompareOperator> for i32 {
  fn from(e: &TCompareOperator) -> i32 {
    e.0
  }
}

/// Thrift wrapper around
/// org.apache.hadoop.hbase.regionserver.BloomType
#[derive(Copy, Clone, Debug, Eq, Hash, Ord, PartialEq, PartialOrd)]
pub struct TBloomFilterType(pub i32);

impl TBloomFilterType {
  /// Bloomfilters disabled
  pub const NONE: TBloomFilterType = TBloomFilterType(0);
  /// Bloom enabled with Table row as Key
  pub const ROW: TBloomFilterType = TBloomFilterType(1);
  /// Bloom enabled with Table row &amp; column (family+qualifier) as Key
  pub const ROWCOL: TBloomFilterType = TBloomFilterType(2);
  /// Bloom enabled with Table row prefix as Key, specify the length of the prefix
  pub const ROWPREFIX_FIXED_LENGTH: TBloomFilterType = TBloomFilterType(3);
  pub const ENUM_VALUES: &'static [Self] = &[
    Self::NONE,
    Self::ROW,
    Self::ROWCOL,
    Self::ROWPREFIX_FIXED_LENGTH,
  ];
  #[allow(clippy::trivially_copy_pass_by_ref)]
  pub fn write_to_out_protocol(&self, o_prot: &mut dyn TOutputProtocol) -> thrift::Result<()> {
    o_prot.write_i32(self.0)
  }
  pub fn read_from_in_protocol(i_prot: &mut dyn TInputProtocol) -> thrift::Result<TBloomFilterType> {
    let enum_value = i_prot.read_i32()?;
    Ok(TBloomFilterType::from(enum_value))
  }
}

impl From<i32> for TBloomFilterType {
  fn from(i: i32) -> Self {
    match i {
      0 => TBloomFilterType::NONE,
      1 => TBloomFilterType::ROW,
      2 => TBloomFilterType::ROWCOL,
      3 => TBloomFilterType::ROWPREFIX_FIXED_LENGTH,
      _ => TBloomFilterType(i)
    }
  }
}

impl From<&i32> for TBloomFilterType {
  fn from(i: &i32) -> Self {
    TBloomFilterType::from(*i)
  }
}

impl From<TBloomFilterType> for i32 {
  fn from(e: TBloomFilterType) -> i32 {
    e.0
  }
}

impl From<&TBloomFilterType> for i32 {
  fn from(e: &TBloomFilterType) -> i32 {
    e.0
  }
}

/// Thrift wrapper around
/// org.apache.hadoop.hbase.io.compress.Algorithm
#[derive(Copy, Clone, Debug, Eq, Hash, Ord, PartialEq, PartialOrd)]
pub struct TCompressionAlgorithm(pub i32);

impl TCompressionAlgorithm {
  pub const LZO: TCompressionAlgorithm = TCompressionAlgorithm(0);
  pub const GZ: TCompressionAlgorithm = TCompressionAlgorithm(1);
  pub const NONE: TCompressionAlgorithm = TCompressionAlgorithm(2);
  pub const SNAPPY: TCompressionAlgorithm = TCompressionAlgorithm(3);
  pub const LZ4: TCompressionAlgorithm = TCompressionAlgorithm(4);
  pub const BZIP2: TCompressionAlgorithm = TCompressionAlgorithm(5);
  pub const ZSTD: TCompressionAlgorithm = TCompressionAlgorithm(6);
  pub const ENUM_VALUES: &'static [Self] = &[
    Self::LZO,
    Self::GZ,
    Self::NONE,
    Self::SNAPPY,
    Self::LZ4,
    Self::BZIP2,
    Self::ZSTD,
  ];
  #[allow(clippy::trivially_copy_pass_by_ref)]
  pub fn write_to_out_protocol(&self, o_prot: &mut dyn TOutputProtocol) -> thrift::Result<()> {
    o_prot.write_i32(self.0)
  }
  pub fn read_from_in_protocol(i_prot: &mut dyn TInputProtocol) -> thrift::Result<TCompressionAlgorithm> {
    let enum_value = i_prot.read_i32()?;
    Ok(TCompressionAlgorithm::from(enum_value))
  }
}

impl From<i32> for TCompressionAlgorithm {
  fn from(i: i32) -> Self {
    match i {
      0 => TCompressionAlgorithm::LZO,
      1 => TCompressionAlgorithm::GZ,
      2 => TCompressionAlgorithm::NONE,
      3 => TCompressionAlgorithm::SNAPPY,
      4 => TCompressionAlgorithm::LZ4,
      5 => TCompressionAlgorithm::BZIP2,
      6 => TCompressionAlgorithm::ZSTD,
      _ => TCompressionAlgorithm(i)
    }
  }
}

impl From<&i32> for TCompressionAlgorithm {
  fn from(i: &i32) -> Self {
    TCompressionAlgorithm::from(*i)
  }
}

impl From<TCompressionAlgorithm> for i32 {
  fn from(e: TCompressionAlgorithm) -> i32 {
    e.0
  }
}

impl From<&TCompressionAlgorithm> for i32 {
  fn from(e: &TCompressionAlgorithm) -> i32 {
    e.0
  }
}

/// Thrift wrapper around
/// org.apache.hadoop.hbase.io.encoding.DataBlockEncoding
#[derive(Copy, Clone, Debug, Eq, Hash, Ord, PartialEq, PartialOrd)]
pub struct TDataBlockEncoding(pub i32);

impl TDataBlockEncoding {
  /// Disable data block encoding.
  pub const NONE: TDataBlockEncoding = TDataBlockEncoding(0);
  pub const PREFIX: TDataBlockEncoding = TDataBlockEncoding(2);
  pub const DIFF: TDataBlockEncoding = TDataBlockEncoding(3);
  pub const FAST_DIFF: TDataBlockEncoding = TDataBlockEncoding(4);
  pub const ROW_INDEX_V1: TDataBlockEncoding = TDataBlockEncoding(7);
  pub const ENUM_VALUES: &'static [Self] = &[
    Self::NONE,
    Self::PREFIX,
    Self::DIFF,
    Self::FAST_DIFF,
    Self::ROW_INDEX_V1,
  ];
  #[allow(clippy::trivially_copy_pass_by_ref)]
  pub fn write_to_out_protocol(&self, o_prot: &mut dyn TOutputProtocol) -> thrift::Result<()> {
    o_prot.write_i32(self.0)
  }
  pub fn read_from_in_protocol(i_prot: &mut dyn TInputProtocol) -> thrift::Result<TDataBlockEncoding> {
    let enum_value = i_prot.read_i32()?;
    Ok(TDataBlockEncoding::from(enum_value))
  }
}

impl From<i32> for TDataBlockEncoding {
  fn from(i: i32) -> Self {
    match i {
      0 => TDataBlockEncoding::NONE,
      2 => TDataBlockEncoding::PREFIX,
      3 => TDataBlockEncoding::DIFF,
      4 => TDataBlockEncoding::FAST_DIFF,
      7 => TDataBlockEncoding::ROW_INDEX_V1,
      _ => TDataBlockEncoding(i)
    }
  }
}

impl From<&i32> for TDataBlockEncoding {
  fn from(i: &i32) -> Self {
    TDataBlockEncoding::from(*i)
  }
}

impl From<TDataBlockEncoding> for i32 {
  fn from(e: TDataBlockEncoding) -> i32 {
    e.0
  }
}

impl From<&TDataBlockEncoding> for i32 {
  fn from(e: &TDataBlockEncoding) -> i32 {
    e.0
  }
}

/// Thrift wrapper around
/// org.apache.hadoop.hbase.KeepDeletedCells
#[derive(Copy, Clone, Debug, Eq, Hash, Ord, PartialEq, PartialOrd)]
pub struct TKeepDeletedCells(pub i32);

impl TKeepDeletedCells {
  /// Deleted Cells are not retained.
  pub const FALSE: TKeepDeletedCells = TKeepDeletedCells(0);
  /// Deleted Cells are retained until they are removed by other means
  /// such TTL or VERSIONS.
  /// If no TTL is specified or no new versions of delete cells are
  /// written, they are retained forever.
  pub const TRUE: TKeepDeletedCells = TKeepDeletedCells(1);
  /// Deleted Cells are retained until the delete marker expires due to TTL.
  /// This is useful when TTL is combined with MIN_VERSIONS and one
  /// wants to keep a minimum number of versions around but at the same
  /// time remove deleted cells after the TTL.
  pub const TTL: TKeepDeletedCells = TKeepDeletedCells(2);
  pub const ENUM_VALUES: &'static [Self] = &[
    Self::FALSE,
    Self::TRUE,
    Self::TTL,
  ];
  #[allow(clippy::trivially_copy_pass_by_ref)]
  pub fn write_to_out_protocol(&self, o_prot: &mut dyn TOutputProtocol) -> thrift::Result<()> {
    o_prot.write_i32(self.0)
  }
  pub fn read_from_in_protocol(i_prot: &mut dyn TInputProtocol) -> thrift::Result<TKeepDeletedCells> {
    let enum_value = i_prot.read_i32()?;
    Ok(TKeepDeletedCells::from(enum_value))
  }
}

impl From<i32> for TKeepDeletedCells {
  fn from(i: i32) -> Self {
    match i {
      0 => TKeepDeletedCells::FALSE,
      1 => TKeepDeletedCells::TRUE,
      2 => TKeepDeletedCells::TTL,
      _ => TKeepDeletedCells(i)
    }
  }
}

impl From<&i32> for TKeepDeletedCells {
  fn from(i: &i32) -> Self {
    TKeepDeletedCells::from(*i)
  }
}

impl From<TKeepDeletedCells> for i32 {
  fn from(e: TKeepDeletedCells) -> i32 {
    e.0
  }
}

impl From<&TKeepDeletedCells> for i32 {
  fn from(e: &TKeepDeletedCells) -> i32 {
    e.0
  }
}

#[derive(Copy, Clone, Debug, Eq, Hash, Ord, PartialEq, PartialOrd)]
pub struct TLogType(pub i32);

impl TLogType {
  pub const SLOW_LOG: TLogType = TLogType(1);
  pub const LARGE_LOG: TLogType = TLogType(2);
  pub const ENUM_VALUES: &'static [Self] = &[
    Self::SLOW_LOG,
    Self::LARGE_LOG,
  ];
  #[allow(clippy::trivially_copy_pass_by_ref)]
  pub fn write_to_out_protocol(&self, o_prot: &mut dyn TOutputProtocol) -> thrift::Result<()> {
    o_prot.write_i32(self.0)
  }
  pub fn read_from_in_protocol(i_prot: &mut dyn TInputProtocol) -> thrift::Result<TLogType> {
    let enum_value = i_prot.read_i32()?;
    Ok(TLogType::from(enum_value))
  }
}

impl From<i32> for TLogType {
  fn from(i: i32) -> Self {
    match i {
      1 => TLogType::SLOW_LOG,
      2 => TLogType::LARGE_LOG,
      _ => TLogType(i)
    }
  }
}

impl From<&i32> for TLogType {
  fn from(i: &i32) -> Self {
    TLogType::from(*i)
  }
}

impl From<TLogType> for i32 {
  fn from(e: TLogType) -> i32 {
    e.0
  }
}

impl From<&TLogType> for i32 {
  fn from(e: &TLogType) -> i32 {
    e.0
  }
}

#[derive(Copy, Clone, Debug, Eq, Hash, Ord, PartialEq, PartialOrd)]
pub struct TFilterByOperator(pub i32);

impl TFilterByOperator {
  pub const AND: TFilterByOperator = TFilterByOperator(0);
  pub const OR: TFilterByOperator = TFilterByOperator(1);
  pub const ENUM_VALUES: &'static [Self] = &[
    Self::AND,
    Self::OR,
  ];
  #[allow(clippy::trivially_copy_pass_by_ref)]
  pub fn write_to_out_protocol(&self, o_prot: &mut dyn TOutputProtocol) -> thrift::Result<()> {
    o_prot.write_i32(self.0)
  }
  pub fn read_from_in_protocol(i_prot: &mut dyn TInputProtocol) -> thrift::Result<TFilterByOperator> {
    let enum_value = i_prot.read_i32()?;
    Ok(TFilterByOperator::from(enum_value))
  }
}

impl From<i32> for TFilterByOperator {
  fn from(i: i32) -> Self {
    match i {
      0 => TFilterByOperator::AND,
      1 => TFilterByOperator::OR,
      _ => TFilterByOperator(i)
    }
  }
}

impl From<&i32> for TFilterByOperator {
  fn from(i: &i32) -> Self {
    TFilterByOperator::from(*i)
  }
}

impl From<TFilterByOperator> for i32 {
  fn from(e: TFilterByOperator) -> i32 {
    e.0
  }
}

impl From<&TFilterByOperator> for i32 {
  fn from(e: &TFilterByOperator) -> i32 {
    e.0
  }
}

/// Specify type of thrift server: thrift and thrift2
#[derive(Copy, Clone, Debug, Eq, Hash, Ord, PartialEq, PartialOrd)]
pub struct TThriftServerType(pub i32);

impl TThriftServerType {
  pub const ONE: TThriftServerType = TThriftServerType(1);
  pub const TWO: TThriftServerType = TThriftServerType(2);
  pub const ENUM_VALUES: &'static [Self] = &[
    Self::ONE,
    Self::TWO,
  ];
  #[allow(clippy::trivially_copy_pass_by_ref)]
  pub fn write_to_out_protocol(&self, o_prot: &mut dyn TOutputProtocol) -> thrift::Result<()> {
    o_prot.write_i32(self.0)
  }
  pub fn read_from_in_protocol(i_prot: &mut dyn TInputProtocol) -> thrift::Result<TThriftServerType> {
    let enum_value = i_prot.read_i32()?;
    Ok(TThriftServerType::from(enum_value))
  }
}

impl From<i32> for TThriftServerType {
  fn from(i: i32) -> Self {
    match i {
      1 => TThriftServerType::ONE,
      2 => TThriftServerType::TWO,
      _ => TThriftServerType(i)
    }
  }
}

impl From<&i32> for TThriftServerType {
  fn from(i: &i32) -> Self {
    TThriftServerType::from(*i)
  }
}

impl From<TThriftServerType> for i32 {
  fn from(e: TThriftServerType) -> i32 {
    e.0
  }
}

impl From<&TThriftServerType> for i32 {
  fn from(e: &TThriftServerType) -> i32 {
    e.0
  }
}

#[derive(Copy, Clone, Debug, Eq, Hash, Ord, PartialEq, PartialOrd)]
pub struct TPermissionScope(pub i32);

impl TPermissionScope {
  pub const TABLE: TPermissionScope = TPermissionScope(0);
  pub const NAMESPACE: TPermissionScope = TPermissionScope(1);
  pub const ENUM_VALUES: &'static [Self] = &[
    Self::TABLE,
    Self::NAMESPACE,
  ];
  #[allow(clippy::trivially_copy_pass_by_ref)]
  pub fn write_to_out_protocol(&self, o_prot: &mut dyn TOutputProtocol) -> thrift::Result<()> {
    o_prot.write_i32(self.0)
  }
  pub fn read_from_in_protocol(i_prot: &mut dyn TInputProtocol) -> thrift::Result<TPermissionScope> {
    let enum_value = i_prot.read_i32()?;
    Ok(TPermissionScope::from(enum_value))
  }
}

impl From<i32> for TPermissionScope {
  fn from(i: i32) -> Self {
    match i {
      0 => TPermissionScope::TABLE,
      1 => TPermissionScope::NAMESPACE,
      _ => TPermissionScope(i)
    }
  }
}

impl From<&i32> for TPermissionScope {
  fn from(i: &i32) -> Self {
    TPermissionScope::from(*i)
  }
}

impl From<TPermissionScope> for i32 {
  fn from(e: TPermissionScope) -> i32 {
    e.0
  }
}

impl From<&TPermissionScope> for i32 {
  fn from(e: &TPermissionScope) -> i32 {
    e.0
  }
}

//
// TTimeRange
//

#[derive(Clone, Debug, Eq, Hash, Ord, PartialEq, PartialOrd)]
pub struct TTimeRange {
  pub min_stamp: i64,
  pub max_stamp: i64,
}

impl TTimeRange {
  pub fn new(min_stamp: i64, max_stamp: i64) -> TTimeRange {
    TTimeRange {
      min_stamp,
      max_stamp,
    }
  }
  pub fn read_from_in_protocol(i_prot: &mut dyn TInputProtocol) -> thrift::Result<TTimeRange> {
    i_prot.read_struct_begin()?;
    let mut f_1: Option<i64> = None;
    let mut f_2: Option<i64> = None;
    loop {
      let field_ident = i_prot.read_field_begin()?;
      if field_ident.field_type == TType::Stop {
        break;
      }
      let field_id = field_id(&field_ident)?;
      match field_id {
        1 => {
          let val = i_prot.read_i64()?;
          f_1 = Some(val);
        },
        2 => {
          let val = i_prot.read_i64()?;
          f_2 = Some(val);
        },
        _ => {
          i_prot.skip(field_ident.field_type)?;
        },
      };
      i_prot.read_field_end()?;
    }
    i_prot.read_struct_end()?;
    verify_required_field_exists("TTimeRange.min_stamp", &f_1)?;
    verify_required_field_exists("TTimeRange.max_stamp", &f_2)?;
    let ret = TTimeRange {
      min_stamp: f_1.expect("auto-generated code should have checked for presence of required fields"),
      max_stamp: f_2.expect("auto-generated code should have checked for presence of required fields"),
    };
    Ok(ret)
  }
  pub fn write_to_out_protocol(&self, o_prot: &mut dyn TOutputProtocol) -> thrift::Result<()> {
    let struct_ident = TStructIdentifier::new("TTimeRange");
    o_prot.write_struct_begin(&struct_ident)?;
    o_prot.write_field_begin(&TFieldIdentifier::new("minStamp", TType::I64, 1))?;
    o_prot.write_i64(self.min_stamp)?;
    o_prot.write_field_end()?;
    o_prot.write_field_begin(&TFieldIdentifier::new("maxStamp", TType::I64, 2))?;
    o_prot.write_i64(self.max_stamp)?;
    o_prot.write_field_end()?;
    o_prot.write_field_stop()?;
    o_prot.write_struct_end()
  }
}

//
// TColumn
//

/// Addresses a single cell or multiple cells
/// in a HBase table by column family and optionally
/// a column qualifier and timestamp
#[derive(Clone, Debug, Eq, Hash, Ord, PartialEq, PartialOrd)]
pub struct TColumn {
  pub family: Vec<u8>,
  pub qualifier: Option<Vec<u8>>,
  pub timestamp: Option<i64>,
}

impl TColumn {
  pub fn new<F2, F3>(family: Vec<u8>, qualifier: F2, timestamp: F3) -> TColumn where F2: Into<Option<Vec<u8>>>, F3: Into<Option<i64>> {
    TColumn {
      family,
      qualifier: qualifier.into(),
      timestamp: timestamp.into(),
    }
  }
  pub fn read_from_in_protocol(i_prot: &mut dyn TInputProtocol) -> thrift::Result<TColumn> {
    i_prot.read_struct_begin()?;
    let mut f_1: Option<Vec<u8>> = None;
    let mut f_2: Option<Vec<u8>> = None;
    let mut f_3: Option<i64> = None;
    loop {
      let field_ident = i_prot.read_field_begin()?;
      if field_ident.field_type == TType::Stop {
        break;
      }
      let field_id = field_id(&field_ident)?;
      match field_id {
        1 => {
          let val = i_prot.read_bytes()?;
          f_1 = Some(val);
        },
        2 => {
          let val = i_prot.read_bytes()?;
          f_2 = Some(val);
        },
        3 => {
          let val = i_prot.read_i64()?;
          f_3 = Some(val);
        },
        _ => {
          i_prot.skip(field_ident.field_type)?;
        },
      };
      i_prot.read_field_end()?;
    }
    i_prot.read_struct_end()?;
    verify_required_field_exists("TColumn.family", &f_1)?;
    let ret = TColumn {
      family: f_1.expect("auto-generated code should have checked for presence of required fields"),
      qualifier: f_2,
      timestamp: f_3,
    };
    Ok(ret)
  }
  pub fn write_to_out_protocol(&self, o_prot: &mut dyn TOutputProtocol) -> thrift::Result<()> {
    let struct_ident = TStructIdentifier::new("TColumn");
    o_prot.write_struct_begin(&struct_ident)?;
    o_prot.write_field_begin(&TFieldIdentifier::new("family", TType::String, 1))?;
    o_prot.write_bytes(&self.family)?;
    o_prot.write_field_end()?;
    if let Some(ref fld_var) = self.qualifier {
      o_prot.write_field_begin(&TFieldIdentifier::new("qualifier", TType::String, 2))?;
      o_prot.write_bytes(fld_var)?;
      o_prot.write_field_end()?
    }
    if let Some(fld_var) = self.timestamp {
      o_prot.write_field_begin(&TFieldIdentifier::new("timestamp", TType::I64, 3))?;
      o_prot.write_i64(fld_var)?;
      o_prot.write_field_end()?
    }
    o_prot.write_field_stop()?;
    o_prot.write_struct_end()
  }
}

//
// TColumnValue
//

/// Represents a single cell and its value.
#[derive(Clone, Debug, Eq, Hash, Ord, PartialEq, PartialOrd)]
pub struct TColumnValue {
  pub family: Vec<u8>,
  pub qualifier: Vec<u8>,
  pub value: Vec<u8>,
  pub timestamp: Option<i64>,
  pub tags: Option<Vec<u8>>,
  pub type_: Option<i8>,
}

impl TColumnValue {
  pub fn new<F4, F5, F6>(family: Vec<u8>, qualifier: Vec<u8>, value: Vec<u8>, timestamp: F4, tags: F5, type_: F6) -> TColumnValue where F4: Into<Option<i64>>, F5: Into<Option<Vec<u8>>>, F6: Into<Option<i8>> {
    TColumnValue {
      family,
      qualifier,
      value,
      timestamp: timestamp.into(),
      tags: tags.into(),
      type_: type_.into(),
    }
  }
  pub fn read_from_in_protocol(i_prot: &mut dyn TInputProtocol) -> thrift::Result<TColumnValue> {
    i_prot.read_struct_begin()?;
    let mut f_1: Option<Vec<u8>> = None;
    let mut f_2: Option<Vec<u8>> = None;
    let mut f_3: Option<Vec<u8>> = None;
    let mut f_4: Option<i64> = None;
    let mut f_5: Option<Vec<u8>> = None;
    let mut f_6: Option<i8> = None;
    loop {
      let field_ident = i_prot.read_field_begin()?;
      if field_ident.field_type == TType::Stop {
        break;
      }
      let field_id = field_id(&field_ident)?;
      match field_id {
        1 => {
          let val = i_prot.read_bytes()?;
          f_1 = Some(val);
        },
        2 => {
          let val = i_prot.read_bytes()?;
          f_2 = Some(val);
        },
        3 => {
          let val = i_prot.read_bytes()?;
          f_3 = Some(val);
        },
        4 => {
          let val = i_prot.read_i64()?;
          f_4 = Some(val);
        },
        5 => {
          let val = i_prot.read_bytes()?;
          f_5 = Some(val);
        },
        6 => {
          let val = i_prot.read_i8()?;
          f_6 = Some(val);
        },
        _ => {
          i_prot.skip(field_ident.field_type)?;
        },
      };
      i_prot.read_field_end()?;
    }
    i_prot.read_struct_end()?;
    verify_required_field_exists("TColumnValue.family", &f_1)?;
    verify_required_field_exists("TColumnValue.qualifier", &f_2)?;
    verify_required_field_exists("TColumnValue.value", &f_3)?;
    let ret = TColumnValue {
      family: f_1.expect("auto-generated code should have checked for presence of required fields"),
      qualifier: f_2.expect("auto-generated code should have checked for presence of required fields"),
      value: f_3.expect("auto-generated code should have checked for presence of required fields"),
      timestamp: f_4,
      tags: f_5,
      type_: f_6,
    };
    Ok(ret)
  }
  pub fn write_to_out_protocol(&self, o_prot: &mut dyn TOutputProtocol) -> thrift::Result<()> {
    let struct_ident = TStructIdentifier::new("TColumnValue");
    o_prot.write_struct_begin(&struct_ident)?;
    o_prot.write_field_begin(&TFieldIdentifier::new("family", TType::String, 1))?;
    o_prot.write_bytes(&self.family)?;
    o_prot.write_field_end()?;
    o_prot.write_field_begin(&TFieldIdentifier::new("qualifier", TType::String, 2))?;
    o_prot.write_bytes(&self.qualifier)?;
    o_prot.write_field_end()?;
    o_prot.write_field_begin(&TFieldIdentifier::new("value", TType::String, 3))?;
    o_prot.write_bytes(&self.value)?;
    o_prot.write_field_end()?;
    if let Some(fld_var) = self.timestamp {
      o_prot.write_field_begin(&TFieldIdentifier::new("timestamp", TType::I64, 4))?;
      o_prot.write_i64(fld_var)?;
      o_prot.write_field_end()?
    }
    if let Some(ref fld_var) = self.tags {
      o_prot.write_field_begin(&TFieldIdentifier::new("tags", TType::String, 5))?;
      o_prot.write_bytes(fld_var)?;
      o_prot.write_field_end()?
    }
    if let Some(fld_var) = self.type_ {
      o_prot.write_field_begin(&TFieldIdentifier::new("type", TType::I08, 6))?;
      o_prot.write_i8(fld_var)?;
      o_prot.write_field_end()?
    }
    o_prot.write_field_stop()?;
    o_prot.write_struct_end()
  }
}

//
// TColumnIncrement
//

/// Represents a single cell and the amount to increment it by
#[derive(Clone, Debug, Eq, Hash, Ord, PartialEq, PartialOrd)]
pub struct TColumnIncrement {
  pub family: Vec<u8>,
  pub qualifier: Vec<u8>,
  pub amount: Option<i64>,
}

impl TColumnIncrement {
  pub fn new<F3>(family: Vec<u8>, qualifier: Vec<u8>, amount: F3) -> TColumnIncrement where F3: Into<Option<i64>> {
    TColumnIncrement {
      family,
      qualifier,
      amount: amount.into(),
    }
  }
  pub fn read_from_in_protocol(i_prot: &mut dyn TInputProtocol) -> thrift::Result<TColumnIncrement> {
    i_prot.read_struct_begin()?;
    let mut f_1: Option<Vec<u8>> = None;
    let mut f_2: Option<Vec<u8>> = None;
    let mut f_3: Option<i64> = None;
    loop {
      let field_ident = i_prot.read_field_begin()?;
      if field_ident.field_type == TType::Stop {
        break;
      }
      let field_id = field_id(&field_ident)?;
      match field_id {
        1 => {
          let val = i_prot.read_bytes()?;
          f_1 = Some(val);
        },
        2 => {
          let val = i_prot.read_bytes()?;
          f_2 = Some(val);
        },
        3 => {
          let val = i_prot.read_i64()?;
          f_3 = Some(val);
        },
        _ => {
          i_prot.skip(field_ident.field_type)?;
        },
      };
      i_prot.read_field_end()?;
    }
    i_prot.read_struct_end()?;
    verify_required_field_exists("TColumnIncrement.family", &f_1)?;
    verify_required_field_exists("TColumnIncrement.qualifier", &f_2)?;
    let ret = TColumnIncrement {
      family: f_1.expect("auto-generated code should have checked for presence of required fields"),
      qualifier: f_2.expect("auto-generated code should have checked for presence of required fields"),
      amount: f_3,
    };
    Ok(ret)
  }
  pub fn write_to_out_protocol(&self, o_prot: &mut dyn TOutputProtocol) -> thrift::Result<()> {
    let struct_ident = TStructIdentifier::new("TColumnIncrement");
    o_prot.write_struct_begin(&struct_ident)?;
    o_prot.write_field_begin(&TFieldIdentifier::new("family", TType::String, 1))?;
    o_prot.write_bytes(&self.family)?;
    o_prot.write_field_end()?;
    o_prot.write_field_begin(&TFieldIdentifier::new("qualifier", TType::String, 2))?;
    o_prot.write_bytes(&self.qualifier)?;
    o_prot.write_field_end()?;
    if let Some(fld_var) = self.amount {
      o_prot.write_field_begin(&TFieldIdentifier::new("amount", TType::I64, 3))?;
      o_prot.write_i64(fld_var)?;
      o_prot.write_field_end()?
    }
    o_prot.write_field_stop()?;
    o_prot.write_struct_end()
  }
}

//
// TResult
//

/// if no Result is found, row and columnValues will not be set.
#[derive(Clone, Debug, Eq, Hash, Ord, PartialEq, PartialOrd)]
pub struct TResult {
  pub row: Option<Vec<u8>>,
  pub column_values: Vec<TColumnValue>,
  pub stale: Option<bool>,
  pub partial: Option<bool>,
}

impl TResult {
  pub fn new<F1, F3, F4>(row: F1, column_values: Vec<TColumnValue>, stale: F3, partial: F4) -> TResult where F1: Into<Option<Vec<u8>>>, F3: Into<Option<bool>>, F4: Into<Option<bool>> {
    TResult {
      row: row.into(),
      column_values,
      stale: stale.into(),
      partial: partial.into(),
    }
  }
  pub fn read_from_in_protocol(i_prot: &mut dyn TInputProtocol) -> thrift::Result<TResult> {
    i_prot.read_struct_begin()?;
    let mut f_1: Option<Vec<u8>> = None;
    let mut f_2: Option<Vec<TColumnValue>> = None;
    let mut f_3: Option<bool> = None;
    let mut f_4: Option<bool> = None;
    loop {
      let field_ident = i_prot.read_field_begin()?;
      if field_ident.field_type == TType::Stop {
        break;
      }
      let field_id = field_id(&field_ident)?;
      match field_id {
        1 => {
          let val = i_prot.read_bytes()?;
          f_1 = Some(val);
        },
        2 => {
          let list_ident = i_prot.read_list_begin()?;
          let mut val: Vec<TColumnValue> = Vec::with_capacity(list_ident.size as usize);
          for _ in 0..list_ident.size {
            let list_elem_0 = TColumnValue::read_from_in_protocol(i_prot)?;
            val.push(list_elem_0);
          }
          i_prot.read_list_end()?;
          f_2 = Some(val);
        },
        3 => {
          let val = i_prot.read_bool()?;
          f_3 = Some(val);
        },
        4 => {
          let val = i_prot.read_bool()?;
          f_4 = Some(val);
        },
        _ => {
          i_prot.skip(field_ident.field_type)?;
        },
      };
      i_prot.read_field_end()?;
    }
    i_prot.read_struct_end()?;
    verify_required_field_exists("TResult.column_values", &f_2)?;
    let ret = TResult {
      row: f_1,
      column_values: f_2.expect("auto-generated code should have checked for presence of required fields"),
      stale: f_3,
      partial: f_4,
    };
    Ok(ret)
  }
  pub fn write_to_out_protocol(&self, o_prot: &mut dyn TOutputProtocol) -> thrift::Result<()> {
    let struct_ident = TStructIdentifier::new("TResult");
    o_prot.write_struct_begin(&struct_ident)?;
    if let Some(ref fld_var) = self.row {
      o_prot.write_field_begin(&TFieldIdentifier::new("row", TType::String, 1))?;
      o_prot.write_bytes(fld_var)?;
      o_prot.write_field_end()?
    }
    o_prot.write_field_begin(&TFieldIdentifier::new("columnValues", TType::List, 2))?;
    o_prot.write_list_begin(&TListIdentifier::new(TType::Struct, self.column_values.len() as i32))?;
    for e in &self.column_values {
      e.write_to_out_protocol(o_prot)?;
    }
    o_prot.write_list_end()?;
    o_prot.write_field_end()?;
    if let Some(fld_var) = self.stale {
      o_prot.write_field_begin(&TFieldIdentifier::new("stale", TType::Bool, 3))?;
      o_prot.write_bool(fld_var)?;
      o_prot.write_field_end()?
    }
    if let Some(fld_var) = self.partial {
      o_prot.write_field_begin(&TFieldIdentifier::new("partial", TType::Bool, 4))?;
      o_prot.write_bool(fld_var)?;
      o_prot.write_field_end()?
    }
    o_prot.write_field_stop()?;
    o_prot.write_struct_end()
  }
}

//
// TAuthorization
//

#[derive(Clone, Debug, Eq, Hash, Ord, PartialEq, PartialOrd)]
pub struct TAuthorization {
  pub labels: Option<Vec<String>>,
}

impl TAuthorization {
  pub fn new<F1>(labels: F1) -> TAuthorization where F1: Into<Option<Vec<String>>> {
    TAuthorization {
      labels: labels.into(),
    }
  }
  pub fn read_from_in_protocol(i_prot: &mut dyn TInputProtocol) -> thrift::Result<TAuthorization> {
    i_prot.read_struct_begin()?;
    let mut f_1: Option<Vec<String>> = None;
    loop {
      let field_ident = i_prot.read_field_begin()?;
      if field_ident.field_type == TType::Stop {
        break;
      }
      let field_id = field_id(&field_ident)?;
      match field_id {
        1 => {
          let list_ident = i_prot.read_list_begin()?;
          let mut val: Vec<String> = Vec::with_capacity(list_ident.size as usize);
          for _ in 0..list_ident.size {
            let list_elem_1 = i_prot.read_string()?;
            val.push(list_elem_1);
          }
          i_prot.read_list_end()?;
          f_1 = Some(val);
        },
        _ => {
          i_prot.skip(field_ident.field_type)?;
        },
      };
      i_prot.read_field_end()?;
    }
    i_prot.read_struct_end()?;
    let ret = TAuthorization {
      labels: f_1,
    };
    Ok(ret)
  }
  pub fn write_to_out_protocol(&self, o_prot: &mut dyn TOutputProtocol) -> thrift::Result<()> {
    let struct_ident = TStructIdentifier::new("TAuthorization");
    o_prot.write_struct_begin(&struct_ident)?;
    if let Some(ref fld_var) = self.labels {
      o_prot.write_field_begin(&TFieldIdentifier::new("labels", TType::List, 1))?;
      o_prot.write_list_begin(&TListIdentifier::new(TType::String, fld_var.len() as i32))?;
      for e in fld_var {
        o_prot.write_string(e)?;
      }
      o_prot.write_list_end()?;
      o_prot.write_field_end()?
    }
    o_prot.write_field_stop()?;
    o_prot.write_struct_end()
  }
}

impl Default for TAuthorization {
  fn default() -> Self {
    TAuthorization{
      labels: Some(Vec::new()),
    }
  }
}

//
// TCellVisibility
//

#[derive(Clone, Debug, Eq, Hash, Ord, PartialEq, PartialOrd)]
pub struct TCellVisibility {
  pub expression: Option<String>,
}

impl TCellVisibility {
  pub fn new<F1>(expression: F1) -> TCellVisibility where F1: Into<Option<String>> {
    TCellVisibility {
      expression: expression.into(),
    }
  }
  pub fn read_from_in_protocol(i_prot: &mut dyn TInputProtocol) -> thrift::Result<TCellVisibility> {
    i_prot.read_struct_begin()?;
    let mut f_1: Option<String> = None;
    loop {
      let field_ident = i_prot.read_field_begin()?;
      if field_ident.field_type == TType::Stop {
        break;
      }
      let field_id = field_id(&field_ident)?;
      match field_id {
        1 => {
          let val = i_prot.read_string()?;
          f_1 = Some(val);
        },
        _ => {
          i_prot.skip(field_ident.field_type)?;
        },
      };
      i_prot.read_field_end()?;
    }
    i_prot.read_struct_end()?;
    let ret = TCellVisibility {
      expression: f_1,
    };
    Ok(ret)
  }
  pub fn write_to_out_protocol(&self, o_prot: &mut dyn TOutputProtocol) -> thrift::Result<()> {
    let struct_ident = TStructIdentifier::new("TCellVisibility");
    o_prot.write_struct_begin(&struct_ident)?;
    if let Some(ref fld_var) = self.expression {
      o_prot.write_field_begin(&TFieldIdentifier::new("expression", TType::String, 1))?;
      o_prot.write_string(fld_var)?;
      o_prot.write_field_end()?
    }
    o_prot.write_field_stop()?;
    o_prot.write_struct_end()
  }
}

impl Default for TCellVisibility {
  fn default() -> Self {
    TCellVisibility{
      expression: Some("".to_owned()),
    }
  }
}

//
// TGet
//

/// Used to perform Get operations on a single row.
/// 
/// The scope can be further narrowed down by specifying a list of
/// columns or column families.
/// 
/// To get everything for a row, instantiate a Get object with just the row to get.
/// To further define the scope of what to get you can add a timestamp or time range
/// with an optional maximum number of versions to return.
/// 
/// If you specify a time range and a timestamp the range is ignored.
/// Timestamps on TColumns are ignored.
#[derive(Clone, Debug, Eq, Hash, Ord, PartialEq, PartialOrd)]
pub struct TGet {
  pub row: Vec<u8>,
  pub columns: Option<Vec<TColumn>>,
  pub timestamp: Option<i64>,
  pub time_range: Option<TTimeRange>,
  pub max_versions: Option<i32>,
  pub filter_string: Option<Vec<u8>>,
  pub attributes: Option<BTreeMap<Vec<u8>, Vec<u8>>>,
  pub authorizations: Option<TAuthorization>,
  pub consistency: Option<TConsistency>,
  pub target_replica_id: Option<i32>,
  pub cache_blocks: Option<bool>,
  pub store_limit: Option<i32>,
  pub store_offset: Option<i32>,
  pub existence_only: Option<bool>,
  pub filter_bytes: Option<Vec<u8>>,
}

impl TGet {
  pub fn new<F2, F3, F4, F5, F6, F7, F8, F9, F10, F11, F12, F13, F14, F15>(row: Vec<u8>, columns: F2, timestamp: F3, time_range: F4, max_versions: F5, filter_string: F6, attributes: F7, authorizations: F8, consistency: F9, target_replica_id: F10, cache_blocks: F11, store_limit: F12, store_offset: F13, existence_only: F14, filter_bytes: F15) -> TGet where F2: Into<Option<Vec<TColumn>>>, F3: Into<Option<i64>>, F4: Into<Option<TTimeRange>>, F5: Into<Option<i32>>, F6: Into<Option<Vec<u8>>>, F7: Into<Option<BTreeMap<Vec<u8>, Vec<u8>>>>, F8: Into<Option<TAuthorization>>, F9: Into<Option<TConsistency>>, F10: Into<Option<i32>>, F11: Into<Option<bool>>, F12: Into<Option<i32>>, F13: Into<Option<i32>>, F14: Into<Option<bool>>, F15: Into<Option<Vec<u8>>> {
    TGet {
      row,
      columns: columns.into(),
      timestamp: timestamp.into(),
      time_range: time_range.into(),
      max_versions: max_versions.into(),
      filter_string: filter_string.into(),
      attributes: attributes.into(),
      authorizations: authorizations.into(),
      consistency: consistency.into(),
      target_replica_id: target_replica_id.into(),
      cache_blocks: cache_blocks.into(),
      store_limit: store_limit.into(),
      store_offset: store_offset.into(),
      existence_only: existence_only.into(),
      filter_bytes: filter_bytes.into(),
    }
  }
  pub fn read_from_in_protocol(i_prot: &mut dyn TInputProtocol) -> thrift::Result<TGet> {
    i_prot.read_struct_begin()?;
    let mut f_1: Option<Vec<u8>> = None;
    let mut f_2: Option<Vec<TColumn>> = None;
    let mut f_3: Option<i64> = None;
    let mut f_4: Option<TTimeRange> = None;
    let mut f_5: Option<i32> = None;
    let mut f_6: Option<Vec<u8>> = None;
    let mut f_7: Option<BTreeMap<Vec<u8>, Vec<u8>>> = None;
    let mut f_8: Option<TAuthorization> = None;
    let mut f_9: Option<TConsistency> = None;
    let mut f_10: Option<i32> = None;
    let mut f_11: Option<bool> = None;
    let mut f_12: Option<i32> = None;
    let mut f_13: Option<i32> = None;
    let mut f_14: Option<bool> = None;
    let mut f_15: Option<Vec<u8>> = None;
    loop {
      let field_ident = i_prot.read_field_begin()?;
      if field_ident.field_type == TType::Stop {
        break;
      }
      let field_id = field_id(&field_ident)?;
      match field_id {
        1 => {
          let val = i_prot.read_bytes()?;
          f_1 = Some(val);
        },
        2 => {
          let list_ident = i_prot.read_list_begin()?;
          let mut val: Vec<TColumn> = Vec::with_capacity(list_ident.size as usize);
          for _ in 0..list_ident.size {
            let list_elem_2 = TColumn::read_from_in_protocol(i_prot)?;
            val.push(list_elem_2);
          }
          i_prot.read_list_end()?;
          f_2 = Some(val);
        },
        3 => {
          let val = i_prot.read_i64()?;
          f_3 = Some(val);
        },
        4 => {
          let val = TTimeRange::read_from_in_protocol(i_prot)?;
          f_4 = Some(val);
        },
        5 => {
          let val = i_prot.read_i32()?;
          f_5 = Some(val);
        },
        6 => {
          let val = i_prot.read_bytes()?;
          f_6 = Some(val);
        },
        7 => {
          let map_ident = i_prot.read_map_begin()?;
          let mut val: BTreeMap<Vec<u8>, Vec<u8>> = BTreeMap::new();
          for _ in 0..map_ident.size {
            let map_key_3 = i_prot.read_bytes()?;
            let map_val_4 = i_prot.read_bytes()?;
            val.insert(map_key_3, map_val_4);
          }
          i_prot.read_map_end()?;
          f_7 = Some(val);
        },
        8 => {
          let val = TAuthorization::read_from_in_protocol(i_prot)?;
          f_8 = Some(val);
        },
        9 => {
          let val = TConsistency::read_from_in_protocol(i_prot)?;
          f_9 = Some(val);
        },
        10 => {
          let val = i_prot.read_i32()?;
          f_10 = Some(val);
        },
        11 => {
          let val = i_prot.read_bool()?;
          f_11 = Some(val);
        },
        12 => {
          let val = i_prot.read_i32()?;
          f_12 = Some(val);
        },
        13 => {
          let val = i_prot.read_i32()?;
          f_13 = Some(val);
        },
        14 => {
          let val = i_prot.read_bool()?;
          f_14 = Some(val);
        },
        15 => {
          let val = i_prot.read_bytes()?;
          f_15 = Some(val);
        },
        _ => {
          i_prot.skip(field_ident.field_type)?;
        },
      };
      i_prot.read_field_end()?;
    }
    i_prot.read_struct_end()?;
    verify_required_field_exists("TGet.row", &f_1)?;
    let ret = TGet {
      row: f_1.expect("auto-generated code should have checked for presence of required fields"),
      columns: f_2,
      timestamp: f_3,
      time_range: f_4,
      max_versions: f_5,
      filter_string: f_6,
      attributes: f_7,
      authorizations: f_8,
      consistency: f_9,
      target_replica_id: f_10,
      cache_blocks: f_11,
      store_limit: f_12,
      store_offset: f_13,
      existence_only: f_14,
      filter_bytes: f_15,
    };
    Ok(ret)
  }
  pub fn write_to_out_protocol(&self, o_prot: &mut dyn TOutputProtocol) -> thrift::Result<()> {
    let struct_ident = TStructIdentifier::new("TGet");
    o_prot.write_struct_begin(&struct_ident)?;
    o_prot.write_field_begin(&TFieldIdentifier::new("row", TType::String, 1))?;
    o_prot.write_bytes(&self.row)?;
    o_prot.write_field_end()?;
    if let Some(ref fld_var) = self.columns {
      o_prot.write_field_begin(&TFieldIdentifier::new("columns", TType::List, 2))?;
      o_prot.write_list_begin(&TListIdentifier::new(TType::Struct, fld_var.len() as i32))?;
      for e in fld_var {
        e.write_to_out_protocol(o_prot)?;
      }
      o_prot.write_list_end()?;
      o_prot.write_field_end()?
    }
    if let Some(fld_var) = self.timestamp {
      o_prot.write_field_begin(&TFieldIdentifier::new("timestamp", TType::I64, 3))?;
      o_prot.write_i64(fld_var)?;
      o_prot.write_field_end()?
    }
    if let Some(ref fld_var) = self.time_range {
      o_prot.write_field_begin(&TFieldIdentifier::new("timeRange", TType::Struct, 4))?;
      fld_var.write_to_out_protocol(o_prot)?;
      o_prot.write_field_end()?
    }
    if let Some(fld_var) = self.max_versions {
      o_prot.write_field_begin(&TFieldIdentifier::new("maxVersions", TType::I32, 5))?;
      o_prot.write_i32(fld_var)?;
      o_prot.write_field_end()?
    }
    if let Some(ref fld_var) = self.filter_string {
      o_prot.write_field_begin(&TFieldIdentifier::new("filterString", TType::String, 6))?;
      o_prot.write_bytes(fld_var)?;
      o_prot.write_field_end()?
    }
    if let Some(ref fld_var) = self.attributes {
      o_prot.write_field_begin(&TFieldIdentifier::new("attributes", TType::Map, 7))?;
      o_prot.write_map_begin(&TMapIdentifier::new(TType::String, TType::String, fld_var.len() as i32))?;
      for (k, v) in fld_var {
        o_prot.write_bytes(k)?;
        o_prot.write_bytes(v)?;
      }
      o_prot.write_map_end()?;
      o_prot.write_field_end()?
    }
    if let Some(ref fld_var) = self.authorizations {
      o_prot.write_field_begin(&TFieldIdentifier::new("authorizations", TType::Struct, 8))?;
      fld_var.write_to_out_protocol(o_prot)?;
      o_prot.write_field_end()?
    }
    if let Some(ref fld_var) = self.consistency {
      o_prot.write_field_begin(&TFieldIdentifier::new("consistency", TType::I32, 9))?;
      fld_var.write_to_out_protocol(o_prot)?;
      o_prot.write_field_end()?
    }
    if let Some(fld_var) = self.target_replica_id {
      o_prot.write_field_begin(&TFieldIdentifier::new("targetReplicaId", TType::I32, 10))?;
      o_prot.write_i32(fld_var)?;
      o_prot.write_field_end()?
    }
    if let Some(fld_var) = self.cache_blocks {
      o_prot.write_field_begin(&TFieldIdentifier::new("cacheBlocks", TType::Bool, 11))?;
      o_prot.write_bool(fld_var)?;
      o_prot.write_field_end()?
    }
    if let Some(fld_var) = self.store_limit {
      o_prot.write_field_begin(&TFieldIdentifier::new("storeLimit", TType::I32, 12))?;
      o_prot.write_i32(fld_var)?;
      o_prot.write_field_end()?
    }
    if let Some(fld_var) = self.store_offset {
      o_prot.write_field_begin(&TFieldIdentifier::new("storeOffset", TType::I32, 13))?;
      o_prot.write_i32(fld_var)?;
      o_prot.write_field_end()?
    }
    if let Some(fld_var) = self.existence_only {
      o_prot.write_field_begin(&TFieldIdentifier::new("existence_only", TType::Bool, 14))?;
      o_prot.write_bool(fld_var)?;
      o_prot.write_field_end()?
    }
    if let Some(ref fld_var) = self.filter_bytes {
      o_prot.write_field_begin(&TFieldIdentifier::new("filterBytes", TType::String, 15))?;
      o_prot.write_bytes(fld_var)?;
      o_prot.write_field_end()?
    }
    o_prot.write_field_stop()?;
    o_prot.write_struct_end()
  }
}

//
// TPut
//

/// Used to perform Put operations for a single row.
/// 
/// Add column values to this object and they'll be added.
/// You can provide a default timestamp if the column values
/// don't have one. If you don't provide a default timestamp
/// the current time is inserted.
/// 
/// You can specify how this Put should be written to the write-ahead Log (WAL)
/// by changing the durability. If you don't provide durability, it defaults to
/// column family's default setting for durability.
#[derive(Clone, Debug, Eq, Hash, Ord, PartialEq, PartialOrd)]
pub struct TPut {
  pub row: Vec<u8>,
  pub column_values: Vec<TColumnValue>,
  pub timestamp: Option<i64>,
  pub attributes: Option<BTreeMap<Vec<u8>, Vec<u8>>>,
  pub durability: Option<TDurability>,
  pub cell_visibility: Option<TCellVisibility>,
}

impl TPut {
  pub fn new<F3, F5, F6, F7>(row: Vec<u8>, column_values: Vec<TColumnValue>, timestamp: F3, attributes: F5, durability: F6, cell_visibility: F7) -> TPut where F3: Into<Option<i64>>, F5: Into<Option<BTreeMap<Vec<u8>, Vec<u8>>>>, F6: Into<Option<TDurability>>, F7: Into<Option<TCellVisibility>> {
    TPut {
      row,
      column_values,
      timestamp: timestamp.into(),
      attributes: attributes.into(),
      durability: durability.into(),
      cell_visibility: cell_visibility.into(),
    }
  }
  pub fn read_from_in_protocol(i_prot: &mut dyn TInputProtocol) -> thrift::Result<TPut> {
    i_prot.read_struct_begin()?;
    let mut f_1: Option<Vec<u8>> = None;
    let mut f_2: Option<Vec<TColumnValue>> = None;
    let mut f_3: Option<i64> = None;
    let mut f_5: Option<BTreeMap<Vec<u8>, Vec<u8>>> = None;
    let mut f_6: Option<TDurability> = None;
    let mut f_7: Option<TCellVisibility> = None;
    loop {
      let field_ident = i_prot.read_field_begin()?;
      if field_ident.field_type == TType::Stop {
        break;
      }
      let field_id = field_id(&field_ident)?;
      match field_id {
        1 => {
          let val = i_prot.read_bytes()?;
          f_1 = Some(val);
        },
        2 => {
          let list_ident = i_prot.read_list_begin()?;
          let mut val: Vec<TColumnValue> = Vec::with_capacity(list_ident.size as usize);
          for _ in 0..list_ident.size {
            let list_elem_5 = TColumnValue::read_from_in_protocol(i_prot)?;
            val.push(list_elem_5);
          }
          i_prot.read_list_end()?;
          f_2 = Some(val);
        },
        3 => {
          let val = i_prot.read_i64()?;
          f_3 = Some(val);
        },
        5 => {
          let map_ident = i_prot.read_map_begin()?;
          let mut val: BTreeMap<Vec<u8>, Vec<u8>> = BTreeMap::new();
          for _ in 0..map_ident.size {
            let map_key_6 = i_prot.read_bytes()?;
            let map_val_7 = i_prot.read_bytes()?;
            val.insert(map_key_6, map_val_7);
          }
          i_prot.read_map_end()?;
          f_5 = Some(val);
        },
        6 => {
          let val = TDurability::read_from_in_protocol(i_prot)?;
          f_6 = Some(val);
        },
        7 => {
          let val = TCellVisibility::read_from_in_protocol(i_prot)?;
          f_7 = Some(val);
        },
        _ => {
          i_prot.skip(field_ident.field_type)?;
        },
      };
      i_prot.read_field_end()?;
    }
    i_prot.read_struct_end()?;
    verify_required_field_exists("TPut.row", &f_1)?;
    verify_required_field_exists("TPut.column_values", &f_2)?;
    let ret = TPut {
      row: f_1.expect("auto-generated code should have checked for presence of required fields"),
      column_values: f_2.expect("auto-generated code should have checked for presence of required fields"),
      timestamp: f_3,
      attributes: f_5,
      durability: f_6,
      cell_visibility: f_7,
    };
    Ok(ret)
  }
  pub fn write_to_out_protocol(&self, o_prot: &mut dyn TOutputProtocol) -> thrift::Result<()> {
    let struct_ident = TStructIdentifier::new("TPut");
    o_prot.write_struct_begin(&struct_ident)?;
    o_prot.write_field_begin(&TFieldIdentifier::new("row", TType::String, 1))?;
    o_prot.write_bytes(&self.row)?;
    o_prot.write_field_end()?;
    o_prot.write_field_begin(&TFieldIdentifier::new("columnValues", TType::List, 2))?;
    o_prot.write_list_begin(&TListIdentifier::new(TType::Struct, self.column_values.len() as i32))?;
    for e in &self.column_values {
      e.write_to_out_protocol(o_prot)?;
    }
    o_prot.write_list_end()?;
    o_prot.write_field_end()?;
    if let Some(fld_var) = self.timestamp {
      o_prot.write_field_begin(&TFieldIdentifier::new("timestamp", TType::I64, 3))?;
      o_prot.write_i64(fld_var)?;
      o_prot.write_field_end()?
    }
    if let Some(ref fld_var) = self.attributes {
      o_prot.write_field_begin(&TFieldIdentifier::new("attributes", TType::Map, 5))?;
      o_prot.write_map_begin(&TMapIdentifier::new(TType::String, TType::String, fld_var.len() as i32))?;
      for (k, v) in fld_var {
        o_prot.write_bytes(k)?;
        o_prot.write_bytes(v)?;
      }
      o_prot.write_map_end()?;
      o_prot.write_field_end()?
    }
    if let Some(ref fld_var) = self.durability {
      o_prot.write_field_begin(&TFieldIdentifier::new("durability", TType::I32, 6))?;
      fld_var.write_to_out_protocol(o_prot)?;
      o_prot.write_field_end()?
    }
    if let Some(ref fld_var) = self.cell_visibility {
      o_prot.write_field_begin(&TFieldIdentifier::new("cellVisibility", TType::Struct, 7))?;
      fld_var.write_to_out_protocol(o_prot)?;
      o_prot.write_field_end()?
    }
    o_prot.write_field_stop()?;
    o_prot.write_struct_end()
  }
}

//
// TDelete
//

/// Used to perform Delete operations on a single row.
/// 
/// The scope can be further narrowed down by specifying a list of
/// columns or column families as TColumns.
/// 
/// Specifying only a family in a TColumn will delete the whole family.
/// If a timestamp is specified all versions with a timestamp less than
/// or equal to this will be deleted. If no timestamp is specified the
/// current time will be used.
/// 
/// Specifying a family and a column qualifier in a TColumn will delete only
/// this qualifier. If a timestamp is specified only versions equal
/// to this timestamp will be deleted. If no timestamp is specified the
/// most recent version will be deleted.  To delete all previous versions,
/// specify the DELETE_COLUMNS TDeleteType.
/// 
/// The top level timestamp is only used if a complete row should be deleted
/// (i.e. no columns are passed) and if it is specified it works the same way
/// as if you had added a TColumn for every column family and this timestamp
/// (i.e. all versions older than or equal in all column families will be deleted)
/// 
/// You can specify how this Delete should be written to the write-ahead Log (WAL)
/// by changing the durability. If you don't provide durability, it defaults to
/// column family's default setting for durability.
#[derive(Clone, Debug, Eq, Hash, Ord, PartialEq, PartialOrd)]
pub struct TDelete {
  pub row: Vec<u8>,
  pub columns: Option<Vec<TColumn>>,
  pub timestamp: Option<i64>,
  pub delete_type: Option<TDeleteType>,
  pub attributes: Option<BTreeMap<Vec<u8>, Vec<u8>>>,
  pub durability: Option<TDurability>,
}

impl TDelete {
  pub fn new<F2, F3, F4, F6, F7>(row: Vec<u8>, columns: F2, timestamp: F3, delete_type: F4, attributes: F6, durability: F7) -> TDelete where F2: Into<Option<Vec<TColumn>>>, F3: Into<Option<i64>>, F4: Into<Option<TDeleteType>>, F6: Into<Option<BTreeMap<Vec<u8>, Vec<u8>>>>, F7: Into<Option<TDurability>> {
    TDelete {
      row,
      columns: columns.into(),
      timestamp: timestamp.into(),
      delete_type: delete_type.into(),
      attributes: attributes.into(),
      durability: durability.into(),
    }
  }
  pub fn read_from_in_protocol(i_prot: &mut dyn TInputProtocol) -> thrift::Result<TDelete> {
    i_prot.read_struct_begin()?;
    let mut f_1: Option<Vec<u8>> = None;
    let mut f_2: Option<Vec<TColumn>> = None;
    let mut f_3: Option<i64> = None;
    let mut f_4: Option<TDeleteType> = None;
    let mut f_6: Option<BTreeMap<Vec<u8>, Vec<u8>>> = None;
    let mut f_7: Option<TDurability> = None;
    loop {
      let field_ident = i_prot.read_field_begin()?;
      if field_ident.field_type == TType::Stop {
        break;
      }
      let field_id = field_id(&field_ident)?;
      match field_id {
        1 => {
          let val = i_prot.read_bytes()?;
          f_1 = Some(val);
        },
        2 => {
          let list_ident = i_prot.read_list_begin()?;
          let mut val: Vec<TColumn> = Vec::with_capacity(list_ident.size as usize);
          for _ in 0..list_ident.size {
            let list_elem_8 = TColumn::read_from_in_protocol(i_prot)?;
            val.push(list_elem_8);
          }
          i_prot.read_list_end()?;
          f_2 = Some(val);
        },
        3 => {
          let val = i_prot.read_i64()?;
          f_3 = Some(val);
        },
        4 => {
          let val = TDeleteType::read_from_in_protocol(i_prot)?;
          f_4 = Some(val);
        },
        6 => {
          let map_ident = i_prot.read_map_begin()?;
          let mut val: BTreeMap<Vec<u8>, Vec<u8>> = BTreeMap::new();
          for _ in 0..map_ident.size {
            let map_key_9 = i_prot.read_bytes()?;
            let map_val_10 = i_prot.read_bytes()?;
            val.insert(map_key_9, map_val_10);
          }
          i_prot.read_map_end()?;
          f_6 = Some(val);
        },
        7 => {
          let val = TDurability::read_from_in_protocol(i_prot)?;
          f_7 = Some(val);
        },
        _ => {
          i_prot.skip(field_ident.field_type)?;
        },
      };
      i_prot.read_field_end()?;
    }
    i_prot.read_struct_end()?;
    verify_required_field_exists("TDelete.row", &f_1)?;
    let ret = TDelete {
      row: f_1.expect("auto-generated code should have checked for presence of required fields"),
      columns: f_2,
      timestamp: f_3,
      delete_type: f_4,
      attributes: f_6,
      durability: f_7,
    };
    Ok(ret)
  }
  pub fn write_to_out_protocol(&self, o_prot: &mut dyn TOutputProtocol) -> thrift::Result<()> {
    let struct_ident = TStructIdentifier::new("TDelete");
    o_prot.write_struct_begin(&struct_ident)?;
    o_prot.write_field_begin(&TFieldIdentifier::new("row", TType::String, 1))?;
    o_prot.write_bytes(&self.row)?;
    o_prot.write_field_end()?;
    if let Some(ref fld_var) = self.columns {
      o_prot.write_field_begin(&TFieldIdentifier::new("columns", TType::List, 2))?;
      o_prot.write_list_begin(&TListIdentifier::new(TType::Struct, fld_var.len() as i32))?;
      for e in fld_var {
        e.write_to_out_protocol(o_prot)?;
      }
      o_prot.write_list_end()?;
      o_prot.write_field_end()?
    }
    if let Some(fld_var) = self.timestamp {
      o_prot.write_field_begin(&TFieldIdentifier::new("timestamp", TType::I64, 3))?;
      o_prot.write_i64(fld_var)?;
      o_prot.write_field_end()?
    }
    if let Some(ref fld_var) = self.delete_type {
      o_prot.write_field_begin(&TFieldIdentifier::new("deleteType", TType::I32, 4))?;
      fld_var.write_to_out_protocol(o_prot)?;
      o_prot.write_field_end()?
    }
    if let Some(ref fld_var) = self.attributes {
      o_prot.write_field_begin(&TFieldIdentifier::new("attributes", TType::Map, 6))?;
      o_prot.write_map_begin(&TMapIdentifier::new(TType::String, TType::String, fld_var.len() as i32))?;
      for (k, v) in fld_var {
        o_prot.write_bytes(k)?;
        o_prot.write_bytes(v)?;
      }
      o_prot.write_map_end()?;
      o_prot.write_field_end()?
    }
    if let Some(ref fld_var) = self.durability {
      o_prot.write_field_begin(&TFieldIdentifier::new("durability", TType::I32, 7))?;
      fld_var.write_to_out_protocol(o_prot)?;
      o_prot.write_field_end()?
    }
    o_prot.write_field_stop()?;
    o_prot.write_struct_end()
  }
}

//
// TIncrement
//

/// Used to perform Increment operations for a single row.
/// 
/// You can specify how this Increment should be written to the write-ahead Log (WAL)
/// by changing the durability. If you don't provide durability, it defaults to
/// column family's default setting for durability.
#[derive(Clone, Debug, Eq, Hash, Ord, PartialEq, PartialOrd)]
pub struct TIncrement {
  pub row: Vec<u8>,
  pub columns: Vec<TColumnIncrement>,
  pub attributes: Option<BTreeMap<Vec<u8>, Vec<u8>>>,
  pub durability: Option<TDurability>,
  pub cell_visibility: Option<TCellVisibility>,
  pub return_results: Option<bool>,
}

impl TIncrement {
  pub fn new<F4, F5, F6, F7>(row: Vec<u8>, columns: Vec<TColumnIncrement>, attributes: F4, durability: F5, cell_visibility: F6, return_results: F7) -> TIncrement where F4: Into<Option<BTreeMap<Vec<u8>, Vec<u8>>>>, F5: Into<Option<TDurability>>, F6: Into<Option<TCellVisibility>>, F7: Into<Option<bool>> {
    TIncrement {
      row,
      columns,
      attributes: attributes.into(),
      durability: durability.into(),
      cell_visibility: cell_visibility.into(),
      return_results: return_results.into(),
    }
  }
  pub fn read_from_in_protocol(i_prot: &mut dyn TInputProtocol) -> thrift::Result<TIncrement> {
    i_prot.read_struct_begin()?;
    let mut f_1: Option<Vec<u8>> = None;
    let mut f_2: Option<Vec<TColumnIncrement>> = None;
    let mut f_4: Option<BTreeMap<Vec<u8>, Vec<u8>>> = None;
    let mut f_5: Option<TDurability> = None;
    let mut f_6: Option<TCellVisibility> = None;
    let mut f_7: Option<bool> = None;
    loop {
      let field_ident = i_prot.read_field_begin()?;
      if field_ident.field_type == TType::Stop {
        break;
      }
      let field_id = field_id(&field_ident)?;
      match field_id {
        1 => {
          let val = i_prot.read_bytes()?;
          f_1 = Some(val);
        },
        2 => {
          let list_ident = i_prot.read_list_begin()?;
          let mut val: Vec<TColumnIncrement> = Vec::with_capacity(list_ident.size as usize);
          for _ in 0..list_ident.size {
            let list_elem_11 = TColumnIncrement::read_from_in_protocol(i_prot)?;
            val.push(list_elem_11);
          }
          i_prot.read_list_end()?;
          f_2 = Some(val);
        },
        4 => {
          let map_ident = i_prot.read_map_begin()?;
          let mut val: BTreeMap<Vec<u8>, Vec<u8>> = BTreeMap::new();
          for _ in 0..map_ident.size {
            let map_key_12 = i_prot.read_bytes()?;
            let map_val_13 = i_prot.read_bytes()?;
            val.insert(map_key_12, map_val_13);
          }
          i_prot.read_map_end()?;
          f_4 = Some(val);
        },
        5 => {
          let val = TDurability::read_from_in_protocol(i_prot)?;
          f_5 = Some(val);
        },
        6 => {
          let val = TCellVisibility::read_from_in_protocol(i_prot)?;
          f_6 = Some(val);
        },
        7 => {
          let val = i_prot.read_bool()?;
          f_7 = Some(val);
        },
        _ => {
          i_prot.skip(field_ident.field_type)?;
        },
      };
      i_prot.read_field_end()?;
    }
    i_prot.read_struct_end()?;
    verify_required_field_exists("TIncrement.row", &f_1)?;
    verify_required_field_exists("TIncrement.columns", &f_2)?;
    let ret = TIncrement {
      row: f_1.expect("auto-generated code should have checked for presence of required fields"),
      columns: f_2.expect("auto-generated code should have checked for presence of required fields"),
      attributes: f_4,
      durability: f_5,
      cell_visibility: f_6,
      return_results: f_7,
    };
    Ok(ret)
  }
  pub fn write_to_out_protocol(&self, o_prot: &mut dyn TOutputProtocol) -> thrift::Result<()> {
    let struct_ident = TStructIdentifier::new("TIncrement");
    o_prot.write_struct_begin(&struct_ident)?;
    o_prot.write_field_begin(&TFieldIdentifier::new("row", TType::String, 1))?;
    o_prot.write_bytes(&self.row)?;
    o_prot.write_field_end()?;
    o_prot.write_field_begin(&TFieldIdentifier::new("columns", TType::List, 2))?;
    o_prot.write_list_begin(&TListIdentifier::new(TType::Struct, self.columns.len() as i32))?;
    for e in &self.columns {
      e.write_to_out_protocol(o_prot)?;
    }
    o_prot.write_list_end()?;
    o_prot.write_field_end()?;
    if let Some(ref fld_var) = self.attributes {
      o_prot.write_field_begin(&TFieldIdentifier::new("attributes", TType::Map, 4))?;
      o_prot.write_map_begin(&TMapIdentifier::new(TType::String, TType::String, fld_var.len() as i32))?;
      for (k, v) in fld_var {
        o_prot.write_bytes(k)?;
        o_prot.write_bytes(v)?;
      }
      o_prot.write_map_end()?;
      o_prot.write_field_end()?
    }
    if let Some(ref fld_var) = self.durability {
      o_prot.write_field_begin(&TFieldIdentifier::new("durability", TType::I32, 5))?;
      fld_var.write_to_out_protocol(o_prot)?;
      o_prot.write_field_end()?
    }
    if let Some(ref fld_var) = self.cell_visibility {
      o_prot.write_field_begin(&TFieldIdentifier::new("cellVisibility", TType::Struct, 6))?;
      fld_var.write_to_out_protocol(o_prot)?;
      o_prot.write_field_end()?
    }
    if let Some(fld_var) = self.return_results {
      o_prot.write_field_begin(&TFieldIdentifier::new("returnResults", TType::Bool, 7))?;
      o_prot.write_bool(fld_var)?;
      o_prot.write_field_end()?
    }
    o_prot.write_field_stop()?;
    o_prot.write_struct_end()
  }
}

//
// TAppend
//

#[derive(Clone, Debug, Eq, Hash, Ord, PartialEq, PartialOrd)]
pub struct TAppend {
  pub row: Vec<u8>,
  pub columns: Vec<TColumnValue>,
  pub attributes: Option<BTreeMap<Vec<u8>, Vec<u8>>>,
  pub durability: Option<TDurability>,
  pub cell_visibility: Option<TCellVisibility>,
  pub return_results: Option<bool>,
}

impl TAppend {
  pub fn new<F3, F4, F5, F6>(row: Vec<u8>, columns: Vec<TColumnValue>, attributes: F3, durability: F4, cell_visibility: F5, return_results: F6) -> TAppend where F3: Into<Option<BTreeMap<Vec<u8>, Vec<u8>>>>, F4: Into<Option<TDurability>>, F5: Into<Option<TCellVisibility>>, F6: Into<Option<bool>> {
    TAppend {
      row,
      columns,
      attributes: attributes.into(),
      durability: durability.into(),
      cell_visibility: cell_visibility.into(),
      return_results: return_results.into(),
    }
  }
  pub fn read_from_in_protocol(i_prot: &mut dyn TInputProtocol) -> thrift::Result<TAppend> {
    i_prot.read_struct_begin()?;
    let mut f_1: Option<Vec<u8>> = None;
    let mut f_2: Option<Vec<TColumnValue>> = None;
    let mut f_3: Option<BTreeMap<Vec<u8>, Vec<u8>>> = None;
    let mut f_4: Option<TDurability> = None;
    let mut f_5: Option<TCellVisibility> = None;
    let mut f_6: Option<bool> = None;
    loop {
      let field_ident = i_prot.read_field_begin()?;
      if field_ident.field_type == TType::Stop {
        break;
      }
      let field_id = field_id(&field_ident)?;
      match field_id {
        1 => {
          let val = i_prot.read_bytes()?;
          f_1 = Some(val);
        },
        2 => {
          let list_ident = i_prot.read_list_begin()?;
          let mut val: Vec<TColumnValue> = Vec::with_capacity(list_ident.size as usize);
          for _ in 0..list_ident.size {
            let list_elem_14 = TColumnValue::read_from_in_protocol(i_prot)?;
            val.push(list_elem_14);
          }
          i_prot.read_list_end()?;
          f_2 = Some(val);
        },
        3 => {
          let map_ident = i_prot.read_map_begin()?;
          let mut val: BTreeMap<Vec<u8>, Vec<u8>> = BTreeMap::new();
          for _ in 0..map_ident.size {
            let map_key_15 = i_prot.read_bytes()?;
            let map_val_16 = i_prot.read_bytes()?;
            val.insert(map_key_15, map_val_16);
          }
          i_prot.read_map_end()?;
          f_3 = Some(val);
        },
        4 => {
          let val = TDurability::read_from_in_protocol(i_prot)?;
          f_4 = Some(val);
        },
        5 => {
          let val = TCellVisibility::read_from_in_protocol(i_prot)?;
          f_5 = Some(val);
        },
        6 => {
          let val = i_prot.read_bool()?;
          f_6 = Some(val);
        },
        _ => {
          i_prot.skip(field_ident.field_type)?;
        },
      };
      i_prot.read_field_end()?;
    }
    i_prot.read_struct_end()?;
    verify_required_field_exists("TAppend.row", &f_1)?;
    verify_required_field_exists("TAppend.columns", &f_2)?;
    let ret = TAppend {
      row: f_1.expect("auto-generated code should have checked for presence of required fields"),
      columns: f_2.expect("auto-generated code should have checked for presence of required fields"),
      attributes: f_3,
      durability: f_4,
      cell_visibility: f_5,
      return_results: f_6,
    };
    Ok(ret)
  }
  pub fn write_to_out_protocol(&self, o_prot: &mut dyn TOutputProtocol) -> thrift::Result<()> {
    let struct_ident = TStructIdentifier::new("TAppend");
    o_prot.write_struct_begin(&struct_ident)?;
    o_prot.write_field_begin(&TFieldIdentifier::new("row", TType::String, 1))?;
    o_prot.write_bytes(&self.row)?;
    o_prot.write_field_end()?;
    o_prot.write_field_begin(&TFieldIdentifier::new("columns", TType::List, 2))?;
    o_prot.write_list_begin(&TListIdentifier::new(TType::Struct, self.columns.len() as i32))?;
    for e in &self.columns {
      e.write_to_out_protocol(o_prot)?;
    }
    o_prot.write_list_end()?;
    o_prot.write_field_end()?;
    if let Some(ref fld_var) = self.attributes {
      o_prot.write_field_begin(&TFieldIdentifier::new("attributes", TType::Map, 3))?;
      o_prot.write_map_begin(&TMapIdentifier::new(TType::String, TType::String, fld_var.len() as i32))?;
      for (k, v) in fld_var {
        o_prot.write_bytes(k)?;
        o_prot.write_bytes(v)?;
      }
      o_prot.write_map_end()?;
      o_prot.write_field_end()?
    }
    if let Some(ref fld_var) = self.durability {
      o_prot.write_field_begin(&TFieldIdentifier::new("durability", TType::I32, 4))?;
      fld_var.write_to_out_protocol(o_prot)?;
      o_prot.write_field_end()?
    }
    if let Some(ref fld_var) = self.cell_visibility {
      o_prot.write_field_begin(&TFieldIdentifier::new("cellVisibility", TType::Struct, 5))?;
      fld_var.write_to_out_protocol(o_prot)?;
      o_prot.write_field_end()?
    }
    if let Some(fld_var) = self.return_results {
      o_prot.write_field_begin(&TFieldIdentifier::new("returnResults", TType::Bool, 6))?;
      o_prot.write_bool(fld_var)?;
      o_prot.write_field_end()?
    }
    o_prot.write_field_stop()?;
    o_prot.write_struct_end()
  }
}

//
// TScan
//

/// Any timestamps in the columns are ignored but the colFamTimeRangeMap included, use timeRange to select by timestamp.
/// Max versions defaults to 1.
#[derive(Clone, Debug, Eq, Hash, Ord, PartialEq, PartialOrd)]
pub struct TScan {
  pub start_row: Option<Vec<u8>>,
  pub stop_row: Option<Vec<u8>>,
  pub columns: Option<Vec<TColumn>>,
  pub caching: Option<i32>,
  pub max_versions: Option<i32>,
  pub time_range: Option<TTimeRange>,
  pub filter_string: Option<Vec<u8>>,
  pub batch_size: Option<i32>,
  pub attributes: Option<BTreeMap<Vec<u8>, Vec<u8>>>,
  pub authorizations: Option<TAuthorization>,
  pub reversed: Option<bool>,
  pub cache_blocks: Option<bool>,
  pub col_fam_time_range_map: Option<BTreeMap<Vec<u8>, TTimeRange>>,
  pub read_type: Option<TReadType>,
  pub limit: Option<i32>,
  pub consistency: Option<TConsistency>,
  pub target_replica_id: Option<i32>,
  pub filter_bytes: Option<Vec<u8>>,
}

impl TScan {
  pub fn new<F1, F2, F3, F4, F5, F6, F7, F8, F9, F10, F11, F12, F13, F14, F15, F16, F17, F18>(start_row: F1, stop_row: F2, columns: F3, caching: F4, max_versions: F5, time_range: F6, filter_string: F7, batch_size: F8, attributes: F9, authorizations: F10, reversed: F11, cache_blocks: F12, col_fam_time_range_map: F13, read_type: F14, limit: F15, consistency: F16, target_replica_id: F17, filter_bytes: F18) -> TScan where F1: Into<Option<Vec<u8>>>, F2: Into<Option<Vec<u8>>>, F3: Into<Option<Vec<TColumn>>>, F4: Into<Option<i32>>, F5: Into<Option<i32>>, F6: Into<Option<TTimeRange>>, F7: Into<Option<Vec<u8>>>, F8: Into<Option<i32>>, F9: Into<Option<BTreeMap<Vec<u8>, Vec<u8>>>>, F10: Into<Option<TAuthorization>>, F11: Into<Option<bool>>, F12: Into<Option<bool>>, F13: Into<Option<BTreeMap<Vec<u8>, TTimeRange>>>, F14: Into<Option<TReadType>>, F15: Into<Option<i32>>, F16: Into<Option<TConsistency>>, F17: Into<Option<i32>>, F18: Into<Option<Vec<u8>>> {
    TScan {
      start_row: start_row.into(),
      stop_row: stop_row.into(),
      columns: columns.into(),
      caching: caching.into(),
      max_versions: max_versions.into(),
      time_range: time_range.into(),
      filter_string: filter_string.into(),
      batch_size: batch_size.into(),
      attributes: attributes.into(),
      authorizations: authorizations.into(),
      reversed: reversed.into(),
      cache_blocks: cache_blocks.into(),
      col_fam_time_range_map: col_fam_time_range_map.into(),
      read_type: read_type.into(),
      limit: limit.into(),
      consistency: consistency.into(),
      target_replica_id: target_replica_id.into(),
      filter_bytes: filter_bytes.into(),
    }
  }
  pub fn read_from_in_protocol(i_prot: &mut dyn TInputProtocol) -> thrift::Result<TScan> {
    i_prot.read_struct_begin()?;
    let mut f_1: Option<Vec<u8>> = None;
    let mut f_2: Option<Vec<u8>> = None;
    let mut f_3: Option<Vec<TColumn>> = None;
    let mut f_4: Option<i32> = None;
    let mut f_5: Option<i32> = None;
    let mut f_6: Option<TTimeRange> = None;
    let mut f_7: Option<Vec<u8>> = None;
    let mut f_8: Option<i32> = None;
    let mut f_9: Option<BTreeMap<Vec<u8>, Vec<u8>>> = None;
    let mut f_10: Option<TAuthorization> = None;
    let mut f_11: Option<bool> = None;
    let mut f_12: Option<bool> = None;
    let mut f_13: Option<BTreeMap<Vec<u8>, TTimeRange>> = None;
    let mut f_14: Option<TReadType> = None;
    let mut f_15: Option<i32> = None;
    let mut f_16: Option<TConsistency> = None;
    let mut f_17: Option<i32> = None;
    let mut f_18: Option<Vec<u8>> = None;
    loop {
      let field_ident = i_prot.read_field_begin()?;
      if field_ident.field_type == TType::Stop {
        break;
      }
      let field_id = field_id(&field_ident)?;
      match field_id {
        1 => {
          let val = i_prot.read_bytes()?;
          f_1 = Some(val);
        },
        2 => {
          let val = i_prot.read_bytes()?;
          f_2 = Some(val);
        },
        3 => {
          let list_ident = i_prot.read_list_begin()?;
          let mut val: Vec<TColumn> = Vec::with_capacity(list_ident.size as usize);
          for _ in 0..list_ident.size {
            let list_elem_17 = TColumn::read_from_in_protocol(i_prot)?;
            val.push(list_elem_17);
          }
          i_prot.read_list_end()?;
          f_3 = Some(val);
        },
        4 => {
          let val = i_prot.read_i32()?;
          f_4 = Some(val);
        },
        5 => {
          let val = i_prot.read_i32()?;
          f_5 = Some(val);
        },
        6 => {
          let val = TTimeRange::read_from_in_protocol(i_prot)?;
          f_6 = Some(val);
        },
        7 => {
          let val = i_prot.read_bytes()?;
          f_7 = Some(val);
        },
        8 => {
          let val = i_prot.read_i32()?;
          f_8 = Some(val);
        },
        9 => {
          let map_ident = i_prot.read_map_begin()?;
          let mut val: BTreeMap<Vec<u8>, Vec<u8>> = BTreeMap::new();
          for _ in 0..map_ident.size {
            let map_key_18 = i_prot.read_bytes()?;
            let map_val_19 = i_prot.read_bytes()?;
            val.insert(map_key_18, map_val_19);
          }
          i_prot.read_map_end()?;
          f_9 = Some(val);
        },
        10 => {
          let val = TAuthorization::read_from_in_protocol(i_prot)?;
          f_10 = Some(val);
        },
        11 => {
          let val = i_prot.read_bool()?;
          f_11 = Some(val);
        },
        12 => {
          let val = i_prot.read_bool()?;
          f_12 = Some(val);
        },
        13 => {
          let map_ident = i_prot.read_map_begin()?;
          let mut val: BTreeMap<Vec<u8>, TTimeRange> = BTreeMap::new();
          for _ in 0..map_ident.size {
            let map_key_20 = i_prot.read_bytes()?;
            let map_val_21 = TTimeRange::read_from_in_protocol(i_prot)?;
            val.insert(map_key_20, map_val_21);
          }
          i_prot.read_map_end()?;
          f_13 = Some(val);
        },
        14 => {
          let val = TReadType::read_from_in_protocol(i_prot)?;
          f_14 = Some(val);
        },
        15 => {
          let val = i_prot.read_i32()?;
          f_15 = Some(val);
        },
        16 => {
          let val = TConsistency::read_from_in_protocol(i_prot)?;
          f_16 = Some(val);
        },
        17 => {
          let val = i_prot.read_i32()?;
          f_17 = Some(val);
        },
        18 => {
          let val = i_prot.read_bytes()?;
          f_18 = Some(val);
        },
        _ => {
          i_prot.skip(field_ident.field_type)?;
        },
      };
      i_prot.read_field_end()?;
    }
    i_prot.read_struct_end()?;
    let ret = TScan {
      start_row: f_1,
      stop_row: f_2,
      columns: f_3,
      caching: f_4,
      max_versions: f_5,
      time_range: f_6,
      filter_string: f_7,
      batch_size: f_8,
      attributes: f_9,
      authorizations: f_10,
      reversed: f_11,
      cache_blocks: f_12,
      col_fam_time_range_map: f_13,
      read_type: f_14,
      limit: f_15,
      consistency: f_16,
      target_replica_id: f_17,
      filter_bytes: f_18,
    };
    Ok(ret)
  }
  pub fn write_to_out_protocol(&self, o_prot: &mut dyn TOutputProtocol) -> thrift::Result<()> {
    let struct_ident = TStructIdentifier::new("TScan");
    o_prot.write_struct_begin(&struct_ident)?;
    if let Some(ref fld_var) = self.start_row {
      o_prot.write_field_begin(&TFieldIdentifier::new("startRow", TType::String, 1))?;
      o_prot.write_bytes(fld_var)?;
      o_prot.write_field_end()?
    }
    if let Some(ref fld_var) = self.stop_row {
      o_prot.write_field_begin(&TFieldIdentifier::new("stopRow", TType::String, 2))?;
      o_prot.write_bytes(fld_var)?;
      o_prot.write_field_end()?
    }
    if let Some(ref fld_var) = self.columns {
      o_prot.write_field_begin(&TFieldIdentifier::new("columns", TType::List, 3))?;
      o_prot.write_list_begin(&TListIdentifier::new(TType::Struct, fld_var.len() as i32))?;
      for e in fld_var {
        e.write_to_out_protocol(o_prot)?;
      }
      o_prot.write_list_end()?;
      o_prot.write_field_end()?
    }
    if let Some(fld_var) = self.caching {
      o_prot.write_field_begin(&TFieldIdentifier::new("caching", TType::I32, 4))?;
      o_prot.write_i32(fld_var)?;
      o_prot.write_field_end()?
    }
    if let Some(fld_var) = self.max_versions {
      o_prot.write_field_begin(&TFieldIdentifier::new("maxVersions", TType::I32, 5))?;
      o_prot.write_i32(fld_var)?;
      o_prot.write_field_end()?
    }
    if let Some(ref fld_var) = self.time_range {
      o_prot.write_field_begin(&TFieldIdentifier::new("timeRange", TType::Struct, 6))?;
      fld_var.write_to_out_protocol(o_prot)?;
      o_prot.write_field_end()?
    }
    if let Some(ref fld_var) = self.filter_string {
      o_prot.write_field_begin(&TFieldIdentifier::new("filterString", TType::String, 7))?;
      o_prot.write_bytes(fld_var)?;
      o_prot.write_field_end()?
    }
    if let Some(fld_var) = self.batch_size {
      o_prot.write_field_begin(&TFieldIdentifier::new("batchSize", TType::I32, 8))?;
      o_prot.write_i32(fld_var)?;
      o_prot.write_field_end()?
    }
    if let Some(ref fld_var) = self.attributes {
      o_prot.write_field_begin(&TFieldIdentifier::new("attributes", TType::Map, 9))?;
      o_prot.write_map_begin(&TMapIdentifier::new(TType::String, TType::String, fld_var.len() as i32))?;
      for (k, v) in fld_var {
        o_prot.write_bytes(k)?;
        o_prot.write_bytes(v)?;
      }
      o_prot.write_map_end()?;
      o_prot.write_field_end()?
    }
    if let Some(ref fld_var) = self.authorizations {
      o_prot.write_field_begin(&TFieldIdentifier::new("authorizations", TType::Struct, 10))?;
      fld_var.write_to_out_protocol(o_prot)?;
      o_prot.write_field_end()?
    }
    if let Some(fld_var) = self.reversed {
      o_prot.write_field_begin(&TFieldIdentifier::new("reversed", TType::Bool, 11))?;
      o_prot.write_bool(fld_var)?;
      o_prot.write_field_end()?
    }
    if let Some(fld_var) = self.cache_blocks {
      o_prot.write_field_begin(&TFieldIdentifier::new("cacheBlocks", TType::Bool, 12))?;
      o_prot.write_bool(fld_var)?;
      o_prot.write_field_end()?
    }
    if let Some(ref fld_var) = self.col_fam_time_range_map {
      o_prot.write_field_begin(&TFieldIdentifier::new("colFamTimeRangeMap", TType::Map, 13))?;
      o_prot.write_map_begin(&TMapIdentifier::new(TType::String, TType::Struct, fld_var.len() as i32))?;
      for (k, v) in fld_var {
        o_prot.write_bytes(k)?;
        v.write_to_out_protocol(o_prot)?;
      }
      o_prot.write_map_end()?;
      o_prot.write_field_end()?
    }
    if let Some(ref fld_var) = self.read_type {
      o_prot.write_field_begin(&TFieldIdentifier::new("readType", TType::I32, 14))?;
      fld_var.write_to_out_protocol(o_prot)?;
      o_prot.write_field_end()?
    }
    if let Some(fld_var) = self.limit {
      o_prot.write_field_begin(&TFieldIdentifier::new("limit", TType::I32, 15))?;
      o_prot.write_i32(fld_var)?;
      o_prot.write_field_end()?
    }
    if let Some(ref fld_var) = self.consistency {
      o_prot.write_field_begin(&TFieldIdentifier::new("consistency", TType::I32, 16))?;
      fld_var.write_to_out_protocol(o_prot)?;
      o_prot.write_field_end()?
    }
    if let Some(fld_var) = self.target_replica_id {
      o_prot.write_field_begin(&TFieldIdentifier::new("targetReplicaId", TType::I32, 17))?;
      o_prot.write_i32(fld_var)?;
      o_prot.write_field_end()?
    }
    if let Some(ref fld_var) = self.filter_bytes {
      o_prot.write_field_begin(&TFieldIdentifier::new("filterBytes", TType::String, 18))?;
      o_prot.write_bytes(fld_var)?;
      o_prot.write_field_end()?
    }
    o_prot.write_field_stop()?;
    o_prot.write_struct_end()
  }
}

impl Default for TScan {
  fn default() -> Self {
    TScan{
      start_row: Some(Vec::new()),
      stop_row: Some(Vec::new()),
      columns: Some(Vec::new()),
      caching: Some(0),
      max_versions: Some(0),
      time_range: None,
      filter_string: Some(Vec::new()),
      batch_size: Some(0),
      attributes: Some(BTreeMap::new()),
      authorizations: None,
      reversed: Some(false),
      cache_blocks: Some(false),
      col_fam_time_range_map: Some(BTreeMap::new()),
      read_type: None,
      limit: Some(0),
      consistency: None,
      target_replica_id: Some(0),
      filter_bytes: Some(Vec::new()),
    }
  }
}

//
// TMutation
//

#[derive(Clone, Debug, Eq, Hash, Ord, PartialEq, PartialOrd)]
pub enum TMutation {
  Put(TPut),
  DeleteSingle(TDelete),
}

impl TMutation {
  pub fn read_from_in_protocol(i_prot: &mut dyn TInputProtocol) -> thrift::Result<TMutation> {
    let mut ret: Option<TMutation> = None;
    let mut received_field_count = 0;
    i_prot.read_struct_begin()?;
    loop {
      let field_ident = i_prot.read_field_begin()?;
      if field_ident.field_type == TType::Stop {
        break;
      }
      let field_id = field_id(&field_ident)?;
      match field_id {
        1 => {
          let val = TPut::read_from_in_protocol(i_prot)?;
          if ret.is_none() {
            ret = Some(TMutation::Put(val));
          }
          received_field_count += 1;
        },
        2 => {
          let val = TDelete::read_from_in_protocol(i_prot)?;
          if ret.is_none() {
            ret = Some(TMutation::DeleteSingle(val));
          }
          received_field_count += 1;
        },
        _ => {
          i_prot.skip(field_ident.field_type)?;
          received_field_count += 1;
        },
      };
      i_prot.read_field_end()?;
    }
    i_prot.read_struct_end()?;
    if received_field_count == 0 {
      Err(
        thrift::Error::Protocol(
          ProtocolError::new(
            ProtocolErrorKind::InvalidData,
            "received empty union from remote TMutation"
          )
        )
      )
    } else if received_field_count > 1 {
      Err(
        thrift::Error::Protocol(
          ProtocolError::new(
            ProtocolErrorKind::InvalidData,
            "received multiple fields for union from remote TMutation"
          )
        )
      )
    } else {
      Ok(ret.expect("return value should have been constructed"))
    }
  }
  pub fn write_to_out_protocol(&self, o_prot: &mut dyn TOutputProtocol) -> thrift::Result<()> {
    let struct_ident = TStructIdentifier::new("TMutation");
    o_prot.write_struct_begin(&struct_ident)?;
    match *self {
      TMutation::Put(ref f) => {
        o_prot.write_field_begin(&TFieldIdentifier::new("put", TType::Struct, 1))?;
        f.write_to_out_protocol(o_prot)?;
        o_prot.write_field_end()?;
      },
      TMutation::DeleteSingle(ref f) => {
        o_prot.write_field_begin(&TFieldIdentifier::new("deleteSingle", TType::Struct, 2))?;
        f.write_to_out_protocol(o_prot)?;
        o_prot.write_field_end()?;
      },
    }
    o_prot.write_field_stop()?;
    o_prot.write_struct_end()
  }
}

//
// TRowMutations
//

/// A TRowMutations object is used to apply a number of Mutations to a single row.
#[derive(Clone, Debug, Eq, Hash, Ord, PartialEq, PartialOrd)]
pub struct TRowMutations {
  pub row: Vec<u8>,
  pub mutations: Vec<TMutation>,
}

impl TRowMutations {
  pub fn new(row: Vec<u8>, mutations: Vec<TMutation>) -> TRowMutations {
    TRowMutations {
      row,
      mutations,
    }
  }
  pub fn read_from_in_protocol(i_prot: &mut dyn TInputProtocol) -> thrift::Result<TRowMutations> {
    i_prot.read_struct_begin()?;
    let mut f_1: Option<Vec<u8>> = None;
    let mut f_2: Option<Vec<TMutation>> = None;
    loop {
      let field_ident = i_prot.read_field_begin()?;
      if field_ident.field_type == TType::Stop {
        break;
      }
      let field_id = field_id(&field_ident)?;
      match field_id {
        1 => {
          let val = i_prot.read_bytes()?;
          f_1 = Some(val);
        },
        2 => {
          let list_ident = i_prot.read_list_begin()?;
          let mut val: Vec<TMutation> = Vec::with_capacity(list_ident.size as usize);
          for _ in 0..list_ident.size {
            let list_elem_22 = TMutation::read_from_in_protocol(i_prot)?;
            val.push(list_elem_22);
          }
          i_prot.read_list_end()?;
          f_2 = Some(val);
        },
        _ => {
          i_prot.skip(field_ident.field_type)?;
        },
      };
      i_prot.read_field_end()?;
    }
    i_prot.read_struct_end()?;
    verify_required_field_exists("TRowMutations.row", &f_1)?;
    verify_required_field_exists("TRowMutations.mutations", &f_2)?;
    let ret = TRowMutations {
      row: f_1.expect("auto-generated code should have checked for presence of required fields"),
      mutations: f_2.expect("auto-generated code should have checked for presence of required fields"),
    };
    Ok(ret)
  }
  pub fn write_to_out_protocol(&self, o_prot: &mut dyn TOutputProtocol) -> thrift::Result<()> {
    let struct_ident = TStructIdentifier::new("TRowMutations");
    o_prot.write_struct_begin(&struct_ident)?;
    o_prot.write_field_begin(&TFieldIdentifier::new("row", TType::String, 1))?;
    o_prot.write_bytes(&self.row)?;
    o_prot.write_field_end()?;
    o_prot.write_field_begin(&TFieldIdentifier::new("mutations", TType::List, 2))?;
    o_prot.write_list_begin(&TListIdentifier::new(TType::Struct, self.mutations.len() as i32))?;
    for e in &self.mutations {
      e.write_to_out_protocol(o_prot)?;
    }
    o_prot.write_list_end()?;
    o_prot.write_field_end()?;
    o_prot.write_field_stop()?;
    o_prot.write_struct_end()
  }
}

//
// THRegionInfo
//

#[derive(Clone, Debug, Eq, Hash, Ord, PartialEq, PartialOrd)]
pub struct THRegionInfo {
  pub region_id: i64,
  pub table_name: Vec<u8>,
  pub start_key: Option<Vec<u8>>,
  pub end_key: Option<Vec<u8>>,
  pub offline: Option<bool>,
  pub split: Option<bool>,
  pub replica_id: Option<i32>,
}

impl THRegionInfo {
  pub fn new<F3, F4, F5, F6, F7>(region_id: i64, table_name: Vec<u8>, start_key: F3, end_key: F4, offline: F5, split: F6, replica_id: F7) -> THRegionInfo where F3: Into<Option<Vec<u8>>>, F4: Into<Option<Vec<u8>>>, F5: Into<Option<bool>>, F6: Into<Option<bool>>, F7: Into<Option<i32>> {
    THRegionInfo {
      region_id,
      table_name,
      start_key: start_key.into(),
      end_key: end_key.into(),
      offline: offline.into(),
      split: split.into(),
      replica_id: replica_id.into(),
    }
  }
  pub fn read_from_in_protocol(i_prot: &mut dyn TInputProtocol) -> thrift::Result<THRegionInfo> {
    i_prot.read_struct_begin()?;
    let mut f_1: Option<i64> = None;
    let mut f_2: Option<Vec<u8>> = None;
    let mut f_3: Option<Vec<u8>> = None;
    let mut f_4: Option<Vec<u8>> = None;
    let mut f_5: Option<bool> = None;
    let mut f_6: Option<bool> = None;
    let mut f_7: Option<i32> = None;
    loop {
      let field_ident = i_prot.read_field_begin()?;
      if field_ident.field_type == TType::Stop {
        break;
      }
      let field_id = field_id(&field_ident)?;
      match field_id {
        1 => {
          let val = i_prot.read_i64()?;
          f_1 = Some(val);
        },
        2 => {
          let val = i_prot.read_bytes()?;
          f_2 = Some(val);
        },
        3 => {
          let val = i_prot.read_bytes()?;
          f_3 = Some(val);
        },
        4 => {
          let val = i_prot.read_bytes()?;
          f_4 = Some(val);
        },
        5 => {
          let val = i_prot.read_bool()?;
          f_5 = Some(val);
        },
        6 => {
          let val = i_prot.read_bool()?;
          f_6 = Some(val);
        },
        7 => {
          let val = i_prot.read_i32()?;
          f_7 = Some(val);
        },
        _ => {
          i_prot.skip(field_ident.field_type)?;
        },
      };
      i_prot.read_field_end()?;
    }
    i_prot.read_struct_end()?;
    verify_required_field_exists("THRegionInfo.region_id", &f_1)?;
    verify_required_field_exists("THRegionInfo.table_name", &f_2)?;
    let ret = THRegionInfo {
      region_id: f_1.expect("auto-generated code should have checked for presence of required fields"),
      table_name: f_2.expect("auto-generated code should have checked for presence of required fields"),
      start_key: f_3,
      end_key: f_4,
      offline: f_5,
      split: f_6,
      replica_id: f_7,
    };
    Ok(ret)
  }
  pub fn write_to_out_protocol(&self, o_prot: &mut dyn TOutputProtocol) -> thrift::Result<()> {
    let struct_ident = TStructIdentifier::new("THRegionInfo");
    o_prot.write_struct_begin(&struct_ident)?;
    o_prot.write_field_begin(&TFieldIdentifier::new("regionId", TType::I64, 1))?;
    o_prot.write_i64(self.region_id)?;
    o_prot.write_field_end()?;
    o_prot.write_field_begin(&TFieldIdentifier::new("tableName", TType::String, 2))?;
    o_prot.write_bytes(&self.table_name)?;
    o_prot.write_field_end()?;
    if let Some(ref fld_var) = self.start_key {
      o_prot.write_field_begin(&TFieldIdentifier::new("startKey", TType::String, 3))?;
      o_prot.write_bytes(fld_var)?;
      o_prot.write_field_end()?
    }
    if let Some(ref fld_var) = self.end_key {
      o_prot.write_field_begin(&TFieldIdentifier::new("endKey", TType::String, 4))?;
      o_prot.write_bytes(fld_var)?;
      o_prot.write_field_end()?
    }
    if let Some(fld_var) = self.offline {
      o_prot.write_field_begin(&TFieldIdentifier::new("offline", TType::Bool, 5))?;
      o_prot.write_bool(fld_var)?;
      o_prot.write_field_end()?
    }
    if let Some(fld_var) = self.split {
      o_prot.write_field_begin(&TFieldIdentifier::new("split", TType::Bool, 6))?;
      o_prot.write_bool(fld_var)?;
      o_prot.write_field_end()?
    }
    if let Some(fld_var) = self.replica_id {
      o_prot.write_field_begin(&TFieldIdentifier::new("replicaId", TType::I32, 7))?;
      o_prot.write_i32(fld_var)?;
      o_prot.write_field_end()?
    }
    o_prot.write_field_stop()?;
    o_prot.write_struct_end()
  }
}

//
// TServerName
//

#[derive(Clone, Debug, Eq, Hash, Ord, PartialEq, PartialOrd)]
pub struct TServerName {
  pub host_name: String,
  pub port: Option<i32>,
  pub start_code: Option<i64>,
}

impl TServerName {
  pub fn new<F2, F3>(host_name: String, port: F2, start_code: F3) -> TServerName where F2: Into<Option<i32>>, F3: Into<Option<i64>> {
    TServerName {
      host_name,
      port: port.into(),
      start_code: start_code.into(),
    }
  }
  pub fn read_from_in_protocol(i_prot: &mut dyn TInputProtocol) -> thrift::Result<TServerName> {
    i_prot.read_struct_begin()?;
    let mut f_1: Option<String> = None;
    let mut f_2: Option<i32> = None;
    let mut f_3: Option<i64> = None;
    loop {
      let field_ident = i_prot.read_field_begin()?;
      if field_ident.field_type == TType::Stop {
        break;
      }
      let field_id = field_id(&field_ident)?;
      match field_id {
        1 => {
          let val = i_prot.read_string()?;
          f_1 = Some(val);
        },
        2 => {
          let val = i_prot.read_i32()?;
          f_2 = Some(val);
        },
        3 => {
          let val = i_prot.read_i64()?;
          f_3 = Some(val);
        },
        _ => {
          i_prot.skip(field_ident.field_type)?;
        },
      };
      i_prot.read_field_end()?;
    }
    i_prot.read_struct_end()?;
    verify_required_field_exists("TServerName.host_name", &f_1)?;
    let ret = TServerName {
      host_name: f_1.expect("auto-generated code should have checked for presence of required fields"),
      port: f_2,
      start_code: f_3,
    };
    Ok(ret)
  }
  pub fn write_to_out_protocol(&self, o_prot: &mut dyn TOutputProtocol) -> thrift::Result<()> {
    let struct_ident = TStructIdentifier::new("TServerName");
    o_prot.write_struct_begin(&struct_ident)?;
    o_prot.write_field_begin(&TFieldIdentifier::new("hostName", TType::String, 1))?;
    o_prot.write_string(&self.host_name)?;
    o_prot.write_field_end()?;
    if let Some(fld_var) = self.port {
      o_prot.write_field_begin(&TFieldIdentifier::new("port", TType::I32, 2))?;
      o_prot.write_i32(fld_var)?;
      o_prot.write_field_end()?
    }
    if let Some(fld_var) = self.start_code {
      o_prot.write_field_begin(&TFieldIdentifier::new("startCode", TType::I64, 3))?;
      o_prot.write_i64(fld_var)?;
      o_prot.write_field_end()?
    }
    o_prot.write_field_stop()?;
    o_prot.write_struct_end()
  }
}

//
// THRegionLocation
//

#[derive(Clone, Debug, Eq, Hash, Ord, PartialEq, PartialOrd)]
pub struct THRegionLocation {
  pub server_name: TServerName,
  pub region_info: THRegionInfo,
}

impl THRegionLocation {
  pub fn new(server_name: TServerName, region_info: THRegionInfo) -> THRegionLocation {
    THRegionLocation {
      server_name,
      region_info,
    }
  }
  pub fn read_from_in_protocol(i_prot: &mut dyn TInputProtocol) -> thrift::Result<THRegionLocation> {
    i_prot.read_struct_begin()?;
    let mut f_1: Option<TServerName> = None;
    let mut f_2: Option<THRegionInfo> = None;
    loop {
      let field_ident = i_prot.read_field_begin()?;
      if field_ident.field_type == TType::Stop {
        break;
      }
      let field_id = field_id(&field_ident)?;
      match field_id {
        1 => {
          let val = TServerName::read_from_in_protocol(i_prot)?;
          f_1 = Some(val);
        },
        2 => {
          let val = THRegionInfo::read_from_in_protocol(i_prot)?;
          f_2 = Some(val);
        },
        _ => {
          i_prot.skip(field_ident.field_type)?;
        },
      };
      i_prot.read_field_end()?;
    }
    i_prot.read_struct_end()?;
    verify_required_field_exists("THRegionLocation.server_name", &f_1)?;
    verify_required_field_exists("THRegionLocation.region_info", &f_2)?;
    let ret = THRegionLocation {
      server_name: f_1.expect("auto-generated code should have checked for presence of required fields"),
      region_info: f_2.expect("auto-generated code should have checked for presence of required fields"),
    };
    Ok(ret)
  }
  pub fn write_to_out_protocol(&self, o_prot: &mut dyn TOutputProtocol) -> thrift::Result<()> {
    let struct_ident = TStructIdentifier::new("THRegionLocation");
    o_prot.write_struct_begin(&struct_ident)?;
    o_prot.write_field_begin(&TFieldIdentifier::new("serverName", TType::Struct, 1))?;
    self.server_name.write_to_out_protocol(o_prot)?;
    o_prot.write_field_end()?;
    o_prot.write_field_begin(&TFieldIdentifier::new("regionInfo", TType::Struct, 2))?;
    self.region_info.write_to_out_protocol(o_prot)?;
    o_prot.write_field_end()?;
    o_prot.write_field_stop()?;
    o_prot.write_struct_end()
  }
}

//
// TTableName
//

/// Thrift wrapper around
/// org.apache.hadoop.hbase.TableName
#[derive(Clone, Debug, Eq, Hash, Ord, PartialEq, PartialOrd)]
pub struct TTableName {
  /// namespace name
  pub ns: Option<Vec<u8>>,
  /// tablename
  pub qualifier: Vec<u8>,
}

impl TTableName {
  pub fn new<F1>(ns: F1, qualifier: Vec<u8>) -> TTableName where F1: Into<Option<Vec<u8>>> {
    TTableName {
      ns: ns.into(),
      qualifier,
    }
  }
  pub fn read_from_in_protocol(i_prot: &mut dyn TInputProtocol) -> thrift::Result<TTableName> {
    i_prot.read_struct_begin()?;
    let mut f_1: Option<Vec<u8>> = None;
    let mut f_2: Option<Vec<u8>> = None;
    loop {
      let field_ident = i_prot.read_field_begin()?;
      if field_ident.field_type == TType::Stop {
        break;
      }
      let field_id = field_id(&field_ident)?;
      match field_id {
        1 => {
          let val = i_prot.read_bytes()?;
          f_1 = Some(val);
        },
        2 => {
          let val = i_prot.read_bytes()?;
          f_2 = Some(val);
        },
        _ => {
          i_prot.skip(field_ident.field_type)?;
        },
      };
      i_prot.read_field_end()?;
    }
    i_prot.read_struct_end()?;
    verify_required_field_exists("TTableName.qualifier", &f_2)?;
    let ret = TTableName {
      ns: f_1,
      qualifier: f_2.expect("auto-generated code should have checked for presence of required fields"),
    };
    Ok(ret)
  }
  pub fn write_to_out_protocol(&self, o_prot: &mut dyn TOutputProtocol) -> thrift::Result<()> {
    let struct_ident = TStructIdentifier::new("TTableName");
    o_prot.write_struct_begin(&struct_ident)?;
    if let Some(ref fld_var) = self.ns {
      o_prot.write_field_begin(&TFieldIdentifier::new("ns", TType::String, 1))?;
      o_prot.write_bytes(fld_var)?;
      o_prot.write_field_end()?
    }
    o_prot.write_field_begin(&TFieldIdentifier::new("qualifier", TType::String, 2))?;
    o_prot.write_bytes(&self.qualifier)?;
    o_prot.write_field_end()?;
    o_prot.write_field_stop()?;
    o_prot.write_struct_end()
  }
}

//
// TColumnFamilyDescriptor
//

/// Thrift wrapper around
/// org.apache.hadoop.hbase.client.ColumnFamilyDescriptor
#[derive(Clone, Debug, Eq, Hash, Ord, PartialEq, PartialOrd)]
pub struct TColumnFamilyDescriptor {
  pub name: Vec<u8>,
  pub attributes: Option<BTreeMap<Vec<u8>, Vec<u8>>>,
  pub configuration: Option<BTreeMap<String, String>>,
  pub block_size: Option<i32>,
  pub bloomn_filter_type: Option<TBloomFilterType>,
  pub compression_type: Option<TCompressionAlgorithm>,
  pub dfs_replication: Option<i16>,
  pub data_block_encoding: Option<TDataBlockEncoding>,
  pub keep_deleted_cells: Option<TKeepDeletedCells>,
  pub max_versions: Option<i32>,
  pub min_versions: Option<i32>,
  pub scope: Option<i32>,
  pub time_to_live: Option<i32>,
  pub block_cache_enabled: Option<bool>,
  pub cache_blooms_on_write: Option<bool>,
  pub cache_data_on_write: Option<bool>,
  pub cache_indexes_on_write: Option<bool>,
  pub compress_tags: Option<bool>,
  pub evict_blocks_on_close: Option<bool>,
  pub in_memory: Option<bool>,
}

impl TColumnFamilyDescriptor {
  pub fn new<F2, F3, F4, F5, F6, F7, F8, F9, F10, F11, F12, F13, F14, F15, F16, F17, F18, F19, F20>(name: Vec<u8>, attributes: F2, configuration: F3, block_size: F4, bloomn_filter_type: F5, compression_type: F6, dfs_replication: F7, data_block_encoding: F8, keep_deleted_cells: F9, max_versions: F10, min_versions: F11, scope: F12, time_to_live: F13, block_cache_enabled: F14, cache_blooms_on_write: F15, cache_data_on_write: F16, cache_indexes_on_write: F17, compress_tags: F18, evict_blocks_on_close: F19, in_memory: F20) -> TColumnFamilyDescriptor where F2: Into<Option<BTreeMap<Vec<u8>, Vec<u8>>>>, F3: Into<Option<BTreeMap<String, String>>>, F4: Into<Option<i32>>, F5: Into<Option<TBloomFilterType>>, F6: Into<Option<TCompressionAlgorithm>>, F7: Into<Option<i16>>, F8: Into<Option<TDataBlockEncoding>>, F9: Into<Option<TKeepDeletedCells>>, F10: Into<Option<i32>>, F11: Into<Option<i32>>, F12: Into<Option<i32>>, F13: Into<Option<i32>>, F14: Into<Option<bool>>, F15: Into<Option<bool>>, F16: Into<Option<bool>>, F17: Into<Option<bool>>, F18: Into<Option<bool>>, F19: Into<Option<bool>>, F20: Into<Option<bool>> {
    TColumnFamilyDescriptor {
      name,
      attributes: attributes.into(),
      configuration: configuration.into(),
      block_size: block_size.into(),
      bloomn_filter_type: bloomn_filter_type.into(),
      compression_type: compression_type.into(),
      dfs_replication: dfs_replication.into(),
      data_block_encoding: data_block_encoding.into(),
      keep_deleted_cells: keep_deleted_cells.into(),
      max_versions: max_versions.into(),
      min_versions: min_versions.into(),
      scope: scope.into(),
      time_to_live: time_to_live.into(),
      block_cache_enabled: block_cache_enabled.into(),
      cache_blooms_on_write: cache_blooms_on_write.into(),
      cache_data_on_write: cache_data_on_write.into(),
      cache_indexes_on_write: cache_indexes_on_write.into(),
      compress_tags: compress_tags.into(),
      evict_blocks_on_close: evict_blocks_on_close.into(),
      in_memory: in_memory.into(),
    }
  }
  pub fn read_from_in_protocol(i_prot: &mut dyn TInputProtocol) -> thrift::Result<TColumnFamilyDescriptor> {
    i_prot.read_struct_begin()?;
    let mut f_1: Option<Vec<u8>> = None;
    let mut f_2: Option<BTreeMap<Vec<u8>, Vec<u8>>> = None;
    let mut f_3: Option<BTreeMap<String, String>> = None;
    let mut f_4: Option<i32> = None;
    let mut f_5: Option<TBloomFilterType> = None;
    let mut f_6: Option<TCompressionAlgorithm> = None;
    let mut f_7: Option<i16> = None;
    let mut f_8: Option<TDataBlockEncoding> = None;
    let mut f_9: Option<TKeepDeletedCells> = None;
    let mut f_10: Option<i32> = None;
    let mut f_11: Option<i32> = None;
    let mut f_12: Option<i32> = None;
    let mut f_13: Option<i32> = None;
    let mut f_14: Option<bool> = None;
    let mut f_15: Option<bool> = None;
    let mut f_16: Option<bool> = None;
    let mut f_17: Option<bool> = None;
    let mut f_18: Option<bool> = None;
    let mut f_19: Option<bool> = None;
    let mut f_20: Option<bool> = None;
    loop {
      let field_ident = i_prot.read_field_begin()?;
      if field_ident.field_type == TType::Stop {
        break;
      }
      let field_id = field_id(&field_ident)?;
      match field_id {
        1 => {
          let val = i_prot.read_bytes()?;
          f_1 = Some(val);
        },
        2 => {
          let map_ident = i_prot.read_map_begin()?;
          let mut val: BTreeMap<Vec<u8>, Vec<u8>> = BTreeMap::new();
          for _ in 0..map_ident.size {
            let map_key_23 = i_prot.read_bytes()?;
            let map_val_24 = i_prot.read_bytes()?;
            val.insert(map_key_23, map_val_24);
          }
          i_prot.read_map_end()?;
          f_2 = Some(val);
        },
        3 => {
          let map_ident = i_prot.read_map_begin()?;
          let mut val: BTreeMap<String, String> = BTreeMap::new();
          for _ in 0..map_ident.size {
            let map_key_25 = i_prot.read_string()?;
            let map_val_26 = i_prot.read_string()?;
            val.insert(map_key_25, map_val_26);
          }
          i_prot.read_map_end()?;
          f_3 = Some(val);
        },
        4 => {
          let val = i_prot.read_i32()?;
          f_4 = Some(val);
        },
        5 => {
          let val = TBloomFilterType::read_from_in_protocol(i_prot)?;
          f_5 = Some(val);
        },
        6 => {
          let val = TCompressionAlgorithm::read_from_in_protocol(i_prot)?;
          f_6 = Some(val);
        },
        7 => {
          let val = i_prot.read_i16()?;
          f_7 = Some(val);
        },
        8 => {
          let val = TDataBlockEncoding::read_from_in_protocol(i_prot)?;
          f_8 = Some(val);
        },
        9 => {
          let val = TKeepDeletedCells::read_from_in_protocol(i_prot)?;
          f_9 = Some(val);
        },
        10 => {
          let val = i_prot.read_i32()?;
          f_10 = Some(val);
        },
        11 => {
          let val = i_prot.read_i32()?;
          f_11 = Some(val);
        },
        12 => {
          let val = i_prot.read_i32()?;
          f_12 = Some(val);
        },
        13 => {
          let val = i_prot.read_i32()?;
          f_13 = Some(val);
        },
        14 => {
          let val = i_prot.read_bool()?;
          f_14 = Some(val);
        },
        15 => {
          let val = i_prot.read_bool()?;
          f_15 = Some(val);
        },
        16 => {
          let val = i_prot.read_bool()?;
          f_16 = Some(val);
        },
        17 => {
          let val = i_prot.read_bool()?;
          f_17 = Some(val);
        },
        18 => {
          let val = i_prot.read_bool()?;
          f_18 = Some(val);
        },
        19 => {
          let val = i_prot.read_bool()?;
          f_19 = Some(val);
        },
        20 => {
          let val = i_prot.read_bool()?;
          f_20 = Some(val);
        },
        _ => {
          i_prot.skip(field_ident.field_type)?;
        },
      };
      i_prot.read_field_end()?;
    }
    i_prot.read_struct_end()?;
    verify_required_field_exists("TColumnFamilyDescriptor.name", &f_1)?;
    let ret = TColumnFamilyDescriptor {
      name: f_1.expect("auto-generated code should have checked for presence of required fields"),
      attributes: f_2,
      configuration: f_3,
      block_size: f_4,
      bloomn_filter_type: f_5,
      compression_type: f_6,
      dfs_replication: f_7,
      data_block_encoding: f_8,
      keep_deleted_cells: f_9,
      max_versions: f_10,
      min_versions: f_11,
      scope: f_12,
      time_to_live: f_13,
      block_cache_enabled: f_14,
      cache_blooms_on_write: f_15,
      cache_data_on_write: f_16,
      cache_indexes_on_write: f_17,
      compress_tags: f_18,
      evict_blocks_on_close: f_19,
      in_memory: f_20,
    };
    Ok(ret)
  }
  pub fn write_to_out_protocol(&self, o_prot: &mut dyn TOutputProtocol) -> thrift::Result<()> {
    let struct_ident = TStructIdentifier::new("TColumnFamilyDescriptor");
    o_prot.write_struct_begin(&struct_ident)?;
    o_prot.write_field_begin(&TFieldIdentifier::new("name", TType::String, 1))?;
    o_prot.write_bytes(&self.name)?;
    o_prot.write_field_end()?;
    if let Some(ref fld_var) = self.attributes {
      o_prot.write_field_begin(&TFieldIdentifier::new("attributes", TType::Map, 2))?;
      o_prot.write_map_begin(&TMapIdentifier::new(TType::String, TType::String, fld_var.len() as i32))?;
      for (k, v) in fld_var {
        o_prot.write_bytes(k)?;
        o_prot.write_bytes(v)?;
      }
      o_prot.write_map_end()?;
      o_prot.write_field_end()?
    }
    if let Some(ref fld_var) = self.configuration {
      o_prot.write_field_begin(&TFieldIdentifier::new("configuration", TType::Map, 3))?;
      o_prot.write_map_begin(&TMapIdentifier::new(TType::String, TType::String, fld_var.len() as i32))?;
      for (k, v) in fld_var {
        o_prot.write_string(k)?;
        o_prot.write_string(v)?;
      }
      o_prot.write_map_end()?;
      o_prot.write_field_end()?
    }
    if let Some(fld_var) = self.block_size {
      o_prot.write_field_begin(&TFieldIdentifier::new("blockSize", TType::I32, 4))?;
      o_prot.write_i32(fld_var)?;
      o_prot.write_field_end()?
    }
    if let Some(ref fld_var) = self.bloomn_filter_type {
      o_prot.write_field_begin(&TFieldIdentifier::new("bloomnFilterType", TType::I32, 5))?;
      fld_var.write_to_out_protocol(o_prot)?;
      o_prot.write_field_end()?
    }
    if let Some(ref fld_var) = self.compression_type {
      o_prot.write_field_begin(&TFieldIdentifier::new("compressionType", TType::I32, 6))?;
      fld_var.write_to_out_protocol(o_prot)?;
      o_prot.write_field_end()?
    }
    if let Some(fld_var) = self.dfs_replication {
      o_prot.write_field_begin(&TFieldIdentifier::new("dfsReplication", TType::I16, 7))?;
      o_prot.write_i16(fld_var)?;
      o_prot.write_field_end()?
    }
    if let Some(ref fld_var) = self.data_block_encoding {
      o_prot.write_field_begin(&TFieldIdentifier::new("dataBlockEncoding", TType::I32, 8))?;
      fld_var.write_to_out_protocol(o_prot)?;
      o_prot.write_field_end()?
    }
    if let Some(ref fld_var) = self.keep_deleted_cells {
      o_prot.write_field_begin(&TFieldIdentifier::new("keepDeletedCells", TType::I32, 9))?;
      fld_var.write_to_out_protocol(o_prot)?;
      o_prot.write_field_end()?
    }
    if let Some(fld_var) = self.max_versions {
      o_prot.write_field_begin(&TFieldIdentifier::new("maxVersions", TType::I32, 10))?;
      o_prot.write_i32(fld_var)?;
      o_prot.write_field_end()?
    }
    if let Some(fld_var) = self.min_versions {
      o_prot.write_field_begin(&TFieldIdentifier::new("minVersions", TType::I32, 11))?;
      o_prot.write_i32(fld_var)?;
      o_prot.write_field_end()?
    }
    if let Some(fld_var) = self.scope {
      o_prot.write_field_begin(&TFieldIdentifier::new("scope", TType::I32, 12))?;
      o_prot.write_i32(fld_var)?;
      o_prot.write_field_end()?
    }
    if let Some(fld_var) = self.time_to_live {
      o_prot.write_field_begin(&TFieldIdentifier::new("timeToLive", TType::I32, 13))?;
      o_prot.write_i32(fld_var)?;
      o_prot.write_field_end()?
    }
    if let Some(fld_var) = self.block_cache_enabled {
      o_prot.write_field_begin(&TFieldIdentifier::new("blockCacheEnabled", TType::Bool, 14))?;
      o_prot.write_bool(fld_var)?;
      o_prot.write_field_end()?
    }
    if let Some(fld_var) = self.cache_blooms_on_write {
      o_prot.write_field_begin(&TFieldIdentifier::new("cacheBloomsOnWrite", TType::Bool, 15))?;
      o_prot.write_bool(fld_var)?;
      o_prot.write_field_end()?
    }
    if let Some(fld_var) = self.cache_data_on_write {
      o_prot.write_field_begin(&TFieldIdentifier::new("cacheDataOnWrite", TType::Bool, 16))?;
      o_prot.write_bool(fld_var)?;
      o_prot.write_field_end()?
    }
    if let Some(fld_var) = self.cache_indexes_on_write {
      o_prot.write_field_begin(&TFieldIdentifier::new("cacheIndexesOnWrite", TType::Bool, 17))?;
      o_prot.write_bool(fld_var)?;
      o_prot.write_field_end()?
    }
    if let Some(fld_var) = self.compress_tags {
      o_prot.write_field_begin(&TFieldIdentifier::new("compressTags", TType::Bool, 18))?;
      o_prot.write_bool(fld_var)?;
      o_prot.write_field_end()?
    }
    if let Some(fld_var) = self.evict_blocks_on_close {
      o_prot.write_field_begin(&TFieldIdentifier::new("evictBlocksOnClose", TType::Bool, 19))?;
      o_prot.write_bool(fld_var)?;
      o_prot.write_field_end()?
    }
    if let Some(fld_var) = self.in_memory {
      o_prot.write_field_begin(&TFieldIdentifier::new("inMemory", TType::Bool, 20))?;
      o_prot.write_bool(fld_var)?;
      o_prot.write_field_end()?
    }
    o_prot.write_field_stop()?;
    o_prot.write_struct_end()
  }
}

//
// TTableDescriptor
//

/// Thrift wrapper around
/// org.apache.hadoop.hbase.client.TableDescriptor
#[derive(Clone, Debug, Eq, Hash, Ord, PartialEq, PartialOrd)]
pub struct TTableDescriptor {
  pub table_name: TTableName,
  pub columns: Option<Vec<TColumnFamilyDescriptor>>,
  pub attributes: Option<BTreeMap<Vec<u8>, Vec<u8>>>,
  pub durability: Option<TDurability>,
}

impl TTableDescriptor {
  pub fn new<F2, F3, F4>(table_name: TTableName, columns: F2, attributes: F3, durability: F4) -> TTableDescriptor where F2: Into<Option<Vec<TColumnFamilyDescriptor>>>, F3: Into<Option<BTreeMap<Vec<u8>, Vec<u8>>>>, F4: Into<Option<TDurability>> {
    TTableDescriptor {
      table_name,
      columns: columns.into(),
      attributes: attributes.into(),
      durability: durability.into(),
    }
  }
  pub fn read_from_in_protocol(i_prot: &mut dyn TInputProtocol) -> thrift::Result<TTableDescriptor> {
    i_prot.read_struct_begin()?;
    let mut f_1: Option<TTableName> = None;
    let mut f_2: Option<Vec<TColumnFamilyDescriptor>> = None;
    let mut f_3: Option<BTreeMap<Vec<u8>, Vec<u8>>> = None;
    let mut f_4: Option<TDurability> = None;
    loop {
      let field_ident = i_prot.read_field_begin()?;
      if field_ident.field_type == TType::Stop {
        break;
      }
      let field_id = field_id(&field_ident)?;
      match field_id {
        1 => {
          let val = TTableName::read_from_in_protocol(i_prot)?;
          f_1 = Some(val);
        },
        2 => {
          let list_ident = i_prot.read_list_begin()?;
          let mut val: Vec<TColumnFamilyDescriptor> = Vec::with_capacity(list_ident.size as usize);
          for _ in 0..list_ident.size {
            let list_elem_27 = TColumnFamilyDescriptor::read_from_in_protocol(i_prot)?;
            val.push(list_elem_27);
          }
          i_prot.read_list_end()?;
          f_2 = Some(val);
        },
        3 => {
          let map_ident = i_prot.read_map_begin()?;
          let mut val: BTreeMap<Vec<u8>, Vec<u8>> = BTreeMap::new();
          for _ in 0..map_ident.size {
            let map_key_28 = i_prot.read_bytes()?;
            let map_val_29 = i_prot.read_bytes()?;
            val.insert(map_key_28, map_val_29);
          }
          i_prot.read_map_end()?;
          f_3 = Some(val);
        },
        4 => {
          let val = TDurability::read_from_in_protocol(i_prot)?;
          f_4 = Some(val);
        },
        _ => {
          i_prot.skip(field_ident.field_type)?;
        },
      };
      i_prot.read_field_end()?;
    }
    i_prot.read_struct_end()?;
    verify_required_field_exists("TTableDescriptor.table_name", &f_1)?;
    let ret = TTableDescriptor {
      table_name: f_1.expect("auto-generated code should have checked for presence of required fields"),
      columns: f_2,
      attributes: f_3,
      durability: f_4,
    };
    Ok(ret)
  }
  pub fn write_to_out_protocol(&self, o_prot: &mut dyn TOutputProtocol) -> thrift::Result<()> {
    let struct_ident = TStructIdentifier::new("TTableDescriptor");
    o_prot.write_struct_begin(&struct_ident)?;
    o_prot.write_field_begin(&TFieldIdentifier::new("tableName", TType::Struct, 1))?;
    self.table_name.write_to_out_protocol(o_prot)?;
    o_prot.write_field_end()?;
    if let Some(ref fld_var) = self.columns {
      o_prot.write_field_begin(&TFieldIdentifier::new("columns", TType::List, 2))?;
      o_prot.write_list_begin(&TListIdentifier::new(TType::Struct, fld_var.len() as i32))?;
      for e in fld_var {
        e.write_to_out_protocol(o_prot)?;
      }
      o_prot.write_list_end()?;
      o_prot.write_field_end()?
    }
    if let Some(ref fld_var) = self.attributes {
      o_prot.write_field_begin(&TFieldIdentifier::new("attributes", TType::Map, 3))?;
      o_prot.write_map_begin(&TMapIdentifier::new(TType::String, TType::String, fld_var.len() as i32))?;
      for (k, v) in fld_var {
        o_prot.write_bytes(k)?;
        o_prot.write_bytes(v)?;
      }
      o_prot.write_map_end()?;
      o_prot.write_field_end()?
    }
    if let Some(ref fld_var) = self.durability {
      o_prot.write_field_begin(&TFieldIdentifier::new("durability", TType::I32, 4))?;
      fld_var.write_to_out_protocol(o_prot)?;
      o_prot.write_field_end()?
    }
    o_prot.write_field_stop()?;
    o_prot.write_struct_end()
  }
}

//
// TNamespaceDescriptor
//

/// Thrift wrapper around
/// org.apache.hadoop.hbase.NamespaceDescriptor
#[derive(Clone, Debug, Eq, Hash, Ord, PartialEq, PartialOrd)]
pub struct TNamespaceDescriptor {
  pub name: String,
  pub configuration: Option<BTreeMap<String, String>>,
}

impl TNamespaceDescriptor {
  pub fn new<F2>(name: String, configuration: F2) -> TNamespaceDescriptor where F2: Into<Option<BTreeMap<String, String>>> {
    TNamespaceDescriptor {
      name,
      configuration: configuration.into(),
    }
  }
  pub fn read_from_in_protocol(i_prot: &mut dyn TInputProtocol) -> thrift::Result<TNamespaceDescriptor> {
    i_prot.read_struct_begin()?;
    let mut f_1: Option<String> = None;
    let mut f_2: Option<BTreeMap<String, String>> = None;
    loop {
      let field_ident = i_prot.read_field_begin()?;
      if field_ident.field_type == TType::Stop {
        break;
      }
      let field_id = field_id(&field_ident)?;
      match field_id {
        1 => {
          let val = i_prot.read_string()?;
          f_1 = Some(val);
        },
        2 => {
          let map_ident = i_prot.read_map_begin()?;
          let mut val: BTreeMap<String, String> = BTreeMap::new();
          for _ in 0..map_ident.size {
            let map_key_30 = i_prot.read_string()?;
            let map_val_31 = i_prot.read_string()?;
            val.insert(map_key_30, map_val_31);
          }
          i_prot.read_map_end()?;
          f_2 = Some(val);
        },
        _ => {
          i_prot.skip(field_ident.field_type)?;
        },
      };
      i_prot.read_field_end()?;
    }
    i_prot.read_struct_end()?;
    verify_required_field_exists("TNamespaceDescriptor.name", &f_1)?;
    let ret = TNamespaceDescriptor {
      name: f_1.expect("auto-generated code should have checked for presence of required fields"),
      configuration: f_2,
    };
    Ok(ret)
  }
  pub fn write_to_out_protocol(&self, o_prot: &mut dyn TOutputProtocol) -> thrift::Result<()> {
    let struct_ident = TStructIdentifier::new("TNamespaceDescriptor");
    o_prot.write_struct_begin(&struct_ident)?;
    o_prot.write_field_begin(&TFieldIdentifier::new("name", TType::String, 1))?;
    o_prot.write_string(&self.name)?;
    o_prot.write_field_end()?;
    if let Some(ref fld_var) = self.configuration {
      o_prot.write_field_begin(&TFieldIdentifier::new("configuration", TType::Map, 2))?;
      o_prot.write_map_begin(&TMapIdentifier::new(TType::String, TType::String, fld_var.len() as i32))?;
      for (k, v) in fld_var {
        o_prot.write_string(k)?;
        o_prot.write_string(v)?;
      }
      o_prot.write_map_end()?;
      o_prot.write_field_end()?
    }
    o_prot.write_field_stop()?;
    o_prot.write_struct_end()
  }
}

//
// TLogQueryFilter
//

/// Thrift wrapper around
/// org.apache.hadoop.hbase.client.LogQueryFilter
#[derive(Clone, Debug, Eq, Hash, Ord, PartialEq, PartialOrd)]
pub struct TLogQueryFilter {
  pub region_name: Option<String>,
  pub client_address: Option<String>,
  pub table_name: Option<String>,
  pub user_name: Option<String>,
  pub limit: Option<i32>,
  pub log_type: Option<TLogType>,
  pub filter_by_operator: Option<TFilterByOperator>,
}

impl TLogQueryFilter {
  pub fn new<F1, F2, F3, F4, F5, F6, F7>(region_name: F1, client_address: F2, table_name: F3, user_name: F4, limit: F5, log_type: F6, filter_by_operator: F7) -> TLogQueryFilter where F1: Into<Option<String>>, F2: Into<Option<String>>, F3: Into<Option<String>>, F4: Into<Option<String>>, F5: Into<Option<i32>>, F6: Into<Option<TLogType>>, F7: Into<Option<TFilterByOperator>> {
    TLogQueryFilter {
      region_name: region_name.into(),
      client_address: client_address.into(),
      table_name: table_name.into(),
      user_name: user_name.into(),
      limit: limit.into(),
      log_type: log_type.into(),
      filter_by_operator: filter_by_operator.into(),
    }
  }
  pub fn read_from_in_protocol(i_prot: &mut dyn TInputProtocol) -> thrift::Result<TLogQueryFilter> {
    i_prot.read_struct_begin()?;
    let mut f_1: Option<String> = None;
    let mut f_2: Option<String> = None;
    let mut f_3: Option<String> = None;
    let mut f_4: Option<String> = None;
    let mut f_5: Option<i32> = None;
    let mut f_6: Option<TLogType> = None;
    let mut f_7: Option<TFilterByOperator> = None;
    loop {
      let field_ident = i_prot.read_field_begin()?;
      if field_ident.field_type == TType::Stop {
        break;
      }
      let field_id = field_id(&field_ident)?;
      match field_id {
        1 => {
          let val = i_prot.read_string()?;
          f_1 = Some(val);
        },
        2 => {
          let val = i_prot.read_string()?;
          f_2 = Some(val);
        },
        3 => {
          let val = i_prot.read_string()?;
          f_3 = Some(val);
        },
        4 => {
          let val = i_prot.read_string()?;
          f_4 = Some(val);
        },
        5 => {
          let val = i_prot.read_i32()?;
          f_5 = Some(val);
        },
        6 => {
          let val = TLogType::read_from_in_protocol(i_prot)?;
          f_6 = Some(val);
        },
        7 => {
          let val = TFilterByOperator::read_from_in_protocol(i_prot)?;
          f_7 = Some(val);
        },
        _ => {
          i_prot.skip(field_ident.field_type)?;
        },
      };
      i_prot.read_field_end()?;
    }
    i_prot.read_struct_end()?;
    let ret = TLogQueryFilter {
      region_name: f_1,
      client_address: f_2,
      table_name: f_3,
      user_name: f_4,
      limit: f_5,
      log_type: f_6,
      filter_by_operator: f_7,
    };
    Ok(ret)
  }
  pub fn write_to_out_protocol(&self, o_prot: &mut dyn TOutputProtocol) -> thrift::Result<()> {
    let struct_ident = TStructIdentifier::new("TLogQueryFilter");
    o_prot.write_struct_begin(&struct_ident)?;
    if let Some(ref fld_var) = self.region_name {
      o_prot.write_field_begin(&TFieldIdentifier::new("regionName", TType::String, 1))?;
      o_prot.write_string(fld_var)?;
      o_prot.write_field_end()?
    }
    if let Some(ref fld_var) = self.client_address {
      o_prot.write_field_begin(&TFieldIdentifier::new("clientAddress", TType::String, 2))?;
      o_prot.write_string(fld_var)?;
      o_prot.write_field_end()?
    }
    if let Some(ref fld_var) = self.table_name {
      o_prot.write_field_begin(&TFieldIdentifier::new("tableName", TType::String, 3))?;
      o_prot.write_string(fld_var)?;
      o_prot.write_field_end()?
    }
    if let Some(ref fld_var) = self.user_name {
      o_prot.write_field_begin(&TFieldIdentifier::new("userName", TType::String, 4))?;
      o_prot.write_string(fld_var)?;
      o_prot.write_field_end()?
    }
    if let Some(fld_var) = self.limit {
      o_prot.write_field_begin(&TFieldIdentifier::new("limit", TType::I32, 5))?;
      o_prot.write_i32(fld_var)?;
      o_prot.write_field_end()?
    }
    if let Some(ref fld_var) = self.log_type {
      o_prot.write_field_begin(&TFieldIdentifier::new("logType", TType::I32, 6))?;
      fld_var.write_to_out_protocol(o_prot)?;
      o_prot.write_field_end()?
    }
    if let Some(ref fld_var) = self.filter_by_operator {
      o_prot.write_field_begin(&TFieldIdentifier::new("filterByOperator", TType::I32, 7))?;
      fld_var.write_to_out_protocol(o_prot)?;
      o_prot.write_field_end()?
    }
    o_prot.write_field_stop()?;
    o_prot.write_struct_end()
  }
}

impl Default for TLogQueryFilter {
  fn default() -> Self {
    TLogQueryFilter{
      region_name: Some("".to_owned()),
      client_address: Some("".to_owned()),
      table_name: Some("".to_owned()),
      user_name: Some("".to_owned()),
      limit: Some(0),
      log_type: None,
      filter_by_operator: None,
    }
  }
}

//
// TOnlineLogRecord
//

/// Thrift wrapper around
/// org.apache.hadoop.hbase.client.OnlineLogRecordrd
#[derive(Clone, Debug, Eq, Hash, Ord, PartialEq, PartialOrd)]
pub struct TOnlineLogRecord {
  pub start_time: i64,
  pub processing_time: i32,
  pub queue_time: i32,
  pub response_size: i64,
  pub client_address: String,
  pub server_class: String,
  pub method_name: String,
  pub call_details: String,
  pub param: String,
  pub user_name: String,
  pub multi_gets_count: i32,
  pub multi_mutations_count: i32,
  pub multi_service_calls: i32,
  pub region_name: Option<String>,
}

impl TOnlineLogRecord {
  pub fn new<F14>(start_time: i64, processing_time: i32, queue_time: i32, response_size: i64, client_address: String, server_class: String, method_name: String, call_details: String, param: String, user_name: String, multi_gets_count: i32, multi_mutations_count: i32, multi_service_calls: i32, region_name: F14) -> TOnlineLogRecord where F14: Into<Option<String>> {
    TOnlineLogRecord {
      start_time,
      processing_time,
      queue_time,
      response_size,
      client_address,
      server_class,
      method_name,
      call_details,
      param,
      user_name,
      multi_gets_count,
      multi_mutations_count,
      multi_service_calls,
      region_name: region_name.into(),
    }
  }
  pub fn read_from_in_protocol(i_prot: &mut dyn TInputProtocol) -> thrift::Result<TOnlineLogRecord> {
    i_prot.read_struct_begin()?;
    let mut f_1: Option<i64> = None;
    let mut f_2: Option<i32> = None;
    let mut f_3: Option<i32> = None;
    let mut f_4: Option<i64> = None;
    let mut f_5: Option<String> = None;
    let mut f_6: Option<String> = None;
    let mut f_7: Option<String> = None;
    let mut f_8: Option<String> = None;
    let mut f_9: Option<String> = None;
    let mut f_10: Option<String> = None;
    let mut f_11: Option<i32> = None;
    let mut f_12: Option<i32> = None;
    let mut f_13: Option<i32> = None;
    let mut f_14: Option<String> = None;
    loop {
      let field_ident = i_prot.read_field_begin()?;
      if field_ident.field_type == TType::Stop {
        break;
      }
      let field_id = field_id(&field_ident)?;
      match field_id {
        1 => {
          let val = i_prot.read_i64()?;
          f_1 = Some(val);
        },
        2 => {
          let val = i_prot.read_i32()?;
          f_2 = Some(val);
        },
        3 => {
          let val = i_prot.read_i32()?;
          f_3 = Some(val);
        },
        4 => {
          let val = i_prot.read_i64()?;
          f_4 = Some(val);
        },
        5 => {
          let val = i_prot.read_string()?;
          f_5 = Some(val);
        },
        6 => {
          let val = i_prot.read_string()?;
          f_6 = Some(val);
        },
        7 => {
          let val = i_prot.read_string()?;
          f_7 = Some(val);
        },
        8 => {
          let val = i_prot.read_string()?;
          f_8 = Some(val);
        },
        9 => {
          let val = i_prot.read_string()?;
          f_9 = Some(val);
        },
        10 => {
          let val = i_prot.read_string()?;
          f_10 = Some(val);
        },
        11 => {
          let val = i_prot.read_i32()?;
          f_11 = Some(val);
        },
        12 => {
          let val = i_prot.read_i32()?;
          f_12 = Some(val);
        },
        13 => {
          let val = i_prot.read_i32()?;
          f_13 = Some(val);
        },
        14 => {
          let val = i_prot.read_string()?;
          f_14 = Some(val);
        },
        _ => {
          i_prot.skip(field_ident.field_type)?;
        },
      };
      i_prot.read_field_end()?;
    }
    i_prot.read_struct_end()?;
    verify_required_field_exists("TOnlineLogRecord.start_time", &f_1)?;
    verify_required_field_exists("TOnlineLogRecord.processing_time", &f_2)?;
    verify_required_field_exists("TOnlineLogRecord.queue_time", &f_3)?;
    verify_required_field_exists("TOnlineLogRecord.response_size", &f_4)?;
    verify_required_field_exists("TOnlineLogRecord.client_address", &f_5)?;
    verify_required_field_exists("TOnlineLogRecord.server_class", &f_6)?;
    verify_required_field_exists("TOnlineLogRecord.method_name", &f_7)?;
    verify_required_field_exists("TOnlineLogRecord.call_details", &f_8)?;
    verify_required_field_exists("TOnlineLogRecord.param", &f_9)?;
    verify_required_field_exists("TOnlineLogRecord.user_name", &f_10)?;
    verify_required_field_exists("TOnlineLogRecord.multi_gets_count", &f_11)?;
    verify_required_field_exists("TOnlineLogRecord.multi_mutations_count", &f_12)?;
    verify_required_field_exists("TOnlineLogRecord.multi_service_calls", &f_13)?;
    let ret = TOnlineLogRecord {
      start_time: f_1.expect("auto-generated code should have checked for presence of required fields"),
      processing_time: f_2.expect("auto-generated code should have checked for presence of required fields"),
      queue_time: f_3.expect("auto-generated code should have checked for presence of required fields"),
      response_size: f_4.expect("auto-generated code should have checked for presence of required fields"),
      client_address: f_5.expect("auto-generated code should have checked for presence of required fields"),
      server_class: f_6.expect("auto-generated code should have checked for presence of required fields"),
      method_name: f_7.expect("auto-generated code should have checked for presence of required fields"),
      call_details: f_8.expect("auto-generated code should have checked for presence of required fields"),
      param: f_9.expect("auto-generated code should have checked for presence of required fields"),
      user_name: f_10.expect("auto-generated code should have checked for presence of required fields"),
      multi_gets_count: f_11.expect("auto-generated code should have checked for presence of required fields"),
      multi_mutations_count: f_12.expect("auto-generated code should have checked for presence of required fields"),
      multi_service_calls: f_13.expect("auto-generated code should have checked for presence of required fields"),
      region_name: f_14,
    };
    Ok(ret)
  }
  pub fn write_to_out_protocol(&self, o_prot: &mut dyn TOutputProtocol) -> thrift::Result<()> {
    let struct_ident = TStructIdentifier::new("TOnlineLogRecord");
    o_prot.write_struct_begin(&struct_ident)?;
    o_prot.write_field_begin(&TFieldIdentifier::new("startTime", TType::I64, 1))?;
    o_prot.write_i64(self.start_time)?;
    o_prot.write_field_end()?;
    o_prot.write_field_begin(&TFieldIdentifier::new("processingTime", TType::I32, 2))?;
    o_prot.write_i32(self.processing_time)?;
    o_prot.write_field_end()?;
    o_prot.write_field_begin(&TFieldIdentifier::new("queueTime", TType::I32, 3))?;
    o_prot.write_i32(self.queue_time)?;
    o_prot.write_field_end()?;
    o_prot.write_field_begin(&TFieldIdentifier::new("responseSize", TType::I64, 4))?;
    o_prot.write_i64(self.response_size)?;
    o_prot.write_field_end()?;
    o_prot.write_field_begin(&TFieldIdentifier::new("clientAddress", TType::String, 5))?;
    o_prot.write_string(&self.client_address)?;
    o_prot.write_field_end()?;
    o_prot.write_field_begin(&TFieldIdentifier::new("serverClass", TType::String, 6))?;
    o_prot.write_string(&self.server_class)?;
    o_prot.write_field_end()?;
    o_prot.write_field_begin(&TFieldIdentifier::new("methodName", TType::String, 7))?;
    o_prot.write_string(&self.method_name)?;
    o_prot.write_field_end()?;
    o_prot.write_field_begin(&TFieldIdentifier::new("callDetails", TType::String, 8))?;
    o_prot.write_string(&self.call_details)?;
    o_prot.write_field_end()?;
    o_prot.write_field_begin(&TFieldIdentifier::new("param", TType::String, 9))?;
    o_prot.write_string(&self.param)?;
    o_prot.write_field_end()?;
    o_prot.write_field_begin(&TFieldIdentifier::new("userName", TType::String, 10))?;
    o_prot.write_string(&self.user_name)?;
    o_prot.write_field_end()?;
    o_prot.write_field_begin(&TFieldIdentifier::new("multiGetsCount", TType::I32, 11))?;
    o_prot.write_i32(self.multi_gets_count)?;
    o_prot.write_field_end()?;
    o_prot.write_field_begin(&TFieldIdentifier::new("multiMutationsCount", TType::I32, 12))?;
    o_prot.write_i32(self.multi_mutations_count)?;
    o_prot.write_field_end()?;
    o_prot.write_field_begin(&TFieldIdentifier::new("multiServiceCalls", TType::I32, 13))?;
    o_prot.write_i32(self.multi_service_calls)?;
    o_prot.write_field_end()?;
    if let Some(ref fld_var) = self.region_name {
      o_prot.write_field_begin(&TFieldIdentifier::new("regionName", TType::String, 14))?;
      o_prot.write_string(fld_var)?;
      o_prot.write_field_end()?
    }
    o_prot.write_field_stop()?;
    o_prot.write_struct_end()
  }
}

//
// TIOError
//

/// A TIOError exception signals that an error occurred communicating
/// to the HBase master or a HBase region server. Also used to return
/// more general HBase error conditions.
#[derive(Clone, Debug, Eq, Hash, Ord, PartialEq, PartialOrd)]
pub struct TIOError {
  pub message: Option<String>,
  pub can_retry: Option<bool>,
}

impl TIOError {
  pub fn new<F1, F2>(message: F1, can_retry: F2) -> TIOError where F1: Into<Option<String>>, F2: Into<Option<bool>> {
    TIOError {
      message: message.into(),
      can_retry: can_retry.into(),
    }
  }
  pub fn read_from_in_protocol(i_prot: &mut dyn TInputProtocol) -> thrift::Result<TIOError> {
    i_prot.read_struct_begin()?;
    let mut f_1: Option<String> = None;
    let mut f_2: Option<bool> = None;
    loop {
      let field_ident = i_prot.read_field_begin()?;
      if field_ident.field_type == TType::Stop {
        break;
      }
      let field_id = field_id(&field_ident)?;
      match field_id {
        1 => {
          let val = i_prot.read_string()?;
          f_1 = Some(val);
        },
        2 => {
          let val = i_prot.read_bool()?;
          f_2 = Some(val);
        },
        _ => {
          i_prot.skip(field_ident.field_type)?;
        },
      };
      i_prot.read_field_end()?;
    }
    i_prot.read_struct_end()?;
    let ret = TIOError {
      message: f_1,
      can_retry: f_2,
    };
    Ok(ret)
  }
  pub fn write_to_out_protocol(&self, o_prot: &mut dyn TOutputProtocol) -> thrift::Result<()> {
    let struct_ident = TStructIdentifier::new("TIOError");
    o_prot.write_struct_begin(&struct_ident)?;
    if let Some(ref fld_var) = self.message {
      o_prot.write_field_begin(&TFieldIdentifier::new("message", TType::String, 1))?;
      o_prot.write_string(fld_var)?;
      o_prot.write_field_end()?
    }
    if let Some(fld_var) = self.can_retry {
      o_prot.write_field_begin(&TFieldIdentifier::new("canRetry", TType::Bool, 2))?;
      o_prot.write_bool(fld_var)?;
      o_prot.write_field_end()?
    }
    o_prot.write_field_stop()?;
    o_prot.write_struct_end()
  }
}

impl Default for TIOError {
  fn default() -> Self {
    TIOError{
      message: Some("".to_owned()),
      can_retry: Some(false),
    }
  }
}

impl Error for TIOError {}

impl From<TIOError> for thrift::Error {
  fn from(e: TIOError) -> Self {
    thrift::Error::User(Box::new(e))
  }
}

impl Display for TIOError {
  fn fmt(&self, f: &mut Formatter) -> fmt::Result {
    write!(f, "remote service threw TIOError")
  }
}

//
// TIllegalArgument
//

/// A TIllegalArgument exception indicates an illegal or invalid
/// argument was passed into a procedure.
#[derive(Clone, Debug, Eq, Hash, Ord, PartialEq, PartialOrd)]
pub struct TIllegalArgument {
  pub message: Option<String>,
}

impl TIllegalArgument {
  pub fn new<F1>(message: F1) -> TIllegalArgument where F1: Into<Option<String>> {
    TIllegalArgument {
      message: message.into(),
    }
  }
  pub fn read_from_in_protocol(i_prot: &mut dyn TInputProtocol) -> thrift::Result<TIllegalArgument> {
    i_prot.read_struct_begin()?;
    let mut f_1: Option<String> = None;
    loop {
      let field_ident = i_prot.read_field_begin()?;
      if field_ident.field_type == TType::Stop {
        break;
      }
      let field_id = field_id(&field_ident)?;
      match field_id {
        1 => {
          let val = i_prot.read_string()?;
          f_1 = Some(val);
        },
        _ => {
          i_prot.skip(field_ident.field_type)?;
        },
      };
      i_prot.read_field_end()?;
    }
    i_prot.read_struct_end()?;
    let ret = TIllegalArgument {
      message: f_1,
    };
    Ok(ret)
  }
  pub fn write_to_out_protocol(&self, o_prot: &mut dyn TOutputProtocol) -> thrift::Result<()> {
    let struct_ident = TStructIdentifier::new("TIllegalArgument");
    o_prot.write_struct_begin(&struct_ident)?;
    if let Some(ref fld_var) = self.message {
      o_prot.write_field_begin(&TFieldIdentifier::new("message", TType::String, 1))?;
      o_prot.write_string(fld_var)?;
      o_prot.write_field_end()?
    }
    o_prot.write_field_stop()?;
    o_prot.write_struct_end()
  }
}

impl Default for TIllegalArgument {
  fn default() -> Self {
    TIllegalArgument{
      message: Some("".to_owned()),
    }
  }
}

impl Error for TIllegalArgument {}

impl From<TIllegalArgument> for thrift::Error {
  fn from(e: TIllegalArgument) -> Self {
    thrift::Error::User(Box::new(e))
  }
}

impl Display for TIllegalArgument {
  fn fmt(&self, f: &mut Formatter) -> fmt::Result {
    write!(f, "remote service threw TIllegalArgument")
  }
}

//
// TAccessControlEntity
//

/// TAccessControlEntity for permission control
#[derive(Clone, Debug, Eq, Hash, Ord, PartialEq, PartialOrd)]
pub struct TAccessControlEntity {
  pub username: String,
  pub scope: TPermissionScope,
  pub actions: String,
  pub table_name: Option<String>,
  pub ns_name: Option<String>,
}

impl TAccessControlEntity {
  pub fn new<F5, F6>(username: String, scope: TPermissionScope, actions: String, table_name: F5, ns_name: F6) -> TAccessControlEntity where F5: Into<Option<String>>, F6: Into<Option<String>> {
    TAccessControlEntity {
      username,
      scope,
      actions,
      table_name: table_name.into(),
      ns_name: ns_name.into(),
    }
  }
  pub fn read_from_in_protocol(i_prot: &mut dyn TInputProtocol) -> thrift::Result<TAccessControlEntity> {
    i_prot.read_struct_begin()?;
    let mut f_1: Option<String> = None;
    let mut f_2: Option<TPermissionScope> = None;
    let mut f_4: Option<String> = None;
    let mut f_5: Option<String> = None;
    let mut f_6: Option<String> = None;
    loop {
      let field_ident = i_prot.read_field_begin()?;
      if field_ident.field_type == TType::Stop {
        break;
      }
      let field_id = field_id(&field_ident)?;
      match field_id {
        1 => {
          let val = i_prot.read_string()?;
          f_1 = Some(val);
        },
        2 => {
          let val = TPermissionScope::read_from_in_protocol(i_prot)?;
          f_2 = Some(val);
        },
        4 => {
          let val = i_prot.read_string()?;
          f_4 = Some(val);
        },
        5 => {
          let val = i_prot.read_string()?;
          f_5 = Some(val);
        },
        6 => {
          let val = i_prot.read_string()?;
          f_6 = Some(val);
        },
        _ => {
          i_prot.skip(field_ident.field_type)?;
        },
      };
      i_prot.read_field_end()?;
    }
    i_prot.read_struct_end()?;
    verify_required_field_exists("TAccessControlEntity.username", &f_1)?;
    verify_required_field_exists("TAccessControlEntity.scope", &f_2)?;
    verify_required_field_exists("TAccessControlEntity.actions", &f_4)?;
    let ret = TAccessControlEntity {
      username: f_1.expect("auto-generated code should have checked for presence of required fields"),
      scope: f_2.expect("auto-generated code should have checked for presence of required fields"),
      actions: f_4.expect("auto-generated code should have checked for presence of required fields"),
      table_name: f_5,
      ns_name: f_6,
    };
    Ok(ret)
  }
  pub fn write_to_out_protocol(&self, o_prot: &mut dyn TOutputProtocol) -> thrift::Result<()> {
    let struct_ident = TStructIdentifier::new("TAccessControlEntity");
    o_prot.write_struct_begin(&struct_ident)?;
    o_prot.write_field_begin(&TFieldIdentifier::new("username", TType::String, 1))?;
    o_prot.write_string(&self.username)?;
    o_prot.write_field_end()?;
    o_prot.write_field_begin(&TFieldIdentifier::new("scope", TType::I32, 2))?;
    self.scope.write_to_out_protocol(o_prot)?;
    o_prot.write_field_end()?;
    o_prot.write_field_begin(&TFieldIdentifier::new("actions", TType::String, 4))?;
    o_prot.write_string(&self.actions)?;
    o_prot.write_field_end()?;
    if let Some(ref fld_var) = self.table_name {
      o_prot.write_field_begin(&TFieldIdentifier::new("tableName", TType::String, 5))?;
      o_prot.write_string(fld_var)?;
      o_prot.write_field_end()?
    }
    if let Some(ref fld_var) = self.ns_name {
      o_prot.write_field_begin(&TFieldIdentifier::new("nsName", TType::String, 6))?;
      o_prot.write_string(fld_var)?;
      o_prot.write_field_end()?
    }
    o_prot.write_field_stop()?;
    o_prot.write_struct_end()
  }
}

//
// THBaseService service client
//

pub trait TTHBaseServiceSyncClient {
  /// Test for the existence of columns in the table, as specified in the TGet.
  /// 
  /// @return true if the specified TGet matches one or more keys, false if not
  fn exists(&mut self, table: Vec<u8>, tget: TGet) -> thrift::Result<bool>;
  /// Test for the existence of columns in the table, as specified by the TGets.
  /// 
  /// This will return an array of booleans. Each value will be true if the related Get matches
  /// one or more keys, false if not.
  fn exists_all(&mut self, table: Vec<u8>, tgets: Vec<TGet>) -> thrift::Result<Vec<bool>>;
  /// Method for getting data from a row.
  /// 
  /// If the row cannot be found an empty Result is returned.
  /// This can be checked by the empty field of the TResult
  /// 
  /// @return the result
  fn get(&mut self, table: Vec<u8>, tget: TGet) -> thrift::Result<TResult>;
  /// Method for getting multiple rows.
  /// 
  /// If a row cannot be found there will be a null
  /// value in the result list for that TGet at the
  /// same position.
  /// 
  /// So the Results are in the same order as the TGets.
  fn get_multiple(&mut self, table: Vec<u8>, tgets: Vec<TGet>) -> thrift::Result<Vec<TResult>>;
  /// Commit a TPut to a table.
  fn put(&mut self, table: Vec<u8>, tput: TPut) -> thrift::Result<()>;
  /// Atomically checks if a row/family/qualifier value matches the expected
  /// value. If it does, it adds the TPut.
  /// 
  /// @return true if the new put was executed, false otherwise
  fn check_and_put(&mut self, table: Vec<u8>, row: Vec<u8>, family: Vec<u8>, qualifier: Vec<u8>, value: Vec<u8>, tput: TPut) -> thrift::Result<bool>;
  /// Commit a List of Puts to the table.
  fn put_multiple(&mut self, table: Vec<u8>, tputs: Vec<TPut>) -> thrift::Result<()>;
  /// Deletes as specified by the TDelete.
  /// 
  /// Note: "delete" is a reserved keyword and cannot be used in Thrift
  /// thus the inconsistent naming scheme from the other functions.
  fn delete_single(&mut self, table: Vec<u8>, tdelete: TDelete) -> thrift::Result<()>;
  /// Bulk commit a List of TDeletes to the table.
  /// 
  /// Throws a TIOError if any of the deletes fail.
  /// 
  /// Always returns an empty list for backwards compatibility.
  fn delete_multiple(&mut self, table: Vec<u8>, tdeletes: Vec<TDelete>) -> thrift::Result<Vec<TDelete>>;
  /// Atomically checks if a row/family/qualifier value matches the expected
  /// value. If it does, it adds the delete.
  /// 
  /// @return true if the new delete was executed, false otherwise
  fn check_and_delete(&mut self, table: Vec<u8>, row: Vec<u8>, family: Vec<u8>, qualifier: Vec<u8>, value: Vec<u8>, tdelete: TDelete) -> thrift::Result<bool>;
  fn increment(&mut self, table: Vec<u8>, tincrement: TIncrement) -> thrift::Result<TResult>;
  fn append(&mut self, table: Vec<u8>, tappend: TAppend) -> thrift::Result<TResult>;
  /// Get a Scanner for the provided TScan object.
  /// 
  /// @return Scanner Id to be used with other scanner procedures
  fn open_scanner(&mut self, table: Vec<u8>, tscan: TScan) -> thrift::Result<i32>;
  /// Grabs multiple rows from a Scanner.
  /// 
  /// @return Between zero and numRows TResults
  fn get_scanner_rows(&mut self, scanner_id: i32, num_rows: i32) -> thrift::Result<Vec<TResult>>;
  /// Closes the scanner. Should be called to free server side resources timely.
  /// Typically close once the scanner is not needed anymore, i.e. after looping
  /// over it to get all the required rows.
  fn close_scanner(&mut self, scanner_id: i32) -> thrift::Result<()>;
  /// mutateRow performs multiple mutations atomically on a single row.
  fn mutate_row(&mut self, table: Vec<u8>, trow_mutations: TRowMutations) -> thrift::Result<()>;
  /// Get results for the provided TScan object.
  /// This helper function opens a scanner, get the results and close the scanner.
  /// 
  /// @return between zero and numRows TResults
  fn get_scanner_results(&mut self, table: Vec<u8>, tscan: TScan, num_rows: i32) -> thrift::Result<Vec<TResult>>;
  /// Given a table and a row get the location of the region that
  /// would contain the given row key.
  /// 
  /// reload = true means the cache will be cleared and the location
  /// will be fetched from meta.
  fn get_region_location(&mut self, table: Vec<u8>, row: Vec<u8>, reload: bool) -> thrift::Result<THRegionLocation>;
  /// Get all of the region locations for a given table.
  /// 
  fn get_all_region_locations(&mut self, table: Vec<u8>) -> thrift::Result<Vec<THRegionLocation>>;
  /// Atomically checks if a row/family/qualifier value matches the expected
  /// value. If it does, it mutates the row.
  /// 
  /// @return true if the row was mutated, false otherwise
  fn check_and_mutate(&mut self, table: Vec<u8>, row: Vec<u8>, family: Vec<u8>, qualifier: Vec<u8>, compare_operator: TCompareOperator, value: Vec<u8>, row_mutations: TRowMutations) -> thrift::Result<bool>;
  /// Get a table descriptor.
  /// @return the TableDescriptor of the giving tablename
  /// 
  fn get_table_descriptor(&mut self, table: TTableName) -> thrift::Result<TTableDescriptor>;
  /// Get table descriptors of tables.
  /// @return the TableDescriptor of the giving tablename
  /// 
  fn get_table_descriptors(&mut self, tables: Vec<TTableName>) -> thrift::Result<Vec<TTableDescriptor>>;
  /// 
  /// @return true if table exists already, false if not
  /// 
  fn table_exists(&mut self, table_name: TTableName) -> thrift::Result<bool>;
  /// Get table descriptors of tables that match the given pattern
  /// @return the tableDescriptors of the matching table
  /// 
  fn get_table_descriptors_by_pattern(&mut self, regex: String, include_sys_tables: bool) -> thrift::Result<Vec<TTableDescriptor>>;
  /// Get table descriptors of tables in the given namespace
  /// @return the tableDescriptors in the namespce
  /// 
  fn get_table_descriptors_by_namespace(&mut self, name: String) -> thrift::Result<Vec<TTableDescriptor>>;
  /// Get table names of tables that match the given pattern
  /// @return the table names of the matching table
  /// 
  fn get_table_names_by_pattern(&mut self, regex: String, include_sys_tables: bool) -> thrift::Result<Vec<TTableName>>;
  /// Get table names of tables in the given namespace
  /// @return the table names of the matching table
  /// 
  fn get_table_names_by_namespace(&mut self, name: String) -> thrift::Result<Vec<TTableName>>;
  /// Creates a new table with an initial set of empty regions defined by the specified split keys.
  /// The total number of regions created will be the number of split keys plus one. Synchronous
  /// operation.
  /// 
  fn create_table(&mut self, desc: TTableDescriptor, split_keys: Vec<Vec<u8>>) -> thrift::Result<()>;
  /// Deletes a table. Synchronous operation.
  /// 
  fn delete_table(&mut self, table_name: TTableName) -> thrift::Result<()>;
  /// Truncate a table. Synchronous operation.
  /// 
  fn truncate_table(&mut self, table_name: TTableName, preserve_splits: bool) -> thrift::Result<()>;
  /// Enalbe a table
  /// 
  fn enable_table(&mut self, table_name: TTableName) -> thrift::Result<()>;
  /// Disable a table
  /// 
  fn disable_table(&mut self, table_name: TTableName) -> thrift::Result<()>;
  /// 
  /// @return true if table is enabled, false if not
  /// 
  fn is_table_enabled(&mut self, table_name: TTableName) -> thrift::Result<bool>;
  /// 
  /// @return true if table is disabled, false if not
  /// 
  fn is_table_disabled(&mut self, table_name: TTableName) -> thrift::Result<bool>;
  /// 
  /// @return true if table is available, false if not
  /// 
  fn is_table_available(&mut self, table_name: TTableName) -> thrift::Result<bool>;
  ///  * Use this api to check if the table has been created with the specified number of splitkeys
  ///  * which was used while creating the given table. Note : If this api is used after a table's
  ///  * region gets splitted, the api may return false.
  ///  *
  ///  * @return true if table is available, false if not
  ///  *
  ///  * @deprecated Since 2.2.0. Because the same method in Table interface has been deprecated
  ///  * since 2.0.0, we will remove it in 3.0.0 release.
  ///  * Use {@link #isTableAvailable(TTableName tableName)} instead
  /// *
  fn is_table_available_with_split(&mut self, table_name: TTableName, split_keys: Vec<Vec<u8>>) -> thrift::Result<bool>;
  /// Add a column family to an existing table. Synchronous operation.
  /// 
  fn add_column_family(&mut self, table_name: TTableName, column: TColumnFamilyDescriptor) -> thrift::Result<()>;
  /// Delete a column family from a table. Synchronous operation.
  /// 
  fn delete_column_family(&mut self, table_name: TTableName, column: Vec<u8>) -> thrift::Result<()>;
  /// Modify an existing column family on a table. Synchronous operation.
  /// 
  fn modify_column_family(&mut self, table_name: TTableName, column: TColumnFamilyDescriptor) -> thrift::Result<()>;
  /// Modify an existing table
  /// 
  fn modify_table(&mut self, desc: TTableDescriptor) -> thrift::Result<()>;
  /// Create a new namespace. Blocks until namespace has been successfully created or an exception is
  /// thrown
  /// 
  fn create_namespace(&mut self, namespace_desc: TNamespaceDescriptor) -> thrift::Result<()>;
  /// Modify an existing namespace.  Blocks until namespace has been successfully modified or an
  /// exception is thrown
  /// 
  fn modify_namespace(&mut self, namespace_desc: TNamespaceDescriptor) -> thrift::Result<()>;
  /// Delete an existing namespace. Only empty namespaces (no tables) can be removed.
  /// Blocks until namespace has been successfully deleted or an
  /// exception is thrown.
  /// 
  fn delete_namespace(&mut self, name: String) -> thrift::Result<()>;
  /// Get a namespace descriptor by name.
  /// @retrun the descriptor
  /// 
  fn get_namespace_descriptor(&mut self, name: String) -> thrift::Result<TNamespaceDescriptor>;
  /// @return all namespaces
  /// 
  fn list_namespace_descriptors(&mut self) -> thrift::Result<Vec<TNamespaceDescriptor>>;
  /// @return all namespace names
  /// 
  fn list_namespaces(&mut self) -> thrift::Result<Vec<String>>;
  /// Get the type of this thrift server.
  /// 
  /// @return the type of this thrift server
  fn get_thrift_server_type(&mut self) -> thrift::Result<TThriftServerType>;
  /// Returns the cluster ID for this cluster.
  fn get_cluster_id(&mut self) -> thrift::Result<String>;
  /// Retrieves online slow RPC logs from the provided list of
  /// RegionServers
  /// 
  /// @return online slowlog response list
  /// @throws TIOError if a remote or network exception occurs
  fn get_slow_log_responses(&mut self, server_names: BTreeSet<TServerName>, log_query_filter: TLogQueryFilter) -> thrift::Result<Vec<TOnlineLogRecord>>;
  /// Clears online slow/large RPC logs from the provided list of
  /// RegionServers
  /// 
  /// @return List of booleans representing if online slowlog response buffer is cleaned
  ///   from each RegionServer
  /// @throws TIOError if a remote or network exception occurs
  fn clear_slow_log_responses(&mut self, server_names: BTreeSet<TServerName>) -> thrift::Result<Vec<bool>>;
  /// Grant permissions in table or namespace level.
  fn grant(&mut self, info: TAccessControlEntity) -> thrift::Result<bool>;
  /// Revoke permissions in table or namespace level.
  fn revoke(&mut self, info: TAccessControlEntity) -> thrift::Result<bool>;
}

pub trait TTHBaseServiceSyncClientMarker {}

pub struct THBaseServiceSyncClient<IP, OP> where IP: TInputProtocol, OP: TOutputProtocol {
  _i_prot: IP,
  _o_prot: OP,
  _sequence_number: i32,
}

impl <IP, OP> THBaseServiceSyncClient<IP, OP> where IP: TInputProtocol, OP: TOutputProtocol {
  pub fn new(input_protocol: IP, output_protocol: OP) -> THBaseServiceSyncClient<IP, OP> {
    THBaseServiceSyncClient { _i_prot: input_protocol, _o_prot: output_protocol, _sequence_number: 0 }
  }
}

impl <IP, OP> TThriftClient for THBaseServiceSyncClient<IP, OP> where IP: TInputProtocol, OP: TOutputProtocol {
  fn i_prot_mut(&mut self) -> &mut dyn TInputProtocol { &mut self._i_prot }
  fn o_prot_mut(&mut self) -> &mut dyn TOutputProtocol { &mut self._o_prot }
  fn sequence_number(&self) -> i32 { self._sequence_number }
  fn increment_sequence_number(&mut self) -> i32 { self._sequence_number += 1; self._sequence_number }
}

impl <IP, OP> TTHBaseServiceSyncClientMarker for THBaseServiceSyncClient<IP, OP> where IP: TInputProtocol, OP: TOutputProtocol {}

impl <C: TThriftClient + TTHBaseServiceSyncClientMarker> TTHBaseServiceSyncClient for C {
  fn exists(&mut self, table: Vec<u8>, tget: TGet) -> thrift::Result<bool> {
    (
      {
        self.increment_sequence_number();
        let message_ident = TMessageIdentifier::new("exists", TMessageType::Call, self.sequence_number());
        let call_args = THBaseServiceExistsArgs { table, tget };
        self.o_prot_mut().write_message_begin(&message_ident)?;
        call_args.write_to_out_protocol(self.o_prot_mut())?;
        self.o_prot_mut().write_message_end()?;
        self.o_prot_mut().flush()
      }
    )?;
    {
      let message_ident = self.i_prot_mut().read_message_begin()?;
      verify_expected_sequence_number(self.sequence_number(), message_ident.sequence_number)?;
      verify_expected_service_call("exists", &message_ident.name)?;
      if message_ident.message_type == TMessageType::Exception {
        let remote_error = thrift::Error::read_application_error_from_in_protocol(self.i_prot_mut())?;
        self.i_prot_mut().read_message_end()?;
        return Err(thrift::Error::Application(remote_error))
      }
      verify_expected_message_type(TMessageType::Reply, message_ident.message_type)?;
      let result = THBaseServiceExistsResult::read_from_in_protocol(self.i_prot_mut())?;
      self.i_prot_mut().read_message_end()?;
      result.ok_or()
    }
  }
  fn exists_all(&mut self, table: Vec<u8>, tgets: Vec<TGet>) -> thrift::Result<Vec<bool>> {
    (
      {
        self.increment_sequence_number();
        let message_ident = TMessageIdentifier::new("existsAll", TMessageType::Call, self.sequence_number());
        let call_args = THBaseServiceExistsAllArgs { table, tgets };
        self.o_prot_mut().write_message_begin(&message_ident)?;
        call_args.write_to_out_protocol(self.o_prot_mut())?;
        self.o_prot_mut().write_message_end()?;
        self.o_prot_mut().flush()
      }
    )?;
    {
      let message_ident = self.i_prot_mut().read_message_begin()?;
      verify_expected_sequence_number(self.sequence_number(), message_ident.sequence_number)?;
      verify_expected_service_call("existsAll", &message_ident.name)?;
      if message_ident.message_type == TMessageType::Exception {
        let remote_error = thrift::Error::read_application_error_from_in_protocol(self.i_prot_mut())?;
        self.i_prot_mut().read_message_end()?;
        return Err(thrift::Error::Application(remote_error))
      }
      verify_expected_message_type(TMessageType::Reply, message_ident.message_type)?;
      let result = THBaseServiceExistsAllResult::read_from_in_protocol(self.i_prot_mut())?;
      self.i_prot_mut().read_message_end()?;
      result.ok_or()
    }
  }
  fn get(&mut self, table: Vec<u8>, tget: TGet) -> thrift::Result<TResult> {
    (
      {
        self.increment_sequence_number();
        let message_ident = TMessageIdentifier::new("get", TMessageType::Call, self.sequence_number());
        let call_args = THBaseServiceGetArgs { table, tget };
        self.o_prot_mut().write_message_begin(&message_ident)?;
        call_args.write_to_out_protocol(self.o_prot_mut())?;
        self.o_prot_mut().write_message_end()?;
        self.o_prot_mut().flush()
      }
    )?;
    {
      let message_ident = self.i_prot_mut().read_message_begin()?;
      verify_expected_sequence_number(self.sequence_number(), message_ident.sequence_number)?;
      verify_expected_service_call("get", &message_ident.name)?;
      if message_ident.message_type == TMessageType::Exception {
        let remote_error = thrift::Error::read_application_error_from_in_protocol(self.i_prot_mut())?;
        self.i_prot_mut().read_message_end()?;
        return Err(thrift::Error::Application(remote_error))
      }
      verify_expected_message_type(TMessageType::Reply, message_ident.message_type)?;
      let result = THBaseServiceGetResult::read_from_in_protocol(self.i_prot_mut())?;
      self.i_prot_mut().read_message_end()?;
      result.ok_or()
    }
  }
  fn get_multiple(&mut self, table: Vec<u8>, tgets: Vec<TGet>) -> thrift::Result<Vec<TResult>> {
    (
      {
        self.increment_sequence_number();
        let message_ident = TMessageIdentifier::new("getMultiple", TMessageType::Call, self.sequence_number());
        let call_args = THBaseServiceGetMultipleArgs { table, tgets };
        self.o_prot_mut().write_message_begin(&message_ident)?;
        call_args.write_to_out_protocol(self.o_prot_mut())?;
        self.o_prot_mut().write_message_end()?;
        self.o_prot_mut().flush()
      }
    )?;
    {
      let message_ident = self.i_prot_mut().read_message_begin()?;
      verify_expected_sequence_number(self.sequence_number(), message_ident.sequence_number)?;
      verify_expected_service_call("getMultiple", &message_ident.name)?;
      if message_ident.message_type == TMessageType::Exception {
        let remote_error = thrift::Error::read_application_error_from_in_protocol(self.i_prot_mut())?;
        self.i_prot_mut().read_message_end()?;
        return Err(thrift::Error::Application(remote_error))
      }
      verify_expected_message_type(TMessageType::Reply, message_ident.message_type)?;
      let result = THBaseServiceGetMultipleResult::read_from_in_protocol(self.i_prot_mut())?;
      self.i_prot_mut().read_message_end()?;
      result.ok_or()
    }
  }
  fn put(&mut self, table: Vec<u8>, tput: TPut) -> thrift::Result<()> {
    (
      {
        self.increment_sequence_number();
        let message_ident = TMessageIdentifier::new("put", TMessageType::Call, self.sequence_number());
        let call_args = THBaseServicePutArgs { table, tput };
        self.o_prot_mut().write_message_begin(&message_ident)?;
        call_args.write_to_out_protocol(self.o_prot_mut())?;
        self.o_prot_mut().write_message_end()?;
        self.o_prot_mut().flush()
      }
    )?;
    {
      let message_ident = self.i_prot_mut().read_message_begin()?;
      verify_expected_sequence_number(self.sequence_number(), message_ident.sequence_number)?;
      verify_expected_service_call("put", &message_ident.name)?;
      if message_ident.message_type == TMessageType::Exception {
        let remote_error = thrift::Error::read_application_error_from_in_protocol(self.i_prot_mut())?;
        self.i_prot_mut().read_message_end()?;
        return Err(thrift::Error::Application(remote_error))
      }
      verify_expected_message_type(TMessageType::Reply, message_ident.message_type)?;
      let result = THBaseServicePutResult::read_from_in_protocol(self.i_prot_mut())?;
      self.i_prot_mut().read_message_end()?;
      result.ok_or()
    }
  }
  fn check_and_put(&mut self, table: Vec<u8>, row: Vec<u8>, family: Vec<u8>, qualifier: Vec<u8>, value: Vec<u8>, tput: TPut) -> thrift::Result<bool> {
    (
      {
        self.increment_sequence_number();
        let message_ident = TMessageIdentifier::new("checkAndPut", TMessageType::Call, self.sequence_number());
        let call_args = THBaseServiceCheckAndPutArgs { table, row, family, qualifier, value, tput };
        self.o_prot_mut().write_message_begin(&message_ident)?;
        call_args.write_to_out_protocol(self.o_prot_mut())?;
        self.o_prot_mut().write_message_end()?;
        self.o_prot_mut().flush()
      }
    )?;
    {
      let message_ident = self.i_prot_mut().read_message_begin()?;
      verify_expected_sequence_number(self.sequence_number(), message_ident.sequence_number)?;
      verify_expected_service_call("checkAndPut", &message_ident.name)?;
      if message_ident.message_type == TMessageType::Exception {
        let remote_error = thrift::Error::read_application_error_from_in_protocol(self.i_prot_mut())?;
        self.i_prot_mut().read_message_end()?;
        return Err(thrift::Error::Application(remote_error))
      }
      verify_expected_message_type(TMessageType::Reply, message_ident.message_type)?;
      let result = THBaseServiceCheckAndPutResult::read_from_in_protocol(self.i_prot_mut())?;
      self.i_prot_mut().read_message_end()?;
      result.ok_or()
    }
  }
  fn put_multiple(&mut self, table: Vec<u8>, tputs: Vec<TPut>) -> thrift::Result<()> {
    (
      {
        self.increment_sequence_number();
        let message_ident = TMessageIdentifier::new("putMultiple", TMessageType::Call, self.sequence_number());
        let call_args = THBaseServicePutMultipleArgs { table, tputs };
        self.o_prot_mut().write_message_begin(&message_ident)?;
        call_args.write_to_out_protocol(self.o_prot_mut())?;
        self.o_prot_mut().write_message_end()?;
        self.o_prot_mut().flush()
      }
    )?;
    {
      let message_ident = self.i_prot_mut().read_message_begin()?;
      verify_expected_sequence_number(self.sequence_number(), message_ident.sequence_number)?;
      verify_expected_service_call("putMultiple", &message_ident.name)?;
      if message_ident.message_type == TMessageType::Exception {
        let remote_error = thrift::Error::read_application_error_from_in_protocol(self.i_prot_mut())?;
        self.i_prot_mut().read_message_end()?;
        return Err(thrift::Error::Application(remote_error))
      }
      verify_expected_message_type(TMessageType::Reply, message_ident.message_type)?;
      let result = THBaseServicePutMultipleResult::read_from_in_protocol(self.i_prot_mut())?;
      self.i_prot_mut().read_message_end()?;
      result.ok_or()
    }
  }
  fn delete_single(&mut self, table: Vec<u8>, tdelete: TDelete) -> thrift::Result<()> {
    (
      {
        self.increment_sequence_number();
        let message_ident = TMessageIdentifier::new("deleteSingle", TMessageType::Call, self.sequence_number());
        let call_args = THBaseServiceDeleteSingleArgs { table, tdelete };
        self.o_prot_mut().write_message_begin(&message_ident)?;
        call_args.write_to_out_protocol(self.o_prot_mut())?;
        self.o_prot_mut().write_message_end()?;
        self.o_prot_mut().flush()
      }
    )?;
    {
      let message_ident = self.i_prot_mut().read_message_begin()?;
      verify_expected_sequence_number(self.sequence_number(), message_ident.sequence_number)?;
      verify_expected_service_call("deleteSingle", &message_ident.name)?;
      if message_ident.message_type == TMessageType::Exception {
        let remote_error = thrift::Error::read_application_error_from_in_protocol(self.i_prot_mut())?;
        self.i_prot_mut().read_message_end()?;
        return Err(thrift::Error::Application(remote_error))
      }
      verify_expected_message_type(TMessageType::Reply, message_ident.message_type)?;
      let result = THBaseServiceDeleteSingleResult::read_from_in_protocol(self.i_prot_mut())?;
      self.i_prot_mut().read_message_end()?;
      result.ok_or()
    }
  }
  fn delete_multiple(&mut self, table: Vec<u8>, tdeletes: Vec<TDelete>) -> thrift::Result<Vec<TDelete>> {
    (
      {
        self.increment_sequence_number();
        let message_ident = TMessageIdentifier::new("deleteMultiple", TMessageType::Call, self.sequence_number());
        let call_args = THBaseServiceDeleteMultipleArgs { table, tdeletes };
        self.o_prot_mut().write_message_begin(&message_ident)?;
        call_args.write_to_out_protocol(self.o_prot_mut())?;
        self.o_prot_mut().write_message_end()?;
        self.o_prot_mut().flush()
      }
    )?;
    {
      let message_ident = self.i_prot_mut().read_message_begin()?;
      verify_expected_sequence_number(self.sequence_number(), message_ident.sequence_number)?;
      verify_expected_service_call("deleteMultiple", &message_ident.name)?;
      if message_ident.message_type == TMessageType::Exception {
        let remote_error = thrift::Error::read_application_error_from_in_protocol(self.i_prot_mut())?;
        self.i_prot_mut().read_message_end()?;
        return Err(thrift::Error::Application(remote_error))
      }
      verify_expected_message_type(TMessageType::Reply, message_ident.message_type)?;
      let result = THBaseServiceDeleteMultipleResult::read_from_in_protocol(self.i_prot_mut())?;
      self.i_prot_mut().read_message_end()?;
      result.ok_or()
    }
  }
  fn check_and_delete(&mut self, table: Vec<u8>, row: Vec<u8>, family: Vec<u8>, qualifier: Vec<u8>, value: Vec<u8>, tdelete: TDelete) -> thrift::Result<bool> {
    (
      {
        self.increment_sequence_number();
        let message_ident = TMessageIdentifier::new("checkAndDelete", TMessageType::Call, self.sequence_number());
        let call_args = THBaseServiceCheckAndDeleteArgs { table, row, family, qualifier, value, tdelete };
        self.o_prot_mut().write_message_begin(&message_ident)?;
        call_args.write_to_out_protocol(self.o_prot_mut())?;
        self.o_prot_mut().write_message_end()?;
        self.o_prot_mut().flush()
      }
    )?;
    {
      let message_ident = self.i_prot_mut().read_message_begin()?;
      verify_expected_sequence_number(self.sequence_number(), message_ident.sequence_number)?;
      verify_expected_service_call("checkAndDelete", &message_ident.name)?;
      if message_ident.message_type == TMessageType::Exception {
        let remote_error = thrift::Error::read_application_error_from_in_protocol(self.i_prot_mut())?;
        self.i_prot_mut().read_message_end()?;
        return Err(thrift::Error::Application(remote_error))
      }
      verify_expected_message_type(TMessageType::Reply, message_ident.message_type)?;
      let result = THBaseServiceCheckAndDeleteResult::read_from_in_protocol(self.i_prot_mut())?;
      self.i_prot_mut().read_message_end()?;
      result.ok_or()
    }
  }
  fn increment(&mut self, table: Vec<u8>, tincrement: TIncrement) -> thrift::Result<TResult> {
    (
      {
        self.increment_sequence_number();
        let message_ident = TMessageIdentifier::new("increment", TMessageType::Call, self.sequence_number());
        let call_args = THBaseServiceIncrementArgs { table, tincrement };
        self.o_prot_mut().write_message_begin(&message_ident)?;
        call_args.write_to_out_protocol(self.o_prot_mut())?;
        self.o_prot_mut().write_message_end()?;
        self.o_prot_mut().flush()
      }
    )?;
    {
      let message_ident = self.i_prot_mut().read_message_begin()?;
      verify_expected_sequence_number(self.sequence_number(), message_ident.sequence_number)?;
      verify_expected_service_call("increment", &message_ident.name)?;
      if message_ident.message_type == TMessageType::Exception {
        let remote_error = thrift::Error::read_application_error_from_in_protocol(self.i_prot_mut())?;
        self.i_prot_mut().read_message_end()?;
        return Err(thrift::Error::Application(remote_error))
      }
      verify_expected_message_type(TMessageType::Reply, message_ident.message_type)?;
      let result = THBaseServiceIncrementResult::read_from_in_protocol(self.i_prot_mut())?;
      self.i_prot_mut().read_message_end()?;
      result.ok_or()
    }
  }
  fn append(&mut self, table: Vec<u8>, tappend: TAppend) -> thrift::Result<TResult> {
    (
      {
        self.increment_sequence_number();
        let message_ident = TMessageIdentifier::new("append", TMessageType::Call, self.sequence_number());
        let call_args = THBaseServiceAppendArgs { table, tappend };
        self.o_prot_mut().write_message_begin(&message_ident)?;
        call_args.write_to_out_protocol(self.o_prot_mut())?;
        self.o_prot_mut().write_message_end()?;
        self.o_prot_mut().flush()
      }
    )?;
    {
      let message_ident = self.i_prot_mut().read_message_begin()?;
      verify_expected_sequence_number(self.sequence_number(), message_ident.sequence_number)?;
      verify_expected_service_call("append", &message_ident.name)?;
      if message_ident.message_type == TMessageType::Exception {
        let remote_error = thrift::Error::read_application_error_from_in_protocol(self.i_prot_mut())?;
        self.i_prot_mut().read_message_end()?;
        return Err(thrift::Error::Application(remote_error))
      }
      verify_expected_message_type(TMessageType::Reply, message_ident.message_type)?;
      let result = THBaseServiceAppendResult::read_from_in_protocol(self.i_prot_mut())?;
      self.i_prot_mut().read_message_end()?;
      result.ok_or()
    }
  }
  fn open_scanner(&mut self, table: Vec<u8>, tscan: TScan) -> thrift::Result<i32> {
    (
      {
        self.increment_sequence_number();
        let message_ident = TMessageIdentifier::new("openScanner", TMessageType::Call, self.sequence_number());
        let call_args = THBaseServiceOpenScannerArgs { table, tscan };
        self.o_prot_mut().write_message_begin(&message_ident)?;
        call_args.write_to_out_protocol(self.o_prot_mut())?;
        self.o_prot_mut().write_message_end()?;
        self.o_prot_mut().flush()
      }
    )?;
    {
      let message_ident = self.i_prot_mut().read_message_begin()?;
      verify_expected_sequence_number(self.sequence_number(), message_ident.sequence_number)?;
      verify_expected_service_call("openScanner", &message_ident.name)?;
      if message_ident.message_type == TMessageType::Exception {
        let remote_error = thrift::Error::read_application_error_from_in_protocol(self.i_prot_mut())?;
        self.i_prot_mut().read_message_end()?;
        return Err(thrift::Error::Application(remote_error))
      }
      verify_expected_message_type(TMessageType::Reply, message_ident.message_type)?;
      let result = THBaseServiceOpenScannerResult::read_from_in_protocol(self.i_prot_mut())?;
      self.i_prot_mut().read_message_end()?;
      result.ok_or()
    }
  }
  fn get_scanner_rows(&mut self, scanner_id: i32, num_rows: i32) -> thrift::Result<Vec<TResult>> {
    (
      {
        self.increment_sequence_number();
        let message_ident = TMessageIdentifier::new("getScannerRows", TMessageType::Call, self.sequence_number());
        let call_args = THBaseServiceGetScannerRowsArgs { scanner_id, num_rows };
        self.o_prot_mut().write_message_begin(&message_ident)?;
        call_args.write_to_out_protocol(self.o_prot_mut())?;
        self.o_prot_mut().write_message_end()?;
        self.o_prot_mut().flush()
      }
    )?;
    {
      let message_ident = self.i_prot_mut().read_message_begin()?;
      verify_expected_sequence_number(self.sequence_number(), message_ident.sequence_number)?;
      verify_expected_service_call("getScannerRows", &message_ident.name)?;
      if message_ident.message_type == TMessageType::Exception {
        let remote_error = thrift::Error::read_application_error_from_in_protocol(self.i_prot_mut())?;
        self.i_prot_mut().read_message_end()?;
        return Err(thrift::Error::Application(remote_error))
      }
      verify_expected_message_type(TMessageType::Reply, message_ident.message_type)?;
      let result = THBaseServiceGetScannerRowsResult::read_from_in_protocol(self.i_prot_mut())?;
      self.i_prot_mut().read_message_end()?;
      result.ok_or()
    }
  }
  fn close_scanner(&mut self, scanner_id: i32) -> thrift::Result<()> {
    (
      {
        self.increment_sequence_number();
        let message_ident = TMessageIdentifier::new("closeScanner", TMessageType::Call, self.sequence_number());
        let call_args = THBaseServiceCloseScannerArgs { scanner_id };
        self.o_prot_mut().write_message_begin(&message_ident)?;
        call_args.write_to_out_protocol(self.o_prot_mut())?;
        self.o_prot_mut().write_message_end()?;
        self.o_prot_mut().flush()
      }
    )?;
    {
      let message_ident = self.i_prot_mut().read_message_begin()?;
      verify_expected_sequence_number(self.sequence_number(), message_ident.sequence_number)?;
      verify_expected_service_call("closeScanner", &message_ident.name)?;
      if message_ident.message_type == TMessageType::Exception {
        let remote_error = thrift::Error::read_application_error_from_in_protocol(self.i_prot_mut())?;
        self.i_prot_mut().read_message_end()?;
        return Err(thrift::Error::Application(remote_error))
      }
      verify_expected_message_type(TMessageType::Reply, message_ident.message_type)?;
      let result = THBaseServiceCloseScannerResult::read_from_in_protocol(self.i_prot_mut())?;
      self.i_prot_mut().read_message_end()?;
      result.ok_or()
    }
  }
  fn mutate_row(&mut self, table: Vec<u8>, trow_mutations: TRowMutations) -> thrift::Result<()> {
    (
      {
        self.increment_sequence_number();
        let message_ident = TMessageIdentifier::new("mutateRow", TMessageType::Call, self.sequence_number());
        let call_args = THBaseServiceMutateRowArgs { table, trow_mutations };
        self.o_prot_mut().write_message_begin(&message_ident)?;
        call_args.write_to_out_protocol(self.o_prot_mut())?;
        self.o_prot_mut().write_message_end()?;
        self.o_prot_mut().flush()
      }
    )?;
    {
      let message_ident = self.i_prot_mut().read_message_begin()?;
      verify_expected_sequence_number(self.sequence_number(), message_ident.sequence_number)?;
      verify_expected_service_call("mutateRow", &message_ident.name)?;
      if message_ident.message_type == TMessageType::Exception {
        let remote_error = thrift::Error::read_application_error_from_in_protocol(self.i_prot_mut())?;
        self.i_prot_mut().read_message_end()?;
        return Err(thrift::Error::Application(remote_error))
      }
      verify_expected_message_type(TMessageType::Reply, message_ident.message_type)?;
      let result = THBaseServiceMutateRowResult::read_from_in_protocol(self.i_prot_mut())?;
      self.i_prot_mut().read_message_end()?;
      result.ok_or()
    }
  }
  fn get_scanner_results(&mut self, table: Vec<u8>, tscan: TScan, num_rows: i32) -> thrift::Result<Vec<TResult>> {
    (
      {
        self.increment_sequence_number();
        let message_ident = TMessageIdentifier::new("getScannerResults", TMessageType::Call, self.sequence_number());
        let call_args = THBaseServiceGetScannerResultsArgs { table, tscan, num_rows };
        self.o_prot_mut().write_message_begin(&message_ident)?;
        call_args.write_to_out_protocol(self.o_prot_mut())?;
        self.o_prot_mut().write_message_end()?;
        self.o_prot_mut().flush()
      }
    )?;
    {
      let message_ident = self.i_prot_mut().read_message_begin()?;
      verify_expected_sequence_number(self.sequence_number(), message_ident.sequence_number)?;
      verify_expected_service_call("getScannerResults", &message_ident.name)?;
      if message_ident.message_type == TMessageType::Exception {
        let remote_error = thrift::Error::read_application_error_from_in_protocol(self.i_prot_mut())?;
        self.i_prot_mut().read_message_end()?;
        return Err(thrift::Error::Application(remote_error))
      }
      verify_expected_message_type(TMessageType::Reply, message_ident.message_type)?;
      let result = THBaseServiceGetScannerResultsResult::read_from_in_protocol(self.i_prot_mut())?;
      self.i_prot_mut().read_message_end()?;
      result.ok_or()
    }
  }
  fn get_region_location(&mut self, table: Vec<u8>, row: Vec<u8>, reload: bool) -> thrift::Result<THRegionLocation> {
    (
      {
        self.increment_sequence_number();
        let message_ident = TMessageIdentifier::new("getRegionLocation", TMessageType::Call, self.sequence_number());
        let call_args = THBaseServiceGetRegionLocationArgs { table, row, reload };
        self.o_prot_mut().write_message_begin(&message_ident)?;
        call_args.write_to_out_protocol(self.o_prot_mut())?;
        self.o_prot_mut().write_message_end()?;
        self.o_prot_mut().flush()
      }
    )?;
    {
      let message_ident = self.i_prot_mut().read_message_begin()?;
      verify_expected_sequence_number(self.sequence_number(), message_ident.sequence_number)?;
      verify_expected_service_call("getRegionLocation", &message_ident.name)?;
      if message_ident.message_type == TMessageType::Exception {
        let remote_error = thrift::Error::read_application_error_from_in_protocol(self.i_prot_mut())?;
        self.i_prot_mut().read_message_end()?;
        return Err(thrift::Error::Application(remote_error))
      }
      verify_expected_message_type(TMessageType::Reply, message_ident.message_type)?;
      let result = THBaseServiceGetRegionLocationResult::read_from_in_protocol(self.i_prot_mut())?;
      self.i_prot_mut().read_message_end()?;
      result.ok_or()
    }
  }
  fn get_all_region_locations(&mut self, table: Vec<u8>) -> thrift::Result<Vec<THRegionLocation>> {
    (
      {
        self.increment_sequence_number();
        let message_ident = TMessageIdentifier::new("getAllRegionLocations", TMessageType::Call, self.sequence_number());
        let call_args = THBaseServiceGetAllRegionLocationsArgs { table };
        self.o_prot_mut().write_message_begin(&message_ident)?;
        call_args.write_to_out_protocol(self.o_prot_mut())?;
        self.o_prot_mut().write_message_end()?;
        self.o_prot_mut().flush()
      }
    )?;
    {
      let message_ident = self.i_prot_mut().read_message_begin()?;
      verify_expected_sequence_number(self.sequence_number(), message_ident.sequence_number)?;
      verify_expected_service_call("getAllRegionLocations", &message_ident.name)?;
      if message_ident.message_type == TMessageType::Exception {
        let remote_error = thrift::Error::read_application_error_from_in_protocol(self.i_prot_mut())?;
        self.i_prot_mut().read_message_end()?;
        return Err(thrift::Error::Application(remote_error))
      }
      verify_expected_message_type(TMessageType::Reply, message_ident.message_type)?;
      let result = THBaseServiceGetAllRegionLocationsResult::read_from_in_protocol(self.i_prot_mut())?;
      self.i_prot_mut().read_message_end()?;
      result.ok_or()
    }
  }
  fn check_and_mutate(&mut self, table: Vec<u8>, row: Vec<u8>, family: Vec<u8>, qualifier: Vec<u8>, compare_operator: TCompareOperator, value: Vec<u8>, row_mutations: TRowMutations) -> thrift::Result<bool> {
    (
      {
        self.increment_sequence_number();
        let message_ident = TMessageIdentifier::new("checkAndMutate", TMessageType::Call, self.sequence_number());
        let call_args = THBaseServiceCheckAndMutateArgs { table, row, family, qualifier, compare_operator, value, row_mutations };
        self.o_prot_mut().write_message_begin(&message_ident)?;
        call_args.write_to_out_protocol(self.o_prot_mut())?;
        self.o_prot_mut().write_message_end()?;
        self.o_prot_mut().flush()
      }
    )?;
    {
      let message_ident = self.i_prot_mut().read_message_begin()?;
      verify_expected_sequence_number(self.sequence_number(), message_ident.sequence_number)?;
      verify_expected_service_call("checkAndMutate", &message_ident.name)?;
      if message_ident.message_type == TMessageType::Exception {
        let remote_error = thrift::Error::read_application_error_from_in_protocol(self.i_prot_mut())?;
        self.i_prot_mut().read_message_end()?;
        return Err(thrift::Error::Application(remote_error))
      }
      verify_expected_message_type(TMessageType::Reply, message_ident.message_type)?;
      let result = THBaseServiceCheckAndMutateResult::read_from_in_protocol(self.i_prot_mut())?;
      self.i_prot_mut().read_message_end()?;
      result.ok_or()
    }
  }
  fn get_table_descriptor(&mut self, table: TTableName) -> thrift::Result<TTableDescriptor> {
    (
      {
        self.increment_sequence_number();
        let message_ident = TMessageIdentifier::new("getTableDescriptor", TMessageType::Call, self.sequence_number());
        let call_args = THBaseServiceGetTableDescriptorArgs { table };
        self.o_prot_mut().write_message_begin(&message_ident)?;
        call_args.write_to_out_protocol(self.o_prot_mut())?;
        self.o_prot_mut().write_message_end()?;
        self.o_prot_mut().flush()
      }
    )?;
    {
      let message_ident = self.i_prot_mut().read_message_begin()?;
      verify_expected_sequence_number(self.sequence_number(), message_ident.sequence_number)?;
      verify_expected_service_call("getTableDescriptor", &message_ident.name)?;
      if message_ident.message_type == TMessageType::Exception {
        let remote_error = thrift::Error::read_application_error_from_in_protocol(self.i_prot_mut())?;
        self.i_prot_mut().read_message_end()?;
        return Err(thrift::Error::Application(remote_error))
      }
      verify_expected_message_type(TMessageType::Reply, message_ident.message_type)?;
      let result = THBaseServiceGetTableDescriptorResult::read_from_in_protocol(self.i_prot_mut())?;
      self.i_prot_mut().read_message_end()?;
      result.ok_or()
    }
  }
  fn get_table_descriptors(&mut self, tables: Vec<TTableName>) -> thrift::Result<Vec<TTableDescriptor>> {
    (
      {
        self.increment_sequence_number();
        let message_ident = TMessageIdentifier::new("getTableDescriptors", TMessageType::Call, self.sequence_number());
        let call_args = THBaseServiceGetTableDescriptorsArgs { tables };
        self.o_prot_mut().write_message_begin(&message_ident)?;
        call_args.write_to_out_protocol(self.o_prot_mut())?;
        self.o_prot_mut().write_message_end()?;
        self.o_prot_mut().flush()
      }
    )?;
    {
      let message_ident = self.i_prot_mut().read_message_begin()?;
      verify_expected_sequence_number(self.sequence_number(), message_ident.sequence_number)?;
      verify_expected_service_call("getTableDescriptors", &message_ident.name)?;
      if message_ident.message_type == TMessageType::Exception {
        let remote_error = thrift::Error::read_application_error_from_in_protocol(self.i_prot_mut())?;
        self.i_prot_mut().read_message_end()?;
        return Err(thrift::Error::Application(remote_error))
      }
      verify_expected_message_type(TMessageType::Reply, message_ident.message_type)?;
      let result = THBaseServiceGetTableDescriptorsResult::read_from_in_protocol(self.i_prot_mut())?;
      self.i_prot_mut().read_message_end()?;
      result.ok_or()
    }
  }
  fn table_exists(&mut self, table_name: TTableName) -> thrift::Result<bool> {
    (
      {
        self.increment_sequence_number();
        let message_ident = TMessageIdentifier::new("tableExists", TMessageType::Call, self.sequence_number());
        let call_args = THBaseServiceTableExistsArgs { table_name };
        self.o_prot_mut().write_message_begin(&message_ident)?;
        call_args.write_to_out_protocol(self.o_prot_mut())?;
        self.o_prot_mut().write_message_end()?;
        self.o_prot_mut().flush()
      }
    )?;
    {
      let message_ident = self.i_prot_mut().read_message_begin()?;
      verify_expected_sequence_number(self.sequence_number(), message_ident.sequence_number)?;
      verify_expected_service_call("tableExists", &message_ident.name)?;
      if message_ident.message_type == TMessageType::Exception {
        let remote_error = thrift::Error::read_application_error_from_in_protocol(self.i_prot_mut())?;
        self.i_prot_mut().read_message_end()?;
        return Err(thrift::Error::Application(remote_error))
      }
      verify_expected_message_type(TMessageType::Reply, message_ident.message_type)?;
      let result = THBaseServiceTableExistsResult::read_from_in_protocol(self.i_prot_mut())?;
      self.i_prot_mut().read_message_end()?;
      result.ok_or()
    }
  }
  fn get_table_descriptors_by_pattern(&mut self, regex: String, include_sys_tables: bool) -> thrift::Result<Vec<TTableDescriptor>> {
    (
      {
        self.increment_sequence_number();
        let message_ident = TMessageIdentifier::new("getTableDescriptorsByPattern", TMessageType::Call, self.sequence_number());
        let call_args = THBaseServiceGetTableDescriptorsByPatternArgs { regex, include_sys_tables };
        self.o_prot_mut().write_message_begin(&message_ident)?;
        call_args.write_to_out_protocol(self.o_prot_mut())?;
        self.o_prot_mut().write_message_end()?;
        self.o_prot_mut().flush()
      }
    )?;
    {
      let message_ident = self.i_prot_mut().read_message_begin()?;
      verify_expected_sequence_number(self.sequence_number(), message_ident.sequence_number)?;
      verify_expected_service_call("getTableDescriptorsByPattern", &message_ident.name)?;
      if message_ident.message_type == TMessageType::Exception {
        let remote_error = thrift::Error::read_application_error_from_in_protocol(self.i_prot_mut())?;
        self.i_prot_mut().read_message_end()?;
        return Err(thrift::Error::Application(remote_error))
      }
      verify_expected_message_type(TMessageType::Reply, message_ident.message_type)?;
      let result = THBaseServiceGetTableDescriptorsByPatternResult::read_from_in_protocol(self.i_prot_mut())?;
      self.i_prot_mut().read_message_end()?;
      result.ok_or()
    }
  }
  fn get_table_descriptors_by_namespace(&mut self, name: String) -> thrift::Result<Vec<TTableDescriptor>> {
    (
      {
        self.increment_sequence_number();
        let message_ident = TMessageIdentifier::new("getTableDescriptorsByNamespace", TMessageType::Call, self.sequence_number());
        let call_args = THBaseServiceGetTableDescriptorsByNamespaceArgs { name };
        self.o_prot_mut().write_message_begin(&message_ident)?;
        call_args.write_to_out_protocol(self.o_prot_mut())?;
        self.o_prot_mut().write_message_end()?;
        self.o_prot_mut().flush()
      }
    )?;
    {
      let message_ident = self.i_prot_mut().read_message_begin()?;
      verify_expected_sequence_number(self.sequence_number(), message_ident.sequence_number)?;
      verify_expected_service_call("getTableDescriptorsByNamespace", &message_ident.name)?;
      if message_ident.message_type == TMessageType::Exception {
        let remote_error = thrift::Error::read_application_error_from_in_protocol(self.i_prot_mut())?;
        self.i_prot_mut().read_message_end()?;
        return Err(thrift::Error::Application(remote_error))
      }
      verify_expected_message_type(TMessageType::Reply, message_ident.message_type)?;
      let result = THBaseServiceGetTableDescriptorsByNamespaceResult::read_from_in_protocol(self.i_prot_mut())?;
      self.i_prot_mut().read_message_end()?;
      result.ok_or()
    }
  }
  fn get_table_names_by_pattern(&mut self, regex: String, include_sys_tables: bool) -> thrift::Result<Vec<TTableName>> {
    (
      {
        self.increment_sequence_number();
        let message_ident = TMessageIdentifier::new("getTableNamesByPattern", TMessageType::Call, self.sequence_number());
        let call_args = THBaseServiceGetTableNamesByPatternArgs { regex, include_sys_tables };
        self.o_prot_mut().write_message_begin(&message_ident)?;
        call_args.write_to_out_protocol(self.o_prot_mut())?;
        self.o_prot_mut().write_message_end()?;
        self.o_prot_mut().flush()
      }
    )?;
    {
      let message_ident = self.i_prot_mut().read_message_begin()?;
      verify_expected_sequence_number(self.sequence_number(), message_ident.sequence_number)?;
      verify_expected_service_call("getTableNamesByPattern", &message_ident.name)?;
      if message_ident.message_type == TMessageType::Exception {
        let remote_error = thrift::Error::read_application_error_from_in_protocol(self.i_prot_mut())?;
        self.i_prot_mut().read_message_end()?;
        return Err(thrift::Error::Application(remote_error))
      }
      verify_expected_message_type(TMessageType::Reply, message_ident.message_type)?;
      let result = THBaseServiceGetTableNamesByPatternResult::read_from_in_protocol(self.i_prot_mut())?;
      self.i_prot_mut().read_message_end()?;
      result.ok_or()
    }
  }
  fn get_table_names_by_namespace(&mut self, name: String) -> thrift::Result<Vec<TTableName>> {
    (
      {
        self.increment_sequence_number();
        let message_ident = TMessageIdentifier::new("getTableNamesByNamespace", TMessageType::Call, self.sequence_number());
        let call_args = THBaseServiceGetTableNamesByNamespaceArgs { name };
        self.o_prot_mut().write_message_begin(&message_ident)?;
        call_args.write_to_out_protocol(self.o_prot_mut())?;
        self.o_prot_mut().write_message_end()?;
        self.o_prot_mut().flush()
      }
    )?;
    {
      let message_ident = self.i_prot_mut().read_message_begin()?;
      verify_expected_sequence_number(self.sequence_number(), message_ident.sequence_number)?;
      verify_expected_service_call("getTableNamesByNamespace", &message_ident.name)?;
      if message_ident.message_type == TMessageType::Exception {
        let remote_error = thrift::Error::read_application_error_from_in_protocol(self.i_prot_mut())?;
        self.i_prot_mut().read_message_end()?;
        return Err(thrift::Error::Application(remote_error))
      }
      verify_expected_message_type(TMessageType::Reply, message_ident.message_type)?;
      let result = THBaseServiceGetTableNamesByNamespaceResult::read_from_in_protocol(self.i_prot_mut())?;
      self.i_prot_mut().read_message_end()?;
      result.ok_or()
    }
  }
  fn create_table(&mut self, desc: TTableDescriptor, split_keys: Vec<Vec<u8>>) -> thrift::Result<()> {
    (
      {
        self.increment_sequence_number();
        let message_ident = TMessageIdentifier::new("createTable", TMessageType::Call, self.sequence_number());
        let call_args = THBaseServiceCreateTableArgs { desc, split_keys };
        self.o_prot_mut().write_message_begin(&message_ident)?;
        call_args.write_to_out_protocol(self.o_prot_mut())?;
        self.o_prot_mut().write_message_end()?;
        self.o_prot_mut().flush()
      }
    )?;
    {
      let message_ident = self.i_prot_mut().read_message_begin()?;
      verify_expected_sequence_number(self.sequence_number(), message_ident.sequence_number)?;
      verify_expected_service_call("createTable", &message_ident.name)?;
      if message_ident.message_type == TMessageType::Exception {
        let remote_error = thrift::Error::read_application_error_from_in_protocol(self.i_prot_mut())?;
        self.i_prot_mut().read_message_end()?;
        return Err(thrift::Error::Application(remote_error))
      }
      verify_expected_message_type(TMessageType::Reply, message_ident.message_type)?;
      let result = THBaseServiceCreateTableResult::read_from_in_protocol(self.i_prot_mut())?;
      self.i_prot_mut().read_message_end()?;
      result.ok_or()
    }
  }
  fn delete_table(&mut self, table_name: TTableName) -> thrift::Result<()> {
    (
      {
        self.increment_sequence_number();
        let message_ident = TMessageIdentifier::new("deleteTable", TMessageType::Call, self.sequence_number());
        let call_args = THBaseServiceDeleteTableArgs { table_name };
        self.o_prot_mut().write_message_begin(&message_ident)?;
        call_args.write_to_out_protocol(self.o_prot_mut())?;
        self.o_prot_mut().write_message_end()?;
        self.o_prot_mut().flush()
      }
    )?;
    {
      let message_ident = self.i_prot_mut().read_message_begin()?;
      verify_expected_sequence_number(self.sequence_number(), message_ident.sequence_number)?;
      verify_expected_service_call("deleteTable", &message_ident.name)?;
      if message_ident.message_type == TMessageType::Exception {
        let remote_error = thrift::Error::read_application_error_from_in_protocol(self.i_prot_mut())?;
        self.i_prot_mut().read_message_end()?;
        return Err(thrift::Error::Application(remote_error))
      }
      verify_expected_message_type(TMessageType::Reply, message_ident.message_type)?;
      let result = THBaseServiceDeleteTableResult::read_from_in_protocol(self.i_prot_mut())?;
      self.i_prot_mut().read_message_end()?;
      result.ok_or()
    }
  }
  fn truncate_table(&mut self, table_name: TTableName, preserve_splits: bool) -> thrift::Result<()> {
    (
      {
        self.increment_sequence_number();
        let message_ident = TMessageIdentifier::new("truncateTable", TMessageType::Call, self.sequence_number());
        let call_args = THBaseServiceTruncateTableArgs { table_name, preserve_splits };
        self.o_prot_mut().write_message_begin(&message_ident)?;
        call_args.write_to_out_protocol(self.o_prot_mut())?;
        self.o_prot_mut().write_message_end()?;
        self.o_prot_mut().flush()
      }
    )?;
    {
      let message_ident = self.i_prot_mut().read_message_begin()?;
      verify_expected_sequence_number(self.sequence_number(), message_ident.sequence_number)?;
      verify_expected_service_call("truncateTable", &message_ident.name)?;
      if message_ident.message_type == TMessageType::Exception {
        let remote_error = thrift::Error::read_application_error_from_in_protocol(self.i_prot_mut())?;
        self.i_prot_mut().read_message_end()?;
        return Err(thrift::Error::Application(remote_error))
      }
      verify_expected_message_type(TMessageType::Reply, message_ident.message_type)?;
      let result = THBaseServiceTruncateTableResult::read_from_in_protocol(self.i_prot_mut())?;
      self.i_prot_mut().read_message_end()?;
      result.ok_or()
    }
  }
  fn enable_table(&mut self, table_name: TTableName) -> thrift::Result<()> {
    (
      {
        self.increment_sequence_number();
        let message_ident = TMessageIdentifier::new("enableTable", TMessageType::Call, self.sequence_number());
        let call_args = THBaseServiceEnableTableArgs { table_name };
        self.o_prot_mut().write_message_begin(&message_ident)?;
        call_args.write_to_out_protocol(self.o_prot_mut())?;
        self.o_prot_mut().write_message_end()?;
        self.o_prot_mut().flush()
      }
    )?;
    {
      let message_ident = self.i_prot_mut().read_message_begin()?;
      verify_expected_sequence_number(self.sequence_number(), message_ident.sequence_number)?;
      verify_expected_service_call("enableTable", &message_ident.name)?;
      if message_ident.message_type == TMessageType::Exception {
        let remote_error = thrift::Error::read_application_error_from_in_protocol(self.i_prot_mut())?;
        self.i_prot_mut().read_message_end()?;
        return Err(thrift::Error::Application(remote_error))
      }
      verify_expected_message_type(TMessageType::Reply, message_ident.message_type)?;
      let result = THBaseServiceEnableTableResult::read_from_in_protocol(self.i_prot_mut())?;
      self.i_prot_mut().read_message_end()?;
      result.ok_or()
    }
  }
  fn disable_table(&mut self, table_name: TTableName) -> thrift::Result<()> {
    (
      {
        self.increment_sequence_number();
        let message_ident = TMessageIdentifier::new("disableTable", TMessageType::Call, self.sequence_number());
        let call_args = THBaseServiceDisableTableArgs { table_name };
        self.o_prot_mut().write_message_begin(&message_ident)?;
        call_args.write_to_out_protocol(self.o_prot_mut())?;
        self.o_prot_mut().write_message_end()?;
        self.o_prot_mut().flush()
      }
    )?;
    {
      let message_ident = self.i_prot_mut().read_message_begin()?;
      verify_expected_sequence_number(self.sequence_number(), message_ident.sequence_number)?;
      verify_expected_service_call("disableTable", &message_ident.name)?;
      if message_ident.message_type == TMessageType::Exception {
        let remote_error = thrift::Error::read_application_error_from_in_protocol(self.i_prot_mut())?;
        self.i_prot_mut().read_message_end()?;
        return Err(thrift::Error::Application(remote_error))
      }
      verify_expected_message_type(TMessageType::Reply, message_ident.message_type)?;
      let result = THBaseServiceDisableTableResult::read_from_in_protocol(self.i_prot_mut())?;
      self.i_prot_mut().read_message_end()?;
      result.ok_or()
    }
  }
  fn is_table_enabled(&mut self, table_name: TTableName) -> thrift::Result<bool> {
    (
      {
        self.increment_sequence_number();
        let message_ident = TMessageIdentifier::new("isTableEnabled", TMessageType::Call, self.sequence_number());
        let call_args = THBaseServiceIsTableEnabledArgs { table_name };
        self.o_prot_mut().write_message_begin(&message_ident)?;
        call_args.write_to_out_protocol(self.o_prot_mut())?;
        self.o_prot_mut().write_message_end()?;
        self.o_prot_mut().flush()
      }
    )?;
    {
      let message_ident = self.i_prot_mut().read_message_begin()?;
      verify_expected_sequence_number(self.sequence_number(), message_ident.sequence_number)?;
      verify_expected_service_call("isTableEnabled", &message_ident.name)?;
      if message_ident.message_type == TMessageType::Exception {
        let remote_error = thrift::Error::read_application_error_from_in_protocol(self.i_prot_mut())?;
        self.i_prot_mut().read_message_end()?;
        return Err(thrift::Error::Application(remote_error))
      }
      verify_expected_message_type(TMessageType::Reply, message_ident.message_type)?;
      let result = THBaseServiceIsTableEnabledResult::read_from_in_protocol(self.i_prot_mut())?;
      self.i_prot_mut().read_message_end()?;
      result.ok_or()
    }
  }
  fn is_table_disabled(&mut self, table_name: TTableName) -> thrift::Result<bool> {
    (
      {
        self.increment_sequence_number();
        let message_ident = TMessageIdentifier::new("isTableDisabled", TMessageType::Call, self.sequence_number());
        let call_args = THBaseServiceIsTableDisabledArgs { table_name };
        self.o_prot_mut().write_message_begin(&message_ident)?;
        call_args.write_to_out_protocol(self.o_prot_mut())?;
        self.o_prot_mut().write_message_end()?;
        self.o_prot_mut().flush()
      }
    )?;
    {
      let message_ident = self.i_prot_mut().read_message_begin()?;
      verify_expected_sequence_number(self.sequence_number(), message_ident.sequence_number)?;
      verify_expected_service_call("isTableDisabled", &message_ident.name)?;
      if message_ident.message_type == TMessageType::Exception {
        let remote_error = thrift::Error::read_application_error_from_in_protocol(self.i_prot_mut())?;
        self.i_prot_mut().read_message_end()?;
        return Err(thrift::Error::Application(remote_error))
      }
      verify_expected_message_type(TMessageType::Reply, message_ident.message_type)?;
      let result = THBaseServiceIsTableDisabledResult::read_from_in_protocol(self.i_prot_mut())?;
      self.i_prot_mut().read_message_end()?;
      result.ok_or()
    }
  }
  fn is_table_available(&mut self, table_name: TTableName) -> thrift::Result<bool> {
    (
      {
        self.increment_sequence_number();
        let message_ident = TMessageIdentifier::new("isTableAvailable", TMessageType::Call, self.sequence_number());
        let call_args = THBaseServiceIsTableAvailableArgs { table_name };
        self.o_prot_mut().write_message_begin(&message_ident)?;
        call_args.write_to_out_protocol(self.o_prot_mut())?;
        self.o_prot_mut().write_message_end()?;
        self.o_prot_mut().flush()
      }
    )?;
    {
      let message_ident = self.i_prot_mut().read_message_begin()?;
      verify_expected_sequence_number(self.sequence_number(), message_ident.sequence_number)?;
      verify_expected_service_call("isTableAvailable", &message_ident.name)?;
      if message_ident.message_type == TMessageType::Exception {
        let remote_error = thrift::Error::read_application_error_from_in_protocol(self.i_prot_mut())?;
        self.i_prot_mut().read_message_end()?;
        return Err(thrift::Error::Application(remote_error))
      }
      verify_expected_message_type(TMessageType::Reply, message_ident.message_type)?;
      let result = THBaseServiceIsTableAvailableResult::read_from_in_protocol(self.i_prot_mut())?;
      self.i_prot_mut().read_message_end()?;
      result.ok_or()
    }
  }
  fn is_table_available_with_split(&mut self, table_name: TTableName, split_keys: Vec<Vec<u8>>) -> thrift::Result<bool> {
    (
      {
        self.increment_sequence_number();
        let message_ident = TMessageIdentifier::new("isTableAvailableWithSplit", TMessageType::Call, self.sequence_number());
        let call_args = THBaseServiceIsTableAvailableWithSplitArgs { table_name, split_keys };
        self.o_prot_mut().write_message_begin(&message_ident)?;
        call_args.write_to_out_protocol(self.o_prot_mut())?;
        self.o_prot_mut().write_message_end()?;
        self.o_prot_mut().flush()
      }
    )?;
    {
      let message_ident = self.i_prot_mut().read_message_begin()?;
      verify_expected_sequence_number(self.sequence_number(), message_ident.sequence_number)?;
      verify_expected_service_call("isTableAvailableWithSplit", &message_ident.name)?;
      if message_ident.message_type == TMessageType::Exception {
        let remote_error = thrift::Error::read_application_error_from_in_protocol(self.i_prot_mut())?;
        self.i_prot_mut().read_message_end()?;
        return Err(thrift::Error::Application(remote_error))
      }
      verify_expected_message_type(TMessageType::Reply, message_ident.message_type)?;
      let result = THBaseServiceIsTableAvailableWithSplitResult::read_from_in_protocol(self.i_prot_mut())?;
      self.i_prot_mut().read_message_end()?;
      result.ok_or()
    }
  }
  fn add_column_family(&mut self, table_name: TTableName, column: TColumnFamilyDescriptor) -> thrift::Result<()> {
    (
      {
        self.increment_sequence_number();
        let message_ident = TMessageIdentifier::new("addColumnFamily", TMessageType::Call, self.sequence_number());
        let call_args = THBaseServiceAddColumnFamilyArgs { table_name, column };
        self.o_prot_mut().write_message_begin(&message_ident)?;
        call_args.write_to_out_protocol(self.o_prot_mut())?;
        self.o_prot_mut().write_message_end()?;
        self.o_prot_mut().flush()
      }
    )?;
    {
      let message_ident = self.i_prot_mut().read_message_begin()?;
      verify_expected_sequence_number(self.sequence_number(), message_ident.sequence_number)?;
      verify_expected_service_call("addColumnFamily", &message_ident.name)?;
      if message_ident.message_type == TMessageType::Exception {
        let remote_error = thrift::Error::read_application_error_from_in_protocol(self.i_prot_mut())?;
        self.i_prot_mut().read_message_end()?;
        return Err(thrift::Error::Application(remote_error))
      }
      verify_expected_message_type(TMessageType::Reply, message_ident.message_type)?;
      let result = THBaseServiceAddColumnFamilyResult::read_from_in_protocol(self.i_prot_mut())?;
      self.i_prot_mut().read_message_end()?;
      result.ok_or()
    }
  }
  fn delete_column_family(&mut self, table_name: TTableName, column: Vec<u8>) -> thrift::Result<()> {
    (
      {
        self.increment_sequence_number();
        let message_ident = TMessageIdentifier::new("deleteColumnFamily", TMessageType::Call, self.sequence_number());
        let call_args = THBaseServiceDeleteColumnFamilyArgs { table_name, column };
        self.o_prot_mut().write_message_begin(&message_ident)?;
        call_args.write_to_out_protocol(self.o_prot_mut())?;
        self.o_prot_mut().write_message_end()?;
        self.o_prot_mut().flush()
      }
    )?;
    {
      let message_ident = self.i_prot_mut().read_message_begin()?;
      verify_expected_sequence_number(self.sequence_number(), message_ident.sequence_number)?;
      verify_expected_service_call("deleteColumnFamily", &message_ident.name)?;
      if message_ident.message_type == TMessageType::Exception {
        let remote_error = thrift::Error::read_application_error_from_in_protocol(self.i_prot_mut())?;
        self.i_prot_mut().read_message_end()?;
        return Err(thrift::Error::Application(remote_error))
      }
      verify_expected_message_type(TMessageType::Reply, message_ident.message_type)?;
      let result = THBaseServiceDeleteColumnFamilyResult::read_from_in_protocol(self.i_prot_mut())?;
      self.i_prot_mut().read_message_end()?;
      result.ok_or()
    }
  }
  fn modify_column_family(&mut self, table_name: TTableName, column: TColumnFamilyDescriptor) -> thrift::Result<()> {
    (
      {
        self.increment_sequence_number();
        let message_ident = TMessageIdentifier::new("modifyColumnFamily", TMessageType::Call, self.sequence_number());
        let call_args = THBaseServiceModifyColumnFamilyArgs { table_name, column };
        self.o_prot_mut().write_message_begin(&message_ident)?;
        call_args.write_to_out_protocol(self.o_prot_mut())?;
        self.o_prot_mut().write_message_end()?;
        self.o_prot_mut().flush()
      }
    )?;
    {
      let message_ident = self.i_prot_mut().read_message_begin()?;
      verify_expected_sequence_number(self.sequence_number(), message_ident.sequence_number)?;
      verify_expected_service_call("modifyColumnFamily", &message_ident.name)?;
      if message_ident.message_type == TMessageType::Exception {
        let remote_error = thrift::Error::read_application_error_from_in_protocol(self.i_prot_mut())?;
        self.i_prot_mut().read_message_end()?;
        return Err(thrift::Error::Application(remote_error))
      }
      verify_expected_message_type(TMessageType::Reply, message_ident.message_type)?;
      let result = THBaseServiceModifyColumnFamilyResult::read_from_in_protocol(self.i_prot_mut())?;
      self.i_prot_mut().read_message_end()?;
      result.ok_or()
    }
  }
  fn modify_table(&mut self, desc: TTableDescriptor) -> thrift::Result<()> {
    (
      {
        self.increment_sequence_number();
        let message_ident = TMessageIdentifier::new("modifyTable", TMessageType::Call, self.sequence_number());
        let call_args = THBaseServiceModifyTableArgs { desc };
        self.o_prot_mut().write_message_begin(&message_ident)?;
        call_args.write_to_out_protocol(self.o_prot_mut())?;
        self.o_prot_mut().write_message_end()?;
        self.o_prot_mut().flush()
      }
    )?;
    {
      let message_ident = self.i_prot_mut().read_message_begin()?;
      verify_expected_sequence_number(self.sequence_number(), message_ident.sequence_number)?;
      verify_expected_service_call("modifyTable", &message_ident.name)?;
      if message_ident.message_type == TMessageType::Exception {
        let remote_error = thrift::Error::read_application_error_from_in_protocol(self.i_prot_mut())?;
        self.i_prot_mut().read_message_end()?;
        return Err(thrift::Error::Application(remote_error))
      }
      verify_expected_message_type(TMessageType::Reply, message_ident.message_type)?;
      let result = THBaseServiceModifyTableResult::read_from_in_protocol(self.i_prot_mut())?;
      self.i_prot_mut().read_message_end()?;
      result.ok_or()
    }
  }
  fn create_namespace(&mut self, namespace_desc: TNamespaceDescriptor) -> thrift::Result<()> {
    (
      {
        self.increment_sequence_number();
        let message_ident = TMessageIdentifier::new("createNamespace", TMessageType::Call, self.sequence_number());
        let call_args = THBaseServiceCreateNamespaceArgs { namespace_desc };
        self.o_prot_mut().write_message_begin(&message_ident)?;
        call_args.write_to_out_protocol(self.o_prot_mut())?;
        self.o_prot_mut().write_message_end()?;
        self.o_prot_mut().flush()
      }
    )?;
    {
      let message_ident = self.i_prot_mut().read_message_begin()?;
      verify_expected_sequence_number(self.sequence_number(), message_ident.sequence_number)?;
      verify_expected_service_call("createNamespace", &message_ident.name)?;
      if message_ident.message_type == TMessageType::Exception {
        let remote_error = thrift::Error::read_application_error_from_in_protocol(self.i_prot_mut())?;
        self.i_prot_mut().read_message_end()?;
        return Err(thrift::Error::Application(remote_error))
      }
      verify_expected_message_type(TMessageType::Reply, message_ident.message_type)?;
      let result = THBaseServiceCreateNamespaceResult::read_from_in_protocol(self.i_prot_mut())?;
      self.i_prot_mut().read_message_end()?;
      result.ok_or()
    }
  }
  fn modify_namespace(&mut self, namespace_desc: TNamespaceDescriptor) -> thrift::Result<()> {
    (
      {
        self.increment_sequence_number();
        let message_ident = TMessageIdentifier::new("modifyNamespace", TMessageType::Call, self.sequence_number());
        let call_args = THBaseServiceModifyNamespaceArgs { namespace_desc };
        self.o_prot_mut().write_message_begin(&message_ident)?;
        call_args.write_to_out_protocol(self.o_prot_mut())?;
        self.o_prot_mut().write_message_end()?;
        self.o_prot_mut().flush()
      }
    )?;
    {
      let message_ident = self.i_prot_mut().read_message_begin()?;
      verify_expected_sequence_number(self.sequence_number(), message_ident.sequence_number)?;
      verify_expected_service_call("modifyNamespace", &message_ident.name)?;
      if message_ident.message_type == TMessageType::Exception {
        let remote_error = thrift::Error::read_application_error_from_in_protocol(self.i_prot_mut())?;
        self.i_prot_mut().read_message_end()?;
        return Err(thrift::Error::Application(remote_error))
      }
      verify_expected_message_type(TMessageType::Reply, message_ident.message_type)?;
      let result = THBaseServiceModifyNamespaceResult::read_from_in_protocol(self.i_prot_mut())?;
      self.i_prot_mut().read_message_end()?;
      result.ok_or()
    }
  }
  fn delete_namespace(&mut self, name: String) -> thrift::Result<()> {
    (
      {
        self.increment_sequence_number();
        let message_ident = TMessageIdentifier::new("deleteNamespace", TMessageType::Call, self.sequence_number());
        let call_args = THBaseServiceDeleteNamespaceArgs { name };
        self.o_prot_mut().write_message_begin(&message_ident)?;
        call_args.write_to_out_protocol(self.o_prot_mut())?;
        self.o_prot_mut().write_message_end()?;
        self.o_prot_mut().flush()
      }
    )?;
    {
      let message_ident = self.i_prot_mut().read_message_begin()?;
      verify_expected_sequence_number(self.sequence_number(), message_ident.sequence_number)?;
      verify_expected_service_call("deleteNamespace", &message_ident.name)?;
      if message_ident.message_type == TMessageType::Exception {
        let remote_error = thrift::Error::read_application_error_from_in_protocol(self.i_prot_mut())?;
        self.i_prot_mut().read_message_end()?;
        return Err(thrift::Error::Application(remote_error))
      }
      verify_expected_message_type(TMessageType::Reply, message_ident.message_type)?;
      let result = THBaseServiceDeleteNamespaceResult::read_from_in_protocol(self.i_prot_mut())?;
      self.i_prot_mut().read_message_end()?;
      result.ok_or()
    }
  }
  fn get_namespace_descriptor(&mut self, name: String) -> thrift::Result<TNamespaceDescriptor> {
    (
      {
        self.increment_sequence_number();
        let message_ident = TMessageIdentifier::new("getNamespaceDescriptor", TMessageType::Call, self.sequence_number());
        let call_args = THBaseServiceGetNamespaceDescriptorArgs { name };
        self.o_prot_mut().write_message_begin(&message_ident)?;
        call_args.write_to_out_protocol(self.o_prot_mut())?;
        self.o_prot_mut().write_message_end()?;
        self.o_prot_mut().flush()
      }
    )?;
    {
      let message_ident = self.i_prot_mut().read_message_begin()?;
      verify_expected_sequence_number(self.sequence_number(), message_ident.sequence_number)?;
      verify_expected_service_call("getNamespaceDescriptor", &message_ident.name)?;
      if message_ident.message_type == TMessageType::Exception {
        let remote_error = thrift::Error::read_application_error_from_in_protocol(self.i_prot_mut())?;
        self.i_prot_mut().read_message_end()?;
        return Err(thrift::Error::Application(remote_error))
      }
      verify_expected_message_type(TMessageType::Reply, message_ident.message_type)?;
      let result = THBaseServiceGetNamespaceDescriptorResult::read_from_in_protocol(self.i_prot_mut())?;
      self.i_prot_mut().read_message_end()?;
      result.ok_or()
    }
  }
  fn list_namespace_descriptors(&mut self) -> thrift::Result<Vec<TNamespaceDescriptor>> {
    (
      {
        self.increment_sequence_number();
        let message_ident = TMessageIdentifier::new("listNamespaceDescriptors", TMessageType::Call, self.sequence_number());
        let call_args = THBaseServiceListNamespaceDescriptorsArgs {  };
        self.o_prot_mut().write_message_begin(&message_ident)?;
        call_args.write_to_out_protocol(self.o_prot_mut())?;
        self.o_prot_mut().write_message_end()?;
        self.o_prot_mut().flush()
      }
    )?;
    {
      let message_ident = self.i_prot_mut().read_message_begin()?;
      verify_expected_sequence_number(self.sequence_number(), message_ident.sequence_number)?;
      verify_expected_service_call("listNamespaceDescriptors", &message_ident.name)?;
      if message_ident.message_type == TMessageType::Exception {
        let remote_error = thrift::Error::read_application_error_from_in_protocol(self.i_prot_mut())?;
        self.i_prot_mut().read_message_end()?;
        return Err(thrift::Error::Application(remote_error))
      }
      verify_expected_message_type(TMessageType::Reply, message_ident.message_type)?;
      let result = THBaseServiceListNamespaceDescriptorsResult::read_from_in_protocol(self.i_prot_mut())?;
      self.i_prot_mut().read_message_end()?;
      result.ok_or()
    }
  }
  fn list_namespaces(&mut self) -> thrift::Result<Vec<String>> {
    (
      {
        self.increment_sequence_number();
        let message_ident = TMessageIdentifier::new("listNamespaces", TMessageType::Call, self.sequence_number());
        let call_args = THBaseServiceListNamespacesArgs {  };
        self.o_prot_mut().write_message_begin(&message_ident)?;
        call_args.write_to_out_protocol(self.o_prot_mut())?;
        self.o_prot_mut().write_message_end()?;
        self.o_prot_mut().flush()
      }
    )?;
    {
      let message_ident = self.i_prot_mut().read_message_begin()?;
      verify_expected_sequence_number(self.sequence_number(), message_ident.sequence_number)?;
      verify_expected_service_call("listNamespaces", &message_ident.name)?;
      if message_ident.message_type == TMessageType::Exception {
        let remote_error = thrift::Error::read_application_error_from_in_protocol(self.i_prot_mut())?;
        self.i_prot_mut().read_message_end()?;
        return Err(thrift::Error::Application(remote_error))
      }
      verify_expected_message_type(TMessageType::Reply, message_ident.message_type)?;
      let result = THBaseServiceListNamespacesResult::read_from_in_protocol(self.i_prot_mut())?;
      self.i_prot_mut().read_message_end()?;
      result.ok_or()
    }
  }
  fn get_thrift_server_type(&mut self) -> thrift::Result<TThriftServerType> {
    (
      {
        self.increment_sequence_number();
        let message_ident = TMessageIdentifier::new("getThriftServerType", TMessageType::Call, self.sequence_number());
        let call_args = THBaseServiceGetThriftServerTypeArgs {  };
        self.o_prot_mut().write_message_begin(&message_ident)?;
        call_args.write_to_out_protocol(self.o_prot_mut())?;
        self.o_prot_mut().write_message_end()?;
        self.o_prot_mut().flush()
      }
    )?;
    {
      let message_ident = self.i_prot_mut().read_message_begin()?;
      verify_expected_sequence_number(self.sequence_number(), message_ident.sequence_number)?;
      verify_expected_service_call("getThriftServerType", &message_ident.name)?;
      if message_ident.message_type == TMessageType::Exception {
        let remote_error = thrift::Error::read_application_error_from_in_protocol(self.i_prot_mut())?;
        self.i_prot_mut().read_message_end()?;
        return Err(thrift::Error::Application(remote_error))
      }
      verify_expected_message_type(TMessageType::Reply, message_ident.message_type)?;
      let result = THBaseServiceGetThriftServerTypeResult::read_from_in_protocol(self.i_prot_mut())?;
      self.i_prot_mut().read_message_end()?;
      result.ok_or()
    }
  }
  fn get_cluster_id(&mut self) -> thrift::Result<String> {
    (
      {
        self.increment_sequence_number();
        let message_ident = TMessageIdentifier::new("getClusterId", TMessageType::Call, self.sequence_number());
        let call_args = THBaseServiceGetClusterIdArgs {  };
        self.o_prot_mut().write_message_begin(&message_ident)?;
        call_args.write_to_out_protocol(self.o_prot_mut())?;
        self.o_prot_mut().write_message_end()?;
        self.o_prot_mut().flush()
      }
    )?;
    {
      let message_ident = self.i_prot_mut().read_message_begin()?;
      verify_expected_sequence_number(self.sequence_number(), message_ident.sequence_number)?;
      verify_expected_service_call("getClusterId", &message_ident.name)?;
      if message_ident.message_type == TMessageType::Exception {
        let remote_error = thrift::Error::read_application_error_from_in_protocol(self.i_prot_mut())?;
        self.i_prot_mut().read_message_end()?;
        return Err(thrift::Error::Application(remote_error))
      }
      verify_expected_message_type(TMessageType::Reply, message_ident.message_type)?;
      let result = THBaseServiceGetClusterIdResult::read_from_in_protocol(self.i_prot_mut())?;
      self.i_prot_mut().read_message_end()?;
      result.ok_or()
    }
  }
  fn get_slow_log_responses(&mut self, server_names: BTreeSet<TServerName>, log_query_filter: TLogQueryFilter) -> thrift::Result<Vec<TOnlineLogRecord>> {
    (
      {
        self.increment_sequence_number();
        let message_ident = TMessageIdentifier::new("getSlowLogResponses", TMessageType::Call, self.sequence_number());
        let call_args = THBaseServiceGetSlowLogResponsesArgs { server_names, log_query_filter };
        self.o_prot_mut().write_message_begin(&message_ident)?;
        call_args.write_to_out_protocol(self.o_prot_mut())?;
        self.o_prot_mut().write_message_end()?;
        self.o_prot_mut().flush()
      }
    )?;
    {
      let message_ident = self.i_prot_mut().read_message_begin()?;
      verify_expected_sequence_number(self.sequence_number(), message_ident.sequence_number)?;
      verify_expected_service_call("getSlowLogResponses", &message_ident.name)?;
      if message_ident.message_type == TMessageType::Exception {
        let remote_error = thrift::Error::read_application_error_from_in_protocol(self.i_prot_mut())?;
        self.i_prot_mut().read_message_end()?;
        return Err(thrift::Error::Application(remote_error))
      }
      verify_expected_message_type(TMessageType::Reply, message_ident.message_type)?;
      let result = THBaseServiceGetSlowLogResponsesResult::read_from_in_protocol(self.i_prot_mut())?;
      self.i_prot_mut().read_message_end()?;
      result.ok_or()
    }
  }
  fn clear_slow_log_responses(&mut self, server_names: BTreeSet<TServerName>) -> thrift::Result<Vec<bool>> {
    (
      {
        self.increment_sequence_number();
        let message_ident = TMessageIdentifier::new("clearSlowLogResponses", TMessageType::Call, self.sequence_number());
        let call_args = THBaseServiceClearSlowLogResponsesArgs { server_names };
        self.o_prot_mut().write_message_begin(&message_ident)?;
        call_args.write_to_out_protocol(self.o_prot_mut())?;
        self.o_prot_mut().write_message_end()?;
        self.o_prot_mut().flush()
      }
    )?;
    {
      let message_ident = self.i_prot_mut().read_message_begin()?;
      verify_expected_sequence_number(self.sequence_number(), message_ident.sequence_number)?;
      verify_expected_service_call("clearSlowLogResponses", &message_ident.name)?;
      if message_ident.message_type == TMessageType::Exception {
        let remote_error = thrift::Error::read_application_error_from_in_protocol(self.i_prot_mut())?;
        self.i_prot_mut().read_message_end()?;
        return Err(thrift::Error::Application(remote_error))
      }
      verify_expected_message_type(TMessageType::Reply, message_ident.message_type)?;
      let result = THBaseServiceClearSlowLogResponsesResult::read_from_in_protocol(self.i_prot_mut())?;
      self.i_prot_mut().read_message_end()?;
      result.ok_or()
    }
  }
  fn grant(&mut self, info: TAccessControlEntity) -> thrift::Result<bool> {
    (
      {
        self.increment_sequence_number();
        let message_ident = TMessageIdentifier::new("grant", TMessageType::Call, self.sequence_number());
        let call_args = THBaseServiceGrantArgs { info };
        self.o_prot_mut().write_message_begin(&message_ident)?;
        call_args.write_to_out_protocol(self.o_prot_mut())?;
        self.o_prot_mut().write_message_end()?;
        self.o_prot_mut().flush()
      }
    )?;
    {
      let message_ident = self.i_prot_mut().read_message_begin()?;
      verify_expected_sequence_number(self.sequence_number(), message_ident.sequence_number)?;
      verify_expected_service_call("grant", &message_ident.name)?;
      if message_ident.message_type == TMessageType::Exception {
        let remote_error = thrift::Error::read_application_error_from_in_protocol(self.i_prot_mut())?;
        self.i_prot_mut().read_message_end()?;
        return Err(thrift::Error::Application(remote_error))
      }
      verify_expected_message_type(TMessageType::Reply, message_ident.message_type)?;
      let result = THBaseServiceGrantResult::read_from_in_protocol(self.i_prot_mut())?;
      self.i_prot_mut().read_message_end()?;
      result.ok_or()
    }
  }
  fn revoke(&mut self, info: TAccessControlEntity) -> thrift::Result<bool> {
    (
      {
        self.increment_sequence_number();
        let message_ident = TMessageIdentifier::new("revoke", TMessageType::Call, self.sequence_number());
        let call_args = THBaseServiceRevokeArgs { info };
        self.o_prot_mut().write_message_begin(&message_ident)?;
        call_args.write_to_out_protocol(self.o_prot_mut())?;
        self.o_prot_mut().write_message_end()?;
        self.o_prot_mut().flush()
      }
    )?;
    {
      let message_ident = self.i_prot_mut().read_message_begin()?;
      verify_expected_sequence_number(self.sequence_number(), message_ident.sequence_number)?;
      verify_expected_service_call("revoke", &message_ident.name)?;
      if message_ident.message_type == TMessageType::Exception {
        let remote_error = thrift::Error::read_application_error_from_in_protocol(self.i_prot_mut())?;
        self.i_prot_mut().read_message_end()?;
        return Err(thrift::Error::Application(remote_error))
      }
      verify_expected_message_type(TMessageType::Reply, message_ident.message_type)?;
      let result = THBaseServiceRevokeResult::read_from_in_protocol(self.i_prot_mut())?;
      self.i_prot_mut().read_message_end()?;
      result.ok_or()
    }
  }
}

//
// THBaseService service processor
//

pub trait THBaseServiceSyncHandler {
  /// Test for the existence of columns in the table, as specified in the TGet.
  /// 
  /// @return true if the specified TGet matches one or more keys, false if not
  fn handle_exists(&self, table: Vec<u8>, tget: TGet) -> thrift::Result<bool>;
  /// Test for the existence of columns in the table, as specified by the TGets.
  /// 
  /// This will return an array of booleans. Each value will be true if the related Get matches
  /// one or more keys, false if not.
  fn handle_exists_all(&self, table: Vec<u8>, tgets: Vec<TGet>) -> thrift::Result<Vec<bool>>;
  /// Method for getting data from a row.
  /// 
  /// If the row cannot be found an empty Result is returned.
  /// This can be checked by the empty field of the TResult
  /// 
  /// @return the result
  fn handle_get(&self, table: Vec<u8>, tget: TGet) -> thrift::Result<TResult>;
  /// Method for getting multiple rows.
  /// 
  /// If a row cannot be found there will be a null
  /// value in the result list for that TGet at the
  /// same position.
  /// 
  /// So the Results are in the same order as the TGets.
  fn handle_get_multiple(&self, table: Vec<u8>, tgets: Vec<TGet>) -> thrift::Result<Vec<TResult>>;
  /// Commit a TPut to a table.
  fn handle_put(&self, table: Vec<u8>, tput: TPut) -> thrift::Result<()>;
  /// Atomically checks if a row/family/qualifier value matches the expected
  /// value. If it does, it adds the TPut.
  /// 
  /// @return true if the new put was executed, false otherwise
  fn handle_check_and_put(&self, table: Vec<u8>, row: Vec<u8>, family: Vec<u8>, qualifier: Vec<u8>, value: Vec<u8>, tput: TPut) -> thrift::Result<bool>;
  /// Commit a List of Puts to the table.
  fn handle_put_multiple(&self, table: Vec<u8>, tputs: Vec<TPut>) -> thrift::Result<()>;
  /// Deletes as specified by the TDelete.
  /// 
  /// Note: "delete" is a reserved keyword and cannot be used in Thrift
  /// thus the inconsistent naming scheme from the other functions.
  fn handle_delete_single(&self, table: Vec<u8>, tdelete: TDelete) -> thrift::Result<()>;
  /// Bulk commit a List of TDeletes to the table.
  /// 
  /// Throws a TIOError if any of the deletes fail.
  /// 
  /// Always returns an empty list for backwards compatibility.
  fn handle_delete_multiple(&self, table: Vec<u8>, tdeletes: Vec<TDelete>) -> thrift::Result<Vec<TDelete>>;
  /// Atomically checks if a row/family/qualifier value matches the expected
  /// value. If it does, it adds the delete.
  /// 
  /// @return true if the new delete was executed, false otherwise
  fn handle_check_and_delete(&self, table: Vec<u8>, row: Vec<u8>, family: Vec<u8>, qualifier: Vec<u8>, value: Vec<u8>, tdelete: TDelete) -> thrift::Result<bool>;
  fn handle_increment(&self, table: Vec<u8>, tincrement: TIncrement) -> thrift::Result<TResult>;
  fn handle_append(&self, table: Vec<u8>, tappend: TAppend) -> thrift::Result<TResult>;
  /// Get a Scanner for the provided TScan object.
  /// 
  /// @return Scanner Id to be used with other scanner procedures
  fn handle_open_scanner(&self, table: Vec<u8>, tscan: TScan) -> thrift::Result<i32>;
  /// Grabs multiple rows from a Scanner.
  /// 
  /// @return Between zero and numRows TResults
  fn handle_get_scanner_rows(&self, scanner_id: i32, num_rows: i32) -> thrift::Result<Vec<TResult>>;
  /// Closes the scanner. Should be called to free server side resources timely.
  /// Typically close once the scanner is not needed anymore, i.e. after looping
  /// over it to get all the required rows.
  fn handle_close_scanner(&self, scanner_id: i32) -> thrift::Result<()>;
  /// mutateRow performs multiple mutations atomically on a single row.
  fn handle_mutate_row(&self, table: Vec<u8>, trow_mutations: TRowMutations) -> thrift::Result<()>;
  /// Get results for the provided TScan object.
  /// This helper function opens a scanner, get the results and close the scanner.
  /// 
  /// @return between zero and numRows TResults
  fn handle_get_scanner_results(&self, table: Vec<u8>, tscan: TScan, num_rows: i32) -> thrift::Result<Vec<TResult>>;
  /// Given a table and a row get the location of the region that
  /// would contain the given row key.
  /// 
  /// reload = true means the cache will be cleared and the location
  /// will be fetched from meta.
  fn handle_get_region_location(&self, table: Vec<u8>, row: Vec<u8>, reload: bool) -> thrift::Result<THRegionLocation>;
  /// Get all of the region locations for a given table.
  /// 
  fn handle_get_all_region_locations(&self, table: Vec<u8>) -> thrift::Result<Vec<THRegionLocation>>;
  /// Atomically checks if a row/family/qualifier value matches the expected
  /// value. If it does, it mutates the row.
  /// 
  /// @return true if the row was mutated, false otherwise
  fn handle_check_and_mutate(&self, table: Vec<u8>, row: Vec<u8>, family: Vec<u8>, qualifier: Vec<u8>, compare_operator: TCompareOperator, value: Vec<u8>, row_mutations: TRowMutations) -> thrift::Result<bool>;
  /// Get a table descriptor.
  /// @return the TableDescriptor of the giving tablename
  /// 
  fn handle_get_table_descriptor(&self, table: TTableName) -> thrift::Result<TTableDescriptor>;
  /// Get table descriptors of tables.
  /// @return the TableDescriptor of the giving tablename
  /// 
  fn handle_get_table_descriptors(&self, tables: Vec<TTableName>) -> thrift::Result<Vec<TTableDescriptor>>;
  /// 
  /// @return true if table exists already, false if not
  /// 
  fn handle_table_exists(&self, table_name: TTableName) -> thrift::Result<bool>;
  /// Get table descriptors of tables that match the given pattern
  /// @return the tableDescriptors of the matching table
  /// 
  fn handle_get_table_descriptors_by_pattern(&self, regex: String, include_sys_tables: bool) -> thrift::Result<Vec<TTableDescriptor>>;
  /// Get table descriptors of tables in the given namespace
  /// @return the tableDescriptors in the namespce
  /// 
  fn handle_get_table_descriptors_by_namespace(&self, name: String) -> thrift::Result<Vec<TTableDescriptor>>;
  /// Get table names of tables that match the given pattern
  /// @return the table names of the matching table
  /// 
  fn handle_get_table_names_by_pattern(&self, regex: String, include_sys_tables: bool) -> thrift::Result<Vec<TTableName>>;
  /// Get table names of tables in the given namespace
  /// @return the table names of the matching table
  /// 
  fn handle_get_table_names_by_namespace(&self, name: String) -> thrift::Result<Vec<TTableName>>;
  /// Creates a new table with an initial set of empty regions defined by the specified split keys.
  /// The total number of regions created will be the number of split keys plus one. Synchronous
  /// operation.
  /// 
  fn handle_create_table(&self, desc: TTableDescriptor, split_keys: Vec<Vec<u8>>) -> thrift::Result<()>;
  /// Deletes a table. Synchronous operation.
  /// 
  fn handle_delete_table(&self, table_name: TTableName) -> thrift::Result<()>;
  /// Truncate a table. Synchronous operation.
  /// 
  fn handle_truncate_table(&self, table_name: TTableName, preserve_splits: bool) -> thrift::Result<()>;
  /// Enalbe a table
  /// 
  fn handle_enable_table(&self, table_name: TTableName) -> thrift::Result<()>;
  /// Disable a table
  /// 
  fn handle_disable_table(&self, table_name: TTableName) -> thrift::Result<()>;
  /// 
  /// @return true if table is enabled, false if not
  /// 
  fn handle_is_table_enabled(&self, table_name: TTableName) -> thrift::Result<bool>;
  /// 
  /// @return true if table is disabled, false if not
  /// 
  fn handle_is_table_disabled(&self, table_name: TTableName) -> thrift::Result<bool>;
  /// 
  /// @return true if table is available, false if not
  /// 
  fn handle_is_table_available(&self, table_name: TTableName) -> thrift::Result<bool>;
  ///  * Use this api to check if the table has been created with the specified number of splitkeys
  ///  * which was used while creating the given table. Note : If this api is used after a table's
  ///  * region gets splitted, the api may return false.
  ///  *
  ///  * @return true if table is available, false if not
  ///  *
  ///  * @deprecated Since 2.2.0. Because the same method in Table interface has been deprecated
  ///  * since 2.0.0, we will remove it in 3.0.0 release.
  ///  * Use {@link #isTableAvailable(TTableName tableName)} instead
  /// *
  fn handle_is_table_available_with_split(&self, table_name: TTableName, split_keys: Vec<Vec<u8>>) -> thrift::Result<bool>;
  /// Add a column family to an existing table. Synchronous operation.
  /// 
  fn handle_add_column_family(&self, table_name: TTableName, column: TColumnFamilyDescriptor) -> thrift::Result<()>;
  /// Delete a column family from a table. Synchronous operation.
  /// 
  fn handle_delete_column_family(&self, table_name: TTableName, column: Vec<u8>) -> thrift::Result<()>;
  /// Modify an existing column family on a table. Synchronous operation.
  /// 
  fn handle_modify_column_family(&self, table_name: TTableName, column: TColumnFamilyDescriptor) -> thrift::Result<()>;
  /// Modify an existing table
  /// 
  fn handle_modify_table(&self, desc: TTableDescriptor) -> thrift::Result<()>;
  /// Create a new namespace. Blocks until namespace has been successfully created or an exception is
  /// thrown
  /// 
  fn handle_create_namespace(&self, namespace_desc: TNamespaceDescriptor) -> thrift::Result<()>;
  /// Modify an existing namespace.  Blocks until namespace has been successfully modified or an
  /// exception is thrown
  /// 
  fn handle_modify_namespace(&self, namespace_desc: TNamespaceDescriptor) -> thrift::Result<()>;
  /// Delete an existing namespace. Only empty namespaces (no tables) can be removed.
  /// Blocks until namespace has been successfully deleted or an
  /// exception is thrown.
  /// 
  fn handle_delete_namespace(&self, name: String) -> thrift::Result<()>;
  /// Get a namespace descriptor by name.
  /// @retrun the descriptor
  /// 
  fn handle_get_namespace_descriptor(&self, name: String) -> thrift::Result<TNamespaceDescriptor>;
  /// @return all namespaces
  /// 
  fn handle_list_namespace_descriptors(&self) -> thrift::Result<Vec<TNamespaceDescriptor>>;
  /// @return all namespace names
  /// 
  fn handle_list_namespaces(&self) -> thrift::Result<Vec<String>>;
  /// Get the type of this thrift server.
  /// 
  /// @return the type of this thrift server
  fn handle_get_thrift_server_type(&self) -> thrift::Result<TThriftServerType>;
  /// Returns the cluster ID for this cluster.
  fn handle_get_cluster_id(&self) -> thrift::Result<String>;
  /// Retrieves online slow RPC logs from the provided list of
  /// RegionServers
  /// 
  /// @return online slowlog response list
  /// @throws TIOError if a remote or network exception occurs
  fn handle_get_slow_log_responses(&self, server_names: BTreeSet<TServerName>, log_query_filter: TLogQueryFilter) -> thrift::Result<Vec<TOnlineLogRecord>>;
  /// Clears online slow/large RPC logs from the provided list of
  /// RegionServers
  /// 
  /// @return List of booleans representing if online slowlog response buffer is cleaned
  ///   from each RegionServer
  /// @throws TIOError if a remote or network exception occurs
  fn handle_clear_slow_log_responses(&self, server_names: BTreeSet<TServerName>) -> thrift::Result<Vec<bool>>;
  /// Grant permissions in table or namespace level.
  fn handle_grant(&self, info: TAccessControlEntity) -> thrift::Result<bool>;
  /// Revoke permissions in table or namespace level.
  fn handle_revoke(&self, info: TAccessControlEntity) -> thrift::Result<bool>;
}

pub struct THBaseServiceSyncProcessor<H: THBaseServiceSyncHandler> {
  handler: H,
}

impl <H: THBaseServiceSyncHandler> THBaseServiceSyncProcessor<H> {
  pub fn new(handler: H) -> THBaseServiceSyncProcessor<H> {
    THBaseServiceSyncProcessor {
      handler,
    }
  }
  fn process_exists(&self, incoming_sequence_number: i32, i_prot: &mut dyn TInputProtocol, o_prot: &mut dyn TOutputProtocol) -> thrift::Result<()> {
    TTHBaseServiceProcessFunctions::process_exists(&self.handler, incoming_sequence_number, i_prot, o_prot)
  }
  fn process_exists_all(&self, incoming_sequence_number: i32, i_prot: &mut dyn TInputProtocol, o_prot: &mut dyn TOutputProtocol) -> thrift::Result<()> {
    TTHBaseServiceProcessFunctions::process_exists_all(&self.handler, incoming_sequence_number, i_prot, o_prot)
  }
  fn process_get(&self, incoming_sequence_number: i32, i_prot: &mut dyn TInputProtocol, o_prot: &mut dyn TOutputProtocol) -> thrift::Result<()> {
    TTHBaseServiceProcessFunctions::process_get(&self.handler, incoming_sequence_number, i_prot, o_prot)
  }
  fn process_get_multiple(&self, incoming_sequence_number: i32, i_prot: &mut dyn TInputProtocol, o_prot: &mut dyn TOutputProtocol) -> thrift::Result<()> {
    TTHBaseServiceProcessFunctions::process_get_multiple(&self.handler, incoming_sequence_number, i_prot, o_prot)
  }
  fn process_put(&self, incoming_sequence_number: i32, i_prot: &mut dyn TInputProtocol, o_prot: &mut dyn TOutputProtocol) -> thrift::Result<()> {
    TTHBaseServiceProcessFunctions::process_put(&self.handler, incoming_sequence_number, i_prot, o_prot)
  }
  fn process_check_and_put(&self, incoming_sequence_number: i32, i_prot: &mut dyn TInputProtocol, o_prot: &mut dyn TOutputProtocol) -> thrift::Result<()> {
    TTHBaseServiceProcessFunctions::process_check_and_put(&self.handler, incoming_sequence_number, i_prot, o_prot)
  }
  fn process_put_multiple(&self, incoming_sequence_number: i32, i_prot: &mut dyn TInputProtocol, o_prot: &mut dyn TOutputProtocol) -> thrift::Result<()> {
    TTHBaseServiceProcessFunctions::process_put_multiple(&self.handler, incoming_sequence_number, i_prot, o_prot)
  }
  fn process_delete_single(&self, incoming_sequence_number: i32, i_prot: &mut dyn TInputProtocol, o_prot: &mut dyn TOutputProtocol) -> thrift::Result<()> {
    TTHBaseServiceProcessFunctions::process_delete_single(&self.handler, incoming_sequence_number, i_prot, o_prot)
  }
  fn process_delete_multiple(&self, incoming_sequence_number: i32, i_prot: &mut dyn TInputProtocol, o_prot: &mut dyn TOutputProtocol) -> thrift::Result<()> {
    TTHBaseServiceProcessFunctions::process_delete_multiple(&self.handler, incoming_sequence_number, i_prot, o_prot)
  }
  fn process_check_and_delete(&self, incoming_sequence_number: i32, i_prot: &mut dyn TInputProtocol, o_prot: &mut dyn TOutputProtocol) -> thrift::Result<()> {
    TTHBaseServiceProcessFunctions::process_check_and_delete(&self.handler, incoming_sequence_number, i_prot, o_prot)
  }
  fn process_increment(&self, incoming_sequence_number: i32, i_prot: &mut dyn TInputProtocol, o_prot: &mut dyn TOutputProtocol) -> thrift::Result<()> {
    TTHBaseServiceProcessFunctions::process_increment(&self.handler, incoming_sequence_number, i_prot, o_prot)
  }
  fn process_append(&self, incoming_sequence_number: i32, i_prot: &mut dyn TInputProtocol, o_prot: &mut dyn TOutputProtocol) -> thrift::Result<()> {
    TTHBaseServiceProcessFunctions::process_append(&self.handler, incoming_sequence_number, i_prot, o_prot)
  }
  fn process_open_scanner(&self, incoming_sequence_number: i32, i_prot: &mut dyn TInputProtocol, o_prot: &mut dyn TOutputProtocol) -> thrift::Result<()> {
    TTHBaseServiceProcessFunctions::process_open_scanner(&self.handler, incoming_sequence_number, i_prot, o_prot)
  }
  fn process_get_scanner_rows(&self, incoming_sequence_number: i32, i_prot: &mut dyn TInputProtocol, o_prot: &mut dyn TOutputProtocol) -> thrift::Result<()> {
    TTHBaseServiceProcessFunctions::process_get_scanner_rows(&self.handler, incoming_sequence_number, i_prot, o_prot)
  }
  fn process_close_scanner(&self, incoming_sequence_number: i32, i_prot: &mut dyn TInputProtocol, o_prot: &mut dyn TOutputProtocol) -> thrift::Result<()> {
    TTHBaseServiceProcessFunctions::process_close_scanner(&self.handler, incoming_sequence_number, i_prot, o_prot)
  }
  fn process_mutate_row(&self, incoming_sequence_number: i32, i_prot: &mut dyn TInputProtocol, o_prot: &mut dyn TOutputProtocol) -> thrift::Result<()> {
    TTHBaseServiceProcessFunctions::process_mutate_row(&self.handler, incoming_sequence_number, i_prot, o_prot)
  }
  fn process_get_scanner_results(&self, incoming_sequence_number: i32, i_prot: &mut dyn TInputProtocol, o_prot: &mut dyn TOutputProtocol) -> thrift::Result<()> {
    TTHBaseServiceProcessFunctions::process_get_scanner_results(&self.handler, incoming_sequence_number, i_prot, o_prot)
  }
  fn process_get_region_location(&self, incoming_sequence_number: i32, i_prot: &mut dyn TInputProtocol, o_prot: &mut dyn TOutputProtocol) -> thrift::Result<()> {
    TTHBaseServiceProcessFunctions::process_get_region_location(&self.handler, incoming_sequence_number, i_prot, o_prot)
  }
  fn process_get_all_region_locations(&self, incoming_sequence_number: i32, i_prot: &mut dyn TInputProtocol, o_prot: &mut dyn TOutputProtocol) -> thrift::Result<()> {
    TTHBaseServiceProcessFunctions::process_get_all_region_locations(&self.handler, incoming_sequence_number, i_prot, o_prot)
  }
  fn process_check_and_mutate(&self, incoming_sequence_number: i32, i_prot: &mut dyn TInputProtocol, o_prot: &mut dyn TOutputProtocol) -> thrift::Result<()> {
    TTHBaseServiceProcessFunctions::process_check_and_mutate(&self.handler, incoming_sequence_number, i_prot, o_prot)
  }
  fn process_get_table_descriptor(&self, incoming_sequence_number: i32, i_prot: &mut dyn TInputProtocol, o_prot: &mut dyn TOutputProtocol) -> thrift::Result<()> {
    TTHBaseServiceProcessFunctions::process_get_table_descriptor(&self.handler, incoming_sequence_number, i_prot, o_prot)
  }
  fn process_get_table_descriptors(&self, incoming_sequence_number: i32, i_prot: &mut dyn TInputProtocol, o_prot: &mut dyn TOutputProtocol) -> thrift::Result<()> {
    TTHBaseServiceProcessFunctions::process_get_table_descriptors(&self.handler, incoming_sequence_number, i_prot, o_prot)
  }
  fn process_table_exists(&self, incoming_sequence_number: i32, i_prot: &mut dyn TInputProtocol, o_prot: &mut dyn TOutputProtocol) -> thrift::Result<()> {
    TTHBaseServiceProcessFunctions::process_table_exists(&self.handler, incoming_sequence_number, i_prot, o_prot)
  }
  fn process_get_table_descriptors_by_pattern(&self, incoming_sequence_number: i32, i_prot: &mut dyn TInputProtocol, o_prot: &mut dyn TOutputProtocol) -> thrift::Result<()> {
    TTHBaseServiceProcessFunctions::process_get_table_descriptors_by_pattern(&self.handler, incoming_sequence_number, i_prot, o_prot)
  }
  fn process_get_table_descriptors_by_namespace(&self, incoming_sequence_number: i32, i_prot: &mut dyn TInputProtocol, o_prot: &mut dyn TOutputProtocol) -> thrift::Result<()> {
    TTHBaseServiceProcessFunctions::process_get_table_descriptors_by_namespace(&self.handler, incoming_sequence_number, i_prot, o_prot)
  }
  fn process_get_table_names_by_pattern(&self, incoming_sequence_number: i32, i_prot: &mut dyn TInputProtocol, o_prot: &mut dyn TOutputProtocol) -> thrift::Result<()> {
    TTHBaseServiceProcessFunctions::process_get_table_names_by_pattern(&self.handler, incoming_sequence_number, i_prot, o_prot)
  }
  fn process_get_table_names_by_namespace(&self, incoming_sequence_number: i32, i_prot: &mut dyn TInputProtocol, o_prot: &mut dyn TOutputProtocol) -> thrift::Result<()> {
    TTHBaseServiceProcessFunctions::process_get_table_names_by_namespace(&self.handler, incoming_sequence_number, i_prot, o_prot)
  }
  fn process_create_table(&self, incoming_sequence_number: i32, i_prot: &mut dyn TInputProtocol, o_prot: &mut dyn TOutputProtocol) -> thrift::Result<()> {
    TTHBaseServiceProcessFunctions::process_create_table(&self.handler, incoming_sequence_number, i_prot, o_prot)
  }
  fn process_delete_table(&self, incoming_sequence_number: i32, i_prot: &mut dyn TInputProtocol, o_prot: &mut dyn TOutputProtocol) -> thrift::Result<()> {
    TTHBaseServiceProcessFunctions::process_delete_table(&self.handler, incoming_sequence_number, i_prot, o_prot)
  }
  fn process_truncate_table(&self, incoming_sequence_number: i32, i_prot: &mut dyn TInputProtocol, o_prot: &mut dyn TOutputProtocol) -> thrift::Result<()> {
    TTHBaseServiceProcessFunctions::process_truncate_table(&self.handler, incoming_sequence_number, i_prot, o_prot)
  }
  fn process_enable_table(&self, incoming_sequence_number: i32, i_prot: &mut dyn TInputProtocol, o_prot: &mut dyn TOutputProtocol) -> thrift::Result<()> {
    TTHBaseServiceProcessFunctions::process_enable_table(&self.handler, incoming_sequence_number, i_prot, o_prot)
  }
  fn process_disable_table(&self, incoming_sequence_number: i32, i_prot: &mut dyn TInputProtocol, o_prot: &mut dyn TOutputProtocol) -> thrift::Result<()> {
    TTHBaseServiceProcessFunctions::process_disable_table(&self.handler, incoming_sequence_number, i_prot, o_prot)
  }
  fn process_is_table_enabled(&self, incoming_sequence_number: i32, i_prot: &mut dyn TInputProtocol, o_prot: &mut dyn TOutputProtocol) -> thrift::Result<()> {
    TTHBaseServiceProcessFunctions::process_is_table_enabled(&self.handler, incoming_sequence_number, i_prot, o_prot)
  }
  fn process_is_table_disabled(&self, incoming_sequence_number: i32, i_prot: &mut dyn TInputProtocol, o_prot: &mut dyn TOutputProtocol) -> thrift::Result<()> {
    TTHBaseServiceProcessFunctions::process_is_table_disabled(&self.handler, incoming_sequence_number, i_prot, o_prot)
  }
  fn process_is_table_available(&self, incoming_sequence_number: i32, i_prot: &mut dyn TInputProtocol, o_prot: &mut dyn TOutputProtocol) -> thrift::Result<()> {
    TTHBaseServiceProcessFunctions::process_is_table_available(&self.handler, incoming_sequence_number, i_prot, o_prot)
  }
  fn process_is_table_available_with_split(&self, incoming_sequence_number: i32, i_prot: &mut dyn TInputProtocol, o_prot: &mut dyn TOutputProtocol) -> thrift::Result<()> {
    TTHBaseServiceProcessFunctions::process_is_table_available_with_split(&self.handler, incoming_sequence_number, i_prot, o_prot)
  }
  fn process_add_column_family(&self, incoming_sequence_number: i32, i_prot: &mut dyn TInputProtocol, o_prot: &mut dyn TOutputProtocol) -> thrift::Result<()> {
    TTHBaseServiceProcessFunctions::process_add_column_family(&self.handler, incoming_sequence_number, i_prot, o_prot)
  }
  fn process_delete_column_family(&self, incoming_sequence_number: i32, i_prot: &mut dyn TInputProtocol, o_prot: &mut dyn TOutputProtocol) -> thrift::Result<()> {
    TTHBaseServiceProcessFunctions::process_delete_column_family(&self.handler, incoming_sequence_number, i_prot, o_prot)
  }
  fn process_modify_column_family(&self, incoming_sequence_number: i32, i_prot: &mut dyn TInputProtocol, o_prot: &mut dyn TOutputProtocol) -> thrift::Result<()> {
    TTHBaseServiceProcessFunctions::process_modify_column_family(&self.handler, incoming_sequence_number, i_prot, o_prot)
  }
  fn process_modify_table(&self, incoming_sequence_number: i32, i_prot: &mut dyn TInputProtocol, o_prot: &mut dyn TOutputProtocol) -> thrift::Result<()> {
    TTHBaseServiceProcessFunctions::process_modify_table(&self.handler, incoming_sequence_number, i_prot, o_prot)
  }
  fn process_create_namespace(&self, incoming_sequence_number: i32, i_prot: &mut dyn TInputProtocol, o_prot: &mut dyn TOutputProtocol) -> thrift::Result<()> {
    TTHBaseServiceProcessFunctions::process_create_namespace(&self.handler, incoming_sequence_number, i_prot, o_prot)
  }
  fn process_modify_namespace(&self, incoming_sequence_number: i32, i_prot: &mut dyn TInputProtocol, o_prot: &mut dyn TOutputProtocol) -> thrift::Result<()> {
    TTHBaseServiceProcessFunctions::process_modify_namespace(&self.handler, incoming_sequence_number, i_prot, o_prot)
  }
  fn process_delete_namespace(&self, incoming_sequence_number: i32, i_prot: &mut dyn TInputProtocol, o_prot: &mut dyn TOutputProtocol) -> thrift::Result<()> {
    TTHBaseServiceProcessFunctions::process_delete_namespace(&self.handler, incoming_sequence_number, i_prot, o_prot)
  }
  fn process_get_namespace_descriptor(&self, incoming_sequence_number: i32, i_prot: &mut dyn TInputProtocol, o_prot: &mut dyn TOutputProtocol) -> thrift::Result<()> {
    TTHBaseServiceProcessFunctions::process_get_namespace_descriptor(&self.handler, incoming_sequence_number, i_prot, o_prot)
  }
  fn process_list_namespace_descriptors(&self, incoming_sequence_number: i32, i_prot: &mut dyn TInputProtocol, o_prot: &mut dyn TOutputProtocol) -> thrift::Result<()> {
    TTHBaseServiceProcessFunctions::process_list_namespace_descriptors(&self.handler, incoming_sequence_number, i_prot, o_prot)
  }
  fn process_list_namespaces(&self, incoming_sequence_number: i32, i_prot: &mut dyn TInputProtocol, o_prot: &mut dyn TOutputProtocol) -> thrift::Result<()> {
    TTHBaseServiceProcessFunctions::process_list_namespaces(&self.handler, incoming_sequence_number, i_prot, o_prot)
  }
  fn process_get_thrift_server_type(&self, incoming_sequence_number: i32, i_prot: &mut dyn TInputProtocol, o_prot: &mut dyn TOutputProtocol) -> thrift::Result<()> {
    TTHBaseServiceProcessFunctions::process_get_thrift_server_type(&self.handler, incoming_sequence_number, i_prot, o_prot)
  }
  fn process_get_cluster_id(&self, incoming_sequence_number: i32, i_prot: &mut dyn TInputProtocol, o_prot: &mut dyn TOutputProtocol) -> thrift::Result<()> {
    TTHBaseServiceProcessFunctions::process_get_cluster_id(&self.handler, incoming_sequence_number, i_prot, o_prot)
  }
  fn process_get_slow_log_responses(&self, incoming_sequence_number: i32, i_prot: &mut dyn TInputProtocol, o_prot: &mut dyn TOutputProtocol) -> thrift::Result<()> {
    TTHBaseServiceProcessFunctions::process_get_slow_log_responses(&self.handler, incoming_sequence_number, i_prot, o_prot)
  }
  fn process_clear_slow_log_responses(&self, incoming_sequence_number: i32, i_prot: &mut dyn TInputProtocol, o_prot: &mut dyn TOutputProtocol) -> thrift::Result<()> {
    TTHBaseServiceProcessFunctions::process_clear_slow_log_responses(&self.handler, incoming_sequence_number, i_prot, o_prot)
  }
  fn process_grant(&self, incoming_sequence_number: i32, i_prot: &mut dyn TInputProtocol, o_prot: &mut dyn TOutputProtocol) -> thrift::Result<()> {
    TTHBaseServiceProcessFunctions::process_grant(&self.handler, incoming_sequence_number, i_prot, o_prot)
  }
  fn process_revoke(&self, incoming_sequence_number: i32, i_prot: &mut dyn TInputProtocol, o_prot: &mut dyn TOutputProtocol) -> thrift::Result<()> {
    TTHBaseServiceProcessFunctions::process_revoke(&self.handler, incoming_sequence_number, i_prot, o_prot)
  }
}

pub struct TTHBaseServiceProcessFunctions;

impl TTHBaseServiceProcessFunctions {
  pub fn process_exists<H: THBaseServiceSyncHandler>(handler: &H, incoming_sequence_number: i32, i_prot: &mut dyn TInputProtocol, o_prot: &mut dyn TOutputProtocol) -> thrift::Result<()> {
    let args = THBaseServiceExistsArgs::read_from_in_protocol(i_prot)?;
    match handler.handle_exists(args.table, args.tget) {
      Ok(handler_return) => {
        let message_ident = TMessageIdentifier::new("exists", TMessageType::Reply, incoming_sequence_number);
        o_prot.write_message_begin(&message_ident)?;
        let ret = THBaseServiceExistsResult { result_value: Some(handler_return), io: None };
        ret.write_to_out_protocol(o_prot)?;
        o_prot.write_message_end()?;
        o_prot.flush()
      },
      Err(e) => {
        match e {
          thrift::Error::User(usr_err) => {
            if usr_err.downcast_ref::<TIOError>().is_some() {
              let err = usr_err.downcast::<TIOError>().expect("downcast already checked");
              let ret_err = THBaseServiceExistsResult{ result_value: None, io: Some(*err) };
              let message_ident = TMessageIdentifier::new("exists", TMessageType::Reply, incoming_sequence_number);
              o_prot.write_message_begin(&message_ident)?;
              ret_err.write_to_out_protocol(o_prot)?;
              o_prot.write_message_end()?;
              o_prot.flush()
            } else {
              let ret_err = {
                ApplicationError::new(
                  ApplicationErrorKind::Unknown,
                  usr_err.to_string()
                )
              };
              let message_ident = TMessageIdentifier::new("exists", TMessageType::Exception, incoming_sequence_number);
              o_prot.write_message_begin(&message_ident)?;
              thrift::Error::write_application_error_to_out_protocol(&ret_err, o_prot)?;
              o_prot.write_message_end()?;
              o_prot.flush()
            }
          },
          thrift::Error::Application(app_err) => {
            let message_ident = TMessageIdentifier::new("exists", TMessageType::Exception, incoming_sequence_number);
            o_prot.write_message_begin(&message_ident)?;
            thrift::Error::write_application_error_to_out_protocol(&app_err, o_prot)?;
            o_prot.write_message_end()?;
            o_prot.flush()
          },
          _ => {
            let ret_err = {
              ApplicationError::new(
                ApplicationErrorKind::Unknown,
                e.to_string()
              )
            };
            let message_ident = TMessageIdentifier::new("exists", TMessageType::Exception, incoming_sequence_number);
            o_prot.write_message_begin(&message_ident)?;
            thrift::Error::write_application_error_to_out_protocol(&ret_err, o_prot)?;
            o_prot.write_message_end()?;
            o_prot.flush()
          },
        }
      },
    }
  }
  pub fn process_exists_all<H: THBaseServiceSyncHandler>(handler: &H, incoming_sequence_number: i32, i_prot: &mut dyn TInputProtocol, o_prot: &mut dyn TOutputProtocol) -> thrift::Result<()> {
    let args = THBaseServiceExistsAllArgs::read_from_in_protocol(i_prot)?;
    match handler.handle_exists_all(args.table, args.tgets) {
      Ok(handler_return) => {
        let message_ident = TMessageIdentifier::new("existsAll", TMessageType::Reply, incoming_sequence_number);
        o_prot.write_message_begin(&message_ident)?;
        let ret = THBaseServiceExistsAllResult { result_value: Some(handler_return), io: None };
        ret.write_to_out_protocol(o_prot)?;
        o_prot.write_message_end()?;
        o_prot.flush()
      },
      Err(e) => {
        match e {
          thrift::Error::User(usr_err) => {
            if usr_err.downcast_ref::<TIOError>().is_some() {
              let err = usr_err.downcast::<TIOError>().expect("downcast already checked");
              let ret_err = THBaseServiceExistsAllResult{ result_value: None, io: Some(*err) };
              let message_ident = TMessageIdentifier::new("existsAll", TMessageType::Reply, incoming_sequence_number);
              o_prot.write_message_begin(&message_ident)?;
              ret_err.write_to_out_protocol(o_prot)?;
              o_prot.write_message_end()?;
              o_prot.flush()
            } else {
              let ret_err = {
                ApplicationError::new(
                  ApplicationErrorKind::Unknown,
                  usr_err.to_string()
                )
              };
              let message_ident = TMessageIdentifier::new("existsAll", TMessageType::Exception, incoming_sequence_number);
              o_prot.write_message_begin(&message_ident)?;
              thrift::Error::write_application_error_to_out_protocol(&ret_err, o_prot)?;
              o_prot.write_message_end()?;
              o_prot.flush()
            }
          },
          thrift::Error::Application(app_err) => {
            let message_ident = TMessageIdentifier::new("existsAll", TMessageType::Exception, incoming_sequence_number);
            o_prot.write_message_begin(&message_ident)?;
            thrift::Error::write_application_error_to_out_protocol(&app_err, o_prot)?;
            o_prot.write_message_end()?;
            o_prot.flush()
          },
          _ => {
            let ret_err = {
              ApplicationError::new(
                ApplicationErrorKind::Unknown,
                e.to_string()
              )
            };
            let message_ident = TMessageIdentifier::new("existsAll", TMessageType::Exception, incoming_sequence_number);
            o_prot.write_message_begin(&message_ident)?;
            thrift::Error::write_application_error_to_out_protocol(&ret_err, o_prot)?;
            o_prot.write_message_end()?;
            o_prot.flush()
          },
        }
      },
    }
  }
  pub fn process_get<H: THBaseServiceSyncHandler>(handler: &H, incoming_sequence_number: i32, i_prot: &mut dyn TInputProtocol, o_prot: &mut dyn TOutputProtocol) -> thrift::Result<()> {
    let args = THBaseServiceGetArgs::read_from_in_protocol(i_prot)?;
    match handler.handle_get(args.table, args.tget) {
      Ok(handler_return) => {
        let message_ident = TMessageIdentifier::new("get", TMessageType::Reply, incoming_sequence_number);
        o_prot.write_message_begin(&message_ident)?;
        let ret = THBaseServiceGetResult { result_value: Some(handler_return), io: None };
        ret.write_to_out_protocol(o_prot)?;
        o_prot.write_message_end()?;
        o_prot.flush()
      },
      Err(e) => {
        match e {
          thrift::Error::User(usr_err) => {
            if usr_err.downcast_ref::<TIOError>().is_some() {
              let err = usr_err.downcast::<TIOError>().expect("downcast already checked");
              let ret_err = THBaseServiceGetResult{ result_value: None, io: Some(*err) };
              let message_ident = TMessageIdentifier::new("get", TMessageType::Reply, incoming_sequence_number);
              o_prot.write_message_begin(&message_ident)?;
              ret_err.write_to_out_protocol(o_prot)?;
              o_prot.write_message_end()?;
              o_prot.flush()
            } else {
              let ret_err = {
                ApplicationError::new(
                  ApplicationErrorKind::Unknown,
                  usr_err.to_string()
                )
              };
              let message_ident = TMessageIdentifier::new("get", TMessageType::Exception, incoming_sequence_number);
              o_prot.write_message_begin(&message_ident)?;
              thrift::Error::write_application_error_to_out_protocol(&ret_err, o_prot)?;
              o_prot.write_message_end()?;
              o_prot.flush()
            }
          },
          thrift::Error::Application(app_err) => {
            let message_ident = TMessageIdentifier::new("get", TMessageType::Exception, incoming_sequence_number);
            o_prot.write_message_begin(&message_ident)?;
            thrift::Error::write_application_error_to_out_protocol(&app_err, o_prot)?;
            o_prot.write_message_end()?;
            o_prot.flush()
          },
          _ => {
            let ret_err = {
              ApplicationError::new(
                ApplicationErrorKind::Unknown,
                e.to_string()
              )
            };
            let message_ident = TMessageIdentifier::new("get", TMessageType::Exception, incoming_sequence_number);
            o_prot.write_message_begin(&message_ident)?;
            thrift::Error::write_application_error_to_out_protocol(&ret_err, o_prot)?;
            o_prot.write_message_end()?;
            o_prot.flush()
          },
        }
      },
    }
  }
  pub fn process_get_multiple<H: THBaseServiceSyncHandler>(handler: &H, incoming_sequence_number: i32, i_prot: &mut dyn TInputProtocol, o_prot: &mut dyn TOutputProtocol) -> thrift::Result<()> {
    let args = THBaseServiceGetMultipleArgs::read_from_in_protocol(i_prot)?;
    match handler.handle_get_multiple(args.table, args.tgets) {
      Ok(handler_return) => {
        let message_ident = TMessageIdentifier::new("getMultiple", TMessageType::Reply, incoming_sequence_number);
        o_prot.write_message_begin(&message_ident)?;
        let ret = THBaseServiceGetMultipleResult { result_value: Some(handler_return), io: None };
        ret.write_to_out_protocol(o_prot)?;
        o_prot.write_message_end()?;
        o_prot.flush()
      },
      Err(e) => {
        match e {
          thrift::Error::User(usr_err) => {
            if usr_err.downcast_ref::<TIOError>().is_some() {
              let err = usr_err.downcast::<TIOError>().expect("downcast already checked");
              let ret_err = THBaseServiceGetMultipleResult{ result_value: None, io: Some(*err) };
              let message_ident = TMessageIdentifier::new("getMultiple", TMessageType::Reply, incoming_sequence_number);
              o_prot.write_message_begin(&message_ident)?;
              ret_err.write_to_out_protocol(o_prot)?;
              o_prot.write_message_end()?;
              o_prot.flush()
            } else {
              let ret_err = {
                ApplicationError::new(
                  ApplicationErrorKind::Unknown,
                  usr_err.to_string()
                )
              };
              let message_ident = TMessageIdentifier::new("getMultiple", TMessageType::Exception, incoming_sequence_number);
              o_prot.write_message_begin(&message_ident)?;
              thrift::Error::write_application_error_to_out_protocol(&ret_err, o_prot)?;
              o_prot.write_message_end()?;
              o_prot.flush()
            }
          },
          thrift::Error::Application(app_err) => {
            let message_ident = TMessageIdentifier::new("getMultiple", TMessageType::Exception, incoming_sequence_number);
            o_prot.write_message_begin(&message_ident)?;
            thrift::Error::write_application_error_to_out_protocol(&app_err, o_prot)?;
            o_prot.write_message_end()?;
            o_prot.flush()
          },
          _ => {
            let ret_err = {
              ApplicationError::new(
                ApplicationErrorKind::Unknown,
                e.to_string()
              )
            };
            let message_ident = TMessageIdentifier::new("getMultiple", TMessageType::Exception, incoming_sequence_number);
            o_prot.write_message_begin(&message_ident)?;
            thrift::Error::write_application_error_to_out_protocol(&ret_err, o_prot)?;
            o_prot.write_message_end()?;
            o_prot.flush()
          },
        }
      },
    }
  }
  pub fn process_put<H: THBaseServiceSyncHandler>(handler: &H, incoming_sequence_number: i32, i_prot: &mut dyn TInputProtocol, o_prot: &mut dyn TOutputProtocol) -> thrift::Result<()> {
    let args = THBaseServicePutArgs::read_from_in_protocol(i_prot)?;
    match handler.handle_put(args.table, args.tput) {
      Ok(_) => {
        let message_ident = TMessageIdentifier::new("put", TMessageType::Reply, incoming_sequence_number);
        o_prot.write_message_begin(&message_ident)?;
        let ret = THBaseServicePutResult { io: None };
        ret.write_to_out_protocol(o_prot)?;
        o_prot.write_message_end()?;
        o_prot.flush()
      },
      Err(e) => {
        match e {
          thrift::Error::User(usr_err) => {
            if usr_err.downcast_ref::<TIOError>().is_some() {
              let err = usr_err.downcast::<TIOError>().expect("downcast already checked");
              let ret_err = THBaseServicePutResult{ io: Some(*err) };
              let message_ident = TMessageIdentifier::new("put", TMessageType::Reply, incoming_sequence_number);
              o_prot.write_message_begin(&message_ident)?;
              ret_err.write_to_out_protocol(o_prot)?;
              o_prot.write_message_end()?;
              o_prot.flush()
            } else {
              let ret_err = {
                ApplicationError::new(
                  ApplicationErrorKind::Unknown,
                  usr_err.to_string()
                )
              };
              let message_ident = TMessageIdentifier::new("put", TMessageType::Exception, incoming_sequence_number);
              o_prot.write_message_begin(&message_ident)?;
              thrift::Error::write_application_error_to_out_protocol(&ret_err, o_prot)?;
              o_prot.write_message_end()?;
              o_prot.flush()
            }
          },
          thrift::Error::Application(app_err) => {
            let message_ident = TMessageIdentifier::new("put", TMessageType::Exception, incoming_sequence_number);
            o_prot.write_message_begin(&message_ident)?;
            thrift::Error::write_application_error_to_out_protocol(&app_err, o_prot)?;
            o_prot.write_message_end()?;
            o_prot.flush()
          },
          _ => {
            let ret_err = {
              ApplicationError::new(
                ApplicationErrorKind::Unknown,
                e.to_string()
              )
            };
            let message_ident = TMessageIdentifier::new("put", TMessageType::Exception, incoming_sequence_number);
            o_prot.write_message_begin(&message_ident)?;
            thrift::Error::write_application_error_to_out_protocol(&ret_err, o_prot)?;
            o_prot.write_message_end()?;
            o_prot.flush()
          },
        }
      },
    }
  }
  pub fn process_check_and_put<H: THBaseServiceSyncHandler>(handler: &H, incoming_sequence_number: i32, i_prot: &mut dyn TInputProtocol, o_prot: &mut dyn TOutputProtocol) -> thrift::Result<()> {
    let args = THBaseServiceCheckAndPutArgs::read_from_in_protocol(i_prot)?;
    match handler.handle_check_and_put(args.table, args.row, args.family, args.qualifier, args.value, args.tput) {
      Ok(handler_return) => {
        let message_ident = TMessageIdentifier::new("checkAndPut", TMessageType::Reply, incoming_sequence_number);
        o_prot.write_message_begin(&message_ident)?;
        let ret = THBaseServiceCheckAndPutResult { result_value: Some(handler_return), io: None };
        ret.write_to_out_protocol(o_prot)?;
        o_prot.write_message_end()?;
        o_prot.flush()
      },
      Err(e) => {
        match e {
          thrift::Error::User(usr_err) => {
            if usr_err.downcast_ref::<TIOError>().is_some() {
              let err = usr_err.downcast::<TIOError>().expect("downcast already checked");
              let ret_err = THBaseServiceCheckAndPutResult{ result_value: None, io: Some(*err) };
              let message_ident = TMessageIdentifier::new("checkAndPut", TMessageType::Reply, incoming_sequence_number);
              o_prot.write_message_begin(&message_ident)?;
              ret_err.write_to_out_protocol(o_prot)?;
              o_prot.write_message_end()?;
              o_prot.flush()
            } else {
              let ret_err = {
                ApplicationError::new(
                  ApplicationErrorKind::Unknown,
                  usr_err.to_string()
                )
              };
              let message_ident = TMessageIdentifier::new("checkAndPut", TMessageType::Exception, incoming_sequence_number);
              o_prot.write_message_begin(&message_ident)?;
              thrift::Error::write_application_error_to_out_protocol(&ret_err, o_prot)?;
              o_prot.write_message_end()?;
              o_prot.flush()
            }
          },
          thrift::Error::Application(app_err) => {
            let message_ident = TMessageIdentifier::new("checkAndPut", TMessageType::Exception, incoming_sequence_number);
            o_prot.write_message_begin(&message_ident)?;
            thrift::Error::write_application_error_to_out_protocol(&app_err, o_prot)?;
            o_prot.write_message_end()?;
            o_prot.flush()
          },
          _ => {
            let ret_err = {
              ApplicationError::new(
                ApplicationErrorKind::Unknown,
                e.to_string()
              )
            };
            let message_ident = TMessageIdentifier::new("checkAndPut", TMessageType::Exception, incoming_sequence_number);
            o_prot.write_message_begin(&message_ident)?;
            thrift::Error::write_application_error_to_out_protocol(&ret_err, o_prot)?;
            o_prot.write_message_end()?;
            o_prot.flush()
          },
        }
      },
    }
  }
  pub fn process_put_multiple<H: THBaseServiceSyncHandler>(handler: &H, incoming_sequence_number: i32, i_prot: &mut dyn TInputProtocol, o_prot: &mut dyn TOutputProtocol) -> thrift::Result<()> {
    let args = THBaseServicePutMultipleArgs::read_from_in_protocol(i_prot)?;
    match handler.handle_put_multiple(args.table, args.tputs) {
      Ok(_) => {
        let message_ident = TMessageIdentifier::new("putMultiple", TMessageType::Reply, incoming_sequence_number);
        o_prot.write_message_begin(&message_ident)?;
        let ret = THBaseServicePutMultipleResult { io: None };
        ret.write_to_out_protocol(o_prot)?;
        o_prot.write_message_end()?;
        o_prot.flush()
      },
      Err(e) => {
        match e {
          thrift::Error::User(usr_err) => {
            if usr_err.downcast_ref::<TIOError>().is_some() {
              let err = usr_err.downcast::<TIOError>().expect("downcast already checked");
              let ret_err = THBaseServicePutMultipleResult{ io: Some(*err) };
              let message_ident = TMessageIdentifier::new("putMultiple", TMessageType::Reply, incoming_sequence_number);
              o_prot.write_message_begin(&message_ident)?;
              ret_err.write_to_out_protocol(o_prot)?;
              o_prot.write_message_end()?;
              o_prot.flush()
            } else {
              let ret_err = {
                ApplicationError::new(
                  ApplicationErrorKind::Unknown,
                  usr_err.to_string()
                )
              };
              let message_ident = TMessageIdentifier::new("putMultiple", TMessageType::Exception, incoming_sequence_number);
              o_prot.write_message_begin(&message_ident)?;
              thrift::Error::write_application_error_to_out_protocol(&ret_err, o_prot)?;
              o_prot.write_message_end()?;
              o_prot.flush()
            }
          },
          thrift::Error::Application(app_err) => {
            let message_ident = TMessageIdentifier::new("putMultiple", TMessageType::Exception, incoming_sequence_number);
            o_prot.write_message_begin(&message_ident)?;
            thrift::Error::write_application_error_to_out_protocol(&app_err, o_prot)?;
            o_prot.write_message_end()?;
            o_prot.flush()
          },
          _ => {
            let ret_err = {
              ApplicationError::new(
                ApplicationErrorKind::Unknown,
                e.to_string()
              )
            };
            let message_ident = TMessageIdentifier::new("putMultiple", TMessageType::Exception, incoming_sequence_number);
            o_prot.write_message_begin(&message_ident)?;
            thrift::Error::write_application_error_to_out_protocol(&ret_err, o_prot)?;
            o_prot.write_message_end()?;
            o_prot.flush()
          },
        }
      },
    }
  }
  pub fn process_delete_single<H: THBaseServiceSyncHandler>(handler: &H, incoming_sequence_number: i32, i_prot: &mut dyn TInputProtocol, o_prot: &mut dyn TOutputProtocol) -> thrift::Result<()> {
    let args = THBaseServiceDeleteSingleArgs::read_from_in_protocol(i_prot)?;
    match handler.handle_delete_single(args.table, args.tdelete) {
      Ok(_) => {
        let message_ident = TMessageIdentifier::new("deleteSingle", TMessageType::Reply, incoming_sequence_number);
        o_prot.write_message_begin(&message_ident)?;
        let ret = THBaseServiceDeleteSingleResult { io: None };
        ret.write_to_out_protocol(o_prot)?;
        o_prot.write_message_end()?;
        o_prot.flush()
      },
      Err(e) => {
        match e {
          thrift::Error::User(usr_err) => {
            if usr_err.downcast_ref::<TIOError>().is_some() {
              let err = usr_err.downcast::<TIOError>().expect("downcast already checked");
              let ret_err = THBaseServiceDeleteSingleResult{ io: Some(*err) };
              let message_ident = TMessageIdentifier::new("deleteSingle", TMessageType::Reply, incoming_sequence_number);
              o_prot.write_message_begin(&message_ident)?;
              ret_err.write_to_out_protocol(o_prot)?;
              o_prot.write_message_end()?;
              o_prot.flush()
            } else {
              let ret_err = {
                ApplicationError::new(
                  ApplicationErrorKind::Unknown,
                  usr_err.to_string()
                )
              };
              let message_ident = TMessageIdentifier::new("deleteSingle", TMessageType::Exception, incoming_sequence_number);
              o_prot.write_message_begin(&message_ident)?;
              thrift::Error::write_application_error_to_out_protocol(&ret_err, o_prot)?;
              o_prot.write_message_end()?;
              o_prot.flush()
            }
          },
          thrift::Error::Application(app_err) => {
            let message_ident = TMessageIdentifier::new("deleteSingle", TMessageType::Exception, incoming_sequence_number);
            o_prot.write_message_begin(&message_ident)?;
            thrift::Error::write_application_error_to_out_protocol(&app_err, o_prot)?;
            o_prot.write_message_end()?;
            o_prot.flush()
          },
          _ => {
            let ret_err = {
              ApplicationError::new(
                ApplicationErrorKind::Unknown,
                e.to_string()
              )
            };
            let message_ident = TMessageIdentifier::new("deleteSingle", TMessageType::Exception, incoming_sequence_number);
            o_prot.write_message_begin(&message_ident)?;
            thrift::Error::write_application_error_to_out_protocol(&ret_err, o_prot)?;
            o_prot.write_message_end()?;
            o_prot.flush()
          },
        }
      },
    }
  }
  pub fn process_delete_multiple<H: THBaseServiceSyncHandler>(handler: &H, incoming_sequence_number: i32, i_prot: &mut dyn TInputProtocol, o_prot: &mut dyn TOutputProtocol) -> thrift::Result<()> {
    let args = THBaseServiceDeleteMultipleArgs::read_from_in_protocol(i_prot)?;
    match handler.handle_delete_multiple(args.table, args.tdeletes) {
      Ok(handler_return) => {
        let message_ident = TMessageIdentifier::new("deleteMultiple", TMessageType::Reply, incoming_sequence_number);
        o_prot.write_message_begin(&message_ident)?;
        let ret = THBaseServiceDeleteMultipleResult { result_value: Some(handler_return), io: None };
        ret.write_to_out_protocol(o_prot)?;
        o_prot.write_message_end()?;
        o_prot.flush()
      },
      Err(e) => {
        match e {
          thrift::Error::User(usr_err) => {
            if usr_err.downcast_ref::<TIOError>().is_some() {
              let err = usr_err.downcast::<TIOError>().expect("downcast already checked");
              let ret_err = THBaseServiceDeleteMultipleResult{ result_value: None, io: Some(*err) };
              let message_ident = TMessageIdentifier::new("deleteMultiple", TMessageType::Reply, incoming_sequence_number);
              o_prot.write_message_begin(&message_ident)?;
              ret_err.write_to_out_protocol(o_prot)?;
              o_prot.write_message_end()?;
              o_prot.flush()
            } else {
              let ret_err = {
                ApplicationError::new(
                  ApplicationErrorKind::Unknown,
                  usr_err.to_string()
                )
              };
              let message_ident = TMessageIdentifier::new("deleteMultiple", TMessageType::Exception, incoming_sequence_number);
              o_prot.write_message_begin(&message_ident)?;
              thrift::Error::write_application_error_to_out_protocol(&ret_err, o_prot)?;
              o_prot.write_message_end()?;
              o_prot.flush()
            }
          },
          thrift::Error::Application(app_err) => {
            let message_ident = TMessageIdentifier::new("deleteMultiple", TMessageType::Exception, incoming_sequence_number);
            o_prot.write_message_begin(&message_ident)?;
            thrift::Error::write_application_error_to_out_protocol(&app_err, o_prot)?;
            o_prot.write_message_end()?;
            o_prot.flush()
          },
          _ => {
            let ret_err = {
              ApplicationError::new(
                ApplicationErrorKind::Unknown,
                e.to_string()
              )
            };
            let message_ident = TMessageIdentifier::new("deleteMultiple", TMessageType::Exception, incoming_sequence_number);
            o_prot.write_message_begin(&message_ident)?;
            thrift::Error::write_application_error_to_out_protocol(&ret_err, o_prot)?;
            o_prot.write_message_end()?;
            o_prot.flush()
          },
        }
      },
    }
  }
  pub fn process_check_and_delete<H: THBaseServiceSyncHandler>(handler: &H, incoming_sequence_number: i32, i_prot: &mut dyn TInputProtocol, o_prot: &mut dyn TOutputProtocol) -> thrift::Result<()> {
    let args = THBaseServiceCheckAndDeleteArgs::read_from_in_protocol(i_prot)?;
    match handler.handle_check_and_delete(args.table, args.row, args.family, args.qualifier, args.value, args.tdelete) {
      Ok(handler_return) => {
        let message_ident = TMessageIdentifier::new("checkAndDelete", TMessageType::Reply, incoming_sequence_number);
        o_prot.write_message_begin(&message_ident)?;
        let ret = THBaseServiceCheckAndDeleteResult { result_value: Some(handler_return), io: None };
        ret.write_to_out_protocol(o_prot)?;
        o_prot.write_message_end()?;
        o_prot.flush()
      },
      Err(e) => {
        match e {
          thrift::Error::User(usr_err) => {
            if usr_err.downcast_ref::<TIOError>().is_some() {
              let err = usr_err.downcast::<TIOError>().expect("downcast already checked");
              let ret_err = THBaseServiceCheckAndDeleteResult{ result_value: None, io: Some(*err) };
              let message_ident = TMessageIdentifier::new("checkAndDelete", TMessageType::Reply, incoming_sequence_number);
              o_prot.write_message_begin(&message_ident)?;
              ret_err.write_to_out_protocol(o_prot)?;
              o_prot.write_message_end()?;
              o_prot.flush()
            } else {
              let ret_err = {
                ApplicationError::new(
                  ApplicationErrorKind::Unknown,
                  usr_err.to_string()
                )
              };
              let message_ident = TMessageIdentifier::new("checkAndDelete", TMessageType::Exception, incoming_sequence_number);
              o_prot.write_message_begin(&message_ident)?;
              thrift::Error::write_application_error_to_out_protocol(&ret_err, o_prot)?;
              o_prot.write_message_end()?;
              o_prot.flush()
            }
          },
          thrift::Error::Application(app_err) => {
            let message_ident = TMessageIdentifier::new("checkAndDelete", TMessageType::Exception, incoming_sequence_number);
            o_prot.write_message_begin(&message_ident)?;
            thrift::Error::write_application_error_to_out_protocol(&app_err, o_prot)?;
            o_prot.write_message_end()?;
            o_prot.flush()
          },
          _ => {
            let ret_err = {
              ApplicationError::new(
                ApplicationErrorKind::Unknown,
                e.to_string()
              )
            };
            let message_ident = TMessageIdentifier::new("checkAndDelete", TMessageType::Exception, incoming_sequence_number);
            o_prot.write_message_begin(&message_ident)?;
            thrift::Error::write_application_error_to_out_protocol(&ret_err, o_prot)?;
            o_prot.write_message_end()?;
            o_prot.flush()
          },
        }
      },
    }
  }
  pub fn process_increment<H: THBaseServiceSyncHandler>(handler: &H, incoming_sequence_number: i32, i_prot: &mut dyn TInputProtocol, o_prot: &mut dyn TOutputProtocol) -> thrift::Result<()> {
    let args = THBaseServiceIncrementArgs::read_from_in_protocol(i_prot)?;
    match handler.handle_increment(args.table, args.tincrement) {
      Ok(handler_return) => {
        let message_ident = TMessageIdentifier::new("increment", TMessageType::Reply, incoming_sequence_number);
        o_prot.write_message_begin(&message_ident)?;
        let ret = THBaseServiceIncrementResult { result_value: Some(handler_return), io: None };
        ret.write_to_out_protocol(o_prot)?;
        o_prot.write_message_end()?;
        o_prot.flush()
      },
      Err(e) => {
        match e {
          thrift::Error::User(usr_err) => {
            if usr_err.downcast_ref::<TIOError>().is_some() {
              let err = usr_err.downcast::<TIOError>().expect("downcast already checked");
              let ret_err = THBaseServiceIncrementResult{ result_value: None, io: Some(*err) };
              let message_ident = TMessageIdentifier::new("increment", TMessageType::Reply, incoming_sequence_number);
              o_prot.write_message_begin(&message_ident)?;
              ret_err.write_to_out_protocol(o_prot)?;
              o_prot.write_message_end()?;
              o_prot.flush()
            } else {
              let ret_err = {
                ApplicationError::new(
                  ApplicationErrorKind::Unknown,
                  usr_err.to_string()
                )
              };
              let message_ident = TMessageIdentifier::new("increment", TMessageType::Exception, incoming_sequence_number);
              o_prot.write_message_begin(&message_ident)?;
              thrift::Error::write_application_error_to_out_protocol(&ret_err, o_prot)?;
              o_prot.write_message_end()?;
              o_prot.flush()
            }
          },
          thrift::Error::Application(app_err) => {
            let message_ident = TMessageIdentifier::new("increment", TMessageType::Exception, incoming_sequence_number);
            o_prot.write_message_begin(&message_ident)?;
            thrift::Error::write_application_error_to_out_protocol(&app_err, o_prot)?;
            o_prot.write_message_end()?;
            o_prot.flush()
          },
          _ => {
            let ret_err = {
              ApplicationError::new(
                ApplicationErrorKind::Unknown,
                e.to_string()
              )
            };
            let message_ident = TMessageIdentifier::new("increment", TMessageType::Exception, incoming_sequence_number);
            o_prot.write_message_begin(&message_ident)?;
            thrift::Error::write_application_error_to_out_protocol(&ret_err, o_prot)?;
            o_prot.write_message_end()?;
            o_prot.flush()
          },
        }
      },
    }
  }
  pub fn process_append<H: THBaseServiceSyncHandler>(handler: &H, incoming_sequence_number: i32, i_prot: &mut dyn TInputProtocol, o_prot: &mut dyn TOutputProtocol) -> thrift::Result<()> {
    let args = THBaseServiceAppendArgs::read_from_in_protocol(i_prot)?;
    match handler.handle_append(args.table, args.tappend) {
      Ok(handler_return) => {
        let message_ident = TMessageIdentifier::new("append", TMessageType::Reply, incoming_sequence_number);
        o_prot.write_message_begin(&message_ident)?;
        let ret = THBaseServiceAppendResult { result_value: Some(handler_return), io: None };
        ret.write_to_out_protocol(o_prot)?;
        o_prot.write_message_end()?;
        o_prot.flush()
      },
      Err(e) => {
        match e {
          thrift::Error::User(usr_err) => {
            if usr_err.downcast_ref::<TIOError>().is_some() {
              let err = usr_err.downcast::<TIOError>().expect("downcast already checked");
              let ret_err = THBaseServiceAppendResult{ result_value: None, io: Some(*err) };
              let message_ident = TMessageIdentifier::new("append", TMessageType::Reply, incoming_sequence_number);
              o_prot.write_message_begin(&message_ident)?;
              ret_err.write_to_out_protocol(o_prot)?;
              o_prot.write_message_end()?;
              o_prot.flush()
            } else {
              let ret_err = {
                ApplicationError::new(
                  ApplicationErrorKind::Unknown,
                  usr_err.to_string()
                )
              };
              let message_ident = TMessageIdentifier::new("append", TMessageType::Exception, incoming_sequence_number);
              o_prot.write_message_begin(&message_ident)?;
              thrift::Error::write_application_error_to_out_protocol(&ret_err, o_prot)?;
              o_prot.write_message_end()?;
              o_prot.flush()
            }
          },
          thrift::Error::Application(app_err) => {
            let message_ident = TMessageIdentifier::new("append", TMessageType::Exception, incoming_sequence_number);
            o_prot.write_message_begin(&message_ident)?;
            thrift::Error::write_application_error_to_out_protocol(&app_err, o_prot)?;
            o_prot.write_message_end()?;
            o_prot.flush()
          },
          _ => {
            let ret_err = {
              ApplicationError::new(
                ApplicationErrorKind::Unknown,
                e.to_string()
              )
            };
            let message_ident = TMessageIdentifier::new("append", TMessageType::Exception, incoming_sequence_number);
            o_prot.write_message_begin(&message_ident)?;
            thrift::Error::write_application_error_to_out_protocol(&ret_err, o_prot)?;
            o_prot.write_message_end()?;
            o_prot.flush()
          },
        }
      },
    }
  }
  pub fn process_open_scanner<H: THBaseServiceSyncHandler>(handler: &H, incoming_sequence_number: i32, i_prot: &mut dyn TInputProtocol, o_prot: &mut dyn TOutputProtocol) -> thrift::Result<()> {
    let args = THBaseServiceOpenScannerArgs::read_from_in_protocol(i_prot)?;
    match handler.handle_open_scanner(args.table, args.tscan) {
      Ok(handler_return) => {
        let message_ident = TMessageIdentifier::new("openScanner", TMessageType::Reply, incoming_sequence_number);
        o_prot.write_message_begin(&message_ident)?;
        let ret = THBaseServiceOpenScannerResult { result_value: Some(handler_return), io: None };
        ret.write_to_out_protocol(o_prot)?;
        o_prot.write_message_end()?;
        o_prot.flush()
      },
      Err(e) => {
        match e {
          thrift::Error::User(usr_err) => {
            if usr_err.downcast_ref::<TIOError>().is_some() {
              let err = usr_err.downcast::<TIOError>().expect("downcast already checked");
              let ret_err = THBaseServiceOpenScannerResult{ result_value: None, io: Some(*err) };
              let message_ident = TMessageIdentifier::new("openScanner", TMessageType::Reply, incoming_sequence_number);
              o_prot.write_message_begin(&message_ident)?;
              ret_err.write_to_out_protocol(o_prot)?;
              o_prot.write_message_end()?;
              o_prot.flush()
            } else {
              let ret_err = {
                ApplicationError::new(
                  ApplicationErrorKind::Unknown,
                  usr_err.to_string()
                )
              };
              let message_ident = TMessageIdentifier::new("openScanner", TMessageType::Exception, incoming_sequence_number);
              o_prot.write_message_begin(&message_ident)?;
              thrift::Error::write_application_error_to_out_protocol(&ret_err, o_prot)?;
              o_prot.write_message_end()?;
              o_prot.flush()
            }
          },
          thrift::Error::Application(app_err) => {
            let message_ident = TMessageIdentifier::new("openScanner", TMessageType::Exception, incoming_sequence_number);
            o_prot.write_message_begin(&message_ident)?;
            thrift::Error::write_application_error_to_out_protocol(&app_err, o_prot)?;
            o_prot.write_message_end()?;
            o_prot.flush()
          },
          _ => {
            let ret_err = {
              ApplicationError::new(
                ApplicationErrorKind::Unknown,
                e.to_string()
              )
            };
            let message_ident = TMessageIdentifier::new("openScanner", TMessageType::Exception, incoming_sequence_number);
            o_prot.write_message_begin(&message_ident)?;
            thrift::Error::write_application_error_to_out_protocol(&ret_err, o_prot)?;
            o_prot.write_message_end()?;
            o_prot.flush()
          },
        }
      },
    }
  }
  pub fn process_get_scanner_rows<H: THBaseServiceSyncHandler>(handler: &H, incoming_sequence_number: i32, i_prot: &mut dyn TInputProtocol, o_prot: &mut dyn TOutputProtocol) -> thrift::Result<()> {
    let args = THBaseServiceGetScannerRowsArgs::read_from_in_protocol(i_prot)?;
    match handler.handle_get_scanner_rows(args.scanner_id, args.num_rows) {
      Ok(handler_return) => {
        let message_ident = TMessageIdentifier::new("getScannerRows", TMessageType::Reply, incoming_sequence_number);
        o_prot.write_message_begin(&message_ident)?;
        let ret = THBaseServiceGetScannerRowsResult { result_value: Some(handler_return), io: None, ia: None };
        ret.write_to_out_protocol(o_prot)?;
        o_prot.write_message_end()?;
        o_prot.flush()
      },
      Err(e) => {
        match e {
          thrift::Error::User(usr_err) => {
            if usr_err.downcast_ref::<TIOError>().is_some() {
              let err = usr_err.downcast::<TIOError>().expect("downcast already checked");
              let ret_err = THBaseServiceGetScannerRowsResult{ result_value: None, io: Some(*err), ia: None };
              let message_ident = TMessageIdentifier::new("getScannerRows", TMessageType::Reply, incoming_sequence_number);
              o_prot.write_message_begin(&message_ident)?;
              ret_err.write_to_out_protocol(o_prot)?;
              o_prot.write_message_end()?;
              o_prot.flush()
            } else if usr_err.downcast_ref::<TIllegalArgument>().is_some() {
              let err = usr_err.downcast::<TIllegalArgument>().expect("downcast already checked");
              let ret_err = THBaseServiceGetScannerRowsResult{ result_value: None, io: None, ia: Some(*err) };
              let message_ident = TMessageIdentifier::new("getScannerRows", TMessageType::Reply, incoming_sequence_number);
              o_prot.write_message_begin(&message_ident)?;
              ret_err.write_to_out_protocol(o_prot)?;
              o_prot.write_message_end()?;
              o_prot.flush()
            } else {
              let ret_err = {
                ApplicationError::new(
                  ApplicationErrorKind::Unknown,
                  usr_err.to_string()
                )
              };
              let message_ident = TMessageIdentifier::new("getScannerRows", TMessageType::Exception, incoming_sequence_number);
              o_prot.write_message_begin(&message_ident)?;
              thrift::Error::write_application_error_to_out_protocol(&ret_err, o_prot)?;
              o_prot.write_message_end()?;
              o_prot.flush()
            }
          },
          thrift::Error::Application(app_err) => {
            let message_ident = TMessageIdentifier::new("getScannerRows", TMessageType::Exception, incoming_sequence_number);
            o_prot.write_message_begin(&message_ident)?;
            thrift::Error::write_application_error_to_out_protocol(&app_err, o_prot)?;
            o_prot.write_message_end()?;
            o_prot.flush()
          },
          _ => {
            let ret_err = {
              ApplicationError::new(
                ApplicationErrorKind::Unknown,
                e.to_string()
              )
            };
            let message_ident = TMessageIdentifier::new("getScannerRows", TMessageType::Exception, incoming_sequence_number);
            o_prot.write_message_begin(&message_ident)?;
            thrift::Error::write_application_error_to_out_protocol(&ret_err, o_prot)?;
            o_prot.write_message_end()?;
            o_prot.flush()
          },
        }
      },
    }
  }
  pub fn process_close_scanner<H: THBaseServiceSyncHandler>(handler: &H, incoming_sequence_number: i32, i_prot: &mut dyn TInputProtocol, o_prot: &mut dyn TOutputProtocol) -> thrift::Result<()> {
    let args = THBaseServiceCloseScannerArgs::read_from_in_protocol(i_prot)?;
    match handler.handle_close_scanner(args.scanner_id) {
      Ok(_) => {
        let message_ident = TMessageIdentifier::new("closeScanner", TMessageType::Reply, incoming_sequence_number);
        o_prot.write_message_begin(&message_ident)?;
        let ret = THBaseServiceCloseScannerResult { io: None, ia: None };
        ret.write_to_out_protocol(o_prot)?;
        o_prot.write_message_end()?;
        o_prot.flush()
      },
      Err(e) => {
        match e {
          thrift::Error::User(usr_err) => {
            if usr_err.downcast_ref::<TIOError>().is_some() {
              let err = usr_err.downcast::<TIOError>().expect("downcast already checked");
              let ret_err = THBaseServiceCloseScannerResult{ io: Some(*err), ia: None };
              let message_ident = TMessageIdentifier::new("closeScanner", TMessageType::Reply, incoming_sequence_number);
              o_prot.write_message_begin(&message_ident)?;
              ret_err.write_to_out_protocol(o_prot)?;
              o_prot.write_message_end()?;
              o_prot.flush()
            } else if usr_err.downcast_ref::<TIllegalArgument>().is_some() {
              let err = usr_err.downcast::<TIllegalArgument>().expect("downcast already checked");
              let ret_err = THBaseServiceCloseScannerResult{ io: None, ia: Some(*err) };
              let message_ident = TMessageIdentifier::new("closeScanner", TMessageType::Reply, incoming_sequence_number);
              o_prot.write_message_begin(&message_ident)?;
              ret_err.write_to_out_protocol(o_prot)?;
              o_prot.write_message_end()?;
              o_prot.flush()
            } else {
              let ret_err = {
                ApplicationError::new(
                  ApplicationErrorKind::Unknown,
                  usr_err.to_string()
                )
              };
              let message_ident = TMessageIdentifier::new("closeScanner", TMessageType::Exception, incoming_sequence_number);
              o_prot.write_message_begin(&message_ident)?;
              thrift::Error::write_application_error_to_out_protocol(&ret_err, o_prot)?;
              o_prot.write_message_end()?;
              o_prot.flush()
            }
          },
          thrift::Error::Application(app_err) => {
            let message_ident = TMessageIdentifier::new("closeScanner", TMessageType::Exception, incoming_sequence_number);
            o_prot.write_message_begin(&message_ident)?;
            thrift::Error::write_application_error_to_out_protocol(&app_err, o_prot)?;
            o_prot.write_message_end()?;
            o_prot.flush()
          },
          _ => {
            let ret_err = {
              ApplicationError::new(
                ApplicationErrorKind::Unknown,
                e.to_string()
              )
            };
            let message_ident = TMessageIdentifier::new("closeScanner", TMessageType::Exception, incoming_sequence_number);
            o_prot.write_message_begin(&message_ident)?;
            thrift::Error::write_application_error_to_out_protocol(&ret_err, o_prot)?;
            o_prot.write_message_end()?;
            o_prot.flush()
          },
        }
      },
    }
  }
  pub fn process_mutate_row<H: THBaseServiceSyncHandler>(handler: &H, incoming_sequence_number: i32, i_prot: &mut dyn TInputProtocol, o_prot: &mut dyn TOutputProtocol) -> thrift::Result<()> {
    let args = THBaseServiceMutateRowArgs::read_from_in_protocol(i_prot)?;
    match handler.handle_mutate_row(args.table, args.trow_mutations) {
      Ok(_) => {
        let message_ident = TMessageIdentifier::new("mutateRow", TMessageType::Reply, incoming_sequence_number);
        o_prot.write_message_begin(&message_ident)?;
        let ret = THBaseServiceMutateRowResult { io: None };
        ret.write_to_out_protocol(o_prot)?;
        o_prot.write_message_end()?;
        o_prot.flush()
      },
      Err(e) => {
        match e {
          thrift::Error::User(usr_err) => {
            if usr_err.downcast_ref::<TIOError>().is_some() {
              let err = usr_err.downcast::<TIOError>().expect("downcast already checked");
              let ret_err = THBaseServiceMutateRowResult{ io: Some(*err) };
              let message_ident = TMessageIdentifier::new("mutateRow", TMessageType::Reply, incoming_sequence_number);
              o_prot.write_message_begin(&message_ident)?;
              ret_err.write_to_out_protocol(o_prot)?;
              o_prot.write_message_end()?;
              o_prot.flush()
            } else {
              let ret_err = {
                ApplicationError::new(
                  ApplicationErrorKind::Unknown,
                  usr_err.to_string()
                )
              };
              let message_ident = TMessageIdentifier::new("mutateRow", TMessageType::Exception, incoming_sequence_number);
              o_prot.write_message_begin(&message_ident)?;
              thrift::Error::write_application_error_to_out_protocol(&ret_err, o_prot)?;
              o_prot.write_message_end()?;
              o_prot.flush()
            }
          },
          thrift::Error::Application(app_err) => {
            let message_ident = TMessageIdentifier::new("mutateRow", TMessageType::Exception, incoming_sequence_number);
            o_prot.write_message_begin(&message_ident)?;
            thrift::Error::write_application_error_to_out_protocol(&app_err, o_prot)?;
            o_prot.write_message_end()?;
            o_prot.flush()
          },
          _ => {
            let ret_err = {
              ApplicationError::new(
                ApplicationErrorKind::Unknown,
                e.to_string()
              )
            };
            let message_ident = TMessageIdentifier::new("mutateRow", TMessageType::Exception, incoming_sequence_number);
            o_prot.write_message_begin(&message_ident)?;
            thrift::Error::write_application_error_to_out_protocol(&ret_err, o_prot)?;
            o_prot.write_message_end()?;
            o_prot.flush()
          },
        }
      },
    }
  }
  pub fn process_get_scanner_results<H: THBaseServiceSyncHandler>(handler: &H, incoming_sequence_number: i32, i_prot: &mut dyn TInputProtocol, o_prot: &mut dyn TOutputProtocol) -> thrift::Result<()> {
    let args = THBaseServiceGetScannerResultsArgs::read_from_in_protocol(i_prot)?;
    match handler.handle_get_scanner_results(args.table, args.tscan, args.num_rows) {
      Ok(handler_return) => {
        let message_ident = TMessageIdentifier::new("getScannerResults", TMessageType::Reply, incoming_sequence_number);
        o_prot.write_message_begin(&message_ident)?;
        let ret = THBaseServiceGetScannerResultsResult { result_value: Some(handler_return), io: None };
        ret.write_to_out_protocol(o_prot)?;
        o_prot.write_message_end()?;
        o_prot.flush()
      },
      Err(e) => {
        match e {
          thrift::Error::User(usr_err) => {
            if usr_err.downcast_ref::<TIOError>().is_some() {
              let err = usr_err.downcast::<TIOError>().expect("downcast already checked");
              let ret_err = THBaseServiceGetScannerResultsResult{ result_value: None, io: Some(*err) };
              let message_ident = TMessageIdentifier::new("getScannerResults", TMessageType::Reply, incoming_sequence_number);
              o_prot.write_message_begin(&message_ident)?;
              ret_err.write_to_out_protocol(o_prot)?;
              o_prot.write_message_end()?;
              o_prot.flush()
            } else {
              let ret_err = {
                ApplicationError::new(
                  ApplicationErrorKind::Unknown,
                  usr_err.to_string()
                )
              };
              let message_ident = TMessageIdentifier::new("getScannerResults", TMessageType::Exception, incoming_sequence_number);
              o_prot.write_message_begin(&message_ident)?;
              thrift::Error::write_application_error_to_out_protocol(&ret_err, o_prot)?;
              o_prot.write_message_end()?;
              o_prot.flush()
            }
          },
          thrift::Error::Application(app_err) => {
            let message_ident = TMessageIdentifier::new("getScannerResults", TMessageType::Exception, incoming_sequence_number);
            o_prot.write_message_begin(&message_ident)?;
            thrift::Error::write_application_error_to_out_protocol(&app_err, o_prot)?;
            o_prot.write_message_end()?;
            o_prot.flush()
          },
          _ => {
            let ret_err = {
              ApplicationError::new(
                ApplicationErrorKind::Unknown,
                e.to_string()
              )
            };
            let message_ident = TMessageIdentifier::new("getScannerResults", TMessageType::Exception, incoming_sequence_number);
            o_prot.write_message_begin(&message_ident)?;
            thrift::Error::write_application_error_to_out_protocol(&ret_err, o_prot)?;
            o_prot.write_message_end()?;
            o_prot.flush()
          },
        }
      },
    }
  }
  pub fn process_get_region_location<H: THBaseServiceSyncHandler>(handler: &H, incoming_sequence_number: i32, i_prot: &mut dyn TInputProtocol, o_prot: &mut dyn TOutputProtocol) -> thrift::Result<()> {
    let args = THBaseServiceGetRegionLocationArgs::read_from_in_protocol(i_prot)?;
    match handler.handle_get_region_location(args.table, args.row, args.reload) {
      Ok(handler_return) => {
        let message_ident = TMessageIdentifier::new("getRegionLocation", TMessageType::Reply, incoming_sequence_number);
        o_prot.write_message_begin(&message_ident)?;
        let ret = THBaseServiceGetRegionLocationResult { result_value: Some(handler_return), io: None };
        ret.write_to_out_protocol(o_prot)?;
        o_prot.write_message_end()?;
        o_prot.flush()
      },
      Err(e) => {
        match e {
          thrift::Error::User(usr_err) => {
            if usr_err.downcast_ref::<TIOError>().is_some() {
              let err = usr_err.downcast::<TIOError>().expect("downcast already checked");
              let ret_err = THBaseServiceGetRegionLocationResult{ result_value: None, io: Some(*err) };
              let message_ident = TMessageIdentifier::new("getRegionLocation", TMessageType::Reply, incoming_sequence_number);
              o_prot.write_message_begin(&message_ident)?;
              ret_err.write_to_out_protocol(o_prot)?;
              o_prot.write_message_end()?;
              o_prot.flush()
            } else {
              let ret_err = {
                ApplicationError::new(
                  ApplicationErrorKind::Unknown,
                  usr_err.to_string()
                )
              };
              let message_ident = TMessageIdentifier::new("getRegionLocation", TMessageType::Exception, incoming_sequence_number);
              o_prot.write_message_begin(&message_ident)?;
              thrift::Error::write_application_error_to_out_protocol(&ret_err, o_prot)?;
              o_prot.write_message_end()?;
              o_prot.flush()
            }
          },
          thrift::Error::Application(app_err) => {
            let message_ident = TMessageIdentifier::new("getRegionLocation", TMessageType::Exception, incoming_sequence_number);
            o_prot.write_message_begin(&message_ident)?;
            thrift::Error::write_application_error_to_out_protocol(&app_err, o_prot)?;
            o_prot.write_message_end()?;
            o_prot.flush()
          },
          _ => {
            let ret_err = {
              ApplicationError::new(
                ApplicationErrorKind::Unknown,
                e.to_string()
              )
            };
            let message_ident = TMessageIdentifier::new("getRegionLocation", TMessageType::Exception, incoming_sequence_number);
            o_prot.write_message_begin(&message_ident)?;
            thrift::Error::write_application_error_to_out_protocol(&ret_err, o_prot)?;
            o_prot.write_message_end()?;
            o_prot.flush()
          },
        }
      },
    }
  }
  pub fn process_get_all_region_locations<H: THBaseServiceSyncHandler>(handler: &H, incoming_sequence_number: i32, i_prot: &mut dyn TInputProtocol, o_prot: &mut dyn TOutputProtocol) -> thrift::Result<()> {
    let args = THBaseServiceGetAllRegionLocationsArgs::read_from_in_protocol(i_prot)?;
    match handler.handle_get_all_region_locations(args.table) {
      Ok(handler_return) => {
        let message_ident = TMessageIdentifier::new("getAllRegionLocations", TMessageType::Reply, incoming_sequence_number);
        o_prot.write_message_begin(&message_ident)?;
        let ret = THBaseServiceGetAllRegionLocationsResult { result_value: Some(handler_return), io: None };
        ret.write_to_out_protocol(o_prot)?;
        o_prot.write_message_end()?;
        o_prot.flush()
      },
      Err(e) => {
        match e {
          thrift::Error::User(usr_err) => {
            if usr_err.downcast_ref::<TIOError>().is_some() {
              let err = usr_err.downcast::<TIOError>().expect("downcast already checked");
              let ret_err = THBaseServiceGetAllRegionLocationsResult{ result_value: None, io: Some(*err) };
              let message_ident = TMessageIdentifier::new("getAllRegionLocations", TMessageType::Reply, incoming_sequence_number);
              o_prot.write_message_begin(&message_ident)?;
              ret_err.write_to_out_protocol(o_prot)?;
              o_prot.write_message_end()?;
              o_prot.flush()
            } else {
              let ret_err = {
                ApplicationError::new(
                  ApplicationErrorKind::Unknown,
                  usr_err.to_string()
                )
              };
              let message_ident = TMessageIdentifier::new("getAllRegionLocations", TMessageType::Exception, incoming_sequence_number);
              o_prot.write_message_begin(&message_ident)?;
              thrift::Error::write_application_error_to_out_protocol(&ret_err, o_prot)?;
              o_prot.write_message_end()?;
              o_prot.flush()
            }
          },
          thrift::Error::Application(app_err) => {
            let message_ident = TMessageIdentifier::new("getAllRegionLocations", TMessageType::Exception, incoming_sequence_number);
            o_prot.write_message_begin(&message_ident)?;
            thrift::Error::write_application_error_to_out_protocol(&app_err, o_prot)?;
            o_prot.write_message_end()?;
            o_prot.flush()
          },
          _ => {
            let ret_err = {
              ApplicationError::new(
                ApplicationErrorKind::Unknown,
                e.to_string()
              )
            };
            let message_ident = TMessageIdentifier::new("getAllRegionLocations", TMessageType::Exception, incoming_sequence_number);
            o_prot.write_message_begin(&message_ident)?;
            thrift::Error::write_application_error_to_out_protocol(&ret_err, o_prot)?;
            o_prot.write_message_end()?;
            o_prot.flush()
          },
        }
      },
    }
  }
  pub fn process_check_and_mutate<H: THBaseServiceSyncHandler>(handler: &H, incoming_sequence_number: i32, i_prot: &mut dyn TInputProtocol, o_prot: &mut dyn TOutputProtocol) -> thrift::Result<()> {
    let args = THBaseServiceCheckAndMutateArgs::read_from_in_protocol(i_prot)?;
    match handler.handle_check_and_mutate(args.table, args.row, args.family, args.qualifier, args.compare_operator, args.value, args.row_mutations) {
      Ok(handler_return) => {
        let message_ident = TMessageIdentifier::new("checkAndMutate", TMessageType::Reply, incoming_sequence_number);
        o_prot.write_message_begin(&message_ident)?;
        let ret = THBaseServiceCheckAndMutateResult { result_value: Some(handler_return), io: None };
        ret.write_to_out_protocol(o_prot)?;
        o_prot.write_message_end()?;
        o_prot.flush()
      },
      Err(e) => {
        match e {
          thrift::Error::User(usr_err) => {
            if usr_err.downcast_ref::<TIOError>().is_some() {
              let err = usr_err.downcast::<TIOError>().expect("downcast already checked");
              let ret_err = THBaseServiceCheckAndMutateResult{ result_value: None, io: Some(*err) };
              let message_ident = TMessageIdentifier::new("checkAndMutate", TMessageType::Reply, incoming_sequence_number);
              o_prot.write_message_begin(&message_ident)?;
              ret_err.write_to_out_protocol(o_prot)?;
              o_prot.write_message_end()?;
              o_prot.flush()
            } else {
              let ret_err = {
                ApplicationError::new(
                  ApplicationErrorKind::Unknown,
                  usr_err.to_string()
                )
              };
              let message_ident = TMessageIdentifier::new("checkAndMutate", TMessageType::Exception, incoming_sequence_number);
              o_prot.write_message_begin(&message_ident)?;
              thrift::Error::write_application_error_to_out_protocol(&ret_err, o_prot)?;
              o_prot.write_message_end()?;
              o_prot.flush()
            }
          },
          thrift::Error::Application(app_err) => {
            let message_ident = TMessageIdentifier::new("checkAndMutate", TMessageType::Exception, incoming_sequence_number);
            o_prot.write_message_begin(&message_ident)?;
            thrift::Error::write_application_error_to_out_protocol(&app_err, o_prot)?;
            o_prot.write_message_end()?;
            o_prot.flush()
          },
          _ => {
            let ret_err = {
              ApplicationError::new(
                ApplicationErrorKind::Unknown,
                e.to_string()
              )
            };
            let message_ident = TMessageIdentifier::new("checkAndMutate", TMessageType::Exception, incoming_sequence_number);
            o_prot.write_message_begin(&message_ident)?;
            thrift::Error::write_application_error_to_out_protocol(&ret_err, o_prot)?;
            o_prot.write_message_end()?;
            o_prot.flush()
          },
        }
      },
    }
  }
  pub fn process_get_table_descriptor<H: THBaseServiceSyncHandler>(handler: &H, incoming_sequence_number: i32, i_prot: &mut dyn TInputProtocol, o_prot: &mut dyn TOutputProtocol) -> thrift::Result<()> {
    let args = THBaseServiceGetTableDescriptorArgs::read_from_in_protocol(i_prot)?;
    match handler.handle_get_table_descriptor(args.table) {
      Ok(handler_return) => {
        let message_ident = TMessageIdentifier::new("getTableDescriptor", TMessageType::Reply, incoming_sequence_number);
        o_prot.write_message_begin(&message_ident)?;
        let ret = THBaseServiceGetTableDescriptorResult { result_value: Some(handler_return), io: None };
        ret.write_to_out_protocol(o_prot)?;
        o_prot.write_message_end()?;
        o_prot.flush()
      },
      Err(e) => {
        match e {
          thrift::Error::User(usr_err) => {
            if usr_err.downcast_ref::<TIOError>().is_some() {
              let err = usr_err.downcast::<TIOError>().expect("downcast already checked");
              let ret_err = THBaseServiceGetTableDescriptorResult{ result_value: None, io: Some(*err) };
              let message_ident = TMessageIdentifier::new("getTableDescriptor", TMessageType::Reply, incoming_sequence_number);
              o_prot.write_message_begin(&message_ident)?;
              ret_err.write_to_out_protocol(o_prot)?;
              o_prot.write_message_end()?;
              o_prot.flush()
            } else {
              let ret_err = {
                ApplicationError::new(
                  ApplicationErrorKind::Unknown,
                  usr_err.to_string()
                )
              };
              let message_ident = TMessageIdentifier::new("getTableDescriptor", TMessageType::Exception, incoming_sequence_number);
              o_prot.write_message_begin(&message_ident)?;
              thrift::Error::write_application_error_to_out_protocol(&ret_err, o_prot)?;
              o_prot.write_message_end()?;
              o_prot.flush()
            }
          },
          thrift::Error::Application(app_err) => {
            let message_ident = TMessageIdentifier::new("getTableDescriptor", TMessageType::Exception, incoming_sequence_number);
            o_prot.write_message_begin(&message_ident)?;
            thrift::Error::write_application_error_to_out_protocol(&app_err, o_prot)?;
            o_prot.write_message_end()?;
            o_prot.flush()
          },
          _ => {
            let ret_err = {
              ApplicationError::new(
                ApplicationErrorKind::Unknown,
                e.to_string()
              )
            };
            let message_ident = TMessageIdentifier::new("getTableDescriptor", TMessageType::Exception, incoming_sequence_number);
            o_prot.write_message_begin(&message_ident)?;
            thrift::Error::write_application_error_to_out_protocol(&ret_err, o_prot)?;
            o_prot.write_message_end()?;
            o_prot.flush()
          },
        }
      },
    }
  }
  pub fn process_get_table_descriptors<H: THBaseServiceSyncHandler>(handler: &H, incoming_sequence_number: i32, i_prot: &mut dyn TInputProtocol, o_prot: &mut dyn TOutputProtocol) -> thrift::Result<()> {
    let args = THBaseServiceGetTableDescriptorsArgs::read_from_in_protocol(i_prot)?;
    match handler.handle_get_table_descriptors(args.tables) {
      Ok(handler_return) => {
        let message_ident = TMessageIdentifier::new("getTableDescriptors", TMessageType::Reply, incoming_sequence_number);
        o_prot.write_message_begin(&message_ident)?;
        let ret = THBaseServiceGetTableDescriptorsResult { result_value: Some(handler_return), io: None };
        ret.write_to_out_protocol(o_prot)?;
        o_prot.write_message_end()?;
        o_prot.flush()
      },
      Err(e) => {
        match e {
          thrift::Error::User(usr_err) => {
            if usr_err.downcast_ref::<TIOError>().is_some() {
              let err = usr_err.downcast::<TIOError>().expect("downcast already checked");
              let ret_err = THBaseServiceGetTableDescriptorsResult{ result_value: None, io: Some(*err) };
              let message_ident = TMessageIdentifier::new("getTableDescriptors", TMessageType::Reply, incoming_sequence_number);
              o_prot.write_message_begin(&message_ident)?;
              ret_err.write_to_out_protocol(o_prot)?;
              o_prot.write_message_end()?;
              o_prot.flush()
            } else {
              let ret_err = {
                ApplicationError::new(
                  ApplicationErrorKind::Unknown,
                  usr_err.to_string()
                )
              };
              let message_ident = TMessageIdentifier::new("getTableDescriptors", TMessageType::Exception, incoming_sequence_number);
              o_prot.write_message_begin(&message_ident)?;
              thrift::Error::write_application_error_to_out_protocol(&ret_err, o_prot)?;
              o_prot.write_message_end()?;
              o_prot.flush()
            }
          },
          thrift::Error::Application(app_err) => {
            let message_ident = TMessageIdentifier::new("getTableDescriptors", TMessageType::Exception, incoming_sequence_number);
            o_prot.write_message_begin(&message_ident)?;
            thrift::Error::write_application_error_to_out_protocol(&app_err, o_prot)?;
            o_prot.write_message_end()?;
            o_prot.flush()
          },
          _ => {
            let ret_err = {
              ApplicationError::new(
                ApplicationErrorKind::Unknown,
                e.to_string()
              )
            };
            let message_ident = TMessageIdentifier::new("getTableDescriptors", TMessageType::Exception, incoming_sequence_number);
            o_prot.write_message_begin(&message_ident)?;
            thrift::Error::write_application_error_to_out_protocol(&ret_err, o_prot)?;
            o_prot.write_message_end()?;
            o_prot.flush()
          },
        }
      },
    }
  }
  pub fn process_table_exists<H: THBaseServiceSyncHandler>(handler: &H, incoming_sequence_number: i32, i_prot: &mut dyn TInputProtocol, o_prot: &mut dyn TOutputProtocol) -> thrift::Result<()> {
    let args = THBaseServiceTableExistsArgs::read_from_in_protocol(i_prot)?;
    match handler.handle_table_exists(args.table_name) {
      Ok(handler_return) => {
        let message_ident = TMessageIdentifier::new("tableExists", TMessageType::Reply, incoming_sequence_number);
        o_prot.write_message_begin(&message_ident)?;
        let ret = THBaseServiceTableExistsResult { result_value: Some(handler_return), io: None };
        ret.write_to_out_protocol(o_prot)?;
        o_prot.write_message_end()?;
        o_prot.flush()
      },
      Err(e) => {
        match e {
          thrift::Error::User(usr_err) => {
            if usr_err.downcast_ref::<TIOError>().is_some() {
              let err = usr_err.downcast::<TIOError>().expect("downcast already checked");
              let ret_err = THBaseServiceTableExistsResult{ result_value: None, io: Some(*err) };
              let message_ident = TMessageIdentifier::new("tableExists", TMessageType::Reply, incoming_sequence_number);
              o_prot.write_message_begin(&message_ident)?;
              ret_err.write_to_out_protocol(o_prot)?;
              o_prot.write_message_end()?;
              o_prot.flush()
            } else {
              let ret_err = {
                ApplicationError::new(
                  ApplicationErrorKind::Unknown,
                  usr_err.to_string()
                )
              };
              let message_ident = TMessageIdentifier::new("tableExists", TMessageType::Exception, incoming_sequence_number);
              o_prot.write_message_begin(&message_ident)?;
              thrift::Error::write_application_error_to_out_protocol(&ret_err, o_prot)?;
              o_prot.write_message_end()?;
              o_prot.flush()
            }
          },
          thrift::Error::Application(app_err) => {
            let message_ident = TMessageIdentifier::new("tableExists", TMessageType::Exception, incoming_sequence_number);
            o_prot.write_message_begin(&message_ident)?;
            thrift::Error::write_application_error_to_out_protocol(&app_err, o_prot)?;
            o_prot.write_message_end()?;
            o_prot.flush()
          },
          _ => {
            let ret_err = {
              ApplicationError::new(
                ApplicationErrorKind::Unknown,
                e.to_string()
              )
            };
            let message_ident = TMessageIdentifier::new("tableExists", TMessageType::Exception, incoming_sequence_number);
            o_prot.write_message_begin(&message_ident)?;
            thrift::Error::write_application_error_to_out_protocol(&ret_err, o_prot)?;
            o_prot.write_message_end()?;
            o_prot.flush()
          },
        }
      },
    }
  }
  pub fn process_get_table_descriptors_by_pattern<H: THBaseServiceSyncHandler>(handler: &H, incoming_sequence_number: i32, i_prot: &mut dyn TInputProtocol, o_prot: &mut dyn TOutputProtocol) -> thrift::Result<()> {
    let args = THBaseServiceGetTableDescriptorsByPatternArgs::read_from_in_protocol(i_prot)?;
    match handler.handle_get_table_descriptors_by_pattern(args.regex, args.include_sys_tables) {
      Ok(handler_return) => {
        let message_ident = TMessageIdentifier::new("getTableDescriptorsByPattern", TMessageType::Reply, incoming_sequence_number);
        o_prot.write_message_begin(&message_ident)?;
        let ret = THBaseServiceGetTableDescriptorsByPatternResult { result_value: Some(handler_return), io: None };
        ret.write_to_out_protocol(o_prot)?;
        o_prot.write_message_end()?;
        o_prot.flush()
      },
      Err(e) => {
        match e {
          thrift::Error::User(usr_err) => {
            if usr_err.downcast_ref::<TIOError>().is_some() {
              let err = usr_err.downcast::<TIOError>().expect("downcast already checked");
              let ret_err = THBaseServiceGetTableDescriptorsByPatternResult{ result_value: None, io: Some(*err) };
              let message_ident = TMessageIdentifier::new("getTableDescriptorsByPattern", TMessageType::Reply, incoming_sequence_number);
              o_prot.write_message_begin(&message_ident)?;
              ret_err.write_to_out_protocol(o_prot)?;
              o_prot.write_message_end()?;
              o_prot.flush()
            } else {
              let ret_err = {
                ApplicationError::new(
                  ApplicationErrorKind::Unknown,
                  usr_err.to_string()
                )
              };
              let message_ident = TMessageIdentifier::new("getTableDescriptorsByPattern", TMessageType::Exception, incoming_sequence_number);
              o_prot.write_message_begin(&message_ident)?;
              thrift::Error::write_application_error_to_out_protocol(&ret_err, o_prot)?;
              o_prot.write_message_end()?;
              o_prot.flush()
            }
          },
          thrift::Error::Application(app_err) => {
            let message_ident = TMessageIdentifier::new("getTableDescriptorsByPattern", TMessageType::Exception, incoming_sequence_number);
            o_prot.write_message_begin(&message_ident)?;
            thrift::Error::write_application_error_to_out_protocol(&app_err, o_prot)?;
            o_prot.write_message_end()?;
            o_prot.flush()
          },
          _ => {
            let ret_err = {
              ApplicationError::new(
                ApplicationErrorKind::Unknown,
                e.to_string()
              )
            };
            let message_ident = TMessageIdentifier::new("getTableDescriptorsByPattern", TMessageType::Exception, incoming_sequence_number);
            o_prot.write_message_begin(&message_ident)?;
            thrift::Error::write_application_error_to_out_protocol(&ret_err, o_prot)?;
            o_prot.write_message_end()?;
            o_prot.flush()
          },
        }
      },
    }
  }
  pub fn process_get_table_descriptors_by_namespace<H: THBaseServiceSyncHandler>(handler: &H, incoming_sequence_number: i32, i_prot: &mut dyn TInputProtocol, o_prot: &mut dyn TOutputProtocol) -> thrift::Result<()> {
    let args = THBaseServiceGetTableDescriptorsByNamespaceArgs::read_from_in_protocol(i_prot)?;
    match handler.handle_get_table_descriptors_by_namespace(args.name) {
      Ok(handler_return) => {
        let message_ident = TMessageIdentifier::new("getTableDescriptorsByNamespace", TMessageType::Reply, incoming_sequence_number);
        o_prot.write_message_begin(&message_ident)?;
        let ret = THBaseServiceGetTableDescriptorsByNamespaceResult { result_value: Some(handler_return), io: None };
        ret.write_to_out_protocol(o_prot)?;
        o_prot.write_message_end()?;
        o_prot.flush()
      },
      Err(e) => {
        match e {
          thrift::Error::User(usr_err) => {
            if usr_err.downcast_ref::<TIOError>().is_some() {
              let err = usr_err.downcast::<TIOError>().expect("downcast already checked");
              let ret_err = THBaseServiceGetTableDescriptorsByNamespaceResult{ result_value: None, io: Some(*err) };
              let message_ident = TMessageIdentifier::new("getTableDescriptorsByNamespace", TMessageType::Reply, incoming_sequence_number);
              o_prot.write_message_begin(&message_ident)?;
              ret_err.write_to_out_protocol(o_prot)?;
              o_prot.write_message_end()?;
              o_prot.flush()
            } else {
              let ret_err = {
                ApplicationError::new(
                  ApplicationErrorKind::Unknown,
                  usr_err.to_string()
                )
              };
              let message_ident = TMessageIdentifier::new("getTableDescriptorsByNamespace", TMessageType::Exception, incoming_sequence_number);
              o_prot.write_message_begin(&message_ident)?;
              thrift::Error::write_application_error_to_out_protocol(&ret_err, o_prot)?;
              o_prot.write_message_end()?;
              o_prot.flush()
            }
          },
          thrift::Error::Application(app_err) => {
            let message_ident = TMessageIdentifier::new("getTableDescriptorsByNamespace", TMessageType::Exception, incoming_sequence_number);
            o_prot.write_message_begin(&message_ident)?;
            thrift::Error::write_application_error_to_out_protocol(&app_err, o_prot)?;
            o_prot.write_message_end()?;
            o_prot.flush()
          },
          _ => {
            let ret_err = {
              ApplicationError::new(
                ApplicationErrorKind::Unknown,
                e.to_string()
              )
            };
            let message_ident = TMessageIdentifier::new("getTableDescriptorsByNamespace", TMessageType::Exception, incoming_sequence_number);
            o_prot.write_message_begin(&message_ident)?;
            thrift::Error::write_application_error_to_out_protocol(&ret_err, o_prot)?;
            o_prot.write_message_end()?;
            o_prot.flush()
          },
        }
      },
    }
  }
  pub fn process_get_table_names_by_pattern<H: THBaseServiceSyncHandler>(handler: &H, incoming_sequence_number: i32, i_prot: &mut dyn TInputProtocol, o_prot: &mut dyn TOutputProtocol) -> thrift::Result<()> {
    let args = THBaseServiceGetTableNamesByPatternArgs::read_from_in_protocol(i_prot)?;
    match handler.handle_get_table_names_by_pattern(args.regex, args.include_sys_tables) {
      Ok(handler_return) => {
        let message_ident = TMessageIdentifier::new("getTableNamesByPattern", TMessageType::Reply, incoming_sequence_number);
        o_prot.write_message_begin(&message_ident)?;
        let ret = THBaseServiceGetTableNamesByPatternResult { result_value: Some(handler_return), io: None };
        ret.write_to_out_protocol(o_prot)?;
        o_prot.write_message_end()?;
        o_prot.flush()
      },
      Err(e) => {
        match e {
          thrift::Error::User(usr_err) => {
            if usr_err.downcast_ref::<TIOError>().is_some() {
              let err = usr_err.downcast::<TIOError>().expect("downcast already checked");
              let ret_err = THBaseServiceGetTableNamesByPatternResult{ result_value: None, io: Some(*err) };
              let message_ident = TMessageIdentifier::new("getTableNamesByPattern", TMessageType::Reply, incoming_sequence_number);
              o_prot.write_message_begin(&message_ident)?;
              ret_err.write_to_out_protocol(o_prot)?;
              o_prot.write_message_end()?;
              o_prot.flush()
            } else {
              let ret_err = {
                ApplicationError::new(
                  ApplicationErrorKind::Unknown,
                  usr_err.to_string()
                )
              };
              let message_ident = TMessageIdentifier::new("getTableNamesByPattern", TMessageType::Exception, incoming_sequence_number);
              o_prot.write_message_begin(&message_ident)?;
              thrift::Error::write_application_error_to_out_protocol(&ret_err, o_prot)?;
              o_prot.write_message_end()?;
              o_prot.flush()
            }
          },
          thrift::Error::Application(app_err) => {
            let message_ident = TMessageIdentifier::new("getTableNamesByPattern", TMessageType::Exception, incoming_sequence_number);
            o_prot.write_message_begin(&message_ident)?;
            thrift::Error::write_application_error_to_out_protocol(&app_err, o_prot)?;
            o_prot.write_message_end()?;
            o_prot.flush()
          },
          _ => {
            let ret_err = {
              ApplicationError::new(
                ApplicationErrorKind::Unknown,
                e.to_string()
              )
            };
            let message_ident = TMessageIdentifier::new("getTableNamesByPattern", TMessageType::Exception, incoming_sequence_number);
            o_prot.write_message_begin(&message_ident)?;
            thrift::Error::write_application_error_to_out_protocol(&ret_err, o_prot)?;
            o_prot.write_message_end()?;
            o_prot.flush()
          },
        }
      },
    }
  }
  pub fn process_get_table_names_by_namespace<H: THBaseServiceSyncHandler>(handler: &H, incoming_sequence_number: i32, i_prot: &mut dyn TInputProtocol, o_prot: &mut dyn TOutputProtocol) -> thrift::Result<()> {
    let args = THBaseServiceGetTableNamesByNamespaceArgs::read_from_in_protocol(i_prot)?;
    match handler.handle_get_table_names_by_namespace(args.name) {
      Ok(handler_return) => {
        let message_ident = TMessageIdentifier::new("getTableNamesByNamespace", TMessageType::Reply, incoming_sequence_number);
        o_prot.write_message_begin(&message_ident)?;
        let ret = THBaseServiceGetTableNamesByNamespaceResult { result_value: Some(handler_return), io: None };
        ret.write_to_out_protocol(o_prot)?;
        o_prot.write_message_end()?;
        o_prot.flush()
      },
      Err(e) => {
        match e {
          thrift::Error::User(usr_err) => {
            if usr_err.downcast_ref::<TIOError>().is_some() {
              let err = usr_err.downcast::<TIOError>().expect("downcast already checked");
              let ret_err = THBaseServiceGetTableNamesByNamespaceResult{ result_value: None, io: Some(*err) };
              let message_ident = TMessageIdentifier::new("getTableNamesByNamespace", TMessageType::Reply, incoming_sequence_number);
              o_prot.write_message_begin(&message_ident)?;
              ret_err.write_to_out_protocol(o_prot)?;
              o_prot.write_message_end()?;
              o_prot.flush()
            } else {
              let ret_err = {
                ApplicationError::new(
                  ApplicationErrorKind::Unknown,
                  usr_err.to_string()
                )
              };
              let message_ident = TMessageIdentifier::new("getTableNamesByNamespace", TMessageType::Exception, incoming_sequence_number);
              o_prot.write_message_begin(&message_ident)?;
              thrift::Error::write_application_error_to_out_protocol(&ret_err, o_prot)?;
              o_prot.write_message_end()?;
              o_prot.flush()
            }
          },
          thrift::Error::Application(app_err) => {
            let message_ident = TMessageIdentifier::new("getTableNamesByNamespace", TMessageType::Exception, incoming_sequence_number);
            o_prot.write_message_begin(&message_ident)?;
            thrift::Error::write_application_error_to_out_protocol(&app_err, o_prot)?;
            o_prot.write_message_end()?;
            o_prot.flush()
          },
          _ => {
            let ret_err = {
              ApplicationError::new(
                ApplicationErrorKind::Unknown,
                e.to_string()
              )
            };
            let message_ident = TMessageIdentifier::new("getTableNamesByNamespace", TMessageType::Exception, incoming_sequence_number);
            o_prot.write_message_begin(&message_ident)?;
            thrift::Error::write_application_error_to_out_protocol(&ret_err, o_prot)?;
            o_prot.write_message_end()?;
            o_prot.flush()
          },
        }
      },
    }
  }
  pub fn process_create_table<H: THBaseServiceSyncHandler>(handler: &H, incoming_sequence_number: i32, i_prot: &mut dyn TInputProtocol, o_prot: &mut dyn TOutputProtocol) -> thrift::Result<()> {
    let args = THBaseServiceCreateTableArgs::read_from_in_protocol(i_prot)?;
    match handler.handle_create_table(args.desc, args.split_keys) {
      Ok(_) => {
        let message_ident = TMessageIdentifier::new("createTable", TMessageType::Reply, incoming_sequence_number);
        o_prot.write_message_begin(&message_ident)?;
        let ret = THBaseServiceCreateTableResult { io: None };
        ret.write_to_out_protocol(o_prot)?;
        o_prot.write_message_end()?;
        o_prot.flush()
      },
      Err(e) => {
        match e {
          thrift::Error::User(usr_err) => {
            if usr_err.downcast_ref::<TIOError>().is_some() {
              let err = usr_err.downcast::<TIOError>().expect("downcast already checked");
              let ret_err = THBaseServiceCreateTableResult{ io: Some(*err) };
              let message_ident = TMessageIdentifier::new("createTable", TMessageType::Reply, incoming_sequence_number);
              o_prot.write_message_begin(&message_ident)?;
              ret_err.write_to_out_protocol(o_prot)?;
              o_prot.write_message_end()?;
              o_prot.flush()
            } else {
              let ret_err = {
                ApplicationError::new(
                  ApplicationErrorKind::Unknown,
                  usr_err.to_string()
                )
              };
              let message_ident = TMessageIdentifier::new("createTable", TMessageType::Exception, incoming_sequence_number);
              o_prot.write_message_begin(&message_ident)?;
              thrift::Error::write_application_error_to_out_protocol(&ret_err, o_prot)?;
              o_prot.write_message_end()?;
              o_prot.flush()
            }
          },
          thrift::Error::Application(app_err) => {
            let message_ident = TMessageIdentifier::new("createTable", TMessageType::Exception, incoming_sequence_number);
            o_prot.write_message_begin(&message_ident)?;
            thrift::Error::write_application_error_to_out_protocol(&app_err, o_prot)?;
            o_prot.write_message_end()?;
            o_prot.flush()
          },
          _ => {
            let ret_err = {
              ApplicationError::new(
                ApplicationErrorKind::Unknown,
                e.to_string()
              )
            };
            let message_ident = TMessageIdentifier::new("createTable", TMessageType::Exception, incoming_sequence_number);
            o_prot.write_message_begin(&message_ident)?;
            thrift::Error::write_application_error_to_out_protocol(&ret_err, o_prot)?;
            o_prot.write_message_end()?;
            o_prot.flush()
          },
        }
      },
    }
  }
  pub fn process_delete_table<H: THBaseServiceSyncHandler>(handler: &H, incoming_sequence_number: i32, i_prot: &mut dyn TInputProtocol, o_prot: &mut dyn TOutputProtocol) -> thrift::Result<()> {
    let args = THBaseServiceDeleteTableArgs::read_from_in_protocol(i_prot)?;
    match handler.handle_delete_table(args.table_name) {
      Ok(_) => {
        let message_ident = TMessageIdentifier::new("deleteTable", TMessageType::Reply, incoming_sequence_number);
        o_prot.write_message_begin(&message_ident)?;
        let ret = THBaseServiceDeleteTableResult { io: None };
        ret.write_to_out_protocol(o_prot)?;
        o_prot.write_message_end()?;
        o_prot.flush()
      },
      Err(e) => {
        match e {
          thrift::Error::User(usr_err) => {
            if usr_err.downcast_ref::<TIOError>().is_some() {
              let err = usr_err.downcast::<TIOError>().expect("downcast already checked");
              let ret_err = THBaseServiceDeleteTableResult{ io: Some(*err) };
              let message_ident = TMessageIdentifier::new("deleteTable", TMessageType::Reply, incoming_sequence_number);
              o_prot.write_message_begin(&message_ident)?;
              ret_err.write_to_out_protocol(o_prot)?;
              o_prot.write_message_end()?;
              o_prot.flush()
            } else {
              let ret_err = {
                ApplicationError::new(
                  ApplicationErrorKind::Unknown,
                  usr_err.to_string()
                )
              };
              let message_ident = TMessageIdentifier::new("deleteTable", TMessageType::Exception, incoming_sequence_number);
              o_prot.write_message_begin(&message_ident)?;
              thrift::Error::write_application_error_to_out_protocol(&ret_err, o_prot)?;
              o_prot.write_message_end()?;
              o_prot.flush()
            }
          },
          thrift::Error::Application(app_err) => {
            let message_ident = TMessageIdentifier::new("deleteTable", TMessageType::Exception, incoming_sequence_number);
            o_prot.write_message_begin(&message_ident)?;
            thrift::Error::write_application_error_to_out_protocol(&app_err, o_prot)?;
            o_prot.write_message_end()?;
            o_prot.flush()
          },
          _ => {
            let ret_err = {
              ApplicationError::new(
                ApplicationErrorKind::Unknown,
                e.to_string()
              )
            };
            let message_ident = TMessageIdentifier::new("deleteTable", TMessageType::Exception, incoming_sequence_number);
            o_prot.write_message_begin(&message_ident)?;
            thrift::Error::write_application_error_to_out_protocol(&ret_err, o_prot)?;
            o_prot.write_message_end()?;
            o_prot.flush()
          },
        }
      },
    }
  }
  pub fn process_truncate_table<H: THBaseServiceSyncHandler>(handler: &H, incoming_sequence_number: i32, i_prot: &mut dyn TInputProtocol, o_prot: &mut dyn TOutputProtocol) -> thrift::Result<()> {
    let args = THBaseServiceTruncateTableArgs::read_from_in_protocol(i_prot)?;
    match handler.handle_truncate_table(args.table_name, args.preserve_splits) {
      Ok(_) => {
        let message_ident = TMessageIdentifier::new("truncateTable", TMessageType::Reply, incoming_sequence_number);
        o_prot.write_message_begin(&message_ident)?;
        let ret = THBaseServiceTruncateTableResult { io: None };
        ret.write_to_out_protocol(o_prot)?;
        o_prot.write_message_end()?;
        o_prot.flush()
      },
      Err(e) => {
        match e {
          thrift::Error::User(usr_err) => {
            if usr_err.downcast_ref::<TIOError>().is_some() {
              let err = usr_err.downcast::<TIOError>().expect("downcast already checked");
              let ret_err = THBaseServiceTruncateTableResult{ io: Some(*err) };
              let message_ident = TMessageIdentifier::new("truncateTable", TMessageType::Reply, incoming_sequence_number);
              o_prot.write_message_begin(&message_ident)?;
              ret_err.write_to_out_protocol(o_prot)?;
              o_prot.write_message_end()?;
              o_prot.flush()
            } else {
              let ret_err = {
                ApplicationError::new(
                  ApplicationErrorKind::Unknown,
                  usr_err.to_string()
                )
              };
              let message_ident = TMessageIdentifier::new("truncateTable", TMessageType::Exception, incoming_sequence_number);
              o_prot.write_message_begin(&message_ident)?;
              thrift::Error::write_application_error_to_out_protocol(&ret_err, o_prot)?;
              o_prot.write_message_end()?;
              o_prot.flush()
            }
          },
          thrift::Error::Application(app_err) => {
            let message_ident = TMessageIdentifier::new("truncateTable", TMessageType::Exception, incoming_sequence_number);
            o_prot.write_message_begin(&message_ident)?;
            thrift::Error::write_application_error_to_out_protocol(&app_err, o_prot)?;
            o_prot.write_message_end()?;
            o_prot.flush()
          },
          _ => {
            let ret_err = {
              ApplicationError::new(
                ApplicationErrorKind::Unknown,
                e.to_string()
              )
            };
            let message_ident = TMessageIdentifier::new("truncateTable", TMessageType::Exception, incoming_sequence_number);
            o_prot.write_message_begin(&message_ident)?;
            thrift::Error::write_application_error_to_out_protocol(&ret_err, o_prot)?;
            o_prot.write_message_end()?;
            o_prot.flush()
          },
        }
      },
    }
  }
  pub fn process_enable_table<H: THBaseServiceSyncHandler>(handler: &H, incoming_sequence_number: i32, i_prot: &mut dyn TInputProtocol, o_prot: &mut dyn TOutputProtocol) -> thrift::Result<()> {
    let args = THBaseServiceEnableTableArgs::read_from_in_protocol(i_prot)?;
    match handler.handle_enable_table(args.table_name) {
      Ok(_) => {
        let message_ident = TMessageIdentifier::new("enableTable", TMessageType::Reply, incoming_sequence_number);
        o_prot.write_message_begin(&message_ident)?;
        let ret = THBaseServiceEnableTableResult { io: None };
        ret.write_to_out_protocol(o_prot)?;
        o_prot.write_message_end()?;
        o_prot.flush()
      },
      Err(e) => {
        match e {
          thrift::Error::User(usr_err) => {
            if usr_err.downcast_ref::<TIOError>().is_some() {
              let err = usr_err.downcast::<TIOError>().expect("downcast already checked");
              let ret_err = THBaseServiceEnableTableResult{ io: Some(*err) };
              let message_ident = TMessageIdentifier::new("enableTable", TMessageType::Reply, incoming_sequence_number);
              o_prot.write_message_begin(&message_ident)?;
              ret_err.write_to_out_protocol(o_prot)?;
              o_prot.write_message_end()?;
              o_prot.flush()
            } else {
              let ret_err = {
                ApplicationError::new(
                  ApplicationErrorKind::Unknown,
                  usr_err.to_string()
                )
              };
              let message_ident = TMessageIdentifier::new("enableTable", TMessageType::Exception, incoming_sequence_number);
              o_prot.write_message_begin(&message_ident)?;
              thrift::Error::write_application_error_to_out_protocol(&ret_err, o_prot)?;
              o_prot.write_message_end()?;
              o_prot.flush()
            }
          },
          thrift::Error::Application(app_err) => {
            let message_ident = TMessageIdentifier::new("enableTable", TMessageType::Exception, incoming_sequence_number);
            o_prot.write_message_begin(&message_ident)?;
            thrift::Error::write_application_error_to_out_protocol(&app_err, o_prot)?;
            o_prot.write_message_end()?;
            o_prot.flush()
          },
          _ => {
            let ret_err = {
              ApplicationError::new(
                ApplicationErrorKind::Unknown,
                e.to_string()
              )
            };
            let message_ident = TMessageIdentifier::new("enableTable", TMessageType::Exception, incoming_sequence_number);
            o_prot.write_message_begin(&message_ident)?;
            thrift::Error::write_application_error_to_out_protocol(&ret_err, o_prot)?;
            o_prot.write_message_end()?;
            o_prot.flush()
          },
        }
      },
    }
  }
  pub fn process_disable_table<H: THBaseServiceSyncHandler>(handler: &H, incoming_sequence_number: i32, i_prot: &mut dyn TInputProtocol, o_prot: &mut dyn TOutputProtocol) -> thrift::Result<()> {
    let args = THBaseServiceDisableTableArgs::read_from_in_protocol(i_prot)?;
    match handler.handle_disable_table(args.table_name) {
      Ok(_) => {
        let message_ident = TMessageIdentifier::new("disableTable", TMessageType::Reply, incoming_sequence_number);
        o_prot.write_message_begin(&message_ident)?;
        let ret = THBaseServiceDisableTableResult { io: None };
        ret.write_to_out_protocol(o_prot)?;
        o_prot.write_message_end()?;
        o_prot.flush()
      },
      Err(e) => {
        match e {
          thrift::Error::User(usr_err) => {
            if usr_err.downcast_ref::<TIOError>().is_some() {
              let err = usr_err.downcast::<TIOError>().expect("downcast already checked");
              let ret_err = THBaseServiceDisableTableResult{ io: Some(*err) };
              let message_ident = TMessageIdentifier::new("disableTable", TMessageType::Reply, incoming_sequence_number);
              o_prot.write_message_begin(&message_ident)?;
              ret_err.write_to_out_protocol(o_prot)?;
              o_prot.write_message_end()?;
              o_prot.flush()
            } else {
              let ret_err = {
                ApplicationError::new(
                  ApplicationErrorKind::Unknown,
                  usr_err.to_string()
                )
              };
              let message_ident = TMessageIdentifier::new("disableTable", TMessageType::Exception, incoming_sequence_number);
              o_prot.write_message_begin(&message_ident)?;
              thrift::Error::write_application_error_to_out_protocol(&ret_err, o_prot)?;
              o_prot.write_message_end()?;
              o_prot.flush()
            }
          },
          thrift::Error::Application(app_err) => {
            let message_ident = TMessageIdentifier::new("disableTable", TMessageType::Exception, incoming_sequence_number);
            o_prot.write_message_begin(&message_ident)?;
            thrift::Error::write_application_error_to_out_protocol(&app_err, o_prot)?;
            o_prot.write_message_end()?;
            o_prot.flush()
          },
          _ => {
            let ret_err = {
              ApplicationError::new(
                ApplicationErrorKind::Unknown,
                e.to_string()
              )
            };
            let message_ident = TMessageIdentifier::new("disableTable", TMessageType::Exception, incoming_sequence_number);
            o_prot.write_message_begin(&message_ident)?;
            thrift::Error::write_application_error_to_out_protocol(&ret_err, o_prot)?;
            o_prot.write_message_end()?;
            o_prot.flush()
          },
        }
      },
    }
  }
  pub fn process_is_table_enabled<H: THBaseServiceSyncHandler>(handler: &H, incoming_sequence_number: i32, i_prot: &mut dyn TInputProtocol, o_prot: &mut dyn TOutputProtocol) -> thrift::Result<()> {
    let args = THBaseServiceIsTableEnabledArgs::read_from_in_protocol(i_prot)?;
    match handler.handle_is_table_enabled(args.table_name) {
      Ok(handler_return) => {
        let message_ident = TMessageIdentifier::new("isTableEnabled", TMessageType::Reply, incoming_sequence_number);
        o_prot.write_message_begin(&message_ident)?;
        let ret = THBaseServiceIsTableEnabledResult { result_value: Some(handler_return), io: None };
        ret.write_to_out_protocol(o_prot)?;
        o_prot.write_message_end()?;
        o_prot.flush()
      },
      Err(e) => {
        match e {
          thrift::Error::User(usr_err) => {
            if usr_err.downcast_ref::<TIOError>().is_some() {
              let err = usr_err.downcast::<TIOError>().expect("downcast already checked");
              let ret_err = THBaseServiceIsTableEnabledResult{ result_value: None, io: Some(*err) };
              let message_ident = TMessageIdentifier::new("isTableEnabled", TMessageType::Reply, incoming_sequence_number);
              o_prot.write_message_begin(&message_ident)?;
              ret_err.write_to_out_protocol(o_prot)?;
              o_prot.write_message_end()?;
              o_prot.flush()
            } else {
              let ret_err = {
                ApplicationError::new(
                  ApplicationErrorKind::Unknown,
                  usr_err.to_string()
                )
              };
              let message_ident = TMessageIdentifier::new("isTableEnabled", TMessageType::Exception, incoming_sequence_number);
              o_prot.write_message_begin(&message_ident)?;
              thrift::Error::write_application_error_to_out_protocol(&ret_err, o_prot)?;
              o_prot.write_message_end()?;
              o_prot.flush()
            }
          },
          thrift::Error::Application(app_err) => {
            let message_ident = TMessageIdentifier::new("isTableEnabled", TMessageType::Exception, incoming_sequence_number);
            o_prot.write_message_begin(&message_ident)?;
            thrift::Error::write_application_error_to_out_protocol(&app_err, o_prot)?;
            o_prot.write_message_end()?;
            o_prot.flush()
          },
          _ => {
            let ret_err = {
              ApplicationError::new(
                ApplicationErrorKind::Unknown,
                e.to_string()
              )
            };
            let message_ident = TMessageIdentifier::new("isTableEnabled", TMessageType::Exception, incoming_sequence_number);
            o_prot.write_message_begin(&message_ident)?;
            thrift::Error::write_application_error_to_out_protocol(&ret_err, o_prot)?;
            o_prot.write_message_end()?;
            o_prot.flush()
          },
        }
      },
    }
  }
  pub fn process_is_table_disabled<H: THBaseServiceSyncHandler>(handler: &H, incoming_sequence_number: i32, i_prot: &mut dyn TInputProtocol, o_prot: &mut dyn TOutputProtocol) -> thrift::Result<()> {
    let args = THBaseServiceIsTableDisabledArgs::read_from_in_protocol(i_prot)?;
    match handler.handle_is_table_disabled(args.table_name) {
      Ok(handler_return) => {
        let message_ident = TMessageIdentifier::new("isTableDisabled", TMessageType::Reply, incoming_sequence_number);
        o_prot.write_message_begin(&message_ident)?;
        let ret = THBaseServiceIsTableDisabledResult { result_value: Some(handler_return), io: None };
        ret.write_to_out_protocol(o_prot)?;
        o_prot.write_message_end()?;
        o_prot.flush()
      },
      Err(e) => {
        match e {
          thrift::Error::User(usr_err) => {
            if usr_err.downcast_ref::<TIOError>().is_some() {
              let err = usr_err.downcast::<TIOError>().expect("downcast already checked");
              let ret_err = THBaseServiceIsTableDisabledResult{ result_value: None, io: Some(*err) };
              let message_ident = TMessageIdentifier::new("isTableDisabled", TMessageType::Reply, incoming_sequence_number);
              o_prot.write_message_begin(&message_ident)?;
              ret_err.write_to_out_protocol(o_prot)?;
              o_prot.write_message_end()?;
              o_prot.flush()
            } else {
              let ret_err = {
                ApplicationError::new(
                  ApplicationErrorKind::Unknown,
                  usr_err.to_string()
                )
              };
              let message_ident = TMessageIdentifier::new("isTableDisabled", TMessageType::Exception, incoming_sequence_number);
              o_prot.write_message_begin(&message_ident)?;
              thrift::Error::write_application_error_to_out_protocol(&ret_err, o_prot)?;
              o_prot.write_message_end()?;
              o_prot.flush()
            }
          },
          thrift::Error::Application(app_err) => {
            let message_ident = TMessageIdentifier::new("isTableDisabled", TMessageType::Exception, incoming_sequence_number);
            o_prot.write_message_begin(&message_ident)?;
            thrift::Error::write_application_error_to_out_protocol(&app_err, o_prot)?;
            o_prot.write_message_end()?;
            o_prot.flush()
          },
          _ => {
            let ret_err = {
              ApplicationError::new(
                ApplicationErrorKind::Unknown,
                e.to_string()
              )
            };
            let message_ident = TMessageIdentifier::new("isTableDisabled", TMessageType::Exception, incoming_sequence_number);
            o_prot.write_message_begin(&message_ident)?;
            thrift::Error::write_application_error_to_out_protocol(&ret_err, o_prot)?;
            o_prot.write_message_end()?;
            o_prot.flush()
          },
        }
      },
    }
  }
  pub fn process_is_table_available<H: THBaseServiceSyncHandler>(handler: &H, incoming_sequence_number: i32, i_prot: &mut dyn TInputProtocol, o_prot: &mut dyn TOutputProtocol) -> thrift::Result<()> {
    let args = THBaseServiceIsTableAvailableArgs::read_from_in_protocol(i_prot)?;
    match handler.handle_is_table_available(args.table_name) {
      Ok(handler_return) => {
        let message_ident = TMessageIdentifier::new("isTableAvailable", TMessageType::Reply, incoming_sequence_number);
        o_prot.write_message_begin(&message_ident)?;
        let ret = THBaseServiceIsTableAvailableResult { result_value: Some(handler_return), io: None };
        ret.write_to_out_protocol(o_prot)?;
        o_prot.write_message_end()?;
        o_prot.flush()
      },
      Err(e) => {
        match e {
          thrift::Error::User(usr_err) => {
            if usr_err.downcast_ref::<TIOError>().is_some() {
              let err = usr_err.downcast::<TIOError>().expect("downcast already checked");
              let ret_err = THBaseServiceIsTableAvailableResult{ result_value: None, io: Some(*err) };
              let message_ident = TMessageIdentifier::new("isTableAvailable", TMessageType::Reply, incoming_sequence_number);
              o_prot.write_message_begin(&message_ident)?;
              ret_err.write_to_out_protocol(o_prot)?;
              o_prot.write_message_end()?;
              o_prot.flush()
            } else {
              let ret_err = {
                ApplicationError::new(
                  ApplicationErrorKind::Unknown,
                  usr_err.to_string()
                )
              };
              let message_ident = TMessageIdentifier::new("isTableAvailable", TMessageType::Exception, incoming_sequence_number);
              o_prot.write_message_begin(&message_ident)?;
              thrift::Error::write_application_error_to_out_protocol(&ret_err, o_prot)?;
              o_prot.write_message_end()?;
              o_prot.flush()
            }
          },
          thrift::Error::Application(app_err) => {
            let message_ident = TMessageIdentifier::new("isTableAvailable", TMessageType::Exception, incoming_sequence_number);
            o_prot.write_message_begin(&message_ident)?;
            thrift::Error::write_application_error_to_out_protocol(&app_err, o_prot)?;
            o_prot.write_message_end()?;
            o_prot.flush()
          },
          _ => {
            let ret_err = {
              ApplicationError::new(
                ApplicationErrorKind::Unknown,
                e.to_string()
              )
            };
            let message_ident = TMessageIdentifier::new("isTableAvailable", TMessageType::Exception, incoming_sequence_number);
            o_prot.write_message_begin(&message_ident)?;
            thrift::Error::write_application_error_to_out_protocol(&ret_err, o_prot)?;
            o_prot.write_message_end()?;
            o_prot.flush()
          },
        }
      },
    }
  }
  pub fn process_is_table_available_with_split<H: THBaseServiceSyncHandler>(handler: &H, incoming_sequence_number: i32, i_prot: &mut dyn TInputProtocol, o_prot: &mut dyn TOutputProtocol) -> thrift::Result<()> {
    let args = THBaseServiceIsTableAvailableWithSplitArgs::read_from_in_protocol(i_prot)?;
    match handler.handle_is_table_available_with_split(args.table_name, args.split_keys) {
      Ok(handler_return) => {
        let message_ident = TMessageIdentifier::new("isTableAvailableWithSplit", TMessageType::Reply, incoming_sequence_number);
        o_prot.write_message_begin(&message_ident)?;
        let ret = THBaseServiceIsTableAvailableWithSplitResult { result_value: Some(handler_return), io: None };
        ret.write_to_out_protocol(o_prot)?;
        o_prot.write_message_end()?;
        o_prot.flush()
      },
      Err(e) => {
        match e {
          thrift::Error::User(usr_err) => {
            if usr_err.downcast_ref::<TIOError>().is_some() {
              let err = usr_err.downcast::<TIOError>().expect("downcast already checked");
              let ret_err = THBaseServiceIsTableAvailableWithSplitResult{ result_value: None, io: Some(*err) };
              let message_ident = TMessageIdentifier::new("isTableAvailableWithSplit", TMessageType::Reply, incoming_sequence_number);
              o_prot.write_message_begin(&message_ident)?;
              ret_err.write_to_out_protocol(o_prot)?;
              o_prot.write_message_end()?;
              o_prot.flush()
            } else {
              let ret_err = {
                ApplicationError::new(
                  ApplicationErrorKind::Unknown,
                  usr_err.to_string()
                )
              };
              let message_ident = TMessageIdentifier::new("isTableAvailableWithSplit", TMessageType::Exception, incoming_sequence_number);
              o_prot.write_message_begin(&message_ident)?;
              thrift::Error::write_application_error_to_out_protocol(&ret_err, o_prot)?;
              o_prot.write_message_end()?;
              o_prot.flush()
            }
          },
          thrift::Error::Application(app_err) => {
            let message_ident = TMessageIdentifier::new("isTableAvailableWithSplit", TMessageType::Exception, incoming_sequence_number);
            o_prot.write_message_begin(&message_ident)?;
            thrift::Error::write_application_error_to_out_protocol(&app_err, o_prot)?;
            o_prot.write_message_end()?;
            o_prot.flush()
          },
          _ => {
            let ret_err = {
              ApplicationError::new(
                ApplicationErrorKind::Unknown,
                e.to_string()
              )
            };
            let message_ident = TMessageIdentifier::new("isTableAvailableWithSplit", TMessageType::Exception, incoming_sequence_number);
            o_prot.write_message_begin(&message_ident)?;
            thrift::Error::write_application_error_to_out_protocol(&ret_err, o_prot)?;
            o_prot.write_message_end()?;
            o_prot.flush()
          },
        }
      },
    }
  }
  pub fn process_add_column_family<H: THBaseServiceSyncHandler>(handler: &H, incoming_sequence_number: i32, i_prot: &mut dyn TInputProtocol, o_prot: &mut dyn TOutputProtocol) -> thrift::Result<()> {
    let args = THBaseServiceAddColumnFamilyArgs::read_from_in_protocol(i_prot)?;
    match handler.handle_add_column_family(args.table_name, args.column) {
      Ok(_) => {
        let message_ident = TMessageIdentifier::new("addColumnFamily", TMessageType::Reply, incoming_sequence_number);
        o_prot.write_message_begin(&message_ident)?;
        let ret = THBaseServiceAddColumnFamilyResult { io: None };
        ret.write_to_out_protocol(o_prot)?;
        o_prot.write_message_end()?;
        o_prot.flush()
      },
      Err(e) => {
        match e {
          thrift::Error::User(usr_err) => {
            if usr_err.downcast_ref::<TIOError>().is_some() {
              let err = usr_err.downcast::<TIOError>().expect("downcast already checked");
              let ret_err = THBaseServiceAddColumnFamilyResult{ io: Some(*err) };
              let message_ident = TMessageIdentifier::new("addColumnFamily", TMessageType::Reply, incoming_sequence_number);
              o_prot.write_message_begin(&message_ident)?;
              ret_err.write_to_out_protocol(o_prot)?;
              o_prot.write_message_end()?;
              o_prot.flush()
            } else {
              let ret_err = {
                ApplicationError::new(
                  ApplicationErrorKind::Unknown,
                  usr_err.to_string()
                )
              };
              let message_ident = TMessageIdentifier::new("addColumnFamily", TMessageType::Exception, incoming_sequence_number);
              o_prot.write_message_begin(&message_ident)?;
              thrift::Error::write_application_error_to_out_protocol(&ret_err, o_prot)?;
              o_prot.write_message_end()?;
              o_prot.flush()
            }
          },
          thrift::Error::Application(app_err) => {
            let message_ident = TMessageIdentifier::new("addColumnFamily", TMessageType::Exception, incoming_sequence_number);
            o_prot.write_message_begin(&message_ident)?;
            thrift::Error::write_application_error_to_out_protocol(&app_err, o_prot)?;
            o_prot.write_message_end()?;
            o_prot.flush()
          },
          _ => {
            let ret_err = {
              ApplicationError::new(
                ApplicationErrorKind::Unknown,
                e.to_string()
              )
            };
            let message_ident = TMessageIdentifier::new("addColumnFamily", TMessageType::Exception, incoming_sequence_number);
            o_prot.write_message_begin(&message_ident)?;
            thrift::Error::write_application_error_to_out_protocol(&ret_err, o_prot)?;
            o_prot.write_message_end()?;
            o_prot.flush()
          },
        }
      },
    }
  }
  pub fn process_delete_column_family<H: THBaseServiceSyncHandler>(handler: &H, incoming_sequence_number: i32, i_prot: &mut dyn TInputProtocol, o_prot: &mut dyn TOutputProtocol) -> thrift::Result<()> {
    let args = THBaseServiceDeleteColumnFamilyArgs::read_from_in_protocol(i_prot)?;
    match handler.handle_delete_column_family(args.table_name, args.column) {
      Ok(_) => {
        let message_ident = TMessageIdentifier::new("deleteColumnFamily", TMessageType::Reply, incoming_sequence_number);
        o_prot.write_message_begin(&message_ident)?;
        let ret = THBaseServiceDeleteColumnFamilyResult { io: None };
        ret.write_to_out_protocol(o_prot)?;
        o_prot.write_message_end()?;
        o_prot.flush()
      },
      Err(e) => {
        match e {
          thrift::Error::User(usr_err) => {
            if usr_err.downcast_ref::<TIOError>().is_some() {
              let err = usr_err.downcast::<TIOError>().expect("downcast already checked");
              let ret_err = THBaseServiceDeleteColumnFamilyResult{ io: Some(*err) };
              let message_ident = TMessageIdentifier::new("deleteColumnFamily", TMessageType::Reply, incoming_sequence_number);
              o_prot.write_message_begin(&message_ident)?;
              ret_err.write_to_out_protocol(o_prot)?;
              o_prot.write_message_end()?;
              o_prot.flush()
            } else {
              let ret_err = {
                ApplicationError::new(
                  ApplicationErrorKind::Unknown,
                  usr_err.to_string()
                )
              };
              let message_ident = TMessageIdentifier::new("deleteColumnFamily", TMessageType::Exception, incoming_sequence_number);
              o_prot.write_message_begin(&message_ident)?;
              thrift::Error::write_application_error_to_out_protocol(&ret_err, o_prot)?;
              o_prot.write_message_end()?;
              o_prot.flush()
            }
          },
          thrift::Error::Application(app_err) => {
            let message_ident = TMessageIdentifier::new("deleteColumnFamily", TMessageType::Exception, incoming_sequence_number);
            o_prot.write_message_begin(&message_ident)?;
            thrift::Error::write_application_error_to_out_protocol(&app_err, o_prot)?;
            o_prot.write_message_end()?;
            o_prot.flush()
          },
          _ => {
            let ret_err = {
              ApplicationError::new(
                ApplicationErrorKind::Unknown,
                e.to_string()
              )
            };
            let message_ident = TMessageIdentifier::new("deleteColumnFamily", TMessageType::Exception, incoming_sequence_number);
            o_prot.write_message_begin(&message_ident)?;
            thrift::Error::write_application_error_to_out_protocol(&ret_err, o_prot)?;
            o_prot.write_message_end()?;
            o_prot.flush()
          },
        }
      },
    }
  }
  pub fn process_modify_column_family<H: THBaseServiceSyncHandler>(handler: &H, incoming_sequence_number: i32, i_prot: &mut dyn TInputProtocol, o_prot: &mut dyn TOutputProtocol) -> thrift::Result<()> {
    let args = THBaseServiceModifyColumnFamilyArgs::read_from_in_protocol(i_prot)?;
    match handler.handle_modify_column_family(args.table_name, args.column) {
      Ok(_) => {
        let message_ident = TMessageIdentifier::new("modifyColumnFamily", TMessageType::Reply, incoming_sequence_number);
        o_prot.write_message_begin(&message_ident)?;
        let ret = THBaseServiceModifyColumnFamilyResult { io: None };
        ret.write_to_out_protocol(o_prot)?;
        o_prot.write_message_end()?;
        o_prot.flush()
      },
      Err(e) => {
        match e {
          thrift::Error::User(usr_err) => {
            if usr_err.downcast_ref::<TIOError>().is_some() {
              let err = usr_err.downcast::<TIOError>().expect("downcast already checked");
              let ret_err = THBaseServiceModifyColumnFamilyResult{ io: Some(*err) };
              let message_ident = TMessageIdentifier::new("modifyColumnFamily", TMessageType::Reply, incoming_sequence_number);
              o_prot.write_message_begin(&message_ident)?;
              ret_err.write_to_out_protocol(o_prot)?;
              o_prot.write_message_end()?;
              o_prot.flush()
            } else {
              let ret_err = {
                ApplicationError::new(
                  ApplicationErrorKind::Unknown,
                  usr_err.to_string()
                )
              };
              let message_ident = TMessageIdentifier::new("modifyColumnFamily", TMessageType::Exception, incoming_sequence_number);
              o_prot.write_message_begin(&message_ident)?;
              thrift::Error::write_application_error_to_out_protocol(&ret_err, o_prot)?;
              o_prot.write_message_end()?;
              o_prot.flush()
            }
          },
          thrift::Error::Application(app_err) => {
            let message_ident = TMessageIdentifier::new("modifyColumnFamily", TMessageType::Exception, incoming_sequence_number);
            o_prot.write_message_begin(&message_ident)?;
            thrift::Error::write_application_error_to_out_protocol(&app_err, o_prot)?;
            o_prot.write_message_end()?;
            o_prot.flush()
          },
          _ => {
            let ret_err = {
              ApplicationError::new(
                ApplicationErrorKind::Unknown,
                e.to_string()
              )
            };
            let message_ident = TMessageIdentifier::new("modifyColumnFamily", TMessageType::Exception, incoming_sequence_number);
            o_prot.write_message_begin(&message_ident)?;
            thrift::Error::write_application_error_to_out_protocol(&ret_err, o_prot)?;
            o_prot.write_message_end()?;
            o_prot.flush()
          },
        }
      },
    }
  }
  pub fn process_modify_table<H: THBaseServiceSyncHandler>(handler: &H, incoming_sequence_number: i32, i_prot: &mut dyn TInputProtocol, o_prot: &mut dyn TOutputProtocol) -> thrift::Result<()> {
    let args = THBaseServiceModifyTableArgs::read_from_in_protocol(i_prot)?;
    match handler.handle_modify_table(args.desc) {
      Ok(_) => {
        let message_ident = TMessageIdentifier::new("modifyTable", TMessageType::Reply, incoming_sequence_number);
        o_prot.write_message_begin(&message_ident)?;
        let ret = THBaseServiceModifyTableResult { io: None };
        ret.write_to_out_protocol(o_prot)?;
        o_prot.write_message_end()?;
        o_prot.flush()
      },
      Err(e) => {
        match e {
          thrift::Error::User(usr_err) => {
            if usr_err.downcast_ref::<TIOError>().is_some() {
              let err = usr_err.downcast::<TIOError>().expect("downcast already checked");
              let ret_err = THBaseServiceModifyTableResult{ io: Some(*err) };
              let message_ident = TMessageIdentifier::new("modifyTable", TMessageType::Reply, incoming_sequence_number);
              o_prot.write_message_begin(&message_ident)?;
              ret_err.write_to_out_protocol(o_prot)?;
              o_prot.write_message_end()?;
              o_prot.flush()
            } else {
              let ret_err = {
                ApplicationError::new(
                  ApplicationErrorKind::Unknown,
                  usr_err.to_string()
                )
              };
              let message_ident = TMessageIdentifier::new("modifyTable", TMessageType::Exception, incoming_sequence_number);
              o_prot.write_message_begin(&message_ident)?;
              thrift::Error::write_application_error_to_out_protocol(&ret_err, o_prot)?;
              o_prot.write_message_end()?;
              o_prot.flush()
            }
          },
          thrift::Error::Application(app_err) => {
            let message_ident = TMessageIdentifier::new("modifyTable", TMessageType::Exception, incoming_sequence_number);
            o_prot.write_message_begin(&message_ident)?;
            thrift::Error::write_application_error_to_out_protocol(&app_err, o_prot)?;
            o_prot.write_message_end()?;
            o_prot.flush()
          },
          _ => {
            let ret_err = {
              ApplicationError::new(
                ApplicationErrorKind::Unknown,
                e.to_string()
              )
            };
            let message_ident = TMessageIdentifier::new("modifyTable", TMessageType::Exception, incoming_sequence_number);
            o_prot.write_message_begin(&message_ident)?;
            thrift::Error::write_application_error_to_out_protocol(&ret_err, o_prot)?;
            o_prot.write_message_end()?;
            o_prot.flush()
          },
        }
      },
    }
  }
  pub fn process_create_namespace<H: THBaseServiceSyncHandler>(handler: &H, incoming_sequence_number: i32, i_prot: &mut dyn TInputProtocol, o_prot: &mut dyn TOutputProtocol) -> thrift::Result<()> {
    let args = THBaseServiceCreateNamespaceArgs::read_from_in_protocol(i_prot)?;
    match handler.handle_create_namespace(args.namespace_desc) {
      Ok(_) => {
        let message_ident = TMessageIdentifier::new("createNamespace", TMessageType::Reply, incoming_sequence_number);
        o_prot.write_message_begin(&message_ident)?;
        let ret = THBaseServiceCreateNamespaceResult { io: None };
        ret.write_to_out_protocol(o_prot)?;
        o_prot.write_message_end()?;
        o_prot.flush()
      },
      Err(e) => {
        match e {
          thrift::Error::User(usr_err) => {
            if usr_err.downcast_ref::<TIOError>().is_some() {
              let err = usr_err.downcast::<TIOError>().expect("downcast already checked");
              let ret_err = THBaseServiceCreateNamespaceResult{ io: Some(*err) };
              let message_ident = TMessageIdentifier::new("createNamespace", TMessageType::Reply, incoming_sequence_number);
              o_prot.write_message_begin(&message_ident)?;
              ret_err.write_to_out_protocol(o_prot)?;
              o_prot.write_message_end()?;
              o_prot.flush()
            } else {
              let ret_err = {
                ApplicationError::new(
                  ApplicationErrorKind::Unknown,
                  usr_err.to_string()
                )
              };
              let message_ident = TMessageIdentifier::new("createNamespace", TMessageType::Exception, incoming_sequence_number);
              o_prot.write_message_begin(&message_ident)?;
              thrift::Error::write_application_error_to_out_protocol(&ret_err, o_prot)?;
              o_prot.write_message_end()?;
              o_prot.flush()
            }
          },
          thrift::Error::Application(app_err) => {
            let message_ident = TMessageIdentifier::new("createNamespace", TMessageType::Exception, incoming_sequence_number);
            o_prot.write_message_begin(&message_ident)?;
            thrift::Error::write_application_error_to_out_protocol(&app_err, o_prot)?;
            o_prot.write_message_end()?;
            o_prot.flush()
          },
          _ => {
            let ret_err = {
              ApplicationError::new(
                ApplicationErrorKind::Unknown,
                e.to_string()
              )
            };
            let message_ident = TMessageIdentifier::new("createNamespace", TMessageType::Exception, incoming_sequence_number);
            o_prot.write_message_begin(&message_ident)?;
            thrift::Error::write_application_error_to_out_protocol(&ret_err, o_prot)?;
            o_prot.write_message_end()?;
            o_prot.flush()
          },
        }
      },
    }
  }
  pub fn process_modify_namespace<H: THBaseServiceSyncHandler>(handler: &H, incoming_sequence_number: i32, i_prot: &mut dyn TInputProtocol, o_prot: &mut dyn TOutputProtocol) -> thrift::Result<()> {
    let args = THBaseServiceModifyNamespaceArgs::read_from_in_protocol(i_prot)?;
    match handler.handle_modify_namespace(args.namespace_desc) {
      Ok(_) => {
        let message_ident = TMessageIdentifier::new("modifyNamespace", TMessageType::Reply, incoming_sequence_number);
        o_prot.write_message_begin(&message_ident)?;
        let ret = THBaseServiceModifyNamespaceResult { io: None };
        ret.write_to_out_protocol(o_prot)?;
        o_prot.write_message_end()?;
        o_prot.flush()
      },
      Err(e) => {
        match e {
          thrift::Error::User(usr_err) => {
            if usr_err.downcast_ref::<TIOError>().is_some() {
              let err = usr_err.downcast::<TIOError>().expect("downcast already checked");
              let ret_err = THBaseServiceModifyNamespaceResult{ io: Some(*err) };
              let message_ident = TMessageIdentifier::new("modifyNamespace", TMessageType::Reply, incoming_sequence_number);
              o_prot.write_message_begin(&message_ident)?;
              ret_err.write_to_out_protocol(o_prot)?;
              o_prot.write_message_end()?;
              o_prot.flush()
            } else {
              let ret_err = {
                ApplicationError::new(
                  ApplicationErrorKind::Unknown,
                  usr_err.to_string()
                )
              };
              let message_ident = TMessageIdentifier::new("modifyNamespace", TMessageType::Exception, incoming_sequence_number);
              o_prot.write_message_begin(&message_ident)?;
              thrift::Error::write_application_error_to_out_protocol(&ret_err, o_prot)?;
              o_prot.write_message_end()?;
              o_prot.flush()
            }
          },
          thrift::Error::Application(app_err) => {
            let message_ident = TMessageIdentifier::new("modifyNamespace", TMessageType::Exception, incoming_sequence_number);
            o_prot.write_message_begin(&message_ident)?;
            thrift::Error::write_application_error_to_out_protocol(&app_err, o_prot)?;
            o_prot.write_message_end()?;
            o_prot.flush()
          },
          _ => {
            let ret_err = {
              ApplicationError::new(
                ApplicationErrorKind::Unknown,
                e.to_string()
              )
            };
            let message_ident = TMessageIdentifier::new("modifyNamespace", TMessageType::Exception, incoming_sequence_number);
            o_prot.write_message_begin(&message_ident)?;
            thrift::Error::write_application_error_to_out_protocol(&ret_err, o_prot)?;
            o_prot.write_message_end()?;
            o_prot.flush()
          },
        }
      },
    }
  }
  pub fn process_delete_namespace<H: THBaseServiceSyncHandler>(handler: &H, incoming_sequence_number: i32, i_prot: &mut dyn TInputProtocol, o_prot: &mut dyn TOutputProtocol) -> thrift::Result<()> {
    let args = THBaseServiceDeleteNamespaceArgs::read_from_in_protocol(i_prot)?;
    match handler.handle_delete_namespace(args.name) {
      Ok(_) => {
        let message_ident = TMessageIdentifier::new("deleteNamespace", TMessageType::Reply, incoming_sequence_number);
        o_prot.write_message_begin(&message_ident)?;
        let ret = THBaseServiceDeleteNamespaceResult { io: None };
        ret.write_to_out_protocol(o_prot)?;
        o_prot.write_message_end()?;
        o_prot.flush()
      },
      Err(e) => {
        match e {
          thrift::Error::User(usr_err) => {
            if usr_err.downcast_ref::<TIOError>().is_some() {
              let err = usr_err.downcast::<TIOError>().expect("downcast already checked");
              let ret_err = THBaseServiceDeleteNamespaceResult{ io: Some(*err) };
              let message_ident = TMessageIdentifier::new("deleteNamespace", TMessageType::Reply, incoming_sequence_number);
              o_prot.write_message_begin(&message_ident)?;
              ret_err.write_to_out_protocol(o_prot)?;
              o_prot.write_message_end()?;
              o_prot.flush()
            } else {
              let ret_err = {
                ApplicationError::new(
                  ApplicationErrorKind::Unknown,
                  usr_err.to_string()
                )
              };
              let message_ident = TMessageIdentifier::new("deleteNamespace", TMessageType::Exception, incoming_sequence_number);
              o_prot.write_message_begin(&message_ident)?;
              thrift::Error::write_application_error_to_out_protocol(&ret_err, o_prot)?;
              o_prot.write_message_end()?;
              o_prot.flush()
            }
          },
          thrift::Error::Application(app_err) => {
            let message_ident = TMessageIdentifier::new("deleteNamespace", TMessageType::Exception, incoming_sequence_number);
            o_prot.write_message_begin(&message_ident)?;
            thrift::Error::write_application_error_to_out_protocol(&app_err, o_prot)?;
            o_prot.write_message_end()?;
            o_prot.flush()
          },
          _ => {
            let ret_err = {
              ApplicationError::new(
                ApplicationErrorKind::Unknown,
                e.to_string()
              )
            };
            let message_ident = TMessageIdentifier::new("deleteNamespace", TMessageType::Exception, incoming_sequence_number);
            o_prot.write_message_begin(&message_ident)?;
            thrift::Error::write_application_error_to_out_protocol(&ret_err, o_prot)?;
            o_prot.write_message_end()?;
            o_prot.flush()
          },
        }
      },
    }
  }
  pub fn process_get_namespace_descriptor<H: THBaseServiceSyncHandler>(handler: &H, incoming_sequence_number: i32, i_prot: &mut dyn TInputProtocol, o_prot: &mut dyn TOutputProtocol) -> thrift::Result<()> {
    let args = THBaseServiceGetNamespaceDescriptorArgs::read_from_in_protocol(i_prot)?;
    match handler.handle_get_namespace_descriptor(args.name) {
      Ok(handler_return) => {
        let message_ident = TMessageIdentifier::new("getNamespaceDescriptor", TMessageType::Reply, incoming_sequence_number);
        o_prot.write_message_begin(&message_ident)?;
        let ret = THBaseServiceGetNamespaceDescriptorResult { result_value: Some(handler_return), io: None };
        ret.write_to_out_protocol(o_prot)?;
        o_prot.write_message_end()?;
        o_prot.flush()
      },
      Err(e) => {
        match e {
          thrift::Error::User(usr_err) => {
            if usr_err.downcast_ref::<TIOError>().is_some() {
              let err = usr_err.downcast::<TIOError>().expect("downcast already checked");
              let ret_err = THBaseServiceGetNamespaceDescriptorResult{ result_value: None, io: Some(*err) };
              let message_ident = TMessageIdentifier::new("getNamespaceDescriptor", TMessageType::Reply, incoming_sequence_number);
              o_prot.write_message_begin(&message_ident)?;
              ret_err.write_to_out_protocol(o_prot)?;
              o_prot.write_message_end()?;
              o_prot.flush()
            } else {
              let ret_err = {
                ApplicationError::new(
                  ApplicationErrorKind::Unknown,
                  usr_err.to_string()
                )
              };
              let message_ident = TMessageIdentifier::new("getNamespaceDescriptor", TMessageType::Exception, incoming_sequence_number);
              o_prot.write_message_begin(&message_ident)?;
              thrift::Error::write_application_error_to_out_protocol(&ret_err, o_prot)?;
              o_prot.write_message_end()?;
              o_prot.flush()
            }
          },
          thrift::Error::Application(app_err) => {
            let message_ident = TMessageIdentifier::new("getNamespaceDescriptor", TMessageType::Exception, incoming_sequence_number);
            o_prot.write_message_begin(&message_ident)?;
            thrift::Error::write_application_error_to_out_protocol(&app_err, o_prot)?;
            o_prot.write_message_end()?;
            o_prot.flush()
          },
          _ => {
            let ret_err = {
              ApplicationError::new(
                ApplicationErrorKind::Unknown,
                e.to_string()
              )
            };
            let message_ident = TMessageIdentifier::new("getNamespaceDescriptor", TMessageType::Exception, incoming_sequence_number);
            o_prot.write_message_begin(&message_ident)?;
            thrift::Error::write_application_error_to_out_protocol(&ret_err, o_prot)?;
            o_prot.write_message_end()?;
            o_prot.flush()
          },
        }
      },
    }
  }
  pub fn process_list_namespace_descriptors<H: THBaseServiceSyncHandler>(handler: &H, incoming_sequence_number: i32, i_prot: &mut dyn TInputProtocol, o_prot: &mut dyn TOutputProtocol) -> thrift::Result<()> {
    let _ = THBaseServiceListNamespaceDescriptorsArgs::read_from_in_protocol(i_prot)?;
    match handler.handle_list_namespace_descriptors() {
      Ok(handler_return) => {
        let message_ident = TMessageIdentifier::new("listNamespaceDescriptors", TMessageType::Reply, incoming_sequence_number);
        o_prot.write_message_begin(&message_ident)?;
        let ret = THBaseServiceListNamespaceDescriptorsResult { result_value: Some(handler_return), io: None };
        ret.write_to_out_protocol(o_prot)?;
        o_prot.write_message_end()?;
        o_prot.flush()
      },
      Err(e) => {
        match e {
          thrift::Error::User(usr_err) => {
            if usr_err.downcast_ref::<TIOError>().is_some() {
              let err = usr_err.downcast::<TIOError>().expect("downcast already checked");
              let ret_err = THBaseServiceListNamespaceDescriptorsResult{ result_value: None, io: Some(*err) };
              let message_ident = TMessageIdentifier::new("listNamespaceDescriptors", TMessageType::Reply, incoming_sequence_number);
              o_prot.write_message_begin(&message_ident)?;
              ret_err.write_to_out_protocol(o_prot)?;
              o_prot.write_message_end()?;
              o_prot.flush()
            } else {
              let ret_err = {
                ApplicationError::new(
                  ApplicationErrorKind::Unknown,
                  usr_err.to_string()
                )
              };
              let message_ident = TMessageIdentifier::new("listNamespaceDescriptors", TMessageType::Exception, incoming_sequence_number);
              o_prot.write_message_begin(&message_ident)?;
              thrift::Error::write_application_error_to_out_protocol(&ret_err, o_prot)?;
              o_prot.write_message_end()?;
              o_prot.flush()
            }
          },
          thrift::Error::Application(app_err) => {
            let message_ident = TMessageIdentifier::new("listNamespaceDescriptors", TMessageType::Exception, incoming_sequence_number);
            o_prot.write_message_begin(&message_ident)?;
            thrift::Error::write_application_error_to_out_protocol(&app_err, o_prot)?;
            o_prot.write_message_end()?;
            o_prot.flush()
          },
          _ => {
            let ret_err = {
              ApplicationError::new(
                ApplicationErrorKind::Unknown,
                e.to_string()
              )
            };
            let message_ident = TMessageIdentifier::new("listNamespaceDescriptors", TMessageType::Exception, incoming_sequence_number);
            o_prot.write_message_begin(&message_ident)?;
            thrift::Error::write_application_error_to_out_protocol(&ret_err, o_prot)?;
            o_prot.write_message_end()?;
            o_prot.flush()
          },
        }
      },
    }
  }
  pub fn process_list_namespaces<H: THBaseServiceSyncHandler>(handler: &H, incoming_sequence_number: i32, i_prot: &mut dyn TInputProtocol, o_prot: &mut dyn TOutputProtocol) -> thrift::Result<()> {
    let _ = THBaseServiceListNamespacesArgs::read_from_in_protocol(i_prot)?;
    match handler.handle_list_namespaces() {
      Ok(handler_return) => {
        let message_ident = TMessageIdentifier::new("listNamespaces", TMessageType::Reply, incoming_sequence_number);
        o_prot.write_message_begin(&message_ident)?;
        let ret = THBaseServiceListNamespacesResult { result_value: Some(handler_return), io: None };
        ret.write_to_out_protocol(o_prot)?;
        o_prot.write_message_end()?;
        o_prot.flush()
      },
      Err(e) => {
        match e {
          thrift::Error::User(usr_err) => {
            if usr_err.downcast_ref::<TIOError>().is_some() {
              let err = usr_err.downcast::<TIOError>().expect("downcast already checked");
              let ret_err = THBaseServiceListNamespacesResult{ result_value: None, io: Some(*err) };
              let message_ident = TMessageIdentifier::new("listNamespaces", TMessageType::Reply, incoming_sequence_number);
              o_prot.write_message_begin(&message_ident)?;
              ret_err.write_to_out_protocol(o_prot)?;
              o_prot.write_message_end()?;
              o_prot.flush()
            } else {
              let ret_err = {
                ApplicationError::new(
                  ApplicationErrorKind::Unknown,
                  usr_err.to_string()
                )
              };
              let message_ident = TMessageIdentifier::new("listNamespaces", TMessageType::Exception, incoming_sequence_number);
              o_prot.write_message_begin(&message_ident)?;
              thrift::Error::write_application_error_to_out_protocol(&ret_err, o_prot)?;
              o_prot.write_message_end()?;
              o_prot.flush()
            }
          },
          thrift::Error::Application(app_err) => {
            let message_ident = TMessageIdentifier::new("listNamespaces", TMessageType::Exception, incoming_sequence_number);
            o_prot.write_message_begin(&message_ident)?;
            thrift::Error::write_application_error_to_out_protocol(&app_err, o_prot)?;
            o_prot.write_message_end()?;
            o_prot.flush()
          },
          _ => {
            let ret_err = {
              ApplicationError::new(
                ApplicationErrorKind::Unknown,
                e.to_string()
              )
            };
            let message_ident = TMessageIdentifier::new("listNamespaces", TMessageType::Exception, incoming_sequence_number);
            o_prot.write_message_begin(&message_ident)?;
            thrift::Error::write_application_error_to_out_protocol(&ret_err, o_prot)?;
            o_prot.write_message_end()?;
            o_prot.flush()
          },
        }
      },
    }
  }
  pub fn process_get_thrift_server_type<H: THBaseServiceSyncHandler>(handler: &H, incoming_sequence_number: i32, i_prot: &mut dyn TInputProtocol, o_prot: &mut dyn TOutputProtocol) -> thrift::Result<()> {
    let _ = THBaseServiceGetThriftServerTypeArgs::read_from_in_protocol(i_prot)?;
    match handler.handle_get_thrift_server_type() {
      Ok(handler_return) => {
        let message_ident = TMessageIdentifier::new("getThriftServerType", TMessageType::Reply, incoming_sequence_number);
        o_prot.write_message_begin(&message_ident)?;
        let ret = THBaseServiceGetThriftServerTypeResult { result_value: Some(handler_return) };
        ret.write_to_out_protocol(o_prot)?;
        o_prot.write_message_end()?;
        o_prot.flush()
      },
      Err(e) => {
        match e {
          thrift::Error::Application(app_err) => {
            let message_ident = TMessageIdentifier::new("getThriftServerType", TMessageType::Exception, incoming_sequence_number);
            o_prot.write_message_begin(&message_ident)?;
            thrift::Error::write_application_error_to_out_protocol(&app_err, o_prot)?;
            o_prot.write_message_end()?;
            o_prot.flush()
          },
          _ => {
            let ret_err = {
              ApplicationError::new(
                ApplicationErrorKind::Unknown,
                e.to_string()
              )
            };
            let message_ident = TMessageIdentifier::new("getThriftServerType", TMessageType::Exception, incoming_sequence_number);
            o_prot.write_message_begin(&message_ident)?;
            thrift::Error::write_application_error_to_out_protocol(&ret_err, o_prot)?;
            o_prot.write_message_end()?;
            o_prot.flush()
          },
        }
      },
    }
  }
  pub fn process_get_cluster_id<H: THBaseServiceSyncHandler>(handler: &H, incoming_sequence_number: i32, i_prot: &mut dyn TInputProtocol, o_prot: &mut dyn TOutputProtocol) -> thrift::Result<()> {
    let _ = THBaseServiceGetClusterIdArgs::read_from_in_protocol(i_prot)?;
    match handler.handle_get_cluster_id() {
      Ok(handler_return) => {
        let message_ident = TMessageIdentifier::new("getClusterId", TMessageType::Reply, incoming_sequence_number);
        o_prot.write_message_begin(&message_ident)?;
        let ret = THBaseServiceGetClusterIdResult { result_value: Some(handler_return) };
        ret.write_to_out_protocol(o_prot)?;
        o_prot.write_message_end()?;
        o_prot.flush()
      },
      Err(e) => {
        match e {
          thrift::Error::Application(app_err) => {
            let message_ident = TMessageIdentifier::new("getClusterId", TMessageType::Exception, incoming_sequence_number);
            o_prot.write_message_begin(&message_ident)?;
            thrift::Error::write_application_error_to_out_protocol(&app_err, o_prot)?;
            o_prot.write_message_end()?;
            o_prot.flush()
          },
          _ => {
            let ret_err = {
              ApplicationError::new(
                ApplicationErrorKind::Unknown,
                e.to_string()
              )
            };
            let message_ident = TMessageIdentifier::new("getClusterId", TMessageType::Exception, incoming_sequence_number);
            o_prot.write_message_begin(&message_ident)?;
            thrift::Error::write_application_error_to_out_protocol(&ret_err, o_prot)?;
            o_prot.write_message_end()?;
            o_prot.flush()
          },
        }
      },
    }
  }
  pub fn process_get_slow_log_responses<H: THBaseServiceSyncHandler>(handler: &H, incoming_sequence_number: i32, i_prot: &mut dyn TInputProtocol, o_prot: &mut dyn TOutputProtocol) -> thrift::Result<()> {
    let args = THBaseServiceGetSlowLogResponsesArgs::read_from_in_protocol(i_prot)?;
    match handler.handle_get_slow_log_responses(args.server_names, args.log_query_filter) {
      Ok(handler_return) => {
        let message_ident = TMessageIdentifier::new("getSlowLogResponses", TMessageType::Reply, incoming_sequence_number);
        o_prot.write_message_begin(&message_ident)?;
        let ret = THBaseServiceGetSlowLogResponsesResult { result_value: Some(handler_return), io: None };
        ret.write_to_out_protocol(o_prot)?;
        o_prot.write_message_end()?;
        o_prot.flush()
      },
      Err(e) => {
        match e {
          thrift::Error::User(usr_err) => {
            if usr_err.downcast_ref::<TIOError>().is_some() {
              let err = usr_err.downcast::<TIOError>().expect("downcast already checked");
              let ret_err = THBaseServiceGetSlowLogResponsesResult{ result_value: None, io: Some(*err) };
              let message_ident = TMessageIdentifier::new("getSlowLogResponses", TMessageType::Reply, incoming_sequence_number);
              o_prot.write_message_begin(&message_ident)?;
              ret_err.write_to_out_protocol(o_prot)?;
              o_prot.write_message_end()?;
              o_prot.flush()
            } else {
              let ret_err = {
                ApplicationError::new(
                  ApplicationErrorKind::Unknown,
                  usr_err.to_string()
                )
              };
              let message_ident = TMessageIdentifier::new("getSlowLogResponses", TMessageType::Exception, incoming_sequence_number);
              o_prot.write_message_begin(&message_ident)?;
              thrift::Error::write_application_error_to_out_protocol(&ret_err, o_prot)?;
              o_prot.write_message_end()?;
              o_prot.flush()
            }
          },
          thrift::Error::Application(app_err) => {
            let message_ident = TMessageIdentifier::new("getSlowLogResponses", TMessageType::Exception, incoming_sequence_number);
            o_prot.write_message_begin(&message_ident)?;
            thrift::Error::write_application_error_to_out_protocol(&app_err, o_prot)?;
            o_prot.write_message_end()?;
            o_prot.flush()
          },
          _ => {
            let ret_err = {
              ApplicationError::new(
                ApplicationErrorKind::Unknown,
                e.to_string()
              )
            };
            let message_ident = TMessageIdentifier::new("getSlowLogResponses", TMessageType::Exception, incoming_sequence_number);
            o_prot.write_message_begin(&message_ident)?;
            thrift::Error::write_application_error_to_out_protocol(&ret_err, o_prot)?;
            o_prot.write_message_end()?;
            o_prot.flush()
          },
        }
      },
    }
  }
  pub fn process_clear_slow_log_responses<H: THBaseServiceSyncHandler>(handler: &H, incoming_sequence_number: i32, i_prot: &mut dyn TInputProtocol, o_prot: &mut dyn TOutputProtocol) -> thrift::Result<()> {
    let args = THBaseServiceClearSlowLogResponsesArgs::read_from_in_protocol(i_prot)?;
    match handler.handle_clear_slow_log_responses(args.server_names) {
      Ok(handler_return) => {
        let message_ident = TMessageIdentifier::new("clearSlowLogResponses", TMessageType::Reply, incoming_sequence_number);
        o_prot.write_message_begin(&message_ident)?;
        let ret = THBaseServiceClearSlowLogResponsesResult { result_value: Some(handler_return), io: None };
        ret.write_to_out_protocol(o_prot)?;
        o_prot.write_message_end()?;
        o_prot.flush()
      },
      Err(e) => {
        match e {
          thrift::Error::User(usr_err) => {
            if usr_err.downcast_ref::<TIOError>().is_some() {
              let err = usr_err.downcast::<TIOError>().expect("downcast already checked");
              let ret_err = THBaseServiceClearSlowLogResponsesResult{ result_value: None, io: Some(*err) };
              let message_ident = TMessageIdentifier::new("clearSlowLogResponses", TMessageType::Reply, incoming_sequence_number);
              o_prot.write_message_begin(&message_ident)?;
              ret_err.write_to_out_protocol(o_prot)?;
              o_prot.write_message_end()?;
              o_prot.flush()
            } else {
              let ret_err = {
                ApplicationError::new(
                  ApplicationErrorKind::Unknown,
                  usr_err.to_string()
                )
              };
              let message_ident = TMessageIdentifier::new("clearSlowLogResponses", TMessageType::Exception, incoming_sequence_number);
              o_prot.write_message_begin(&message_ident)?;
              thrift::Error::write_application_error_to_out_protocol(&ret_err, o_prot)?;
              o_prot.write_message_end()?;
              o_prot.flush()
            }
          },
          thrift::Error::Application(app_err) => {
            let message_ident = TMessageIdentifier::new("clearSlowLogResponses", TMessageType::Exception, incoming_sequence_number);
            o_prot.write_message_begin(&message_ident)?;
            thrift::Error::write_application_error_to_out_protocol(&app_err, o_prot)?;
            o_prot.write_message_end()?;
            o_prot.flush()
          },
          _ => {
            let ret_err = {
              ApplicationError::new(
                ApplicationErrorKind::Unknown,
                e.to_string()
              )
            };
            let message_ident = TMessageIdentifier::new("clearSlowLogResponses", TMessageType::Exception, incoming_sequence_number);
            o_prot.write_message_begin(&message_ident)?;
            thrift::Error::write_application_error_to_out_protocol(&ret_err, o_prot)?;
            o_prot.write_message_end()?;
            o_prot.flush()
          },
        }
      },
    }
  }
  pub fn process_grant<H: THBaseServiceSyncHandler>(handler: &H, incoming_sequence_number: i32, i_prot: &mut dyn TInputProtocol, o_prot: &mut dyn TOutputProtocol) -> thrift::Result<()> {
    let args = THBaseServiceGrantArgs::read_from_in_protocol(i_prot)?;
    match handler.handle_grant(args.info) {
      Ok(handler_return) => {
        let message_ident = TMessageIdentifier::new("grant", TMessageType::Reply, incoming_sequence_number);
        o_prot.write_message_begin(&message_ident)?;
        let ret = THBaseServiceGrantResult { result_value: Some(handler_return), io: None };
        ret.write_to_out_protocol(o_prot)?;
        o_prot.write_message_end()?;
        o_prot.flush()
      },
      Err(e) => {
        match e {
          thrift::Error::User(usr_err) => {
            if usr_err.downcast_ref::<TIOError>().is_some() {
              let err = usr_err.downcast::<TIOError>().expect("downcast already checked");
              let ret_err = THBaseServiceGrantResult{ result_value: None, io: Some(*err) };
              let message_ident = TMessageIdentifier::new("grant", TMessageType::Reply, incoming_sequence_number);
              o_prot.write_message_begin(&message_ident)?;
              ret_err.write_to_out_protocol(o_prot)?;
              o_prot.write_message_end()?;
              o_prot.flush()
            } else {
              let ret_err = {
                ApplicationError::new(
                  ApplicationErrorKind::Unknown,
                  usr_err.to_string()
                )
              };
              let message_ident = TMessageIdentifier::new("grant", TMessageType::Exception, incoming_sequence_number);
              o_prot.write_message_begin(&message_ident)?;
              thrift::Error::write_application_error_to_out_protocol(&ret_err, o_prot)?;
              o_prot.write_message_end()?;
              o_prot.flush()
            }
          },
          thrift::Error::Application(app_err) => {
            let message_ident = TMessageIdentifier::new("grant", TMessageType::Exception, incoming_sequence_number);
            o_prot.write_message_begin(&message_ident)?;
            thrift::Error::write_application_error_to_out_protocol(&app_err, o_prot)?;
            o_prot.write_message_end()?;
            o_prot.flush()
          },
          _ => {
            let ret_err = {
              ApplicationError::new(
                ApplicationErrorKind::Unknown,
                e.to_string()
              )
            };
            let message_ident = TMessageIdentifier::new("grant", TMessageType::Exception, incoming_sequence_number);
            o_prot.write_message_begin(&message_ident)?;
            thrift::Error::write_application_error_to_out_protocol(&ret_err, o_prot)?;
            o_prot.write_message_end()?;
            o_prot.flush()
          },
        }
      },
    }
  }
  pub fn process_revoke<H: THBaseServiceSyncHandler>(handler: &H, incoming_sequence_number: i32, i_prot: &mut dyn TInputProtocol, o_prot: &mut dyn TOutputProtocol) -> thrift::Result<()> {
    let args = THBaseServiceRevokeArgs::read_from_in_protocol(i_prot)?;
    match handler.handle_revoke(args.info) {
      Ok(handler_return) => {
        let message_ident = TMessageIdentifier::new("revoke", TMessageType::Reply, incoming_sequence_number);
        o_prot.write_message_begin(&message_ident)?;
        let ret = THBaseServiceRevokeResult { result_value: Some(handler_return), io: None };
        ret.write_to_out_protocol(o_prot)?;
        o_prot.write_message_end()?;
        o_prot.flush()
      },
      Err(e) => {
        match e {
          thrift::Error::User(usr_err) => {
            if usr_err.downcast_ref::<TIOError>().is_some() {
              let err = usr_err.downcast::<TIOError>().expect("downcast already checked");
              let ret_err = THBaseServiceRevokeResult{ result_value: None, io: Some(*err) };
              let message_ident = TMessageIdentifier::new("revoke", TMessageType::Reply, incoming_sequence_number);
              o_prot.write_message_begin(&message_ident)?;
              ret_err.write_to_out_protocol(o_prot)?;
              o_prot.write_message_end()?;
              o_prot.flush()
            } else {
              let ret_err = {
                ApplicationError::new(
                  ApplicationErrorKind::Unknown,
                  usr_err.to_string()
                )
              };
              let message_ident = TMessageIdentifier::new("revoke", TMessageType::Exception, incoming_sequence_number);
              o_prot.write_message_begin(&message_ident)?;
              thrift::Error::write_application_error_to_out_protocol(&ret_err, o_prot)?;
              o_prot.write_message_end()?;
              o_prot.flush()
            }
          },
          thrift::Error::Application(app_err) => {
            let message_ident = TMessageIdentifier::new("revoke", TMessageType::Exception, incoming_sequence_number);
            o_prot.write_message_begin(&message_ident)?;
            thrift::Error::write_application_error_to_out_protocol(&app_err, o_prot)?;
            o_prot.write_message_end()?;
            o_prot.flush()
          },
          _ => {
            let ret_err = {
              ApplicationError::new(
                ApplicationErrorKind::Unknown,
                e.to_string()
              )
            };
            let message_ident = TMessageIdentifier::new("revoke", TMessageType::Exception, incoming_sequence_number);
            o_prot.write_message_begin(&message_ident)?;
            thrift::Error::write_application_error_to_out_protocol(&ret_err, o_prot)?;
            o_prot.write_message_end()?;
            o_prot.flush()
          },
        }
      },
    }
  }
}

impl <H: THBaseServiceSyncHandler> TProcessor for THBaseServiceSyncProcessor<H> {
  fn process(&self, i_prot: &mut dyn TInputProtocol, o_prot: &mut dyn TOutputProtocol) -> thrift::Result<()> {
    let message_ident = i_prot.read_message_begin()?;
    let res = match &*message_ident.name {
      "exists" => {
        self.process_exists(message_ident.sequence_number, i_prot, o_prot)
      },
      "existsAll" => {
        self.process_exists_all(message_ident.sequence_number, i_prot, o_prot)
      },
      "get" => {
        self.process_get(message_ident.sequence_number, i_prot, o_prot)
      },
      "getMultiple" => {
        self.process_get_multiple(message_ident.sequence_number, i_prot, o_prot)
      },
      "put" => {
        self.process_put(message_ident.sequence_number, i_prot, o_prot)
      },
      "checkAndPut" => {
        self.process_check_and_put(message_ident.sequence_number, i_prot, o_prot)
      },
      "putMultiple" => {
        self.process_put_multiple(message_ident.sequence_number, i_prot, o_prot)
      },
      "deleteSingle" => {
        self.process_delete_single(message_ident.sequence_number, i_prot, o_prot)
      },
      "deleteMultiple" => {
        self.process_delete_multiple(message_ident.sequence_number, i_prot, o_prot)
      },
      "checkAndDelete" => {
        self.process_check_and_delete(message_ident.sequence_number, i_prot, o_prot)
      },
      "increment" => {
        self.process_increment(message_ident.sequence_number, i_prot, o_prot)
      },
      "append" => {
        self.process_append(message_ident.sequence_number, i_prot, o_prot)
      },
      "openScanner" => {
        self.process_open_scanner(message_ident.sequence_number, i_prot, o_prot)
      },
      "getScannerRows" => {
        self.process_get_scanner_rows(message_ident.sequence_number, i_prot, o_prot)
      },
      "closeScanner" => {
        self.process_close_scanner(message_ident.sequence_number, i_prot, o_prot)
      },
      "mutateRow" => {
        self.process_mutate_row(message_ident.sequence_number, i_prot, o_prot)
      },
      "getScannerResults" => {
        self.process_get_scanner_results(message_ident.sequence_number, i_prot, o_prot)
      },
      "getRegionLocation" => {
        self.process_get_region_location(message_ident.sequence_number, i_prot, o_prot)
      },
      "getAllRegionLocations" => {
        self.process_get_all_region_locations(message_ident.sequence_number, i_prot, o_prot)
      },
      "checkAndMutate" => {
        self.process_check_and_mutate(message_ident.sequence_number, i_prot, o_prot)
      },
      "getTableDescriptor" => {
        self.process_get_table_descriptor(message_ident.sequence_number, i_prot, o_prot)
      },
      "getTableDescriptors" => {
        self.process_get_table_descriptors(message_ident.sequence_number, i_prot, o_prot)
      },
      "tableExists" => {
        self.process_table_exists(message_ident.sequence_number, i_prot, o_prot)
      },
      "getTableDescriptorsByPattern" => {
        self.process_get_table_descriptors_by_pattern(message_ident.sequence_number, i_prot, o_prot)
      },
      "getTableDescriptorsByNamespace" => {
        self.process_get_table_descriptors_by_namespace(message_ident.sequence_number, i_prot, o_prot)
      },
      "getTableNamesByPattern" => {
        self.process_get_table_names_by_pattern(message_ident.sequence_number, i_prot, o_prot)
      },
      "getTableNamesByNamespace" => {
        self.process_get_table_names_by_namespace(message_ident.sequence_number, i_prot, o_prot)
      },
      "createTable" => {
        self.process_create_table(message_ident.sequence_number, i_prot, o_prot)
      },
      "deleteTable" => {
        self.process_delete_table(message_ident.sequence_number, i_prot, o_prot)
      },
      "truncateTable" => {
        self.process_truncate_table(message_ident.sequence_number, i_prot, o_prot)
      },
      "enableTable" => {
        self.process_enable_table(message_ident.sequence_number, i_prot, o_prot)
      },
      "disableTable" => {
        self.process_disable_table(message_ident.sequence_number, i_prot, o_prot)
      },
      "isTableEnabled" => {
        self.process_is_table_enabled(message_ident.sequence_number, i_prot, o_prot)
      },
      "isTableDisabled" => {
        self.process_is_table_disabled(message_ident.sequence_number, i_prot, o_prot)
      },
      "isTableAvailable" => {
        self.process_is_table_available(message_ident.sequence_number, i_prot, o_prot)
      },
      "isTableAvailableWithSplit" => {
        self.process_is_table_available_with_split(message_ident.sequence_number, i_prot, o_prot)
      },
      "addColumnFamily" => {
        self.process_add_column_family(message_ident.sequence_number, i_prot, o_prot)
      },
      "deleteColumnFamily" => {
        self.process_delete_column_family(message_ident.sequence_number, i_prot, o_prot)
      },
      "modifyColumnFamily" => {
        self.process_modify_column_family(message_ident.sequence_number, i_prot, o_prot)
      },
      "modifyTable" => {
        self.process_modify_table(message_ident.sequence_number, i_prot, o_prot)
      },
      "createNamespace" => {
        self.process_create_namespace(message_ident.sequence_number, i_prot, o_prot)
      },
      "modifyNamespace" => {
        self.process_modify_namespace(message_ident.sequence_number, i_prot, o_prot)
      },
      "deleteNamespace" => {
        self.process_delete_namespace(message_ident.sequence_number, i_prot, o_prot)
      },
      "getNamespaceDescriptor" => {
        self.process_get_namespace_descriptor(message_ident.sequence_number, i_prot, o_prot)
      },
      "listNamespaceDescriptors" => {
        self.process_list_namespace_descriptors(message_ident.sequence_number, i_prot, o_prot)
      },
      "listNamespaces" => {
        self.process_list_namespaces(message_ident.sequence_number, i_prot, o_prot)
      },
      "getThriftServerType" => {
        self.process_get_thrift_server_type(message_ident.sequence_number, i_prot, o_prot)
      },
      "getClusterId" => {
        self.process_get_cluster_id(message_ident.sequence_number, i_prot, o_prot)
      },
      "getSlowLogResponses" => {
        self.process_get_slow_log_responses(message_ident.sequence_number, i_prot, o_prot)
      },
      "clearSlowLogResponses" => {
        self.process_clear_slow_log_responses(message_ident.sequence_number, i_prot, o_prot)
      },
      "grant" => {
        self.process_grant(message_ident.sequence_number, i_prot, o_prot)
      },
      "revoke" => {
        self.process_revoke(message_ident.sequence_number, i_prot, o_prot)
      },
      method => {
        Err(
          thrift::Error::Application(
            ApplicationError::new(
              ApplicationErrorKind::UnknownMethod,
              format!("unknown method {}", method)
            )
          )
        )
      },
    };
    thrift::server::handle_process_result(&message_ident, res, o_prot)
  }
}

//
// THBaseServiceExistsArgs
//

#[derive(Clone, Debug, Eq, Hash, Ord, PartialEq, PartialOrd)]
struct THBaseServiceExistsArgs {
  /// the table to check on
  table: Vec<u8>,
  /// the TGet to check for
  tget: TGet,
}

impl THBaseServiceExistsArgs {
  fn read_from_in_protocol(i_prot: &mut dyn TInputProtocol) -> thrift::Result<THBaseServiceExistsArgs> {
    i_prot.read_struct_begin()?;
    let mut f_1: Option<Vec<u8>> = None;
    let mut f_2: Option<TGet> = None;
    loop {
      let field_ident = i_prot.read_field_begin()?;
      if field_ident.field_type == TType::Stop {
        break;
      }
      let field_id = field_id(&field_ident)?;
      match field_id {
        1 => {
          let val = i_prot.read_bytes()?;
          f_1 = Some(val);
        },
        2 => {
          let val = TGet::read_from_in_protocol(i_prot)?;
          f_2 = Some(val);
        },
        _ => {
          i_prot.skip(field_ident.field_type)?;
        },
      };
      i_prot.read_field_end()?;
    }
    i_prot.read_struct_end()?;
    verify_required_field_exists("THBaseServiceExistsArgs.table", &f_1)?;
    verify_required_field_exists("THBaseServiceExistsArgs.tget", &f_2)?;
    let ret = THBaseServiceExistsArgs {
      table: f_1.expect("auto-generated code should have checked for presence of required fields"),
      tget: f_2.expect("auto-generated code should have checked for presence of required fields"),
    };
    Ok(ret)
  }
  fn write_to_out_protocol(&self, o_prot: &mut dyn TOutputProtocol) -> thrift::Result<()> {
    let struct_ident = TStructIdentifier::new("exists_args");
    o_prot.write_struct_begin(&struct_ident)?;
    o_prot.write_field_begin(&TFieldIdentifier::new("table", TType::String, 1))?;
    o_prot.write_bytes(&self.table)?;
    o_prot.write_field_end()?;
    o_prot.write_field_begin(&TFieldIdentifier::new("tget", TType::Struct, 2))?;
    self.tget.write_to_out_protocol(o_prot)?;
    o_prot.write_field_end()?;
    o_prot.write_field_stop()?;
    o_prot.write_struct_end()
  }
}

//
// THBaseServiceExistsResult
//

#[derive(Clone, Debug, Eq, Hash, Ord, PartialEq, PartialOrd)]
struct THBaseServiceExistsResult {
  result_value: Option<bool>,
  io: Option<TIOError>,
}

impl THBaseServiceExistsResult {
  fn read_from_in_protocol(i_prot: &mut dyn TInputProtocol) -> thrift::Result<THBaseServiceExistsResult> {
    i_prot.read_struct_begin()?;
    let mut f_0: Option<bool> = None;
    let mut f_1: Option<TIOError> = None;
    loop {
      let field_ident = i_prot.read_field_begin()?;
      if field_ident.field_type == TType::Stop {
        break;
      }
      let field_id = field_id(&field_ident)?;
      match field_id {
        0 => {
          let val = i_prot.read_bool()?;
          f_0 = Some(val);
        },
        1 => {
          let val = TIOError::read_from_in_protocol(i_prot)?;
          f_1 = Some(val);
        },
        _ => {
          i_prot.skip(field_ident.field_type)?;
        },
      };
      i_prot.read_field_end()?;
    }
    i_prot.read_struct_end()?;
    let ret = THBaseServiceExistsResult {
      result_value: f_0,
      io: f_1,
    };
    Ok(ret)
  }
  fn write_to_out_protocol(&self, o_prot: &mut dyn TOutputProtocol) -> thrift::Result<()> {
    let struct_ident = TStructIdentifier::new("THBaseServiceExistsResult");
    o_prot.write_struct_begin(&struct_ident)?;
    if let Some(fld_var) = self.result_value {
      o_prot.write_field_begin(&TFieldIdentifier::new("result_value", TType::Bool, 0))?;
      o_prot.write_bool(fld_var)?;
      o_prot.write_field_end()?
    }
    if let Some(ref fld_var) = self.io {
      o_prot.write_field_begin(&TFieldIdentifier::new("io", TType::Struct, 1))?;
      fld_var.write_to_out_protocol(o_prot)?;
      o_prot.write_field_end()?
    }
    o_prot.write_field_stop()?;
    o_prot.write_struct_end()
  }
  fn ok_or(self) -> thrift::Result<bool> {
    if self.io.is_some() {
      Err(thrift::Error::User(Box::new(self.io.unwrap())))
    } else if self.result_value.is_some() {
      Ok(self.result_value.unwrap())
    } else {
      Err(
        thrift::Error::Application(
          ApplicationError::new(
            ApplicationErrorKind::MissingResult,
            "no result received for THBaseServiceExists"
          )
        )
      )
    }
  }
}

//
// THBaseServiceExistsAllArgs
//

#[derive(Clone, Debug, Eq, Hash, Ord, PartialEq, PartialOrd)]
struct THBaseServiceExistsAllArgs {
  /// the table to check on
  table: Vec<u8>,
  /// a list of TGets to check for
  tgets: Vec<TGet>,
}

impl THBaseServiceExistsAllArgs {
  fn read_from_in_protocol(i_prot: &mut dyn TInputProtocol) -> thrift::Result<THBaseServiceExistsAllArgs> {
    i_prot.read_struct_begin()?;
    let mut f_1: Option<Vec<u8>> = None;
    let mut f_2: Option<Vec<TGet>> = None;
    loop {
      let field_ident = i_prot.read_field_begin()?;
      if field_ident.field_type == TType::Stop {
        break;
      }
      let field_id = field_id(&field_ident)?;
      match field_id {
        1 => {
          let val = i_prot.read_bytes()?;
          f_1 = Some(val);
        },
        2 => {
          let list_ident = i_prot.read_list_begin()?;
          let mut val: Vec<TGet> = Vec::with_capacity(list_ident.size as usize);
          for _ in 0..list_ident.size {
            let list_elem_32 = TGet::read_from_in_protocol(i_prot)?;
            val.push(list_elem_32);
          }
          i_prot.read_list_end()?;
          f_2 = Some(val);
        },
        _ => {
          i_prot.skip(field_ident.field_type)?;
        },
      };
      i_prot.read_field_end()?;
    }
    i_prot.read_struct_end()?;
    verify_required_field_exists("THBaseServiceExistsAllArgs.table", &f_1)?;
    verify_required_field_exists("THBaseServiceExistsAllArgs.tgets", &f_2)?;
    let ret = THBaseServiceExistsAllArgs {
      table: f_1.expect("auto-generated code should have checked for presence of required fields"),
      tgets: f_2.expect("auto-generated code should have checked for presence of required fields"),
    };
    Ok(ret)
  }
  fn write_to_out_protocol(&self, o_prot: &mut dyn TOutputProtocol) -> thrift::Result<()> {
    let struct_ident = TStructIdentifier::new("existsAll_args");
    o_prot.write_struct_begin(&struct_ident)?;
    o_prot.write_field_begin(&TFieldIdentifier::new("table", TType::String, 1))?;
    o_prot.write_bytes(&self.table)?;
    o_prot.write_field_end()?;
    o_prot.write_field_begin(&TFieldIdentifier::new("tgets", TType::List, 2))?;
    o_prot.write_list_begin(&TListIdentifier::new(TType::Struct, self.tgets.len() as i32))?;
    for e in &self.tgets {
      e.write_to_out_protocol(o_prot)?;
    }
    o_prot.write_list_end()?;
    o_prot.write_field_end()?;
    o_prot.write_field_stop()?;
    o_prot.write_struct_end()
  }
}

//
// THBaseServiceExistsAllResult
//

#[derive(Clone, Debug, Eq, Hash, Ord, PartialEq, PartialOrd)]
struct THBaseServiceExistsAllResult {
  result_value: Option<Vec<bool>>,
  io: Option<TIOError>,
}

impl THBaseServiceExistsAllResult {
  fn read_from_in_protocol(i_prot: &mut dyn TInputProtocol) -> thrift::Result<THBaseServiceExistsAllResult> {
    i_prot.read_struct_begin()?;
    let mut f_0: Option<Vec<bool>> = None;
    let mut f_1: Option<TIOError> = None;
    loop {
      let field_ident = i_prot.read_field_begin()?;
      if field_ident.field_type == TType::Stop {
        break;
      }
      let field_id = field_id(&field_ident)?;
      match field_id {
        0 => {
          let list_ident = i_prot.read_list_begin()?;
          let mut val: Vec<bool> = Vec::with_capacity(list_ident.size as usize);
          for _ in 0..list_ident.size {
            let list_elem_33 = i_prot.read_bool()?;
            val.push(list_elem_33);
          }
          i_prot.read_list_end()?;
          f_0 = Some(val);
        },
        1 => {
          let val = TIOError::read_from_in_protocol(i_prot)?;
          f_1 = Some(val);
        },
        _ => {
          i_prot.skip(field_ident.field_type)?;
        },
      };
      i_prot.read_field_end()?;
    }
    i_prot.read_struct_end()?;
    let ret = THBaseServiceExistsAllResult {
      result_value: f_0,
      io: f_1,
    };
    Ok(ret)
  }
  fn write_to_out_protocol(&self, o_prot: &mut dyn TOutputProtocol) -> thrift::Result<()> {
    let struct_ident = TStructIdentifier::new("THBaseServiceExistsAllResult");
    o_prot.write_struct_begin(&struct_ident)?;
    if let Some(ref fld_var) = self.result_value {
      o_prot.write_field_begin(&TFieldIdentifier::new("result_value", TType::List, 0))?;
      o_prot.write_list_begin(&TListIdentifier::new(TType::Bool, fld_var.len() as i32))?;
      for e in fld_var {
        o_prot.write_bool(*e)?;
      }
      o_prot.write_list_end()?;
      o_prot.write_field_end()?
    }
    if let Some(ref fld_var) = self.io {
      o_prot.write_field_begin(&TFieldIdentifier::new("io", TType::Struct, 1))?;
      fld_var.write_to_out_protocol(o_prot)?;
      o_prot.write_field_end()?
    }
    o_prot.write_field_stop()?;
    o_prot.write_struct_end()
  }
  fn ok_or(self) -> thrift::Result<Vec<bool>> {
    if self.io.is_some() {
      Err(thrift::Error::User(Box::new(self.io.unwrap())))
    } else if self.result_value.is_some() {
      Ok(self.result_value.unwrap())
    } else {
      Err(
        thrift::Error::Application(
          ApplicationError::new(
            ApplicationErrorKind::MissingResult,
            "no result received for THBaseServiceExistsAll"
          )
        )
      )
    }
  }
}

//
// THBaseServiceGetArgs
//

#[derive(Clone, Debug, Eq, Hash, Ord, PartialEq, PartialOrd)]
struct THBaseServiceGetArgs {
  /// the table to get from
  table: Vec<u8>,
  /// the TGet to fetch
  tget: TGet,
}

impl THBaseServiceGetArgs {
  fn read_from_in_protocol(i_prot: &mut dyn TInputProtocol) -> thrift::Result<THBaseServiceGetArgs> {
    i_prot.read_struct_begin()?;
    let mut f_1: Option<Vec<u8>> = None;
    let mut f_2: Option<TGet> = None;
    loop {
      let field_ident = i_prot.read_field_begin()?;
      if field_ident.field_type == TType::Stop {
        break;
      }
      let field_id = field_id(&field_ident)?;
      match field_id {
        1 => {
          let val = i_prot.read_bytes()?;
          f_1 = Some(val);
        },
        2 => {
          let val = TGet::read_from_in_protocol(i_prot)?;
          f_2 = Some(val);
        },
        _ => {
          i_prot.skip(field_ident.field_type)?;
        },
      };
      i_prot.read_field_end()?;
    }
    i_prot.read_struct_end()?;
    verify_required_field_exists("THBaseServiceGetArgs.table", &f_1)?;
    verify_required_field_exists("THBaseServiceGetArgs.tget", &f_2)?;
    let ret = THBaseServiceGetArgs {
      table: f_1.expect("auto-generated code should have checked for presence of required fields"),
      tget: f_2.expect("auto-generated code should have checked for presence of required fields"),
    };
    Ok(ret)
  }
  fn write_to_out_protocol(&self, o_prot: &mut dyn TOutputProtocol) -> thrift::Result<()> {
    let struct_ident = TStructIdentifier::new("get_args");
    o_prot.write_struct_begin(&struct_ident)?;
    o_prot.write_field_begin(&TFieldIdentifier::new("table", TType::String, 1))?;
    o_prot.write_bytes(&self.table)?;
    o_prot.write_field_end()?;
    o_prot.write_field_begin(&TFieldIdentifier::new("tget", TType::Struct, 2))?;
    self.tget.write_to_out_protocol(o_prot)?;
    o_prot.write_field_end()?;
    o_prot.write_field_stop()?;
    o_prot.write_struct_end()
  }
}

//
// THBaseServiceGetResult
//

#[derive(Clone, Debug, Eq, Hash, Ord, PartialEq, PartialOrd)]
struct THBaseServiceGetResult {
  result_value: Option<TResult>,
  io: Option<TIOError>,
}

impl THBaseServiceGetResult {
  fn read_from_in_protocol(i_prot: &mut dyn TInputProtocol) -> thrift::Result<THBaseServiceGetResult> {
    i_prot.read_struct_begin()?;
    let mut f_0: Option<TResult> = None;
    let mut f_1: Option<TIOError> = None;
    loop {
      let field_ident = i_prot.read_field_begin()?;
      if field_ident.field_type == TType::Stop {
        break;
      }
      let field_id = field_id(&field_ident)?;
      match field_id {
        0 => {
          let val = TResult::read_from_in_protocol(i_prot)?;
          f_0 = Some(val);
        },
        1 => {
          let val = TIOError::read_from_in_protocol(i_prot)?;
          f_1 = Some(val);
        },
        _ => {
          i_prot.skip(field_ident.field_type)?;
        },
      };
      i_prot.read_field_end()?;
    }
    i_prot.read_struct_end()?;
    let ret = THBaseServiceGetResult {
      result_value: f_0,
      io: f_1,
    };
    Ok(ret)
  }
  fn write_to_out_protocol(&self, o_prot: &mut dyn TOutputProtocol) -> thrift::Result<()> {
    let struct_ident = TStructIdentifier::new("THBaseServiceGetResult");
    o_prot.write_struct_begin(&struct_ident)?;
    if let Some(ref fld_var) = self.result_value {
      o_prot.write_field_begin(&TFieldIdentifier::new("result_value", TType::Struct, 0))?;
      fld_var.write_to_out_protocol(o_prot)?;
      o_prot.write_field_end()?
    }
    if let Some(ref fld_var) = self.io {
      o_prot.write_field_begin(&TFieldIdentifier::new("io", TType::Struct, 1))?;
      fld_var.write_to_out_protocol(o_prot)?;
      o_prot.write_field_end()?
    }
    o_prot.write_field_stop()?;
    o_prot.write_struct_end()
  }
  fn ok_or(self) -> thrift::Result<TResult> {
    if self.io.is_some() {
      Err(thrift::Error::User(Box::new(self.io.unwrap())))
    } else if self.result_value.is_some() {
      Ok(self.result_value.unwrap())
    } else {
      Err(
        thrift::Error::Application(
          ApplicationError::new(
            ApplicationErrorKind::MissingResult,
            "no result received for THBaseServiceGet"
          )
        )
      )
    }
  }
}

//
// THBaseServiceGetMultipleArgs
//

#[derive(Clone, Debug, Eq, Hash, Ord, PartialEq, PartialOrd)]
struct THBaseServiceGetMultipleArgs {
  /// the table to get from
  table: Vec<u8>,
  /// a list of TGets to fetch, the Result list
  /// will have the Results at corresponding positions
  /// or null if there was an error
  tgets: Vec<TGet>,
}

impl THBaseServiceGetMultipleArgs {
  fn read_from_in_protocol(i_prot: &mut dyn TInputProtocol) -> thrift::Result<THBaseServiceGetMultipleArgs> {
    i_prot.read_struct_begin()?;
    let mut f_1: Option<Vec<u8>> = None;
    let mut f_2: Option<Vec<TGet>> = None;
    loop {
      let field_ident = i_prot.read_field_begin()?;
      if field_ident.field_type == TType::Stop {
        break;
      }
      let field_id = field_id(&field_ident)?;
      match field_id {
        1 => {
          let val = i_prot.read_bytes()?;
          f_1 = Some(val);
        },
        2 => {
          let list_ident = i_prot.read_list_begin()?;
          let mut val: Vec<TGet> = Vec::with_capacity(list_ident.size as usize);
          for _ in 0..list_ident.size {
            let list_elem_34 = TGet::read_from_in_protocol(i_prot)?;
            val.push(list_elem_34);
          }
          i_prot.read_list_end()?;
          f_2 = Some(val);
        },
        _ => {
          i_prot.skip(field_ident.field_type)?;
        },
      };
      i_prot.read_field_end()?;
    }
    i_prot.read_struct_end()?;
    verify_required_field_exists("THBaseServiceGetMultipleArgs.table", &f_1)?;
    verify_required_field_exists("THBaseServiceGetMultipleArgs.tgets", &f_2)?;
    let ret = THBaseServiceGetMultipleArgs {
      table: f_1.expect("auto-generated code should have checked for presence of required fields"),
      tgets: f_2.expect("auto-generated code should have checked for presence of required fields"),
    };
    Ok(ret)
  }
  fn write_to_out_protocol(&self, o_prot: &mut dyn TOutputProtocol) -> thrift::Result<()> {
    let struct_ident = TStructIdentifier::new("getMultiple_args");
    o_prot.write_struct_begin(&struct_ident)?;
    o_prot.write_field_begin(&TFieldIdentifier::new("table", TType::String, 1))?;
    o_prot.write_bytes(&self.table)?;
    o_prot.write_field_end()?;
    o_prot.write_field_begin(&TFieldIdentifier::new("tgets", TType::List, 2))?;
    o_prot.write_list_begin(&TListIdentifier::new(TType::Struct, self.tgets.len() as i32))?;
    for e in &self.tgets {
      e.write_to_out_protocol(o_prot)?;
    }
    o_prot.write_list_end()?;
    o_prot.write_field_end()?;
    o_prot.write_field_stop()?;
    o_prot.write_struct_end()
  }
}

//
// THBaseServiceGetMultipleResult
//

#[derive(Clone, Debug, Eq, Hash, Ord, PartialEq, PartialOrd)]
struct THBaseServiceGetMultipleResult {
  result_value: Option<Vec<TResult>>,
  io: Option<TIOError>,
}

impl THBaseServiceGetMultipleResult {
  fn read_from_in_protocol(i_prot: &mut dyn TInputProtocol) -> thrift::Result<THBaseServiceGetMultipleResult> {
    i_prot.read_struct_begin()?;
    let mut f_0: Option<Vec<TResult>> = None;
    let mut f_1: Option<TIOError> = None;
    loop {
      let field_ident = i_prot.read_field_begin()?;
      if field_ident.field_type == TType::Stop {
        break;
      }
      let field_id = field_id(&field_ident)?;
      match field_id {
        0 => {
          let list_ident = i_prot.read_list_begin()?;
          let mut val: Vec<TResult> = Vec::with_capacity(list_ident.size as usize);
          for _ in 0..list_ident.size {
            let list_elem_35 = TResult::read_from_in_protocol(i_prot)?;
            val.push(list_elem_35);
          }
          i_prot.read_list_end()?;
          f_0 = Some(val);
        },
        1 => {
          let val = TIOError::read_from_in_protocol(i_prot)?;
          f_1 = Some(val);
        },
        _ => {
          i_prot.skip(field_ident.field_type)?;
        },
      };
      i_prot.read_field_end()?;
    }
    i_prot.read_struct_end()?;
    let ret = THBaseServiceGetMultipleResult {
      result_value: f_0,
      io: f_1,
    };
    Ok(ret)
  }
  fn write_to_out_protocol(&self, o_prot: &mut dyn TOutputProtocol) -> thrift::Result<()> {
    let struct_ident = TStructIdentifier::new("THBaseServiceGetMultipleResult");
    o_prot.write_struct_begin(&struct_ident)?;
    if let Some(ref fld_var) = self.result_value {
      o_prot.write_field_begin(&TFieldIdentifier::new("result_value", TType::List, 0))?;
      o_prot.write_list_begin(&TListIdentifier::new(TType::Struct, fld_var.len() as i32))?;
      for e in fld_var {
        e.write_to_out_protocol(o_prot)?;
      }
      o_prot.write_list_end()?;
      o_prot.write_field_end()?
    }
    if let Some(ref fld_var) = self.io {
      o_prot.write_field_begin(&TFieldIdentifier::new("io", TType::Struct, 1))?;
      fld_var.write_to_out_protocol(o_prot)?;
      o_prot.write_field_end()?
    }
    o_prot.write_field_stop()?;
    o_prot.write_struct_end()
  }
  fn ok_or(self) -> thrift::Result<Vec<TResult>> {
    if self.io.is_some() {
      Err(thrift::Error::User(Box::new(self.io.unwrap())))
    } else if self.result_value.is_some() {
      Ok(self.result_value.unwrap())
    } else {
      Err(
        thrift::Error::Application(
          ApplicationError::new(
            ApplicationErrorKind::MissingResult,
            "no result received for THBaseServiceGetMultiple"
          )
        )
      )
    }
  }
}

//
// THBaseServicePutArgs
//

#[derive(Clone, Debug, Eq, Hash, Ord, PartialEq, PartialOrd)]
struct THBaseServicePutArgs {
  /// the table to put data in
  table: Vec<u8>,
  /// the TPut to put
  tput: TPut,
}

impl THBaseServicePutArgs {
  fn read_from_in_protocol(i_prot: &mut dyn TInputProtocol) -> thrift::Result<THBaseServicePutArgs> {
    i_prot.read_struct_begin()?;
    let mut f_1: Option<Vec<u8>> = None;
    let mut f_2: Option<TPut> = None;
    loop {
      let field_ident = i_prot.read_field_begin()?;
      if field_ident.field_type == TType::Stop {
        break;
      }
      let field_id = field_id(&field_ident)?;
      match field_id {
        1 => {
          let val = i_prot.read_bytes()?;
          f_1 = Some(val);
        },
        2 => {
          let val = TPut::read_from_in_protocol(i_prot)?;
          f_2 = Some(val);
        },
        _ => {
          i_prot.skip(field_ident.field_type)?;
        },
      };
      i_prot.read_field_end()?;
    }
    i_prot.read_struct_end()?;
    verify_required_field_exists("THBaseServicePutArgs.table", &f_1)?;
    verify_required_field_exists("THBaseServicePutArgs.tput", &f_2)?;
    let ret = THBaseServicePutArgs {
      table: f_1.expect("auto-generated code should have checked for presence of required fields"),
      tput: f_2.expect("auto-generated code should have checked for presence of required fields"),
    };
    Ok(ret)
  }
  fn write_to_out_protocol(&self, o_prot: &mut dyn TOutputProtocol) -> thrift::Result<()> {
    let struct_ident = TStructIdentifier::new("put_args");
    o_prot.write_struct_begin(&struct_ident)?;
    o_prot.write_field_begin(&TFieldIdentifier::new("table", TType::String, 1))?;
    o_prot.write_bytes(&self.table)?;
    o_prot.write_field_end()?;
    o_prot.write_field_begin(&TFieldIdentifier::new("tput", TType::Struct, 2))?;
    self.tput.write_to_out_protocol(o_prot)?;
    o_prot.write_field_end()?;
    o_prot.write_field_stop()?;
    o_prot.write_struct_end()
  }
}

//
// THBaseServicePutResult
//

#[derive(Clone, Debug, Eq, Hash, Ord, PartialEq, PartialOrd)]
struct THBaseServicePutResult {
  io: Option<TIOError>,
}

impl THBaseServicePutResult {
  fn read_from_in_protocol(i_prot: &mut dyn TInputProtocol) -> thrift::Result<THBaseServicePutResult> {
    i_prot.read_struct_begin()?;
    let mut f_1: Option<TIOError> = None;
    loop {
      let field_ident = i_prot.read_field_begin()?;
      if field_ident.field_type == TType::Stop {
        break;
      }
      let field_id = field_id(&field_ident)?;
      match field_id {
        1 => {
          let val = TIOError::read_from_in_protocol(i_prot)?;
          f_1 = Some(val);
        },
        _ => {
          i_prot.skip(field_ident.field_type)?;
        },
      };
      i_prot.read_field_end()?;
    }
    i_prot.read_struct_end()?;
    let ret = THBaseServicePutResult {
      io: f_1,
    };
    Ok(ret)
  }
  fn write_to_out_protocol(&self, o_prot: &mut dyn TOutputProtocol) -> thrift::Result<()> {
    let struct_ident = TStructIdentifier::new("THBaseServicePutResult");
    o_prot.write_struct_begin(&struct_ident)?;
    if let Some(ref fld_var) = self.io {
      o_prot.write_field_begin(&TFieldIdentifier::new("io", TType::Struct, 1))?;
      fld_var.write_to_out_protocol(o_prot)?;
      o_prot.write_field_end()?
    }
    o_prot.write_field_stop()?;
    o_prot.write_struct_end()
  }
  fn ok_or(self) -> thrift::Result<()> {
    if self.io.is_some() {
      Err(thrift::Error::User(Box::new(self.io.unwrap())))
    } else {
      Ok(())
    }
  }
}

//
// THBaseServiceCheckAndPutArgs
//

#[derive(Clone, Debug, Eq, Hash, Ord, PartialEq, PartialOrd)]
struct THBaseServiceCheckAndPutArgs {
  /// to check in and put to
  table: Vec<u8>,
  /// row to check
  row: Vec<u8>,
  /// column family to check
  family: Vec<u8>,
  /// column qualifier to check
  qualifier: Vec<u8>,
  /// the expected value, if not provided the
  /// check is for the non-existence of the
  /// column in question
  value: Vec<u8>,
  /// the TPut to put if the check succeeds
  tput: TPut,
}

impl THBaseServiceCheckAndPutArgs {
  fn read_from_in_protocol(i_prot: &mut dyn TInputProtocol) -> thrift::Result<THBaseServiceCheckAndPutArgs> {
    i_prot.read_struct_begin()?;
    let mut f_1: Option<Vec<u8>> = None;
    let mut f_2: Option<Vec<u8>> = None;
    let mut f_3: Option<Vec<u8>> = None;
    let mut f_4: Option<Vec<u8>> = None;
    let mut f_5: Option<Vec<u8>> = None;
    let mut f_6: Option<TPut> = None;
    loop {
      let field_ident = i_prot.read_field_begin()?;
      if field_ident.field_type == TType::Stop {
        break;
      }
      let field_id = field_id(&field_ident)?;
      match field_id {
        1 => {
          let val = i_prot.read_bytes()?;
          f_1 = Some(val);
        },
        2 => {
          let val = i_prot.read_bytes()?;
          f_2 = Some(val);
        },
        3 => {
          let val = i_prot.read_bytes()?;
          f_3 = Some(val);
        },
        4 => {
          let val = i_prot.read_bytes()?;
          f_4 = Some(val);
        },
        5 => {
          let val = i_prot.read_bytes()?;
          f_5 = Some(val);
        },
        6 => {
          let val = TPut::read_from_in_protocol(i_prot)?;
          f_6 = Some(val);
        },
        _ => {
          i_prot.skip(field_ident.field_type)?;
        },
      };
      i_prot.read_field_end()?;
    }
    i_prot.read_struct_end()?;
    verify_required_field_exists("THBaseServiceCheckAndPutArgs.table", &f_1)?;
    verify_required_field_exists("THBaseServiceCheckAndPutArgs.row", &f_2)?;
    verify_required_field_exists("THBaseServiceCheckAndPutArgs.family", &f_3)?;
    verify_required_field_exists("THBaseServiceCheckAndPutArgs.qualifier", &f_4)?;
    verify_required_field_exists("THBaseServiceCheckAndPutArgs.value", &f_5)?;
    verify_required_field_exists("THBaseServiceCheckAndPutArgs.tput", &f_6)?;
    let ret = THBaseServiceCheckAndPutArgs {
      table: f_1.expect("auto-generated code should have checked for presence of required fields"),
      row: f_2.expect("auto-generated code should have checked for presence of required fields"),
      family: f_3.expect("auto-generated code should have checked for presence of required fields"),
      qualifier: f_4.expect("auto-generated code should have checked for presence of required fields"),
      value: f_5.expect("auto-generated code should have checked for presence of required fields"),
      tput: f_6.expect("auto-generated code should have checked for presence of required fields"),
    };
    Ok(ret)
  }
  fn write_to_out_protocol(&self, o_prot: &mut dyn TOutputProtocol) -> thrift::Result<()> {
    let struct_ident = TStructIdentifier::new("checkAndPut_args");
    o_prot.write_struct_begin(&struct_ident)?;
    o_prot.write_field_begin(&TFieldIdentifier::new("table", TType::String, 1))?;
    o_prot.write_bytes(&self.table)?;
    o_prot.write_field_end()?;
    o_prot.write_field_begin(&TFieldIdentifier::new("row", TType::String, 2))?;
    o_prot.write_bytes(&self.row)?;
    o_prot.write_field_end()?;
    o_prot.write_field_begin(&TFieldIdentifier::new("family", TType::String, 3))?;
    o_prot.write_bytes(&self.family)?;
    o_prot.write_field_end()?;
    o_prot.write_field_begin(&TFieldIdentifier::new("qualifier", TType::String, 4))?;
    o_prot.write_bytes(&self.qualifier)?;
    o_prot.write_field_end()?;
    o_prot.write_field_begin(&TFieldIdentifier::new("value", TType::String, 5))?;
    o_prot.write_bytes(&self.value)?;
    o_prot.write_field_end()?;
    o_prot.write_field_begin(&TFieldIdentifier::new("tput", TType::Struct, 6))?;
    self.tput.write_to_out_protocol(o_prot)?;
    o_prot.write_field_end()?;
    o_prot.write_field_stop()?;
    o_prot.write_struct_end()
  }
}

//
// THBaseServiceCheckAndPutResult
//

#[derive(Clone, Debug, Eq, Hash, Ord, PartialEq, PartialOrd)]
struct THBaseServiceCheckAndPutResult {
  result_value: Option<bool>,
  io: Option<TIOError>,
}

impl THBaseServiceCheckAndPutResult {
  fn read_from_in_protocol(i_prot: &mut dyn TInputProtocol) -> thrift::Result<THBaseServiceCheckAndPutResult> {
    i_prot.read_struct_begin()?;
    let mut f_0: Option<bool> = None;
    let mut f_1: Option<TIOError> = None;
    loop {
      let field_ident = i_prot.read_field_begin()?;
      if field_ident.field_type == TType::Stop {
        break;
      }
      let field_id = field_id(&field_ident)?;
      match field_id {
        0 => {
          let val = i_prot.read_bool()?;
          f_0 = Some(val);
        },
        1 => {
          let val = TIOError::read_from_in_protocol(i_prot)?;
          f_1 = Some(val);
        },
        _ => {
          i_prot.skip(field_ident.field_type)?;
        },
      };
      i_prot.read_field_end()?;
    }
    i_prot.read_struct_end()?;
    let ret = THBaseServiceCheckAndPutResult {
      result_value: f_0,
      io: f_1,
    };
    Ok(ret)
  }
  fn write_to_out_protocol(&self, o_prot: &mut dyn TOutputProtocol) -> thrift::Result<()> {
    let struct_ident = TStructIdentifier::new("THBaseServiceCheckAndPutResult");
    o_prot.write_struct_begin(&struct_ident)?;
    if let Some(fld_var) = self.result_value {
      o_prot.write_field_begin(&TFieldIdentifier::new("result_value", TType::Bool, 0))?;
      o_prot.write_bool(fld_var)?;
      o_prot.write_field_end()?
    }
    if let Some(ref fld_var) = self.io {
      o_prot.write_field_begin(&TFieldIdentifier::new("io", TType::Struct, 1))?;
      fld_var.write_to_out_protocol(o_prot)?;
      o_prot.write_field_end()?
    }
    o_prot.write_field_stop()?;
    o_prot.write_struct_end()
  }
  fn ok_or(self) -> thrift::Result<bool> {
    if self.io.is_some() {
      Err(thrift::Error::User(Box::new(self.io.unwrap())))
    } else if self.result_value.is_some() {
      Ok(self.result_value.unwrap())
    } else {
      Err(
        thrift::Error::Application(
          ApplicationError::new(
            ApplicationErrorKind::MissingResult,
            "no result received for THBaseServiceCheckAndPut"
          )
        )
      )
    }
  }
}

//
// THBaseServicePutMultipleArgs
//

#[derive(Clone, Debug, Eq, Hash, Ord, PartialEq, PartialOrd)]
struct THBaseServicePutMultipleArgs {
  /// the table to put data in
  table: Vec<u8>,
  /// a list of TPuts to commit
  tputs: Vec<TPut>,
}

impl THBaseServicePutMultipleArgs {
  fn read_from_in_protocol(i_prot: &mut dyn TInputProtocol) -> thrift::Result<THBaseServicePutMultipleArgs> {
    i_prot.read_struct_begin()?;
    let mut f_1: Option<Vec<u8>> = None;
    let mut f_2: Option<Vec<TPut>> = None;
    loop {
      let field_ident = i_prot.read_field_begin()?;
      if field_ident.field_type == TType::Stop {
        break;
      }
      let field_id = field_id(&field_ident)?;
      match field_id {
        1 => {
          let val = i_prot.read_bytes()?;
          f_1 = Some(val);
        },
        2 => {
          let list_ident = i_prot.read_list_begin()?;
          let mut val: Vec<TPut> = Vec::with_capacity(list_ident.size as usize);
          for _ in 0..list_ident.size {
            let list_elem_36 = TPut::read_from_in_protocol(i_prot)?;
            val.push(list_elem_36);
          }
          i_prot.read_list_end()?;
          f_2 = Some(val);
        },
        _ => {
          i_prot.skip(field_ident.field_type)?;
        },
      };
      i_prot.read_field_end()?;
    }
    i_prot.read_struct_end()?;
    verify_required_field_exists("THBaseServicePutMultipleArgs.table", &f_1)?;
    verify_required_field_exists("THBaseServicePutMultipleArgs.tputs", &f_2)?;
    let ret = THBaseServicePutMultipleArgs {
      table: f_1.expect("auto-generated code should have checked for presence of required fields"),
      tputs: f_2.expect("auto-generated code should have checked for presence of required fields"),
    };
    Ok(ret)
  }
  fn write_to_out_protocol(&self, o_prot: &mut dyn TOutputProtocol) -> thrift::Result<()> {
    let struct_ident = TStructIdentifier::new("putMultiple_args");
    o_prot.write_struct_begin(&struct_ident)?;
    o_prot.write_field_begin(&TFieldIdentifier::new("table", TType::String, 1))?;
    o_prot.write_bytes(&self.table)?;
    o_prot.write_field_end()?;
    o_prot.write_field_begin(&TFieldIdentifier::new("tputs", TType::List, 2))?;
    o_prot.write_list_begin(&TListIdentifier::new(TType::Struct, self.tputs.len() as i32))?;
    for e in &self.tputs {
      e.write_to_out_protocol(o_prot)?;
    }
    o_prot.write_list_end()?;
    o_prot.write_field_end()?;
    o_prot.write_field_stop()?;
    o_prot.write_struct_end()
  }
}

//
// THBaseServicePutMultipleResult
//

#[derive(Clone, Debug, Eq, Hash, Ord, PartialEq, PartialOrd)]
struct THBaseServicePutMultipleResult {
  io: Option<TIOError>,
}

impl THBaseServicePutMultipleResult {
  fn read_from_in_protocol(i_prot: &mut dyn TInputProtocol) -> thrift::Result<THBaseServicePutMultipleResult> {
    i_prot.read_struct_begin()?;
    let mut f_1: Option<TIOError> = None;
    loop {
      let field_ident = i_prot.read_field_begin()?;
      if field_ident.field_type == TType::Stop {
        break;
      }
      let field_id = field_id(&field_ident)?;
      match field_id {
        1 => {
          let val = TIOError::read_from_in_protocol(i_prot)?;
          f_1 = Some(val);
        },
        _ => {
          i_prot.skip(field_ident.field_type)?;
        },
      };
      i_prot.read_field_end()?;
    }
    i_prot.read_struct_end()?;
    let ret = THBaseServicePutMultipleResult {
      io: f_1,
    };
    Ok(ret)
  }
  fn write_to_out_protocol(&self, o_prot: &mut dyn TOutputProtocol) -> thrift::Result<()> {
    let struct_ident = TStructIdentifier::new("THBaseServicePutMultipleResult");
    o_prot.write_struct_begin(&struct_ident)?;
    if let Some(ref fld_var) = self.io {
      o_prot.write_field_begin(&TFieldIdentifier::new("io", TType::Struct, 1))?;
      fld_var.write_to_out_protocol(o_prot)?;
      o_prot.write_field_end()?
    }
    o_prot.write_field_stop()?;
    o_prot.write_struct_end()
  }
  fn ok_or(self) -> thrift::Result<()> {
    if self.io.is_some() {
      Err(thrift::Error::User(Box::new(self.io.unwrap())))
    } else {
      Ok(())
    }
  }
}

//
// THBaseServiceDeleteSingleArgs
//

#[derive(Clone, Debug, Eq, Hash, Ord, PartialEq, PartialOrd)]
struct THBaseServiceDeleteSingleArgs {
  /// the table to delete from
  table: Vec<u8>,
  /// the TDelete to delete
  tdelete: TDelete,
}

impl THBaseServiceDeleteSingleArgs {
  fn read_from_in_protocol(i_prot: &mut dyn TInputProtocol) -> thrift::Result<THBaseServiceDeleteSingleArgs> {
    i_prot.read_struct_begin()?;
    let mut f_1: Option<Vec<u8>> = None;
    let mut f_2: Option<TDelete> = None;
    loop {
      let field_ident = i_prot.read_field_begin()?;
      if field_ident.field_type == TType::Stop {
        break;
      }
      let field_id = field_id(&field_ident)?;
      match field_id {
        1 => {
          let val = i_prot.read_bytes()?;
          f_1 = Some(val);
        },
        2 => {
          let val = TDelete::read_from_in_protocol(i_prot)?;
          f_2 = Some(val);
        },
        _ => {
          i_prot.skip(field_ident.field_type)?;
        },
      };
      i_prot.read_field_end()?;
    }
    i_prot.read_struct_end()?;
    verify_required_field_exists("THBaseServiceDeleteSingleArgs.table", &f_1)?;
    verify_required_field_exists("THBaseServiceDeleteSingleArgs.tdelete", &f_2)?;
    let ret = THBaseServiceDeleteSingleArgs {
      table: f_1.expect("auto-generated code should have checked for presence of required fields"),
      tdelete: f_2.expect("auto-generated code should have checked for presence of required fields"),
    };
    Ok(ret)
  }
  fn write_to_out_protocol(&self, o_prot: &mut dyn TOutputProtocol) -> thrift::Result<()> {
    let struct_ident = TStructIdentifier::new("deleteSingle_args");
    o_prot.write_struct_begin(&struct_ident)?;
    o_prot.write_field_begin(&TFieldIdentifier::new("table", TType::String, 1))?;
    o_prot.write_bytes(&self.table)?;
    o_prot.write_field_end()?;
    o_prot.write_field_begin(&TFieldIdentifier::new("tdelete", TType::Struct, 2))?;
    self.tdelete.write_to_out_protocol(o_prot)?;
    o_prot.write_field_end()?;
    o_prot.write_field_stop()?;
    o_prot.write_struct_end()
  }
}

//
// THBaseServiceDeleteSingleResult
//

#[derive(Clone, Debug, Eq, Hash, Ord, PartialEq, PartialOrd)]
struct THBaseServiceDeleteSingleResult {
  io: Option<TIOError>,
}

impl THBaseServiceDeleteSingleResult {
  fn read_from_in_protocol(i_prot: &mut dyn TInputProtocol) -> thrift::Result<THBaseServiceDeleteSingleResult> {
    i_prot.read_struct_begin()?;
    let mut f_1: Option<TIOError> = None;
    loop {
      let field_ident = i_prot.read_field_begin()?;
      if field_ident.field_type == TType::Stop {
        break;
      }
      let field_id = field_id(&field_ident)?;
      match field_id {
        1 => {
          let val = TIOError::read_from_in_protocol(i_prot)?;
          f_1 = Some(val);
        },
        _ => {
          i_prot.skip(field_ident.field_type)?;
        },
      };
      i_prot.read_field_end()?;
    }
    i_prot.read_struct_end()?;
    let ret = THBaseServiceDeleteSingleResult {
      io: f_1,
    };
    Ok(ret)
  }
  fn write_to_out_protocol(&self, o_prot: &mut dyn TOutputProtocol) -> thrift::Result<()> {
    let struct_ident = TStructIdentifier::new("THBaseServiceDeleteSingleResult");
    o_prot.write_struct_begin(&struct_ident)?;
    if let Some(ref fld_var) = self.io {
      o_prot.write_field_begin(&TFieldIdentifier::new("io", TType::Struct, 1))?;
      fld_var.write_to_out_protocol(o_prot)?;
      o_prot.write_field_end()?
    }
    o_prot.write_field_stop()?;
    o_prot.write_struct_end()
  }
  fn ok_or(self) -> thrift::Result<()> {
    if self.io.is_some() {
      Err(thrift::Error::User(Box::new(self.io.unwrap())))
    } else {
      Ok(())
    }
  }
}

//
// THBaseServiceDeleteMultipleArgs
//

#[derive(Clone, Debug, Eq, Hash, Ord, PartialEq, PartialOrd)]
struct THBaseServiceDeleteMultipleArgs {
  /// the table to delete from
  table: Vec<u8>,
  /// list of TDeletes to delete
  tdeletes: Vec<TDelete>,
}

impl THBaseServiceDeleteMultipleArgs {
  fn read_from_in_protocol(i_prot: &mut dyn TInputProtocol) -> thrift::Result<THBaseServiceDeleteMultipleArgs> {
    i_prot.read_struct_begin()?;
    let mut f_1: Option<Vec<u8>> = None;
    let mut f_2: Option<Vec<TDelete>> = None;
    loop {
      let field_ident = i_prot.read_field_begin()?;
      if field_ident.field_type == TType::Stop {
        break;
      }
      let field_id = field_id(&field_ident)?;
      match field_id {
        1 => {
          let val = i_prot.read_bytes()?;
          f_1 = Some(val);
        },
        2 => {
          let list_ident = i_prot.read_list_begin()?;
          let mut val: Vec<TDelete> = Vec::with_capacity(list_ident.size as usize);
          for _ in 0..list_ident.size {
            let list_elem_37 = TDelete::read_from_in_protocol(i_prot)?;
            val.push(list_elem_37);
          }
          i_prot.read_list_end()?;
          f_2 = Some(val);
        },
        _ => {
          i_prot.skip(field_ident.field_type)?;
        },
      };
      i_prot.read_field_end()?;
    }
    i_prot.read_struct_end()?;
    verify_required_field_exists("THBaseServiceDeleteMultipleArgs.table", &f_1)?;
    verify_required_field_exists("THBaseServiceDeleteMultipleArgs.tdeletes", &f_2)?;
    let ret = THBaseServiceDeleteMultipleArgs {
      table: f_1.expect("auto-generated code should have checked for presence of required fields"),
      tdeletes: f_2.expect("auto-generated code should have checked for presence of required fields"),
    };
    Ok(ret)
  }
  fn write_to_out_protocol(&self, o_prot: &mut dyn TOutputProtocol) -> thrift::Result<()> {
    let struct_ident = TStructIdentifier::new("deleteMultiple_args");
    o_prot.write_struct_begin(&struct_ident)?;
    o_prot.write_field_begin(&TFieldIdentifier::new("table", TType::String, 1))?;
    o_prot.write_bytes(&self.table)?;
    o_prot.write_field_end()?;
    o_prot.write_field_begin(&TFieldIdentifier::new("tdeletes", TType::List, 2))?;
    o_prot.write_list_begin(&TListIdentifier::new(TType::Struct, self.tdeletes.len() as i32))?;
    for e in &self.tdeletes {
      e.write_to_out_protocol(o_prot)?;
    }
    o_prot.write_list_end()?;
    o_prot.write_field_end()?;
    o_prot.write_field_stop()?;
    o_prot.write_struct_end()
  }
}

//
// THBaseServiceDeleteMultipleResult
//

#[derive(Clone, Debug, Eq, Hash, Ord, PartialEq, PartialOrd)]
struct THBaseServiceDeleteMultipleResult {
  result_value: Option<Vec<TDelete>>,
  io: Option<TIOError>,
}

impl THBaseServiceDeleteMultipleResult {
  fn read_from_in_protocol(i_prot: &mut dyn TInputProtocol) -> thrift::Result<THBaseServiceDeleteMultipleResult> {
    i_prot.read_struct_begin()?;
    let mut f_0: Option<Vec<TDelete>> = None;
    let mut f_1: Option<TIOError> = None;
    loop {
      let field_ident = i_prot.read_field_begin()?;
      if field_ident.field_type == TType::Stop {
        break;
      }
      let field_id = field_id(&field_ident)?;
      match field_id {
        0 => {
          let list_ident = i_prot.read_list_begin()?;
          let mut val: Vec<TDelete> = Vec::with_capacity(list_ident.size as usize);
          for _ in 0..list_ident.size {
            let list_elem_38 = TDelete::read_from_in_protocol(i_prot)?;
            val.push(list_elem_38);
          }
          i_prot.read_list_end()?;
          f_0 = Some(val);
        },
        1 => {
          let val = TIOError::read_from_in_protocol(i_prot)?;
          f_1 = Some(val);
        },
        _ => {
          i_prot.skip(field_ident.field_type)?;
        },
      };
      i_prot.read_field_end()?;
    }
    i_prot.read_struct_end()?;
    let ret = THBaseServiceDeleteMultipleResult {
      result_value: f_0,
      io: f_1,
    };
    Ok(ret)
  }
  fn write_to_out_protocol(&self, o_prot: &mut dyn TOutputProtocol) -> thrift::Result<()> {
    let struct_ident = TStructIdentifier::new("THBaseServiceDeleteMultipleResult");
    o_prot.write_struct_begin(&struct_ident)?;
    if let Some(ref fld_var) = self.result_value {
      o_prot.write_field_begin(&TFieldIdentifier::new("result_value", TType::List, 0))?;
      o_prot.write_list_begin(&TListIdentifier::new(TType::Struct, fld_var.len() as i32))?;
      for e in fld_var {
        e.write_to_out_protocol(o_prot)?;
      }
      o_prot.write_list_end()?;
      o_prot.write_field_end()?
    }
    if let Some(ref fld_var) = self.io {
      o_prot.write_field_begin(&TFieldIdentifier::new("io", TType::Struct, 1))?;
      fld_var.write_to_out_protocol(o_prot)?;
      o_prot.write_field_end()?
    }
    o_prot.write_field_stop()?;
    o_prot.write_struct_end()
  }
  fn ok_or(self) -> thrift::Result<Vec<TDelete>> {
    if self.io.is_some() {
      Err(thrift::Error::User(Box::new(self.io.unwrap())))
    } else if self.result_value.is_some() {
      Ok(self.result_value.unwrap())
    } else {
      Err(
        thrift::Error::Application(
          ApplicationError::new(
            ApplicationErrorKind::MissingResult,
            "no result received for THBaseServiceDeleteMultiple"
          )
        )
      )
    }
  }
}

//
// THBaseServiceCheckAndDeleteArgs
//

#[derive(Clone, Debug, Eq, Hash, Ord, PartialEq, PartialOrd)]
struct THBaseServiceCheckAndDeleteArgs {
  /// to check in and delete from
  table: Vec<u8>,
  /// row to check
  row: Vec<u8>,
  /// column family to check
  family: Vec<u8>,
  /// column qualifier to check
  qualifier: Vec<u8>,
  /// the expected value, if not provided the
  /// check is for the non-existence of the
  /// column in question
  value: Vec<u8>,
  /// the TDelete to execute if the check succeeds
  tdelete: TDelete,
}

impl THBaseServiceCheckAndDeleteArgs {
  fn read_from_in_protocol(i_prot: &mut dyn TInputProtocol) -> thrift::Result<THBaseServiceCheckAndDeleteArgs> {
    i_prot.read_struct_begin()?;
    let mut f_1: Option<Vec<u8>> = None;
    let mut f_2: Option<Vec<u8>> = None;
    let mut f_3: Option<Vec<u8>> = None;
    let mut f_4: Option<Vec<u8>> = None;
    let mut f_5: Option<Vec<u8>> = None;
    let mut f_6: Option<TDelete> = None;
    loop {
      let field_ident = i_prot.read_field_begin()?;
      if field_ident.field_type == TType::Stop {
        break;
      }
      let field_id = field_id(&field_ident)?;
      match field_id {
        1 => {
          let val = i_prot.read_bytes()?;
          f_1 = Some(val);
        },
        2 => {
          let val = i_prot.read_bytes()?;
          f_2 = Some(val);
        },
        3 => {
          let val = i_prot.read_bytes()?;
          f_3 = Some(val);
        },
        4 => {
          let val = i_prot.read_bytes()?;
          f_4 = Some(val);
        },
        5 => {
          let val = i_prot.read_bytes()?;
          f_5 = Some(val);
        },
        6 => {
          let val = TDelete::read_from_in_protocol(i_prot)?;
          f_6 = Some(val);
        },
        _ => {
          i_prot.skip(field_ident.field_type)?;
        },
      };
      i_prot.read_field_end()?;
    }
    i_prot.read_struct_end()?;
    verify_required_field_exists("THBaseServiceCheckAndDeleteArgs.table", &f_1)?;
    verify_required_field_exists("THBaseServiceCheckAndDeleteArgs.row", &f_2)?;
    verify_required_field_exists("THBaseServiceCheckAndDeleteArgs.family", &f_3)?;
    verify_required_field_exists("THBaseServiceCheckAndDeleteArgs.qualifier", &f_4)?;
    verify_required_field_exists("THBaseServiceCheckAndDeleteArgs.value", &f_5)?;
    verify_required_field_exists("THBaseServiceCheckAndDeleteArgs.tdelete", &f_6)?;
    let ret = THBaseServiceCheckAndDeleteArgs {
      table: f_1.expect("auto-generated code should have checked for presence of required fields"),
      row: f_2.expect("auto-generated code should have checked for presence of required fields"),
      family: f_3.expect("auto-generated code should have checked for presence of required fields"),
      qualifier: f_4.expect("auto-generated code should have checked for presence of required fields"),
      value: f_5.expect("auto-generated code should have checked for presence of required fields"),
      tdelete: f_6.expect("auto-generated code should have checked for presence of required fields"),
    };
    Ok(ret)
  }
  fn write_to_out_protocol(&self, o_prot: &mut dyn TOutputProtocol) -> thrift::Result<()> {
    let struct_ident = TStructIdentifier::new("checkAndDelete_args");
    o_prot.write_struct_begin(&struct_ident)?;
    o_prot.write_field_begin(&TFieldIdentifier::new("table", TType::String, 1))?;
    o_prot.write_bytes(&self.table)?;
    o_prot.write_field_end()?;
    o_prot.write_field_begin(&TFieldIdentifier::new("row", TType::String, 2))?;
    o_prot.write_bytes(&self.row)?;
    o_prot.write_field_end()?;
    o_prot.write_field_begin(&TFieldIdentifier::new("family", TType::String, 3))?;
    o_prot.write_bytes(&self.family)?;
    o_prot.write_field_end()?;
    o_prot.write_field_begin(&TFieldIdentifier::new("qualifier", TType::String, 4))?;
    o_prot.write_bytes(&self.qualifier)?;
    o_prot.write_field_end()?;
    o_prot.write_field_begin(&TFieldIdentifier::new("value", TType::String, 5))?;
    o_prot.write_bytes(&self.value)?;
    o_prot.write_field_end()?;
    o_prot.write_field_begin(&TFieldIdentifier::new("tdelete", TType::Struct, 6))?;
    self.tdelete.write_to_out_protocol(o_prot)?;
    o_prot.write_field_end()?;
    o_prot.write_field_stop()?;
    o_prot.write_struct_end()
  }
}

//
// THBaseServiceCheckAndDeleteResult
//

#[derive(Clone, Debug, Eq, Hash, Ord, PartialEq, PartialOrd)]
struct THBaseServiceCheckAndDeleteResult {
  result_value: Option<bool>,
  io: Option<TIOError>,
}

impl THBaseServiceCheckAndDeleteResult {
  fn read_from_in_protocol(i_prot: &mut dyn TInputProtocol) -> thrift::Result<THBaseServiceCheckAndDeleteResult> {
    i_prot.read_struct_begin()?;
    let mut f_0: Option<bool> = None;
    let mut f_1: Option<TIOError> = None;
    loop {
      let field_ident = i_prot.read_field_begin()?;
      if field_ident.field_type == TType::Stop {
        break;
      }
      let field_id = field_id(&field_ident)?;
      match field_id {
        0 => {
          let val = i_prot.read_bool()?;
          f_0 = Some(val);
        },
        1 => {
          let val = TIOError::read_from_in_protocol(i_prot)?;
          f_1 = Some(val);
        },
        _ => {
          i_prot.skip(field_ident.field_type)?;
        },
      };
      i_prot.read_field_end()?;
    }
    i_prot.read_struct_end()?;
    let ret = THBaseServiceCheckAndDeleteResult {
      result_value: f_0,
      io: f_1,
    };
    Ok(ret)
  }
  fn write_to_out_protocol(&self, o_prot: &mut dyn TOutputProtocol) -> thrift::Result<()> {
    let struct_ident = TStructIdentifier::new("THBaseServiceCheckAndDeleteResult");
    o_prot.write_struct_begin(&struct_ident)?;
    if let Some(fld_var) = self.result_value {
      o_prot.write_field_begin(&TFieldIdentifier::new("result_value", TType::Bool, 0))?;
      o_prot.write_bool(fld_var)?;
      o_prot.write_field_end()?
    }
    if let Some(ref fld_var) = self.io {
      o_prot.write_field_begin(&TFieldIdentifier::new("io", TType::Struct, 1))?;
      fld_var.write_to_out_protocol(o_prot)?;
      o_prot.write_field_end()?
    }
    o_prot.write_field_stop()?;
    o_prot.write_struct_end()
  }
  fn ok_or(self) -> thrift::Result<bool> {
    if self.io.is_some() {
      Err(thrift::Error::User(Box::new(self.io.unwrap())))
    } else if self.result_value.is_some() {
      Ok(self.result_value.unwrap())
    } else {
      Err(
        thrift::Error::Application(
          ApplicationError::new(
            ApplicationErrorKind::MissingResult,
            "no result received for THBaseServiceCheckAndDelete"
          )
        )
      )
    }
  }
}

//
// THBaseServiceIncrementArgs
//

#[derive(Clone, Debug, Eq, Hash, Ord, PartialEq, PartialOrd)]
struct THBaseServiceIncrementArgs {
  /// the table to increment the value on
  table: Vec<u8>,
  /// the TIncrement to increment
  tincrement: TIncrement,
}

impl THBaseServiceIncrementArgs {
  fn read_from_in_protocol(i_prot: &mut dyn TInputProtocol) -> thrift::Result<THBaseServiceIncrementArgs> {
    i_prot.read_struct_begin()?;
    let mut f_1: Option<Vec<u8>> = None;
    let mut f_2: Option<TIncrement> = None;
    loop {
      let field_ident = i_prot.read_field_begin()?;
      if field_ident.field_type == TType::Stop {
        break;
      }
      let field_id = field_id(&field_ident)?;
      match field_id {
        1 => {
          let val = i_prot.read_bytes()?;
          f_1 = Some(val);
        },
        2 => {
          let val = TIncrement::read_from_in_protocol(i_prot)?;
          f_2 = Some(val);
        },
        _ => {
          i_prot.skip(field_ident.field_type)?;
        },
      };
      i_prot.read_field_end()?;
    }
    i_prot.read_struct_end()?;
    verify_required_field_exists("THBaseServiceIncrementArgs.table", &f_1)?;
    verify_required_field_exists("THBaseServiceIncrementArgs.tincrement", &f_2)?;
    let ret = THBaseServiceIncrementArgs {
      table: f_1.expect("auto-generated code should have checked for presence of required fields"),
      tincrement: f_2.expect("auto-generated code should have checked for presence of required fields"),
    };
    Ok(ret)
  }
  fn write_to_out_protocol(&self, o_prot: &mut dyn TOutputProtocol) -> thrift::Result<()> {
    let struct_ident = TStructIdentifier::new("increment_args");
    o_prot.write_struct_begin(&struct_ident)?;
    o_prot.write_field_begin(&TFieldIdentifier::new("table", TType::String, 1))?;
    o_prot.write_bytes(&self.table)?;
    o_prot.write_field_end()?;
    o_prot.write_field_begin(&TFieldIdentifier::new("tincrement", TType::Struct, 2))?;
    self.tincrement.write_to_out_protocol(o_prot)?;
    o_prot.write_field_end()?;
    o_prot.write_field_stop()?;
    o_prot.write_struct_end()
  }
}

//
// THBaseServiceIncrementResult
//

#[derive(Clone, Debug, Eq, Hash, Ord, PartialEq, PartialOrd)]
struct THBaseServiceIncrementResult {
  result_value: Option<TResult>,
  io: Option<TIOError>,
}

impl THBaseServiceIncrementResult {
  fn read_from_in_protocol(i_prot: &mut dyn TInputProtocol) -> thrift::Result<THBaseServiceIncrementResult> {
    i_prot.read_struct_begin()?;
    let mut f_0: Option<TResult> = None;
    let mut f_1: Option<TIOError> = None;
    loop {
      let field_ident = i_prot.read_field_begin()?;
      if field_ident.field_type == TType::Stop {
        break;
      }
      let field_id = field_id(&field_ident)?;
      match field_id {
        0 => {
          let val = TResult::read_from_in_protocol(i_prot)?;
          f_0 = Some(val);
        },
        1 => {
          let val = TIOError::read_from_in_protocol(i_prot)?;
          f_1 = Some(val);
        },
        _ => {
          i_prot.skip(field_ident.field_type)?;
        },
      };
      i_prot.read_field_end()?;
    }
    i_prot.read_struct_end()?;
    let ret = THBaseServiceIncrementResult {
      result_value: f_0,
      io: f_1,
    };
    Ok(ret)
  }
  fn write_to_out_protocol(&self, o_prot: &mut dyn TOutputProtocol) -> thrift::Result<()> {
    let struct_ident = TStructIdentifier::new("THBaseServiceIncrementResult");
    o_prot.write_struct_begin(&struct_ident)?;
    if let Some(ref fld_var) = self.result_value {
      o_prot.write_field_begin(&TFieldIdentifier::new("result_value", TType::Struct, 0))?;
      fld_var.write_to_out_protocol(o_prot)?;
      o_prot.write_field_end()?
    }
    if let Some(ref fld_var) = self.io {
      o_prot.write_field_begin(&TFieldIdentifier::new("io", TType::Struct, 1))?;
      fld_var.write_to_out_protocol(o_prot)?;
      o_prot.write_field_end()?
    }
    o_prot.write_field_stop()?;
    o_prot.write_struct_end()
  }
  fn ok_or(self) -> thrift::Result<TResult> {
    if self.io.is_some() {
      Err(thrift::Error::User(Box::new(self.io.unwrap())))
    } else if self.result_value.is_some() {
      Ok(self.result_value.unwrap())
    } else {
      Err(
        thrift::Error::Application(
          ApplicationError::new(
            ApplicationErrorKind::MissingResult,
            "no result received for THBaseServiceIncrement"
          )
        )
      )
    }
  }
}

//
// THBaseServiceAppendArgs
//

#[derive(Clone, Debug, Eq, Hash, Ord, PartialEq, PartialOrd)]
struct THBaseServiceAppendArgs {
  /// the table to append the value on
  table: Vec<u8>,
  /// the TAppend to append
  tappend: TAppend,
}

impl THBaseServiceAppendArgs {
  fn read_from_in_protocol(i_prot: &mut dyn TInputProtocol) -> thrift::Result<THBaseServiceAppendArgs> {
    i_prot.read_struct_begin()?;
    let mut f_1: Option<Vec<u8>> = None;
    let mut f_2: Option<TAppend> = None;
    loop {
      let field_ident = i_prot.read_field_begin()?;
      if field_ident.field_type == TType::Stop {
        break;
      }
      let field_id = field_id(&field_ident)?;
      match field_id {
        1 => {
          let val = i_prot.read_bytes()?;
          f_1 = Some(val);
        },
        2 => {
          let val = TAppend::read_from_in_protocol(i_prot)?;
          f_2 = Some(val);
        },
        _ => {
          i_prot.skip(field_ident.field_type)?;
        },
      };
      i_prot.read_field_end()?;
    }
    i_prot.read_struct_end()?;
    verify_required_field_exists("THBaseServiceAppendArgs.table", &f_1)?;
    verify_required_field_exists("THBaseServiceAppendArgs.tappend", &f_2)?;
    let ret = THBaseServiceAppendArgs {
      table: f_1.expect("auto-generated code should have checked for presence of required fields"),
      tappend: f_2.expect("auto-generated code should have checked for presence of required fields"),
    };
    Ok(ret)
  }
  fn write_to_out_protocol(&self, o_prot: &mut dyn TOutputProtocol) -> thrift::Result<()> {
    let struct_ident = TStructIdentifier::new("append_args");
    o_prot.write_struct_begin(&struct_ident)?;
    o_prot.write_field_begin(&TFieldIdentifier::new("table", TType::String, 1))?;
    o_prot.write_bytes(&self.table)?;
    o_prot.write_field_end()?;
    o_prot.write_field_begin(&TFieldIdentifier::new("tappend", TType::Struct, 2))?;
    self.tappend.write_to_out_protocol(o_prot)?;
    o_prot.write_field_end()?;
    o_prot.write_field_stop()?;
    o_prot.write_struct_end()
  }
}

//
// THBaseServiceAppendResult
//

#[derive(Clone, Debug, Eq, Hash, Ord, PartialEq, PartialOrd)]
struct THBaseServiceAppendResult {
  result_value: Option<TResult>,
  io: Option<TIOError>,
}

impl THBaseServiceAppendResult {
  fn read_from_in_protocol(i_prot: &mut dyn TInputProtocol) -> thrift::Result<THBaseServiceAppendResult> {
    i_prot.read_struct_begin()?;
    let mut f_0: Option<TResult> = None;
    let mut f_1: Option<TIOError> = None;
    loop {
      let field_ident = i_prot.read_field_begin()?;
      if field_ident.field_type == TType::Stop {
        break;
      }
      let field_id = field_id(&field_ident)?;
      match field_id {
        0 => {
          let val = TResult::read_from_in_protocol(i_prot)?;
          f_0 = Some(val);
        },
        1 => {
          let val = TIOError::read_from_in_protocol(i_prot)?;
          f_1 = Some(val);
        },
        _ => {
          i_prot.skip(field_ident.field_type)?;
        },
      };
      i_prot.read_field_end()?;
    }
    i_prot.read_struct_end()?;
    let ret = THBaseServiceAppendResult {
      result_value: f_0,
      io: f_1,
    };
    Ok(ret)
  }
  fn write_to_out_protocol(&self, o_prot: &mut dyn TOutputProtocol) -> thrift::Result<()> {
    let struct_ident = TStructIdentifier::new("THBaseServiceAppendResult");
    o_prot.write_struct_begin(&struct_ident)?;
    if let Some(ref fld_var) = self.result_value {
      o_prot.write_field_begin(&TFieldIdentifier::new("result_value", TType::Struct, 0))?;
      fld_var.write_to_out_protocol(o_prot)?;
      o_prot.write_field_end()?
    }
    if let Some(ref fld_var) = self.io {
      o_prot.write_field_begin(&TFieldIdentifier::new("io", TType::Struct, 1))?;
      fld_var.write_to_out_protocol(o_prot)?;
      o_prot.write_field_end()?
    }
    o_prot.write_field_stop()?;
    o_prot.write_struct_end()
  }
  fn ok_or(self) -> thrift::Result<TResult> {
    if self.io.is_some() {
      Err(thrift::Error::User(Box::new(self.io.unwrap())))
    } else if self.result_value.is_some() {
      Ok(self.result_value.unwrap())
    } else {
      Err(
        thrift::Error::Application(
          ApplicationError::new(
            ApplicationErrorKind::MissingResult,
            "no result received for THBaseServiceAppend"
          )
        )
      )
    }
  }
}

//
// THBaseServiceOpenScannerArgs
//

#[derive(Clone, Debug, Eq, Hash, Ord, PartialEq, PartialOrd)]
struct THBaseServiceOpenScannerArgs {
  /// the table to get the Scanner for
  table: Vec<u8>,
  /// the scan object to get a Scanner for
  tscan: TScan,
}

impl THBaseServiceOpenScannerArgs {
  fn read_from_in_protocol(i_prot: &mut dyn TInputProtocol) -> thrift::Result<THBaseServiceOpenScannerArgs> {
    i_prot.read_struct_begin()?;
    let mut f_1: Option<Vec<u8>> = None;
    let mut f_2: Option<TScan> = None;
    loop {
      let field_ident = i_prot.read_field_begin()?;
      if field_ident.field_type == TType::Stop {
        break;
      }
      let field_id = field_id(&field_ident)?;
      match field_id {
        1 => {
          let val = i_prot.read_bytes()?;
          f_1 = Some(val);
        },
        2 => {
          let val = TScan::read_from_in_protocol(i_prot)?;
          f_2 = Some(val);
        },
        _ => {
          i_prot.skip(field_ident.field_type)?;
        },
      };
      i_prot.read_field_end()?;
    }
    i_prot.read_struct_end()?;
    verify_required_field_exists("THBaseServiceOpenScannerArgs.table", &f_1)?;
    verify_required_field_exists("THBaseServiceOpenScannerArgs.tscan", &f_2)?;
    let ret = THBaseServiceOpenScannerArgs {
      table: f_1.expect("auto-generated code should have checked for presence of required fields"),
      tscan: f_2.expect("auto-generated code should have checked for presence of required fields"),
    };
    Ok(ret)
  }
  fn write_to_out_protocol(&self, o_prot: &mut dyn TOutputProtocol) -> thrift::Result<()> {
    let struct_ident = TStructIdentifier::new("openScanner_args");
    o_prot.write_struct_begin(&struct_ident)?;
    o_prot.write_field_begin(&TFieldIdentifier::new("table", TType::String, 1))?;
    o_prot.write_bytes(&self.table)?;
    o_prot.write_field_end()?;
    o_prot.write_field_begin(&TFieldIdentifier::new("tscan", TType::Struct, 2))?;
    self.tscan.write_to_out_protocol(o_prot)?;
    o_prot.write_field_end()?;
    o_prot.write_field_stop()?;
    o_prot.write_struct_end()
  }
}

//
// THBaseServiceOpenScannerResult
//

#[derive(Clone, Debug, Eq, Hash, Ord, PartialEq, PartialOrd)]
struct THBaseServiceOpenScannerResult {
  result_value: Option<i32>,
  io: Option<TIOError>,
}

impl THBaseServiceOpenScannerResult {
  fn read_from_in_protocol(i_prot: &mut dyn TInputProtocol) -> thrift::Result<THBaseServiceOpenScannerResult> {
    i_prot.read_struct_begin()?;
    let mut f_0: Option<i32> = None;
    let mut f_1: Option<TIOError> = None;
    loop {
      let field_ident = i_prot.read_field_begin()?;
      if field_ident.field_type == TType::Stop {
        break;
      }
      let field_id = field_id(&field_ident)?;
      match field_id {
        0 => {
          let val = i_prot.read_i32()?;
          f_0 = Some(val);
        },
        1 => {
          let val = TIOError::read_from_in_protocol(i_prot)?;
          f_1 = Some(val);
        },
        _ => {
          i_prot.skip(field_ident.field_type)?;
        },
      };
      i_prot.read_field_end()?;
    }
    i_prot.read_struct_end()?;
    let ret = THBaseServiceOpenScannerResult {
      result_value: f_0,
      io: f_1,
    };
    Ok(ret)
  }
  fn write_to_out_protocol(&self, o_prot: &mut dyn TOutputProtocol) -> thrift::Result<()> {
    let struct_ident = TStructIdentifier::new("THBaseServiceOpenScannerResult");
    o_prot.write_struct_begin(&struct_ident)?;
    if let Some(fld_var) = self.result_value {
      o_prot.write_field_begin(&TFieldIdentifier::new("result_value", TType::I32, 0))?;
      o_prot.write_i32(fld_var)?;
      o_prot.write_field_end()?
    }
    if let Some(ref fld_var) = self.io {
      o_prot.write_field_begin(&TFieldIdentifier::new("io", TType::Struct, 1))?;
      fld_var.write_to_out_protocol(o_prot)?;
      o_prot.write_field_end()?
    }
    o_prot.write_field_stop()?;
    o_prot.write_struct_end()
  }
  fn ok_or(self) -> thrift::Result<i32> {
    if self.io.is_some() {
      Err(thrift::Error::User(Box::new(self.io.unwrap())))
    } else if self.result_value.is_some() {
      Ok(self.result_value.unwrap())
    } else {
      Err(
        thrift::Error::Application(
          ApplicationError::new(
            ApplicationErrorKind::MissingResult,
            "no result received for THBaseServiceOpenScanner"
          )
        )
      )
    }
  }
}

//
// THBaseServiceGetScannerRowsArgs
//

#[derive(Clone, Debug, Eq, Hash, Ord, PartialEq, PartialOrd)]
struct THBaseServiceGetScannerRowsArgs {
  /// the Id of the Scanner to return rows from. This is an Id returned from the openScanner function.
  scanner_id: i32,
  /// number of rows to return
  num_rows: i32,
}

impl THBaseServiceGetScannerRowsArgs {
  fn read_from_in_protocol(i_prot: &mut dyn TInputProtocol) -> thrift::Result<THBaseServiceGetScannerRowsArgs> {
    i_prot.read_struct_begin()?;
    let mut f_1: Option<i32> = None;
    let mut f_2: Option<i32> = None;
    loop {
      let field_ident = i_prot.read_field_begin()?;
      if field_ident.field_type == TType::Stop {
        break;
      }
      let field_id = field_id(&field_ident)?;
      match field_id {
        1 => {
          let val = i_prot.read_i32()?;
          f_1 = Some(val);
        },
        2 => {
          let val = i_prot.read_i32()?;
          f_2 = Some(val);
        },
        _ => {
          i_prot.skip(field_ident.field_type)?;
        },
      };
      i_prot.read_field_end()?;
    }
    i_prot.read_struct_end()?;
    verify_required_field_exists("THBaseServiceGetScannerRowsArgs.scanner_id", &f_1)?;
    verify_required_field_exists("THBaseServiceGetScannerRowsArgs.num_rows", &f_2)?;
    let ret = THBaseServiceGetScannerRowsArgs {
      scanner_id: f_1.expect("auto-generated code should have checked for presence of required fields"),
      num_rows: f_2.expect("auto-generated code should have checked for presence of required fields"),
    };
    Ok(ret)
  }
  fn write_to_out_protocol(&self, o_prot: &mut dyn TOutputProtocol) -> thrift::Result<()> {
    let struct_ident = TStructIdentifier::new("getScannerRows_args");
    o_prot.write_struct_begin(&struct_ident)?;
    o_prot.write_field_begin(&TFieldIdentifier::new("scannerId", TType::I32, 1))?;
    o_prot.write_i32(self.scanner_id)?;
    o_prot.write_field_end()?;
    o_prot.write_field_begin(&TFieldIdentifier::new("numRows", TType::I32, 2))?;
    o_prot.write_i32(self.num_rows)?;
    o_prot.write_field_end()?;
    o_prot.write_field_stop()?;
    o_prot.write_struct_end()
  }
}

//
// THBaseServiceGetScannerRowsResult
//

#[derive(Clone, Debug, Eq, Hash, Ord, PartialEq, PartialOrd)]
struct THBaseServiceGetScannerRowsResult {
  result_value: Option<Vec<TResult>>,
  io: Option<TIOError>,
  /// if the scannerId is invalid
  ia: Option<TIllegalArgument>,
}

impl THBaseServiceGetScannerRowsResult {
  fn read_from_in_protocol(i_prot: &mut dyn TInputProtocol) -> thrift::Result<THBaseServiceGetScannerRowsResult> {
    i_prot.read_struct_begin()?;
    let mut f_0: Option<Vec<TResult>> = None;
    let mut f_1: Option<TIOError> = None;
    let mut f_2: Option<TIllegalArgument> = None;
    loop {
      let field_ident = i_prot.read_field_begin()?;
      if field_ident.field_type == TType::Stop {
        break;
      }
      let field_id = field_id(&field_ident)?;
      match field_id {
        0 => {
          let list_ident = i_prot.read_list_begin()?;
          let mut val: Vec<TResult> = Vec::with_capacity(list_ident.size as usize);
          for _ in 0..list_ident.size {
            let list_elem_39 = TResult::read_from_in_protocol(i_prot)?;
            val.push(list_elem_39);
          }
          i_prot.read_list_end()?;
          f_0 = Some(val);
        },
        1 => {
          let val = TIOError::read_from_in_protocol(i_prot)?;
          f_1 = Some(val);
        },
        2 => {
          let val = TIllegalArgument::read_from_in_protocol(i_prot)?;
          f_2 = Some(val);
        },
        _ => {
          i_prot.skip(field_ident.field_type)?;
        },
      };
      i_prot.read_field_end()?;
    }
    i_prot.read_struct_end()?;
    let ret = THBaseServiceGetScannerRowsResult {
      result_value: f_0,
      io: f_1,
      ia: f_2,
    };
    Ok(ret)
  }
  fn write_to_out_protocol(&self, o_prot: &mut dyn TOutputProtocol) -> thrift::Result<()> {
    let struct_ident = TStructIdentifier::new("THBaseServiceGetScannerRowsResult");
    o_prot.write_struct_begin(&struct_ident)?;
    if let Some(ref fld_var) = self.result_value {
      o_prot.write_field_begin(&TFieldIdentifier::new("result_value", TType::List, 0))?;
      o_prot.write_list_begin(&TListIdentifier::new(TType::Struct, fld_var.len() as i32))?;
      for e in fld_var {
        e.write_to_out_protocol(o_prot)?;
      }
      o_prot.write_list_end()?;
      o_prot.write_field_end()?
    }
    if let Some(ref fld_var) = self.io {
      o_prot.write_field_begin(&TFieldIdentifier::new("io", TType::Struct, 1))?;
      fld_var.write_to_out_protocol(o_prot)?;
      o_prot.write_field_end()?
    }
    if let Some(ref fld_var) = self.ia {
      o_prot.write_field_begin(&TFieldIdentifier::new("ia", TType::Struct, 2))?;
      fld_var.write_to_out_protocol(o_prot)?;
      o_prot.write_field_end()?
    }
    o_prot.write_field_stop()?;
    o_prot.write_struct_end()
  }
  fn ok_or(self) -> thrift::Result<Vec<TResult>> {
    if self.io.is_some() {
      Err(thrift::Error::User(Box::new(self.io.unwrap())))
    } else if self.ia.is_some() {
      Err(thrift::Error::User(Box::new(self.ia.unwrap())))
    } else if self.result_value.is_some() {
      Ok(self.result_value.unwrap())
    } else {
      Err(
        thrift::Error::Application(
          ApplicationError::new(
            ApplicationErrorKind::MissingResult,
            "no result received for THBaseServiceGetScannerRows"
          )
        )
      )
    }
  }
}

//
// THBaseServiceCloseScannerArgs
//

#[derive(Clone, Debug, Eq, Hash, Ord, PartialEq, PartialOrd)]
struct THBaseServiceCloseScannerArgs {
  /// the Id of the Scanner to close *
  scanner_id: i32,
}

impl THBaseServiceCloseScannerArgs {
  fn read_from_in_protocol(i_prot: &mut dyn TInputProtocol) -> thrift::Result<THBaseServiceCloseScannerArgs> {
    i_prot.read_struct_begin()?;
    let mut f_1: Option<i32> = None;
    loop {
      let field_ident = i_prot.read_field_begin()?;
      if field_ident.field_type == TType::Stop {
        break;
      }
      let field_id = field_id(&field_ident)?;
      match field_id {
        1 => {
          let val = i_prot.read_i32()?;
          f_1 = Some(val);
        },
        _ => {
          i_prot.skip(field_ident.field_type)?;
        },
      };
      i_prot.read_field_end()?;
    }
    i_prot.read_struct_end()?;
    verify_required_field_exists("THBaseServiceCloseScannerArgs.scanner_id", &f_1)?;
    let ret = THBaseServiceCloseScannerArgs {
      scanner_id: f_1.expect("auto-generated code should have checked for presence of required fields"),
    };
    Ok(ret)
  }
  fn write_to_out_protocol(&self, o_prot: &mut dyn TOutputProtocol) -> thrift::Result<()> {
    let struct_ident = TStructIdentifier::new("closeScanner_args");
    o_prot.write_struct_begin(&struct_ident)?;
    o_prot.write_field_begin(&TFieldIdentifier::new("scannerId", TType::I32, 1))?;
    o_prot.write_i32(self.scanner_id)?;
    o_prot.write_field_end()?;
    o_prot.write_field_stop()?;
    o_prot.write_struct_end()
  }
}

//
// THBaseServiceCloseScannerResult
//

#[derive(Clone, Debug, Eq, Hash, Ord, PartialEq, PartialOrd)]
struct THBaseServiceCloseScannerResult {
  io: Option<TIOError>,
  /// if the scannerId is invalid
  ia: Option<TIllegalArgument>,
}

impl THBaseServiceCloseScannerResult {
  fn read_from_in_protocol(i_prot: &mut dyn TInputProtocol) -> thrift::Result<THBaseServiceCloseScannerResult> {
    i_prot.read_struct_begin()?;
    let mut f_1: Option<TIOError> = None;
    let mut f_2: Option<TIllegalArgument> = None;
    loop {
      let field_ident = i_prot.read_field_begin()?;
      if field_ident.field_type == TType::Stop {
        break;
      }
      let field_id = field_id(&field_ident)?;
      match field_id {
        1 => {
          let val = TIOError::read_from_in_protocol(i_prot)?;
          f_1 = Some(val);
        },
        2 => {
          let val = TIllegalArgument::read_from_in_protocol(i_prot)?;
          f_2 = Some(val);
        },
        _ => {
          i_prot.skip(field_ident.field_type)?;
        },
      };
      i_prot.read_field_end()?;
    }
    i_prot.read_struct_end()?;
    let ret = THBaseServiceCloseScannerResult {
      io: f_1,
      ia: f_2,
    };
    Ok(ret)
  }
  fn write_to_out_protocol(&self, o_prot: &mut dyn TOutputProtocol) -> thrift::Result<()> {
    let struct_ident = TStructIdentifier::new("THBaseServiceCloseScannerResult");
    o_prot.write_struct_begin(&struct_ident)?;
    if let Some(ref fld_var) = self.io {
      o_prot.write_field_begin(&TFieldIdentifier::new("io", TType::Struct, 1))?;
      fld_var.write_to_out_protocol(o_prot)?;
      o_prot.write_field_end()?
    }
    if let Some(ref fld_var) = self.ia {
      o_prot.write_field_begin(&TFieldIdentifier::new("ia", TType::Struct, 2))?;
      fld_var.write_to_out_protocol(o_prot)?;
      o_prot.write_field_end()?
    }
    o_prot.write_field_stop()?;
    o_prot.write_struct_end()
  }
  fn ok_or(self) -> thrift::Result<()> {
    if self.io.is_some() {
      Err(thrift::Error::User(Box::new(self.io.unwrap())))
    } else if self.ia.is_some() {
      Err(thrift::Error::User(Box::new(self.ia.unwrap())))
    } else {
      Ok(())
    }
  }
}

//
// THBaseServiceMutateRowArgs
//

#[derive(Clone, Debug, Eq, Hash, Ord, PartialEq, PartialOrd)]
struct THBaseServiceMutateRowArgs {
  /// table to apply the mutations
  table: Vec<u8>,
  /// mutations to apply
  trow_mutations: TRowMutations,
}

impl THBaseServiceMutateRowArgs {
  fn read_from_in_protocol(i_prot: &mut dyn TInputProtocol) -> thrift::Result<THBaseServiceMutateRowArgs> {
    i_prot.read_struct_begin()?;
    let mut f_1: Option<Vec<u8>> = None;
    let mut f_2: Option<TRowMutations> = None;
    loop {
      let field_ident = i_prot.read_field_begin()?;
      if field_ident.field_type == TType::Stop {
        break;
      }
      let field_id = field_id(&field_ident)?;
      match field_id {
        1 => {
          let val = i_prot.read_bytes()?;
          f_1 = Some(val);
        },
        2 => {
          let val = TRowMutations::read_from_in_protocol(i_prot)?;
          f_2 = Some(val);
        },
        _ => {
          i_prot.skip(field_ident.field_type)?;
        },
      };
      i_prot.read_field_end()?;
    }
    i_prot.read_struct_end()?;
    verify_required_field_exists("THBaseServiceMutateRowArgs.table", &f_1)?;
    verify_required_field_exists("THBaseServiceMutateRowArgs.trow_mutations", &f_2)?;
    let ret = THBaseServiceMutateRowArgs {
      table: f_1.expect("auto-generated code should have checked for presence of required fields"),
      trow_mutations: f_2.expect("auto-generated code should have checked for presence of required fields"),
    };
    Ok(ret)
  }
  fn write_to_out_protocol(&self, o_prot: &mut dyn TOutputProtocol) -> thrift::Result<()> {
    let struct_ident = TStructIdentifier::new("mutateRow_args");
    o_prot.write_struct_begin(&struct_ident)?;
    o_prot.write_field_begin(&TFieldIdentifier::new("table", TType::String, 1))?;
    o_prot.write_bytes(&self.table)?;
    o_prot.write_field_end()?;
    o_prot.write_field_begin(&TFieldIdentifier::new("trowMutations", TType::Struct, 2))?;
    self.trow_mutations.write_to_out_protocol(o_prot)?;
    o_prot.write_field_end()?;
    o_prot.write_field_stop()?;
    o_prot.write_struct_end()
  }
}

//
// THBaseServiceMutateRowResult
//

#[derive(Clone, Debug, Eq, Hash, Ord, PartialEq, PartialOrd)]
struct THBaseServiceMutateRowResult {
  io: Option<TIOError>,
}

impl THBaseServiceMutateRowResult {
  fn read_from_in_protocol(i_prot: &mut dyn TInputProtocol) -> thrift::Result<THBaseServiceMutateRowResult> {
    i_prot.read_struct_begin()?;
    let mut f_1: Option<TIOError> = None;
    loop {
      let field_ident = i_prot.read_field_begin()?;
      if field_ident.field_type == TType::Stop {
        break;
      }
      let field_id = field_id(&field_ident)?;
      match field_id {
        1 => {
          let val = TIOError::read_from_in_protocol(i_prot)?;
          f_1 = Some(val);
        },
        _ => {
          i_prot.skip(field_ident.field_type)?;
        },
      };
      i_prot.read_field_end()?;
    }
    i_prot.read_struct_end()?;
    let ret = THBaseServiceMutateRowResult {
      io: f_1,
    };
    Ok(ret)
  }
  fn write_to_out_protocol(&self, o_prot: &mut dyn TOutputProtocol) -> thrift::Result<()> {
    let struct_ident = TStructIdentifier::new("THBaseServiceMutateRowResult");
    o_prot.write_struct_begin(&struct_ident)?;
    if let Some(ref fld_var) = self.io {
      o_prot.write_field_begin(&TFieldIdentifier::new("io", TType::Struct, 1))?;
      fld_var.write_to_out_protocol(o_prot)?;
      o_prot.write_field_end()?
    }
    o_prot.write_field_stop()?;
    o_prot.write_struct_end()
  }
  fn ok_or(self) -> thrift::Result<()> {
    if self.io.is_some() {
      Err(thrift::Error::User(Box::new(self.io.unwrap())))
    } else {
      Ok(())
    }
  }
}

//
// THBaseServiceGetScannerResultsArgs
//

#[derive(Clone, Debug, Eq, Hash, Ord, PartialEq, PartialOrd)]
struct THBaseServiceGetScannerResultsArgs {
  /// the table to get the Scanner for
  table: Vec<u8>,
  /// the scan object to get a Scanner for
  tscan: TScan,
  /// number of rows to return
  num_rows: i32,
}

impl THBaseServiceGetScannerResultsArgs {
  fn read_from_in_protocol(i_prot: &mut dyn TInputProtocol) -> thrift::Result<THBaseServiceGetScannerResultsArgs> {
    i_prot.read_struct_begin()?;
    let mut f_1: Option<Vec<u8>> = None;
    let mut f_2: Option<TScan> = None;
    let mut f_3: Option<i32> = None;
    loop {
      let field_ident = i_prot.read_field_begin()?;
      if field_ident.field_type == TType::Stop {
        break;
      }
      let field_id = field_id(&field_ident)?;
      match field_id {
        1 => {
          let val = i_prot.read_bytes()?;
          f_1 = Some(val);
        },
        2 => {
          let val = TScan::read_from_in_protocol(i_prot)?;
          f_2 = Some(val);
        },
        3 => {
          let val = i_prot.read_i32()?;
          f_3 = Some(val);
        },
        _ => {
          i_prot.skip(field_ident.field_type)?;
        },
      };
      i_prot.read_field_end()?;
    }
    i_prot.read_struct_end()?;
    verify_required_field_exists("THBaseServiceGetScannerResultsArgs.table", &f_1)?;
    verify_required_field_exists("THBaseServiceGetScannerResultsArgs.tscan", &f_2)?;
    verify_required_field_exists("THBaseServiceGetScannerResultsArgs.num_rows", &f_3)?;
    let ret = THBaseServiceGetScannerResultsArgs {
      table: f_1.expect("auto-generated code should have checked for presence of required fields"),
      tscan: f_2.expect("auto-generated code should have checked for presence of required fields"),
      num_rows: f_3.expect("auto-generated code should have checked for presence of required fields"),
    };
    Ok(ret)
  }
  fn write_to_out_protocol(&self, o_prot: &mut dyn TOutputProtocol) -> thrift::Result<()> {
    let struct_ident = TStructIdentifier::new("getScannerResults_args");
    o_prot.write_struct_begin(&struct_ident)?;
    o_prot.write_field_begin(&TFieldIdentifier::new("table", TType::String, 1))?;
    o_prot.write_bytes(&self.table)?;
    o_prot.write_field_end()?;
    o_prot.write_field_begin(&TFieldIdentifier::new("tscan", TType::Struct, 2))?;
    self.tscan.write_to_out_protocol(o_prot)?;
    o_prot.write_field_end()?;
    o_prot.write_field_begin(&TFieldIdentifier::new("numRows", TType::I32, 3))?;
    o_prot.write_i32(self.num_rows)?;
    o_prot.write_field_end()?;
    o_prot.write_field_stop()?;
    o_prot.write_struct_end()
  }
}

//
// THBaseServiceGetScannerResultsResult
//

#[derive(Clone, Debug, Eq, Hash, Ord, PartialEq, PartialOrd)]
struct THBaseServiceGetScannerResultsResult {
  result_value: Option<Vec<TResult>>,
  io: Option<TIOError>,
}

impl THBaseServiceGetScannerResultsResult {
  fn read_from_in_protocol(i_prot: &mut dyn TInputProtocol) -> thrift::Result<THBaseServiceGetScannerResultsResult> {
    i_prot.read_struct_begin()?;
    let mut f_0: Option<Vec<TResult>> = None;
    let mut f_1: Option<TIOError> = None;
    loop {
      let field_ident = i_prot.read_field_begin()?;
      if field_ident.field_type == TType::Stop {
        break;
      }
      let field_id = field_id(&field_ident)?;
      match field_id {
        0 => {
          let list_ident = i_prot.read_list_begin()?;
          let mut val: Vec<TResult> = Vec::with_capacity(list_ident.size as usize);
          for _ in 0..list_ident.size {
            let list_elem_40 = TResult::read_from_in_protocol(i_prot)?;
            val.push(list_elem_40);
          }
          i_prot.read_list_end()?;
          f_0 = Some(val);
        },
        1 => {
          let val = TIOError::read_from_in_protocol(i_prot)?;
          f_1 = Some(val);
        },
        _ => {
          i_prot.skip(field_ident.field_type)?;
        },
      };
      i_prot.read_field_end()?;
    }
    i_prot.read_struct_end()?;
    let ret = THBaseServiceGetScannerResultsResult {
      result_value: f_0,
      io: f_1,
    };
    Ok(ret)
  }
  fn write_to_out_protocol(&self, o_prot: &mut dyn TOutputProtocol) -> thrift::Result<()> {
    let struct_ident = TStructIdentifier::new("THBaseServiceGetScannerResultsResult");
    o_prot.write_struct_begin(&struct_ident)?;
    if let Some(ref fld_var) = self.result_value {
      o_prot.write_field_begin(&TFieldIdentifier::new("result_value", TType::List, 0))?;
      o_prot.write_list_begin(&TListIdentifier::new(TType::Struct, fld_var.len() as i32))?;
      for e in fld_var {
        e.write_to_out_protocol(o_prot)?;
      }
      o_prot.write_list_end()?;
      o_prot.write_field_end()?
    }
    if let Some(ref fld_var) = self.io {
      o_prot.write_field_begin(&TFieldIdentifier::new("io", TType::Struct, 1))?;
      fld_var.write_to_out_protocol(o_prot)?;
      o_prot.write_field_end()?
    }
    o_prot.write_field_stop()?;
    o_prot.write_struct_end()
  }
  fn ok_or(self) -> thrift::Result<Vec<TResult>> {
    if self.io.is_some() {
      Err(thrift::Error::User(Box::new(self.io.unwrap())))
    } else if self.result_value.is_some() {
      Ok(self.result_value.unwrap())
    } else {
      Err(
        thrift::Error::Application(
          ApplicationError::new(
            ApplicationErrorKind::MissingResult,
            "no result received for THBaseServiceGetScannersResult"
          )
        )
      )
    }
  }
}

//
// THBaseServiceGetRegionLocationArgs
//

#[derive(Clone, Debug, Eq, Hash, Ord, PartialEq, PartialOrd)]
struct THBaseServiceGetRegionLocationArgs {
  table: Vec<u8>,
  row: Vec<u8>,
  reload: bool,
}

impl THBaseServiceGetRegionLocationArgs {
  fn read_from_in_protocol(i_prot: &mut dyn TInputProtocol) -> thrift::Result<THBaseServiceGetRegionLocationArgs> {
    i_prot.read_struct_begin()?;
    let mut f_1: Option<Vec<u8>> = None;
    let mut f_2: Option<Vec<u8>> = None;
    let mut f_3: Option<bool> = None;
    loop {
      let field_ident = i_prot.read_field_begin()?;
      if field_ident.field_type == TType::Stop {
        break;
      }
      let field_id = field_id(&field_ident)?;
      match field_id {
        1 => {
          let val = i_prot.read_bytes()?;
          f_1 = Some(val);
        },
        2 => {
          let val = i_prot.read_bytes()?;
          f_2 = Some(val);
        },
        3 => {
          let val = i_prot.read_bool()?;
          f_3 = Some(val);
        },
        _ => {
          i_prot.skip(field_ident.field_type)?;
        },
      };
      i_prot.read_field_end()?;
    }
    i_prot.read_struct_end()?;
    verify_required_field_exists("THBaseServiceGetRegionLocationArgs.table", &f_1)?;
    verify_required_field_exists("THBaseServiceGetRegionLocationArgs.row", &f_2)?;
    verify_required_field_exists("THBaseServiceGetRegionLocationArgs.reload", &f_3)?;
    let ret = THBaseServiceGetRegionLocationArgs {
      table: f_1.expect("auto-generated code should have checked for presence of required fields"),
      row: f_2.expect("auto-generated code should have checked for presence of required fields"),
      reload: f_3.expect("auto-generated code should have checked for presence of required fields"),
    };
    Ok(ret)
  }
  fn write_to_out_protocol(&self, o_prot: &mut dyn TOutputProtocol) -> thrift::Result<()> {
    let struct_ident = TStructIdentifier::new("getRegionLocation_args");
    o_prot.write_struct_begin(&struct_ident)?;
    o_prot.write_field_begin(&TFieldIdentifier::new("table", TType::String, 1))?;
    o_prot.write_bytes(&self.table)?;
    o_prot.write_field_end()?;
    o_prot.write_field_begin(&TFieldIdentifier::new("row", TType::String, 2))?;
    o_prot.write_bytes(&self.row)?;
    o_prot.write_field_end()?;
    o_prot.write_field_begin(&TFieldIdentifier::new("reload", TType::Bool, 3))?;
    o_prot.write_bool(self.reload)?;
    o_prot.write_field_end()?;
    o_prot.write_field_stop()?;
    o_prot.write_struct_end()
  }
}

//
// THBaseServiceGetRegionLocationResult
//

#[derive(Clone, Debug, Eq, Hash, Ord, PartialEq, PartialOrd)]
struct THBaseServiceGetRegionLocationResult {
  result_value: Option<THRegionLocation>,
  io: Option<TIOError>,
}

impl THBaseServiceGetRegionLocationResult {
  fn read_from_in_protocol(i_prot: &mut dyn TInputProtocol) -> thrift::Result<THBaseServiceGetRegionLocationResult> {
    i_prot.read_struct_begin()?;
    let mut f_0: Option<THRegionLocation> = None;
    let mut f_1: Option<TIOError> = None;
    loop {
      let field_ident = i_prot.read_field_begin()?;
      if field_ident.field_type == TType::Stop {
        break;
      }
      let field_id = field_id(&field_ident)?;
      match field_id {
        0 => {
          let val = THRegionLocation::read_from_in_protocol(i_prot)?;
          f_0 = Some(val);
        },
        1 => {
          let val = TIOError::read_from_in_protocol(i_prot)?;
          f_1 = Some(val);
        },
        _ => {
          i_prot.skip(field_ident.field_type)?;
        },
      };
      i_prot.read_field_end()?;
    }
    i_prot.read_struct_end()?;
    let ret = THBaseServiceGetRegionLocationResult {
      result_value: f_0,
      io: f_1,
    };
    Ok(ret)
  }
  fn write_to_out_protocol(&self, o_prot: &mut dyn TOutputProtocol) -> thrift::Result<()> {
    let struct_ident = TStructIdentifier::new("THBaseServiceGetRegionLocationResult");
    o_prot.write_struct_begin(&struct_ident)?;
    if let Some(ref fld_var) = self.result_value {
      o_prot.write_field_begin(&TFieldIdentifier::new("result_value", TType::Struct, 0))?;
      fld_var.write_to_out_protocol(o_prot)?;
      o_prot.write_field_end()?
    }
    if let Some(ref fld_var) = self.io {
      o_prot.write_field_begin(&TFieldIdentifier::new("io", TType::Struct, 1))?;
      fld_var.write_to_out_protocol(o_prot)?;
      o_prot.write_field_end()?
    }
    o_prot.write_field_stop()?;
    o_prot.write_struct_end()
  }
  fn ok_or(self) -> thrift::Result<THRegionLocation> {
    if self.io.is_some() {
      Err(thrift::Error::User(Box::new(self.io.unwrap())))
    } else if self.result_value.is_some() {
      Ok(self.result_value.unwrap())
    } else {
      Err(
        thrift::Error::Application(
          ApplicationError::new(
            ApplicationErrorKind::MissingResult,
            "no result received for THBaseServiceGetRegionLocation"
          )
        )
      )
    }
  }
}

//
// THBaseServiceGetAllRegionLocationsArgs
//

#[derive(Clone, Debug, Eq, Hash, Ord, PartialEq, PartialOrd)]
struct THBaseServiceGetAllRegionLocationsArgs {
  table: Vec<u8>,
}

impl THBaseServiceGetAllRegionLocationsArgs {
  fn read_from_in_protocol(i_prot: &mut dyn TInputProtocol) -> thrift::Result<THBaseServiceGetAllRegionLocationsArgs> {
    i_prot.read_struct_begin()?;
    let mut f_1: Option<Vec<u8>> = None;
    loop {
      let field_ident = i_prot.read_field_begin()?;
      if field_ident.field_type == TType::Stop {
        break;
      }
      let field_id = field_id(&field_ident)?;
      match field_id {
        1 => {
          let val = i_prot.read_bytes()?;
          f_1 = Some(val);
        },
        _ => {
          i_prot.skip(field_ident.field_type)?;
        },
      };
      i_prot.read_field_end()?;
    }
    i_prot.read_struct_end()?;
    verify_required_field_exists("THBaseServiceGetAllRegionLocationsArgs.table", &f_1)?;
    let ret = THBaseServiceGetAllRegionLocationsArgs {
      table: f_1.expect("auto-generated code should have checked for presence of required fields"),
    };
    Ok(ret)
  }
  fn write_to_out_protocol(&self, o_prot: &mut dyn TOutputProtocol) -> thrift::Result<()> {
    let struct_ident = TStructIdentifier::new("getAllRegionLocations_args");
    o_prot.write_struct_begin(&struct_ident)?;
    o_prot.write_field_begin(&TFieldIdentifier::new("table", TType::String, 1))?;
    o_prot.write_bytes(&self.table)?;
    o_prot.write_field_end()?;
    o_prot.write_field_stop()?;
    o_prot.write_struct_end()
  }
}

//
// THBaseServiceGetAllRegionLocationsResult
//

#[derive(Clone, Debug, Eq, Hash, Ord, PartialEq, PartialOrd)]
struct THBaseServiceGetAllRegionLocationsResult {
  result_value: Option<Vec<THRegionLocation>>,
  io: Option<TIOError>,
}

impl THBaseServiceGetAllRegionLocationsResult {
  fn read_from_in_protocol(i_prot: &mut dyn TInputProtocol) -> thrift::Result<THBaseServiceGetAllRegionLocationsResult> {
    i_prot.read_struct_begin()?;
    let mut f_0: Option<Vec<THRegionLocation>> = None;
    let mut f_1: Option<TIOError> = None;
    loop {
      let field_ident = i_prot.read_field_begin()?;
      if field_ident.field_type == TType::Stop {
        break;
      }
      let field_id = field_id(&field_ident)?;
      match field_id {
        0 => {
          let list_ident = i_prot.read_list_begin()?;
          let mut val: Vec<THRegionLocation> = Vec::with_capacity(list_ident.size as usize);
          for _ in 0..list_ident.size {
            let list_elem_41 = THRegionLocation::read_from_in_protocol(i_prot)?;
            val.push(list_elem_41);
          }
          i_prot.read_list_end()?;
          f_0 = Some(val);
        },
        1 => {
          let val = TIOError::read_from_in_protocol(i_prot)?;
          f_1 = Some(val);
        },
        _ => {
          i_prot.skip(field_ident.field_type)?;
        },
      };
      i_prot.read_field_end()?;
    }
    i_prot.read_struct_end()?;
    let ret = THBaseServiceGetAllRegionLocationsResult {
      result_value: f_0,
      io: f_1,
    };
    Ok(ret)
  }
  fn write_to_out_protocol(&self, o_prot: &mut dyn TOutputProtocol) -> thrift::Result<()> {
    let struct_ident = TStructIdentifier::new("THBaseServiceGetAllRegionLocationsResult");
    o_prot.write_struct_begin(&struct_ident)?;
    if let Some(ref fld_var) = self.result_value {
      o_prot.write_field_begin(&TFieldIdentifier::new("result_value", TType::List, 0))?;
      o_prot.write_list_begin(&TListIdentifier::new(TType::Struct, fld_var.len() as i32))?;
      for e in fld_var {
        e.write_to_out_protocol(o_prot)?;
      }
      o_prot.write_list_end()?;
      o_prot.write_field_end()?
    }
    if let Some(ref fld_var) = self.io {
      o_prot.write_field_begin(&TFieldIdentifier::new("io", TType::Struct, 1))?;
      fld_var.write_to_out_protocol(o_prot)?;
      o_prot.write_field_end()?
    }
    o_prot.write_field_stop()?;
    o_prot.write_struct_end()
  }
  fn ok_or(self) -> thrift::Result<Vec<THRegionLocation>> {
    if self.io.is_some() {
      Err(thrift::Error::User(Box::new(self.io.unwrap())))
    } else if self.result_value.is_some() {
      Ok(self.result_value.unwrap())
    } else {
      Err(
        thrift::Error::Application(
          ApplicationError::new(
            ApplicationErrorKind::MissingResult,
            "no result received for THBaseServiceGetAllRegionLocations"
          )
        )
      )
    }
  }
}

//
// THBaseServiceCheckAndMutateArgs
//

#[derive(Clone, Debug, Eq, Hash, Ord, PartialEq, PartialOrd)]
struct THBaseServiceCheckAndMutateArgs {
  /// to check in and delete from
  table: Vec<u8>,
  /// row to check
  row: Vec<u8>,
  /// column family to check
  family: Vec<u8>,
  /// column qualifier to check
  qualifier: Vec<u8>,
  /// comparison to make on the value
  compare_operator: TCompareOperator,
  /// the expected value to be compared against, if not provided the
  /// check is for the non-existence of the column in question
  value: Vec<u8>,
  /// row mutations to execute if the value matches
  row_mutations: TRowMutations,
}

impl THBaseServiceCheckAndMutateArgs {
  fn read_from_in_protocol(i_prot: &mut dyn TInputProtocol) -> thrift::Result<THBaseServiceCheckAndMutateArgs> {
    i_prot.read_struct_begin()?;
    let mut f_1: Option<Vec<u8>> = None;
    let mut f_2: Option<Vec<u8>> = None;
    let mut f_3: Option<Vec<u8>> = None;
    let mut f_4: Option<Vec<u8>> = None;
    let mut f_5: Option<TCompareOperator> = None;
    let mut f_6: Option<Vec<u8>> = None;
    let mut f_7: Option<TRowMutations> = None;
    loop {
      let field_ident = i_prot.read_field_begin()?;
      if field_ident.field_type == TType::Stop {
        break;
      }
      let field_id = field_id(&field_ident)?;
      match field_id {
        1 => {
          let val = i_prot.read_bytes()?;
          f_1 = Some(val);
        },
        2 => {
          let val = i_prot.read_bytes()?;
          f_2 = Some(val);
        },
        3 => {
          let val = i_prot.read_bytes()?;
          f_3 = Some(val);
        },
        4 => {
          let val = i_prot.read_bytes()?;
          f_4 = Some(val);
        },
        5 => {
          let val = TCompareOperator::read_from_in_protocol(i_prot)?;
          f_5 = Some(val);
        },
        6 => {
          let val = i_prot.read_bytes()?;
          f_6 = Some(val);
        },
        7 => {
          let val = TRowMutations::read_from_in_protocol(i_prot)?;
          f_7 = Some(val);
        },
        _ => {
          i_prot.skip(field_ident.field_type)?;
        },
      };
      i_prot.read_field_end()?;
    }
    i_prot.read_struct_end()?;
    verify_required_field_exists("THBaseServiceCheckAndMutateArgs.table", &f_1)?;
    verify_required_field_exists("THBaseServiceCheckAndMutateArgs.row", &f_2)?;
    verify_required_field_exists("THBaseServiceCheckAndMutateArgs.family", &f_3)?;
    verify_required_field_exists("THBaseServiceCheckAndMutateArgs.qualifier", &f_4)?;
    verify_required_field_exists("THBaseServiceCheckAndMutateArgs.compare_operator", &f_5)?;
    verify_required_field_exists("THBaseServiceCheckAndMutateArgs.value", &f_6)?;
    verify_required_field_exists("THBaseServiceCheckAndMutateArgs.row_mutations", &f_7)?;
    let ret = THBaseServiceCheckAndMutateArgs {
      table: f_1.expect("auto-generated code should have checked for presence of required fields"),
      row: f_2.expect("auto-generated code should have checked for presence of required fields"),
      family: f_3.expect("auto-generated code should have checked for presence of required fields"),
      qualifier: f_4.expect("auto-generated code should have checked for presence of required fields"),
      compare_operator: f_5.expect("auto-generated code should have checked for presence of required fields"),
      value: f_6.expect("auto-generated code should have checked for presence of required fields"),
      row_mutations: f_7.expect("auto-generated code should have checked for presence of required fields"),
    };
    Ok(ret)
  }
  fn write_to_out_protocol(&self, o_prot: &mut dyn TOutputProtocol) -> thrift::Result<()> {
    let struct_ident = TStructIdentifier::new("checkAndMutate_args");
    o_prot.write_struct_begin(&struct_ident)?;
    o_prot.write_field_begin(&TFieldIdentifier::new("table", TType::String, 1))?;
    o_prot.write_bytes(&self.table)?;
    o_prot.write_field_end()?;
    o_prot.write_field_begin(&TFieldIdentifier::new("row", TType::String, 2))?;
    o_prot.write_bytes(&self.row)?;
    o_prot.write_field_end()?;
    o_prot.write_field_begin(&TFieldIdentifier::new("family", TType::String, 3))?;
    o_prot.write_bytes(&self.family)?;
    o_prot.write_field_end()?;
    o_prot.write_field_begin(&TFieldIdentifier::new("qualifier", TType::String, 4))?;
    o_prot.write_bytes(&self.qualifier)?;
    o_prot.write_field_end()?;
    o_prot.write_field_begin(&TFieldIdentifier::new("compareOperator", TType::I32, 5))?;
    self.compare_operator.write_to_out_protocol(o_prot)?;
    o_prot.write_field_end()?;
    o_prot.write_field_begin(&TFieldIdentifier::new("value", TType::String, 6))?;
    o_prot.write_bytes(&self.value)?;
    o_prot.write_field_end()?;
    o_prot.write_field_begin(&TFieldIdentifier::new("rowMutations", TType::Struct, 7))?;
    self.row_mutations.write_to_out_protocol(o_prot)?;
    o_prot.write_field_end()?;
    o_prot.write_field_stop()?;
    o_prot.write_struct_end()
  }
}

//
// THBaseServiceCheckAndMutateResult
//

#[derive(Clone, Debug, Eq, Hash, Ord, PartialEq, PartialOrd)]
struct THBaseServiceCheckAndMutateResult {
  result_value: Option<bool>,
  io: Option<TIOError>,
}

impl THBaseServiceCheckAndMutateResult {
  fn read_from_in_protocol(i_prot: &mut dyn TInputProtocol) -> thrift::Result<THBaseServiceCheckAndMutateResult> {
    i_prot.read_struct_begin()?;
    let mut f_0: Option<bool> = None;
    let mut f_1: Option<TIOError> = None;
    loop {
      let field_ident = i_prot.read_field_begin()?;
      if field_ident.field_type == TType::Stop {
        break;
      }
      let field_id = field_id(&field_ident)?;
      match field_id {
        0 => {
          let val = i_prot.read_bool()?;
          f_0 = Some(val);
        },
        1 => {
          let val = TIOError::read_from_in_protocol(i_prot)?;
          f_1 = Some(val);
        },
        _ => {
          i_prot.skip(field_ident.field_type)?;
        },
      };
      i_prot.read_field_end()?;
    }
    i_prot.read_struct_end()?;
    let ret = THBaseServiceCheckAndMutateResult {
      result_value: f_0,
      io: f_1,
    };
    Ok(ret)
  }
  fn write_to_out_protocol(&self, o_prot: &mut dyn TOutputProtocol) -> thrift::Result<()> {
    let struct_ident = TStructIdentifier::new("THBaseServiceCheckAndMutateResult");
    o_prot.write_struct_begin(&struct_ident)?;
    if let Some(fld_var) = self.result_value {
      o_prot.write_field_begin(&TFieldIdentifier::new("result_value", TType::Bool, 0))?;
      o_prot.write_bool(fld_var)?;
      o_prot.write_field_end()?
    }
    if let Some(ref fld_var) = self.io {
      o_prot.write_field_begin(&TFieldIdentifier::new("io", TType::Struct, 1))?;
      fld_var.write_to_out_protocol(o_prot)?;
      o_prot.write_field_end()?
    }
    o_prot.write_field_stop()?;
    o_prot.write_struct_end()
  }
  fn ok_or(self) -> thrift::Result<bool> {
    if self.io.is_some() {
      Err(thrift::Error::User(Box::new(self.io.unwrap())))
    } else if self.result_value.is_some() {
      Ok(self.result_value.unwrap())
    } else {
      Err(
        thrift::Error::Application(
          ApplicationError::new(
            ApplicationErrorKind::MissingResult,
            "no result received for THBaseServiceCheckAndMutate"
          )
        )
      )
    }
  }
}

//
// THBaseServiceGetTableDescriptorArgs
//

#[derive(Clone, Debug, Eq, Hash, Ord, PartialEq, PartialOrd)]
struct THBaseServiceGetTableDescriptorArgs {
  /// the tablename of the table to get tableDescriptor
  table: TTableName,
}

impl THBaseServiceGetTableDescriptorArgs {
  fn read_from_in_protocol(i_prot: &mut dyn TInputProtocol) -> thrift::Result<THBaseServiceGetTableDescriptorArgs> {
    i_prot.read_struct_begin()?;
    let mut f_1: Option<TTableName> = None;
    loop {
      let field_ident = i_prot.read_field_begin()?;
      if field_ident.field_type == TType::Stop {
        break;
      }
      let field_id = field_id(&field_ident)?;
      match field_id {
        1 => {
          let val = TTableName::read_from_in_protocol(i_prot)?;
          f_1 = Some(val);
        },
        _ => {
          i_prot.skip(field_ident.field_type)?;
        },
      };
      i_prot.read_field_end()?;
    }
    i_prot.read_struct_end()?;
    verify_required_field_exists("THBaseServiceGetTableDescriptorArgs.table", &f_1)?;
    let ret = THBaseServiceGetTableDescriptorArgs {
      table: f_1.expect("auto-generated code should have checked for presence of required fields"),
    };
    Ok(ret)
  }
  fn write_to_out_protocol(&self, o_prot: &mut dyn TOutputProtocol) -> thrift::Result<()> {
    let struct_ident = TStructIdentifier::new("getTableDescriptor_args");
    o_prot.write_struct_begin(&struct_ident)?;
    o_prot.write_field_begin(&TFieldIdentifier::new("table", TType::Struct, 1))?;
    self.table.write_to_out_protocol(o_prot)?;
    o_prot.write_field_end()?;
    o_prot.write_field_stop()?;
    o_prot.write_struct_end()
  }
}

//
// THBaseServiceGetTableDescriptorResult
//

#[derive(Clone, Debug, Eq, Hash, Ord, PartialEq, PartialOrd)]
struct THBaseServiceGetTableDescriptorResult {
  result_value: Option<TTableDescriptor>,
  io: Option<TIOError>,
}

impl THBaseServiceGetTableDescriptorResult {
  fn read_from_in_protocol(i_prot: &mut dyn TInputProtocol) -> thrift::Result<THBaseServiceGetTableDescriptorResult> {
    i_prot.read_struct_begin()?;
    let mut f_0: Option<TTableDescriptor> = None;
    let mut f_1: Option<TIOError> = None;
    loop {
      let field_ident = i_prot.read_field_begin()?;
      if field_ident.field_type == TType::Stop {
        break;
      }
      let field_id = field_id(&field_ident)?;
      match field_id {
        0 => {
          let val = TTableDescriptor::read_from_in_protocol(i_prot)?;
          f_0 = Some(val);
        },
        1 => {
          let val = TIOError::read_from_in_protocol(i_prot)?;
          f_1 = Some(val);
        },
        _ => {
          i_prot.skip(field_ident.field_type)?;
        },
      };
      i_prot.read_field_end()?;
    }
    i_prot.read_struct_end()?;
    let ret = THBaseServiceGetTableDescriptorResult {
      result_value: f_0,
      io: f_1,
    };
    Ok(ret)
  }
  fn write_to_out_protocol(&self, o_prot: &mut dyn TOutputProtocol) -> thrift::Result<()> {
    let struct_ident = TStructIdentifier::new("THBaseServiceGetTableDescriptorResult");
    o_prot.write_struct_begin(&struct_ident)?;
    if let Some(ref fld_var) = self.result_value {
      o_prot.write_field_begin(&TFieldIdentifier::new("result_value", TType::Struct, 0))?;
      fld_var.write_to_out_protocol(o_prot)?;
      o_prot.write_field_end()?
    }
    if let Some(ref fld_var) = self.io {
      o_prot.write_field_begin(&TFieldIdentifier::new("io", TType::Struct, 1))?;
      fld_var.write_to_out_protocol(o_prot)?;
      o_prot.write_field_end()?
    }
    o_prot.write_field_stop()?;
    o_prot.write_struct_end()
  }
  fn ok_or(self) -> thrift::Result<TTableDescriptor> {
    if self.io.is_some() {
      Err(thrift::Error::User(Box::new(self.io.unwrap())))
    } else if self.result_value.is_some() {
      Ok(self.result_value.unwrap())
    } else {
      Err(
        thrift::Error::Application(
          ApplicationError::new(
            ApplicationErrorKind::MissingResult,
            "no result received for THBaseServiceGetTableDescriptor"
          )
        )
      )
    }
  }
}

//
// THBaseServiceGetTableDescriptorsArgs
//

#[derive(Clone, Debug, Eq, Hash, Ord, PartialEq, PartialOrd)]
struct THBaseServiceGetTableDescriptorsArgs {
  /// the tablename list of the tables to get tableDescriptor
  tables: Vec<TTableName>,
}

impl THBaseServiceGetTableDescriptorsArgs {
  fn read_from_in_protocol(i_prot: &mut dyn TInputProtocol) -> thrift::Result<THBaseServiceGetTableDescriptorsArgs> {
    i_prot.read_struct_begin()?;
    let mut f_1: Option<Vec<TTableName>> = None;
    loop {
      let field_ident = i_prot.read_field_begin()?;
      if field_ident.field_type == TType::Stop {
        break;
      }
      let field_id = field_id(&field_ident)?;
      match field_id {
        1 => {
          let list_ident = i_prot.read_list_begin()?;
          let mut val: Vec<TTableName> = Vec::with_capacity(list_ident.size as usize);
          for _ in 0..list_ident.size {
            let list_elem_42 = TTableName::read_from_in_protocol(i_prot)?;
            val.push(list_elem_42);
          }
          i_prot.read_list_end()?;
          f_1 = Some(val);
        },
        _ => {
          i_prot.skip(field_ident.field_type)?;
        },
      };
      i_prot.read_field_end()?;
    }
    i_prot.read_struct_end()?;
    verify_required_field_exists("THBaseServiceGetTableDescriptorsArgs.tables", &f_1)?;
    let ret = THBaseServiceGetTableDescriptorsArgs {
      tables: f_1.expect("auto-generated code should have checked for presence of required fields"),
    };
    Ok(ret)
  }
  fn write_to_out_protocol(&self, o_prot: &mut dyn TOutputProtocol) -> thrift::Result<()> {
    let struct_ident = TStructIdentifier::new("getTableDescriptors_args");
    o_prot.write_struct_begin(&struct_ident)?;
    o_prot.write_field_begin(&TFieldIdentifier::new("tables", TType::List, 1))?;
    o_prot.write_list_begin(&TListIdentifier::new(TType::Struct, self.tables.len() as i32))?;
    for e in &self.tables {
      e.write_to_out_protocol(o_prot)?;
    }
    o_prot.write_list_end()?;
    o_prot.write_field_end()?;
    o_prot.write_field_stop()?;
    o_prot.write_struct_end()
  }
}

//
// THBaseServiceGetTableDescriptorsResult
//

#[derive(Clone, Debug, Eq, Hash, Ord, PartialEq, PartialOrd)]
struct THBaseServiceGetTableDescriptorsResult {
  result_value: Option<Vec<TTableDescriptor>>,
  io: Option<TIOError>,
}

impl THBaseServiceGetTableDescriptorsResult {
  fn read_from_in_protocol(i_prot: &mut dyn TInputProtocol) -> thrift::Result<THBaseServiceGetTableDescriptorsResult> {
    i_prot.read_struct_begin()?;
    let mut f_0: Option<Vec<TTableDescriptor>> = None;
    let mut f_1: Option<TIOError> = None;
    loop {
      let field_ident = i_prot.read_field_begin()?;
      if field_ident.field_type == TType::Stop {
        break;
      }
      let field_id = field_id(&field_ident)?;
      match field_id {
        0 => {
          let list_ident = i_prot.read_list_begin()?;
          let mut val: Vec<TTableDescriptor> = Vec::with_capacity(list_ident.size as usize);
          for _ in 0..list_ident.size {
            let list_elem_43 = TTableDescriptor::read_from_in_protocol(i_prot)?;
            val.push(list_elem_43);
          }
          i_prot.read_list_end()?;
          f_0 = Some(val);
        },
        1 => {
          let val = TIOError::read_from_in_protocol(i_prot)?;
          f_1 = Some(val);
        },
        _ => {
          i_prot.skip(field_ident.field_type)?;
        },
      };
      i_prot.read_field_end()?;
    }
    i_prot.read_struct_end()?;
    let ret = THBaseServiceGetTableDescriptorsResult {
      result_value: f_0,
      io: f_1,
    };
    Ok(ret)
  }
  fn write_to_out_protocol(&self, o_prot: &mut dyn TOutputProtocol) -> thrift::Result<()> {
    let struct_ident = TStructIdentifier::new("THBaseServiceGetTableDescriptorsResult");
    o_prot.write_struct_begin(&struct_ident)?;
    if let Some(ref fld_var) = self.result_value {
      o_prot.write_field_begin(&TFieldIdentifier::new("result_value", TType::List, 0))?;
      o_prot.write_list_begin(&TListIdentifier::new(TType::Struct, fld_var.len() as i32))?;
      for e in fld_var {
        e.write_to_out_protocol(o_prot)?;
      }
      o_prot.write_list_end()?;
      o_prot.write_field_end()?
    }
    if let Some(ref fld_var) = self.io {
      o_prot.write_field_begin(&TFieldIdentifier::new("io", TType::Struct, 1))?;
      fld_var.write_to_out_protocol(o_prot)?;
      o_prot.write_field_end()?
    }
    o_prot.write_field_stop()?;
    o_prot.write_struct_end()
  }
  fn ok_or(self) -> thrift::Result<Vec<TTableDescriptor>> {
    if self.io.is_some() {
      Err(thrift::Error::User(Box::new(self.io.unwrap())))
    } else if self.result_value.is_some() {
      Ok(self.result_value.unwrap())
    } else {
      Err(
        thrift::Error::Application(
          ApplicationError::new(
            ApplicationErrorKind::MissingResult,
            "no result received for THBaseServiceGetTableDescriptors"
          )
        )
      )
    }
  }
}

//
// THBaseServiceTableExistsArgs
//

#[derive(Clone, Debug, Eq, Hash, Ord, PartialEq, PartialOrd)]
struct THBaseServiceTableExistsArgs {
  /// the tablename of the tables to check
  table_name: TTableName,
}

impl THBaseServiceTableExistsArgs {
  fn read_from_in_protocol(i_prot: &mut dyn TInputProtocol) -> thrift::Result<THBaseServiceTableExistsArgs> {
    i_prot.read_struct_begin()?;
    let mut f_1: Option<TTableName> = None;
    loop {
      let field_ident = i_prot.read_field_begin()?;
      if field_ident.field_type == TType::Stop {
        break;
      }
      let field_id = field_id(&field_ident)?;
      match field_id {
        1 => {
          let val = TTableName::read_from_in_protocol(i_prot)?;
          f_1 = Some(val);
        },
        _ => {
          i_prot.skip(field_ident.field_type)?;
        },
      };
      i_prot.read_field_end()?;
    }
    i_prot.read_struct_end()?;
    verify_required_field_exists("THBaseServiceTableExistsArgs.table_name", &f_1)?;
    let ret = THBaseServiceTableExistsArgs {
      table_name: f_1.expect("auto-generated code should have checked for presence of required fields"),
    };
    Ok(ret)
  }
  fn write_to_out_protocol(&self, o_prot: &mut dyn TOutputProtocol) -> thrift::Result<()> {
    let struct_ident = TStructIdentifier::new("tableExists_args");
    o_prot.write_struct_begin(&struct_ident)?;
    o_prot.write_field_begin(&TFieldIdentifier::new("tableName", TType::Struct, 1))?;
    self.table_name.write_to_out_protocol(o_prot)?;
    o_prot.write_field_end()?;
    o_prot.write_field_stop()?;
    o_prot.write_struct_end()
  }
}

//
// THBaseServiceTableExistsResult
//

#[derive(Clone, Debug, Eq, Hash, Ord, PartialEq, PartialOrd)]
struct THBaseServiceTableExistsResult {
  result_value: Option<bool>,
  io: Option<TIOError>,
}

impl THBaseServiceTableExistsResult {
  fn read_from_in_protocol(i_prot: &mut dyn TInputProtocol) -> thrift::Result<THBaseServiceTableExistsResult> {
    i_prot.read_struct_begin()?;
    let mut f_0: Option<bool> = None;
    let mut f_1: Option<TIOError> = None;
    loop {
      let field_ident = i_prot.read_field_begin()?;
      if field_ident.field_type == TType::Stop {
        break;
      }
      let field_id = field_id(&field_ident)?;
      match field_id {
        0 => {
          let val = i_prot.read_bool()?;
          f_0 = Some(val);
        },
        1 => {
          let val = TIOError::read_from_in_protocol(i_prot)?;
          f_1 = Some(val);
        },
        _ => {
          i_prot.skip(field_ident.field_type)?;
        },
      };
      i_prot.read_field_end()?;
    }
    i_prot.read_struct_end()?;
    let ret = THBaseServiceTableExistsResult {
      result_value: f_0,
      io: f_1,
    };
    Ok(ret)
  }
  fn write_to_out_protocol(&self, o_prot: &mut dyn TOutputProtocol) -> thrift::Result<()> {
    let struct_ident = TStructIdentifier::new("THBaseServiceTableExistsResult");
    o_prot.write_struct_begin(&struct_ident)?;
    if let Some(fld_var) = self.result_value {
      o_prot.write_field_begin(&TFieldIdentifier::new("result_value", TType::Bool, 0))?;
      o_prot.write_bool(fld_var)?;
      o_prot.write_field_end()?
    }
    if let Some(ref fld_var) = self.io {
      o_prot.write_field_begin(&TFieldIdentifier::new("io", TType::Struct, 1))?;
      fld_var.write_to_out_protocol(o_prot)?;
      o_prot.write_field_end()?
    }
    o_prot.write_field_stop()?;
    o_prot.write_struct_end()
  }
  fn ok_or(self) -> thrift::Result<bool> {
    if self.io.is_some() {
      Err(thrift::Error::User(Box::new(self.io.unwrap())))
    } else if self.result_value.is_some() {
      Ok(self.result_value.unwrap())
    } else {
      Err(
        thrift::Error::Application(
          ApplicationError::new(
            ApplicationErrorKind::MissingResult,
            "no result received for THBaseServiceTableExists"
          )
        )
      )
    }
  }
}

//
// THBaseServiceGetTableDescriptorsByPatternArgs
//

#[derive(Clone, Debug, Eq, Hash, Ord, PartialEq, PartialOrd)]
struct THBaseServiceGetTableDescriptorsByPatternArgs {
  /// The regular expression to match against
  regex: String,
  /// set to false if match only against userspace tables
  include_sys_tables: bool,
}

impl THBaseServiceGetTableDescriptorsByPatternArgs {
  fn read_from_in_protocol(i_prot: &mut dyn TInputProtocol) -> thrift::Result<THBaseServiceGetTableDescriptorsByPatternArgs> {
    i_prot.read_struct_begin()?;
    let mut f_1: Option<String> = None;
    let mut f_2: Option<bool> = None;
    loop {
      let field_ident = i_prot.read_field_begin()?;
      if field_ident.field_type == TType::Stop {
        break;
      }
      let field_id = field_id(&field_ident)?;
      match field_id {
        1 => {
          let val = i_prot.read_string()?;
          f_1 = Some(val);
        },
        2 => {
          let val = i_prot.read_bool()?;
          f_2 = Some(val);
        },
        _ => {
          i_prot.skip(field_ident.field_type)?;
        },
      };
      i_prot.read_field_end()?;
    }
    i_prot.read_struct_end()?;
    verify_required_field_exists("THBaseServiceGetTableDescriptorsByPatternArgs.regex", &f_1)?;
    verify_required_field_exists("THBaseServiceGetTableDescriptorsByPatternArgs.include_sys_tables", &f_2)?;
    let ret = THBaseServiceGetTableDescriptorsByPatternArgs {
      regex: f_1.expect("auto-generated code should have checked for presence of required fields"),
      include_sys_tables: f_2.expect("auto-generated code should have checked for presence of required fields"),
    };
    Ok(ret)
  }
  fn write_to_out_protocol(&self, o_prot: &mut dyn TOutputProtocol) -> thrift::Result<()> {
    let struct_ident = TStructIdentifier::new("getTableDescriptorsByPattern_args");
    o_prot.write_struct_begin(&struct_ident)?;
    o_prot.write_field_begin(&TFieldIdentifier::new("regex", TType::String, 1))?;
    o_prot.write_string(&self.regex)?;
    o_prot.write_field_end()?;
    o_prot.write_field_begin(&TFieldIdentifier::new("includeSysTables", TType::Bool, 2))?;
    o_prot.write_bool(self.include_sys_tables)?;
    o_prot.write_field_end()?;
    o_prot.write_field_stop()?;
    o_prot.write_struct_end()
  }
}

//
// THBaseServiceGetTableDescriptorsByPatternResult
//

#[derive(Clone, Debug, Eq, Hash, Ord, PartialEq, PartialOrd)]
struct THBaseServiceGetTableDescriptorsByPatternResult {
  result_value: Option<Vec<TTableDescriptor>>,
  io: Option<TIOError>,
}

impl THBaseServiceGetTableDescriptorsByPatternResult {
  fn read_from_in_protocol(i_prot: &mut dyn TInputProtocol) -> thrift::Result<THBaseServiceGetTableDescriptorsByPatternResult> {
    i_prot.read_struct_begin()?;
    let mut f_0: Option<Vec<TTableDescriptor>> = None;
    let mut f_1: Option<TIOError> = None;
    loop {
      let field_ident = i_prot.read_field_begin()?;
      if field_ident.field_type == TType::Stop {
        break;
      }
      let field_id = field_id(&field_ident)?;
      match field_id {
        0 => {
          let list_ident = i_prot.read_list_begin()?;
          let mut val: Vec<TTableDescriptor> = Vec::with_capacity(list_ident.size as usize);
          for _ in 0..list_ident.size {
            let list_elem_44 = TTableDescriptor::read_from_in_protocol(i_prot)?;
            val.push(list_elem_44);
          }
          i_prot.read_list_end()?;
          f_0 = Some(val);
        },
        1 => {
          let val = TIOError::read_from_in_protocol(i_prot)?;
          f_1 = Some(val);
        },
        _ => {
          i_prot.skip(field_ident.field_type)?;
        },
      };
      i_prot.read_field_end()?;
    }
    i_prot.read_struct_end()?;
    let ret = THBaseServiceGetTableDescriptorsByPatternResult {
      result_value: f_0,
      io: f_1,
    };
    Ok(ret)
  }
  fn write_to_out_protocol(&self, o_prot: &mut dyn TOutputProtocol) -> thrift::Result<()> {
    let struct_ident = TStructIdentifier::new("THBaseServiceGetTableDescriptorsByPatternResult");
    o_prot.write_struct_begin(&struct_ident)?;
    if let Some(ref fld_var) = self.result_value {
      o_prot.write_field_begin(&TFieldIdentifier::new("result_value", TType::List, 0))?;
      o_prot.write_list_begin(&TListIdentifier::new(TType::Struct, fld_var.len() as i32))?;
      for e in fld_var {
        e.write_to_out_protocol(o_prot)?;
      }
      o_prot.write_list_end()?;
      o_prot.write_field_end()?
    }
    if let Some(ref fld_var) = self.io {
      o_prot.write_field_begin(&TFieldIdentifier::new("io", TType::Struct, 1))?;
      fld_var.write_to_out_protocol(o_prot)?;
      o_prot.write_field_end()?
    }
    o_prot.write_field_stop()?;
    o_prot.write_struct_end()
  }
  fn ok_or(self) -> thrift::Result<Vec<TTableDescriptor>> {
    if self.io.is_some() {
      Err(thrift::Error::User(Box::new(self.io.unwrap())))
    } else if self.result_value.is_some() {
      Ok(self.result_value.unwrap())
    } else {
      Err(
        thrift::Error::Application(
          ApplicationError::new(
            ApplicationErrorKind::MissingResult,
            "no result received for THBaseServiceGetTableDescriptorsByPattern"
          )
        )
      )
    }
  }
}

//
// THBaseServiceGetTableDescriptorsByNamespaceArgs
//

#[derive(Clone, Debug, Eq, Hash, Ord, PartialEq, PartialOrd)]
struct THBaseServiceGetTableDescriptorsByNamespaceArgs {
  /// The namesapce's name
  name: String,
}

impl THBaseServiceGetTableDescriptorsByNamespaceArgs {
  fn read_from_in_protocol(i_prot: &mut dyn TInputProtocol) -> thrift::Result<THBaseServiceGetTableDescriptorsByNamespaceArgs> {
    i_prot.read_struct_begin()?;
    let mut f_1: Option<String> = None;
    loop {
      let field_ident = i_prot.read_field_begin()?;
      if field_ident.field_type == TType::Stop {
        break;
      }
      let field_id = field_id(&field_ident)?;
      match field_id {
        1 => {
          let val = i_prot.read_string()?;
          f_1 = Some(val);
        },
        _ => {
          i_prot.skip(field_ident.field_type)?;
        },
      };
      i_prot.read_field_end()?;
    }
    i_prot.read_struct_end()?;
    verify_required_field_exists("THBaseServiceGetTableDescriptorsByNamespaceArgs.name", &f_1)?;
    let ret = THBaseServiceGetTableDescriptorsByNamespaceArgs {
      name: f_1.expect("auto-generated code should have checked for presence of required fields"),
    };
    Ok(ret)
  }
  fn write_to_out_protocol(&self, o_prot: &mut dyn TOutputProtocol) -> thrift::Result<()> {
    let struct_ident = TStructIdentifier::new("getTableDescriptorsByNamespace_args");
    o_prot.write_struct_begin(&struct_ident)?;
    o_prot.write_field_begin(&TFieldIdentifier::new("name", TType::String, 1))?;
    o_prot.write_string(&self.name)?;
    o_prot.write_field_end()?;
    o_prot.write_field_stop()?;
    o_prot.write_struct_end()
  }
}

//
// THBaseServiceGetTableDescriptorsByNamespaceResult
//

#[derive(Clone, Debug, Eq, Hash, Ord, PartialEq, PartialOrd)]
struct THBaseServiceGetTableDescriptorsByNamespaceResult {
  result_value: Option<Vec<TTableDescriptor>>,
  io: Option<TIOError>,
}

impl THBaseServiceGetTableDescriptorsByNamespaceResult {
  fn read_from_in_protocol(i_prot: &mut dyn TInputProtocol) -> thrift::Result<THBaseServiceGetTableDescriptorsByNamespaceResult> {
    i_prot.read_struct_begin()?;
    let mut f_0: Option<Vec<TTableDescriptor>> = None;
    let mut f_1: Option<TIOError> = None;
    loop {
      let field_ident = i_prot.read_field_begin()?;
      if field_ident.field_type == TType::Stop {
        break;
      }
      let field_id = field_id(&field_ident)?;
      match field_id {
        0 => {
          let list_ident = i_prot.read_list_begin()?;
          let mut val: Vec<TTableDescriptor> = Vec::with_capacity(list_ident.size as usize);
          for _ in 0..list_ident.size {
            let list_elem_45 = TTableDescriptor::read_from_in_protocol(i_prot)?;
            val.push(list_elem_45);
          }
          i_prot.read_list_end()?;
          f_0 = Some(val);
        },
        1 => {
          let val = TIOError::read_from_in_protocol(i_prot)?;
          f_1 = Some(val);
        },
        _ => {
          i_prot.skip(field_ident.field_type)?;
        },
      };
      i_prot.read_field_end()?;
    }
    i_prot.read_struct_end()?;
    let ret = THBaseServiceGetTableDescriptorsByNamespaceResult {
      result_value: f_0,
      io: f_1,
    };
    Ok(ret)
  }
  fn write_to_out_protocol(&self, o_prot: &mut dyn TOutputProtocol) -> thrift::Result<()> {
    let struct_ident = TStructIdentifier::new("THBaseServiceGetTableDescriptorsByNamespaceResult");
    o_prot.write_struct_begin(&struct_ident)?;
    if let Some(ref fld_var) = self.result_value {
      o_prot.write_field_begin(&TFieldIdentifier::new("result_value", TType::List, 0))?;
      o_prot.write_list_begin(&TListIdentifier::new(TType::Struct, fld_var.len() as i32))?;
      for e in fld_var {
        e.write_to_out_protocol(o_prot)?;
      }
      o_prot.write_list_end()?;
      o_prot.write_field_end()?
    }
    if let Some(ref fld_var) = self.io {
      o_prot.write_field_begin(&TFieldIdentifier::new("io", TType::Struct, 1))?;
      fld_var.write_to_out_protocol(o_prot)?;
      o_prot.write_field_end()?
    }
    o_prot.write_field_stop()?;
    o_prot.write_struct_end()
  }
  fn ok_or(self) -> thrift::Result<Vec<TTableDescriptor>> {
    if self.io.is_some() {
      Err(thrift::Error::User(Box::new(self.io.unwrap())))
    } else if self.result_value.is_some() {
      Ok(self.result_value.unwrap())
    } else {
      Err(
        thrift::Error::Application(
          ApplicationError::new(
            ApplicationErrorKind::MissingResult,
            "no result received for THBaseServiceGetTableDescriptorsByNamespace"
          )
        )
      )
    }
  }
}

//
// THBaseServiceGetTableNamesByPatternArgs
//

#[derive(Clone, Debug, Eq, Hash, Ord, PartialEq, PartialOrd)]
struct THBaseServiceGetTableNamesByPatternArgs {
  /// The regular expression to match against
  regex: String,
  /// set to false if match only against userspace tables
  include_sys_tables: bool,
}

impl THBaseServiceGetTableNamesByPatternArgs {
  fn read_from_in_protocol(i_prot: &mut dyn TInputProtocol) -> thrift::Result<THBaseServiceGetTableNamesByPatternArgs> {
    i_prot.read_struct_begin()?;
    let mut f_1: Option<String> = None;
    let mut f_2: Option<bool> = None;
    loop {
      let field_ident = i_prot.read_field_begin()?;
      if field_ident.field_type == TType::Stop {
        break;
      }
      let field_id = field_id(&field_ident)?;
      match field_id {
        1 => {
          let val = i_prot.read_string()?;
          f_1 = Some(val);
        },
        2 => {
          let val = i_prot.read_bool()?;
          f_2 = Some(val);
        },
        _ => {
          i_prot.skip(field_ident.field_type)?;
        },
      };
      i_prot.read_field_end()?;
    }
    i_prot.read_struct_end()?;
    verify_required_field_exists("THBaseServiceGetTableNamesByPatternArgs.regex", &f_1)?;
    verify_required_field_exists("THBaseServiceGetTableNamesByPatternArgs.include_sys_tables", &f_2)?;
    let ret = THBaseServiceGetTableNamesByPatternArgs {
      regex: f_1.expect("auto-generated code should have checked for presence of required fields"),
      include_sys_tables: f_2.expect("auto-generated code should have checked for presence of required fields"),
    };
    Ok(ret)
  }
  fn write_to_out_protocol(&self, o_prot: &mut dyn TOutputProtocol) -> thrift::Result<()> {
    let struct_ident = TStructIdentifier::new("getTableNamesByPattern_args");
    o_prot.write_struct_begin(&struct_ident)?;
    o_prot.write_field_begin(&TFieldIdentifier::new("regex", TType::String, 1))?;
    o_prot.write_string(&self.regex)?;
    o_prot.write_field_end()?;
    o_prot.write_field_begin(&TFieldIdentifier::new("includeSysTables", TType::Bool, 2))?;
    o_prot.write_bool(self.include_sys_tables)?;
    o_prot.write_field_end()?;
    o_prot.write_field_stop()?;
    o_prot.write_struct_end()
  }
}

//
// THBaseServiceGetTableNamesByPatternResult
//

#[derive(Clone, Debug, Eq, Hash, Ord, PartialEq, PartialOrd)]
struct THBaseServiceGetTableNamesByPatternResult {
  result_value: Option<Vec<TTableName>>,
  io: Option<TIOError>,
}

impl THBaseServiceGetTableNamesByPatternResult {
  fn read_from_in_protocol(i_prot: &mut dyn TInputProtocol) -> thrift::Result<THBaseServiceGetTableNamesByPatternResult> {
    i_prot.read_struct_begin()?;
    let mut f_0: Option<Vec<TTableName>> = None;
    let mut f_1: Option<TIOError> = None;
    loop {
      let field_ident = i_prot.read_field_begin()?;
      if field_ident.field_type == TType::Stop {
        break;
      }
      let field_id = field_id(&field_ident)?;
      match field_id {
        0 => {
          let list_ident = i_prot.read_list_begin()?;
          let mut val: Vec<TTableName> = Vec::with_capacity(list_ident.size as usize);
          for _ in 0..list_ident.size {
            let list_elem_46 = TTableName::read_from_in_protocol(i_prot)?;
            val.push(list_elem_46);
          }
          i_prot.read_list_end()?;
          f_0 = Some(val);
        },
        1 => {
          let val = TIOError::read_from_in_protocol(i_prot)?;
          f_1 = Some(val);
        },
        _ => {
          i_prot.skip(field_ident.field_type)?;
        },
      };
      i_prot.read_field_end()?;
    }
    i_prot.read_struct_end()?;
    let ret = THBaseServiceGetTableNamesByPatternResult {
      result_value: f_0,
      io: f_1,
    };
    Ok(ret)
  }
  fn write_to_out_protocol(&self, o_prot: &mut dyn TOutputProtocol) -> thrift::Result<()> {
    let struct_ident = TStructIdentifier::new("THBaseServiceGetTableNamesByPatternResult");
    o_prot.write_struct_begin(&struct_ident)?;
    if let Some(ref fld_var) = self.result_value {
      o_prot.write_field_begin(&TFieldIdentifier::new("result_value", TType::List, 0))?;
      o_prot.write_list_begin(&TListIdentifier::new(TType::Struct, fld_var.len() as i32))?;
      for e in fld_var {
        e.write_to_out_protocol(o_prot)?;
      }
      o_prot.write_list_end()?;
      o_prot.write_field_end()?
    }
    if let Some(ref fld_var) = self.io {
      o_prot.write_field_begin(&TFieldIdentifier::new("io", TType::Struct, 1))?;
      fld_var.write_to_out_protocol(o_prot)?;
      o_prot.write_field_end()?
    }
    o_prot.write_field_stop()?;
    o_prot.write_struct_end()
  }
  fn ok_or(self) -> thrift::Result<Vec<TTableName>> {
    if self.io.is_some() {
      Err(thrift::Error::User(Box::new(self.io.unwrap())))
    } else if self.result_value.is_some() {
      Ok(self.result_value.unwrap())
    } else {
      Err(
        thrift::Error::Application(
          ApplicationError::new(
            ApplicationErrorKind::MissingResult,
            "no result received for THBaseServiceGetTableNamesByPattern"
          )
        )
      )
    }
  }
}

//
// THBaseServiceGetTableNamesByNamespaceArgs
//

#[derive(Clone, Debug, Eq, Hash, Ord, PartialEq, PartialOrd)]
struct THBaseServiceGetTableNamesByNamespaceArgs {
  /// The namesapce's name
  name: String,
}

impl THBaseServiceGetTableNamesByNamespaceArgs {
  fn read_from_in_protocol(i_prot: &mut dyn TInputProtocol) -> thrift::Result<THBaseServiceGetTableNamesByNamespaceArgs> {
    i_prot.read_struct_begin()?;
    let mut f_1: Option<String> = None;
    loop {
      let field_ident = i_prot.read_field_begin()?;
      if field_ident.field_type == TType::Stop {
        break;
      }
      let field_id = field_id(&field_ident)?;
      match field_id {
        1 => {
          let val = i_prot.read_string()?;
          f_1 = Some(val);
        },
        _ => {
          i_prot.skip(field_ident.field_type)?;
        },
      };
      i_prot.read_field_end()?;
    }
    i_prot.read_struct_end()?;
    verify_required_field_exists("THBaseServiceGetTableNamesByNamespaceArgs.name", &f_1)?;
    let ret = THBaseServiceGetTableNamesByNamespaceArgs {
      name: f_1.expect("auto-generated code should have checked for presence of required fields"),
    };
    Ok(ret)
  }
  fn write_to_out_protocol(&self, o_prot: &mut dyn TOutputProtocol) -> thrift::Result<()> {
    let struct_ident = TStructIdentifier::new("getTableNamesByNamespace_args");
    o_prot.write_struct_begin(&struct_ident)?;
    o_prot.write_field_begin(&TFieldIdentifier::new("name", TType::String, 1))?;
    o_prot.write_string(&self.name)?;
    o_prot.write_field_end()?;
    o_prot.write_field_stop()?;
    o_prot.write_struct_end()
  }
}

//
// THBaseServiceGetTableNamesByNamespaceResult
//

#[derive(Clone, Debug, Eq, Hash, Ord, PartialEq, PartialOrd)]
struct THBaseServiceGetTableNamesByNamespaceResult {
  result_value: Option<Vec<TTableName>>,
  io: Option<TIOError>,
}

impl THBaseServiceGetTableNamesByNamespaceResult {
  fn read_from_in_protocol(i_prot: &mut dyn TInputProtocol) -> thrift::Result<THBaseServiceGetTableNamesByNamespaceResult> {
    i_prot.read_struct_begin()?;
    let mut f_0: Option<Vec<TTableName>> = None;
    let mut f_1: Option<TIOError> = None;
    loop {
      let field_ident = i_prot.read_field_begin()?;
      if field_ident.field_type == TType::Stop {
        break;
      }
      let field_id = field_id(&field_ident)?;
      match field_id {
        0 => {
          let list_ident = i_prot.read_list_begin()?;
          let mut val: Vec<TTableName> = Vec::with_capacity(list_ident.size as usize);
          for _ in 0..list_ident.size {
            let list_elem_47 = TTableName::read_from_in_protocol(i_prot)?;
            val.push(list_elem_47);
          }
          i_prot.read_list_end()?;
          f_0 = Some(val);
        },
        1 => {
          let val = TIOError::read_from_in_protocol(i_prot)?;
          f_1 = Some(val);
        },
        _ => {
          i_prot.skip(field_ident.field_type)?;
        },
      };
      i_prot.read_field_end()?;
    }
    i_prot.read_struct_end()?;
    let ret = THBaseServiceGetTableNamesByNamespaceResult {
      result_value: f_0,
      io: f_1,
    };
    Ok(ret)
  }
  fn write_to_out_protocol(&self, o_prot: &mut dyn TOutputProtocol) -> thrift::Result<()> {
    let struct_ident = TStructIdentifier::new("THBaseServiceGetTableNamesByNamespaceResult");
    o_prot.write_struct_begin(&struct_ident)?;
    if let Some(ref fld_var) = self.result_value {
      o_prot.write_field_begin(&TFieldIdentifier::new("result_value", TType::List, 0))?;
      o_prot.write_list_begin(&TListIdentifier::new(TType::Struct, fld_var.len() as i32))?;
      for e in fld_var {
        e.write_to_out_protocol(o_prot)?;
      }
      o_prot.write_list_end()?;
      o_prot.write_field_end()?
    }
    if let Some(ref fld_var) = self.io {
      o_prot.write_field_begin(&TFieldIdentifier::new("io", TType::Struct, 1))?;
      fld_var.write_to_out_protocol(o_prot)?;
      o_prot.write_field_end()?
    }
    o_prot.write_field_stop()?;
    o_prot.write_struct_end()
  }
  fn ok_or(self) -> thrift::Result<Vec<TTableName>> {
    if self.io.is_some() {
      Err(thrift::Error::User(Box::new(self.io.unwrap())))
    } else if self.result_value.is_some() {
      Ok(self.result_value.unwrap())
    } else {
      Err(
        thrift::Error::Application(
          ApplicationError::new(
            ApplicationErrorKind::MissingResult,
            "no result received for THBaseServiceGetTableNamesByNamespace"
          )
        )
      )
    }
  }
}

//
// THBaseServiceCreateTableArgs
//

#[derive(Clone, Debug, Eq, Hash, Ord, PartialEq, PartialOrd)]
struct THBaseServiceCreateTableArgs {
  /// table descriptor for table
  desc: TTableDescriptor,
  /// rray of split keys for the initial regions of the table
  split_keys: Vec<Vec<u8>>,
}

impl THBaseServiceCreateTableArgs {
  fn read_from_in_protocol(i_prot: &mut dyn TInputProtocol) -> thrift::Result<THBaseServiceCreateTableArgs> {
    i_prot.read_struct_begin()?;
    let mut f_1: Option<TTableDescriptor> = None;
    let mut f_2: Option<Vec<Vec<u8>>> = None;
    loop {
      let field_ident = i_prot.read_field_begin()?;
      if field_ident.field_type == TType::Stop {
        break;
      }
      let field_id = field_id(&field_ident)?;
      match field_id {
        1 => {
          let val = TTableDescriptor::read_from_in_protocol(i_prot)?;
          f_1 = Some(val);
        },
        2 => {
          let list_ident = i_prot.read_list_begin()?;
          let mut val: Vec<Vec<u8>> = Vec::with_capacity(list_ident.size as usize);
          for _ in 0..list_ident.size {
            let list_elem_48 = i_prot.read_bytes()?;
            val.push(list_elem_48);
          }
          i_prot.read_list_end()?;
          f_2 = Some(val);
        },
        _ => {
          i_prot.skip(field_ident.field_type)?;
        },
      };
      i_prot.read_field_end()?;
    }
    i_prot.read_struct_end()?;
    verify_required_field_exists("THBaseServiceCreateTableArgs.desc", &f_1)?;
    verify_required_field_exists("THBaseServiceCreateTableArgs.split_keys", &f_2)?;
    let ret = THBaseServiceCreateTableArgs {
      desc: f_1.expect("auto-generated code should have checked for presence of required fields"),
      split_keys: f_2.expect("auto-generated code should have checked for presence of required fields"),
    };
    Ok(ret)
  }
  fn write_to_out_protocol(&self, o_prot: &mut dyn TOutputProtocol) -> thrift::Result<()> {
    let struct_ident = TStructIdentifier::new("createTable_args");
    o_prot.write_struct_begin(&struct_ident)?;
    o_prot.write_field_begin(&TFieldIdentifier::new("desc", TType::Struct, 1))?;
    self.desc.write_to_out_protocol(o_prot)?;
    o_prot.write_field_end()?;
    o_prot.write_field_begin(&TFieldIdentifier::new("splitKeys", TType::List, 2))?;
    o_prot.write_list_begin(&TListIdentifier::new(TType::String, self.split_keys.len() as i32))?;
    for e in &self.split_keys {
      o_prot.write_bytes(e)?;
    }
    o_prot.write_list_end()?;
    o_prot.write_field_end()?;
    o_prot.write_field_stop()?;
    o_prot.write_struct_end()
  }
}

//
// THBaseServiceCreateTableResult
//

#[derive(Clone, Debug, Eq, Hash, Ord, PartialEq, PartialOrd)]
struct THBaseServiceCreateTableResult {
  io: Option<TIOError>,
}

impl THBaseServiceCreateTableResult {
  fn read_from_in_protocol(i_prot: &mut dyn TInputProtocol) -> thrift::Result<THBaseServiceCreateTableResult> {
    i_prot.read_struct_begin()?;
    let mut f_1: Option<TIOError> = None;
    loop {
      let field_ident = i_prot.read_field_begin()?;
      if field_ident.field_type == TType::Stop {
        break;
      }
      let field_id = field_id(&field_ident)?;
      match field_id {
        1 => {
          let val = TIOError::read_from_in_protocol(i_prot)?;
          f_1 = Some(val);
        },
        _ => {
          i_prot.skip(field_ident.field_type)?;
        },
      };
      i_prot.read_field_end()?;
    }
    i_prot.read_struct_end()?;
    let ret = THBaseServiceCreateTableResult {
      io: f_1,
    };
    Ok(ret)
  }
  fn write_to_out_protocol(&self, o_prot: &mut dyn TOutputProtocol) -> thrift::Result<()> {
    let struct_ident = TStructIdentifier::new("THBaseServiceCreateTableResult");
    o_prot.write_struct_begin(&struct_ident)?;
    if let Some(ref fld_var) = self.io {
      o_prot.write_field_begin(&TFieldIdentifier::new("io", TType::Struct, 1))?;
      fld_var.write_to_out_protocol(o_prot)?;
      o_prot.write_field_end()?
    }
    o_prot.write_field_stop()?;
    o_prot.write_struct_end()
  }
  fn ok_or(self) -> thrift::Result<()> {
    if self.io.is_some() {
      Err(thrift::Error::User(Box::new(self.io.unwrap())))
    } else {
      Ok(())
    }
  }
}

//
// THBaseServiceDeleteTableArgs
//

#[derive(Clone, Debug, Eq, Hash, Ord, PartialEq, PartialOrd)]
struct THBaseServiceDeleteTableArgs {
  /// the tablename to delete
  table_name: TTableName,
}

impl THBaseServiceDeleteTableArgs {
  fn read_from_in_protocol(i_prot: &mut dyn TInputProtocol) -> thrift::Result<THBaseServiceDeleteTableArgs> {
    i_prot.read_struct_begin()?;
    let mut f_1: Option<TTableName> = None;
    loop {
      let field_ident = i_prot.read_field_begin()?;
      if field_ident.field_type == TType::Stop {
        break;
      }
      let field_id = field_id(&field_ident)?;
      match field_id {
        1 => {
          let val = TTableName::read_from_in_protocol(i_prot)?;
          f_1 = Some(val);
        },
        _ => {
          i_prot.skip(field_ident.field_type)?;
        },
      };
      i_prot.read_field_end()?;
    }
    i_prot.read_struct_end()?;
    verify_required_field_exists("THBaseServiceDeleteTableArgs.table_name", &f_1)?;
    let ret = THBaseServiceDeleteTableArgs {
      table_name: f_1.expect("auto-generated code should have checked for presence of required fields"),
    };
    Ok(ret)
  }
  fn write_to_out_protocol(&self, o_prot: &mut dyn TOutputProtocol) -> thrift::Result<()> {
    let struct_ident = TStructIdentifier::new("deleteTable_args");
    o_prot.write_struct_begin(&struct_ident)?;
    o_prot.write_field_begin(&TFieldIdentifier::new("tableName", TType::Struct, 1))?;
    self.table_name.write_to_out_protocol(o_prot)?;
    o_prot.write_field_end()?;
    o_prot.write_field_stop()?;
    o_prot.write_struct_end()
  }
}

//
// THBaseServiceDeleteTableResult
//

#[derive(Clone, Debug, Eq, Hash, Ord, PartialEq, PartialOrd)]
struct THBaseServiceDeleteTableResult {
  io: Option<TIOError>,
}

impl THBaseServiceDeleteTableResult {
  fn read_from_in_protocol(i_prot: &mut dyn TInputProtocol) -> thrift::Result<THBaseServiceDeleteTableResult> {
    i_prot.read_struct_begin()?;
    let mut f_1: Option<TIOError> = None;
    loop {
      let field_ident = i_prot.read_field_begin()?;
      if field_ident.field_type == TType::Stop {
        break;
      }
      let field_id = field_id(&field_ident)?;
      match field_id {
        1 => {
          let val = TIOError::read_from_in_protocol(i_prot)?;
          f_1 = Some(val);
        },
        _ => {
          i_prot.skip(field_ident.field_type)?;
        },
      };
      i_prot.read_field_end()?;
    }
    i_prot.read_struct_end()?;
    let ret = THBaseServiceDeleteTableResult {
      io: f_1,
    };
    Ok(ret)
  }
  fn write_to_out_protocol(&self, o_prot: &mut dyn TOutputProtocol) -> thrift::Result<()> {
    let struct_ident = TStructIdentifier::new("THBaseServiceDeleteTableResult");
    o_prot.write_struct_begin(&struct_ident)?;
    if let Some(ref fld_var) = self.io {
      o_prot.write_field_begin(&TFieldIdentifier::new("io", TType::Struct, 1))?;
      fld_var.write_to_out_protocol(o_prot)?;
      o_prot.write_field_end()?
    }
    o_prot.write_field_stop()?;
    o_prot.write_struct_end()
  }
  fn ok_or(self) -> thrift::Result<()> {
    if self.io.is_some() {
      Err(thrift::Error::User(Box::new(self.io.unwrap())))
    } else {
      Ok(())
    }
  }
}

//
// THBaseServiceTruncateTableArgs
//

#[derive(Clone, Debug, Eq, Hash, Ord, PartialEq, PartialOrd)]
struct THBaseServiceTruncateTableArgs {
  /// the tablename to truncate
  table_name: TTableName,
  /// whether to  preserve previous splits
  preserve_splits: bool,
}

impl THBaseServiceTruncateTableArgs {
  fn read_from_in_protocol(i_prot: &mut dyn TInputProtocol) -> thrift::Result<THBaseServiceTruncateTableArgs> {
    i_prot.read_struct_begin()?;
    let mut f_1: Option<TTableName> = None;
    let mut f_2: Option<bool> = None;
    loop {
      let field_ident = i_prot.read_field_begin()?;
      if field_ident.field_type == TType::Stop {
        break;
      }
      let field_id = field_id(&field_ident)?;
      match field_id {
        1 => {
          let val = TTableName::read_from_in_protocol(i_prot)?;
          f_1 = Some(val);
        },
        2 => {
          let val = i_prot.read_bool()?;
          f_2 = Some(val);
        },
        _ => {
          i_prot.skip(field_ident.field_type)?;
        },
      };
      i_prot.read_field_end()?;
    }
    i_prot.read_struct_end()?;
    verify_required_field_exists("THBaseServiceTruncateTableArgs.table_name", &f_1)?;
    verify_required_field_exists("THBaseServiceTruncateTableArgs.preserve_splits", &f_2)?;
    let ret = THBaseServiceTruncateTableArgs {
      table_name: f_1.expect("auto-generated code should have checked for presence of required fields"),
      preserve_splits: f_2.expect("auto-generated code should have checked for presence of required fields"),
    };
    Ok(ret)
  }
  fn write_to_out_protocol(&self, o_prot: &mut dyn TOutputProtocol) -> thrift::Result<()> {
    let struct_ident = TStructIdentifier::new("truncateTable_args");
    o_prot.write_struct_begin(&struct_ident)?;
    o_prot.write_field_begin(&TFieldIdentifier::new("tableName", TType::Struct, 1))?;
    self.table_name.write_to_out_protocol(o_prot)?;
    o_prot.write_field_end()?;
    o_prot.write_field_begin(&TFieldIdentifier::new("preserveSplits", TType::Bool, 2))?;
    o_prot.write_bool(self.preserve_splits)?;
    o_prot.write_field_end()?;
    o_prot.write_field_stop()?;
    o_prot.write_struct_end()
  }
}

//
// THBaseServiceTruncateTableResult
//

#[derive(Clone, Debug, Eq, Hash, Ord, PartialEq, PartialOrd)]
struct THBaseServiceTruncateTableResult {
  io: Option<TIOError>,
}

impl THBaseServiceTruncateTableResult {
  fn read_from_in_protocol(i_prot: &mut dyn TInputProtocol) -> thrift::Result<THBaseServiceTruncateTableResult> {
    i_prot.read_struct_begin()?;
    let mut f_1: Option<TIOError> = None;
    loop {
      let field_ident = i_prot.read_field_begin()?;
      if field_ident.field_type == TType::Stop {
        break;
      }
      let field_id = field_id(&field_ident)?;
      match field_id {
        1 => {
          let val = TIOError::read_from_in_protocol(i_prot)?;
          f_1 = Some(val);
        },
        _ => {
          i_prot.skip(field_ident.field_type)?;
        },
      };
      i_prot.read_field_end()?;
    }
    i_prot.read_struct_end()?;
    let ret = THBaseServiceTruncateTableResult {
      io: f_1,
    };
    Ok(ret)
  }
  fn write_to_out_protocol(&self, o_prot: &mut dyn TOutputProtocol) -> thrift::Result<()> {
    let struct_ident = TStructIdentifier::new("THBaseServiceTruncateTableResult");
    o_prot.write_struct_begin(&struct_ident)?;
    if let Some(ref fld_var) = self.io {
      o_prot.write_field_begin(&TFieldIdentifier::new("io", TType::Struct, 1))?;
      fld_var.write_to_out_protocol(o_prot)?;
      o_prot.write_field_end()?
    }
    o_prot.write_field_stop()?;
    o_prot.write_struct_end()
  }
  fn ok_or(self) -> thrift::Result<()> {
    if self.io.is_some() {
      Err(thrift::Error::User(Box::new(self.io.unwrap())))
    } else {
      Ok(())
    }
  }
}

//
// THBaseServiceEnableTableArgs
//

#[derive(Clone, Debug, Eq, Hash, Ord, PartialEq, PartialOrd)]
struct THBaseServiceEnableTableArgs {
  /// the tablename to enable
  table_name: TTableName,
}

impl THBaseServiceEnableTableArgs {
  fn read_from_in_protocol(i_prot: &mut dyn TInputProtocol) -> thrift::Result<THBaseServiceEnableTableArgs> {
    i_prot.read_struct_begin()?;
    let mut f_1: Option<TTableName> = None;
    loop {
      let field_ident = i_prot.read_field_begin()?;
      if field_ident.field_type == TType::Stop {
        break;
      }
      let field_id = field_id(&field_ident)?;
      match field_id {
        1 => {
          let val = TTableName::read_from_in_protocol(i_prot)?;
          f_1 = Some(val);
        },
        _ => {
          i_prot.skip(field_ident.field_type)?;
        },
      };
      i_prot.read_field_end()?;
    }
    i_prot.read_struct_end()?;
    verify_required_field_exists("THBaseServiceEnableTableArgs.table_name", &f_1)?;
    let ret = THBaseServiceEnableTableArgs {
      table_name: f_1.expect("auto-generated code should have checked for presence of required fields"),
    };
    Ok(ret)
  }
  fn write_to_out_protocol(&self, o_prot: &mut dyn TOutputProtocol) -> thrift::Result<()> {
    let struct_ident = TStructIdentifier::new("enableTable_args");
    o_prot.write_struct_begin(&struct_ident)?;
    o_prot.write_field_begin(&TFieldIdentifier::new("tableName", TType::Struct, 1))?;
    self.table_name.write_to_out_protocol(o_prot)?;
    o_prot.write_field_end()?;
    o_prot.write_field_stop()?;
    o_prot.write_struct_end()
  }
}

//
// THBaseServiceEnableTableResult
//

#[derive(Clone, Debug, Eq, Hash, Ord, PartialEq, PartialOrd)]
struct THBaseServiceEnableTableResult {
  io: Option<TIOError>,
}

impl THBaseServiceEnableTableResult {
  fn read_from_in_protocol(i_prot: &mut dyn TInputProtocol) -> thrift::Result<THBaseServiceEnableTableResult> {
    i_prot.read_struct_begin()?;
    let mut f_1: Option<TIOError> = None;
    loop {
      let field_ident = i_prot.read_field_begin()?;
      if field_ident.field_type == TType::Stop {
        break;
      }
      let field_id = field_id(&field_ident)?;
      match field_id {
        1 => {
          let val = TIOError::read_from_in_protocol(i_prot)?;
          f_1 = Some(val);
        },
        _ => {
          i_prot.skip(field_ident.field_type)?;
        },
      };
      i_prot.read_field_end()?;
    }
    i_prot.read_struct_end()?;
    let ret = THBaseServiceEnableTableResult {
      io: f_1,
    };
    Ok(ret)
  }
  fn write_to_out_protocol(&self, o_prot: &mut dyn TOutputProtocol) -> thrift::Result<()> {
    let struct_ident = TStructIdentifier::new("THBaseServiceEnableTableResult");
    o_prot.write_struct_begin(&struct_ident)?;
    if let Some(ref fld_var) = self.io {
      o_prot.write_field_begin(&TFieldIdentifier::new("io", TType::Struct, 1))?;
      fld_var.write_to_out_protocol(o_prot)?;
      o_prot.write_field_end()?
    }
    o_prot.write_field_stop()?;
    o_prot.write_struct_end()
  }
  fn ok_or(self) -> thrift::Result<()> {
    if self.io.is_some() {
      Err(thrift::Error::User(Box::new(self.io.unwrap())))
    } else {
      Ok(())
    }
  }
}

//
// THBaseServiceDisableTableArgs
//

#[derive(Clone, Debug, Eq, Hash, Ord, PartialEq, PartialOrd)]
struct THBaseServiceDisableTableArgs {
  /// the tablename to disable
  table_name: TTableName,
}

impl THBaseServiceDisableTableArgs {
  fn read_from_in_protocol(i_prot: &mut dyn TInputProtocol) -> thrift::Result<THBaseServiceDisableTableArgs> {
    i_prot.read_struct_begin()?;
    let mut f_1: Option<TTableName> = None;
    loop {
      let field_ident = i_prot.read_field_begin()?;
      if field_ident.field_type == TType::Stop {
        break;
      }
      let field_id = field_id(&field_ident)?;
      match field_id {
        1 => {
          let val = TTableName::read_from_in_protocol(i_prot)?;
          f_1 = Some(val);
        },
        _ => {
          i_prot.skip(field_ident.field_type)?;
        },
      };
      i_prot.read_field_end()?;
    }
    i_prot.read_struct_end()?;
    verify_required_field_exists("THBaseServiceDisableTableArgs.table_name", &f_1)?;
    let ret = THBaseServiceDisableTableArgs {
      table_name: f_1.expect("auto-generated code should have checked for presence of required fields"),
    };
    Ok(ret)
  }
  fn write_to_out_protocol(&self, o_prot: &mut dyn TOutputProtocol) -> thrift::Result<()> {
    let struct_ident = TStructIdentifier::new("disableTable_args");
    o_prot.write_struct_begin(&struct_ident)?;
    o_prot.write_field_begin(&TFieldIdentifier::new("tableName", TType::Struct, 1))?;
    self.table_name.write_to_out_protocol(o_prot)?;
    o_prot.write_field_end()?;
    o_prot.write_field_stop()?;
    o_prot.write_struct_end()
  }
}

//
// THBaseServiceDisableTableResult
//

#[derive(Clone, Debug, Eq, Hash, Ord, PartialEq, PartialOrd)]
struct THBaseServiceDisableTableResult {
  io: Option<TIOError>,
}

impl THBaseServiceDisableTableResult {
  fn read_from_in_protocol(i_prot: &mut dyn TInputProtocol) -> thrift::Result<THBaseServiceDisableTableResult> {
    i_prot.read_struct_begin()?;
    let mut f_1: Option<TIOError> = None;
    loop {
      let field_ident = i_prot.read_field_begin()?;
      if field_ident.field_type == TType::Stop {
        break;
      }
      let field_id = field_id(&field_ident)?;
      match field_id {
        1 => {
          let val = TIOError::read_from_in_protocol(i_prot)?;
          f_1 = Some(val);
        },
        _ => {
          i_prot.skip(field_ident.field_type)?;
        },
      };
      i_prot.read_field_end()?;
    }
    i_prot.read_struct_end()?;
    let ret = THBaseServiceDisableTableResult {
      io: f_1,
    };
    Ok(ret)
  }
  fn write_to_out_protocol(&self, o_prot: &mut dyn TOutputProtocol) -> thrift::Result<()> {
    let struct_ident = TStructIdentifier::new("THBaseServiceDisableTableResult");
    o_prot.write_struct_begin(&struct_ident)?;
    if let Some(ref fld_var) = self.io {
      o_prot.write_field_begin(&TFieldIdentifier::new("io", TType::Struct, 1))?;
      fld_var.write_to_out_protocol(o_prot)?;
      o_prot.write_field_end()?
    }
    o_prot.write_field_stop()?;
    o_prot.write_struct_end()
  }
  fn ok_or(self) -> thrift::Result<()> {
    if self.io.is_some() {
      Err(thrift::Error::User(Box::new(self.io.unwrap())))
    } else {
      Ok(())
    }
  }
}

//
// THBaseServiceIsTableEnabledArgs
//

#[derive(Clone, Debug, Eq, Hash, Ord, PartialEq, PartialOrd)]
struct THBaseServiceIsTableEnabledArgs {
  /// the tablename to check
  table_name: TTableName,
}

impl THBaseServiceIsTableEnabledArgs {
  fn read_from_in_protocol(i_prot: &mut dyn TInputProtocol) -> thrift::Result<THBaseServiceIsTableEnabledArgs> {
    i_prot.read_struct_begin()?;
    let mut f_1: Option<TTableName> = None;
    loop {
      let field_ident = i_prot.read_field_begin()?;
      if field_ident.field_type == TType::Stop {
        break;
      }
      let field_id = field_id(&field_ident)?;
      match field_id {
        1 => {
          let val = TTableName::read_from_in_protocol(i_prot)?;
          f_1 = Some(val);
        },
        _ => {
          i_prot.skip(field_ident.field_type)?;
        },
      };
      i_prot.read_field_end()?;
    }
    i_prot.read_struct_end()?;
    verify_required_field_exists("THBaseServiceIsTableEnabledArgs.table_name", &f_1)?;
    let ret = THBaseServiceIsTableEnabledArgs {
      table_name: f_1.expect("auto-generated code should have checked for presence of required fields"),
    };
    Ok(ret)
  }
  fn write_to_out_protocol(&self, o_prot: &mut dyn TOutputProtocol) -> thrift::Result<()> {
    let struct_ident = TStructIdentifier::new("isTableEnabled_args");
    o_prot.write_struct_begin(&struct_ident)?;
    o_prot.write_field_begin(&TFieldIdentifier::new("tableName", TType::Struct, 1))?;
    self.table_name.write_to_out_protocol(o_prot)?;
    o_prot.write_field_end()?;
    o_prot.write_field_stop()?;
    o_prot.write_struct_end()
  }
}

//
// THBaseServiceIsTableEnabledResult
//

#[derive(Clone, Debug, Eq, Hash, Ord, PartialEq, PartialOrd)]
struct THBaseServiceIsTableEnabledResult {
  result_value: Option<bool>,
  io: Option<TIOError>,
}

impl THBaseServiceIsTableEnabledResult {
  fn read_from_in_protocol(i_prot: &mut dyn TInputProtocol) -> thrift::Result<THBaseServiceIsTableEnabledResult> {
    i_prot.read_struct_begin()?;
    let mut f_0: Option<bool> = None;
    let mut f_1: Option<TIOError> = None;
    loop {
      let field_ident = i_prot.read_field_begin()?;
      if field_ident.field_type == TType::Stop {
        break;
      }
      let field_id = field_id(&field_ident)?;
      match field_id {
        0 => {
          let val = i_prot.read_bool()?;
          f_0 = Some(val);
        },
        1 => {
          let val = TIOError::read_from_in_protocol(i_prot)?;
          f_1 = Some(val);
        },
        _ => {
          i_prot.skip(field_ident.field_type)?;
        },
      };
      i_prot.read_field_end()?;
    }
    i_prot.read_struct_end()?;
    let ret = THBaseServiceIsTableEnabledResult {
      result_value: f_0,
      io: f_1,
    };
    Ok(ret)
  }
  fn write_to_out_protocol(&self, o_prot: &mut dyn TOutputProtocol) -> thrift::Result<()> {
    let struct_ident = TStructIdentifier::new("THBaseServiceIsTableEnabledResult");
    o_prot.write_struct_begin(&struct_ident)?;
    if let Some(fld_var) = self.result_value {
      o_prot.write_field_begin(&TFieldIdentifier::new("result_value", TType::Bool, 0))?;
      o_prot.write_bool(fld_var)?;
      o_prot.write_field_end()?
    }
    if let Some(ref fld_var) = self.io {
      o_prot.write_field_begin(&TFieldIdentifier::new("io", TType::Struct, 1))?;
      fld_var.write_to_out_protocol(o_prot)?;
      o_prot.write_field_end()?
    }
    o_prot.write_field_stop()?;
    o_prot.write_struct_end()
  }
  fn ok_or(self) -> thrift::Result<bool> {
    if self.io.is_some() {
      Err(thrift::Error::User(Box::new(self.io.unwrap())))
    } else if self.result_value.is_some() {
      Ok(self.result_value.unwrap())
    } else {
      Err(
        thrift::Error::Application(
          ApplicationError::new(
            ApplicationErrorKind::MissingResult,
            "no result received for THBaseServiceIsTableEnabled"
          )
        )
      )
    }
  }
}

//
// THBaseServiceIsTableDisabledArgs
//

#[derive(Clone, Debug, Eq, Hash, Ord, PartialEq, PartialOrd)]
struct THBaseServiceIsTableDisabledArgs {
  /// the tablename to check
  table_name: TTableName,
}

impl THBaseServiceIsTableDisabledArgs {
  fn read_from_in_protocol(i_prot: &mut dyn TInputProtocol) -> thrift::Result<THBaseServiceIsTableDisabledArgs> {
    i_prot.read_struct_begin()?;
    let mut f_1: Option<TTableName> = None;
    loop {
      let field_ident = i_prot.read_field_begin()?;
      if field_ident.field_type == TType::Stop {
        break;
      }
      let field_id = field_id(&field_ident)?;
      match field_id {
        1 => {
          let val = TTableName::read_from_in_protocol(i_prot)?;
          f_1 = Some(val);
        },
        _ => {
          i_prot.skip(field_ident.field_type)?;
        },
      };
      i_prot.read_field_end()?;
    }
    i_prot.read_struct_end()?;
    verify_required_field_exists("THBaseServiceIsTableDisabledArgs.table_name", &f_1)?;
    let ret = THBaseServiceIsTableDisabledArgs {
      table_name: f_1.expect("auto-generated code should have checked for presence of required fields"),
    };
    Ok(ret)
  }
  fn write_to_out_protocol(&self, o_prot: &mut dyn TOutputProtocol) -> thrift::Result<()> {
    let struct_ident = TStructIdentifier::new("isTableDisabled_args");
    o_prot.write_struct_begin(&struct_ident)?;
    o_prot.write_field_begin(&TFieldIdentifier::new("tableName", TType::Struct, 1))?;
    self.table_name.write_to_out_protocol(o_prot)?;
    o_prot.write_field_end()?;
    o_prot.write_field_stop()?;
    o_prot.write_struct_end()
  }
}

//
// THBaseServiceIsTableDisabledResult
//

#[derive(Clone, Debug, Eq, Hash, Ord, PartialEq, PartialOrd)]
struct THBaseServiceIsTableDisabledResult {
  result_value: Option<bool>,
  io: Option<TIOError>,
}

impl THBaseServiceIsTableDisabledResult {
  fn read_from_in_protocol(i_prot: &mut dyn TInputProtocol) -> thrift::Result<THBaseServiceIsTableDisabledResult> {
    i_prot.read_struct_begin()?;
    let mut f_0: Option<bool> = None;
    let mut f_1: Option<TIOError> = None;
    loop {
      let field_ident = i_prot.read_field_begin()?;
      if field_ident.field_type == TType::Stop {
        break;
      }
      let field_id = field_id(&field_ident)?;
      match field_id {
        0 => {
          let val = i_prot.read_bool()?;
          f_0 = Some(val);
        },
        1 => {
          let val = TIOError::read_from_in_protocol(i_prot)?;
          f_1 = Some(val);
        },
        _ => {
          i_prot.skip(field_ident.field_type)?;
        },
      };
      i_prot.read_field_end()?;
    }
    i_prot.read_struct_end()?;
    let ret = THBaseServiceIsTableDisabledResult {
      result_value: f_0,
      io: f_1,
    };
    Ok(ret)
  }
  fn write_to_out_protocol(&self, o_prot: &mut dyn TOutputProtocol) -> thrift::Result<()> {
    let struct_ident = TStructIdentifier::new("THBaseServiceIsTableDisabledResult");
    o_prot.write_struct_begin(&struct_ident)?;
    if let Some(fld_var) = self.result_value {
      o_prot.write_field_begin(&TFieldIdentifier::new("result_value", TType::Bool, 0))?;
      o_prot.write_bool(fld_var)?;
      o_prot.write_field_end()?
    }
    if let Some(ref fld_var) = self.io {
      o_prot.write_field_begin(&TFieldIdentifier::new("io", TType::Struct, 1))?;
      fld_var.write_to_out_protocol(o_prot)?;
      o_prot.write_field_end()?
    }
    o_prot.write_field_stop()?;
    o_prot.write_struct_end()
  }
  fn ok_or(self) -> thrift::Result<bool> {
    if self.io.is_some() {
      Err(thrift::Error::User(Box::new(self.io.unwrap())))
    } else if self.result_value.is_some() {
      Ok(self.result_value.unwrap())
    } else {
      Err(
        thrift::Error::Application(
          ApplicationError::new(
            ApplicationErrorKind::MissingResult,
            "no result received for THBaseServiceIsTableDisabled"
          )
        )
      )
    }
  }
}

//
// THBaseServiceIsTableAvailableArgs
//

#[derive(Clone, Debug, Eq, Hash, Ord, PartialEq, PartialOrd)]
struct THBaseServiceIsTableAvailableArgs {
  /// the tablename to check
  table_name: TTableName,
}

impl THBaseServiceIsTableAvailableArgs {
  fn read_from_in_protocol(i_prot: &mut dyn TInputProtocol) -> thrift::Result<THBaseServiceIsTableAvailableArgs> {
    i_prot.read_struct_begin()?;
    let mut f_1: Option<TTableName> = None;
    loop {
      let field_ident = i_prot.read_field_begin()?;
      if field_ident.field_type == TType::Stop {
        break;
      }
      let field_id = field_id(&field_ident)?;
      match field_id {
        1 => {
          let val = TTableName::read_from_in_protocol(i_prot)?;
          f_1 = Some(val);
        },
        _ => {
          i_prot.skip(field_ident.field_type)?;
        },
      };
      i_prot.read_field_end()?;
    }
    i_prot.read_struct_end()?;
    verify_required_field_exists("THBaseServiceIsTableAvailableArgs.table_name", &f_1)?;
    let ret = THBaseServiceIsTableAvailableArgs {
      table_name: f_1.expect("auto-generated code should have checked for presence of required fields"),
    };
    Ok(ret)
  }
  fn write_to_out_protocol(&self, o_prot: &mut dyn TOutputProtocol) -> thrift::Result<()> {
    let struct_ident = TStructIdentifier::new("isTableAvailable_args");
    o_prot.write_struct_begin(&struct_ident)?;
    o_prot.write_field_begin(&TFieldIdentifier::new("tableName", TType::Struct, 1))?;
    self.table_name.write_to_out_protocol(o_prot)?;
    o_prot.write_field_end()?;
    o_prot.write_field_stop()?;
    o_prot.write_struct_end()
  }
}

//
// THBaseServiceIsTableAvailableResult
//

#[derive(Clone, Debug, Eq, Hash, Ord, PartialEq, PartialOrd)]
struct THBaseServiceIsTableAvailableResult {
  result_value: Option<bool>,
  io: Option<TIOError>,
}

impl THBaseServiceIsTableAvailableResult {
  fn read_from_in_protocol(i_prot: &mut dyn TInputProtocol) -> thrift::Result<THBaseServiceIsTableAvailableResult> {
    i_prot.read_struct_begin()?;
    let mut f_0: Option<bool> = None;
    let mut f_1: Option<TIOError> = None;
    loop {
      let field_ident = i_prot.read_field_begin()?;
      if field_ident.field_type == TType::Stop {
        break;
      }
      let field_id = field_id(&field_ident)?;
      match field_id {
        0 => {
          let val = i_prot.read_bool()?;
          f_0 = Some(val);
        },
        1 => {
          let val = TIOError::read_from_in_protocol(i_prot)?;
          f_1 = Some(val);
        },
        _ => {
          i_prot.skip(field_ident.field_type)?;
        },
      };
      i_prot.read_field_end()?;
    }
    i_prot.read_struct_end()?;
    let ret = THBaseServiceIsTableAvailableResult {
      result_value: f_0,
      io: f_1,
    };
    Ok(ret)
  }
  fn write_to_out_protocol(&self, o_prot: &mut dyn TOutputProtocol) -> thrift::Result<()> {
    let struct_ident = TStructIdentifier::new("THBaseServiceIsTableAvailableResult");
    o_prot.write_struct_begin(&struct_ident)?;
    if let Some(fld_var) = self.result_value {
      o_prot.write_field_begin(&TFieldIdentifier::new("result_value", TType::Bool, 0))?;
      o_prot.write_bool(fld_var)?;
      o_prot.write_field_end()?
    }
    if let Some(ref fld_var) = self.io {
      o_prot.write_field_begin(&TFieldIdentifier::new("io", TType::Struct, 1))?;
      fld_var.write_to_out_protocol(o_prot)?;
      o_prot.write_field_end()?
    }
    o_prot.write_field_stop()?;
    o_prot.write_struct_end()
  }
  fn ok_or(self) -> thrift::Result<bool> {
    if self.io.is_some() {
      Err(thrift::Error::User(Box::new(self.io.unwrap())))
    } else if self.result_value.is_some() {
      Ok(self.result_value.unwrap())
    } else {
      Err(
        thrift::Error::Application(
          ApplicationError::new(
            ApplicationErrorKind::MissingResult,
            "no result received for THBaseServiceIsTableAvailable"
          )
        )
      )
    }
  }
}

//
// THBaseServiceIsTableAvailableWithSplitArgs
//

#[derive(Clone, Debug, Eq, Hash, Ord, PartialEq, PartialOrd)]
struct THBaseServiceIsTableAvailableWithSplitArgs {
  /// the tablename to check
  table_name: TTableName,
  /// keys to check if the table has been created with all split keys
  split_keys: Vec<Vec<u8>>,
}

impl THBaseServiceIsTableAvailableWithSplitArgs {
  fn read_from_in_protocol(i_prot: &mut dyn TInputProtocol) -> thrift::Result<THBaseServiceIsTableAvailableWithSplitArgs> {
    i_prot.read_struct_begin()?;
    let mut f_1: Option<TTableName> = None;
    let mut f_2: Option<Vec<Vec<u8>>> = None;
    loop {
      let field_ident = i_prot.read_field_begin()?;
      if field_ident.field_type == TType::Stop {
        break;
      }
      let field_id = field_id(&field_ident)?;
      match field_id {
        1 => {
          let val = TTableName::read_from_in_protocol(i_prot)?;
          f_1 = Some(val);
        },
        2 => {
          let list_ident = i_prot.read_list_begin()?;
          let mut val: Vec<Vec<u8>> = Vec::with_capacity(list_ident.size as usize);
          for _ in 0..list_ident.size {
            let list_elem_49 = i_prot.read_bytes()?;
            val.push(list_elem_49);
          }
          i_prot.read_list_end()?;
          f_2 = Some(val);
        },
        _ => {
          i_prot.skip(field_ident.field_type)?;
        },
      };
      i_prot.read_field_end()?;
    }
    i_prot.read_struct_end()?;
    verify_required_field_exists("THBaseServiceIsTableAvailableWithSplitArgs.table_name", &f_1)?;
    verify_required_field_exists("THBaseServiceIsTableAvailableWithSplitArgs.split_keys", &f_2)?;
    let ret = THBaseServiceIsTableAvailableWithSplitArgs {
      table_name: f_1.expect("auto-generated code should have checked for presence of required fields"),
      split_keys: f_2.expect("auto-generated code should have checked for presence of required fields"),
    };
    Ok(ret)
  }
  fn write_to_out_protocol(&self, o_prot: &mut dyn TOutputProtocol) -> thrift::Result<()> {
    let struct_ident = TStructIdentifier::new("isTableAvailableWithSplit_args");
    o_prot.write_struct_begin(&struct_ident)?;
    o_prot.write_field_begin(&TFieldIdentifier::new("tableName", TType::Struct, 1))?;
    self.table_name.write_to_out_protocol(o_prot)?;
    o_prot.write_field_end()?;
    o_prot.write_field_begin(&TFieldIdentifier::new("splitKeys", TType::List, 2))?;
    o_prot.write_list_begin(&TListIdentifier::new(TType::String, self.split_keys.len() as i32))?;
    for e in &self.split_keys {
      o_prot.write_bytes(e)?;
    }
    o_prot.write_list_end()?;
    o_prot.write_field_end()?;
    o_prot.write_field_stop()?;
    o_prot.write_struct_end()
  }
}

//
// THBaseServiceIsTableAvailableWithSplitResult
//

#[derive(Clone, Debug, Eq, Hash, Ord, PartialEq, PartialOrd)]
struct THBaseServiceIsTableAvailableWithSplitResult {
  result_value: Option<bool>,
  io: Option<TIOError>,
}

impl THBaseServiceIsTableAvailableWithSplitResult {
  fn read_from_in_protocol(i_prot: &mut dyn TInputProtocol) -> thrift::Result<THBaseServiceIsTableAvailableWithSplitResult> {
    i_prot.read_struct_begin()?;
    let mut f_0: Option<bool> = None;
    let mut f_1: Option<TIOError> = None;
    loop {
      let field_ident = i_prot.read_field_begin()?;
      if field_ident.field_type == TType::Stop {
        break;
      }
      let field_id = field_id(&field_ident)?;
      match field_id {
        0 => {
          let val = i_prot.read_bool()?;
          f_0 = Some(val);
        },
        1 => {
          let val = TIOError::read_from_in_protocol(i_prot)?;
          f_1 = Some(val);
        },
        _ => {
          i_prot.skip(field_ident.field_type)?;
        },
      };
      i_prot.read_field_end()?;
    }
    i_prot.read_struct_end()?;
    let ret = THBaseServiceIsTableAvailableWithSplitResult {
      result_value: f_0,
      io: f_1,
    };
    Ok(ret)
  }
  fn write_to_out_protocol(&self, o_prot: &mut dyn TOutputProtocol) -> thrift::Result<()> {
    let struct_ident = TStructIdentifier::new("THBaseServiceIsTableAvailableWithSplitResult");
    o_prot.write_struct_begin(&struct_ident)?;
    if let Some(fld_var) = self.result_value {
      o_prot.write_field_begin(&TFieldIdentifier::new("result_value", TType::Bool, 0))?;
      o_prot.write_bool(fld_var)?;
      o_prot.write_field_end()?
    }
    if let Some(ref fld_var) = self.io {
      o_prot.write_field_begin(&TFieldIdentifier::new("io", TType::Struct, 1))?;
      fld_var.write_to_out_protocol(o_prot)?;
      o_prot.write_field_end()?
    }
    o_prot.write_field_stop()?;
    o_prot.write_struct_end()
  }
  fn ok_or(self) -> thrift::Result<bool> {
    if self.io.is_some() {
      Err(thrift::Error::User(Box::new(self.io.unwrap())))
    } else if self.result_value.is_some() {
      Ok(self.result_value.unwrap())
    } else {
      Err(
        thrift::Error::Application(
          ApplicationError::new(
            ApplicationErrorKind::MissingResult,
            "no result received for THBaseServiceIsTableAvailableWithSplit"
          )
        )
      )
    }
  }
}

//
// THBaseServiceAddColumnFamilyArgs
//

#[derive(Clone, Debug, Eq, Hash, Ord, PartialEq, PartialOrd)]
struct THBaseServiceAddColumnFamilyArgs {
  /// the tablename to add column family to
  table_name: TTableName,
  /// column family descriptor of column family to be added
  column: TColumnFamilyDescriptor,
}

impl THBaseServiceAddColumnFamilyArgs {
  fn read_from_in_protocol(i_prot: &mut dyn TInputProtocol) -> thrift::Result<THBaseServiceAddColumnFamilyArgs> {
    i_prot.read_struct_begin()?;
    let mut f_1: Option<TTableName> = None;
    let mut f_2: Option<TColumnFamilyDescriptor> = None;
    loop {
      let field_ident = i_prot.read_field_begin()?;
      if field_ident.field_type == TType::Stop {
        break;
      }
      let field_id = field_id(&field_ident)?;
      match field_id {
        1 => {
          let val = TTableName::read_from_in_protocol(i_prot)?;
          f_1 = Some(val);
        },
        2 => {
          let val = TColumnFamilyDescriptor::read_from_in_protocol(i_prot)?;
          f_2 = Some(val);
        },
        _ => {
          i_prot.skip(field_ident.field_type)?;
        },
      };
      i_prot.read_field_end()?;
    }
    i_prot.read_struct_end()?;
    verify_required_field_exists("THBaseServiceAddColumnFamilyArgs.table_name", &f_1)?;
    verify_required_field_exists("THBaseServiceAddColumnFamilyArgs.column", &f_2)?;
    let ret = THBaseServiceAddColumnFamilyArgs {
      table_name: f_1.expect("auto-generated code should have checked for presence of required fields"),
      column: f_2.expect("auto-generated code should have checked for presence of required fields"),
    };
    Ok(ret)
  }
  fn write_to_out_protocol(&self, o_prot: &mut dyn TOutputProtocol) -> thrift::Result<()> {
    let struct_ident = TStructIdentifier::new("addColumnFamily_args");
    o_prot.write_struct_begin(&struct_ident)?;
    o_prot.write_field_begin(&TFieldIdentifier::new("tableName", TType::Struct, 1))?;
    self.table_name.write_to_out_protocol(o_prot)?;
    o_prot.write_field_end()?;
    o_prot.write_field_begin(&TFieldIdentifier::new("column", TType::Struct, 2))?;
    self.column.write_to_out_protocol(o_prot)?;
    o_prot.write_field_end()?;
    o_prot.write_field_stop()?;
    o_prot.write_struct_end()
  }
}

//
// THBaseServiceAddColumnFamilyResult
//

#[derive(Clone, Debug, Eq, Hash, Ord, PartialEq, PartialOrd)]
struct THBaseServiceAddColumnFamilyResult {
  io: Option<TIOError>,
}

impl THBaseServiceAddColumnFamilyResult {
  fn read_from_in_protocol(i_prot: &mut dyn TInputProtocol) -> thrift::Result<THBaseServiceAddColumnFamilyResult> {
    i_prot.read_struct_begin()?;
    let mut f_1: Option<TIOError> = None;
    loop {
      let field_ident = i_prot.read_field_begin()?;
      if field_ident.field_type == TType::Stop {
        break;
      }
      let field_id = field_id(&field_ident)?;
      match field_id {
        1 => {
          let val = TIOError::read_from_in_protocol(i_prot)?;
          f_1 = Some(val);
        },
        _ => {
          i_prot.skip(field_ident.field_type)?;
        },
      };
      i_prot.read_field_end()?;
    }
    i_prot.read_struct_end()?;
    let ret = THBaseServiceAddColumnFamilyResult {
      io: f_1,
    };
    Ok(ret)
  }
  fn write_to_out_protocol(&self, o_prot: &mut dyn TOutputProtocol) -> thrift::Result<()> {
    let struct_ident = TStructIdentifier::new("THBaseServiceAddColumnFamilyResult");
    o_prot.write_struct_begin(&struct_ident)?;
    if let Some(ref fld_var) = self.io {
      o_prot.write_field_begin(&TFieldIdentifier::new("io", TType::Struct, 1))?;
      fld_var.write_to_out_protocol(o_prot)?;
      o_prot.write_field_end()?
    }
    o_prot.write_field_stop()?;
    o_prot.write_struct_end()
  }
  fn ok_or(self) -> thrift::Result<()> {
    if self.io.is_some() {
      Err(thrift::Error::User(Box::new(self.io.unwrap())))
    } else {
      Ok(())
    }
  }
}

//
// THBaseServiceDeleteColumnFamilyArgs
//

#[derive(Clone, Debug, Eq, Hash, Ord, PartialEq, PartialOrd)]
struct THBaseServiceDeleteColumnFamilyArgs {
  /// the tablename to delete column family from
  table_name: TTableName,
  /// name of column family to be deleted
  column: Vec<u8>,
}

impl THBaseServiceDeleteColumnFamilyArgs {
  fn read_from_in_protocol(i_prot: &mut dyn TInputProtocol) -> thrift::Result<THBaseServiceDeleteColumnFamilyArgs> {
    i_prot.read_struct_begin()?;
    let mut f_1: Option<TTableName> = None;
    let mut f_2: Option<Vec<u8>> = None;
    loop {
      let field_ident = i_prot.read_field_begin()?;
      if field_ident.field_type == TType::Stop {
        break;
      }
      let field_id = field_id(&field_ident)?;
      match field_id {
        1 => {
          let val = TTableName::read_from_in_protocol(i_prot)?;
          f_1 = Some(val);
        },
        2 => {
          let val = i_prot.read_bytes()?;
          f_2 = Some(val);
        },
        _ => {
          i_prot.skip(field_ident.field_type)?;
        },
      };
      i_prot.read_field_end()?;
    }
    i_prot.read_struct_end()?;
    verify_required_field_exists("THBaseServiceDeleteColumnFamilyArgs.table_name", &f_1)?;
    verify_required_field_exists("THBaseServiceDeleteColumnFamilyArgs.column", &f_2)?;
    let ret = THBaseServiceDeleteColumnFamilyArgs {
      table_name: f_1.expect("auto-generated code should have checked for presence of required fields"),
      column: f_2.expect("auto-generated code should have checked for presence of required fields"),
    };
    Ok(ret)
  }
  fn write_to_out_protocol(&self, o_prot: &mut dyn TOutputProtocol) -> thrift::Result<()> {
    let struct_ident = TStructIdentifier::new("deleteColumnFamily_args");
    o_prot.write_struct_begin(&struct_ident)?;
    o_prot.write_field_begin(&TFieldIdentifier::new("tableName", TType::Struct, 1))?;
    self.table_name.write_to_out_protocol(o_prot)?;
    o_prot.write_field_end()?;
    o_prot.write_field_begin(&TFieldIdentifier::new("column", TType::String, 2))?;
    o_prot.write_bytes(&self.column)?;
    o_prot.write_field_end()?;
    o_prot.write_field_stop()?;
    o_prot.write_struct_end()
  }
}

//
// THBaseServiceDeleteColumnFamilyResult
//

#[derive(Clone, Debug, Eq, Hash, Ord, PartialEq, PartialOrd)]
struct THBaseServiceDeleteColumnFamilyResult {
  io: Option<TIOError>,
}

impl THBaseServiceDeleteColumnFamilyResult {
  fn read_from_in_protocol(i_prot: &mut dyn TInputProtocol) -> thrift::Result<THBaseServiceDeleteColumnFamilyResult> {
    i_prot.read_struct_begin()?;
    let mut f_1: Option<TIOError> = None;
    loop {
      let field_ident = i_prot.read_field_begin()?;
      if field_ident.field_type == TType::Stop {
        break;
      }
      let field_id = field_id(&field_ident)?;
      match field_id {
        1 => {
          let val = TIOError::read_from_in_protocol(i_prot)?;
          f_1 = Some(val);
        },
        _ => {
          i_prot.skip(field_ident.field_type)?;
        },
      };
      i_prot.read_field_end()?;
    }
    i_prot.read_struct_end()?;
    let ret = THBaseServiceDeleteColumnFamilyResult {
      io: f_1,
    };
    Ok(ret)
  }
  fn write_to_out_protocol(&self, o_prot: &mut dyn TOutputProtocol) -> thrift::Result<()> {
    let struct_ident = TStructIdentifier::new("THBaseServiceDeleteColumnFamilyResult");
    o_prot.write_struct_begin(&struct_ident)?;
    if let Some(ref fld_var) = self.io {
      o_prot.write_field_begin(&TFieldIdentifier::new("io", TType::Struct, 1))?;
      fld_var.write_to_out_protocol(o_prot)?;
      o_prot.write_field_end()?
    }
    o_prot.write_field_stop()?;
    o_prot.write_struct_end()
  }
  fn ok_or(self) -> thrift::Result<()> {
    if self.io.is_some() {
      Err(thrift::Error::User(Box::new(self.io.unwrap())))
    } else {
      Ok(())
    }
  }
}

//
// THBaseServiceModifyColumnFamilyArgs
//

#[derive(Clone, Debug, Eq, Hash, Ord, PartialEq, PartialOrd)]
struct THBaseServiceModifyColumnFamilyArgs {
  /// the tablename to modify column family
  table_name: TTableName,
  /// column family descriptor of column family to be modified
  column: TColumnFamilyDescriptor,
}

impl THBaseServiceModifyColumnFamilyArgs {
  fn read_from_in_protocol(i_prot: &mut dyn TInputProtocol) -> thrift::Result<THBaseServiceModifyColumnFamilyArgs> {
    i_prot.read_struct_begin()?;
    let mut f_1: Option<TTableName> = None;
    let mut f_2: Option<TColumnFamilyDescriptor> = None;
    loop {
      let field_ident = i_prot.read_field_begin()?;
      if field_ident.field_type == TType::Stop {
        break;
      }
      let field_id = field_id(&field_ident)?;
      match field_id {
        1 => {
          let val = TTableName::read_from_in_protocol(i_prot)?;
          f_1 = Some(val);
        },
        2 => {
          let val = TColumnFamilyDescriptor::read_from_in_protocol(i_prot)?;
          f_2 = Some(val);
        },
        _ => {
          i_prot.skip(field_ident.field_type)?;
        },
      };
      i_prot.read_field_end()?;
    }
    i_prot.read_struct_end()?;
    verify_required_field_exists("THBaseServiceModifyColumnFamilyArgs.table_name", &f_1)?;
    verify_required_field_exists("THBaseServiceModifyColumnFamilyArgs.column", &f_2)?;
    let ret = THBaseServiceModifyColumnFamilyArgs {
      table_name: f_1.expect("auto-generated code should have checked for presence of required fields"),
      column: f_2.expect("auto-generated code should have checked for presence of required fields"),
    };
    Ok(ret)
  }
  fn write_to_out_protocol(&self, o_prot: &mut dyn TOutputProtocol) -> thrift::Result<()> {
    let struct_ident = TStructIdentifier::new("modifyColumnFamily_args");
    o_prot.write_struct_begin(&struct_ident)?;
    o_prot.write_field_begin(&TFieldIdentifier::new("tableName", TType::Struct, 1))?;
    self.table_name.write_to_out_protocol(o_prot)?;
    o_prot.write_field_end()?;
    o_prot.write_field_begin(&TFieldIdentifier::new("column", TType::Struct, 2))?;
    self.column.write_to_out_protocol(o_prot)?;
    o_prot.write_field_end()?;
    o_prot.write_field_stop()?;
    o_prot.write_struct_end()
  }
}

//
// THBaseServiceModifyColumnFamilyResult
//

#[derive(Clone, Debug, Eq, Hash, Ord, PartialEq, PartialOrd)]
struct THBaseServiceModifyColumnFamilyResult {
  io: Option<TIOError>,
}

impl THBaseServiceModifyColumnFamilyResult {
  fn read_from_in_protocol(i_prot: &mut dyn TInputProtocol) -> thrift::Result<THBaseServiceModifyColumnFamilyResult> {
    i_prot.read_struct_begin()?;
    let mut f_1: Option<TIOError> = None;
    loop {
      let field_ident = i_prot.read_field_begin()?;
      if field_ident.field_type == TType::Stop {
        break;
      }
      let field_id = field_id(&field_ident)?;
      match field_id {
        1 => {
          let val = TIOError::read_from_in_protocol(i_prot)?;
          f_1 = Some(val);
        },
        _ => {
          i_prot.skip(field_ident.field_type)?;
        },
      };
      i_prot.read_field_end()?;
    }
    i_prot.read_struct_end()?;
    let ret = THBaseServiceModifyColumnFamilyResult {
      io: f_1,
    };
    Ok(ret)
  }
  fn write_to_out_protocol(&self, o_prot: &mut dyn TOutputProtocol) -> thrift::Result<()> {
    let struct_ident = TStructIdentifier::new("THBaseServiceModifyColumnFamilyResult");
    o_prot.write_struct_begin(&struct_ident)?;
    if let Some(ref fld_var) = self.io {
      o_prot.write_field_begin(&TFieldIdentifier::new("io", TType::Struct, 1))?;
      fld_var.write_to_out_protocol(o_prot)?;
      o_prot.write_field_end()?
    }
    o_prot.write_field_stop()?;
    o_prot.write_struct_end()
  }
  fn ok_or(self) -> thrift::Result<()> {
    if self.io.is_some() {
      Err(thrift::Error::User(Box::new(self.io.unwrap())))
    } else {
      Ok(())
    }
  }
}

//
// THBaseServiceModifyTableArgs
//

#[derive(Clone, Debug, Eq, Hash, Ord, PartialEq, PartialOrd)]
struct THBaseServiceModifyTableArgs {
  /// the descriptor of the table to modify
  desc: TTableDescriptor,
}

impl THBaseServiceModifyTableArgs {
  fn read_from_in_protocol(i_prot: &mut dyn TInputProtocol) -> thrift::Result<THBaseServiceModifyTableArgs> {
    i_prot.read_struct_begin()?;
    let mut f_1: Option<TTableDescriptor> = None;
    loop {
      let field_ident = i_prot.read_field_begin()?;
      if field_ident.field_type == TType::Stop {
        break;
      }
      let field_id = field_id(&field_ident)?;
      match field_id {
        1 => {
          let val = TTableDescriptor::read_from_in_protocol(i_prot)?;
          f_1 = Some(val);
        },
        _ => {
          i_prot.skip(field_ident.field_type)?;
        },
      };
      i_prot.read_field_end()?;
    }
    i_prot.read_struct_end()?;
    verify_required_field_exists("THBaseServiceModifyTableArgs.desc", &f_1)?;
    let ret = THBaseServiceModifyTableArgs {
      desc: f_1.expect("auto-generated code should have checked for presence of required fields"),
    };
    Ok(ret)
  }
  fn write_to_out_protocol(&self, o_prot: &mut dyn TOutputProtocol) -> thrift::Result<()> {
    let struct_ident = TStructIdentifier::new("modifyTable_args");
    o_prot.write_struct_begin(&struct_ident)?;
    o_prot.write_field_begin(&TFieldIdentifier::new("desc", TType::Struct, 1))?;
    self.desc.write_to_out_protocol(o_prot)?;
    o_prot.write_field_end()?;
    o_prot.write_field_stop()?;
    o_prot.write_struct_end()
  }
}

//
// THBaseServiceModifyTableResult
//

#[derive(Clone, Debug, Eq, Hash, Ord, PartialEq, PartialOrd)]
struct THBaseServiceModifyTableResult {
  io: Option<TIOError>,
}

impl THBaseServiceModifyTableResult {
  fn read_from_in_protocol(i_prot: &mut dyn TInputProtocol) -> thrift::Result<THBaseServiceModifyTableResult> {
    i_prot.read_struct_begin()?;
    let mut f_1: Option<TIOError> = None;
    loop {
      let field_ident = i_prot.read_field_begin()?;
      if field_ident.field_type == TType::Stop {
        break;
      }
      let field_id = field_id(&field_ident)?;
      match field_id {
        1 => {
          let val = TIOError::read_from_in_protocol(i_prot)?;
          f_1 = Some(val);
        },
        _ => {
          i_prot.skip(field_ident.field_type)?;
        },
      };
      i_prot.read_field_end()?;
    }
    i_prot.read_struct_end()?;
    let ret = THBaseServiceModifyTableResult {
      io: f_1,
    };
    Ok(ret)
  }
  fn write_to_out_protocol(&self, o_prot: &mut dyn TOutputProtocol) -> thrift::Result<()> {
    let struct_ident = TStructIdentifier::new("THBaseServiceModifyTableResult");
    o_prot.write_struct_begin(&struct_ident)?;
    if let Some(ref fld_var) = self.io {
      o_prot.write_field_begin(&TFieldIdentifier::new("io", TType::Struct, 1))?;
      fld_var.write_to_out_protocol(o_prot)?;
      o_prot.write_field_end()?
    }
    o_prot.write_field_stop()?;
    o_prot.write_struct_end()
  }
  fn ok_or(self) -> thrift::Result<()> {
    if self.io.is_some() {
      Err(thrift::Error::User(Box::new(self.io.unwrap())))
    } else {
      Ok(())
    }
  }
}

//
// THBaseServiceCreateNamespaceArgs
//

#[derive(Clone, Debug, Eq, Hash, Ord, PartialEq, PartialOrd)]
struct THBaseServiceCreateNamespaceArgs {
  /// descriptor which describes the new namespace
  namespace_desc: TNamespaceDescriptor,
}

impl THBaseServiceCreateNamespaceArgs {
  fn read_from_in_protocol(i_prot: &mut dyn TInputProtocol) -> thrift::Result<THBaseServiceCreateNamespaceArgs> {
    i_prot.read_struct_begin()?;
    let mut f_1: Option<TNamespaceDescriptor> = None;
    loop {
      let field_ident = i_prot.read_field_begin()?;
      if field_ident.field_type == TType::Stop {
        break;
      }
      let field_id = field_id(&field_ident)?;
      match field_id {
        1 => {
          let val = TNamespaceDescriptor::read_from_in_protocol(i_prot)?;
          f_1 = Some(val);
        },
        _ => {
          i_prot.skip(field_ident.field_type)?;
        },
      };
      i_prot.read_field_end()?;
    }
    i_prot.read_struct_end()?;
    verify_required_field_exists("THBaseServiceCreateNamespaceArgs.namespace_desc", &f_1)?;
    let ret = THBaseServiceCreateNamespaceArgs {
      namespace_desc: f_1.expect("auto-generated code should have checked for presence of required fields"),
    };
    Ok(ret)
  }
  fn write_to_out_protocol(&self, o_prot: &mut dyn TOutputProtocol) -> thrift::Result<()> {
    let struct_ident = TStructIdentifier::new("createNamespace_args");
    o_prot.write_struct_begin(&struct_ident)?;
    o_prot.write_field_begin(&TFieldIdentifier::new("namespaceDesc", TType::Struct, 1))?;
    self.namespace_desc.write_to_out_protocol(o_prot)?;
    o_prot.write_field_end()?;
    o_prot.write_field_stop()?;
    o_prot.write_struct_end()
  }
}

//
// THBaseServiceCreateNamespaceResult
//

#[derive(Clone, Debug, Eq, Hash, Ord, PartialEq, PartialOrd)]
struct THBaseServiceCreateNamespaceResult {
  io: Option<TIOError>,
}

impl THBaseServiceCreateNamespaceResult {
  fn read_from_in_protocol(i_prot: &mut dyn TInputProtocol) -> thrift::Result<THBaseServiceCreateNamespaceResult> {
    i_prot.read_struct_begin()?;
    let mut f_1: Option<TIOError> = None;
    loop {
      let field_ident = i_prot.read_field_begin()?;
      if field_ident.field_type == TType::Stop {
        break;
      }
      let field_id = field_id(&field_ident)?;
      match field_id {
        1 => {
          let val = TIOError::read_from_in_protocol(i_prot)?;
          f_1 = Some(val);
        },
        _ => {
          i_prot.skip(field_ident.field_type)?;
        },
      };
      i_prot.read_field_end()?;
    }
    i_prot.read_struct_end()?;
    let ret = THBaseServiceCreateNamespaceResult {
      io: f_1,
    };
    Ok(ret)
  }
  fn write_to_out_protocol(&self, o_prot: &mut dyn TOutputProtocol) -> thrift::Result<()> {
    let struct_ident = TStructIdentifier::new("THBaseServiceCreateNamespaceResult");
    o_prot.write_struct_begin(&struct_ident)?;
    if let Some(ref fld_var) = self.io {
      o_prot.write_field_begin(&TFieldIdentifier::new("io", TType::Struct, 1))?;
      fld_var.write_to_out_protocol(o_prot)?;
      o_prot.write_field_end()?
    }
    o_prot.write_field_stop()?;
    o_prot.write_struct_end()
  }
  fn ok_or(self) -> thrift::Result<()> {
    if self.io.is_some() {
      Err(thrift::Error::User(Box::new(self.io.unwrap())))
    } else {
      Ok(())
    }
  }
}

//
// THBaseServiceModifyNamespaceArgs
//

#[derive(Clone, Debug, Eq, Hash, Ord, PartialEq, PartialOrd)]
struct THBaseServiceModifyNamespaceArgs {
  /// descriptor which describes the new namespace
  namespace_desc: TNamespaceDescriptor,
}

impl THBaseServiceModifyNamespaceArgs {
  fn read_from_in_protocol(i_prot: &mut dyn TInputProtocol) -> thrift::Result<THBaseServiceModifyNamespaceArgs> {
    i_prot.read_struct_begin()?;
    let mut f_1: Option<TNamespaceDescriptor> = None;
    loop {
      let field_ident = i_prot.read_field_begin()?;
      if field_ident.field_type == TType::Stop {
        break;
      }
      let field_id = field_id(&field_ident)?;
      match field_id {
        1 => {
          let val = TNamespaceDescriptor::read_from_in_protocol(i_prot)?;
          f_1 = Some(val);
        },
        _ => {
          i_prot.skip(field_ident.field_type)?;
        },
      };
      i_prot.read_field_end()?;
    }
    i_prot.read_struct_end()?;
    verify_required_field_exists("THBaseServiceModifyNamespaceArgs.namespace_desc", &f_1)?;
    let ret = THBaseServiceModifyNamespaceArgs {
      namespace_desc: f_1.expect("auto-generated code should have checked for presence of required fields"),
    };
    Ok(ret)
  }
  fn write_to_out_protocol(&self, o_prot: &mut dyn TOutputProtocol) -> thrift::Result<()> {
    let struct_ident = TStructIdentifier::new("modifyNamespace_args");
    o_prot.write_struct_begin(&struct_ident)?;
    o_prot.write_field_begin(&TFieldIdentifier::new("namespaceDesc", TType::Struct, 1))?;
    self.namespace_desc.write_to_out_protocol(o_prot)?;
    o_prot.write_field_end()?;
    o_prot.write_field_stop()?;
    o_prot.write_struct_end()
  }
}

//
// THBaseServiceModifyNamespaceResult
//

#[derive(Clone, Debug, Eq, Hash, Ord, PartialEq, PartialOrd)]
struct THBaseServiceModifyNamespaceResult {
  io: Option<TIOError>,
}

impl THBaseServiceModifyNamespaceResult {
  fn read_from_in_protocol(i_prot: &mut dyn TInputProtocol) -> thrift::Result<THBaseServiceModifyNamespaceResult> {
    i_prot.read_struct_begin()?;
    let mut f_1: Option<TIOError> = None;
    loop {
      let field_ident = i_prot.read_field_begin()?;
      if field_ident.field_type == TType::Stop {
        break;
      }
      let field_id = field_id(&field_ident)?;
      match field_id {
        1 => {
          let val = TIOError::read_from_in_protocol(i_prot)?;
          f_1 = Some(val);
        },
        _ => {
          i_prot.skip(field_ident.field_type)?;
        },
      };
      i_prot.read_field_end()?;
    }
    i_prot.read_struct_end()?;
    let ret = THBaseServiceModifyNamespaceResult {
      io: f_1,
    };
    Ok(ret)
  }
  fn write_to_out_protocol(&self, o_prot: &mut dyn TOutputProtocol) -> thrift::Result<()> {
    let struct_ident = TStructIdentifier::new("THBaseServiceModifyNamespaceResult");
    o_prot.write_struct_begin(&struct_ident)?;
    if let Some(ref fld_var) = self.io {
      o_prot.write_field_begin(&TFieldIdentifier::new("io", TType::Struct, 1))?;
      fld_var.write_to_out_protocol(o_prot)?;
      o_prot.write_field_end()?
    }
    o_prot.write_field_stop()?;
    o_prot.write_struct_end()
  }
  fn ok_or(self) -> thrift::Result<()> {
    if self.io.is_some() {
      Err(thrift::Error::User(Box::new(self.io.unwrap())))
    } else {
      Ok(())
    }
  }
}

//
// THBaseServiceDeleteNamespaceArgs
//

#[derive(Clone, Debug, Eq, Hash, Ord, PartialEq, PartialOrd)]
struct THBaseServiceDeleteNamespaceArgs {
  /// namespace name
  name: String,
}

impl THBaseServiceDeleteNamespaceArgs {
  fn read_from_in_protocol(i_prot: &mut dyn TInputProtocol) -> thrift::Result<THBaseServiceDeleteNamespaceArgs> {
    i_prot.read_struct_begin()?;
    let mut f_1: Option<String> = None;
    loop {
      let field_ident = i_prot.read_field_begin()?;
      if field_ident.field_type == TType::Stop {
        break;
      }
      let field_id = field_id(&field_ident)?;
      match field_id {
        1 => {
          let val = i_prot.read_string()?;
          f_1 = Some(val);
        },
        _ => {
          i_prot.skip(field_ident.field_type)?;
        },
      };
      i_prot.read_field_end()?;
    }
    i_prot.read_struct_end()?;
    verify_required_field_exists("THBaseServiceDeleteNamespaceArgs.name", &f_1)?;
    let ret = THBaseServiceDeleteNamespaceArgs {
      name: f_1.expect("auto-generated code should have checked for presence of required fields"),
    };
    Ok(ret)
  }
  fn write_to_out_protocol(&self, o_prot: &mut dyn TOutputProtocol) -> thrift::Result<()> {
    let struct_ident = TStructIdentifier::new("deleteNamespace_args");
    o_prot.write_struct_begin(&struct_ident)?;
    o_prot.write_field_begin(&TFieldIdentifier::new("name", TType::String, 1))?;
    o_prot.write_string(&self.name)?;
    o_prot.write_field_end()?;
    o_prot.write_field_stop()?;
    o_prot.write_struct_end()
  }
}

//
// THBaseServiceDeleteNamespaceResult
//

#[derive(Clone, Debug, Eq, Hash, Ord, PartialEq, PartialOrd)]
struct THBaseServiceDeleteNamespaceResult {
  io: Option<TIOError>,
}

impl THBaseServiceDeleteNamespaceResult {
  fn read_from_in_protocol(i_prot: &mut dyn TInputProtocol) -> thrift::Result<THBaseServiceDeleteNamespaceResult> {
    i_prot.read_struct_begin()?;
    let mut f_1: Option<TIOError> = None;
    loop {
      let field_ident = i_prot.read_field_begin()?;
      if field_ident.field_type == TType::Stop {
        break;
      }
      let field_id = field_id(&field_ident)?;
      match field_id {
        1 => {
          let val = TIOError::read_from_in_protocol(i_prot)?;
          f_1 = Some(val);
        },
        _ => {
          i_prot.skip(field_ident.field_type)?;
        },
      };
      i_prot.read_field_end()?;
    }
    i_prot.read_struct_end()?;
    let ret = THBaseServiceDeleteNamespaceResult {
      io: f_1,
    };
    Ok(ret)
  }
  fn write_to_out_protocol(&self, o_prot: &mut dyn TOutputProtocol) -> thrift::Result<()> {
    let struct_ident = TStructIdentifier::new("THBaseServiceDeleteNamespaceResult");
    o_prot.write_struct_begin(&struct_ident)?;
    if let Some(ref fld_var) = self.io {
      o_prot.write_field_begin(&TFieldIdentifier::new("io", TType::Struct, 1))?;
      fld_var.write_to_out_protocol(o_prot)?;
      o_prot.write_field_end()?
    }
    o_prot.write_field_stop()?;
    o_prot.write_struct_end()
  }
  fn ok_or(self) -> thrift::Result<()> {
    if self.io.is_some() {
      Err(thrift::Error::User(Box::new(self.io.unwrap())))
    } else {
      Ok(())
    }
  }
}

//
// THBaseServiceGetNamespaceDescriptorArgs
//

#[derive(Clone, Debug, Eq, Hash, Ord, PartialEq, PartialOrd)]
struct THBaseServiceGetNamespaceDescriptorArgs {
  /// name of namespace descriptor
  name: String,
}

impl THBaseServiceGetNamespaceDescriptorArgs {
  fn read_from_in_protocol(i_prot: &mut dyn TInputProtocol) -> thrift::Result<THBaseServiceGetNamespaceDescriptorArgs> {
    i_prot.read_struct_begin()?;
    let mut f_1: Option<String> = None;
    loop {
      let field_ident = i_prot.read_field_begin()?;
      if field_ident.field_type == TType::Stop {
        break;
      }
      let field_id = field_id(&field_ident)?;
      match field_id {
        1 => {
          let val = i_prot.read_string()?;
          f_1 = Some(val);
        },
        _ => {
          i_prot.skip(field_ident.field_type)?;
        },
      };
      i_prot.read_field_end()?;
    }
    i_prot.read_struct_end()?;
    verify_required_field_exists("THBaseServiceGetNamespaceDescriptorArgs.name", &f_1)?;
    let ret = THBaseServiceGetNamespaceDescriptorArgs {
      name: f_1.expect("auto-generated code should have checked for presence of required fields"),
    };
    Ok(ret)
  }
  fn write_to_out_protocol(&self, o_prot: &mut dyn TOutputProtocol) -> thrift::Result<()> {
    let struct_ident = TStructIdentifier::new("getNamespaceDescriptor_args");
    o_prot.write_struct_begin(&struct_ident)?;
    o_prot.write_field_begin(&TFieldIdentifier::new("name", TType::String, 1))?;
    o_prot.write_string(&self.name)?;
    o_prot.write_field_end()?;
    o_prot.write_field_stop()?;
    o_prot.write_struct_end()
  }
}

//
// THBaseServiceGetNamespaceDescriptorResult
//

#[derive(Clone, Debug, Eq, Hash, Ord, PartialEq, PartialOrd)]
struct THBaseServiceGetNamespaceDescriptorResult {
  result_value: Option<TNamespaceDescriptor>,
  io: Option<TIOError>,
}

impl THBaseServiceGetNamespaceDescriptorResult {
  fn read_from_in_protocol(i_prot: &mut dyn TInputProtocol) -> thrift::Result<THBaseServiceGetNamespaceDescriptorResult> {
    i_prot.read_struct_begin()?;
    let mut f_0: Option<TNamespaceDescriptor> = None;
    let mut f_1: Option<TIOError> = None;
    loop {
      let field_ident = i_prot.read_field_begin()?;
      if field_ident.field_type == TType::Stop {
        break;
      }
      let field_id = field_id(&field_ident)?;
      match field_id {
        0 => {
          let val = TNamespaceDescriptor::read_from_in_protocol(i_prot)?;
          f_0 = Some(val);
        },
        1 => {
          let val = TIOError::read_from_in_protocol(i_prot)?;
          f_1 = Some(val);
        },
        _ => {
          i_prot.skip(field_ident.field_type)?;
        },
      };
      i_prot.read_field_end()?;
    }
    i_prot.read_struct_end()?;
    let ret = THBaseServiceGetNamespaceDescriptorResult {
      result_value: f_0,
      io: f_1,
    };
    Ok(ret)
  }
  fn write_to_out_protocol(&self, o_prot: &mut dyn TOutputProtocol) -> thrift::Result<()> {
    let struct_ident = TStructIdentifier::new("THBaseServiceGetNamespaceDescriptorResult");
    o_prot.write_struct_begin(&struct_ident)?;
    if let Some(ref fld_var) = self.result_value {
      o_prot.write_field_begin(&TFieldIdentifier::new("result_value", TType::Struct, 0))?;
      fld_var.write_to_out_protocol(o_prot)?;
      o_prot.write_field_end()?
    }
    if let Some(ref fld_var) = self.io {
      o_prot.write_field_begin(&TFieldIdentifier::new("io", TType::Struct, 1))?;
      fld_var.write_to_out_protocol(o_prot)?;
      o_prot.write_field_end()?
    }
    o_prot.write_field_stop()?;
    o_prot.write_struct_end()
  }
  fn ok_or(self) -> thrift::Result<TNamespaceDescriptor> {
    if self.io.is_some() {
      Err(thrift::Error::User(Box::new(self.io.unwrap())))
    } else if self.result_value.is_some() {
      Ok(self.result_value.unwrap())
    } else {
      Err(
        thrift::Error::Application(
          ApplicationError::new(
            ApplicationErrorKind::MissingResult,
            "no result received for THBaseServiceGetNamespaceDescriptor"
          )
        )
      )
    }
  }
}

//
// THBaseServiceListNamespaceDescriptorsArgs
//

#[derive(Clone, Debug, Eq, Hash, Ord, PartialEq, PartialOrd)]
struct THBaseServiceListNamespaceDescriptorsArgs {
}

impl THBaseServiceListNamespaceDescriptorsArgs {
  fn read_from_in_protocol(i_prot: &mut dyn TInputProtocol) -> thrift::Result<THBaseServiceListNamespaceDescriptorsArgs> {
    i_prot.read_struct_begin()?;
    loop {
      let field_ident = i_prot.read_field_begin()?;
      if field_ident.field_type == TType::Stop {
        break;
      }
      let field_id = field_id(&field_ident)?;
      match field_id {
        _ => {
          i_prot.skip(field_ident.field_type)?;
        },
      };
      i_prot.read_field_end()?;
    }
    i_prot.read_struct_end()?;
    let ret = THBaseServiceListNamespaceDescriptorsArgs {};
    Ok(ret)
  }
  fn write_to_out_protocol(&self, o_prot: &mut dyn TOutputProtocol) -> thrift::Result<()> {
    let struct_ident = TStructIdentifier::new("listNamespaceDescriptors_args");
    o_prot.write_struct_begin(&struct_ident)?;
    o_prot.write_field_stop()?;
    o_prot.write_struct_end()
  }
}

//
// THBaseServiceListNamespaceDescriptorsResult
//

#[derive(Clone, Debug, Eq, Hash, Ord, PartialEq, PartialOrd)]
struct THBaseServiceListNamespaceDescriptorsResult {
  result_value: Option<Vec<TNamespaceDescriptor>>,
  io: Option<TIOError>,
}

impl THBaseServiceListNamespaceDescriptorsResult {
  fn read_from_in_protocol(i_prot: &mut dyn TInputProtocol) -> thrift::Result<THBaseServiceListNamespaceDescriptorsResult> {
    i_prot.read_struct_begin()?;
    let mut f_0: Option<Vec<TNamespaceDescriptor>> = None;
    let mut f_1: Option<TIOError> = None;
    loop {
      let field_ident = i_prot.read_field_begin()?;
      if field_ident.field_type == TType::Stop {
        break;
      }
      let field_id = field_id(&field_ident)?;
      match field_id {
        0 => {
          let list_ident = i_prot.read_list_begin()?;
          let mut val: Vec<TNamespaceDescriptor> = Vec::with_capacity(list_ident.size as usize);
          for _ in 0..list_ident.size {
            let list_elem_50 = TNamespaceDescriptor::read_from_in_protocol(i_prot)?;
            val.push(list_elem_50);
          }
          i_prot.read_list_end()?;
          f_0 = Some(val);
        },
        1 => {
          let val = TIOError::read_from_in_protocol(i_prot)?;
          f_1 = Some(val);
        },
        _ => {
          i_prot.skip(field_ident.field_type)?;
        },
      };
      i_prot.read_field_end()?;
    }
    i_prot.read_struct_end()?;
    let ret = THBaseServiceListNamespaceDescriptorsResult {
      result_value: f_0,
      io: f_1,
    };
    Ok(ret)
  }
  fn write_to_out_protocol(&self, o_prot: &mut dyn TOutputProtocol) -> thrift::Result<()> {
    let struct_ident = TStructIdentifier::new("THBaseServiceListNamespaceDescriptorsResult");
    o_prot.write_struct_begin(&struct_ident)?;
    if let Some(ref fld_var) = self.result_value {
      o_prot.write_field_begin(&TFieldIdentifier::new("result_value", TType::List, 0))?;
      o_prot.write_list_begin(&TListIdentifier::new(TType::Struct, fld_var.len() as i32))?;
      for e in fld_var {
        e.write_to_out_protocol(o_prot)?;
      }
      o_prot.write_list_end()?;
      o_prot.write_field_end()?
    }
    if let Some(ref fld_var) = self.io {
      o_prot.write_field_begin(&TFieldIdentifier::new("io", TType::Struct, 1))?;
      fld_var.write_to_out_protocol(o_prot)?;
      o_prot.write_field_end()?
    }
    o_prot.write_field_stop()?;
    o_prot.write_struct_end()
  }
  fn ok_or(self) -> thrift::Result<Vec<TNamespaceDescriptor>> {
    if self.io.is_some() {
      Err(thrift::Error::User(Box::new(self.io.unwrap())))
    } else if self.result_value.is_some() {
      Ok(self.result_value.unwrap())
    } else {
      Err(
        thrift::Error::Application(
          ApplicationError::new(
            ApplicationErrorKind::MissingResult,
            "no result received for THBaseServiceListNamespaceDescriptors"
          )
        )
      )
    }
  }
}

//
// THBaseServiceListNamespacesArgs
//

#[derive(Clone, Debug, Eq, Hash, Ord, PartialEq, PartialOrd)]
struct THBaseServiceListNamespacesArgs {
}

impl THBaseServiceListNamespacesArgs {
  fn read_from_in_protocol(i_prot: &mut dyn TInputProtocol) -> thrift::Result<THBaseServiceListNamespacesArgs> {
    i_prot.read_struct_begin()?;
    loop {
      let field_ident = i_prot.read_field_begin()?;
      if field_ident.field_type == TType::Stop {
        break;
      }
      let field_id = field_id(&field_ident)?;
      match field_id {
        _ => {
          i_prot.skip(field_ident.field_type)?;
        },
      };
      i_prot.read_field_end()?;
    }
    i_prot.read_struct_end()?;
    let ret = THBaseServiceListNamespacesArgs {};
    Ok(ret)
  }
  fn write_to_out_protocol(&self, o_prot: &mut dyn TOutputProtocol) -> thrift::Result<()> {
    let struct_ident = TStructIdentifier::new("listNamespaces_args");
    o_prot.write_struct_begin(&struct_ident)?;
    o_prot.write_field_stop()?;
    o_prot.write_struct_end()
  }
}

//
// THBaseServiceListNamespacesResult
//

#[derive(Clone, Debug, Eq, Hash, Ord, PartialEq, PartialOrd)]
struct THBaseServiceListNamespacesResult {
  result_value: Option<Vec<String>>,
  io: Option<TIOError>,
}

impl THBaseServiceListNamespacesResult {
  fn read_from_in_protocol(i_prot: &mut dyn TInputProtocol) -> thrift::Result<THBaseServiceListNamespacesResult> {
    i_prot.read_struct_begin()?;
    let mut f_0: Option<Vec<String>> = None;
    let mut f_1: Option<TIOError> = None;
    loop {
      let field_ident = i_prot.read_field_begin()?;
      if field_ident.field_type == TType::Stop {
        break;
      }
      let field_id = field_id(&field_ident)?;
      match field_id {
        0 => {
          let list_ident = i_prot.read_list_begin()?;
          let mut val: Vec<String> = Vec::with_capacity(list_ident.size as usize);
          for _ in 0..list_ident.size {
            let list_elem_51 = i_prot.read_string()?;
            val.push(list_elem_51);
          }
          i_prot.read_list_end()?;
          f_0 = Some(val);
        },
        1 => {
          let val = TIOError::read_from_in_protocol(i_prot)?;
          f_1 = Some(val);
        },
        _ => {
          i_prot.skip(field_ident.field_type)?;
        },
      };
      i_prot.read_field_end()?;
    }
    i_prot.read_struct_end()?;
    let ret = THBaseServiceListNamespacesResult {
      result_value: f_0,
      io: f_1,
    };
    Ok(ret)
  }
  fn write_to_out_protocol(&self, o_prot: &mut dyn TOutputProtocol) -> thrift::Result<()> {
    let struct_ident = TStructIdentifier::new("THBaseServiceListNamespacesResult");
    o_prot.write_struct_begin(&struct_ident)?;
    if let Some(ref fld_var) = self.result_value {
      o_prot.write_field_begin(&TFieldIdentifier::new("result_value", TType::List, 0))?;
      o_prot.write_list_begin(&TListIdentifier::new(TType::String, fld_var.len() as i32))?;
      for e in fld_var {
        o_prot.write_string(e)?;
      }
      o_prot.write_list_end()?;
      o_prot.write_field_end()?
    }
    if let Some(ref fld_var) = self.io {
      o_prot.write_field_begin(&TFieldIdentifier::new("io", TType::Struct, 1))?;
      fld_var.write_to_out_protocol(o_prot)?;
      o_prot.write_field_end()?
    }
    o_prot.write_field_stop()?;
    o_prot.write_struct_end()
  }
  fn ok_or(self) -> thrift::Result<Vec<String>> {
    if self.io.is_some() {
      Err(thrift::Error::User(Box::new(self.io.unwrap())))
    } else if self.result_value.is_some() {
      Ok(self.result_value.unwrap())
    } else {
      Err(
        thrift::Error::Application(
          ApplicationError::new(
            ApplicationErrorKind::MissingResult,
            "no result received for THBaseServiceListNamespaces"
          )
        )
      )
    }
  }
}

//
// THBaseServiceGetThriftServerTypeArgs
//

#[derive(Clone, Debug, Eq, Hash, Ord, PartialEq, PartialOrd)]
struct THBaseServiceGetThriftServerTypeArgs {
}

impl THBaseServiceGetThriftServerTypeArgs {
  fn read_from_in_protocol(i_prot: &mut dyn TInputProtocol) -> thrift::Result<THBaseServiceGetThriftServerTypeArgs> {
    i_prot.read_struct_begin()?;
    loop {
      let field_ident = i_prot.read_field_begin()?;
      if field_ident.field_type == TType::Stop {
        break;
      }
      let field_id = field_id(&field_ident)?;
      match field_id {
        _ => {
          i_prot.skip(field_ident.field_type)?;
        },
      };
      i_prot.read_field_end()?;
    }
    i_prot.read_struct_end()?;
    let ret = THBaseServiceGetThriftServerTypeArgs {};
    Ok(ret)
  }
  fn write_to_out_protocol(&self, o_prot: &mut dyn TOutputProtocol) -> thrift::Result<()> {
    let struct_ident = TStructIdentifier::new("getThriftServerType_args");
    o_prot.write_struct_begin(&struct_ident)?;
    o_prot.write_field_stop()?;
    o_prot.write_struct_end()
  }
}

//
// THBaseServiceGetThriftServerTypeResult
//

#[derive(Clone, Debug, Eq, Hash, Ord, PartialEq, PartialOrd)]
struct THBaseServiceGetThriftServerTypeResult {
  result_value: Option<TThriftServerType>,
}

impl THBaseServiceGetThriftServerTypeResult {
  fn read_from_in_protocol(i_prot: &mut dyn TInputProtocol) -> thrift::Result<THBaseServiceGetThriftServerTypeResult> {
    i_prot.read_struct_begin()?;
    let mut f_0: Option<TThriftServerType> = None;
    loop {
      let field_ident = i_prot.read_field_begin()?;
      if field_ident.field_type == TType::Stop {
        break;
      }
      let field_id = field_id(&field_ident)?;
      match field_id {
        0 => {
          let val = TThriftServerType::read_from_in_protocol(i_prot)?;
          f_0 = Some(val);
        },
        _ => {
          i_prot.skip(field_ident.field_type)?;
        },
      };
      i_prot.read_field_end()?;
    }
    i_prot.read_struct_end()?;
    let ret = THBaseServiceGetThriftServerTypeResult {
      result_value: f_0,
    };
    Ok(ret)
  }
  fn write_to_out_protocol(&self, o_prot: &mut dyn TOutputProtocol) -> thrift::Result<()> {
    let struct_ident = TStructIdentifier::new("THBaseServiceGetThriftServerTypeResult");
    o_prot.write_struct_begin(&struct_ident)?;
    if let Some(ref fld_var) = self.result_value {
      o_prot.write_field_begin(&TFieldIdentifier::new("result_value", TType::I32, 0))?;
      fld_var.write_to_out_protocol(o_prot)?;
      o_prot.write_field_end()?
    }
    o_prot.write_field_stop()?;
    o_prot.write_struct_end()
  }
  fn ok_or(self) -> thrift::Result<TThriftServerType> {
    if self.result_value.is_some() {
      Ok(self.result_value.unwrap())
    } else {
      Err(
        thrift::Error::Application(
          ApplicationError::new(
            ApplicationErrorKind::MissingResult,
            "no result received for THBaseServiceGetThriftServerType"
          )
        )
      )
    }
  }
}

//
// THBaseServiceGetClusterIdArgs
//

#[derive(Clone, Debug, Eq, Hash, Ord, PartialEq, PartialOrd)]
struct THBaseServiceGetClusterIdArgs {
}

impl THBaseServiceGetClusterIdArgs {
  fn read_from_in_protocol(i_prot: &mut dyn TInputProtocol) -> thrift::Result<THBaseServiceGetClusterIdArgs> {
    i_prot.read_struct_begin()?;
    loop {
      let field_ident = i_prot.read_field_begin()?;
      if field_ident.field_type == TType::Stop {
        break;
      }
      let field_id = field_id(&field_ident)?;
      match field_id {
        _ => {
          i_prot.skip(field_ident.field_type)?;
        },
      };
      i_prot.read_field_end()?;
    }
    i_prot.read_struct_end()?;
    let ret = THBaseServiceGetClusterIdArgs {};
    Ok(ret)
  }
  fn write_to_out_protocol(&self, o_prot: &mut dyn TOutputProtocol) -> thrift::Result<()> {
    let struct_ident = TStructIdentifier::new("getClusterId_args");
    o_prot.write_struct_begin(&struct_ident)?;
    o_prot.write_field_stop()?;
    o_prot.write_struct_end()
  }
}

//
// THBaseServiceGetClusterIdResult
//

#[derive(Clone, Debug, Eq, Hash, Ord, PartialEq, PartialOrd)]
struct THBaseServiceGetClusterIdResult {
  result_value: Option<String>,
}

impl THBaseServiceGetClusterIdResult {
  fn read_from_in_protocol(i_prot: &mut dyn TInputProtocol) -> thrift::Result<THBaseServiceGetClusterIdResult> {
    i_prot.read_struct_begin()?;
    let mut f_0: Option<String> = None;
    loop {
      let field_ident = i_prot.read_field_begin()?;
      if field_ident.field_type == TType::Stop {
        break;
      }
      let field_id = field_id(&field_ident)?;
      match field_id {
        0 => {
          let val = i_prot.read_string()?;
          f_0 = Some(val);
        },
        _ => {
          i_prot.skip(field_ident.field_type)?;
        },
      };
      i_prot.read_field_end()?;
    }
    i_prot.read_struct_end()?;
    let ret = THBaseServiceGetClusterIdResult {
      result_value: f_0,
    };
    Ok(ret)
  }
  fn write_to_out_protocol(&self, o_prot: &mut dyn TOutputProtocol) -> thrift::Result<()> {
    let struct_ident = TStructIdentifier::new("THBaseServiceGetClusterIdResult");
    o_prot.write_struct_begin(&struct_ident)?;
    if let Some(ref fld_var) = self.result_value {
      o_prot.write_field_begin(&TFieldIdentifier::new("result_value", TType::String, 0))?;
      o_prot.write_string(fld_var)?;
      o_prot.write_field_end()?
    }
    o_prot.write_field_stop()?;
    o_prot.write_struct_end()
  }
  fn ok_or(self) -> thrift::Result<String> {
    if self.result_value.is_some() {
      Ok(self.result_value.unwrap())
    } else {
      Err(
        thrift::Error::Application(
          ApplicationError::new(
            ApplicationErrorKind::MissingResult,
            "no result received for THBaseServiceGetClusterId"
          )
        )
      )
    }
  }
}

//
// THBaseServiceGetSlowLogResponsesArgs
//

#[derive(Clone, Debug, Eq, Hash, Ord, PartialEq, PartialOrd)]
struct THBaseServiceGetSlowLogResponsesArgs {
  /// @param serverNames Server names to get slowlog responses from
  server_names: BTreeSet<TServerName>,
  /// @param logQueryFilter filter to be used if provided
  log_query_filter: TLogQueryFilter,
}

impl THBaseServiceGetSlowLogResponsesArgs {
  fn read_from_in_protocol(i_prot: &mut dyn TInputProtocol) -> thrift::Result<THBaseServiceGetSlowLogResponsesArgs> {
    i_prot.read_struct_begin()?;
    let mut f_1: Option<BTreeSet<TServerName>> = None;
    let mut f_2: Option<TLogQueryFilter> = None;
    loop {
      let field_ident = i_prot.read_field_begin()?;
      if field_ident.field_type == TType::Stop {
        break;
      }
      let field_id = field_id(&field_ident)?;
      match field_id {
        1 => {
          let set_ident = i_prot.read_set_begin()?;
          let mut val: BTreeSet<TServerName> = BTreeSet::new();
          for _ in 0..set_ident.size {
            let set_elem_52 = TServerName::read_from_in_protocol(i_prot)?;
            val.insert(set_elem_52);
          }
          i_prot.read_set_end()?;
          f_1 = Some(val);
        },
        2 => {
          let val = TLogQueryFilter::read_from_in_protocol(i_prot)?;
          f_2 = Some(val);
        },
        _ => {
          i_prot.skip(field_ident.field_type)?;
        },
      };
      i_prot.read_field_end()?;
    }
    i_prot.read_struct_end()?;
    verify_required_field_exists("THBaseServiceGetSlowLogResponsesArgs.server_names", &f_1)?;
    verify_required_field_exists("THBaseServiceGetSlowLogResponsesArgs.log_query_filter", &f_2)?;
    let ret = THBaseServiceGetSlowLogResponsesArgs {
      server_names: f_1.expect("auto-generated code should have checked for presence of required fields"),
      log_query_filter: f_2.expect("auto-generated code should have checked for presence of required fields"),
    };
    Ok(ret)
  }
  fn write_to_out_protocol(&self, o_prot: &mut dyn TOutputProtocol) -> thrift::Result<()> {
    let struct_ident = TStructIdentifier::new("getSlowLogResponses_args");
    o_prot.write_struct_begin(&struct_ident)?;
    o_prot.write_field_begin(&TFieldIdentifier::new("serverNames", TType::Set, 1))?;
    o_prot.write_set_begin(&TSetIdentifier::new(TType::Struct, self.server_names.len() as i32))?;
    for e in &self.server_names {
      e.write_to_out_protocol(o_prot)?;
    }
    o_prot.write_set_end()?;
    o_prot.write_field_end()?;
    o_prot.write_field_begin(&TFieldIdentifier::new("logQueryFilter", TType::Struct, 2))?;
    self.log_query_filter.write_to_out_protocol(o_prot)?;
    o_prot.write_field_end()?;
    o_prot.write_field_stop()?;
    o_prot.write_struct_end()
  }
}

//
// THBaseServiceGetSlowLogResponsesResult
//

#[derive(Clone, Debug, Eq, Hash, Ord, PartialEq, PartialOrd)]
struct THBaseServiceGetSlowLogResponsesResult {
  result_value: Option<Vec<TOnlineLogRecord>>,
  io: Option<TIOError>,
}

impl THBaseServiceGetSlowLogResponsesResult {
  fn read_from_in_protocol(i_prot: &mut dyn TInputProtocol) -> thrift::Result<THBaseServiceGetSlowLogResponsesResult> {
    i_prot.read_struct_begin()?;
    let mut f_0: Option<Vec<TOnlineLogRecord>> = None;
    let mut f_1: Option<TIOError> = None;
    loop {
      let field_ident = i_prot.read_field_begin()?;
      if field_ident.field_type == TType::Stop {
        break;
      }
      let field_id = field_id(&field_ident)?;
      match field_id {
        0 => {
          let list_ident = i_prot.read_list_begin()?;
          let mut val: Vec<TOnlineLogRecord> = Vec::with_capacity(list_ident.size as usize);
          for _ in 0..list_ident.size {
            let list_elem_53 = TOnlineLogRecord::read_from_in_protocol(i_prot)?;
            val.push(list_elem_53);
          }
          i_prot.read_list_end()?;
          f_0 = Some(val);
        },
        1 => {
          let val = TIOError::read_from_in_protocol(i_prot)?;
          f_1 = Some(val);
        },
        _ => {
          i_prot.skip(field_ident.field_type)?;
        },
      };
      i_prot.read_field_end()?;
    }
    i_prot.read_struct_end()?;
    let ret = THBaseServiceGetSlowLogResponsesResult {
      result_value: f_0,
      io: f_1,
    };
    Ok(ret)
  }
  fn write_to_out_protocol(&self, o_prot: &mut dyn TOutputProtocol) -> thrift::Result<()> {
    let struct_ident = TStructIdentifier::new("THBaseServiceGetSlowLogResponsesResult");
    o_prot.write_struct_begin(&struct_ident)?;
    if let Some(ref fld_var) = self.result_value {
      o_prot.write_field_begin(&TFieldIdentifier::new("result_value", TType::List, 0))?;
      o_prot.write_list_begin(&TListIdentifier::new(TType::Struct, fld_var.len() as i32))?;
      for e in fld_var {
        e.write_to_out_protocol(o_prot)?;
      }
      o_prot.write_list_end()?;
      o_prot.write_field_end()?
    }
    if let Some(ref fld_var) = self.io {
      o_prot.write_field_begin(&TFieldIdentifier::new("io", TType::Struct, 1))?;
      fld_var.write_to_out_protocol(o_prot)?;
      o_prot.write_field_end()?
    }
    o_prot.write_field_stop()?;
    o_prot.write_struct_end()
  }
  fn ok_or(self) -> thrift::Result<Vec<TOnlineLogRecord>> {
    if self.io.is_some() {
      Err(thrift::Error::User(Box::new(self.io.unwrap())))
    } else if self.result_value.is_some() {
      Ok(self.result_value.unwrap())
    } else {
      Err(
        thrift::Error::Application(
          ApplicationError::new(
            ApplicationErrorKind::MissingResult,
            "no result received for THBaseServiceGetSlowLogResponses"
          )
        )
      )
    }
  }
}

//
// THBaseServiceClearSlowLogResponsesArgs
//

#[derive(Clone, Debug, Eq, Hash, Ord, PartialEq, PartialOrd)]
struct THBaseServiceClearSlowLogResponsesArgs {
  /// @param serverNames Set of Server names to clean slowlog responses from
  server_names: BTreeSet<TServerName>,
}

impl THBaseServiceClearSlowLogResponsesArgs {
  fn read_from_in_protocol(i_prot: &mut dyn TInputProtocol) -> thrift::Result<THBaseServiceClearSlowLogResponsesArgs> {
    i_prot.read_struct_begin()?;
    let mut f_1: Option<BTreeSet<TServerName>> = None;
    loop {
      let field_ident = i_prot.read_field_begin()?;
      if field_ident.field_type == TType::Stop {
        break;
      }
      let field_id = field_id(&field_ident)?;
      match field_id {
        1 => {
          let set_ident = i_prot.read_set_begin()?;
          let mut val: BTreeSet<TServerName> = BTreeSet::new();
          for _ in 0..set_ident.size {
            let set_elem_54 = TServerName::read_from_in_protocol(i_prot)?;
            val.insert(set_elem_54);
          }
          i_prot.read_set_end()?;
          f_1 = Some(val);
        },
        _ => {
          i_prot.skip(field_ident.field_type)?;
        },
      };
      i_prot.read_field_end()?;
    }
    i_prot.read_struct_end()?;
    verify_required_field_exists("THBaseServiceClearSlowLogResponsesArgs.server_names", &f_1)?;
    let ret = THBaseServiceClearSlowLogResponsesArgs {
      server_names: f_1.expect("auto-generated code should have checked for presence of required fields"),
    };
    Ok(ret)
  }
  fn write_to_out_protocol(&self, o_prot: &mut dyn TOutputProtocol) -> thrift::Result<()> {
    let struct_ident = TStructIdentifier::new("clearSlowLogResponses_args");
    o_prot.write_struct_begin(&struct_ident)?;
    o_prot.write_field_begin(&TFieldIdentifier::new("serverNames", TType::Set, 1))?;
    o_prot.write_set_begin(&TSetIdentifier::new(TType::Struct, self.server_names.len() as i32))?;
    for e in &self.server_names {
      e.write_to_out_protocol(o_prot)?;
    }
    o_prot.write_set_end()?;
    o_prot.write_field_end()?;
    o_prot.write_field_stop()?;
    o_prot.write_struct_end()
  }
}

//
// THBaseServiceClearSlowLogResponsesResult
//

#[derive(Clone, Debug, Eq, Hash, Ord, PartialEq, PartialOrd)]
struct THBaseServiceClearSlowLogResponsesResult {
  result_value: Option<Vec<bool>>,
  io: Option<TIOError>,
}

impl THBaseServiceClearSlowLogResponsesResult {
  fn read_from_in_protocol(i_prot: &mut dyn TInputProtocol) -> thrift::Result<THBaseServiceClearSlowLogResponsesResult> {
    i_prot.read_struct_begin()?;
    let mut f_0: Option<Vec<bool>> = None;
    let mut f_1: Option<TIOError> = None;
    loop {
      let field_ident = i_prot.read_field_begin()?;
      if field_ident.field_type == TType::Stop {
        break;
      }
      let field_id = field_id(&field_ident)?;
      match field_id {
        0 => {
          let list_ident = i_prot.read_list_begin()?;
          let mut val: Vec<bool> = Vec::with_capacity(list_ident.size as usize);
          for _ in 0..list_ident.size {
            let list_elem_55 = i_prot.read_bool()?;
            val.push(list_elem_55);
          }
          i_prot.read_list_end()?;
          f_0 = Some(val);
        },
        1 => {
          let val = TIOError::read_from_in_protocol(i_prot)?;
          f_1 = Some(val);
        },
        _ => {
          i_prot.skip(field_ident.field_type)?;
        },
      };
      i_prot.read_field_end()?;
    }
    i_prot.read_struct_end()?;
    let ret = THBaseServiceClearSlowLogResponsesResult {
      result_value: f_0,
      io: f_1,
    };
    Ok(ret)
  }
  fn write_to_out_protocol(&self, o_prot: &mut dyn TOutputProtocol) -> thrift::Result<()> {
    let struct_ident = TStructIdentifier::new("THBaseServiceClearSlowLogResponsesResult");
    o_prot.write_struct_begin(&struct_ident)?;
    if let Some(ref fld_var) = self.result_value {
      o_prot.write_field_begin(&TFieldIdentifier::new("result_value", TType::List, 0))?;
      o_prot.write_list_begin(&TListIdentifier::new(TType::Bool, fld_var.len() as i32))?;
      for e in fld_var {
        o_prot.write_bool(*e)?;
      }
      o_prot.write_list_end()?;
      o_prot.write_field_end()?
    }
    if let Some(ref fld_var) = self.io {
      o_prot.write_field_begin(&TFieldIdentifier::new("io", TType::Struct, 1))?;
      fld_var.write_to_out_protocol(o_prot)?;
      o_prot.write_field_end()?
    }
    o_prot.write_field_stop()?;
    o_prot.write_struct_end()
  }
  fn ok_or(self) -> thrift::Result<Vec<bool>> {
    if self.io.is_some() {
      Err(thrift::Error::User(Box::new(self.io.unwrap())))
    } else if self.result_value.is_some() {
      Ok(self.result_value.unwrap())
    } else {
      Err(
        thrift::Error::Application(
          ApplicationError::new(
            ApplicationErrorKind::MissingResult,
            "no result received for THBaseServiceClearSlowLogResponses"
          )
        )
      )
    }
  }
}

//
// THBaseServiceGrantArgs
//

#[derive(Clone, Debug, Eq, Hash, Ord, PartialEq, PartialOrd)]
struct THBaseServiceGrantArgs {
  info: TAccessControlEntity,
}

impl THBaseServiceGrantArgs {
  fn read_from_in_protocol(i_prot: &mut dyn TInputProtocol) -> thrift::Result<THBaseServiceGrantArgs> {
    i_prot.read_struct_begin()?;
    let mut f_1: Option<TAccessControlEntity> = None;
    loop {
      let field_ident = i_prot.read_field_begin()?;
      if field_ident.field_type == TType::Stop {
        break;
      }
      let field_id = field_id(&field_ident)?;
      match field_id {
        1 => {
          let val = TAccessControlEntity::read_from_in_protocol(i_prot)?;
          f_1 = Some(val);
        },
        _ => {
          i_prot.skip(field_ident.field_type)?;
        },
      };
      i_prot.read_field_end()?;
    }
    i_prot.read_struct_end()?;
    verify_required_field_exists("THBaseServiceGrantArgs.info", &f_1)?;
    let ret = THBaseServiceGrantArgs {
      info: f_1.expect("auto-generated code should have checked for presence of required fields"),
    };
    Ok(ret)
  }
  fn write_to_out_protocol(&self, o_prot: &mut dyn TOutputProtocol) -> thrift::Result<()> {
    let struct_ident = TStructIdentifier::new("grant_args");
    o_prot.write_struct_begin(&struct_ident)?;
    o_prot.write_field_begin(&TFieldIdentifier::new("info", TType::Struct, 1))?;
    self.info.write_to_out_protocol(o_prot)?;
    o_prot.write_field_end()?;
    o_prot.write_field_stop()?;
    o_prot.write_struct_end()
  }
}

//
// THBaseServiceGrantResult
//

#[derive(Clone, Debug, Eq, Hash, Ord, PartialEq, PartialOrd)]
struct THBaseServiceGrantResult {
  result_value: Option<bool>,
  io: Option<TIOError>,
}

impl THBaseServiceGrantResult {
  fn read_from_in_protocol(i_prot: &mut dyn TInputProtocol) -> thrift::Result<THBaseServiceGrantResult> {
    i_prot.read_struct_begin()?;
    let mut f_0: Option<bool> = None;
    let mut f_1: Option<TIOError> = None;
    loop {
      let field_ident = i_prot.read_field_begin()?;
      if field_ident.field_type == TType::Stop {
        break;
      }
      let field_id = field_id(&field_ident)?;
      match field_id {
        0 => {
          let val = i_prot.read_bool()?;
          f_0 = Some(val);
        },
        1 => {
          let val = TIOError::read_from_in_protocol(i_prot)?;
          f_1 = Some(val);
        },
        _ => {
          i_prot.skip(field_ident.field_type)?;
        },
      };
      i_prot.read_field_end()?;
    }
    i_prot.read_struct_end()?;
    let ret = THBaseServiceGrantResult {
      result_value: f_0,
      io: f_1,
    };
    Ok(ret)
  }
  fn write_to_out_protocol(&self, o_prot: &mut dyn TOutputProtocol) -> thrift::Result<()> {
    let struct_ident = TStructIdentifier::new("THBaseServiceGrantResult");
    o_prot.write_struct_begin(&struct_ident)?;
    if let Some(fld_var) = self.result_value {
      o_prot.write_field_begin(&TFieldIdentifier::new("result_value", TType::Bool, 0))?;
      o_prot.write_bool(fld_var)?;
      o_prot.write_field_end()?
    }
    if let Some(ref fld_var) = self.io {
      o_prot.write_field_begin(&TFieldIdentifier::new("io", TType::Struct, 1))?;
      fld_var.write_to_out_protocol(o_prot)?;
      o_prot.write_field_end()?
    }
    o_prot.write_field_stop()?;
    o_prot.write_struct_end()
  }
  fn ok_or(self) -> thrift::Result<bool> {
    if self.io.is_some() {
      Err(thrift::Error::User(Box::new(self.io.unwrap())))
    } else if self.result_value.is_some() {
      Ok(self.result_value.unwrap())
    } else {
      Err(
        thrift::Error::Application(
          ApplicationError::new(
            ApplicationErrorKind::MissingResult,
            "no result received for THBaseServiceGrant"
          )
        )
      )
    }
  }
}

//
// THBaseServiceRevokeArgs
//

#[derive(Clone, Debug, Eq, Hash, Ord, PartialEq, PartialOrd)]
struct THBaseServiceRevokeArgs {
  info: TAccessControlEntity,
}

impl THBaseServiceRevokeArgs {
  fn read_from_in_protocol(i_prot: &mut dyn TInputProtocol) -> thrift::Result<THBaseServiceRevokeArgs> {
    i_prot.read_struct_begin()?;
    let mut f_1: Option<TAccessControlEntity> = None;
    loop {
      let field_ident = i_prot.read_field_begin()?;
      if field_ident.field_type == TType::Stop {
        break;
      }
      let field_id = field_id(&field_ident)?;
      match field_id {
        1 => {
          let val = TAccessControlEntity::read_from_in_protocol(i_prot)?;
          f_1 = Some(val);
        },
        _ => {
          i_prot.skip(field_ident.field_type)?;
        },
      };
      i_prot.read_field_end()?;
    }
    i_prot.read_struct_end()?;
    verify_required_field_exists("THBaseServiceRevokeArgs.info", &f_1)?;
    let ret = THBaseServiceRevokeArgs {
      info: f_1.expect("auto-generated code should have checked for presence of required fields"),
    };
    Ok(ret)
  }
  fn write_to_out_protocol(&self, o_prot: &mut dyn TOutputProtocol) -> thrift::Result<()> {
    let struct_ident = TStructIdentifier::new("revoke_args");
    o_prot.write_struct_begin(&struct_ident)?;
    o_prot.write_field_begin(&TFieldIdentifier::new("info", TType::Struct, 1))?;
    self.info.write_to_out_protocol(o_prot)?;
    o_prot.write_field_end()?;
    o_prot.write_field_stop()?;
    o_prot.write_struct_end()
  }
}

//
// THBaseServiceRevokeResult
//

#[derive(Clone, Debug, Eq, Hash, Ord, PartialEq, PartialOrd)]
struct THBaseServiceRevokeResult {
  result_value: Option<bool>,
  io: Option<TIOError>,
}

impl THBaseServiceRevokeResult {
  fn read_from_in_protocol(i_prot: &mut dyn TInputProtocol) -> thrift::Result<THBaseServiceRevokeResult> {
    i_prot.read_struct_begin()?;
    let mut f_0: Option<bool> = None;
    let mut f_1: Option<TIOError> = None;
    loop {
      let field_ident = i_prot.read_field_begin()?;
      if field_ident.field_type == TType::Stop {
        break;
      }
      let field_id = field_id(&field_ident)?;
      match field_id {
        0 => {
          let val = i_prot.read_bool()?;
          f_0 = Some(val);
        },
        1 => {
          let val = TIOError::read_from_in_protocol(i_prot)?;
          f_1 = Some(val);
        },
        _ => {
          i_prot.skip(field_ident.field_type)?;
        },
      };
      i_prot.read_field_end()?;
    }
    i_prot.read_struct_end()?;
    let ret = THBaseServiceRevokeResult {
      result_value: f_0,
      io: f_1,
    };
    Ok(ret)
  }
  fn write_to_out_protocol(&self, o_prot: &mut dyn TOutputProtocol) -> thrift::Result<()> {
    let struct_ident = TStructIdentifier::new("THBaseServiceRevokeResult");
    o_prot.write_struct_begin(&struct_ident)?;
    if let Some(fld_var) = self.result_value {
      o_prot.write_field_begin(&TFieldIdentifier::new("result_value", TType::Bool, 0))?;
      o_prot.write_bool(fld_var)?;
      o_prot.write_field_end()?
    }
    if let Some(ref fld_var) = self.io {
      o_prot.write_field_begin(&TFieldIdentifier::new("io", TType::Struct, 1))?;
      fld_var.write_to_out_protocol(o_prot)?;
      o_prot.write_field_end()?
    }
    o_prot.write_field_stop()?;
    o_prot.write_struct_end()
  }
  fn ok_or(self) -> thrift::Result<bool> {
    if self.io.is_some() {
      Err(thrift::Error::User(Box::new(self.io.unwrap())))
    } else if self.result_value.is_some() {
      Ok(self.result_value.unwrap())
    } else {
      Err(
        thrift::Error::Application(
          ApplicationError::new(
            ApplicationErrorKind::MissingResult,
            "no result received for THBaseServiceRevoke"
          )
        )
      )
    }
  }
}
