use hasher::Hasher;

#[cfg(feature = "hash-keccak")]
#[test]
fn test_keccak() {
    let h = hasher::HasherKeccak::new();
    let r = h.digest(&[]);
    assert_eq!(
        r,
        vec![
            0xc5, 0xd2, 0x46, 0x01, 0x86, 0xf7, 0x23, 0x3c, 0x92, 0x7e, 0x7d, 0xb2, 0xdc, 0xc7,
            0x03, 0xc0, 0xe5, 0x00, 0xb6, 0x53, 0xca, 0x82, 0x27, 0x3b, 0x7b, 0xfa, 0xd8, 0x04,
            0x5d, 0x85, 0xa4, 0x70,
        ]
    )
}

#[cfg(feature = "hash-blake2b")]
#[test]
fn test_blake2b() {
    let h = hasher::HasherBlake2B::new("CryptapeCryptape".as_bytes().to_vec());
    let r = h.digest(&[]);
    assert_eq!(
        r,
        vec![
            0xd6, 0x7f, 0x72, 0x9f, 0x8d, 0x19, 0xed, 0x2e, 0x92, 0xf8, 0x17, 0xcf, 0x5c, 0x31,
            0xc7, 0x81, 0x2d, 0xd3, 0x9e, 0xd3, 0x5b, 0x0b, 0x1a, 0xae, 0x41, 0xc7, 0x66, 0x5f,
            0x46, 0xc3, 0x6b, 0x9f,
        ]
    )
}

#[cfg(feature = "hash-sm3")]
#[test]
fn test_sm3() {
    let h = hasher::HasherSM3::new();
    let r = h.digest(&[]);
    assert_eq!(
        r,
        vec![
            0x1a, 0xb2, 0x1d, 0x83, 0x55, 0xcf, 0xa1, 0x7f, 0x8e, 0x61, 0x19, 0x48, 0x31, 0xe8,
            0x1a, 0x8f, 0x22, 0xbe, 0xc8, 0xc7, 0x28, 0xfe, 0xfb, 0x74, 0x7e, 0xd0, 0x35, 0xeb,
            0x50, 0x82, 0xaa, 0x2b,
        ]
    )
}
