var composition = (function (exports, require$$0$2) {
	'use strict';

	function _interopDefaultLegacy (e) { return e && typeof e === 'object' && 'default' in e ? e : { 'default': e }; }

	var require$$0__default = /*#__PURE__*/_interopDefaultLegacy(require$$0$2);

	var commonjsGlobal = typeof globalThis !== 'undefined' ? globalThis : typeof window !== 'undefined' ? window : typeof global !== 'undefined' ? global : typeof self !== 'undefined' ? self : {};

	function getAugmentedNamespace(n) {
		if (n.__esModule) return n;
		var a = Object.defineProperty({}, '__esModule', {value: true});
		Object.keys(n).forEach(function (k) {
			var d = Object.getOwnPropertyDescriptor(n, k);
			Object.defineProperty(a, k, d.get ? d : {
				enumerable: true,
				get: function () {
					return n[k];
				}
			});
		});
		return a;
	}

	var dist$3 = {};

	var compose$1 = {};

	var dist$2 = {};

	var definitions = {};

	/**
	 * Note: This file is autogenerated using "resources/gen-version.js" script and
	 * automatically updated by "npm version" command.
	 */

	/**
	 * A string containing the version of the GraphQL.js library
	 */
	var version$2 = '15.6.1';
	/**
	 * An object containing the components of the GraphQL.js version string
	 */

	var versionInfo = Object.freeze({
	  major: 15,
	  minor: 6,
	  patch: 1,
	  preReleaseTag: null
	});

	/**
	 * Returns true if the value acts like a Promise, i.e. has a "then" function,
	 * otherwise returns false.
	 */
	// eslint-disable-next-line no-redeclare
	function isPromise(value) {
	  return typeof (value === null || value === void 0 ? void 0 : value.then) === 'function';
	}

	function _typeof$4(obj) { "@babel/helpers - typeof"; if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof$4 = function _typeof(obj) { return typeof obj; }; } else { _typeof$4 = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof$4(obj); }

	/**
	 * Return true if `value` is object-like. A value is object-like if it's not
	 * `null` and has a `typeof` result of "object".
	 */
	function isObjectLike(value) {
	  return _typeof$4(value) == 'object' && value !== null;
	}

	// In ES2015 (or a polyfilled) environment, this will be Symbol.iterator
	// istanbul ignore next (See: 'https://github.com/graphql/graphql-js/issues/2317')
	var SYMBOL_ITERATOR = typeof Symbol === 'function' && Symbol.iterator != null ? Symbol.iterator : '@@iterator'; // In ES2017 (or a polyfilled) environment, this will be Symbol.asyncIterator
	// istanbul ignore next (See: 'https://github.com/graphql/graphql-js/issues/2317')

	var SYMBOL_ASYNC_ITERATOR = typeof Symbol === 'function' && Symbol.asyncIterator != null ? Symbol.asyncIterator : '@@asyncIterator'; // istanbul ignore next (See: 'https://github.com/graphql/graphql-js/issues/2317')

	var SYMBOL_TO_STRING_TAG = typeof Symbol === 'function' && Symbol.toStringTag != null ? Symbol.toStringTag : '@@toStringTag';

	/**
	 * Represents a location in a Source.
	 */

	/**
	 * Takes a Source and a UTF-8 character offset, and returns the corresponding
	 * line and column as a SourceLocation.
	 */
	function getLocation(source, position) {
	  var lineRegexp = /\r\n|[\n\r]/g;
	  var line = 1;
	  var column = position + 1;
	  var match;

	  while ((match = lineRegexp.exec(source.body)) && match.index < position) {
	    line += 1;
	    column = position + 1 - (match.index + match[0].length);
	  }

	  return {
	    line: line,
	    column: column
	  };
	}

	/**
	 * Render a helpful description of the location in the GraphQL Source document.
	 */

	function printLocation(location) {
	  return printSourceLocation(location.source, getLocation(location.source, location.start));
	}
	/**
	 * Render a helpful description of the location in the GraphQL Source document.
	 */

	function printSourceLocation(source, sourceLocation) {
	  var firstLineColumnOffset = source.locationOffset.column - 1;
	  var body = whitespace(firstLineColumnOffset) + source.body;
	  var lineIndex = sourceLocation.line - 1;
	  var lineOffset = source.locationOffset.line - 1;
	  var lineNum = sourceLocation.line + lineOffset;
	  var columnOffset = sourceLocation.line === 1 ? firstLineColumnOffset : 0;
	  var columnNum = sourceLocation.column + columnOffset;
	  var locationStr = "".concat(source.name, ":").concat(lineNum, ":").concat(columnNum, "\n");
	  var lines = body.split(/\r\n|[\n\r]/g);
	  var locationLine = lines[lineIndex]; // Special case for minified documents

	  if (locationLine.length > 120) {
	    var subLineIndex = Math.floor(columnNum / 80);
	    var subLineColumnNum = columnNum % 80;
	    var subLines = [];

	    for (var i = 0; i < locationLine.length; i += 80) {
	      subLines.push(locationLine.slice(i, i + 80));
	    }

	    return locationStr + printPrefixedLines([["".concat(lineNum), subLines[0]]].concat(subLines.slice(1, subLineIndex + 1).map(function (subLine) {
	      return ['', subLine];
	    }), [[' ', whitespace(subLineColumnNum - 1) + '^'], ['', subLines[subLineIndex + 1]]]));
	  }

	  return locationStr + printPrefixedLines([// Lines specified like this: ["prefix", "string"],
	  ["".concat(lineNum - 1), lines[lineIndex - 1]], ["".concat(lineNum), locationLine], ['', whitespace(columnNum - 1) + '^'], ["".concat(lineNum + 1), lines[lineIndex + 1]]]);
	}

	function printPrefixedLines(lines) {
	  var existingLines = lines.filter(function (_ref) {
	    _ref[0];
	        var line = _ref[1];
	    return line !== undefined;
	  });
	  var padLen = Math.max.apply(Math, existingLines.map(function (_ref2) {
	    var prefix = _ref2[0];
	    return prefix.length;
	  }));
	  return existingLines.map(function (_ref3) {
	    var prefix = _ref3[0],
	        line = _ref3[1];
	    return leftPad(padLen, prefix) + (line ? ' | ' + line : ' |');
	  }).join('\n');
	}

	function whitespace(len) {
	  return Array(len + 1).join(' ');
	}

	function leftPad(len, str) {
	  return whitespace(len - str.length) + str;
	}

	function _typeof$3(obj) { "@babel/helpers - typeof"; if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof$3 = function _typeof(obj) { return typeof obj; }; } else { _typeof$3 = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof$3(obj); }

	function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

	function _defineProperties$4(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

	function _createClass$4(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties$4(Constructor.prototype, protoProps); if (staticProps) _defineProperties$4(Constructor, staticProps); return Constructor; }

	function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); if (superClass) _setPrototypeOf(subClass, superClass); }

	function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }

	function _possibleConstructorReturn(self, call) { if (call && (_typeof$3(call) === "object" || typeof call === "function")) { return call; } return _assertThisInitialized(self); }

	function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

	function _wrapNativeSuper(Class) { var _cache = typeof Map === "function" ? new Map() : undefined; _wrapNativeSuper = function _wrapNativeSuper(Class) { if (Class === null || !_isNativeFunction(Class)) return Class; if (typeof Class !== "function") { throw new TypeError("Super expression must either be null or a function"); } if (typeof _cache !== "undefined") { if (_cache.has(Class)) return _cache.get(Class); _cache.set(Class, Wrapper); } function Wrapper() { return _construct(Class, arguments, _getPrototypeOf(this).constructor); } Wrapper.prototype = Object.create(Class.prototype, { constructor: { value: Wrapper, enumerable: false, writable: true, configurable: true } }); return _setPrototypeOf(Wrapper, Class); }; return _wrapNativeSuper(Class); }

	function _construct(Parent, args, Class) { if (_isNativeReflectConstruct()) { _construct = Reflect.construct; } else { _construct = function _construct(Parent, args, Class) { var a = [null]; a.push.apply(a, args); var Constructor = Function.bind.apply(Parent, a); var instance = new Constructor(); if (Class) _setPrototypeOf(instance, Class.prototype); return instance; }; } return _construct.apply(null, arguments); }

	function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Date.prototype.toString.call(Reflect.construct(Date, [], function () {})); return true; } catch (e) { return false; } }

	function _isNativeFunction(fn) { return Function.toString.call(fn).indexOf("[native code]") !== -1; }

	function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

	function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }
	/**
	 * A GraphQLError describes an Error found during the parse, validate, or
	 * execute phases of performing a GraphQL operation. In addition to a message
	 * and stack trace, it also includes information about the locations in a
	 * GraphQL document and/or execution result that correspond to the Error.
	 */

	var GraphQLError = /*#__PURE__*/function (_Error) {
	  _inherits(GraphQLError, _Error);

	  var _super = _createSuper(GraphQLError);

	  /**
	   * A message describing the Error for debugging purposes.
	   *
	   * Enumerable, and appears in the result of JSON.stringify().
	   *
	   * Note: should be treated as readonly, despite invariant usage.
	   */

	  /**
	   * An array of { line, column } locations within the source GraphQL document
	   * which correspond to this error.
	   *
	   * Errors during validation often contain multiple locations, for example to
	   * point out two things with the same name. Errors during execution include a
	   * single location, the field which produced the error.
	   *
	   * Enumerable, and appears in the result of JSON.stringify().
	   */

	  /**
	   * An array describing the JSON-path into the execution response which
	   * corresponds to this error. Only included for errors during execution.
	   *
	   * Enumerable, and appears in the result of JSON.stringify().
	   */

	  /**
	   * An array of GraphQL AST Nodes corresponding to this error.
	   */

	  /**
	   * The source GraphQL document for the first location of this error.
	   *
	   * Note that if this Error represents more than one node, the source may not
	   * represent nodes after the first node.
	   */

	  /**
	   * An array of character offsets within the source GraphQL document
	   * which correspond to this error.
	   */

	  /**
	   * The original error thrown from a field resolver during execution.
	   */

	  /**
	   * Extension fields to add to the formatted error.
	   */
	  function GraphQLError(message, nodes, source, positions, path, originalError, extensions) {
	    var _locations2, _source2, _positions2, _extensions2;

	    var _this;

	    _classCallCheck(this, GraphQLError);

	    _this = _super.call(this, message); // Compute list of blame nodes.

	    var _nodes = Array.isArray(nodes) ? nodes.length !== 0 ? nodes : undefined : nodes ? [nodes] : undefined; // Compute locations in the source for the given nodes/positions.


	    var _source = source;

	    if (!_source && _nodes) {
	      var _nodes$0$loc;

	      _source = (_nodes$0$loc = _nodes[0].loc) === null || _nodes$0$loc === void 0 ? void 0 : _nodes$0$loc.source;
	    }

	    var _positions = positions;

	    if (!_positions && _nodes) {
	      _positions = _nodes.reduce(function (list, node) {
	        if (node.loc) {
	          list.push(node.loc.start);
	        }

	        return list;
	      }, []);
	    }

	    if (_positions && _positions.length === 0) {
	      _positions = undefined;
	    }

	    var _locations;

	    if (positions && source) {
	      _locations = positions.map(function (pos) {
	        return getLocation(source, pos);
	      });
	    } else if (_nodes) {
	      _locations = _nodes.reduce(function (list, node) {
	        if (node.loc) {
	          list.push(getLocation(node.loc.source, node.loc.start));
	        }

	        return list;
	      }, []);
	    }

	    var _extensions = extensions;

	    if (_extensions == null && originalError != null) {
	      var originalExtensions = originalError.extensions;

	      if (isObjectLike(originalExtensions)) {
	        _extensions = originalExtensions;
	      }
	    }

	    Object.defineProperties(_assertThisInitialized(_this), {
	      name: {
	        value: 'GraphQLError'
	      },
	      message: {
	        value: message,
	        // By being enumerable, JSON.stringify will include `message` in the
	        // resulting output. This ensures that the simplest possible GraphQL
	        // service adheres to the spec.
	        enumerable: true,
	        writable: true
	      },
	      locations: {
	        // Coercing falsy values to undefined ensures they will not be included
	        // in JSON.stringify() when not provided.
	        value: (_locations2 = _locations) !== null && _locations2 !== void 0 ? _locations2 : undefined,
	        // By being enumerable, JSON.stringify will include `locations` in the
	        // resulting output. This ensures that the simplest possible GraphQL
	        // service adheres to the spec.
	        enumerable: _locations != null
	      },
	      path: {
	        // Coercing falsy values to undefined ensures they will not be included
	        // in JSON.stringify() when not provided.
	        value: path !== null && path !== void 0 ? path : undefined,
	        // By being enumerable, JSON.stringify will include `path` in the
	        // resulting output. This ensures that the simplest possible GraphQL
	        // service adheres to the spec.
	        enumerable: path != null
	      },
	      nodes: {
	        value: _nodes !== null && _nodes !== void 0 ? _nodes : undefined
	      },
	      source: {
	        value: (_source2 = _source) !== null && _source2 !== void 0 ? _source2 : undefined
	      },
	      positions: {
	        value: (_positions2 = _positions) !== null && _positions2 !== void 0 ? _positions2 : undefined
	      },
	      originalError: {
	        value: originalError
	      },
	      extensions: {
	        // Coercing falsy values to undefined ensures they will not be included
	        // in JSON.stringify() when not provided.
	        value: (_extensions2 = _extensions) !== null && _extensions2 !== void 0 ? _extensions2 : undefined,
	        // By being enumerable, JSON.stringify will include `path` in the
	        // resulting output. This ensures that the simplest possible GraphQL
	        // service adheres to the spec.
	        enumerable: _extensions != null
	      }
	    }); // Include (non-enumerable) stack trace.

	    if (originalError !== null && originalError !== void 0 && originalError.stack) {
	      Object.defineProperty(_assertThisInitialized(_this), 'stack', {
	        value: originalError.stack,
	        writable: true,
	        configurable: true
	      });
	      return _possibleConstructorReturn(_this);
	    } // istanbul ignore next (See: 'https://github.com/graphql/graphql-js/issues/2317')


	    if (Error.captureStackTrace) {
	      Error.captureStackTrace(_assertThisInitialized(_this), GraphQLError);
	    } else {
	      Object.defineProperty(_assertThisInitialized(_this), 'stack', {
	        value: Error().stack,
	        writable: true,
	        configurable: true
	      });
	    }

	    return _this;
	  }

	  _createClass$4(GraphQLError, [{
	    key: "toString",
	    value: function toString() {
	      return printError(this);
	    } // FIXME: workaround to not break chai comparisons, should be remove in v16
	    // $FlowFixMe[unsupported-syntax] Flow doesn't support computed properties yet

	  }, {
	    key: SYMBOL_TO_STRING_TAG,
	    get: function get() {
	      return 'Object';
	    }
	  }]);

	  return GraphQLError;
	}( /*#__PURE__*/_wrapNativeSuper(Error));
	/**
	 * Prints a GraphQLError to a string, representing useful location information
	 * about the error's position in the source.
	 */

	function printError(error) {
	  var output = error.message;

	  if (error.nodes) {
	    for (var _i2 = 0, _error$nodes2 = error.nodes; _i2 < _error$nodes2.length; _i2++) {
	      var node = _error$nodes2[_i2];

	      if (node.loc) {
	        output += '\n\n' + printLocation(node.loc);
	      }
	    }
	  } else if (error.source && error.locations) {
	    for (var _i4 = 0, _error$locations2 = error.locations; _i4 < _error$locations2.length; _i4++) {
	      var location = _error$locations2[_i4];
	      output += '\n\n' + printSourceLocation(error.source, location);
	    }
	  }

	  return output;
	}

	/**
	 * Produces a GraphQLError representing a syntax error, containing useful
	 * descriptive information about the syntax error's position in the source.
	 */

	function syntaxError(source, position, description) {
	  return new GraphQLError("Syntax Error: ".concat(description), undefined, source, [position]);
	}

	/**
	 * The set of allowed kind values for AST nodes.
	 */
	var Kind = Object.freeze({
	  // Name
	  NAME: 'Name',
	  // Document
	  DOCUMENT: 'Document',
	  OPERATION_DEFINITION: 'OperationDefinition',
	  VARIABLE_DEFINITION: 'VariableDefinition',
	  SELECTION_SET: 'SelectionSet',
	  FIELD: 'Field',
	  ARGUMENT: 'Argument',
	  // Fragments
	  FRAGMENT_SPREAD: 'FragmentSpread',
	  INLINE_FRAGMENT: 'InlineFragment',
	  FRAGMENT_DEFINITION: 'FragmentDefinition',
	  // Values
	  VARIABLE: 'Variable',
	  INT: 'IntValue',
	  FLOAT: 'FloatValue',
	  STRING: 'StringValue',
	  BOOLEAN: 'BooleanValue',
	  NULL: 'NullValue',
	  ENUM: 'EnumValue',
	  LIST: 'ListValue',
	  OBJECT: 'ObjectValue',
	  OBJECT_FIELD: 'ObjectField',
	  // Directives
	  DIRECTIVE: 'Directive',
	  // Types
	  NAMED_TYPE: 'NamedType',
	  LIST_TYPE: 'ListType',
	  NON_NULL_TYPE: 'NonNullType',
	  // Type System Definitions
	  SCHEMA_DEFINITION: 'SchemaDefinition',
	  OPERATION_TYPE_DEFINITION: 'OperationTypeDefinition',
	  // Type Definitions
	  SCALAR_TYPE_DEFINITION: 'ScalarTypeDefinition',
	  OBJECT_TYPE_DEFINITION: 'ObjectTypeDefinition',
	  FIELD_DEFINITION: 'FieldDefinition',
	  INPUT_VALUE_DEFINITION: 'InputValueDefinition',
	  INTERFACE_TYPE_DEFINITION: 'InterfaceTypeDefinition',
	  UNION_TYPE_DEFINITION: 'UnionTypeDefinition',
	  ENUM_TYPE_DEFINITION: 'EnumTypeDefinition',
	  ENUM_VALUE_DEFINITION: 'EnumValueDefinition',
	  INPUT_OBJECT_TYPE_DEFINITION: 'InputObjectTypeDefinition',
	  // Directive Definitions
	  DIRECTIVE_DEFINITION: 'DirectiveDefinition',
	  // Type System Extensions
	  SCHEMA_EXTENSION: 'SchemaExtension',
	  // Type Extensions
	  SCALAR_TYPE_EXTENSION: 'ScalarTypeExtension',
	  OBJECT_TYPE_EXTENSION: 'ObjectTypeExtension',
	  INTERFACE_TYPE_EXTENSION: 'InterfaceTypeExtension',
	  UNION_TYPE_EXTENSION: 'UnionTypeExtension',
	  ENUM_TYPE_EXTENSION: 'EnumTypeExtension',
	  INPUT_OBJECT_TYPE_EXTENSION: 'InputObjectTypeExtension'
	});
	/**
	 * The enum type representing the possible kind values of AST nodes.
	 */

	function invariant(condition, message) {
	  var booleanCondition = Boolean(condition); // istanbul ignore else (See transformation done in './resources/inlineInvariant.js')

	  if (!booleanCondition) {
	    throw new Error(message != null ? message : 'Unexpected invariant triggered.');
	  }
	}

	// istanbul ignore next (See: 'https://github.com/graphql/graphql-js/issues/2317')
	var nodejsCustomInspectSymbol = typeof Symbol === 'function' && typeof Symbol.for === 'function' ? Symbol.for('nodejs.util.inspect.custom') : undefined;
	var nodejsCustomInspectSymbol$1 = nodejsCustomInspectSymbol;

	/**
	 * The `defineInspect()` function defines `inspect()` prototype method as alias of `toJSON`
	 */

	function defineInspect(classObject) {
	  var fn = classObject.prototype.toJSON;
	  typeof fn === 'function' || invariant(0);
	  classObject.prototype.inspect = fn; // istanbul ignore else (See: 'https://github.com/graphql/graphql-js/issues/2317')

	  if (nodejsCustomInspectSymbol$1) {
	    classObject.prototype[nodejsCustomInspectSymbol$1] = fn;
	  }
	}

	/**
	 * Contains a range of UTF-8 character offsets and token references that
	 * identify the region of the source from which the AST derived.
	 */
	var Location = /*#__PURE__*/function () {
	  /**
	   * The character offset at which this Node begins.
	   */

	  /**
	   * The character offset at which this Node ends.
	   */

	  /**
	   * The Token at which this Node begins.
	   */

	  /**
	   * The Token at which this Node ends.
	   */

	  /**
	   * The Source document the AST represents.
	   */
	  function Location(startToken, endToken, source) {
	    this.start = startToken.start;
	    this.end = endToken.end;
	    this.startToken = startToken;
	    this.endToken = endToken;
	    this.source = source;
	  }

	  var _proto = Location.prototype;

	  _proto.toJSON = function toJSON() {
	    return {
	      start: this.start,
	      end: this.end
	    };
	  };

	  return Location;
	}(); // Print a simplified form when appearing in `inspect` and `util.inspect`.

	defineInspect(Location);
	/**
	 * Represents a range of characters represented by a lexical token
	 * within a Source.
	 */

	var Token = /*#__PURE__*/function () {
	  /**
	   * The kind of Token.
	   */

	  /**
	   * The character offset at which this Node begins.
	   */

	  /**
	   * The character offset at which this Node ends.
	   */

	  /**
	   * The 1-indexed line number on which this Token appears.
	   */

	  /**
	   * The 1-indexed column number at which this Token begins.
	   */

	  /**
	   * For non-punctuation tokens, represents the interpreted value of the token.
	   */

	  /**
	   * Tokens exist as nodes in a double-linked-list amongst all tokens
	   * including ignored tokens. <SOF> is always the first node and <EOF>
	   * the last.
	   */
	  function Token(kind, start, end, line, column, prev, value) {
	    this.kind = kind;
	    this.start = start;
	    this.end = end;
	    this.line = line;
	    this.column = column;
	    this.value = value;
	    this.prev = prev;
	    this.next = null;
	  }

	  var _proto2 = Token.prototype;

	  _proto2.toJSON = function toJSON() {
	    return {
	      kind: this.kind,
	      value: this.value,
	      line: this.line,
	      column: this.column
	    };
	  };

	  return Token;
	}(); // Print a simplified form when appearing in `inspect` and `util.inspect`.

	defineInspect(Token);
	/**
	 * @internal
	 */

	function isNode(maybeNode) {
	  return maybeNode != null && typeof maybeNode.kind === 'string';
	}
	/**
	 * The list of all possible AST node types.
	 */

	/**
	 * An exported enum describing the different kinds of tokens that the
	 * lexer emits.
	 */
	var TokenKind = Object.freeze({
	  SOF: '<SOF>',
	  EOF: '<EOF>',
	  BANG: '!',
	  DOLLAR: '$',
	  AMP: '&',
	  PAREN_L: '(',
	  PAREN_R: ')',
	  SPREAD: '...',
	  COLON: ':',
	  EQUALS: '=',
	  AT: '@',
	  BRACKET_L: '[',
	  BRACKET_R: ']',
	  BRACE_L: '{',
	  PIPE: '|',
	  BRACE_R: '}',
	  NAME: 'Name',
	  INT: 'Int',
	  FLOAT: 'Float',
	  STRING: 'String',
	  BLOCK_STRING: 'BlockString',
	  COMMENT: 'Comment'
	});
	/**
	 * The enum type representing the token kinds values.
	 */

	function _typeof$2(obj) { "@babel/helpers - typeof"; if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof$2 = function _typeof(obj) { return typeof obj; }; } else { _typeof$2 = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof$2(obj); }
	var MAX_ARRAY_LENGTH = 10;
	var MAX_RECURSIVE_DEPTH = 2;
	/**
	 * Used to print values in error messages.
	 */

	function inspect$2(value) {
	  return formatValue$1(value, []);
	}

	function formatValue$1(value, seenValues) {
	  switch (_typeof$2(value)) {
	    case 'string':
	      return JSON.stringify(value);

	    case 'function':
	      return value.name ? "[function ".concat(value.name, "]") : '[function]';

	    case 'object':
	      if (value === null) {
	        return 'null';
	      }

	      return formatObjectValue(value, seenValues);

	    default:
	      return String(value);
	  }
	}

	function formatObjectValue(value, previouslySeenValues) {
	  if (previouslySeenValues.indexOf(value) !== -1) {
	    return '[Circular]';
	  }

	  var seenValues = [].concat(previouslySeenValues, [value]);
	  var customInspectFn = getCustomFn(value);

	  if (customInspectFn !== undefined) {
	    var customValue = customInspectFn.call(value); // check for infinite recursion

	    if (customValue !== value) {
	      return typeof customValue === 'string' ? customValue : formatValue$1(customValue, seenValues);
	    }
	  } else if (Array.isArray(value)) {
	    return formatArray$1(value, seenValues);
	  }

	  return formatObject(value, seenValues);
	}

	function formatObject(object, seenValues) {
	  var keys = Object.keys(object);

	  if (keys.length === 0) {
	    return '{}';
	  }

	  if (seenValues.length > MAX_RECURSIVE_DEPTH) {
	    return '[' + getObjectTag(object) + ']';
	  }

	  var properties = keys.map(function (key) {
	    var value = formatValue$1(object[key], seenValues);
	    return key + ': ' + value;
	  });
	  return '{ ' + properties.join(', ') + ' }';
	}

	function formatArray$1(array, seenValues) {
	  if (array.length === 0) {
	    return '[]';
	  }

	  if (seenValues.length > MAX_RECURSIVE_DEPTH) {
	    return '[Array]';
	  }

	  var len = Math.min(MAX_ARRAY_LENGTH, array.length);
	  var remaining = array.length - len;
	  var items = [];

	  for (var i = 0; i < len; ++i) {
	    items.push(formatValue$1(array[i], seenValues));
	  }

	  if (remaining === 1) {
	    items.push('... 1 more item');
	  } else if (remaining > 1) {
	    items.push("... ".concat(remaining, " more items"));
	  }

	  return '[' + items.join(', ') + ']';
	}

	function getCustomFn(object) {
	  var customInspectFn = object[String(nodejsCustomInspectSymbol$1)];

	  if (typeof customInspectFn === 'function') {
	    return customInspectFn;
	  }

	  if (typeof object.inspect === 'function') {
	    return object.inspect;
	  }
	}

	function getObjectTag(object) {
	  var tag = Object.prototype.toString.call(object).replace(/^\[object /, '').replace(/]$/, '');

	  if (tag === 'Object' && typeof object.constructor === 'function') {
	    var name = object.constructor.name;

	    if (typeof name === 'string' && name !== '') {
	      return name;
	    }
	  }

	  return tag;
	}

	function devAssert(condition, message) {
	  var booleanCondition = Boolean(condition); // istanbul ignore else (See transformation done in './resources/inlineInvariant.js')

	  if (!booleanCondition) {
	    throw new Error(message);
	  }
	}

	function _typeof$1(obj) { "@babel/helpers - typeof"; if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof$1 = function _typeof(obj) { return typeof obj; }; } else { _typeof$1 = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof$1(obj); }
	/**
	 * A replacement for instanceof which includes an error warning when multi-realm
	 * constructors are detected.
	 */

	// See: https://expressjs.com/en/advanced/best-practice-performance.html#set-node_env-to-production
	// See: https://webpack.js.org/guides/production/
	var instanceOf = process.env.NODE_ENV === 'production' ? // istanbul ignore next (See: 'https://github.com/graphql/graphql-js/issues/2317')
	// eslint-disable-next-line no-shadow
	function instanceOf(value, constructor) {
	  return value instanceof constructor;
	} : // eslint-disable-next-line no-shadow
	function instanceOf(value, constructor) {
	  if (value instanceof constructor) {
	    return true;
	  }

	  if (_typeof$1(value) === 'object' && value !== null) {
	    var _value$constructor;

	    var className = constructor.prototype[Symbol.toStringTag];
	    var valueClassName = // We still need to support constructor's name to detect conflicts with older versions of this library.
	    Symbol.toStringTag in value ? value[Symbol.toStringTag] : (_value$constructor = value.constructor) === null || _value$constructor === void 0 ? void 0 : _value$constructor.name;

	    if (className === valueClassName) {
	      var stringifiedValue = inspect$2(value);
	      throw new Error("Cannot use ".concat(className, " \"").concat(stringifiedValue, "\" from another module or realm.\n\nEnsure that there is only one instance of \"graphql\" in the node_modules\ndirectory. If different versions of \"graphql\" are the dependencies of other\nrelied on modules, use \"resolutions\" to ensure only one version is installed.\n\nhttps://yarnpkg.com/en/docs/selective-version-resolutions\n\nDuplicate \"graphql\" modules cannot be used at the same time since different\nversions may have different capabilities and behavior. The data from one\nversion used in the function from another could produce confusing and\nspurious results."));
	    }
	  }

	  return false;
	};

	function _defineProperties$3(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

	function _createClass$3(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties$3(Constructor.prototype, protoProps); if (staticProps) _defineProperties$3(Constructor, staticProps); return Constructor; }

	/**
	 * A representation of source input to GraphQL. The `name` and `locationOffset` parameters are
	 * optional, but they are useful for clients who store GraphQL documents in source files.
	 * For example, if the GraphQL input starts at line 40 in a file named `Foo.graphql`, it might
	 * be useful for `name` to be `"Foo.graphql"` and location to be `{ line: 40, column: 1 }`.
	 * The `line` and `column` properties in `locationOffset` are 1-indexed.
	 */
	var Source = /*#__PURE__*/function () {
	  function Source(body) {
	    var name = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : 'GraphQL request';
	    var locationOffset = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : {
	      line: 1,
	      column: 1
	    };
	    typeof body === 'string' || devAssert(0, "Body must be a string. Received: ".concat(inspect$2(body), "."));
	    this.body = body;
	    this.name = name;
	    this.locationOffset = locationOffset;
	    this.locationOffset.line > 0 || devAssert(0, 'line in locationOffset is 1-indexed and must be positive.');
	    this.locationOffset.column > 0 || devAssert(0, 'column in locationOffset is 1-indexed and must be positive.');
	  } // $FlowFixMe[unsupported-syntax] Flow doesn't support computed properties yet


	  _createClass$3(Source, [{
	    key: SYMBOL_TO_STRING_TAG,
	    get: function get() {
	      return 'Source';
	    }
	  }]);

	  return Source;
	}();
	/**
	 * Test if the given value is a Source object.
	 *
	 * @internal
	 */

	// eslint-disable-next-line no-redeclare
	function isSource(source) {
	  return instanceOf(source, Source);
	}

	/**
	 * The set of allowed directive location values.
	 */
	var DirectiveLocation = Object.freeze({
	  // Request Definitions
	  QUERY: 'QUERY',
	  MUTATION: 'MUTATION',
	  SUBSCRIPTION: 'SUBSCRIPTION',
	  FIELD: 'FIELD',
	  FRAGMENT_DEFINITION: 'FRAGMENT_DEFINITION',
	  FRAGMENT_SPREAD: 'FRAGMENT_SPREAD',
	  INLINE_FRAGMENT: 'INLINE_FRAGMENT',
	  VARIABLE_DEFINITION: 'VARIABLE_DEFINITION',
	  // Type System Definitions
	  SCHEMA: 'SCHEMA',
	  SCALAR: 'SCALAR',
	  OBJECT: 'OBJECT',
	  FIELD_DEFINITION: 'FIELD_DEFINITION',
	  ARGUMENT_DEFINITION: 'ARGUMENT_DEFINITION',
	  INTERFACE: 'INTERFACE',
	  UNION: 'UNION',
	  ENUM: 'ENUM',
	  ENUM_VALUE: 'ENUM_VALUE',
	  INPUT_OBJECT: 'INPUT_OBJECT',
	  INPUT_FIELD_DEFINITION: 'INPUT_FIELD_DEFINITION'
	});
	/**
	 * The enum type representing the directive location values.
	 */

	/**
	 * Produces the value of a block string from its parsed raw value, similar to
	 * CoffeeScript's block string, Python's docstring trim or Ruby's strip_heredoc.
	 *
	 * This implements the GraphQL spec's BlockStringValue() static algorithm.
	 *
	 * @internal
	 */
	function dedentBlockStringValue(rawString) {
	  // Expand a block string's raw value into independent lines.
	  var lines = rawString.split(/\r\n|[\n\r]/g); // Remove common indentation from all lines but first.

	  var commonIndent = getBlockStringIndentation(rawString);

	  if (commonIndent !== 0) {
	    for (var i = 1; i < lines.length; i++) {
	      lines[i] = lines[i].slice(commonIndent);
	    }
	  } // Remove leading and trailing blank lines.


	  var startLine = 0;

	  while (startLine < lines.length && isBlank(lines[startLine])) {
	    ++startLine;
	  }

	  var endLine = lines.length;

	  while (endLine > startLine && isBlank(lines[endLine - 1])) {
	    --endLine;
	  } // Return a string of the lines joined with U+000A.


	  return lines.slice(startLine, endLine).join('\n');
	}

	function isBlank(str) {
	  for (var i = 0; i < str.length; ++i) {
	    if (str[i] !== ' ' && str[i] !== '\t') {
	      return false;
	    }
	  }

	  return true;
	}
	/**
	 * @internal
	 */


	function getBlockStringIndentation(value) {
	  var _commonIndent;

	  var isFirstLine = true;
	  var isEmptyLine = true;
	  var indent = 0;
	  var commonIndent = null;

	  for (var i = 0; i < value.length; ++i) {
	    switch (value.charCodeAt(i)) {
	      case 13:
	        //  \r
	        if (value.charCodeAt(i + 1) === 10) {
	          ++i; // skip \r\n as one symbol
	        }

	      // falls through

	      case 10:
	        //  \n
	        isFirstLine = false;
	        isEmptyLine = true;
	        indent = 0;
	        break;

	      case 9: //   \t

	      case 32:
	        //  <space>
	        ++indent;
	        break;

	      default:
	        if (isEmptyLine && !isFirstLine && (commonIndent === null || indent < commonIndent)) {
	          commonIndent = indent;
	        }

	        isEmptyLine = false;
	    }
	  }

	  return (_commonIndent = commonIndent) !== null && _commonIndent !== void 0 ? _commonIndent : 0;
	}
	/**
	 * Print a block string in the indented block form by adding a leading and
	 * trailing blank line. However, if a block string starts with whitespace and is
	 * a single-line, adding a leading blank line would strip that whitespace.
	 *
	 * @internal
	 */

	function printBlockString(value) {
	  var indentation = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : '';
	  var preferMultipleLines = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : false;
	  var isSingleLine = value.indexOf('\n') === -1;
	  var hasLeadingSpace = value[0] === ' ' || value[0] === '\t';
	  var hasTrailingQuote = value[value.length - 1] === '"';
	  var hasTrailingSlash = value[value.length - 1] === '\\';
	  var printAsMultipleLines = !isSingleLine || hasTrailingQuote || hasTrailingSlash || preferMultipleLines;
	  var result = ''; // Format a multi-line block quote to account for leading space.

	  if (printAsMultipleLines && !(isSingleLine && hasLeadingSpace)) {
	    result += '\n' + indentation;
	  }

	  result += indentation ? value.replace(/\n/g, '\n' + indentation) : value;

	  if (printAsMultipleLines) {
	    result += '\n';
	  }

	  return '"""' + result.replace(/"""/g, '\\"""') + '"""';
	}

	/**
	 * Given a Source object, creates a Lexer for that source.
	 * A Lexer is a stateful stream generator in that every time
	 * it is advanced, it returns the next token in the Source. Assuming the
	 * source lexes, the final Token emitted by the lexer will be of kind
	 * EOF, after which the lexer will repeatedly return the same EOF token
	 * whenever called.
	 */

	var Lexer = /*#__PURE__*/function () {
	  /**
	   * The previously focused non-ignored token.
	   */

	  /**
	   * The currently focused non-ignored token.
	   */

	  /**
	   * The (1-indexed) line containing the current token.
	   */

	  /**
	   * The character offset at which the current line begins.
	   */
	  function Lexer(source) {
	    var startOfFileToken = new Token(TokenKind.SOF, 0, 0, 0, 0, null);
	    this.source = source;
	    this.lastToken = startOfFileToken;
	    this.token = startOfFileToken;
	    this.line = 1;
	    this.lineStart = 0;
	  }
	  /**
	   * Advances the token stream to the next non-ignored token.
	   */


	  var _proto = Lexer.prototype;

	  _proto.advance = function advance() {
	    this.lastToken = this.token;
	    var token = this.token = this.lookahead();
	    return token;
	  }
	  /**
	   * Looks ahead and returns the next non-ignored token, but does not change
	   * the state of Lexer.
	   */
	  ;

	  _proto.lookahead = function lookahead() {
	    var token = this.token;

	    if (token.kind !== TokenKind.EOF) {
	      do {
	        var _token$next;

	        // Note: next is only mutable during parsing, so we cast to allow this.
	        token = (_token$next = token.next) !== null && _token$next !== void 0 ? _token$next : token.next = readToken(this, token);
	      } while (token.kind === TokenKind.COMMENT);
	    }

	    return token;
	  };

	  return Lexer;
	}();
	/**
	 * @internal
	 */

	function isPunctuatorTokenKind(kind) {
	  return kind === TokenKind.BANG || kind === TokenKind.DOLLAR || kind === TokenKind.AMP || kind === TokenKind.PAREN_L || kind === TokenKind.PAREN_R || kind === TokenKind.SPREAD || kind === TokenKind.COLON || kind === TokenKind.EQUALS || kind === TokenKind.AT || kind === TokenKind.BRACKET_L || kind === TokenKind.BRACKET_R || kind === TokenKind.BRACE_L || kind === TokenKind.PIPE || kind === TokenKind.BRACE_R;
	}

	function printCharCode(code) {
	  return (// NaN/undefined represents access beyond the end of the file.
	    isNaN(code) ? TokenKind.EOF : // Trust JSON for ASCII.
	    code < 0x007f ? JSON.stringify(String.fromCharCode(code)) : // Otherwise print the escaped form.
	    "\"\\u".concat(('00' + code.toString(16).toUpperCase()).slice(-4), "\"")
	  );
	}
	/**
	 * Gets the next token from the source starting at the given position.
	 *
	 * This skips over whitespace until it finds the next lexable token, then lexes
	 * punctuators immediately or calls the appropriate helper function for more
	 * complicated tokens.
	 */


	function readToken(lexer, prev) {
	  var source = lexer.source;
	  var body = source.body;
	  var bodyLength = body.length;
	  var pos = prev.end;

	  while (pos < bodyLength) {
	    var code = body.charCodeAt(pos);
	    var _line = lexer.line;

	    var _col = 1 + pos - lexer.lineStart; // SourceCharacter


	    switch (code) {
	      case 0xfeff: // <BOM>

	      case 9: //   \t

	      case 32: //  <space>

	      case 44:
	        //  ,
	        ++pos;
	        continue;

	      case 10:
	        //  \n
	        ++pos;
	        ++lexer.line;
	        lexer.lineStart = pos;
	        continue;

	      case 13:
	        //  \r
	        if (body.charCodeAt(pos + 1) === 10) {
	          pos += 2;
	        } else {
	          ++pos;
	        }

	        ++lexer.line;
	        lexer.lineStart = pos;
	        continue;

	      case 33:
	        //  !
	        return new Token(TokenKind.BANG, pos, pos + 1, _line, _col, prev);

	      case 35:
	        //  #
	        return readComment(source, pos, _line, _col, prev);

	      case 36:
	        //  $
	        return new Token(TokenKind.DOLLAR, pos, pos + 1, _line, _col, prev);

	      case 38:
	        //  &
	        return new Token(TokenKind.AMP, pos, pos + 1, _line, _col, prev);

	      case 40:
	        //  (
	        return new Token(TokenKind.PAREN_L, pos, pos + 1, _line, _col, prev);

	      case 41:
	        //  )
	        return new Token(TokenKind.PAREN_R, pos, pos + 1, _line, _col, prev);

	      case 46:
	        //  .
	        if (body.charCodeAt(pos + 1) === 46 && body.charCodeAt(pos + 2) === 46) {
	          return new Token(TokenKind.SPREAD, pos, pos + 3, _line, _col, prev);
	        }

	        break;

	      case 58:
	        //  :
	        return new Token(TokenKind.COLON, pos, pos + 1, _line, _col, prev);

	      case 61:
	        //  =
	        return new Token(TokenKind.EQUALS, pos, pos + 1, _line, _col, prev);

	      case 64:
	        //  @
	        return new Token(TokenKind.AT, pos, pos + 1, _line, _col, prev);

	      case 91:
	        //  [
	        return new Token(TokenKind.BRACKET_L, pos, pos + 1, _line, _col, prev);

	      case 93:
	        //  ]
	        return new Token(TokenKind.BRACKET_R, pos, pos + 1, _line, _col, prev);

	      case 123:
	        // {
	        return new Token(TokenKind.BRACE_L, pos, pos + 1, _line, _col, prev);

	      case 124:
	        // |
	        return new Token(TokenKind.PIPE, pos, pos + 1, _line, _col, prev);

	      case 125:
	        // }
	        return new Token(TokenKind.BRACE_R, pos, pos + 1, _line, _col, prev);

	      case 34:
	        //  "
	        if (body.charCodeAt(pos + 1) === 34 && body.charCodeAt(pos + 2) === 34) {
	          return readBlockString(source, pos, _line, _col, prev, lexer);
	        }

	        return readString(source, pos, _line, _col, prev);

	      case 45: //  -

	      case 48: //  0

	      case 49: //  1

	      case 50: //  2

	      case 51: //  3

	      case 52: //  4

	      case 53: //  5

	      case 54: //  6

	      case 55: //  7

	      case 56: //  8

	      case 57:
	        //  9
	        return readNumber(source, pos, code, _line, _col, prev);

	      case 65: //  A

	      case 66: //  B

	      case 67: //  C

	      case 68: //  D

	      case 69: //  E

	      case 70: //  F

	      case 71: //  G

	      case 72: //  H

	      case 73: //  I

	      case 74: //  J

	      case 75: //  K

	      case 76: //  L

	      case 77: //  M

	      case 78: //  N

	      case 79: //  O

	      case 80: //  P

	      case 81: //  Q

	      case 82: //  R

	      case 83: //  S

	      case 84: //  T

	      case 85: //  U

	      case 86: //  V

	      case 87: //  W

	      case 88: //  X

	      case 89: //  Y

	      case 90: //  Z

	      case 95: //  _

	      case 97: //  a

	      case 98: //  b

	      case 99: //  c

	      case 100: // d

	      case 101: // e

	      case 102: // f

	      case 103: // g

	      case 104: // h

	      case 105: // i

	      case 106: // j

	      case 107: // k

	      case 108: // l

	      case 109: // m

	      case 110: // n

	      case 111: // o

	      case 112: // p

	      case 113: // q

	      case 114: // r

	      case 115: // s

	      case 116: // t

	      case 117: // u

	      case 118: // v

	      case 119: // w

	      case 120: // x

	      case 121: // y

	      case 122:
	        // z
	        return readName(source, pos, _line, _col, prev);
	    }

	    throw syntaxError(source, pos, unexpectedCharacterMessage(code));
	  }

	  var line = lexer.line;
	  var col = 1 + pos - lexer.lineStart;
	  return new Token(TokenKind.EOF, bodyLength, bodyLength, line, col, prev);
	}
	/**
	 * Report a message that an unexpected character was encountered.
	 */


	function unexpectedCharacterMessage(code) {
	  if (code < 0x0020 && code !== 0x0009 && code !== 0x000a && code !== 0x000d) {
	    return "Cannot contain the invalid character ".concat(printCharCode(code), ".");
	  }

	  if (code === 39) {
	    // '
	    return 'Unexpected single quote character (\'), did you mean to use a double quote (")?';
	  }

	  return "Cannot parse the unexpected character ".concat(printCharCode(code), ".");
	}
	/**
	 * Reads a comment token from the source file.
	 *
	 * #[\u0009\u0020-\uFFFF]*
	 */


	function readComment(source, start, line, col, prev) {
	  var body = source.body;
	  var code;
	  var position = start;

	  do {
	    code = body.charCodeAt(++position);
	  } while (!isNaN(code) && ( // SourceCharacter but not LineTerminator
	  code > 0x001f || code === 0x0009));

	  return new Token(TokenKind.COMMENT, start, position, line, col, prev, body.slice(start + 1, position));
	}
	/**
	 * Reads a number token from the source file, either a float
	 * or an int depending on whether a decimal point appears.
	 *
	 * Int:   -?(0|[1-9][0-9]*)
	 * Float: -?(0|[1-9][0-9]*)(\.[0-9]+)?((E|e)(+|-)?[0-9]+)?
	 */


	function readNumber(source, start, firstCode, line, col, prev) {
	  var body = source.body;
	  var code = firstCode;
	  var position = start;
	  var isFloat = false;

	  if (code === 45) {
	    // -
	    code = body.charCodeAt(++position);
	  }

	  if (code === 48) {
	    // 0
	    code = body.charCodeAt(++position);

	    if (code >= 48 && code <= 57) {
	      throw syntaxError(source, position, "Invalid number, unexpected digit after 0: ".concat(printCharCode(code), "."));
	    }
	  } else {
	    position = readDigits(source, position, code);
	    code = body.charCodeAt(position);
	  }

	  if (code === 46) {
	    // .
	    isFloat = true;
	    code = body.charCodeAt(++position);
	    position = readDigits(source, position, code);
	    code = body.charCodeAt(position);
	  }

	  if (code === 69 || code === 101) {
	    // E e
	    isFloat = true;
	    code = body.charCodeAt(++position);

	    if (code === 43 || code === 45) {
	      // + -
	      code = body.charCodeAt(++position);
	    }

	    position = readDigits(source, position, code);
	    code = body.charCodeAt(position);
	  } // Numbers cannot be followed by . or NameStart


	  if (code === 46 || isNameStart(code)) {
	    throw syntaxError(source, position, "Invalid number, expected digit but got: ".concat(printCharCode(code), "."));
	  }

	  return new Token(isFloat ? TokenKind.FLOAT : TokenKind.INT, start, position, line, col, prev, body.slice(start, position));
	}
	/**
	 * Returns the new position in the source after reading digits.
	 */


	function readDigits(source, start, firstCode) {
	  var body = source.body;
	  var position = start;
	  var code = firstCode;

	  if (code >= 48 && code <= 57) {
	    // 0 - 9
	    do {
	      code = body.charCodeAt(++position);
	    } while (code >= 48 && code <= 57); // 0 - 9


	    return position;
	  }

	  throw syntaxError(source, position, "Invalid number, expected digit but got: ".concat(printCharCode(code), "."));
	}
	/**
	 * Reads a string token from the source file.
	 *
	 * "([^"\\\u000A\u000D]|(\\(u[0-9a-fA-F]{4}|["\\/bfnrt])))*"
	 */


	function readString(source, start, line, col, prev) {
	  var body = source.body;
	  var position = start + 1;
	  var chunkStart = position;
	  var code = 0;
	  var value = '';

	  while (position < body.length && !isNaN(code = body.charCodeAt(position)) && // not LineTerminator
	  code !== 0x000a && code !== 0x000d) {
	    // Closing Quote (")
	    if (code === 34) {
	      value += body.slice(chunkStart, position);
	      return new Token(TokenKind.STRING, start, position + 1, line, col, prev, value);
	    } // SourceCharacter


	    if (code < 0x0020 && code !== 0x0009) {
	      throw syntaxError(source, position, "Invalid character within String: ".concat(printCharCode(code), "."));
	    }

	    ++position;

	    if (code === 92) {
	      // \
	      value += body.slice(chunkStart, position - 1);
	      code = body.charCodeAt(position);

	      switch (code) {
	        case 34:
	          value += '"';
	          break;

	        case 47:
	          value += '/';
	          break;

	        case 92:
	          value += '\\';
	          break;

	        case 98:
	          value += '\b';
	          break;

	        case 102:
	          value += '\f';
	          break;

	        case 110:
	          value += '\n';
	          break;

	        case 114:
	          value += '\r';
	          break;

	        case 116:
	          value += '\t';
	          break;

	        case 117:
	          {
	            // uXXXX
	            var charCode = uniCharCode(body.charCodeAt(position + 1), body.charCodeAt(position + 2), body.charCodeAt(position + 3), body.charCodeAt(position + 4));

	            if (charCode < 0) {
	              var invalidSequence = body.slice(position + 1, position + 5);
	              throw syntaxError(source, position, "Invalid character escape sequence: \\u".concat(invalidSequence, "."));
	            }

	            value += String.fromCharCode(charCode);
	            position += 4;
	            break;
	          }

	        default:
	          throw syntaxError(source, position, "Invalid character escape sequence: \\".concat(String.fromCharCode(code), "."));
	      }

	      ++position;
	      chunkStart = position;
	    }
	  }

	  throw syntaxError(source, position, 'Unterminated string.');
	}
	/**
	 * Reads a block string token from the source file.
	 *
	 * """("?"?(\\"""|\\(?!=""")|[^"\\]))*"""
	 */


	function readBlockString(source, start, line, col, prev, lexer) {
	  var body = source.body;
	  var position = start + 3;
	  var chunkStart = position;
	  var code = 0;
	  var rawValue = '';

	  while (position < body.length && !isNaN(code = body.charCodeAt(position))) {
	    // Closing Triple-Quote (""")
	    if (code === 34 && body.charCodeAt(position + 1) === 34 && body.charCodeAt(position + 2) === 34) {
	      rawValue += body.slice(chunkStart, position);
	      return new Token(TokenKind.BLOCK_STRING, start, position + 3, line, col, prev, dedentBlockStringValue(rawValue));
	    } // SourceCharacter


	    if (code < 0x0020 && code !== 0x0009 && code !== 0x000a && code !== 0x000d) {
	      throw syntaxError(source, position, "Invalid character within String: ".concat(printCharCode(code), "."));
	    }

	    if (code === 10) {
	      // new line
	      ++position;
	      ++lexer.line;
	      lexer.lineStart = position;
	    } else if (code === 13) {
	      // carriage return
	      if (body.charCodeAt(position + 1) === 10) {
	        position += 2;
	      } else {
	        ++position;
	      }

	      ++lexer.line;
	      lexer.lineStart = position;
	    } else if ( // Escape Triple-Quote (\""")
	    code === 92 && body.charCodeAt(position + 1) === 34 && body.charCodeAt(position + 2) === 34 && body.charCodeAt(position + 3) === 34) {
	      rawValue += body.slice(chunkStart, position) + '"""';
	      position += 4;
	      chunkStart = position;
	    } else {
	      ++position;
	    }
	  }

	  throw syntaxError(source, position, 'Unterminated string.');
	}
	/**
	 * Converts four hexadecimal chars to the integer that the
	 * string represents. For example, uniCharCode('0','0','0','f')
	 * will return 15, and uniCharCode('0','0','f','f') returns 255.
	 *
	 * Returns a negative number on error, if a char was invalid.
	 *
	 * This is implemented by noting that char2hex() returns -1 on error,
	 * which means the result of ORing the char2hex() will also be negative.
	 */


	function uniCharCode(a, b, c, d) {
	  return char2hex(a) << 12 | char2hex(b) << 8 | char2hex(c) << 4 | char2hex(d);
	}
	/**
	 * Converts a hex character to its integer value.
	 * '0' becomes 0, '9' becomes 9
	 * 'A' becomes 10, 'F' becomes 15
	 * 'a' becomes 10, 'f' becomes 15
	 *
	 * Returns -1 on error.
	 */


	function char2hex(a) {
	  return a >= 48 && a <= 57 ? a - 48 // 0-9
	  : a >= 65 && a <= 70 ? a - 55 // A-F
	  : a >= 97 && a <= 102 ? a - 87 // a-f
	  : -1;
	}
	/**
	 * Reads an alphanumeric + underscore name from the source.
	 *
	 * [_A-Za-z][_0-9A-Za-z]*
	 */


	function readName(source, start, line, col, prev) {
	  var body = source.body;
	  var bodyLength = body.length;
	  var position = start + 1;
	  var code = 0;

	  while (position !== bodyLength && !isNaN(code = body.charCodeAt(position)) && (code === 95 || // _
	  code >= 48 && code <= 57 || // 0-9
	  code >= 65 && code <= 90 || // A-Z
	  code >= 97 && code <= 122) // a-z
	  ) {
	    ++position;
	  }

	  return new Token(TokenKind.NAME, start, position, line, col, prev, body.slice(start, position));
	} // _ A-Z a-z


	function isNameStart(code) {
	  return code === 95 || code >= 65 && code <= 90 || code >= 97 && code <= 122;
	}

	/**
	 * Configuration options to control parser behavior
	 */

	/**
	 * Given a GraphQL source, parses it into a Document.
	 * Throws GraphQLError if a syntax error is encountered.
	 */
	function parse(source, options) {
	  var parser = new Parser(source, options);
	  return parser.parseDocument();
	}
	/**
	 * Given a string containing a GraphQL value (ex. `[42]`), parse the AST for
	 * that value.
	 * Throws GraphQLError if a syntax error is encountered.
	 *
	 * This is useful within tools that operate upon GraphQL Values directly and
	 * in isolation of complete GraphQL documents.
	 *
	 * Consider providing the results to the utility function: valueFromAST().
	 */

	function parseValue(source, options) {
	  var parser = new Parser(source, options);
	  parser.expectToken(TokenKind.SOF);
	  var value = parser.parseValueLiteral(false);
	  parser.expectToken(TokenKind.EOF);
	  return value;
	}
	/**
	 * Given a string containing a GraphQL Type (ex. `[Int!]`), parse the AST for
	 * that type.
	 * Throws GraphQLError if a syntax error is encountered.
	 *
	 * This is useful within tools that operate upon GraphQL Types directly and
	 * in isolation of complete GraphQL documents.
	 *
	 * Consider providing the results to the utility function: typeFromAST().
	 */

	function parseType(source, options) {
	  var parser = new Parser(source, options);
	  parser.expectToken(TokenKind.SOF);
	  var type = parser.parseTypeReference();
	  parser.expectToken(TokenKind.EOF);
	  return type;
	}
	/**
	 * This class is exported only to assist people in implementing their own parsers
	 * without duplicating too much code and should be used only as last resort for cases
	 * such as experimental syntax or if certain features could not be contributed upstream.
	 *
	 * It is still part of the internal API and is versioned, so any changes to it are never
	 * considered breaking changes. If you still need to support multiple versions of the
	 * library, please use the `versionInfo` variable for version detection.
	 *
	 * @internal
	 */

	var Parser = /*#__PURE__*/function () {
	  function Parser(source, options) {
	    var sourceObj = isSource(source) ? source : new Source(source);
	    this._lexer = new Lexer(sourceObj);
	    this._options = options;
	  }
	  /**
	   * Converts a name lex token into a name parse node.
	   */


	  var _proto = Parser.prototype;

	  _proto.parseName = function parseName() {
	    var token = this.expectToken(TokenKind.NAME);
	    return {
	      kind: Kind.NAME,
	      value: token.value,
	      loc: this.loc(token)
	    };
	  } // Implements the parsing rules in the Document section.

	  /**
	   * Document : Definition+
	   */
	  ;

	  _proto.parseDocument = function parseDocument() {
	    var start = this._lexer.token;
	    return {
	      kind: Kind.DOCUMENT,
	      definitions: this.many(TokenKind.SOF, this.parseDefinition, TokenKind.EOF),
	      loc: this.loc(start)
	    };
	  }
	  /**
	   * Definition :
	   *   - ExecutableDefinition
	   *   - TypeSystemDefinition
	   *   - TypeSystemExtension
	   *
	   * ExecutableDefinition :
	   *   - OperationDefinition
	   *   - FragmentDefinition
	   */
	  ;

	  _proto.parseDefinition = function parseDefinition() {
	    if (this.peek(TokenKind.NAME)) {
	      switch (this._lexer.token.value) {
	        case 'query':
	        case 'mutation':
	        case 'subscription':
	          return this.parseOperationDefinition();

	        case 'fragment':
	          return this.parseFragmentDefinition();

	        case 'schema':
	        case 'scalar':
	        case 'type':
	        case 'interface':
	        case 'union':
	        case 'enum':
	        case 'input':
	        case 'directive':
	          return this.parseTypeSystemDefinition();

	        case 'extend':
	          return this.parseTypeSystemExtension();
	      }
	    } else if (this.peek(TokenKind.BRACE_L)) {
	      return this.parseOperationDefinition();
	    } else if (this.peekDescription()) {
	      return this.parseTypeSystemDefinition();
	    }

	    throw this.unexpected();
	  } // Implements the parsing rules in the Operations section.

	  /**
	   * OperationDefinition :
	   *  - SelectionSet
	   *  - OperationType Name? VariableDefinitions? Directives? SelectionSet
	   */
	  ;

	  _proto.parseOperationDefinition = function parseOperationDefinition() {
	    var start = this._lexer.token;

	    if (this.peek(TokenKind.BRACE_L)) {
	      return {
	        kind: Kind.OPERATION_DEFINITION,
	        operation: 'query',
	        name: undefined,
	        variableDefinitions: [],
	        directives: [],
	        selectionSet: this.parseSelectionSet(),
	        loc: this.loc(start)
	      };
	    }

	    var operation = this.parseOperationType();
	    var name;

	    if (this.peek(TokenKind.NAME)) {
	      name = this.parseName();
	    }

	    return {
	      kind: Kind.OPERATION_DEFINITION,
	      operation: operation,
	      name: name,
	      variableDefinitions: this.parseVariableDefinitions(),
	      directives: this.parseDirectives(false),
	      selectionSet: this.parseSelectionSet(),
	      loc: this.loc(start)
	    };
	  }
	  /**
	   * OperationType : one of query mutation subscription
	   */
	  ;

	  _proto.parseOperationType = function parseOperationType() {
	    var operationToken = this.expectToken(TokenKind.NAME);

	    switch (operationToken.value) {
	      case 'query':
	        return 'query';

	      case 'mutation':
	        return 'mutation';

	      case 'subscription':
	        return 'subscription';
	    }

	    throw this.unexpected(operationToken);
	  }
	  /**
	   * VariableDefinitions : ( VariableDefinition+ )
	   */
	  ;

	  _proto.parseVariableDefinitions = function parseVariableDefinitions() {
	    return this.optionalMany(TokenKind.PAREN_L, this.parseVariableDefinition, TokenKind.PAREN_R);
	  }
	  /**
	   * VariableDefinition : Variable : Type DefaultValue? Directives[Const]?
	   */
	  ;

	  _proto.parseVariableDefinition = function parseVariableDefinition() {
	    var start = this._lexer.token;
	    return {
	      kind: Kind.VARIABLE_DEFINITION,
	      variable: this.parseVariable(),
	      type: (this.expectToken(TokenKind.COLON), this.parseTypeReference()),
	      defaultValue: this.expectOptionalToken(TokenKind.EQUALS) ? this.parseValueLiteral(true) : undefined,
	      directives: this.parseDirectives(true),
	      loc: this.loc(start)
	    };
	  }
	  /**
	   * Variable : $ Name
	   */
	  ;

	  _proto.parseVariable = function parseVariable() {
	    var start = this._lexer.token;
	    this.expectToken(TokenKind.DOLLAR);
	    return {
	      kind: Kind.VARIABLE,
	      name: this.parseName(),
	      loc: this.loc(start)
	    };
	  }
	  /**
	   * SelectionSet : { Selection+ }
	   */
	  ;

	  _proto.parseSelectionSet = function parseSelectionSet() {
	    var start = this._lexer.token;
	    return {
	      kind: Kind.SELECTION_SET,
	      selections: this.many(TokenKind.BRACE_L, this.parseSelection, TokenKind.BRACE_R),
	      loc: this.loc(start)
	    };
	  }
	  /**
	   * Selection :
	   *   - Field
	   *   - FragmentSpread
	   *   - InlineFragment
	   */
	  ;

	  _proto.parseSelection = function parseSelection() {
	    return this.peek(TokenKind.SPREAD) ? this.parseFragment() : this.parseField();
	  }
	  /**
	   * Field : Alias? Name Arguments? Directives? SelectionSet?
	   *
	   * Alias : Name :
	   */
	  ;

	  _proto.parseField = function parseField() {
	    var start = this._lexer.token;
	    var nameOrAlias = this.parseName();
	    var alias;
	    var name;

	    if (this.expectOptionalToken(TokenKind.COLON)) {
	      alias = nameOrAlias;
	      name = this.parseName();
	    } else {
	      name = nameOrAlias;
	    }

	    return {
	      kind: Kind.FIELD,
	      alias: alias,
	      name: name,
	      arguments: this.parseArguments(false),
	      directives: this.parseDirectives(false),
	      selectionSet: this.peek(TokenKind.BRACE_L) ? this.parseSelectionSet() : undefined,
	      loc: this.loc(start)
	    };
	  }
	  /**
	   * Arguments[Const] : ( Argument[?Const]+ )
	   */
	  ;

	  _proto.parseArguments = function parseArguments(isConst) {
	    var item = isConst ? this.parseConstArgument : this.parseArgument;
	    return this.optionalMany(TokenKind.PAREN_L, item, TokenKind.PAREN_R);
	  }
	  /**
	   * Argument[Const] : Name : Value[?Const]
	   */
	  ;

	  _proto.parseArgument = function parseArgument() {
	    var start = this._lexer.token;
	    var name = this.parseName();
	    this.expectToken(TokenKind.COLON);
	    return {
	      kind: Kind.ARGUMENT,
	      name: name,
	      value: this.parseValueLiteral(false),
	      loc: this.loc(start)
	    };
	  };

	  _proto.parseConstArgument = function parseConstArgument() {
	    var start = this._lexer.token;
	    return {
	      kind: Kind.ARGUMENT,
	      name: this.parseName(),
	      value: (this.expectToken(TokenKind.COLON), this.parseValueLiteral(true)),
	      loc: this.loc(start)
	    };
	  } // Implements the parsing rules in the Fragments section.

	  /**
	   * Corresponds to both FragmentSpread and InlineFragment in the spec.
	   *
	   * FragmentSpread : ... FragmentName Directives?
	   *
	   * InlineFragment : ... TypeCondition? Directives? SelectionSet
	   */
	  ;

	  _proto.parseFragment = function parseFragment() {
	    var start = this._lexer.token;
	    this.expectToken(TokenKind.SPREAD);
	    var hasTypeCondition = this.expectOptionalKeyword('on');

	    if (!hasTypeCondition && this.peek(TokenKind.NAME)) {
	      return {
	        kind: Kind.FRAGMENT_SPREAD,
	        name: this.parseFragmentName(),
	        directives: this.parseDirectives(false),
	        loc: this.loc(start)
	      };
	    }

	    return {
	      kind: Kind.INLINE_FRAGMENT,
	      typeCondition: hasTypeCondition ? this.parseNamedType() : undefined,
	      directives: this.parseDirectives(false),
	      selectionSet: this.parseSelectionSet(),
	      loc: this.loc(start)
	    };
	  }
	  /**
	   * FragmentDefinition :
	   *   - fragment FragmentName on TypeCondition Directives? SelectionSet
	   *
	   * TypeCondition : NamedType
	   */
	  ;

	  _proto.parseFragmentDefinition = function parseFragmentDefinition() {
	    var _this$_options;

	    var start = this._lexer.token;
	    this.expectKeyword('fragment'); // Experimental support for defining variables within fragments changes
	    // the grammar of FragmentDefinition:
	    //   - fragment FragmentName VariableDefinitions? on TypeCondition Directives? SelectionSet

	    if (((_this$_options = this._options) === null || _this$_options === void 0 ? void 0 : _this$_options.experimentalFragmentVariables) === true) {
	      return {
	        kind: Kind.FRAGMENT_DEFINITION,
	        name: this.parseFragmentName(),
	        variableDefinitions: this.parseVariableDefinitions(),
	        typeCondition: (this.expectKeyword('on'), this.parseNamedType()),
	        directives: this.parseDirectives(false),
	        selectionSet: this.parseSelectionSet(),
	        loc: this.loc(start)
	      };
	    }

	    return {
	      kind: Kind.FRAGMENT_DEFINITION,
	      name: this.parseFragmentName(),
	      typeCondition: (this.expectKeyword('on'), this.parseNamedType()),
	      directives: this.parseDirectives(false),
	      selectionSet: this.parseSelectionSet(),
	      loc: this.loc(start)
	    };
	  }
	  /**
	   * FragmentName : Name but not `on`
	   */
	  ;

	  _proto.parseFragmentName = function parseFragmentName() {
	    if (this._lexer.token.value === 'on') {
	      throw this.unexpected();
	    }

	    return this.parseName();
	  } // Implements the parsing rules in the Values section.

	  /**
	   * Value[Const] :
	   *   - [~Const] Variable
	   *   - IntValue
	   *   - FloatValue
	   *   - StringValue
	   *   - BooleanValue
	   *   - NullValue
	   *   - EnumValue
	   *   - ListValue[?Const]
	   *   - ObjectValue[?Const]
	   *
	   * BooleanValue : one of `true` `false`
	   *
	   * NullValue : `null`
	   *
	   * EnumValue : Name but not `true`, `false` or `null`
	   */
	  ;

	  _proto.parseValueLiteral = function parseValueLiteral(isConst) {
	    var token = this._lexer.token;

	    switch (token.kind) {
	      case TokenKind.BRACKET_L:
	        return this.parseList(isConst);

	      case TokenKind.BRACE_L:
	        return this.parseObject(isConst);

	      case TokenKind.INT:
	        this._lexer.advance();

	        return {
	          kind: Kind.INT,
	          value: token.value,
	          loc: this.loc(token)
	        };

	      case TokenKind.FLOAT:
	        this._lexer.advance();

	        return {
	          kind: Kind.FLOAT,
	          value: token.value,
	          loc: this.loc(token)
	        };

	      case TokenKind.STRING:
	      case TokenKind.BLOCK_STRING:
	        return this.parseStringLiteral();

	      case TokenKind.NAME:
	        this._lexer.advance();

	        switch (token.value) {
	          case 'true':
	            return {
	              kind: Kind.BOOLEAN,
	              value: true,
	              loc: this.loc(token)
	            };

	          case 'false':
	            return {
	              kind: Kind.BOOLEAN,
	              value: false,
	              loc: this.loc(token)
	            };

	          case 'null':
	            return {
	              kind: Kind.NULL,
	              loc: this.loc(token)
	            };

	          default:
	            return {
	              kind: Kind.ENUM,
	              value: token.value,
	              loc: this.loc(token)
	            };
	        }

	      case TokenKind.DOLLAR:
	        if (!isConst) {
	          return this.parseVariable();
	        }

	        break;
	    }

	    throw this.unexpected();
	  };

	  _proto.parseStringLiteral = function parseStringLiteral() {
	    var token = this._lexer.token;

	    this._lexer.advance();

	    return {
	      kind: Kind.STRING,
	      value: token.value,
	      block: token.kind === TokenKind.BLOCK_STRING,
	      loc: this.loc(token)
	    };
	  }
	  /**
	   * ListValue[Const] :
	   *   - [ ]
	   *   - [ Value[?Const]+ ]
	   */
	  ;

	  _proto.parseList = function parseList(isConst) {
	    var _this = this;

	    var start = this._lexer.token;

	    var item = function item() {
	      return _this.parseValueLiteral(isConst);
	    };

	    return {
	      kind: Kind.LIST,
	      values: this.any(TokenKind.BRACKET_L, item, TokenKind.BRACKET_R),
	      loc: this.loc(start)
	    };
	  }
	  /**
	   * ObjectValue[Const] :
	   *   - { }
	   *   - { ObjectField[?Const]+ }
	   */
	  ;

	  _proto.parseObject = function parseObject(isConst) {
	    var _this2 = this;

	    var start = this._lexer.token;

	    var item = function item() {
	      return _this2.parseObjectField(isConst);
	    };

	    return {
	      kind: Kind.OBJECT,
	      fields: this.any(TokenKind.BRACE_L, item, TokenKind.BRACE_R),
	      loc: this.loc(start)
	    };
	  }
	  /**
	   * ObjectField[Const] : Name : Value[?Const]
	   */
	  ;

	  _proto.parseObjectField = function parseObjectField(isConst) {
	    var start = this._lexer.token;
	    var name = this.parseName();
	    this.expectToken(TokenKind.COLON);
	    return {
	      kind: Kind.OBJECT_FIELD,
	      name: name,
	      value: this.parseValueLiteral(isConst),
	      loc: this.loc(start)
	    };
	  } // Implements the parsing rules in the Directives section.

	  /**
	   * Directives[Const] : Directive[?Const]+
	   */
	  ;

	  _proto.parseDirectives = function parseDirectives(isConst) {
	    var directives = [];

	    while (this.peek(TokenKind.AT)) {
	      directives.push(this.parseDirective(isConst));
	    }

	    return directives;
	  }
	  /**
	   * Directive[Const] : @ Name Arguments[?Const]?
	   */
	  ;

	  _proto.parseDirective = function parseDirective(isConst) {
	    var start = this._lexer.token;
	    this.expectToken(TokenKind.AT);
	    return {
	      kind: Kind.DIRECTIVE,
	      name: this.parseName(),
	      arguments: this.parseArguments(isConst),
	      loc: this.loc(start)
	    };
	  } // Implements the parsing rules in the Types section.

	  /**
	   * Type :
	   *   - NamedType
	   *   - ListType
	   *   - NonNullType
	   */
	  ;

	  _proto.parseTypeReference = function parseTypeReference() {
	    var start = this._lexer.token;
	    var type;

	    if (this.expectOptionalToken(TokenKind.BRACKET_L)) {
	      type = this.parseTypeReference();
	      this.expectToken(TokenKind.BRACKET_R);
	      type = {
	        kind: Kind.LIST_TYPE,
	        type: type,
	        loc: this.loc(start)
	      };
	    } else {
	      type = this.parseNamedType();
	    }

	    if (this.expectOptionalToken(TokenKind.BANG)) {
	      return {
	        kind: Kind.NON_NULL_TYPE,
	        type: type,
	        loc: this.loc(start)
	      };
	    }

	    return type;
	  }
	  /**
	   * NamedType : Name
	   */
	  ;

	  _proto.parseNamedType = function parseNamedType() {
	    var start = this._lexer.token;
	    return {
	      kind: Kind.NAMED_TYPE,
	      name: this.parseName(),
	      loc: this.loc(start)
	    };
	  } // Implements the parsing rules in the Type Definition section.

	  /**
	   * TypeSystemDefinition :
	   *   - SchemaDefinition
	   *   - TypeDefinition
	   *   - DirectiveDefinition
	   *
	   * TypeDefinition :
	   *   - ScalarTypeDefinition
	   *   - ObjectTypeDefinition
	   *   - InterfaceTypeDefinition
	   *   - UnionTypeDefinition
	   *   - EnumTypeDefinition
	   *   - InputObjectTypeDefinition
	   */
	  ;

	  _proto.parseTypeSystemDefinition = function parseTypeSystemDefinition() {
	    // Many definitions begin with a description and require a lookahead.
	    var keywordToken = this.peekDescription() ? this._lexer.lookahead() : this._lexer.token;

	    if (keywordToken.kind === TokenKind.NAME) {
	      switch (keywordToken.value) {
	        case 'schema':
	          return this.parseSchemaDefinition();

	        case 'scalar':
	          return this.parseScalarTypeDefinition();

	        case 'type':
	          return this.parseObjectTypeDefinition();

	        case 'interface':
	          return this.parseInterfaceTypeDefinition();

	        case 'union':
	          return this.parseUnionTypeDefinition();

	        case 'enum':
	          return this.parseEnumTypeDefinition();

	        case 'input':
	          return this.parseInputObjectTypeDefinition();

	        case 'directive':
	          return this.parseDirectiveDefinition();
	      }
	    }

	    throw this.unexpected(keywordToken);
	  };

	  _proto.peekDescription = function peekDescription() {
	    return this.peek(TokenKind.STRING) || this.peek(TokenKind.BLOCK_STRING);
	  }
	  /**
	   * Description : StringValue
	   */
	  ;

	  _proto.parseDescription = function parseDescription() {
	    if (this.peekDescription()) {
	      return this.parseStringLiteral();
	    }
	  }
	  /**
	   * SchemaDefinition : Description? schema Directives[Const]? { OperationTypeDefinition+ }
	   */
	  ;

	  _proto.parseSchemaDefinition = function parseSchemaDefinition() {
	    var start = this._lexer.token;
	    var description = this.parseDescription();
	    this.expectKeyword('schema');
	    var directives = this.parseDirectives(true);
	    var operationTypes = this.many(TokenKind.BRACE_L, this.parseOperationTypeDefinition, TokenKind.BRACE_R);
	    return {
	      kind: Kind.SCHEMA_DEFINITION,
	      description: description,
	      directives: directives,
	      operationTypes: operationTypes,
	      loc: this.loc(start)
	    };
	  }
	  /**
	   * OperationTypeDefinition : OperationType : NamedType
	   */
	  ;

	  _proto.parseOperationTypeDefinition = function parseOperationTypeDefinition() {
	    var start = this._lexer.token;
	    var operation = this.parseOperationType();
	    this.expectToken(TokenKind.COLON);
	    var type = this.parseNamedType();
	    return {
	      kind: Kind.OPERATION_TYPE_DEFINITION,
	      operation: operation,
	      type: type,
	      loc: this.loc(start)
	    };
	  }
	  /**
	   * ScalarTypeDefinition : Description? scalar Name Directives[Const]?
	   */
	  ;

	  _proto.parseScalarTypeDefinition = function parseScalarTypeDefinition() {
	    var start = this._lexer.token;
	    var description = this.parseDescription();
	    this.expectKeyword('scalar');
	    var name = this.parseName();
	    var directives = this.parseDirectives(true);
	    return {
	      kind: Kind.SCALAR_TYPE_DEFINITION,
	      description: description,
	      name: name,
	      directives: directives,
	      loc: this.loc(start)
	    };
	  }
	  /**
	   * ObjectTypeDefinition :
	   *   Description?
	   *   type Name ImplementsInterfaces? Directives[Const]? FieldsDefinition?
	   */
	  ;

	  _proto.parseObjectTypeDefinition = function parseObjectTypeDefinition() {
	    var start = this._lexer.token;
	    var description = this.parseDescription();
	    this.expectKeyword('type');
	    var name = this.parseName();
	    var interfaces = this.parseImplementsInterfaces();
	    var directives = this.parseDirectives(true);
	    var fields = this.parseFieldsDefinition();
	    return {
	      kind: Kind.OBJECT_TYPE_DEFINITION,
	      description: description,
	      name: name,
	      interfaces: interfaces,
	      directives: directives,
	      fields: fields,
	      loc: this.loc(start)
	    };
	  }
	  /**
	   * ImplementsInterfaces :
	   *   - implements `&`? NamedType
	   *   - ImplementsInterfaces & NamedType
	   */
	  ;

	  _proto.parseImplementsInterfaces = function parseImplementsInterfaces() {
	    var _this$_options2;

	    if (!this.expectOptionalKeyword('implements')) {
	      return [];
	    }

	    if (((_this$_options2 = this._options) === null || _this$_options2 === void 0 ? void 0 : _this$_options2.allowLegacySDLImplementsInterfaces) === true) {
	      var types = []; // Optional leading ampersand

	      this.expectOptionalToken(TokenKind.AMP);

	      do {
	        types.push(this.parseNamedType());
	      } while (this.expectOptionalToken(TokenKind.AMP) || this.peek(TokenKind.NAME));

	      return types;
	    }

	    return this.delimitedMany(TokenKind.AMP, this.parseNamedType);
	  }
	  /**
	   * FieldsDefinition : { FieldDefinition+ }
	   */
	  ;

	  _proto.parseFieldsDefinition = function parseFieldsDefinition() {
	    var _this$_options3;

	    // Legacy support for the SDL?
	    if (((_this$_options3 = this._options) === null || _this$_options3 === void 0 ? void 0 : _this$_options3.allowLegacySDLEmptyFields) === true && this.peek(TokenKind.BRACE_L) && this._lexer.lookahead().kind === TokenKind.BRACE_R) {
	      this._lexer.advance();

	      this._lexer.advance();

	      return [];
	    }

	    return this.optionalMany(TokenKind.BRACE_L, this.parseFieldDefinition, TokenKind.BRACE_R);
	  }
	  /**
	   * FieldDefinition :
	   *   - Description? Name ArgumentsDefinition? : Type Directives[Const]?
	   */
	  ;

	  _proto.parseFieldDefinition = function parseFieldDefinition() {
	    var start = this._lexer.token;
	    var description = this.parseDescription();
	    var name = this.parseName();
	    var args = this.parseArgumentDefs();
	    this.expectToken(TokenKind.COLON);
	    var type = this.parseTypeReference();
	    var directives = this.parseDirectives(true);
	    return {
	      kind: Kind.FIELD_DEFINITION,
	      description: description,
	      name: name,
	      arguments: args,
	      type: type,
	      directives: directives,
	      loc: this.loc(start)
	    };
	  }
	  /**
	   * ArgumentsDefinition : ( InputValueDefinition+ )
	   */
	  ;

	  _proto.parseArgumentDefs = function parseArgumentDefs() {
	    return this.optionalMany(TokenKind.PAREN_L, this.parseInputValueDef, TokenKind.PAREN_R);
	  }
	  /**
	   * InputValueDefinition :
	   *   - Description? Name : Type DefaultValue? Directives[Const]?
	   */
	  ;

	  _proto.parseInputValueDef = function parseInputValueDef() {
	    var start = this._lexer.token;
	    var description = this.parseDescription();
	    var name = this.parseName();
	    this.expectToken(TokenKind.COLON);
	    var type = this.parseTypeReference();
	    var defaultValue;

	    if (this.expectOptionalToken(TokenKind.EQUALS)) {
	      defaultValue = this.parseValueLiteral(true);
	    }

	    var directives = this.parseDirectives(true);
	    return {
	      kind: Kind.INPUT_VALUE_DEFINITION,
	      description: description,
	      name: name,
	      type: type,
	      defaultValue: defaultValue,
	      directives: directives,
	      loc: this.loc(start)
	    };
	  }
	  /**
	   * InterfaceTypeDefinition :
	   *   - Description? interface Name Directives[Const]? FieldsDefinition?
	   */
	  ;

	  _proto.parseInterfaceTypeDefinition = function parseInterfaceTypeDefinition() {
	    var start = this._lexer.token;
	    var description = this.parseDescription();
	    this.expectKeyword('interface');
	    var name = this.parseName();
	    var interfaces = this.parseImplementsInterfaces();
	    var directives = this.parseDirectives(true);
	    var fields = this.parseFieldsDefinition();
	    return {
	      kind: Kind.INTERFACE_TYPE_DEFINITION,
	      description: description,
	      name: name,
	      interfaces: interfaces,
	      directives: directives,
	      fields: fields,
	      loc: this.loc(start)
	    };
	  }
	  /**
	   * UnionTypeDefinition :
	   *   - Description? union Name Directives[Const]? UnionMemberTypes?
	   */
	  ;

	  _proto.parseUnionTypeDefinition = function parseUnionTypeDefinition() {
	    var start = this._lexer.token;
	    var description = this.parseDescription();
	    this.expectKeyword('union');
	    var name = this.parseName();
	    var directives = this.parseDirectives(true);
	    var types = this.parseUnionMemberTypes();
	    return {
	      kind: Kind.UNION_TYPE_DEFINITION,
	      description: description,
	      name: name,
	      directives: directives,
	      types: types,
	      loc: this.loc(start)
	    };
	  }
	  /**
	   * UnionMemberTypes :
	   *   - = `|`? NamedType
	   *   - UnionMemberTypes | NamedType
	   */
	  ;

	  _proto.parseUnionMemberTypes = function parseUnionMemberTypes() {
	    return this.expectOptionalToken(TokenKind.EQUALS) ? this.delimitedMany(TokenKind.PIPE, this.parseNamedType) : [];
	  }
	  /**
	   * EnumTypeDefinition :
	   *   - Description? enum Name Directives[Const]? EnumValuesDefinition?
	   */
	  ;

	  _proto.parseEnumTypeDefinition = function parseEnumTypeDefinition() {
	    var start = this._lexer.token;
	    var description = this.parseDescription();
	    this.expectKeyword('enum');
	    var name = this.parseName();
	    var directives = this.parseDirectives(true);
	    var values = this.parseEnumValuesDefinition();
	    return {
	      kind: Kind.ENUM_TYPE_DEFINITION,
	      description: description,
	      name: name,
	      directives: directives,
	      values: values,
	      loc: this.loc(start)
	    };
	  }
	  /**
	   * EnumValuesDefinition : { EnumValueDefinition+ }
	   */
	  ;

	  _proto.parseEnumValuesDefinition = function parseEnumValuesDefinition() {
	    return this.optionalMany(TokenKind.BRACE_L, this.parseEnumValueDefinition, TokenKind.BRACE_R);
	  }
	  /**
	   * EnumValueDefinition : Description? EnumValue Directives[Const]?
	   *
	   * EnumValue : Name
	   */
	  ;

	  _proto.parseEnumValueDefinition = function parseEnumValueDefinition() {
	    var start = this._lexer.token;
	    var description = this.parseDescription();
	    var name = this.parseName();
	    var directives = this.parseDirectives(true);
	    return {
	      kind: Kind.ENUM_VALUE_DEFINITION,
	      description: description,
	      name: name,
	      directives: directives,
	      loc: this.loc(start)
	    };
	  }
	  /**
	   * InputObjectTypeDefinition :
	   *   - Description? input Name Directives[Const]? InputFieldsDefinition?
	   */
	  ;

	  _proto.parseInputObjectTypeDefinition = function parseInputObjectTypeDefinition() {
	    var start = this._lexer.token;
	    var description = this.parseDescription();
	    this.expectKeyword('input');
	    var name = this.parseName();
	    var directives = this.parseDirectives(true);
	    var fields = this.parseInputFieldsDefinition();
	    return {
	      kind: Kind.INPUT_OBJECT_TYPE_DEFINITION,
	      description: description,
	      name: name,
	      directives: directives,
	      fields: fields,
	      loc: this.loc(start)
	    };
	  }
	  /**
	   * InputFieldsDefinition : { InputValueDefinition+ }
	   */
	  ;

	  _proto.parseInputFieldsDefinition = function parseInputFieldsDefinition() {
	    return this.optionalMany(TokenKind.BRACE_L, this.parseInputValueDef, TokenKind.BRACE_R);
	  }
	  /**
	   * TypeSystemExtension :
	   *   - SchemaExtension
	   *   - TypeExtension
	   *
	   * TypeExtension :
	   *   - ScalarTypeExtension
	   *   - ObjectTypeExtension
	   *   - InterfaceTypeExtension
	   *   - UnionTypeExtension
	   *   - EnumTypeExtension
	   *   - InputObjectTypeDefinition
	   */
	  ;

	  _proto.parseTypeSystemExtension = function parseTypeSystemExtension() {
	    var keywordToken = this._lexer.lookahead();

	    if (keywordToken.kind === TokenKind.NAME) {
	      switch (keywordToken.value) {
	        case 'schema':
	          return this.parseSchemaExtension();

	        case 'scalar':
	          return this.parseScalarTypeExtension();

	        case 'type':
	          return this.parseObjectTypeExtension();

	        case 'interface':
	          return this.parseInterfaceTypeExtension();

	        case 'union':
	          return this.parseUnionTypeExtension();

	        case 'enum':
	          return this.parseEnumTypeExtension();

	        case 'input':
	          return this.parseInputObjectTypeExtension();
	      }
	    }

	    throw this.unexpected(keywordToken);
	  }
	  /**
	   * SchemaExtension :
	   *  - extend schema Directives[Const]? { OperationTypeDefinition+ }
	   *  - extend schema Directives[Const]
	   */
	  ;

	  _proto.parseSchemaExtension = function parseSchemaExtension() {
	    var start = this._lexer.token;
	    this.expectKeyword('extend');
	    this.expectKeyword('schema');
	    var directives = this.parseDirectives(true);
	    var operationTypes = this.optionalMany(TokenKind.BRACE_L, this.parseOperationTypeDefinition, TokenKind.BRACE_R);

	    if (directives.length === 0 && operationTypes.length === 0) {
	      throw this.unexpected();
	    }

	    return {
	      kind: Kind.SCHEMA_EXTENSION,
	      directives: directives,
	      operationTypes: operationTypes,
	      loc: this.loc(start)
	    };
	  }
	  /**
	   * ScalarTypeExtension :
	   *   - extend scalar Name Directives[Const]
	   */
	  ;

	  _proto.parseScalarTypeExtension = function parseScalarTypeExtension() {
	    var start = this._lexer.token;
	    this.expectKeyword('extend');
	    this.expectKeyword('scalar');
	    var name = this.parseName();
	    var directives = this.parseDirectives(true);

	    if (directives.length === 0) {
	      throw this.unexpected();
	    }

	    return {
	      kind: Kind.SCALAR_TYPE_EXTENSION,
	      name: name,
	      directives: directives,
	      loc: this.loc(start)
	    };
	  }
	  /**
	   * ObjectTypeExtension :
	   *  - extend type Name ImplementsInterfaces? Directives[Const]? FieldsDefinition
	   *  - extend type Name ImplementsInterfaces? Directives[Const]
	   *  - extend type Name ImplementsInterfaces
	   */
	  ;

	  _proto.parseObjectTypeExtension = function parseObjectTypeExtension() {
	    var start = this._lexer.token;
	    this.expectKeyword('extend');
	    this.expectKeyword('type');
	    var name = this.parseName();
	    var interfaces = this.parseImplementsInterfaces();
	    var directives = this.parseDirectives(true);
	    var fields = this.parseFieldsDefinition();

	    if (interfaces.length === 0 && directives.length === 0 && fields.length === 0) {
	      throw this.unexpected();
	    }

	    return {
	      kind: Kind.OBJECT_TYPE_EXTENSION,
	      name: name,
	      interfaces: interfaces,
	      directives: directives,
	      fields: fields,
	      loc: this.loc(start)
	    };
	  }
	  /**
	   * InterfaceTypeExtension :
	   *  - extend interface Name ImplementsInterfaces? Directives[Const]? FieldsDefinition
	   *  - extend interface Name ImplementsInterfaces? Directives[Const]
	   *  - extend interface Name ImplementsInterfaces
	   */
	  ;

	  _proto.parseInterfaceTypeExtension = function parseInterfaceTypeExtension() {
	    var start = this._lexer.token;
	    this.expectKeyword('extend');
	    this.expectKeyword('interface');
	    var name = this.parseName();
	    var interfaces = this.parseImplementsInterfaces();
	    var directives = this.parseDirectives(true);
	    var fields = this.parseFieldsDefinition();

	    if (interfaces.length === 0 && directives.length === 0 && fields.length === 0) {
	      throw this.unexpected();
	    }

	    return {
	      kind: Kind.INTERFACE_TYPE_EXTENSION,
	      name: name,
	      interfaces: interfaces,
	      directives: directives,
	      fields: fields,
	      loc: this.loc(start)
	    };
	  }
	  /**
	   * UnionTypeExtension :
	   *   - extend union Name Directives[Const]? UnionMemberTypes
	   *   - extend union Name Directives[Const]
	   */
	  ;

	  _proto.parseUnionTypeExtension = function parseUnionTypeExtension() {
	    var start = this._lexer.token;
	    this.expectKeyword('extend');
	    this.expectKeyword('union');
	    var name = this.parseName();
	    var directives = this.parseDirectives(true);
	    var types = this.parseUnionMemberTypes();

	    if (directives.length === 0 && types.length === 0) {
	      throw this.unexpected();
	    }

	    return {
	      kind: Kind.UNION_TYPE_EXTENSION,
	      name: name,
	      directives: directives,
	      types: types,
	      loc: this.loc(start)
	    };
	  }
	  /**
	   * EnumTypeExtension :
	   *   - extend enum Name Directives[Const]? EnumValuesDefinition
	   *   - extend enum Name Directives[Const]
	   */
	  ;

	  _proto.parseEnumTypeExtension = function parseEnumTypeExtension() {
	    var start = this._lexer.token;
	    this.expectKeyword('extend');
	    this.expectKeyword('enum');
	    var name = this.parseName();
	    var directives = this.parseDirectives(true);
	    var values = this.parseEnumValuesDefinition();

	    if (directives.length === 0 && values.length === 0) {
	      throw this.unexpected();
	    }

	    return {
	      kind: Kind.ENUM_TYPE_EXTENSION,
	      name: name,
	      directives: directives,
	      values: values,
	      loc: this.loc(start)
	    };
	  }
	  /**
	   * InputObjectTypeExtension :
	   *   - extend input Name Directives[Const]? InputFieldsDefinition
	   *   - extend input Name Directives[Const]
	   */
	  ;

	  _proto.parseInputObjectTypeExtension = function parseInputObjectTypeExtension() {
	    var start = this._lexer.token;
	    this.expectKeyword('extend');
	    this.expectKeyword('input');
	    var name = this.parseName();
	    var directives = this.parseDirectives(true);
	    var fields = this.parseInputFieldsDefinition();

	    if (directives.length === 0 && fields.length === 0) {
	      throw this.unexpected();
	    }

	    return {
	      kind: Kind.INPUT_OBJECT_TYPE_EXTENSION,
	      name: name,
	      directives: directives,
	      fields: fields,
	      loc: this.loc(start)
	    };
	  }
	  /**
	   * DirectiveDefinition :
	   *   - Description? directive @ Name ArgumentsDefinition? `repeatable`? on DirectiveLocations
	   */
	  ;

	  _proto.parseDirectiveDefinition = function parseDirectiveDefinition() {
	    var start = this._lexer.token;
	    var description = this.parseDescription();
	    this.expectKeyword('directive');
	    this.expectToken(TokenKind.AT);
	    var name = this.parseName();
	    var args = this.parseArgumentDefs();
	    var repeatable = this.expectOptionalKeyword('repeatable');
	    this.expectKeyword('on');
	    var locations = this.parseDirectiveLocations();
	    return {
	      kind: Kind.DIRECTIVE_DEFINITION,
	      description: description,
	      name: name,
	      arguments: args,
	      repeatable: repeatable,
	      locations: locations,
	      loc: this.loc(start)
	    };
	  }
	  /**
	   * DirectiveLocations :
	   *   - `|`? DirectiveLocation
	   *   - DirectiveLocations | DirectiveLocation
	   */
	  ;

	  _proto.parseDirectiveLocations = function parseDirectiveLocations() {
	    return this.delimitedMany(TokenKind.PIPE, this.parseDirectiveLocation);
	  }
	  /*
	   * DirectiveLocation :
	   *   - ExecutableDirectiveLocation
	   *   - TypeSystemDirectiveLocation
	   *
	   * ExecutableDirectiveLocation : one of
	   *   `QUERY`
	   *   `MUTATION`
	   *   `SUBSCRIPTION`
	   *   `FIELD`
	   *   `FRAGMENT_DEFINITION`
	   *   `FRAGMENT_SPREAD`
	   *   `INLINE_FRAGMENT`
	   *
	   * TypeSystemDirectiveLocation : one of
	   *   `SCHEMA`
	   *   `SCALAR`
	   *   `OBJECT`
	   *   `FIELD_DEFINITION`
	   *   `ARGUMENT_DEFINITION`
	   *   `INTERFACE`
	   *   `UNION`
	   *   `ENUM`
	   *   `ENUM_VALUE`
	   *   `INPUT_OBJECT`
	   *   `INPUT_FIELD_DEFINITION`
	   */
	  ;

	  _proto.parseDirectiveLocation = function parseDirectiveLocation() {
	    var start = this._lexer.token;
	    var name = this.parseName();

	    if (DirectiveLocation[name.value] !== undefined) {
	      return name;
	    }

	    throw this.unexpected(start);
	  } // Core parsing utility functions

	  /**
	   * Returns a location object, used to identify the place in the source that created a given parsed object.
	   */
	  ;

	  _proto.loc = function loc(startToken) {
	    var _this$_options4;

	    if (((_this$_options4 = this._options) === null || _this$_options4 === void 0 ? void 0 : _this$_options4.noLocation) !== true) {
	      return new Location(startToken, this._lexer.lastToken, this._lexer.source);
	    }
	  }
	  /**
	   * Determines if the next token is of a given kind
	   */
	  ;

	  _proto.peek = function peek(kind) {
	    return this._lexer.token.kind === kind;
	  }
	  /**
	   * If the next token is of the given kind, return that token after advancing the lexer.
	   * Otherwise, do not change the parser state and throw an error.
	   */
	  ;

	  _proto.expectToken = function expectToken(kind) {
	    var token = this._lexer.token;

	    if (token.kind === kind) {
	      this._lexer.advance();

	      return token;
	    }

	    throw syntaxError(this._lexer.source, token.start, "Expected ".concat(getTokenKindDesc(kind), ", found ").concat(getTokenDesc(token), "."));
	  }
	  /**
	   * If the next token is of the given kind, return that token after advancing the lexer.
	   * Otherwise, do not change the parser state and return undefined.
	   */
	  ;

	  _proto.expectOptionalToken = function expectOptionalToken(kind) {
	    var token = this._lexer.token;

	    if (token.kind === kind) {
	      this._lexer.advance();

	      return token;
	    }

	    return undefined;
	  }
	  /**
	   * If the next token is a given keyword, advance the lexer.
	   * Otherwise, do not change the parser state and throw an error.
	   */
	  ;

	  _proto.expectKeyword = function expectKeyword(value) {
	    var token = this._lexer.token;

	    if (token.kind === TokenKind.NAME && token.value === value) {
	      this._lexer.advance();
	    } else {
	      throw syntaxError(this._lexer.source, token.start, "Expected \"".concat(value, "\", found ").concat(getTokenDesc(token), "."));
	    }
	  }
	  /**
	   * If the next token is a given keyword, return "true" after advancing the lexer.
	   * Otherwise, do not change the parser state and return "false".
	   */
	  ;

	  _proto.expectOptionalKeyword = function expectOptionalKeyword(value) {
	    var token = this._lexer.token;

	    if (token.kind === TokenKind.NAME && token.value === value) {
	      this._lexer.advance();

	      return true;
	    }

	    return false;
	  }
	  /**
	   * Helper function for creating an error when an unexpected lexed token is encountered.
	   */
	  ;

	  _proto.unexpected = function unexpected(atToken) {
	    var token = atToken !== null && atToken !== void 0 ? atToken : this._lexer.token;
	    return syntaxError(this._lexer.source, token.start, "Unexpected ".concat(getTokenDesc(token), "."));
	  }
	  /**
	   * Returns a possibly empty list of parse nodes, determined by the parseFn.
	   * This list begins with a lex token of openKind and ends with a lex token of closeKind.
	   * Advances the parser to the next lex token after the closing token.
	   */
	  ;

	  _proto.any = function any(openKind, parseFn, closeKind) {
	    this.expectToken(openKind);
	    var nodes = [];

	    while (!this.expectOptionalToken(closeKind)) {
	      nodes.push(parseFn.call(this));
	    }

	    return nodes;
	  }
	  /**
	   * Returns a list of parse nodes, determined by the parseFn.
	   * It can be empty only if open token is missing otherwise it will always return non-empty list
	   * that begins with a lex token of openKind and ends with a lex token of closeKind.
	   * Advances the parser to the next lex token after the closing token.
	   */
	  ;

	  _proto.optionalMany = function optionalMany(openKind, parseFn, closeKind) {
	    if (this.expectOptionalToken(openKind)) {
	      var nodes = [];

	      do {
	        nodes.push(parseFn.call(this));
	      } while (!this.expectOptionalToken(closeKind));

	      return nodes;
	    }

	    return [];
	  }
	  /**
	   * Returns a non-empty list of parse nodes, determined by the parseFn.
	   * This list begins with a lex token of openKind and ends with a lex token of closeKind.
	   * Advances the parser to the next lex token after the closing token.
	   */
	  ;

	  _proto.many = function many(openKind, parseFn, closeKind) {
	    this.expectToken(openKind);
	    var nodes = [];

	    do {
	      nodes.push(parseFn.call(this));
	    } while (!this.expectOptionalToken(closeKind));

	    return nodes;
	  }
	  /**
	   * Returns a non-empty list of parse nodes, determined by the parseFn.
	   * This list may begin with a lex token of delimiterKind followed by items separated by lex tokens of tokenKind.
	   * Advances the parser to the next lex token after last item in the list.
	   */
	  ;

	  _proto.delimitedMany = function delimitedMany(delimiterKind, parseFn) {
	    this.expectOptionalToken(delimiterKind);
	    var nodes = [];

	    do {
	      nodes.push(parseFn.call(this));
	    } while (this.expectOptionalToken(delimiterKind));

	    return nodes;
	  };

	  return Parser;
	}();
	/**
	 * A helper function to describe a token as a string for debugging.
	 */

	function getTokenDesc(token) {
	  var value = token.value;
	  return getTokenKindDesc(token.kind) + (value != null ? " \"".concat(value, "\"") : '');
	}
	/**
	 * A helper function to describe a token kind as a string for debugging.
	 */


	function getTokenKindDesc(kind) {
	  return isPunctuatorTokenKind(kind) ? "\"".concat(kind, "\"") : kind;
	}

	/**
	 * A visitor is provided to visit, it contains the collection of
	 * relevant functions to be called during the visitor's traversal.
	 */

	var QueryDocumentKeys = {
	  Name: [],
	  Document: ['definitions'],
	  OperationDefinition: ['name', 'variableDefinitions', 'directives', 'selectionSet'],
	  VariableDefinition: ['variable', 'type', 'defaultValue', 'directives'],
	  Variable: ['name'],
	  SelectionSet: ['selections'],
	  Field: ['alias', 'name', 'arguments', 'directives', 'selectionSet'],
	  Argument: ['name', 'value'],
	  FragmentSpread: ['name', 'directives'],
	  InlineFragment: ['typeCondition', 'directives', 'selectionSet'],
	  FragmentDefinition: ['name', // Note: fragment variable definitions are experimental and may be changed
	  // or removed in the future.
	  'variableDefinitions', 'typeCondition', 'directives', 'selectionSet'],
	  IntValue: [],
	  FloatValue: [],
	  StringValue: [],
	  BooleanValue: [],
	  NullValue: [],
	  EnumValue: [],
	  ListValue: ['values'],
	  ObjectValue: ['fields'],
	  ObjectField: ['name', 'value'],
	  Directive: ['name', 'arguments'],
	  NamedType: ['name'],
	  ListType: ['type'],
	  NonNullType: ['type'],
	  SchemaDefinition: ['description', 'directives', 'operationTypes'],
	  OperationTypeDefinition: ['type'],
	  ScalarTypeDefinition: ['description', 'name', 'directives'],
	  ObjectTypeDefinition: ['description', 'name', 'interfaces', 'directives', 'fields'],
	  FieldDefinition: ['description', 'name', 'arguments', 'type', 'directives'],
	  InputValueDefinition: ['description', 'name', 'type', 'defaultValue', 'directives'],
	  InterfaceTypeDefinition: ['description', 'name', 'interfaces', 'directives', 'fields'],
	  UnionTypeDefinition: ['description', 'name', 'directives', 'types'],
	  EnumTypeDefinition: ['description', 'name', 'directives', 'values'],
	  EnumValueDefinition: ['description', 'name', 'directives'],
	  InputObjectTypeDefinition: ['description', 'name', 'directives', 'fields'],
	  DirectiveDefinition: ['description', 'name', 'arguments', 'locations'],
	  SchemaExtension: ['directives', 'operationTypes'],
	  ScalarTypeExtension: ['name', 'directives'],
	  ObjectTypeExtension: ['name', 'interfaces', 'directives', 'fields'],
	  InterfaceTypeExtension: ['name', 'interfaces', 'directives', 'fields'],
	  UnionTypeExtension: ['name', 'directives', 'types'],
	  EnumTypeExtension: ['name', 'directives', 'values'],
	  InputObjectTypeExtension: ['name', 'directives', 'fields']
	};
	var BREAK = Object.freeze({});
	/**
	 * visit() will walk through an AST using a depth-first traversal, calling
	 * the visitor's enter function at each node in the traversal, and calling the
	 * leave function after visiting that node and all of its child nodes.
	 *
	 * By returning different values from the enter and leave functions, the
	 * behavior of the visitor can be altered, including skipping over a sub-tree of
	 * the AST (by returning false), editing the AST by returning a value or null
	 * to remove the value, or to stop the whole traversal by returning BREAK.
	 *
	 * When using visit() to edit an AST, the original AST will not be modified, and
	 * a new version of the AST with the changes applied will be returned from the
	 * visit function.
	 *
	 *     const editedAST = visit(ast, {
	 *       enter(node, key, parent, path, ancestors) {
	 *         // @return
	 *         //   undefined: no action
	 *         //   false: skip visiting this node
	 *         //   visitor.BREAK: stop visiting altogether
	 *         //   null: delete this node
	 *         //   any value: replace this node with the returned value
	 *       },
	 *       leave(node, key, parent, path, ancestors) {
	 *         // @return
	 *         //   undefined: no action
	 *         //   false: no action
	 *         //   visitor.BREAK: stop visiting altogether
	 *         //   null: delete this node
	 *         //   any value: replace this node with the returned value
	 *       }
	 *     });
	 *
	 * Alternatively to providing enter() and leave() functions, a visitor can
	 * instead provide functions named the same as the kinds of AST nodes, or
	 * enter/leave visitors at a named key, leading to four permutations of the
	 * visitor API:
	 *
	 * 1) Named visitors triggered when entering a node of a specific kind.
	 *
	 *     visit(ast, {
	 *       Kind(node) {
	 *         // enter the "Kind" node
	 *       }
	 *     })
	 *
	 * 2) Named visitors that trigger upon entering and leaving a node of
	 *    a specific kind.
	 *
	 *     visit(ast, {
	 *       Kind: {
	 *         enter(node) {
	 *           // enter the "Kind" node
	 *         }
	 *         leave(node) {
	 *           // leave the "Kind" node
	 *         }
	 *       }
	 *     })
	 *
	 * 3) Generic visitors that trigger upon entering and leaving any node.
	 *
	 *     visit(ast, {
	 *       enter(node) {
	 *         // enter any node
	 *       },
	 *       leave(node) {
	 *         // leave any node
	 *       }
	 *     })
	 *
	 * 4) Parallel visitors for entering and leaving nodes of a specific kind.
	 *
	 *     visit(ast, {
	 *       enter: {
	 *         Kind(node) {
	 *           // enter the "Kind" node
	 *         }
	 *       },
	 *       leave: {
	 *         Kind(node) {
	 *           // leave the "Kind" node
	 *         }
	 *       }
	 *     })
	 */

	function visit(root, visitor) {
	  var visitorKeys = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : QueryDocumentKeys;

	  /* eslint-disable no-undef-init */
	  var stack = undefined;
	  var inArray = Array.isArray(root);
	  var keys = [root];
	  var index = -1;
	  var edits = [];
	  var node = undefined;
	  var key = undefined;
	  var parent = undefined;
	  var path = [];
	  var ancestors = [];
	  var newRoot = root;
	  /* eslint-enable no-undef-init */

	  do {
	    index++;
	    var isLeaving = index === keys.length;
	    var isEdited = isLeaving && edits.length !== 0;

	    if (isLeaving) {
	      key = ancestors.length === 0 ? undefined : path[path.length - 1];
	      node = parent;
	      parent = ancestors.pop();

	      if (isEdited) {
	        if (inArray) {
	          node = node.slice();
	        } else {
	          var clone = {};

	          for (var _i2 = 0, _Object$keys2 = Object.keys(node); _i2 < _Object$keys2.length; _i2++) {
	            var k = _Object$keys2[_i2];
	            clone[k] = node[k];
	          }

	          node = clone;
	        }

	        var editOffset = 0;

	        for (var ii = 0; ii < edits.length; ii++) {
	          var editKey = edits[ii][0];
	          var editValue = edits[ii][1];

	          if (inArray) {
	            editKey -= editOffset;
	          }

	          if (inArray && editValue === null) {
	            node.splice(editKey, 1);
	            editOffset++;
	          } else {
	            node[editKey] = editValue;
	          }
	        }
	      }

	      index = stack.index;
	      keys = stack.keys;
	      edits = stack.edits;
	      inArray = stack.inArray;
	      stack = stack.prev;
	    } else {
	      key = parent ? inArray ? index : keys[index] : undefined;
	      node = parent ? parent[key] : newRoot;

	      if (node === null || node === undefined) {
	        continue;
	      }

	      if (parent) {
	        path.push(key);
	      }
	    }

	    var result = void 0;

	    if (!Array.isArray(node)) {
	      if (!isNode(node)) {
	        throw new Error("Invalid AST Node: ".concat(inspect$2(node), "."));
	      }

	      var visitFn = getVisitFn(visitor, node.kind, isLeaving);

	      if (visitFn) {
	        result = visitFn.call(visitor, node, key, parent, path, ancestors);

	        if (result === BREAK) {
	          break;
	        }

	        if (result === false) {
	          if (!isLeaving) {
	            path.pop();
	            continue;
	          }
	        } else if (result !== undefined) {
	          edits.push([key, result]);

	          if (!isLeaving) {
	            if (isNode(result)) {
	              node = result;
	            } else {
	              path.pop();
	              continue;
	            }
	          }
	        }
	      }
	    }

	    if (result === undefined && isEdited) {
	      edits.push([key, node]);
	    }

	    if (isLeaving) {
	      path.pop();
	    } else {
	      var _visitorKeys$node$kin;

	      stack = {
	        inArray: inArray,
	        index: index,
	        keys: keys,
	        edits: edits,
	        prev: stack
	      };
	      inArray = Array.isArray(node);
	      keys = inArray ? node : (_visitorKeys$node$kin = visitorKeys[node.kind]) !== null && _visitorKeys$node$kin !== void 0 ? _visitorKeys$node$kin : [];
	      index = -1;
	      edits = [];

	      if (parent) {
	        ancestors.push(parent);
	      }

	      parent = node;
	    }
	  } while (stack !== undefined);

	  if (edits.length !== 0) {
	    newRoot = edits[edits.length - 1][1];
	  }

	  return newRoot;
	}
	/**
	 * Creates a new visitor instance which delegates to many visitors to run in
	 * parallel. Each visitor will be visited for each node before moving on.
	 *
	 * If a prior visitor edits a node, no following visitors will see that node.
	 */

	function visitInParallel(visitors) {
	  var skipping = new Array(visitors.length);
	  return {
	    enter: function enter(node) {
	      for (var i = 0; i < visitors.length; i++) {
	        if (skipping[i] == null) {
	          var fn = getVisitFn(visitors[i], node.kind,
	          /* isLeaving */
	          false);

	          if (fn) {
	            var result = fn.apply(visitors[i], arguments);

	            if (result === false) {
	              skipping[i] = node;
	            } else if (result === BREAK) {
	              skipping[i] = BREAK;
	            } else if (result !== undefined) {
	              return result;
	            }
	          }
	        }
	      }
	    },
	    leave: function leave(node) {
	      for (var i = 0; i < visitors.length; i++) {
	        if (skipping[i] == null) {
	          var fn = getVisitFn(visitors[i], node.kind,
	          /* isLeaving */
	          true);

	          if (fn) {
	            var result = fn.apply(visitors[i], arguments);

	            if (result === BREAK) {
	              skipping[i] = BREAK;
	            } else if (result !== undefined && result !== false) {
	              return result;
	            }
	          }
	        } else if (skipping[i] === node) {
	          skipping[i] = null;
	        }
	      }
	    }
	  };
	}
	/**
	 * Given a visitor instance, if it is leaving or not, and a node kind, return
	 * the function the visitor runtime should call.
	 */

	function getVisitFn(visitor, kind, isLeaving) {
	  var kindVisitor = visitor[kind];

	  if (kindVisitor) {
	    if (!isLeaving && typeof kindVisitor === 'function') {
	      // { Kind() {} }
	      return kindVisitor;
	    }

	    var kindSpecificVisitor = isLeaving ? kindVisitor.leave : kindVisitor.enter;

	    if (typeof kindSpecificVisitor === 'function') {
	      // { Kind: { enter() {}, leave() {} } }
	      return kindSpecificVisitor;
	    }
	  } else {
	    var specificVisitor = isLeaving ? visitor.leave : visitor.enter;

	    if (specificVisitor) {
	      if (typeof specificVisitor === 'function') {
	        // { enter() {}, leave() {} }
	        return specificVisitor;
	      }

	      var specificKindVisitor = specificVisitor[kind];

	      if (typeof specificKindVisitor === 'function') {
	        // { enter: { Kind() {} }, leave: { Kind() {} } }
	        return specificKindVisitor;
	      }
	    }
	  }
	}

	/* eslint-disable no-redeclare */
	// $FlowFixMe[name-already-bound]
	var find = Array.prototype.find ? function (list, predicate) {
	  return Array.prototype.find.call(list, predicate);
	} : function (list, predicate) {
	  for (var _i2 = 0; _i2 < list.length; _i2++) {
	    var value = list[_i2];

	    if (predicate(value)) {
	      return value;
	    }
	  }
	};
	var find$1 = find;

	/* eslint-disable no-redeclare */
	// $FlowFixMe[name-already-bound] workaround for: https://github.com/facebook/flow/issues/4441
	var objectValues = Object.values || function (obj) {
	  return Object.keys(obj).map(function (key) {
	    return obj[key];
	  });
	};

	var objectValues$1 = objectValues;

	/**
	 * Given an arbitrary value, presumably thrown while attempting to execute a
	 * GraphQL operation, produce a new GraphQLError aware of the location in the
	 * document responsible for the original Error.
	 */

	function locatedError(rawOriginalError, nodes, path) {
	  var _nodes;

	  // Sometimes a non-error is thrown, wrap it as an Error instance to ensure a consistent Error interface.
	  var originalError = rawOriginalError instanceof Error ? rawOriginalError : new Error('Unexpected error value: ' + inspect$2(rawOriginalError)); // Note: this uses a brand-check to support GraphQL errors originating from other contexts.

	  if (Array.isArray(originalError.path)) {
	    return originalError;
	  }

	  return new GraphQLError(originalError.message, (_nodes = originalError.nodes) !== null && _nodes !== void 0 ? _nodes : nodes, originalError.source, originalError.positions, path, originalError);
	}

	var NAME_RX = /^[_a-zA-Z][_a-zA-Z0-9]*$/;
	/**
	 * Upholds the spec rules about naming.
	 */

	function assertValidName(name) {
	  var error = isValidNameError(name);

	  if (error) {
	    throw error;
	  }

	  return name;
	}
	/**
	 * Returns an Error if a name is invalid.
	 */

	function isValidNameError(name) {
	  typeof name === 'string' || devAssert(0, 'Expected name to be a string.');

	  if (name.length > 1 && name[0] === '_' && name[1] === '_') {
	    return new GraphQLError("Name \"".concat(name, "\" must not begin with \"__\", which is reserved by GraphQL introspection."));
	  }

	  if (!NAME_RX.test(name)) {
	    return new GraphQLError("Names must match /^[_a-zA-Z][_a-zA-Z0-9]*$/ but \"".concat(name, "\" does not."));
	  }
	}

	/* eslint-disable no-redeclare */
	// $FlowFixMe[name-already-bound] workaround for: https://github.com/facebook/flow/issues/4441
	var objectEntries = Object.entries || function (obj) {
	  return Object.keys(obj).map(function (key) {
	    return [key, obj[key]];
	  });
	};

	var objectEntries$1 = objectEntries;

	/**
	 * Creates a keyed JS object from an array, given a function to produce the keys
	 * for each value in the array.
	 *
	 * This provides a convenient lookup for the array items if the key function
	 * produces unique results.
	 *
	 *     const phoneBook = [
	 *       { name: 'Jon', num: '555-1234' },
	 *       { name: 'Jenny', num: '867-5309' }
	 *     ]
	 *
	 *     // { Jon: { name: 'Jon', num: '555-1234' },
	 *     //   Jenny: { name: 'Jenny', num: '867-5309' } }
	 *     const entriesByName = keyMap(
	 *       phoneBook,
	 *       entry => entry.name
	 *     )
	 *
	 *     // { name: 'Jenny', num: '857-6309' }
	 *     const jennyEntry = entriesByName['Jenny']
	 *
	 */
	function keyMap(list, keyFn) {
	  return list.reduce(function (map, item) {
	    map[keyFn(item)] = item;
	    return map;
	  }, Object.create(null));
	}

	/**
	 * Creates an object map with the same keys as `map` and values generated by
	 * running each value of `map` thru `fn`.
	 */
	function mapValue(map, fn) {
	  var result = Object.create(null);

	  for (var _i2 = 0, _objectEntries2 = objectEntries$1(map); _i2 < _objectEntries2.length; _i2++) {
	    var _ref2 = _objectEntries2[_i2];
	    var _key = _ref2[0];
	    var _value = _ref2[1];
	    result[_key] = fn(_value, _key);
	  }

	  return result;
	}

	function toObjMap(obj) {
	  /* eslint-enable no-redeclare */
	  if (Object.getPrototypeOf(obj) === null) {
	    return obj;
	  }

	  var map = Object.create(null);

	  for (var _i2 = 0, _objectEntries2 = objectEntries$1(obj); _i2 < _objectEntries2.length; _i2++) {
	    var _ref2 = _objectEntries2[_i2];
	    var key = _ref2[0];
	    var value = _ref2[1];
	    map[key] = value;
	  }

	  return map;
	}

	/**
	 * Creates a keyed JS object from an array, given a function to produce the keys
	 * and a function to produce the values from each item in the array.
	 *
	 *     const phoneBook = [
	 *       { name: 'Jon', num: '555-1234' },
	 *       { name: 'Jenny', num: '867-5309' }
	 *     ]
	 *
	 *     // { Jon: '555-1234', Jenny: '867-5309' }
	 *     const phonesByName = keyValMap(
	 *       phoneBook,
	 *       entry => entry.name,
	 *       entry => entry.num
	 *     )
	 *
	 */
	function keyValMap(list, keyFn, valFn) {
	  return list.reduce(function (map, item) {
	    map[keyFn(item)] = valFn(item);
	    return map;
	  }, Object.create(null));
	}

	var MAX_SUGGESTIONS$1 = 5;
	/**
	 * Given [ A, B, C ] return ' Did you mean A, B, or C?'.
	 */

	// eslint-disable-next-line no-redeclare
	function didYouMean$1(firstArg, secondArg) {
	  var _ref = typeof firstArg === 'string' ? [firstArg, secondArg] : [undefined, firstArg],
	      subMessage = _ref[0],
	      suggestionsArg = _ref[1];

	  var message = ' Did you mean ';

	  if (subMessage) {
	    message += subMessage + ' ';
	  }

	  var suggestions = suggestionsArg.map(function (x) {
	    return "\"".concat(x, "\"");
	  });

	  switch (suggestions.length) {
	    case 0:
	      return '';

	    case 1:
	      return message + suggestions[0] + '?';

	    case 2:
	      return message + suggestions[0] + ' or ' + suggestions[1] + '?';
	  }

	  var selected = suggestions.slice(0, MAX_SUGGESTIONS$1);
	  var lastItem = selected.pop();
	  return message + selected.join(', ') + ', or ' + lastItem + '?';
	}

	/**
	 * Returns the first argument it receives.
	 */
	function identityFunc(x) {
	  return x;
	}

	/**
	 * Returns a number indicating whether a reference string comes before, or after,
	 * or is the same as the given string in natural sort order.
	 *
	 * See: https://en.wikipedia.org/wiki/Natural_sort_order
	 *
	 */
	function naturalCompare(aStr, bStr) {
	  var aIdx = 0;
	  var bIdx = 0;

	  while (aIdx < aStr.length && bIdx < bStr.length) {
	    var aChar = aStr.charCodeAt(aIdx);
	    var bChar = bStr.charCodeAt(bIdx);

	    if (isDigit(aChar) && isDigit(bChar)) {
	      var aNum = 0;

	      do {
	        ++aIdx;
	        aNum = aNum * 10 + aChar - DIGIT_0;
	        aChar = aStr.charCodeAt(aIdx);
	      } while (isDigit(aChar) && aNum > 0);

	      var bNum = 0;

	      do {
	        ++bIdx;
	        bNum = bNum * 10 + bChar - DIGIT_0;
	        bChar = bStr.charCodeAt(bIdx);
	      } while (isDigit(bChar) && bNum > 0);

	      if (aNum < bNum) {
	        return -1;
	      }

	      if (aNum > bNum) {
	        return 1;
	      }
	    } else {
	      if (aChar < bChar) {
	        return -1;
	      }

	      if (aChar > bChar) {
	        return 1;
	      }

	      ++aIdx;
	      ++bIdx;
	    }
	  }

	  return aStr.length - bStr.length;
	}
	var DIGIT_0 = 48;
	var DIGIT_9 = 57;

	function isDigit(code) {
	  return !isNaN(code) && DIGIT_0 <= code && code <= DIGIT_9;
	}

	/**
	 * Given an invalid input string and a list of valid options, returns a filtered
	 * list of valid options sorted based on their similarity with the input.
	 */

	function suggestionList$1(input, options) {
	  var optionsByDistance = Object.create(null);
	  var lexicalDistance = new LexicalDistance(input);
	  var threshold = Math.floor(input.length * 0.4) + 1;

	  for (var _i2 = 0; _i2 < options.length; _i2++) {
	    var option = options[_i2];
	    var distance = lexicalDistance.measure(option, threshold);

	    if (distance !== undefined) {
	      optionsByDistance[option] = distance;
	    }
	  }

	  return Object.keys(optionsByDistance).sort(function (a, b) {
	    var distanceDiff = optionsByDistance[a] - optionsByDistance[b];
	    return distanceDiff !== 0 ? distanceDiff : naturalCompare(a, b);
	  });
	}
	/**
	 * Computes the lexical distance between strings A and B.
	 *
	 * The "distance" between two strings is given by counting the minimum number
	 * of edits needed to transform string A into string B. An edit can be an
	 * insertion, deletion, or substitution of a single character, or a swap of two
	 * adjacent characters.
	 *
	 * Includes a custom alteration from Damerau-Levenshtein to treat case changes
	 * as a single edit which helps identify mis-cased values with an edit distance
	 * of 1.
	 *
	 * This distance can be useful for detecting typos in input or sorting
	 */

	var LexicalDistance = /*#__PURE__*/function () {
	  function LexicalDistance(input) {
	    this._input = input;
	    this._inputLowerCase = input.toLowerCase();
	    this._inputArray = stringToArray(this._inputLowerCase);
	    this._rows = [new Array(input.length + 1).fill(0), new Array(input.length + 1).fill(0), new Array(input.length + 1).fill(0)];
	  }

	  var _proto = LexicalDistance.prototype;

	  _proto.measure = function measure(option, threshold) {
	    if (this._input === option) {
	      return 0;
	    }

	    var optionLowerCase = option.toLowerCase(); // Any case change counts as a single edit

	    if (this._inputLowerCase === optionLowerCase) {
	      return 1;
	    }

	    var a = stringToArray(optionLowerCase);
	    var b = this._inputArray;

	    if (a.length < b.length) {
	      var tmp = a;
	      a = b;
	      b = tmp;
	    }

	    var aLength = a.length;
	    var bLength = b.length;

	    if (aLength - bLength > threshold) {
	      return undefined;
	    }

	    var rows = this._rows;

	    for (var j = 0; j <= bLength; j++) {
	      rows[0][j] = j;
	    }

	    for (var i = 1; i <= aLength; i++) {
	      var upRow = rows[(i - 1) % 3];
	      var currentRow = rows[i % 3];
	      var smallestCell = currentRow[0] = i;

	      for (var _j = 1; _j <= bLength; _j++) {
	        var cost = a[i - 1] === b[_j - 1] ? 0 : 1;
	        var currentCell = Math.min(upRow[_j] + 1, // delete
	        currentRow[_j - 1] + 1, // insert
	        upRow[_j - 1] + cost // substitute
	        );

	        if (i > 1 && _j > 1 && a[i - 1] === b[_j - 2] && a[i - 2] === b[_j - 1]) {
	          // transposition
	          var doubleDiagonalCell = rows[(i - 2) % 3][_j - 2];
	          currentCell = Math.min(currentCell, doubleDiagonalCell + 1);
	        }

	        if (currentCell < smallestCell) {
	          smallestCell = currentCell;
	        }

	        currentRow[_j] = currentCell;
	      } // Early exit, since distance can't go smaller than smallest element of the previous row.


	      if (smallestCell > threshold) {
	        return undefined;
	      }
	    }

	    var distance = rows[aLength % 3][bLength];
	    return distance <= threshold ? distance : undefined;
	  };

	  return LexicalDistance;
	}();

	function stringToArray(str) {
	  var strLength = str.length;
	  var array = new Array(strLength);

	  for (var i = 0; i < strLength; ++i) {
	    array[i] = str.charCodeAt(i);
	  }

	  return array;
	}

	/**
	 * Converts an AST into a string, using one set of reasonable
	 * formatting rules.
	 */

	function print$1(ast) {
	  return visit(ast, {
	    leave: printDocASTReducer
	  });
	}
	var MAX_LINE_LENGTH = 80; // TODO: provide better type coverage in future

	var printDocASTReducer = {
	  Name: function Name(node) {
	    return node.value;
	  },
	  Variable: function Variable(node) {
	    return '$' + node.name;
	  },
	  // Document
	  Document: function Document(node) {
	    return join$1(node.definitions, '\n\n') + '\n';
	  },
	  OperationDefinition: function OperationDefinition(node) {
	    var op = node.operation;
	    var name = node.name;
	    var varDefs = wrap('(', join$1(node.variableDefinitions, ', '), ')');
	    var directives = join$1(node.directives, ' ');
	    var selectionSet = node.selectionSet; // Anonymous queries with no directives or variable definitions can use
	    // the query short form.

	    return !name && !directives && !varDefs && op === 'query' ? selectionSet : join$1([op, join$1([name, varDefs]), directives, selectionSet], ' ');
	  },
	  VariableDefinition: function VariableDefinition(_ref) {
	    var variable = _ref.variable,
	        type = _ref.type,
	        defaultValue = _ref.defaultValue,
	        directives = _ref.directives;
	    return variable + ': ' + type + wrap(' = ', defaultValue) + wrap(' ', join$1(directives, ' '));
	  },
	  SelectionSet: function SelectionSet(_ref2) {
	    var selections = _ref2.selections;
	    return block(selections);
	  },
	  Field: function Field(_ref3) {
	    var alias = _ref3.alias,
	        name = _ref3.name,
	        args = _ref3.arguments,
	        directives = _ref3.directives,
	        selectionSet = _ref3.selectionSet;
	    var prefix = wrap('', alias, ': ') + name;
	    var argsLine = prefix + wrap('(', join$1(args, ', '), ')');

	    if (argsLine.length > MAX_LINE_LENGTH) {
	      argsLine = prefix + wrap('(\n', indent(join$1(args, '\n')), '\n)');
	    }

	    return join$1([argsLine, join$1(directives, ' '), selectionSet], ' ');
	  },
	  Argument: function Argument(_ref4) {
	    var name = _ref4.name,
	        value = _ref4.value;
	    return name + ': ' + value;
	  },
	  // Fragments
	  FragmentSpread: function FragmentSpread(_ref5) {
	    var name = _ref5.name,
	        directives = _ref5.directives;
	    return '...' + name + wrap(' ', join$1(directives, ' '));
	  },
	  InlineFragment: function InlineFragment(_ref6) {
	    var typeCondition = _ref6.typeCondition,
	        directives = _ref6.directives,
	        selectionSet = _ref6.selectionSet;
	    return join$1(['...', wrap('on ', typeCondition), join$1(directives, ' '), selectionSet], ' ');
	  },
	  FragmentDefinition: function FragmentDefinition(_ref7) {
	    var name = _ref7.name,
	        typeCondition = _ref7.typeCondition,
	        variableDefinitions = _ref7.variableDefinitions,
	        directives = _ref7.directives,
	        selectionSet = _ref7.selectionSet;
	    return (// Note: fragment variable definitions are experimental and may be changed
	      // or removed in the future.
	      "fragment ".concat(name).concat(wrap('(', join$1(variableDefinitions, ', '), ')'), " ") + "on ".concat(typeCondition, " ").concat(wrap('', join$1(directives, ' '), ' ')) + selectionSet
	    );
	  },
	  // Value
	  IntValue: function IntValue(_ref8) {
	    var value = _ref8.value;
	    return value;
	  },
	  FloatValue: function FloatValue(_ref9) {
	    var value = _ref9.value;
	    return value;
	  },
	  StringValue: function StringValue(_ref10, key) {
	    var value = _ref10.value,
	        isBlockString = _ref10.block;
	    return isBlockString ? printBlockString(value, key === 'description' ? '' : '  ') : JSON.stringify(value);
	  },
	  BooleanValue: function BooleanValue(_ref11) {
	    var value = _ref11.value;
	    return value ? 'true' : 'false';
	  },
	  NullValue: function NullValue() {
	    return 'null';
	  },
	  EnumValue: function EnumValue(_ref12) {
	    var value = _ref12.value;
	    return value;
	  },
	  ListValue: function ListValue(_ref13) {
	    var values = _ref13.values;
	    return '[' + join$1(values, ', ') + ']';
	  },
	  ObjectValue: function ObjectValue(_ref14) {
	    var fields = _ref14.fields;
	    return '{' + join$1(fields, ', ') + '}';
	  },
	  ObjectField: function ObjectField(_ref15) {
	    var name = _ref15.name,
	        value = _ref15.value;
	    return name + ': ' + value;
	  },
	  // Directive
	  Directive: function Directive(_ref16) {
	    var name = _ref16.name,
	        args = _ref16.arguments;
	    return '@' + name + wrap('(', join$1(args, ', '), ')');
	  },
	  // Type
	  NamedType: function NamedType(_ref17) {
	    var name = _ref17.name;
	    return name;
	  },
	  ListType: function ListType(_ref18) {
	    var type = _ref18.type;
	    return '[' + type + ']';
	  },
	  NonNullType: function NonNullType(_ref19) {
	    var type = _ref19.type;
	    return type + '!';
	  },
	  // Type System Definitions
	  SchemaDefinition: addDescription(function (_ref20) {
	    var directives = _ref20.directives,
	        operationTypes = _ref20.operationTypes;
	    return join$1(['schema', join$1(directives, ' '), block(operationTypes)], ' ');
	  }),
	  OperationTypeDefinition: function OperationTypeDefinition(_ref21) {
	    var operation = _ref21.operation,
	        type = _ref21.type;
	    return operation + ': ' + type;
	  },
	  ScalarTypeDefinition: addDescription(function (_ref22) {
	    var name = _ref22.name,
	        directives = _ref22.directives;
	    return join$1(['scalar', name, join$1(directives, ' ')], ' ');
	  }),
	  ObjectTypeDefinition: addDescription(function (_ref23) {
	    var name = _ref23.name,
	        interfaces = _ref23.interfaces,
	        directives = _ref23.directives,
	        fields = _ref23.fields;
	    return join$1(['type', name, wrap('implements ', join$1(interfaces, ' & ')), join$1(directives, ' '), block(fields)], ' ');
	  }),
	  FieldDefinition: addDescription(function (_ref24) {
	    var name = _ref24.name,
	        args = _ref24.arguments,
	        type = _ref24.type,
	        directives = _ref24.directives;
	    return name + (hasMultilineItems(args) ? wrap('(\n', indent(join$1(args, '\n')), '\n)') : wrap('(', join$1(args, ', '), ')')) + ': ' + type + wrap(' ', join$1(directives, ' '));
	  }),
	  InputValueDefinition: addDescription(function (_ref25) {
	    var name = _ref25.name,
	        type = _ref25.type,
	        defaultValue = _ref25.defaultValue,
	        directives = _ref25.directives;
	    return join$1([name + ': ' + type, wrap('= ', defaultValue), join$1(directives, ' ')], ' ');
	  }),
	  InterfaceTypeDefinition: addDescription(function (_ref26) {
	    var name = _ref26.name,
	        interfaces = _ref26.interfaces,
	        directives = _ref26.directives,
	        fields = _ref26.fields;
	    return join$1(['interface', name, wrap('implements ', join$1(interfaces, ' & ')), join$1(directives, ' '), block(fields)], ' ');
	  }),
	  UnionTypeDefinition: addDescription(function (_ref27) {
	    var name = _ref27.name,
	        directives = _ref27.directives,
	        types = _ref27.types;
	    return join$1(['union', name, join$1(directives, ' '), types && types.length !== 0 ? '= ' + join$1(types, ' | ') : ''], ' ');
	  }),
	  EnumTypeDefinition: addDescription(function (_ref28) {
	    var name = _ref28.name,
	        directives = _ref28.directives,
	        values = _ref28.values;
	    return join$1(['enum', name, join$1(directives, ' '), block(values)], ' ');
	  }),
	  EnumValueDefinition: addDescription(function (_ref29) {
	    var name = _ref29.name,
	        directives = _ref29.directives;
	    return join$1([name, join$1(directives, ' ')], ' ');
	  }),
	  InputObjectTypeDefinition: addDescription(function (_ref30) {
	    var name = _ref30.name,
	        directives = _ref30.directives,
	        fields = _ref30.fields;
	    return join$1(['input', name, join$1(directives, ' '), block(fields)], ' ');
	  }),
	  DirectiveDefinition: addDescription(function (_ref31) {
	    var name = _ref31.name,
	        args = _ref31.arguments,
	        repeatable = _ref31.repeatable,
	        locations = _ref31.locations;
	    return 'directive @' + name + (hasMultilineItems(args) ? wrap('(\n', indent(join$1(args, '\n')), '\n)') : wrap('(', join$1(args, ', '), ')')) + (repeatable ? ' repeatable' : '') + ' on ' + join$1(locations, ' | ');
	  }),
	  SchemaExtension: function SchemaExtension(_ref32) {
	    var directives = _ref32.directives,
	        operationTypes = _ref32.operationTypes;
	    return join$1(['extend schema', join$1(directives, ' '), block(operationTypes)], ' ');
	  },
	  ScalarTypeExtension: function ScalarTypeExtension(_ref33) {
	    var name = _ref33.name,
	        directives = _ref33.directives;
	    return join$1(['extend scalar', name, join$1(directives, ' ')], ' ');
	  },
	  ObjectTypeExtension: function ObjectTypeExtension(_ref34) {
	    var name = _ref34.name,
	        interfaces = _ref34.interfaces,
	        directives = _ref34.directives,
	        fields = _ref34.fields;
	    return join$1(['extend type', name, wrap('implements ', join$1(interfaces, ' & ')), join$1(directives, ' '), block(fields)], ' ');
	  },
	  InterfaceTypeExtension: function InterfaceTypeExtension(_ref35) {
	    var name = _ref35.name,
	        interfaces = _ref35.interfaces,
	        directives = _ref35.directives,
	        fields = _ref35.fields;
	    return join$1(['extend interface', name, wrap('implements ', join$1(interfaces, ' & ')), join$1(directives, ' '), block(fields)], ' ');
	  },
	  UnionTypeExtension: function UnionTypeExtension(_ref36) {
	    var name = _ref36.name,
	        directives = _ref36.directives,
	        types = _ref36.types;
	    return join$1(['extend union', name, join$1(directives, ' '), types && types.length !== 0 ? '= ' + join$1(types, ' | ') : ''], ' ');
	  },
	  EnumTypeExtension: function EnumTypeExtension(_ref37) {
	    var name = _ref37.name,
	        directives = _ref37.directives,
	        values = _ref37.values;
	    return join$1(['extend enum', name, join$1(directives, ' '), block(values)], ' ');
	  },
	  InputObjectTypeExtension: function InputObjectTypeExtension(_ref38) {
	    var name = _ref38.name,
	        directives = _ref38.directives,
	        fields = _ref38.fields;
	    return join$1(['extend input', name, join$1(directives, ' '), block(fields)], ' ');
	  }
	};

	function addDescription(cb) {
	  return function (node) {
	    return join$1([node.description, cb(node)], '\n');
	  };
	}
	/**
	 * Given maybeArray, print an empty string if it is null or empty, otherwise
	 * print all items together separated by separator if provided
	 */


	function join$1(maybeArray) {
	  var _maybeArray$filter$jo;

	  var separator = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : '';
	  return (_maybeArray$filter$jo = maybeArray === null || maybeArray === void 0 ? void 0 : maybeArray.filter(function (x) {
	    return x;
	  }).join(separator)) !== null && _maybeArray$filter$jo !== void 0 ? _maybeArray$filter$jo : '';
	}
	/**
	 * Given array, print each item on its own line, wrapped in an
	 * indented "{ }" block.
	 */


	function block(array) {
	  return wrap('{\n', indent(join$1(array, '\n')), '\n}');
	}
	/**
	 * If maybeString is not null or empty, then wrap with start and end, otherwise print an empty string.
	 */


	function wrap(start, maybeString) {
	  var end = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : '';
	  return maybeString != null && maybeString !== '' ? start + maybeString + end : '';
	}

	function indent(str) {
	  return wrap('  ', str.replace(/\n/g, '\n  '));
	}

	function isMultiline(str) {
	  return str.indexOf('\n') !== -1;
	}

	function hasMultilineItems(maybeArray) {
	  return maybeArray != null && maybeArray.some(isMultiline);
	}

	/**
	 * Produces a JavaScript value given a GraphQL Value AST.
	 *
	 * Unlike `valueFromAST()`, no type is provided. The resulting JavaScript value
	 * will reflect the provided GraphQL value AST.
	 *
	 * | GraphQL Value        | JavaScript Value |
	 * | -------------------- | ---------------- |
	 * | Input Object         | Object           |
	 * | List                 | Array            |
	 * | Boolean              | Boolean          |
	 * | String / Enum        | String           |
	 * | Int / Float          | Number           |
	 * | Null                 | null             |
	 *
	 */
	function valueFromASTUntyped$1(valueNode, variables) {
	  switch (valueNode.kind) {
	    case Kind.NULL:
	      return null;

	    case Kind.INT:
	      return parseInt(valueNode.value, 10);

	    case Kind.FLOAT:
	      return parseFloat(valueNode.value);

	    case Kind.STRING:
	    case Kind.ENUM:
	    case Kind.BOOLEAN:
	      return valueNode.value;

	    case Kind.LIST:
	      return valueNode.values.map(function (node) {
	        return valueFromASTUntyped$1(node, variables);
	      });

	    case Kind.OBJECT:
	      return keyValMap(valueNode.fields, function (field) {
	        return field.name.value;
	      }, function (field) {
	        return valueFromASTUntyped$1(field.value, variables);
	      });

	    case Kind.VARIABLE:
	      return variables === null || variables === void 0 ? void 0 : variables[valueNode.name.value];
	  } // istanbul ignore next (Not reachable. All possible value nodes have been considered)


	  invariant(0, 'Unexpected value node: ' + inspect$2(valueNode));
	}

	function _defineProperties$2(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

	function _createClass$2(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties$2(Constructor.prototype, protoProps); if (staticProps) _defineProperties$2(Constructor, staticProps); return Constructor; }
	function isType(type) {
	  return isScalarType(type) || isObjectType(type) || isInterfaceType(type) || isUnionType(type) || isEnumType(type) || isInputObjectType(type) || isListType(type) || isNonNullType(type);
	}
	function assertType(type) {
	  if (!isType(type)) {
	    throw new Error("Expected ".concat(inspect$2(type), " to be a GraphQL type."));
	  }

	  return type;
	}
	/**
	 * There are predicates for each kind of GraphQL type.
	 */

	// eslint-disable-next-line no-redeclare
	function isScalarType(type) {
	  return instanceOf(type, GraphQLScalarType);
	}
	function assertScalarType(type) {
	  if (!isScalarType(type)) {
	    throw new Error("Expected ".concat(inspect$2(type), " to be a GraphQL Scalar type."));
	  }

	  return type;
	}
	// eslint-disable-next-line no-redeclare
	function isObjectType(type) {
	  return instanceOf(type, GraphQLObjectType);
	}
	function assertObjectType(type) {
	  if (!isObjectType(type)) {
	    throw new Error("Expected ".concat(inspect$2(type), " to be a GraphQL Object type."));
	  }

	  return type;
	}
	// eslint-disable-next-line no-redeclare
	function isInterfaceType(type) {
	  return instanceOf(type, GraphQLInterfaceType);
	}
	function assertInterfaceType(type) {
	  if (!isInterfaceType(type)) {
	    throw new Error("Expected ".concat(inspect$2(type), " to be a GraphQL Interface type."));
	  }

	  return type;
	}
	// eslint-disable-next-line no-redeclare
	function isUnionType(type) {
	  return instanceOf(type, GraphQLUnionType);
	}
	function assertUnionType(type) {
	  if (!isUnionType(type)) {
	    throw new Error("Expected ".concat(inspect$2(type), " to be a GraphQL Union type."));
	  }

	  return type;
	}
	// eslint-disable-next-line no-redeclare
	function isEnumType(type) {
	  return instanceOf(type, GraphQLEnumType);
	}
	function assertEnumType(type) {
	  if (!isEnumType(type)) {
	    throw new Error("Expected ".concat(inspect$2(type), " to be a GraphQL Enum type."));
	  }

	  return type;
	}
	// eslint-disable-next-line no-redeclare
	function isInputObjectType(type) {
	  return instanceOf(type, GraphQLInputObjectType);
	}
	function assertInputObjectType(type) {
	  if (!isInputObjectType(type)) {
	    throw new Error("Expected ".concat(inspect$2(type), " to be a GraphQL Input Object type."));
	  }

	  return type;
	}
	// eslint-disable-next-line no-redeclare
	function isListType(type) {
	  return instanceOf(type, GraphQLList);
	}
	function assertListType(type) {
	  if (!isListType(type)) {
	    throw new Error("Expected ".concat(inspect$2(type), " to be a GraphQL List type."));
	  }

	  return type;
	}
	// eslint-disable-next-line no-redeclare
	function isNonNullType(type) {
	  return instanceOf(type, GraphQLNonNull);
	}
	function assertNonNullType(type) {
	  if (!isNonNullType(type)) {
	    throw new Error("Expected ".concat(inspect$2(type), " to be a GraphQL Non-Null type."));
	  }

	  return type;
	}
	/**
	 * These types may be used as input types for arguments and directives.
	 */

	function isInputType(type) {
	  return isScalarType(type) || isEnumType(type) || isInputObjectType(type) || isWrappingType(type) && isInputType(type.ofType);
	}
	function assertInputType(type) {
	  if (!isInputType(type)) {
	    throw new Error("Expected ".concat(inspect$2(type), " to be a GraphQL input type."));
	  }

	  return type;
	}
	/**
	 * These types may be used as output types as the result of fields.
	 */

	function isOutputType(type) {
	  return isScalarType(type) || isObjectType(type) || isInterfaceType(type) || isUnionType(type) || isEnumType(type) || isWrappingType(type) && isOutputType(type.ofType);
	}
	function assertOutputType(type) {
	  if (!isOutputType(type)) {
	    throw new Error("Expected ".concat(inspect$2(type), " to be a GraphQL output type."));
	  }

	  return type;
	}
	/**
	 * These types may describe types which may be leaf values.
	 */

	function isLeafType(type) {
	  return isScalarType(type) || isEnumType(type);
	}
	function assertLeafType(type) {
	  if (!isLeafType(type)) {
	    throw new Error("Expected ".concat(inspect$2(type), " to be a GraphQL leaf type."));
	  }

	  return type;
	}
	/**
	 * These types may describe the parent context of a selection set.
	 */

	function isCompositeType(type) {
	  return isObjectType(type) || isInterfaceType(type) || isUnionType(type);
	}
	function assertCompositeType(type) {
	  if (!isCompositeType(type)) {
	    throw new Error("Expected ".concat(inspect$2(type), " to be a GraphQL composite type."));
	  }

	  return type;
	}
	/**
	 * These types may describe the parent context of a selection set.
	 */

	function isAbstractType(type) {
	  return isInterfaceType(type) || isUnionType(type);
	}
	function assertAbstractType(type) {
	  if (!isAbstractType(type)) {
	    throw new Error("Expected ".concat(inspect$2(type), " to be a GraphQL abstract type."));
	  }

	  return type;
	}
	/**
	 * List Type Wrapper
	 *
	 * A list is a wrapping type which points to another type.
	 * Lists are often created within the context of defining the fields of
	 * an object type.
	 *
	 * Example:
	 *
	 *     const PersonType = new GraphQLObjectType({
	 *       name: 'Person',
	 *       fields: () => ({
	 *         parents: { type: new GraphQLList(PersonType) },
	 *         children: { type: new GraphQLList(PersonType) },
	 *       })
	 *     })
	 *
	 */
	// FIXME: workaround to fix issue with Babel parser

	/* ::
	declare class GraphQLList<+T: GraphQLType> {
	  +ofType: T;
	  static <T>(ofType: T): GraphQLList<T>;
	  // Note: constructors cannot be used for covariant types. Drop the "new".
	  constructor(ofType: GraphQLType): void;
	}
	*/

	function GraphQLList(ofType) {
	  // istanbul ignore else (to be removed in v16.0.0)
	  if (this instanceof GraphQLList) {
	    this.ofType = assertType(ofType);
	  } else {
	    return new GraphQLList(ofType);
	  }
	} // Need to cast through any to alter the prototype.

	GraphQLList.prototype.toString = function toString() {
	  return '[' + String(this.ofType) + ']';
	};

	GraphQLList.prototype.toJSON = function toJSON() {
	  return this.toString();
	};

	Object.defineProperty(GraphQLList.prototype, SYMBOL_TO_STRING_TAG, {
	  get: function get() {
	    return 'GraphQLList';
	  }
	}); // Print a simplified form when appearing in `inspect` and `util.inspect`.

	defineInspect(GraphQLList);
	/**
	 * Non-Null Type Wrapper
	 *
	 * A non-null is a wrapping type which points to another type.
	 * Non-null types enforce that their values are never null and can ensure
	 * an error is raised if this ever occurs during a request. It is useful for
	 * fields which you can make a strong guarantee on non-nullability, for example
	 * usually the id field of a database row will never be null.
	 *
	 * Example:
	 *
	 *     const RowType = new GraphQLObjectType({
	 *       name: 'Row',
	 *       fields: () => ({
	 *         id: { type: new GraphQLNonNull(GraphQLString) },
	 *       })
	 *     })
	 *
	 * Note: the enforcement of non-nullability occurs within the executor.
	 */
	// FIXME: workaround to fix issue with Babel parser

	/* ::
	declare class GraphQLNonNull<+T: GraphQLNullableType> {
	  +ofType: T;
	  static <T>(ofType: T): GraphQLNonNull<T>;
	  // Note: constructors cannot be used for covariant types. Drop the "new".
	  constructor(ofType: GraphQLType): void;
	}
	*/

	function GraphQLNonNull(ofType) {
	  // istanbul ignore else (to be removed in v16.0.0)
	  if (this instanceof GraphQLNonNull) {
	    this.ofType = assertNullableType(ofType);
	  } else {
	    return new GraphQLNonNull(ofType);
	  }
	} // Need to cast through any to alter the prototype.

	GraphQLNonNull.prototype.toString = function toString() {
	  return String(this.ofType) + '!';
	};

	GraphQLNonNull.prototype.toJSON = function toJSON() {
	  return this.toString();
	};

	Object.defineProperty(GraphQLNonNull.prototype, SYMBOL_TO_STRING_TAG, {
	  get: function get() {
	    return 'GraphQLNonNull';
	  }
	}); // Print a simplified form when appearing in `inspect` and `util.inspect`.

	defineInspect(GraphQLNonNull);
	/**
	 * These types wrap and modify other types
	 */

	function isWrappingType(type) {
	  return isListType(type) || isNonNullType(type);
	}
	function assertWrappingType(type) {
	  if (!isWrappingType(type)) {
	    throw new Error("Expected ".concat(inspect$2(type), " to be a GraphQL wrapping type."));
	  }

	  return type;
	}
	/**
	 * These types can all accept null as a value.
	 */

	function isNullableType(type) {
	  return isType(type) && !isNonNullType(type);
	}
	function assertNullableType(type) {
	  if (!isNullableType(type)) {
	    throw new Error("Expected ".concat(inspect$2(type), " to be a GraphQL nullable type."));
	  }

	  return type;
	}
	/* eslint-disable no-redeclare */

	function getNullableType(type) {
	  /* eslint-enable no-redeclare */
	  if (type) {
	    return isNonNullType(type) ? type.ofType : type;
	  }
	}
	/**
	 * These named types do not include modifiers like List or NonNull.
	 */

	function isNamedType(type) {
	  return isScalarType(type) || isObjectType(type) || isInterfaceType(type) || isUnionType(type) || isEnumType(type) || isInputObjectType(type);
	}
	function assertNamedType(type) {
	  if (!isNamedType(type)) {
	    throw new Error("Expected ".concat(inspect$2(type), " to be a GraphQL named type."));
	  }

	  return type;
	}
	/* eslint-disable no-redeclare */

	function getNamedType(type) {
	  /* eslint-enable no-redeclare */
	  if (type) {
	    var unwrappedType = type;

	    while (isWrappingType(unwrappedType)) {
	      unwrappedType = unwrappedType.ofType;
	    }

	    return unwrappedType;
	  }
	}
	/**
	 * Used while defining GraphQL types to allow for circular references in
	 * otherwise immutable type definitions.
	 */

	function resolveThunk(thunk) {
	  // $FlowFixMe[incompatible-use]
	  return typeof thunk === 'function' ? thunk() : thunk;
	}

	function undefineIfEmpty(arr) {
	  return arr && arr.length > 0 ? arr : undefined;
	}
	/**
	 * Scalar Type Definition
	 *
	 * The leaf values of any request and input values to arguments are
	 * Scalars (or Enums) and are defined with a name and a series of functions
	 * used to parse input from ast or variables and to ensure validity.
	 *
	 * If a type's serialize function does not return a value (i.e. it returns
	 * `undefined`) then an error will be raised and a `null` value will be returned
	 * in the response. If the serialize function returns `null`, then no error will
	 * be included in the response.
	 *
	 * Example:
	 *
	 *     const OddType = new GraphQLScalarType({
	 *       name: 'Odd',
	 *       serialize(value) {
	 *         if (value % 2 === 1) {
	 *           return value;
	 *         }
	 *       }
	 *     });
	 *
	 */


	var GraphQLScalarType = /*#__PURE__*/function () {
	  function GraphQLScalarType(config) {
	    var _config$parseValue, _config$serialize, _config$parseLiteral;

	    var parseValue = (_config$parseValue = config.parseValue) !== null && _config$parseValue !== void 0 ? _config$parseValue : identityFunc;
	    this.name = config.name;
	    this.description = config.description;
	    this.specifiedByUrl = config.specifiedByUrl;
	    this.serialize = (_config$serialize = config.serialize) !== null && _config$serialize !== void 0 ? _config$serialize : identityFunc;
	    this.parseValue = parseValue;
	    this.parseLiteral = (_config$parseLiteral = config.parseLiteral) !== null && _config$parseLiteral !== void 0 ? _config$parseLiteral : function (node, variables) {
	      return parseValue(valueFromASTUntyped$1(node, variables));
	    };
	    this.extensions = config.extensions && toObjMap(config.extensions);
	    this.astNode = config.astNode;
	    this.extensionASTNodes = undefineIfEmpty(config.extensionASTNodes);
	    typeof config.name === 'string' || devAssert(0, 'Must provide name.');
	    config.specifiedByUrl == null || typeof config.specifiedByUrl === 'string' || devAssert(0, "".concat(this.name, " must provide \"specifiedByUrl\" as a string, ") + "but got: ".concat(inspect$2(config.specifiedByUrl), "."));
	    config.serialize == null || typeof config.serialize === 'function' || devAssert(0, "".concat(this.name, " must provide \"serialize\" function. If this custom Scalar is also used as an input type, ensure \"parseValue\" and \"parseLiteral\" functions are also provided."));

	    if (config.parseLiteral) {
	      typeof config.parseValue === 'function' && typeof config.parseLiteral === 'function' || devAssert(0, "".concat(this.name, " must provide both \"parseValue\" and \"parseLiteral\" functions."));
	    }
	  }

	  var _proto = GraphQLScalarType.prototype;

	  _proto.toConfig = function toConfig() {
	    var _this$extensionASTNod;

	    return {
	      name: this.name,
	      description: this.description,
	      specifiedByUrl: this.specifiedByUrl,
	      serialize: this.serialize,
	      parseValue: this.parseValue,
	      parseLiteral: this.parseLiteral,
	      extensions: this.extensions,
	      astNode: this.astNode,
	      extensionASTNodes: (_this$extensionASTNod = this.extensionASTNodes) !== null && _this$extensionASTNod !== void 0 ? _this$extensionASTNod : []
	    };
	  };

	  _proto.toString = function toString() {
	    return this.name;
	  };

	  _proto.toJSON = function toJSON() {
	    return this.toString();
	  } // $FlowFixMe[unsupported-syntax] Flow doesn't support computed properties yet
	  ;

	  _createClass$2(GraphQLScalarType, [{
	    key: SYMBOL_TO_STRING_TAG,
	    get: function get() {
	      return 'GraphQLScalarType';
	    }
	  }]);

	  return GraphQLScalarType;
	}(); // Print a simplified form when appearing in `inspect` and `util.inspect`.

	defineInspect(GraphQLScalarType);

	/**
	 * Object Type Definition
	 *
	 * Almost all of the GraphQL types you define will be object types. Object types
	 * have a name, but most importantly describe their fields.
	 *
	 * Example:
	 *
	 *     const AddressType = new GraphQLObjectType({
	 *       name: 'Address',
	 *       fields: {
	 *         street: { type: GraphQLString },
	 *         number: { type: GraphQLInt },
	 *         formatted: {
	 *           type: GraphQLString,
	 *           resolve(obj) {
	 *             return obj.number + ' ' + obj.street
	 *           }
	 *         }
	 *       }
	 *     });
	 *
	 * When two types need to refer to each other, or a type needs to refer to
	 * itself in a field, you can use a function expression (aka a closure or a
	 * thunk) to supply the fields lazily.
	 *
	 * Example:
	 *
	 *     const PersonType = new GraphQLObjectType({
	 *       name: 'Person',
	 *       fields: () => ({
	 *         name: { type: GraphQLString },
	 *         bestFriend: { type: PersonType },
	 *       })
	 *     });
	 *
	 */
	var GraphQLObjectType = /*#__PURE__*/function () {
	  function GraphQLObjectType(config) {
	    this.name = config.name;
	    this.description = config.description;
	    this.isTypeOf = config.isTypeOf;
	    this.extensions = config.extensions && toObjMap(config.extensions);
	    this.astNode = config.astNode;
	    this.extensionASTNodes = undefineIfEmpty(config.extensionASTNodes);
	    this._fields = defineFieldMap.bind(undefined, config);
	    this._interfaces = defineInterfaces.bind(undefined, config);
	    typeof config.name === 'string' || devAssert(0, 'Must provide name.');
	    config.isTypeOf == null || typeof config.isTypeOf === 'function' || devAssert(0, "".concat(this.name, " must provide \"isTypeOf\" as a function, ") + "but got: ".concat(inspect$2(config.isTypeOf), "."));
	  }

	  var _proto2 = GraphQLObjectType.prototype;

	  _proto2.getFields = function getFields() {
	    if (typeof this._fields === 'function') {
	      this._fields = this._fields();
	    }

	    return this._fields;
	  };

	  _proto2.getInterfaces = function getInterfaces() {
	    if (typeof this._interfaces === 'function') {
	      this._interfaces = this._interfaces();
	    }

	    return this._interfaces;
	  };

	  _proto2.toConfig = function toConfig() {
	    return {
	      name: this.name,
	      description: this.description,
	      interfaces: this.getInterfaces(),
	      fields: fieldsToFieldsConfig(this.getFields()),
	      isTypeOf: this.isTypeOf,
	      extensions: this.extensions,
	      astNode: this.astNode,
	      extensionASTNodes: this.extensionASTNodes || []
	    };
	  };

	  _proto2.toString = function toString() {
	    return this.name;
	  };

	  _proto2.toJSON = function toJSON() {
	    return this.toString();
	  } // $FlowFixMe[unsupported-syntax] Flow doesn't support computed properties yet
	  ;

	  _createClass$2(GraphQLObjectType, [{
	    key: SYMBOL_TO_STRING_TAG,
	    get: function get() {
	      return 'GraphQLObjectType';
	    }
	  }]);

	  return GraphQLObjectType;
	}(); // Print a simplified form when appearing in `inspect` and `util.inspect`.

	defineInspect(GraphQLObjectType);

	function defineInterfaces(config) {
	  var _resolveThunk;

	  var interfaces = (_resolveThunk = resolveThunk(config.interfaces)) !== null && _resolveThunk !== void 0 ? _resolveThunk : [];
	  Array.isArray(interfaces) || devAssert(0, "".concat(config.name, " interfaces must be an Array or a function which returns an Array."));
	  return interfaces;
	}

	function defineFieldMap(config) {
	  var fieldMap = resolveThunk(config.fields);
	  isPlainObj(fieldMap) || devAssert(0, "".concat(config.name, " fields must be an object with field names as keys or a function which returns such an object."));
	  return mapValue(fieldMap, function (fieldConfig, fieldName) {
	    var _fieldConfig$args;

	    isPlainObj(fieldConfig) || devAssert(0, "".concat(config.name, ".").concat(fieldName, " field config must be an object."));
	    !('isDeprecated' in fieldConfig) || devAssert(0, "".concat(config.name, ".").concat(fieldName, " should provide \"deprecationReason\" instead of \"isDeprecated\"."));
	    fieldConfig.resolve == null || typeof fieldConfig.resolve === 'function' || devAssert(0, "".concat(config.name, ".").concat(fieldName, " field resolver must be a function if ") + "provided, but got: ".concat(inspect$2(fieldConfig.resolve), "."));
	    var argsConfig = (_fieldConfig$args = fieldConfig.args) !== null && _fieldConfig$args !== void 0 ? _fieldConfig$args : {};
	    isPlainObj(argsConfig) || devAssert(0, "".concat(config.name, ".").concat(fieldName, " args must be an object with argument names as keys."));
	    var args = objectEntries$1(argsConfig).map(function (_ref) {
	      var argName = _ref[0],
	          argConfig = _ref[1];
	      return {
	        name: argName,
	        description: argConfig.description,
	        type: argConfig.type,
	        defaultValue: argConfig.defaultValue,
	        deprecationReason: argConfig.deprecationReason,
	        extensions: argConfig.extensions && toObjMap(argConfig.extensions),
	        astNode: argConfig.astNode
	      };
	    });
	    return {
	      name: fieldName,
	      description: fieldConfig.description,
	      type: fieldConfig.type,
	      args: args,
	      resolve: fieldConfig.resolve,
	      subscribe: fieldConfig.subscribe,
	      isDeprecated: fieldConfig.deprecationReason != null,
	      deprecationReason: fieldConfig.deprecationReason,
	      extensions: fieldConfig.extensions && toObjMap(fieldConfig.extensions),
	      astNode: fieldConfig.astNode
	    };
	  });
	}

	function isPlainObj(obj) {
	  return isObjectLike(obj) && !Array.isArray(obj);
	}

	function fieldsToFieldsConfig(fields) {
	  return mapValue(fields, function (field) {
	    return {
	      description: field.description,
	      type: field.type,
	      args: argsToArgsConfig(field.args),
	      resolve: field.resolve,
	      subscribe: field.subscribe,
	      deprecationReason: field.deprecationReason,
	      extensions: field.extensions,
	      astNode: field.astNode
	    };
	  });
	}
	/**
	 * @internal
	 */


	function argsToArgsConfig(args) {
	  return keyValMap(args, function (arg) {
	    return arg.name;
	  }, function (arg) {
	    return {
	      description: arg.description,
	      type: arg.type,
	      defaultValue: arg.defaultValue,
	      deprecationReason: arg.deprecationReason,
	      extensions: arg.extensions,
	      astNode: arg.astNode
	    };
	  });
	}
	function isRequiredArgument(arg) {
	  return isNonNullType(arg.type) && arg.defaultValue === undefined;
	}

	/**
	 * Interface Type Definition
	 *
	 * When a field can return one of a heterogeneous set of types, a Interface type
	 * is used to describe what types are possible, what fields are in common across
	 * all types, as well as a function to determine which type is actually used
	 * when the field is resolved.
	 *
	 * Example:
	 *
	 *     const EntityType = new GraphQLInterfaceType({
	 *       name: 'Entity',
	 *       fields: {
	 *         name: { type: GraphQLString }
	 *       }
	 *     });
	 *
	 */
	var GraphQLInterfaceType = /*#__PURE__*/function () {
	  function GraphQLInterfaceType(config) {
	    this.name = config.name;
	    this.description = config.description;
	    this.resolveType = config.resolveType;
	    this.extensions = config.extensions && toObjMap(config.extensions);
	    this.astNode = config.astNode;
	    this.extensionASTNodes = undefineIfEmpty(config.extensionASTNodes);
	    this._fields = defineFieldMap.bind(undefined, config);
	    this._interfaces = defineInterfaces.bind(undefined, config);
	    typeof config.name === 'string' || devAssert(0, 'Must provide name.');
	    config.resolveType == null || typeof config.resolveType === 'function' || devAssert(0, "".concat(this.name, " must provide \"resolveType\" as a function, ") + "but got: ".concat(inspect$2(config.resolveType), "."));
	  }

	  var _proto3 = GraphQLInterfaceType.prototype;

	  _proto3.getFields = function getFields() {
	    if (typeof this._fields === 'function') {
	      this._fields = this._fields();
	    }

	    return this._fields;
	  };

	  _proto3.getInterfaces = function getInterfaces() {
	    if (typeof this._interfaces === 'function') {
	      this._interfaces = this._interfaces();
	    }

	    return this._interfaces;
	  };

	  _proto3.toConfig = function toConfig() {
	    var _this$extensionASTNod2;

	    return {
	      name: this.name,
	      description: this.description,
	      interfaces: this.getInterfaces(),
	      fields: fieldsToFieldsConfig(this.getFields()),
	      resolveType: this.resolveType,
	      extensions: this.extensions,
	      astNode: this.astNode,
	      extensionASTNodes: (_this$extensionASTNod2 = this.extensionASTNodes) !== null && _this$extensionASTNod2 !== void 0 ? _this$extensionASTNod2 : []
	    };
	  };

	  _proto3.toString = function toString() {
	    return this.name;
	  };

	  _proto3.toJSON = function toJSON() {
	    return this.toString();
	  } // $FlowFixMe[unsupported-syntax] Flow doesn't support computed properties yet
	  ;

	  _createClass$2(GraphQLInterfaceType, [{
	    key: SYMBOL_TO_STRING_TAG,
	    get: function get() {
	      return 'GraphQLInterfaceType';
	    }
	  }]);

	  return GraphQLInterfaceType;
	}(); // Print a simplified form when appearing in `inspect` and `util.inspect`.

	defineInspect(GraphQLInterfaceType);

	/**
	 * Union Type Definition
	 *
	 * When a field can return one of a heterogeneous set of types, a Union type
	 * is used to describe what types are possible as well as providing a function
	 * to determine which type is actually used when the field is resolved.
	 *
	 * Example:
	 *
	 *     const PetType = new GraphQLUnionType({
	 *       name: 'Pet',
	 *       types: [ DogType, CatType ],
	 *       resolveType(value) {
	 *         if (value instanceof Dog) {
	 *           return DogType;
	 *         }
	 *         if (value instanceof Cat) {
	 *           return CatType;
	 *         }
	 *       }
	 *     });
	 *
	 */
	var GraphQLUnionType = /*#__PURE__*/function () {
	  function GraphQLUnionType(config) {
	    this.name = config.name;
	    this.description = config.description;
	    this.resolveType = config.resolveType;
	    this.extensions = config.extensions && toObjMap(config.extensions);
	    this.astNode = config.astNode;
	    this.extensionASTNodes = undefineIfEmpty(config.extensionASTNodes);
	    this._types = defineTypes.bind(undefined, config);
	    typeof config.name === 'string' || devAssert(0, 'Must provide name.');
	    config.resolveType == null || typeof config.resolveType === 'function' || devAssert(0, "".concat(this.name, " must provide \"resolveType\" as a function, ") + "but got: ".concat(inspect$2(config.resolveType), "."));
	  }

	  var _proto4 = GraphQLUnionType.prototype;

	  _proto4.getTypes = function getTypes() {
	    if (typeof this._types === 'function') {
	      this._types = this._types();
	    }

	    return this._types;
	  };

	  _proto4.toConfig = function toConfig() {
	    var _this$extensionASTNod3;

	    return {
	      name: this.name,
	      description: this.description,
	      types: this.getTypes(),
	      resolveType: this.resolveType,
	      extensions: this.extensions,
	      astNode: this.astNode,
	      extensionASTNodes: (_this$extensionASTNod3 = this.extensionASTNodes) !== null && _this$extensionASTNod3 !== void 0 ? _this$extensionASTNod3 : []
	    };
	  };

	  _proto4.toString = function toString() {
	    return this.name;
	  };

	  _proto4.toJSON = function toJSON() {
	    return this.toString();
	  } // $FlowFixMe[unsupported-syntax] Flow doesn't support computed properties yet
	  ;

	  _createClass$2(GraphQLUnionType, [{
	    key: SYMBOL_TO_STRING_TAG,
	    get: function get() {
	      return 'GraphQLUnionType';
	    }
	  }]);

	  return GraphQLUnionType;
	}(); // Print a simplified form when appearing in `inspect` and `util.inspect`.

	defineInspect(GraphQLUnionType);

	function defineTypes(config) {
	  var types = resolveThunk(config.types);
	  Array.isArray(types) || devAssert(0, "Must provide Array of types or a function which returns such an array for Union ".concat(config.name, "."));
	  return types;
	}

	/**
	 * Enum Type Definition
	 *
	 * Some leaf values of requests and input values are Enums. GraphQL serializes
	 * Enum values as strings, however internally Enums can be represented by any
	 * kind of type, often integers.
	 *
	 * Example:
	 *
	 *     const RGBType = new GraphQLEnumType({
	 *       name: 'RGB',
	 *       values: {
	 *         RED: { value: 0 },
	 *         GREEN: { value: 1 },
	 *         BLUE: { value: 2 }
	 *       }
	 *     });
	 *
	 * Note: If a value is not provided in a definition, the name of the enum value
	 * will be used as its internal value.
	 */
	var GraphQLEnumType
	/* <T> */
	= /*#__PURE__*/function () {
	  function GraphQLEnumType(config) {
	    this.name = config.name;
	    this.description = config.description;
	    this.extensions = config.extensions && toObjMap(config.extensions);
	    this.astNode = config.astNode;
	    this.extensionASTNodes = undefineIfEmpty(config.extensionASTNodes);
	    this._values = defineEnumValues(this.name, config.values);
	    this._valueLookup = new Map(this._values.map(function (enumValue) {
	      return [enumValue.value, enumValue];
	    }));
	    this._nameLookup = keyMap(this._values, function (value) {
	      return value.name;
	    });
	    typeof config.name === 'string' || devAssert(0, 'Must provide name.');
	  }

	  var _proto5 = GraphQLEnumType.prototype;

	  _proto5.getValues = function getValues() {
	    return this._values;
	  };

	  _proto5.getValue = function getValue(name) {
	    return this._nameLookup[name];
	  };

	  _proto5.serialize = function serialize(outputValue) {
	    var enumValue = this._valueLookup.get(outputValue);

	    if (enumValue === undefined) {
	      throw new GraphQLError("Enum \"".concat(this.name, "\" cannot represent value: ").concat(inspect$2(outputValue)));
	    }

	    return enumValue.name;
	  };

	  _proto5.parseValue = function parseValue(inputValue)
	  /* T */
	  {
	    if (typeof inputValue !== 'string') {
	      var valueStr = inspect$2(inputValue);
	      throw new GraphQLError("Enum \"".concat(this.name, "\" cannot represent non-string value: ").concat(valueStr, ".") + didYouMeanEnumValue(this, valueStr));
	    }

	    var enumValue = this.getValue(inputValue);

	    if (enumValue == null) {
	      throw new GraphQLError("Value \"".concat(inputValue, "\" does not exist in \"").concat(this.name, "\" enum.") + didYouMeanEnumValue(this, inputValue));
	    }

	    return enumValue.value;
	  };

	  _proto5.parseLiteral = function parseLiteral(valueNode, _variables)
	  /* T */
	  {
	    // Note: variables will be resolved to a value before calling this function.
	    if (valueNode.kind !== Kind.ENUM) {
	      var valueStr = print$1(valueNode);
	      throw new GraphQLError("Enum \"".concat(this.name, "\" cannot represent non-enum value: ").concat(valueStr, ".") + didYouMeanEnumValue(this, valueStr), valueNode);
	    }

	    var enumValue = this.getValue(valueNode.value);

	    if (enumValue == null) {
	      var _valueStr = print$1(valueNode);

	      throw new GraphQLError("Value \"".concat(_valueStr, "\" does not exist in \"").concat(this.name, "\" enum.") + didYouMeanEnumValue(this, _valueStr), valueNode);
	    }

	    return enumValue.value;
	  };

	  _proto5.toConfig = function toConfig() {
	    var _this$extensionASTNod4;

	    var values = keyValMap(this.getValues(), function (value) {
	      return value.name;
	    }, function (value) {
	      return {
	        description: value.description,
	        value: value.value,
	        deprecationReason: value.deprecationReason,
	        extensions: value.extensions,
	        astNode: value.astNode
	      };
	    });
	    return {
	      name: this.name,
	      description: this.description,
	      values: values,
	      extensions: this.extensions,
	      astNode: this.astNode,
	      extensionASTNodes: (_this$extensionASTNod4 = this.extensionASTNodes) !== null && _this$extensionASTNod4 !== void 0 ? _this$extensionASTNod4 : []
	    };
	  };

	  _proto5.toString = function toString() {
	    return this.name;
	  };

	  _proto5.toJSON = function toJSON() {
	    return this.toString();
	  } // $FlowFixMe[unsupported-syntax] Flow doesn't support computed properties yet
	  ;

	  _createClass$2(GraphQLEnumType, [{
	    key: SYMBOL_TO_STRING_TAG,
	    get: function get() {
	      return 'GraphQLEnumType';
	    }
	  }]);

	  return GraphQLEnumType;
	}(); // Print a simplified form when appearing in `inspect` and `util.inspect`.

	defineInspect(GraphQLEnumType);

	function didYouMeanEnumValue(enumType, unknownValueStr) {
	  var allNames = enumType.getValues().map(function (value) {
	    return value.name;
	  });
	  var suggestedValues = suggestionList$1(unknownValueStr, allNames);
	  return didYouMean$1('the enum value', suggestedValues);
	}

	function defineEnumValues(typeName, valueMap) {
	  isPlainObj(valueMap) || devAssert(0, "".concat(typeName, " values must be an object with value names as keys."));
	  return objectEntries$1(valueMap).map(function (_ref2) {
	    var valueName = _ref2[0],
	        valueConfig = _ref2[1];
	    isPlainObj(valueConfig) || devAssert(0, "".concat(typeName, ".").concat(valueName, " must refer to an object with a \"value\" key ") + "representing an internal value but got: ".concat(inspect$2(valueConfig), "."));
	    !('isDeprecated' in valueConfig) || devAssert(0, "".concat(typeName, ".").concat(valueName, " should provide \"deprecationReason\" instead of \"isDeprecated\"."));
	    return {
	      name: valueName,
	      description: valueConfig.description,
	      value: valueConfig.value !== undefined ? valueConfig.value : valueName,
	      isDeprecated: valueConfig.deprecationReason != null,
	      deprecationReason: valueConfig.deprecationReason,
	      extensions: valueConfig.extensions && toObjMap(valueConfig.extensions),
	      astNode: valueConfig.astNode
	    };
	  });
	}

	/**
	 * Input Object Type Definition
	 *
	 * An input object defines a structured collection of fields which may be
	 * supplied to a field argument.
	 *
	 * Using `NonNull` will ensure that a value must be provided by the query
	 *
	 * Example:
	 *
	 *     const GeoPoint = new GraphQLInputObjectType({
	 *       name: 'GeoPoint',
	 *       fields: {
	 *         lat: { type: new GraphQLNonNull(GraphQLFloat) },
	 *         lon: { type: new GraphQLNonNull(GraphQLFloat) },
	 *         alt: { type: GraphQLFloat, defaultValue: 0 },
	 *       }
	 *     });
	 *
	 */
	var GraphQLInputObjectType = /*#__PURE__*/function () {
	  function GraphQLInputObjectType(config) {
	    this.name = config.name;
	    this.description = config.description;
	    this.extensions = config.extensions && toObjMap(config.extensions);
	    this.astNode = config.astNode;
	    this.extensionASTNodes = undefineIfEmpty(config.extensionASTNodes);
	    this._fields = defineInputFieldMap.bind(undefined, config);
	    typeof config.name === 'string' || devAssert(0, 'Must provide name.');
	  }

	  var _proto6 = GraphQLInputObjectType.prototype;

	  _proto6.getFields = function getFields() {
	    if (typeof this._fields === 'function') {
	      this._fields = this._fields();
	    }

	    return this._fields;
	  };

	  _proto6.toConfig = function toConfig() {
	    var _this$extensionASTNod5;

	    var fields = mapValue(this.getFields(), function (field) {
	      return {
	        description: field.description,
	        type: field.type,
	        defaultValue: field.defaultValue,
	        deprecationReason: field.deprecationReason,
	        extensions: field.extensions,
	        astNode: field.astNode
	      };
	    });
	    return {
	      name: this.name,
	      description: this.description,
	      fields: fields,
	      extensions: this.extensions,
	      astNode: this.astNode,
	      extensionASTNodes: (_this$extensionASTNod5 = this.extensionASTNodes) !== null && _this$extensionASTNod5 !== void 0 ? _this$extensionASTNod5 : []
	    };
	  };

	  _proto6.toString = function toString() {
	    return this.name;
	  };

	  _proto6.toJSON = function toJSON() {
	    return this.toString();
	  } // $FlowFixMe[unsupported-syntax] Flow doesn't support computed properties yet
	  ;

	  _createClass$2(GraphQLInputObjectType, [{
	    key: SYMBOL_TO_STRING_TAG,
	    get: function get() {
	      return 'GraphQLInputObjectType';
	    }
	  }]);

	  return GraphQLInputObjectType;
	}(); // Print a simplified form when appearing in `inspect` and `util.inspect`.

	defineInspect(GraphQLInputObjectType);

	function defineInputFieldMap(config) {
	  var fieldMap = resolveThunk(config.fields);
	  isPlainObj(fieldMap) || devAssert(0, "".concat(config.name, " fields must be an object with field names as keys or a function which returns such an object."));
	  return mapValue(fieldMap, function (fieldConfig, fieldName) {
	    !('resolve' in fieldConfig) || devAssert(0, "".concat(config.name, ".").concat(fieldName, " field has a resolve property, but Input Types cannot define resolvers."));
	    return {
	      name: fieldName,
	      description: fieldConfig.description,
	      type: fieldConfig.type,
	      defaultValue: fieldConfig.defaultValue,
	      deprecationReason: fieldConfig.deprecationReason,
	      extensions: fieldConfig.extensions && toObjMap(fieldConfig.extensions),
	      astNode: fieldConfig.astNode
	    };
	  });
	}

	function isRequiredInputField(field) {
	  return isNonNullType(field.type) && field.defaultValue === undefined;
	}

	/**
	 * Provided two types, return true if the types are equal (invariant).
	 */

	function isEqualType(typeA, typeB) {
	  // Equivalent types are equal.
	  if (typeA === typeB) {
	    return true;
	  } // If either type is non-null, the other must also be non-null.


	  if (isNonNullType(typeA) && isNonNullType(typeB)) {
	    return isEqualType(typeA.ofType, typeB.ofType);
	  } // If either type is a list, the other must also be a list.


	  if (isListType(typeA) && isListType(typeB)) {
	    return isEqualType(typeA.ofType, typeB.ofType);
	  } // Otherwise the types are not equal.


	  return false;
	}
	/**
	 * Provided a type and a super type, return true if the first type is either
	 * equal or a subset of the second super type (covariant).
	 */

	function isTypeSubTypeOf(schema, maybeSubType, superType) {
	  // Equivalent type is a valid subtype
	  if (maybeSubType === superType) {
	    return true;
	  } // If superType is non-null, maybeSubType must also be non-null.


	  if (isNonNullType(superType)) {
	    if (isNonNullType(maybeSubType)) {
	      return isTypeSubTypeOf(schema, maybeSubType.ofType, superType.ofType);
	    }

	    return false;
	  }

	  if (isNonNullType(maybeSubType)) {
	    // If superType is nullable, maybeSubType may be non-null or nullable.
	    return isTypeSubTypeOf(schema, maybeSubType.ofType, superType);
	  } // If superType type is a list, maybeSubType type must also be a list.


	  if (isListType(superType)) {
	    if (isListType(maybeSubType)) {
	      return isTypeSubTypeOf(schema, maybeSubType.ofType, superType.ofType);
	    }

	    return false;
	  }

	  if (isListType(maybeSubType)) {
	    // If superType is not a list, maybeSubType must also be not a list.
	    return false;
	  } // If superType type is an abstract type, check if it is super type of maybeSubType.
	  // Otherwise, the child type is not a valid subtype of the parent type.


	  return isAbstractType(superType) && (isInterfaceType(maybeSubType) || isObjectType(maybeSubType)) && schema.isSubType(superType, maybeSubType);
	}
	/**
	 * Provided two composite types, determine if they "overlap". Two composite
	 * types overlap when the Sets of possible concrete types for each intersect.
	 *
	 * This is often used to determine if a fragment of a given type could possibly
	 * be visited in a context of another type.
	 *
	 * This function is commutative.
	 */

	function doTypesOverlap(schema, typeA, typeB) {
	  // Equivalent types overlap
	  if (typeA === typeB) {
	    return true;
	  }

	  if (isAbstractType(typeA)) {
	    if (isAbstractType(typeB)) {
	      // If both types are abstract, then determine if there is any intersection
	      // between possible concrete types of each.
	      return schema.getPossibleTypes(typeA).some(function (type) {
	        return schema.isSubType(typeB, type);
	      });
	    } // Determine if the latter type is a possible concrete type of the former.


	    return schema.isSubType(typeA, typeB);
	  }

	  if (isAbstractType(typeB)) {
	    // Determine if the former type is a possible concrete type of the latter.
	    return schema.isSubType(typeB, typeA);
	  } // Otherwise the types do not overlap.


	  return false;
	}

	/* eslint-disable no-redeclare */
	// $FlowFixMe[name-already-bound]
	var arrayFrom = Array.from || function (obj, mapFn, thisArg) {
	  if (obj == null) {
	    throw new TypeError('Array.from requires an array-like object - not null or undefined');
	  } // Is Iterable?


	  var iteratorMethod = obj[SYMBOL_ITERATOR];

	  if (typeof iteratorMethod === 'function') {
	    var iterator = iteratorMethod.call(obj);
	    var result = [];
	    var step;

	    for (var i = 0; !(step = iterator.next()).done; ++i) {
	      result.push(mapFn.call(thisArg, step.value, i)); // Infinite Iterators could cause forEach to run forever.
	      // After a very large number of iterations, produce an error.
	      // istanbul ignore if (Too big to actually test)

	      if (i > 9999999) {
	        throw new TypeError('Near-infinite iteration.');
	      }
	    }

	    return result;
	  } // Is Array like?


	  var length = obj.length;

	  if (typeof length === 'number' && length >= 0 && length % 1 === 0) {
	    var _result = [];

	    for (var _i = 0; _i < length; ++_i) {
	      if (Object.prototype.hasOwnProperty.call(obj, _i)) {
	        _result.push(mapFn.call(thisArg, obj[_i], _i));
	      }
	    }

	    return _result;
	  }

	  return [];
	};

	var arrayFrom$1 = arrayFrom;

	/* eslint-disable no-redeclare */
	// $FlowFixMe[name-already-bound] workaround for: https://github.com/facebook/flow/issues/4441
	var isFinitePolyfill = Number.isFinite || function (value) {
	  return typeof value === 'number' && isFinite(value);
	};

	var isFinite$1 = isFinitePolyfill;

	function _typeof(obj) { "@babel/helpers - typeof"; if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }
	/**
	 * Safer version of `Array.from` that return `null` if value isn't convertible to array.
	 * Also protects against Array-like objects without items.
	 *
	 * @example
	 *
	 * safeArrayFrom([ 1, 2, 3 ]) // [1, 2, 3]
	 * safeArrayFrom('ABC') // null
	 * safeArrayFrom({ length: 1 }) // null
	 * safeArrayFrom({ length: 1, 0: 'Alpha' }) // ['Alpha']
	 * safeArrayFrom({ key: 'value' }) // null
	 * safeArrayFrom(new Map()) // []
	 *
	 */

	function safeArrayFrom(collection) {
	  var mapFn = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : function (item) {
	    return item;
	  };

	  if (collection == null || _typeof(collection) !== 'object') {
	    return null;
	  }

	  if (Array.isArray(collection)) {
	    return collection.map(mapFn);
	  } // Is Iterable?


	  var iteratorMethod = collection[SYMBOL_ITERATOR];

	  if (typeof iteratorMethod === 'function') {
	    // $FlowFixMe[incompatible-use]
	    var iterator = iteratorMethod.call(collection);
	    var result = [];
	    var step;

	    for (var i = 0; !(step = iterator.next()).done; ++i) {
	      result.push(mapFn(step.value, i));
	    }

	    return result;
	  } // Is Array like?


	  var length = collection.length;

	  if (typeof length === 'number' && length >= 0 && length % 1 === 0) {
	    var _result = [];

	    for (var _i = 0; _i < length; ++_i) {
	      if (!Object.prototype.hasOwnProperty.call(collection, _i)) {
	        return null;
	      }

	      _result.push(mapFn(collection[String(_i)], _i));
	    }

	    return _result;
	  }

	  return null;
	}

	/* eslint-disable no-redeclare */
	// $FlowFixMe[name-already-bound] workaround for: https://github.com/facebook/flow/issues/4441
	var isInteger = Number.isInteger || function (value) {
	  return typeof value === 'number' && isFinite(value) && Math.floor(value) === value;
	};

	var isInteger$1 = isInteger;

	// 32-bit signed integer, providing the broadest support across platforms.
	//
	// n.b. JavaScript's integers are safe between -(2^53 - 1) and 2^53 - 1 because
	// they are internally represented as IEEE 754 doubles.

	var MAX_INT$1 = 2147483647;
	var MIN_INT$1 = -2147483648;

	function serializeInt(outputValue) {
	  var coercedValue = serializeObject(outputValue);

	  if (typeof coercedValue === 'boolean') {
	    return coercedValue ? 1 : 0;
	  }

	  var num = coercedValue;

	  if (typeof coercedValue === 'string' && coercedValue !== '') {
	    num = Number(coercedValue);
	  }

	  if (!isInteger$1(num)) {
	    throw new GraphQLError("Int cannot represent non-integer value: ".concat(inspect$2(coercedValue)));
	  }

	  if (num > MAX_INT$1 || num < MIN_INT$1) {
	    throw new GraphQLError('Int cannot represent non 32-bit signed integer value: ' + inspect$2(coercedValue));
	  }

	  return num;
	}

	function coerceInt(inputValue) {
	  if (!isInteger$1(inputValue)) {
	    throw new GraphQLError("Int cannot represent non-integer value: ".concat(inspect$2(inputValue)));
	  }

	  if (inputValue > MAX_INT$1 || inputValue < MIN_INT$1) {
	    throw new GraphQLError("Int cannot represent non 32-bit signed integer value: ".concat(inputValue));
	  }

	  return inputValue;
	}

	var GraphQLInt = new GraphQLScalarType({
	  name: 'Int',
	  description: 'The `Int` scalar type represents non-fractional signed whole numeric values. Int can represent values between -(2^31) and 2^31 - 1.',
	  serialize: serializeInt,
	  parseValue: coerceInt,
	  parseLiteral: function parseLiteral(valueNode) {
	    if (valueNode.kind !== Kind.INT) {
	      throw new GraphQLError("Int cannot represent non-integer value: ".concat(print$1(valueNode)), valueNode);
	    }

	    var num = parseInt(valueNode.value, 10);

	    if (num > MAX_INT$1 || num < MIN_INT$1) {
	      throw new GraphQLError("Int cannot represent non 32-bit signed integer value: ".concat(valueNode.value), valueNode);
	    }

	    return num;
	  }
	});

	function serializeFloat(outputValue) {
	  var coercedValue = serializeObject(outputValue);

	  if (typeof coercedValue === 'boolean') {
	    return coercedValue ? 1 : 0;
	  }

	  var num = coercedValue;

	  if (typeof coercedValue === 'string' && coercedValue !== '') {
	    num = Number(coercedValue);
	  }

	  if (!isFinite$1(num)) {
	    throw new GraphQLError("Float cannot represent non numeric value: ".concat(inspect$2(coercedValue)));
	  }

	  return num;
	}

	function coerceFloat(inputValue) {
	  if (!isFinite$1(inputValue)) {
	    throw new GraphQLError("Float cannot represent non numeric value: ".concat(inspect$2(inputValue)));
	  }

	  return inputValue;
	}

	var GraphQLFloat = new GraphQLScalarType({
	  name: 'Float',
	  description: 'The `Float` scalar type represents signed double-precision fractional values as specified by [IEEE 754](https://en.wikipedia.org/wiki/IEEE_floating_point).',
	  serialize: serializeFloat,
	  parseValue: coerceFloat,
	  parseLiteral: function parseLiteral(valueNode) {
	    if (valueNode.kind !== Kind.FLOAT && valueNode.kind !== Kind.INT) {
	      throw new GraphQLError("Float cannot represent non numeric value: ".concat(print$1(valueNode)), valueNode);
	    }

	    return parseFloat(valueNode.value);
	  }
	}); // Support serializing objects with custom valueOf() or toJSON() functions -
	// a common way to represent a complex value which can be represented as
	// a string (ex: MongoDB id objects).

	function serializeObject(outputValue) {
	  if (isObjectLike(outputValue)) {
	    if (typeof outputValue.valueOf === 'function') {
	      var valueOfResult = outputValue.valueOf();

	      if (!isObjectLike(valueOfResult)) {
	        return valueOfResult;
	      }
	    }

	    if (typeof outputValue.toJSON === 'function') {
	      // $FlowFixMe[incompatible-use]
	      return outputValue.toJSON();
	    }
	  }

	  return outputValue;
	}

	function serializeString(outputValue) {
	  var coercedValue = serializeObject(outputValue); // Serialize string, boolean and number values to a string, but do not
	  // attempt to coerce object, function, symbol, or other types as strings.

	  if (typeof coercedValue === 'string') {
	    return coercedValue;
	  }

	  if (typeof coercedValue === 'boolean') {
	    return coercedValue ? 'true' : 'false';
	  }

	  if (isFinite$1(coercedValue)) {
	    return coercedValue.toString();
	  }

	  throw new GraphQLError("String cannot represent value: ".concat(inspect$2(outputValue)));
	}

	function coerceString(inputValue) {
	  if (typeof inputValue !== 'string') {
	    throw new GraphQLError("String cannot represent a non string value: ".concat(inspect$2(inputValue)));
	  }

	  return inputValue;
	}

	var GraphQLString = new GraphQLScalarType({
	  name: 'String',
	  description: 'The `String` scalar type represents textual data, represented as UTF-8 character sequences. The String type is most often used by GraphQL to represent free-form human-readable text.',
	  serialize: serializeString,
	  parseValue: coerceString,
	  parseLiteral: function parseLiteral(valueNode) {
	    if (valueNode.kind !== Kind.STRING) {
	      throw new GraphQLError("String cannot represent a non string value: ".concat(print$1(valueNode)), valueNode);
	    }

	    return valueNode.value;
	  }
	});

	function serializeBoolean(outputValue) {
	  var coercedValue = serializeObject(outputValue);

	  if (typeof coercedValue === 'boolean') {
	    return coercedValue;
	  }

	  if (isFinite$1(coercedValue)) {
	    return coercedValue !== 0;
	  }

	  throw new GraphQLError("Boolean cannot represent a non boolean value: ".concat(inspect$2(coercedValue)));
	}

	function coerceBoolean(inputValue) {
	  if (typeof inputValue !== 'boolean') {
	    throw new GraphQLError("Boolean cannot represent a non boolean value: ".concat(inspect$2(inputValue)));
	  }

	  return inputValue;
	}

	var GraphQLBoolean = new GraphQLScalarType({
	  name: 'Boolean',
	  description: 'The `Boolean` scalar type represents `true` or `false`.',
	  serialize: serializeBoolean,
	  parseValue: coerceBoolean,
	  parseLiteral: function parseLiteral(valueNode) {
	    if (valueNode.kind !== Kind.BOOLEAN) {
	      throw new GraphQLError("Boolean cannot represent a non boolean value: ".concat(print$1(valueNode)), valueNode);
	    }

	    return valueNode.value;
	  }
	});

	function serializeID(outputValue) {
	  var coercedValue = serializeObject(outputValue);

	  if (typeof coercedValue === 'string') {
	    return coercedValue;
	  }

	  if (isInteger$1(coercedValue)) {
	    return String(coercedValue);
	  }

	  throw new GraphQLError("ID cannot represent value: ".concat(inspect$2(outputValue)));
	}

	function coerceID(inputValue) {
	  if (typeof inputValue === 'string') {
	    return inputValue;
	  }

	  if (isInteger$1(inputValue)) {
	    return inputValue.toString();
	  }

	  throw new GraphQLError("ID cannot represent value: ".concat(inspect$2(inputValue)));
	}

	var GraphQLID = new GraphQLScalarType({
	  name: 'ID',
	  description: 'The `ID` scalar type represents a unique identifier, often used to refetch an object or as key for a cache. The ID type appears in a JSON response as a String; however, it is not intended to be human-readable. When expected as an input type, any string (such as `"4"`) or integer (such as `4`) input value will be accepted as an ID.',
	  serialize: serializeID,
	  parseValue: coerceID,
	  parseLiteral: function parseLiteral(valueNode) {
	    if (valueNode.kind !== Kind.STRING && valueNode.kind !== Kind.INT) {
	      throw new GraphQLError('ID cannot represent a non-string and non-integer value: ' + print$1(valueNode), valueNode);
	    }

	    return valueNode.value;
	  }
	});
	var specifiedScalarTypes = Object.freeze([GraphQLString, GraphQLInt, GraphQLFloat, GraphQLBoolean, GraphQLID]);
	function isSpecifiedScalarType(type) {
	  return specifiedScalarTypes.some(function (_ref) {
	    var name = _ref.name;
	    return type.name === name;
	  });
	}

	/**
	 * Produces a GraphQL Value AST given a JavaScript object.
	 * Function will match JavaScript/JSON values to GraphQL AST schema format
	 * by using suggested GraphQLInputType. For example:
	 *
	 *     astFromValue("value", GraphQLString)
	 *
	 * A GraphQL type must be provided, which will be used to interpret different
	 * JavaScript values.
	 *
	 * | JSON Value    | GraphQL Value        |
	 * | ------------- | -------------------- |
	 * | Object        | Input Object         |
	 * | Array         | List                 |
	 * | Boolean       | Boolean              |
	 * | String        | String / Enum Value  |
	 * | Number        | Int / Float          |
	 * | Mixed         | Enum Value           |
	 * | null          | NullValue            |
	 *
	 */

	function astFromValue(value, type) {
	  if (isNonNullType(type)) {
	    var astValue = astFromValue(value, type.ofType);

	    if ((astValue === null || astValue === void 0 ? void 0 : astValue.kind) === Kind.NULL) {
	      return null;
	    }

	    return astValue;
	  } // only explicit null, not undefined, NaN


	  if (value === null) {
	    return {
	      kind: Kind.NULL
	    };
	  } // undefined


	  if (value === undefined) {
	    return null;
	  } // Convert JavaScript array to GraphQL list. If the GraphQLType is a list, but
	  // the value is not an array, convert the value using the list's item type.


	  if (isListType(type)) {
	    var itemType = type.ofType;
	    var items = safeArrayFrom(value);

	    if (items != null) {
	      var valuesNodes = [];

	      for (var _i2 = 0; _i2 < items.length; _i2++) {
	        var item = items[_i2];
	        var itemNode = astFromValue(item, itemType);

	        if (itemNode != null) {
	          valuesNodes.push(itemNode);
	        }
	      }

	      return {
	        kind: Kind.LIST,
	        values: valuesNodes
	      };
	    }

	    return astFromValue(value, itemType);
	  } // Populate the fields of the input object by creating ASTs from each value
	  // in the JavaScript object according to the fields in the input type.


	  if (isInputObjectType(type)) {
	    if (!isObjectLike(value)) {
	      return null;
	    }

	    var fieldNodes = [];

	    for (var _i4 = 0, _objectValues2 = objectValues$1(type.getFields()); _i4 < _objectValues2.length; _i4++) {
	      var field = _objectValues2[_i4];
	      var fieldValue = astFromValue(value[field.name], field.type);

	      if (fieldValue) {
	        fieldNodes.push({
	          kind: Kind.OBJECT_FIELD,
	          name: {
	            kind: Kind.NAME,
	            value: field.name
	          },
	          value: fieldValue
	        });
	      }
	    }

	    return {
	      kind: Kind.OBJECT,
	      fields: fieldNodes
	    };
	  } // istanbul ignore else (See: 'https://github.com/graphql/graphql-js/issues/2618')


	  if (isLeafType(type)) {
	    // Since value is an internally represented value, it must be serialized
	    // to an externally represented value before converting into an AST.
	    var serialized = type.serialize(value);

	    if (serialized == null) {
	      return null;
	    } // Others serialize based on their corresponding JavaScript scalar types.


	    if (typeof serialized === 'boolean') {
	      return {
	        kind: Kind.BOOLEAN,
	        value: serialized
	      };
	    } // JavaScript numbers can be Int or Float values.


	    if (typeof serialized === 'number' && isFinite$1(serialized)) {
	      var stringNum = String(serialized);
	      return integerStringRegExp$1.test(stringNum) ? {
	        kind: Kind.INT,
	        value: stringNum
	      } : {
	        kind: Kind.FLOAT,
	        value: stringNum
	      };
	    }

	    if (typeof serialized === 'string') {
	      // Enum types use Enum literals.
	      if (isEnumType(type)) {
	        return {
	          kind: Kind.ENUM,
	          value: serialized
	        };
	      } // ID types can use Int literals.


	      if (type === GraphQLID && integerStringRegExp$1.test(serialized)) {
	        return {
	          kind: Kind.INT,
	          value: serialized
	        };
	      }

	      return {
	        kind: Kind.STRING,
	        value: serialized
	      };
	    }

	    throw new TypeError("Cannot convert value to AST: ".concat(inspect$2(serialized), "."));
	  } // istanbul ignore next (Not reachable. All possible input types have been considered)


	  invariant(0, 'Unexpected input type: ' + inspect$2(type));
	}
	/**
	 * IntValue:
	 *   - NegativeSign? 0
	 *   - NegativeSign? NonZeroDigit ( Digit+ )?
	 */

	var integerStringRegExp$1 = /^-?(?:0|[1-9][0-9]*)$/;

	var __Schema = new GraphQLObjectType({
	  name: '__Schema',
	  description: 'A GraphQL Schema defines the capabilities of a GraphQL server. It exposes all available types and directives on the server, as well as the entry points for query, mutation, and subscription operations.',
	  fields: function fields() {
	    return {
	      description: {
	        type: GraphQLString,
	        resolve: function resolve(schema) {
	          return schema.description;
	        }
	      },
	      types: {
	        description: 'A list of all types supported by this server.',
	        type: new GraphQLNonNull(new GraphQLList(new GraphQLNonNull(__Type))),
	        resolve: function resolve(schema) {
	          return objectValues$1(schema.getTypeMap());
	        }
	      },
	      queryType: {
	        description: 'The type that query operations will be rooted at.',
	        type: new GraphQLNonNull(__Type),
	        resolve: function resolve(schema) {
	          return schema.getQueryType();
	        }
	      },
	      mutationType: {
	        description: 'If this server supports mutation, the type that mutation operations will be rooted at.',
	        type: __Type,
	        resolve: function resolve(schema) {
	          return schema.getMutationType();
	        }
	      },
	      subscriptionType: {
	        description: 'If this server support subscription, the type that subscription operations will be rooted at.',
	        type: __Type,
	        resolve: function resolve(schema) {
	          return schema.getSubscriptionType();
	        }
	      },
	      directives: {
	        description: 'A list of all directives supported by this server.',
	        type: new GraphQLNonNull(new GraphQLList(new GraphQLNonNull(__Directive))),
	        resolve: function resolve(schema) {
	          return schema.getDirectives();
	        }
	      }
	    };
	  }
	});
	var __Directive = new GraphQLObjectType({
	  name: '__Directive',
	  description: "A Directive provides a way to describe alternate runtime execution and type validation behavior in a GraphQL document.\n\nIn some cases, you need to provide options to alter GraphQL's execution behavior in ways field arguments will not suffice, such as conditionally including or skipping a field. Directives provide this by describing additional information to the executor.",
	  fields: function fields() {
	    return {
	      name: {
	        type: new GraphQLNonNull(GraphQLString),
	        resolve: function resolve(directive) {
	          return directive.name;
	        }
	      },
	      description: {
	        type: GraphQLString,
	        resolve: function resolve(directive) {
	          return directive.description;
	        }
	      },
	      isRepeatable: {
	        type: new GraphQLNonNull(GraphQLBoolean),
	        resolve: function resolve(directive) {
	          return directive.isRepeatable;
	        }
	      },
	      locations: {
	        type: new GraphQLNonNull(new GraphQLList(new GraphQLNonNull(__DirectiveLocation))),
	        resolve: function resolve(directive) {
	          return directive.locations;
	        }
	      },
	      args: {
	        type: new GraphQLNonNull(new GraphQLList(new GraphQLNonNull(__InputValue))),
	        args: {
	          includeDeprecated: {
	            type: GraphQLBoolean,
	            defaultValue: false
	          }
	        },
	        resolve: function resolve(field, _ref) {
	          var includeDeprecated = _ref.includeDeprecated;
	          return includeDeprecated ? field.args : field.args.filter(function (arg) {
	            return arg.deprecationReason == null;
	          });
	        }
	      }
	    };
	  }
	});
	var __DirectiveLocation = new GraphQLEnumType({
	  name: '__DirectiveLocation',
	  description: 'A Directive can be adjacent to many parts of the GraphQL language, a __DirectiveLocation describes one such possible adjacencies.',
	  values: {
	    QUERY: {
	      value: DirectiveLocation.QUERY,
	      description: 'Location adjacent to a query operation.'
	    },
	    MUTATION: {
	      value: DirectiveLocation.MUTATION,
	      description: 'Location adjacent to a mutation operation.'
	    },
	    SUBSCRIPTION: {
	      value: DirectiveLocation.SUBSCRIPTION,
	      description: 'Location adjacent to a subscription operation.'
	    },
	    FIELD: {
	      value: DirectiveLocation.FIELD,
	      description: 'Location adjacent to a field.'
	    },
	    FRAGMENT_DEFINITION: {
	      value: DirectiveLocation.FRAGMENT_DEFINITION,
	      description: 'Location adjacent to a fragment definition.'
	    },
	    FRAGMENT_SPREAD: {
	      value: DirectiveLocation.FRAGMENT_SPREAD,
	      description: 'Location adjacent to a fragment spread.'
	    },
	    INLINE_FRAGMENT: {
	      value: DirectiveLocation.INLINE_FRAGMENT,
	      description: 'Location adjacent to an inline fragment.'
	    },
	    VARIABLE_DEFINITION: {
	      value: DirectiveLocation.VARIABLE_DEFINITION,
	      description: 'Location adjacent to a variable definition.'
	    },
	    SCHEMA: {
	      value: DirectiveLocation.SCHEMA,
	      description: 'Location adjacent to a schema definition.'
	    },
	    SCALAR: {
	      value: DirectiveLocation.SCALAR,
	      description: 'Location adjacent to a scalar definition.'
	    },
	    OBJECT: {
	      value: DirectiveLocation.OBJECT,
	      description: 'Location adjacent to an object type definition.'
	    },
	    FIELD_DEFINITION: {
	      value: DirectiveLocation.FIELD_DEFINITION,
	      description: 'Location adjacent to a field definition.'
	    },
	    ARGUMENT_DEFINITION: {
	      value: DirectiveLocation.ARGUMENT_DEFINITION,
	      description: 'Location adjacent to an argument definition.'
	    },
	    INTERFACE: {
	      value: DirectiveLocation.INTERFACE,
	      description: 'Location adjacent to an interface definition.'
	    },
	    UNION: {
	      value: DirectiveLocation.UNION,
	      description: 'Location adjacent to a union definition.'
	    },
	    ENUM: {
	      value: DirectiveLocation.ENUM,
	      description: 'Location adjacent to an enum definition.'
	    },
	    ENUM_VALUE: {
	      value: DirectiveLocation.ENUM_VALUE,
	      description: 'Location adjacent to an enum value definition.'
	    },
	    INPUT_OBJECT: {
	      value: DirectiveLocation.INPUT_OBJECT,
	      description: 'Location adjacent to an input object type definition.'
	    },
	    INPUT_FIELD_DEFINITION: {
	      value: DirectiveLocation.INPUT_FIELD_DEFINITION,
	      description: 'Location adjacent to an input object field definition.'
	    }
	  }
	});
	var __Type = new GraphQLObjectType({
	  name: '__Type',
	  description: 'The fundamental unit of any GraphQL Schema is the type. There are many kinds of types in GraphQL as represented by the `__TypeKind` enum.\n\nDepending on the kind of a type, certain fields describe information about that type. Scalar types provide no information beyond a name, description and optional `specifiedByUrl`, while Enum types provide their values. Object and Interface types provide the fields they describe. Abstract types, Union and Interface, provide the Object types possible at runtime. List and NonNull types compose other types.',
	  fields: function fields() {
	    return {
	      kind: {
	        type: new GraphQLNonNull(__TypeKind),
	        resolve: function resolve(type) {
	          if (isScalarType(type)) {
	            return TypeKind.SCALAR;
	          }

	          if (isObjectType(type)) {
	            return TypeKind.OBJECT;
	          }

	          if (isInterfaceType(type)) {
	            return TypeKind.INTERFACE;
	          }

	          if (isUnionType(type)) {
	            return TypeKind.UNION;
	          }

	          if (isEnumType(type)) {
	            return TypeKind.ENUM;
	          }

	          if (isInputObjectType(type)) {
	            return TypeKind.INPUT_OBJECT;
	          }

	          if (isListType(type)) {
	            return TypeKind.LIST;
	          } // istanbul ignore else (See: 'https://github.com/graphql/graphql-js/issues/2618')


	          if (isNonNullType(type)) {
	            return TypeKind.NON_NULL;
	          } // istanbul ignore next (Not reachable. All possible types have been considered)


	          invariant(0, "Unexpected type: \"".concat(inspect$2(type), "\"."));
	        }
	      },
	      name: {
	        type: GraphQLString,
	        resolve: function resolve(type) {
	          return type.name !== undefined ? type.name : undefined;
	        }
	      },
	      description: {
	        type: GraphQLString,
	        resolve: function resolve(type) {
	          return type.description !== undefined ? type.description : undefined;
	        }
	      },
	      specifiedByUrl: {
	        type: GraphQLString,
	        resolve: function resolve(obj) {
	          return obj.specifiedByUrl !== undefined ? obj.specifiedByUrl : undefined;
	        }
	      },
	      fields: {
	        type: new GraphQLList(new GraphQLNonNull(__Field)),
	        args: {
	          includeDeprecated: {
	            type: GraphQLBoolean,
	            defaultValue: false
	          }
	        },
	        resolve: function resolve(type, _ref2) {
	          var includeDeprecated = _ref2.includeDeprecated;

	          if (isObjectType(type) || isInterfaceType(type)) {
	            var fields = objectValues$1(type.getFields());
	            return includeDeprecated ? fields : fields.filter(function (field) {
	              return field.deprecationReason == null;
	            });
	          }
	        }
	      },
	      interfaces: {
	        type: new GraphQLList(new GraphQLNonNull(__Type)),
	        resolve: function resolve(type) {
	          if (isObjectType(type) || isInterfaceType(type)) {
	            return type.getInterfaces();
	          }
	        }
	      },
	      possibleTypes: {
	        type: new GraphQLList(new GraphQLNonNull(__Type)),
	        resolve: function resolve(type, _args, _context, _ref3) {
	          var schema = _ref3.schema;

	          if (isAbstractType(type)) {
	            return schema.getPossibleTypes(type);
	          }
	        }
	      },
	      enumValues: {
	        type: new GraphQLList(new GraphQLNonNull(__EnumValue)),
	        args: {
	          includeDeprecated: {
	            type: GraphQLBoolean,
	            defaultValue: false
	          }
	        },
	        resolve: function resolve(type, _ref4) {
	          var includeDeprecated = _ref4.includeDeprecated;

	          if (isEnumType(type)) {
	            var values = type.getValues();
	            return includeDeprecated ? values : values.filter(function (field) {
	              return field.deprecationReason == null;
	            });
	          }
	        }
	      },
	      inputFields: {
	        type: new GraphQLList(new GraphQLNonNull(__InputValue)),
	        args: {
	          includeDeprecated: {
	            type: GraphQLBoolean,
	            defaultValue: false
	          }
	        },
	        resolve: function resolve(type, _ref5) {
	          var includeDeprecated = _ref5.includeDeprecated;

	          if (isInputObjectType(type)) {
	            var values = objectValues$1(type.getFields());
	            return includeDeprecated ? values : values.filter(function (field) {
	              return field.deprecationReason == null;
	            });
	          }
	        }
	      },
	      ofType: {
	        type: __Type,
	        resolve: function resolve(type) {
	          return type.ofType !== undefined ? type.ofType : undefined;
	        }
	      }
	    };
	  }
	});
	var __Field = new GraphQLObjectType({
	  name: '__Field',
	  description: 'Object and Interface types are described by a list of Fields, each of which has a name, potentially a list of arguments, and a return type.',
	  fields: function fields() {
	    return {
	      name: {
	        type: new GraphQLNonNull(GraphQLString),
	        resolve: function resolve(field) {
	          return field.name;
	        }
	      },
	      description: {
	        type: GraphQLString,
	        resolve: function resolve(field) {
	          return field.description;
	        }
	      },
	      args: {
	        type: new GraphQLNonNull(new GraphQLList(new GraphQLNonNull(__InputValue))),
	        args: {
	          includeDeprecated: {
	            type: GraphQLBoolean,
	            defaultValue: false
	          }
	        },
	        resolve: function resolve(field, _ref6) {
	          var includeDeprecated = _ref6.includeDeprecated;
	          return includeDeprecated ? field.args : field.args.filter(function (arg) {
	            return arg.deprecationReason == null;
	          });
	        }
	      },
	      type: {
	        type: new GraphQLNonNull(__Type),
	        resolve: function resolve(field) {
	          return field.type;
	        }
	      },
	      isDeprecated: {
	        type: new GraphQLNonNull(GraphQLBoolean),
	        resolve: function resolve(field) {
	          return field.deprecationReason != null;
	        }
	      },
	      deprecationReason: {
	        type: GraphQLString,
	        resolve: function resolve(field) {
	          return field.deprecationReason;
	        }
	      }
	    };
	  }
	});
	var __InputValue = new GraphQLObjectType({
	  name: '__InputValue',
	  description: 'Arguments provided to Fields or Directives and the input fields of an InputObject are represented as Input Values which describe their type and optionally a default value.',
	  fields: function fields() {
	    return {
	      name: {
	        type: new GraphQLNonNull(GraphQLString),
	        resolve: function resolve(inputValue) {
	          return inputValue.name;
	        }
	      },
	      description: {
	        type: GraphQLString,
	        resolve: function resolve(inputValue) {
	          return inputValue.description;
	        }
	      },
	      type: {
	        type: new GraphQLNonNull(__Type),
	        resolve: function resolve(inputValue) {
	          return inputValue.type;
	        }
	      },
	      defaultValue: {
	        type: GraphQLString,
	        description: 'A GraphQL-formatted string representing the default value for this input value.',
	        resolve: function resolve(inputValue) {
	          var type = inputValue.type,
	              defaultValue = inputValue.defaultValue;
	          var valueAST = astFromValue(defaultValue, type);
	          return valueAST ? print$1(valueAST) : null;
	        }
	      },
	      isDeprecated: {
	        type: new GraphQLNonNull(GraphQLBoolean),
	        resolve: function resolve(field) {
	          return field.deprecationReason != null;
	        }
	      },
	      deprecationReason: {
	        type: GraphQLString,
	        resolve: function resolve(obj) {
	          return obj.deprecationReason;
	        }
	      }
	    };
	  }
	});
	var __EnumValue = new GraphQLObjectType({
	  name: '__EnumValue',
	  description: 'One possible value for a given Enum. Enum values are unique values, not a placeholder for a string or numeric value. However an Enum value is returned in a JSON response as a string.',
	  fields: function fields() {
	    return {
	      name: {
	        type: new GraphQLNonNull(GraphQLString),
	        resolve: function resolve(enumValue) {
	          return enumValue.name;
	        }
	      },
	      description: {
	        type: GraphQLString,
	        resolve: function resolve(enumValue) {
	          return enumValue.description;
	        }
	      },
	      isDeprecated: {
	        type: new GraphQLNonNull(GraphQLBoolean),
	        resolve: function resolve(enumValue) {
	          return enumValue.deprecationReason != null;
	        }
	      },
	      deprecationReason: {
	        type: GraphQLString,
	        resolve: function resolve(enumValue) {
	          return enumValue.deprecationReason;
	        }
	      }
	    };
	  }
	});
	var TypeKind = Object.freeze({
	  SCALAR: 'SCALAR',
	  OBJECT: 'OBJECT',
	  INTERFACE: 'INTERFACE',
	  UNION: 'UNION',
	  ENUM: 'ENUM',
	  INPUT_OBJECT: 'INPUT_OBJECT',
	  LIST: 'LIST',
	  NON_NULL: 'NON_NULL'
	});
	var __TypeKind = new GraphQLEnumType({
	  name: '__TypeKind',
	  description: 'An enum describing what kind of type a given `__Type` is.',
	  values: {
	    SCALAR: {
	      value: TypeKind.SCALAR,
	      description: 'Indicates this type is a scalar.'
	    },
	    OBJECT: {
	      value: TypeKind.OBJECT,
	      description: 'Indicates this type is an object. `fields` and `interfaces` are valid fields.'
	    },
	    INTERFACE: {
	      value: TypeKind.INTERFACE,
	      description: 'Indicates this type is an interface. `fields`, `interfaces`, and `possibleTypes` are valid fields.'
	    },
	    UNION: {
	      value: TypeKind.UNION,
	      description: 'Indicates this type is a union. `possibleTypes` is a valid field.'
	    },
	    ENUM: {
	      value: TypeKind.ENUM,
	      description: 'Indicates this type is an enum. `enumValues` is a valid field.'
	    },
	    INPUT_OBJECT: {
	      value: TypeKind.INPUT_OBJECT,
	      description: 'Indicates this type is an input object. `inputFields` is a valid field.'
	    },
	    LIST: {
	      value: TypeKind.LIST,
	      description: 'Indicates this type is a list. `ofType` is a valid field.'
	    },
	    NON_NULL: {
	      value: TypeKind.NON_NULL,
	      description: 'Indicates this type is a non-null. `ofType` is a valid field.'
	    }
	  }
	});
	/**
	 * Note that these are GraphQLField and not GraphQLFieldConfig,
	 * so the format for args is different.
	 */

	var SchemaMetaFieldDef = {
	  name: '__schema',
	  type: new GraphQLNonNull(__Schema),
	  description: 'Access the current type schema of this server.',
	  args: [],
	  resolve: function resolve(_source, _args, _context, _ref7) {
	    var schema = _ref7.schema;
	    return schema;
	  },
	  isDeprecated: false,
	  deprecationReason: undefined,
	  extensions: undefined,
	  astNode: undefined
	};
	var TypeMetaFieldDef = {
	  name: '__type',
	  type: __Type,
	  description: 'Request the type information of a single type.',
	  args: [{
	    name: 'name',
	    description: undefined,
	    type: new GraphQLNonNull(GraphQLString),
	    defaultValue: undefined,
	    deprecationReason: undefined,
	    extensions: undefined,
	    astNode: undefined
	  }],
	  resolve: function resolve(_source, _ref8, _context, _ref9) {
	    var name = _ref8.name;
	    var schema = _ref9.schema;
	    return schema.getType(name);
	  },
	  isDeprecated: false,
	  deprecationReason: undefined,
	  extensions: undefined,
	  astNode: undefined
	};
	var TypeNameMetaFieldDef = {
	  name: '__typename',
	  type: new GraphQLNonNull(GraphQLString),
	  description: 'The name of the current Object type at runtime.',
	  args: [],
	  resolve: function resolve(_source, _args, _context, _ref10) {
	    var parentType = _ref10.parentType;
	    return parentType.name;
	  },
	  isDeprecated: false,
	  deprecationReason: undefined,
	  extensions: undefined,
	  astNode: undefined
	};
	var introspectionTypes = Object.freeze([__Schema, __Directive, __DirectiveLocation, __Type, __Field, __InputValue, __EnumValue, __TypeKind]);
	function isIntrospectionType(type) {
	  return introspectionTypes.some(function (_ref11) {
	    var name = _ref11.name;
	    return type.name === name;
	  });
	}

	function _defineProperties$1(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

	function _createClass$1(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties$1(Constructor.prototype, protoProps); if (staticProps) _defineProperties$1(Constructor, staticProps); return Constructor; }
	/**
	 * Test if the given value is a GraphQL directive.
	 */

	// eslint-disable-next-line no-redeclare
	function isDirective(directive) {
	  return instanceOf(directive, GraphQLDirective);
	}
	function assertDirective(directive) {
	  if (!isDirective(directive)) {
	    throw new Error("Expected ".concat(inspect$2(directive), " to be a GraphQL directive."));
	  }

	  return directive;
	}
	/**
	 * Directives are used by the GraphQL runtime as a way of modifying execution
	 * behavior. Type system creators will usually not create these directly.
	 */

	var GraphQLDirective = /*#__PURE__*/function () {
	  function GraphQLDirective(config) {
	    var _config$isRepeatable, _config$args;

	    this.name = config.name;
	    this.description = config.description;
	    this.locations = config.locations;
	    this.isRepeatable = (_config$isRepeatable = config.isRepeatable) !== null && _config$isRepeatable !== void 0 ? _config$isRepeatable : false;
	    this.extensions = config.extensions && toObjMap(config.extensions);
	    this.astNode = config.astNode;
	    config.name || devAssert(0, 'Directive must be named.');
	    Array.isArray(config.locations) || devAssert(0, "@".concat(config.name, " locations must be an Array."));
	    var args = (_config$args = config.args) !== null && _config$args !== void 0 ? _config$args : {};
	    isObjectLike(args) && !Array.isArray(args) || devAssert(0, "@".concat(config.name, " args must be an object with argument names as keys."));
	    this.args = objectEntries$1(args).map(function (_ref) {
	      var argName = _ref[0],
	          argConfig = _ref[1];
	      return {
	        name: argName,
	        description: argConfig.description,
	        type: argConfig.type,
	        defaultValue: argConfig.defaultValue,
	        deprecationReason: argConfig.deprecationReason,
	        extensions: argConfig.extensions && toObjMap(argConfig.extensions),
	        astNode: argConfig.astNode
	      };
	    });
	  }

	  var _proto = GraphQLDirective.prototype;

	  _proto.toConfig = function toConfig() {
	    return {
	      name: this.name,
	      description: this.description,
	      locations: this.locations,
	      args: argsToArgsConfig(this.args),
	      isRepeatable: this.isRepeatable,
	      extensions: this.extensions,
	      astNode: this.astNode
	    };
	  };

	  _proto.toString = function toString() {
	    return '@' + this.name;
	  };

	  _proto.toJSON = function toJSON() {
	    return this.toString();
	  } // $FlowFixMe[unsupported-syntax] Flow doesn't support computed properties yet
	  ;

	  _createClass$1(GraphQLDirective, [{
	    key: SYMBOL_TO_STRING_TAG,
	    get: function get() {
	      return 'GraphQLDirective';
	    }
	  }]);

	  return GraphQLDirective;
	}(); // Print a simplified form when appearing in `inspect` and `util.inspect`.

	defineInspect(GraphQLDirective);

	/**
	 * Used to conditionally include fields or fragments.
	 */
	var GraphQLIncludeDirective = new GraphQLDirective({
	  name: 'include',
	  description: 'Directs the executor to include this field or fragment only when the `if` argument is true.',
	  locations: [DirectiveLocation.FIELD, DirectiveLocation.FRAGMENT_SPREAD, DirectiveLocation.INLINE_FRAGMENT],
	  args: {
	    if: {
	      type: new GraphQLNonNull(GraphQLBoolean),
	      description: 'Included when true.'
	    }
	  }
	});
	/**
	 * Used to conditionally skip (exclude) fields or fragments.
	 */

	var GraphQLSkipDirective = new GraphQLDirective({
	  name: 'skip',
	  description: 'Directs the executor to skip this field or fragment when the `if` argument is true.',
	  locations: [DirectiveLocation.FIELD, DirectiveLocation.FRAGMENT_SPREAD, DirectiveLocation.INLINE_FRAGMENT],
	  args: {
	    if: {
	      type: new GraphQLNonNull(GraphQLBoolean),
	      description: 'Skipped when true.'
	    }
	  }
	});
	/**
	 * Constant string used for default reason for a deprecation.
	 */

	var DEFAULT_DEPRECATION_REASON = 'No longer supported';
	/**
	 * Used to declare element of a GraphQL schema as deprecated.
	 */

	var GraphQLDeprecatedDirective = new GraphQLDirective({
	  name: 'deprecated',
	  description: 'Marks an element of a GraphQL schema as no longer supported.',
	  locations: [DirectiveLocation.FIELD_DEFINITION, DirectiveLocation.ARGUMENT_DEFINITION, DirectiveLocation.INPUT_FIELD_DEFINITION, DirectiveLocation.ENUM_VALUE],
	  args: {
	    reason: {
	      type: GraphQLString,
	      description: 'Explains why this element was deprecated, usually also including a suggestion for how to access supported similar data. Formatted using the Markdown syntax, as specified by [CommonMark](https://commonmark.org/).',
	      defaultValue: DEFAULT_DEPRECATION_REASON
	    }
	  }
	});
	/**
	 * Used to provide a URL for specifying the behaviour of custom scalar definitions.
	 */

	var GraphQLSpecifiedByDirective = new GraphQLDirective({
	  name: 'specifiedBy',
	  description: 'Exposes a URL that specifies the behaviour of this scalar.',
	  locations: [DirectiveLocation.SCALAR],
	  args: {
	    url: {
	      type: new GraphQLNonNull(GraphQLString),
	      description: 'The URL that specifies the behaviour of this scalar.'
	    }
	  }
	});
	/**
	 * The full list of specified directives.
	 */

	var specifiedDirectives = Object.freeze([GraphQLIncludeDirective, GraphQLSkipDirective, GraphQLDeprecatedDirective, GraphQLSpecifiedByDirective]);
	function isSpecifiedDirective(directive) {
	  return specifiedDirectives.some(function (_ref2) {
	    var name = _ref2.name;
	    return name === directive.name;
	  });
	}

	function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

	function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }
	/**
	 * Test if the given value is a GraphQL schema.
	 */

	// eslint-disable-next-line no-redeclare
	function isSchema(schema) {
	  return instanceOf(schema, GraphQLSchema);
	}
	function assertSchema(schema) {
	  if (!isSchema(schema)) {
	    throw new Error("Expected ".concat(inspect$2(schema), " to be a GraphQL schema."));
	  }

	  return schema;
	}
	/**
	 * Schema Definition
	 *
	 * A Schema is created by supplying the root types of each type of operation,
	 * query and mutation (optional). A schema definition is then supplied to the
	 * validator and executor.
	 *
	 * Example:
	 *
	 *     const MyAppSchema = new GraphQLSchema({
	 *       query: MyAppQueryRootType,
	 *       mutation: MyAppMutationRootType,
	 *     })
	 *
	 * Note: When the schema is constructed, by default only the types that are
	 * reachable by traversing the root types are included, other types must be
	 * explicitly referenced.
	 *
	 * Example:
	 *
	 *     const characterInterface = new GraphQLInterfaceType({
	 *       name: 'Character',
	 *       ...
	 *     });
	 *
	 *     const humanType = new GraphQLObjectType({
	 *       name: 'Human',
	 *       interfaces: [characterInterface],
	 *       ...
	 *     });
	 *
	 *     const droidType = new GraphQLObjectType({
	 *       name: 'Droid',
	 *       interfaces: [characterInterface],
	 *       ...
	 *     });
	 *
	 *     const schema = new GraphQLSchema({
	 *       query: new GraphQLObjectType({
	 *         name: 'Query',
	 *         fields: {
	 *           hero: { type: characterInterface, ... },
	 *         }
	 *       }),
	 *       ...
	 *       // Since this schema references only the `Character` interface it's
	 *       // necessary to explicitly list the types that implement it if
	 *       // you want them to be included in the final schema.
	 *       types: [humanType, droidType],
	 *     })
	 *
	 * Note: If an array of `directives` are provided to GraphQLSchema, that will be
	 * the exact list of directives represented and allowed. If `directives` is not
	 * provided then a default set of the specified directives (e.g. @include and
	 * @skip) will be used. If you wish to provide *additional* directives to these
	 * specified directives, you must explicitly declare them. Example:
	 *
	 *     const MyAppSchema = new GraphQLSchema({
	 *       ...
	 *       directives: specifiedDirectives.concat([ myCustomDirective ]),
	 *     })
	 *
	 */

	var GraphQLSchema = /*#__PURE__*/function () {
	  // Used as a cache for validateSchema().
	  function GraphQLSchema(config) {
	    var _config$directives;

	    // If this schema was built from a source known to be valid, then it may be
	    // marked with assumeValid to avoid an additional type system validation.
	    this.__validationErrors = config.assumeValid === true ? [] : undefined; // Check for common mistakes during construction to produce early errors.

	    isObjectLike(config) || devAssert(0, 'Must provide configuration object.');
	    !config.types || Array.isArray(config.types) || devAssert(0, "\"types\" must be Array if provided but got: ".concat(inspect$2(config.types), "."));
	    !config.directives || Array.isArray(config.directives) || devAssert(0, '"directives" must be Array if provided but got: ' + "".concat(inspect$2(config.directives), "."));
	    this.description = config.description;
	    this.extensions = config.extensions && toObjMap(config.extensions);
	    this.astNode = config.astNode;
	    this.extensionASTNodes = config.extensionASTNodes;
	    this._queryType = config.query;
	    this._mutationType = config.mutation;
	    this._subscriptionType = config.subscription; // Provide specified directives (e.g. @include and @skip) by default.

	    this._directives = (_config$directives = config.directives) !== null && _config$directives !== void 0 ? _config$directives : specifiedDirectives; // To preserve order of user-provided types, we add first to add them to
	    // the set of "collected" types, so `collectReferencedTypes` ignore them.

	    var allReferencedTypes = new Set(config.types);

	    if (config.types != null) {
	      for (var _i2 = 0, _config$types2 = config.types; _i2 < _config$types2.length; _i2++) {
	        var type = _config$types2[_i2];
	        // When we ready to process this type, we remove it from "collected" types
	        // and then add it together with all dependent types in the correct position.
	        allReferencedTypes.delete(type);
	        collectReferencedTypes(type, allReferencedTypes);
	      }
	    }

	    if (this._queryType != null) {
	      collectReferencedTypes(this._queryType, allReferencedTypes);
	    }

	    if (this._mutationType != null) {
	      collectReferencedTypes(this._mutationType, allReferencedTypes);
	    }

	    if (this._subscriptionType != null) {
	      collectReferencedTypes(this._subscriptionType, allReferencedTypes);
	    }

	    for (var _i4 = 0, _this$_directives2 = this._directives; _i4 < _this$_directives2.length; _i4++) {
	      var directive = _this$_directives2[_i4];

	      // Directives are not validated until validateSchema() is called.
	      if (isDirective(directive)) {
	        for (var _i6 = 0, _directive$args2 = directive.args; _i6 < _directive$args2.length; _i6++) {
	          var arg = _directive$args2[_i6];
	          collectReferencedTypes(arg.type, allReferencedTypes);
	        }
	      }
	    }

	    collectReferencedTypes(__Schema, allReferencedTypes); // Storing the resulting map for reference by the schema.

	    this._typeMap = Object.create(null);
	    this._subTypeMap = Object.create(null); // Keep track of all implementations by interface name.

	    this._implementationsMap = Object.create(null);

	    for (var _i8 = 0, _arrayFrom2 = arrayFrom$1(allReferencedTypes); _i8 < _arrayFrom2.length; _i8++) {
	      var namedType = _arrayFrom2[_i8];

	      if (namedType == null) {
	        continue;
	      }

	      var typeName = namedType.name;
	      typeName || devAssert(0, 'One of the provided types for building the Schema is missing a name.');

	      if (this._typeMap[typeName] !== undefined) {
	        throw new Error("Schema must contain uniquely named types but contains multiple types named \"".concat(typeName, "\"."));
	      }

	      this._typeMap[typeName] = namedType;

	      if (isInterfaceType(namedType)) {
	        // Store implementations by interface.
	        for (var _i10 = 0, _namedType$getInterfa2 = namedType.getInterfaces(); _i10 < _namedType$getInterfa2.length; _i10++) {
	          var iface = _namedType$getInterfa2[_i10];

	          if (isInterfaceType(iface)) {
	            var implementations = this._implementationsMap[iface.name];

	            if (implementations === undefined) {
	              implementations = this._implementationsMap[iface.name] = {
	                objects: [],
	                interfaces: []
	              };
	            }

	            implementations.interfaces.push(namedType);
	          }
	        }
	      } else if (isObjectType(namedType)) {
	        // Store implementations by objects.
	        for (var _i12 = 0, _namedType$getInterfa4 = namedType.getInterfaces(); _i12 < _namedType$getInterfa4.length; _i12++) {
	          var _iface = _namedType$getInterfa4[_i12];

	          if (isInterfaceType(_iface)) {
	            var _implementations = this._implementationsMap[_iface.name];

	            if (_implementations === undefined) {
	              _implementations = this._implementationsMap[_iface.name] = {
	                objects: [],
	                interfaces: []
	              };
	            }

	            _implementations.objects.push(namedType);
	          }
	        }
	      }
	    }
	  }

	  var _proto = GraphQLSchema.prototype;

	  _proto.getQueryType = function getQueryType() {
	    return this._queryType;
	  };

	  _proto.getMutationType = function getMutationType() {
	    return this._mutationType;
	  };

	  _proto.getSubscriptionType = function getSubscriptionType() {
	    return this._subscriptionType;
	  };

	  _proto.getTypeMap = function getTypeMap() {
	    return this._typeMap;
	  };

	  _proto.getType = function getType(name) {
	    return this.getTypeMap()[name];
	  };

	  _proto.getPossibleTypes = function getPossibleTypes(abstractType) {
	    return isUnionType(abstractType) ? abstractType.getTypes() : this.getImplementations(abstractType).objects;
	  };

	  _proto.getImplementations = function getImplementations(interfaceType) {
	    var implementations = this._implementationsMap[interfaceType.name];
	    return implementations !== null && implementations !== void 0 ? implementations : {
	      objects: [],
	      interfaces: []
	    };
	  } // @deprecated: use isSubType instead - will be removed in v16.
	  ;

	  _proto.isPossibleType = function isPossibleType(abstractType, possibleType) {
	    return this.isSubType(abstractType, possibleType);
	  };

	  _proto.isSubType = function isSubType(abstractType, maybeSubType) {
	    var map = this._subTypeMap[abstractType.name];

	    if (map === undefined) {
	      map = Object.create(null);

	      if (isUnionType(abstractType)) {
	        for (var _i14 = 0, _abstractType$getType2 = abstractType.getTypes(); _i14 < _abstractType$getType2.length; _i14++) {
	          var type = _abstractType$getType2[_i14];
	          map[type.name] = true;
	        }
	      } else {
	        var implementations = this.getImplementations(abstractType);

	        for (var _i16 = 0, _implementations$obje2 = implementations.objects; _i16 < _implementations$obje2.length; _i16++) {
	          var _type = _implementations$obje2[_i16];
	          map[_type.name] = true;
	        }

	        for (var _i18 = 0, _implementations$inte2 = implementations.interfaces; _i18 < _implementations$inte2.length; _i18++) {
	          var _type2 = _implementations$inte2[_i18];
	          map[_type2.name] = true;
	        }
	      }

	      this._subTypeMap[abstractType.name] = map;
	    }

	    return map[maybeSubType.name] !== undefined;
	  };

	  _proto.getDirectives = function getDirectives() {
	    return this._directives;
	  };

	  _proto.getDirective = function getDirective(name) {
	    return find$1(this.getDirectives(), function (directive) {
	      return directive.name === name;
	    });
	  };

	  _proto.toConfig = function toConfig() {
	    var _this$extensionASTNod;

	    return {
	      description: this.description,
	      query: this.getQueryType(),
	      mutation: this.getMutationType(),
	      subscription: this.getSubscriptionType(),
	      types: objectValues$1(this.getTypeMap()),
	      directives: this.getDirectives().slice(),
	      extensions: this.extensions,
	      astNode: this.astNode,
	      extensionASTNodes: (_this$extensionASTNod = this.extensionASTNodes) !== null && _this$extensionASTNod !== void 0 ? _this$extensionASTNod : [],
	      assumeValid: this.__validationErrors !== undefined
	    };
	  } // $FlowFixMe[unsupported-syntax] Flow doesn't support computed properties yet
	  ;

	  _createClass(GraphQLSchema, [{
	    key: SYMBOL_TO_STRING_TAG,
	    get: function get() {
	      return 'GraphQLSchema';
	    }
	  }]);

	  return GraphQLSchema;
	}();

	function collectReferencedTypes(type, typeSet) {
	  var namedType = getNamedType(type);

	  if (!typeSet.has(namedType)) {
	    typeSet.add(namedType);

	    if (isUnionType(namedType)) {
	      for (var _i20 = 0, _namedType$getTypes2 = namedType.getTypes(); _i20 < _namedType$getTypes2.length; _i20++) {
	        var memberType = _namedType$getTypes2[_i20];
	        collectReferencedTypes(memberType, typeSet);
	      }
	    } else if (isObjectType(namedType) || isInterfaceType(namedType)) {
	      for (var _i22 = 0, _namedType$getInterfa6 = namedType.getInterfaces(); _i22 < _namedType$getInterfa6.length; _i22++) {
	        var interfaceType = _namedType$getInterfa6[_i22];
	        collectReferencedTypes(interfaceType, typeSet);
	      }

	      for (var _i24 = 0, _objectValues2 = objectValues$1(namedType.getFields()); _i24 < _objectValues2.length; _i24++) {
	        var field = _objectValues2[_i24];
	        collectReferencedTypes(field.type, typeSet);

	        for (var _i26 = 0, _field$args2 = field.args; _i26 < _field$args2.length; _i26++) {
	          var arg = _field$args2[_i26];
	          collectReferencedTypes(arg.type, typeSet);
	        }
	      }
	    } else if (isInputObjectType(namedType)) {
	      for (var _i28 = 0, _objectValues4 = objectValues$1(namedType.getFields()); _i28 < _objectValues4.length; _i28++) {
	        var _field = _objectValues4[_i28];
	        collectReferencedTypes(_field.type, typeSet);
	      }
	    }
	  }

	  return typeSet;
	}

	/**
	 * Implements the "Type Validation" sub-sections of the specification's
	 * "Type System" section.
	 *
	 * Validation runs synchronously, returning an array of encountered errors, or
	 * an empty array if no errors were encountered and the Schema is valid.
	 */

	function validateSchema$1(schema) {
	  // First check to ensure the provided value is in fact a GraphQLSchema.
	  assertSchema(schema); // If this Schema has already been validated, return the previous results.

	  if (schema.__validationErrors) {
	    return schema.__validationErrors;
	  } // Validate the schema, producing a list of errors.


	  var context = new SchemaValidationContext(schema);
	  validateRootTypes(context);
	  validateDirectives(context);
	  validateTypes(context); // Persist the results of validation before returning to ensure validation
	  // does not run multiple times for this schema.

	  var errors = context.getErrors();
	  schema.__validationErrors = errors;
	  return errors;
	}
	/**
	 * Utility function which asserts a schema is valid by throwing an error if
	 * it is invalid.
	 */

	function assertValidSchema(schema) {
	  var errors = validateSchema$1(schema);

	  if (errors.length !== 0) {
	    throw new Error(errors.map(function (error) {
	      return error.message;
	    }).join('\n\n'));
	  }
	}

	var SchemaValidationContext = /*#__PURE__*/function () {
	  function SchemaValidationContext(schema) {
	    this._errors = [];
	    this.schema = schema;
	  }

	  var _proto = SchemaValidationContext.prototype;

	  _proto.reportError = function reportError(message, nodes) {
	    var _nodes = Array.isArray(nodes) ? nodes.filter(Boolean) : nodes;

	    this.addError(new GraphQLError(message, _nodes));
	  };

	  _proto.addError = function addError(error) {
	    this._errors.push(error);
	  };

	  _proto.getErrors = function getErrors() {
	    return this._errors;
	  };

	  return SchemaValidationContext;
	}();

	function validateRootTypes(context) {
	  var schema = context.schema;
	  var queryType = schema.getQueryType();

	  if (!queryType) {
	    context.reportError('Query root type must be provided.', schema.astNode);
	  } else if (!isObjectType(queryType)) {
	    var _getOperationTypeNode;

	    context.reportError("Query root type must be Object type, it cannot be ".concat(inspect$2(queryType), "."), (_getOperationTypeNode = getOperationTypeNode(schema, 'query')) !== null && _getOperationTypeNode !== void 0 ? _getOperationTypeNode : queryType.astNode);
	  }

	  var mutationType = schema.getMutationType();

	  if (mutationType && !isObjectType(mutationType)) {
	    var _getOperationTypeNode2;

	    context.reportError('Mutation root type must be Object type if provided, it cannot be ' + "".concat(inspect$2(mutationType), "."), (_getOperationTypeNode2 = getOperationTypeNode(schema, 'mutation')) !== null && _getOperationTypeNode2 !== void 0 ? _getOperationTypeNode2 : mutationType.astNode);
	  }

	  var subscriptionType = schema.getSubscriptionType();

	  if (subscriptionType && !isObjectType(subscriptionType)) {
	    var _getOperationTypeNode3;

	    context.reportError('Subscription root type must be Object type if provided, it cannot be ' + "".concat(inspect$2(subscriptionType), "."), (_getOperationTypeNode3 = getOperationTypeNode(schema, 'subscription')) !== null && _getOperationTypeNode3 !== void 0 ? _getOperationTypeNode3 : subscriptionType.astNode);
	  }
	}

	function getOperationTypeNode(schema, operation) {
	  var operationNodes = getAllSubNodes(schema, function (node) {
	    return node.operationTypes;
	  });

	  for (var _i2 = 0; _i2 < operationNodes.length; _i2++) {
	    var node = operationNodes[_i2];

	    if (node.operation === operation) {
	      return node.type;
	    }
	  }

	  return undefined;
	}

	function validateDirectives(context) {
	  for (var _i4 = 0, _context$schema$getDi2 = context.schema.getDirectives(); _i4 < _context$schema$getDi2.length; _i4++) {
	    var directive = _context$schema$getDi2[_i4];

	    // Ensure all directives are in fact GraphQL directives.
	    if (!isDirective(directive)) {
	      context.reportError("Expected directive but got: ".concat(inspect$2(directive), "."), directive === null || directive === void 0 ? void 0 : directive.astNode);
	      continue;
	    } // Ensure they are named correctly.


	    validateName(context, directive); // TODO: Ensure proper locations.
	    // Ensure the arguments are valid.

	    for (var _i6 = 0, _directive$args2 = directive.args; _i6 < _directive$args2.length; _i6++) {
	      var arg = _directive$args2[_i6];
	      // Ensure they are named correctly.
	      validateName(context, arg); // Ensure the type is an input type.

	      if (!isInputType(arg.type)) {
	        context.reportError("The type of @".concat(directive.name, "(").concat(arg.name, ":) must be Input Type ") + "but got: ".concat(inspect$2(arg.type), "."), arg.astNode);
	      }

	      if (isRequiredArgument(arg) && arg.deprecationReason != null) {
	        var _arg$astNode;

	        context.reportError("Required argument @".concat(directive.name, "(").concat(arg.name, ":) cannot be deprecated."), [getDeprecatedDirectiveNode(arg.astNode), // istanbul ignore next (TODO need to write coverage tests)
	        (_arg$astNode = arg.astNode) === null || _arg$astNode === void 0 ? void 0 : _arg$astNode.type]);
	      }
	    }
	  }
	}

	function validateName(context, node) {
	  // Ensure names are valid, however introspection types opt out.
	  var error = isValidNameError(node.name);

	  if (error) {
	    context.addError(locatedError(error, node.astNode));
	  }
	}

	function validateTypes(context) {
	  var validateInputObjectCircularRefs = createInputObjectCircularRefsValidator(context);
	  var typeMap = context.schema.getTypeMap();

	  for (var _i8 = 0, _objectValues2 = objectValues$1(typeMap); _i8 < _objectValues2.length; _i8++) {
	    var type = _objectValues2[_i8];

	    // Ensure all provided types are in fact GraphQL type.
	    if (!isNamedType(type)) {
	      context.reportError("Expected GraphQL named type but got: ".concat(inspect$2(type), "."), type.astNode);
	      continue;
	    } // Ensure it is named correctly (excluding introspection types).


	    if (!isIntrospectionType(type)) {
	      validateName(context, type);
	    }

	    if (isObjectType(type)) {
	      // Ensure fields are valid
	      validateFields(context, type); // Ensure objects implement the interfaces they claim to.

	      validateInterfaces(context, type);
	    } else if (isInterfaceType(type)) {
	      // Ensure fields are valid.
	      validateFields(context, type); // Ensure interfaces implement the interfaces they claim to.

	      validateInterfaces(context, type);
	    } else if (isUnionType(type)) {
	      // Ensure Unions include valid member types.
	      validateUnionMembers(context, type);
	    } else if (isEnumType(type)) {
	      // Ensure Enums have valid values.
	      validateEnumValues(context, type);
	    } else if (isInputObjectType(type)) {
	      // Ensure Input Object fields are valid.
	      validateInputFields(context, type); // Ensure Input Objects do not contain non-nullable circular references

	      validateInputObjectCircularRefs(type);
	    }
	  }
	}

	function validateFields(context, type) {
	  var fields = objectValues$1(type.getFields()); // Objects and Interfaces both must define one or more fields.

	  if (fields.length === 0) {
	    context.reportError("Type ".concat(type.name, " must define one or more fields."), getAllNodes(type));
	  }

	  for (var _i10 = 0; _i10 < fields.length; _i10++) {
	    var field = fields[_i10];
	    // Ensure they are named correctly.
	    validateName(context, field); // Ensure the type is an output type

	    if (!isOutputType(field.type)) {
	      var _field$astNode;

	      context.reportError("The type of ".concat(type.name, ".").concat(field.name, " must be Output Type ") + "but got: ".concat(inspect$2(field.type), "."), (_field$astNode = field.astNode) === null || _field$astNode === void 0 ? void 0 : _field$astNode.type);
	    } // Ensure the arguments are valid


	    for (var _i12 = 0, _field$args2 = field.args; _i12 < _field$args2.length; _i12++) {
	      var arg = _field$args2[_i12];
	      var argName = arg.name; // Ensure they are named correctly.

	      validateName(context, arg); // Ensure the type is an input type

	      if (!isInputType(arg.type)) {
	        var _arg$astNode2;

	        context.reportError("The type of ".concat(type.name, ".").concat(field.name, "(").concat(argName, ":) must be Input ") + "Type but got: ".concat(inspect$2(arg.type), "."), (_arg$astNode2 = arg.astNode) === null || _arg$astNode2 === void 0 ? void 0 : _arg$astNode2.type);
	      }

	      if (isRequiredArgument(arg) && arg.deprecationReason != null) {
	        var _arg$astNode3;

	        context.reportError("Required argument ".concat(type.name, ".").concat(field.name, "(").concat(argName, ":) cannot be deprecated."), [getDeprecatedDirectiveNode(arg.astNode), // istanbul ignore next (TODO need to write coverage tests)
	        (_arg$astNode3 = arg.astNode) === null || _arg$astNode3 === void 0 ? void 0 : _arg$astNode3.type]);
	      }
	    }
	  }
	}

	function validateInterfaces(context, type) {
	  var ifaceTypeNames = Object.create(null);

	  for (var _i14 = 0, _type$getInterfaces2 = type.getInterfaces(); _i14 < _type$getInterfaces2.length; _i14++) {
	    var iface = _type$getInterfaces2[_i14];

	    if (!isInterfaceType(iface)) {
	      context.reportError("Type ".concat(inspect$2(type), " must only implement Interface types, ") + "it cannot implement ".concat(inspect$2(iface), "."), getAllImplementsInterfaceNodes(type, iface));
	      continue;
	    }

	    if (type === iface) {
	      context.reportError("Type ".concat(type.name, " cannot implement itself because it would create a circular reference."), getAllImplementsInterfaceNodes(type, iface));
	      continue;
	    }

	    if (ifaceTypeNames[iface.name]) {
	      context.reportError("Type ".concat(type.name, " can only implement ").concat(iface.name, " once."), getAllImplementsInterfaceNodes(type, iface));
	      continue;
	    }

	    ifaceTypeNames[iface.name] = true;
	    validateTypeImplementsAncestors(context, type, iface);
	    validateTypeImplementsInterface(context, type, iface);
	  }
	}

	function validateTypeImplementsInterface(context, type, iface) {
	  var typeFieldMap = type.getFields(); // Assert each interface field is implemented.

	  for (var _i16 = 0, _objectValues4 = objectValues$1(iface.getFields()); _i16 < _objectValues4.length; _i16++) {
	    var ifaceField = _objectValues4[_i16];
	    var fieldName = ifaceField.name;
	    var typeField = typeFieldMap[fieldName]; // Assert interface field exists on type.

	    if (!typeField) {
	      context.reportError("Interface field ".concat(iface.name, ".").concat(fieldName, " expected but ").concat(type.name, " does not provide it."), [ifaceField.astNode].concat(getAllNodes(type)));
	      continue;
	    } // Assert interface field type is satisfied by type field type, by being
	    // a valid subtype. (covariant)


	    if (!isTypeSubTypeOf(context.schema, typeField.type, ifaceField.type)) {
	      var _ifaceField$astNode, _typeField$astNode;

	      context.reportError("Interface field ".concat(iface.name, ".").concat(fieldName, " expects type ") + "".concat(inspect$2(ifaceField.type), " but ").concat(type.name, ".").concat(fieldName, " ") + "is type ".concat(inspect$2(typeField.type), "."), [// istanbul ignore next (TODO need to write coverage tests)
	      (_ifaceField$astNode = ifaceField.astNode) === null || _ifaceField$astNode === void 0 ? void 0 : _ifaceField$astNode.type, // istanbul ignore next (TODO need to write coverage tests)
	      (_typeField$astNode = typeField.astNode) === null || _typeField$astNode === void 0 ? void 0 : _typeField$astNode.type]);
	    } // Assert each interface field arg is implemented.


	    var _loop = function _loop(_i18, _ifaceField$args2) {
	      var ifaceArg = _ifaceField$args2[_i18];
	      var argName = ifaceArg.name;
	      var typeArg = find$1(typeField.args, function (arg) {
	        return arg.name === argName;
	      }); // Assert interface field arg exists on object field.

	      if (!typeArg) {
	        context.reportError("Interface field argument ".concat(iface.name, ".").concat(fieldName, "(").concat(argName, ":) expected but ").concat(type.name, ".").concat(fieldName, " does not provide it."), [ifaceArg.astNode, typeField.astNode]);
	        return "continue";
	      } // Assert interface field arg type matches object field arg type.
	      // (invariant)
	      // TODO: change to contravariant?


	      if (!isEqualType(ifaceArg.type, typeArg.type)) {
	        var _ifaceArg$astNode, _typeArg$astNode;

	        context.reportError("Interface field argument ".concat(iface.name, ".").concat(fieldName, "(").concat(argName, ":) ") + "expects type ".concat(inspect$2(ifaceArg.type), " but ") + "".concat(type.name, ".").concat(fieldName, "(").concat(argName, ":) is type ") + "".concat(inspect$2(typeArg.type), "."), [// istanbul ignore next (TODO need to write coverage tests)
	        (_ifaceArg$astNode = ifaceArg.astNode) === null || _ifaceArg$astNode === void 0 ? void 0 : _ifaceArg$astNode.type, // istanbul ignore next (TODO need to write coverage tests)
	        (_typeArg$astNode = typeArg.astNode) === null || _typeArg$astNode === void 0 ? void 0 : _typeArg$astNode.type]);
	      } // TODO: validate default values?

	    };

	    for (var _i18 = 0, _ifaceField$args2 = ifaceField.args; _i18 < _ifaceField$args2.length; _i18++) {
	      var _ret = _loop(_i18, _ifaceField$args2);

	      if (_ret === "continue") continue;
	    } // Assert additional arguments must not be required.


	    var _loop2 = function _loop2(_i20, _typeField$args2) {
	      var typeArg = _typeField$args2[_i20];
	      var argName = typeArg.name;
	      var ifaceArg = find$1(ifaceField.args, function (arg) {
	        return arg.name === argName;
	      });

	      if (!ifaceArg && isRequiredArgument(typeArg)) {
	        context.reportError("Object field ".concat(type.name, ".").concat(fieldName, " includes required argument ").concat(argName, " that is missing from the Interface field ").concat(iface.name, ".").concat(fieldName, "."), [typeArg.astNode, ifaceField.astNode]);
	      }
	    };

	    for (var _i20 = 0, _typeField$args2 = typeField.args; _i20 < _typeField$args2.length; _i20++) {
	      _loop2(_i20, _typeField$args2);
	    }
	  }
	}

	function validateTypeImplementsAncestors(context, type, iface) {
	  var ifaceInterfaces = type.getInterfaces();

	  for (var _i22 = 0, _iface$getInterfaces2 = iface.getInterfaces(); _i22 < _iface$getInterfaces2.length; _i22++) {
	    var transitive = _iface$getInterfaces2[_i22];

	    if (ifaceInterfaces.indexOf(transitive) === -1) {
	      context.reportError(transitive === type ? "Type ".concat(type.name, " cannot implement ").concat(iface.name, " because it would create a circular reference.") : "Type ".concat(type.name, " must implement ").concat(transitive.name, " because it is implemented by ").concat(iface.name, "."), [].concat(getAllImplementsInterfaceNodes(iface, transitive), getAllImplementsInterfaceNodes(type, iface)));
	    }
	  }
	}

	function validateUnionMembers(context, union) {
	  var memberTypes = union.getTypes();

	  if (memberTypes.length === 0) {
	    context.reportError("Union type ".concat(union.name, " must define one or more member types."), getAllNodes(union));
	  }

	  var includedTypeNames = Object.create(null);

	  for (var _i24 = 0; _i24 < memberTypes.length; _i24++) {
	    var memberType = memberTypes[_i24];

	    if (includedTypeNames[memberType.name]) {
	      context.reportError("Union type ".concat(union.name, " can only include type ").concat(memberType.name, " once."), getUnionMemberTypeNodes(union, memberType.name));
	      continue;
	    }

	    includedTypeNames[memberType.name] = true;

	    if (!isObjectType(memberType)) {
	      context.reportError("Union type ".concat(union.name, " can only include Object types, ") + "it cannot include ".concat(inspect$2(memberType), "."), getUnionMemberTypeNodes(union, String(memberType)));
	    }
	  }
	}

	function validateEnumValues(context, enumType) {
	  var enumValues = enumType.getValues();

	  if (enumValues.length === 0) {
	    context.reportError("Enum type ".concat(enumType.name, " must define one or more values."), getAllNodes(enumType));
	  }

	  for (var _i26 = 0; _i26 < enumValues.length; _i26++) {
	    var enumValue = enumValues[_i26];
	    var valueName = enumValue.name; // Ensure valid name.

	    validateName(context, enumValue);

	    if (valueName === 'true' || valueName === 'false' || valueName === 'null') {
	      context.reportError("Enum type ".concat(enumType.name, " cannot include value: ").concat(valueName, "."), enumValue.astNode);
	    }
	  }
	}

	function validateInputFields(context, inputObj) {
	  var fields = objectValues$1(inputObj.getFields());

	  if (fields.length === 0) {
	    context.reportError("Input Object type ".concat(inputObj.name, " must define one or more fields."), getAllNodes(inputObj));
	  } // Ensure the arguments are valid


	  for (var _i28 = 0; _i28 < fields.length; _i28++) {
	    var field = fields[_i28];
	    // Ensure they are named correctly.
	    validateName(context, field); // Ensure the type is an input type

	    if (!isInputType(field.type)) {
	      var _field$astNode2;

	      context.reportError("The type of ".concat(inputObj.name, ".").concat(field.name, " must be Input Type ") + "but got: ".concat(inspect$2(field.type), "."), (_field$astNode2 = field.astNode) === null || _field$astNode2 === void 0 ? void 0 : _field$astNode2.type);
	    }

	    if (isRequiredInputField(field) && field.deprecationReason != null) {
	      var _field$astNode3;

	      context.reportError("Required input field ".concat(inputObj.name, ".").concat(field.name, " cannot be deprecated."), [getDeprecatedDirectiveNode(field.astNode), // istanbul ignore next (TODO need to write coverage tests)
	      (_field$astNode3 = field.astNode) === null || _field$astNode3 === void 0 ? void 0 : _field$astNode3.type]);
	    }
	  }
	}

	function createInputObjectCircularRefsValidator(context) {
	  // Modified copy of algorithm from 'src/validation/rules/NoFragmentCycles.js'.
	  // Tracks already visited types to maintain O(N) and to ensure that cycles
	  // are not redundantly reported.
	  var visitedTypes = Object.create(null); // Array of types nodes used to produce meaningful errors

	  var fieldPath = []; // Position in the type path

	  var fieldPathIndexByTypeName = Object.create(null);
	  return detectCycleRecursive; // This does a straight-forward DFS to find cycles.
	  // It does not terminate when a cycle was found but continues to explore
	  // the graph to find all possible cycles.

	  function detectCycleRecursive(inputObj) {
	    if (visitedTypes[inputObj.name]) {
	      return;
	    }

	    visitedTypes[inputObj.name] = true;
	    fieldPathIndexByTypeName[inputObj.name] = fieldPath.length;
	    var fields = objectValues$1(inputObj.getFields());

	    for (var _i30 = 0; _i30 < fields.length; _i30++) {
	      var field = fields[_i30];

	      if (isNonNullType(field.type) && isInputObjectType(field.type.ofType)) {
	        var fieldType = field.type.ofType;
	        var cycleIndex = fieldPathIndexByTypeName[fieldType.name];
	        fieldPath.push(field);

	        if (cycleIndex === undefined) {
	          detectCycleRecursive(fieldType);
	        } else {
	          var cyclePath = fieldPath.slice(cycleIndex);
	          var pathStr = cyclePath.map(function (fieldObj) {
	            return fieldObj.name;
	          }).join('.');
	          context.reportError("Cannot reference Input Object \"".concat(fieldType.name, "\" within itself through a series of non-null fields: \"").concat(pathStr, "\"."), cyclePath.map(function (fieldObj) {
	            return fieldObj.astNode;
	          }));
	        }

	        fieldPath.pop();
	      }
	    }

	    fieldPathIndexByTypeName[inputObj.name] = undefined;
	  }
	}

	function getAllNodes(object) {
	  var astNode = object.astNode,
	      extensionASTNodes = object.extensionASTNodes;
	  return astNode ? extensionASTNodes ? [astNode].concat(extensionASTNodes) : [astNode] : extensionASTNodes !== null && extensionASTNodes !== void 0 ? extensionASTNodes : [];
	}

	function getAllSubNodes(object, getter) {
	  var subNodes = [];

	  for (var _i32 = 0, _getAllNodes2 = getAllNodes(object); _i32 < _getAllNodes2.length; _i32++) {
	    var _getter;

	    var node = _getAllNodes2[_i32];
	    // istanbul ignore next (See: 'https://github.com/graphql/graphql-js/issues/2203')
	    subNodes = subNodes.concat((_getter = getter(node)) !== null && _getter !== void 0 ? _getter : []);
	  }

	  return subNodes;
	}

	function getAllImplementsInterfaceNodes(type, iface) {
	  return getAllSubNodes(type, function (typeNode) {
	    return typeNode.interfaces;
	  }).filter(function (ifaceNode) {
	    return ifaceNode.name.value === iface.name;
	  });
	}

	function getUnionMemberTypeNodes(union, typeName) {
	  return getAllSubNodes(union, function (unionNode) {
	    return unionNode.types;
	  }).filter(function (typeNode) {
	    return typeNode.name.value === typeName;
	  });
	}

	function getDeprecatedDirectiveNode(definitionNode) {
	  var _definitionNode$direc;

	  // istanbul ignore next (See: 'https://github.com/graphql/graphql-js/issues/2203')
	  return definitionNode === null || definitionNode === void 0 ? void 0 : (_definitionNode$direc = definitionNode.directives) === null || _definitionNode$direc === void 0 ? void 0 : _definitionNode$direc.find(function (node) {
	    return node.name.value === GraphQLDeprecatedDirective.name;
	  });
	}

	/**
	 * Given a Schema and an AST node describing a type, return a GraphQLType
	 * definition which applies to that type. For example, if provided the parsed
	 * AST node for `[User]`, a GraphQLList instance will be returned, containing
	 * the type called "User" found in the schema. If a type called "User" is not
	 * found in the schema, then undefined will be returned.
	 */

	/* eslint-disable no-redeclare */

	function typeFromAST(schema, typeNode) {
	  /* eslint-enable no-redeclare */
	  var innerType;

	  if (typeNode.kind === Kind.LIST_TYPE) {
	    innerType = typeFromAST(schema, typeNode.type);
	    return innerType && new GraphQLList(innerType);
	  }

	  if (typeNode.kind === Kind.NON_NULL_TYPE) {
	    innerType = typeFromAST(schema, typeNode.type);
	    return innerType && new GraphQLNonNull(innerType);
	  } // istanbul ignore else (See: 'https://github.com/graphql/graphql-js/issues/2618')


	  if (typeNode.kind === Kind.NAMED_TYPE) {
	    return schema.getType(typeNode.name.value);
	  } // istanbul ignore next (Not reachable. All possible type nodes have been considered)


	  invariant(0, 'Unexpected type node: ' + inspect$2(typeNode));
	}

	/**
	 * TypeInfo is a utility class which, given a GraphQL schema, can keep track
	 * of the current field and type definitions at any point in a GraphQL document
	 * AST during a recursive descent by calling `enter(node)` and `leave(node)`.
	 */

	var TypeInfo = /*#__PURE__*/function () {
	  function TypeInfo(schema, // NOTE: this experimental optional second parameter is only needed in order
	  // to support non-spec-compliant code bases. You should never need to use it.
	  // It may disappear in the future.
	  getFieldDefFn, // Initial type may be provided in rare cases to facilitate traversals
	  // beginning somewhere other than documents.
	  initialType) {
	    this._schema = schema;
	    this._typeStack = [];
	    this._parentTypeStack = [];
	    this._inputTypeStack = [];
	    this._fieldDefStack = [];
	    this._defaultValueStack = [];
	    this._directive = null;
	    this._argument = null;
	    this._enumValue = null;
	    this._getFieldDef = getFieldDefFn !== null && getFieldDefFn !== void 0 ? getFieldDefFn : getFieldDef$1;

	    if (initialType) {
	      if (isInputType(initialType)) {
	        this._inputTypeStack.push(initialType);
	      }

	      if (isCompositeType(initialType)) {
	        this._parentTypeStack.push(initialType);
	      }

	      if (isOutputType(initialType)) {
	        this._typeStack.push(initialType);
	      }
	    }
	  }

	  var _proto = TypeInfo.prototype;

	  _proto.getType = function getType() {
	    if (this._typeStack.length > 0) {
	      return this._typeStack[this._typeStack.length - 1];
	    }
	  };

	  _proto.getParentType = function getParentType() {
	    if (this._parentTypeStack.length > 0) {
	      return this._parentTypeStack[this._parentTypeStack.length - 1];
	    }
	  };

	  _proto.getInputType = function getInputType() {
	    if (this._inputTypeStack.length > 0) {
	      return this._inputTypeStack[this._inputTypeStack.length - 1];
	    }
	  };

	  _proto.getParentInputType = function getParentInputType() {
	    if (this._inputTypeStack.length > 1) {
	      return this._inputTypeStack[this._inputTypeStack.length - 2];
	    }
	  };

	  _proto.getFieldDef = function getFieldDef() {
	    if (this._fieldDefStack.length > 0) {
	      return this._fieldDefStack[this._fieldDefStack.length - 1];
	    }
	  };

	  _proto.getDefaultValue = function getDefaultValue() {
	    if (this._defaultValueStack.length > 0) {
	      return this._defaultValueStack[this._defaultValueStack.length - 1];
	    }
	  };

	  _proto.getDirective = function getDirective() {
	    return this._directive;
	  };

	  _proto.getArgument = function getArgument() {
	    return this._argument;
	  };

	  _proto.getEnumValue = function getEnumValue() {
	    return this._enumValue;
	  };

	  _proto.enter = function enter(node) {
	    var schema = this._schema; // Note: many of the types below are explicitly typed as "mixed" to drop
	    // any assumptions of a valid schema to ensure runtime types are properly
	    // checked before continuing since TypeInfo is used as part of validation
	    // which occurs before guarantees of schema and document validity.

	    switch (node.kind) {
	      case Kind.SELECTION_SET:
	        {
	          var namedType = getNamedType(this.getType());

	          this._parentTypeStack.push(isCompositeType(namedType) ? namedType : undefined);

	          break;
	        }

	      case Kind.FIELD:
	        {
	          var parentType = this.getParentType();
	          var fieldDef;
	          var fieldType;

	          if (parentType) {
	            fieldDef = this._getFieldDef(schema, parentType, node);

	            if (fieldDef) {
	              fieldType = fieldDef.type;
	            }
	          }

	          this._fieldDefStack.push(fieldDef);

	          this._typeStack.push(isOutputType(fieldType) ? fieldType : undefined);

	          break;
	        }

	      case Kind.DIRECTIVE:
	        this._directive = schema.getDirective(node.name.value);
	        break;

	      case Kind.OPERATION_DEFINITION:
	        {
	          var type;

	          switch (node.operation) {
	            case 'query':
	              type = schema.getQueryType();
	              break;

	            case 'mutation':
	              type = schema.getMutationType();
	              break;

	            case 'subscription':
	              type = schema.getSubscriptionType();
	              break;
	          }

	          this._typeStack.push(isObjectType(type) ? type : undefined);

	          break;
	        }

	      case Kind.INLINE_FRAGMENT:
	      case Kind.FRAGMENT_DEFINITION:
	        {
	          var typeConditionAST = node.typeCondition;
	          var outputType = typeConditionAST ? typeFromAST(schema, typeConditionAST) : getNamedType(this.getType());

	          this._typeStack.push(isOutputType(outputType) ? outputType : undefined);

	          break;
	        }

	      case Kind.VARIABLE_DEFINITION:
	        {
	          var inputType = typeFromAST(schema, node.type);

	          this._inputTypeStack.push(isInputType(inputType) ? inputType : undefined);

	          break;
	        }

	      case Kind.ARGUMENT:
	        {
	          var _this$getDirective;

	          var argDef;
	          var argType;
	          var fieldOrDirective = (_this$getDirective = this.getDirective()) !== null && _this$getDirective !== void 0 ? _this$getDirective : this.getFieldDef();

	          if (fieldOrDirective) {
	            argDef = find$1(fieldOrDirective.args, function (arg) {
	              return arg.name === node.name.value;
	            });

	            if (argDef) {
	              argType = argDef.type;
	            }
	          }

	          this._argument = argDef;

	          this._defaultValueStack.push(argDef ? argDef.defaultValue : undefined);

	          this._inputTypeStack.push(isInputType(argType) ? argType : undefined);

	          break;
	        }

	      case Kind.LIST:
	        {
	          var listType = getNullableType(this.getInputType());
	          var itemType = isListType(listType) ? listType.ofType : listType; // List positions never have a default value.

	          this._defaultValueStack.push(undefined);

	          this._inputTypeStack.push(isInputType(itemType) ? itemType : undefined);

	          break;
	        }

	      case Kind.OBJECT_FIELD:
	        {
	          var objectType = getNamedType(this.getInputType());
	          var inputFieldType;
	          var inputField;

	          if (isInputObjectType(objectType)) {
	            inputField = objectType.getFields()[node.name.value];

	            if (inputField) {
	              inputFieldType = inputField.type;
	            }
	          }

	          this._defaultValueStack.push(inputField ? inputField.defaultValue : undefined);

	          this._inputTypeStack.push(isInputType(inputFieldType) ? inputFieldType : undefined);

	          break;
	        }

	      case Kind.ENUM:
	        {
	          var enumType = getNamedType(this.getInputType());
	          var enumValue;

	          if (isEnumType(enumType)) {
	            enumValue = enumType.getValue(node.value);
	          }

	          this._enumValue = enumValue;
	          break;
	        }
	    }
	  };

	  _proto.leave = function leave(node) {
	    switch (node.kind) {
	      case Kind.SELECTION_SET:
	        this._parentTypeStack.pop();

	        break;

	      case Kind.FIELD:
	        this._fieldDefStack.pop();

	        this._typeStack.pop();

	        break;

	      case Kind.DIRECTIVE:
	        this._directive = null;
	        break;

	      case Kind.OPERATION_DEFINITION:
	      case Kind.INLINE_FRAGMENT:
	      case Kind.FRAGMENT_DEFINITION:
	        this._typeStack.pop();

	        break;

	      case Kind.VARIABLE_DEFINITION:
	        this._inputTypeStack.pop();

	        break;

	      case Kind.ARGUMENT:
	        this._argument = null;

	        this._defaultValueStack.pop();

	        this._inputTypeStack.pop();

	        break;

	      case Kind.LIST:
	      case Kind.OBJECT_FIELD:
	        this._defaultValueStack.pop();

	        this._inputTypeStack.pop();

	        break;

	      case Kind.ENUM:
	        this._enumValue = null;
	        break;
	    }
	  };

	  return TypeInfo;
	}();
	/**
	 * Not exactly the same as the executor's definition of getFieldDef, in this
	 * statically evaluated environment we do not always have an Object type,
	 * and need to handle Interface and Union types.
	 */

	function getFieldDef$1(schema, parentType, fieldNode) {
	  var name = fieldNode.name.value;

	  if (name === SchemaMetaFieldDef.name && schema.getQueryType() === parentType) {
	    return SchemaMetaFieldDef;
	  }

	  if (name === TypeMetaFieldDef.name && schema.getQueryType() === parentType) {
	    return TypeMetaFieldDef;
	  }

	  if (name === TypeNameMetaFieldDef.name && isCompositeType(parentType)) {
	    return TypeNameMetaFieldDef;
	  }

	  if (isObjectType(parentType) || isInterfaceType(parentType)) {
	    return parentType.getFields()[name];
	  }
	}
	/**
	 * Creates a new visitor instance which maintains a provided TypeInfo instance
	 * along with visiting visitor.
	 */


	function visitWithTypeInfo(typeInfo, visitor) {
	  return {
	    enter: function enter(node) {
	      typeInfo.enter(node);
	      var fn = getVisitFn(visitor, node.kind,
	      /* isLeaving */
	      false);

	      if (fn) {
	        var result = fn.apply(visitor, arguments);

	        if (result !== undefined) {
	          typeInfo.leave(node);

	          if (isNode(result)) {
	            typeInfo.enter(result);
	          }
	        }

	        return result;
	      }
	    },
	    leave: function leave(node) {
	      var fn = getVisitFn(visitor, node.kind,
	      /* isLeaving */
	      true);
	      var result;

	      if (fn) {
	        result = fn.apply(visitor, arguments);
	      }

	      typeInfo.leave(node);
	      return result;
	    }
	  };
	}

	function isDefinitionNode(node) {
	  return isExecutableDefinitionNode(node) || isTypeSystemDefinitionNode(node) || isTypeSystemExtensionNode(node);
	}
	function isExecutableDefinitionNode(node) {
	  return node.kind === Kind.OPERATION_DEFINITION || node.kind === Kind.FRAGMENT_DEFINITION;
	}
	function isSelectionNode(node) {
	  return node.kind === Kind.FIELD || node.kind === Kind.FRAGMENT_SPREAD || node.kind === Kind.INLINE_FRAGMENT;
	}
	function isValueNode(node) {
	  return node.kind === Kind.VARIABLE || node.kind === Kind.INT || node.kind === Kind.FLOAT || node.kind === Kind.STRING || node.kind === Kind.BOOLEAN || node.kind === Kind.NULL || node.kind === Kind.ENUM || node.kind === Kind.LIST || node.kind === Kind.OBJECT;
	}
	function isTypeNode(node) {
	  return node.kind === Kind.NAMED_TYPE || node.kind === Kind.LIST_TYPE || node.kind === Kind.NON_NULL_TYPE;
	}
	function isTypeSystemDefinitionNode(node) {
	  return node.kind === Kind.SCHEMA_DEFINITION || isTypeDefinitionNode(node) || node.kind === Kind.DIRECTIVE_DEFINITION;
	}
	function isTypeDefinitionNode(node) {
	  return node.kind === Kind.SCALAR_TYPE_DEFINITION || node.kind === Kind.OBJECT_TYPE_DEFINITION || node.kind === Kind.INTERFACE_TYPE_DEFINITION || node.kind === Kind.UNION_TYPE_DEFINITION || node.kind === Kind.ENUM_TYPE_DEFINITION || node.kind === Kind.INPUT_OBJECT_TYPE_DEFINITION;
	}
	function isTypeSystemExtensionNode(node) {
	  return node.kind === Kind.SCHEMA_EXTENSION || isTypeExtensionNode(node);
	}
	function isTypeExtensionNode(node) {
	  return node.kind === Kind.SCALAR_TYPE_EXTENSION || node.kind === Kind.OBJECT_TYPE_EXTENSION || node.kind === Kind.INTERFACE_TYPE_EXTENSION || node.kind === Kind.UNION_TYPE_EXTENSION || node.kind === Kind.ENUM_TYPE_EXTENSION || node.kind === Kind.INPUT_OBJECT_TYPE_EXTENSION;
	}

	/**
	 * Executable definitions
	 *
	 * A GraphQL document is only valid for execution if all definitions are either
	 * operation or fragment definitions.
	 */
	function ExecutableDefinitionsRule(context) {
	  return {
	    Document: function Document(node) {
	      for (var _i2 = 0, _node$definitions2 = node.definitions; _i2 < _node$definitions2.length; _i2++) {
	        var definition = _node$definitions2[_i2];

	        if (!isExecutableDefinitionNode(definition)) {
	          var defName = definition.kind === Kind.SCHEMA_DEFINITION || definition.kind === Kind.SCHEMA_EXTENSION ? 'schema' : '"' + definition.name.value + '"';
	          context.reportError(new GraphQLError("The ".concat(defName, " definition is not executable."), definition));
	        }
	      }

	      return false;
	    }
	  };
	}

	/**
	 * Unique operation names
	 *
	 * A GraphQL document is only valid if all defined operations have unique names.
	 */
	function UniqueOperationNamesRule(context) {
	  var knownOperationNames = Object.create(null);
	  return {
	    OperationDefinition: function OperationDefinition(node) {
	      var operationName = node.name;

	      if (operationName) {
	        if (knownOperationNames[operationName.value]) {
	          context.reportError(new GraphQLError("There can be only one operation named \"".concat(operationName.value, "\"."), [knownOperationNames[operationName.value], operationName]));
	        } else {
	          knownOperationNames[operationName.value] = operationName;
	        }
	      }

	      return false;
	    },
	    FragmentDefinition: function FragmentDefinition() {
	      return false;
	    }
	  };
	}

	/**
	 * Lone anonymous operation
	 *
	 * A GraphQL document is only valid if when it contains an anonymous operation
	 * (the query short-hand) that it contains only that one operation definition.
	 */
	function LoneAnonymousOperationRule(context) {
	  var operationCount = 0;
	  return {
	    Document: function Document(node) {
	      operationCount = node.definitions.filter(function (definition) {
	        return definition.kind === Kind.OPERATION_DEFINITION;
	      }).length;
	    },
	    OperationDefinition: function OperationDefinition(node) {
	      if (!node.name && operationCount > 1) {
	        context.reportError(new GraphQLError('This anonymous operation must be the only defined operation.', node));
	      }
	    }
	  };
	}

	/**
	 * Subscriptions must only include one field.
	 *
	 * A GraphQL subscription is valid only if it contains a single root field.
	 */
	function SingleFieldSubscriptionsRule(context) {
	  return {
	    OperationDefinition: function OperationDefinition(node) {
	      if (node.operation === 'subscription') {
	        if (node.selectionSet.selections.length !== 1) {
	          context.reportError(new GraphQLError(node.name ? "Subscription \"".concat(node.name.value, "\" must select only one top level field.") : 'Anonymous Subscription must select only one top level field.', node.selectionSet.selections.slice(1)));
	        }
	      }
	    }
	  };
	}

	/**
	 * Known type names
	 *
	 * A GraphQL document is only valid if referenced types (specifically
	 * variable definitions and fragment conditions) are defined by the type schema.
	 */
	function KnownTypeNamesRule(context) {
	  var schema = context.getSchema();
	  var existingTypesMap = schema ? schema.getTypeMap() : Object.create(null);
	  var definedTypes = Object.create(null);

	  for (var _i2 = 0, _context$getDocument$2 = context.getDocument().definitions; _i2 < _context$getDocument$2.length; _i2++) {
	    var def = _context$getDocument$2[_i2];

	    if (isTypeDefinitionNode(def)) {
	      definedTypes[def.name.value] = true;
	    }
	  }

	  var typeNames = Object.keys(existingTypesMap).concat(Object.keys(definedTypes));
	  return {
	    NamedType: function NamedType(node, _1, parent, _2, ancestors) {
	      var typeName = node.name.value;

	      if (!existingTypesMap[typeName] && !definedTypes[typeName]) {
	        var _ancestors$;

	        var definitionNode = (_ancestors$ = ancestors[2]) !== null && _ancestors$ !== void 0 ? _ancestors$ : parent;
	        var isSDL = definitionNode != null && isSDLNode$1(definitionNode);

	        if (isSDL && isStandardTypeName$1(typeName)) {
	          return;
	        }

	        var suggestedTypes = suggestionList$1(typeName, isSDL ? standardTypeNames$1.concat(typeNames) : typeNames);
	        context.reportError(new GraphQLError("Unknown type \"".concat(typeName, "\".") + didYouMean$1(suggestedTypes), node));
	      }
	    }
	  };
	}
	var standardTypeNames$1 = [].concat(specifiedScalarTypes, introspectionTypes).map(function (type) {
	  return type.name;
	});

	function isStandardTypeName$1(typeName) {
	  return standardTypeNames$1.indexOf(typeName) !== -1;
	}

	function isSDLNode$1(value) {
	  return !Array.isArray(value) && (isTypeSystemDefinitionNode(value) || isTypeSystemExtensionNode(value));
	}

	/**
	 * Fragments on composite type
	 *
	 * Fragments use a type condition to determine if they apply, since fragments
	 * can only be spread into a composite type (object, interface, or union), the
	 * type condition must also be a composite type.
	 */
	function FragmentsOnCompositeTypesRule(context) {
	  return {
	    InlineFragment: function InlineFragment(node) {
	      var typeCondition = node.typeCondition;

	      if (typeCondition) {
	        var type = typeFromAST(context.getSchema(), typeCondition);

	        if (type && !isCompositeType(type)) {
	          var typeStr = print$1(typeCondition);
	          context.reportError(new GraphQLError("Fragment cannot condition on non composite type \"".concat(typeStr, "\"."), typeCondition));
	        }
	      }
	    },
	    FragmentDefinition: function FragmentDefinition(node) {
	      var type = typeFromAST(context.getSchema(), node.typeCondition);

	      if (type && !isCompositeType(type)) {
	        var typeStr = print$1(node.typeCondition);
	        context.reportError(new GraphQLError("Fragment \"".concat(node.name.value, "\" cannot condition on non composite type \"").concat(typeStr, "\"."), node.typeCondition));
	      }
	    }
	  };
	}

	/**
	 * Variables are input types
	 *
	 * A GraphQL operation is only valid if all the variables it defines are of
	 * input types (scalar, enum, or input object).
	 */
	function VariablesAreInputTypesRule(context) {
	  return {
	    VariableDefinition: function VariableDefinition(node) {
	      var type = typeFromAST(context.getSchema(), node.type);

	      if (type && !isInputType(type)) {
	        var variableName = node.variable.name.value;
	        var typeName = print$1(node.type);
	        context.reportError(new GraphQLError("Variable \"$".concat(variableName, "\" cannot be non-input type \"").concat(typeName, "\"."), node.type));
	      }
	    }
	  };
	}

	/**
	 * Scalar leafs
	 *
	 * A GraphQL document is valid only if all leaf fields (fields without
	 * sub selections) are of scalar or enum types.
	 */
	function ScalarLeafsRule(context) {
	  return {
	    Field: function Field(node) {
	      var type = context.getType();
	      var selectionSet = node.selectionSet;

	      if (type) {
	        if (isLeafType(getNamedType(type))) {
	          if (selectionSet) {
	            var fieldName = node.name.value;
	            var typeStr = inspect$2(type);
	            context.reportError(new GraphQLError("Field \"".concat(fieldName, "\" must not have a selection since type \"").concat(typeStr, "\" has no subfields."), selectionSet));
	          }
	        } else if (!selectionSet) {
	          var _fieldName = node.name.value;

	          var _typeStr = inspect$2(type);

	          context.reportError(new GraphQLError("Field \"".concat(_fieldName, "\" of type \"").concat(_typeStr, "\" must have a selection of subfields. Did you mean \"").concat(_fieldName, " { ... }\"?"), node));
	        }
	      }
	    }
	  };
	}

	/**
	 * Fields on correct type
	 *
	 * A GraphQL document is only valid if all fields selected are defined by the
	 * parent type, or are an allowed meta field such as __typename.
	 */
	function FieldsOnCorrectTypeRule(context) {
	  return {
	    Field: function Field(node) {
	      var type = context.getParentType();

	      if (type) {
	        var fieldDef = context.getFieldDef();

	        if (!fieldDef) {
	          // This field doesn't exist, lets look for suggestions.
	          var schema = context.getSchema();
	          var fieldName = node.name.value; // First determine if there are any suggested types to condition on.

	          var suggestion = didYouMean$1('to use an inline fragment on', getSuggestedTypeNames(schema, type, fieldName)); // If there are no suggested types, then perhaps this was a typo?

	          if (suggestion === '') {
	            suggestion = didYouMean$1(getSuggestedFieldNames(type, fieldName));
	          } // Report an error, including helpful suggestions.


	          context.reportError(new GraphQLError("Cannot query field \"".concat(fieldName, "\" on type \"").concat(type.name, "\".") + suggestion, node));
	        }
	      }
	    }
	  };
	}
	/**
	 * Go through all of the implementations of type, as well as the interfaces that
	 * they implement. If any of those types include the provided field, suggest them,
	 * sorted by how often the type is referenced.
	 */

	function getSuggestedTypeNames(schema, type, fieldName) {
	  if (!isAbstractType(type)) {
	    // Must be an Object type, which does not have possible fields.
	    return [];
	  }

	  var suggestedTypes = new Set();
	  var usageCount = Object.create(null);

	  for (var _i2 = 0, _schema$getPossibleTy2 = schema.getPossibleTypes(type); _i2 < _schema$getPossibleTy2.length; _i2++) {
	    var possibleType = _schema$getPossibleTy2[_i2];

	    if (!possibleType.getFields()[fieldName]) {
	      continue;
	    } // This object type defines this field.


	    suggestedTypes.add(possibleType);
	    usageCount[possibleType.name] = 1;

	    for (var _i4 = 0, _possibleType$getInte2 = possibleType.getInterfaces(); _i4 < _possibleType$getInte2.length; _i4++) {
	      var _usageCount$possibleI;

	      var possibleInterface = _possibleType$getInte2[_i4];

	      if (!possibleInterface.getFields()[fieldName]) {
	        continue;
	      } // This interface type defines this field.


	      suggestedTypes.add(possibleInterface);
	      usageCount[possibleInterface.name] = ((_usageCount$possibleI = usageCount[possibleInterface.name]) !== null && _usageCount$possibleI !== void 0 ? _usageCount$possibleI : 0) + 1;
	    }
	  }

	  return arrayFrom$1(suggestedTypes).sort(function (typeA, typeB) {
	    // Suggest both interface and object types based on how common they are.
	    var usageCountDiff = usageCount[typeB.name] - usageCount[typeA.name];

	    if (usageCountDiff !== 0) {
	      return usageCountDiff;
	    } // Suggest super types first followed by subtypes


	    if (isInterfaceType(typeA) && schema.isSubType(typeA, typeB)) {
	      return -1;
	    }

	    if (isInterfaceType(typeB) && schema.isSubType(typeB, typeA)) {
	      return 1;
	    }

	    return naturalCompare(typeA.name, typeB.name);
	  }).map(function (x) {
	    return x.name;
	  });
	}
	/**
	 * For the field name provided, determine if there are any similar field names
	 * that may be the result of a typo.
	 */


	function getSuggestedFieldNames(type, fieldName) {
	  if (isObjectType(type) || isInterfaceType(type)) {
	    var possibleFieldNames = Object.keys(type.getFields());
	    return suggestionList$1(fieldName, possibleFieldNames);
	  } // Otherwise, must be a Union type, which does not define fields.


	  return [];
	}

	/**
	 * Unique fragment names
	 *
	 * A GraphQL document is only valid if all defined fragments have unique names.
	 */
	function UniqueFragmentNamesRule(context) {
	  var knownFragmentNames = Object.create(null);
	  return {
	    OperationDefinition: function OperationDefinition() {
	      return false;
	    },
	    FragmentDefinition: function FragmentDefinition(node) {
	      var fragmentName = node.name.value;

	      if (knownFragmentNames[fragmentName]) {
	        context.reportError(new GraphQLError("There can be only one fragment named \"".concat(fragmentName, "\"."), [knownFragmentNames[fragmentName], node.name]));
	      } else {
	        knownFragmentNames[fragmentName] = node.name;
	      }

	      return false;
	    }
	  };
	}

	/**
	 * Known fragment names
	 *
	 * A GraphQL document is only valid if all `...Fragment` fragment spreads refer
	 * to fragments defined in the same document.
	 */
	function KnownFragmentNamesRule(context) {
	  return {
	    FragmentSpread: function FragmentSpread(node) {
	      var fragmentName = node.name.value;
	      var fragment = context.getFragment(fragmentName);

	      if (!fragment) {
	        context.reportError(new GraphQLError("Unknown fragment \"".concat(fragmentName, "\"."), node.name));
	      }
	    }
	  };
	}

	/**
	 * No unused fragments
	 *
	 * A GraphQL document is only valid if all fragment definitions are spread
	 * within operations, or spread within other fragments spread within operations.
	 */
	function NoUnusedFragmentsRule(context) {
	  var operationDefs = [];
	  var fragmentDefs = [];
	  return {
	    OperationDefinition: function OperationDefinition(node) {
	      operationDefs.push(node);
	      return false;
	    },
	    FragmentDefinition: function FragmentDefinition(node) {
	      fragmentDefs.push(node);
	      return false;
	    },
	    Document: {
	      leave: function leave() {
	        var fragmentNameUsed = Object.create(null);

	        for (var _i2 = 0; _i2 < operationDefs.length; _i2++) {
	          var operation = operationDefs[_i2];

	          for (var _i4 = 0, _context$getRecursive2 = context.getRecursivelyReferencedFragments(operation); _i4 < _context$getRecursive2.length; _i4++) {
	            var fragment = _context$getRecursive2[_i4];
	            fragmentNameUsed[fragment.name.value] = true;
	          }
	        }

	        for (var _i6 = 0; _i6 < fragmentDefs.length; _i6++) {
	          var fragmentDef = fragmentDefs[_i6];
	          var fragName = fragmentDef.name.value;

	          if (fragmentNameUsed[fragName] !== true) {
	            context.reportError(new GraphQLError("Fragment \"".concat(fragName, "\" is never used."), fragmentDef));
	          }
	        }
	      }
	    }
	  };
	}

	/**
	 * Possible fragment spread
	 *
	 * A fragment spread is only valid if the type condition could ever possibly
	 * be true: if there is a non-empty intersection of the possible parent types,
	 * and possible types which pass the type condition.
	 */
	function PossibleFragmentSpreadsRule(context) {
	  return {
	    InlineFragment: function InlineFragment(node) {
	      var fragType = context.getType();
	      var parentType = context.getParentType();

	      if (isCompositeType(fragType) && isCompositeType(parentType) && !doTypesOverlap(context.getSchema(), fragType, parentType)) {
	        var parentTypeStr = inspect$2(parentType);
	        var fragTypeStr = inspect$2(fragType);
	        context.reportError(new GraphQLError("Fragment cannot be spread here as objects of type \"".concat(parentTypeStr, "\" can never be of type \"").concat(fragTypeStr, "\"."), node));
	      }
	    },
	    FragmentSpread: function FragmentSpread(node) {
	      var fragName = node.name.value;
	      var fragType = getFragmentType(context, fragName);
	      var parentType = context.getParentType();

	      if (fragType && parentType && !doTypesOverlap(context.getSchema(), fragType, parentType)) {
	        var parentTypeStr = inspect$2(parentType);
	        var fragTypeStr = inspect$2(fragType);
	        context.reportError(new GraphQLError("Fragment \"".concat(fragName, "\" cannot be spread here as objects of type \"").concat(parentTypeStr, "\" can never be of type \"").concat(fragTypeStr, "\"."), node));
	      }
	    }
	  };
	}

	function getFragmentType(context, name) {
	  var frag = context.getFragment(name);

	  if (frag) {
	    var type = typeFromAST(context.getSchema(), frag.typeCondition);

	    if (isCompositeType(type)) {
	      return type;
	    }
	  }
	}

	function NoFragmentCyclesRule(context) {
	  // Tracks already visited fragments to maintain O(N) and to ensure that cycles
	  // are not redundantly reported.
	  var visitedFrags = Object.create(null); // Array of AST nodes used to produce meaningful errors

	  var spreadPath = []; // Position in the spread path

	  var spreadPathIndexByName = Object.create(null);
	  return {
	    OperationDefinition: function OperationDefinition() {
	      return false;
	    },
	    FragmentDefinition: function FragmentDefinition(node) {
	      detectCycleRecursive(node);
	      return false;
	    }
	  }; // This does a straight-forward DFS to find cycles.
	  // It does not terminate when a cycle was found but continues to explore
	  // the graph to find all possible cycles.

	  function detectCycleRecursive(fragment) {
	    if (visitedFrags[fragment.name.value]) {
	      return;
	    }

	    var fragmentName = fragment.name.value;
	    visitedFrags[fragmentName] = true;
	    var spreadNodes = context.getFragmentSpreads(fragment.selectionSet);

	    if (spreadNodes.length === 0) {
	      return;
	    }

	    spreadPathIndexByName[fragmentName] = spreadPath.length;

	    for (var _i2 = 0; _i2 < spreadNodes.length; _i2++) {
	      var spreadNode = spreadNodes[_i2];
	      var spreadName = spreadNode.name.value;
	      var cycleIndex = spreadPathIndexByName[spreadName];
	      spreadPath.push(spreadNode);

	      if (cycleIndex === undefined) {
	        var spreadFragment = context.getFragment(spreadName);

	        if (spreadFragment) {
	          detectCycleRecursive(spreadFragment);
	        }
	      } else {
	        var cyclePath = spreadPath.slice(cycleIndex);
	        var viaPath = cyclePath.slice(0, -1).map(function (s) {
	          return '"' + s.name.value + '"';
	        }).join(', ');
	        context.reportError(new GraphQLError("Cannot spread fragment \"".concat(spreadName, "\" within itself") + (viaPath !== '' ? " via ".concat(viaPath, ".") : '.'), cyclePath));
	      }

	      spreadPath.pop();
	    }

	    spreadPathIndexByName[fragmentName] = undefined;
	  }
	}

	/**
	 * Unique variable names
	 *
	 * A GraphQL operation is only valid if all its variables are uniquely named.
	 */
	function UniqueVariableNamesRule(context) {
	  var knownVariableNames = Object.create(null);
	  return {
	    OperationDefinition: function OperationDefinition() {
	      knownVariableNames = Object.create(null);
	    },
	    VariableDefinition: function VariableDefinition(node) {
	      var variableName = node.variable.name.value;

	      if (knownVariableNames[variableName]) {
	        context.reportError(new GraphQLError("There can be only one variable named \"$".concat(variableName, "\"."), [knownVariableNames[variableName], node.variable.name]));
	      } else {
	        knownVariableNames[variableName] = node.variable.name;
	      }
	    }
	  };
	}

	/**
	 * No undefined variables
	 *
	 * A GraphQL operation is only valid if all variables encountered, both directly
	 * and via fragment spreads, are defined by that operation.
	 */
	function NoUndefinedVariablesRule(context) {
	  var variableNameDefined = Object.create(null);
	  return {
	    OperationDefinition: {
	      enter: function enter() {
	        variableNameDefined = Object.create(null);
	      },
	      leave: function leave(operation) {
	        var usages = context.getRecursiveVariableUsages(operation);

	        for (var _i2 = 0; _i2 < usages.length; _i2++) {
	          var _ref2 = usages[_i2];
	          var node = _ref2.node;
	          var varName = node.name.value;

	          if (variableNameDefined[varName] !== true) {
	            context.reportError(new GraphQLError(operation.name ? "Variable \"$".concat(varName, "\" is not defined by operation \"").concat(operation.name.value, "\".") : "Variable \"$".concat(varName, "\" is not defined."), [node, operation]));
	          }
	        }
	      }
	    },
	    VariableDefinition: function VariableDefinition(node) {
	      variableNameDefined[node.variable.name.value] = true;
	    }
	  };
	}

	/**
	 * No unused variables
	 *
	 * A GraphQL operation is only valid if all variables defined by an operation
	 * are used, either directly or within a spread fragment.
	 */
	function NoUnusedVariablesRule(context) {
	  var variableDefs = [];
	  return {
	    OperationDefinition: {
	      enter: function enter() {
	        variableDefs = [];
	      },
	      leave: function leave(operation) {
	        var variableNameUsed = Object.create(null);
	        var usages = context.getRecursiveVariableUsages(operation);

	        for (var _i2 = 0; _i2 < usages.length; _i2++) {
	          var _ref2 = usages[_i2];
	          var node = _ref2.node;
	          variableNameUsed[node.name.value] = true;
	        }

	        for (var _i4 = 0, _variableDefs2 = variableDefs; _i4 < _variableDefs2.length; _i4++) {
	          var variableDef = _variableDefs2[_i4];
	          var variableName = variableDef.variable.name.value;

	          if (variableNameUsed[variableName] !== true) {
	            context.reportError(new GraphQLError(operation.name ? "Variable \"$".concat(variableName, "\" is never used in operation \"").concat(operation.name.value, "\".") : "Variable \"$".concat(variableName, "\" is never used."), variableDef));
	          }
	        }
	      }
	    },
	    VariableDefinition: function VariableDefinition(def) {
	      variableDefs.push(def);
	    }
	  };
	}

	/**
	 * Known directives
	 *
	 * A GraphQL document is only valid if all `@directives` are known by the
	 * schema and legally positioned.
	 */
	function KnownDirectivesRule(context) {
	  var locationsMap = Object.create(null);
	  var schema = context.getSchema();
	  var definedDirectives = schema ? schema.getDirectives() : specifiedDirectives;

	  for (var _i2 = 0; _i2 < definedDirectives.length; _i2++) {
	    var directive = definedDirectives[_i2];
	    locationsMap[directive.name] = directive.locations;
	  }

	  var astDefinitions = context.getDocument().definitions;

	  for (var _i4 = 0; _i4 < astDefinitions.length; _i4++) {
	    var def = astDefinitions[_i4];

	    if (def.kind === Kind.DIRECTIVE_DEFINITION) {
	      locationsMap[def.name.value] = def.locations.map(function (name) {
	        return name.value;
	      });
	    }
	  }

	  return {
	    Directive: function Directive(node, _key, _parent, _path, ancestors) {
	      var name = node.name.value;
	      var locations = locationsMap[name];

	      if (!locations) {
	        context.reportError(new GraphQLError("Unknown directive \"@".concat(name, "\"."), node));
	        return;
	      }

	      var candidateLocation = getDirectiveLocationForASTPath(ancestors);

	      if (candidateLocation && locations.indexOf(candidateLocation) === -1) {
	        context.reportError(new GraphQLError("Directive \"@".concat(name, "\" may not be used on ").concat(candidateLocation, "."), node));
	      }
	    }
	  };
	}

	function getDirectiveLocationForASTPath(ancestors) {
	  var appliedTo = ancestors[ancestors.length - 1];
	  !Array.isArray(appliedTo) || invariant(0);

	  switch (appliedTo.kind) {
	    case Kind.OPERATION_DEFINITION:
	      return getDirectiveLocationForOperation(appliedTo.operation);

	    case Kind.FIELD:
	      return DirectiveLocation.FIELD;

	    case Kind.FRAGMENT_SPREAD:
	      return DirectiveLocation.FRAGMENT_SPREAD;

	    case Kind.INLINE_FRAGMENT:
	      return DirectiveLocation.INLINE_FRAGMENT;

	    case Kind.FRAGMENT_DEFINITION:
	      return DirectiveLocation.FRAGMENT_DEFINITION;

	    case Kind.VARIABLE_DEFINITION:
	      return DirectiveLocation.VARIABLE_DEFINITION;

	    case Kind.SCHEMA_DEFINITION:
	    case Kind.SCHEMA_EXTENSION:
	      return DirectiveLocation.SCHEMA;

	    case Kind.SCALAR_TYPE_DEFINITION:
	    case Kind.SCALAR_TYPE_EXTENSION:
	      return DirectiveLocation.SCALAR;

	    case Kind.OBJECT_TYPE_DEFINITION:
	    case Kind.OBJECT_TYPE_EXTENSION:
	      return DirectiveLocation.OBJECT;

	    case Kind.FIELD_DEFINITION:
	      return DirectiveLocation.FIELD_DEFINITION;

	    case Kind.INTERFACE_TYPE_DEFINITION:
	    case Kind.INTERFACE_TYPE_EXTENSION:
	      return DirectiveLocation.INTERFACE;

	    case Kind.UNION_TYPE_DEFINITION:
	    case Kind.UNION_TYPE_EXTENSION:
	      return DirectiveLocation.UNION;

	    case Kind.ENUM_TYPE_DEFINITION:
	    case Kind.ENUM_TYPE_EXTENSION:
	      return DirectiveLocation.ENUM;

	    case Kind.ENUM_VALUE_DEFINITION:
	      return DirectiveLocation.ENUM_VALUE;

	    case Kind.INPUT_OBJECT_TYPE_DEFINITION:
	    case Kind.INPUT_OBJECT_TYPE_EXTENSION:
	      return DirectiveLocation.INPUT_OBJECT;

	    case Kind.INPUT_VALUE_DEFINITION:
	      {
	        var parentNode = ancestors[ancestors.length - 3];
	        return parentNode.kind === Kind.INPUT_OBJECT_TYPE_DEFINITION ? DirectiveLocation.INPUT_FIELD_DEFINITION : DirectiveLocation.ARGUMENT_DEFINITION;
	      }
	  }
	}

	function getDirectiveLocationForOperation(operation) {
	  switch (operation) {
	    case 'query':
	      return DirectiveLocation.QUERY;

	    case 'mutation':
	      return DirectiveLocation.MUTATION;

	    case 'subscription':
	      return DirectiveLocation.SUBSCRIPTION;
	  } // istanbul ignore next (Not reachable. All possible types have been considered)


	  invariant(0, 'Unexpected operation: ' + inspect$2(operation));
	}

	/**
	 * Unique directive names per location
	 *
	 * A GraphQL document is only valid if all non-repeatable directives at
	 * a given location are uniquely named.
	 */
	function UniqueDirectivesPerLocationRule(context) {
	  var uniqueDirectiveMap = Object.create(null);
	  var schema = context.getSchema();
	  var definedDirectives = schema ? schema.getDirectives() : specifiedDirectives;

	  for (var _i2 = 0; _i2 < definedDirectives.length; _i2++) {
	    var directive = definedDirectives[_i2];
	    uniqueDirectiveMap[directive.name] = !directive.isRepeatable;
	  }

	  var astDefinitions = context.getDocument().definitions;

	  for (var _i4 = 0; _i4 < astDefinitions.length; _i4++) {
	    var def = astDefinitions[_i4];

	    if (def.kind === Kind.DIRECTIVE_DEFINITION) {
	      uniqueDirectiveMap[def.name.value] = !def.repeatable;
	    }
	  }

	  var schemaDirectives = Object.create(null);
	  var typeDirectivesMap = Object.create(null);
	  return {
	    // Many different AST nodes may contain directives. Rather than listing
	    // them all, just listen for entering any node, and check to see if it
	    // defines any directives.
	    enter: function enter(node) {
	      if (node.directives == null) {
	        return;
	      }

	      var seenDirectives;

	      if (node.kind === Kind.SCHEMA_DEFINITION || node.kind === Kind.SCHEMA_EXTENSION) {
	        seenDirectives = schemaDirectives;
	      } else if (isTypeDefinitionNode(node) || isTypeExtensionNode(node)) {
	        var typeName = node.name.value;
	        seenDirectives = typeDirectivesMap[typeName];

	        if (seenDirectives === undefined) {
	          typeDirectivesMap[typeName] = seenDirectives = Object.create(null);
	        }
	      } else {
	        seenDirectives = Object.create(null);
	      }

	      for (var _i6 = 0, _node$directives2 = node.directives; _i6 < _node$directives2.length; _i6++) {
	        var _directive = _node$directives2[_i6];
	        var directiveName = _directive.name.value;

	        if (uniqueDirectiveMap[directiveName]) {
	          if (seenDirectives[directiveName]) {
	            context.reportError(new GraphQLError("The directive \"@".concat(directiveName, "\" can only be used once at this location."), [seenDirectives[directiveName], _directive]));
	          } else {
	            seenDirectives[directiveName] = _directive;
	          }
	        }
	      }
	    }
	  };
	}

	function ownKeys$6(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); keys.push.apply(keys, symbols); } return keys; }

	function _objectSpread$6(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys$6(Object(source), true).forEach(function (key) { _defineProperty$8(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys$6(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

	function _defineProperty$8(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

	/**
	 * Known argument names
	 *
	 * A GraphQL field is only valid if all supplied arguments are defined by
	 * that field.
	 */
	function KnownArgumentNamesRule(context) {
	  return _objectSpread$6(_objectSpread$6({}, KnownArgumentNamesOnDirectivesRule(context)), {}, {
	    Argument: function Argument(argNode) {
	      var argDef = context.getArgument();
	      var fieldDef = context.getFieldDef();
	      var parentType = context.getParentType();

	      if (!argDef && fieldDef && parentType) {
	        var argName = argNode.name.value;
	        var knownArgsNames = fieldDef.args.map(function (arg) {
	          return arg.name;
	        });
	        var suggestions = suggestionList$1(argName, knownArgsNames);
	        context.reportError(new GraphQLError("Unknown argument \"".concat(argName, "\" on field \"").concat(parentType.name, ".").concat(fieldDef.name, "\".") + didYouMean$1(suggestions), argNode));
	      }
	    }
	  });
	}
	/**
	 * @internal
	 */

	function KnownArgumentNamesOnDirectivesRule(context) {
	  var directiveArgs = Object.create(null);
	  var schema = context.getSchema();
	  var definedDirectives = schema ? schema.getDirectives() : specifiedDirectives;

	  for (var _i2 = 0; _i2 < definedDirectives.length; _i2++) {
	    var directive = definedDirectives[_i2];
	    directiveArgs[directive.name] = directive.args.map(function (arg) {
	      return arg.name;
	    });
	  }

	  var astDefinitions = context.getDocument().definitions;

	  for (var _i4 = 0; _i4 < astDefinitions.length; _i4++) {
	    var def = astDefinitions[_i4];

	    if (def.kind === Kind.DIRECTIVE_DEFINITION) {
	      var _def$arguments;

	      // istanbul ignore next (See: 'https://github.com/graphql/graphql-js/issues/2203')
	      var argsNodes = (_def$arguments = def.arguments) !== null && _def$arguments !== void 0 ? _def$arguments : [];
	      directiveArgs[def.name.value] = argsNodes.map(function (arg) {
	        return arg.name.value;
	      });
	    }
	  }

	  return {
	    Directive: function Directive(directiveNode) {
	      var directiveName = directiveNode.name.value;
	      var knownArgs = directiveArgs[directiveName];

	      if (directiveNode.arguments && knownArgs) {
	        for (var _i6 = 0, _directiveNode$argume2 = directiveNode.arguments; _i6 < _directiveNode$argume2.length; _i6++) {
	          var argNode = _directiveNode$argume2[_i6];
	          var argName = argNode.name.value;

	          if (knownArgs.indexOf(argName) === -1) {
	            var suggestions = suggestionList$1(argName, knownArgs);
	            context.reportError(new GraphQLError("Unknown argument \"".concat(argName, "\" on directive \"@").concat(directiveName, "\".") + didYouMean$1(suggestions), argNode));
	          }
	        }
	      }

	      return false;
	    }
	  };
	}

	/**
	 * Unique argument names
	 *
	 * A GraphQL field or directive is only valid if all supplied arguments are
	 * uniquely named.
	 */
	function UniqueArgumentNamesRule(context) {
	  var knownArgNames = Object.create(null);
	  return {
	    Field: function Field() {
	      knownArgNames = Object.create(null);
	    },
	    Directive: function Directive() {
	      knownArgNames = Object.create(null);
	    },
	    Argument: function Argument(node) {
	      var argName = node.name.value;

	      if (knownArgNames[argName]) {
	        context.reportError(new GraphQLError("There can be only one argument named \"".concat(argName, "\"."), [knownArgNames[argName], node.name]));
	      } else {
	        knownArgNames[argName] = node.name;
	      }

	      return false;
	    }
	  };
	}

	/**
	 * Value literals of correct type
	 *
	 * A GraphQL document is only valid if all value literals are of the type
	 * expected at their position.
	 */
	function ValuesOfCorrectTypeRule(context) {
	  return {
	    ListValue: function ListValue(node) {
	      // Note: TypeInfo will traverse into a list's item type, so look to the
	      // parent input type to check if it is a list.
	      var type = getNullableType(context.getParentInputType());

	      if (!isListType(type)) {
	        isValidValueNode(context, node);
	        return false; // Don't traverse further.
	      }
	    },
	    ObjectValue: function ObjectValue(node) {
	      var type = getNamedType(context.getInputType());

	      if (!isInputObjectType(type)) {
	        isValidValueNode(context, node);
	        return false; // Don't traverse further.
	      } // Ensure every required field exists.


	      var fieldNodeMap = keyMap(node.fields, function (field) {
	        return field.name.value;
	      });

	      for (var _i2 = 0, _objectValues2 = objectValues$1(type.getFields()); _i2 < _objectValues2.length; _i2++) {
	        var fieldDef = _objectValues2[_i2];
	        var fieldNode = fieldNodeMap[fieldDef.name];

	        if (!fieldNode && isRequiredInputField(fieldDef)) {
	          var typeStr = inspect$2(fieldDef.type);
	          context.reportError(new GraphQLError("Field \"".concat(type.name, ".").concat(fieldDef.name, "\" of required type \"").concat(typeStr, "\" was not provided."), node));
	        }
	      }
	    },
	    ObjectField: function ObjectField(node) {
	      var parentType = getNamedType(context.getParentInputType());
	      var fieldType = context.getInputType();

	      if (!fieldType && isInputObjectType(parentType)) {
	        var suggestions = suggestionList$1(node.name.value, Object.keys(parentType.getFields()));
	        context.reportError(new GraphQLError("Field \"".concat(node.name.value, "\" is not defined by type \"").concat(parentType.name, "\".") + didYouMean$1(suggestions), node));
	      }
	    },
	    NullValue: function NullValue(node) {
	      var type = context.getInputType();

	      if (isNonNullType(type)) {
	        context.reportError(new GraphQLError("Expected value of type \"".concat(inspect$2(type), "\", found ").concat(print$1(node), "."), node));
	      }
	    },
	    EnumValue: function EnumValue(node) {
	      return isValidValueNode(context, node);
	    },
	    IntValue: function IntValue(node) {
	      return isValidValueNode(context, node);
	    },
	    FloatValue: function FloatValue(node) {
	      return isValidValueNode(context, node);
	    },
	    StringValue: function StringValue(node) {
	      return isValidValueNode(context, node);
	    },
	    BooleanValue: function BooleanValue(node) {
	      return isValidValueNode(context, node);
	    }
	  };
	}
	/**
	 * Any value literal may be a valid representation of a Scalar, depending on
	 * that scalar type.
	 */

	function isValidValueNode(context, node) {
	  // Report any error at the full type expected by the location.
	  var locationType = context.getInputType();

	  if (!locationType) {
	    return;
	  }

	  var type = getNamedType(locationType);

	  if (!isLeafType(type)) {
	    var typeStr = inspect$2(locationType);
	    context.reportError(new GraphQLError("Expected value of type \"".concat(typeStr, "\", found ").concat(print$1(node), "."), node));
	    return;
	  } // Scalars and Enums determine if a literal value is valid via parseLiteral(),
	  // which may throw or return an invalid value to indicate failure.


	  try {
	    var parseResult = type.parseLiteral(node, undefined
	    /* variables */
	    );

	    if (parseResult === undefined) {
	      var _typeStr = inspect$2(locationType);

	      context.reportError(new GraphQLError("Expected value of type \"".concat(_typeStr, "\", found ").concat(print$1(node), "."), node));
	    }
	  } catch (error) {
	    var _typeStr2 = inspect$2(locationType);

	    if (error instanceof GraphQLError) {
	      context.reportError(error);
	    } else {
	      context.reportError(new GraphQLError("Expected value of type \"".concat(_typeStr2, "\", found ").concat(print$1(node), "; ") + error.message, node, undefined, undefined, undefined, error));
	    }
	  }
	}

	function ownKeys$5(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); keys.push.apply(keys, symbols); } return keys; }

	function _objectSpread$5(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys$5(Object(source), true).forEach(function (key) { _defineProperty$7(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys$5(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

	function _defineProperty$7(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

	/**
	 * Provided required arguments
	 *
	 * A field or directive is only valid if all required (non-null without a
	 * default value) field arguments have been provided.
	 */
	function ProvidedRequiredArgumentsRule(context) {
	  return _objectSpread$5(_objectSpread$5({}, ProvidedRequiredArgumentsOnDirectivesRule(context)), {}, {
	    Field: {
	      // Validate on leave to allow for deeper errors to appear first.
	      leave: function leave(fieldNode) {
	        var _fieldNode$arguments;

	        var fieldDef = context.getFieldDef();

	        if (!fieldDef) {
	          return false;
	        } // istanbul ignore next (See: 'https://github.com/graphql/graphql-js/issues/2203')


	        var argNodes = (_fieldNode$arguments = fieldNode.arguments) !== null && _fieldNode$arguments !== void 0 ? _fieldNode$arguments : [];
	        var argNodeMap = keyMap(argNodes, function (arg) {
	          return arg.name.value;
	        });

	        for (var _i2 = 0, _fieldDef$args2 = fieldDef.args; _i2 < _fieldDef$args2.length; _i2++) {
	          var argDef = _fieldDef$args2[_i2];
	          var argNode = argNodeMap[argDef.name];

	          if (!argNode && isRequiredArgument(argDef)) {
	            var argTypeStr = inspect$2(argDef.type);
	            context.reportError(new GraphQLError("Field \"".concat(fieldDef.name, "\" argument \"").concat(argDef.name, "\" of type \"").concat(argTypeStr, "\" is required, but it was not provided."), fieldNode));
	          }
	        }
	      }
	    }
	  });
	}
	/**
	 * @internal
	 */

	function ProvidedRequiredArgumentsOnDirectivesRule(context) {
	  var requiredArgsMap = Object.create(null);
	  var schema = context.getSchema();
	  var definedDirectives = schema ? schema.getDirectives() : specifiedDirectives;

	  for (var _i4 = 0; _i4 < definedDirectives.length; _i4++) {
	    var directive = definedDirectives[_i4];
	    requiredArgsMap[directive.name] = keyMap(directive.args.filter(isRequiredArgument), function (arg) {
	      return arg.name;
	    });
	  }

	  var astDefinitions = context.getDocument().definitions;

	  for (var _i6 = 0; _i6 < astDefinitions.length; _i6++) {
	    var def = astDefinitions[_i6];

	    if (def.kind === Kind.DIRECTIVE_DEFINITION) {
	      var _def$arguments;

	      // istanbul ignore next (See: 'https://github.com/graphql/graphql-js/issues/2203')
	      var argNodes = (_def$arguments = def.arguments) !== null && _def$arguments !== void 0 ? _def$arguments : [];
	      requiredArgsMap[def.name.value] = keyMap(argNodes.filter(isRequiredArgumentNode), function (arg) {
	        return arg.name.value;
	      });
	    }
	  }

	  return {
	    Directive: {
	      // Validate on leave to allow for deeper errors to appear first.
	      leave: function leave(directiveNode) {
	        var directiveName = directiveNode.name.value;
	        var requiredArgs = requiredArgsMap[directiveName];

	        if (requiredArgs) {
	          var _directiveNode$argume;

	          // istanbul ignore next (See: 'https://github.com/graphql/graphql-js/issues/2203')
	          var _argNodes = (_directiveNode$argume = directiveNode.arguments) !== null && _directiveNode$argume !== void 0 ? _directiveNode$argume : [];

	          var argNodeMap = keyMap(_argNodes, function (arg) {
	            return arg.name.value;
	          });

	          for (var _i8 = 0, _Object$keys2 = Object.keys(requiredArgs); _i8 < _Object$keys2.length; _i8++) {
	            var argName = _Object$keys2[_i8];

	            if (!argNodeMap[argName]) {
	              var argType = requiredArgs[argName].type;
	              var argTypeStr = isType(argType) ? inspect$2(argType) : print$1(argType);
	              context.reportError(new GraphQLError("Directive \"@".concat(directiveName, "\" argument \"").concat(argName, "\" of type \"").concat(argTypeStr, "\" is required, but it was not provided."), directiveNode));
	            }
	          }
	        }
	      }
	    }
	  };
	}

	function isRequiredArgumentNode(arg) {
	  return arg.type.kind === Kind.NON_NULL_TYPE && arg.defaultValue == null;
	}

	/**
	 * Variables passed to field arguments conform to type
	 */
	function VariablesInAllowedPositionRule(context) {
	  var varDefMap = Object.create(null);
	  return {
	    OperationDefinition: {
	      enter: function enter() {
	        varDefMap = Object.create(null);
	      },
	      leave: function leave(operation) {
	        var usages = context.getRecursiveVariableUsages(operation);

	        for (var _i2 = 0; _i2 < usages.length; _i2++) {
	          var _ref2 = usages[_i2];
	          var node = _ref2.node;
	          var type = _ref2.type;
	          var defaultValue = _ref2.defaultValue;
	          var varName = node.name.value;
	          var varDef = varDefMap[varName];

	          if (varDef && type) {
	            // A var type is allowed if it is the same or more strict (e.g. is
	            // a subtype of) than the expected type. It can be more strict if
	            // the variable type is non-null when the expected type is nullable.
	            // If both are list types, the variable item type can be more strict
	            // than the expected item type (contravariant).
	            var schema = context.getSchema();
	            var varType = typeFromAST(schema, varDef.type);

	            if (varType && !allowedVariableUsage(schema, varType, varDef.defaultValue, type, defaultValue)) {
	              var varTypeStr = inspect$2(varType);
	              var typeStr = inspect$2(type);
	              context.reportError(new GraphQLError("Variable \"$".concat(varName, "\" of type \"").concat(varTypeStr, "\" used in position expecting type \"").concat(typeStr, "\"."), [varDef, node]));
	            }
	          }
	        }
	      }
	    },
	    VariableDefinition: function VariableDefinition(node) {
	      varDefMap[node.variable.name.value] = node;
	    }
	  };
	}
	/**
	 * Returns true if the variable is allowed in the location it was found,
	 * which includes considering if default values exist for either the variable
	 * or the location at which it is located.
	 */

	function allowedVariableUsage(schema, varType, varDefaultValue, locationType, locationDefaultValue) {
	  if (isNonNullType(locationType) && !isNonNullType(varType)) {
	    var hasNonNullVariableDefaultValue = varDefaultValue != null && varDefaultValue.kind !== Kind.NULL;
	    var hasLocationDefaultValue = locationDefaultValue !== undefined;

	    if (!hasNonNullVariableDefaultValue && !hasLocationDefaultValue) {
	      return false;
	    }

	    var nullableLocationType = locationType.ofType;
	    return isTypeSubTypeOf(schema, varType, nullableLocationType);
	  }

	  return isTypeSubTypeOf(schema, varType, locationType);
	}

	function reasonMessage(reason) {
	  if (Array.isArray(reason)) {
	    return reason.map(function (_ref) {
	      var responseName = _ref[0],
	          subReason = _ref[1];
	      return "subfields \"".concat(responseName, "\" conflict because ") + reasonMessage(subReason);
	    }).join(' and ');
	  }

	  return reason;
	}
	/**
	 * Overlapping fields can be merged
	 *
	 * A selection set is only valid if all fields (including spreading any
	 * fragments) either correspond to distinct response names or can be merged
	 * without ambiguity.
	 */


	function OverlappingFieldsCanBeMergedRule(context) {
	  // A memoization for when two fragments are compared "between" each other for
	  // conflicts. Two fragments may be compared many times, so memoizing this can
	  // dramatically improve the performance of this validator.
	  var comparedFragmentPairs = new PairSet(); // A cache for the "field map" and list of fragment names found in any given
	  // selection set. Selection sets may be asked for this information multiple
	  // times, so this improves the performance of this validator.

	  var cachedFieldsAndFragmentNames = new Map();
	  return {
	    SelectionSet: function SelectionSet(selectionSet) {
	      var conflicts = findConflictsWithinSelectionSet(context, cachedFieldsAndFragmentNames, comparedFragmentPairs, context.getParentType(), selectionSet);

	      for (var _i2 = 0; _i2 < conflicts.length; _i2++) {
	        var _ref3 = conflicts[_i2];
	        var _ref2$ = _ref3[0];
	        var responseName = _ref2$[0];
	        var reason = _ref2$[1];
	        var fields1 = _ref3[1];
	        var fields2 = _ref3[2];
	        var reasonMsg = reasonMessage(reason);
	        context.reportError(new GraphQLError("Fields \"".concat(responseName, "\" conflict because ").concat(reasonMsg, ". Use different aliases on the fields to fetch both if this was intentional."), fields1.concat(fields2)));
	      }
	    }
	  };
	}

	/**
	 * Algorithm:
	 *
	 * Conflicts occur when two fields exist in a query which will produce the same
	 * response name, but represent differing values, thus creating a conflict.
	 * The algorithm below finds all conflicts via making a series of comparisons
	 * between fields. In order to compare as few fields as possible, this makes
	 * a series of comparisons "within" sets of fields and "between" sets of fields.
	 *
	 * Given any selection set, a collection produces both a set of fields by
	 * also including all inline fragments, as well as a list of fragments
	 * referenced by fragment spreads.
	 *
	 * A) Each selection set represented in the document first compares "within" its
	 * collected set of fields, finding any conflicts between every pair of
	 * overlapping fields.
	 * Note: This is the *only time* that a the fields "within" a set are compared
	 * to each other. After this only fields "between" sets are compared.
	 *
	 * B) Also, if any fragment is referenced in a selection set, then a
	 * comparison is made "between" the original set of fields and the
	 * referenced fragment.
	 *
	 * C) Also, if multiple fragments are referenced, then comparisons
	 * are made "between" each referenced fragment.
	 *
	 * D) When comparing "between" a set of fields and a referenced fragment, first
	 * a comparison is made between each field in the original set of fields and
	 * each field in the the referenced set of fields.
	 *
	 * E) Also, if any fragment is referenced in the referenced selection set,
	 * then a comparison is made "between" the original set of fields and the
	 * referenced fragment (recursively referring to step D).
	 *
	 * F) When comparing "between" two fragments, first a comparison is made between
	 * each field in the first referenced set of fields and each field in the the
	 * second referenced set of fields.
	 *
	 * G) Also, any fragments referenced by the first must be compared to the
	 * second, and any fragments referenced by the second must be compared to the
	 * first (recursively referring to step F).
	 *
	 * H) When comparing two fields, if both have selection sets, then a comparison
	 * is made "between" both selection sets, first comparing the set of fields in
	 * the first selection set with the set of fields in the second.
	 *
	 * I) Also, if any fragment is referenced in either selection set, then a
	 * comparison is made "between" the other set of fields and the
	 * referenced fragment.
	 *
	 * J) Also, if two fragments are referenced in both selection sets, then a
	 * comparison is made "between" the two fragments.
	 *
	 */
	// Find all conflicts found "within" a selection set, including those found
	// via spreading in fragments. Called when visiting each SelectionSet in the
	// GraphQL Document.
	function findConflictsWithinSelectionSet(context, cachedFieldsAndFragmentNames, comparedFragmentPairs, parentType, selectionSet) {
	  var conflicts = [];

	  var _getFieldsAndFragment = getFieldsAndFragmentNames(context, cachedFieldsAndFragmentNames, parentType, selectionSet),
	      fieldMap = _getFieldsAndFragment[0],
	      fragmentNames = _getFieldsAndFragment[1]; // (A) Find find all conflicts "within" the fields of this selection set.
	  // Note: this is the *only place* `collectConflictsWithin` is called.


	  collectConflictsWithin(context, conflicts, cachedFieldsAndFragmentNames, comparedFragmentPairs, fieldMap);

	  if (fragmentNames.length !== 0) {
	    // (B) Then collect conflicts between these fields and those represented by
	    // each spread fragment name found.
	    for (var i = 0; i < fragmentNames.length; i++) {
	      collectConflictsBetweenFieldsAndFragment(context, conflicts, cachedFieldsAndFragmentNames, comparedFragmentPairs, false, fieldMap, fragmentNames[i]); // (C) Then compare this fragment with all other fragments found in this
	      // selection set to collect conflicts between fragments spread together.
	      // This compares each item in the list of fragment names to every other
	      // item in that same list (except for itself).

	      for (var j = i + 1; j < fragmentNames.length; j++) {
	        collectConflictsBetweenFragments(context, conflicts, cachedFieldsAndFragmentNames, comparedFragmentPairs, false, fragmentNames[i], fragmentNames[j]);
	      }
	    }
	  }

	  return conflicts;
	} // Collect all conflicts found between a set of fields and a fragment reference
	// including via spreading in any nested fragments.


	function collectConflictsBetweenFieldsAndFragment(context, conflicts, cachedFieldsAndFragmentNames, comparedFragmentPairs, areMutuallyExclusive, fieldMap, fragmentName) {
	  var fragment = context.getFragment(fragmentName);

	  if (!fragment) {
	    return;
	  }

	  var _getReferencedFieldsA = getReferencedFieldsAndFragmentNames(context, cachedFieldsAndFragmentNames, fragment),
	      fieldMap2 = _getReferencedFieldsA[0],
	      fragmentNames2 = _getReferencedFieldsA[1]; // Do not compare a fragment's fieldMap to itself.


	  if (fieldMap === fieldMap2) {
	    return;
	  } // (D) First collect any conflicts between the provided collection of fields
	  // and the collection of fields represented by the given fragment.


	  collectConflictsBetween(context, conflicts, cachedFieldsAndFragmentNames, comparedFragmentPairs, areMutuallyExclusive, fieldMap, fieldMap2); // (E) Then collect any conflicts between the provided collection of fields
	  // and any fragment names found in the given fragment.

	  for (var i = 0; i < fragmentNames2.length; i++) {
	    collectConflictsBetweenFieldsAndFragment(context, conflicts, cachedFieldsAndFragmentNames, comparedFragmentPairs, areMutuallyExclusive, fieldMap, fragmentNames2[i]);
	  }
	} // Collect all conflicts found between two fragments, including via spreading in
	// any nested fragments.


	function collectConflictsBetweenFragments(context, conflicts, cachedFieldsAndFragmentNames, comparedFragmentPairs, areMutuallyExclusive, fragmentName1, fragmentName2) {
	  // No need to compare a fragment to itself.
	  if (fragmentName1 === fragmentName2) {
	    return;
	  } // Memoize so two fragments are not compared for conflicts more than once.


	  if (comparedFragmentPairs.has(fragmentName1, fragmentName2, areMutuallyExclusive)) {
	    return;
	  }

	  comparedFragmentPairs.add(fragmentName1, fragmentName2, areMutuallyExclusive);
	  var fragment1 = context.getFragment(fragmentName1);
	  var fragment2 = context.getFragment(fragmentName2);

	  if (!fragment1 || !fragment2) {
	    return;
	  }

	  var _getReferencedFieldsA2 = getReferencedFieldsAndFragmentNames(context, cachedFieldsAndFragmentNames, fragment1),
	      fieldMap1 = _getReferencedFieldsA2[0],
	      fragmentNames1 = _getReferencedFieldsA2[1];

	  var _getReferencedFieldsA3 = getReferencedFieldsAndFragmentNames(context, cachedFieldsAndFragmentNames, fragment2),
	      fieldMap2 = _getReferencedFieldsA3[0],
	      fragmentNames2 = _getReferencedFieldsA3[1]; // (F) First, collect all conflicts between these two collections of fields
	  // (not including any nested fragments).


	  collectConflictsBetween(context, conflicts, cachedFieldsAndFragmentNames, comparedFragmentPairs, areMutuallyExclusive, fieldMap1, fieldMap2); // (G) Then collect conflicts between the first fragment and any nested
	  // fragments spread in the second fragment.

	  for (var j = 0; j < fragmentNames2.length; j++) {
	    collectConflictsBetweenFragments(context, conflicts, cachedFieldsAndFragmentNames, comparedFragmentPairs, areMutuallyExclusive, fragmentName1, fragmentNames2[j]);
	  } // (G) Then collect conflicts between the second fragment and any nested
	  // fragments spread in the first fragment.


	  for (var i = 0; i < fragmentNames1.length; i++) {
	    collectConflictsBetweenFragments(context, conflicts, cachedFieldsAndFragmentNames, comparedFragmentPairs, areMutuallyExclusive, fragmentNames1[i], fragmentName2);
	  }
	} // Find all conflicts found between two selection sets, including those found
	// via spreading in fragments. Called when determining if conflicts exist
	// between the sub-fields of two overlapping fields.


	function findConflictsBetweenSubSelectionSets(context, cachedFieldsAndFragmentNames, comparedFragmentPairs, areMutuallyExclusive, parentType1, selectionSet1, parentType2, selectionSet2) {
	  var conflicts = [];

	  var _getFieldsAndFragment2 = getFieldsAndFragmentNames(context, cachedFieldsAndFragmentNames, parentType1, selectionSet1),
	      fieldMap1 = _getFieldsAndFragment2[0],
	      fragmentNames1 = _getFieldsAndFragment2[1];

	  var _getFieldsAndFragment3 = getFieldsAndFragmentNames(context, cachedFieldsAndFragmentNames, parentType2, selectionSet2),
	      fieldMap2 = _getFieldsAndFragment3[0],
	      fragmentNames2 = _getFieldsAndFragment3[1]; // (H) First, collect all conflicts between these two collections of field.


	  collectConflictsBetween(context, conflicts, cachedFieldsAndFragmentNames, comparedFragmentPairs, areMutuallyExclusive, fieldMap1, fieldMap2); // (I) Then collect conflicts between the first collection of fields and
	  // those referenced by each fragment name associated with the second.

	  if (fragmentNames2.length !== 0) {
	    for (var j = 0; j < fragmentNames2.length; j++) {
	      collectConflictsBetweenFieldsAndFragment(context, conflicts, cachedFieldsAndFragmentNames, comparedFragmentPairs, areMutuallyExclusive, fieldMap1, fragmentNames2[j]);
	    }
	  } // (I) Then collect conflicts between the second collection of fields and
	  // those referenced by each fragment name associated with the first.


	  if (fragmentNames1.length !== 0) {
	    for (var i = 0; i < fragmentNames1.length; i++) {
	      collectConflictsBetweenFieldsAndFragment(context, conflicts, cachedFieldsAndFragmentNames, comparedFragmentPairs, areMutuallyExclusive, fieldMap2, fragmentNames1[i]);
	    }
	  } // (J) Also collect conflicts between any fragment names by the first and
	  // fragment names by the second. This compares each item in the first set of
	  // names to each item in the second set of names.


	  for (var _i3 = 0; _i3 < fragmentNames1.length; _i3++) {
	    for (var _j = 0; _j < fragmentNames2.length; _j++) {
	      collectConflictsBetweenFragments(context, conflicts, cachedFieldsAndFragmentNames, comparedFragmentPairs, areMutuallyExclusive, fragmentNames1[_i3], fragmentNames2[_j]);
	    }
	  }

	  return conflicts;
	} // Collect all Conflicts "within" one collection of fields.


	function collectConflictsWithin(context, conflicts, cachedFieldsAndFragmentNames, comparedFragmentPairs, fieldMap) {
	  // A field map is a keyed collection, where each key represents a response
	  // name and the value at that key is a list of all fields which provide that
	  // response name. For every response name, if there are multiple fields, they
	  // must be compared to find a potential conflict.
	  for (var _i5 = 0, _objectEntries2 = objectEntries$1(fieldMap); _i5 < _objectEntries2.length; _i5++) {
	    var _ref5 = _objectEntries2[_i5];
	    var responseName = _ref5[0];
	    var fields = _ref5[1];

	    // This compares every field in the list to every other field in this list
	    // (except to itself). If the list only has one item, nothing needs to
	    // be compared.
	    if (fields.length > 1) {
	      for (var i = 0; i < fields.length; i++) {
	        for (var j = i + 1; j < fields.length; j++) {
	          var conflict = findConflict(context, cachedFieldsAndFragmentNames, comparedFragmentPairs, false, // within one collection is never mutually exclusive
	          responseName, fields[i], fields[j]);

	          if (conflict) {
	            conflicts.push(conflict);
	          }
	        }
	      }
	    }
	  }
	} // Collect all Conflicts between two collections of fields. This is similar to,
	// but different from the `collectConflictsWithin` function above. This check
	// assumes that `collectConflictsWithin` has already been called on each
	// provided collection of fields. This is true because this validator traverses
	// each individual selection set.


	function collectConflictsBetween(context, conflicts, cachedFieldsAndFragmentNames, comparedFragmentPairs, parentFieldsAreMutuallyExclusive, fieldMap1, fieldMap2) {
	  // A field map is a keyed collection, where each key represents a response
	  // name and the value at that key is a list of all fields which provide that
	  // response name. For any response name which appears in both provided field
	  // maps, each field from the first field map must be compared to every field
	  // in the second field map to find potential conflicts.
	  for (var _i7 = 0, _Object$keys2 = Object.keys(fieldMap1); _i7 < _Object$keys2.length; _i7++) {
	    var responseName = _Object$keys2[_i7];
	    var fields2 = fieldMap2[responseName];

	    if (fields2) {
	      var fields1 = fieldMap1[responseName];

	      for (var i = 0; i < fields1.length; i++) {
	        for (var j = 0; j < fields2.length; j++) {
	          var conflict = findConflict(context, cachedFieldsAndFragmentNames, comparedFragmentPairs, parentFieldsAreMutuallyExclusive, responseName, fields1[i], fields2[j]);

	          if (conflict) {
	            conflicts.push(conflict);
	          }
	        }
	      }
	    }
	  }
	} // Determines if there is a conflict between two particular fields, including
	// comparing their sub-fields.


	function findConflict(context, cachedFieldsAndFragmentNames, comparedFragmentPairs, parentFieldsAreMutuallyExclusive, responseName, field1, field2) {
	  var parentType1 = field1[0],
	      node1 = field1[1],
	      def1 = field1[2];
	  var parentType2 = field2[0],
	      node2 = field2[1],
	      def2 = field2[2]; // If it is known that two fields could not possibly apply at the same
	  // time, due to the parent types, then it is safe to permit them to diverge
	  // in aliased field or arguments used as they will not present any ambiguity
	  // by differing.
	  // It is known that two parent types could never overlap if they are
	  // different Object types. Interface or Union types might overlap - if not
	  // in the current state of the schema, then perhaps in some future version,
	  // thus may not safely diverge.

	  var areMutuallyExclusive = parentFieldsAreMutuallyExclusive || parentType1 !== parentType2 && isObjectType(parentType1) && isObjectType(parentType2);

	  if (!areMutuallyExclusive) {
	    var _node1$arguments, _node2$arguments;

	    // Two aliases must refer to the same field.
	    var name1 = node1.name.value;
	    var name2 = node2.name.value;

	    if (name1 !== name2) {
	      return [[responseName, "\"".concat(name1, "\" and \"").concat(name2, "\" are different fields")], [node1], [node2]];
	    } // istanbul ignore next (See: 'https://github.com/graphql/graphql-js/issues/2203')


	    var args1 = (_node1$arguments = node1.arguments) !== null && _node1$arguments !== void 0 ? _node1$arguments : []; // istanbul ignore next (See: 'https://github.com/graphql/graphql-js/issues/2203')

	    var args2 = (_node2$arguments = node2.arguments) !== null && _node2$arguments !== void 0 ? _node2$arguments : []; // Two field calls must have the same arguments.

	    if (!sameArguments(args1, args2)) {
	      return [[responseName, 'they have differing arguments'], [node1], [node2]];
	    }
	  } // The return type for each field.


	  var type1 = def1 === null || def1 === void 0 ? void 0 : def1.type;
	  var type2 = def2 === null || def2 === void 0 ? void 0 : def2.type;

	  if (type1 && type2 && doTypesConflict(type1, type2)) {
	    return [[responseName, "they return conflicting types \"".concat(inspect$2(type1), "\" and \"").concat(inspect$2(type2), "\"")], [node1], [node2]];
	  } // Collect and compare sub-fields. Use the same "visited fragment names" list
	  // for both collections so fields in a fragment reference are never
	  // compared to themselves.


	  var selectionSet1 = node1.selectionSet;
	  var selectionSet2 = node2.selectionSet;

	  if (selectionSet1 && selectionSet2) {
	    var conflicts = findConflictsBetweenSubSelectionSets(context, cachedFieldsAndFragmentNames, comparedFragmentPairs, areMutuallyExclusive, getNamedType(type1), selectionSet1, getNamedType(type2), selectionSet2);
	    return subfieldConflicts(conflicts, responseName, node1, node2);
	  }
	}

	function sameArguments(arguments1, arguments2) {
	  if (arguments1.length !== arguments2.length) {
	    return false;
	  }

	  return arguments1.every(function (argument1) {
	    var argument2 = find$1(arguments2, function (argument) {
	      return argument.name.value === argument1.name.value;
	    });

	    if (!argument2) {
	      return false;
	    }

	    return sameValue(argument1.value, argument2.value);
	  });
	}

	function sameValue(value1, value2) {
	  return print$1(value1) === print$1(value2);
	} // Two types conflict if both types could not apply to a value simultaneously.
	// Composite types are ignored as their individual field types will be compared
	// later recursively. However List and Non-Null types must match.


	function doTypesConflict(type1, type2) {
	  if (isListType(type1)) {
	    return isListType(type2) ? doTypesConflict(type1.ofType, type2.ofType) : true;
	  }

	  if (isListType(type2)) {
	    return true;
	  }

	  if (isNonNullType(type1)) {
	    return isNonNullType(type2) ? doTypesConflict(type1.ofType, type2.ofType) : true;
	  }

	  if (isNonNullType(type2)) {
	    return true;
	  }

	  if (isLeafType(type1) || isLeafType(type2)) {
	    return type1 !== type2;
	  }

	  return false;
	} // Given a selection set, return the collection of fields (a mapping of response
	// name to field nodes and definitions) as well as a list of fragment names
	// referenced via fragment spreads.


	function getFieldsAndFragmentNames(context, cachedFieldsAndFragmentNames, parentType, selectionSet) {
	  var cached = cachedFieldsAndFragmentNames.get(selectionSet);

	  if (!cached) {
	    var nodeAndDefs = Object.create(null);
	    var fragmentNames = Object.create(null);

	    _collectFieldsAndFragmentNames(context, parentType, selectionSet, nodeAndDefs, fragmentNames);

	    cached = [nodeAndDefs, Object.keys(fragmentNames)];
	    cachedFieldsAndFragmentNames.set(selectionSet, cached);
	  }

	  return cached;
	} // Given a reference to a fragment, return the represented collection of fields
	// as well as a list of nested fragment names referenced via fragment spreads.


	function getReferencedFieldsAndFragmentNames(context, cachedFieldsAndFragmentNames, fragment) {
	  // Short-circuit building a type from the node if possible.
	  var cached = cachedFieldsAndFragmentNames.get(fragment.selectionSet);

	  if (cached) {
	    return cached;
	  }

	  var fragmentType = typeFromAST(context.getSchema(), fragment.typeCondition);
	  return getFieldsAndFragmentNames(context, cachedFieldsAndFragmentNames, fragmentType, fragment.selectionSet);
	}

	function _collectFieldsAndFragmentNames(context, parentType, selectionSet, nodeAndDefs, fragmentNames) {
	  for (var _i9 = 0, _selectionSet$selecti2 = selectionSet.selections; _i9 < _selectionSet$selecti2.length; _i9++) {
	    var selection = _selectionSet$selecti2[_i9];

	    switch (selection.kind) {
	      case Kind.FIELD:
	        {
	          var fieldName = selection.name.value;
	          var fieldDef = void 0;

	          if (isObjectType(parentType) || isInterfaceType(parentType)) {
	            fieldDef = parentType.getFields()[fieldName];
	          }

	          var responseName = selection.alias ? selection.alias.value : fieldName;

	          if (!nodeAndDefs[responseName]) {
	            nodeAndDefs[responseName] = [];
	          }

	          nodeAndDefs[responseName].push([parentType, selection, fieldDef]);
	          break;
	        }

	      case Kind.FRAGMENT_SPREAD:
	        fragmentNames[selection.name.value] = true;
	        break;

	      case Kind.INLINE_FRAGMENT:
	        {
	          var typeCondition = selection.typeCondition;
	          var inlineFragmentType = typeCondition ? typeFromAST(context.getSchema(), typeCondition) : parentType;

	          _collectFieldsAndFragmentNames(context, inlineFragmentType, selection.selectionSet, nodeAndDefs, fragmentNames);

	          break;
	        }
	    }
	  }
	} // Given a series of Conflicts which occurred between two sub-fields, generate
	// a single Conflict.


	function subfieldConflicts(conflicts, responseName, node1, node2) {
	  if (conflicts.length > 0) {
	    return [[responseName, conflicts.map(function (_ref6) {
	      var reason = _ref6[0];
	      return reason;
	    })], conflicts.reduce(function (allFields, _ref7) {
	      var fields1 = _ref7[1];
	      return allFields.concat(fields1);
	    }, [node1]), conflicts.reduce(function (allFields, _ref8) {
	      var fields2 = _ref8[2];
	      return allFields.concat(fields2);
	    }, [node2])];
	  }
	}
	/**
	 * A way to keep track of pairs of things when the ordering of the pair does
	 * not matter. We do this by maintaining a sort of double adjacency sets.
	 */


	var PairSet = /*#__PURE__*/function () {
	  function PairSet() {
	    this._data = Object.create(null);
	  }

	  var _proto = PairSet.prototype;

	  _proto.has = function has(a, b, areMutuallyExclusive) {
	    var first = this._data[a];
	    var result = first && first[b];

	    if (result === undefined) {
	      return false;
	    } // areMutuallyExclusive being false is a superset of being true,
	    // hence if we want to know if this PairSet "has" these two with no
	    // exclusivity, we have to ensure it was added as such.


	    if (areMutuallyExclusive === false) {
	      return result === false;
	    }

	    return true;
	  };

	  _proto.add = function add(a, b, areMutuallyExclusive) {
	    this._pairSetAdd(a, b, areMutuallyExclusive);

	    this._pairSetAdd(b, a, areMutuallyExclusive);
	  };

	  _proto._pairSetAdd = function _pairSetAdd(a, b, areMutuallyExclusive) {
	    var map = this._data[a];

	    if (!map) {
	      map = Object.create(null);
	      this._data[a] = map;
	    }

	    map[b] = areMutuallyExclusive;
	  };

	  return PairSet;
	}();

	/**
	 * Unique input field names
	 *
	 * A GraphQL input object value is only valid if all supplied fields are
	 * uniquely named.
	 */
	function UniqueInputFieldNamesRule(context) {
	  var knownNameStack = [];
	  var knownNames = Object.create(null);
	  return {
	    ObjectValue: {
	      enter: function enter() {
	        knownNameStack.push(knownNames);
	        knownNames = Object.create(null);
	      },
	      leave: function leave() {
	        knownNames = knownNameStack.pop();
	      }
	    },
	    ObjectField: function ObjectField(node) {
	      var fieldName = node.name.value;

	      if (knownNames[fieldName]) {
	        context.reportError(new GraphQLError("There can be only one input field named \"".concat(fieldName, "\"."), [knownNames[fieldName], node.name]));
	      } else {
	        knownNames[fieldName] = node.name;
	      }
	    }
	  };
	}

	/**
	 * Lone Schema definition
	 *
	 * A GraphQL document is only valid if it contains only one schema definition.
	 */
	function LoneSchemaDefinitionRule(context) {
	  var _ref, _ref2, _oldSchema$astNode;

	  var oldSchema = context.getSchema();
	  var alreadyDefined = (_ref = (_ref2 = (_oldSchema$astNode = oldSchema === null || oldSchema === void 0 ? void 0 : oldSchema.astNode) !== null && _oldSchema$astNode !== void 0 ? _oldSchema$astNode : oldSchema === null || oldSchema === void 0 ? void 0 : oldSchema.getQueryType()) !== null && _ref2 !== void 0 ? _ref2 : oldSchema === null || oldSchema === void 0 ? void 0 : oldSchema.getMutationType()) !== null && _ref !== void 0 ? _ref : oldSchema === null || oldSchema === void 0 ? void 0 : oldSchema.getSubscriptionType();
	  var schemaDefinitionsCount = 0;
	  return {
	    SchemaDefinition: function SchemaDefinition(node) {
	      if (alreadyDefined) {
	        context.reportError(new GraphQLError('Cannot define a new schema within a schema extension.', node));
	        return;
	      }

	      if (schemaDefinitionsCount > 0) {
	        context.reportError(new GraphQLError('Must provide only one schema definition.', node));
	      }

	      ++schemaDefinitionsCount;
	    }
	  };
	}

	/**
	 * Unique operation types
	 *
	 * A GraphQL document is only valid if it has only one type per operation.
	 */
	function UniqueOperationTypesRule(context) {
	  var schema = context.getSchema();
	  var definedOperationTypes = Object.create(null);
	  var existingOperationTypes = schema ? {
	    query: schema.getQueryType(),
	    mutation: schema.getMutationType(),
	    subscription: schema.getSubscriptionType()
	  } : {};
	  return {
	    SchemaDefinition: checkOperationTypes,
	    SchemaExtension: checkOperationTypes
	  };

	  function checkOperationTypes(node) {
	    var _node$operationTypes;

	    // istanbul ignore next (See: 'https://github.com/graphql/graphql-js/issues/2203')
	    var operationTypesNodes = (_node$operationTypes = node.operationTypes) !== null && _node$operationTypes !== void 0 ? _node$operationTypes : [];

	    for (var _i2 = 0; _i2 < operationTypesNodes.length; _i2++) {
	      var operationType = operationTypesNodes[_i2];
	      var operation = operationType.operation;
	      var alreadyDefinedOperationType = definedOperationTypes[operation];

	      if (existingOperationTypes[operation]) {
	        context.reportError(new GraphQLError("Type for ".concat(operation, " already defined in the schema. It cannot be redefined."), operationType));
	      } else if (alreadyDefinedOperationType) {
	        context.reportError(new GraphQLError("There can be only one ".concat(operation, " type in schema."), [alreadyDefinedOperationType, operationType]));
	      } else {
	        definedOperationTypes[operation] = operationType;
	      }
	    }

	    return false;
	  }
	}

	/**
	 * Unique type names
	 *
	 * A GraphQL document is only valid if all defined types have unique names.
	 */
	function UniqueTypeNamesRule(context) {
	  var knownTypeNames = Object.create(null);
	  var schema = context.getSchema();
	  return {
	    ScalarTypeDefinition: checkTypeName,
	    ObjectTypeDefinition: checkTypeName,
	    InterfaceTypeDefinition: checkTypeName,
	    UnionTypeDefinition: checkTypeName,
	    EnumTypeDefinition: checkTypeName,
	    InputObjectTypeDefinition: checkTypeName
	  };

	  function checkTypeName(node) {
	    var typeName = node.name.value;

	    if (schema !== null && schema !== void 0 && schema.getType(typeName)) {
	      context.reportError(new GraphQLError("Type \"".concat(typeName, "\" already exists in the schema. It cannot also be defined in this type definition."), node.name));
	      return;
	    }

	    if (knownTypeNames[typeName]) {
	      context.reportError(new GraphQLError("There can be only one type named \"".concat(typeName, "\"."), [knownTypeNames[typeName], node.name]));
	    } else {
	      knownTypeNames[typeName] = node.name;
	    }

	    return false;
	  }
	}

	/**
	 * Unique enum value names
	 *
	 * A GraphQL enum type is only valid if all its values are uniquely named.
	 */
	function UniqueEnumValueNamesRule(context) {
	  var schema = context.getSchema();
	  var existingTypeMap = schema ? schema.getTypeMap() : Object.create(null);
	  var knownValueNames = Object.create(null);
	  return {
	    EnumTypeDefinition: checkValueUniqueness,
	    EnumTypeExtension: checkValueUniqueness
	  };

	  function checkValueUniqueness(node) {
	    var _node$values;

	    var typeName = node.name.value;

	    if (!knownValueNames[typeName]) {
	      knownValueNames[typeName] = Object.create(null);
	    } // istanbul ignore next (See: 'https://github.com/graphql/graphql-js/issues/2203')


	    var valueNodes = (_node$values = node.values) !== null && _node$values !== void 0 ? _node$values : [];
	    var valueNames = knownValueNames[typeName];

	    for (var _i2 = 0; _i2 < valueNodes.length; _i2++) {
	      var valueDef = valueNodes[_i2];
	      var valueName = valueDef.name.value;
	      var existingType = existingTypeMap[typeName];

	      if (isEnumType(existingType) && existingType.getValue(valueName)) {
	        context.reportError(new GraphQLError("Enum value \"".concat(typeName, ".").concat(valueName, "\" already exists in the schema. It cannot also be defined in this type extension."), valueDef.name));
	      } else if (valueNames[valueName]) {
	        context.reportError(new GraphQLError("Enum value \"".concat(typeName, ".").concat(valueName, "\" can only be defined once."), [valueNames[valueName], valueDef.name]));
	      } else {
	        valueNames[valueName] = valueDef.name;
	      }
	    }

	    return false;
	  }
	}

	/**
	 * Unique field definition names
	 *
	 * A GraphQL complex type is only valid if all its fields are uniquely named.
	 */
	function UniqueFieldDefinitionNamesRule(context) {
	  var schema = context.getSchema();
	  var existingTypeMap = schema ? schema.getTypeMap() : Object.create(null);
	  var knownFieldNames = Object.create(null);
	  return {
	    InputObjectTypeDefinition: checkFieldUniqueness,
	    InputObjectTypeExtension: checkFieldUniqueness,
	    InterfaceTypeDefinition: checkFieldUniqueness,
	    InterfaceTypeExtension: checkFieldUniqueness,
	    ObjectTypeDefinition: checkFieldUniqueness,
	    ObjectTypeExtension: checkFieldUniqueness
	  };

	  function checkFieldUniqueness(node) {
	    var _node$fields;

	    var typeName = node.name.value;

	    if (!knownFieldNames[typeName]) {
	      knownFieldNames[typeName] = Object.create(null);
	    } // istanbul ignore next (See: 'https://github.com/graphql/graphql-js/issues/2203')


	    var fieldNodes = (_node$fields = node.fields) !== null && _node$fields !== void 0 ? _node$fields : [];
	    var fieldNames = knownFieldNames[typeName];

	    for (var _i2 = 0; _i2 < fieldNodes.length; _i2++) {
	      var fieldDef = fieldNodes[_i2];
	      var fieldName = fieldDef.name.value;

	      if (hasField(existingTypeMap[typeName], fieldName)) {
	        context.reportError(new GraphQLError("Field \"".concat(typeName, ".").concat(fieldName, "\" already exists in the schema. It cannot also be defined in this type extension."), fieldDef.name));
	      } else if (fieldNames[fieldName]) {
	        context.reportError(new GraphQLError("Field \"".concat(typeName, ".").concat(fieldName, "\" can only be defined once."), [fieldNames[fieldName], fieldDef.name]));
	      } else {
	        fieldNames[fieldName] = fieldDef.name;
	      }
	    }

	    return false;
	  }
	}

	function hasField(type, fieldName) {
	  if (isObjectType(type) || isInterfaceType(type) || isInputObjectType(type)) {
	    return type.getFields()[fieldName] != null;
	  }

	  return false;
	}

	/**
	 * Unique directive names
	 *
	 * A GraphQL document is only valid if all defined directives have unique names.
	 */
	function UniqueDirectiveNamesRule(context) {
	  var knownDirectiveNames = Object.create(null);
	  var schema = context.getSchema();
	  return {
	    DirectiveDefinition: function DirectiveDefinition(node) {
	      var directiveName = node.name.value;

	      if (schema !== null && schema !== void 0 && schema.getDirective(directiveName)) {
	        context.reportError(new GraphQLError("Directive \"@".concat(directiveName, "\" already exists in the schema. It cannot be redefined."), node.name));
	        return;
	      }

	      if (knownDirectiveNames[directiveName]) {
	        context.reportError(new GraphQLError("There can be only one directive named \"@".concat(directiveName, "\"."), [knownDirectiveNames[directiveName], node.name]));
	      } else {
	        knownDirectiveNames[directiveName] = node.name;
	      }

	      return false;
	    }
	  };
	}

	var _defKindToExtKind;

	function _defineProperty$6(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

	/**
	 * Possible type extension
	 *
	 * A type extension is only valid if the type is defined and has the same kind.
	 */
	function PossibleTypeExtensionsRule(context) {
	  var schema = context.getSchema();
	  var definedTypes = Object.create(null);

	  for (var _i2 = 0, _context$getDocument$2 = context.getDocument().definitions; _i2 < _context$getDocument$2.length; _i2++) {
	    var def = _context$getDocument$2[_i2];

	    if (isTypeDefinitionNode(def)) {
	      definedTypes[def.name.value] = def;
	    }
	  }

	  return {
	    ScalarTypeExtension: checkExtension,
	    ObjectTypeExtension: checkExtension,
	    InterfaceTypeExtension: checkExtension,
	    UnionTypeExtension: checkExtension,
	    EnumTypeExtension: checkExtension,
	    InputObjectTypeExtension: checkExtension
	  };

	  function checkExtension(node) {
	    var typeName = node.name.value;
	    var defNode = definedTypes[typeName];
	    var existingType = schema === null || schema === void 0 ? void 0 : schema.getType(typeName);
	    var expectedKind;

	    if (defNode) {
	      expectedKind = defKindToExtKind[defNode.kind];
	    } else if (existingType) {
	      expectedKind = typeToExtKind(existingType);
	    }

	    if (expectedKind) {
	      if (expectedKind !== node.kind) {
	        var kindStr = extensionKindToTypeName(node.kind);
	        context.reportError(new GraphQLError("Cannot extend non-".concat(kindStr, " type \"").concat(typeName, "\"."), defNode ? [defNode, node] : node));
	      }
	    } else {
	      var allTypeNames = Object.keys(definedTypes);

	      if (schema) {
	        allTypeNames = allTypeNames.concat(Object.keys(schema.getTypeMap()));
	      }

	      var suggestedTypes = suggestionList$1(typeName, allTypeNames);
	      context.reportError(new GraphQLError("Cannot extend type \"".concat(typeName, "\" because it is not defined.") + didYouMean$1(suggestedTypes), node.name));
	    }
	  }
	}
	var defKindToExtKind = (_defKindToExtKind = {}, _defineProperty$6(_defKindToExtKind, Kind.SCALAR_TYPE_DEFINITION, Kind.SCALAR_TYPE_EXTENSION), _defineProperty$6(_defKindToExtKind, Kind.OBJECT_TYPE_DEFINITION, Kind.OBJECT_TYPE_EXTENSION), _defineProperty$6(_defKindToExtKind, Kind.INTERFACE_TYPE_DEFINITION, Kind.INTERFACE_TYPE_EXTENSION), _defineProperty$6(_defKindToExtKind, Kind.UNION_TYPE_DEFINITION, Kind.UNION_TYPE_EXTENSION), _defineProperty$6(_defKindToExtKind, Kind.ENUM_TYPE_DEFINITION, Kind.ENUM_TYPE_EXTENSION), _defineProperty$6(_defKindToExtKind, Kind.INPUT_OBJECT_TYPE_DEFINITION, Kind.INPUT_OBJECT_TYPE_EXTENSION), _defKindToExtKind);

	function typeToExtKind(type) {
	  if (isScalarType(type)) {
	    return Kind.SCALAR_TYPE_EXTENSION;
	  }

	  if (isObjectType(type)) {
	    return Kind.OBJECT_TYPE_EXTENSION;
	  }

	  if (isInterfaceType(type)) {
	    return Kind.INTERFACE_TYPE_EXTENSION;
	  }

	  if (isUnionType(type)) {
	    return Kind.UNION_TYPE_EXTENSION;
	  }

	  if (isEnumType(type)) {
	    return Kind.ENUM_TYPE_EXTENSION;
	  } // istanbul ignore else (See: 'https://github.com/graphql/graphql-js/issues/2618')


	  if (isInputObjectType(type)) {
	    return Kind.INPUT_OBJECT_TYPE_EXTENSION;
	  } // istanbul ignore next (Not reachable. All possible types have been considered)


	  invariant(0, 'Unexpected type: ' + inspect$2(type));
	}

	function extensionKindToTypeName(kind) {
	  switch (kind) {
	    case Kind.SCALAR_TYPE_EXTENSION:
	      return 'scalar';

	    case Kind.OBJECT_TYPE_EXTENSION:
	      return 'object';

	    case Kind.INTERFACE_TYPE_EXTENSION:
	      return 'interface';

	    case Kind.UNION_TYPE_EXTENSION:
	      return 'union';

	    case Kind.ENUM_TYPE_EXTENSION:
	      return 'enum';

	    case Kind.INPUT_OBJECT_TYPE_EXTENSION:
	      return 'input object';
	  } // istanbul ignore next (Not reachable. All possible types have been considered)


	  invariant(0, 'Unexpected kind: ' + inspect$2(kind));
	}

	// Spec Section: "Executable Definitions"
	/**
	 * This set includes all validation rules defined by the GraphQL spec.
	 *
	 * The order of the rules in this list has been adjusted to lead to the
	 * most clear output when encountering multiple validation errors.
	 */

	var specifiedRules = Object.freeze([ExecutableDefinitionsRule, UniqueOperationNamesRule, LoneAnonymousOperationRule, SingleFieldSubscriptionsRule, KnownTypeNamesRule, FragmentsOnCompositeTypesRule, VariablesAreInputTypesRule, ScalarLeafsRule, FieldsOnCorrectTypeRule, UniqueFragmentNamesRule, KnownFragmentNamesRule, NoUnusedFragmentsRule, PossibleFragmentSpreadsRule, NoFragmentCyclesRule, UniqueVariableNamesRule, NoUndefinedVariablesRule, NoUnusedVariablesRule, KnownDirectivesRule, UniqueDirectivesPerLocationRule, KnownArgumentNamesRule, UniqueArgumentNamesRule, ValuesOfCorrectTypeRule, ProvidedRequiredArgumentsRule, VariablesInAllowedPositionRule, OverlappingFieldsCanBeMergedRule, UniqueInputFieldNamesRule]);
	/**
	 * @internal
	 */

	var specifiedSDLRules = Object.freeze([LoneSchemaDefinitionRule, UniqueOperationTypesRule, UniqueTypeNamesRule, UniqueEnumValueNamesRule, UniqueFieldDefinitionNamesRule, UniqueDirectiveNamesRule, KnownTypeNamesRule, KnownDirectivesRule, UniqueDirectivesPerLocationRule, PossibleTypeExtensionsRule, KnownArgumentNamesOnDirectivesRule, UniqueArgumentNamesRule, UniqueInputFieldNamesRule, ProvidedRequiredArgumentsOnDirectivesRule]);

	var specifiedRules$1 = /*#__PURE__*/Object.freeze({
		__proto__: null,
		specifiedRules: specifiedRules,
		specifiedSDLRules: specifiedSDLRules
	});

	function _inheritsLoose(subClass, superClass) { subClass.prototype = Object.create(superClass.prototype); subClass.prototype.constructor = subClass; subClass.__proto__ = superClass; }

	/**
	 * An instance of this class is passed as the "this" context to all validators,
	 * allowing access to commonly useful contextual information from within a
	 * validation rule.
	 */
	var ASTValidationContext = /*#__PURE__*/function () {
	  function ASTValidationContext(ast, onError) {
	    this._ast = ast;
	    this._fragments = undefined;
	    this._fragmentSpreads = new Map();
	    this._recursivelyReferencedFragments = new Map();
	    this._onError = onError;
	  }

	  var _proto = ASTValidationContext.prototype;

	  _proto.reportError = function reportError(error) {
	    this._onError(error);
	  };

	  _proto.getDocument = function getDocument() {
	    return this._ast;
	  };

	  _proto.getFragment = function getFragment(name) {
	    var fragments = this._fragments;

	    if (!fragments) {
	      this._fragments = fragments = this.getDocument().definitions.reduce(function (frags, statement) {
	        if (statement.kind === Kind.FRAGMENT_DEFINITION) {
	          frags[statement.name.value] = statement;
	        }

	        return frags;
	      }, Object.create(null));
	    }

	    return fragments[name];
	  };

	  _proto.getFragmentSpreads = function getFragmentSpreads(node) {
	    var spreads = this._fragmentSpreads.get(node);

	    if (!spreads) {
	      spreads = [];
	      var setsToVisit = [node];

	      while (setsToVisit.length !== 0) {
	        var set = setsToVisit.pop();

	        for (var _i2 = 0, _set$selections2 = set.selections; _i2 < _set$selections2.length; _i2++) {
	          var selection = _set$selections2[_i2];

	          if (selection.kind === Kind.FRAGMENT_SPREAD) {
	            spreads.push(selection);
	          } else if (selection.selectionSet) {
	            setsToVisit.push(selection.selectionSet);
	          }
	        }
	      }

	      this._fragmentSpreads.set(node, spreads);
	    }

	    return spreads;
	  };

	  _proto.getRecursivelyReferencedFragments = function getRecursivelyReferencedFragments(operation) {
	    var fragments = this._recursivelyReferencedFragments.get(operation);

	    if (!fragments) {
	      fragments = [];
	      var collectedNames = Object.create(null);
	      var nodesToVisit = [operation.selectionSet];

	      while (nodesToVisit.length !== 0) {
	        var node = nodesToVisit.pop();

	        for (var _i4 = 0, _this$getFragmentSpre2 = this.getFragmentSpreads(node); _i4 < _this$getFragmentSpre2.length; _i4++) {
	          var spread = _this$getFragmentSpre2[_i4];
	          var fragName = spread.name.value;

	          if (collectedNames[fragName] !== true) {
	            collectedNames[fragName] = true;
	            var fragment = this.getFragment(fragName);

	            if (fragment) {
	              fragments.push(fragment);
	              nodesToVisit.push(fragment.selectionSet);
	            }
	          }
	        }
	      }

	      this._recursivelyReferencedFragments.set(operation, fragments);
	    }

	    return fragments;
	  };

	  return ASTValidationContext;
	}();
	var SDLValidationContext = /*#__PURE__*/function (_ASTValidationContext) {
	  _inheritsLoose(SDLValidationContext, _ASTValidationContext);

	  function SDLValidationContext(ast, schema, onError) {
	    var _this;

	    _this = _ASTValidationContext.call(this, ast, onError) || this;
	    _this._schema = schema;
	    return _this;
	  }

	  var _proto2 = SDLValidationContext.prototype;

	  _proto2.getSchema = function getSchema() {
	    return this._schema;
	  };

	  return SDLValidationContext;
	}(ASTValidationContext);
	var ValidationContext = /*#__PURE__*/function (_ASTValidationContext2) {
	  _inheritsLoose(ValidationContext, _ASTValidationContext2);

	  function ValidationContext(schema, ast, typeInfo, onError) {
	    var _this2;

	    _this2 = _ASTValidationContext2.call(this, ast, onError) || this;
	    _this2._schema = schema;
	    _this2._typeInfo = typeInfo;
	    _this2._variableUsages = new Map();
	    _this2._recursiveVariableUsages = new Map();
	    return _this2;
	  }

	  var _proto3 = ValidationContext.prototype;

	  _proto3.getSchema = function getSchema() {
	    return this._schema;
	  };

	  _proto3.getVariableUsages = function getVariableUsages(node) {
	    var usages = this._variableUsages.get(node);

	    if (!usages) {
	      var newUsages = [];
	      var typeInfo = new TypeInfo(this._schema);
	      visit(node, visitWithTypeInfo(typeInfo, {
	        VariableDefinition: function VariableDefinition() {
	          return false;
	        },
	        Variable: function Variable(variable) {
	          newUsages.push({
	            node: variable,
	            type: typeInfo.getInputType(),
	            defaultValue: typeInfo.getDefaultValue()
	          });
	        }
	      }));
	      usages = newUsages;

	      this._variableUsages.set(node, usages);
	    }

	    return usages;
	  };

	  _proto3.getRecursiveVariableUsages = function getRecursiveVariableUsages(operation) {
	    var usages = this._recursiveVariableUsages.get(operation);

	    if (!usages) {
	      usages = this.getVariableUsages(operation);

	      for (var _i6 = 0, _this$getRecursivelyR2 = this.getRecursivelyReferencedFragments(operation); _i6 < _this$getRecursivelyR2.length; _i6++) {
	        var frag = _this$getRecursivelyR2[_i6];
	        usages = usages.concat(this.getVariableUsages(frag));
	      }

	      this._recursiveVariableUsages.set(operation, usages);
	    }

	    return usages;
	  };

	  _proto3.getType = function getType() {
	    return this._typeInfo.getType();
	  };

	  _proto3.getParentType = function getParentType() {
	    return this._typeInfo.getParentType();
	  };

	  _proto3.getInputType = function getInputType() {
	    return this._typeInfo.getInputType();
	  };

	  _proto3.getParentInputType = function getParentInputType() {
	    return this._typeInfo.getParentInputType();
	  };

	  _proto3.getFieldDef = function getFieldDef() {
	    return this._typeInfo.getFieldDef();
	  };

	  _proto3.getDirective = function getDirective() {
	    return this._typeInfo.getDirective();
	  };

	  _proto3.getArgument = function getArgument() {
	    return this._typeInfo.getArgument();
	  };

	  _proto3.getEnumValue = function getEnumValue() {
	    return this._typeInfo.getEnumValue();
	  };

	  return ValidationContext;
	}(ASTValidationContext);

	/**
	 * Implements the "Validation" section of the spec.
	 *
	 * Validation runs synchronously, returning an array of encountered errors, or
	 * an empty array if no errors were encountered and the document is valid.
	 *
	 * A list of specific validation rules may be provided. If not provided, the
	 * default list of rules defined by the GraphQL specification will be used.
	 *
	 * Each validation rules is a function which returns a visitor
	 * (see the language/visitor API). Visitor methods are expected to return
	 * GraphQLErrors, or Arrays of GraphQLErrors when invalid.
	 *
	 * Optionally a custom TypeInfo instance may be provided. If not provided, one
	 * will be created from the provided schema.
	 */

	function validate$3(schema, documentAST) {
	  var rules = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : specifiedRules;
	  var typeInfo = arguments.length > 3 && arguments[3] !== undefined ? arguments[3] : new TypeInfo(schema);
	  var options = arguments.length > 4 && arguments[4] !== undefined ? arguments[4] : {
	    maxErrors: undefined
	  };
	  documentAST || devAssert(0, 'Must provide document.'); // If the schema used for validation is invalid, throw an error.

	  assertValidSchema(schema);
	  var abortObj = Object.freeze({});
	  var errors = [];
	  var context = new ValidationContext(schema, documentAST, typeInfo, function (error) {
	    if (options.maxErrors != null && errors.length >= options.maxErrors) {
	      errors.push(new GraphQLError('Too many validation errors, error limit reached. Validation aborted.'));
	      throw abortObj;
	    }

	    errors.push(error);
	  }); // This uses a specialized visitor which runs multiple visitors in parallel,
	  // while maintaining the visitor skip and break API.

	  var visitor = visitInParallel(rules.map(function (rule) {
	    return rule(context);
	  })); // Visit the whole document with each instance of all provided rules.

	  try {
	    visit(documentAST, visitWithTypeInfo(typeInfo, visitor));
	  } catch (e) {
	    if (e !== abortObj) {
	      throw e;
	    }
	  }

	  return errors;
	}
	/**
	 * @internal
	 */

	function validateSDL(documentAST, schemaToExtend) {
	  var rules = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : specifiedSDLRules;
	  var errors = [];
	  var context = new SDLValidationContext(documentAST, schemaToExtend, function (error) {
	    errors.push(error);
	  });
	  var visitors = rules.map(function (rule) {
	    return rule(context);
	  });
	  visit(documentAST, visitInParallel(visitors));
	  return errors;
	}
	/**
	 * Utility function which asserts a SDL document is valid by throwing an error
	 * if it is invalid.
	 *
	 * @internal
	 */

	function assertValidSDL(documentAST) {
	  var errors = validateSDL(documentAST);

	  if (errors.length !== 0) {
	    throw new Error(errors.map(function (error) {
	      return error.message;
	    }).join('\n\n'));
	  }
	}
	/**
	 * Utility function which asserts a SDL document is valid by throwing an error
	 * if it is invalid.
	 *
	 * @internal
	 */

	function assertValidSDLExtension(documentAST, schema) {
	  var errors = validateSDL(documentAST, schema);

	  if (errors.length !== 0) {
	    throw new Error(errors.map(function (error) {
	      return error.message;
	    }).join('\n\n'));
	  }
	}

	var validate$4 = /*#__PURE__*/Object.freeze({
		__proto__: null,
		validate: validate$3,
		validateSDL: validateSDL,
		assertValidSDL: assertValidSDL,
		assertValidSDLExtension: assertValidSDLExtension
	});

	/**
	 * Memoizes the provided three-argument function.
	 */
	function memoize3(fn) {
	  var cache0;
	  return function memoized(a1, a2, a3) {
	    if (!cache0) {
	      cache0 = new WeakMap();
	    }

	    var cache1 = cache0.get(a1);
	    var cache2;

	    if (cache1) {
	      cache2 = cache1.get(a2);

	      if (cache2) {
	        var cachedValue = cache2.get(a3);

	        if (cachedValue !== undefined) {
	          return cachedValue;
	        }
	      }
	    } else {
	      cache1 = new WeakMap();
	      cache0.set(a1, cache1);
	    }

	    if (!cache2) {
	      cache2 = new WeakMap();
	      cache1.set(a2, cache2);
	    }

	    var newValue = fn(a1, a2, a3);
	    cache2.set(a3, newValue);
	    return newValue;
	  };
	}

	/**
	 * Similar to Array.prototype.reduce(), however the reducing callback may return
	 * a Promise, in which case reduction will continue after each promise resolves.
	 *
	 * If the callback does not return a Promise, then this function will also not
	 * return a Promise.
	 */

	function promiseReduce(values, callback, initialValue) {
	  return values.reduce(function (previous, value) {
	    return isPromise(previous) ? previous.then(function (resolved) {
	      return callback(resolved, value);
	    }) : callback(previous, value);
	  }, initialValue);
	}

	/**
	 * This function transforms a JS object `ObjMap<Promise<T>>` into
	 * a `Promise<ObjMap<T>>`
	 *
	 * This is akin to bluebird's `Promise.props`, but implemented only using
	 * `Promise.all` so it will work with any implementation of ES6 promises.
	 */
	function promiseForObject(object) {
	  var keys = Object.keys(object);
	  var valuesAndPromises = keys.map(function (name) {
	    return object[name];
	  });
	  return Promise.all(valuesAndPromises).then(function (values) {
	    return values.reduce(function (resolvedObject, value, i) {
	      resolvedObject[keys[i]] = value;
	      return resolvedObject;
	    }, Object.create(null));
	  });
	}

	/**
	 * Given a Path and a key, return a new Path containing the new key.
	 */
	function addPath(prev, key, typename) {
	  return {
	    prev: prev,
	    key: key,
	    typename: typename
	  };
	}
	/**
	 * Given a Path, return an Array of the path keys.
	 */

	function pathToArray(path) {
	  var flattened = [];
	  var curr = path;

	  while (curr) {
	    flattened.push(curr.key);
	    curr = curr.prev;
	  }

	  return flattened.reverse();
	}

	/**
	 * Extracts the root type of the operation from the schema.
	 */
	function getOperationRootType(schema, operation) {
	  if (operation.operation === 'query') {
	    var queryType = schema.getQueryType();

	    if (!queryType) {
	      throw new GraphQLError('Schema does not define the required query root type.', operation);
	    }

	    return queryType;
	  }

	  if (operation.operation === 'mutation') {
	    var mutationType = schema.getMutationType();

	    if (!mutationType) {
	      throw new GraphQLError('Schema is not configured for mutations.', operation);
	    }

	    return mutationType;
	  }

	  if (operation.operation === 'subscription') {
	    var subscriptionType = schema.getSubscriptionType();

	    if (!subscriptionType) {
	      throw new GraphQLError('Schema is not configured for subscriptions.', operation);
	    }

	    return subscriptionType;
	  }

	  throw new GraphQLError('Can only have query, mutation and subscription operations.', operation);
	}

	/**
	 * Build a string describing the path.
	 */
	function printPathArray(path) {
	  return path.map(function (key) {
	    return typeof key === 'number' ? '[' + key.toString() + ']' : '.' + key;
	  }).join('');
	}

	/**
	 * Produces a JavaScript value given a GraphQL Value AST.
	 *
	 * A GraphQL type must be provided, which will be used to interpret different
	 * GraphQL Value literals.
	 *
	 * Returns `undefined` when the value could not be validly coerced according to
	 * the provided type.
	 *
	 * | GraphQL Value        | JSON Value    |
	 * | -------------------- | ------------- |
	 * | Input Object         | Object        |
	 * | List                 | Array         |
	 * | Boolean              | Boolean       |
	 * | String               | String        |
	 * | Int / Float          | Number        |
	 * | Enum Value           | Mixed         |
	 * | NullValue            | null          |
	 *
	 */

	function valueFromAST$1(valueNode, type, variables) {
	  if (!valueNode) {
	    // When there is no node, then there is also no value.
	    // Importantly, this is different from returning the value null.
	    return;
	  }

	  if (valueNode.kind === Kind.VARIABLE) {
	    var variableName = valueNode.name.value;

	    if (variables == null || variables[variableName] === undefined) {
	      // No valid return value.
	      return;
	    }

	    var variableValue = variables[variableName];

	    if (variableValue === null && isNonNullType(type)) {
	      return; // Invalid: intentionally return no value.
	    } // Note: This does no further checking that this variable is correct.
	    // This assumes that this query has been validated and the variable
	    // usage here is of the correct type.


	    return variableValue;
	  }

	  if (isNonNullType(type)) {
	    if (valueNode.kind === Kind.NULL) {
	      return; // Invalid: intentionally return no value.
	    }

	    return valueFromAST$1(valueNode, type.ofType, variables);
	  }

	  if (valueNode.kind === Kind.NULL) {
	    // This is explicitly returning the value null.
	    return null;
	  }

	  if (isListType(type)) {
	    var itemType = type.ofType;

	    if (valueNode.kind === Kind.LIST) {
	      var coercedValues = [];

	      for (var _i2 = 0, _valueNode$values2 = valueNode.values; _i2 < _valueNode$values2.length; _i2++) {
	        var itemNode = _valueNode$values2[_i2];

	        if (isMissingVariable(itemNode, variables)) {
	          // If an array contains a missing variable, it is either coerced to
	          // null or if the item type is non-null, it considered invalid.
	          if (isNonNullType(itemType)) {
	            return; // Invalid: intentionally return no value.
	          }

	          coercedValues.push(null);
	        } else {
	          var itemValue = valueFromAST$1(itemNode, itemType, variables);

	          if (itemValue === undefined) {
	            return; // Invalid: intentionally return no value.
	          }

	          coercedValues.push(itemValue);
	        }
	      }

	      return coercedValues;
	    }

	    var coercedValue = valueFromAST$1(valueNode, itemType, variables);

	    if (coercedValue === undefined) {
	      return; // Invalid: intentionally return no value.
	    }

	    return [coercedValue];
	  }

	  if (isInputObjectType(type)) {
	    if (valueNode.kind !== Kind.OBJECT) {
	      return; // Invalid: intentionally return no value.
	    }

	    var coercedObj = Object.create(null);
	    var fieldNodes = keyMap(valueNode.fields, function (field) {
	      return field.name.value;
	    });

	    for (var _i4 = 0, _objectValues2 = objectValues$1(type.getFields()); _i4 < _objectValues2.length; _i4++) {
	      var field = _objectValues2[_i4];
	      var fieldNode = fieldNodes[field.name];

	      if (!fieldNode || isMissingVariable(fieldNode.value, variables)) {
	        if (field.defaultValue !== undefined) {
	          coercedObj[field.name] = field.defaultValue;
	        } else if (isNonNullType(field.type)) {
	          return; // Invalid: intentionally return no value.
	        }

	        continue;
	      }

	      var fieldValue = valueFromAST$1(fieldNode.value, field.type, variables);

	      if (fieldValue === undefined) {
	        return; // Invalid: intentionally return no value.
	      }

	      coercedObj[field.name] = fieldValue;
	    }

	    return coercedObj;
	  } // istanbul ignore else (See: 'https://github.com/graphql/graphql-js/issues/2618')


	  if (isLeafType(type)) {
	    // Scalars and Enums fulfill parsing a literal value via parseLiteral().
	    // Invalid values represent a failure to parse correctly, in which case
	    // no value is returned.
	    var result;

	    try {
	      result = type.parseLiteral(valueNode, variables);
	    } catch (_error) {
	      return; // Invalid: intentionally return no value.
	    }

	    if (result === undefined) {
	      return; // Invalid: intentionally return no value.
	    }

	    return result;
	  } // istanbul ignore next (Not reachable. All possible input types have been considered)


	  invariant(0, 'Unexpected input type: ' + inspect$2(type));
	} // Returns true if the provided valueNode is a variable which is not defined
	// in the set of variables.

	function isMissingVariable(valueNode, variables) {
	  return valueNode.kind === Kind.VARIABLE && (variables == null || variables[valueNode.name.value] === undefined);
	}

	/**
	 * Coerces a JavaScript value given a GraphQL Input Type.
	 */
	function coerceInputValue(inputValue, type) {
	  var onError = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : defaultOnError;
	  return coerceInputValueImpl(inputValue, type, onError);
	}

	function defaultOnError(path, invalidValue, error) {
	  var errorPrefix = 'Invalid value ' + inspect$2(invalidValue);

	  if (path.length > 0) {
	    errorPrefix += " at \"value".concat(printPathArray(path), "\"");
	  }

	  error.message = errorPrefix + ': ' + error.message;
	  throw error;
	}

	function coerceInputValueImpl(inputValue, type, onError, path) {
	  if (isNonNullType(type)) {
	    if (inputValue != null) {
	      return coerceInputValueImpl(inputValue, type.ofType, onError, path);
	    }

	    onError(pathToArray(path), inputValue, new GraphQLError("Expected non-nullable type \"".concat(inspect$2(type), "\" not to be null.")));
	    return;
	  }

	  if (inputValue == null) {
	    // Explicitly return the value null.
	    return null;
	  }

	  if (isListType(type)) {
	    var itemType = type.ofType;
	    var coercedList = safeArrayFrom(inputValue, function (itemValue, index) {
	      var itemPath = addPath(path, index, undefined);
	      return coerceInputValueImpl(itemValue, itemType, onError, itemPath);
	    });

	    if (coercedList != null) {
	      return coercedList;
	    } // Lists accept a non-list value as a list of one.


	    return [coerceInputValueImpl(inputValue, itemType, onError, path)];
	  }

	  if (isInputObjectType(type)) {
	    if (!isObjectLike(inputValue)) {
	      onError(pathToArray(path), inputValue, new GraphQLError("Expected type \"".concat(type.name, "\" to be an object.")));
	      return;
	    }

	    var coercedValue = {};
	    var fieldDefs = type.getFields();

	    for (var _i2 = 0, _objectValues2 = objectValues$1(fieldDefs); _i2 < _objectValues2.length; _i2++) {
	      var field = _objectValues2[_i2];
	      var fieldValue = inputValue[field.name];

	      if (fieldValue === undefined) {
	        if (field.defaultValue !== undefined) {
	          coercedValue[field.name] = field.defaultValue;
	        } else if (isNonNullType(field.type)) {
	          var typeStr = inspect$2(field.type);
	          onError(pathToArray(path), inputValue, new GraphQLError("Field \"".concat(field.name, "\" of required type \"").concat(typeStr, "\" was not provided.")));
	        }

	        continue;
	      }

	      coercedValue[field.name] = coerceInputValueImpl(fieldValue, field.type, onError, addPath(path, field.name, type.name));
	    } // Ensure every provided field is defined.


	    for (var _i4 = 0, _Object$keys2 = Object.keys(inputValue); _i4 < _Object$keys2.length; _i4++) {
	      var fieldName = _Object$keys2[_i4];

	      if (!fieldDefs[fieldName]) {
	        var suggestions = suggestionList$1(fieldName, Object.keys(type.getFields()));
	        onError(pathToArray(path), inputValue, new GraphQLError("Field \"".concat(fieldName, "\" is not defined by type \"").concat(type.name, "\".") + didYouMean$1(suggestions)));
	      }
	    }

	    return coercedValue;
	  } // istanbul ignore else (See: 'https://github.com/graphql/graphql-js/issues/2618')


	  if (isLeafType(type)) {
	    var parseResult; // Scalars and Enums determine if a input value is valid via parseValue(),
	    // which can throw to indicate failure. If it throws, maintain a reference
	    // to the original error.

	    try {
	      parseResult = type.parseValue(inputValue);
	    } catch (error) {
	      if (error instanceof GraphQLError) {
	        onError(pathToArray(path), inputValue, error);
	      } else {
	        onError(pathToArray(path), inputValue, new GraphQLError("Expected type \"".concat(type.name, "\". ") + error.message, undefined, undefined, undefined, undefined, error));
	      }

	      return;
	    }

	    if (parseResult === undefined) {
	      onError(pathToArray(path), inputValue, new GraphQLError("Expected type \"".concat(type.name, "\".")));
	    }

	    return parseResult;
	  } // istanbul ignore next (Not reachable. All possible input types have been considered)


	  invariant(0, 'Unexpected input type: ' + inspect$2(type));
	}

	/**
	 * Prepares an object map of variableValues of the correct type based on the
	 * provided variable definitions and arbitrary input. If the input cannot be
	 * parsed to match the variable definitions, a GraphQLError will be thrown.
	 *
	 * Note: The returned value is a plain Object with a prototype, since it is
	 * exposed to user code. Care should be taken to not pull values from the
	 * Object prototype.
	 *
	 * @internal
	 */
	function getVariableValues(schema, varDefNodes, inputs, options) {
	  var errors = [];
	  var maxErrors = options === null || options === void 0 ? void 0 : options.maxErrors;

	  try {
	    var coerced = coerceVariableValues(schema, varDefNodes, inputs, function (error) {
	      if (maxErrors != null && errors.length >= maxErrors) {
	        throw new GraphQLError('Too many errors processing variables, error limit reached. Execution aborted.');
	      }

	      errors.push(error);
	    });

	    if (errors.length === 0) {
	      return {
	        coerced: coerced
	      };
	    }
	  } catch (error) {
	    errors.push(error);
	  }

	  return {
	    errors: errors
	  };
	}

	function coerceVariableValues(schema, varDefNodes, inputs, onError) {
	  var coercedValues = {};

	  var _loop = function _loop(_i2) {
	    var varDefNode = varDefNodes[_i2];
	    var varName = varDefNode.variable.name.value;
	    var varType = typeFromAST(schema, varDefNode.type);

	    if (!isInputType(varType)) {
	      // Must use input types for variables. This should be caught during
	      // validation, however is checked again here for safety.
	      var varTypeStr = print$1(varDefNode.type);
	      onError(new GraphQLError("Variable \"$".concat(varName, "\" expected value of type \"").concat(varTypeStr, "\" which cannot be used as an input type."), varDefNode.type));
	      return "continue";
	    }

	    if (!hasOwnProperty$1(inputs, varName)) {
	      if (varDefNode.defaultValue) {
	        coercedValues[varName] = valueFromAST$1(varDefNode.defaultValue, varType);
	      } else if (isNonNullType(varType)) {
	        var _varTypeStr = inspect$2(varType);

	        onError(new GraphQLError("Variable \"$".concat(varName, "\" of required type \"").concat(_varTypeStr, "\" was not provided."), varDefNode));
	      }

	      return "continue";
	    }

	    var value = inputs[varName];

	    if (value === null && isNonNullType(varType)) {
	      var _varTypeStr2 = inspect$2(varType);

	      onError(new GraphQLError("Variable \"$".concat(varName, "\" of non-null type \"").concat(_varTypeStr2, "\" must not be null."), varDefNode));
	      return "continue";
	    }

	    coercedValues[varName] = coerceInputValue(value, varType, function (path, invalidValue, error) {
	      var prefix = "Variable \"$".concat(varName, "\" got invalid value ") + inspect$2(invalidValue);

	      if (path.length > 0) {
	        prefix += " at \"".concat(varName).concat(printPathArray(path), "\"");
	      }

	      onError(new GraphQLError(prefix + '; ' + error.message, varDefNode, undefined, undefined, undefined, error.originalError));
	    });
	  };

	  for (var _i2 = 0; _i2 < varDefNodes.length; _i2++) {
	    var _ret = _loop(_i2);

	    if (_ret === "continue") continue;
	  }

	  return coercedValues;
	}
	/**
	 * Prepares an object map of argument values given a list of argument
	 * definitions and list of argument AST nodes.
	 *
	 * Note: The returned value is a plain Object with a prototype, since it is
	 * exposed to user code. Care should be taken to not pull values from the
	 * Object prototype.
	 *
	 * @internal
	 */


	function getArgumentValues(def, node, variableValues) {
	  var _node$arguments;

	  var coercedValues = {}; // istanbul ignore next (See: 'https://github.com/graphql/graphql-js/issues/2203')

	  var argumentNodes = (_node$arguments = node.arguments) !== null && _node$arguments !== void 0 ? _node$arguments : [];
	  var argNodeMap = keyMap(argumentNodes, function (arg) {
	    return arg.name.value;
	  });

	  for (var _i4 = 0, _def$args2 = def.args; _i4 < _def$args2.length; _i4++) {
	    var argDef = _def$args2[_i4];
	    var name = argDef.name;
	    var argType = argDef.type;
	    var argumentNode = argNodeMap[name];

	    if (!argumentNode) {
	      if (argDef.defaultValue !== undefined) {
	        coercedValues[name] = argDef.defaultValue;
	      } else if (isNonNullType(argType)) {
	        throw new GraphQLError("Argument \"".concat(name, "\" of required type \"").concat(inspect$2(argType), "\" ") + 'was not provided.', node);
	      }

	      continue;
	    }

	    var valueNode = argumentNode.value;
	    var isNull = valueNode.kind === Kind.NULL;

	    if (valueNode.kind === Kind.VARIABLE) {
	      var variableName = valueNode.name.value;

	      if (variableValues == null || !hasOwnProperty$1(variableValues, variableName)) {
	        if (argDef.defaultValue !== undefined) {
	          coercedValues[name] = argDef.defaultValue;
	        } else if (isNonNullType(argType)) {
	          throw new GraphQLError("Argument \"".concat(name, "\" of required type \"").concat(inspect$2(argType), "\" ") + "was provided the variable \"$".concat(variableName, "\" which was not provided a runtime value."), valueNode);
	        }

	        continue;
	      }

	      isNull = variableValues[variableName] == null;
	    }

	    if (isNull && isNonNullType(argType)) {
	      throw new GraphQLError("Argument \"".concat(name, "\" of non-null type \"").concat(inspect$2(argType), "\" ") + 'must not be null.', valueNode);
	    }

	    var coercedValue = valueFromAST$1(valueNode, argType, variableValues);

	    if (coercedValue === undefined) {
	      // Note: ValuesOfCorrectTypeRule validation should catch this before
	      // execution. This is a runtime check to ensure execution does not
	      // continue with an invalid argument value.
	      throw new GraphQLError("Argument \"".concat(name, "\" has invalid value ").concat(print$1(valueNode), "."), valueNode);
	    }

	    coercedValues[name] = coercedValue;
	  }

	  return coercedValues;
	}
	/**
	 * Prepares an object map of argument values given a directive definition
	 * and a AST node which may contain directives. Optionally also accepts a map
	 * of variable values.
	 *
	 * If the directive does not exist on the node, returns undefined.
	 *
	 * Note: The returned value is a plain Object with a prototype, since it is
	 * exposed to user code. Care should be taken to not pull values from the
	 * Object prototype.
	 */

	function getDirectiveValues(directiveDef, node, variableValues) {
	  var directiveNode = node.directives && find$1(node.directives, function (directive) {
	    return directive.name.value === directiveDef.name;
	  });

	  if (directiveNode) {
	    return getArgumentValues(directiveDef, directiveNode, variableValues);
	  }
	}

	function hasOwnProperty$1(obj, prop) {
	  return Object.prototype.hasOwnProperty.call(obj, prop);
	}

	var values$1 = /*#__PURE__*/Object.freeze({
		__proto__: null,
		getVariableValues: getVariableValues,
		getArgumentValues: getArgumentValues,
		getDirectiveValues: getDirectiveValues
	});

	/**
	 * Terminology
	 *
	 * "Definitions" are the generic name for top-level statements in the document.
	 * Examples of this include:
	 * 1) Operations (such as a query)
	 * 2) Fragments
	 *
	 * "Operations" are a generic name for requests in the document.
	 * Examples of this include:
	 * 1) query,
	 * 2) mutation
	 *
	 * "Selections" are the definitions that can appear legally and at
	 * single level of the query. These include:
	 * 1) field references e.g "a"
	 * 2) fragment "spreads" e.g. "...c"
	 * 3) inline fragment "spreads" e.g. "...on Type { a }"
	 */

	/**
	 * Data that must be available at all points during query execution.
	 *
	 * Namely, schema of the type system that is currently executing,
	 * and the fragments defined in the query document
	 */

	function execute(argsOrSchema, document, rootValue, contextValue, variableValues, operationName, fieldResolver, typeResolver) {
	  /* eslint-enable no-redeclare */
	  // Extract arguments from object args if provided.
	  return arguments.length === 1 ? executeImpl(argsOrSchema) : executeImpl({
	    schema: argsOrSchema,
	    document: document,
	    rootValue: rootValue,
	    contextValue: contextValue,
	    variableValues: variableValues,
	    operationName: operationName,
	    fieldResolver: fieldResolver,
	    typeResolver: typeResolver
	  });
	}
	/**
	 * Also implements the "Evaluating requests" section of the GraphQL specification.
	 * However, it guarantees to complete synchronously (or throw an error) assuming
	 * that all field resolvers are also synchronous.
	 */

	function executeSync(args) {
	  var result = executeImpl(args); // Assert that the execution was synchronous.

	  if (isPromise(result)) {
	    throw new Error('GraphQL execution failed to complete synchronously.');
	  }

	  return result;
	}

	function executeImpl(args) {
	  var schema = args.schema,
	      document = args.document,
	      rootValue = args.rootValue,
	      contextValue = args.contextValue,
	      variableValues = args.variableValues,
	      operationName = args.operationName,
	      fieldResolver = args.fieldResolver,
	      typeResolver = args.typeResolver; // If arguments are missing or incorrect, throw an error.

	  assertValidExecutionArguments(schema, document, variableValues); // If a valid execution context cannot be created due to incorrect arguments,
	  // a "Response" with only errors is returned.

	  var exeContext = buildExecutionContext(schema, document, rootValue, contextValue, variableValues, operationName, fieldResolver, typeResolver); // Return early errors if execution context failed.

	  if (Array.isArray(exeContext)) {
	    return {
	      errors: exeContext
	    };
	  } // Return a Promise that will eventually resolve to the data described by
	  // The "Response" section of the GraphQL specification.
	  //
	  // If errors are encountered while executing a GraphQL field, only that
	  // field and its descendants will be omitted, and sibling fields will still
	  // be executed. An execution which encounters errors will still result in a
	  // resolved Promise.


	  var data = executeOperation(exeContext, exeContext.operation, rootValue);
	  return buildResponse(exeContext, data);
	}
	/**
	 * Given a completed execution context and data, build the { errors, data }
	 * response defined by the "Response" section of the GraphQL specification.
	 */


	function buildResponse(exeContext, data) {
	  if (isPromise(data)) {
	    return data.then(function (resolved) {
	      return buildResponse(exeContext, resolved);
	    });
	  }

	  return exeContext.errors.length === 0 ? {
	    data: data
	  } : {
	    errors: exeContext.errors,
	    data: data
	  };
	}
	/**
	 * Essential assertions before executing to provide developer feedback for
	 * improper use of the GraphQL library.
	 *
	 * @internal
	 */


	function assertValidExecutionArguments(schema, document, rawVariableValues) {
	  document || devAssert(0, 'Must provide document.'); // If the schema used for execution is invalid, throw an error.

	  assertValidSchema(schema); // Variables, if provided, must be an object.

	  rawVariableValues == null || isObjectLike(rawVariableValues) || devAssert(0, 'Variables must be provided as an Object where each property is a variable value. Perhaps look to see if an unparsed JSON string was provided.');
	}
	/**
	 * Constructs a ExecutionContext object from the arguments passed to
	 * execute, which we will pass throughout the other execution methods.
	 *
	 * Throws a GraphQLError if a valid execution context cannot be created.
	 *
	 * @internal
	 */

	function buildExecutionContext(schema, document, rootValue, contextValue, rawVariableValues, operationName, fieldResolver, typeResolver) {
	  var _definition$name, _operation$variableDe;

	  var operation;
	  var fragments = Object.create(null);

	  for (var _i2 = 0, _document$definitions2 = document.definitions; _i2 < _document$definitions2.length; _i2++) {
	    var definition = _document$definitions2[_i2];

	    switch (definition.kind) {
	      case Kind.OPERATION_DEFINITION:
	        if (operationName == null) {
	          if (operation !== undefined) {
	            return [new GraphQLError('Must provide operation name if query contains multiple operations.')];
	          }

	          operation = definition;
	        } else if (((_definition$name = definition.name) === null || _definition$name === void 0 ? void 0 : _definition$name.value) === operationName) {
	          operation = definition;
	        }

	        break;

	      case Kind.FRAGMENT_DEFINITION:
	        fragments[definition.name.value] = definition;
	        break;
	    }
	  }

	  if (!operation) {
	    if (operationName != null) {
	      return [new GraphQLError("Unknown operation named \"".concat(operationName, "\"."))];
	    }

	    return [new GraphQLError('Must provide an operation.')];
	  } // istanbul ignore next (See: 'https://github.com/graphql/graphql-js/issues/2203')


	  var variableDefinitions = (_operation$variableDe = operation.variableDefinitions) !== null && _operation$variableDe !== void 0 ? _operation$variableDe : [];
	  var coercedVariableValues = getVariableValues(schema, variableDefinitions, rawVariableValues !== null && rawVariableValues !== void 0 ? rawVariableValues : {}, {
	    maxErrors: 50
	  });

	  if (coercedVariableValues.errors) {
	    return coercedVariableValues.errors;
	  }

	  return {
	    schema: schema,
	    fragments: fragments,
	    rootValue: rootValue,
	    contextValue: contextValue,
	    operation: operation,
	    variableValues: coercedVariableValues.coerced,
	    fieldResolver: fieldResolver !== null && fieldResolver !== void 0 ? fieldResolver : defaultFieldResolver,
	    typeResolver: typeResolver !== null && typeResolver !== void 0 ? typeResolver : defaultTypeResolver,
	    errors: []
	  };
	}
	/**
	 * Implements the "Evaluating operations" section of the spec.
	 */

	function executeOperation(exeContext, operation, rootValue) {
	  var type = getOperationRootType(exeContext.schema, operation);
	  var fields = collectFields(exeContext, type, operation.selectionSet, Object.create(null), Object.create(null));
	  var path = undefined; // Errors from sub-fields of a NonNull type may propagate to the top level,
	  // at which point we still log the error and null the parent field, which
	  // in this case is the entire response.

	  try {
	    var result = operation.operation === 'mutation' ? executeFieldsSerially(exeContext, type, rootValue, path, fields) : executeFields(exeContext, type, rootValue, path, fields);

	    if (isPromise(result)) {
	      return result.then(undefined, function (error) {
	        exeContext.errors.push(error);
	        return Promise.resolve(null);
	      });
	    }

	    return result;
	  } catch (error) {
	    exeContext.errors.push(error);
	    return null;
	  }
	}
	/**
	 * Implements the "Evaluating selection sets" section of the spec
	 * for "write" mode.
	 */


	function executeFieldsSerially(exeContext, parentType, sourceValue, path, fields) {
	  return promiseReduce(Object.keys(fields), function (results, responseName) {
	    var fieldNodes = fields[responseName];
	    var fieldPath = addPath(path, responseName, parentType.name);
	    var result = resolveField(exeContext, parentType, sourceValue, fieldNodes, fieldPath);

	    if (result === undefined) {
	      return results;
	    }

	    if (isPromise(result)) {
	      return result.then(function (resolvedResult) {
	        results[responseName] = resolvedResult;
	        return results;
	      });
	    }

	    results[responseName] = result;
	    return results;
	  }, Object.create(null));
	}
	/**
	 * Implements the "Evaluating selection sets" section of the spec
	 * for "read" mode.
	 */


	function executeFields(exeContext, parentType, sourceValue, path, fields) {
	  var results = Object.create(null);
	  var containsPromise = false;

	  for (var _i4 = 0, _Object$keys2 = Object.keys(fields); _i4 < _Object$keys2.length; _i4++) {
	    var responseName = _Object$keys2[_i4];
	    var fieldNodes = fields[responseName];
	    var fieldPath = addPath(path, responseName, parentType.name);
	    var result = resolveField(exeContext, parentType, sourceValue, fieldNodes, fieldPath);

	    if (result !== undefined) {
	      results[responseName] = result;

	      if (isPromise(result)) {
	        containsPromise = true;
	      }
	    }
	  } // If there are no promises, we can just return the object


	  if (!containsPromise) {
	    return results;
	  } // Otherwise, results is a map from field name to the result of resolving that
	  // field, which is possibly a promise. Return a promise that will return this
	  // same map, but with any promises replaced with the values they resolved to.


	  return promiseForObject(results);
	}
	/**
	 * Given a selectionSet, adds all of the fields in that selection to
	 * the passed in map of fields, and returns it at the end.
	 *
	 * CollectFields requires the "runtime type" of an object. For a field which
	 * returns an Interface or Union type, the "runtime type" will be the actual
	 * Object type returned by that field.
	 *
	 * @internal
	 */


	function collectFields(exeContext, runtimeType, selectionSet, fields, visitedFragmentNames) {
	  for (var _i6 = 0, _selectionSet$selecti2 = selectionSet.selections; _i6 < _selectionSet$selecti2.length; _i6++) {
	    var selection = _selectionSet$selecti2[_i6];

	    switch (selection.kind) {
	      case Kind.FIELD:
	        {
	          if (!shouldIncludeNode(exeContext, selection)) {
	            continue;
	          }

	          var name = getFieldEntryKey(selection);

	          if (!fields[name]) {
	            fields[name] = [];
	          }

	          fields[name].push(selection);
	          break;
	        }

	      case Kind.INLINE_FRAGMENT:
	        {
	          if (!shouldIncludeNode(exeContext, selection) || !doesFragmentConditionMatch(exeContext, selection, runtimeType)) {
	            continue;
	          }

	          collectFields(exeContext, runtimeType, selection.selectionSet, fields, visitedFragmentNames);
	          break;
	        }

	      case Kind.FRAGMENT_SPREAD:
	        {
	          var fragName = selection.name.value;

	          if (visitedFragmentNames[fragName] || !shouldIncludeNode(exeContext, selection)) {
	            continue;
	          }

	          visitedFragmentNames[fragName] = true;
	          var fragment = exeContext.fragments[fragName];

	          if (!fragment || !doesFragmentConditionMatch(exeContext, fragment, runtimeType)) {
	            continue;
	          }

	          collectFields(exeContext, runtimeType, fragment.selectionSet, fields, visitedFragmentNames);
	          break;
	        }
	    }
	  }

	  return fields;
	}
	/**
	 * Determines if a field should be included based on the @include and @skip
	 * directives, where @skip has higher precedence than @include.
	 */

	function shouldIncludeNode(exeContext, node) {
	  var skip = getDirectiveValues(GraphQLSkipDirective, node, exeContext.variableValues);

	  if ((skip === null || skip === void 0 ? void 0 : skip.if) === true) {
	    return false;
	  }

	  var include = getDirectiveValues(GraphQLIncludeDirective, node, exeContext.variableValues);

	  if ((include === null || include === void 0 ? void 0 : include.if) === false) {
	    return false;
	  }

	  return true;
	}
	/**
	 * Determines if a fragment is applicable to the given type.
	 */


	function doesFragmentConditionMatch(exeContext, fragment, type) {
	  var typeConditionNode = fragment.typeCondition;

	  if (!typeConditionNode) {
	    return true;
	  }

	  var conditionalType = typeFromAST(exeContext.schema, typeConditionNode);

	  if (conditionalType === type) {
	    return true;
	  }

	  if (isAbstractType(conditionalType)) {
	    return exeContext.schema.isSubType(conditionalType, type);
	  }

	  return false;
	}
	/**
	 * Implements the logic to compute the key of a given field's entry
	 */


	function getFieldEntryKey(node) {
	  return node.alias ? node.alias.value : node.name.value;
	}
	/**
	 * Resolves the field on the given source object. In particular, this
	 * figures out the value that the field returns by calling its resolve function,
	 * then calls completeValue to complete promises, serialize scalars, or execute
	 * the sub-selection-set for objects.
	 */


	function resolveField(exeContext, parentType, source, fieldNodes, path) {
	  var _fieldDef$resolve;

	  var fieldNode = fieldNodes[0];
	  var fieldName = fieldNode.name.value;
	  var fieldDef = getFieldDef(exeContext.schema, parentType, fieldName);

	  if (!fieldDef) {
	    return;
	  }

	  var returnType = fieldDef.type;
	  var resolveFn = (_fieldDef$resolve = fieldDef.resolve) !== null && _fieldDef$resolve !== void 0 ? _fieldDef$resolve : exeContext.fieldResolver;
	  var info = buildResolveInfo(exeContext, fieldDef, fieldNodes, parentType, path); // Get the resolve function, regardless of if its result is normal or abrupt (error).

	  try {
	    // Build a JS object of arguments from the field.arguments AST, using the
	    // variables scope to fulfill any variable references.
	    // TODO: find a way to memoize, in case this field is within a List type.
	    var args = getArgumentValues(fieldDef, fieldNodes[0], exeContext.variableValues); // The resolve function's optional third argument is a context value that
	    // is provided to every resolve function within an execution. It is commonly
	    // used to represent an authenticated user, or request-specific caches.

	    var _contextValue = exeContext.contextValue;
	    var result = resolveFn(source, args, _contextValue, info);
	    var completed;

	    if (isPromise(result)) {
	      completed = result.then(function (resolved) {
	        return completeValue(exeContext, returnType, fieldNodes, info, path, resolved);
	      });
	    } else {
	      completed = completeValue(exeContext, returnType, fieldNodes, info, path, result);
	    }

	    if (isPromise(completed)) {
	      // Note: we don't rely on a `catch` method, but we do expect "thenable"
	      // to take a second callback for the error case.
	      return completed.then(undefined, function (rawError) {
	        var error = locatedError(rawError, fieldNodes, pathToArray(path));
	        return handleFieldError(error, returnType, exeContext);
	      });
	    }

	    return completed;
	  } catch (rawError) {
	    var error = locatedError(rawError, fieldNodes, pathToArray(path));
	    return handleFieldError(error, returnType, exeContext);
	  }
	}
	/**
	 * @internal
	 */


	function buildResolveInfo(exeContext, fieldDef, fieldNodes, parentType, path) {
	  // The resolve function's optional fourth argument is a collection of
	  // information about the current execution state.
	  return {
	    fieldName: fieldDef.name,
	    fieldNodes: fieldNodes,
	    returnType: fieldDef.type,
	    parentType: parentType,
	    path: path,
	    schema: exeContext.schema,
	    fragments: exeContext.fragments,
	    rootValue: exeContext.rootValue,
	    operation: exeContext.operation,
	    variableValues: exeContext.variableValues
	  };
	}

	function handleFieldError(error, returnType, exeContext) {
	  // If the field type is non-nullable, then it is resolved without any
	  // protection from errors, however it still properly locates the error.
	  if (isNonNullType(returnType)) {
	    throw error;
	  } // Otherwise, error protection is applied, logging the error and resolving
	  // a null value for this field if one is encountered.


	  exeContext.errors.push(error);
	  return null;
	}
	/**
	 * Implements the instructions for completeValue as defined in the
	 * "Field entries" section of the spec.
	 *
	 * If the field type is Non-Null, then this recursively completes the value
	 * for the inner type. It throws a field error if that completion returns null,
	 * as per the "Nullability" section of the spec.
	 *
	 * If the field type is a List, then this recursively completes the value
	 * for the inner type on each item in the list.
	 *
	 * If the field type is a Scalar or Enum, ensures the completed value is a legal
	 * value of the type by calling the `serialize` method of GraphQL type
	 * definition.
	 *
	 * If the field is an abstract type, determine the runtime type of the value
	 * and then complete based on that type
	 *
	 * Otherwise, the field type expects a sub-selection set, and will complete the
	 * value by evaluating all sub-selections.
	 */


	function completeValue(exeContext, returnType, fieldNodes, info, path, result) {
	  // If result is an Error, throw a located error.
	  if (result instanceof Error) {
	    throw result;
	  } // If field type is NonNull, complete for inner type, and throw field error
	  // if result is null.


	  if (isNonNullType(returnType)) {
	    var completed = completeValue(exeContext, returnType.ofType, fieldNodes, info, path, result);

	    if (completed === null) {
	      throw new Error("Cannot return null for non-nullable field ".concat(info.parentType.name, ".").concat(info.fieldName, "."));
	    }

	    return completed;
	  } // If result value is null or undefined then return null.


	  if (result == null) {
	    return null;
	  } // If field type is List, complete each item in the list with the inner type


	  if (isListType(returnType)) {
	    return completeListValue(exeContext, returnType, fieldNodes, info, path, result);
	  } // If field type is a leaf type, Scalar or Enum, serialize to a valid value,
	  // returning null if serialization is not possible.


	  if (isLeafType(returnType)) {
	    return completeLeafValue(returnType, result);
	  } // If field type is an abstract type, Interface or Union, determine the
	  // runtime Object type and complete for that type.


	  if (isAbstractType(returnType)) {
	    return completeAbstractValue(exeContext, returnType, fieldNodes, info, path, result);
	  } // If field type is Object, execute and complete all sub-selections.
	  // istanbul ignore else (See: 'https://github.com/graphql/graphql-js/issues/2618')


	  if (isObjectType(returnType)) {
	    return completeObjectValue(exeContext, returnType, fieldNodes, info, path, result);
	  } // istanbul ignore next (Not reachable. All possible output types have been considered)


	  invariant(0, 'Cannot complete value of unexpected output type: ' + inspect$2(returnType));
	}
	/**
	 * Complete a list value by completing each item in the list with the
	 * inner type
	 */


	function completeListValue(exeContext, returnType, fieldNodes, info, path, result) {
	  // This is specified as a simple map, however we're optimizing the path
	  // where the list contains no Promises by avoiding creating another Promise.
	  var itemType = returnType.ofType;
	  var containsPromise = false;
	  var completedResults = safeArrayFrom(result, function (item, index) {
	    // No need to modify the info object containing the path,
	    // since from here on it is not ever accessed by resolver functions.
	    var itemPath = addPath(path, index, undefined);

	    try {
	      var completedItem;

	      if (isPromise(item)) {
	        completedItem = item.then(function (resolved) {
	          return completeValue(exeContext, itemType, fieldNodes, info, itemPath, resolved);
	        });
	      } else {
	        completedItem = completeValue(exeContext, itemType, fieldNodes, info, itemPath, item);
	      }

	      if (isPromise(completedItem)) {
	        containsPromise = true; // Note: we don't rely on a `catch` method, but we do expect "thenable"
	        // to take a second callback for the error case.

	        return completedItem.then(undefined, function (rawError) {
	          var error = locatedError(rawError, fieldNodes, pathToArray(itemPath));
	          return handleFieldError(error, itemType, exeContext);
	        });
	      }

	      return completedItem;
	    } catch (rawError) {
	      var error = locatedError(rawError, fieldNodes, pathToArray(itemPath));
	      return handleFieldError(error, itemType, exeContext);
	    }
	  });

	  if (completedResults == null) {
	    throw new GraphQLError("Expected Iterable, but did not find one for field \"".concat(info.parentType.name, ".").concat(info.fieldName, "\"."));
	  }

	  return containsPromise ? Promise.all(completedResults) : completedResults;
	}
	/**
	 * Complete a Scalar or Enum by serializing to a valid value, returning
	 * null if serialization is not possible.
	 */


	function completeLeafValue(returnType, result) {
	  var serializedResult = returnType.serialize(result);

	  if (serializedResult === undefined) {
	    throw new Error("Expected a value of type \"".concat(inspect$2(returnType), "\" but ") + "received: ".concat(inspect$2(result)));
	  }

	  return serializedResult;
	}
	/**
	 * Complete a value of an abstract type by determining the runtime object type
	 * of that value, then complete the value for that type.
	 */


	function completeAbstractValue(exeContext, returnType, fieldNodes, info, path, result) {
	  var _returnType$resolveTy;

	  var resolveTypeFn = (_returnType$resolveTy = returnType.resolveType) !== null && _returnType$resolveTy !== void 0 ? _returnType$resolveTy : exeContext.typeResolver;
	  var contextValue = exeContext.contextValue;
	  var runtimeType = resolveTypeFn(result, contextValue, info, returnType);

	  if (isPromise(runtimeType)) {
	    return runtimeType.then(function (resolvedRuntimeType) {
	      return completeObjectValue(exeContext, ensureValidRuntimeType(resolvedRuntimeType, exeContext, returnType, fieldNodes, info, result), fieldNodes, info, path, result);
	    });
	  }

	  return completeObjectValue(exeContext, ensureValidRuntimeType(runtimeType, exeContext, returnType, fieldNodes, info, result), fieldNodes, info, path, result);
	}

	function ensureValidRuntimeType(runtimeTypeOrName, exeContext, returnType, fieldNodes, info, result) {
	  if (runtimeTypeOrName == null) {
	    throw new GraphQLError("Abstract type \"".concat(returnType.name, "\" must resolve to an Object type at runtime for field \"").concat(info.parentType.name, ".").concat(info.fieldName, "\". Either the \"").concat(returnType.name, "\" type should provide a \"resolveType\" function or each possible type should provide an \"isTypeOf\" function."), fieldNodes);
	  } // FIXME: temporary workaround until support for passing object types would be removed in v16.0.0


	  var runtimeTypeName = isNamedType(runtimeTypeOrName) ? runtimeTypeOrName.name : runtimeTypeOrName;

	  if (typeof runtimeTypeName !== 'string') {
	    throw new GraphQLError("Abstract type \"".concat(returnType.name, "\" must resolve to an Object type at runtime for field \"").concat(info.parentType.name, ".").concat(info.fieldName, "\" with ") + "value ".concat(inspect$2(result), ", received \"").concat(inspect$2(runtimeTypeOrName), "\"."));
	  }

	  var runtimeType = exeContext.schema.getType(runtimeTypeName);

	  if (runtimeType == null) {
	    throw new GraphQLError("Abstract type \"".concat(returnType.name, "\" was resolve to a type \"").concat(runtimeTypeName, "\" that does not exist inside schema."), fieldNodes);
	  }

	  if (!isObjectType(runtimeType)) {
	    throw new GraphQLError("Abstract type \"".concat(returnType.name, "\" was resolve to a non-object type \"").concat(runtimeTypeName, "\"."), fieldNodes);
	  }

	  if (!exeContext.schema.isSubType(returnType, runtimeType)) {
	    throw new GraphQLError("Runtime Object type \"".concat(runtimeType.name, "\" is not a possible type for \"").concat(returnType.name, "\"."), fieldNodes);
	  }

	  return runtimeType;
	}
	/**
	 * Complete an Object value by executing all sub-selections.
	 */


	function completeObjectValue(exeContext, returnType, fieldNodes, info, path, result) {
	  // If there is an isTypeOf predicate function, call it with the
	  // current result. If isTypeOf returns false, then raise an error rather
	  // than continuing execution.
	  if (returnType.isTypeOf) {
	    var isTypeOf = returnType.isTypeOf(result, exeContext.contextValue, info);

	    if (isPromise(isTypeOf)) {
	      return isTypeOf.then(function (resolvedIsTypeOf) {
	        if (!resolvedIsTypeOf) {
	          throw invalidReturnTypeError(returnType, result, fieldNodes);
	        }

	        return collectAndExecuteSubfields(exeContext, returnType, fieldNodes, path, result);
	      });
	    }

	    if (!isTypeOf) {
	      throw invalidReturnTypeError(returnType, result, fieldNodes);
	    }
	  }

	  return collectAndExecuteSubfields(exeContext, returnType, fieldNodes, path, result);
	}

	function invalidReturnTypeError(returnType, result, fieldNodes) {
	  return new GraphQLError("Expected value of type \"".concat(returnType.name, "\" but got: ").concat(inspect$2(result), "."), fieldNodes);
	}

	function collectAndExecuteSubfields(exeContext, returnType, fieldNodes, path, result) {
	  // Collect sub-fields to execute to complete this value.
	  var subFieldNodes = collectSubfields(exeContext, returnType, fieldNodes);
	  return executeFields(exeContext, returnType, result, path, subFieldNodes);
	}
	/**
	 * A memoized collection of relevant subfields with regard to the return
	 * type. Memoizing ensures the subfields are not repeatedly calculated, which
	 * saves overhead when resolving lists of values.
	 */


	var collectSubfields = memoize3(_collectSubfields);

	function _collectSubfields(exeContext, returnType, fieldNodes) {
	  var subFieldNodes = Object.create(null);
	  var visitedFragmentNames = Object.create(null);

	  for (var _i8 = 0; _i8 < fieldNodes.length; _i8++) {
	    var node = fieldNodes[_i8];

	    if (node.selectionSet) {
	      subFieldNodes = collectFields(exeContext, returnType, node.selectionSet, subFieldNodes, visitedFragmentNames);
	    }
	  }

	  return subFieldNodes;
	}
	/**
	 * If a resolveType function is not given, then a default resolve behavior is
	 * used which attempts two strategies:
	 *
	 * First, See if the provided value has a `__typename` field defined, if so, use
	 * that value as name of the resolved type.
	 *
	 * Otherwise, test each possible type for the abstract type by calling
	 * isTypeOf for the object being coerced, returning the first type that matches.
	 */


	var defaultTypeResolver = function defaultTypeResolver(value, contextValue, info, abstractType) {
	  // First, look for `__typename`.
	  if (isObjectLike(value) && typeof value.__typename === 'string') {
	    return value.__typename;
	  } // Otherwise, test each possible type.


	  var possibleTypes = info.schema.getPossibleTypes(abstractType);
	  var promisedIsTypeOfResults = [];

	  for (var i = 0; i < possibleTypes.length; i++) {
	    var type = possibleTypes[i];

	    if (type.isTypeOf) {
	      var isTypeOfResult = type.isTypeOf(value, contextValue, info);

	      if (isPromise(isTypeOfResult)) {
	        promisedIsTypeOfResults[i] = isTypeOfResult;
	      } else if (isTypeOfResult) {
	        return type.name;
	      }
	    }
	  }

	  if (promisedIsTypeOfResults.length) {
	    return Promise.all(promisedIsTypeOfResults).then(function (isTypeOfResults) {
	      for (var _i9 = 0; _i9 < isTypeOfResults.length; _i9++) {
	        if (isTypeOfResults[_i9]) {
	          return possibleTypes[_i9].name;
	        }
	      }
	    });
	  }
	};
	/**
	 * If a resolve function is not given, then a default resolve behavior is used
	 * which takes the property of the source object of the same name as the field
	 * and returns it as the result, or if it's a function, returns the result
	 * of calling that function while passing along args and context value.
	 */

	var defaultFieldResolver = function defaultFieldResolver(source, args, contextValue, info) {
	  // ensure source is a value for which property access is acceptable.
	  if (isObjectLike(source) || typeof source === 'function') {
	    var property = source[info.fieldName];

	    if (typeof property === 'function') {
	      return source[info.fieldName](args, contextValue, info);
	    }

	    return property;
	  }
	};
	/**
	 * This method looks up the field on the given type definition.
	 * It has special casing for the three introspection fields,
	 * __schema, __type and __typename. __typename is special because
	 * it can always be queried as a field, even in situations where no
	 * other fields are allowed, like on a Union. __schema and __type
	 * could get automatically added to the query type, but that would
	 * require mutating type definitions, which would cause issues.
	 *
	 * @internal
	 */

	function getFieldDef(schema, parentType, fieldName) {
	  if (fieldName === SchemaMetaFieldDef.name && schema.getQueryType() === parentType) {
	    return SchemaMetaFieldDef;
	  } else if (fieldName === TypeMetaFieldDef.name && schema.getQueryType() === parentType) {
	    return TypeMetaFieldDef;
	  } else if (fieldName === TypeNameMetaFieldDef.name) {
	    return TypeNameMetaFieldDef;
	  }

	  return parentType.getFields()[fieldName];
	}

	/**
	 * This is the primary entry point function for fulfilling GraphQL operations
	 * by parsing, validating, and executing a GraphQL document along side a
	 * GraphQL schema.
	 *
	 * More sophisticated GraphQL servers, such as those which persist queries,
	 * may wish to separate the validation and execution phases to a static time
	 * tooling step, and a server runtime step.
	 *
	 * Accepts either an object with named arguments, or individual arguments:
	 *
	 * schema:
	 *    The GraphQL type system to use when validating and executing a query.
	 * source:
	 *    A GraphQL language formatted string representing the requested operation.
	 * rootValue:
	 *    The value provided as the first argument to resolver functions on the top
	 *    level type (e.g. the query object type).
	 * contextValue:
	 *    The context value is provided as an argument to resolver functions after
	 *    field arguments. It is used to pass shared information useful at any point
	 *    during executing this query, for example the currently logged in user and
	 *    connections to databases or other services.
	 * variableValues:
	 *    A mapping of variable name to runtime value to use for all variables
	 *    defined in the requestString.
	 * operationName:
	 *    The name of the operation to use if requestString contains multiple
	 *    possible operations. Can be omitted if requestString contains only
	 *    one operation.
	 * fieldResolver:
	 *    A resolver function to use when one is not provided by the schema.
	 *    If not provided, the default field resolver is used (which looks for a
	 *    value or method on the source value with the field's name).
	 * typeResolver:
	 *    A type resolver function to use when none is provided by the schema.
	 *    If not provided, the default type resolver is used (which looks for a
	 *    `__typename` field or alternatively calls the `isTypeOf` method).
	 */

	function graphql$1(argsOrSchema, source, rootValue, contextValue, variableValues, operationName, fieldResolver, typeResolver) {
	  var _arguments = arguments;

	  /* eslint-enable no-redeclare */
	  // Always return a Promise for a consistent API.
	  return new Promise(function (resolve) {
	    return resolve( // Extract arguments from object args if provided.
	    _arguments.length === 1 ? graphqlImpl(argsOrSchema) : graphqlImpl({
	      schema: argsOrSchema,
	      source: source,
	      rootValue: rootValue,
	      contextValue: contextValue,
	      variableValues: variableValues,
	      operationName: operationName,
	      fieldResolver: fieldResolver,
	      typeResolver: typeResolver
	    }));
	  });
	}
	/**
	 * The graphqlSync function also fulfills GraphQL operations by parsing,
	 * validating, and executing a GraphQL document along side a GraphQL schema.
	 * However, it guarantees to complete synchronously (or throw an error) assuming
	 * that all field resolvers are also synchronous.
	 */

	function graphqlSync(argsOrSchema, source, rootValue, contextValue, variableValues, operationName, fieldResolver, typeResolver) {
	  /* eslint-enable no-redeclare */
	  // Extract arguments from object args if provided.
	  var result = arguments.length === 1 ? graphqlImpl(argsOrSchema) : graphqlImpl({
	    schema: argsOrSchema,
	    source: source,
	    rootValue: rootValue,
	    contextValue: contextValue,
	    variableValues: variableValues,
	    operationName: operationName,
	    fieldResolver: fieldResolver,
	    typeResolver: typeResolver
	  }); // Assert that the execution was synchronous.

	  if (isPromise(result)) {
	    throw new Error('GraphQL execution failed to complete synchronously.');
	  }

	  return result;
	}

	function graphqlImpl(args) {
	  var schema = args.schema,
	      source = args.source,
	      rootValue = args.rootValue,
	      contextValue = args.contextValue,
	      variableValues = args.variableValues,
	      operationName = args.operationName,
	      fieldResolver = args.fieldResolver,
	      typeResolver = args.typeResolver; // Validate Schema

	  var schemaValidationErrors = validateSchema$1(schema);

	  if (schemaValidationErrors.length > 0) {
	    return {
	      errors: schemaValidationErrors
	    };
	  } // Parse


	  var document;

	  try {
	    document = parse(source);
	  } catch (syntaxError) {
	    return {
	      errors: [syntaxError]
	    };
	  } // Validate


	  var validationErrors = validate$3(schema, document);

	  if (validationErrors.length > 0) {
	    return {
	      errors: validationErrors
	    };
	  } // Execute


	  return execute({
	    schema: schema,
	    document: document,
	    rootValue: rootValue,
	    contextValue: contextValue,
	    variableValues: variableValues,
	    operationName: operationName,
	    fieldResolver: fieldResolver,
	    typeResolver: typeResolver
	  });
	}

	/**
	 * Returns true if the provided object implements the AsyncIterator protocol via
	 * either implementing a `Symbol.asyncIterator` or `"@@asyncIterator"` method.
	 */

	// eslint-disable-next-line no-redeclare
	function isAsyncIterable(maybeAsyncIterable) {
	  return typeof (maybeAsyncIterable === null || maybeAsyncIterable === void 0 ? void 0 : maybeAsyncIterable[SYMBOL_ASYNC_ITERATOR]) === 'function';
	}

	function _defineProperty$5(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

	/**
	 * Given an AsyncIterable and a callback function, return an AsyncIterator
	 * which produces values mapped via calling the callback function.
	 */
	function mapAsyncIterator(iterable, callback, rejectCallback) {
	  // $FlowFixMe[prop-missing]
	  var iteratorMethod = iterable[SYMBOL_ASYNC_ITERATOR];
	  var iterator = iteratorMethod.call(iterable);
	  var $return;
	  var abruptClose;

	  if (typeof iterator.return === 'function') {
	    $return = iterator.return;

	    abruptClose = function abruptClose(error) {
	      var rethrow = function rethrow() {
	        return Promise.reject(error);
	      };

	      return $return.call(iterator).then(rethrow, rethrow);
	    };
	  }

	  function mapResult(result) {
	    return result.done ? result : asyncMapValue(result.value, callback).then(iteratorResult, abruptClose);
	  }

	  var mapReject;

	  if (rejectCallback) {
	    // Capture rejectCallback to ensure it cannot be null.
	    var reject = rejectCallback;

	    mapReject = function mapReject(error) {
	      return asyncMapValue(error, reject).then(iteratorResult, abruptClose);
	    };
	  }
	  /* TODO: Flow doesn't support symbols as keys:
	     https://github.com/facebook/flow/issues/3258 */


	  return _defineProperty$5({
	    next: function next() {
	      return iterator.next().then(mapResult, mapReject);
	    },
	    return: function _return() {
	      return $return ? $return.call(iterator).then(mapResult, mapReject) : Promise.resolve({
	        value: undefined,
	        done: true
	      });
	    },
	    throw: function _throw(error) {
	      if (typeof iterator.throw === 'function') {
	        return iterator.throw(error).then(mapResult, mapReject);
	      }

	      return Promise.reject(error).catch(abruptClose);
	    }
	  }, SYMBOL_ASYNC_ITERATOR, function () {
	    return this;
	  });
	}

	function asyncMapValue(value, callback) {
	  return new Promise(function (resolve) {
	    return resolve(callback(value));
	  });
	}

	function iteratorResult(value) {
	  return {
	    value: value,
	    done: false
	  };
	}

	function subscribe(argsOrSchema, document, rootValue, contextValue, variableValues, operationName, fieldResolver, subscribeFieldResolver) {
	  /* eslint-enable no-redeclare */
	  // Extract arguments from object args if provided.
	  return arguments.length === 1 ? subscribeImpl(argsOrSchema) : subscribeImpl({
	    schema: argsOrSchema,
	    document: document,
	    rootValue: rootValue,
	    contextValue: contextValue,
	    variableValues: variableValues,
	    operationName: operationName,
	    fieldResolver: fieldResolver,
	    subscribeFieldResolver: subscribeFieldResolver
	  });
	}
	/**
	 * This function checks if the error is a GraphQLError. If it is, report it as
	 * an ExecutionResult, containing only errors and no data. Otherwise treat the
	 * error as a system-class error and re-throw it.
	 */

	function reportGraphQLError(error) {
	  if (error instanceof GraphQLError) {
	    return {
	      errors: [error]
	    };
	  }

	  throw error;
	}

	function subscribeImpl(args) {
	  var schema = args.schema,
	      document = args.document,
	      rootValue = args.rootValue,
	      contextValue = args.contextValue,
	      variableValues = args.variableValues,
	      operationName = args.operationName,
	      fieldResolver = args.fieldResolver,
	      subscribeFieldResolver = args.subscribeFieldResolver;
	  var sourcePromise = createSourceEventStream(schema, document, rootValue, contextValue, variableValues, operationName, subscribeFieldResolver); // For each payload yielded from a subscription, map it over the normal
	  // GraphQL `execute` function, with `payload` as the rootValue.
	  // This implements the "MapSourceToResponseEvent" algorithm described in
	  // the GraphQL specification. The `execute` function provides the
	  // "ExecuteSubscriptionEvent" algorithm, as it is nearly identical to the
	  // "ExecuteQuery" algorithm, for which `execute` is also used.

	  var mapSourceToResponse = function mapSourceToResponse(payload) {
	    return execute({
	      schema: schema,
	      document: document,
	      rootValue: payload,
	      contextValue: contextValue,
	      variableValues: variableValues,
	      operationName: operationName,
	      fieldResolver: fieldResolver
	    });
	  }; // Resolve the Source Stream, then map every source value to a
	  // ExecutionResult value as described above.


	  return sourcePromise.then(function (resultOrStream) {
	    return (// Note: Flow can't refine isAsyncIterable, so explicit casts are used.
	      isAsyncIterable(resultOrStream) ? mapAsyncIterator(resultOrStream, mapSourceToResponse, reportGraphQLError) : resultOrStream
	    );
	  });
	}
	/**
	 * Implements the "CreateSourceEventStream" algorithm described in the
	 * GraphQL specification, resolving the subscription source event stream.
	 *
	 * Returns a Promise which resolves to either an AsyncIterable (if successful)
	 * or an ExecutionResult (error). The promise will be rejected if the schema or
	 * other arguments to this function are invalid, or if the resolved event stream
	 * is not an async iterable.
	 *
	 * If the client-provided arguments to this function do not result in a
	 * compliant subscription, a GraphQL Response (ExecutionResult) with
	 * descriptive errors and no data will be returned.
	 *
	 * If the the source stream could not be created due to faulty subscription
	 * resolver logic or underlying systems, the promise will resolve to a single
	 * ExecutionResult containing `errors` and no `data`.
	 *
	 * If the operation succeeded, the promise resolves to the AsyncIterable for the
	 * event stream returned by the resolver.
	 *
	 * A Source Event Stream represents a sequence of events, each of which triggers
	 * a GraphQL execution for that event.
	 *
	 * This may be useful when hosting the stateful subscription service in a
	 * different process or machine than the stateless GraphQL execution engine,
	 * or otherwise separating these two steps. For more on this, see the
	 * "Supporting Subscriptions at Scale" information in the GraphQL specification.
	 */


	function createSourceEventStream(schema, document, rootValue, contextValue, variableValues, operationName, fieldResolver) {
	  // If arguments are missing or incorrectly typed, this is an internal
	  // developer mistake which should throw an early error.
	  assertValidExecutionArguments(schema, document, variableValues);
	  return new Promise(function (resolve) {
	    // If a valid context cannot be created due to incorrect arguments,
	    // this will throw an error.
	    var exeContext = buildExecutionContext(schema, document, rootValue, contextValue, variableValues, operationName, fieldResolver);
	    resolve( // Return early errors if execution context failed.
	    Array.isArray(exeContext) ? {
	      errors: exeContext
	    } : executeSubscription(exeContext));
	  }).catch(reportGraphQLError);
	}

	function executeSubscription(exeContext) {
	  var schema = exeContext.schema,
	      operation = exeContext.operation,
	      variableValues = exeContext.variableValues,
	      rootValue = exeContext.rootValue;
	  var type = getOperationRootType(schema, operation);
	  var fields = collectFields(exeContext, type, operation.selectionSet, Object.create(null), Object.create(null));
	  var responseNames = Object.keys(fields);
	  var responseName = responseNames[0];
	  var fieldNodes = fields[responseName];
	  var fieldNode = fieldNodes[0];
	  var fieldName = fieldNode.name.value;
	  var fieldDef = getFieldDef(schema, type, fieldName);

	  if (!fieldDef) {
	    throw new GraphQLError("The subscription field \"".concat(fieldName, "\" is not defined."), fieldNodes);
	  }

	  var path = addPath(undefined, responseName, type.name);
	  var info = buildResolveInfo(exeContext, fieldDef, fieldNodes, type, path); // Coerce to Promise for easier error handling and consistent return type.

	  return new Promise(function (resolveResult) {
	    var _fieldDef$subscribe;

	    // Implements the "ResolveFieldEventStream" algorithm from GraphQL specification.
	    // It differs from "ResolveFieldValue" due to providing a different `resolveFn`.
	    // Build a JS object of arguments from the field.arguments AST, using the
	    // variables scope to fulfill any variable references.
	    var args = getArgumentValues(fieldDef, fieldNodes[0], variableValues); // The resolve function's optional third argument is a context value that
	    // is provided to every resolve function within an execution. It is commonly
	    // used to represent an authenticated user, or request-specific caches.

	    var contextValue = exeContext.contextValue; // Call the `subscribe()` resolver or the default resolver to produce an
	    // AsyncIterable yielding raw payloads.

	    var resolveFn = (_fieldDef$subscribe = fieldDef.subscribe) !== null && _fieldDef$subscribe !== void 0 ? _fieldDef$subscribe : exeContext.fieldResolver;
	    resolveResult(resolveFn(rootValue, args, contextValue, info));
	  }).then(function (eventStream) {
	    if (eventStream instanceof Error) {
	      throw locatedError(eventStream, fieldNodes, pathToArray(path));
	    } // Assert field returned an event stream, otherwise yield an error.


	    if (!isAsyncIterable(eventStream)) {
	      throw new Error('Subscription field must return Async Iterable. ' + "Received: ".concat(inspect$2(eventStream), "."));
	    }

	    return eventStream;
	  }, function (error) {
	    throw locatedError(error, fieldNodes, pathToArray(path));
	  });
	}

	/**
	 * No deprecated
	 *
	 * A GraphQL document is only valid if all selected fields and all used enum values have not been
	 * deprecated.
	 *
	 * Note: This rule is optional and is not part of the Validation section of the GraphQL
	 * Specification. The main purpose of this rule is detection of deprecated usages and not
	 * necessarily to forbid their use when querying a service.
	 */
	function NoDeprecatedCustomRule(context) {
	  return {
	    Field: function Field(node) {
	      var fieldDef = context.getFieldDef();
	      var deprecationReason = fieldDef === null || fieldDef === void 0 ? void 0 : fieldDef.deprecationReason;

	      if (fieldDef && deprecationReason != null) {
	        var parentType = context.getParentType();
	        parentType != null || invariant(0);
	        context.reportError(new GraphQLError("The field ".concat(parentType.name, ".").concat(fieldDef.name, " is deprecated. ").concat(deprecationReason), node));
	      }
	    },
	    Argument: function Argument(node) {
	      var argDef = context.getArgument();
	      var deprecationReason = argDef === null || argDef === void 0 ? void 0 : argDef.deprecationReason;

	      if (argDef && deprecationReason != null) {
	        var directiveDef = context.getDirective();

	        if (directiveDef != null) {
	          context.reportError(new GraphQLError("Directive \"@".concat(directiveDef.name, "\" argument \"").concat(argDef.name, "\" is deprecated. ").concat(deprecationReason), node));
	        } else {
	          var parentType = context.getParentType();
	          var fieldDef = context.getFieldDef();
	          parentType != null && fieldDef != null || invariant(0);
	          context.reportError(new GraphQLError("Field \"".concat(parentType.name, ".").concat(fieldDef.name, "\" argument \"").concat(argDef.name, "\" is deprecated. ").concat(deprecationReason), node));
	        }
	      }
	    },
	    ObjectField: function ObjectField(node) {
	      var inputObjectDef = getNamedType(context.getParentInputType());

	      if (isInputObjectType(inputObjectDef)) {
	        var inputFieldDef = inputObjectDef.getFields()[node.name.value]; // flowlint-next-line unnecessary-optional-chain:off

	        var deprecationReason = inputFieldDef === null || inputFieldDef === void 0 ? void 0 : inputFieldDef.deprecationReason;

	        if (deprecationReason != null) {
	          context.reportError(new GraphQLError("The input field ".concat(inputObjectDef.name, ".").concat(inputFieldDef.name, " is deprecated. ").concat(deprecationReason), node));
	        }
	      }
	    },
	    EnumValue: function EnumValue(node) {
	      var enumValueDef = context.getEnumValue();
	      var deprecationReason = enumValueDef === null || enumValueDef === void 0 ? void 0 : enumValueDef.deprecationReason;

	      if (enumValueDef && deprecationReason != null) {
	        var enumTypeDef = getNamedType(context.getInputType());
	        enumTypeDef != null || invariant(0);
	        context.reportError(new GraphQLError("The enum value \"".concat(enumTypeDef.name, ".").concat(enumValueDef.name, "\" is deprecated. ").concat(deprecationReason), node));
	      }
	    }
	  };
	}

	/**
	 * Prohibit introspection queries
	 *
	 * A GraphQL document is only valid if all fields selected are not fields that
	 * return an introspection type.
	 *
	 * Note: This rule is optional and is not part of the Validation section of the
	 * GraphQL Specification. This rule effectively disables introspection, which
	 * does not reflect best practices and should only be done if absolutely necessary.
	 */
	function NoSchemaIntrospectionCustomRule(context) {
	  return {
	    Field: function Field(node) {
	      var type = getNamedType(context.getType());

	      if (type && isIntrospectionType(type)) {
	        context.reportError(new GraphQLError("GraphQL introspection has been disabled, but the requested query contained the field \"".concat(node.name.value, "\"."), node));
	      }
	    }
	  };
	}

	/**
	 * Given a GraphQLError, format it according to the rules described by the
	 * Response Format, Errors section of the GraphQL Specification.
	 */
	function formatError$1(error) {
	  var _error$message;

	  error || devAssert(0, 'Received null or undefined error.');
	  var message = (_error$message = error.message) !== null && _error$message !== void 0 ? _error$message : 'An unknown error occurred.';
	  var locations = error.locations;
	  var path = error.path;
	  var extensions = error.extensions;
	  return extensions ? {
	    message: message,
	    locations: locations,
	    path: path,
	    extensions: extensions
	  } : {
	    message: message,
	    locations: locations,
	    path: path
	  };
	}
	/**
	 * @see https://github.com/graphql/graphql-spec/blob/master/spec/Section%207%20--%20Response.md#errors
	 */

	function ownKeys$4(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); keys.push.apply(keys, symbols); } return keys; }

	function _objectSpread$4(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys$4(Object(source), true).forEach(function (key) { _defineProperty$4(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys$4(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

	function _defineProperty$4(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

	function getIntrospectionQuery(options) {
	  var optionsWithDefault = _objectSpread$4({
	    descriptions: true,
	    specifiedByUrl: false,
	    directiveIsRepeatable: false,
	    schemaDescription: false,
	    inputValueDeprecation: false
	  }, options);

	  var descriptions = optionsWithDefault.descriptions ? 'description' : '';
	  var specifiedByUrl = optionsWithDefault.specifiedByUrl ? 'specifiedByUrl' : '';
	  var directiveIsRepeatable = optionsWithDefault.directiveIsRepeatable ? 'isRepeatable' : '';
	  var schemaDescription = optionsWithDefault.schemaDescription ? descriptions : '';

	  function inputDeprecation(str) {
	    return optionsWithDefault.inputValueDeprecation ? str : '';
	  }

	  return "\n    query IntrospectionQuery {\n      __schema {\n        ".concat(schemaDescription, "\n        queryType { name }\n        mutationType { name }\n        subscriptionType { name }\n        types {\n          ...FullType\n        }\n        directives {\n          name\n          ").concat(descriptions, "\n          ").concat(directiveIsRepeatable, "\n          locations\n          args").concat(inputDeprecation('(includeDeprecated: true)'), " {\n            ...InputValue\n          }\n        }\n      }\n    }\n\n    fragment FullType on __Type {\n      kind\n      name\n      ").concat(descriptions, "\n      ").concat(specifiedByUrl, "\n      fields(includeDeprecated: true) {\n        name\n        ").concat(descriptions, "\n        args").concat(inputDeprecation('(includeDeprecated: true)'), " {\n          ...InputValue\n        }\n        type {\n          ...TypeRef\n        }\n        isDeprecated\n        deprecationReason\n      }\n      inputFields").concat(inputDeprecation('(includeDeprecated: true)'), " {\n        ...InputValue\n      }\n      interfaces {\n        ...TypeRef\n      }\n      enumValues(includeDeprecated: true) {\n        name\n        ").concat(descriptions, "\n        isDeprecated\n        deprecationReason\n      }\n      possibleTypes {\n        ...TypeRef\n      }\n    }\n\n    fragment InputValue on __InputValue {\n      name\n      ").concat(descriptions, "\n      type { ...TypeRef }\n      defaultValue\n      ").concat(inputDeprecation('isDeprecated'), "\n      ").concat(inputDeprecation('deprecationReason'), "\n    }\n\n    fragment TypeRef on __Type {\n      kind\n      name\n      ofType {\n        kind\n        name\n        ofType {\n          kind\n          name\n          ofType {\n            kind\n            name\n            ofType {\n              kind\n              name\n              ofType {\n                kind\n                name\n                ofType {\n                  kind\n                  name\n                  ofType {\n                    kind\n                    name\n                  }\n                }\n              }\n            }\n          }\n        }\n      }\n    }\n  ");
	}

	/**
	 * Returns an operation AST given a document AST and optionally an operation
	 * name. If a name is not provided, an operation is only returned if only one is
	 * provided in the document.
	 */

	function getOperationAST(documentAST, operationName) {
	  var operation = null;

	  for (var _i2 = 0, _documentAST$definiti2 = documentAST.definitions; _i2 < _documentAST$definiti2.length; _i2++) {
	    var definition = _documentAST$definiti2[_i2];

	    if (definition.kind === Kind.OPERATION_DEFINITION) {
	      var _definition$name;

	      if (operationName == null) {
	        // If no operation name was provided, only return an Operation if there
	        // is one defined in the document. Upon encountering the second, return
	        // null.
	        if (operation) {
	          return null;
	        }

	        operation = definition;
	      } else if (((_definition$name = definition.name) === null || _definition$name === void 0 ? void 0 : _definition$name.value) === operationName) {
	        return definition;
	      }
	    }
	  }

	  return operation;
	}

	function ownKeys$3(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); keys.push.apply(keys, symbols); } return keys; }

	function _objectSpread$3(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys$3(Object(source), true).forEach(function (key) { _defineProperty$3(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys$3(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

	function _defineProperty$3(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }
	/**
	 * Build an IntrospectionQuery from a GraphQLSchema
	 *
	 * IntrospectionQuery is useful for utilities that care about type and field
	 * relationships, but do not need to traverse through those relationships.
	 *
	 * This is the inverse of buildClientSchema. The primary use case is outside
	 * of the server context, for instance when doing schema comparisons.
	 */

	function introspectionFromSchema(schema, options) {
	  var optionsWithDefaults = _objectSpread$3({
	    specifiedByUrl: true,
	    directiveIsRepeatable: true,
	    schemaDescription: true,
	    inputValueDeprecation: true
	  }, options);

	  var document = parse(getIntrospectionQuery(optionsWithDefaults));
	  var result = executeSync({
	    schema: schema,
	    document: document
	  });
	  !result.errors && result.data || invariant(0);
	  return result.data;
	}

	/**
	 * Build a GraphQLSchema for use by client tools.
	 *
	 * Given the result of a client running the introspection query, creates and
	 * returns a GraphQLSchema instance which can be then used with all graphql-js
	 * tools, but cannot be used to execute a query, as introspection does not
	 * represent the "resolver", "parse" or "serialize" functions or any other
	 * server-internal mechanisms.
	 *
	 * This function expects a complete introspection result. Don't forget to check
	 * the "errors" field of a server response before calling this function.
	 */

	function buildClientSchema(introspection, options) {
	  isObjectLike(introspection) && isObjectLike(introspection.__schema) || devAssert(0, "Invalid or incomplete introspection result. Ensure that you are passing \"data\" property of introspection response and no \"errors\" was returned alongside: ".concat(inspect$2(introspection), ".")); // Get the schema from the introspection result.

	  var schemaIntrospection = introspection.__schema; // Iterate through all types, getting the type definition for each.

	  var typeMap = keyValMap(schemaIntrospection.types, function (typeIntrospection) {
	    return typeIntrospection.name;
	  }, function (typeIntrospection) {
	    return buildType(typeIntrospection);
	  }); // Include standard types only if they are used.

	  for (var _i2 = 0, _ref2 = [].concat(specifiedScalarTypes, introspectionTypes); _i2 < _ref2.length; _i2++) {
	    var stdType = _ref2[_i2];

	    if (typeMap[stdType.name]) {
	      typeMap[stdType.name] = stdType;
	    }
	  } // Get the root Query, Mutation, and Subscription types.


	  var queryType = schemaIntrospection.queryType ? getObjectType(schemaIntrospection.queryType) : null;
	  var mutationType = schemaIntrospection.mutationType ? getObjectType(schemaIntrospection.mutationType) : null;
	  var subscriptionType = schemaIntrospection.subscriptionType ? getObjectType(schemaIntrospection.subscriptionType) : null; // Get the directives supported by Introspection, assuming empty-set if
	  // directives were not queried for.

	  var directives = schemaIntrospection.directives ? schemaIntrospection.directives.map(buildDirective) : []; // Then produce and return a Schema with these types.

	  return new GraphQLSchema({
	    description: schemaIntrospection.description,
	    query: queryType,
	    mutation: mutationType,
	    subscription: subscriptionType,
	    types: objectValues$1(typeMap),
	    directives: directives,
	    assumeValid: options === null || options === void 0 ? void 0 : options.assumeValid
	  }); // Given a type reference in introspection, return the GraphQLType instance.
	  // preferring cached instances before building new instances.

	  function getType(typeRef) {
	    if (typeRef.kind === TypeKind.LIST) {
	      var itemRef = typeRef.ofType;

	      if (!itemRef) {
	        throw new Error('Decorated type deeper than introspection query.');
	      }

	      return new GraphQLList(getType(itemRef));
	    }

	    if (typeRef.kind === TypeKind.NON_NULL) {
	      var nullableRef = typeRef.ofType;

	      if (!nullableRef) {
	        throw new Error('Decorated type deeper than introspection query.');
	      }

	      var nullableType = getType(nullableRef);
	      return new GraphQLNonNull(assertNullableType(nullableType));
	    }

	    return getNamedType(typeRef);
	  }

	  function getNamedType(typeRef) {
	    var typeName = typeRef.name;

	    if (!typeName) {
	      throw new Error("Unknown type reference: ".concat(inspect$2(typeRef), "."));
	    }

	    var type = typeMap[typeName];

	    if (!type) {
	      throw new Error("Invalid or incomplete schema, unknown type: ".concat(typeName, ". Ensure that a full introspection query is used in order to build a client schema."));
	    }

	    return type;
	  }

	  function getObjectType(typeRef) {
	    return assertObjectType(getNamedType(typeRef));
	  }

	  function getInterfaceType(typeRef) {
	    return assertInterfaceType(getNamedType(typeRef));
	  } // Given a type's introspection result, construct the correct
	  // GraphQLType instance.


	  function buildType(type) {
	    if (type != null && type.name != null && type.kind != null) {
	      switch (type.kind) {
	        case TypeKind.SCALAR:
	          return buildScalarDef(type);

	        case TypeKind.OBJECT:
	          return buildObjectDef(type);

	        case TypeKind.INTERFACE:
	          return buildInterfaceDef(type);

	        case TypeKind.UNION:
	          return buildUnionDef(type);

	        case TypeKind.ENUM:
	          return buildEnumDef(type);

	        case TypeKind.INPUT_OBJECT:
	          return buildInputObjectDef(type);
	      }
	    }

	    var typeStr = inspect$2(type);
	    throw new Error("Invalid or incomplete introspection result. Ensure that a full introspection query is used in order to build a client schema: ".concat(typeStr, "."));
	  }

	  function buildScalarDef(scalarIntrospection) {
	    return new GraphQLScalarType({
	      name: scalarIntrospection.name,
	      description: scalarIntrospection.description,
	      specifiedByUrl: scalarIntrospection.specifiedByUrl
	    });
	  }

	  function buildImplementationsList(implementingIntrospection) {
	    // TODO: Temporary workaround until GraphQL ecosystem will fully support
	    // 'interfaces' on interface types.
	    if (implementingIntrospection.interfaces === null && implementingIntrospection.kind === TypeKind.INTERFACE) {
	      return [];
	    }

	    if (!implementingIntrospection.interfaces) {
	      var implementingIntrospectionStr = inspect$2(implementingIntrospection);
	      throw new Error("Introspection result missing interfaces: ".concat(implementingIntrospectionStr, "."));
	    }

	    return implementingIntrospection.interfaces.map(getInterfaceType);
	  }

	  function buildObjectDef(objectIntrospection) {
	    return new GraphQLObjectType({
	      name: objectIntrospection.name,
	      description: objectIntrospection.description,
	      interfaces: function interfaces() {
	        return buildImplementationsList(objectIntrospection);
	      },
	      fields: function fields() {
	        return buildFieldDefMap(objectIntrospection);
	      }
	    });
	  }

	  function buildInterfaceDef(interfaceIntrospection) {
	    return new GraphQLInterfaceType({
	      name: interfaceIntrospection.name,
	      description: interfaceIntrospection.description,
	      interfaces: function interfaces() {
	        return buildImplementationsList(interfaceIntrospection);
	      },
	      fields: function fields() {
	        return buildFieldDefMap(interfaceIntrospection);
	      }
	    });
	  }

	  function buildUnionDef(unionIntrospection) {
	    if (!unionIntrospection.possibleTypes) {
	      var unionIntrospectionStr = inspect$2(unionIntrospection);
	      throw new Error("Introspection result missing possibleTypes: ".concat(unionIntrospectionStr, "."));
	    }

	    return new GraphQLUnionType({
	      name: unionIntrospection.name,
	      description: unionIntrospection.description,
	      types: function types() {
	        return unionIntrospection.possibleTypes.map(getObjectType);
	      }
	    });
	  }

	  function buildEnumDef(enumIntrospection) {
	    if (!enumIntrospection.enumValues) {
	      var enumIntrospectionStr = inspect$2(enumIntrospection);
	      throw new Error("Introspection result missing enumValues: ".concat(enumIntrospectionStr, "."));
	    }

	    return new GraphQLEnumType({
	      name: enumIntrospection.name,
	      description: enumIntrospection.description,
	      values: keyValMap(enumIntrospection.enumValues, function (valueIntrospection) {
	        return valueIntrospection.name;
	      }, function (valueIntrospection) {
	        return {
	          description: valueIntrospection.description,
	          deprecationReason: valueIntrospection.deprecationReason
	        };
	      })
	    });
	  }

	  function buildInputObjectDef(inputObjectIntrospection) {
	    if (!inputObjectIntrospection.inputFields) {
	      var inputObjectIntrospectionStr = inspect$2(inputObjectIntrospection);
	      throw new Error("Introspection result missing inputFields: ".concat(inputObjectIntrospectionStr, "."));
	    }

	    return new GraphQLInputObjectType({
	      name: inputObjectIntrospection.name,
	      description: inputObjectIntrospection.description,
	      fields: function fields() {
	        return buildInputValueDefMap(inputObjectIntrospection.inputFields);
	      }
	    });
	  }

	  function buildFieldDefMap(typeIntrospection) {
	    if (!typeIntrospection.fields) {
	      throw new Error("Introspection result missing fields: ".concat(inspect$2(typeIntrospection), "."));
	    }

	    return keyValMap(typeIntrospection.fields, function (fieldIntrospection) {
	      return fieldIntrospection.name;
	    }, buildField);
	  }

	  function buildField(fieldIntrospection) {
	    var type = getType(fieldIntrospection.type);

	    if (!isOutputType(type)) {
	      var typeStr = inspect$2(type);
	      throw new Error("Introspection must provide output type for fields, but received: ".concat(typeStr, "."));
	    }

	    if (!fieldIntrospection.args) {
	      var fieldIntrospectionStr = inspect$2(fieldIntrospection);
	      throw new Error("Introspection result missing field args: ".concat(fieldIntrospectionStr, "."));
	    }

	    return {
	      description: fieldIntrospection.description,
	      deprecationReason: fieldIntrospection.deprecationReason,
	      type: type,
	      args: buildInputValueDefMap(fieldIntrospection.args)
	    };
	  }

	  function buildInputValueDefMap(inputValueIntrospections) {
	    return keyValMap(inputValueIntrospections, function (inputValue) {
	      return inputValue.name;
	    }, buildInputValue);
	  }

	  function buildInputValue(inputValueIntrospection) {
	    var type = getType(inputValueIntrospection.type);

	    if (!isInputType(type)) {
	      var typeStr = inspect$2(type);
	      throw new Error("Introspection must provide input type for arguments, but received: ".concat(typeStr, "."));
	    }

	    var defaultValue = inputValueIntrospection.defaultValue != null ? valueFromAST$1(parseValue(inputValueIntrospection.defaultValue), type) : undefined;
	    return {
	      description: inputValueIntrospection.description,
	      type: type,
	      defaultValue: defaultValue,
	      deprecationReason: inputValueIntrospection.deprecationReason
	    };
	  }

	  function buildDirective(directiveIntrospection) {
	    if (!directiveIntrospection.args) {
	      var directiveIntrospectionStr = inspect$2(directiveIntrospection);
	      throw new Error("Introspection result missing directive args: ".concat(directiveIntrospectionStr, "."));
	    }

	    if (!directiveIntrospection.locations) {
	      var _directiveIntrospectionStr = inspect$2(directiveIntrospection);

	      throw new Error("Introspection result missing directive locations: ".concat(_directiveIntrospectionStr, "."));
	    }

	    return new GraphQLDirective({
	      name: directiveIntrospection.name,
	      description: directiveIntrospection.description,
	      isRepeatable: directiveIntrospection.isRepeatable,
	      locations: directiveIntrospection.locations.slice(),
	      args: buildInputValueDefMap(directiveIntrospection.args)
	    });
	  }
	}

	function ownKeys$2(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); keys.push.apply(keys, symbols); } return keys; }

	function _objectSpread$2(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys$2(Object(source), true).forEach(function (key) { _defineProperty$2(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys$2(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

	function _defineProperty$2(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

	/**
	 * Produces a new schema given an existing schema and a document which may
	 * contain GraphQL type extensions and definitions. The original schema will
	 * remain unaltered.
	 *
	 * Because a schema represents a graph of references, a schema cannot be
	 * extended without effectively making an entire copy. We do not know until it's
	 * too late if subgraphs remain unchanged.
	 *
	 * This algorithm copies the provided schema, applying extensions while
	 * producing the copy. The original schema remains unaltered.
	 *
	 * Accepts options as a third argument:
	 *
	 *    - commentDescriptions:
	 *        Provide true to use preceding comments as the description.
	 *
	 */
	function extendSchema(schema, documentAST, options) {
	  assertSchema(schema);
	  documentAST != null && documentAST.kind === Kind.DOCUMENT || devAssert(0, 'Must provide valid Document AST.');

	  if ((options === null || options === void 0 ? void 0 : options.assumeValid) !== true && (options === null || options === void 0 ? void 0 : options.assumeValidSDL) !== true) {
	    assertValidSDLExtension(documentAST, schema);
	  }

	  var schemaConfig = schema.toConfig();
	  var extendedConfig = extendSchemaImpl(schemaConfig, documentAST, options);
	  return schemaConfig === extendedConfig ? schema : new GraphQLSchema(extendedConfig);
	}
	/**
	 * @internal
	 */

	function extendSchemaImpl(schemaConfig, documentAST, options) {
	  var _schemaDef, _schemaDef$descriptio, _schemaDef2, _options$assumeValid;

	  // Collect the type definitions and extensions found in the document.
	  var typeDefs = [];
	  var typeExtensionsMap = Object.create(null); // New directives and types are separate because a directives and types can
	  // have the same name. For example, a type named "skip".

	  var directiveDefs = [];
	  var schemaDef; // Schema extensions are collected which may add additional operation types.

	  var schemaExtensions = [];

	  for (var _i2 = 0, _documentAST$definiti2 = documentAST.definitions; _i2 < _documentAST$definiti2.length; _i2++) {
	    var def = _documentAST$definiti2[_i2];

	    if (def.kind === Kind.SCHEMA_DEFINITION) {
	      schemaDef = def;
	    } else if (def.kind === Kind.SCHEMA_EXTENSION) {
	      schemaExtensions.push(def);
	    } else if (isTypeDefinitionNode(def)) {
	      typeDefs.push(def);
	    } else if (isTypeExtensionNode(def)) {
	      var extendedTypeName = def.name.value;
	      var existingTypeExtensions = typeExtensionsMap[extendedTypeName];
	      typeExtensionsMap[extendedTypeName] = existingTypeExtensions ? existingTypeExtensions.concat([def]) : [def];
	    } else if (def.kind === Kind.DIRECTIVE_DEFINITION) {
	      directiveDefs.push(def);
	    }
	  } // If this document contains no new types, extensions, or directives then
	  // return the same unmodified GraphQLSchema instance.


	  if (Object.keys(typeExtensionsMap).length === 0 && typeDefs.length === 0 && directiveDefs.length === 0 && schemaExtensions.length === 0 && schemaDef == null) {
	    return schemaConfig;
	  }

	  var typeMap = Object.create(null);

	  for (var _i4 = 0, _schemaConfig$types2 = schemaConfig.types; _i4 < _schemaConfig$types2.length; _i4++) {
	    var existingType = _schemaConfig$types2[_i4];
	    typeMap[existingType.name] = extendNamedType(existingType);
	  }

	  for (var _i6 = 0; _i6 < typeDefs.length; _i6++) {
	    var _stdTypeMap$name;

	    var typeNode = typeDefs[_i6];
	    var name = typeNode.name.value;
	    typeMap[name] = (_stdTypeMap$name = stdTypeMap[name]) !== null && _stdTypeMap$name !== void 0 ? _stdTypeMap$name : buildType(typeNode);
	  }

	  var operationTypes = _objectSpread$2(_objectSpread$2({
	    // Get the extended root operation types.
	    query: schemaConfig.query && replaceNamedType(schemaConfig.query),
	    mutation: schemaConfig.mutation && replaceNamedType(schemaConfig.mutation),
	    subscription: schemaConfig.subscription && replaceNamedType(schemaConfig.subscription)
	  }, schemaDef && getOperationTypes([schemaDef])), getOperationTypes(schemaExtensions)); // Then produce and return a Schema config with these types.


	  return _objectSpread$2(_objectSpread$2({
	    description: (_schemaDef = schemaDef) === null || _schemaDef === void 0 ? void 0 : (_schemaDef$descriptio = _schemaDef.description) === null || _schemaDef$descriptio === void 0 ? void 0 : _schemaDef$descriptio.value
	  }, operationTypes), {}, {
	    types: objectValues$1(typeMap),
	    directives: [].concat(schemaConfig.directives.map(replaceDirective), directiveDefs.map(buildDirective)),
	    extensions: undefined,
	    astNode: (_schemaDef2 = schemaDef) !== null && _schemaDef2 !== void 0 ? _schemaDef2 : schemaConfig.astNode,
	    extensionASTNodes: schemaConfig.extensionASTNodes.concat(schemaExtensions),
	    assumeValid: (_options$assumeValid = options === null || options === void 0 ? void 0 : options.assumeValid) !== null && _options$assumeValid !== void 0 ? _options$assumeValid : false
	  }); // Below are functions used for producing this schema that have closed over
	  // this scope and have access to the schema, cache, and newly defined types.

	  function replaceType(type) {
	    if (isListType(type)) {
	      // $FlowFixMe[incompatible-return]
	      return new GraphQLList(replaceType(type.ofType));
	    }

	    if (isNonNullType(type)) {
	      // $FlowFixMe[incompatible-return]
	      return new GraphQLNonNull(replaceType(type.ofType));
	    }

	    return replaceNamedType(type);
	  }

	  function replaceNamedType(type) {
	    // Note: While this could make early assertions to get the correctly
	    // typed values, that would throw immediately while type system
	    // validation with validateSchema() will produce more actionable results.
	    return typeMap[type.name];
	  }

	  function replaceDirective(directive) {
	    var config = directive.toConfig();
	    return new GraphQLDirective(_objectSpread$2(_objectSpread$2({}, config), {}, {
	      args: mapValue(config.args, extendArg)
	    }));
	  }

	  function extendNamedType(type) {
	    if (isIntrospectionType(type) || isSpecifiedScalarType(type)) {
	      // Builtin types are not extended.
	      return type;
	    }

	    if (isScalarType(type)) {
	      return extendScalarType(type);
	    }

	    if (isObjectType(type)) {
	      return extendObjectType(type);
	    }

	    if (isInterfaceType(type)) {
	      return extendInterfaceType(type);
	    }

	    if (isUnionType(type)) {
	      return extendUnionType(type);
	    }

	    if (isEnumType(type)) {
	      return extendEnumType(type);
	    } // istanbul ignore else (See: 'https://github.com/graphql/graphql-js/issues/2618')


	    if (isInputObjectType(type)) {
	      return extendInputObjectType(type);
	    } // istanbul ignore next (Not reachable. All possible types have been considered)


	    invariant(0, 'Unexpected type: ' + inspect$2(type));
	  }

	  function extendInputObjectType(type) {
	    var _typeExtensionsMap$co;

	    var config = type.toConfig();
	    var extensions = (_typeExtensionsMap$co = typeExtensionsMap[config.name]) !== null && _typeExtensionsMap$co !== void 0 ? _typeExtensionsMap$co : [];
	    return new GraphQLInputObjectType(_objectSpread$2(_objectSpread$2({}, config), {}, {
	      fields: function fields() {
	        return _objectSpread$2(_objectSpread$2({}, mapValue(config.fields, function (field) {
	          return _objectSpread$2(_objectSpread$2({}, field), {}, {
	            type: replaceType(field.type)
	          });
	        })), buildInputFieldMap(extensions));
	      },
	      extensionASTNodes: config.extensionASTNodes.concat(extensions)
	    }));
	  }

	  function extendEnumType(type) {
	    var _typeExtensionsMap$ty;

	    var config = type.toConfig();
	    var extensions = (_typeExtensionsMap$ty = typeExtensionsMap[type.name]) !== null && _typeExtensionsMap$ty !== void 0 ? _typeExtensionsMap$ty : [];
	    return new GraphQLEnumType(_objectSpread$2(_objectSpread$2({}, config), {}, {
	      values: _objectSpread$2(_objectSpread$2({}, config.values), buildEnumValueMap(extensions)),
	      extensionASTNodes: config.extensionASTNodes.concat(extensions)
	    }));
	  }

	  function extendScalarType(type) {
	    var _typeExtensionsMap$co2;

	    var config = type.toConfig();
	    var extensions = (_typeExtensionsMap$co2 = typeExtensionsMap[config.name]) !== null && _typeExtensionsMap$co2 !== void 0 ? _typeExtensionsMap$co2 : [];
	    var specifiedByUrl = config.specifiedByUrl;

	    for (var _i8 = 0; _i8 < extensions.length; _i8++) {
	      var _getSpecifiedByUrl;

	      var extensionNode = extensions[_i8];
	      specifiedByUrl = (_getSpecifiedByUrl = getSpecifiedByUrl(extensionNode)) !== null && _getSpecifiedByUrl !== void 0 ? _getSpecifiedByUrl : specifiedByUrl;
	    }

	    return new GraphQLScalarType(_objectSpread$2(_objectSpread$2({}, config), {}, {
	      specifiedByUrl: specifiedByUrl,
	      extensionASTNodes: config.extensionASTNodes.concat(extensions)
	    }));
	  }

	  function extendObjectType(type) {
	    var _typeExtensionsMap$co3;

	    var config = type.toConfig();
	    var extensions = (_typeExtensionsMap$co3 = typeExtensionsMap[config.name]) !== null && _typeExtensionsMap$co3 !== void 0 ? _typeExtensionsMap$co3 : [];
	    return new GraphQLObjectType(_objectSpread$2(_objectSpread$2({}, config), {}, {
	      interfaces: function interfaces() {
	        return [].concat(type.getInterfaces().map(replaceNamedType), buildInterfaces(extensions));
	      },
	      fields: function fields() {
	        return _objectSpread$2(_objectSpread$2({}, mapValue(config.fields, extendField)), buildFieldMap(extensions));
	      },
	      extensionASTNodes: config.extensionASTNodes.concat(extensions)
	    }));
	  }

	  function extendInterfaceType(type) {
	    var _typeExtensionsMap$co4;

	    var config = type.toConfig();
	    var extensions = (_typeExtensionsMap$co4 = typeExtensionsMap[config.name]) !== null && _typeExtensionsMap$co4 !== void 0 ? _typeExtensionsMap$co4 : [];
	    return new GraphQLInterfaceType(_objectSpread$2(_objectSpread$2({}, config), {}, {
	      interfaces: function interfaces() {
	        return [].concat(type.getInterfaces().map(replaceNamedType), buildInterfaces(extensions));
	      },
	      fields: function fields() {
	        return _objectSpread$2(_objectSpread$2({}, mapValue(config.fields, extendField)), buildFieldMap(extensions));
	      },
	      extensionASTNodes: config.extensionASTNodes.concat(extensions)
	    }));
	  }

	  function extendUnionType(type) {
	    var _typeExtensionsMap$co5;

	    var config = type.toConfig();
	    var extensions = (_typeExtensionsMap$co5 = typeExtensionsMap[config.name]) !== null && _typeExtensionsMap$co5 !== void 0 ? _typeExtensionsMap$co5 : [];
	    return new GraphQLUnionType(_objectSpread$2(_objectSpread$2({}, config), {}, {
	      types: function types() {
	        return [].concat(type.getTypes().map(replaceNamedType), buildUnionTypes(extensions));
	      },
	      extensionASTNodes: config.extensionASTNodes.concat(extensions)
	    }));
	  }

	  function extendField(field) {
	    return _objectSpread$2(_objectSpread$2({}, field), {}, {
	      type: replaceType(field.type),
	      // $FlowFixMe[incompatible-call]
	      args: mapValue(field.args, extendArg)
	    });
	  }

	  function extendArg(arg) {
	    return _objectSpread$2(_objectSpread$2({}, arg), {}, {
	      type: replaceType(arg.type)
	    });
	  }

	  function getOperationTypes(nodes) {
	    var opTypes = {};

	    for (var _i10 = 0; _i10 < nodes.length; _i10++) {
	      var _node$operationTypes;

	      var node = nodes[_i10];
	      // istanbul ignore next (See: 'https://github.com/graphql/graphql-js/issues/2203')
	      var operationTypesNodes = (_node$operationTypes = node.operationTypes) !== null && _node$operationTypes !== void 0 ? _node$operationTypes : [];

	      for (var _i12 = 0; _i12 < operationTypesNodes.length; _i12++) {
	        var operationType = operationTypesNodes[_i12];
	        opTypes[operationType.operation] = getNamedType(operationType.type);
	      }
	    } // Note: While this could make early assertions to get the correctly
	    // typed values below, that would throw immediately while type system
	    // validation with validateSchema() will produce more actionable results.


	    return opTypes;
	  }

	  function getNamedType(node) {
	    var _stdTypeMap$name2;

	    var name = node.name.value;
	    var type = (_stdTypeMap$name2 = stdTypeMap[name]) !== null && _stdTypeMap$name2 !== void 0 ? _stdTypeMap$name2 : typeMap[name];

	    if (type === undefined) {
	      throw new Error("Unknown type: \"".concat(name, "\"."));
	    }

	    return type;
	  }

	  function getWrappedType(node) {
	    if (node.kind === Kind.LIST_TYPE) {
	      return new GraphQLList(getWrappedType(node.type));
	    }

	    if (node.kind === Kind.NON_NULL_TYPE) {
	      return new GraphQLNonNull(getWrappedType(node.type));
	    }

	    return getNamedType(node);
	  }

	  function buildDirective(node) {
	    var locations = node.locations.map(function (_ref) {
	      var value = _ref.value;
	      return value;
	    });
	    return new GraphQLDirective({
	      name: node.name.value,
	      description: getDescription(node, options),
	      locations: locations,
	      isRepeatable: node.repeatable,
	      args: buildArgumentMap(node.arguments),
	      astNode: node
	    });
	  }

	  function buildFieldMap(nodes) {
	    var fieldConfigMap = Object.create(null);

	    for (var _i14 = 0; _i14 < nodes.length; _i14++) {
	      var _node$fields;

	      var node = nodes[_i14];
	      // istanbul ignore next (See: 'https://github.com/graphql/graphql-js/issues/2203')
	      var nodeFields = (_node$fields = node.fields) !== null && _node$fields !== void 0 ? _node$fields : [];

	      for (var _i16 = 0; _i16 < nodeFields.length; _i16++) {
	        var field = nodeFields[_i16];
	        fieldConfigMap[field.name.value] = {
	          // Note: While this could make assertions to get the correctly typed
	          // value, that would throw immediately while type system validation
	          // with validateSchema() will produce more actionable results.
	          type: getWrappedType(field.type),
	          description: getDescription(field, options),
	          args: buildArgumentMap(field.arguments),
	          deprecationReason: getDeprecationReason(field),
	          astNode: field
	        };
	      }
	    }

	    return fieldConfigMap;
	  }

	  function buildArgumentMap(args) {
	    // istanbul ignore next (See: 'https://github.com/graphql/graphql-js/issues/2203')
	    var argsNodes = args !== null && args !== void 0 ? args : [];
	    var argConfigMap = Object.create(null);

	    for (var _i18 = 0; _i18 < argsNodes.length; _i18++) {
	      var arg = argsNodes[_i18];
	      // Note: While this could make assertions to get the correctly typed
	      // value, that would throw immediately while type system validation
	      // with validateSchema() will produce more actionable results.
	      var type = getWrappedType(arg.type);
	      argConfigMap[arg.name.value] = {
	        type: type,
	        description: getDescription(arg, options),
	        defaultValue: valueFromAST$1(arg.defaultValue, type),
	        deprecationReason: getDeprecationReason(arg),
	        astNode: arg
	      };
	    }

	    return argConfigMap;
	  }

	  function buildInputFieldMap(nodes) {
	    var inputFieldMap = Object.create(null);

	    for (var _i20 = 0; _i20 < nodes.length; _i20++) {
	      var _node$fields2;

	      var node = nodes[_i20];
	      // istanbul ignore next (See: 'https://github.com/graphql/graphql-js/issues/2203')
	      var fieldsNodes = (_node$fields2 = node.fields) !== null && _node$fields2 !== void 0 ? _node$fields2 : [];

	      for (var _i22 = 0; _i22 < fieldsNodes.length; _i22++) {
	        var field = fieldsNodes[_i22];
	        // Note: While this could make assertions to get the correctly typed
	        // value, that would throw immediately while type system validation
	        // with validateSchema() will produce more actionable results.
	        var type = getWrappedType(field.type);
	        inputFieldMap[field.name.value] = {
	          type: type,
	          description: getDescription(field, options),
	          defaultValue: valueFromAST$1(field.defaultValue, type),
	          deprecationReason: getDeprecationReason(field),
	          astNode: field
	        };
	      }
	    }

	    return inputFieldMap;
	  }

	  function buildEnumValueMap(nodes) {
	    var enumValueMap = Object.create(null);

	    for (var _i24 = 0; _i24 < nodes.length; _i24++) {
	      var _node$values;

	      var node = nodes[_i24];
	      // istanbul ignore next (See: 'https://github.com/graphql/graphql-js/issues/2203')
	      var valuesNodes = (_node$values = node.values) !== null && _node$values !== void 0 ? _node$values : [];

	      for (var _i26 = 0; _i26 < valuesNodes.length; _i26++) {
	        var value = valuesNodes[_i26];
	        enumValueMap[value.name.value] = {
	          description: getDescription(value, options),
	          deprecationReason: getDeprecationReason(value),
	          astNode: value
	        };
	      }
	    }

	    return enumValueMap;
	  }

	  function buildInterfaces(nodes) {
	    var interfaces = [];

	    for (var _i28 = 0; _i28 < nodes.length; _i28++) {
	      var _node$interfaces;

	      var node = nodes[_i28];
	      // istanbul ignore next (See: 'https://github.com/graphql/graphql-js/issues/2203')
	      var interfacesNodes = (_node$interfaces = node.interfaces) !== null && _node$interfaces !== void 0 ? _node$interfaces : [];

	      for (var _i30 = 0; _i30 < interfacesNodes.length; _i30++) {
	        var type = interfacesNodes[_i30];
	        // Note: While this could make assertions to get the correctly typed
	        // values below, that would throw immediately while type system
	        // validation with validateSchema() will produce more actionable
	        // results.
	        interfaces.push(getNamedType(type));
	      }
	    }

	    return interfaces;
	  }

	  function buildUnionTypes(nodes) {
	    var types = [];

	    for (var _i32 = 0; _i32 < nodes.length; _i32++) {
	      var _node$types;

	      var node = nodes[_i32];
	      // istanbul ignore next (See: 'https://github.com/graphql/graphql-js/issues/2203')
	      var typeNodes = (_node$types = node.types) !== null && _node$types !== void 0 ? _node$types : [];

	      for (var _i34 = 0; _i34 < typeNodes.length; _i34++) {
	        var type = typeNodes[_i34];
	        // Note: While this could make assertions to get the correctly typed
	        // values below, that would throw immediately while type system
	        // validation with validateSchema() will produce more actionable
	        // results.
	        types.push(getNamedType(type));
	      }
	    }

	    return types;
	  }

	  function buildType(astNode) {
	    var _typeExtensionsMap$na;

	    var name = astNode.name.value;
	    var description = getDescription(astNode, options);
	    var extensionNodes = (_typeExtensionsMap$na = typeExtensionsMap[name]) !== null && _typeExtensionsMap$na !== void 0 ? _typeExtensionsMap$na : [];

	    switch (astNode.kind) {
	      case Kind.OBJECT_TYPE_DEFINITION:
	        {
	          var extensionASTNodes = extensionNodes;
	          var allNodes = [astNode].concat(extensionASTNodes);
	          return new GraphQLObjectType({
	            name: name,
	            description: description,
	            interfaces: function interfaces() {
	              return buildInterfaces(allNodes);
	            },
	            fields: function fields() {
	              return buildFieldMap(allNodes);
	            },
	            astNode: astNode,
	            extensionASTNodes: extensionASTNodes
	          });
	        }

	      case Kind.INTERFACE_TYPE_DEFINITION:
	        {
	          var _extensionASTNodes = extensionNodes;

	          var _allNodes = [astNode].concat(_extensionASTNodes);

	          return new GraphQLInterfaceType({
	            name: name,
	            description: description,
	            interfaces: function interfaces() {
	              return buildInterfaces(_allNodes);
	            },
	            fields: function fields() {
	              return buildFieldMap(_allNodes);
	            },
	            astNode: astNode,
	            extensionASTNodes: _extensionASTNodes
	          });
	        }

	      case Kind.ENUM_TYPE_DEFINITION:
	        {
	          var _extensionASTNodes2 = extensionNodes;

	          var _allNodes2 = [astNode].concat(_extensionASTNodes2);

	          return new GraphQLEnumType({
	            name: name,
	            description: description,
	            values: buildEnumValueMap(_allNodes2),
	            astNode: astNode,
	            extensionASTNodes: _extensionASTNodes2
	          });
	        }

	      case Kind.UNION_TYPE_DEFINITION:
	        {
	          var _extensionASTNodes3 = extensionNodes;

	          var _allNodes3 = [astNode].concat(_extensionASTNodes3);

	          return new GraphQLUnionType({
	            name: name,
	            description: description,
	            types: function types() {
	              return buildUnionTypes(_allNodes3);
	            },
	            astNode: astNode,
	            extensionASTNodes: _extensionASTNodes3
	          });
	        }

	      case Kind.SCALAR_TYPE_DEFINITION:
	        {
	          var _extensionASTNodes4 = extensionNodes;
	          return new GraphQLScalarType({
	            name: name,
	            description: description,
	            specifiedByUrl: getSpecifiedByUrl(astNode),
	            astNode: astNode,
	            extensionASTNodes: _extensionASTNodes4
	          });
	        }

	      case Kind.INPUT_OBJECT_TYPE_DEFINITION:
	        {
	          var _extensionASTNodes5 = extensionNodes;

	          var _allNodes4 = [astNode].concat(_extensionASTNodes5);

	          return new GraphQLInputObjectType({
	            name: name,
	            description: description,
	            fields: function fields() {
	              return buildInputFieldMap(_allNodes4);
	            },
	            astNode: astNode,
	            extensionASTNodes: _extensionASTNodes5
	          });
	        }
	    } // istanbul ignore next (Not reachable. All possible type definition nodes have been considered)


	    invariant(0, 'Unexpected type definition node: ' + inspect$2(astNode));
	  }
	}
	var stdTypeMap = keyMap(specifiedScalarTypes.concat(introspectionTypes), function (type) {
	  return type.name;
	});
	/**
	 * Given a field or enum value node, returns the string value for the
	 * deprecation reason.
	 */

	function getDeprecationReason(node) {
	  var deprecated = getDirectiveValues(GraphQLDeprecatedDirective, node);
	  return deprecated === null || deprecated === void 0 ? void 0 : deprecated.reason;
	}
	/**
	 * Given a scalar node, returns the string value for the specifiedByUrl.
	 */


	function getSpecifiedByUrl(node) {
	  var specifiedBy = getDirectiveValues(GraphQLSpecifiedByDirective, node);
	  return specifiedBy === null || specifiedBy === void 0 ? void 0 : specifiedBy.url;
	}
	/**
	 * Given an ast node, returns its string description.
	 * @deprecated: provided to ease adoption and will be removed in v16.
	 *
	 * Accepts options as a second argument:
	 *
	 *    - commentDescriptions:
	 *        Provide true to use preceding comments as the description.
	 *
	 */


	function getDescription(node, options) {
	  if (node.description) {
	    return node.description.value;
	  }

	  if ((options === null || options === void 0 ? void 0 : options.commentDescriptions) === true) {
	    var rawValue = getLeadingCommentBlock(node);

	    if (rawValue !== undefined) {
	      return dedentBlockStringValue('\n' + rawValue);
	    }
	  }
	}

	function getLeadingCommentBlock(node) {
	  var loc = node.loc;

	  if (!loc) {
	    return;
	  }

	  var comments = [];
	  var token = loc.startToken.prev;

	  while (token != null && token.kind === TokenKind.COMMENT && token.next && token.prev && token.line + 1 === token.next.line && token.line !== token.prev.line) {
	    var value = String(token.value);
	    comments.push(value);
	    token = token.prev;
	  }

	  return comments.length > 0 ? comments.reverse().join('\n') : undefined;
	}

	/**
	 * This takes the ast of a schema document produced by the parse function in
	 * src/language/parser.js.
	 *
	 * If no schema definition is provided, then it will look for types named Query
	 * and Mutation.
	 *
	 * Given that AST it constructs a GraphQLSchema. The resulting schema
	 * has no resolve methods, so execution will use default resolvers.
	 *
	 * Accepts options as a second argument:
	 *
	 *    - commentDescriptions:
	 *        Provide true to use preceding comments as the description.
	 *
	 */
	function buildASTSchema(documentAST, options) {
	  documentAST != null && documentAST.kind === Kind.DOCUMENT || devAssert(0, 'Must provide valid Document AST.');

	  if ((options === null || options === void 0 ? void 0 : options.assumeValid) !== true && (options === null || options === void 0 ? void 0 : options.assumeValidSDL) !== true) {
	    assertValidSDL(documentAST);
	  }

	  var emptySchemaConfig = {
	    description: undefined,
	    types: [],
	    directives: [],
	    extensions: undefined,
	    extensionASTNodes: [],
	    assumeValid: false
	  };
	  var config = extendSchemaImpl(emptySchemaConfig, documentAST, options);

	  if (config.astNode == null) {
	    for (var _i2 = 0, _config$types2 = config.types; _i2 < _config$types2.length; _i2++) {
	      var type = _config$types2[_i2];

	      switch (type.name) {
	        // Note: While this could make early assertions to get the correctly
	        // typed values below, that would throw immediately while type system
	        // validation with validateSchema() will produce more actionable results.
	        case 'Query':
	          config.query = type;
	          break;

	        case 'Mutation':
	          config.mutation = type;
	          break;

	        case 'Subscription':
	          config.subscription = type;
	          break;
	      }
	    }
	  }

	  var directives = config.directives; // If specified directives were not explicitly declared, add them.

	  var _loop = function _loop(_i4) {
	    var stdDirective = specifiedDirectives[_i4];

	    if (directives.every(function (directive) {
	      return directive.name !== stdDirective.name;
	    })) {
	      directives.push(stdDirective);
	    }
	  };

	  for (var _i4 = 0; _i4 < specifiedDirectives.length; _i4++) {
	    _loop(_i4);
	  }

	  return new GraphQLSchema(config);
	}
	/**
	 * A helper function to build a GraphQLSchema directly from a source
	 * document.
	 */

	function buildSchema$2(source, options) {
	  var document = parse(source, {
	    noLocation: options === null || options === void 0 ? void 0 : options.noLocation,
	    allowLegacySDLEmptyFields: options === null || options === void 0 ? void 0 : options.allowLegacySDLEmptyFields,
	    allowLegacySDLImplementsInterfaces: options === null || options === void 0 ? void 0 : options.allowLegacySDLImplementsInterfaces,
	    experimentalFragmentVariables: options === null || options === void 0 ? void 0 : options.experimentalFragmentVariables
	  });
	  return buildASTSchema(document, {
	    commentDescriptions: options === null || options === void 0 ? void 0 : options.commentDescriptions,
	    assumeValidSDL: options === null || options === void 0 ? void 0 : options.assumeValidSDL,
	    assumeValid: options === null || options === void 0 ? void 0 : options.assumeValid
	  });
	}

	function ownKeys$1(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); keys.push.apply(keys, symbols); } return keys; }

	function _objectSpread$1(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys$1(Object(source), true).forEach(function (key) { _defineProperty$1(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys$1(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

	function _defineProperty$1(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }
	/**
	 * Sort GraphQLSchema.
	 *
	 * This function returns a sorted copy of the given GraphQLSchema.
	 */

	function lexicographicSortSchema(schema) {
	  var schemaConfig = schema.toConfig();
	  var typeMap = keyValMap(sortByName(schemaConfig.types), function (type) {
	    return type.name;
	  }, sortNamedType);
	  return new GraphQLSchema(_objectSpread$1(_objectSpread$1({}, schemaConfig), {}, {
	    types: objectValues$1(typeMap),
	    directives: sortByName(schemaConfig.directives).map(sortDirective),
	    query: replaceMaybeType(schemaConfig.query),
	    mutation: replaceMaybeType(schemaConfig.mutation),
	    subscription: replaceMaybeType(schemaConfig.subscription)
	  }));

	  function replaceType(type) {
	    if (isListType(type)) {
	      // $FlowFixMe[incompatible-return]
	      return new GraphQLList(replaceType(type.ofType));
	    } else if (isNonNullType(type)) {
	      // $FlowFixMe[incompatible-return]
	      return new GraphQLNonNull(replaceType(type.ofType));
	    }

	    return replaceNamedType(type);
	  }

	  function replaceNamedType(type) {
	    return typeMap[type.name];
	  }

	  function replaceMaybeType(maybeType) {
	    return maybeType && replaceNamedType(maybeType);
	  }

	  function sortDirective(directive) {
	    var config = directive.toConfig();
	    return new GraphQLDirective(_objectSpread$1(_objectSpread$1({}, config), {}, {
	      locations: sortBy(config.locations, function (x) {
	        return x;
	      }),
	      args: sortArgs(config.args)
	    }));
	  }

	  function sortArgs(args) {
	    return sortObjMap(args, function (arg) {
	      return _objectSpread$1(_objectSpread$1({}, arg), {}, {
	        type: replaceType(arg.type)
	      });
	    });
	  }

	  function sortFields(fieldsMap) {
	    return sortObjMap(fieldsMap, function (field) {
	      return _objectSpread$1(_objectSpread$1({}, field), {}, {
	        type: replaceType(field.type),
	        args: sortArgs(field.args)
	      });
	    });
	  }

	  function sortInputFields(fieldsMap) {
	    return sortObjMap(fieldsMap, function (field) {
	      return _objectSpread$1(_objectSpread$1({}, field), {}, {
	        type: replaceType(field.type)
	      });
	    });
	  }

	  function sortTypes(arr) {
	    return sortByName(arr).map(replaceNamedType);
	  }

	  function sortNamedType(type) {
	    if (isScalarType(type) || isIntrospectionType(type)) {
	      return type;
	    }

	    if (isObjectType(type)) {
	      var config = type.toConfig();
	      return new GraphQLObjectType(_objectSpread$1(_objectSpread$1({}, config), {}, {
	        interfaces: function interfaces() {
	          return sortTypes(config.interfaces);
	        },
	        fields: function fields() {
	          return sortFields(config.fields);
	        }
	      }));
	    }

	    if (isInterfaceType(type)) {
	      var _config = type.toConfig();

	      return new GraphQLInterfaceType(_objectSpread$1(_objectSpread$1({}, _config), {}, {
	        interfaces: function interfaces() {
	          return sortTypes(_config.interfaces);
	        },
	        fields: function fields() {
	          return sortFields(_config.fields);
	        }
	      }));
	    }

	    if (isUnionType(type)) {
	      var _config2 = type.toConfig();

	      return new GraphQLUnionType(_objectSpread$1(_objectSpread$1({}, _config2), {}, {
	        types: function types() {
	          return sortTypes(_config2.types);
	        }
	      }));
	    }

	    if (isEnumType(type)) {
	      var _config3 = type.toConfig();

	      return new GraphQLEnumType(_objectSpread$1(_objectSpread$1({}, _config3), {}, {
	        values: sortObjMap(_config3.values)
	      }));
	    } // istanbul ignore else (See: 'https://github.com/graphql/graphql-js/issues/2618')


	    if (isInputObjectType(type)) {
	      var _config4 = type.toConfig();

	      return new GraphQLInputObjectType(_objectSpread$1(_objectSpread$1({}, _config4), {}, {
	        fields: function fields() {
	          return sortInputFields(_config4.fields);
	        }
	      }));
	    } // istanbul ignore next (Not reachable. All possible types have been considered)


	    invariant(0, 'Unexpected type: ' + inspect$2(type));
	  }
	}

	function sortObjMap(map, sortValueFn) {
	  var sortedMap = Object.create(null);
	  var sortedKeys = sortBy(Object.keys(map), function (x) {
	    return x;
	  });

	  for (var _i2 = 0; _i2 < sortedKeys.length; _i2++) {
	    var key = sortedKeys[_i2];
	    var value = map[key];
	    sortedMap[key] = sortValueFn ? sortValueFn(value) : value;
	  }

	  return sortedMap;
	}

	function sortByName(array) {
	  return sortBy(array, function (obj) {
	    return obj.name;
	  });
	}

	function sortBy(array, mapToKey) {
	  return array.slice().sort(function (obj1, obj2) {
	    var key1 = mapToKey(obj1);
	    var key2 = mapToKey(obj2);
	    return naturalCompare(key1, key2);
	  });
	}

	/**
	 * Accepts options as a second argument:
	 *
	 *    - commentDescriptions:
	 *        Provide true to use preceding comments as the description.
	 *
	 */
	function printSchema(schema, options) {
	  return printFilteredSchema(schema, function (n) {
	    return !isSpecifiedDirective(n);
	  }, isDefinedType, options);
	}
	function printIntrospectionSchema(schema, options) {
	  return printFilteredSchema(schema, isSpecifiedDirective, isIntrospectionType, options);
	}

	function isDefinedType(type) {
	  return !isSpecifiedScalarType(type) && !isIntrospectionType(type);
	}

	function printFilteredSchema(schema, directiveFilter, typeFilter, options) {
	  var directives = schema.getDirectives().filter(directiveFilter);
	  var types = objectValues$1(schema.getTypeMap()).filter(typeFilter);
	  return [printSchemaDefinition(schema)].concat(directives.map(function (directive) {
	    return printDirective(directive, options);
	  }), types.map(function (type) {
	    return printType(type, options);
	  })).filter(Boolean).join('\n\n') + '\n';
	}

	function printSchemaDefinition(schema) {
	  if (schema.description == null && isSchemaOfCommonNames(schema)) {
	    return;
	  }

	  var operationTypes = [];
	  var queryType = schema.getQueryType();

	  if (queryType) {
	    operationTypes.push("  query: ".concat(queryType.name));
	  }

	  var mutationType = schema.getMutationType();

	  if (mutationType) {
	    operationTypes.push("  mutation: ".concat(mutationType.name));
	  }

	  var subscriptionType = schema.getSubscriptionType();

	  if (subscriptionType) {
	    operationTypes.push("  subscription: ".concat(subscriptionType.name));
	  }

	  return printDescription({}, schema) + "schema {\n".concat(operationTypes.join('\n'), "\n}");
	}
	/**
	 * GraphQL schema define root types for each type of operation. These types are
	 * the same as any other type and can be named in any manner, however there is
	 * a common naming convention:
	 *
	 *   schema {
	 *     query: Query
	 *     mutation: Mutation
	 *   }
	 *
	 * When using this naming convention, the schema description can be omitted.
	 */


	function isSchemaOfCommonNames(schema) {
	  var queryType = schema.getQueryType();

	  if (queryType && queryType.name !== 'Query') {
	    return false;
	  }

	  var mutationType = schema.getMutationType();

	  if (mutationType && mutationType.name !== 'Mutation') {
	    return false;
	  }

	  var subscriptionType = schema.getSubscriptionType();

	  if (subscriptionType && subscriptionType.name !== 'Subscription') {
	    return false;
	  }

	  return true;
	}

	function printType(type, options) {
	  if (isScalarType(type)) {
	    return printScalar(type, options);
	  }

	  if (isObjectType(type)) {
	    return printObject(type, options);
	  }

	  if (isInterfaceType(type)) {
	    return printInterface(type, options);
	  }

	  if (isUnionType(type)) {
	    return printUnion(type, options);
	  }

	  if (isEnumType(type)) {
	    return printEnum(type, options);
	  } // istanbul ignore else (See: 'https://github.com/graphql/graphql-js/issues/2618')


	  if (isInputObjectType(type)) {
	    return printInputObject(type, options);
	  } // istanbul ignore next (Not reachable. All possible types have been considered)


	  invariant(0, 'Unexpected type: ' + inspect$2(type));
	}

	function printScalar(type, options) {
	  return printDescription(options, type) + "scalar ".concat(type.name) + printSpecifiedByUrl(type);
	}

	function printImplementedInterfaces(type) {
	  var interfaces = type.getInterfaces();
	  return interfaces.length ? ' implements ' + interfaces.map(function (i) {
	    return i.name;
	  }).join(' & ') : '';
	}

	function printObject(type, options) {
	  return printDescription(options, type) + "type ".concat(type.name) + printImplementedInterfaces(type) + printFields(options, type);
	}

	function printInterface(type, options) {
	  return printDescription(options, type) + "interface ".concat(type.name) + printImplementedInterfaces(type) + printFields(options, type);
	}

	function printUnion(type, options) {
	  var types = type.getTypes();
	  var possibleTypes = types.length ? ' = ' + types.join(' | ') : '';
	  return printDescription(options, type) + 'union ' + type.name + possibleTypes;
	}

	function printEnum(type, options) {
	  var values = type.getValues().map(function (value, i) {
	    return printDescription(options, value, '  ', !i) + '  ' + value.name + printDeprecated(value.deprecationReason);
	  });
	  return printDescription(options, type) + "enum ".concat(type.name) + printBlock(values);
	}

	function printInputObject(type, options) {
	  var fields = objectValues$1(type.getFields()).map(function (f, i) {
	    return printDescription(options, f, '  ', !i) + '  ' + printInputValue(f);
	  });
	  return printDescription(options, type) + "input ".concat(type.name) + printBlock(fields);
	}

	function printFields(options, type) {
	  var fields = objectValues$1(type.getFields()).map(function (f, i) {
	    return printDescription(options, f, '  ', !i) + '  ' + f.name + printArgs(options, f.args, '  ') + ': ' + String(f.type) + printDeprecated(f.deprecationReason);
	  });
	  return printBlock(fields);
	}

	function printBlock(items) {
	  return items.length !== 0 ? ' {\n' + items.join('\n') + '\n}' : '';
	}

	function printArgs(options, args) {
	  var indentation = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : '';

	  if (args.length === 0) {
	    return '';
	  } // If every arg does not have a description, print them on one line.


	  if (args.every(function (arg) {
	    return !arg.description;
	  })) {
	    return '(' + args.map(printInputValue).join(', ') + ')';
	  }

	  return '(\n' + args.map(function (arg, i) {
	    return printDescription(options, arg, '  ' + indentation, !i) + '  ' + indentation + printInputValue(arg);
	  }).join('\n') + '\n' + indentation + ')';
	}

	function printInputValue(arg) {
	  var defaultAST = astFromValue(arg.defaultValue, arg.type);
	  var argDecl = arg.name + ': ' + String(arg.type);

	  if (defaultAST) {
	    argDecl += " = ".concat(print$1(defaultAST));
	  }

	  return argDecl + printDeprecated(arg.deprecationReason);
	}

	function printDirective(directive, options) {
	  return printDescription(options, directive) + 'directive @' + directive.name + printArgs(options, directive.args) + (directive.isRepeatable ? ' repeatable' : '') + ' on ' + directive.locations.join(' | ');
	}

	function printDeprecated(reason) {
	  if (reason == null) {
	    return '';
	  }

	  var reasonAST = astFromValue(reason, GraphQLString);

	  if (reasonAST && reason !== DEFAULT_DEPRECATION_REASON) {
	    return ' @deprecated(reason: ' + print$1(reasonAST) + ')';
	  }

	  return ' @deprecated';
	}

	function printSpecifiedByUrl(scalar) {
	  if (scalar.specifiedByUrl == null) {
	    return '';
	  }

	  var url = scalar.specifiedByUrl;
	  var urlAST = astFromValue(url, GraphQLString);
	  urlAST || invariant(0, 'Unexpected null value returned from `astFromValue` for specifiedByUrl');
	  return ' @specifiedBy(url: ' + print$1(urlAST) + ')';
	}

	function printDescription(options, def) {
	  var indentation = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : '';
	  var firstInBlock = arguments.length > 3 && arguments[3] !== undefined ? arguments[3] : true;
	  var description = def.description;

	  if (description == null) {
	    return '';
	  }

	  if ((options === null || options === void 0 ? void 0 : options.commentDescriptions) === true) {
	    return printDescriptionWithComments(description, indentation, firstInBlock);
	  }

	  var preferMultipleLines = description.length > 70;
	  var blockString = printBlockString(description, '', preferMultipleLines);
	  var prefix = indentation && !firstInBlock ? '\n' + indentation : indentation;
	  return prefix + blockString.replace(/\n/g, '\n' + indentation) + '\n';
	}

	function printDescriptionWithComments(description, indentation, firstInBlock) {
	  var prefix = indentation && !firstInBlock ? '\n' : '';
	  var comment = description.split('\n').map(function (line) {
	    return indentation + (line !== '' ? '# ' + line : '#');
	  }).join('\n');
	  return prefix + comment + '\n';
	}

	/**
	 * Provided a collection of ASTs, presumably each from different files,
	 * concatenate the ASTs together into batched AST, useful for validating many
	 * GraphQL source files which together represent one conceptual application.
	 */
	function concatAST(documents) {
	  var definitions = [];

	  for (var _i2 = 0; _i2 < documents.length; _i2++) {
	    var doc = documents[_i2];
	    definitions = definitions.concat(doc.definitions);
	  }

	  return {
	    kind: 'Document',
	    definitions: definitions
	  };
	}

	/**
	 * separateOperations accepts a single AST document which may contain many
	 * operations and fragments and returns a collection of AST documents each of
	 * which contains a single operation as well the fragment definitions it
	 * refers to.
	 */

	function separateOperations(documentAST) {
	  var operations = [];
	  var depGraph = Object.create(null); // Populate metadata and build a dependency graph.

	  for (var _i2 = 0, _documentAST$definiti2 = documentAST.definitions; _i2 < _documentAST$definiti2.length; _i2++) {
	    var definitionNode = _documentAST$definiti2[_i2];

	    switch (definitionNode.kind) {
	      case Kind.OPERATION_DEFINITION:
	        operations.push(definitionNode);
	        break;

	      case Kind.FRAGMENT_DEFINITION:
	        depGraph[definitionNode.name.value] = collectDependencies(definitionNode.selectionSet);
	        break;
	    }
	  } // For each operation, produce a new synthesized AST which includes only what
	  // is necessary for completing that operation.


	  var separatedDocumentASTs = Object.create(null);

	  var _loop = function _loop(_i4) {
	    var operation = operations[_i4];
	    var dependencies = new Set();

	    for (var _i6 = 0, _collectDependencies2 = collectDependencies(operation.selectionSet); _i6 < _collectDependencies2.length; _i6++) {
	      var fragmentName = _collectDependencies2[_i6];
	      collectTransitiveDependencies(dependencies, depGraph, fragmentName);
	    } // Provides the empty string for anonymous operations.


	    var operationName = operation.name ? operation.name.value : ''; // The list of definition nodes to be included for this operation, sorted
	    // to retain the same order as the original document.

	    separatedDocumentASTs[operationName] = {
	      kind: Kind.DOCUMENT,
	      definitions: documentAST.definitions.filter(function (node) {
	        return node === operation || node.kind === Kind.FRAGMENT_DEFINITION && dependencies.has(node.name.value);
	      })
	    };
	  };

	  for (var _i4 = 0; _i4 < operations.length; _i4++) {
	    _loop(_i4);
	  }

	  return separatedDocumentASTs;
	}

	// From a dependency graph, collects a list of transitive dependencies by
	// recursing through a dependency graph.
	function collectTransitiveDependencies(collected, depGraph, fromName) {
	  if (!collected.has(fromName)) {
	    collected.add(fromName);
	    var immediateDeps = depGraph[fromName];

	    if (immediateDeps !== undefined) {
	      for (var _i8 = 0; _i8 < immediateDeps.length; _i8++) {
	        var toName = immediateDeps[_i8];
	        collectTransitiveDependencies(collected, depGraph, toName);
	      }
	    }
	  }
	}

	function collectDependencies(selectionSet) {
	  var dependencies = [];
	  visit(selectionSet, {
	    FragmentSpread: function FragmentSpread(node) {
	      dependencies.push(node.name.value);
	    }
	  });
	  return dependencies;
	}

	/**
	 * Strips characters that are not significant to the validity or execution
	 * of a GraphQL document:
	 *   - UnicodeBOM
	 *   - WhiteSpace
	 *   - LineTerminator
	 *   - Comment
	 *   - Comma
	 *   - BlockString indentation
	 *
	 * Note: It is required to have a delimiter character between neighboring
	 * non-punctuator tokens and this function always uses single space as delimiter.
	 *
	 * It is guaranteed that both input and output documents if parsed would result
	 * in the exact same AST except for nodes location.
	 *
	 * Warning: It is guaranteed that this function will always produce stable results.
	 * However, it's not guaranteed that it will stay the same between different
	 * releases due to bugfixes or changes in the GraphQL specification.
	 *
	 * Query example:
	 *
	 * query SomeQuery($foo: String!, $bar: String) {
	 *   someField(foo: $foo, bar: $bar) {
	 *     a
	 *     b {
	 *       c
	 *       d
	 *     }
	 *   }
	 * }
	 *
	 * Becomes:
	 *
	 * query SomeQuery($foo:String!$bar:String){someField(foo:$foo bar:$bar){a b{c d}}}
	 *
	 * SDL example:
	 *
	 * """
	 * Type description
	 * """
	 * type Foo {
	 *   """
	 *   Field description
	 *   """
	 *   bar: String
	 * }
	 *
	 * Becomes:
	 *
	 * """Type description""" type Foo{"""Field description""" bar:String}
	 */

	function stripIgnoredCharacters(source) {
	  var sourceObj = isSource(source) ? source : new Source(source);
	  var body = sourceObj.body;
	  var lexer = new Lexer(sourceObj);
	  var strippedBody = '';
	  var wasLastAddedTokenNonPunctuator = false;

	  while (lexer.advance().kind !== TokenKind.EOF) {
	    var currentToken = lexer.token;
	    var tokenKind = currentToken.kind;
	    /**
	     * Every two non-punctuator tokens should have space between them.
	     * Also prevent case of non-punctuator token following by spread resulting
	     * in invalid token (e.g. `1...` is invalid Float token).
	     */

	    var isNonPunctuator = !isPunctuatorTokenKind(currentToken.kind);

	    if (wasLastAddedTokenNonPunctuator) {
	      if (isNonPunctuator || currentToken.kind === TokenKind.SPREAD) {
	        strippedBody += ' ';
	      }
	    }

	    var tokenBody = body.slice(currentToken.start, currentToken.end);

	    if (tokenKind === TokenKind.BLOCK_STRING) {
	      strippedBody += dedentBlockString(tokenBody);
	    } else {
	      strippedBody += tokenBody;
	    }

	    wasLastAddedTokenNonPunctuator = isNonPunctuator;
	  }

	  return strippedBody;
	}

	function dedentBlockString(blockStr) {
	  // skip leading and trailing triple quotations
	  var rawStr = blockStr.slice(3, -3);
	  var body = dedentBlockStringValue(rawStr);

	  if (getBlockStringIndentation(body) > 0) {
	    body = '\n' + body;
	  }

	  var lastChar = body[body.length - 1];
	  var hasTrailingQuote = lastChar === '"' && body.slice(-4) !== '\\"""';

	  if (hasTrailingQuote || lastChar === '\\') {
	    body += '\n';
	  }

	  return '"""' + body + '"""';
	}

	function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); keys.push.apply(keys, symbols); } return keys; }

	function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(Object(source), true).forEach(function (key) { _defineProperty(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

	function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }
	var BreakingChangeType = Object.freeze({
	  TYPE_REMOVED: 'TYPE_REMOVED',
	  TYPE_CHANGED_KIND: 'TYPE_CHANGED_KIND',
	  TYPE_REMOVED_FROM_UNION: 'TYPE_REMOVED_FROM_UNION',
	  VALUE_REMOVED_FROM_ENUM: 'VALUE_REMOVED_FROM_ENUM',
	  REQUIRED_INPUT_FIELD_ADDED: 'REQUIRED_INPUT_FIELD_ADDED',
	  IMPLEMENTED_INTERFACE_REMOVED: 'IMPLEMENTED_INTERFACE_REMOVED',
	  FIELD_REMOVED: 'FIELD_REMOVED',
	  FIELD_CHANGED_KIND: 'FIELD_CHANGED_KIND',
	  REQUIRED_ARG_ADDED: 'REQUIRED_ARG_ADDED',
	  ARG_REMOVED: 'ARG_REMOVED',
	  ARG_CHANGED_KIND: 'ARG_CHANGED_KIND',
	  DIRECTIVE_REMOVED: 'DIRECTIVE_REMOVED',
	  DIRECTIVE_ARG_REMOVED: 'DIRECTIVE_ARG_REMOVED',
	  REQUIRED_DIRECTIVE_ARG_ADDED: 'REQUIRED_DIRECTIVE_ARG_ADDED',
	  DIRECTIVE_REPEATABLE_REMOVED: 'DIRECTIVE_REPEATABLE_REMOVED',
	  DIRECTIVE_LOCATION_REMOVED: 'DIRECTIVE_LOCATION_REMOVED'
	});
	var DangerousChangeType = Object.freeze({
	  VALUE_ADDED_TO_ENUM: 'VALUE_ADDED_TO_ENUM',
	  TYPE_ADDED_TO_UNION: 'TYPE_ADDED_TO_UNION',
	  OPTIONAL_INPUT_FIELD_ADDED: 'OPTIONAL_INPUT_FIELD_ADDED',
	  OPTIONAL_ARG_ADDED: 'OPTIONAL_ARG_ADDED',
	  IMPLEMENTED_INTERFACE_ADDED: 'IMPLEMENTED_INTERFACE_ADDED',
	  ARG_DEFAULT_VALUE_CHANGE: 'ARG_DEFAULT_VALUE_CHANGE'
	});

	/**
	 * Given two schemas, returns an Array containing descriptions of all the types
	 * of breaking changes covered by the other functions down below.
	 */
	function findBreakingChanges(oldSchema, newSchema) {
	  var breakingChanges = findSchemaChanges(oldSchema, newSchema).filter(function (change) {
	    return change.type in BreakingChangeType;
	  });
	  return breakingChanges;
	}
	/**
	 * Given two schemas, returns an Array containing descriptions of all the types
	 * of potentially dangerous changes covered by the other functions down below.
	 */

	function findDangerousChanges(oldSchema, newSchema) {
	  var dangerousChanges = findSchemaChanges(oldSchema, newSchema).filter(function (change) {
	    return change.type in DangerousChangeType;
	  });
	  return dangerousChanges;
	}

	function findSchemaChanges(oldSchema, newSchema) {
	  return [].concat(findTypeChanges(oldSchema, newSchema), findDirectiveChanges(oldSchema, newSchema));
	}

	function findDirectiveChanges(oldSchema, newSchema) {
	  var schemaChanges = [];
	  var directivesDiff = diff(oldSchema.getDirectives(), newSchema.getDirectives());

	  for (var _i2 = 0, _directivesDiff$remov2 = directivesDiff.removed; _i2 < _directivesDiff$remov2.length; _i2++) {
	    var oldDirective = _directivesDiff$remov2[_i2];
	    schemaChanges.push({
	      type: BreakingChangeType.DIRECTIVE_REMOVED,
	      description: "".concat(oldDirective.name, " was removed.")
	    });
	  }

	  for (var _i4 = 0, _directivesDiff$persi2 = directivesDiff.persisted; _i4 < _directivesDiff$persi2.length; _i4++) {
	    var _ref2 = _directivesDiff$persi2[_i4];
	    var _oldDirective = _ref2[0];
	    var newDirective = _ref2[1];
	    var argsDiff = diff(_oldDirective.args, newDirective.args);

	    for (var _i6 = 0, _argsDiff$added2 = argsDiff.added; _i6 < _argsDiff$added2.length; _i6++) {
	      var newArg = _argsDiff$added2[_i6];

	      if (isRequiredArgument(newArg)) {
	        schemaChanges.push({
	          type: BreakingChangeType.REQUIRED_DIRECTIVE_ARG_ADDED,
	          description: "A required arg ".concat(newArg.name, " on directive ").concat(_oldDirective.name, " was added.")
	        });
	      }
	    }

	    for (var _i8 = 0, _argsDiff$removed2 = argsDiff.removed; _i8 < _argsDiff$removed2.length; _i8++) {
	      var oldArg = _argsDiff$removed2[_i8];
	      schemaChanges.push({
	        type: BreakingChangeType.DIRECTIVE_ARG_REMOVED,
	        description: "".concat(oldArg.name, " was removed from ").concat(_oldDirective.name, ".")
	      });
	    }

	    if (_oldDirective.isRepeatable && !newDirective.isRepeatable) {
	      schemaChanges.push({
	        type: BreakingChangeType.DIRECTIVE_REPEATABLE_REMOVED,
	        description: "Repeatable flag was removed from ".concat(_oldDirective.name, ".")
	      });
	    }

	    for (var _i10 = 0, _oldDirective$locatio2 = _oldDirective.locations; _i10 < _oldDirective$locatio2.length; _i10++) {
	      var location = _oldDirective$locatio2[_i10];

	      if (newDirective.locations.indexOf(location) === -1) {
	        schemaChanges.push({
	          type: BreakingChangeType.DIRECTIVE_LOCATION_REMOVED,
	          description: "".concat(location, " was removed from ").concat(_oldDirective.name, ".")
	        });
	      }
	    }
	  }

	  return schemaChanges;
	}

	function findTypeChanges(oldSchema, newSchema) {
	  var schemaChanges = [];
	  var typesDiff = diff(objectValues$1(oldSchema.getTypeMap()), objectValues$1(newSchema.getTypeMap()));

	  for (var _i12 = 0, _typesDiff$removed2 = typesDiff.removed; _i12 < _typesDiff$removed2.length; _i12++) {
	    var oldType = _typesDiff$removed2[_i12];
	    schemaChanges.push({
	      type: BreakingChangeType.TYPE_REMOVED,
	      description: isSpecifiedScalarType(oldType) ? "Standard scalar ".concat(oldType.name, " was removed because it is not referenced anymore.") : "".concat(oldType.name, " was removed.")
	    });
	  }

	  for (var _i14 = 0, _typesDiff$persisted2 = typesDiff.persisted; _i14 < _typesDiff$persisted2.length; _i14++) {
	    var _ref4 = _typesDiff$persisted2[_i14];
	    var _oldType = _ref4[0];
	    var newType = _ref4[1];

	    if (isEnumType(_oldType) && isEnumType(newType)) {
	      schemaChanges.push.apply(schemaChanges, findEnumTypeChanges(_oldType, newType));
	    } else if (isUnionType(_oldType) && isUnionType(newType)) {
	      schemaChanges.push.apply(schemaChanges, findUnionTypeChanges(_oldType, newType));
	    } else if (isInputObjectType(_oldType) && isInputObjectType(newType)) {
	      schemaChanges.push.apply(schemaChanges, findInputObjectTypeChanges(_oldType, newType));
	    } else if (isObjectType(_oldType) && isObjectType(newType)) {
	      schemaChanges.push.apply(schemaChanges, findFieldChanges(_oldType, newType).concat(findImplementedInterfacesChanges(_oldType, newType)));
	    } else if (isInterfaceType(_oldType) && isInterfaceType(newType)) {
	      schemaChanges.push.apply(schemaChanges, findFieldChanges(_oldType, newType).concat(findImplementedInterfacesChanges(_oldType, newType)));
	    } else if (_oldType.constructor !== newType.constructor) {
	      schemaChanges.push({
	        type: BreakingChangeType.TYPE_CHANGED_KIND,
	        description: "".concat(_oldType.name, " changed from ") + "".concat(typeKindName(_oldType), " to ").concat(typeKindName(newType), ".")
	      });
	    }
	  }

	  return schemaChanges;
	}

	function findInputObjectTypeChanges(oldType, newType) {
	  var schemaChanges = [];
	  var fieldsDiff = diff(objectValues$1(oldType.getFields()), objectValues$1(newType.getFields()));

	  for (var _i16 = 0, _fieldsDiff$added2 = fieldsDiff.added; _i16 < _fieldsDiff$added2.length; _i16++) {
	    var newField = _fieldsDiff$added2[_i16];

	    if (isRequiredInputField(newField)) {
	      schemaChanges.push({
	        type: BreakingChangeType.REQUIRED_INPUT_FIELD_ADDED,
	        description: "A required field ".concat(newField.name, " on input type ").concat(oldType.name, " was added.")
	      });
	    } else {
	      schemaChanges.push({
	        type: DangerousChangeType.OPTIONAL_INPUT_FIELD_ADDED,
	        description: "An optional field ".concat(newField.name, " on input type ").concat(oldType.name, " was added.")
	      });
	    }
	  }

	  for (var _i18 = 0, _fieldsDiff$removed2 = fieldsDiff.removed; _i18 < _fieldsDiff$removed2.length; _i18++) {
	    var oldField = _fieldsDiff$removed2[_i18];
	    schemaChanges.push({
	      type: BreakingChangeType.FIELD_REMOVED,
	      description: "".concat(oldType.name, ".").concat(oldField.name, " was removed.")
	    });
	  }

	  for (var _i20 = 0, _fieldsDiff$persisted2 = fieldsDiff.persisted; _i20 < _fieldsDiff$persisted2.length; _i20++) {
	    var _ref6 = _fieldsDiff$persisted2[_i20];
	    var _oldField = _ref6[0];
	    var _newField = _ref6[1];
	    var isSafe = isChangeSafeForInputObjectFieldOrFieldArg(_oldField.type, _newField.type);

	    if (!isSafe) {
	      schemaChanges.push({
	        type: BreakingChangeType.FIELD_CHANGED_KIND,
	        description: "".concat(oldType.name, ".").concat(_oldField.name, " changed type from ") + "".concat(String(_oldField.type), " to ").concat(String(_newField.type), ".")
	      });
	    }
	  }

	  return schemaChanges;
	}

	function findUnionTypeChanges(oldType, newType) {
	  var schemaChanges = [];
	  var possibleTypesDiff = diff(oldType.getTypes(), newType.getTypes());

	  for (var _i22 = 0, _possibleTypesDiff$ad2 = possibleTypesDiff.added; _i22 < _possibleTypesDiff$ad2.length; _i22++) {
	    var newPossibleType = _possibleTypesDiff$ad2[_i22];
	    schemaChanges.push({
	      type: DangerousChangeType.TYPE_ADDED_TO_UNION,
	      description: "".concat(newPossibleType.name, " was added to union type ").concat(oldType.name, ".")
	    });
	  }

	  for (var _i24 = 0, _possibleTypesDiff$re2 = possibleTypesDiff.removed; _i24 < _possibleTypesDiff$re2.length; _i24++) {
	    var oldPossibleType = _possibleTypesDiff$re2[_i24];
	    schemaChanges.push({
	      type: BreakingChangeType.TYPE_REMOVED_FROM_UNION,
	      description: "".concat(oldPossibleType.name, " was removed from union type ").concat(oldType.name, ".")
	    });
	  }

	  return schemaChanges;
	}

	function findEnumTypeChanges(oldType, newType) {
	  var schemaChanges = [];
	  var valuesDiff = diff(oldType.getValues(), newType.getValues());

	  for (var _i26 = 0, _valuesDiff$added2 = valuesDiff.added; _i26 < _valuesDiff$added2.length; _i26++) {
	    var newValue = _valuesDiff$added2[_i26];
	    schemaChanges.push({
	      type: DangerousChangeType.VALUE_ADDED_TO_ENUM,
	      description: "".concat(newValue.name, " was added to enum type ").concat(oldType.name, ".")
	    });
	  }

	  for (var _i28 = 0, _valuesDiff$removed2 = valuesDiff.removed; _i28 < _valuesDiff$removed2.length; _i28++) {
	    var oldValue = _valuesDiff$removed2[_i28];
	    schemaChanges.push({
	      type: BreakingChangeType.VALUE_REMOVED_FROM_ENUM,
	      description: "".concat(oldValue.name, " was removed from enum type ").concat(oldType.name, ".")
	    });
	  }

	  return schemaChanges;
	}

	function findImplementedInterfacesChanges(oldType, newType) {
	  var schemaChanges = [];
	  var interfacesDiff = diff(oldType.getInterfaces(), newType.getInterfaces());

	  for (var _i30 = 0, _interfacesDiff$added2 = interfacesDiff.added; _i30 < _interfacesDiff$added2.length; _i30++) {
	    var newInterface = _interfacesDiff$added2[_i30];
	    schemaChanges.push({
	      type: DangerousChangeType.IMPLEMENTED_INTERFACE_ADDED,
	      description: "".concat(newInterface.name, " added to interfaces implemented by ").concat(oldType.name, ".")
	    });
	  }

	  for (var _i32 = 0, _interfacesDiff$remov2 = interfacesDiff.removed; _i32 < _interfacesDiff$remov2.length; _i32++) {
	    var oldInterface = _interfacesDiff$remov2[_i32];
	    schemaChanges.push({
	      type: BreakingChangeType.IMPLEMENTED_INTERFACE_REMOVED,
	      description: "".concat(oldType.name, " no longer implements interface ").concat(oldInterface.name, ".")
	    });
	  }

	  return schemaChanges;
	}

	function findFieldChanges(oldType, newType) {
	  var schemaChanges = [];
	  var fieldsDiff = diff(objectValues$1(oldType.getFields()), objectValues$1(newType.getFields()));

	  for (var _i34 = 0, _fieldsDiff$removed4 = fieldsDiff.removed; _i34 < _fieldsDiff$removed4.length; _i34++) {
	    var oldField = _fieldsDiff$removed4[_i34];
	    schemaChanges.push({
	      type: BreakingChangeType.FIELD_REMOVED,
	      description: "".concat(oldType.name, ".").concat(oldField.name, " was removed.")
	    });
	  }

	  for (var _i36 = 0, _fieldsDiff$persisted4 = fieldsDiff.persisted; _i36 < _fieldsDiff$persisted4.length; _i36++) {
	    var _ref8 = _fieldsDiff$persisted4[_i36];
	    var _oldField2 = _ref8[0];
	    var newField = _ref8[1];
	    schemaChanges.push.apply(schemaChanges, findArgChanges(oldType, _oldField2, newField));
	    var isSafe = isChangeSafeForObjectOrInterfaceField(_oldField2.type, newField.type);

	    if (!isSafe) {
	      schemaChanges.push({
	        type: BreakingChangeType.FIELD_CHANGED_KIND,
	        description: "".concat(oldType.name, ".").concat(_oldField2.name, " changed type from ") + "".concat(String(_oldField2.type), " to ").concat(String(newField.type), ".")
	      });
	    }
	  }

	  return schemaChanges;
	}

	function findArgChanges(oldType, oldField, newField) {
	  var schemaChanges = [];
	  var argsDiff = diff(oldField.args, newField.args);

	  for (var _i38 = 0, _argsDiff$removed4 = argsDiff.removed; _i38 < _argsDiff$removed4.length; _i38++) {
	    var oldArg = _argsDiff$removed4[_i38];
	    schemaChanges.push({
	      type: BreakingChangeType.ARG_REMOVED,
	      description: "".concat(oldType.name, ".").concat(oldField.name, " arg ").concat(oldArg.name, " was removed.")
	    });
	  }

	  for (var _i40 = 0, _argsDiff$persisted2 = argsDiff.persisted; _i40 < _argsDiff$persisted2.length; _i40++) {
	    var _ref10 = _argsDiff$persisted2[_i40];
	    var _oldArg = _ref10[0];
	    var newArg = _ref10[1];
	    var isSafe = isChangeSafeForInputObjectFieldOrFieldArg(_oldArg.type, newArg.type);

	    if (!isSafe) {
	      schemaChanges.push({
	        type: BreakingChangeType.ARG_CHANGED_KIND,
	        description: "".concat(oldType.name, ".").concat(oldField.name, " arg ").concat(_oldArg.name, " has changed type from ") + "".concat(String(_oldArg.type), " to ").concat(String(newArg.type), ".")
	      });
	    } else if (_oldArg.defaultValue !== undefined) {
	      if (newArg.defaultValue === undefined) {
	        schemaChanges.push({
	          type: DangerousChangeType.ARG_DEFAULT_VALUE_CHANGE,
	          description: "".concat(oldType.name, ".").concat(oldField.name, " arg ").concat(_oldArg.name, " defaultValue was removed.")
	        });
	      } else {
	        // Since we looking only for client's observable changes we should
	        // compare default values in the same representation as they are
	        // represented inside introspection.
	        var oldValueStr = stringifyValue(_oldArg.defaultValue, _oldArg.type);
	        var newValueStr = stringifyValue(newArg.defaultValue, newArg.type);

	        if (oldValueStr !== newValueStr) {
	          schemaChanges.push({
	            type: DangerousChangeType.ARG_DEFAULT_VALUE_CHANGE,
	            description: "".concat(oldType.name, ".").concat(oldField.name, " arg ").concat(_oldArg.name, " has changed defaultValue from ").concat(oldValueStr, " to ").concat(newValueStr, ".")
	          });
	        }
	      }
	    }
	  }

	  for (var _i42 = 0, _argsDiff$added4 = argsDiff.added; _i42 < _argsDiff$added4.length; _i42++) {
	    var _newArg = _argsDiff$added4[_i42];

	    if (isRequiredArgument(_newArg)) {
	      schemaChanges.push({
	        type: BreakingChangeType.REQUIRED_ARG_ADDED,
	        description: "A required arg ".concat(_newArg.name, " on ").concat(oldType.name, ".").concat(oldField.name, " was added.")
	      });
	    } else {
	      schemaChanges.push({
	        type: DangerousChangeType.OPTIONAL_ARG_ADDED,
	        description: "An optional arg ".concat(_newArg.name, " on ").concat(oldType.name, ".").concat(oldField.name, " was added.")
	      });
	    }
	  }

	  return schemaChanges;
	}

	function isChangeSafeForObjectOrInterfaceField(oldType, newType) {
	  if (isListType(oldType)) {
	    return (// if they're both lists, make sure the underlying types are compatible
	      isListType(newType) && isChangeSafeForObjectOrInterfaceField(oldType.ofType, newType.ofType) || // moving from nullable to non-null of the same underlying type is safe
	      isNonNullType(newType) && isChangeSafeForObjectOrInterfaceField(oldType, newType.ofType)
	    );
	  }

	  if (isNonNullType(oldType)) {
	    // if they're both non-null, make sure the underlying types are compatible
	    return isNonNullType(newType) && isChangeSafeForObjectOrInterfaceField(oldType.ofType, newType.ofType);
	  }

	  return (// if they're both named types, see if their names are equivalent
	    isNamedType(newType) && oldType.name === newType.name || // moving from nullable to non-null of the same underlying type is safe
	    isNonNullType(newType) && isChangeSafeForObjectOrInterfaceField(oldType, newType.ofType)
	  );
	}

	function isChangeSafeForInputObjectFieldOrFieldArg(oldType, newType) {
	  if (isListType(oldType)) {
	    // if they're both lists, make sure the underlying types are compatible
	    return isListType(newType) && isChangeSafeForInputObjectFieldOrFieldArg(oldType.ofType, newType.ofType);
	  }

	  if (isNonNullType(oldType)) {
	    return (// if they're both non-null, make sure the underlying types are
	      // compatible
	      isNonNullType(newType) && isChangeSafeForInputObjectFieldOrFieldArg(oldType.ofType, newType.ofType) || // moving from non-null to nullable of the same underlying type is safe
	      !isNonNullType(newType) && isChangeSafeForInputObjectFieldOrFieldArg(oldType.ofType, newType)
	    );
	  } // if they're both named types, see if their names are equivalent


	  return isNamedType(newType) && oldType.name === newType.name;
	}

	function typeKindName(type) {
	  if (isScalarType(type)) {
	    return 'a Scalar type';
	  }

	  if (isObjectType(type)) {
	    return 'an Object type';
	  }

	  if (isInterfaceType(type)) {
	    return 'an Interface type';
	  }

	  if (isUnionType(type)) {
	    return 'a Union type';
	  }

	  if (isEnumType(type)) {
	    return 'an Enum type';
	  } // istanbul ignore else (See: 'https://github.com/graphql/graphql-js/issues/2618')


	  if (isInputObjectType(type)) {
	    return 'an Input type';
	  } // istanbul ignore next (Not reachable. All possible named types have been considered)


	  invariant(0, 'Unexpected type: ' + inspect$2(type));
	}

	function stringifyValue(value, type) {
	  var ast = astFromValue(value, type);
	  ast != null || invariant(0);
	  var sortedAST = visit(ast, {
	    ObjectValue: function ObjectValue(objectNode) {
	      // Make a copy since sort mutates array
	      var fields = [].concat(objectNode.fields);
	      fields.sort(function (fieldA, fieldB) {
	        return naturalCompare(fieldA.name.value, fieldB.name.value);
	      });
	      return _objectSpread(_objectSpread({}, objectNode), {}, {
	        fields: fields
	      });
	    }
	  });
	  return print$1(sortedAST);
	}

	function diff(oldArray, newArray) {
	  var added = [];
	  var removed = [];
	  var persisted = [];
	  var oldMap = keyMap(oldArray, function (_ref11) {
	    var name = _ref11.name;
	    return name;
	  });
	  var newMap = keyMap(newArray, function (_ref12) {
	    var name = _ref12.name;
	    return name;
	  });

	  for (var _i44 = 0; _i44 < oldArray.length; _i44++) {
	    var oldItem = oldArray[_i44];
	    var newItem = newMap[oldItem.name];

	    if (newItem === undefined) {
	      removed.push(oldItem);
	    } else {
	      persisted.push([oldItem, newItem]);
	    }
	  }

	  for (var _i46 = 0; _i46 < newArray.length; _i46++) {
	    var _newItem = newArray[_i46];

	    if (oldMap[_newItem.name] === undefined) {
	      added.push(_newItem);
	    }
	  }

	  return {
	    added: added,
	    persisted: persisted,
	    removed: removed
	  };
	}

	/**
	 * A validation rule which reports deprecated usages.
	 *
	 * Returns a list of GraphQLError instances describing each deprecated use.
	 *
	 * @deprecated Please use `validate` with `NoDeprecatedCustomRule` instead:
	 *
	 * ```
	 * import { validate, NoDeprecatedCustomRule } from 'graphql'
	 *
	 * const errors = validate(schema, document, [NoDeprecatedCustomRule])
	 * ```
	 */

	function findDeprecatedUsages(schema, ast) {
	  return validate$3(schema, ast, [NoDeprecatedCustomRule]);
	}

	/**
	 * GraphQL.js provides a reference implementation for the GraphQL specification
	 * but is also a useful utility for operating on GraphQL files and building
	 * sophisticated tools.
	 *
	 * This primary module exports a general purpose function for fulfilling all
	 * steps of the GraphQL specification in a single operation, but also includes
	 * utilities for every part of the GraphQL specification:
	 *
	 *   - Parsing the GraphQL language.
	 *   - Building a GraphQL type schema.
	 *   - Validating a GraphQL request against a type schema.
	 *   - Executing a GraphQL request against a type schema.
	 *
	 * This also includes utility functions for operating on GraphQL types and
	 * GraphQL documents to facilitate building tools.
	 *
	 * You may also import from each sub-directory directly. For example, the
	 * following two import statements are equivalent:
	 *
	 *     import { parse } from 'graphql';
	 *     import { parse } from 'graphql/language';
	 */

	var graphql = /*#__PURE__*/Object.freeze({
		__proto__: null,
		version: version$2,
		versionInfo: versionInfo,
		graphql: graphql$1,
		graphqlSync: graphqlSync,
		GraphQLSchema: GraphQLSchema,
		GraphQLDirective: GraphQLDirective,
		GraphQLScalarType: GraphQLScalarType,
		GraphQLObjectType: GraphQLObjectType,
		GraphQLInterfaceType: GraphQLInterfaceType,
		GraphQLUnionType: GraphQLUnionType,
		GraphQLEnumType: GraphQLEnumType,
		GraphQLInputObjectType: GraphQLInputObjectType,
		GraphQLList: GraphQLList,
		GraphQLNonNull: GraphQLNonNull,
		specifiedScalarTypes: specifiedScalarTypes,
		GraphQLInt: GraphQLInt,
		GraphQLFloat: GraphQLFloat,
		GraphQLString: GraphQLString,
		GraphQLBoolean: GraphQLBoolean,
		GraphQLID: GraphQLID,
		specifiedDirectives: specifiedDirectives,
		GraphQLIncludeDirective: GraphQLIncludeDirective,
		GraphQLSkipDirective: GraphQLSkipDirective,
		GraphQLDeprecatedDirective: GraphQLDeprecatedDirective,
		GraphQLSpecifiedByDirective: GraphQLSpecifiedByDirective,
		TypeKind: TypeKind,
		DEFAULT_DEPRECATION_REASON: DEFAULT_DEPRECATION_REASON,
		introspectionTypes: introspectionTypes,
		__Schema: __Schema,
		__Directive: __Directive,
		__DirectiveLocation: __DirectiveLocation,
		__Type: __Type,
		__Field: __Field,
		__InputValue: __InputValue,
		__EnumValue: __EnumValue,
		__TypeKind: __TypeKind,
		SchemaMetaFieldDef: SchemaMetaFieldDef,
		TypeMetaFieldDef: TypeMetaFieldDef,
		TypeNameMetaFieldDef: TypeNameMetaFieldDef,
		isSchema: isSchema,
		isDirective: isDirective,
		isType: isType,
		isScalarType: isScalarType,
		isObjectType: isObjectType,
		isInterfaceType: isInterfaceType,
		isUnionType: isUnionType,
		isEnumType: isEnumType,
		isInputObjectType: isInputObjectType,
		isListType: isListType,
		isNonNullType: isNonNullType,
		isInputType: isInputType,
		isOutputType: isOutputType,
		isLeafType: isLeafType,
		isCompositeType: isCompositeType,
		isAbstractType: isAbstractType,
		isWrappingType: isWrappingType,
		isNullableType: isNullableType,
		isNamedType: isNamedType,
		isRequiredArgument: isRequiredArgument,
		isRequiredInputField: isRequiredInputField,
		isSpecifiedScalarType: isSpecifiedScalarType,
		isIntrospectionType: isIntrospectionType,
		isSpecifiedDirective: isSpecifiedDirective,
		assertSchema: assertSchema,
		assertDirective: assertDirective,
		assertType: assertType,
		assertScalarType: assertScalarType,
		assertObjectType: assertObjectType,
		assertInterfaceType: assertInterfaceType,
		assertUnionType: assertUnionType,
		assertEnumType: assertEnumType,
		assertInputObjectType: assertInputObjectType,
		assertListType: assertListType,
		assertNonNullType: assertNonNullType,
		assertInputType: assertInputType,
		assertOutputType: assertOutputType,
		assertLeafType: assertLeafType,
		assertCompositeType: assertCompositeType,
		assertAbstractType: assertAbstractType,
		assertWrappingType: assertWrappingType,
		assertNullableType: assertNullableType,
		assertNamedType: assertNamedType,
		getNullableType: getNullableType,
		getNamedType: getNamedType,
		validateSchema: validateSchema$1,
		assertValidSchema: assertValidSchema,
		Token: Token,
		Source: Source,
		Location: Location,
		getLocation: getLocation,
		printLocation: printLocation,
		printSourceLocation: printSourceLocation,
		Lexer: Lexer,
		TokenKind: TokenKind,
		parse: parse,
		parseValue: parseValue,
		parseType: parseType,
		print: print$1,
		visit: visit,
		visitInParallel: visitInParallel,
		getVisitFn: getVisitFn,
		BREAK: BREAK,
		Kind: Kind,
		DirectiveLocation: DirectiveLocation,
		isDefinitionNode: isDefinitionNode,
		isExecutableDefinitionNode: isExecutableDefinitionNode,
		isSelectionNode: isSelectionNode,
		isValueNode: isValueNode,
		isTypeNode: isTypeNode,
		isTypeSystemDefinitionNode: isTypeSystemDefinitionNode,
		isTypeDefinitionNode: isTypeDefinitionNode,
		isTypeSystemExtensionNode: isTypeSystemExtensionNode,
		isTypeExtensionNode: isTypeExtensionNode,
		execute: execute,
		executeSync: executeSync,
		defaultFieldResolver: defaultFieldResolver,
		defaultTypeResolver: defaultTypeResolver,
		responsePathAsArray: pathToArray,
		getDirectiveValues: getDirectiveValues,
		subscribe: subscribe,
		createSourceEventStream: createSourceEventStream,
		validate: validate$3,
		ValidationContext: ValidationContext,
		specifiedRules: specifiedRules,
		ExecutableDefinitionsRule: ExecutableDefinitionsRule,
		FieldsOnCorrectTypeRule: FieldsOnCorrectTypeRule,
		FragmentsOnCompositeTypesRule: FragmentsOnCompositeTypesRule,
		KnownArgumentNamesRule: KnownArgumentNamesRule,
		KnownDirectivesRule: KnownDirectivesRule,
		KnownFragmentNamesRule: KnownFragmentNamesRule,
		KnownTypeNamesRule: KnownTypeNamesRule,
		LoneAnonymousOperationRule: LoneAnonymousOperationRule,
		NoFragmentCyclesRule: NoFragmentCyclesRule,
		NoUndefinedVariablesRule: NoUndefinedVariablesRule,
		NoUnusedFragmentsRule: NoUnusedFragmentsRule,
		NoUnusedVariablesRule: NoUnusedVariablesRule,
		OverlappingFieldsCanBeMergedRule: OverlappingFieldsCanBeMergedRule,
		PossibleFragmentSpreadsRule: PossibleFragmentSpreadsRule,
		ProvidedRequiredArgumentsRule: ProvidedRequiredArgumentsRule,
		ScalarLeafsRule: ScalarLeafsRule,
		SingleFieldSubscriptionsRule: SingleFieldSubscriptionsRule,
		UniqueArgumentNamesRule: UniqueArgumentNamesRule,
		UniqueDirectivesPerLocationRule: UniqueDirectivesPerLocationRule,
		UniqueFragmentNamesRule: UniqueFragmentNamesRule,
		UniqueInputFieldNamesRule: UniqueInputFieldNamesRule,
		UniqueOperationNamesRule: UniqueOperationNamesRule,
		UniqueVariableNamesRule: UniqueVariableNamesRule,
		ValuesOfCorrectTypeRule: ValuesOfCorrectTypeRule,
		VariablesAreInputTypesRule: VariablesAreInputTypesRule,
		VariablesInAllowedPositionRule: VariablesInAllowedPositionRule,
		LoneSchemaDefinitionRule: LoneSchemaDefinitionRule,
		UniqueOperationTypesRule: UniqueOperationTypesRule,
		UniqueTypeNamesRule: UniqueTypeNamesRule,
		UniqueEnumValueNamesRule: UniqueEnumValueNamesRule,
		UniqueFieldDefinitionNamesRule: UniqueFieldDefinitionNamesRule,
		UniqueDirectiveNamesRule: UniqueDirectiveNamesRule,
		PossibleTypeExtensionsRule: PossibleTypeExtensionsRule,
		NoDeprecatedCustomRule: NoDeprecatedCustomRule,
		NoSchemaIntrospectionCustomRule: NoSchemaIntrospectionCustomRule,
		GraphQLError: GraphQLError,
		syntaxError: syntaxError,
		locatedError: locatedError,
		printError: printError,
		formatError: formatError$1,
		getIntrospectionQuery: getIntrospectionQuery,
		getOperationAST: getOperationAST,
		getOperationRootType: getOperationRootType,
		introspectionFromSchema: introspectionFromSchema,
		buildClientSchema: buildClientSchema,
		buildASTSchema: buildASTSchema,
		buildSchema: buildSchema$2,
		getDescription: getDescription,
		extendSchema: extendSchema,
		lexicographicSortSchema: lexicographicSortSchema,
		printSchema: printSchema,
		printType: printType,
		printIntrospectionSchema: printIntrospectionSchema,
		typeFromAST: typeFromAST,
		valueFromAST: valueFromAST$1,
		valueFromASTUntyped: valueFromASTUntyped$1,
		astFromValue: astFromValue,
		TypeInfo: TypeInfo,
		visitWithTypeInfo: visitWithTypeInfo,
		coerceInputValue: coerceInputValue,
		concatAST: concatAST,
		separateOperations: separateOperations,
		stripIgnoredCharacters: stripIgnoredCharacters,
		isEqualType: isEqualType,
		isTypeSubTypeOf: isTypeSubTypeOf,
		doTypesOverlap: doTypesOverlap,
		assertValidName: assertValidName,
		isValidNameError: isValidNameError,
		BreakingChangeType: BreakingChangeType,
		DangerousChangeType: DangerousChangeType,
		findBreakingChanges: findBreakingChanges,
		findDangerousChanges: findDangerousChanges,
		findDeprecatedUsages: findDeprecatedUsages
	});

	var require$$2$1 = /*@__PURE__*/getAugmentedNamespace(graphql);

	var coreSpec$1 = {};

	var types = {};

	(function (exports) {
	Object.defineProperty(exports, "__esModule", { value: true });
	exports.isStrictSubtype = exports.isSubtype = exports.isDirectSubtype = exports.sameType = exports.DEFAULT_SUBTYPING_RULES = exports.ALL_SUBTYPING_RULES = void 0;
	const definitions_1 = definitions;
	exports.ALL_SUBTYPING_RULES = [
	    'direct',
	    'nonNullable_downgrade',
	    'list_upgrade',
	    'list_propagation',
	    'nonNullable_propagation'
	];
	exports.DEFAULT_SUBTYPING_RULES = exports.ALL_SUBTYPING_RULES.filter(r => r !== "list_upgrade");
	function sameType(t1, t2) {
	    if (t1.kind !== t2.kind) {
	        return false;
	    }
	    switch (t1.kind) {
	        case 'ListType':
	            return sameType(t1.ofType, t2.ofType);
	        case 'NonNullType':
	            return sameType(t1.ofType, t2.ofType);
	        default:
	            return t1.name === t2.name;
	    }
	}
	exports.sameType = sameType;
	function isDirectSubtype(type, maybeSubType, unionMembershipTester = (u, m) => u.hasTypeMember(m), implementsInterfaceTester = (m, i) => m.implementsInterface(i)) {
	    if ((0, definitions_1.isUnionType)(type)) {
	        return (0, definitions_1.isObjectType)(maybeSubType) && unionMembershipTester(type, maybeSubType);
	    }
	    return implementsInterfaceTester(maybeSubType, type);
	}
	exports.isDirectSubtype = isDirectSubtype;
	function isSubtype(type, maybeSubType, allowedRules = exports.DEFAULT_SUBTYPING_RULES, unionMembershipTester = (u, m) => u.hasTypeMember(m), implementsInterfaceTester = (m, i) => m.implementsInterface(i)) {
	    return sameType(type, maybeSubType) || isStrictSubtype(type, maybeSubType, allowedRules, unionMembershipTester, implementsInterfaceTester);
	}
	exports.isSubtype = isSubtype;
	function isStrictSubtype(type, maybeSubType, allowedRules = exports.DEFAULT_SUBTYPING_RULES, unionMembershipTester = (u, m) => u.hasTypeMember(m), implementsInterfaceTester = (m, i) => m.implementsInterface(i)) {
	    switch (maybeSubType.kind) {
	        case 'ListType':
	            return allowedRules.includes('list_propagation')
	                && (0, definitions_1.isListType)(type)
	                && isSubtype(type.ofType, maybeSubType.ofType, allowedRules, unionMembershipTester, implementsInterfaceTester);
	        case 'NonNullType':
	            if ((0, definitions_1.isNonNullType)(type)) {
	                return allowedRules.includes('nonNullable_propagation')
	                    && isSubtype(type.ofType, maybeSubType.ofType, allowedRules, unionMembershipTester, implementsInterfaceTester);
	            }
	            return allowedRules.includes('nonNullable_downgrade')
	                && isSubtype(type, maybeSubType.ofType, allowedRules, unionMembershipTester, implementsInterfaceTester);
	        case 'ObjectType':
	        case 'InterfaceType':
	            if ((0, definitions_1.isListType)(type)) {
	                return allowedRules.includes('list_upgrade')
	                    && isSubtype(type.ofType, maybeSubType, allowedRules, unionMembershipTester, implementsInterfaceTester);
	            }
	            return allowedRules.includes('direct')
	                && ((0, definitions_1.isInterfaceType)(type) || (0, definitions_1.isUnionType)(type))
	                && isDirectSubtype(type, maybeSubType, unionMembershipTester, implementsInterfaceTester);
	        default:
	            return (0, definitions_1.isListType)(type)
	                && allowedRules.includes('list_upgrade')
	                && isSubtype(type.ofType, maybeSubType, allowedRules, unionMembershipTester, implementsInterfaceTester);
	    }
	}
	exports.isStrictSubtype = isStrictSubtype;

	}(types));

	var dist$1 = {};

	var schema$1 = {};

	var require$$1$2 = /*@__PURE__*/getAugmentedNamespace(values$1);

	var core = {};

	var error$2 = {};

	Object.defineProperty(error$2, "__esModule", { value: true });
	error$2.err = error$2.GraphQLErrorExt = void 0;
	const graphql_1$d = require$$2$1;
	class GraphQLErrorExt extends graphql_1$d.GraphQLError {
	    constructor(code, message, props) {
	        super(message, props === null || props === void 0 ? void 0 : props.nodes, props === null || props === void 0 ? void 0 : props.source, props === null || props === void 0 ? void 0 : props.positions, props === null || props === void 0 ? void 0 : props.path, props === null || props === void 0 ? void 0 : props.originalError, props === null || props === void 0 ? void 0 : props.extensions);
	        this.code = code;
	        if (props)
	            for (const prop in props) {
	                if (!GraphQLErrorExt.BASE_PROPS.has(prop)) {
	                    this[prop] = props[prop];
	                }
	            }
	    }
	    get name() { return this.code; }
	    throw() { throw this; }
	    toString() {
	        let output = `[${this.code}] ${graphql_1$d.printError(this)}`;
	        const causes = this.causes;
	        if (causes && causes.length) {
	            output += '\ncaused by:';
	            for (const cause of this.causes || []) {
	                if (!cause)
	                    continue;
	                output += '\n\n  - ';
	                output += cause.toString().split('\n').join('\n    ');
	            }
	        }
	        return output;
	    }
	}
	error$2.GraphQLErrorExt = GraphQLErrorExt;
	GraphQLErrorExt.BASE_PROPS = new Set('nodes source positions path originalError extensions'.split(' '));
	function err(code, props) {
	    const message = typeof props === 'string' ? props : props.message;
	    const error = new GraphQLErrorExt(code, message, typeof props === 'string' ? undefined : props);
	    return error;
	}
	error$2.err = err;
	error$2.default = err;

	(function (exports) {
	Object.defineProperty(exports, "__esModule", { value: true });
	exports.Cell = exports.ROLLBACK = exports.Core = exports.ErrCheckFailed = exports.ErrEvalStackEmpty = exports.ErrNoData = void 0;
	const error_1 = error$2;
	const ErrNoData = (causes) => error_1.err('NoData', {
	    message: 'no data',
	    causes
	});
	exports.ErrNoData = ErrNoData;
	const ErrEvalStackEmpty = () => error_1.err('EvalStackEmpty', {
	    code: 'EvalStackEmpty',
	    message: 'this method must only be called from an evaluator, during evaluation. no evaluation is ongoing.'
	});
	exports.ErrEvalStackEmpty = ErrEvalStackEmpty;
	const ErrCheckFailed = (causes) => error_1.err('CheckFailed', {
	    message: 'one or more checks failed',
	    causes
	});
	exports.ErrCheckFailed = ErrCheckFailed;
	class Core {
	    constructor(data) {
	        this._cells = new WeakMap;
	        this._stack = [];
	        this._traceStack = [];
	        this._data = data;
	    }
	    get data() { return this._data; }
	    get(fn) {
	        var _a;
	        const cell = this.getCell(fn);
	        this.evaluate(cell, fn);
	        if (!cell.result) {
	            throw exports.ErrNoData();
	        }
	        if (cell.result.data === undefined) {
	            if (((_a = cell.result.errors) === null || _a === void 0 ? void 0 : _a.length) === 1)
	                throw cell.result.errors[0];
	            throw exports.ErrNoData(cell.result.errors);
	        }
	        return cell.result.data;
	    }
	    try(fn) {
	        var _a;
	        const cell = this.getCell(fn);
	        this.evaluate(cell, fn);
	        return (_a = cell.result) === null || _a === void 0 ? void 0 : _a.data;
	    }
	    getResult(fn) {
	        const cell = this.getCell(fn);
	        let result = { errors: [] };
	        this.trace(() => {
	            var _a;
	            this.evaluate(cell, fn);
	            result.data = (_a = cell.result) === null || _a === void 0 ? void 0 : _a.data;
	        }, (event, _fn, cellResult) => {
	            if (event === 'end' && cellResult && cellResult.errors)
	                result.errors = result.errors.concat(cellResult.errors);
	        });
	        return result;
	    }
	    check(...fns) {
	        let errors = [];
	        this.trace(() => {
	            for (const fn of fns)
	                this.try(fn);
	        }, (event, _fn, cellResult) => {
	            if (event === 'end' && cellResult && cellResult.errors)
	                errors = errors.concat(cellResult.errors);
	        });
	        if (!errors.length)
	            return this;
	        throw exports.ErrCheckFailed(errors);
	    }
	    update(update) {
	        this._data = update(this.data);
	    }
	    pure(...passIfChanged) {
	        const { currentCell } = this;
	        currentCell.pure(...passIfChanged);
	    }
	    report(...errors) {
	        const { currentCell } = this;
	        for (const error of errors)
	            currentCell.report(error);
	    }
	    get currentCell() {
	        const top = this._stack[this._stack.length - 1];
	        if (!top)
	            throw exports.ErrEvalStackEmpty();
	        return top;
	    }
	    get currentTracer() {
	        return this._traceStack[this._traceStack.length - 1];
	    }
	    trace(block, onEvent) {
	        this._traceStack.push(onEvent);
	        try {
	            block();
	        }
	        finally {
	            this._traceStack.pop();
	        }
	    }
	    evaluate(cell, fn) {
	        const tracer = this.currentTracer;
	        this._stack.push(cell);
	        try {
	            try {
	                if (tracer)
	                    tracer('begin', fn, cell.result);
	                cell.evaluate(this, fn);
	            }
	            finally {
	                if (tracer)
	                    tracer('end', fn, cell.result);
	            }
	        }
	        finally {
	            this._stack.pop();
	        }
	    }
	    getCell(fn) {
	        const existing = this._cells.get(fn);
	        if (existing)
	            return existing;
	        const created = new Cell;
	        this._cells.set(fn, created);
	        return created;
	    }
	}
	exports.Core = Core;
	exports.default = Core;
	exports.ROLLBACK = Object.freeze({ ROLLBACK: true });
	class Cell {
	    constructor() {
	        this.status = 'empty';
	        this.result = undefined;
	        this._pendingResult = undefined;
	        this._guards = [];
	        this._nextGuard = 0;
	    }
	    pure(...changed) {
	        const index = this._nextGuard++;
	        const existing = this._guards[index];
	        try {
	            if (!existing)
	                return;
	            if (existing.length !== changed.length)
	                return;
	            let i = existing.length;
	            while (i-- > 0) {
	                if (existing[i] !== changed[i])
	                    return;
	            }
	            throw exports.ROLLBACK;
	        }
	        finally {
	            this._guards[index] = changed;
	        }
	    }
	    report(error) {
	        var _a;
	        const pending = this._pendingResult;
	        if (!pending)
	            throw new Error('cell is not being evaluated');
	        pending.errors = (_a = pending.errors) !== null && _a !== void 0 ? _a : [];
	        pending.errors.push(error);
	    }
	    evaluate(core, fn) {
	        const pending = {};
	        this._pendingResult = pending;
	        const lastStatus = this.status;
	        this.status = 'run';
	        this._nextGuard = 0;
	        let rollback = false;
	        try {
	            pending.data = fn.call(core, core);
	        }
	        catch (err) {
	            if (err === exports.ROLLBACK) {
	                rollback = true;
	            }
	            else {
	                this.report(err);
	            }
	        }
	        finally {
	            this._nextGuard = 0;
	            if (!rollback) {
	                this.result = pending;
	                this.status = 'ready';
	            }
	            else {
	                this.status = lastStatus;
	            }
	            this._pendingResult = undefined;
	        }
	    }
	}
	exports.Cell = Cell;

	}(core));

	var featureUrl = {};

	var version$1 = {};

	(function (exports) {
	var __importDefault = (commonjsGlobal && commonjsGlobal.__importDefault) || function (mod) {
	    return (mod && mod.__esModule) ? mod : { "default": mod };
	};
	Object.defineProperty(exports, "__esModule", { value: true });
	exports.Version = exports.ErrVersionParse = void 0;
	const error_1 = __importDefault(error$2);
	const ErrVersionParse = (input) => error_1.default('VersionParse', {
	    message: `expected a version specifier like "v9.8", got "${input}"`,
	    input,
	});
	exports.ErrVersionParse = ErrVersionParse;
	class Version {
	    constructor(major, minor) {
	        this.major = major;
	        this.minor = minor;
	    }
	    static parse(input) {
	        const match = input.match(this.VERSION_RE);
	        if (!match)
	            throw exports.ErrVersionParse(input);
	        return new this(+match[1], +match[2]);
	    }
	    satisfies(required) {
	        const { major, minor } = this;
	        const { major: rMajor, minor: rMinor } = required;
	        return rMajor == major && (major == 0
	            ? rMinor == minor
	            : rMinor <= minor);
	    }
	    get series() {
	        const { major } = this;
	        return major > 0 ? `${major}.x` : String(this);
	    }
	    toString() {
	        return `v${this.major}.${this.minor}`;
	    }
	    equals(other) {
	        return this.major === other.major && this.minor === other.minor;
	    }
	}
	exports.Version = Version;
	Version.VERSION_RE = /^v(\d+)\.(\d+)$/;
	exports.default = Version;

	}(version$1));

	(function (exports) {
	Object.defineProperty(exports, "__esModule", { value: true });
	exports.ErrNoVersion = exports.ErrNoName = exports.ErrNoPath = void 0;
	const url_1 = require$$0__default["default"];
	const version_1 = version$1;
	const error_1 = error$2;
	const ErrNoPath = (url, node) => error_1.err('NoPath', {
	    message: `feature url does not have a path: ${url}`,
	    url,
	    nodes: node ? [node] : undefined
	});
	exports.ErrNoPath = ErrNoPath;
	const ErrNoName = (url, node) => error_1.err('NoName', {
	    message: `feature url does not specify a name: ${url}`,
	    url,
	    nodes: node ? [node] : undefined
	});
	exports.ErrNoName = ErrNoName;
	const ErrNoVersion = (url, node) => error_1.err('NoVersion', {
	    message: `feature url does not specify a version: ${url}`,
	    url,
	    nodes: node ? [node] : undefined
	});
	exports.ErrNoVersion = ErrNoVersion;
	class FeatureUrl {
	    constructor(identity, name, version, element) {
	        this.identity = identity;
	        this.name = name;
	        this.version = version;
	        this.element = element;
	    }
	    static parse(input, node) {
	        const url = new url_1.URL(input);
	        if (!url.pathname || url.pathname === '/')
	            throw exports.ErrNoPath(url, node);
	        const path = url.pathname.split('/');
	        const verStr = path.pop();
	        if (!verStr)
	            throw exports.ErrNoVersion(url, node);
	        const version = version_1.Version.parse(verStr);
	        const name = path[path.length - 1];
	        if (!name)
	            throw exports.ErrNoName(url, node);
	        const element = url.hash ? url.hash.slice(1) : undefined;
	        url.hash = '';
	        url.search = '';
	        url.password = '';
	        url.username = '';
	        url.pathname = path.join('/');
	        return new FeatureUrl(url.toString(), name, version, element);
	    }
	    static decode(node) {
	        return this.parse(node.value, node);
	    }
	    satisfies(requested) {
	        return requested.identity === this.identity &&
	            this.version.satisfies(requested.version);
	    }
	    equals(other) {
	        return this.identity === other.identity &&
	            this.version.equals(other.version);
	    }
	    get url() {
	        return this.element ?
	            `${this.identity}/${this.version}#${this.element}`
	            : `${this.identity}/${this.version}`;
	    }
	    get isDirective() {
	        var _a;
	        return (_a = this.element) === null || _a === void 0 ? void 0 : _a.startsWith('@');
	    }
	    get elementName() {
	        var _a;
	        return this.isDirective ? (_a = this.element) === null || _a === void 0 ? void 0 : _a.slice(1) : this.element;
	    }
	    get base() {
	        if (!this.element)
	            return this;
	        return new FeatureUrl(this.identity, this.name, this.version);
	    }
	    toString() {
	        return this.url;
	    }
	}
	exports.default = FeatureUrl;

	}(featureUrl));

	var features$1 = {};

	var names$1 = {};

	Object.defineProperty(names$1, "__esModule", { value: true });
	names$1.getPrefix = void 0;
	function getPrefix(name, sep = '__') {
	    const idx = name.indexOf(sep);
	    if (idx === -1)
	        return [null, name];
	    return [name.substr(0, idx), name.substr(idx + sep.length)];
	}
	names$1.getPrefix = getPrefix;

	var __importDefault$4 = (commonjsGlobal && commonjsGlobal.__importDefault) || function (mod) {
	    return (mod && mod.__esModule) ? mod : { "default": mod };
	};
	Object.defineProperty(features$1, "__esModule", { value: true });
	features$1.Features = features$1.Feature = void 0;
	const error_1$1 = error$2;
	const feature_url_1$1 = __importDefault$4(featureUrl);
	const names_1$1 = names$1;
	const ErrTooManyFeatureVersions = (features) => error_1$1.err('TooManyFeatureVersions', {
	    message: `too many versions of ${features[0].url.identity} at v${features[0].url.version.series}`,
	    features,
	    major: features[0].url.version.major,
	    nodes: features.map(f => f.directive),
	});
	class Feature {
	    constructor(url, name, directive, purpose) {
	        this.url = url;
	        this.name = name;
	        this.directive = directive;
	        this.purpose = purpose;
	    }
	    canonicalName(docName) {
	        const [prefix, base] = names_1$1.getPrefix(docName);
	        if (prefix) {
	            if (prefix !== this.name)
	                return null;
	            return `${this.url.name}__${base}`;
	        }
	        if (base !== this.name)
	            return null;
	        return this.url.name;
	    }
	}
	features$1.Feature = Feature;
	class Features {
	    constructor() {
	        this.features = new Map;
	    }
	    add(feature) {
	        const majors = this.findOrCreateIdentity(feature.url.identity);
	        const { series } = feature.url.version;
	        const existing = majors.get(series);
	        if (existing != null) {
	            existing.push(feature);
	            return;
	        }
	        majors.set(series, [feature]);
	    }
	    find(feature, exact = false) {
	        var _a, _b;
	        feature = typeof feature === 'string' ? feature_url_1$1.default.parse(feature) : feature;
	        const documentFeature = (_b = (_a = this.features.get(feature.identity)) === null || _a === void 0 ? void 0 : _a.get(feature.version.series)) === null || _b === void 0 ? void 0 : _b[0];
	        if ((exact && (documentFeature === null || documentFeature === void 0 ? void 0 : documentFeature.url.equals(feature))) ||
	            (!exact && (documentFeature === null || documentFeature === void 0 ? void 0 : documentFeature.url.satisfies(feature))))
	            return documentFeature;
	        return null;
	    }
	    documentName(feature, exact = false) {
	        var _a;
	        feature = typeof feature === 'string' ? feature_url_1$1.default.parse(feature) : feature;
	        const found = this.find(feature, exact);
	        if (!found)
	            return null;
	        const element = feature.isDirective ? (_a = feature.element) === null || _a === void 0 ? void 0 : _a.slice(1) : feature.element;
	        if (!element || feature.isDirective && (element === found.url.name))
	            return found.name;
	        return found.name + '__' + element;
	    }
	    *[Symbol.iterator]() {
	        for (const majors of this.features.values()) {
	            for (const features of majors.values()) {
	                yield* features;
	            }
	        }
	    }
	    validate() {
	        const errors = [];
	        for (const [_, majors] of this.features) {
	            for (const [_, features] of majors) {
	                if (features.length <= 1)
	                    continue;
	                errors.push(ErrTooManyFeatureVersions(features));
	            }
	        }
	        return errors;
	    }
	    findOrCreateIdentity(identity) {
	        const existing = this.features.get(identity);
	        if (existing)
	            return existing;
	        const created = new Map();
	        this.features.set(identity, created);
	        return created;
	    }
	}
	features$1.Features = Features;
	features$1.default = Features;

	var is$1 = {};

	(function (exports) {
	Object.defineProperty(exports, "__esModule", { value: true });
	exports.hasDirectives = exports.hasName = exports.isAst = exports.isEmpty = exports.isNonEmpty = exports.asString = exports.isAsString = exports.isTemplate = void 0;
	const knownTemplates = new WeakSet;
	const isTemplate = (args) => knownTemplates.has(args) || !!(Array.isArray(args[0]) &&
	    args[0].every(x => typeof x === 'string') &&
	    args[0].length === args.length &&
	    knownTemplates.add(args[0]));
	exports.isTemplate = isTemplate;
	const isAsString = (args) => exports.isTemplate(args) || (args.length === 1 && typeof args[0] === 'string');
	exports.isAsString = isAsString;
	function asString(input) {
	    return (!exports.isAsString(input)
	        ? undefined
	        :
	            exports.isTemplate(input)
	                ? String.raw(...input)
	                : input[0]);
	}
	exports.asString = asString;
	function isNonEmpty(input) {
	    return !isEmpty(input);
	}
	exports.isNonEmpty = isNonEmpty;
	function isEmpty(input) {
	    return !input.length;
	}
	exports.isEmpty = isEmpty;
	function isAst(obj, ...kinds) {
	    return kinds.indexOf(obj === null || obj === void 0 ? void 0 : obj.kind) !== -1;
	}
	exports.isAst = isAst;
	const hasName = (node) => isAst(node === null || node === void 0 ? void 0 : node.name, 'Name');
	exports.hasName = hasName;
	const hasDirectives = (node) => Array.isArray(node === null || node === void 0 ? void 0 : node.directives);
	exports.hasDirectives = hasDirectives;

	}(is$1));

	var __createBinding = (commonjsGlobal && commonjsGlobal.__createBinding) || (Object.create ? (function(o, m, k, k2) {
	    if (k2 === undefined) k2 = k;
	    Object.defineProperty(o, k2, { enumerable: true, get: function() { return m[k]; } });
	}) : (function(o, m, k, k2) {
	    if (k2 === undefined) k2 = k;
	    o[k2] = m[k];
	}));
	var __setModuleDefault = (commonjsGlobal && commonjsGlobal.__setModuleDefault) || (Object.create ? (function(o, v) {
	    Object.defineProperty(o, "default", { enumerable: true, value: v });
	}) : function(o, v) {
	    o["default"] = v;
	});
	var __importStar = (commonjsGlobal && commonjsGlobal.__importStar) || function (mod) {
	    if (mod && mod.__esModule) return mod;
	    var result = {};
	    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
	    __setModuleDefault(result, mod);
	    return result;
	};
	var __importDefault$3 = (commonjsGlobal && commonjsGlobal.__importDefault) || function (mod) {
	    return (mod && mod.__esModule) ? mod : { "default": mod };
	};
	Object.defineProperty(schema$1, "__esModule", { value: true });
	schema$1.names = schema$1.features = schema$1.schema = schema$1.CoreSchema = void 0;
	const graphql_1$c = require$$2$1;
	const values_1$2 = require$$1$2;
	const core_1 = __importDefault$3(core);
	const error_1 = error$2;
	const feature_url_1 = __importDefault$3(featureUrl);
	const features_1 = __importStar(features$1);
	const is_1 = is$1;
	const names_1 = names$1;
	const ErrExtraSchema = (def) => error_1.err('ExtraSchema', {
	    message: 'extra schema definition ignored',
	    nodes: [def]
	});
	const ErrNoSchema = () => error_1.err('NoSchema', 'no schema definitions found');
	const ErrNoCore = (causes) => error_1.err('NoCore', {
	    message: 'no core feature found',
	    causes
	});
	const ErrBadFeature = (node, ...causes) => error_1.err('BadFeature', {
	    message: 'bad core feature request',
	    nodes: [node],
	    causes
	});
	const ErrOverlappingNames = (name, features) => error_1.err('OverlappingNames', {
	    message: `the name "${name}" is defined by multiple features`,
	    nodes: features.map(f => f.directive)
	});
	class CoreSchema extends core_1.default {
	    static graphql(parts, ...replacements) {
	        return CoreSchema.fromSource(new graphql_1$c.Source(String.raw.call(null, parts, ...replacements), '(inline graphql)'));
	    }
	    static fromSource(source) {
	        return new CoreSchema(graphql_1$c.parse(source));
	    }
	    check(...fns) {
	        if (!fns.length)
	            fns = [features, names];
	        return super.check(...fns);
	    }
	    get document() { return this.data; }
	    get schema() { return this.get(schema); }
	    get features() { return this.get(features); }
	    get names() { return this.get(names); }
	    *read(directive, node) {
	        var _a;
	        const url = directive instanceof feature_url_1.default ? directive
	            : typeof directive === 'string' ? feature_url_1.default.parse(directive)
	                : feature_url_1.default.parse((_a = directive.extensions) === null || _a === void 0 ? void 0 : _a.specifiedBy);
	        const name = this.features.documentName(url);
	        const feature = this.features.find(url);
	        const match = url.isDirective
	            ? (dir) => dir.name.value === name
	            : (dir) => this.featureFor(dir) === feature;
	        if (!is_1.hasDirectives(node))
	            return;
	        if (!feature)
	            return;
	        for (const d of node.directives) {
	            if (match(d)) {
	                const data = directive instanceof graphql_1$c.GraphQLDirective
	                    ? values_1$2.getArgumentValues(directive, d)
	                    : undefined;
	                const item = {
	                    node,
	                    directive: d,
	                    feature,
	                    canonicalName: '@' + (feature === null || feature === void 0 ? void 0 : feature.canonicalName(d.name.value)),
	                };
	                if (data != null)
	                    item.data = data;
	                yield item;
	            }
	        }
	    }
	    featureFor(node) {
	        if (!is_1.hasName(node))
	            return;
	        const [prefix] = names_1.getPrefix(node.name.value);
	        if (prefix || is_1.isAst(node, 'Directive', 'DirectiveDefinition')) {
	            return this.names.get(prefix !== null && prefix !== void 0 ? prefix : node.name.value);
	        }
	        return;
	    }
	}
	schema$1.CoreSchema = CoreSchema;
	schema$1.default = CoreSchema;
	function schema() {
	    let schema = null;
	    for (const def of this.document.definitions) {
	        if (def.kind === 'SchemaDefinition') {
	            if (!schema)
	                schema = def;
	            else
	                this.report(ErrExtraSchema(def));
	        }
	    }
	    if (!schema) {
	        throw ErrNoSchema();
	    }
	    return schema;
	}
	schema$1.schema = schema;
	function features() {
	    var _a, _b, _c, _d;
	    const schema = this.schema;
	    this.pure(...(_a = schema.directives) !== null && _a !== void 0 ? _a : []);
	    const noCoreErrors = [];
	    let coreFeature = null;
	    const features = new features_1.default;
	    for (const d of schema.directives || []) {
	        if (!coreFeature)
	            try {
	                const candidate = values_1$2.getArgumentValues($core, d);
	                if (CORE_VERSIONS.has(candidate.feature) &&
	                    d.name.value === ((_b = candidate.as) !== null && _b !== void 0 ? _b : 'core')) {
	                    const url = feature_url_1.default.parse(candidate.feature);
	                    coreFeature = new features_1.Feature(url, (_c = candidate.as) !== null && _c !== void 0 ? _c : url.name, d);
	                }
	            }
	            catch (err) {
	                noCoreErrors.push(err);
	            }
	        if (coreFeature && d.name.value === coreFeature.name)
	            try {
	                const values = values_1$2.getArgumentValues($core, d);
	                const url = feature_url_1.default.parse(values.feature);
	                features.add(new features_1.Feature(url, (_d = values.as) !== null && _d !== void 0 ? _d : url.name, d, values.for));
	            }
	            catch (err) {
	                this.report(ErrBadFeature(d, err));
	            }
	    }
	    if (!coreFeature)
	        throw ErrNoCore(noCoreErrors);
	    this.report(...features.validate());
	    return features;
	}
	schema$1.features = features;
	function names() {
	    var _a;
	    const { features } = this;
	    this.pure(features);
	    const names = new Map;
	    for (const feature of features) {
	        if (!names.has(feature.name))
	            names.set(feature.name, []);
	        (_a = names.get(feature.name)) === null || _a === void 0 ? void 0 : _a.push(feature);
	    }
	    const output = new Map;
	    for (const [name, features] of names) {
	        if (features.length > 1) {
	            this.report(ErrOverlappingNames(name, features));
	            continue;
	        }
	        output.set(name, features[0]);
	    }
	    return output;
	}
	schema$1.names = names;
	const CORE_VERSIONS = new Set([
	    'https://specs.apollo.dev/core/v0.1',
	    'https://specs.apollo.dev/core/v0.2',
	]);
	const Purpose = new graphql_1$c.GraphQLEnumType({
	    name: 'core__Purpose',
	    values: {
	        SECURITY: {},
	        EXECUTION: {},
	    },
	});
	const $core = new graphql_1$c.GraphQLDirective({
	    name: '@core',
	    args: {
	        feature: { type: graphql_1$c.GraphQLNonNull(graphql_1$c.GraphQLString), },
	        as: { type: graphql_1$c.GraphQLString },
	        'for': { type: Purpose }
	    },
	    locations: ['SCHEMA'],
	    isRepeatable: true,
	});

	(function (exports) {
	var __createBinding = (commonjsGlobal && commonjsGlobal.__createBinding) || (Object.create ? (function(o, m, k, k2) {
	    if (k2 === undefined) k2 = k;
	    Object.defineProperty(o, k2, { enumerable: true, get: function() { return m[k]; } });
	}) : (function(o, m, k, k2) {
	    if (k2 === undefined) k2 = k;
	    o[k2] = m[k];
	}));
	var __exportStar = (commonjsGlobal && commonjsGlobal.__exportStar) || function(m, exports) {
	    for (var p in m) if (p !== "default" && !Object.prototype.hasOwnProperty.call(exports, p)) __createBinding(exports, m, p);
	};
	Object.defineProperty(exports, "__esModule", { value: true });
	exports.err = exports.Core = exports.Features = exports.Feature = exports.Version = void 0;
	__exportStar(schema$1, exports);
	var version_1 = version$1;
	Object.defineProperty(exports, "Version", { enumerable: true, get: function () { return version_1.Version; } });
	var features_1 = features$1;
	Object.defineProperty(exports, "Feature", { enumerable: true, get: function () { return features_1.Feature; } });
	Object.defineProperty(exports, "Features", { enumerable: true, get: function () { return features_1.Features; } });
	var core_1 = core;
	Object.defineProperty(exports, "Core", { enumerable: true, get: function () { return core_1.Core; } });
	var error_1 = error$2;
	Object.defineProperty(exports, "err", { enumerable: true, get: function () { return error_1.err; } });

	}(dist$1));

	(function (exports) {
	Object.defineProperty(exports, "__esModule", { value: true });
	exports.removeFeatureElements = exports.CORE_VERSIONS = exports.FeatureUrl = exports.FeatureVersion = exports.FeatureDefinitions = exports.CoreSpecDefinition = exports.isCoreSpecDirectiveApplication = exports.FeatureDefinition = exports.corePurposes = exports.ErrCoreCheckFailed = exports.coreIdentity = void 0;
	const graphql_1 = require$$2$1;
	const url_1 = require$$0__default["default"];
	const definitions_1 = definitions;
	const types_1 = types;
	const core_schema_1 = dist$1;
	exports.coreIdentity = 'https://specs.apollo.dev/core';
	const ErrCoreCheckFailed = (causes) => (0, core_schema_1.err)('CheckFailed', {
	    message: 'one or more checks failed',
	    causes
	});
	exports.ErrCoreCheckFailed = ErrCoreCheckFailed;
	function buildError(message) {
	    return new Error(message);
	}
	exports.corePurposes = [
	    'SECURITY',
	    'EXECUTION',
	];
	function purposesDescription(purpose) {
	    switch (purpose) {
	        case 'SECURITY': return "`SECURITY` features provide metadata necessary to securely resolve fields.";
	        case 'EXECUTION': return "`EXECUTION` features provide metadata necessary for operation execution.";
	    }
	}
	class FeatureDefinition {
	    constructor(url) {
	        this.url = typeof url === 'string' ? FeatureUrl.parse(url) : url;
	    }
	    get identity() {
	        return this.url.identity;
	    }
	    get version() {
	        return this.url.version;
	    }
	    isSpecType(type) {
	        const nameInSchema = this.nameInSchema(type.schema());
	        return nameInSchema !== undefined && type.name.startsWith(`${nameInSchema}__`);
	    }
	    isSpecDirective(directive) {
	        const nameInSchema = this.nameInSchema(directive.schema());
	        return nameInSchema != undefined && (directive.name === nameInSchema || directive.name.startsWith(`${nameInSchema}__`));
	    }
	    nameInSchema(schema) {
	        const feature = this.featureInSchema(schema);
	        return feature === null || feature === void 0 ? void 0 : feature.nameInSchema;
	    }
	    elementNameInSchema(schema, elementName) {
	        const nameInSchema = this.nameInSchema(schema);
	        return nameInSchema
	            ? (elementName === nameInSchema ? nameInSchema : `${nameInSchema}__${elementName}`)
	            : undefined;
	    }
	    rootDirective(schema) {
	        const name = this.nameInSchema(schema);
	        return name ? schema.directive(name) : undefined;
	    }
	    directive(schema, elementName) {
	        const name = this.elementNameInSchema(schema, elementName);
	        return name ? schema.directive(name) : undefined;
	    }
	    type(schema, elementName) {
	        const name = this.elementNameInSchema(schema, elementName);
	        return name ? schema.type(name) : undefined;
	    }
	    addRootDirective(schema) {
	        return schema.addDirectiveDefinition(this.nameInSchema(schema));
	    }
	    addDirective(schema, name) {
	        return schema.addDirectiveDefinition(this.elementNameInSchema(schema, name));
	    }
	    addScalarType(schema, name) {
	        return schema.addType(new definitions_1.ScalarType(this.elementNameInSchema(schema, name)));
	    }
	    addEnumType(schema, name) {
	        return schema.addType(new definitions_1.EnumType(this.elementNameInSchema(schema, name)));
	    }
	    featureInSchema(schema) {
	        const features = schema.coreFeatures;
	        if (!features) {
	            throw buildError(`Schema is not a core schema (add @core first)`);
	        }
	        return features.getByIdentity(this.identity);
	    }
	    toString() {
	        return `${this.identity}/${this.version}`;
	    }
	}
	exports.FeatureDefinition = FeatureDefinition;
	function isCoreSpecDirectiveApplication(directive) {
	    var _a;
	    const definition = directive.definition;
	    if (!definition) {
	        return false;
	    }
	    const featureArg = definition.argument('feature');
	    if (!featureArg || !(0, types_1.sameType)(featureArg.type, new definitions_1.NonNullType(directive.schema().stringType()))) {
	        return false;
	    }
	    const asArg = definition.argument('as');
	    if (asArg && !(0, types_1.sameType)(asArg.type, directive.schema().stringType())) {
	        return false;
	    }
	    if (!definition.repeatable || definition.locations.length !== 1 || definition.locations[0] !== graphql_1.DirectiveLocation.SCHEMA) {
	        return false;
	    }
	    const args = directive.arguments();
	    try {
	        const url = FeatureUrl.parse(args.feature);
	        return url.identity === exports.coreIdentity && directive.name === ((_a = args.as) !== null && _a !== void 0 ? _a : 'core');
	    }
	    catch (err) {
	        return false;
	    }
	}
	exports.isCoreSpecDirectiveApplication = isCoreSpecDirectiveApplication;
	class CoreSpecDefinition extends FeatureDefinition {
	    constructor(version) {
	        super(new FeatureUrl(exports.coreIdentity, 'core', version));
	    }
	    addElementsToSchema(_) {
	    }
	    addToSchema(schema, as) {
	        const existing = schema.coreFeatures;
	        if (existing) {
	            if (existing.coreItself.url.identity === this.identity) {
	                return;
	            }
	            else {
	                throw buildError(`Cannot add feature ${this} to the schema, it already uses ${existing.coreItself.url}`);
	            }
	        }
	        const nameInSchema = as !== null && as !== void 0 ? as : this.url.name;
	        const core = schema.addDirectiveDefinition(nameInSchema).addLocations(graphql_1.DirectiveLocation.SCHEMA);
	        core.repeatable = true;
	        core.addArgument('feature', new definitions_1.NonNullType(schema.stringType()));
	        core.addArgument('as', schema.stringType());
	        if (this.supportPurposes()) {
	            const purposeEnum = schema.addType(new definitions_1.EnumType(`${nameInSchema}__Purpose`));
	            for (const purpose of exports.corePurposes) {
	                purposeEnum.addValue(purpose).description = purposesDescription(purpose);
	            }
	            core.addArgument('for', purposeEnum);
	        }
	        const args = { feature: this.toString() };
	        if (as) {
	            args.as = as;
	        }
	        schema.schemaDefinition.applyDirective(nameInSchema, args);
	    }
	    supportPurposes() {
	        return this.version.strictlyGreaterThan(new FeatureVersion(0, 1));
	    }
	    extractFeature(schema) {
	        const features = schema.coreFeatures;
	        if (!features) {
	            throw buildError(`Schema is not a core schema (add @core first)`);
	        }
	        if (!features.coreItself.url.version.equals(this.version)) {
	            throw buildError(`Cannot use this version of @core (${this.version}), the schema uses version ${features.coreItself.url.version}`);
	        }
	        return features.coreItself;
	    }
	    coreDirective(schema) {
	        const feature = this.extractFeature(schema);
	        const directive = schema.directive(feature.nameInSchema);
	        return directive;
	    }
	    coreVersion(schema) {
	        const feature = this.extractFeature(schema);
	        return feature.url.version;
	    }
	    applyFeatureToSchema(schema, feature, as, purpose) {
	        const coreDirective = this.coreDirective(schema);
	        const args = {
	            feature: feature.toString(),
	            as,
	        };
	        if (this.supportPurposes() && purpose) {
	            args.for = purpose;
	        }
	        schema.schemaDefinition.applyDirective(coreDirective, args);
	        feature.addElementsToSchema(schema);
	    }
	}
	exports.CoreSpecDefinition = CoreSpecDefinition;
	class FeatureDefinitions {
	    constructor(identity) {
	        this.identity = identity;
	        this._definitions = [];
	    }
	    add(definition) {
	        if (definition.identity !== this.identity) {
	            throw buildError(`Cannot add definition for ${definition} to the versions of definitions for ${this.identity}`);
	        }
	        if (this._definitions.find(def => definition.version.equals(def.version))) {
	            return this;
	        }
	        this._definitions.push(definition);
	        this._definitions.sort((def1, def2) => -def1.version.compareTo(def2.version));
	        return this;
	    }
	    find(requested) {
	        return this._definitions.find(def => def.version.satisfies(requested));
	    }
	    versions() {
	        return this._definitions.map(def => def.version);
	    }
	    latest() {
	        return this._definitions[0];
	    }
	}
	exports.FeatureDefinitions = FeatureDefinitions;
	class FeatureVersion {
	    constructor(major, minor) {
	        this.major = major;
	        this.minor = minor;
	    }
	    static parse(input) {
	        const match = input.match(this.VERSION_RE);
	        if (!match) {
	            throw new graphql_1.GraphQLError(`Expected a version string (of the form v1.2), got ${input}`);
	        }
	        return new this(+match[1], +match[2]);
	    }
	    satisfies(required) {
	        const { major, minor } = this;
	        const { major: rMajor, minor: rMinor } = required;
	        return rMajor == major && (major == 0
	            ? rMinor == minor
	            : rMinor <= minor);
	    }
	    get series() {
	        const { major } = this;
	        return major > 0 ? `${major}.x` : String(this);
	    }
	    compareTo(other) {
	        if (this.major > other.major) {
	            return 1;
	        }
	        if (this.major < other.major) {
	            return -1;
	        }
	        if (this.minor > other.minor) {
	            return 1;
	        }
	        if (this.minor < other.minor) {
	            return -1;
	        }
	        return 0;
	    }
	    strictlyGreaterThan(version) {
	        return this.compareTo(version) > 0;
	    }
	    toString() {
	        return `v${this.major}.${this.minor}`;
	    }
	    equals(other) {
	        return this.major === other.major && this.minor === other.minor;
	    }
	}
	exports.FeatureVersion = FeatureVersion;
	FeatureVersion.VERSION_RE = /^v(\d+)\.(\d+)$/;
	class FeatureUrl {
	    constructor(identity, name, version, element) {
	        this.identity = identity;
	        this.name = name;
	        this.version = version;
	        this.element = element;
	    }
	    static parse(input, node) {
	        const url = new url_1.URL(input);
	        if (!url.pathname || url.pathname === '/') {
	            throw new graphql_1.GraphQLError(`Missing path in feature url '${url}'`, node);
	        }
	        const path = url.pathname.split('/');
	        const verStr = path.pop();
	        if (!verStr) {
	            throw new graphql_1.GraphQLError(`Missing version component in feature url '${url}'`, node);
	        }
	        const version = FeatureVersion.parse(verStr);
	        const name = path[path.length - 1];
	        if (!name) {
	            throw new graphql_1.GraphQLError(`Missing feature name component in feature url '${url}'`, node);
	        }
	        const element = url.hash ? url.hash.slice(1) : undefined;
	        url.hash = '';
	        url.search = '';
	        url.password = '';
	        url.username = '';
	        url.pathname = path.join('/');
	        return new FeatureUrl(url.toString(), name, version, element);
	    }
	    static decode(node) {
	        return this.parse(node.value, node);
	    }
	    satisfies(requested) {
	        return requested.identity === this.identity &&
	            this.version.satisfies(requested.version);
	    }
	    equals(other) {
	        return this.identity === other.identity &&
	            this.version.equals(other.version);
	    }
	    get url() {
	        return this.element ?
	            `${this.identity}/${this.version}#${this.element}`
	            : `${this.identity}/${this.version}`;
	    }
	    get isDirective() {
	        var _a;
	        return (_a = this.element) === null || _a === void 0 ? void 0 : _a.startsWith('@');
	    }
	    get elementName() {
	        var _a;
	        return this.isDirective ? (_a = this.element) === null || _a === void 0 ? void 0 : _a.slice(1) : this.element;
	    }
	    get base() {
	        if (!this.element)
	            return this;
	        return new FeatureUrl(this.identity, this.name, this.version);
	    }
	    toString() {
	        return this.url;
	    }
	}
	exports.FeatureUrl = FeatureUrl;
	exports.CORE_VERSIONS = new FeatureDefinitions(exports.coreIdentity)
	    .add(new CoreSpecDefinition(new FeatureVersion(0, 1)))
	    .add(new CoreSpecDefinition(new FeatureVersion(0, 2)));
	function removeFeatureElements(schema, feature) {
	    const featureDirectives = schema.directives().filter(d => feature.isFeatureDefinition(d));
	    featureDirectives.forEach(d => d.remove().forEach(application => application.remove()));
	    const featureTypes = schema.types().filter(t => feature.isFeatureDefinition(t));
	    featureTypes.forEach(type => {
	        const references = type.remove();
	        if (references.length > 0) {
	            throw new graphql_1.GraphQLError(`Cannot remove elements of feature ${feature} as feature type ${type} is referenced by elements: ${references.join(', ')}`, references.map(r => r.sourceAST).filter(n => n !== undefined));
	        }
	    });
	}
	exports.removeFeatureElements = removeFeatureElements;

	}(coreSpec$1));

	var utils = {};

	Object.defineProperty(utils, "__esModule", { value: true });
	utils.copyWitNewLength = utils.MapWithCachedArrays = utils.setValues = utils.mapEntries = utils.mapKeys = utils.mapValues = utils.firstOf = utils.arrayEquals = utils.MultiMap = utils.assertUnreachable = utils.assert = void 0;
	function assert(condition, message) {
	    if (!condition) {
	        throw new Error(typeof message === 'string' ? message : message());
	    }
	}
	utils.assert = assert;
	function assertUnreachable(_) {
	    throw new Error("Didn't expect to get here");
	}
	utils.assertUnreachable = assertUnreachable;
	class MultiMap extends Map {
	    add(key, value) {
	        const values = this.get(key);
	        if (values) {
	            values.push(value);
	        }
	        else {
	            this.set(key, [value]);
	        }
	        return this;
	    }
	}
	utils.MultiMap = MultiMap;
	function arrayEquals(a, b, equalFct) {
	    if (a === b) {
	        return true;
	    }
	    if (a.length !== b.length) {
	        return false;
	    }
	    for (let i = 0; i < a.length; ++i) {
	        const eltEqual = equalFct ? equalFct(a[i], b[i]) : a[i] === b[i];
	        if (!eltEqual) {
	            return false;
	        }
	    }
	    return true;
	}
	utils.arrayEquals = arrayEquals;
	function firstOf(iterable) {
	    const res = iterable[Symbol.iterator]().next();
	    return res.done ? undefined : res.value;
	}
	utils.firstOf = firstOf;
	function mapValues(map) {
	    const array = new Array(map.size);
	    let i = 0;
	    for (const v of map.values()) {
	        array[i++] = v;
	    }
	    return array;
	}
	utils.mapValues = mapValues;
	function mapKeys(map) {
	    const array = new Array(map.size);
	    let i = 0;
	    for (const k of map.keys()) {
	        array[i++] = k;
	    }
	    return array;
	}
	utils.mapKeys = mapKeys;
	function mapEntries(map) {
	    const array = new Array(map.size);
	    let i = 0;
	    for (const entry of map.entries()) {
	        array[i++] = entry;
	    }
	    return array;
	}
	utils.mapEntries = mapEntries;
	function setValues(set) {
	    const array = new Array(set.size);
	    let i = 0;
	    for (const v of set.values()) {
	        array[i++] = v;
	    }
	    return array;
	}
	utils.setValues = setValues;
	class MapWithCachedArrays {
	    constructor() {
	        this.map = new Map();
	    }
	    clearCaches() {
	        this.cachedKeys = undefined;
	        this.cachedValues = undefined;
	    }
	    get size() {
	        return this.map.size;
	    }
	    has(key) {
	        return this.map.has(key);
	    }
	    get(key) {
	        return this.map.get(key);
	    }
	    set(key, value) {
	        this.map.set(key, value);
	        this.clearCaches();
	        return this;
	    }
	    delete(key) {
	        const deleted = this.map.delete(key);
	        if (deleted) {
	            this.clearCaches();
	        }
	        return deleted;
	    }
	    clear() {
	        this.map.clear();
	        this.clearCaches();
	    }
	    keys() {
	        if (!this.cachedKeys) {
	            this.cachedKeys = mapKeys(this.map);
	        }
	        return this.cachedKeys;
	    }
	    values() {
	        if (!this.cachedValues) {
	            this.cachedValues = mapValues(this.map);
	        }
	        return this.cachedValues;
	    }
	}
	utils.MapWithCachedArrays = MapWithCachedArrays;
	function copyWitNewLength(arr, newLength) {
	    assert(newLength >= arr.length, () => `${newLength} < ${arr.length}`);
	    const copy = new Array(newLength);
	    for (let i = 0; i < arr.length; i++) {
	        copy[i] = arr[i];
	    }
	    return copy;
	}
	utils.copyWitNewLength = copyWitNewLength;

	var values = {};

	var suggestions = {};

	var jsLevenshtein = (function()
	{
	  function _min(d0, d1, d2, bx, ay)
	  {
	    return d0 < d1 || d2 < d1
	        ? d0 > d2
	            ? d2 + 1
	            : d0 + 1
	        : bx === ay
	            ? d1
	            : d1 + 1;
	  }

	  return function(a, b)
	  {
	    if (a === b) {
	      return 0;
	    }

	    if (a.length > b.length) {
	      var tmp = a;
	      a = b;
	      b = tmp;
	    }

	    var la = a.length;
	    var lb = b.length;

	    while (la > 0 && (a.charCodeAt(la - 1) === b.charCodeAt(lb - 1))) {
	      la--;
	      lb--;
	    }

	    var offset = 0;

	    while (offset < la && (a.charCodeAt(offset) === b.charCodeAt(offset))) {
	      offset++;
	    }

	    la -= offset;
	    lb -= offset;

	    if (la === 0 || lb < 3) {
	      return lb;
	    }

	    var x = 0;
	    var y;
	    var d0;
	    var d1;
	    var d2;
	    var d3;
	    var dd;
	    var dy;
	    var ay;
	    var bx0;
	    var bx1;
	    var bx2;
	    var bx3;

	    var vector = [];

	    for (y = 0; y < la; y++) {
	      vector.push(y + 1);
	      vector.push(a.charCodeAt(offset + y));
	    }

	    var len = vector.length - 1;

	    for (; x < lb - 3;) {
	      bx0 = b.charCodeAt(offset + (d0 = x));
	      bx1 = b.charCodeAt(offset + (d1 = x + 1));
	      bx2 = b.charCodeAt(offset + (d2 = x + 2));
	      bx3 = b.charCodeAt(offset + (d3 = x + 3));
	      dd = (x += 4);
	      for (y = 0; y < len; y += 2) {
	        dy = vector[y];
	        ay = vector[y + 1];
	        d0 = _min(dy, d0, d1, bx0, ay);
	        d1 = _min(d0, d1, d2, bx1, ay);
	        d2 = _min(d1, d2, d3, bx2, ay);
	        dd = _min(d2, d3, dd, bx3, ay);
	        vector[y] = dd;
	        d3 = d2;
	        d2 = d1;
	        d1 = d0;
	        d0 = dy;
	      }
	    }

	    for (; x < lb;) {
	      bx0 = b.charCodeAt(offset + (d0 = x));
	      dd = ++x;
	      for (y = 0; y < len; y += 2) {
	        dy = vector[y];
	        vector[y] = dd = _min(dy, d0, dd, bx0, vector[y + 1]);
	        d0 = dy;
	      }
	    }

	    return dd;
	  };
	})();

	var __importDefault$2 = (commonjsGlobal && commonjsGlobal.__importDefault) || function (mod) {
	    return (mod && mod.__esModule) ? mod : { "default": mod };
	};
	Object.defineProperty(suggestions, "__esModule", { value: true });
	suggestions.didYouMean = suggestions.suggestionList = void 0;
	const js_levenshtein_1 = __importDefault$2(jsLevenshtein);
	const utils_1$3 = utils;
	function suggestionList(input, options) {
	    const optionsByDistance = new Map();
	    const threshold = Math.floor(input.length * 0.4) + 1;
	    const inputLowerCase = input.toLowerCase();
	    for (const option of options) {
	        const distance = inputLowerCase === option.toLowerCase()
	            ? 1
	            : (0, js_levenshtein_1.default)(input, option);
	        if (distance <= threshold) {
	            optionsByDistance.set(option, distance);
	        }
	    }
	    return (0, utils_1$3.mapKeys)(optionsByDistance).sort((a, b) => {
	        const distanceDiff = optionsByDistance.get(a) - optionsByDistance.get(b);
	        return distanceDiff !== 0 ? distanceDiff : a.localeCompare(b);
	    });
	}
	suggestions.suggestionList = suggestionList;
	const MAX_SUGGESTIONS = 5;
	function didYouMean(suggestions) {
	    let message = ' Did you mean ';
	    const quotedSuggestions = suggestions.map((x) => `"${x}"`);
	    switch (suggestions.length) {
	        case 0:
	            return '';
	        case 1:
	            return message + quotedSuggestions[0] + '?';
	        case 2:
	            return message + quotedSuggestions[0] + ' or ' + quotedSuggestions[1] + '?';
	    }
	    const selected = quotedSuggestions.slice(0, MAX_SUGGESTIONS);
	    const lastItem = selected.pop();
	    return message + selected.join(', ') + ', or ' + lastItem + '?';
	}
	suggestions.didYouMean = didYouMean;

	// shim for using process in browser
	// based off https://github.com/defunctzombie/node-process/blob/master/browser.js

	function defaultSetTimout() {
	    throw new Error('setTimeout has not been defined');
	}
	function defaultClearTimeout () {
	    throw new Error('clearTimeout has not been defined');
	}
	var cachedSetTimeout = defaultSetTimout;
	var cachedClearTimeout = defaultClearTimeout;
	if (typeof global.setTimeout === 'function') {
	    cachedSetTimeout = setTimeout;
	}
	if (typeof global.clearTimeout === 'function') {
	    cachedClearTimeout = clearTimeout;
	}

	function runTimeout(fun) {
	    if (cachedSetTimeout === setTimeout) {
	        //normal enviroments in sane situations
	        return setTimeout(fun, 0);
	    }
	    // if setTimeout wasn't available but was latter defined
	    if ((cachedSetTimeout === defaultSetTimout || !cachedSetTimeout) && setTimeout) {
	        cachedSetTimeout = setTimeout;
	        return setTimeout(fun, 0);
	    }
	    try {
	        // when when somebody has screwed with setTimeout but no I.E. maddness
	        return cachedSetTimeout(fun, 0);
	    } catch(e){
	        try {
	            // When we are in I.E. but the script has been evaled so I.E. doesn't trust the global object when called normally
	            return cachedSetTimeout.call(null, fun, 0);
	        } catch(e){
	            // same as above but when it's a version of I.E. that must have the global object for 'this', hopfully our context correct otherwise it will throw a global error
	            return cachedSetTimeout.call(this, fun, 0);
	        }
	    }


	}
	function runClearTimeout(marker) {
	    if (cachedClearTimeout === clearTimeout) {
	        //normal enviroments in sane situations
	        return clearTimeout(marker);
	    }
	    // if clearTimeout wasn't available but was latter defined
	    if ((cachedClearTimeout === defaultClearTimeout || !cachedClearTimeout) && clearTimeout) {
	        cachedClearTimeout = clearTimeout;
	        return clearTimeout(marker);
	    }
	    try {
	        // when when somebody has screwed with setTimeout but no I.E. maddness
	        return cachedClearTimeout(marker);
	    } catch (e){
	        try {
	            // When we are in I.E. but the script has been evaled so I.E. doesn't  trust the global object when called normally
	            return cachedClearTimeout.call(null, marker);
	        } catch (e){
	            // same as above but when it's a version of I.E. that must have the global object for 'this', hopfully our context correct otherwise it will throw a global error.
	            // Some versions of I.E. have different rules for clearTimeout vs setTimeout
	            return cachedClearTimeout.call(this, marker);
	        }
	    }



	}
	var queue = [];
	var draining = false;
	var currentQueue;
	var queueIndex = -1;

	function cleanUpNextTick() {
	    if (!draining || !currentQueue) {
	        return;
	    }
	    draining = false;
	    if (currentQueue.length) {
	        queue = currentQueue.concat(queue);
	    } else {
	        queueIndex = -1;
	    }
	    if (queue.length) {
	        drainQueue();
	    }
	}

	function drainQueue() {
	    if (draining) {
	        return;
	    }
	    var timeout = runTimeout(cleanUpNextTick);
	    draining = true;

	    var len = queue.length;
	    while(len) {
	        currentQueue = queue;
	        queue = [];
	        while (++queueIndex < len) {
	            if (currentQueue) {
	                currentQueue[queueIndex].run();
	            }
	        }
	        queueIndex = -1;
	        len = queue.length;
	    }
	    currentQueue = null;
	    draining = false;
	    runClearTimeout(timeout);
	}
	function nextTick(fun) {
	    var args = new Array(arguments.length - 1);
	    if (arguments.length > 1) {
	        for (var i = 1; i < arguments.length; i++) {
	            args[i - 1] = arguments[i];
	        }
	    }
	    queue.push(new Item(fun, args));
	    if (queue.length === 1 && !draining) {
	        runTimeout(drainQueue);
	    }
	}
	// v8 likes predictible objects
	function Item(fun, array) {
	    this.fun = fun;
	    this.array = array;
	}
	Item.prototype.run = function () {
	    this.fun.apply(null, this.array);
	};
	var title = 'browser';
	var platform$1 = 'browser';
	var browser = true;
	var env$1 = {};
	var argv = [];
	var version = ''; // empty string to avoid regexp issues
	var versions = {};
	var release$1 = {};
	var config = {};

	function noop$1() {}

	var on = noop$1;
	var addListener = noop$1;
	var once = noop$1;
	var off = noop$1;
	var removeListener = noop$1;
	var removeAllListeners = noop$1;
	var emit = noop$1;

	function binding(name) {
	    throw new Error('process.binding is not supported');
	}

	function cwd () { return '/' }
	function chdir (dir) {
	    throw new Error('process.chdir is not supported');
	}function umask() { return 0; }

	// from https://github.com/kumavis/browser-process-hrtime/blob/master/index.js
	var performance = global.performance || {};
	var performanceNow =
	  performance.now        ||
	  performance.mozNow     ||
	  performance.msNow      ||
	  performance.oNow       ||
	  performance.webkitNow  ||
	  function(){ return (new Date()).getTime() };

	// generate timestamp or delta
	// see http://nodejs.org/api/process.html#process_process_hrtime
	function hrtime(previousTimestamp){
	  var clocktime = performanceNow.call(performance)*1e-3;
	  var seconds = Math.floor(clocktime);
	  var nanoseconds = Math.floor((clocktime%1)*1e9);
	  if (previousTimestamp) {
	    seconds = seconds - previousTimestamp[0];
	    nanoseconds = nanoseconds - previousTimestamp[1];
	    if (nanoseconds<0) {
	      seconds--;
	      nanoseconds += 1e9;
	    }
	  }
	  return [seconds,nanoseconds]
	}

	var startTime = new Date();
	function uptime$1() {
	  var currentTime = new Date();
	  var dif = currentTime - startTime;
	  return dif / 1000;
	}

	var browser$1 = {
	  nextTick: nextTick,
	  title: title,
	  browser: browser,
	  env: env$1,
	  argv: argv,
	  version: version,
	  versions: versions,
	  on: on,
	  addListener: addListener,
	  once: once,
	  off: off,
	  removeListener: removeListener,
	  removeAllListeners: removeAllListeners,
	  emit: emit,
	  binding: binding,
	  cwd: cwd,
	  chdir: chdir,
	  umask: umask,
	  hrtime: hrtime,
	  platform: platform$1,
	  release: release$1,
	  config: config,
	  uptime: uptime$1
	};

	var process$1 = browser$1;

	var inherits;
	if (typeof Object.create === 'function'){
	  inherits = function inherits(ctor, superCtor) {
	    // implementation from standard node.js 'util' module
	    ctor.super_ = superCtor;
	    ctor.prototype = Object.create(superCtor.prototype, {
	      constructor: {
	        value: ctor,
	        enumerable: false,
	        writable: true,
	        configurable: true
	      }
	    });
	  };
	} else {
	  inherits = function inherits(ctor, superCtor) {
	    ctor.super_ = superCtor;
	    var TempCtor = function () {};
	    TempCtor.prototype = superCtor.prototype;
	    ctor.prototype = new TempCtor();
	    ctor.prototype.constructor = ctor;
	  };
	}
	var inherits$1 = inherits;

	// Copyright Joyent, Inc. and other Node contributors.
	var formatRegExp = /%[sdj%]/g;
	function format(f) {
	  if (!isString$3(f)) {
	    var objects = [];
	    for (var i = 0; i < arguments.length; i++) {
	      objects.push(inspect$1(arguments[i]));
	    }
	    return objects.join(' ');
	  }

	  var i = 1;
	  var args = arguments;
	  var len = args.length;
	  var str = String(f).replace(formatRegExp, function(x) {
	    if (x === '%%') return '%';
	    if (i >= len) return x;
	    switch (x) {
	      case '%s': return String(args[i++]);
	      case '%d': return Number(args[i++]);
	      case '%j':
	        try {
	          return JSON.stringify(args[i++]);
	        } catch (_) {
	          return '[Circular]';
	        }
	      default:
	        return x;
	    }
	  });
	  for (var x = args[i]; i < len; x = args[++i]) {
	    if (isNull(x) || !isObject(x)) {
	      str += ' ' + x;
	    } else {
	      str += ' ' + inspect$1(x);
	    }
	  }
	  return str;
	}

	// Mark that a method should not be used.
	// Returns a modified function which warns once by default.
	// If --no-deprecation is set, then it is a no-op.
	function deprecate(fn, msg) {
	  // Allow for deprecating things in the process of starting up.
	  if (isUndefined(global.process)) {
	    return function() {
	      return deprecate(fn, msg).apply(this, arguments);
	    };
	  }

	  if (process$1.noDeprecation === true) {
	    return fn;
	  }

	  var warned = false;
	  function deprecated() {
	    if (!warned) {
	      if (process$1.throwDeprecation) {
	        throw new Error(msg);
	      } else if (process$1.traceDeprecation) {
	        console.trace(msg);
	      } else {
	        console.error(msg);
	      }
	      warned = true;
	    }
	    return fn.apply(this, arguments);
	  }

	  return deprecated;
	}

	var debugs = {};
	var debugEnviron;
	function debuglog(set) {
	  if (isUndefined(debugEnviron))
	    debugEnviron = process$1.env.NODE_DEBUG || '';
	  set = set.toUpperCase();
	  if (!debugs[set]) {
	    if (new RegExp('\\b' + set + '\\b', 'i').test(debugEnviron)) {
	      var pid = 0;
	      debugs[set] = function() {
	        var msg = format.apply(null, arguments);
	        console.error('%s %d: %s', set, pid, msg);
	      };
	    } else {
	      debugs[set] = function() {};
	    }
	  }
	  return debugs[set];
	}

	/**
	 * Echos the value of a value. Trys to print the value out
	 * in the best way possible given the different types.
	 *
	 * @param {Object} obj The object to print out.
	 * @param {Object} opts Optional options object that alters the output.
	 */
	/* legacy: obj, showHidden, depth, colors*/
	function inspect$1(obj, opts) {
	  // default options
	  var ctx = {
	    seen: [],
	    stylize: stylizeNoColor
	  };
	  // legacy...
	  if (arguments.length >= 3) ctx.depth = arguments[2];
	  if (arguments.length >= 4) ctx.colors = arguments[3];
	  if (isBoolean$2(opts)) {
	    // legacy...
	    ctx.showHidden = opts;
	  } else if (opts) {
	    // got an "options" object
	    _extend(ctx, opts);
	  }
	  // set default options
	  if (isUndefined(ctx.showHidden)) ctx.showHidden = false;
	  if (isUndefined(ctx.depth)) ctx.depth = 2;
	  if (isUndefined(ctx.colors)) ctx.colors = false;
	  if (isUndefined(ctx.customInspect)) ctx.customInspect = true;
	  if (ctx.colors) ctx.stylize = stylizeWithColor;
	  return formatValue(ctx, obj, ctx.depth);
	}

	// http://en.wikipedia.org/wiki/ANSI_escape_code#graphics
	inspect$1.colors = {
	  'bold' : [1, 22],
	  'italic' : [3, 23],
	  'underline' : [4, 24],
	  'inverse' : [7, 27],
	  'white' : [37, 39],
	  'grey' : [90, 39],
	  'black' : [30, 39],
	  'blue' : [34, 39],
	  'cyan' : [36, 39],
	  'green' : [32, 39],
	  'magenta' : [35, 39],
	  'red' : [31, 39],
	  'yellow' : [33, 39]
	};

	// Don't use 'blue' not visible on cmd.exe
	inspect$1.styles = {
	  'special': 'cyan',
	  'number': 'yellow',
	  'boolean': 'yellow',
	  'undefined': 'grey',
	  'null': 'bold',
	  'string': 'green',
	  'date': 'magenta',
	  // "name": intentionally not styling
	  'regexp': 'red'
	};


	function stylizeWithColor(str, styleType) {
	  var style = inspect$1.styles[styleType];

	  if (style) {
	    return '\u001b[' + inspect$1.colors[style][0] + 'm' + str +
	           '\u001b[' + inspect$1.colors[style][1] + 'm';
	  } else {
	    return str;
	  }
	}


	function stylizeNoColor(str, styleType) {
	  return str;
	}


	function arrayToHash(array) {
	  var hash = {};

	  array.forEach(function(val, idx) {
	    hash[val] = true;
	  });

	  return hash;
	}


	function formatValue(ctx, value, recurseTimes) {
	  // Provide a hook for user-specified inspect functions.
	  // Check that value is an object with an inspect function on it
	  if (ctx.customInspect &&
	      value &&
	      isFunction$1(value.inspect) &&
	      // Filter out the util module, it's inspect function is special
	      value.inspect !== inspect$1 &&
	      // Also filter out any prototype objects using the circular check.
	      !(value.constructor && value.constructor.prototype === value)) {
	    var ret = value.inspect(recurseTimes, ctx);
	    if (!isString$3(ret)) {
	      ret = formatValue(ctx, ret, recurseTimes);
	    }
	    return ret;
	  }

	  // Primitive types cannot have properties
	  var primitive = formatPrimitive(ctx, value);
	  if (primitive) {
	    return primitive;
	  }

	  // Look up the keys of the object.
	  var keys = Object.keys(value);
	  var visibleKeys = arrayToHash(keys);

	  if (ctx.showHidden) {
	    keys = Object.getOwnPropertyNames(value);
	  }

	  // IE doesn't make error fields non-enumerable
	  // http://msdn.microsoft.com/en-us/library/ie/dww52sbt(v=vs.94).aspx
	  if (isError$1(value)
	      && (keys.indexOf('message') >= 0 || keys.indexOf('description') >= 0)) {
	    return formatError(value);
	  }

	  // Some type of object without properties can be shortcutted.
	  if (keys.length === 0) {
	    if (isFunction$1(value)) {
	      var name = value.name ? ': ' + value.name : '';
	      return ctx.stylize('[Function' + name + ']', 'special');
	    }
	    if (isRegExp$1(value)) {
	      return ctx.stylize(RegExp.prototype.toString.call(value), 'regexp');
	    }
	    if (isDate$2(value)) {
	      return ctx.stylize(Date.prototype.toString.call(value), 'date');
	    }
	    if (isError$1(value)) {
	      return formatError(value);
	    }
	  }

	  var base = '', array = false, braces = ['{', '}'];

	  // Make Array say that they are Array
	  if (isArray$3(value)) {
	    array = true;
	    braces = ['[', ']'];
	  }

	  // Make functions say that they are functions
	  if (isFunction$1(value)) {
	    var n = value.name ? ': ' + value.name : '';
	    base = ' [Function' + n + ']';
	  }

	  // Make RegExps say that they are RegExps
	  if (isRegExp$1(value)) {
	    base = ' ' + RegExp.prototype.toString.call(value);
	  }

	  // Make dates with properties first say the date
	  if (isDate$2(value)) {
	    base = ' ' + Date.prototype.toUTCString.call(value);
	  }

	  // Make error with message first say the error
	  if (isError$1(value)) {
	    base = ' ' + formatError(value);
	  }

	  if (keys.length === 0 && (!array || value.length == 0)) {
	    return braces[0] + base + braces[1];
	  }

	  if (recurseTimes < 0) {
	    if (isRegExp$1(value)) {
	      return ctx.stylize(RegExp.prototype.toString.call(value), 'regexp');
	    } else {
	      return ctx.stylize('[Object]', 'special');
	    }
	  }

	  ctx.seen.push(value);

	  var output;
	  if (array) {
	    output = formatArray(ctx, value, recurseTimes, visibleKeys, keys);
	  } else {
	    output = keys.map(function(key) {
	      return formatProperty(ctx, value, recurseTimes, visibleKeys, key, array);
	    });
	  }

	  ctx.seen.pop();

	  return reduceToSingleString(output, base, braces);
	}


	function formatPrimitive(ctx, value) {
	  if (isUndefined(value))
	    return ctx.stylize('undefined', 'undefined');
	  if (isString$3(value)) {
	    var simple = '\'' + JSON.stringify(value).replace(/^"|"$/g, '')
	                                             .replace(/'/g, "\\'")
	                                             .replace(/\\"/g, '"') + '\'';
	    return ctx.stylize(simple, 'string');
	  }
	  if (isNumber$2(value))
	    return ctx.stylize('' + value, 'number');
	  if (isBoolean$2(value))
	    return ctx.stylize('' + value, 'boolean');
	  // For some reason typeof null is "object", so special case here.
	  if (isNull(value))
	    return ctx.stylize('null', 'null');
	}


	function formatError(value) {
	  return '[' + Error.prototype.toString.call(value) + ']';
	}


	function formatArray(ctx, value, recurseTimes, visibleKeys, keys) {
	  var output = [];
	  for (var i = 0, l = value.length; i < l; ++i) {
	    if (hasOwnProperty(value, String(i))) {
	      output.push(formatProperty(ctx, value, recurseTimes, visibleKeys,
	          String(i), true));
	    } else {
	      output.push('');
	    }
	  }
	  keys.forEach(function(key) {
	    if (!key.match(/^\d+$/)) {
	      output.push(formatProperty(ctx, value, recurseTimes, visibleKeys,
	          key, true));
	    }
	  });
	  return output;
	}


	function formatProperty(ctx, value, recurseTimes, visibleKeys, key, array) {
	  var name, str, desc;
	  desc = Object.getOwnPropertyDescriptor(value, key) || { value: value[key] };
	  if (desc.get) {
	    if (desc.set) {
	      str = ctx.stylize('[Getter/Setter]', 'special');
	    } else {
	      str = ctx.stylize('[Getter]', 'special');
	    }
	  } else {
	    if (desc.set) {
	      str = ctx.stylize('[Setter]', 'special');
	    }
	  }
	  if (!hasOwnProperty(visibleKeys, key)) {
	    name = '[' + key + ']';
	  }
	  if (!str) {
	    if (ctx.seen.indexOf(desc.value) < 0) {
	      if (isNull(recurseTimes)) {
	        str = formatValue(ctx, desc.value, null);
	      } else {
	        str = formatValue(ctx, desc.value, recurseTimes - 1);
	      }
	      if (str.indexOf('\n') > -1) {
	        if (array) {
	          str = str.split('\n').map(function(line) {
	            return '  ' + line;
	          }).join('\n').substr(2);
	        } else {
	          str = '\n' + str.split('\n').map(function(line) {
	            return '   ' + line;
	          }).join('\n');
	        }
	      }
	    } else {
	      str = ctx.stylize('[Circular]', 'special');
	    }
	  }
	  if (isUndefined(name)) {
	    if (array && key.match(/^\d+$/)) {
	      return str;
	    }
	    name = JSON.stringify('' + key);
	    if (name.match(/^"([a-zA-Z_][a-zA-Z_0-9]*)"$/)) {
	      name = name.substr(1, name.length - 2);
	      name = ctx.stylize(name, 'name');
	    } else {
	      name = name.replace(/'/g, "\\'")
	                 .replace(/\\"/g, '"')
	                 .replace(/(^"|"$)/g, "'");
	      name = ctx.stylize(name, 'string');
	    }
	  }

	  return name + ': ' + str;
	}


	function reduceToSingleString(output, base, braces) {
	  var length = output.reduce(function(prev, cur) {
	    if (cur.indexOf('\n') >= 0) ;
	    return prev + cur.replace(/\u001b\[\d\d?m/g, '').length + 1;
	  }, 0);

	  if (length > 60) {
	    return braces[0] +
	           (base === '' ? '' : base + '\n ') +
	           ' ' +
	           output.join(',\n  ') +
	           ' ' +
	           braces[1];
	  }

	  return braces[0] + base + ' ' + output.join(', ') + ' ' + braces[1];
	}


	// NOTE: These type checking functions intentionally don't use `instanceof`
	// because it is fragile and can be easily faked with `Object.create()`.
	function isArray$3(ar) {
	  return Array.isArray(ar);
	}

	function isBoolean$2(arg) {
	  return typeof arg === 'boolean';
	}

	function isNull(arg) {
	  return arg === null;
	}

	function isNullOrUndefined(arg) {
	  return arg == null;
	}

	function isNumber$2(arg) {
	  return typeof arg === 'number';
	}

	function isString$3(arg) {
	  return typeof arg === 'string';
	}

	function isSymbol$3(arg) {
	  return typeof arg === 'symbol';
	}

	function isUndefined(arg) {
	  return arg === void 0;
	}

	function isRegExp$1(re) {
	  return isObject(re) && objectToString$1(re) === '[object RegExp]';
	}

	function isObject(arg) {
	  return typeof arg === 'object' && arg !== null;
	}

	function isDate$2(d) {
	  return isObject(d) && objectToString$1(d) === '[object Date]';
	}

	function isError$1(e) {
	  return isObject(e) &&
	      (objectToString$1(e) === '[object Error]' || e instanceof Error);
	}

	function isFunction$1(arg) {
	  return typeof arg === 'function';
	}

	function isPrimitive(arg) {
	  return arg === null ||
	         typeof arg === 'boolean' ||
	         typeof arg === 'number' ||
	         typeof arg === 'string' ||
	         typeof arg === 'symbol' ||  // ES6 symbol
	         typeof arg === 'undefined';
	}

	function isBuffer$1(maybeBuf) {
	  return Buffer.isBuffer(maybeBuf);
	}

	function objectToString$1(o) {
	  return Object.prototype.toString.call(o);
	}


	function pad(n) {
	  return n < 10 ? '0' + n.toString(10) : n.toString(10);
	}


	var months = ['Jan', 'Feb', 'Mar', 'Apr', 'May', 'Jun', 'Jul', 'Aug', 'Sep',
	              'Oct', 'Nov', 'Dec'];

	// 26 Feb 16:19:34
	function timestamp() {
	  var d = new Date();
	  var time = [pad(d.getHours()),
	              pad(d.getMinutes()),
	              pad(d.getSeconds())].join(':');
	  return [d.getDate(), months[d.getMonth()], time].join(' ');
	}


	// log is just a thin wrapper to console.log that prepends a timestamp
	function log() {
	  console.log('%s - %s', timestamp(), format.apply(null, arguments));
	}

	function _extend(origin, add) {
	  // Don't do anything if add isn't an object
	  if (!add || !isObject(add)) return origin;

	  var keys = Object.keys(add);
	  var i = keys.length;
	  while (i--) {
	    origin[keys[i]] = add[keys[i]];
	  }
	  return origin;
	}
	function hasOwnProperty(obj, prop) {
	  return Object.prototype.hasOwnProperty.call(obj, prop);
	}

	var util$1 = {
	  inherits: inherits$1,
	  _extend: _extend,
	  log: log,
	  isBuffer: isBuffer$1,
	  isPrimitive: isPrimitive,
	  isFunction: isFunction$1,
	  isError: isError$1,
	  isDate: isDate$2,
	  isObject: isObject,
	  isRegExp: isRegExp$1,
	  isUndefined: isUndefined,
	  isSymbol: isSymbol$3,
	  isString: isString$3,
	  isNumber: isNumber$2,
	  isNullOrUndefined: isNullOrUndefined,
	  isNull: isNull,
	  isBoolean: isBoolean$2,
	  isArray: isArray$3,
	  inspect: inspect$1,
	  deprecate: deprecate,
	  format: format,
	  debuglog: debuglog
	};

	var util$2 = /*#__PURE__*/Object.freeze({
		__proto__: null,
		format: format,
		deprecate: deprecate,
		debuglog: debuglog,
		inspect: inspect$1,
		isArray: isArray$3,
		isBoolean: isBoolean$2,
		isNull: isNull,
		isNullOrUndefined: isNullOrUndefined,
		isNumber: isNumber$2,
		isString: isString$3,
		isSymbol: isSymbol$3,
		isUndefined: isUndefined,
		isRegExp: isRegExp$1,
		isObject: isObject,
		isDate: isDate$2,
		isError: isError$1,
		isFunction: isFunction$1,
		isPrimitive: isPrimitive,
		isBuffer: isBuffer$1,
		log: log,
		inherits: inherits$1,
		_extend: _extend,
		'default': util$1
	});

	var require$$0$1 = /*@__PURE__*/getAugmentedNamespace(util$2);

	Object.defineProperty(values, "__esModule", { value: true });
	values.variablesInValue = values.argumentsFromAST = values.valueFromAST = values.isValidValue = values.valueToAST = values.withDefaultValues = values.argumentsEquals = values.valueEquals = values.valueToString = void 0;
	const definitions_1$6 = definitions;
	const graphql_1$b = require$$2$1;
	const suggestions_1$1 = suggestions;
	const util_1$1 = require$$0$1;
	const types_1$2 = types;
	const utils_1$2 = utils;
	const MAX_INT = 2147483647;
	const MIN_INT = -2147483648;
	function valueToString(v, expectedType) {
	    if (v === undefined || v === null) {
	        if (expectedType && (0, definitions_1$6.isNonNullType)(expectedType)) {
	            throw buildError(`Invalid undefined/null value for non-null type ${expectedType}`);
	        }
	        return "null";
	    }
	    if (expectedType && (0, definitions_1$6.isNonNullType)(expectedType)) {
	        expectedType = expectedType.ofType;
	    }
	    if (expectedType && (0, definitions_1$6.isCustomScalarType)(expectedType)) {
	        expectedType = undefined;
	    }
	    if ((0, definitions_1$6.isVariable)(v)) {
	        return v.toString();
	    }
	    if (Array.isArray(v)) {
	        let elementsType = undefined;
	        if (expectedType) {
	            if (!(0, definitions_1$6.isListType)(expectedType)) {
	                throw buildError(`Invalid list value for non-list type ${expectedType}`);
	            }
	            elementsType = expectedType.ofType;
	        }
	        return '[' + v.map(e => valueToString(e, elementsType)).join(', ') + ']';
	    }
	    if (typeof v === 'object') {
	        if (expectedType && !(0, definitions_1$6.isInputObjectType)(expectedType)) {
	            throw buildError(`Invalid object value for non-input-object type ${expectedType} (isCustomScalar? ${(0, definitions_1$6.isCustomScalarType)(expectedType)})`);
	        }
	        return '{' + Object.keys(v).map(k => {
	            var _a;
	            let valueType = expectedType ? (_a = expectedType.field(k)) === null || _a === void 0 ? void 0 : _a.type : undefined;
	            return `${k}: ${valueToString(v[k], valueType)}`;
	        }).join(', ') + '}';
	    }
	    if (typeof v === 'string') {
	        if (expectedType) {
	            if ((0, definitions_1$6.isEnumType)(expectedType)) {
	                return v;
	            }
	            if (expectedType === expectedType.schema().idType() && integerStringRegExp.test(v)) {
	                return v;
	            }
	        }
	        return JSON.stringify(v);
	    }
	    return String(v);
	}
	values.valueToString = valueToString;
	function valueEquals(a, b) {
	    if (a === b) {
	        return true;
	    }
	    if (Array.isArray(a)) {
	        return Array.isArray(b) && arrayValueEquals(a, b);
	    }
	    if (typeof a === 'object') {
	        return typeof b === 'object' && objectEquals(a, b);
	    }
	    return a === b;
	}
	values.valueEquals = valueEquals;
	function arrayValueEquals(a, b) {
	    if (a.length !== b.length) {
	        return false;
	    }
	    for (let i = 0; i < a.length; ++i) {
	        if (!valueEquals(a[i], b[i])) {
	            return false;
	        }
	    }
	    return true;
	}
	function objectEquals(a, b) {
	    const keys1 = Object.keys(a);
	    const keys2 = Object.keys(b);
	    if (keys1.length != keys2.length) {
	        return false;
	    }
	    for (const key of keys1) {
	        const v1 = a[key];
	        const v2 = b[key];
	        if (v2 === undefined) {
	            return v1 === undefined && b.hasOwnProperty(key);
	        }
	        if (!valueEquals(v1, v2)) {
	            return false;
	        }
	    }
	    return true;
	}
	function argumentsEquals(args1, args2) {
	    if (args1 === args2) {
	        return true;
	    }
	    return objectEquals(args1, args2);
	}
	values.argumentsEquals = argumentsEquals;
	function buildError(message) {
	    return new Error(message);
	}
	function applyDefaultValues(value, type) {
	    if ((0, definitions_1$6.isVariable)(value)) {
	        return value;
	    }
	    if (value === null) {
	        if ((0, definitions_1$6.isNonNullType)(type)) {
	            throw new graphql_1$b.GraphQLError(`Invalid null value for non-null type ${type} while computing default values`);
	        }
	        return null;
	    }
	    if ((0, definitions_1$6.isNonNullType)(type)) {
	        return applyDefaultValues(value, type.ofType);
	    }
	    if ((0, definitions_1$6.isListType)(type)) {
	        if (Array.isArray(value)) {
	            return value.map(v => applyDefaultValues(v, type.ofType));
	        }
	        else {
	            return applyDefaultValues(value, type.ofType);
	        }
	    }
	    if ((0, definitions_1$6.isInputObjectType)(type)) {
	        if (typeof value !== 'object') {
	            throw new graphql_1$b.GraphQLError(`Expected value for type ${type} to be an object, but is ${typeof value}.`);
	        }
	        const updated = Object.create(null);
	        for (const field of type.fields()) {
	            if (!field.type) {
	                throw buildError(`Cannot compute default value for field ${field.name} of ${type} as the field type is undefined`);
	            }
	            const fieldValue = value[field.name];
	            if (fieldValue === undefined) {
	                if (field.defaultValue !== undefined) {
	                    updated[field.name] = applyDefaultValues(field.defaultValue, field.type);
	                }
	                else if ((0, definitions_1$6.isNonNullType)(field.type)) {
	                    throw new graphql_1$b.GraphQLError(`Field "${field.name}" of required type ${type} was not provided.`);
	                }
	            }
	            else {
	                updated[field.name] = applyDefaultValues(fieldValue, field.type);
	            }
	        }
	        for (const fieldName of Object.keys(value)) {
	            if (!type.field(fieldName)) {
	                const suggestions = (0, suggestions_1$1.suggestionList)(fieldName, type.fields().map(f => f.name));
	                throw new graphql_1$b.GraphQLError(`Field "${fieldName}" is not defined by type "${type}".` + (0, suggestions_1$1.didYouMean)(suggestions));
	            }
	        }
	        return updated;
	    }
	    return value;
	}
	function withDefaultValues(value, argument) {
	    if (!argument.type) {
	        throw buildError(`Cannot compute default value for argument ${argument} as the type is undefined`);
	    }
	    if (value === undefined) {
	        if (argument.defaultValue) {
	            return applyDefaultValues(argument.defaultValue, argument.type);
	        }
	    }
	    return applyDefaultValues(value, argument.type);
	}
	values.withDefaultValues = withDefaultValues;
	const integerStringRegExp = /^-?(?:0|[1-9][0-9]*)$/;
	function valueToAST(value, type) {
	    var _a;
	    if (value === undefined) {
	        return undefined;
	    }
	    if ((0, definitions_1$6.isNonNullType)(type)) {
	        const astValue = valueToAST(value, type.ofType);
	        if ((astValue === null || astValue === void 0 ? void 0 : astValue.kind) === graphql_1$b.Kind.NULL) {
	            throw buildError(`Invalid null value ${valueToString(value)} for non-null type ${type}`);
	        }
	        return astValue;
	    }
	    if (value === null) {
	        return { kind: graphql_1$b.Kind.NULL };
	    }
	    if ((0, definitions_1$6.isVariable)(value)) {
	        return { kind: graphql_1$b.Kind.VARIABLE, name: { kind: graphql_1$b.Kind.NAME, value: value.name } };
	    }
	    if ((0, definitions_1$6.isCustomScalarType)(type)) {
	        return valueToASTUntyped(value);
	    }
	    if ((0, definitions_1$6.isListType)(type)) {
	        const itemType = type.ofType;
	        const items = Array.from(value);
	        if (items != null) {
	            const valuesNodes = [];
	            for (const item of items) {
	                const itemNode = valueToAST(item, itemType);
	                if (itemNode != null) {
	                    valuesNodes.push(itemNode);
	                }
	            }
	            return { kind: graphql_1$b.Kind.LIST, values: valuesNodes };
	        }
	        return valueToAST(value, itemType);
	    }
	    if ((0, definitions_1$6.isInputObjectType)(type)) {
	        if (typeof value !== 'object') {
	            throw buildError(`Invalid non-objet value for input type ${type}, cannot be converted to AST: ${(0, util_1$1.inspect)(value, true, 10, true)}`);
	        }
	        const fieldNodes = [];
	        for (const field of type.fields()) {
	            if (!field.type) {
	                throw buildError(`Cannot convert value ${valueToString(value)} as field ${field} has no type set`);
	            }
	            const fieldValue = valueToAST(value[field.name], field.type);
	            if (fieldValue) {
	                fieldNodes.push({
	                    kind: graphql_1$b.Kind.OBJECT_FIELD,
	                    name: { kind: graphql_1$b.Kind.NAME, value: field.name },
	                    value: fieldValue,
	                });
	            }
	        }
	        return { kind: graphql_1$b.Kind.OBJECT, fields: fieldNodes };
	    }
	    if (typeof value === 'boolean') {
	        return { kind: graphql_1$b.Kind.BOOLEAN, value: value };
	    }
	    if (typeof value === 'number' && isFinite(value)) {
	        const stringNum = String(value);
	        return integerStringRegExp.test(stringNum)
	            ? { kind: graphql_1$b.Kind.INT, value: stringNum }
	            : { kind: graphql_1$b.Kind.FLOAT, value: stringNum };
	    }
	    if (typeof value === 'string') {
	        if ((0, definitions_1$6.isEnumType)(type)) {
	            return { kind: graphql_1$b.Kind.ENUM, value: value };
	        }
	        if (type === ((_a = type.schema()) === null || _a === void 0 ? void 0 : _a.idType()) && integerStringRegExp.test(value)) {
	            return { kind: graphql_1$b.Kind.INT, value: value };
	        }
	        return {
	            kind: graphql_1$b.Kind.STRING,
	            value: value,
	        };
	    }
	    throw buildError(`Invalid value for type ${type}, cannot be converted to AST: ${(0, util_1$1.inspect)(value)}`);
	}
	values.valueToAST = valueToAST;
	function valueToASTUntyped(value) {
	    if (value === undefined) {
	        return undefined;
	    }
	    if (value === null) {
	        return { kind: graphql_1$b.Kind.NULL };
	    }
	    if ((0, definitions_1$6.isVariable)(value)) {
	        return { kind: graphql_1$b.Kind.VARIABLE, name: { kind: graphql_1$b.Kind.NAME, value: value.name } };
	    }
	    if (Array.isArray(value)) {
	        const valuesNodes = [];
	        for (const item of value) {
	            const itemNode = valueToASTUntyped(item);
	            if (itemNode !== undefined) {
	                valuesNodes.push(itemNode);
	            }
	        }
	        return { kind: graphql_1$b.Kind.LIST, values: valuesNodes };
	    }
	    if (typeof value === 'object') {
	        const fieldNodes = [];
	        for (const key of Object.keys(value)) {
	            const fieldValue = valueToASTUntyped(value[key]);
	            if (fieldValue) {
	                fieldNodes.push({
	                    kind: graphql_1$b.Kind.OBJECT_FIELD,
	                    name: { kind: graphql_1$b.Kind.NAME, value: key },
	                    value: fieldValue,
	                });
	            }
	        }
	        return { kind: graphql_1$b.Kind.OBJECT, fields: fieldNodes };
	    }
	    if (typeof value === 'boolean') {
	        return { kind: graphql_1$b.Kind.BOOLEAN, value: value };
	    }
	    if (typeof value === 'number' && isFinite(value)) {
	        const stringNum = String(value);
	        return integerStringRegExp.test(stringNum)
	            ? { kind: graphql_1$b.Kind.INT, value: stringNum }
	            : { kind: graphql_1$b.Kind.FLOAT, value: stringNum };
	    }
	    if (typeof value === 'string') {
	        return { kind: graphql_1$b.Kind.STRING, value: value };
	    }
	    throw buildError(`Invalid value, cannot be converted to AST: ${(0, util_1$1.inspect)(value, true, 10, true)}`);
	}
	function isValidVariable(variable, locationType, locationDefault) {
	    const variableType = variable.type;
	    if ((0, definitions_1$6.isNonNullType)(locationType) && !(0, definitions_1$6.isNonNullType)(variableType)) {
	        const hasVariableDefault = variable.defaultValue !== undefined && variable.defaultValue !== null;
	        const hasLocationDefault = locationDefault !== undefined;
	        if (!hasVariableDefault && !hasLocationDefault) {
	            return false;
	        }
	        return areTypesCompatible(variableType, locationType.ofType);
	    }
	    return areTypesCompatible(variableType, locationType);
	}
	function areTypesCompatible(variableType, locationType) {
	    if ((0, definitions_1$6.isNonNullType)(locationType)) {
	        if (!(0, definitions_1$6.isNonNullType)(variableType)) {
	            return false;
	        }
	        return areTypesCompatible(variableType.ofType, locationType.ofType);
	    }
	    if ((0, definitions_1$6.isNonNullType)(variableType)) {
	        return areTypesCompatible(variableType.ofType, locationType);
	    }
	    if ((0, definitions_1$6.isListType)(locationType)) {
	        if (!(0, definitions_1$6.isListType)(variableType)) {
	            return false;
	        }
	        return areTypesCompatible(variableType.ofType, locationType.ofType);
	    }
	    return !(0, definitions_1$6.isListType)(variableType) && (0, types_1$2.sameType)(variableType, locationType);
	}
	function isValidValue(value, argument, variableDefinitions) {
	    return isValidValueApplication(value, argument.type, argument.defaultValue, variableDefinitions);
	}
	values.isValidValue = isValidValue;
	function isValidValueApplication(value, locationType, locationDefault, variableDefinitions) {
	    if ((0, definitions_1$6.isVariable)(value)) {
	        const definition = variableDefinitions.definition(value);
	        return !!definition && isValidVariable(definition, locationType, locationDefault);
	    }
	    if ((0, definitions_1$6.isNonNullType)(locationType)) {
	        return value !== null && isValidValueApplication(value, locationType.ofType, undefined, variableDefinitions);
	    }
	    if (value === null || value === undefined) {
	        return true;
	    }
	    if ((0, definitions_1$6.isCustomScalarType)(locationType)) {
	        return true;
	    }
	    if ((0, definitions_1$6.isListType)(locationType)) {
	        const itemType = locationType.ofType;
	        if (Array.isArray(value)) {
	            return value.every(item => isValidValueApplication(item, itemType, undefined, variableDefinitions));
	        }
	        return isValidValueApplication(value, itemType, locationDefault, variableDefinitions);
	    }
	    if ((0, definitions_1$6.isInputObjectType)(locationType)) {
	        if (typeof value !== 'object') {
	            return false;
	        }
	        const isValid = locationType.fields().every(field => isValidValueApplication(value[field.name], field.type, undefined, variableDefinitions));
	        return isValid;
	    }
	    const schema = locationType.schema();
	    if (typeof value === 'boolean') {
	        return locationType === schema.booleanType();
	    }
	    if (typeof value === 'number' && isFinite(value)) {
	        const stringNum = String(value);
	        if (locationType === schema.intType() || locationType === schema.idType()) {
	            return integerStringRegExp.test(stringNum);
	        }
	        return locationType === schema.floatType();
	    }
	    if (typeof value === 'string') {
	        if ((0, definitions_1$6.isEnumType)(locationType)) {
	            return locationType.value(value) !== undefined;
	        }
	        return (0, definitions_1$6.isScalarType)(locationType)
	            && locationType !== schema.booleanType()
	            && locationType !== schema.intType()
	            && locationType !== schema.floatType();
	    }
	    return false;
	}
	function valueFromAST(node, expectedType) {
	    if (node.kind === graphql_1$b.Kind.NULL) {
	        if ((0, definitions_1$6.isNonNullType)(expectedType)) {
	            throw new graphql_1$b.GraphQLError(`Invalid null value for non-null type "${expectedType}"`);
	        }
	        return null;
	    }
	    if (node.kind === graphql_1$b.Kind.VARIABLE) {
	        return new definitions_1$6.Variable(node.name.value);
	    }
	    if ((0, definitions_1$6.isNonNullType)(expectedType)) {
	        expectedType = expectedType.ofType;
	    }
	    if ((0, definitions_1$6.isListType)(expectedType)) {
	        const baseType = expectedType.ofType;
	        if (node.kind === graphql_1$b.Kind.LIST) {
	            return node.values.map(v => valueFromAST(v, baseType));
	        }
	        return [valueFromAST(node, baseType)];
	    }
	    if ((0, definitions_1$6.isIntType)(expectedType)) {
	        if (node.kind !== graphql_1$b.Kind.INT) {
	            throw new graphql_1$b.GraphQLError(`Int cannot represent non-integer value ${(0, graphql_1$b.print)(node)}.`);
	        }
	        const i = parseInt(node.value, 10);
	        if (i > MAX_INT || i < MIN_INT) {
	            throw new graphql_1$b.GraphQLError(`Int cannot represent non 32-bit signed integer value ${i}.`);
	        }
	        return i;
	    }
	    if ((0, definitions_1$6.isFloatType)(expectedType)) {
	        let parsed;
	        if (node.kind === graphql_1$b.Kind.INT) {
	            parsed = parseInt(node.value, 10);
	        }
	        else if (node.kind === graphql_1$b.Kind.FLOAT) {
	            parsed = parseFloat(node.value);
	        }
	        else {
	            throw new graphql_1$b.GraphQLError(`Float can only represent integer or float value, but got a ${node.kind}.`);
	        }
	        if (!isFinite(parsed)) {
	            throw new graphql_1$b.GraphQLError(`Float cannot represent non numeric value ${parsed}.`);
	        }
	        return parsed;
	    }
	    if ((0, definitions_1$6.isBooleanType)(expectedType)) {
	        if (node.kind !== graphql_1$b.Kind.BOOLEAN) {
	            throw new graphql_1$b.GraphQLError(`Boolean cannot represent a non boolean value ${(0, graphql_1$b.print)(node)}.`);
	        }
	        return node.value;
	    }
	    if ((0, definitions_1$6.isStringType)(expectedType)) {
	        if (node.kind !== graphql_1$b.Kind.STRING) {
	            throw new graphql_1$b.GraphQLError(`String cannot represent non string value ${(0, graphql_1$b.print)(node)}.`);
	        }
	        return node.value;
	    }
	    if ((0, definitions_1$6.isIDType)(expectedType)) {
	        if (node.kind !== graphql_1$b.Kind.STRING && node.kind !== graphql_1$b.Kind.INT) {
	            throw new graphql_1$b.GraphQLError(`ID cannot represent value ${(0, graphql_1$b.print)(node)}.`);
	        }
	        return node.value;
	    }
	    if ((0, definitions_1$6.isScalarType)(expectedType)) {
	        return valueFromASTUntyped(node);
	    }
	    if ((0, definitions_1$6.isInputObjectType)(expectedType)) {
	        if (node.kind !== graphql_1$b.Kind.OBJECT) {
	            throw new graphql_1$b.GraphQLError(`Input Object Type ${expectedType} cannot represent non-object value ${(0, graphql_1$b.print)(node)}.`);
	        }
	        const obj = Object.create(null);
	        for (const f of node.fields) {
	            const name = f.name.value;
	            const field = expectedType.field(name);
	            if (!field) {
	                throw new graphql_1$b.GraphQLError(`Unknown field "${name}" found in value for Input Object Type "${expectedType}".`);
	            }
	            obj[name] = valueFromAST(f.value, field.type);
	        }
	        return obj;
	    }
	    if ((0, definitions_1$6.isEnumType)(expectedType)) {
	        if (node.kind !== graphql_1$b.Kind.STRING && node.kind !== graphql_1$b.Kind.ENUM) {
	            throw new graphql_1$b.GraphQLError(`Enum Type ${expectedType} cannot represent value ${(0, graphql_1$b.print)(node)}.`);
	        }
	        if (!expectedType.value(node.value)) {
	            throw new graphql_1$b.GraphQLError(`Enum Type ${expectedType} has no value ${node.value}.`);
	        }
	        return node.value;
	    }
	    (0, utils_1$2.assert)(false, () => `Unexpected input type ${expectedType} of kind ${expectedType.kind}.`);
	}
	values.valueFromAST = valueFromAST;
	function valueFromASTUntyped(node) {
	    switch (node.kind) {
	        case graphql_1$b.Kind.NULL:
	            return null;
	        case graphql_1$b.Kind.INT:
	            return parseInt(node.value, 10);
	        case graphql_1$b.Kind.FLOAT:
	            return parseFloat(node.value);
	        case graphql_1$b.Kind.STRING:
	        case graphql_1$b.Kind.ENUM:
	        case graphql_1$b.Kind.BOOLEAN:
	            return node.value;
	        case graphql_1$b.Kind.LIST:
	            return node.values.map(valueFromASTUntyped);
	        case graphql_1$b.Kind.OBJECT:
	            const obj = Object.create(null);
	            node.fields.forEach(f => obj[f.name.value] = valueFromASTUntyped(f.value));
	            return obj;
	        case graphql_1$b.Kind.VARIABLE:
	            return new definitions_1$6.Variable(node.name.value);
	    }
	}
	function argumentsFromAST(context, args, argsDefiner) {
	    var _a;
	    const values = Object.create(null);
	    if (args) {
	        for (const argNode of args) {
	            const name = argNode.name.value;
	            const expectedType = (_a = argsDefiner.argument(name)) === null || _a === void 0 ? void 0 : _a.type;
	            if (!expectedType) {
	                throw new graphql_1$b.GraphQLError(`Unknown argument "${name}" found in value: ${context} has no argument named "${name}"`);
	            }
	            try {
	                values[name] = valueFromAST(argNode.value, expectedType);
	            }
	            catch (e) {
	                if (e instanceof graphql_1$b.GraphQLError) {
	                    throw new graphql_1$b.GraphQLError(`Invalid value for argument ${name}: ${e.message}`);
	                }
	                throw e;
	            }
	        }
	    }
	    return values;
	}
	values.argumentsFromAST = argumentsFromAST;
	function variablesInValue(value) {
	    const variables = [];
	    collectVariables(value, variables);
	    return variables;
	}
	values.variablesInValue = variablesInValue;
	function collectVariables(value, variables) {
	    if ((0, definitions_1$6.isVariable)(value)) {
	        if (!variables.some(v => v.name === value.name)) {
	            variables.push(value);
	        }
	        return;
	    }
	    if (!value) {
	        return;
	    }
	    if (Array.isArray(value)) {
	        value.forEach(v => collectVariables(v, variables));
	    }
	    if (typeof value === 'object') {
	        Object.keys(value).forEach(k => collectVariables(value[k], variables));
	    }
	}

	var inaccessibleSpec = {};

	(function (exports) {
	Object.defineProperty(exports, "__esModule", { value: true });
	exports.removeInaccessibleElements = exports.INACCESSIBLE_VERSIONS = exports.InaccessibleSpecDefinition = exports.inaccessibleIdentity = void 0;
	const coreSpec_1 = coreSpec$1;
	const definitions_1 = definitions;
	const graphql_1 = require$$2$1;
	exports.inaccessibleIdentity = 'https://specs.apollo.dev/inaccessible';
	class InaccessibleSpecDefinition extends coreSpec_1.FeatureDefinition {
	    constructor(version) {
	        super(new coreSpec_1.FeatureUrl(exports.inaccessibleIdentity, 'inaccessible', version));
	    }
	    addElementsToSchema(schema) {
	        this.addDirective(schema, 'inacessible').addLocations('FIELD_DEFINITION', 'OBJECT', 'INTERFACE', 'UNION');
	    }
	    inaccessibleDirective(schema) {
	        return this.directive(schema, 'inaccessible');
	    }
	}
	exports.InaccessibleSpecDefinition = InaccessibleSpecDefinition;
	exports.INACCESSIBLE_VERSIONS = new coreSpec_1.FeatureDefinitions(exports.inaccessibleIdentity)
	    .add(new InaccessibleSpecDefinition(new coreSpec_1.FeatureVersion(0, 1)));
	function removeInaccessibleElements(schema) {
	    const coreFeatures = schema.coreFeatures;
	    if (!coreFeatures) {
	        return;
	    }
	    const inacessibleFeature = coreFeatures.getByIdentity(exports.inaccessibleIdentity);
	    if (!inacessibleFeature) {
	        return;
	    }
	    const inaccessibleSpec = exports.INACCESSIBLE_VERSIONS.find(inacessibleFeature.url.version);
	    if (!inaccessibleSpec) {
	        throw new graphql_1.GraphQLError(`Cannot remove inacessible elements: the schema uses unsupported inacessible spec version ${inacessibleFeature.url.version} (supported versions: ${exports.INACCESSIBLE_VERSIONS.versions().join(', ')})`);
	    }
	    const inaccessibleDirective = inaccessibleSpec.inaccessibleDirective(schema);
	    if (!inaccessibleDirective) {
	        throw new graphql_1.GraphQLError(`Invalid schema: declares ${inaccessibleSpec.url} spec but does not define a @inaccessible directive`);
	    }
	    for (const type of schema.types()) {
	        if (!(0, definitions_1.isCompositeType)(type)) {
	            continue;
	        }
	        if (type.hasAppliedDirective(inaccessibleDirective)) {
	            const references = type.remove();
	            for (const reference of references) {
	                if (reference.kind === 'FieldDefinition') {
	                    if (!reference.hasAppliedDirective(inaccessibleDirective)) {
	                        throw new graphql_1.GraphQLError(`Field ${reference.coordinate} returns an @inaccessible type without being marked @inaccessible itself.`, reference.sourceAST);
	                    }
	                }
	            }
	        }
	        else if ((0, definitions_1.isObjectType)(type) || (0, definitions_1.isInterfaceType)(type)) {
	            const toRemove = type.fields().filter(f => f.hasAppliedDirective(inaccessibleDirective));
	            toRemove.forEach(f => f.remove());
	        }
	    }
	}
	exports.removeInaccessibleElements = removeInaccessibleElements;

	}(inaccessibleSpec));

	var print = {};

	(function (exports) {
	Object.defineProperty(exports, "__esModule", { value: true });
	exports.printDirectiveDefinition = exports.printTypeDefinitionAndExtensions = exports.printType = exports.printSchema = exports.orderPrintedDefinitions = exports.defaultPrintOptions = void 0;
	const utils_1 = utils;
	const values_1 = values;
	exports.defaultPrintOptions = {
	    indentString: "  ",
	    definitionsOrder: ['schema', 'directives', 'types'],
	    rootTypesOrder: ['query', 'mutation', 'subscription'],
	    mergeTypesAndExtensions: false,
	    showAllBuiltIns: false,
	    showNonGraphQLBuiltIns: false,
	    noDesciptions: false,
	};
	function orderPrintedDefinitions(options) {
	    return {
	        ...options,
	        typeCompareFn: (t1, t2) => t1.name.localeCompare(t2.name),
	        directiveCompareFn: (t1, t2) => t1.name.localeCompare(t2.name),
	    };
	}
	exports.orderPrintedDefinitions = orderPrintedDefinitions;
	function isDefinitionOrderValid(options) {
	    return options.definitionsOrder.length === 3
	        && options.definitionsOrder.indexOf('schema') >= 0
	        && options.definitionsOrder.indexOf('types') >= 0
	        && options.definitionsOrder.indexOf('directives') >= 0;
	}
	function validateOptions(options) {
	    if (!isDefinitionOrderValid(options)) {
	        throw new Error(`'definitionsOrder' should be a 3-element array containing 'schema', 'types' and 'directives' in the desired order (got: [${options.definitionsOrder.join(', ')}])`);
	    }
	}
	function printSchema(schema, options = exports.defaultPrintOptions) {
	    validateOptions(options);
	    let directives = options.showAllBuiltIns ? schema.allDirectives() : schema.directives(options.showNonGraphQLBuiltIns);
	    if (options.directiveCompareFn) {
	        directives = directives.concat().sort(options.directiveCompareFn);
	    }
	    let types = options.showAllBuiltIns ? schema.allTypes() : schema.types(undefined, options.showNonGraphQLBuiltIns);
	    if (options.typeCompareFn) {
	        types = types.concat().sort(options.typeCompareFn);
	    }
	    const definitions = new Array(3);
	    definitions[options.definitionsOrder.indexOf('schema')] = printSchemaDefinitionAndExtensions(schema.schemaDefinition, options);
	    definitions[options.definitionsOrder.indexOf('directives')] = directives.map(directive => printDirectiveDefinition(directive, options));
	    definitions[options.definitionsOrder.indexOf('types')] = types.flatMap(type => printTypeDefinitionAndExtensions(type, options));
	    return definitions.flat().join('\n\n');
	}
	exports.printSchema = printSchema;
	function definitionAndExtensions(element, options) {
	    return options.mergeTypesAndExtensions ? [undefined] : [null, ...element.extensions()];
	}
	function printSchemaDefinitionAndExtensions(schemaDefinition, options) {
	    if (isSchemaOfCommonNames(schemaDefinition)) {
	        return [];
	    }
	    return printDefinitionAndExtensions(schemaDefinition, options, printSchemaDefinitionOrExtension);
	}
	function printDefinitionAndExtensions(t, options, printer) {
	    return definitionAndExtensions(t, options)
	        .map(ext => printer(t, options, ext))
	        .filter(v => v !== undefined);
	}
	function printIsExtension(extension) {
	    return extension ? 'extend ' : '';
	}
	function forExtension(ts, extension) {
	    if (extension === undefined) {
	        return ts;
	    }
	    return ts.filter(r => { var _a; return ((_a = r.ofExtension()) !== null && _a !== void 0 ? _a : null) === extension; });
	}
	function orderRoots(roots, options) {
	    return roots.concat().sort((r1, r2) => options.rootTypesOrder.indexOf(r1.rootKind) - options.rootTypesOrder.indexOf(r2.rootKind));
	}
	function printSchemaDefinitionOrExtension(schemaDefinition, options, extension) {
	    const roots = forExtension(schemaDefinition.roots(), extension);
	    const directives = forExtension(schemaDefinition.appliedDirectives, extension);
	    if (!roots.length && !directives.length) {
	        return undefined;
	    }
	    const rootEntries = orderRoots(roots, options).map((rootType) => `${options.indentString}${rootType.rootKind}: ${rootType.type}`);
	    return printDescription(schemaDefinition, options)
	        + printIsExtension(extension)
	        + 'schema'
	        + printAppliedDirectives(directives, options, true)
	        + (directives.length === 0 ? ' ' : '')
	        + '{\n' + rootEntries.join('\n') + '\n}';
	}
	function isSchemaOfCommonNames(schema) {
	    return schema.appliedDirectives.length === 0 && !schema.description && schema.roots().every(r => r.isDefaultRootName());
	}
	function printType(type, options = exports.defaultPrintOptions) {
	    const definitionAndExtensions = printTypeDefinitionAndExtensions(type, options);
	    (0, utils_1.assert)(definitionAndExtensions.length == 1, `Type ${type} is built from more than 1 definition or extension`);
	    return definitionAndExtensions[0];
	}
	exports.printType = printType;
	function printTypeDefinitionAndExtensions(type, options = exports.defaultPrintOptions) {
	    switch (type.kind) {
	        case 'ScalarType': return printDefinitionAndExtensions(type, options, printScalarDefinitionOrExtension);
	        case 'ObjectType': return printDefinitionAndExtensions(type, options, (t, options, ext) => printFieldBasedTypeDefinitionOrExtension('type', t, options, ext));
	        case 'InterfaceType': return printDefinitionAndExtensions(type, options, (t, options, ext) => printFieldBasedTypeDefinitionOrExtension('interface', t, options, ext));
	        case 'UnionType': return printDefinitionAndExtensions(type, options, printUnionDefinitionOrExtension);
	        case 'EnumType': return printDefinitionAndExtensions(type, options, printEnumDefinitionOrExtension);
	        case 'InputObjectType': return printDefinitionAndExtensions(type, options, printInputDefinitionOrExtension);
	    }
	}
	exports.printTypeDefinitionAndExtensions = printTypeDefinitionAndExtensions;
	function printDirectiveDefinition(directive, options) {
	    const locations = directive.locations.join(' | ');
	    return `${printDescription(directive, options)}directive ${directive}${printArgs(directive.arguments(), options)}${directive.repeatable ? ' repeatable' : ''} on ${locations}`;
	}
	exports.printDirectiveDefinition = printDirectiveDefinition;
	function printAppliedDirectives(appliedDirectives, options, onNewLines = false, endWithNewLine = onNewLines) {
	    if (appliedDirectives.length == 0) {
	        return "";
	    }
	    const joinStr = onNewLines ? '\n' + options.indentString : ' ';
	    const directives = appliedDirectives.map(d => d.toString()).join(joinStr);
	    return onNewLines ? '\n' + options.indentString + directives + (endWithNewLine ? '\n' : '') : ' ' + directives;
	}
	function printDescription(element, options, indentation = '', firstInBlock = true) {
	    if (element.description === undefined || options.noDesciptions) {
	        return '';
	    }
	    const preferMultipleLines = element.description.length > 70;
	    const blockString = printBlockString(element.description, '', preferMultipleLines);
	    const prefix = indentation && !firstInBlock ? '\n' + indentation : indentation;
	    return prefix + blockString.replace(/\n/g, '\n' + indentation) + '\n';
	}
	function printScalarDefinitionOrExtension(type, options, extension) {
	    const directives = forExtension(type.appliedDirectives, extension);
	    if (extension && !directives.length) {
	        return undefined;
	    }
	    return `${printDescription(type, options)}${printIsExtension(extension)}scalar ${type.name}${printAppliedDirectives(directives, options, true, false)}`;
	}
	function printImplementedInterfaces(implementations) {
	    return implementations.length
	        ? ' implements ' + implementations.map(i => i.interface.name).join(' & ')
	        : '';
	}
	function printFieldBasedTypeDefinitionOrExtension(kind, type, options, extension) {
	    const directives = forExtension(type.appliedDirectives, extension);
	    const interfaces = forExtension(type.interfaceImplementations(), extension);
	    const fields = forExtension(type.fields(options.showNonGraphQLBuiltIns), extension);
	    if (!directives.length && !interfaces.length && !fields.length) {
	        return undefined;
	    }
	    return printDescription(type, options)
	        + printIsExtension(extension)
	        + kind + ' ' + type
	        + printImplementedInterfaces(interfaces)
	        + printAppliedDirectives(directives, options, true, fields.length > 0)
	        + (directives.length === 0 ? ' ' : '')
	        + printFields(fields, options);
	}
	function printUnionDefinitionOrExtension(type, options, extension) {
	    const directives = forExtension(type.appliedDirectives, extension);
	    const members = forExtension(type.members(), extension);
	    if (!directives.length && !members.length) {
	        return undefined;
	    }
	    const possibleTypes = members.length ? ' = ' + members.map(m => m.type).join(' | ') : '';
	    return printDescription(type, options)
	        + printIsExtension(extension)
	        + 'union ' + type
	        + printAppliedDirectives(directives, options, true, members.length > 0)
	        + possibleTypes;
	}
	function printEnumDefinitionOrExtension(type, options, extension) {
	    const directives = forExtension(type.appliedDirectives, extension);
	    const values = forExtension(type.values, extension);
	    if (!directives.length && !values.length) {
	        return undefined;
	    }
	    const vals = values.map((v, i) => printDescription(v, options, options.indentString, !i)
	        + options.indentString
	        + v
	        + printAppliedDirectives(v.appliedDirectives, options));
	    return printDescription(type, options)
	        + printIsExtension(extension)
	        + 'enum ' + type
	        + printAppliedDirectives(directives, options, true, vals.length > 0)
	        + (directives.length === 0 ? ' ' : '')
	        + printBlock(vals);
	}
	function printInputDefinitionOrExtension(type, options, extension) {
	    const directives = forExtension(type.appliedDirectives, extension);
	    const fields = forExtension(type.fields(), extension);
	    if (!directives.length && !fields.length) {
	        return undefined;
	    }
	    return printDescription(type, options)
	        + printIsExtension(extension)
	        + 'input ' + type
	        + printAppliedDirectives(directives, options, true, fields.length > 0)
	        + (directives.length === 0 ? ' ' : '')
	        + printFields(fields, options);
	}
	function printFields(fields, options) {
	    return printBlock(fields.map((f, i) => printDescription(f, options, options.indentString, !i)
	        + options.indentString
	        + printField(f, options)
	        + printAppliedDirectives(f.appliedDirectives, options)));
	}
	function printField(field, options) {
	    let args = field.kind == 'FieldDefinition' ? printArgs(field.arguments(), options, options.indentString) : '';
	    let defaultValue = field.kind === 'InputFieldDefinition' && field.defaultValue !== undefined
	        ? ' = ' + (0, values_1.valueToString)(field.defaultValue, field.type)
	        : '';
	    return `${field.name}${args}: ${field.type}${defaultValue}`;
	}
	function printArgs(args, options, indentation = '') {
	    if (args.length === 0) {
	        return '';
	    }
	    if (args.every(arg => !arg.description)) {
	        return '(' + args.map(arg => printArg(arg, options)).join(', ') + ')';
	    }
	    const formattedArgs = args
	        .map((arg, i) => printDescription(arg, options, '  ' + indentation, !i) + '  ' + indentation + printArg(arg, options))
	        .join('\n');
	    return `(\n${formattedArgs}\n${indentation})`;
	}
	function printArg(arg, options) {
	    return `${arg}${printAppliedDirectives(arg.appliedDirectives, options)}`;
	}
	function printBlock(items) {
	    return items.length !== 0 ? '{\n' + items.join('\n') + '\n}' : '';
	}
	function printBlockString(value, indentation = '', preferMultipleLines = false) {
	    const isSingleLine = value.indexOf('\n') === -1;
	    const hasLeadingSpace = value[0] === ' ' || value[0] === '\t';
	    const hasTrailingQuote = value[value.length - 1] === '"';
	    const hasTrailingSlash = value[value.length - 1] === '\\';
	    const printAsMultipleLines = !isSingleLine ||
	        hasTrailingQuote ||
	        hasTrailingSlash ||
	        preferMultipleLines;
	    let result = '';
	    if (printAsMultipleLines && !(isSingleLine && hasLeadingSpace)) {
	        result += '\n' + indentation;
	    }
	    result += indentation ? value.replace(/\n/g, '\n' + indentation) : value;
	    if (printAsMultipleLines) {
	        result += '\n';
	    }
	    return '"""' + result.replace(/"""/g, '\\"""') + '"""';
	}

	}(print));

	var introspection = {};

	Object.defineProperty(introspection, "__esModule", { value: true });
	introspection.addIntrospectionFields = introspection.isIntrospectionName = introspection.introspectionFieldNames = void 0;
	const graphql_1$a = require$$2$1;
	const definitions_1$5 = definitions;
	introspection.introspectionFieldNames = ['__schema', '__type'];
	function isIntrospectionName(name) {
	    return name.startsWith('__');
	}
	introspection.isIntrospectionName = isIntrospectionName;
	function addIntrospectionFields(schema) {
	    if (schema.type('__Schema')) {
	        return;
	    }
	    const typeKindEnum = schema.addType(new definitions_1$5.EnumType('__TypeKind', true));
	    typeKindEnum.addValue('SCALAR');
	    typeKindEnum.addValue('OBJECT');
	    typeKindEnum.addValue('INTERFACE');
	    typeKindEnum.addValue('UNION');
	    typeKindEnum.addValue('ENUM');
	    typeKindEnum.addValue('INPUT_OBJECT');
	    typeKindEnum.addValue('LIST');
	    typeKindEnum.addValue('NON_NULL');
	    const inputValueType = schema.addType(new definitions_1$5.ObjectType('__InputValue', true));
	    const fieldType = schema.addType(new definitions_1$5.ObjectType('__Field', true));
	    const typeType = schema.addType(new definitions_1$5.ObjectType('__Type', true));
	    const enumValueType = schema.addType(new definitions_1$5.ObjectType('__EnumValue', true));
	    typeType.addField('kind', new definitions_1$5.NonNullType(typeKindEnum));
	    typeType.addField('name', schema.stringType());
	    typeType.addField('description', schema.stringType());
	    typeType.addField('fields', new definitions_1$5.ListType(new definitions_1$5.NonNullType(fieldType)))
	        .addArgument('includeDeprecated', schema.booleanType(), false);
	    typeType.addField('interfaces', new definitions_1$5.ListType(new definitions_1$5.NonNullType(typeType)));
	    typeType.addField('possibleTypes', new definitions_1$5.ListType(new definitions_1$5.NonNullType(typeType)));
	    typeType.addField('enumValues', new definitions_1$5.ListType(new definitions_1$5.NonNullType(enumValueType)))
	        .addArgument('includeDeprecated', schema.booleanType(), false);
	    typeType.addField('inputFields', new definitions_1$5.ListType(new definitions_1$5.NonNullType(inputValueType)));
	    typeType.addField('ofType', typeType);
	    typeType.addField('specifiedByURL', schema.stringType());
	    fieldType.addField('name', new definitions_1$5.NonNullType(schema.stringType()));
	    fieldType.addField('description', schema.stringType());
	    fieldType.addField('args', new definitions_1$5.NonNullType(new definitions_1$5.ListType(new definitions_1$5.NonNullType(inputValueType))));
	    fieldType.addField('type', new definitions_1$5.NonNullType(typeType));
	    fieldType.addField('isDeprecated', new definitions_1$5.NonNullType(schema.booleanType()));
	    fieldType.addField('deprecationReason', schema.stringType());
	    inputValueType.addField('name', new definitions_1$5.NonNullType(schema.stringType()));
	    inputValueType.addField('description', schema.stringType());
	    inputValueType.addField('type', new definitions_1$5.NonNullType(typeType));
	    inputValueType.addField('defaultValue', schema.stringType());
	    enumValueType.addField('name', new definitions_1$5.NonNullType(schema.stringType()));
	    enumValueType.addField('description', schema.stringType());
	    enumValueType.addField('isDeprecated', new definitions_1$5.NonNullType(schema.booleanType()));
	    enumValueType.addField('deprecationReason', schema.stringType());
	    const directiveLocationEnum = schema.addType(new definitions_1$5.EnumType('__DirectiveLocation', true));
	    for (const location of Object.values(graphql_1$a.DirectiveLocation)) {
	        directiveLocationEnum.addValue(location);
	    }
	    const directiveType = schema.addType(new definitions_1$5.ObjectType('__Directive', true));
	    directiveType.addField('name', new definitions_1$5.NonNullType(schema.stringType()));
	    directiveType.addField('description', schema.stringType());
	    directiveType.addField('locations', new definitions_1$5.NonNullType(new definitions_1$5.ListType(new definitions_1$5.NonNullType(directiveLocationEnum))));
	    directiveType.addField('args', new definitions_1$5.NonNullType(new definitions_1$5.ListType(new definitions_1$5.NonNullType(inputValueType))));
	    directiveType.addField('isRepeatable', new definitions_1$5.NonNullType(schema.booleanType()));
	    const schemaType = schema.addType(new definitions_1$5.ObjectType('__Schema', true));
	    schemaType.addField('description', schema.stringType());
	    schemaType.addField('types', new definitions_1$5.NonNullType(new definitions_1$5.ListType(new definitions_1$5.NonNullType(typeType))));
	    schemaType.addField('queryType', new definitions_1$5.NonNullType(typeType));
	    schemaType.addField('mutationType', new definitions_1$5.NonNullType(typeType));
	    schemaType.addField('subscriptionType', new definitions_1$5.NonNullType(typeType));
	    schemaType.addField('directives', new definitions_1$5.NonNullType(new definitions_1$5.ListType(new definitions_1$5.NonNullType(directiveType))));
	    let queryRoot = schema.schemaDefinition.rootType('query');
	    if (!queryRoot) {
	        queryRoot = schema.addType(new definitions_1$5.ObjectType('Query'));
	        schema.schemaDefinition.setRoot('query', queryRoot);
	    }
	    queryRoot.addField(new definitions_1$5.FieldDefinition('__schema', true), new definitions_1$5.NonNullType(schemaType));
	    queryRoot.addField(new definitions_1$5.FieldDefinition('__type', true), typeType)
	        .addArgument('name', new definitions_1$5.NonNullType(schema.stringType()));
	}
	introspection.addIntrospectionFields = addIntrospectionFields;

	var require$$10 = /*@__PURE__*/getAugmentedNamespace(validate$4);

	var require$$2 = /*@__PURE__*/getAugmentedNamespace(specifiedRules$1);

	var validate$2 = {};

	Object.defineProperty(validate$2, "__esModule", { value: true });
	validate$2.validateSchema = void 0;
	const definitions_1$4 = definitions;
	const graphql_1$9 = require$$2$1;
	const values_1$1 = values;
	const introspection_1 = introspection;
	const types_1$1 = types;
	function validateSchema(schema) {
	    return new Validator(schema).validate();
	}
	validate$2.validateSchema = validateSchema;
	class InputObjectCircularRefsValidator {
	    constructor(onError) {
	        this.onError = onError;
	        this.visitedTypes = new Set();
	        this.fieldPath = [];
	        this.fieldPathIndexByTypeName = new Map();
	    }
	    detectCycles(type) {
	        if (this.visitedTypes.has(type.name)) {
	            return;
	        }
	        this.visitedTypes.add(type.name);
	        this.fieldPathIndexByTypeName.set(type.name, this.fieldPath.length);
	        for (const field of type.fields()) {
	            if ((0, definitions_1$4.isNonNullType)(field.type) && (0, definitions_1$4.isInputObjectType)(field.type.ofType)) {
	                const fieldType = field.type.ofType;
	                const cycleIndex = this.fieldPathIndexByTypeName.get(fieldType.name);
	                this.fieldPath.push(field);
	                if (cycleIndex === undefined) {
	                    this.detectCycles(fieldType);
	                }
	                else {
	                    const cyclePath = this.fieldPath.slice(cycleIndex);
	                    const pathStr = cyclePath.map((fieldObj) => fieldObj.name).join('.');
	                    this.onError(new graphql_1$9.GraphQLError(`Cannot reference Input Object "${fieldType.name}" within itself through a series of non-null fields: "${pathStr}".`, (0, definitions_1$4.sourceASTs)(...cyclePath)));
	                }
	                this.fieldPath.pop();
	            }
	        }
	        this.fieldPathIndexByTypeName.delete(type.name);
	    }
	}
	class Validator {
	    constructor(schema) {
	        this.schema = schema;
	        this.emptyVariables = new definitions_1$4.VariableDefinitions();
	        this.hasMissingTypes = false;
	        this.errors = [];
	    }
	    validate() {
	        for (const type of this.schema.types()) {
	            this.validateName(type);
	            switch (type.kind) {
	                case 'ObjectType':
	                case 'InterfaceType':
	                    this.validateObjectOrInterfaceType(type);
	                    break;
	                case 'InputObjectType':
	                    this.validateInputObjectType(type);
	                    break;
	                case 'UnionType':
	                    this.validateUnionType(type);
	                    break;
	                case 'EnumType':
	                    this.validateEnumType(type);
	                    break;
	            }
	        }
	        for (const directive of this.schema.allDirectives()) {
	            this.validateName(directive);
	            for (const arg of directive.arguments()) {
	                this.validateArg(arg);
	            }
	            for (const application of directive.applications()) {
	                this.validateDirectiveApplication(directive, application);
	            }
	        }
	        if (!this.hasMissingTypes) {
	            const refsValidator = new InputObjectCircularRefsValidator(e => this.errors.push(e));
	            for (const type of this.schema.types()) {
	                switch (type.kind) {
	                    case 'ObjectType':
	                    case 'InterfaceType':
	                        this.validateImplementedInterfaces(type);
	                        break;
	                    case 'InputObjectType':
	                        refsValidator.detectCycles(type);
	                        break;
	                }
	            }
	        }
	        return this.errors;
	    }
	    validateHasType(elt) {
	        if (!elt.type) {
	            this.errors.push(new graphql_1$9.GraphQLError(`Element ${elt.coordinate} does not have a type set`, elt.sourceAST));
	            this.hasMissingTypes = false;
	        }
	    }
	    validateName(elt) {
	        if ((0, introspection_1.isIntrospectionName)(elt.name)) {
	            return;
	        }
	        const error = (0, graphql_1$9.isValidNameError)(elt.name);
	        if (error) {
	            this.errors.push(elt.sourceAST ? new graphql_1$9.GraphQLError(error.message, elt.sourceAST) : error);
	        }
	    }
	    validateObjectOrInterfaceType(type) {
	        if (!type.hasFields(true)) {
	            this.errors.push(new graphql_1$9.GraphQLError(`Type ${type.name} must define one or more fields.`, type.sourceAST));
	        }
	        for (const field of type.fields()) {
	            this.validateName(field);
	            this.validateHasType(field);
	            for (const arg of field.arguments()) {
	                this.validateArg(arg);
	            }
	        }
	    }
	    validateImplementedInterfaces(type) {
	        if (type.implementsInterface(type.name)) {
	            this.errors.push(new graphql_1$9.GraphQLError(`Type ${type} cannot implement itself because it would create a circular reference.`, (0, definitions_1$4.sourceASTs)(type, type.interfaceImplementation(type.name))));
	        }
	        for (const itf of type.interfaces()) {
	            for (const itfField of itf.fields()) {
	                const field = type.field(itfField.name);
	                if (!field) {
	                    this.errors.push(new graphql_1$9.GraphQLError(`Interface field ${itfField.coordinate} expected but ${type} does not provide it.`, (0, definitions_1$4.sourceASTs)(itfField, type)));
	                    continue;
	                }
	                this.validateHasType(itfField);
	                if (!(0, types_1$1.isSubtype)(itfField.type, field.type)) {
	                    this.errors.push(new graphql_1$9.GraphQLError(`Interface field ${itfField.coordinate} expects type ${itfField.type} but ${field.coordinate} of type ${field.type} is not a proper subtype.`, (0, definitions_1$4.sourceASTs)(itfField, field)));
	                }
	                for (const itfArg of itfField.arguments()) {
	                    const arg = field.argument(itfArg.name);
	                    if (!arg) {
	                        this.errors.push(new graphql_1$9.GraphQLError(`Interface field argument ${itfArg.coordinate} expected but ${field.coordinate} does not provide it.`, (0, definitions_1$4.sourceASTs)(itfArg, field)));
	                        continue;
	                    }
	                    this.validateHasType(itfArg);
	                    if (!(0, types_1$1.sameType)(itfArg.type, arg.type)) {
	                        this.errors.push(new graphql_1$9.GraphQLError(`Interface field argument ${itfArg.coordinate} expects type ${itfArg.type} but ${arg.coordinate} is type ${arg.type}.`, (0, definitions_1$4.sourceASTs)(itfArg, arg)));
	                    }
	                }
	                for (const arg of field.arguments()) {
	                    if (itfField.argument(arg.name)) {
	                        continue;
	                    }
	                    if (arg.isRequired()) {
	                        this.errors.push(new graphql_1$9.GraphQLError(`Field ${field.coordinate} includes required argument ${arg.name} that is missing from the Interface field ${itfField.coordinate}.`, (0, definitions_1$4.sourceASTs)(arg, itfField)));
	                    }
	                }
	            }
	            for (const itfOfItf of itf.interfaces()) {
	                if (!type.implementsInterface(itfOfItf)) {
	                    if (itfOfItf === type) {
	                        this.errors.push(new graphql_1$9.GraphQLError(`Type ${type} cannot implement ${itf} because it would create a circular reference.`, (0, definitions_1$4.sourceASTs)(type, itf)));
	                    }
	                    else {
	                        this.errors.push(new graphql_1$9.GraphQLError(`Type ${type} must implement ${itfOfItf} because it is implemented by ${itf}.`, (0, definitions_1$4.sourceASTs)(type, itf, itfOfItf)));
	                    }
	                }
	            }
	        }
	    }
	    validateInputObjectType(type) {
	        if (!type.hasFields()) {
	            this.errors.push(new graphql_1$9.GraphQLError(`Input Object type ${type.name} must define one or more fields.`, type.sourceAST));
	        }
	        for (const field of type.fields()) {
	            this.validateName(field);
	            this.validateHasType(field);
	            if (field.isRequired() && field.isDeprecated()) {
	                this.errors.push(new graphql_1$9.GraphQLError(`Required input field ${field.coordinate} cannot be deprecated.`, (0, definitions_1$4.sourceASTs)(field.appliedDirectivesOf('deprecated')[0], field)));
	            }
	        }
	    }
	    validateArg(arg) {
	        this.validateName(arg);
	        this.validateHasType(arg);
	        if (arg.isRequired() && arg.isDeprecated()) {
	            this.errors.push(new graphql_1$9.GraphQLError(`Required argument ${arg.coordinate} cannot be deprecated.`, (0, definitions_1$4.sourceASTs)(arg.appliedDirectivesOf('deprecated')[0], arg)));
	        }
	    }
	    validateUnionType(type) {
	        if (type.membersCount() === 0) {
	            this.errors.push(new graphql_1$9.GraphQLError(`Union type ${type.coordinate} must define one or more member types.`, type.sourceAST));
	        }
	    }
	    validateEnumType(type) {
	        if (type.values.length === 0) {
	            this.errors.push(new graphql_1$9.GraphQLError(`Enum type ${type.coordinate} must define one or more values.`, type.sourceAST));
	        }
	        for (const value of type.values) {
	            this.validateName(value);
	            if (value.name === 'true' || value.name === 'false' || value.name === 'null') {
	                this.errors.push(new graphql_1$9.GraphQLError(`Enum type ${type.coordinate} cannot include value: ${value}.`, value.sourceAST));
	            }
	        }
	    }
	    validateDirectiveApplication(definition, application) {
	        for (const argument of definition.arguments()) {
	            const value = application.arguments()[argument.name];
	            if (!value) {
	                continue;
	            }
	            if (!(0, values_1$1.isValidValue)(value, argument, this.emptyVariables)) {
	                const parent = application.parent;
	                const parentDesc = parent instanceof definitions_1$4.NamedSchemaElement
	                    ? parent.coordinate
	                    : 'schema';
	                this.errors.push(new graphql_1$9.GraphQLError(`Invalid value for "${argument.coordinate}" of type "${argument.type}" in application of "${definition.coordinate}" to "${parentDesc}".`, (0, definitions_1$4.sourceASTs)(application, argument)));
	            }
	        }
	    }
	}

	(function (exports) {
	Object.defineProperty(exports, "__esModule", { value: true });
	exports.ObjectType = exports.InterfaceImplementation = exports.ScalarType = exports.SchemaDefinition = exports.RootType = exports.Schema = exports.CoreFeatures = exports.CoreFeature = exports.BuiltIns = exports.NamedSchemaElementWithType = exports.NamedSchemaElement = exports.SchemaElement = exports.Extension = exports.sourceASTs = exports.DirectiveTargetElement = exports.isLeafType = exports.typeFromAST = exports.typeToAST = exports.executableDirectiveLocations = exports.runtimeTypesIntersects = exports.possibleRuntimeTypes = exports.isCompositeType = exports.isAbstractType = exports.isNullableType = exports.baseType = exports.isInputType = exports.isOutputType = exports.isInputObjectType = exports.isUnionType = exports.isEnumType = exports.isInterfaceType = exports.isObjectType = exports.isIDType = exports.isBooleanType = exports.isFloatType = exports.isStringType = exports.isIntType = exports.isCustomScalarType = exports.isScalarType = exports.isNonNullType = exports.isListType = exports.isWrapperType = exports.isNamedType = exports.defaultRootName = exports.allSchemaRootKinds = exports.typenameFieldName = exports.printErrors = exports.printGraphQLErrorsOrRethrow = exports.errorCauses = exports.ErrGraphQLValidationFailed = void 0;
	exports.newNamedType = exports.graphQLBuiltIns = exports.variableDefinitionFromAST = exports.variableDefinitionsFromAST = exports.VariableDefinitions = exports.VariableDefinition = exports.variablesInArguments = exports.isVariable = exports.containsVariable = exports.mergeVariables = exports.Variable = exports.Directive = exports.DirectiveDefinition = exports.EnumValue = exports.ArgumentDefinition = exports.InputFieldDefinition = exports.FieldDefinition = exports.NonNullType = exports.ListType = exports.InputObjectType = exports.EnumType = exports.UnionType = exports.UnionMember = exports.InterfaceType = void 0;
	const graphql_1 = require$$2$1;
	const coreSpec_1 = coreSpec$1;
	const utils_1 = utils;
	const values_1 = values;
	const inaccessibleSpec_1 = inaccessibleSpec;
	const print_1 = print;
	const types_1 = types;
	const introspection_1 = introspection;
	const core_schema_1 = dist$1;
	const error_1 = error$2;
	const validate_1 = require$$10;
	const specifiedRules_1 = require$$2;
	const validate_2 = validate$2;
	const validationErrorCode = 'GraphQLValidationFailed';
	const ErrGraphQLValidationFailed = (causes) => (0, core_schema_1.err)(validationErrorCode, {
	    message: 'The schema is not a valid GraphQL schema',
	    causes
	});
	exports.ErrGraphQLValidationFailed = ErrGraphQLValidationFailed;
	function errorCauses(e) {
	    if (e instanceof error_1.GraphQLErrorExt) {
	        if (e.code === validationErrorCode) {
	            return (e.causes);
	        }
	        return [e];
	    }
	    if (e instanceof graphql_1.GraphQLError) {
	        return [e];
	    }
	    return undefined;
	}
	exports.errorCauses = errorCauses;
	function printGraphQLErrorsOrRethrow(e) {
	    const causes = errorCauses(e);
	    if (!causes) {
	        throw e;
	    }
	    return causes.map(e => (0, graphql_1.printError)(e)).join('\n\n');
	}
	exports.printGraphQLErrorsOrRethrow = printGraphQLErrorsOrRethrow;
	function printErrors(errors) {
	    return errors.map(e => (0, graphql_1.printError)(e)).join('\n\n');
	}
	exports.printErrors = printErrors;
	exports.typenameFieldName = '__typename';
	exports.allSchemaRootKinds = ['query', 'mutation', 'subscription'];
	function defaultRootName(rootKind) {
	    return rootKind.charAt(0).toUpperCase() + rootKind.slice(1);
	}
	exports.defaultRootName = defaultRootName;
	function checkDefaultSchemaRoot(type) {
	    if (type.kind !== 'ObjectType') {
	        return undefined;
	    }
	    switch (type.name) {
	        case 'Query': return 'query';
	        case 'Mutation': return 'mutation';
	        case 'Subscription': return 'subscription';
	        default: return undefined;
	    }
	}
	function isNamedType(type) {
	    return type instanceof BaseNamedType;
	}
	exports.isNamedType = isNamedType;
	function isWrapperType(type) {
	    return isListType(type) || isNonNullType(type);
	}
	exports.isWrapperType = isWrapperType;
	function isListType(type) {
	    return type.kind == 'ListType';
	}
	exports.isListType = isListType;
	function isNonNullType(type) {
	    return type.kind == 'NonNullType';
	}
	exports.isNonNullType = isNonNullType;
	function isScalarType(type) {
	    return type.kind == 'ScalarType';
	}
	exports.isScalarType = isScalarType;
	function isCustomScalarType(type) {
	    return isScalarType(type) && !exports.graphQLBuiltIns.defaultGraphQLBuiltInTypes.includes(type.name);
	}
	exports.isCustomScalarType = isCustomScalarType;
	function isIntType(type) {
	    var _a;
	    return type === ((_a = type.schema()) === null || _a === void 0 ? void 0 : _a.intType());
	}
	exports.isIntType = isIntType;
	function isStringType(type) {
	    var _a;
	    return type === ((_a = type.schema()) === null || _a === void 0 ? void 0 : _a.stringType());
	}
	exports.isStringType = isStringType;
	function isFloatType(type) {
	    var _a;
	    return type === ((_a = type.schema()) === null || _a === void 0 ? void 0 : _a.floatType());
	}
	exports.isFloatType = isFloatType;
	function isBooleanType(type) {
	    var _a;
	    return type === ((_a = type.schema()) === null || _a === void 0 ? void 0 : _a.booleanType());
	}
	exports.isBooleanType = isBooleanType;
	function isIDType(type) {
	    var _a;
	    return type === ((_a = type.schema()) === null || _a === void 0 ? void 0 : _a.idType());
	}
	exports.isIDType = isIDType;
	function isObjectType(type) {
	    return type.kind == 'ObjectType';
	}
	exports.isObjectType = isObjectType;
	function isInterfaceType(type) {
	    return type.kind == 'InterfaceType';
	}
	exports.isInterfaceType = isInterfaceType;
	function isEnumType(type) {
	    return type.kind == 'EnumType';
	}
	exports.isEnumType = isEnumType;
	function isUnionType(type) {
	    return type.kind == 'UnionType';
	}
	exports.isUnionType = isUnionType;
	function isInputObjectType(type) {
	    return type.kind == 'InputObjectType';
	}
	exports.isInputObjectType = isInputObjectType;
	function isOutputType(type) {
	    switch (baseType(type).kind) {
	        case 'ScalarType':
	        case 'ObjectType':
	        case 'UnionType':
	        case 'EnumType':
	        case 'InterfaceType':
	            return true;
	        default:
	            return false;
	    }
	}
	exports.isOutputType = isOutputType;
	function isInputType(type) {
	    switch (baseType(type).kind) {
	        case 'ScalarType':
	        case 'EnumType':
	        case 'InputObjectType':
	            return true;
	        default:
	            return false;
	    }
	}
	exports.isInputType = isInputType;
	function baseType(type) {
	    return isWrapperType(type) ? type.baseType() : type;
	}
	exports.baseType = baseType;
	function isNullableType(type) {
	    return !isNonNullType(type);
	}
	exports.isNullableType = isNullableType;
	function isAbstractType(type) {
	    return isInterfaceType(type) || isUnionType(type);
	}
	exports.isAbstractType = isAbstractType;
	function isCompositeType(type) {
	    return isObjectType(type) || isInterfaceType(type) || isUnionType(type);
	}
	exports.isCompositeType = isCompositeType;
	function possibleRuntimeTypes(type) {
	    switch (type.kind) {
	        case 'InterfaceType': return type.possibleRuntimeTypes();
	        case 'UnionType': return type.types();
	        case 'ObjectType': return [type];
	    }
	}
	exports.possibleRuntimeTypes = possibleRuntimeTypes;
	function runtimeTypesIntersects(t1, t2) {
	    const rt1 = possibleRuntimeTypes(t1);
	    const rt2 = possibleRuntimeTypes(t2);
	    for (const obj1 of rt1) {
	        if (rt2.some(obj2 => obj1.name === obj2.name)) {
	            return true;
	        }
	    }
	    return false;
	}
	exports.runtimeTypesIntersects = runtimeTypesIntersects;
	exports.executableDirectiveLocations = [
	    'QUERY',
	    'MUTATION',
	    'SUBSCRIPTION',
	    'FIELD',
	    'FRAGMENT_DEFINITION',
	    'FRAGMENT_SPREAD',
	    'INLINE_FRAGMENT',
	    'VARIABLE_DEFINITION',
	];
	function typeToAST(type) {
	    switch (type.kind) {
	        case 'ListType':
	            return {
	                kind: 'ListType',
	                type: typeToAST(type.ofType)
	            };
	        case 'NonNullType':
	            return {
	                kind: 'NonNullType',
	                type: typeToAST(type.ofType)
	            };
	        default:
	            return {
	                kind: 'NamedType',
	                name: { kind: 'Name', value: type.name }
	            };
	    }
	}
	exports.typeToAST = typeToAST;
	function typeFromAST(schema, node) {
	    switch (node.kind) {
	        case 'ListType':
	            return new ListType(typeFromAST(schema, node.type));
	        case 'NonNullType':
	            return new NonNullType(typeFromAST(schema, node.type));
	        default:
	            const type = schema.type(node.name.value);
	            if (!type) {
	                throw new graphql_1.GraphQLError(`Unknown type "${node.name.value}"`, node);
	            }
	            return type;
	    }
	}
	exports.typeFromAST = typeFromAST;
	function isLeafType(type) {
	    return isScalarType(type) || isEnumType(type);
	}
	exports.isLeafType = isLeafType;
	class DirectiveTargetElement {
	    constructor(_schema) {
	        this._schema = _schema;
	        this.appliedDirectives = [];
	    }
	    schema() {
	        return this._schema;
	    }
	    appliedDirectivesOf(nameOrDefinition) {
	        const directiveName = typeof nameOrDefinition === 'string' ? nameOrDefinition : nameOrDefinition.name;
	        return this.appliedDirectives.filter(d => d.name == directiveName);
	    }
	    hasAppliedDirective(nameOrDefinition) {
	        const directiveName = typeof nameOrDefinition === 'string' ? nameOrDefinition : nameOrDefinition.name;
	        return this.appliedDirectives.some(d => d.name == directiveName);
	    }
	    applyDirective(defOrDirective, args) {
	        let toAdd;
	        if (defOrDirective instanceof Directive) {
	            if (defOrDirective.schema() && defOrDirective.schema() != this.schema()) {
	                throw new Error(`Cannot add directive ${defOrDirective} to ${this} as it is attached to another schema`);
	            }
	            toAdd = defOrDirective;
	            if (args) {
	                toAdd.setArguments(args);
	            }
	        }
	        else {
	            toAdd = new Directive(defOrDirective.name, args !== null && args !== void 0 ? args : Object.create(null));
	        }
	        Element.prototype['setParent'].call(toAdd, this);
	        this.appliedDirectives.push(toAdd);
	        return toAdd;
	    }
	    appliedDirectivesToDirectiveNodes() {
	        if (this.appliedDirectives.length == 0) {
	            return undefined;
	        }
	        return this.appliedDirectives.map(directive => {
	            return {
	                kind: 'Directive',
	                name: {
	                    kind: graphql_1.Kind.NAME,
	                    value: directive.name,
	                },
	                arguments: directive.argumentsToAST()
	            };
	        });
	    }
	    appliedDirectivesToString() {
	        return this.appliedDirectives.length == 0
	            ? ''
	            : ' ' + this.appliedDirectives.join(' ');
	    }
	    variablesInAppliedDirectives() {
	        return this.appliedDirectives.reduce((acc, d) => mergeVariables(acc, variablesInArguments(d.arguments())), []);
	    }
	}
	exports.DirectiveTargetElement = DirectiveTargetElement;
	function sourceASTs(...elts) {
	    return elts.map(elt => elt === null || elt === void 0 ? void 0 : elt.sourceAST).filter(elt => elt !== undefined);
	}
	exports.sourceASTs = sourceASTs;
	class Element {
	    schema() {
	        if (!this._parent) {
	            return undefined;
	        }
	        else if (this._parent instanceof Schema) {
	            return this._parent;
	        }
	        else {
	            return this._parent.schema();
	        }
	    }
	    get parent() {
	        return this._parent;
	    }
	    setParent(parent) {
	        (0, utils_1.assert)(!this._parent, "Cannot set parent of an already attached element");
	        this._parent = parent;
	        this.onAttached();
	    }
	    onAttached() {
	    }
	    checkUpdate() {
	        if (!this.schema()) {
	            throw error(`Cannot modify detached element ${this}`);
	        }
	    }
	}
	class Extension {
	    get extendedElement() {
	        return this._extendedElement;
	    }
	    setExtendedElement(element) {
	        (0, utils_1.assert)(!this._extendedElement, "Cannot attached already attached extension");
	        this._extendedElement = element;
	    }
	}
	exports.Extension = Extension;
	class SchemaElement extends Element {
	    constructor() {
	        super(...arguments);
	        this._appliedDirectives = [];
	    }
	    get appliedDirectives() {
	        return this._appliedDirectives;
	    }
	    appliedDirectivesOf(nameOrDefinition) {
	        const directiveName = typeof nameOrDefinition === 'string' ? nameOrDefinition : nameOrDefinition.name;
	        return this._appliedDirectives.filter(d => d.name == directiveName);
	    }
	    hasAppliedDirective(nameOrDefinition) {
	        return (typeof nameOrDefinition === 'string'
	            ? this.appliedDirectivesOf(nameOrDefinition)
	            : this.appliedDirectivesOf(nameOrDefinition)).length !== 0;
	    }
	    applyDirective(nameOrDefOrDirective, args) {
	        let toAdd;
	        if (nameOrDefOrDirective instanceof Directive) {
	            this.checkUpdate(nameOrDefOrDirective);
	            toAdd = nameOrDefOrDirective;
	            if (args) {
	                toAdd.setArguments(args);
	            }
	        }
	        else {
	            let name;
	            if (typeof nameOrDefOrDirective === 'string') {
	                this.checkUpdate();
	                const def = this.schema().directive(nameOrDefOrDirective);
	                if (!def) {
	                    throw new graphql_1.GraphQLError(`Cannot apply unkown directive "@${nameOrDefOrDirective}"`);
	                }
	                name = nameOrDefOrDirective;
	            }
	            else {
	                this.checkUpdate(nameOrDefOrDirective);
	                name = nameOrDefOrDirective.name;
	            }
	            toAdd = new Directive(name, args !== null && args !== void 0 ? args : Object.create(null));
	            Element.prototype['setParent'].call(toAdd, this);
	        }
	        this._appliedDirectives.push(toAdd);
	        DirectiveDefinition.prototype['addReferencer'].call(toAdd.definition, toAdd);
	        this.onModification();
	        return toAdd;
	    }
	    removeAppliedDirectives() {
	        const applied = this._appliedDirectives.concat();
	        applied.forEach(d => d.remove());
	    }
	    onModification() {
	        const schema = this.schema();
	        if (schema) {
	            Schema.prototype['onModification'].call(schema);
	        }
	    }
	    isElementBuiltIn() {
	        return false;
	    }
	    removeTypeReferenceInternal(type) {
	        this.removeTypeReference(type);
	    }
	    checkRemoval() {
	        if (this.isElementBuiltIn() && !Schema.prototype['canModifyBuiltIn'].call(this.schema())) {
	            throw error(`Cannot modify built-in ${this}`);
	        }
	    }
	    checkUpdate(addedElement) {
	        super.checkUpdate();
	        if (!Schema.prototype['canModifyBuiltIn'].call(this.schema())) {
	            let thisElement = this;
	            while (thisElement && thisElement instanceof SchemaElement) {
	                if (thisElement.isElementBuiltIn()) {
	                    throw error(`Cannot modify built-in (or part of built-in) ${this}`);
	                }
	                thisElement = thisElement.parent;
	            }
	        }
	        if (addedElement) {
	            const thatSchema = addedElement.schema();
	            if (thatSchema && thatSchema != this.schema()) {
	                throw error(`Cannot add element ${addedElement} to ${this} as it is attached to another schema`);
	            }
	        }
	    }
	}
	exports.SchemaElement = SchemaElement;
	class NamedSchemaElement extends SchemaElement {
	    constructor(name) {
	        super();
	        this._name = name;
	    }
	    get name() {
	        return this._name;
	    }
	}
	exports.NamedSchemaElement = NamedSchemaElement;
	class BaseNamedType extends NamedSchemaElement {
	    constructor(name, isBuiltIn = false) {
	        super(name);
	        this.isBuiltIn = isBuiltIn;
	        this._referencers = new Set();
	        this._extensions = new Set();
	    }
	    addReferencer(referencer) {
	        this._referencers.add(referencer);
	    }
	    removeReferencer(referencer) {
	        this._referencers.delete(referencer);
	    }
	    get coordinate() {
	        return this.name;
	    }
	    *allChildElements() {
	    }
	    extensions() {
	        return this._extensions;
	    }
	    newExtension() {
	        return this.addExtension(new Extension());
	    }
	    addExtension(extension) {
	        this.checkUpdate();
	        if (this._extensions.has(extension)) {
	            return extension;
	        }
	        if (extension.extendedElement) {
	            throw error(`Cannot add extension to type ${this}: it is already added to another type`);
	        }
	        this._extensions.add(extension);
	        Extension.prototype['setExtendedElement'].call(extension, this);
	        this.onModification();
	        return extension;
	    }
	    isIntrospectionType() {
	        return (0, introspection_1.isIntrospectionName)(this.name);
	    }
	    hasExtensionElements() {
	        return this._extensions.size > 0;
	    }
	    hasNonExtensionElements() {
	        return this._appliedDirectives.some(d => d.ofExtension() === undefined) || this.hasNonExtensionInnerElements();
	    }
	    isElementBuiltIn() {
	        return this.isBuiltIn;
	    }
	    rename(newName) {
	        this.checkUpdate();
	        const oldName = this._name;
	        this._name = newName;
	        Schema.prototype['renameTypeInternal'].call(this._parent, oldName, newName);
	        this.onModification();
	    }
	    remove() {
	        if (!this._parent) {
	            return [];
	        }
	        this.checkRemoval();
	        this.onModification();
	        this.removeInnerElements();
	        Schema.prototype['removeTypeInternal'].call(this._parent, this);
	        this.removeAppliedDirectives();
	        this.sourceAST = undefined;
	        const toReturn = (0, utils_1.setValues)(this._referencers).map(r => {
	            SchemaElement.prototype['removeTypeReferenceInternal'].call(r, this);
	            return r;
	        });
	        this._referencers.clear();
	        this._parent = undefined;
	        return toReturn;
	    }
	    referencers() {
	        return (0, utils_1.setValues)(this._referencers);
	    }
	    isReferenced() {
	        return this._referencers.size > 0;
	    }
	    toString() {
	        return this.name;
	    }
	}
	class NamedSchemaElementWithType extends NamedSchemaElement {
	    get type() {
	        return this._type;
	    }
	    set type(type) {
	        if (type) {
	            this.checkUpdate(type);
	        }
	        else {
	            this.checkRemoval();
	        }
	        if (this._type) {
	            removeReferenceToType(this, this._type);
	        }
	        this._type = type;
	        if (type) {
	            addReferenceToType(this, type);
	        }
	    }
	    removeTypeReference(type) {
	        (0, utils_1.assert)(this._type && baseType(this._type) === type, () => `Cannot remove reference to type ${type} on ${this} as its type is ${this._type}`);
	        this._type = undefined;
	    }
	}
	exports.NamedSchemaElementWithType = NamedSchemaElementWithType;
	function error(message) {
	    return new graphql_1.GraphQLError(message);
	}
	class BaseExtensionMember extends Element {
	    ofExtension() {
	        return this._extension;
	    }
	    setOfExtension(extension) {
	        var _a;
	        this.checkUpdate();
	        if (extension && !((_a = this.parent) === null || _a === void 0 ? void 0 : _a.extensions().has(extension))) {
	            throw error(`Cannot set object as part of the provided extension: it is not an extension of parent ${this.parent}`);
	        }
	        this._extension = extension;
	    }
	    remove() {
	        this.removeInner();
	        Schema.prototype['onModification'].call(this.schema());
	        this._extension = undefined;
	        this._parent = undefined;
	    }
	}
	function sortedMemberNames(u) {
	    return u.members().map(m => m.type.name).sort((n1, n2) => n1.localeCompare(n2));
	}
	class BuiltIns {
	    constructor() {
	        this.defaultGraphQLBuiltInTypes = ['Int', 'Float', 'String', 'Boolean', 'ID'];
	        this.defaultGraphQLBuiltInDirectives = ['include', 'skip', 'deprecated', 'specifiedBy'];
	    }
	    addBuiltInTypes(schema) {
	        this.defaultGraphQLBuiltInTypes.forEach(t => this.addBuiltInScalar(schema, t));
	    }
	    addBuiltInDirectives(schema) {
	        for (const name of ['include', 'skip']) {
	            this.addBuiltInDirective(schema, name)
	                .addLocations('FIELD', 'FRAGMENT_SPREAD', 'INLINE_FRAGMENT')
	                .addArgument('if', new NonNullType(schema.booleanType()));
	        }
	        this.addBuiltInDirective(schema, 'deprecated')
	            .addLocations('FIELD_DEFINITION', 'ENUM_VALUE', 'ARGUMENT_DEFINITION', 'INPUT_FIELD_DEFINITION')
	            .addArgument('reason', schema.stringType(), 'No longer supported');
	        this.addBuiltInDirective(schema, 'specifiedBy')
	            .addLocations('SCALAR')
	            .addArgument('url', new NonNullType(schema.stringType()));
	    }
	    isGraphQLBuiltIn(element) {
	        if ((0, introspection_1.isIntrospectionName)(element.name)) {
	            return true;
	        }
	        if (element instanceof FieldDefinition) {
	            return false;
	        }
	        else if (element instanceof DirectiveDefinition) {
	            return this.defaultGraphQLBuiltInDirectives.includes(element.name);
	        }
	        else {
	            return this.defaultGraphQLBuiltInTypes.includes(element.name);
	        }
	    }
	    prepareValidation(_) {
	    }
	    onValidation(schema, unvalidatedDirectives) {
	        const errors = [];
	        for (const type of schema.builtInTypes(undefined, true)) {
	            const maybeRedefined = schema.type(type.name);
	            if (!maybeRedefined.isBuiltIn) {
	                this.ensureSameTypeStructure(type, maybeRedefined, errors);
	            }
	        }
	        for (const directive of schema.builtInDirectives(true)) {
	            if (unvalidatedDirectives && unvalidatedDirectives.includes(directive.name)) {
	                continue;
	            }
	            const maybeRedefined = schema.directive(directive.name);
	            if (!maybeRedefined.isBuiltIn) {
	                this.ensureSameDirectiveStructure(directive, maybeRedefined, errors);
	            }
	        }
	        return errors;
	    }
	    validationRules() {
	        return specifiedRules_1.specifiedSDLRules;
	    }
	    maybeUpdateSubgraphDocument(_, document) {
	        return document;
	    }
	    ensureSameDirectiveStructure(builtIn, manuallyDefined, errors) {
	        this.ensureSameArguments(builtIn, manuallyDefined, `directive ${builtIn}`, errors);
	        if (!builtIn.repeatable && manuallyDefined.repeatable) {
	            errors.push(error(`Invalid redefinition of built-in directive ${builtIn}: ${builtIn} should${builtIn.repeatable ? "" : " not"} be repeatable`));
	        }
	        if (!manuallyDefined.locations.every(loc => builtIn.locations.includes(loc))) {
	            errors.push(error(`Invalid redefinition of built-in directive ${builtIn}: ${builtIn} should have locations ${builtIn.locations.join(', ')}, but found (non-subset) ${manuallyDefined.locations.join(', ')}`));
	        }
	    }
	    ensureSameArguments(builtIn, manuallyDefined, what, errors) {
	        const expectedArguments = builtIn.arguments();
	        const foundArguments = manuallyDefined.arguments();
	        if (expectedArguments.length !== foundArguments.length) {
	            errors.push(error(`Invalid redefinition of built-in ${what}: should have ${expectedArguments.length} arguments but ${foundArguments.length} found in redefinition`));
	            return;
	        }
	        for (const expectedArgument of expectedArguments) {
	            const foundArgument = manuallyDefined.argument(expectedArgument.name);
	            const expectedType = expectedArgument.type;
	            let actualType = foundArgument.type;
	            if (isNonNullType(actualType) && !isNonNullType(expectedType)) {
	                actualType = actualType.ofType;
	            }
	            if (!(0, types_1.sameType)(expectedType, actualType)) {
	                errors.push(error(`Invalid redefinition of built-in ${what}: ${expectedArgument.coordinate} should have type ${expectedArgument.type} but found type ${foundArgument.type}`));
	            }
	            else if (!isNonNullType(actualType) && !(0, values_1.valueEquals)(expectedArgument.defaultValue, foundArgument.defaultValue)) {
	                errors.push(error(`Invalid redefinition of built-in ${what}: ${expectedArgument.coordinate} should have default value ${(0, values_1.valueToString)(expectedArgument.defaultValue)} but found default value ${(0, values_1.valueToString)(foundArgument.defaultValue)}`));
	            }
	        }
	    }
	    ensureSameTypeStructure(builtIn, manuallyDefined, errors) {
	        if (builtIn.kind !== manuallyDefined.kind) {
	            errors.push(error(`Invalid redefinition of built-in type ${builtIn}: ${builtIn} should be a ${builtIn.kind} type but redefined as a ${manuallyDefined.kind}`));
	            return;
	        }
	        switch (builtIn.kind) {
	            case 'ScalarType':
	                return;
	            case 'ObjectType':
	                const redefinedObject = manuallyDefined;
	                for (const builtInField of builtIn.fields()) {
	                    const redefinedField = redefinedObject.field(builtInField.name);
	                    if (!redefinedField) {
	                        errors.push(error(`Invalid redefinition of built-in type ${builtIn}: redefinition is missing field ${builtInField}`));
	                        return;
	                    }
	                    let rType = redefinedField.type;
	                    if (!isNonNullType(builtInField.type) && isNonNullType(rType)) {
	                        rType = rType.ofType;
	                    }
	                    if (!(0, types_1.sameType)(builtInField.type, rType)) {
	                        errors.push(error(`Invalid redefinition of field ${builtInField} of built-in type ${builtIn}: should have type ${builtInField.type} but redefined with type ${redefinedField.type}`));
	                        return;
	                    }
	                    this.ensureSameArguments(builtInField, redefinedField, `field ${builtInField.coordinate}`, errors);
	                }
	                break;
	            case 'UnionType':
	                const redefinedUnion = manuallyDefined;
	                const builtInMembers = sortedMemberNames(builtIn);
	                const redefinedMembers = sortedMemberNames(redefinedUnion);
	                if (!(0, utils_1.arrayEquals)(builtInMembers, redefinedMembers)) {
	                    errors.push(error(`Invalid redefinition of built-in type ${builtIn}: redefinition has members [${redefinedMembers}] but should have members [${builtInMembers}]`));
	                }
	                break;
	            default:
	                errors.push(error(`Invalid redefinition of built-in type ${builtIn}: cannot redefine ${builtIn.kind} built-in types`));
	        }
	    }
	    addBuiltInScalar(schema, name) {
	        return schema.addType(new ScalarType(name, true));
	    }
	    addBuiltInObject(schema, name) {
	        return schema.addType(new ObjectType(name, true));
	    }
	    addBuiltInUnion(schema, name) {
	        return schema.addType(new UnionType(name, true));
	    }
	    addBuiltInDirective(schema, name) {
	        return schema.addDirectiveDefinition(new DirectiveDefinition(name, true));
	    }
	    addBuiltInField(parentType, name, type) {
	        return parentType.addField(new FieldDefinition(name, true), type);
	    }
	    getTypedDirective(schema, name) {
	        const directive = schema.directive(name);
	        if (!directive) {
	            throw new Error(`The provided schema has not be built with the ${name} directive built-in`);
	        }
	        return directive;
	    }
	    includeDirective(schema) {
	        return this.getTypedDirective(schema, 'include');
	    }
	    skipDirective(schema) {
	        return this.getTypedDirective(schema, 'skip');
	    }
	    deprecatedDirective(schema) {
	        return this.getTypedDirective(schema, 'deprecated');
	    }
	    specifiedByDirective(schema) {
	        return this.getTypedDirective(schema, 'specifiedBy');
	    }
	}
	exports.BuiltIns = BuiltIns;
	class CoreFeature {
	    constructor(url, nameInSchema, directive, purpose) {
	        this.url = url;
	        this.nameInSchema = nameInSchema;
	        this.directive = directive;
	        this.purpose = purpose;
	    }
	    isFeatureDefinition(element) {
	        return element.name.startsWith(this.nameInSchema + '__')
	            || (element.kind === 'DirectiveDefinition' && element.name === this.nameInSchema);
	    }
	}
	exports.CoreFeature = CoreFeature;
	class CoreFeatures {
	    constructor(coreItself) {
	        this.coreItself = coreItself;
	        this.byAlias = new Map();
	        this.byIdentity = new Map();
	        this.add(coreItself);
	        const coreDef = coreSpec_1.CORE_VERSIONS.find(coreItself.url.version);
	        if (!coreDef) {
	            throw error(`Schema uses unknown version ${coreItself.url.version} of the core spec (known versions: ${coreSpec_1.CORE_VERSIONS.versions().join(', ')})`);
	        }
	        this.coreDefinition = coreDef;
	    }
	    getByIdentity(identity) {
	        return this.byIdentity.get(identity);
	    }
	    allFeatures() {
	        return this.byIdentity.values();
	    }
	    removeFeature(featureIdentity) {
	        const feature = this.byIdentity.get(featureIdentity);
	        if (feature) {
	            this.byIdentity.delete(featureIdentity);
	            this.byAlias.delete(feature.nameInSchema);
	        }
	    }
	    maybeAddFeature(directive) {
	        var _a, _b;
	        if (((_a = directive.definition) === null || _a === void 0 ? void 0 : _a.name) !== this.coreItself.nameInSchema) {
	            return undefined;
	        }
	        const args = directive.arguments();
	        const url = coreSpec_1.FeatureUrl.parse(args.feature);
	        const existing = this.byIdentity.get(url.identity);
	        if (existing) {
	            throw error(`Duplicate inclusion of feature ${url.identity}`);
	        }
	        const feature = new CoreFeature(url, (_b = args.as) !== null && _b !== void 0 ? _b : url.name, directive, args.for);
	        this.add(feature);
	        return feature;
	    }
	    add(feature) {
	        this.byAlias.set(feature.nameInSchema, feature);
	        this.byIdentity.set(feature.url.identity, feature);
	    }
	}
	exports.CoreFeatures = CoreFeatures;
	const toASTPrintOptions = { ...print_1.defaultPrintOptions, showNonGraphQLBuiltIns: true };
	class Schema {
	    constructor(builtIns = exports.graphQLBuiltIns) {
	        this.builtIns = builtIns;
	        this._builtInTypes = new utils_1.MapWithCachedArrays();
	        this._types = new utils_1.MapWithCachedArrays();
	        this._builtInDirectives = new utils_1.MapWithCachedArrays();
	        this._directives = new utils_1.MapWithCachedArrays();
	        this.isConstructed = false;
	        this.isValidated = false;
	        this._schemaDefinition = new SchemaDefinition();
	        Element.prototype['setParent'].call(this._schemaDefinition, this);
	        builtIns.addBuiltInTypes(this);
	        builtIns.addBuiltInDirectives(this);
	        this.isConstructed = true;
	    }
	    canModifyBuiltIn() {
	        return !this.isConstructed;
	    }
	    runWithBuiltInModificationAllowed(fct) {
	        const wasConstructed = this.isConstructed;
	        this.isConstructed = false;
	        fct();
	        this.isConstructed = wasConstructed;
	    }
	    renameTypeInternal(oldName, newName) {
	        this._types.set(newName, this._types.get(oldName));
	        this._types.delete(oldName);
	    }
	    removeTypeInternal(type) {
	        this._types.delete(type.name);
	    }
	    removeDirectiveInternal(definition) {
	        this._directives.delete(definition.name);
	    }
	    markAsCoreSchema(coreItself) {
	        this._coreFeatures = new CoreFeatures(coreItself);
	    }
	    unmarkAsCoreSchema() {
	        this._coreFeatures = undefined;
	    }
	    onModification() {
	        if (this.isConstructed) {
	            this.invalidate();
	            this.cachedDocument = undefined;
	            this.apiSchema = undefined;
	        }
	    }
	    forceSetCachedDocument(document, addNonGraphQLBuiltIns = true) {
	        this.cachedDocument = addNonGraphQLBuiltIns
	            ? this.builtIns.maybeUpdateSubgraphDocument(this, document)
	            : document;
	    }
	    isCoreSchema() {
	        return this.coreFeatures !== undefined;
	    }
	    get coreFeatures() {
	        return this._coreFeatures;
	    }
	    toAST() {
	        if (!this.cachedDocument) {
	            this.forceSetCachedDocument((0, graphql_1.parse)((0, print_1.printSchema)(this, toASTPrintOptions), { noLocation: true }), false);
	        }
	        return this.cachedDocument;
	    }
	    toAPISchema() {
	        if (!this.apiSchema) {
	            this.validate();
	            const apiSchema = this.clone();
	            (0, inaccessibleSpec_1.removeInaccessibleElements)(apiSchema);
	            const coreFeatures = apiSchema.coreFeatures;
	            if (coreFeatures) {
	                for (const coreFeature of coreFeatures.allFeatures()) {
	                    (0, coreSpec_1.removeFeatureElements)(apiSchema, coreFeature);
	                }
	            }
	            (0, utils_1.assert)(!apiSchema.isCoreSchema(), "The API schema shouldn't be a core schema");
	            apiSchema.validate();
	            this.apiSchema = apiSchema;
	        }
	        return this.apiSchema;
	    }
	    toGraphQLJSSchema() {
	        return (0, graphql_1.buildASTSchema)(this.toAST());
	    }
	    get schemaDefinition() {
	        return this._schemaDefinition;
	    }
	    types(kind, includeNonGraphQLBuiltIns = false) {
	        const allKinds = this._types.values();
	        const forKind = (kind ? allKinds.filter(t => t.kind === kind) : allKinds);
	        return includeNonGraphQLBuiltIns
	            ? this.builtInTypes(kind).filter(t => !exports.graphQLBuiltIns.isGraphQLBuiltIn(t)).concat(forKind)
	            : forKind;
	    }
	    builtInTypes(kind, includeShadowed = false) {
	        const allBuiltIns = this._builtInTypes.values();
	        const forKind = (kind ? allBuiltIns.filter(t => t.kind === kind) : allBuiltIns);
	        return includeShadowed
	            ? forKind
	            : forKind.filter(t => !this.isShadowedBuiltInType(t));
	    }
	    isShadowedBuiltInType(type) {
	        return type.isBuiltIn && this._types.has(type.name);
	    }
	    allTypes(kind) {
	        return this.builtInTypes(kind).concat(this.types(kind));
	    }
	    type(name) {
	        const type = this._types.get(name);
	        return type ? type : this._builtInTypes.get(name);
	    }
	    typeOfKind(name, kind) {
	        const type = this.type(name);
	        return type && type.kind === kind ? type : undefined;
	    }
	    intType() {
	        return this._builtInTypes.get('Int');
	    }
	    floatType() {
	        return this._builtInTypes.get('Float');
	    }
	    stringType() {
	        return this._builtInTypes.get('String');
	    }
	    booleanType() {
	        return this._builtInTypes.get('Boolean');
	    }
	    idType() {
	        return this._builtInTypes.get('ID');
	    }
	    addType(type) {
	        const existing = this.type(type.name);
	        if (existing && !existing.isBuiltIn) {
	            throw error(`Type ${type} already exists in this schema`);
	        }
	        if (type.parent) {
	            if (type.parent == this) {
	                return type;
	            }
	            throw error(`Cannot add type ${type} to this schema; it is already attached to another schema`);
	        }
	        if (type.isBuiltIn) {
	            if (!this.isConstructed) {
	                this._builtInTypes.set(type.name, type);
	            }
	            else {
	                throw error(`Cannot add built-in ${type} to this schema (built-ins can only be added at schema construction time)`);
	            }
	        }
	        else {
	            this._types.set(type.name, type);
	        }
	        Element.prototype['setParent'].call(type, this);
	        const defaultSchemaRoot = checkDefaultSchemaRoot(type);
	        if (defaultSchemaRoot && !this.schemaDefinition.root(defaultSchemaRoot)) {
	            this.schemaDefinition.setRoot(defaultSchemaRoot, type);
	        }
	        this.onModification();
	        return type;
	    }
	    directives(includeNonGraphQLBuiltIns = false) {
	        return includeNonGraphQLBuiltIns
	            ? this.builtInDirectives().filter(d => !exports.graphQLBuiltIns.isGraphQLBuiltIn(d)).concat(this._directives.values())
	            : this._directives.values();
	    }
	    builtInDirectives(includeShadowed = false) {
	        return includeShadowed
	            ? this._builtInDirectives.values()
	            : this._builtInDirectives.values().filter(d => !this.isShadowedBuiltInDirective(d));
	    }
	    allDirectives() {
	        return this.builtInDirectives().concat(this.directives());
	    }
	    isShadowedBuiltInDirective(directive) {
	        return directive.isBuiltIn && this._directives.has(directive.name);
	    }
	    directive(name) {
	        const directive = this._directives.get(name);
	        return directive ? directive : this._builtInDirectives.get(name);
	    }
	    *allNamedSchemaElement() {
	        for (const type of this.types()) {
	            yield type;
	            yield* type.allChildElements();
	        }
	        for (const directive of this.directives()) {
	            yield directive;
	            yield* directive.arguments();
	        }
	    }
	    *allSchemaElement() {
	        yield this._schemaDefinition;
	        yield* this.allNamedSchemaElement();
	    }
	    addDirectiveDefinition(directiveOrName) {
	        const definition = typeof directiveOrName === 'string' ? new DirectiveDefinition(directiveOrName) : directiveOrName;
	        const existing = this.directive(definition.name);
	        if (existing && !existing.isBuiltIn) {
	            throw error(`Directive ${definition} already exists in this schema`);
	        }
	        if (definition.parent) {
	            if (definition.parent == this) {
	                return definition;
	            }
	            throw error(`Cannot add directive ${definition} to this schema; it is already attached to another schema`);
	        }
	        if (definition.isBuiltIn) {
	            if (!this.isConstructed) {
	                this._builtInDirectives.set(definition.name, definition);
	            }
	            else {
	                throw error(`Cannot add built-in ${definition} to this schema (built-ins can only be added at schema construction time)`);
	            }
	        }
	        else {
	            this._directives.set(definition.name, definition);
	        }
	        Element.prototype['setParent'].call(definition, this);
	        this.onModification();
	        return definition;
	    }
	    invalidate() {
	        this.isValidated = false;
	    }
	    validate() {
	        if (this.isValidated) {
	            return;
	        }
	        this.runWithBuiltInModificationAllowed(() => {
	            this.builtIns.prepareValidation(this);
	            (0, introspection_1.addIntrospectionFields)(this);
	        });
	        let errors = (0, validate_1.validateSDL)(this.toAST(), undefined, this.builtIns.validationRules());
	        errors = errors.concat((0, validate_2.validateSchema)(this));
	        if (errors.length === 0) {
	            this.runWithBuiltInModificationAllowed(() => {
	                errors = this.builtIns.onValidation(this);
	            });
	        }
	        if (errors.length > 0) {
	            throw (0, exports.ErrGraphQLValidationFailed)(errors);
	        }
	        this.isValidated = true;
	    }
	    clone(builtIns) {
	        const cloned = new Schema(builtIns !== null && builtIns !== void 0 ? builtIns : this.builtIns);
	        copy(this, cloned);
	        if (this.isValidated) {
	            cloned.validate();
	        }
	        return cloned;
	    }
	}
	exports.Schema = Schema;
	class RootType extends BaseExtensionMember {
	    constructor(rootKind, type) {
	        super();
	        this.rootKind = rootKind;
	        this.type = type;
	    }
	    isDefaultRootName() {
	        return defaultRootName(this.rootKind) == this.type.name;
	    }
	    removeInner() {
	        SchemaDefinition.prototype['removeRootType'].call(this._parent, this);
	    }
	}
	exports.RootType = RootType;
	class SchemaDefinition extends SchemaElement {
	    constructor() {
	        super(...arguments);
	        this.kind = 'SchemaDefinition';
	        this._roots = new utils_1.MapWithCachedArrays();
	        this._extensions = new Set();
	    }
	    roots() {
	        return this._roots.values();
	    }
	    applyDirective(nameOrDefOrDirective, args) {
	        var _a;
	        const applied = super.applyDirective(nameOrDefOrDirective, args);
	        const schema = this.schema();
	        const coreFeatures = schema.coreFeatures;
	        if ((0, coreSpec_1.isCoreSpecDirectiveApplication)(applied)) {
	            if (coreFeatures) {
	                throw error(`Invalid duplicate application of the @core feature`);
	            }
	            const schemaDirective = applied;
	            const args = schemaDirective.arguments();
	            const url = coreSpec_1.FeatureUrl.parse(args.feature);
	            const core = new CoreFeature(url, (_a = args.as) !== null && _a !== void 0 ? _a : 'core', schemaDirective, args.for);
	            Schema.prototype['markAsCoreSchema'].call(schema, core);
	        }
	        else if (coreFeatures) {
	            CoreFeatures.prototype['maybeAddFeature'].call(coreFeatures, applied);
	        }
	        this.onModification();
	        return applied;
	    }
	    root(rootKind) {
	        return this._roots.get(rootKind);
	    }
	    rootType(rootKind) {
	        var _a;
	        return (_a = this.root(rootKind)) === null || _a === void 0 ? void 0 : _a.type;
	    }
	    setRoot(rootKind, nameOrType) {
	        let toSet;
	        if (typeof nameOrType === 'string') {
	            this.checkUpdate();
	            const obj = this.schema().type(nameOrType);
	            if (!obj) {
	                throw new graphql_1.GraphQLError(`Cannot set schema ${rootKind} root to unknown type ${nameOrType}`);
	            }
	            else if (obj.kind != 'ObjectType') {
	                throw new graphql_1.GraphQLError(`${defaultRootName(rootKind)} root type must be an Object type${rootKind === 'query' ? '' : ' if provided'}, it cannot be set to ${nameOrType} (an ${obj.kind}).`);
	            }
	            toSet = new RootType(rootKind, obj);
	        }
	        else {
	            this.checkUpdate(nameOrType);
	            toSet = new RootType(rootKind, nameOrType);
	        }
	        const prevRoot = this._roots.get(rootKind);
	        if (prevRoot) {
	            removeReferenceToType(this, prevRoot.type);
	        }
	        this._roots.set(rootKind, toSet);
	        Element.prototype['setParent'].call(toSet, this);
	        addReferenceToType(this, toSet.type);
	        this.onModification();
	        return toSet;
	    }
	    extensions() {
	        return this._extensions;
	    }
	    newExtension() {
	        return this.addExtension(new Extension());
	    }
	    addExtension(extension) {
	        this.checkUpdate();
	        if (this._extensions.has(extension)) {
	            return extension;
	        }
	        if (extension.extendedElement) {
	            throw error(`Cannot add extension to this schema: extension is already added to another schema`);
	        }
	        this._extensions.add(extension);
	        Extension.prototype['setExtendedElement'].call(extension, this);
	        this.onModification();
	        return extension;
	    }
	    removeRootType(rootType) {
	        this._roots.delete(rootType.rootKind);
	        removeReferenceToType(this, rootType.type);
	    }
	    removeTypeReference(toRemove) {
	        for (const rootType of this.roots()) {
	            if (rootType.type == toRemove) {
	                this._roots.delete(rootType.rootKind);
	            }
	        }
	    }
	    toString() {
	        return `schema[${this._roots.keys().join(', ')}]`;
	    }
	}
	exports.SchemaDefinition = SchemaDefinition;
	class ScalarType extends BaseNamedType {
	    constructor() {
	        super(...arguments);
	        this.kind = 'ScalarType';
	    }
	    removeTypeReference(type) {
	        (0, utils_1.assert)(false, `Scalar type ${this} can't reference other types; shouldn't be asked to remove reference to ${type}`);
	    }
	    hasNonExtensionInnerElements() {
	        return false;
	    }
	    removeInnerElements() {
	    }
	}
	exports.ScalarType = ScalarType;
	class InterfaceImplementation extends BaseExtensionMember {
	    constructor(itf) {
	        super();
	        this.interface = itf;
	    }
	    removeInner() {
	        FieldBasedType.prototype['removeInterfaceImplementation'].call(this._parent, this.interface);
	    }
	    toString() {
	        return `'implements ${this.interface}'`;
	    }
	}
	exports.InterfaceImplementation = InterfaceImplementation;
	class FieldBasedType extends BaseNamedType {
	    constructor() {
	        super(...arguments);
	        this._interfaceImplementations = new utils_1.MapWithCachedArrays();
	        this._fields = new utils_1.MapWithCachedArrays();
	    }
	    onAttached() {
	        Schema.prototype['runWithBuiltInModificationAllowed'].call(this.schema(), () => {
	            this.addField(new FieldDefinition(exports.typenameFieldName, true), new NonNullType(this.schema().stringType()));
	        });
	    }
	    removeFieldInternal(field) {
	        this._fields.delete(field.name);
	        this._cachedNonBuiltInFields = undefined;
	    }
	    interfaceImplementations() {
	        return this._interfaceImplementations.values();
	    }
	    interfaceImplementation(type) {
	        return this._interfaceImplementations.get(typeof type === 'string' ? type : type.name);
	    }
	    interfaces() {
	        return this.interfaceImplementations().map(impl => impl.interface);
	    }
	    implementsInterface(type) {
	        return this._interfaceImplementations.has(typeof type === 'string' ? type : type.name);
	    }
	    addImplementedInterface(nameOrItfOrItfImpl) {
	        let toAdd;
	        if (nameOrItfOrItfImpl instanceof InterfaceImplementation) {
	            this.checkUpdate(nameOrItfOrItfImpl);
	            toAdd = nameOrItfOrItfImpl;
	        }
	        else {
	            let itf;
	            if (typeof nameOrItfOrItfImpl === 'string') {
	                this.checkUpdate();
	                const maybeItf = this.schema().type(nameOrItfOrItfImpl);
	                if (!maybeItf) {
	                    throw new graphql_1.GraphQLError(`Cannot implement unkown type ${nameOrItfOrItfImpl}`);
	                }
	                else if (maybeItf.kind != 'InterfaceType') {
	                    throw new graphql_1.GraphQLError(`Cannot implement non-interface type ${nameOrItfOrItfImpl} (of type ${maybeItf.kind})`);
	                }
	                itf = maybeItf;
	            }
	            else {
	                itf = nameOrItfOrItfImpl;
	            }
	            toAdd = new InterfaceImplementation(itf);
	        }
	        const existing = this._interfaceImplementations.get(toAdd.interface.name);
	        if (!existing) {
	            this._interfaceImplementations.set(toAdd.interface.name, toAdd);
	            addReferenceToType(this, toAdd.interface);
	            Element.prototype['setParent'].call(toAdd, this);
	            this.onModification();
	            return toAdd;
	        }
	        else {
	            return existing;
	        }
	    }
	    fields(includeNonGraphQLBuiltIns = false) {
	        if (includeNonGraphQLBuiltIns) {
	            return this.allFields().filter(f => !exports.graphQLBuiltIns.isGraphQLBuiltIn(f));
	        }
	        if (!this._cachedNonBuiltInFields) {
	            this._cachedNonBuiltInFields = this._fields.values().filter(f => !f.isBuiltIn);
	        }
	        return this._cachedNonBuiltInFields;
	    }
	    hasFields(includeNonGraphQLBuiltIns = false) {
	        return this.fields(includeNonGraphQLBuiltIns).length > 0;
	    }
	    builtInFields() {
	        return this.allFields().filter(f => f.isBuiltIn);
	    }
	    allFields() {
	        return this._fields.values();
	    }
	    field(name) {
	        return this._fields.get(name);
	    }
	    typenameField() {
	        return this.field(exports.typenameFieldName);
	    }
	    addField(nameOrField, type) {
	        let toAdd;
	        if (typeof nameOrField === 'string') {
	            this.checkUpdate();
	            toAdd = new FieldDefinition(nameOrField);
	        }
	        else {
	            this.checkUpdate(nameOrField);
	            toAdd = nameOrField;
	        }
	        if (this.field(toAdd.name)) {
	            throw error(`Field ${toAdd.name} already exists on ${this}`);
	        }
	        if (type && !isOutputType(type)) {
	            throw error(`Invalid input type ${type} for field ${toAdd.name}: object and interface field types should be output types.`);
	        }
	        this._fields.set(toAdd.name, toAdd);
	        this._cachedNonBuiltInFields = undefined;
	        Element.prototype['setParent'].call(toAdd, this);
	        if (type) {
	            toAdd.type = type;
	        }
	        this.onModification();
	        return toAdd;
	    }
	    *allChildElements() {
	        for (const field of this._fields.values()) {
	            yield field;
	            yield* field.arguments();
	        }
	    }
	    removeInterfaceImplementation(itf) {
	        this._interfaceImplementations.delete(itf.name);
	        removeReferenceToType(this, itf);
	    }
	    removeTypeReference(type) {
	        this._interfaceImplementations.delete(type.name);
	    }
	    removeInnerElements() {
	        for (const interfaceImpl of this.interfaceImplementations()) {
	            interfaceImpl.remove();
	        }
	        for (const field of this.allFields()) {
	            if (field.isBuiltIn) {
	                FieldDefinition.prototype['removeParent'].call(field);
	            }
	            else {
	                field.remove();
	            }
	        }
	    }
	    hasNonExtensionInnerElements() {
	        return this.interfaceImplementations().some(itf => itf.ofExtension() === undefined)
	            || this.fields().some(f => f.ofExtension() === undefined);
	    }
	}
	class ObjectType extends FieldBasedType {
	    constructor() {
	        super(...arguments);
	        this.kind = 'ObjectType';
	    }
	    isRootType() {
	        const schema = this.schema();
	        if (!schema) {
	            return false;
	        }
	        return schema.schemaDefinition.roots().some(rt => rt.type == this);
	    }
	    isQueryRootType() {
	        var _a;
	        const schema = this.schema();
	        if (!schema) {
	            return false;
	        }
	        return ((_a = schema.schemaDefinition.root('query')) === null || _a === void 0 ? void 0 : _a.type) === this;
	    }
	}
	exports.ObjectType = ObjectType;
	class InterfaceType extends FieldBasedType {
	    constructor() {
	        super(...arguments);
	        this.kind = 'InterfaceType';
	    }
	    allImplementations() {
	        return (0, utils_1.setValues)(this._referencers).filter(ref => ref.kind === 'ObjectType' || ref.kind === 'InterfaceType');
	    }
	    possibleRuntimeTypes() {
	        return this.allImplementations().filter(impl => impl.kind === 'ObjectType');
	    }
	    isPossibleRuntimeType(type) {
	        const typeName = typeof type === 'string' ? type : type.name;
	        return this.possibleRuntimeTypes().some(t => t.name == typeName);
	    }
	}
	exports.InterfaceType = InterfaceType;
	class UnionMember extends BaseExtensionMember {
	    constructor(type) {
	        super();
	        this.type = type;
	    }
	    removeInner() {
	        UnionType.prototype['removeMember'].call(this._parent, this.type);
	    }
	}
	exports.UnionMember = UnionMember;
	class UnionType extends BaseNamedType {
	    constructor() {
	        super(...arguments);
	        this.kind = 'UnionType';
	        this._members = new utils_1.MapWithCachedArrays();
	    }
	    onAttached() {
	        Schema.prototype['runWithBuiltInModificationAllowed'].call(this.schema(), () => {
	            this._typenameField = new FieldDefinition(exports.typenameFieldName, true);
	            Element.prototype['setParent'].call(this._typenameField, this);
	            this._typenameField.type = new NonNullType(this.schema().stringType());
	        });
	    }
	    types() {
	        return this.members().map(m => m.type);
	    }
	    members() {
	        return this._members.values();
	    }
	    membersCount() {
	        return this._members.size;
	    }
	    hasTypeMember(type) {
	        return this._members.has(typeof type === 'string' ? type : type.name);
	    }
	    addType(nameOrTypeOrMember) {
	        let toAdd;
	        if (nameOrTypeOrMember instanceof UnionMember) {
	            this.checkUpdate(nameOrTypeOrMember);
	            toAdd = nameOrTypeOrMember;
	        }
	        else {
	            let obj;
	            if (typeof nameOrTypeOrMember === 'string') {
	                this.checkUpdate();
	                const maybeObj = this.schema().type(nameOrTypeOrMember);
	                if (!maybeObj) {
	                    throw new graphql_1.GraphQLError(`Cannot add unkown type ${nameOrTypeOrMember} as member of union type ${this.name}`);
	                }
	                else if (maybeObj.kind != 'ObjectType') {
	                    throw new graphql_1.GraphQLError(`Cannot add non-object type ${nameOrTypeOrMember} (of type ${maybeObj.kind}) as member of union type ${this.name}`);
	                }
	                obj = maybeObj;
	            }
	            else {
	                this.checkUpdate(nameOrTypeOrMember);
	                obj = nameOrTypeOrMember;
	            }
	            toAdd = new UnionMember(obj);
	        }
	        const existing = this._members.get(toAdd.type.name);
	        if (!existing) {
	            this._members.set(toAdd.type.name, toAdd);
	            Element.prototype['setParent'].call(toAdd, this);
	            addReferenceToType(this, toAdd.type);
	            this.onModification();
	            return toAdd;
	        }
	        else {
	            return existing;
	        }
	    }
	    clearTypes() {
	        for (const type of this.types()) {
	            this.removeMember(type);
	        }
	        this.onModification();
	    }
	    field(name) {
	        if (name === exports.typenameFieldName && this._typenameField) {
	            return this._typenameField;
	        }
	        return undefined;
	    }
	    typenameField() {
	        return this._typenameField;
	    }
	    removeMember(type) {
	        this._members.delete(type.name);
	        removeReferenceToType(this, type);
	    }
	    removeTypeReference(type) {
	        this._members.delete(type.name);
	    }
	    removeInnerElements() {
	        for (const member of this.members()) {
	            member.remove();
	        }
	    }
	    hasNonExtensionInnerElements() {
	        return this.members().some(m => m.ofExtension() === undefined);
	    }
	}
	exports.UnionType = UnionType;
	class EnumType extends BaseNamedType {
	    constructor() {
	        super(...arguments);
	        this.kind = 'EnumType';
	        this._values = [];
	    }
	    get values() {
	        return this._values;
	    }
	    value(name) {
	        return this._values.find(v => v.name == name);
	    }
	    addValue(nameOrValue) {
	        let toAdd;
	        if (typeof nameOrValue === 'string') {
	            this.checkUpdate();
	            toAdd = new EnumValue(nameOrValue);
	        }
	        else {
	            this.checkUpdate(nameOrValue);
	            toAdd = nameOrValue;
	        }
	        const existing = this.value(toAdd.name);
	        if (!existing) {
	            this._values.push(toAdd);
	            Element.prototype['setParent'].call(toAdd, this);
	            this.onModification();
	            return toAdd;
	        }
	        else {
	            return existing;
	        }
	    }
	    removeTypeReference(type) {
	        (0, utils_1.assert)(false, `Eum type ${this} can't reference other types; shouldn't be asked to remove reference to ${type}`);
	    }
	    removeValueInternal(value) {
	        const index = this._values.indexOf(value);
	        if (index >= 0) {
	            this._values.splice(index, 1);
	        }
	    }
	    removeInnerElements() {
	        this._values.splice(0, this._values.length);
	    }
	    hasNonExtensionInnerElements() {
	        return this._values.some(v => v.ofExtension() === undefined);
	    }
	}
	exports.EnumType = EnumType;
	class InputObjectType extends BaseNamedType {
	    constructor() {
	        super(...arguments);
	        this.kind = 'InputObjectType';
	        this._fields = new Map();
	    }
	    fields() {
	        if (!this._cachedFieldsArray) {
	            this._cachedFieldsArray = (0, utils_1.mapValues)(this._fields);
	        }
	        return this._cachedFieldsArray;
	    }
	    field(name) {
	        return this._fields.get(name);
	    }
	    addField(nameOrField, type) {
	        const toAdd = typeof nameOrField === 'string' ? new InputFieldDefinition(nameOrField) : nameOrField;
	        this.checkUpdate(toAdd);
	        if (this.field(toAdd.name)) {
	            throw error(`Field ${toAdd.name} already exists on ${this}`);
	        }
	        if (type && !isInputType(type)) {
	            throw error(`Invalid ouptut type ${type} for field ${toAdd.name}: input field types should be input types.`);
	        }
	        this._fields.set(toAdd.name, toAdd);
	        this._cachedFieldsArray = undefined;
	        Element.prototype['setParent'].call(toAdd, this);
	        if (typeof nameOrField === 'string' && type) {
	            toAdd.type = type;
	        }
	        this.onModification();
	        return toAdd;
	    }
	    hasFields() {
	        return this._fields.size > 0;
	    }
	    *allChildElements() {
	        yield* this._fields.values();
	    }
	    removeTypeReference(type) {
	        (0, utils_1.assert)(false, `Input Object type ${this} can't reference other types; shouldn't be asked to remove reference to ${type}`);
	    }
	    removeInnerElements() {
	        for (const field of this.fields()) {
	            field.remove();
	        }
	    }
	    removeFieldInternal(field) {
	        this._fields.delete(field.name);
	        this._cachedFieldsArray = undefined;
	    }
	    hasNonExtensionInnerElements() {
	        return this.fields().some(f => f.ofExtension() === undefined);
	    }
	}
	exports.InputObjectType = InputObjectType;
	class BaseWrapperType {
	    constructor(_type) {
	        this._type = _type;
	        (0, utils_1.assert)(this._type, 'Cannot wrap an undefined/null type');
	    }
	    schema() {
	        return this.baseType().schema();
	    }
	    get ofType() {
	        return this._type;
	    }
	    baseType() {
	        return baseType(this._type);
	    }
	}
	class ListType extends BaseWrapperType {
	    constructor(type) {
	        super(type);
	        this.kind = 'ListType';
	    }
	    toString() {
	        return `[${this.ofType}]`;
	    }
	}
	exports.ListType = ListType;
	class NonNullType extends BaseWrapperType {
	    constructor(type) {
	        super(type);
	        this.kind = 'NonNullType';
	    }
	    toString() {
	        return `${this.ofType}!`;
	    }
	}
	exports.NonNullType = NonNullType;
	class FieldDefinition extends NamedSchemaElementWithType {
	    constructor(name, isBuiltIn = false) {
	        super(name);
	        this.isBuiltIn = isBuiltIn;
	        this.kind = 'FieldDefinition';
	        this._args = new utils_1.MapWithCachedArrays();
	    }
	    isElementBuiltIn() {
	        return this.isBuiltIn;
	    }
	    get coordinate() {
	        const parent = this.parent;
	        return `${parent == undefined ? '<detached>' : parent.coordinate}.${this.name}`;
	    }
	    hasArguments() {
	        return this._args.size > 0;
	    }
	    arguments() {
	        return this._args.values();
	    }
	    argument(name) {
	        return this._args.get(name);
	    }
	    addArgument(nameOrArg, type, defaultValue) {
	        let toAdd;
	        if (typeof nameOrArg === 'string') {
	            this.checkUpdate();
	            toAdd = new ArgumentDefinition(nameOrArg);
	            toAdd.defaultValue = defaultValue;
	        }
	        else {
	            this.checkUpdate(nameOrArg);
	            toAdd = nameOrArg;
	        }
	        const existing = this.argument(toAdd.name);
	        if (existing) {
	            if (type && existing.type && !(0, types_1.sameType)(type, existing.type)) {
	                throw error(`Argument ${toAdd.name} already exists on field ${this.name} with a different type (${existing.type})`);
	            }
	            if (defaultValue && (!existing.defaultValue || !(0, values_1.valueEquals)(defaultValue, existing.defaultValue))) {
	                throw error(`Argument ${toAdd.name} already exists on field ${this.name} with a different default value (${(0, values_1.valueToString)(existing.defaultValue)})`);
	            }
	            return existing;
	        }
	        if (type && !isInputType(type)) {
	            throw error(`Invalid ouptut type ${type} for argument ${toAdd.name} of ${this}: arguments should be input types.`);
	        }
	        this._args.set(toAdd.name, toAdd);
	        Element.prototype['setParent'].call(toAdd, this);
	        if (typeof nameOrArg === 'string') {
	            toAdd.type = type;
	        }
	        this.onModification();
	        return toAdd;
	    }
	    ofExtension() {
	        return this._extension;
	    }
	    setOfExtension(extension) {
	        var _a;
	        this.checkUpdate();
	        if (extension && !((_a = this.parent) === null || _a === void 0 ? void 0 : _a.extensions().has(extension))) {
	            throw error(`Cannot mark field ${this.name} as part of the provided extension: it is not an extension of field parent type ${this.parent}`);
	        }
	        this._extension = extension;
	        this.onModification();
	    }
	    isIntrospectionField() {
	        return (0, introspection_1.isIntrospectionName)(this.name);
	    }
	    isSchemaIntrospectionField() {
	        return introspection_1.introspectionFieldNames.includes(this.name);
	    }
	    removeArgumentInternal(name) {
	        this._args.delete(name);
	    }
	    removeParent() {
	        this._parent = undefined;
	    }
	    isDeprecated() {
	        return this.hasAppliedDirective('deprecated');
	    }
	    remove() {
	        if (!this._parent) {
	            return [];
	        }
	        this.onModification();
	        this.removeAppliedDirectives();
	        this.type = undefined;
	        this._extension = undefined;
	        for (const arg of this.arguments()) {
	            arg.remove();
	        }
	        FieldBasedType.prototype['removeFieldInternal'].call(this._parent, this);
	        this._parent = undefined;
	        return [];
	    }
	    toString() {
	        const args = this._args.size == 0
	            ? ""
	            : '(' + this.arguments().map(arg => arg.toString()).join(', ') + ')';
	        return `${this.name}${args}: ${this.type}`;
	    }
	}
	exports.FieldDefinition = FieldDefinition;
	class InputFieldDefinition extends NamedSchemaElementWithType {
	    constructor() {
	        super(...arguments);
	        this.kind = 'InputFieldDefinition';
	    }
	    get coordinate() {
	        const parent = this.parent;
	        return `${parent == undefined ? '<detached>' : parent.coordinate}.${this.name}`;
	    }
	    isRequired() {
	        return isNonNullType(this.type) && this.defaultValue === undefined;
	    }
	    ofExtension() {
	        return this._extension;
	    }
	    setOfExtension(extension) {
	        var _a;
	        this.checkUpdate();
	        if (extension && !((_a = this.parent) === null || _a === void 0 ? void 0 : _a.extensions().has(extension))) {
	            throw error(`Cannot mark field ${this.name} as part of the provided extension: it is not an extension of field parent type ${this.parent}`);
	        }
	        this._extension = extension;
	        this.onModification();
	    }
	    isDeprecated() {
	        return this.hasAppliedDirective('deprecated');
	    }
	    remove() {
	        if (!this._parent) {
	            return [];
	        }
	        this.onModification();
	        InputObjectType.prototype['removeFieldInternal'].call(this._parent, this);
	        this._parent = undefined;
	        this.type = undefined;
	        return [];
	    }
	    toString() {
	        const defaultStr = this.defaultValue === undefined ? "" : ` = ${(0, values_1.valueToString)(this.defaultValue, this.type)}`;
	        return `${this.name}: ${this.type}${defaultStr}`;
	    }
	}
	exports.InputFieldDefinition = InputFieldDefinition;
	class ArgumentDefinition extends NamedSchemaElementWithType {
	    constructor(name) {
	        super(name);
	        this.kind = 'ArgumentDefinition';
	    }
	    get coordinate() {
	        const parent = this.parent;
	        return `${parent == undefined ? '<detached>' : parent.coordinate}(${this.name}:)`;
	    }
	    isRequired() {
	        return isNonNullType(this.type) && this.defaultValue === undefined;
	    }
	    isDeprecated() {
	        return this.hasAppliedDirective('deprecated');
	    }
	    remove() {
	        if (!this._parent) {
	            return [];
	        }
	        this.onModification();
	        if (this._parent instanceof FieldDefinition) {
	            FieldDefinition.prototype['removeArgumentInternal'].call(this._parent, this.name);
	        }
	        else {
	            DirectiveDefinition.prototype['removeArgumentInternal'].call(this._parent, this.name);
	        }
	        this._parent = undefined;
	        this.type = undefined;
	        this.defaultValue = undefined;
	        return [];
	    }
	    toString() {
	        const defaultStr = this.defaultValue === undefined ? "" : ` = ${(0, values_1.valueToString)(this.defaultValue, this.type)}`;
	        return `${this.name}: ${this.type}${defaultStr}`;
	    }
	}
	exports.ArgumentDefinition = ArgumentDefinition;
	class EnumValue extends NamedSchemaElement {
	    constructor() {
	        super(...arguments);
	        this.kind = 'EnumValue';
	    }
	    get coordinate() {
	        const parent = this.parent;
	        return `${parent == undefined ? '<detached>' : parent.coordinate}.${this.name}`;
	    }
	    ofExtension() {
	        return this._extension;
	    }
	    setOfExtension(extension) {
	        var _a;
	        this.checkUpdate();
	        if (extension && !((_a = this.parent) === null || _a === void 0 ? void 0 : _a.extensions().has(extension))) {
	            throw error(`Cannot mark field ${this.name} as part of the provided extension: it is not an extension of field parent type ${this.parent}`);
	        }
	        this._extension = extension;
	        this.onModification();
	    }
	    isDeprecated() {
	        return this.hasAppliedDirective('deprecated');
	    }
	    remove() {
	        if (!this._parent) {
	            return [];
	        }
	        this.onModification();
	        EnumType.prototype['removeValueInternal'].call(this._parent, this);
	        this._parent = undefined;
	        return [];
	    }
	    removeTypeReference(type) {
	        (0, utils_1.assert)(false, `Enum value ${this} can't reference other types; shouldn't be asked to remove reference to ${type}`);
	    }
	    toString() {
	        return `${this.name}`;
	    }
	}
	exports.EnumValue = EnumValue;
	class DirectiveDefinition extends NamedSchemaElement {
	    constructor(name, isBuiltIn = false) {
	        super(name);
	        this.isBuiltIn = isBuiltIn;
	        this.kind = 'DirectiveDefinition';
	        this._args = new utils_1.MapWithCachedArrays();
	        this.repeatable = false;
	        this._locations = [];
	        this._referencers = new Set();
	    }
	    get coordinate() {
	        return `@${this.name}`;
	    }
	    arguments() {
	        return this._args.values();
	    }
	    argument(name) {
	        return this._args.get(name);
	    }
	    addArgument(nameOrArg, type, defaultValue) {
	        let toAdd;
	        if (typeof nameOrArg === 'string') {
	            this.checkUpdate();
	            toAdd = new ArgumentDefinition(nameOrArg);
	            toAdd.defaultValue = defaultValue;
	        }
	        else {
	            this.checkUpdate(nameOrArg);
	            toAdd = nameOrArg;
	        }
	        if (this.argument(toAdd.name)) {
	            throw error(`Argument ${toAdd.name} already exists on field ${this.name}`);
	        }
	        this._args.set(toAdd.name, toAdd);
	        Element.prototype['setParent'].call(toAdd, this);
	        if (typeof nameOrArg === 'string') {
	            toAdd.type = type;
	        }
	        this.onModification();
	        return toAdd;
	    }
	    removeArgumentInternal(name) {
	        this._args.delete(name);
	    }
	    get locations() {
	        return this._locations;
	    }
	    addLocations(...locations) {
	        let modified = false;
	        for (const location of locations) {
	            if (!this._locations.includes(location)) {
	                this._locations.push(location);
	                modified = true;
	            }
	        }
	        if (modified) {
	            this.onModification();
	        }
	        return this;
	    }
	    addAllLocations() {
	        return this.addLocations(...Object.values(graphql_1.DirectiveLocation));
	    }
	    addAllTypeLocations() {
	        return this.addLocations('SCALAR', 'OBJECT', 'INTERFACE', 'UNION', 'ENUM', 'INPUT_OBJECT');
	    }
	    removeLocations(...locations) {
	        let modified = false;
	        for (const location of locations) {
	            const index = this._locations.indexOf(location);
	            if (index >= 0) {
	                this._locations.splice(index, 1);
	                modified = true;
	            }
	        }
	        if (modified) {
	            this.onModification();
	        }
	        return this;
	    }
	    applications() {
	        return (0, utils_1.setValues)(this._referencers);
	    }
	    addReferencer(referencer) {
	        (0, utils_1.assert)(referencer, 'Referencer should exists');
	        this._referencers.add(referencer);
	    }
	    removeReferencer(referencer) {
	        this._referencers.delete(referencer);
	    }
	    removeTypeReference(type) {
	        (0, utils_1.assert)(false, `Directive definition ${this} can't reference other types (it's arguments can); shouldn't be asked to remove reference to ${type}`);
	    }
	    remove() {
	        if (!this._parent) {
	            return [];
	        }
	        this.onModification();
	        Schema.prototype['removeDirectiveInternal'].call(this._parent, this);
	        this._parent = undefined;
	        (0, utils_1.assert)(this._appliedDirectives.length === 0, "Directive definition should not have directive applied to it");
	        for (const arg of this.arguments()) {
	            arg.remove();
	        }
	        const toReturn = (0, utils_1.setValues)(this._referencers);
	        this._referencers.clear();
	        return toReturn;
	    }
	    toString() {
	        return `@${this.name}`;
	    }
	}
	exports.DirectiveDefinition = DirectiveDefinition;
	class Directive extends Element {
	    constructor(name, _args) {
	        super();
	        this.name = name;
	        this._args = _args;
	    }
	    schema() {
	        var _a;
	        return (_a = this._parent) === null || _a === void 0 ? void 0 : _a.schema();
	    }
	    get definition() {
	        const doc = this.schema();
	        return doc === null || doc === void 0 ? void 0 : doc.directive(this.name);
	    }
	    arguments(includeDefaultValues = false) {
	        if (!includeDefaultValues) {
	            return this._args;
	        }
	        const definition = this.definition;
	        if (!definition) {
	            throw error(`Cannot include default values for arguments: cannot find directive definition for ${this.name}`);
	        }
	        const updated = Object.create(null);
	        for (const argDef of definition.arguments()) {
	            updated[argDef.name] = (0, values_1.withDefaultValues)(this._args[argDef.name], argDef);
	        }
	        return updated;
	    }
	    onModification() {
	        if (this.isAttachedToSchemaElement()) {
	            Schema.prototype['onModification'].call(this.schema());
	        }
	    }
	    isAttachedToSchemaElement() {
	        return this.parent !== undefined && this.parent instanceof SchemaElement;
	    }
	    setArguments(args) {
	        this._args = args;
	        this.onModification();
	    }
	    argumentType(name) {
	        var _a, _b;
	        return (_b = (_a = this.definition) === null || _a === void 0 ? void 0 : _a.argument(name)) === null || _b === void 0 ? void 0 : _b.type;
	    }
	    matchArguments(expectedArgs) {
	        const entries = Object.entries(this._args);
	        if (entries.length !== Object.keys(expectedArgs).length) {
	            return false;
	        }
	        for (var [key, val] of entries) {
	            if (!(key in expectedArgs)) {
	                return false;
	            }
	            const expectedVal = expectedArgs[key];
	            if (!(0, values_1.valueEquals)(expectedVal, val)) {
	                return false;
	            }
	        }
	        return true;
	    }
	    ofExtension() {
	        return this._extension;
	    }
	    setOfExtension(extension) {
	        this.checkUpdate();
	        if (extension) {
	            const parent = this.parent;
	            if (parent instanceof SchemaDefinition || parent instanceof BaseNamedType) {
	                if (!parent.extensions().has(extension)) {
	                    throw error(`Cannot mark directive ${this.name} as part of the provided extension: it is not an extension of parent ${parent}`);
	                }
	            }
	            else {
	                throw error(`Can only mark directive parts of extensions when directly apply to type or schema definition.`);
	            }
	        }
	        this._extension = extension;
	        this.onModification();
	    }
	    argumentsToAST() {
	        const entries = Object.entries(this._args);
	        if (entries.length === 0) {
	            return undefined;
	        }
	        const definition = this.definition;
	        (0, utils_1.assert)(definition, () => `Cannot convert arguments of detached directive ${this}`);
	        return entries.map(([n, v]) => {
	            return {
	                kind: 'Argument',
	                name: { kind: graphql_1.Kind.NAME, value: n },
	                value: (0, values_1.valueToAST)(v, definition.argument(n).type),
	            };
	        });
	    }
	    remove() {
	        var _a;
	        if (!this._parent) {
	            return false;
	        }
	        this.onModification();
	        const coreFeatures = (_a = this.schema()) === null || _a === void 0 ? void 0 : _a.coreFeatures;
	        if (coreFeatures && this.name === coreFeatures.coreItself.nameInSchema) {
	            const url = coreSpec_1.FeatureUrl.parse(this._args['feature']);
	            if (url.identity === coreFeatures.coreItself.url.identity) {
	                Schema.prototype['unmarkAsCoreSchema'].call(this.schema());
	                for (const d of this.schema().schemaDefinition.appliedDirectivesOf(coreFeatures.coreItself.nameInSchema)) {
	                    d.removeInternal();
	                }
	                return true;
	            }
	            else {
	                CoreFeatures.prototype['removeFeature'].call(coreFeatures, url.identity);
	            }
	        }
	        return this.removeInternal();
	    }
	    removeInternal() {
	        if (!this._parent) {
	            return false;
	        }
	        const definition = this.definition;
	        if (definition && this.isAttachedToSchemaElement()) {
	            DirectiveDefinition.prototype['removeReferencer'].call(definition, this);
	        }
	        const parentDirectives = this._parent.appliedDirectives;
	        const index = parentDirectives.indexOf(this);
	        (0, utils_1.assert)(index >= 0, () => `Directive ${this} lists ${this._parent} as parent, but that parent doesn't list it as applied directive`);
	        parentDirectives.splice(index, 1);
	        this._parent = undefined;
	        this._extension = undefined;
	        return true;
	    }
	    toString() {
	        const entries = Object.entries(this._args).filter(([_, v]) => v !== undefined);
	        const args = entries.length == 0 ? '' : '(' + entries.map(([n, v]) => `${n}: ${(0, values_1.valueToString)(v, this.argumentType(n))}`).join(', ') + ')';
	        return `@${this.name}${args}`;
	    }
	}
	exports.Directive = Directive;
	class Variable {
	    constructor(name) {
	        this.name = name;
	    }
	    toVariableNode() {
	        return {
	            kind: 'Variable',
	            name: { kind: 'Name', value: this.name },
	        };
	    }
	    toString() {
	        return '$' + this.name;
	    }
	}
	exports.Variable = Variable;
	function mergeVariables(v1s, v2s) {
	    if (v1s.length == 0) {
	        return v2s;
	    }
	    if (v2s.length == 0) {
	        return v1s;
	    }
	    const res = v1s.concat();
	    for (const v of v2s) {
	        if (!containsVariable(v1s, v)) {
	            res.push(v);
	        }
	    }
	    return res;
	}
	exports.mergeVariables = mergeVariables;
	function containsVariable(variables, toCheck) {
	    return variables.some(v => v.name == toCheck.name);
	}
	exports.containsVariable = containsVariable;
	function isVariable(v) {
	    return v instanceof Variable;
	}
	exports.isVariable = isVariable;
	function variablesInArguments(args) {
	    let variables = [];
	    for (const value of Object.values(args)) {
	        variables = mergeVariables(variables, (0, values_1.variablesInValue)(value));
	    }
	    return variables;
	}
	exports.variablesInArguments = variablesInArguments;
	class VariableDefinition extends DirectiveTargetElement {
	    constructor(schema, variable, type, defaultValue) {
	        super(schema);
	        this.variable = variable;
	        this.type = type;
	        this.defaultValue = defaultValue;
	    }
	    toVariableDefinitionNode() {
	        return {
	            kind: 'VariableDefinition',
	            variable: this.variable.toVariableNode(),
	            type: typeToAST(this.type),
	            defaultValue: (0, values_1.valueToAST)(this.defaultValue, this.type),
	            directives: this.appliedDirectivesToDirectiveNodes()
	        };
	    }
	    toString() {
	        let base = this.variable + ': ' + this.type;
	        if (this.defaultValue) {
	            base = base + ' = ' + (0, values_1.valueToString)(this.defaultValue, this.type);
	        }
	        return base + this.appliedDirectivesToString();
	    }
	}
	exports.VariableDefinition = VariableDefinition;
	class VariableDefinitions {
	    constructor() {
	        this._definitions = new utils_1.MapWithCachedArrays();
	    }
	    add(definition) {
	        if (this._definitions.has(definition.variable.name)) {
	            return false;
	        }
	        this._definitions.set(definition.variable.name, definition);
	        return true;
	    }
	    addAll(definitions) {
	        for (const definition of definitions._definitions.values()) {
	            this.add(definition);
	        }
	    }
	    definition(variable) {
	        const varName = typeof variable === 'string' ? variable : variable.name;
	        return this._definitions.get(varName);
	    }
	    isEmpty() {
	        return this._definitions.size === 0;
	    }
	    definitions() {
	        return this._definitions.values();
	    }
	    filter(variables) {
	        if (variables.length === 0) {
	            return new VariableDefinitions();
	        }
	        const newDefs = new VariableDefinitions();
	        for (const variable of variables) {
	            const def = this.definition(variable);
	            if (!def) {
	                throw new Error(`Cannot find variable ${variable} in definitions ${this}`);
	            }
	            newDefs.add(def);
	        }
	        return newDefs;
	    }
	    toVariableDefinitionNodes() {
	        if (this._definitions.size === 0) {
	            return undefined;
	        }
	        return this.definitions().map(def => def.toVariableDefinitionNode());
	    }
	    toString() {
	        return '(' + this.definitions().join(', ') + ')';
	    }
	}
	exports.VariableDefinitions = VariableDefinitions;
	function variableDefinitionsFromAST(schema, definitionNodes) {
	    const definitions = new VariableDefinitions();
	    for (const definitionNode of definitionNodes) {
	        if (!definitions.add(variableDefinitionFromAST(schema, definitionNode))) {
	            const name = definitionNode.variable.name.value;
	            throw new graphql_1.GraphQLError(`Duplicate definition for variable ${name}`, definitionNodes.filter(n => n.variable.name.value === name));
	        }
	    }
	    return definitions;
	}
	exports.variableDefinitionsFromAST = variableDefinitionsFromAST;
	function variableDefinitionFromAST(schema, definitionNode) {
	    const variable = new Variable(definitionNode.variable.name.value);
	    const type = typeFromAST(schema, definitionNode.type);
	    if (!isInputType(type)) {
	        throw new graphql_1.GraphQLError(`Invalid type "${type}" for variable $${variable}: not an input type`, definitionNode.type);
	    }
	    const def = new VariableDefinition(schema, variable, type, definitionNode.defaultValue ? (0, values_1.valueFromAST)(definitionNode.defaultValue, type) : undefined);
	    return def;
	}
	exports.variableDefinitionFromAST = variableDefinitionFromAST;
	exports.graphQLBuiltIns = new BuiltIns();
	function addReferenceToType(referencer, type) {
	    switch (type.kind) {
	        case 'ListType':
	            addReferenceToType(referencer, type.baseType());
	            break;
	        case 'NonNullType':
	            addReferenceToType(referencer, type.baseType());
	            break;
	        default:
	            BaseNamedType.prototype['addReferencer'].call(type, referencer);
	            break;
	    }
	}
	function removeReferenceToType(referencer, type) {
	    switch (type.kind) {
	        case 'ListType':
	            removeReferenceToType(referencer, type.baseType());
	            break;
	        case 'NonNullType':
	            removeReferenceToType(referencer, type.baseType());
	            break;
	        default:
	            BaseNamedType.prototype['removeReferencer'].call(type, referencer);
	            break;
	    }
	}
	function newNamedType(kind, name) {
	    switch (kind) {
	        case 'ScalarType':
	            return new ScalarType(name);
	        case 'ObjectType':
	            return new ObjectType(name);
	        case 'InterfaceType':
	            return new InterfaceType(name);
	        case 'UnionType':
	            return new UnionType(name);
	        case 'EnumType':
	            return new EnumType(name);
	        case 'InputObjectType':
	            return new InputObjectType(name);
	        default:
	            (0, utils_1.assert)(false, `Unhandled kind ${kind} for type ${name}`);
	    }
	}
	exports.newNamedType = newNamedType;
	function* typesToCopy(source, dest) {
	    var _a;
	    for (const type of source.builtInTypes()) {
	        if (!type.isIntrospectionType() && !((_a = dest.type(type.name)) === null || _a === void 0 ? void 0 : _a.isBuiltIn)) {
	            yield type;
	        }
	    }
	    yield* source.types();
	}
	function* directivesToCopy(source, dest) {
	    var _a;
	    for (const directive of source.builtInDirectives()) {
	        if (!((_a = dest.directive(directive.name)) === null || _a === void 0 ? void 0 : _a.isBuiltIn)) {
	            yield directive;
	        }
	    }
	    yield* source.directives();
	}
	function copy(source, dest) {
	    for (const type of typesToCopy(source, dest)) {
	        dest.addType(newNamedType(type.kind, type.name));
	    }
	    for (const directive of directivesToCopy(source, dest)) {
	        copyDirectiveDefinitionInner(directive, dest.addDirectiveDefinition(directive.name));
	    }
	    copySchemaDefinitionInner(source.schemaDefinition, dest.schemaDefinition);
	    for (const type of typesToCopy(source, dest)) {
	        copyNamedTypeInner(type, dest.type(type.name));
	    }
	}
	function copyExtensions(source, dest) {
	    const extensionMap = new Map();
	    for (const sourceExtension of source.extensions()) {
	        const destExtension = new Extension();
	        dest.addExtension(destExtension);
	        extensionMap.set(sourceExtension, destExtension);
	    }
	    return extensionMap;
	}
	function copyOfExtension(extensionsMap, source, dest) {
	    const toCopy = source.ofExtension();
	    if (toCopy) {
	        dest.setOfExtension(extensionsMap.get(toCopy));
	    }
	}
	function copySchemaDefinitionInner(source, dest) {
	    const extensionsMap = copyExtensions(source, dest);
	    for (const rootType of source.roots()) {
	        copyOfExtension(extensionsMap, rootType, dest.setRoot(rootType.rootKind, rootType.type.name));
	    }
	    for (const directive of source.appliedDirectives) {
	        copyOfExtension(extensionsMap, directive, dest.applyDirective(directive.name, { ...directive.arguments() }));
	    }
	    dest.description = source.description;
	    dest.sourceAST = source.sourceAST;
	}
	function copyNamedTypeInner(source, dest) {
	    const extensionsMap = copyExtensions(source, dest);
	    for (const directive of source.appliedDirectives) {
	        copyOfExtension(extensionsMap, directive, dest.applyDirective(directive.name, { ...directive.arguments() }));
	    }
	    dest.description = source.description;
	    dest.sourceAST = source.sourceAST;
	    switch (source.kind) {
	        case 'ObjectType':
	        case 'InterfaceType':
	            const destFieldBasedType = dest;
	            for (const sourceField of source.fields()) {
	                const destField = destFieldBasedType.addField(new FieldDefinition(sourceField.name));
	                copyOfExtension(extensionsMap, sourceField, destField);
	                copyFieldDefinitionInner(sourceField, destField);
	            }
	            for (const sourceImpl of source.interfaceImplementations()) {
	                const destImpl = destFieldBasedType.addImplementedInterface(sourceImpl.interface.name);
	                copyOfExtension(extensionsMap, sourceImpl, destImpl);
	            }
	            break;
	        case 'UnionType':
	            const destUnionType = dest;
	            for (const sourceType of source.members()) {
	                const destType = destUnionType.addType(sourceType.type.name);
	                copyOfExtension(extensionsMap, sourceType, destType);
	            }
	            break;
	        case 'EnumType':
	            const destEnumType = dest;
	            for (const sourceValue of source.values) {
	                const destValue = destEnumType.addValue(sourceValue.name);
	                destValue.description = sourceValue.description;
	                copyOfExtension(extensionsMap, sourceValue, destValue);
	                copyAppliedDirectives(sourceValue, destValue);
	            }
	            break;
	        case 'InputObjectType':
	            const destInputType = dest;
	            for (const sourceField of source.fields()) {
	                const destField = destInputType.addField(new InputFieldDefinition(sourceField.name));
	                copyOfExtension(extensionsMap, sourceField, destField);
	                copyInputFieldDefinitionInner(sourceField, destField);
	            }
	    }
	}
	function copyAppliedDirectives(source, dest) {
	    for (const directive of source.appliedDirectives) {
	        dest.applyDirective(directive.name, { ...directive.arguments() });
	    }
	}
	function copyFieldDefinitionInner(source, dest) {
	    const type = copyWrapperTypeOrTypeRef(source.type, dest.schema());
	    dest.type = type;
	    for (const arg of source.arguments()) {
	        const argType = copyWrapperTypeOrTypeRef(arg.type, dest.schema());
	        copyArgumentDefinitionInner(arg, dest.addArgument(arg.name, argType));
	    }
	    copyAppliedDirectives(source, dest);
	    dest.description = source.description;
	    dest.sourceAST = source.sourceAST;
	}
	function copyInputFieldDefinitionInner(source, dest) {
	    const type = copyWrapperTypeOrTypeRef(source.type, dest.schema());
	    dest.type = type;
	    dest.defaultValue = source.defaultValue;
	    copyAppliedDirectives(source, dest);
	    dest.description = source.description;
	    dest.sourceAST = source.sourceAST;
	}
	function copyWrapperTypeOrTypeRef(source, destParent) {
	    if (!source) {
	        return undefined;
	    }
	    switch (source.kind) {
	        case 'ListType':
	            return new ListType(copyWrapperTypeOrTypeRef(source.ofType, destParent));
	        case 'NonNullType':
	            return new NonNullType(copyWrapperTypeOrTypeRef(source.ofType, destParent));
	        default:
	            return destParent.type(source.name);
	    }
	}
	function copyArgumentDefinitionInner(source, dest) {
	    const type = copyWrapperTypeOrTypeRef(source.type, dest.schema());
	    dest.type = type;
	    dest.defaultValue = source.defaultValue;
	    copyAppliedDirectives(source, dest);
	    dest.description = source.description;
	    dest.sourceAST = source.sourceAST;
	}
	function copyDirectiveDefinitionInner(source, dest) {
	    for (const arg of source.arguments()) {
	        const type = copyWrapperTypeOrTypeRef(arg.type, dest.schema());
	        copyArgumentDefinitionInner(arg, dest.addArgument(arg.name, type));
	    }
	    dest.repeatable = source.repeatable;
	    dest.addLocations(...source.locations);
	    dest.sourceAST = source.sourceAST;
	    dest.description = source.description;
	}

	}(definitions));

	var buildSchema$1 = {};

	Object.defineProperty(buildSchema$1, "__esModule", { value: true });
	buildSchema$1.builtTypeReference = buildSchema$1.buildSchemaFromAST = buildSchema$1.buildSchema = void 0;
	const graphql_1$8 = require$$2$1;
	const definitions_1$3 = definitions;
	function buildValue(value) {
	    return value ? (0, graphql_1$8.valueFromASTUntyped)(value) : undefined;
	}
	function buildSchema(source, builtIns = definitions_1$3.graphQLBuiltIns, validate = true) {
	    return buildSchemaFromAST((0, graphql_1$8.parse)(source), builtIns, validate);
	}
	buildSchema$1.buildSchema = buildSchema;
	function buildSchemaFromAST(documentNode, builtIns = definitions_1$3.graphQLBuiltIns, validate = true) {
	    const schema = new definitions_1$3.Schema(builtIns);
	    const directiveDefinitionNodes = buildNamedTypeAndDirectivesShallow(documentNode, schema);
	    for (const directiveDefinitionNode of directiveDefinitionNodes) {
	        buildDirectiveDefinitionInner(directiveDefinitionNode, schema.directive(directiveDefinitionNode.name.value));
	    }
	    for (const definitionNode of documentNode.definitions) {
	        switch (definitionNode.kind) {
	            case 'OperationDefinition':
	            case 'FragmentDefinition':
	                throw new graphql_1$8.GraphQLError("Invalid executable definition found while building schema", definitionNode);
	            case 'SchemaDefinition':
	                buildSchemaDefinitionInner(definitionNode, schema.schemaDefinition);
	                break;
	            case 'SchemaExtension':
	                buildSchemaDefinitionInner(definitionNode, schema.schemaDefinition, schema.schemaDefinition.newExtension());
	                break;
	            case 'ScalarTypeDefinition':
	            case 'ObjectTypeDefinition':
	            case 'InterfaceTypeDefinition':
	            case 'UnionTypeDefinition':
	            case 'EnumTypeDefinition':
	            case 'InputObjectTypeDefinition':
	                buildNamedTypeInner(definitionNode, schema.type(definitionNode.name.value));
	                break;
	            case 'ScalarTypeExtension':
	            case 'ObjectTypeExtension':
	            case 'InterfaceTypeExtension':
	            case 'UnionTypeExtension':
	            case 'EnumTypeExtension':
	            case 'InputObjectTypeExtension':
	                const toExtend = schema.type(definitionNode.name.value);
	                const extension = toExtend.newExtension();
	                extension.sourceAST = definitionNode;
	                buildNamedTypeInner(definitionNode, toExtend, extension);
	                break;
	        }
	    }
	    definitions_1$3.Schema.prototype['forceSetCachedDocument'].call(schema, documentNode);
	    if (validate) {
	        schema.validate();
	    }
	    return schema;
	}
	buildSchema$1.buildSchemaFromAST = buildSchemaFromAST;
	function buildNamedTypeAndDirectivesShallow(documentNode, schema) {
	    const directiveDefinitionNodes = [];
	    for (const definitionNode of documentNode.definitions) {
	        switch (definitionNode.kind) {
	            case 'ScalarTypeDefinition':
	            case 'ObjectTypeDefinition':
	            case 'InterfaceTypeDefinition':
	            case 'UnionTypeDefinition':
	            case 'EnumTypeDefinition':
	            case 'InputObjectTypeDefinition':
	            case 'ScalarTypeExtension':
	            case 'ObjectTypeExtension':
	            case 'InterfaceTypeExtension':
	            case 'UnionTypeExtension':
	            case 'EnumTypeExtension':
	            case 'InputObjectTypeExtension':
	                const existing = schema.type(definitionNode.name.value);
	                if (!existing || existing.isBuiltIn) {
	                    schema.addType((0, definitions_1$3.newNamedType)(withoutTrailingDefinition(definitionNode.kind), definitionNode.name.value));
	                }
	                break;
	            case 'DirectiveDefinition':
	                directiveDefinitionNodes.push(definitionNode);
	                schema.addDirectiveDefinition(definitionNode.name.value);
	                break;
	        }
	    }
	    return directiveDefinitionNodes;
	}
	function withoutTrailingDefinition(str) {
	    const endString = str.endsWith('Definition') ? 'Definition' : 'Extension';
	    return str.slice(0, str.length - endString.length);
	}
	function getReferencedType(node, schema) {
	    const type = schema.type(node.name.value);
	    if (!type) {
	        throw new graphql_1$8.GraphQLError(`Unknown type ${node.name.value}`, node);
	    }
	    return type;
	}
	function withNodeAttachedToError(operation, node) {
	    try {
	        operation();
	    }
	    catch (e) {
	        if (e instanceof graphql_1$8.GraphQLError) {
	            const allNodes = e.nodes ? [node, ...e.nodes] : node;
	            throw new graphql_1$8.GraphQLError(e.message, allNodes, e.source, e.positions, e.path, e, e.extensions);
	        }
	        else {
	            throw e;
	        }
	    }
	}
	function buildSchemaDefinitionInner(schemaNode, schemaDefinition, extension) {
	    var _a, _b;
	    for (const opTypeNode of (_a = schemaNode.operationTypes) !== null && _a !== void 0 ? _a : []) {
	        withNodeAttachedToError(() => schemaDefinition.setRoot(opTypeNode.operation, opTypeNode.type.name.value).setOfExtension(extension), opTypeNode);
	    }
	    schemaDefinition.sourceAST = schemaNode;
	    schemaDefinition.description = 'description' in schemaNode ? (_b = schemaNode.description) === null || _b === void 0 ? void 0 : _b.value : undefined;
	    buildAppliedDirectives(schemaNode, schemaDefinition, extension);
	}
	function buildAppliedDirectives(elementNode, element, extension) {
	    var _a;
	    for (const directive of (_a = elementNode.directives) !== null && _a !== void 0 ? _a : []) {
	        withNodeAttachedToError(() => {
	            const d = element.applyDirective(directive.name.value, buildArgs(directive));
	            d.setOfExtension(extension);
	            d.sourceAST = directive;
	        }, directive);
	    }
	}
	function buildArgs(argumentsNode) {
	    var _a;
	    const args = Object.create(null);
	    for (const argNode of (_a = argumentsNode.arguments) !== null && _a !== void 0 ? _a : []) {
	        args[argNode.name.value] = buildValue(argNode.value);
	    }
	    return args;
	}
	function buildNamedTypeInner(definitionNode, type, extension) {
	    var _a, _b, _c, _d, _e, _f, _g;
	    switch (definitionNode.kind) {
	        case 'ObjectTypeDefinition':
	        case 'ObjectTypeExtension':
	        case 'InterfaceTypeDefinition':
	        case 'InterfaceTypeExtension':
	            const fieldBasedType = type;
	            for (const fieldNode of (_a = definitionNode.fields) !== null && _a !== void 0 ? _a : []) {
	                const field = fieldBasedType.addField(fieldNode.name.value);
	                field.setOfExtension(extension);
	                buildFieldDefinitionInner(fieldNode, field);
	            }
	            for (const itfNode of (_b = definitionNode.interfaces) !== null && _b !== void 0 ? _b : []) {
	                withNodeAttachedToError(() => {
	                    const itfName = itfNode.name.value;
	                    if (fieldBasedType.implementsInterface(itfName)) {
	                        throw new graphql_1$8.GraphQLError(`Type ${type} can only implement ${itfName} once.`);
	                    }
	                    fieldBasedType.addImplementedInterface(itfName).setOfExtension(extension);
	                }, itfNode);
	            }
	            break;
	        case 'UnionTypeDefinition':
	        case 'UnionTypeExtension':
	            const unionType = type;
	            for (const namedType of (_c = definitionNode.types) !== null && _c !== void 0 ? _c : []) {
	                withNodeAttachedToError(() => {
	                    const name = namedType.name.value;
	                    if (unionType.hasTypeMember(name)) {
	                        throw new graphql_1$8.GraphQLError(`Union type ${unionType} can only include type ${name} once.`);
	                    }
	                    unionType.addType(name).setOfExtension(extension);
	                }, namedType);
	            }
	            break;
	        case 'EnumTypeDefinition':
	        case 'EnumTypeExtension':
	            const enumType = type;
	            for (const enumVal of (_d = definitionNode.values) !== null && _d !== void 0 ? _d : []) {
	                const v = enumType.addValue(enumVal.name.value);
	                v.description = (_e = enumVal.description) === null || _e === void 0 ? void 0 : _e.value;
	                v.setOfExtension(extension);
	                buildAppliedDirectives(enumVal, v);
	            }
	            break;
	        case 'InputObjectTypeDefinition':
	        case 'InputObjectTypeExtension':
	            const inputObjectType = type;
	            for (const fieldNode of (_f = definitionNode.fields) !== null && _f !== void 0 ? _f : []) {
	                const field = inputObjectType.addField(fieldNode.name.value);
	                field.setOfExtension(extension);
	                buildInputFieldDefinitionInner(fieldNode, field);
	            }
	            break;
	    }
	    buildAppliedDirectives(definitionNode, type, extension);
	    type.description = (_g = definitionNode.description) === null || _g === void 0 ? void 0 : _g.value;
	    type.sourceAST = definitionNode;
	}
	function buildFieldDefinitionInner(fieldNode, field) {
	    var _a, _b;
	    const type = buildTypeReferenceFromAST(fieldNode.type, field.schema());
	    field.type = ensureOutputType(type, field.coordinate, fieldNode);
	    for (const inputValueDef of (_a = fieldNode.arguments) !== null && _a !== void 0 ? _a : []) {
	        buildArgumentDefinitionInner(inputValueDef, field.addArgument(inputValueDef.name.value));
	    }
	    buildAppliedDirectives(fieldNode, field);
	    field.description = (_b = fieldNode.description) === null || _b === void 0 ? void 0 : _b.value;
	    field.sourceAST = fieldNode;
	}
	function ensureOutputType(type, what, node) {
	    if ((0, definitions_1$3.isOutputType)(type)) {
	        return type;
	    }
	    else {
	        throw new graphql_1$8.GraphQLError(`The type of ${what} must be Output Type but got: ${type}, a ${type.kind}.`, node);
	    }
	}
	function ensureInputType(type, what, node) {
	    if ((0, definitions_1$3.isInputType)(type)) {
	        return type;
	    }
	    else {
	        throw new graphql_1$8.GraphQLError(`The type of ${what} must be Input Type but got: ${type}, a ${type.kind}.`, node);
	    }
	}
	function builtTypeReference(encodedType, schema) {
	    return buildTypeReferenceFromAST((0, graphql_1$8.parseType)(encodedType), schema);
	}
	buildSchema$1.builtTypeReference = builtTypeReference;
	function buildTypeReferenceFromAST(typeNode, schema) {
	    switch (typeNode.kind) {
	        case 'ListType':
	            return new definitions_1$3.ListType(buildTypeReferenceFromAST(typeNode.type, schema));
	        case 'NonNullType':
	            const wrapped = buildTypeReferenceFromAST(typeNode.type, schema);
	            if (wrapped.kind == 'NonNullType') {
	                throw new graphql_1$8.GraphQLError(`Cannot apply the non-null operator (!) twice to the same type`, typeNode);
	            }
	            return new definitions_1$3.NonNullType(wrapped);
	        default:
	            return getReferencedType(typeNode, schema);
	    }
	}
	function buildArgumentDefinitionInner(inputNode, arg) {
	    var _a;
	    const type = buildTypeReferenceFromAST(inputNode.type, arg.schema());
	    arg.type = ensureInputType(type, arg.coordinate, inputNode);
	    arg.defaultValue = buildValue(inputNode.defaultValue);
	    buildAppliedDirectives(inputNode, arg);
	    arg.description = (_a = inputNode.description) === null || _a === void 0 ? void 0 : _a.value;
	    arg.sourceAST = inputNode;
	}
	function buildInputFieldDefinitionInner(fieldNode, field) {
	    var _a;
	    const type = buildTypeReferenceFromAST(fieldNode.type, field.schema());
	    field.type = ensureInputType(type, field.coordinate, fieldNode);
	    field.defaultValue = buildValue(fieldNode.defaultValue);
	    buildAppliedDirectives(fieldNode, field);
	    field.description = (_a = fieldNode.description) === null || _a === void 0 ? void 0 : _a.value;
	    field.sourceAST = fieldNode;
	}
	function buildDirectiveDefinitionInner(directiveNode, directive) {
	    var _a, _b;
	    for (const inputValueDef of (_a = directiveNode.arguments) !== null && _a !== void 0 ? _a : []) {
	        buildArgumentDefinitionInner(inputValueDef, directive.addArgument(inputValueDef.name.value));
	    }
	    directive.repeatable = directiveNode.repeatable;
	    const locations = directiveNode.locations.map(({ value }) => value);
	    directive.addLocations(...locations);
	    directive.description = (_b = directiveNode.description) === null || _b === void 0 ? void 0 : _b.value;
	    directive.sourceAST = directiveNode;
	}

	var federation = {};

	var KnownTypeNamesInFederationRule$1 = {};

	Object.defineProperty(KnownTypeNamesInFederationRule$1, "__esModule", { value: true });
	KnownTypeNamesInFederationRule$1.KnownTypeNamesInFederationRule = void 0;
	const graphql_1$7 = require$$2$1;
	const federation_1$1 = federation;
	const suggestions_1 = suggestions;
	function KnownTypeNamesInFederationRule(context) {
	    const schema = context.getSchema();
	    const existingTypesMap = schema ? schema.getTypeMap() : Object.create(null);
	    const definedTypes = Object.create(null);
	    for (const def of context.getDocument().definitions) {
	        if ((0, graphql_1$7.isTypeDefinitionNode)(def) || (0, graphql_1$7.isTypeExtensionNode)(def)) {
	            definedTypes[def.name.value] = true;
	        }
	    }
	    const typeNames = Object.keys(existingTypesMap).concat(Object.keys(definedTypes));
	    return {
	        NamedType(node, _1, parent, _2, ancestors) {
	            var _a;
	            const typeName = node.name.value;
	            if (!existingTypesMap[typeName] && !definedTypes[typeName]) {
	                const definitionNode = (_a = ancestors[2]) !== null && _a !== void 0 ? _a : parent;
	                const isSDL = definitionNode != null && isSDLNode(definitionNode);
	                if (isSDL && isStandardTypeName(typeName)) {
	                    return;
	                }
	                const suggestedTypes = (0, suggestions_1.suggestionList)(typeName, isSDL ? standardTypeNames.concat(typeNames) : typeNames);
	                context.reportError(new graphql_1$7.GraphQLError(`Unknown type "${typeName}".` + (0, suggestions_1.didYouMean)(suggestedTypes), node));
	            }
	        },
	    };
	}
	KnownTypeNamesInFederationRule$1.KnownTypeNamesInFederationRule = KnownTypeNamesInFederationRule;
	const standardTypeNames = [...graphql_1$7.specifiedScalarTypes, ...graphql_1$7.introspectionTypes].map((type) => type.name);
	function isStandardTypeName(typeName) {
	    return standardTypeNames.indexOf(typeName) !== -1 || (0, federation_1$1.isFederationTypeName)(typeName);
	}
	function isSDLNode(value) {
	    return (!Array.isArray(value) &&
	        ((0, graphql_1$7.isTypeSystemDefinitionNode)(value) || (0, graphql_1$7.isTypeSystemExtensionNode)(value)));
	}

	var operations = {};

	Object.defineProperty(operations, "__esModule", { value: true });
	operations.operationToDocument = operations.parseSelectionSet = operations.parseOperation = operations.operationFromDocument = operations.FragmentSelection = operations.FieldSelection = operations.selectionSetOfPath = operations.selectionOfElement = operations.selectionSetOfElement = operations.SelectionSet = operations.NamedFragments = operations.NamedFragmentDefinition = operations.selectionSetOf = operations.Operation = operations.sameOperationPaths = operations.FragmentElement = operations.Field = void 0;
	const graphql_1$6 = require$$2$1;
	const definitions_1$2 = definitions;
	const utils_1$1 = utils;
	const values_1 = values;
	function validate$1(condition, message, sourceAST) {
	    if (!condition) {
	        throw new graphql_1$6.GraphQLError(message(), sourceAST);
	    }
	}
	function haveSameDirectives(op1, op2) {
	    if (op1.appliedDirectives.length != op2.appliedDirectives.length) {
	        return false;
	    }
	    for (const thisDirective of op1.appliedDirectives) {
	        if (!op2.appliedDirectives.some(thatDirective => thisDirective.name === thatDirective.name && (0, values_1.argumentsEquals)(thisDirective.arguments(), thatDirective.arguments()))) {
	            return false;
	        }
	    }
	    return true;
	}
	class AbstractOperationElement extends definitions_1$2.DirectiveTargetElement {
	    constructor(schema, variablesInElement) {
	        super(schema);
	        this.variablesInElement = variablesInElement;
	    }
	    variables() {
	        return (0, definitions_1$2.mergeVariables)(this.variablesInElement, this.variablesInAppliedDirectives());
	    }
	}
	class Field extends AbstractOperationElement {
	    constructor(definition, args = Object.create(null), variableDefinitions = new definitions_1$2.VariableDefinitions(), alias) {
	        super(definition.schema(), (0, definitions_1$2.variablesInArguments)(args));
	        this.definition = definition;
	        this.args = args;
	        this.variableDefinitions = variableDefinitions;
	        this.alias = alias;
	        this.kind = 'Field';
	        this.validate();
	    }
	    get name() {
	        return this.definition.name;
	    }
	    responseName() {
	        return this.alias ? this.alias : this.name;
	    }
	    get parentType() {
	        return this.definition.parent;
	    }
	    withUpdatedDefinition(newDefinition) {
	        const newField = new Field(newDefinition, this.args, this.variableDefinitions, this.alias);
	        for (const directive of this.appliedDirectives) {
	            newField.applyDirective(directive.definition, directive.arguments());
	        }
	        return newField;
	    }
	    appliesTo(type) {
	        const definition = type.field(this.name);
	        return !!definition && this.selects(definition);
	    }
	    selects(definition, assumeValid = false) {
	        if (definition == this.definition) {
	            return true;
	        }
	        if (this.name !== definition.name) {
	            return false;
	        }
	        for (const argDef of definition.arguments()) {
	            const appliedValue = this.args[argDef.name];
	            if (appliedValue === undefined) {
	                if (argDef.defaultValue === undefined && !(0, definitions_1$2.isNullableType)(argDef.type)) {
	                    return false;
	                }
	            }
	            else {
	                if (!assumeValid && !(0, values_1.isValidValue)(appliedValue, argDef, this.variableDefinitions)) {
	                    return false;
	                }
	            }
	        }
	        if (!assumeValid) {
	            for (const [name, value] of Object.entries(this.args)) {
	                if (value !== null && definition.argument(name) === undefined) {
	                    return false;
	                }
	            }
	        }
	        return true;
	    }
	    validate() {
	        validate$1(this.name === this.definition.name, () => `Field name "${this.name}" cannot select field "${this.definition.coordinate}: name mismatch"`);
	        for (const argDef of this.definition.arguments()) {
	            const appliedValue = this.args[argDef.name];
	            if (appliedValue === undefined) {
	                validate$1(argDef.defaultValue !== undefined || (0, definitions_1$2.isNullableType)(argDef.type), () => `Missing mandatory value "${argDef.name}" in field selection "${this}"`);
	            }
	            else {
	                validate$1((0, values_1.isValidValue)(appliedValue, argDef, this.variableDefinitions), () => `Invalid value ${(0, values_1.valueToString)(appliedValue)} for argument "${argDef.coordinate}" of type ${argDef.type}`);
	            }
	        }
	        for (const [name, value] of Object.entries(this.args)) {
	            validate$1(value === null || this.definition.argument(name) !== undefined, () => `Unknown argument "${name}" in field application of "${this.name}"`);
	        }
	    }
	    updateForAddingTo(selectionSet) {
	        const selectionParent = selectionSet.parentType;
	        const fieldParent = this.definition.parent;
	        if (selectionParent.name !== fieldParent.name) {
	            if (this.name === definitions_1$2.typenameFieldName) {
	                return this.withUpdatedDefinition(selectionParent.typenameField());
	            }
	            validate$1(!(0, definitions_1$2.isUnionType)(selectionParent)
	                && (((0, definitions_1$2.isInterfaceType)(fieldParent) && fieldParent.allImplementations().some(i => i.name == selectionParent.name))
	                    || ((0, definitions_1$2.isObjectType)(fieldParent) && fieldParent.name == selectionParent.name)), () => `Cannot add selection of field "${this.definition.coordinate}" to selection set of parent type "${selectionSet.parentType}"`);
	            const fieldDef = selectionParent.field(this.name);
	            validate$1(fieldDef, () => `Cannot add selection of field "${this.definition.coordinate}" to selection set of parent type "${selectionParent} (that does not declare that type)"`);
	            return this.withUpdatedDefinition(fieldDef);
	        }
	        return this;
	    }
	    equals(that) {
	        if (this === that) {
	            return true;
	        }
	        return that.kind === 'Field'
	            && this.name === that.name
	            && this.alias === that.alias
	            && (0, values_1.argumentsEquals)(this.args, that.args)
	            && haveSameDirectives(this, that);
	    }
	    toString() {
	        const alias = this.alias ? this.alias + ': ' : '';
	        const entries = Object.entries(this.args);
	        const args = entries.length == 0
	            ? ''
	            : '(' + entries.map(([n, v]) => { var _a; return `${n}: ${(0, values_1.valueToString)(v, (_a = this.definition.argument(n)) === null || _a === void 0 ? void 0 : _a.type)}`; }).join(', ') + ')';
	        return alias + this.name + args + this.appliedDirectivesToString();
	    }
	}
	operations.Field = Field;
	class FragmentElement extends AbstractOperationElement {
	    constructor(sourceType, typeCondition) {
	        super(sourceType.schema(), []);
	        this.sourceType = sourceType;
	        this.kind = 'FragmentElement';
	        this.typeCondition = typeCondition !== undefined && typeof typeCondition === 'string'
	            ? this.schema().type(typeCondition)
	            : typeCondition;
	    }
	    get parentType() {
	        return this.sourceType;
	    }
	    withUpdatedSourceType(newSourceType) {
	        const newFragment = new FragmentElement(newSourceType, this.typeCondition);
	        for (const directive of this.appliedDirectives) {
	            newFragment.applyDirective(directive.definition, directive.arguments());
	        }
	        return newFragment;
	    }
	    updateForAddingTo(selectionSet) {
	        const selectionParent = selectionSet.parentType;
	        const fragmentParent = this.parentType;
	        const typeCondition = this.typeCondition;
	        if (selectionParent != fragmentParent) {
	            validate$1(!typeCondition || (0, definitions_1$2.runtimeTypesIntersects)(selectionParent, typeCondition), () => `Cannot add fragment of parent type "${this.parentType}" to selection set of parent type "${selectionSet.parentType}"`);
	            return this.withUpdatedSourceType(selectionParent);
	        }
	        return this;
	    }
	    equals(that) {
	        var _a, _b;
	        if (this === that) {
	            return true;
	        }
	        return that.kind === 'FragmentElement'
	            && ((_a = this.typeCondition) === null || _a === void 0 ? void 0 : _a.name) === ((_b = that.typeCondition) === null || _b === void 0 ? void 0 : _b.name)
	            && haveSameDirectives(this, that);
	    }
	    toString() {
	        return '...' + (this.typeCondition ? ' on ' + this.typeCondition : '') + this.appliedDirectivesToString();
	    }
	}
	operations.FragmentElement = FragmentElement;
	function sameOperationPaths(p1, p2) {
	    if (p1 === p2) {
	        return true;
	    }
	    if (p1.length !== p2.length) {
	        return false;
	    }
	    for (let i = 0; i < p1.length; i++) {
	        if (!p1[i].equals(p2[i])) {
	            return false;
	        }
	    }
	    return true;
	}
	operations.sameOperationPaths = sameOperationPaths;
	class Operation {
	    constructor(rootKind, selectionSet, variableDefinitions, name) {
	        this.rootKind = rootKind;
	        this.selectionSet = selectionSet;
	        this.variableDefinitions = variableDefinitions;
	        this.name = name;
	    }
	    optimize(fragments, minUsagesToOptimize = 2) {
	        if (!fragments) {
	            return this;
	        }
	        let optimizedSelection = this.selectionSet.optimize(fragments);
	        if (optimizedSelection === this.selectionSet) {
	            return this;
	        }
	        if (minUsagesToOptimize > 1) {
	            const usages = new Map();
	            optimizedSelection.collectUsedFragmentNames(usages);
	            for (const fragment of fragments.names()) {
	                if (!usages.has(fragment)) {
	                    usages.set(fragment, 0);
	                }
	            }
	            const toDeoptimize = (0, utils_1$1.mapEntries)(usages).filter(([_, count]) => count < minUsagesToOptimize).map(([name]) => name);
	            optimizedSelection = optimizedSelection.expandFragments(toDeoptimize);
	        }
	        return new Operation(this.rootKind, optimizedSelection, this.variableDefinitions, this.name);
	    }
	    expandAllFragments() {
	        const expandedSelections = this.selectionSet.expandFragments();
	        if (expandedSelections === this.selectionSet) {
	            return this;
	        }
	        return new Operation(this.rootKind, expandedSelections, this.variableDefinitions, this.name);
	    }
	    toString(expandFragments = false, prettyPrint = true) {
	        return this.selectionSet.toOperationString(this.rootKind, this.variableDefinitions, this.name, expandFragments, prettyPrint);
	    }
	}
	operations.Operation = Operation;
	function addDirectiveNodesToElement(directiveNodes, element) {
	    if (!directiveNodes) {
	        return;
	    }
	    const schema = element.schema();
	    for (const node of directiveNodes) {
	        const directiveDef = schema.directive(node.name.value);
	        validate$1(directiveDef, () => `Unknown directive "@${node.name.value}" in selection`);
	        element.applyDirective(directiveDef, (0, values_1.argumentsFromAST)(directiveDef.coordinate, node.arguments, directiveDef));
	    }
	}
	function selectionSetOf(parentType, selection) {
	    const selectionSet = new SelectionSet(parentType);
	    selectionSet.add(selection);
	    return selectionSet;
	}
	operations.selectionSetOf = selectionSetOf;
	class NamedFragmentDefinition extends definitions_1$2.DirectiveTargetElement {
	    constructor(schema, name, typeCondition, selectionSet) {
	        super(schema);
	        this.name = name;
	        this.typeCondition = typeCondition;
	        this.selectionSet = selectionSet;
	    }
	    variables() {
	        return (0, definitions_1$2.mergeVariables)(this.variablesInAppliedDirectives(), this.selectionSet.usedVariables());
	    }
	    collectUsedFragmentNames(collector) {
	        this.selectionSet.collectUsedFragmentNames(collector);
	    }
	    toFragmentDefinitionNode() {
	        return {
	            kind: 'FragmentDefinition',
	            name: {
	                kind: 'Name',
	                value: this.name
	            },
	            typeCondition: {
	                kind: 'NamedType',
	                name: {
	                    kind: 'Name',
	                    value: this.typeCondition.name
	                }
	            },
	            selectionSet: this.selectionSet.toSelectionSetNode()
	        };
	    }
	    toString(indent) {
	        return (indent !== null && indent !== void 0 ? indent : '') + `fragment ${this.name} on ${this.typeCondition}${this.appliedDirectivesToString()} ${this.selectionSet.toString(false, true, indent)}`;
	    }
	}
	operations.NamedFragmentDefinition = NamedFragmentDefinition;
	class NamedFragments {
	    constructor() {
	        this.fragments = new utils_1$1.MapWithCachedArrays();
	    }
	    isEmpty() {
	        return this.fragments.size === 0;
	    }
	    variables() {
	        let variables = [];
	        for (const fragment of this.fragments.values()) {
	            variables = (0, definitions_1$2.mergeVariables)(variables, fragment.variables());
	        }
	        return variables;
	    }
	    names() {
	        return this.fragments.keys();
	    }
	    add(fragment) {
	        if (this.fragments.has(fragment.name)) {
	            throw new graphql_1$6.GraphQLError(`Duplicate fragment name '${fragment}'`);
	        }
	        this.fragments.set(fragment.name, fragment);
	    }
	    addIfNotExist(fragment) {
	        if (!this.fragments.has(fragment.name)) {
	            this.fragments.set(fragment.name, fragment);
	        }
	    }
	    onType(type) {
	        return this.fragments.values().filter(f => f.typeCondition.name === type.name);
	    }
	    without(names) {
	        if (!names.some(n => this.fragments.has(n))) {
	            return this;
	        }
	        const newFragments = new NamedFragments();
	        for (const fragment of this.fragments.values()) {
	            if (!names.includes(fragment.name)) {
	                const updatedSelection = fragment.selectionSet.expandFragments(names, false);
	                const newFragment = updatedSelection === fragment.selectionSet
	                    ? fragment
	                    : new NamedFragmentDefinition(fragment.schema(), fragment.name, fragment.typeCondition, updatedSelection);
	                newFragments.add(newFragment);
	            }
	        }
	        return newFragments;
	    }
	    get(name) {
	        return this.fragments.get(name);
	    }
	    definitions() {
	        return this.fragments.values();
	    }
	    validate() {
	        for (const fragment of this.fragments.values()) {
	            fragment.selectionSet.validate();
	        }
	    }
	    toFragmentDefinitionNodes() {
	        return this.definitions().map(f => f.toFragmentDefinitionNode());
	    }
	    toString(indent) {
	        return this.definitions().map(f => f.toString(indent)).join('\n\n');
	    }
	}
	operations.NamedFragments = NamedFragments;
	class SelectionSet {
	    constructor(parentType, fragments) {
	        this.parentType = parentType;
	        this.fragments = fragments;
	        this._selections = new utils_1$1.MultiMap();
	        this._selectionCount = 0;
	        validate$1(!(0, definitions_1$2.isLeafType)(parentType), () => `Cannot have selection on non-leaf type ${parentType}`);
	    }
	    selections(reversedOrder = false) {
	        if (!this._cachedSelections) {
	            const selections = new Array(this._selectionCount);
	            let idx = 0;
	            for (const byResponseName of this._selections.values()) {
	                for (const selection of byResponseName) {
	                    selections[idx++] = selection;
	                }
	            }
	            this._cachedSelections = selections;
	        }
	        (0, utils_1$1.assert)(this._cachedSelections, 'Cache should have been populated');
	        if (reversedOrder) {
	            const reversed = new Array(this._selectionCount);
	            for (let i = 0; i < this._selectionCount; i++) {
	                reversed[i] = this._cachedSelections[this._selectionCount - i - 1];
	            }
	            return reversed;
	        }
	        return this._cachedSelections;
	    }
	    usedVariables() {
	        let variables = [];
	        for (const byResponseName of this._selections.values()) {
	            for (const selection of byResponseName) {
	                variables = (0, definitions_1$2.mergeVariables)(variables, selection.usedVariables());
	            }
	        }
	        if (this.fragments) {
	            variables = (0, definitions_1$2.mergeVariables)(variables, this.fragments.variables());
	        }
	        return variables;
	    }
	    collectUsedFragmentNames(collector) {
	        if (!this.fragments) {
	            return;
	        }
	        for (const byResponseName of this._selections.values()) {
	            for (const selection of byResponseName) {
	                selection.collectUsedFragmentNames(collector);
	            }
	        }
	    }
	    optimize(fragments) {
	        if (!fragments || fragments.isEmpty()) {
	            return this;
	        }
	        if (this.fragments && this.fragments.definitions().some(def => fragments.get(def.name))) {
	            return this;
	        }
	        const optimized = new SelectionSet(this.parentType, fragments);
	        for (const selection of this.selections()) {
	            optimized.add(selection.optimize(fragments));
	        }
	        return optimized;
	    }
	    expandFragments(names, updateSelectionSetFragments = true) {
	        var _a;
	        if (!this.fragments) {
	            return this;
	        }
	        if (names && names.length === 0) {
	            return this;
	        }
	        const newFragments = updateSelectionSetFragments
	            ? (names ? (_a = this.fragments) === null || _a === void 0 ? void 0 : _a.without(names) : undefined)
	            : this.fragments;
	        const withExpanded = new SelectionSet(this.parentType, newFragments);
	        for (const selection of this.selections()) {
	            withExpanded.add(selection.expandFragments(names, updateSelectionSetFragments));
	        }
	        return withExpanded;
	    }
	    mergeIn(selectionSet) {
	        for (const selection of selectionSet.selections()) {
	            this.add(selection);
	        }
	    }
	    addAll(selections) {
	        selections.forEach(s => this.add(s));
	        return this;
	    }
	    add(selection) {
	        const toAdd = selection.updateForAddingTo(this);
	        const key = toAdd.key();
	        let existing = this._selections.get(key);
	        if (existing) {
	            for (const existingSelection of existing) {
	                if (existingSelection.kind === toAdd.kind && haveSameDirectives(existingSelection.element(), toAdd.element())) {
	                    if (toAdd.selectionSet) {
	                        existingSelection.selectionSet.mergeIn(toAdd.selectionSet);
	                    }
	                    return existingSelection;
	                }
	            }
	        }
	        this._selections.add(key, toAdd);
	        ++this._selectionCount;
	        this._cachedSelections = undefined;
	        return selection;
	    }
	    addPath(path) {
	        let previousSelections = this;
	        let currentSelections = this;
	        for (const element of path) {
	            validate$1(currentSelections, () => `Cannot apply selection ${element} to non-selectable parent type "${previousSelections.parentType}"`);
	            const mergedSelection = currentSelections.add(selectionOfElement(element));
	            previousSelections = currentSelections;
	            currentSelections = mergedSelection.selectionSet;
	        }
	    }
	    addSelectionSetNode(node, variableDefinitions, fieldAccessor = (type, name) => type.field(name)) {
	        if (!node) {
	            return;
	        }
	        for (const selectionNode of node.selections) {
	            this.addSelectionNode(selectionNode, variableDefinitions, fieldAccessor);
	        }
	    }
	    addSelectionNode(node, variableDefinitions, fieldAccessor = (type, name) => type.field(name)) {
	        this.add(this.nodeToSelection(node, variableDefinitions, fieldAccessor));
	    }
	    nodeToSelection(node, variableDefinitions, fieldAccessor) {
	        var _a, _b;
	        let selection;
	        switch (node.kind) {
	            case 'Field':
	                const definition = fieldAccessor(this.parentType, node.name.value);
	                validate$1(definition, () => `Cannot query field "${node.name.value}" on type "${this.parentType}".`, this.parentType.sourceAST);
	                const type = (0, definitions_1$2.baseType)(definition.type);
	                selection = new FieldSelection(new Field(definition, (0, values_1.argumentsFromAST)(definition.coordinate, node.arguments, definition), variableDefinitions, (_a = node.alias) === null || _a === void 0 ? void 0 : _a.value), (0, definitions_1$2.isLeafType)(type) ? undefined : new SelectionSet(type, this.fragments));
	                if (node.selectionSet) {
	                    validate$1(selection.selectionSet, () => `Unexpected selection set on leaf field "${selection.element()}"`, selection.element().definition.sourceAST);
	                    selection.selectionSet.addSelectionSetNode(node.selectionSet, variableDefinitions, fieldAccessor);
	                }
	                break;
	            case 'InlineFragment':
	                const element = new FragmentElement(this.parentType, (_b = node.typeCondition) === null || _b === void 0 ? void 0 : _b.name.value);
	                selection = new InlineFragmentSelection(element, new SelectionSet(element.typeCondition ? element.typeCondition : element.parentType, this.fragments));
	                selection.selectionSet.addSelectionSetNode(node.selectionSet, variableDefinitions, fieldAccessor);
	                break;
	            case 'FragmentSpread':
	                const fragmentName = node.name.value;
	                validate$1(this.fragments, () => `Cannot find fragment name "${fragmentName}" (no fragments were provided)`);
	                selection = new FragmentSpreadSelection(this.parentType, this.fragments, fragmentName);
	                break;
	        }
	        addDirectiveNodesToElement(node.directives, selection.element());
	        return selection;
	    }
	    equals(that) {
	        if (this === that) {
	            return true;
	        }
	        if (this._selections.size !== that._selections.size) {
	            return false;
	        }
	        for (const [key, thisSelections] of this._selections) {
	            const thatSelections = that._selections.get(key);
	            if (!thatSelections
	                || thisSelections.length !== thatSelections.length
	                || !thisSelections.every(thisSelection => thatSelections.some(thatSelection => thisSelection.equals(thatSelection)))) {
	                return false;
	            }
	        }
	        return true;
	    }
	    contains(that) {
	        if (this._selections.size < that._selections.size) {
	            return false;
	        }
	        for (const [key, thatSelections] of that._selections) {
	            const thisSelections = this._selections.get(key);
	            if (!thisSelections
	                || (thisSelections.length < thatSelections.length
	                    || !thatSelections.every(thatSelection => thisSelections.some(thisSelection => thisSelection.contains(thatSelection))))) {
	                return false;
	            }
	        }
	        return true;
	    }
	    validate() {
	        validate$1(!this.isEmpty(), () => `Invalid empty selection set`);
	        for (const selection of this.selections()) {
	            selection.validate();
	            const selectionFragments = selection.namedFragments();
	            (0, utils_1$1.assert)(!selectionFragments || selectionFragments === this.fragments, () => `Selection fragments (${selectionFragments}) for ${selection} does not match selection set one (${this.fragments})`);
	        }
	    }
	    isEmpty() {
	        return this._selections.size === 0;
	    }
	    toSelectionSetNode() {
	        if (this.isEmpty()) {
	            return {
	                kind: graphql_1$6.Kind.SELECTION_SET,
	                selections: [{
	                        kind: 'Field',
	                        name: {
	                            kind: graphql_1$6.Kind.NAME,
	                            value: '...',
	                        },
	                    }]
	            };
	        }
	        return {
	            kind: graphql_1$6.Kind.SELECTION_SET,
	            selections: Array.from(this.selectionsInPrintOrder(), s => s.toSelectionNode())
	        };
	    }
	    selectionsInPrintOrder() {
	        const typenameSelection = this._selections.get(definitions_1$2.typenameFieldName);
	        if (typenameSelection) {
	            return typenameSelection.concat(this.selections().filter(s => s.kind != 'FieldSelection' || s.field.name !== definitions_1$2.typenameFieldName));
	        }
	        else {
	            return this.selections();
	        }
	    }
	    toOperationPaths() {
	        return this.toOperationPathsInternal([]);
	    }
	    toOperationPathsInternal(parentPaths) {
	        return this.selections().flatMap((selection) => {
	            const updatedPaths = parentPaths.map(path => path.concat(selection.element()));
	            return selection.selectionSet
	                ? selection.selectionSet.toOperationPathsInternal(updatedPaths)
	                : updatedPaths;
	        });
	    }
	    clone() {
	        const cloned = new SelectionSet(this.parentType);
	        for (const selection of this.selections()) {
	            cloned.add(selection.clone());
	        }
	        return cloned;
	    }
	    toOperationString(rootKind, variableDefinitions, operationName, expandFragments = false, prettyPrint = true) {
	        const indent = prettyPrint ? '' : undefined;
	        const fragmentsDefinitions = !expandFragments && this.fragments && !this.fragments.isEmpty()
	            ? this.fragments.toString(indent) + "\n\n"
	            : "";
	        if (rootKind == "query" && !operationName && variableDefinitions.isEmpty()) {
	            return fragmentsDefinitions + this.toString(expandFragments, true, indent);
	        }
	        const nameAndVariables = operationName
	            ? " " + (operationName + (variableDefinitions.isEmpty() ? "" : variableDefinitions.toString()))
	            : (variableDefinitions.isEmpty() ? "" : " " + variableDefinitions.toString());
	        return fragmentsDefinitions + rootKind + nameAndVariables + " " + this.toString(expandFragments, true, indent);
	    }
	    toString(expandFragments = true, includeExternalBrackets = true, indent) {
	        if (indent === undefined) {
	            const selectionsToString = this.selections().map(s => s.toString(expandFragments)).join(' ');
	            return includeExternalBrackets ? '{ ' + selectionsToString + ' }' : selectionsToString;
	        }
	        else {
	            const selectionIndent = includeExternalBrackets ? indent + "  " : indent;
	            const selectionsToString = this.selections().map(s => s.toString(expandFragments, selectionIndent)).join('\n');
	            return includeExternalBrackets
	                ? '{\n' + selectionsToString + '\n' + indent + '}'
	                : selectionsToString;
	        }
	    }
	}
	operations.SelectionSet = SelectionSet;
	function selectionSetOfElement(element, subSelection) {
	    const selectionSet = new SelectionSet(element.parentType);
	    selectionSet.add(selectionOfElement(element, subSelection));
	    return selectionSet;
	}
	operations.selectionSetOfElement = selectionSetOfElement;
	function selectionOfElement(element, subSelection) {
	    return element.kind === 'Field' ? new FieldSelection(element, subSelection) : new InlineFragmentSelection(element, subSelection);
	}
	operations.selectionOfElement = selectionOfElement;
	function selectionSetOfPath(path, onPathEnd) {
	    validate$1(path.length > 0, () => `Cannot create a selection set from an empty path`);
	    const last = selectionSetOfElement(path[path.length - 1]);
	    let current = last;
	    for (let i = path.length - 2; i >= 0; i--) {
	        current = selectionSetOfElement(path[i], current);
	    }
	    if (onPathEnd) {
	        onPathEnd(last.selections()[0].selectionSet);
	    }
	    return current;
	}
	operations.selectionSetOfPath = selectionSetOfPath;
	class FieldSelection {
	    constructor(field, initialSelectionSet) {
	        this.field = field;
	        this.kind = 'FieldSelection';
	        const type = (0, definitions_1$2.baseType)(field.definition.type);
	        this.selectionSet = (0, definitions_1$2.isLeafType)(type) ? undefined : (initialSelectionSet ? initialSelectionSet : new SelectionSet(type));
	    }
	    key() {
	        return this.element().responseName();
	    }
	    element() {
	        return this.field;
	    }
	    usedVariables() {
	        var _a, _b;
	        return (0, definitions_1$2.mergeVariables)(this.element().variables(), (_b = (_a = this.selectionSet) === null || _a === void 0 ? void 0 : _a.usedVariables()) !== null && _b !== void 0 ? _b : []);
	    }
	    collectUsedFragmentNames(collector) {
	        if (this.selectionSet) {
	            this.selectionSet.collectUsedFragmentNames(collector);
	        }
	    }
	    optimize(fragments) {
	        const optimizedSelection = this.selectionSet ? this.selectionSet.optimize(fragments) : undefined;
	        return this.selectionSet === optimizedSelection
	            ? this
	            : new FieldSelection(this.field, optimizedSelection);
	    }
	    expandFragments(names, updateSelectionSetFragments = true) {
	        const expandedSelection = this.selectionSet ? this.selectionSet.expandFragments(names, updateSelectionSetFragments) : undefined;
	        return this.selectionSet === expandedSelection
	            ? this
	            : new FieldSelection(this.field, expandedSelection);
	    }
	    fieldArgumentsToAST() {
	        const entries = Object.entries(this.field.args);
	        if (entries.length === 0) {
	            return undefined;
	        }
	        return entries.map(([n, v]) => {
	            return {
	                kind: 'Argument',
	                name: { kind: graphql_1$6.Kind.NAME, value: n },
	                value: (0, values_1.valueToAST)(v, this.field.definition.argument(n).type),
	            };
	        });
	    }
	    validate() {
	        var _a;
	        validate$1(!(this.selectionSet && this.selectionSet.isEmpty()), () => `Invalid empty selection set for field "${this.field.definition.coordinate}" of non-leaf type ${this.field.definition.type}`, this.field.definition.sourceAST);
	        (_a = this.selectionSet) === null || _a === void 0 ? void 0 : _a.validate();
	    }
	    updateForAddingTo(selectionSet) {
	        const updatedField = this.field.updateForAddingTo(selectionSet);
	        return this.field === updatedField ? this : new FieldSelection(updatedField, this.selectionSet);
	    }
	    toSelectionNode() {
	        var _a;
	        const alias = this.field.alias ? { kind: graphql_1$6.Kind.NAME, value: this.field.alias, } : undefined;
	        return {
	            kind: 'Field',
	            name: {
	                kind: graphql_1$6.Kind.NAME,
	                value: this.field.name,
	            },
	            alias,
	            arguments: this.fieldArgumentsToAST(),
	            directives: this.element().appliedDirectivesToDirectiveNodes(),
	            selectionSet: (_a = this.selectionSet) === null || _a === void 0 ? void 0 : _a.toSelectionSetNode()
	        };
	    }
	    equals(that) {
	        if (this === that) {
	            return true;
	        }
	        if (!(that instanceof FieldSelection) || !this.field.equals(that.field)) {
	            return false;
	        }
	        if (!this.selectionSet) {
	            return !that.selectionSet;
	        }
	        return !!that.selectionSet && this.selectionSet.equals(that.selectionSet);
	    }
	    contains(that) {
	        if (!(that instanceof FieldSelection) || !this.field.equals(that.field)) {
	            return false;
	        }
	        if (!that.selectionSet) {
	            return true;
	        }
	        return !!this.selectionSet && this.selectionSet.contains(that.selectionSet);
	    }
	    namedFragments() {
	        var _a;
	        return (_a = this.selectionSet) === null || _a === void 0 ? void 0 : _a.fragments;
	    }
	    clone() {
	        if (!this.selectionSet) {
	            return this;
	        }
	        return new FieldSelection(this.field, this.selectionSet.clone());
	    }
	    toString(expandFragments = true, indent) {
	        return (indent !== null && indent !== void 0 ? indent : '') + this.field + (this.selectionSet ? ' ' + this.selectionSet.toString(expandFragments, true, indent) : '');
	    }
	}
	operations.FieldSelection = FieldSelection;
	class FragmentSelection {
	    constructor() {
	        this.kind = 'FragmentSelection';
	    }
	    usedVariables() {
	        return (0, definitions_1$2.mergeVariables)(this.element().variables(), this.selectionSet.usedVariables());
	    }
	    updateForAddingTo(selectionSet) {
	        const updatedFragment = this.element().updateForAddingTo(selectionSet);
	        return this.element() === updatedFragment ? this : new InlineFragmentSelection(updatedFragment, this.selectionSet);
	    }
	    equals(that) {
	        if (this === that) {
	            return true;
	        }
	        return (that instanceof FragmentSelection)
	            && this.element().equals(that.element())
	            && this.selectionSet.equals(that.selectionSet);
	    }
	    contains(that) {
	        return (that instanceof FragmentSelection)
	            && this.element().equals(that.element())
	            && this.selectionSet.contains(that.selectionSet);
	    }
	    clone() {
	        return new InlineFragmentSelection(this.element(), this.selectionSet.clone());
	    }
	}
	operations.FragmentSelection = FragmentSelection;
	class InlineFragmentSelection extends FragmentSelection {
	    constructor(fragmentElement, initialSelectionSet) {
	        super();
	        this.fragmentElement = fragmentElement;
	        this._selectionSet = initialSelectionSet
	            ? initialSelectionSet
	            : new SelectionSet(fragmentElement.typeCondition ? fragmentElement.typeCondition : fragmentElement.parentType);
	    }
	    key() {
	        var _a, _b;
	        return (_b = (_a = this.element().typeCondition) === null || _a === void 0 ? void 0 : _a.name) !== null && _b !== void 0 ? _b : '';
	    }
	    validate() {
	        validate$1(!this.selectionSet.isEmpty(), () => `Invalid empty selection set for fragment "${this.element()}"`);
	        this.selectionSet.validate();
	    }
	    get selectionSet() {
	        return this._selectionSet;
	    }
	    namedFragments() {
	        return this.selectionSet.fragments;
	    }
	    element() {
	        return this.fragmentElement;
	    }
	    toSelectionNode() {
	        const typeCondition = this.element().typeCondition;
	        return {
	            kind: graphql_1$6.Kind.INLINE_FRAGMENT,
	            typeCondition: typeCondition
	                ? {
	                    kind: graphql_1$6.Kind.NAMED_TYPE,
	                    name: {
	                        kind: graphql_1$6.Kind.NAME,
	                        value: typeCondition.name,
	                    },
	                }
	                : undefined,
	            directives: this.element().appliedDirectivesToDirectiveNodes(),
	            selectionSet: this.selectionSet.toSelectionSetNode()
	        };
	    }
	    optimize(fragments) {
	        const optimizedSelection = this.selectionSet.optimize(fragments);
	        const typeCondition = this.element().typeCondition;
	        if (typeCondition) {
	            for (const candidate of fragments.onType(typeCondition)) {
	                if (candidate.selectionSet.equals(optimizedSelection)) {
	                    fragments.addIfNotExist(candidate);
	                    return new FragmentSpreadSelection(this.element().parentType, fragments, candidate.name);
	                }
	            }
	        }
	        return this.selectionSet === optimizedSelection
	            ? this
	            : new InlineFragmentSelection(this.fragmentElement, optimizedSelection);
	    }
	    expandFragments(names, updateSelectionSetFragments = true) {
	        const expandedSelection = this.selectionSet.expandFragments(names, updateSelectionSetFragments);
	        return this.selectionSet === expandedSelection
	            ? this
	            : new InlineFragmentSelection(this.element(), expandedSelection);
	    }
	    collectUsedFragmentNames(collector) {
	        this.selectionSet.collectUsedFragmentNames(collector);
	    }
	    toString(expandFragments = true, indent) {
	        return (indent !== null && indent !== void 0 ? indent : '') + this.fragmentElement + ' ' + this.selectionSet.toString(expandFragments, true, indent);
	    }
	}
	class FragmentSpreadSelection extends FragmentSelection {
	    constructor(sourceType, fragments, fragmentName) {
	        super();
	        this.fragments = fragments;
	        const fragmentDefinition = fragments.get(fragmentName);
	        validate$1(fragmentDefinition, () => `Unknown fragment "...${fragmentName}"`);
	        this.namedFragment = fragmentDefinition;
	        this._element = new FragmentElement(sourceType, fragmentDefinition.typeCondition);
	        for (const directive of fragmentDefinition.appliedDirectives) {
	            this._element.applyDirective(directive.definition, directive.arguments());
	        }
	    }
	    key() {
	        return '...' + this.namedFragment.name;
	    }
	    element() {
	        return this._element;
	    }
	    namedFragments() {
	        return this.fragments;
	    }
	    get selectionSet() {
	        return this.namedFragment.selectionSet;
	    }
	    validate() {
	    }
	    toSelectionNode() {
	        const spreadDirectives = this.spreadDirectives();
	        const directiveNodes = spreadDirectives.length === 0
	            ? undefined
	            : spreadDirectives.map(directive => {
	                return {
	                    kind: 'Directive',
	                    name: {
	                        kind: graphql_1$6.Kind.NAME,
	                        value: directive.name,
	                    },
	                    arguments: directive.argumentsToAST()
	                };
	            });
	        return {
	            kind: 'FragmentSpread',
	            name: { kind: 'Name', value: this.namedFragment.name },
	            directives: directiveNodes,
	        };
	    }
	    optimize(_) {
	        return this;
	    }
	    expandFragments(names, updateSelectionSetFragments = true) {
	        if (names && !names.includes(this.namedFragment.name)) {
	            return this;
	        }
	        return new InlineFragmentSelection(this._element, this.selectionSet.expandFragments(names, updateSelectionSetFragments));
	    }
	    collectUsedFragmentNames(collector) {
	        this.selectionSet.collectUsedFragmentNames(collector);
	        const usageCount = collector.get(this.namedFragment.name);
	        collector.set(this.namedFragment.name, usageCount === undefined ? 1 : usageCount + 1);
	    }
	    spreadDirectives() {
	        return this._element.appliedDirectives.slice(this.namedFragment.appliedDirectives.length);
	    }
	    toString(expandFragments = true, indent) {
	        if (expandFragments) {
	            return (indent !== null && indent !== void 0 ? indent : '') + this._element + ' ' + this.selectionSet.toString(true, true, indent);
	        }
	        else {
	            const directives = this.spreadDirectives();
	            const directiveString = directives.length == 0 ? '' : ' ' + directives.join(' ');
	            return (indent !== null && indent !== void 0 ? indent : '') + '...' + this.namedFragment.name + directiveString;
	        }
	    }
	}
	function operationFromDocument(schema, document, operationName) {
	    let operation;
	    const fragments = new NamedFragments();
	    document.definitions.forEach(definition => {
	        switch (definition.kind) {
	            case graphql_1$6.Kind.OPERATION_DEFINITION:
	                validate$1(!operation || operationName, () => 'Must provide operation name if query contains multiple operations.');
	                if (!operationName || (definition.name && definition.name.value === operationName)) {
	                    operation = definition;
	                }
	                break;
	            case graphql_1$6.Kind.FRAGMENT_DEFINITION:
	                const name = definition.name.value;
	                const typeName = definition.typeCondition.name.value;
	                const typeCondition = schema.type(typeName);
	                if (!typeCondition) {
	                    throw new graphql_1$6.GraphQLError(`Unknown type "${typeName}" for fragment "${name}"`, definition);
	                }
	                if (!(0, definitions_1$2.isCompositeType)(typeCondition)) {
	                    throw new graphql_1$6.GraphQLError(`Invalid fragment "${name}" on non-composite type "${typeName}"`, definition);
	                }
	                const fragment = new NamedFragmentDefinition(schema, name, typeCondition, new SelectionSet(typeCondition, fragments));
	                addDirectiveNodesToElement(definition.directives, fragment);
	                fragments.add(fragment);
	                break;
	        }
	    });
	    validate$1(operation, () => operationName ? `Unknown operation named "${operationName}"` : 'No operation found in provided document.');
	    const variableDefinitions = operation.variableDefinitions
	        ? (0, definitions_1$2.variableDefinitionsFromAST)(schema, operation.variableDefinitions)
	        : new definitions_1$2.VariableDefinitions();
	    document.definitions.forEach(definition => {
	        switch (definition.kind) {
	            case graphql_1$6.Kind.FRAGMENT_DEFINITION:
	                const fragment = fragments.get(definition.name.value);
	                fragment.selectionSet.addSelectionSetNode(definition.selectionSet, variableDefinitions);
	                break;
	        }
	    });
	    fragments.validate();
	    return operationFromAST(schema, operation, fragments);
	}
	operations.operationFromDocument = operationFromDocument;
	function operationFromAST(schema, operation, fragments) {
	    var _a;
	    const rootType = schema.schemaDefinition.root(operation.operation);
	    validate$1(rootType, () => `The schema has no "${operation.operation}" root type defined`);
	    const variableDefinitions = operation.variableDefinitions ? (0, definitions_1$2.variableDefinitionsFromAST)(schema, operation.variableDefinitions) : new definitions_1$2.VariableDefinitions();
	    return new Operation(operation.operation, parseSelectionSet(rootType.type, operation.selectionSet, variableDefinitions, fragments), variableDefinitions, (_a = operation.name) === null || _a === void 0 ? void 0 : _a.value);
	}
	function parseOperation(schema, operation, operationName) {
	    return operationFromDocument(schema, (0, graphql_1$6.parse)(operation), operationName);
	}
	operations.parseOperation = parseOperation;
	function parseSelectionSet(parentType, source, variableDefinitions = new definitions_1$2.VariableDefinitions(), fragments, fieldAccessor = (type, name) => type.field(name)) {
	    const node = typeof source === 'string'
	        ? parseOperationAST(source.trim().startsWith('{') ? source : `{${source}}`).selectionSet
	        : source;
	    const selectionSet = new SelectionSet(parentType, fragments);
	    selectionSet.addSelectionSetNode(node, variableDefinitions, fieldAccessor);
	    selectionSet.validate();
	    return selectionSet;
	}
	operations.parseSelectionSet = parseSelectionSet;
	function parseOperationAST(source) {
	    const parsed = (0, graphql_1$6.parse)(source);
	    validate$1(parsed.definitions.length === 1, () => 'Selections should contain a single definitions, found ' + parsed.definitions.length);
	    const def = parsed.definitions[0];
	    validate$1(def.kind === 'OperationDefinition', () => 'Expected an operation definition but got a ' + def.kind);
	    return def;
	}
	function operationToDocument(operation) {
	    var _a;
	    const operationAST = {
	        kind: 'OperationDefinition',
	        operation: operation.rootKind,
	        selectionSet: operation.selectionSet.toSelectionSetNode(),
	        variableDefinitions: operation.variableDefinitions.toVariableDefinitionNodes(),
	    };
	    const fragmentASTs = operation.selectionSet.fragments
	        ? (_a = operation.selectionSet.fragments) === null || _a === void 0 ? void 0 : _a.toFragmentDefinitionNodes()
	        : [];
	    return {
	        kind: graphql_1$6.Kind.DOCUMENT,
	        definitions: [operationAST].concat(fragmentASTs),
	    };
	}
	operations.operationToDocument = operationToDocument;

	var tagSpec$1 = {};

	var error$1 = {};

	Object.defineProperty(error$1, "__esModule", { value: true });
	error$1.error = void 0;
	const graphql_1$5 = require$$2$1;
	function error(code, message, nodes, source, positions, path, originalError, extensions) {
	    return new graphql_1$5.GraphQLError(message, nodes, source, positions, path, originalError, {
	        ...extensions,
	        code,
	    });
	}
	error$1.error = error;

	(function (exports) {
	Object.defineProperty(exports, "__esModule", { value: true });
	exports.TAG_VERSIONS = exports.TagSpecDefinition = exports.tagLocations = exports.tagIdentity = void 0;
	const coreSpec_1 = coreSpec$1;
	const definitions_1 = definitions;
	const error_1 = error$1;
	const types_1 = types;
	const utils_1 = utils;
	exports.tagIdentity = 'https://specs.apollo.dev/tag';
	exports.tagLocations = ['FIELD_DEFINITION', 'OBJECT', 'INTERFACE', 'UNION'];
	const printedTagDefinition = 'directive @tag(name: String!) repeatable on FIELD_DEFINITION | INTERFACE | OBJECT | UNION';
	class TagSpecDefinition extends coreSpec_1.FeatureDefinition {
	    constructor(version) {
	        super(new coreSpec_1.FeatureUrl(exports.tagIdentity, 'tag', version));
	    }
	    addElementsToSchema(schema) {
	        const directive = this.addDirective(schema, 'tag').addLocations(...exports.tagLocations);
	        directive.addArgument("name", new definitions_1.NonNullType(schema.stringType()));
	    }
	    tagDirective(schema) {
	        return this.directive(schema, 'tag');
	    }
	    checkCompatibleDirective(definition) {
	        (0, utils_1.assert)(definition.name === 'tag', () => `This method should not have been called on directive named ${definition.name}`);
	        const hasUnknownArguments = Object.keys(definition.arguments()).length > 1;
	        const nameArg = definition.argument('name');
	        const hasValidNameArg = nameArg && (0, types_1.sameType)(nameArg.type, new definitions_1.NonNullType(definition.schema().stringType()));
	        const hasValidLocations = definition.locations.every(loc => exports.tagLocations.includes(loc));
	        if (hasUnknownArguments || !hasValidNameArg || !hasValidLocations) {
	            return (0, error_1.error)('TAG_DIRECTIVE_DEFINITION_INVALID', `Found invalid @tag directive definition. Please ensure the directive definition in your schema's definitions matches the following:\n\t${printedTagDefinition}`);
	        }
	        return undefined;
	    }
	}
	exports.TagSpecDefinition = TagSpecDefinition;
	exports.TAG_VERSIONS = new coreSpec_1.FeatureDefinitions(exports.tagIdentity)
	    .add(new TagSpecDefinition(new coreSpec_1.FeatureVersion(0, 1)));

	}(tagSpec$1));

	(function (exports) {
	Object.defineProperty(exports, "__esModule", { value: true });
	exports.ExternalTester = exports.addSubgraphToError = exports.addSubgraphToASTNode = exports.Subgraph = exports.Subgraphs = exports.subgraphsFromServiceList = exports.parseFieldSetArgument = exports.isEntityType = exports.isFederationDirective = exports.isFederationField = exports.isFederationTypeName = exports.isFederationType = exports.isFederationSubgraphSchema = exports.federationBuiltIns = exports.FederationBuiltIns = exports.FEDERATION_RESERVED_SUBGRAPH_NAME = exports.entitiesFieldName = exports.serviceFieldName = exports.tagDirectiveName = exports.providesDirectiveName = exports.requiresDirectiveName = exports.externalDirectiveName = exports.extendsDirectiveName = exports.keyDirectiveName = exports.fieldSetTypeName = exports.anyTypeName = exports.serviceTypeName = exports.entityTypeName = void 0;
	const definitions_1 = definitions;
	const utils_1 = utils;
	const specifiedRules_1 = require$$2;
	const graphql_1 = require$$2$1;
	const print_1 = print;
	const KnownTypeNamesInFederationRule_1 = KnownTypeNamesInFederationRule$1;
	const buildSchema_1 = buildSchema$1;
	const operations_1 = operations;
	const tagSpec_1 = tagSpec$1;
	const error_1 = error$1;
	exports.entityTypeName = '_Entity';
	exports.serviceTypeName = '_Service';
	exports.anyTypeName = '_Any';
	exports.fieldSetTypeName = '_FieldSet';
	exports.keyDirectiveName = 'key';
	exports.extendsDirectiveName = 'extends';
	exports.externalDirectiveName = 'external';
	exports.requiresDirectiveName = 'requires';
	exports.providesDirectiveName = 'provides';
	exports.tagDirectiveName = 'tag';
	exports.serviceFieldName = '_service';
	exports.entitiesFieldName = '_entities';
	const tagSpec = tagSpec_1.TAG_VERSIONS.latest();
	exports.FEDERATION_RESERVED_SUBGRAPH_NAME = '_';
	const FEDERATION_TYPES = [
	    exports.entityTypeName,
	    exports.serviceTypeName,
	    exports.anyTypeName,
	    exports.fieldSetTypeName
	];
	const FEDERATION_DIRECTIVES = [
	    exports.keyDirectiveName,
	    exports.extendsDirectiveName,
	    exports.externalDirectiveName,
	    exports.requiresDirectiveName,
	    exports.providesDirectiveName,
	    exports.tagDirectiveName
	];
	const FEDERATION_ROOT_FIELDS = [
	    exports.serviceFieldName,
	    exports.entitiesFieldName
	];
	const FEDERATION_OMITTED_VALIDATION_RULES = [
	    graphql_1.PossibleTypeExtensionsRule,
	    graphql_1.KnownTypeNamesRule
	];
	const FEDERATION_SPECIFIC_VALIDATION_RULES = [
	    KnownTypeNamesInFederationRule_1.KnownTypeNamesInFederationRule
	];
	const FEDERATION_VALIDATION_RULES = specifiedRules_1.specifiedSDLRules.filter(rule => !FEDERATION_OMITTED_VALIDATION_RULES.includes(rule)).concat(FEDERATION_SPECIFIC_VALIDATION_RULES);
	function validateFieldSetSelections(directiveName, selectionSet, hasExternalInParents, externalTester, externalFieldCoordinatesCollector, allowOnNonExternalLeafFields) {
	    for (const selection of selectionSet.selections()) {
	        if (selection.kind === 'FieldSelection') {
	            const field = selection.element().definition;
	            if (field.hasArguments()) {
	                throw new graphql_1.GraphQLError(`field ${field.coordinate} cannot be included because it has arguments (fields with argument are not allowed in @${directiveName})`, field.sourceAST);
	            }
	            const mustBeExternal = !selection.selectionSet && !allowOnNonExternalLeafFields && !hasExternalInParents;
	            const isExternal = externalTester.isExternal(field);
	            if (isExternal) {
	                externalFieldCoordinatesCollector.push(field.coordinate);
	            }
	            else if (mustBeExternal) {
	                if (externalTester.isFakeExternal(field)) {
	                    throw new graphql_1.GraphQLError(`field "${field.coordinate}" should not be part of a @${directiveName} since it is already "effectively" provided by this subgraph `
	                        + `(while it is marked @${exports.externalDirectiveName}, it is a @${exports.keyDirectiveName} field of an extension type, which are not internally considered external for historical/backward compatibility reasons)`, field.sourceAST);
	                }
	                else {
	                    throw new graphql_1.GraphQLError(`field "${field.coordinate}" should not be part of a @${directiveName} since it is already provided by this subgraph (it is not marked @${exports.externalDirectiveName})`, field.sourceAST);
	                }
	            }
	            if (selection.selectionSet) {
	                validateFieldSetSelections(directiveName, selection.selectionSet, hasExternalInParents || isExternal, externalTester, externalFieldCoordinatesCollector, allowOnNonExternalLeafFields);
	            }
	        }
	        else {
	            validateFieldSetSelections(directiveName, selection.selectionSet, hasExternalInParents, externalTester, externalFieldCoordinatesCollector, allowOnNonExternalLeafFields);
	        }
	    }
	}
	function validateFieldSet(type, directive, targetDescription, externalTester, externalFieldCoordinatesCollector, allowOnNonExternalLeafFields) {
	    try {
	        const selectionSet = parseFieldSetArgument(type, directive);
	        selectionSet.validate();
	        validateFieldSetSelections(directive.name, selectionSet, false, externalTester, externalFieldCoordinatesCollector, allowOnNonExternalLeafFields);
	        return undefined;
	    }
	    catch (e) {
	        if (!(e instanceof graphql_1.GraphQLError)) {
	            throw e;
	        }
	        const nodes = (0, definitions_1.sourceASTs)(directive);
	        if (e.nodes) {
	            nodes.push(...e.nodes);
	        }
	        let msg = e.message.trim();
	        if (msg.startsWith('Cannot query field')) {
	            if (msg.endsWith('.')) {
	                msg = msg.slice(0, msg.length - 1);
	            }
	            if (directive.name === exports.keyDirectiveName) {
	                msg = msg + ' (the field should be either be added to this subgraph or, if it should not be resolved by this subgraph, you need to add it to this subgraph with @external).';
	            }
	            else {
	                msg = msg + ' (if the field is defined in another subgraph, you need to add it to this subgraph with @external).';
	            }
	        }
	        return new graphql_1.GraphQLError(`On ${targetDescription}, for ${directive}: ${msg}`, nodes);
	    }
	}
	function validateAllFieldSet(definition, targetTypeExtractor, targetDescriptionExtractor, errorCollector, externalTester, externalFieldCoordinatesCollector, isOnParentType, allowOnNonExternalLeafFields) {
	    for (const application of definition.applications()) {
	        const elt = application.parent;
	        const type = targetTypeExtractor(elt);
	        const targetDescription = targetDescriptionExtractor(elt);
	        const parentType = isOnParentType ? type : elt.parent;
	        if ((0, definitions_1.isInterfaceType)(parentType)) {
	            errorCollector.push(new graphql_1.GraphQLError(isOnParentType
	                ? `Cannot use ${definition.coordinate} on interface ${parentType.coordinate}: ${definition.coordinate} is not yet supported on interfaces`
	                : `Cannot use ${definition.coordinate} on ${targetDescription} of parent type ${parentType}: ${definition.coordinate} is not yet supported within interfaces`, (0, definitions_1.sourceASTs)(application).concat(isOnParentType ? [] : (0, definitions_1.sourceASTs)(type))));
	        }
	        const error = validateFieldSet(type, application, targetDescription, externalTester, externalFieldCoordinatesCollector, allowOnNonExternalLeafFields);
	        if (error) {
	            errorCollector.push(error);
	        }
	    }
	}
	function validateAllExternalFieldsUsed(schema, externalTester, allExternalFieldsUsedInFederationDirectivesCoordinates, errorCollector) {
	    for (const type of schema.types()) {
	        if (!(0, definitions_1.isObjectType)(type) && !(0, definitions_1.isInterfaceType)(type)) {
	            continue;
	        }
	        for (const field of type.fields()) {
	            if (!externalTester.isExternal(field) || allExternalFieldsUsedInFederationDirectivesCoordinates.includes(field.coordinate)) {
	                continue;
	            }
	            if (!isFieldSatisfyingInterface(field)) {
	                errorCollector.push(new graphql_1.GraphQLError(`Field ${field.coordinate} is marked @external but is not used in any federation directive (@key, @provides, @requires) or to satisfy an interface;`
	                    + ' the field declaration has no use and should be removed (or the field should not be @external).', field.sourceAST));
	            }
	        }
	    }
	}
	function isFieldSatisfyingInterface(field) {
	    return field.parent.interfaces().some(itf => itf.field(field.name));
	}
	class FederationBuiltIns extends definitions_1.BuiltIns {
	    addBuiltInTypes(schema) {
	        super.addBuiltInTypes(schema);
	        this.addBuiltInUnion(schema, exports.entityTypeName);
	        this.addBuiltInObject(schema, exports.serviceTypeName).addField('sdl', schema.stringType());
	        this.addBuiltInScalar(schema, exports.anyTypeName);
	        this.addBuiltInScalar(schema, exports.fieldSetTypeName);
	    }
	    addBuiltInDirectives(schema) {
	        super.addBuiltInDirectives(schema);
	        const fieldSetType = new definitions_1.NonNullType(schema.type(exports.fieldSetTypeName));
	        const keyDirective = this.addBuiltInDirective(schema, exports.keyDirectiveName)
	            .addLocations('OBJECT', 'INTERFACE');
	        keyDirective.repeatable = true;
	        keyDirective.addArgument('fields', fieldSetType);
	        this.addBuiltInDirective(schema, exports.extendsDirectiveName)
	            .addLocations('OBJECT', 'INTERFACE');
	        this.addBuiltInDirective(schema, exports.externalDirectiveName)
	            .addLocations('OBJECT', 'FIELD_DEFINITION');
	        for (const name of [exports.requiresDirectiveName, exports.providesDirectiveName]) {
	            this.addBuiltInDirective(schema, name)
	                .addLocations('FIELD_DEFINITION')
	                .addArgument('fields', fieldSetType);
	        }
	        const directive = this.addBuiltInDirective(schema, 'tag').addLocations(...tagSpec_1.tagLocations);
	        directive.addArgument("name", new definitions_1.NonNullType(schema.stringType()));
	    }
	    prepareValidation(schema) {
	        super.prepareValidation(schema);
	        let entityType = schema.type(exports.entityTypeName);
	        if (!entityType.isBuiltIn) {
	            if (entityType.membersCount() === 0) {
	                entityType.remove();
	            }
	            entityType = schema.builtInTypes('UnionType', true).find(u => u.name === exports.entityTypeName);
	        }
	        entityType.clearTypes();
	        for (const objectType of schema.types("ObjectType")) {
	            if (isEntityType(objectType)) {
	                entityType.addType(objectType);
	            }
	        }
	        const hasEntities = entityType.membersCount() > 0;
	        if (!hasEntities) {
	            entityType.remove();
	        }
	        const queryRoot = schema.schemaDefinition.root("query");
	        const queryType = queryRoot ? queryRoot.type : schema.addType(new definitions_1.ObjectType("Query"));
	        let entityField = queryType.field(exports.entitiesFieldName);
	        if (hasEntities) {
	            const anyType = schema.type(exports.anyTypeName);
	            (0, utils_1.assert)(anyType, `The schema should have the _Any type`);
	            const entityFieldType = new definitions_1.NonNullType(new definitions_1.ListType(entityType));
	            if (!entityField) {
	                this.addBuiltInField(queryType, exports.entitiesFieldName, entityFieldType)
	                    .addArgument('representations', new definitions_1.NonNullType(new definitions_1.ListType(new definitions_1.NonNullType(anyType))));
	            }
	            else if (!entityField.type) {
	                entityField.type = entityType;
	            }
	        }
	        else if (entityField) {
	            entityField.remove();
	        }
	        if (!queryType.field(exports.serviceFieldName)) {
	            this.addBuiltInField(queryType, exports.serviceFieldName, schema.type(exports.serviceTypeName));
	        }
	    }
	    onValidation(schema) {
	        var _a;
	        const errors = super.onValidation(schema, [exports.tagDirectiveName]);
	        for (const k of definitions_1.allSchemaRootKinds) {
	            const type = (_a = schema.schemaDefinition.root(k)) === null || _a === void 0 ? void 0 : _a.type;
	            const defaultName = (0, definitions_1.defaultRootName)(k);
	            if (type && type.name !== defaultName) {
	                const existing = schema.type(defaultName);
	                if (existing) {
	                    errors.push((0, error_1.error)(`ROOT_${k.toUpperCase()}_USED`, `The schema has a type named "${defaultName}" but it is not set as the ${k} root type ("${type.name}" is instead): `
	                        + 'this is not supported by federation. '
	                        + 'If a root type does not use its default name, there should be no other type with that default name.', (0, definitions_1.sourceASTs)(type, existing)));
	                }
	                type.rename(defaultName);
	            }
	        }
	        const externalTester = new ExternalTester(schema);
	        const externalFieldsInFedDirectivesCoordinates = [];
	        const keyDirective = this.keyDirective(schema);
	        validateAllFieldSet(keyDirective, type => type, type => `type "${type}"`, errors, externalTester, externalFieldsInFedDirectivesCoordinates, true, true);
	        validateAllFieldSet(this.requiresDirective(schema), field => field.parent, field => `field "${field.coordinate}"`, errors, externalTester, externalFieldsInFedDirectivesCoordinates, false, false);
	        validateAllFieldSet(this.providesDirective(schema), field => {
	            const type = (0, definitions_1.baseType)(field.type);
	            if (!(0, definitions_1.isObjectType)(type)) {
	                throw new graphql_1.GraphQLError(`Invalid @provides directive on field "${field.coordinate}": field has type "${field.type}" which is not an Object Type`, field.sourceAST);
	            }
	            return type;
	        }, field => `field ${field.coordinate}`, errors, externalTester, externalFieldsInFedDirectivesCoordinates, false, false);
	        validateAllExternalFieldsUsed(schema, externalTester, externalFieldsInFedDirectivesCoordinates, errors);
	        const tagDirective = this.tagDirective(schema);
	        if (!tagDirective.isBuiltIn) {
	            const error = tagSpec.checkCompatibleDirective(tagDirective);
	            if (error) {
	                errors.push(error);
	            }
	        }
	        return errors;
	    }
	    validationRules() {
	        return FEDERATION_VALIDATION_RULES;
	    }
	    keyDirective(schema) {
	        return this.getTypedDirective(schema, exports.keyDirectiveName);
	    }
	    extendsDirective(schema) {
	        return this.getTypedDirective(schema, exports.extendsDirectiveName);
	    }
	    externalDirective(schema) {
	        return this.getTypedDirective(schema, exports.externalDirectiveName);
	    }
	    requiresDirective(schema) {
	        return this.getTypedDirective(schema, exports.requiresDirectiveName);
	    }
	    providesDirective(schema) {
	        return this.getTypedDirective(schema, exports.providesDirectiveName);
	    }
	    tagDirective(schema) {
	        return this.getTypedDirective(schema, exports.tagDirectiveName);
	    }
	    maybeUpdateSubgraphDocument(schema, document) {
	        document = super.maybeUpdateSubgraphDocument(schema, document);
	        let definitions = document.definitions.concat();
	        for (const directiveName of FEDERATION_DIRECTIVES) {
	            const directive = schema.directive(directiveName);
	            (0, utils_1.assert)(directive, 'This method should only have been called on a schema with federation built-ins');
	            if (directive.isBuiltIn) {
	                definitions.push((0, graphql_1.parse)((0, print_1.printDirectiveDefinition)(directive, print_1.defaultPrintOptions)).definitions[0]);
	            }
	        }
	        return {
	            kind: 'Document',
	            loc: document.loc,
	            definitions
	        };
	    }
	}
	exports.FederationBuiltIns = FederationBuiltIns;
	exports.federationBuiltIns = new FederationBuiltIns();
	function isFederationSubgraphSchema(schema) {
	    return schema.builtIns instanceof FederationBuiltIns;
	}
	exports.isFederationSubgraphSchema = isFederationSubgraphSchema;
	function isFederationType(type) {
	    return isFederationTypeName(type.name);
	}
	exports.isFederationType = isFederationType;
	function isFederationTypeName(typeName) {
	    return FEDERATION_TYPES.includes(typeName);
	}
	exports.isFederationTypeName = isFederationTypeName;
	function isFederationField(field) {
	    var _a;
	    if (field.parent === ((_a = field.schema().schemaDefinition.root("query")) === null || _a === void 0 ? void 0 : _a.type)) {
	        return FEDERATION_ROOT_FIELDS.includes(field.name);
	    }
	    return false;
	}
	exports.isFederationField = isFederationField;
	function isFederationDirective(directive) {
	    return FEDERATION_DIRECTIVES.includes(directive.name);
	}
	exports.isFederationDirective = isFederationDirective;
	function isEntityType(type) {
	    return type.kind == "ObjectType" && type.hasAppliedDirective(exports.keyDirectiveName);
	}
	exports.isEntityType = isEntityType;
	function buildSubgraph(name, source) {
	    try {
	        return typeof source === 'string'
	            ? (0, buildSchema_1.buildSchema)(new graphql_1.Source(source, name), exports.federationBuiltIns)
	            : (0, buildSchema_1.buildSchemaFromAST)(source, exports.federationBuiltIns);
	    }
	    catch (e) {
	        if (e instanceof graphql_1.GraphQLError) {
	            throw addSubgraphToError(e, name);
	        }
	        else {
	            throw e;
	        }
	    }
	}
	function parseFieldSetArgument(parentType, directive, fieldAccessor = (type, name) => type.field(name)) {
	    return (0, operations_1.parseSelectionSet)(parentType, validateFieldSetValue(directive), new definitions_1.VariableDefinitions(), undefined, fieldAccessor);
	}
	exports.parseFieldSetArgument = parseFieldSetArgument;
	function validateFieldSetValue(directive) {
	    const fields = directive.arguments().fields;
	    if (typeof fields !== 'string') {
	        throw new graphql_1.GraphQLError(`Invalid value for argument ${directive.definition.argument('fields').coordinate} on ${directive.parent.coordinate}: must be a string.`, directive.sourceAST);
	    }
	    return fields;
	}
	function subgraphsFromServiceList(serviceList) {
	    var _a;
	    let errors = [];
	    const subgraphs = new Subgraphs();
	    for (const service of serviceList) {
	        try {
	            subgraphs.add(service.name, (_a = service.url) !== null && _a !== void 0 ? _a : '', service.typeDefs);
	        }
	        catch (e) {
	            const causes = (0, definitions_1.errorCauses)(e);
	            if (causes) {
	                errors = errors.concat(causes);
	            }
	            else {
	                throw e;
	            }
	        }
	    }
	    return errors.length === 0 ? subgraphs : errors;
	}
	exports.subgraphsFromServiceList = subgraphsFromServiceList;
	class Subgraphs {
	    constructor() {
	        this.subgraphs = [];
	    }
	    idx(name) {
	        return this.subgraphs.findIndex(s => s.name === name);
	    }
	    add(subgraphOrName, url, schema) {
	        const toAdd = typeof subgraphOrName === 'string'
	            ? new Subgraph(subgraphOrName, url, schema instanceof definitions_1.Schema ? schema : buildSubgraph(subgraphOrName, schema))
	            : subgraphOrName;
	        if (toAdd.name === exports.FEDERATION_RESERVED_SUBGRAPH_NAME) {
	            throw new graphql_1.GraphQLError(`Invalid name ${exports.FEDERATION_RESERVED_SUBGRAPH_NAME} for a subgraph: this name is reserved`);
	        }
	        const idx = this.idx(toAdd.name);
	        if (idx >= 0) {
	            throw new Error(`A subgraph named ${toAdd.name} already exists` + (toAdd.url ? ` (with url '${toAdd.url}')` : ''));
	        }
	        this.subgraphs.push(toAdd);
	        this.subgraphs.sort();
	        return toAdd;
	    }
	    get(name) {
	        const idx = this.idx(name);
	        return idx >= 0 ? this.subgraphs[idx] : undefined;
	    }
	    getByIdx(idx) {
	        return this.subgraphs[idx];
	    }
	    size() {
	        return this.subgraphs.length;
	    }
	    names() {
	        return this.subgraphs.map(s => s.name);
	    }
	    values() {
	        return this.subgraphs;
	    }
	    [Symbol.iterator]() {
	        return this.subgraphs.values();
	    }
	    toString() {
	        return '[' + this.subgraphs.map(s => s.name).join(', ') + ']';
	    }
	}
	exports.Subgraphs = Subgraphs;
	class Subgraph {
	    constructor(name, url, schema, validateSchema = true) {
	        this.name = name;
	        this.url = url;
	        this.schema = schema;
	        if (validateSchema) {
	            schema.validate();
	        }
	    }
	    toString() {
	        return `${this.name} (${this.url})`;
	    }
	}
	exports.Subgraph = Subgraph;
	function addSubgraphToASTNode(node, subgraph) {
	    return {
	        ...node,
	        subgraph
	    };
	}
	exports.addSubgraphToASTNode = addSubgraphToASTNode;
	function addSubgraphToError(e, subgraphName) {
	    const updatedCauses = (0, definitions_1.errorCauses)(e).map(cause => new graphql_1.GraphQLError(`[${subgraphName}] ${cause.message}`, cause.nodes ? cause.nodes.map(node => addSubgraphToASTNode(node, subgraphName)) : undefined, cause.source, cause.positions, cause.path, cause.originalError, cause.extensions));
	    return (0, definitions_1.ErrGraphQLValidationFailed)(updatedCauses);
	}
	exports.addSubgraphToError = addSubgraphToError;
	class ExternalTester {
	    constructor(schema) {
	        this.schema = schema;
	        this.fakeExternalFields = new Set();
	        this.collectFakeExternals();
	    }
	    collectFakeExternals() {
	        const keyDirective = exports.federationBuiltIns.keyDirective(this.schema);
	        if (!keyDirective) {
	            return;
	        }
	        for (const key of keyDirective.applications()) {
	            const parent = key.parent;
	            if (!(key.ofExtension() || parent.hasAppliedDirective(exports.extendsDirectiveName))) {
	                continue;
	            }
	            try {
	                parseFieldSetArgument(parent, key, (parentType, fieldName) => {
	                    const field = parentType.field(fieldName);
	                    if (field && field.hasAppliedDirective(exports.externalDirectiveName)) {
	                        this.fakeExternalFields.add(field.coordinate);
	                    }
	                    return field;
	                });
	            }
	            catch (e) {
	            }
	        }
	    }
	    isExternal(field) {
	        return field.hasAppliedDirective(exports.externalDirectiveName) && !this.isFakeExternal(field);
	    }
	    isFakeExternal(field) {
	        return this.fakeExternalFields.has(field.coordinate);
	    }
	}
	exports.ExternalTester = ExternalTester;

	}(federation));

	var debug$1 = {};

	var ansiStyles$1 = {exports: {}};

	var colorName = {
		"aliceblue": [240, 248, 255],
		"antiquewhite": [250, 235, 215],
		"aqua": [0, 255, 255],
		"aquamarine": [127, 255, 212],
		"azure": [240, 255, 255],
		"beige": [245, 245, 220],
		"bisque": [255, 228, 196],
		"black": [0, 0, 0],
		"blanchedalmond": [255, 235, 205],
		"blue": [0, 0, 255],
		"blueviolet": [138, 43, 226],
		"brown": [165, 42, 42],
		"burlywood": [222, 184, 135],
		"cadetblue": [95, 158, 160],
		"chartreuse": [127, 255, 0],
		"chocolate": [210, 105, 30],
		"coral": [255, 127, 80],
		"cornflowerblue": [100, 149, 237],
		"cornsilk": [255, 248, 220],
		"crimson": [220, 20, 60],
		"cyan": [0, 255, 255],
		"darkblue": [0, 0, 139],
		"darkcyan": [0, 139, 139],
		"darkgoldenrod": [184, 134, 11],
		"darkgray": [169, 169, 169],
		"darkgreen": [0, 100, 0],
		"darkgrey": [169, 169, 169],
		"darkkhaki": [189, 183, 107],
		"darkmagenta": [139, 0, 139],
		"darkolivegreen": [85, 107, 47],
		"darkorange": [255, 140, 0],
		"darkorchid": [153, 50, 204],
		"darkred": [139, 0, 0],
		"darksalmon": [233, 150, 122],
		"darkseagreen": [143, 188, 143],
		"darkslateblue": [72, 61, 139],
		"darkslategray": [47, 79, 79],
		"darkslategrey": [47, 79, 79],
		"darkturquoise": [0, 206, 209],
		"darkviolet": [148, 0, 211],
		"deeppink": [255, 20, 147],
		"deepskyblue": [0, 191, 255],
		"dimgray": [105, 105, 105],
		"dimgrey": [105, 105, 105],
		"dodgerblue": [30, 144, 255],
		"firebrick": [178, 34, 34],
		"floralwhite": [255, 250, 240],
		"forestgreen": [34, 139, 34],
		"fuchsia": [255, 0, 255],
		"gainsboro": [220, 220, 220],
		"ghostwhite": [248, 248, 255],
		"gold": [255, 215, 0],
		"goldenrod": [218, 165, 32],
		"gray": [128, 128, 128],
		"green": [0, 128, 0],
		"greenyellow": [173, 255, 47],
		"grey": [128, 128, 128],
		"honeydew": [240, 255, 240],
		"hotpink": [255, 105, 180],
		"indianred": [205, 92, 92],
		"indigo": [75, 0, 130],
		"ivory": [255, 255, 240],
		"khaki": [240, 230, 140],
		"lavender": [230, 230, 250],
		"lavenderblush": [255, 240, 245],
		"lawngreen": [124, 252, 0],
		"lemonchiffon": [255, 250, 205],
		"lightblue": [173, 216, 230],
		"lightcoral": [240, 128, 128],
		"lightcyan": [224, 255, 255],
		"lightgoldenrodyellow": [250, 250, 210],
		"lightgray": [211, 211, 211],
		"lightgreen": [144, 238, 144],
		"lightgrey": [211, 211, 211],
		"lightpink": [255, 182, 193],
		"lightsalmon": [255, 160, 122],
		"lightseagreen": [32, 178, 170],
		"lightskyblue": [135, 206, 250],
		"lightslategray": [119, 136, 153],
		"lightslategrey": [119, 136, 153],
		"lightsteelblue": [176, 196, 222],
		"lightyellow": [255, 255, 224],
		"lime": [0, 255, 0],
		"limegreen": [50, 205, 50],
		"linen": [250, 240, 230],
		"magenta": [255, 0, 255],
		"maroon": [128, 0, 0],
		"mediumaquamarine": [102, 205, 170],
		"mediumblue": [0, 0, 205],
		"mediumorchid": [186, 85, 211],
		"mediumpurple": [147, 112, 219],
		"mediumseagreen": [60, 179, 113],
		"mediumslateblue": [123, 104, 238],
		"mediumspringgreen": [0, 250, 154],
		"mediumturquoise": [72, 209, 204],
		"mediumvioletred": [199, 21, 133],
		"midnightblue": [25, 25, 112],
		"mintcream": [245, 255, 250],
		"mistyrose": [255, 228, 225],
		"moccasin": [255, 228, 181],
		"navajowhite": [255, 222, 173],
		"navy": [0, 0, 128],
		"oldlace": [253, 245, 230],
		"olive": [128, 128, 0],
		"olivedrab": [107, 142, 35],
		"orange": [255, 165, 0],
		"orangered": [255, 69, 0],
		"orchid": [218, 112, 214],
		"palegoldenrod": [238, 232, 170],
		"palegreen": [152, 251, 152],
		"paleturquoise": [175, 238, 238],
		"palevioletred": [219, 112, 147],
		"papayawhip": [255, 239, 213],
		"peachpuff": [255, 218, 185],
		"peru": [205, 133, 63],
		"pink": [255, 192, 203],
		"plum": [221, 160, 221],
		"powderblue": [176, 224, 230],
		"purple": [128, 0, 128],
		"rebeccapurple": [102, 51, 153],
		"red": [255, 0, 0],
		"rosybrown": [188, 143, 143],
		"royalblue": [65, 105, 225],
		"saddlebrown": [139, 69, 19],
		"salmon": [250, 128, 114],
		"sandybrown": [244, 164, 96],
		"seagreen": [46, 139, 87],
		"seashell": [255, 245, 238],
		"sienna": [160, 82, 45],
		"silver": [192, 192, 192],
		"skyblue": [135, 206, 235],
		"slateblue": [106, 90, 205],
		"slategray": [112, 128, 144],
		"slategrey": [112, 128, 144],
		"snow": [255, 250, 250],
		"springgreen": [0, 255, 127],
		"steelblue": [70, 130, 180],
		"tan": [210, 180, 140],
		"teal": [0, 128, 128],
		"thistle": [216, 191, 216],
		"tomato": [255, 99, 71],
		"turquoise": [64, 224, 208],
		"violet": [238, 130, 238],
		"wheat": [245, 222, 179],
		"white": [255, 255, 255],
		"whitesmoke": [245, 245, 245],
		"yellow": [255, 255, 0],
		"yellowgreen": [154, 205, 50]
	};

	/* MIT license */

	/* eslint-disable no-mixed-operators */
	const cssKeywords = colorName;

	// NOTE: conversions should only return primitive values (i.e. arrays, or
	//       values that give correct `typeof` results).
	//       do not use box values types (i.e. Number(), String(), etc.)

	const reverseKeywords = {};
	for (const key of Object.keys(cssKeywords)) {
		reverseKeywords[cssKeywords[key]] = key;
	}

	const convert$1 = {
		rgb: {channels: 3, labels: 'rgb'},
		hsl: {channels: 3, labels: 'hsl'},
		hsv: {channels: 3, labels: 'hsv'},
		hwb: {channels: 3, labels: 'hwb'},
		cmyk: {channels: 4, labels: 'cmyk'},
		xyz: {channels: 3, labels: 'xyz'},
		lab: {channels: 3, labels: 'lab'},
		lch: {channels: 3, labels: 'lch'},
		hex: {channels: 1, labels: ['hex']},
		keyword: {channels: 1, labels: ['keyword']},
		ansi16: {channels: 1, labels: ['ansi16']},
		ansi256: {channels: 1, labels: ['ansi256']},
		hcg: {channels: 3, labels: ['h', 'c', 'g']},
		apple: {channels: 3, labels: ['r16', 'g16', 'b16']},
		gray: {channels: 1, labels: ['gray']}
	};

	var conversions$2 = convert$1;

	// Hide .channels and .labels properties
	for (const model of Object.keys(convert$1)) {
		if (!('channels' in convert$1[model])) {
			throw new Error('missing channels property: ' + model);
		}

		if (!('labels' in convert$1[model])) {
			throw new Error('missing channel labels property: ' + model);
		}

		if (convert$1[model].labels.length !== convert$1[model].channels) {
			throw new Error('channel and label counts mismatch: ' + model);
		}

		const {channels, labels} = convert$1[model];
		delete convert$1[model].channels;
		delete convert$1[model].labels;
		Object.defineProperty(convert$1[model], 'channels', {value: channels});
		Object.defineProperty(convert$1[model], 'labels', {value: labels});
	}

	convert$1.rgb.hsl = function (rgb) {
		const r = rgb[0] / 255;
		const g = rgb[1] / 255;
		const b = rgb[2] / 255;
		const min = Math.min(r, g, b);
		const max = Math.max(r, g, b);
		const delta = max - min;
		let h;
		let s;

		if (max === min) {
			h = 0;
		} else if (r === max) {
			h = (g - b) / delta;
		} else if (g === max) {
			h = 2 + (b - r) / delta;
		} else if (b === max) {
			h = 4 + (r - g) / delta;
		}

		h = Math.min(h * 60, 360);

		if (h < 0) {
			h += 360;
		}

		const l = (min + max) / 2;

		if (max === min) {
			s = 0;
		} else if (l <= 0.5) {
			s = delta / (max + min);
		} else {
			s = delta / (2 - max - min);
		}

		return [h, s * 100, l * 100];
	};

	convert$1.rgb.hsv = function (rgb) {
		let rdif;
		let gdif;
		let bdif;
		let h;
		let s;

		const r = rgb[0] / 255;
		const g = rgb[1] / 255;
		const b = rgb[2] / 255;
		const v = Math.max(r, g, b);
		const diff = v - Math.min(r, g, b);
		const diffc = function (c) {
			return (v - c) / 6 / diff + 1 / 2;
		};

		if (diff === 0) {
			h = 0;
			s = 0;
		} else {
			s = diff / v;
			rdif = diffc(r);
			gdif = diffc(g);
			bdif = diffc(b);

			if (r === v) {
				h = bdif - gdif;
			} else if (g === v) {
				h = (1 / 3) + rdif - bdif;
			} else if (b === v) {
				h = (2 / 3) + gdif - rdif;
			}

			if (h < 0) {
				h += 1;
			} else if (h > 1) {
				h -= 1;
			}
		}

		return [
			h * 360,
			s * 100,
			v * 100
		];
	};

	convert$1.rgb.hwb = function (rgb) {
		const r = rgb[0];
		const g = rgb[1];
		let b = rgb[2];
		const h = convert$1.rgb.hsl(rgb)[0];
		const w = 1 / 255 * Math.min(r, Math.min(g, b));

		b = 1 - 1 / 255 * Math.max(r, Math.max(g, b));

		return [h, w * 100, b * 100];
	};

	convert$1.rgb.cmyk = function (rgb) {
		const r = rgb[0] / 255;
		const g = rgb[1] / 255;
		const b = rgb[2] / 255;

		const k = Math.min(1 - r, 1 - g, 1 - b);
		const c = (1 - r - k) / (1 - k) || 0;
		const m = (1 - g - k) / (1 - k) || 0;
		const y = (1 - b - k) / (1 - k) || 0;

		return [c * 100, m * 100, y * 100, k * 100];
	};

	function comparativeDistance(x, y) {
		/*
			See https://en.m.wikipedia.org/wiki/Euclidean_distance#Squared_Euclidean_distance
		*/
		return (
			((x[0] - y[0]) ** 2) +
			((x[1] - y[1]) ** 2) +
			((x[2] - y[2]) ** 2)
		);
	}

	convert$1.rgb.keyword = function (rgb) {
		const reversed = reverseKeywords[rgb];
		if (reversed) {
			return reversed;
		}

		let currentClosestDistance = Infinity;
		let currentClosestKeyword;

		for (const keyword of Object.keys(cssKeywords)) {
			const value = cssKeywords[keyword];

			// Compute comparative distance
			const distance = comparativeDistance(rgb, value);

			// Check if its less, if so set as closest
			if (distance < currentClosestDistance) {
				currentClosestDistance = distance;
				currentClosestKeyword = keyword;
			}
		}

		return currentClosestKeyword;
	};

	convert$1.keyword.rgb = function (keyword) {
		return cssKeywords[keyword];
	};

	convert$1.rgb.xyz = function (rgb) {
		let r = rgb[0] / 255;
		let g = rgb[1] / 255;
		let b = rgb[2] / 255;

		// Assume sRGB
		r = r > 0.04045 ? (((r + 0.055) / 1.055) ** 2.4) : (r / 12.92);
		g = g > 0.04045 ? (((g + 0.055) / 1.055) ** 2.4) : (g / 12.92);
		b = b > 0.04045 ? (((b + 0.055) / 1.055) ** 2.4) : (b / 12.92);

		const x = (r * 0.4124) + (g * 0.3576) + (b * 0.1805);
		const y = (r * 0.2126) + (g * 0.7152) + (b * 0.0722);
		const z = (r * 0.0193) + (g * 0.1192) + (b * 0.9505);

		return [x * 100, y * 100, z * 100];
	};

	convert$1.rgb.lab = function (rgb) {
		const xyz = convert$1.rgb.xyz(rgb);
		let x = xyz[0];
		let y = xyz[1];
		let z = xyz[2];

		x /= 95.047;
		y /= 100;
		z /= 108.883;

		x = x > 0.008856 ? (x ** (1 / 3)) : (7.787 * x) + (16 / 116);
		y = y > 0.008856 ? (y ** (1 / 3)) : (7.787 * y) + (16 / 116);
		z = z > 0.008856 ? (z ** (1 / 3)) : (7.787 * z) + (16 / 116);

		const l = (116 * y) - 16;
		const a = 500 * (x - y);
		const b = 200 * (y - z);

		return [l, a, b];
	};

	convert$1.hsl.rgb = function (hsl) {
		const h = hsl[0] / 360;
		const s = hsl[1] / 100;
		const l = hsl[2] / 100;
		let t2;
		let t3;
		let val;

		if (s === 0) {
			val = l * 255;
			return [val, val, val];
		}

		if (l < 0.5) {
			t2 = l * (1 + s);
		} else {
			t2 = l + s - l * s;
		}

		const t1 = 2 * l - t2;

		const rgb = [0, 0, 0];
		for (let i = 0; i < 3; i++) {
			t3 = h + 1 / 3 * -(i - 1);
			if (t3 < 0) {
				t3++;
			}

			if (t3 > 1) {
				t3--;
			}

			if (6 * t3 < 1) {
				val = t1 + (t2 - t1) * 6 * t3;
			} else if (2 * t3 < 1) {
				val = t2;
			} else if (3 * t3 < 2) {
				val = t1 + (t2 - t1) * (2 / 3 - t3) * 6;
			} else {
				val = t1;
			}

			rgb[i] = val * 255;
		}

		return rgb;
	};

	convert$1.hsl.hsv = function (hsl) {
		const h = hsl[0];
		let s = hsl[1] / 100;
		let l = hsl[2] / 100;
		let smin = s;
		const lmin = Math.max(l, 0.01);

		l *= 2;
		s *= (l <= 1) ? l : 2 - l;
		smin *= lmin <= 1 ? lmin : 2 - lmin;
		const v = (l + s) / 2;
		const sv = l === 0 ? (2 * smin) / (lmin + smin) : (2 * s) / (l + s);

		return [h, sv * 100, v * 100];
	};

	convert$1.hsv.rgb = function (hsv) {
		const h = hsv[0] / 60;
		const s = hsv[1] / 100;
		let v = hsv[2] / 100;
		const hi = Math.floor(h) % 6;

		const f = h - Math.floor(h);
		const p = 255 * v * (1 - s);
		const q = 255 * v * (1 - (s * f));
		const t = 255 * v * (1 - (s * (1 - f)));
		v *= 255;

		switch (hi) {
			case 0:
				return [v, t, p];
			case 1:
				return [q, v, p];
			case 2:
				return [p, v, t];
			case 3:
				return [p, q, v];
			case 4:
				return [t, p, v];
			case 5:
				return [v, p, q];
		}
	};

	convert$1.hsv.hsl = function (hsv) {
		const h = hsv[0];
		const s = hsv[1] / 100;
		const v = hsv[2] / 100;
		const vmin = Math.max(v, 0.01);
		let sl;
		let l;

		l = (2 - s) * v;
		const lmin = (2 - s) * vmin;
		sl = s * vmin;
		sl /= (lmin <= 1) ? lmin : 2 - lmin;
		sl = sl || 0;
		l /= 2;

		return [h, sl * 100, l * 100];
	};

	// http://dev.w3.org/csswg/css-color/#hwb-to-rgb
	convert$1.hwb.rgb = function (hwb) {
		const h = hwb[0] / 360;
		let wh = hwb[1] / 100;
		let bl = hwb[2] / 100;
		const ratio = wh + bl;
		let f;

		// Wh + bl cant be > 1
		if (ratio > 1) {
			wh /= ratio;
			bl /= ratio;
		}

		const i = Math.floor(6 * h);
		const v = 1 - bl;
		f = 6 * h - i;

		if ((i & 0x01) !== 0) {
			f = 1 - f;
		}

		const n = wh + f * (v - wh); // Linear interpolation

		let r;
		let g;
		let b;
		/* eslint-disable max-statements-per-line,no-multi-spaces */
		switch (i) {
			default:
			case 6:
			case 0: r = v;  g = n;  b = wh; break;
			case 1: r = n;  g = v;  b = wh; break;
			case 2: r = wh; g = v;  b = n; break;
			case 3: r = wh; g = n;  b = v; break;
			case 4: r = n;  g = wh; b = v; break;
			case 5: r = v;  g = wh; b = n; break;
		}
		/* eslint-enable max-statements-per-line,no-multi-spaces */

		return [r * 255, g * 255, b * 255];
	};

	convert$1.cmyk.rgb = function (cmyk) {
		const c = cmyk[0] / 100;
		const m = cmyk[1] / 100;
		const y = cmyk[2] / 100;
		const k = cmyk[3] / 100;

		const r = 1 - Math.min(1, c * (1 - k) + k);
		const g = 1 - Math.min(1, m * (1 - k) + k);
		const b = 1 - Math.min(1, y * (1 - k) + k);

		return [r * 255, g * 255, b * 255];
	};

	convert$1.xyz.rgb = function (xyz) {
		const x = xyz[0] / 100;
		const y = xyz[1] / 100;
		const z = xyz[2] / 100;
		let r;
		let g;
		let b;

		r = (x * 3.2406) + (y * -1.5372) + (z * -0.4986);
		g = (x * -0.9689) + (y * 1.8758) + (z * 0.0415);
		b = (x * 0.0557) + (y * -0.2040) + (z * 1.0570);

		// Assume sRGB
		r = r > 0.0031308
			? ((1.055 * (r ** (1.0 / 2.4))) - 0.055)
			: r * 12.92;

		g = g > 0.0031308
			? ((1.055 * (g ** (1.0 / 2.4))) - 0.055)
			: g * 12.92;

		b = b > 0.0031308
			? ((1.055 * (b ** (1.0 / 2.4))) - 0.055)
			: b * 12.92;

		r = Math.min(Math.max(0, r), 1);
		g = Math.min(Math.max(0, g), 1);
		b = Math.min(Math.max(0, b), 1);

		return [r * 255, g * 255, b * 255];
	};

	convert$1.xyz.lab = function (xyz) {
		let x = xyz[0];
		let y = xyz[1];
		let z = xyz[2];

		x /= 95.047;
		y /= 100;
		z /= 108.883;

		x = x > 0.008856 ? (x ** (1 / 3)) : (7.787 * x) + (16 / 116);
		y = y > 0.008856 ? (y ** (1 / 3)) : (7.787 * y) + (16 / 116);
		z = z > 0.008856 ? (z ** (1 / 3)) : (7.787 * z) + (16 / 116);

		const l = (116 * y) - 16;
		const a = 500 * (x - y);
		const b = 200 * (y - z);

		return [l, a, b];
	};

	convert$1.lab.xyz = function (lab) {
		const l = lab[0];
		const a = lab[1];
		const b = lab[2];
		let x;
		let y;
		let z;

		y = (l + 16) / 116;
		x = a / 500 + y;
		z = y - b / 200;

		const y2 = y ** 3;
		const x2 = x ** 3;
		const z2 = z ** 3;
		y = y2 > 0.008856 ? y2 : (y - 16 / 116) / 7.787;
		x = x2 > 0.008856 ? x2 : (x - 16 / 116) / 7.787;
		z = z2 > 0.008856 ? z2 : (z - 16 / 116) / 7.787;

		x *= 95.047;
		y *= 100;
		z *= 108.883;

		return [x, y, z];
	};

	convert$1.lab.lch = function (lab) {
		const l = lab[0];
		const a = lab[1];
		const b = lab[2];
		let h;

		const hr = Math.atan2(b, a);
		h = hr * 360 / 2 / Math.PI;

		if (h < 0) {
			h += 360;
		}

		const c = Math.sqrt(a * a + b * b);

		return [l, c, h];
	};

	convert$1.lch.lab = function (lch) {
		const l = lch[0];
		const c = lch[1];
		const h = lch[2];

		const hr = h / 360 * 2 * Math.PI;
		const a = c * Math.cos(hr);
		const b = c * Math.sin(hr);

		return [l, a, b];
	};

	convert$1.rgb.ansi16 = function (args, saturation = null) {
		const [r, g, b] = args;
		let value = saturation === null ? convert$1.rgb.hsv(args)[2] : saturation; // Hsv -> ansi16 optimization

		value = Math.round(value / 50);

		if (value === 0) {
			return 30;
		}

		let ansi = 30
			+ ((Math.round(b / 255) << 2)
			| (Math.round(g / 255) << 1)
			| Math.round(r / 255));

		if (value === 2) {
			ansi += 60;
		}

		return ansi;
	};

	convert$1.hsv.ansi16 = function (args) {
		// Optimization here; we already know the value and don't need to get
		// it converted for us.
		return convert$1.rgb.ansi16(convert$1.hsv.rgb(args), args[2]);
	};

	convert$1.rgb.ansi256 = function (args) {
		const r = args[0];
		const g = args[1];
		const b = args[2];

		// We use the extended greyscale palette here, with the exception of
		// black and white. normal palette only has 4 greyscale shades.
		if (r === g && g === b) {
			if (r < 8) {
				return 16;
			}

			if (r > 248) {
				return 231;
			}

			return Math.round(((r - 8) / 247) * 24) + 232;
		}

		const ansi = 16
			+ (36 * Math.round(r / 255 * 5))
			+ (6 * Math.round(g / 255 * 5))
			+ Math.round(b / 255 * 5);

		return ansi;
	};

	convert$1.ansi16.rgb = function (args) {
		let color = args % 10;

		// Handle greyscale
		if (color === 0 || color === 7) {
			if (args > 50) {
				color += 3.5;
			}

			color = color / 10.5 * 255;

			return [color, color, color];
		}

		const mult = (~~(args > 50) + 1) * 0.5;
		const r = ((color & 1) * mult) * 255;
		const g = (((color >> 1) & 1) * mult) * 255;
		const b = (((color >> 2) & 1) * mult) * 255;

		return [r, g, b];
	};

	convert$1.ansi256.rgb = function (args) {
		// Handle greyscale
		if (args >= 232) {
			const c = (args - 232) * 10 + 8;
			return [c, c, c];
		}

		args -= 16;

		let rem;
		const r = Math.floor(args / 36) / 5 * 255;
		const g = Math.floor((rem = args % 36) / 6) / 5 * 255;
		const b = (rem % 6) / 5 * 255;

		return [r, g, b];
	};

	convert$1.rgb.hex = function (args) {
		const integer = ((Math.round(args[0]) & 0xFF) << 16)
			+ ((Math.round(args[1]) & 0xFF) << 8)
			+ (Math.round(args[2]) & 0xFF);

		const string = integer.toString(16).toUpperCase();
		return '000000'.substring(string.length) + string;
	};

	convert$1.hex.rgb = function (args) {
		const match = args.toString(16).match(/[a-f0-9]{6}|[a-f0-9]{3}/i);
		if (!match) {
			return [0, 0, 0];
		}

		let colorString = match[0];

		if (match[0].length === 3) {
			colorString = colorString.split('').map(char => {
				return char + char;
			}).join('');
		}

		const integer = parseInt(colorString, 16);
		const r = (integer >> 16) & 0xFF;
		const g = (integer >> 8) & 0xFF;
		const b = integer & 0xFF;

		return [r, g, b];
	};

	convert$1.rgb.hcg = function (rgb) {
		const r = rgb[0] / 255;
		const g = rgb[1] / 255;
		const b = rgb[2] / 255;
		const max = Math.max(Math.max(r, g), b);
		const min = Math.min(Math.min(r, g), b);
		const chroma = (max - min);
		let grayscale;
		let hue;

		if (chroma < 1) {
			grayscale = min / (1 - chroma);
		} else {
			grayscale = 0;
		}

		if (chroma <= 0) {
			hue = 0;
		} else
		if (max === r) {
			hue = ((g - b) / chroma) % 6;
		} else
		if (max === g) {
			hue = 2 + (b - r) / chroma;
		} else {
			hue = 4 + (r - g) / chroma;
		}

		hue /= 6;
		hue %= 1;

		return [hue * 360, chroma * 100, grayscale * 100];
	};

	convert$1.hsl.hcg = function (hsl) {
		const s = hsl[1] / 100;
		const l = hsl[2] / 100;

		const c = l < 0.5 ? (2.0 * s * l) : (2.0 * s * (1.0 - l));

		let f = 0;
		if (c < 1.0) {
			f = (l - 0.5 * c) / (1.0 - c);
		}

		return [hsl[0], c * 100, f * 100];
	};

	convert$1.hsv.hcg = function (hsv) {
		const s = hsv[1] / 100;
		const v = hsv[2] / 100;

		const c = s * v;
		let f = 0;

		if (c < 1.0) {
			f = (v - c) / (1 - c);
		}

		return [hsv[0], c * 100, f * 100];
	};

	convert$1.hcg.rgb = function (hcg) {
		const h = hcg[0] / 360;
		const c = hcg[1] / 100;
		const g = hcg[2] / 100;

		if (c === 0.0) {
			return [g * 255, g * 255, g * 255];
		}

		const pure = [0, 0, 0];
		const hi = (h % 1) * 6;
		const v = hi % 1;
		const w = 1 - v;
		let mg = 0;

		/* eslint-disable max-statements-per-line */
		switch (Math.floor(hi)) {
			case 0:
				pure[0] = 1; pure[1] = v; pure[2] = 0; break;
			case 1:
				pure[0] = w; pure[1] = 1; pure[2] = 0; break;
			case 2:
				pure[0] = 0; pure[1] = 1; pure[2] = v; break;
			case 3:
				pure[0] = 0; pure[1] = w; pure[2] = 1; break;
			case 4:
				pure[0] = v; pure[1] = 0; pure[2] = 1; break;
			default:
				pure[0] = 1; pure[1] = 0; pure[2] = w;
		}
		/* eslint-enable max-statements-per-line */

		mg = (1.0 - c) * g;

		return [
			(c * pure[0] + mg) * 255,
			(c * pure[1] + mg) * 255,
			(c * pure[2] + mg) * 255
		];
	};

	convert$1.hcg.hsv = function (hcg) {
		const c = hcg[1] / 100;
		const g = hcg[2] / 100;

		const v = c + g * (1.0 - c);
		let f = 0;

		if (v > 0.0) {
			f = c / v;
		}

		return [hcg[0], f * 100, v * 100];
	};

	convert$1.hcg.hsl = function (hcg) {
		const c = hcg[1] / 100;
		const g = hcg[2] / 100;

		const l = g * (1.0 - c) + 0.5 * c;
		let s = 0;

		if (l > 0.0 && l < 0.5) {
			s = c / (2 * l);
		} else
		if (l >= 0.5 && l < 1.0) {
			s = c / (2 * (1 - l));
		}

		return [hcg[0], s * 100, l * 100];
	};

	convert$1.hcg.hwb = function (hcg) {
		const c = hcg[1] / 100;
		const g = hcg[2] / 100;
		const v = c + g * (1.0 - c);
		return [hcg[0], (v - c) * 100, (1 - v) * 100];
	};

	convert$1.hwb.hcg = function (hwb) {
		const w = hwb[1] / 100;
		const b = hwb[2] / 100;
		const v = 1 - b;
		const c = v - w;
		let g = 0;

		if (c < 1) {
			g = (v - c) / (1 - c);
		}

		return [hwb[0], c * 100, g * 100];
	};

	convert$1.apple.rgb = function (apple) {
		return [(apple[0] / 65535) * 255, (apple[1] / 65535) * 255, (apple[2] / 65535) * 255];
	};

	convert$1.rgb.apple = function (rgb) {
		return [(rgb[0] / 255) * 65535, (rgb[1] / 255) * 65535, (rgb[2] / 255) * 65535];
	};

	convert$1.gray.rgb = function (args) {
		return [args[0] / 100 * 255, args[0] / 100 * 255, args[0] / 100 * 255];
	};

	convert$1.gray.hsl = function (args) {
		return [0, 0, args[0]];
	};

	convert$1.gray.hsv = convert$1.gray.hsl;

	convert$1.gray.hwb = function (gray) {
		return [0, 100, gray[0]];
	};

	convert$1.gray.cmyk = function (gray) {
		return [0, 0, 0, gray[0]];
	};

	convert$1.gray.lab = function (gray) {
		return [gray[0], 0, 0];
	};

	convert$1.gray.hex = function (gray) {
		const val = Math.round(gray[0] / 100 * 255) & 0xFF;
		const integer = (val << 16) + (val << 8) + val;

		const string = integer.toString(16).toUpperCase();
		return '000000'.substring(string.length) + string;
	};

	convert$1.rgb.gray = function (rgb) {
		const val = (rgb[0] + rgb[1] + rgb[2]) / 3;
		return [val / 255 * 100];
	};

	const conversions$1 = conversions$2;

	/*
		This function routes a model to all other models.

		all functions that are routed have a property `.conversion` attached
		to the returned synthetic function. This property is an array
		of strings, each with the steps in between the 'from' and 'to'
		color models (inclusive).

		conversions that are not possible simply are not included.
	*/

	function buildGraph() {
		const graph = {};
		// https://jsperf.com/object-keys-vs-for-in-with-closure/3
		const models = Object.keys(conversions$1);

		for (let len = models.length, i = 0; i < len; i++) {
			graph[models[i]] = {
				// http://jsperf.com/1-vs-infinity
				// micro-opt, but this is simple.
				distance: -1,
				parent: null
			};
		}

		return graph;
	}

	// https://en.wikipedia.org/wiki/Breadth-first_search
	function deriveBFS(fromModel) {
		const graph = buildGraph();
		const queue = [fromModel]; // Unshift -> queue -> pop

		graph[fromModel].distance = 0;

		while (queue.length) {
			const current = queue.pop();
			const adjacents = Object.keys(conversions$1[current]);

			for (let len = adjacents.length, i = 0; i < len; i++) {
				const adjacent = adjacents[i];
				const node = graph[adjacent];

				if (node.distance === -1) {
					node.distance = graph[current].distance + 1;
					node.parent = current;
					queue.unshift(adjacent);
				}
			}
		}

		return graph;
	}

	function link(from, to) {
		return function (args) {
			return to(from(args));
		};
	}

	function wrapConversion(toModel, graph) {
		const path = [graph[toModel].parent, toModel];
		let fn = conversions$1[graph[toModel].parent][toModel];

		let cur = graph[toModel].parent;
		while (graph[cur].parent) {
			path.unshift(graph[cur].parent);
			fn = link(conversions$1[graph[cur].parent][cur], fn);
			cur = graph[cur].parent;
		}

		fn.conversion = path;
		return fn;
	}

	var route$1 = function (fromModel) {
		const graph = deriveBFS(fromModel);
		const conversion = {};

		const models = Object.keys(graph);
		for (let len = models.length, i = 0; i < len; i++) {
			const toModel = models[i];
			const node = graph[toModel];

			if (node.parent === null) {
				// No possible conversion, or this node is the source model.
				continue;
			}

			conversion[toModel] = wrapConversion(toModel, graph);
		}

		return conversion;
	};

	const conversions = conversions$2;
	const route = route$1;

	const convert = {};

	const models = Object.keys(conversions);

	function wrapRaw(fn) {
		const wrappedFn = function (...args) {
			const arg0 = args[0];
			if (arg0 === undefined || arg0 === null) {
				return arg0;
			}

			if (arg0.length > 1) {
				args = arg0;
			}

			return fn(args);
		};

		// Preserve .conversion property if there is one
		if ('conversion' in fn) {
			wrappedFn.conversion = fn.conversion;
		}

		return wrappedFn;
	}

	function wrapRounded(fn) {
		const wrappedFn = function (...args) {
			const arg0 = args[0];

			if (arg0 === undefined || arg0 === null) {
				return arg0;
			}

			if (arg0.length > 1) {
				args = arg0;
			}

			const result = fn(args);

			// We're assuming the result is an array here.
			// see notice in conversions.js; don't use box types
			// in conversion functions.
			if (typeof result === 'object') {
				for (let len = result.length, i = 0; i < len; i++) {
					result[i] = Math.round(result[i]);
				}
			}

			return result;
		};

		// Preserve .conversion property if there is one
		if ('conversion' in fn) {
			wrappedFn.conversion = fn.conversion;
		}

		return wrappedFn;
	}

	models.forEach(fromModel => {
		convert[fromModel] = {};

		Object.defineProperty(convert[fromModel], 'channels', {value: conversions[fromModel].channels});
		Object.defineProperty(convert[fromModel], 'labels', {value: conversions[fromModel].labels});

		const routes = route(fromModel);
		const routeModels = Object.keys(routes);

		routeModels.forEach(toModel => {
			const fn = routes[toModel];

			convert[fromModel][toModel] = wrapRounded(fn);
			convert[fromModel][toModel].raw = wrapRaw(fn);
		});
	});

	var colorConvert = convert;

	(function (module) {

	const wrapAnsi16 = (fn, offset) => (...args) => {
		const code = fn(...args);
		return `\u001B[${code + offset}m`;
	};

	const wrapAnsi256 = (fn, offset) => (...args) => {
		const code = fn(...args);
		return `\u001B[${38 + offset};5;${code}m`;
	};

	const wrapAnsi16m = (fn, offset) => (...args) => {
		const rgb = fn(...args);
		return `\u001B[${38 + offset};2;${rgb[0]};${rgb[1]};${rgb[2]}m`;
	};

	const ansi2ansi = n => n;
	const rgb2rgb = (r, g, b) => [r, g, b];

	const setLazyProperty = (object, property, get) => {
		Object.defineProperty(object, property, {
			get: () => {
				const value = get();

				Object.defineProperty(object, property, {
					value,
					enumerable: true,
					configurable: true
				});

				return value;
			},
			enumerable: true,
			configurable: true
		});
	};

	/** @type {typeof import('color-convert')} */
	let colorConvert$1;
	const makeDynamicStyles = (wrap, targetSpace, identity, isBackground) => {
		if (colorConvert$1 === undefined) {
			colorConvert$1 = colorConvert;
		}

		const offset = isBackground ? 10 : 0;
		const styles = {};

		for (const [sourceSpace, suite] of Object.entries(colorConvert$1)) {
			const name = sourceSpace === 'ansi16' ? 'ansi' : sourceSpace;
			if (sourceSpace === targetSpace) {
				styles[name] = wrap(identity, offset);
			} else if (typeof suite === 'object') {
				styles[name] = wrap(suite[targetSpace], offset);
			}
		}

		return styles;
	};

	function assembleStyles() {
		const codes = new Map();
		const styles = {
			modifier: {
				reset: [0, 0],
				// 21 isn't widely supported and 22 does the same thing
				bold: [1, 22],
				dim: [2, 22],
				italic: [3, 23],
				underline: [4, 24],
				inverse: [7, 27],
				hidden: [8, 28],
				strikethrough: [9, 29]
			},
			color: {
				black: [30, 39],
				red: [31, 39],
				green: [32, 39],
				yellow: [33, 39],
				blue: [34, 39],
				magenta: [35, 39],
				cyan: [36, 39],
				white: [37, 39],

				// Bright color
				blackBright: [90, 39],
				redBright: [91, 39],
				greenBright: [92, 39],
				yellowBright: [93, 39],
				blueBright: [94, 39],
				magentaBright: [95, 39],
				cyanBright: [96, 39],
				whiteBright: [97, 39]
			},
			bgColor: {
				bgBlack: [40, 49],
				bgRed: [41, 49],
				bgGreen: [42, 49],
				bgYellow: [43, 49],
				bgBlue: [44, 49],
				bgMagenta: [45, 49],
				bgCyan: [46, 49],
				bgWhite: [47, 49],

				// Bright color
				bgBlackBright: [100, 49],
				bgRedBright: [101, 49],
				bgGreenBright: [102, 49],
				bgYellowBright: [103, 49],
				bgBlueBright: [104, 49],
				bgMagentaBright: [105, 49],
				bgCyanBright: [106, 49],
				bgWhiteBright: [107, 49]
			}
		};

		// Alias bright black as gray (and grey)
		styles.color.gray = styles.color.blackBright;
		styles.bgColor.bgGray = styles.bgColor.bgBlackBright;
		styles.color.grey = styles.color.blackBright;
		styles.bgColor.bgGrey = styles.bgColor.bgBlackBright;

		for (const [groupName, group] of Object.entries(styles)) {
			for (const [styleName, style] of Object.entries(group)) {
				styles[styleName] = {
					open: `\u001B[${style[0]}m`,
					close: `\u001B[${style[1]}m`
				};

				group[styleName] = styles[styleName];

				codes.set(style[0], style[1]);
			}

			Object.defineProperty(styles, groupName, {
				value: group,
				enumerable: false
			});
		}

		Object.defineProperty(styles, 'codes', {
			value: codes,
			enumerable: false
		});

		styles.color.close = '\u001B[39m';
		styles.bgColor.close = '\u001B[49m';

		setLazyProperty(styles.color, 'ansi', () => makeDynamicStyles(wrapAnsi16, 'ansi16', ansi2ansi, false));
		setLazyProperty(styles.color, 'ansi256', () => makeDynamicStyles(wrapAnsi256, 'ansi256', ansi2ansi, false));
		setLazyProperty(styles.color, 'ansi16m', () => makeDynamicStyles(wrapAnsi16m, 'rgb', rgb2rgb, false));
		setLazyProperty(styles.bgColor, 'ansi', () => makeDynamicStyles(wrapAnsi16, 'ansi16', ansi2ansi, true));
		setLazyProperty(styles.bgColor, 'ansi256', () => makeDynamicStyles(wrapAnsi256, 'ansi256', ansi2ansi, true));
		setLazyProperty(styles.bgColor, 'ansi16m', () => makeDynamicStyles(wrapAnsi16m, 'rgb', rgb2rgb, true));

		return styles;
	}

	// Make the export immutable
	Object.defineProperty(module, 'exports', {
		enumerable: true,
		get: assembleStyles
	});
	}(ansiStyles$1));

	/*
	The MIT License (MIT)

	Copyright (c) 2016 CoderPuppy

	Permission is hereby granted, free of charge, to any person obtaining a copy
	of this software and associated documentation files (the "Software"), to deal
	in the Software without restriction, including without limitation the rights
	to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
	copies of the Software, and to permit persons to whom the Software is
	furnished to do so, subject to the following conditions:

	The above copyright notice and this permission notice shall be included in all
	copies or substantial portions of the Software.

	THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
	IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
	FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
	AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
	LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
	OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
	SOFTWARE.

	*/
	var _endianness;
	function endianness() {
	  if (typeof _endianness === 'undefined') {
	    var a = new ArrayBuffer(2);
	    var b = new Uint8Array(a);
	    var c = new Uint16Array(a);
	    b[0] = 1;
	    b[1] = 2;
	    if (c[0] === 258) {
	      _endianness = 'BE';
	    } else if (c[0] === 513){
	      _endianness = 'LE';
	    } else {
	      throw new Error('unable to figure out endianess');
	    }
	  }
	  return _endianness;
	}

	function hostname() {
	  if (typeof global.location !== 'undefined') {
	    return global.location.hostname
	  } else return '';
	}

	function loadavg() {
	  return [];
	}

	function uptime() {
	  return 0;
	}

	function freemem() {
	  return Number.MAX_VALUE;
	}

	function totalmem() {
	  return Number.MAX_VALUE;
	}

	function cpus() {
	  return [];
	}

	function type() {
	  return 'Browser';
	}

	function release () {
	  if (typeof global.navigator !== 'undefined') {
	    return global.navigator.appVersion;
	  }
	  return '';
	}

	function networkInterfaces(){}
	function getNetworkInterfaces(){}

	function arch() {
	  return 'javascript';
	}

	function platform() {
	  return 'browser';
	}

	function tmpDir() {
	  return '/tmp';
	}
	var tmpdir = tmpDir;

	var EOL = '\n';
	var os$1 = {
	  EOL: EOL,
	  tmpdir: tmpdir,
	  tmpDir: tmpDir,
	  networkInterfaces:networkInterfaces,
	  getNetworkInterfaces: getNetworkInterfaces,
	  release: release,
	  type: type,
	  cpus: cpus,
	  totalmem: totalmem,
	  freemem: freemem,
	  uptime: uptime,
	  loadavg: loadavg,
	  hostname: hostname,
	  endianness: endianness,
	};

	var os$2 = /*#__PURE__*/Object.freeze({
		__proto__: null,
		endianness: endianness,
		hostname: hostname,
		loadavg: loadavg,
		uptime: uptime,
		freemem: freemem,
		totalmem: totalmem,
		cpus: cpus,
		type: type,
		release: release,
		networkInterfaces: networkInterfaces,
		getNetworkInterfaces: getNetworkInterfaces,
		arch: arch,
		platform: platform,
		tmpDir: tmpDir,
		tmpdir: tmpdir,
		EOL: EOL,
		'default': os$1
	});

	var require$$0 = /*@__PURE__*/getAugmentedNamespace(os$2);

	// MIT lisence
	// from https://github.com/substack/tty-browserify/blob/1ba769a6429d242f36226538835b4034bf6b7886/index.js

	function isatty() {
	  return false;
	}

	function ReadStream() {
	  throw new Error('tty.ReadStream is not implemented');
	}

	function WriteStream() {
	  throw new Error('tty.ReadStream is not implemented');
	}

	var tty$1 = {
	  isatty: isatty,
	  ReadStream: ReadStream,
	  WriteStream: WriteStream
	};

	var tty$2 = /*#__PURE__*/Object.freeze({
		__proto__: null,
		isatty: isatty,
		ReadStream: ReadStream,
		WriteStream: WriteStream,
		'default': tty$1
	});

	var require$$1$1 = /*@__PURE__*/getAugmentedNamespace(tty$2);

	var hasFlag$1 = (flag, argv = process.argv) => {
		const prefix = flag.startsWith('-') ? '' : (flag.length === 1 ? '-' : '--');
		const position = argv.indexOf(prefix + flag);
		const terminatorPosition = argv.indexOf('--');
		return position !== -1 && (terminatorPosition === -1 || position < terminatorPosition);
	};

	const os = require$$0;
	const tty = require$$1$1;
	const hasFlag = hasFlag$1;

	const {env} = process;

	let forceColor;
	if (hasFlag('no-color') ||
		hasFlag('no-colors') ||
		hasFlag('color=false') ||
		hasFlag('color=never')) {
		forceColor = 0;
	} else if (hasFlag('color') ||
		hasFlag('colors') ||
		hasFlag('color=true') ||
		hasFlag('color=always')) {
		forceColor = 1;
	}

	if ('FORCE_COLOR' in env) {
		if (env.FORCE_COLOR === 'true') {
			forceColor = 1;
		} else if (env.FORCE_COLOR === 'false') {
			forceColor = 0;
		} else {
			forceColor = env.FORCE_COLOR.length === 0 ? 1 : Math.min(parseInt(env.FORCE_COLOR, 10), 3);
		}
	}

	function translateLevel(level) {
		if (level === 0) {
			return false;
		}

		return {
			level,
			hasBasic: true,
			has256: level >= 2,
			has16m: level >= 3
		};
	}

	function supportsColor(haveStream, streamIsTTY) {
		if (forceColor === 0) {
			return 0;
		}

		if (hasFlag('color=16m') ||
			hasFlag('color=full') ||
			hasFlag('color=truecolor')) {
			return 3;
		}

		if (hasFlag('color=256')) {
			return 2;
		}

		if (haveStream && !streamIsTTY && forceColor === undefined) {
			return 0;
		}

		const min = forceColor || 0;

		if (env.TERM === 'dumb') {
			return min;
		}

		if (process.platform === 'win32') {
			// Windows 10 build 10586 is the first Windows release that supports 256 colors.
			// Windows 10 build 14931 is the first release that supports 16m/TrueColor.
			const osRelease = os.release().split('.');
			if (
				Number(osRelease[0]) >= 10 &&
				Number(osRelease[2]) >= 10586
			) {
				return Number(osRelease[2]) >= 14931 ? 3 : 2;
			}

			return 1;
		}

		if ('CI' in env) {
			if (['TRAVIS', 'CIRCLECI', 'APPVEYOR', 'GITLAB_CI', 'GITHUB_ACTIONS', 'BUILDKITE'].some(sign => sign in env) || env.CI_NAME === 'codeship') {
				return 1;
			}

			return min;
		}

		if ('TEAMCITY_VERSION' in env) {
			return /^(9\.(0*[1-9]\d*)\.|\d{2,}\.)/.test(env.TEAMCITY_VERSION) ? 1 : 0;
		}

		if (env.COLORTERM === 'truecolor') {
			return 3;
		}

		if ('TERM_PROGRAM' in env) {
			const version = parseInt((env.TERM_PROGRAM_VERSION || '').split('.')[0], 10);

			switch (env.TERM_PROGRAM) {
				case 'iTerm.app':
					return version >= 3 ? 3 : 2;
				case 'Apple_Terminal':
					return 2;
				// No default
			}
		}

		if (/-256(color)?$/i.test(env.TERM)) {
			return 2;
		}

		if (/^screen|^xterm|^vt100|^vt220|^rxvt|color|ansi|cygwin|linux/i.test(env.TERM)) {
			return 1;
		}

		if ('COLORTERM' in env) {
			return 1;
		}

		return min;
	}

	function getSupportLevel(stream) {
		const level = supportsColor(stream, stream && stream.isTTY);
		return translateLevel(level);
	}

	var supportsColor_1 = {
		supportsColor: getSupportLevel,
		stdout: translateLevel(supportsColor(true, tty.isatty(1))),
		stderr: translateLevel(supportsColor(true, tty.isatty(2)))
	};

	const stringReplaceAll$1 = (string, substring, replacer) => {
		let index = string.indexOf(substring);
		if (index === -1) {
			return string;
		}

		const substringLength = substring.length;
		let endIndex = 0;
		let returnValue = '';
		do {
			returnValue += string.substr(endIndex, index - endIndex) + substring + replacer;
			endIndex = index + substringLength;
			index = string.indexOf(substring, endIndex);
		} while (index !== -1);

		returnValue += string.substr(endIndex);
		return returnValue;
	};

	const stringEncaseCRLFWithFirstIndex$1 = (string, prefix, postfix, index) => {
		let endIndex = 0;
		let returnValue = '';
		do {
			const gotCR = string[index - 1] === '\r';
			returnValue += string.substr(endIndex, (gotCR ? index - 1 : index) - endIndex) + prefix + (gotCR ? '\r\n' : '\n') + postfix;
			endIndex = index + 1;
			index = string.indexOf('\n', endIndex);
		} while (index !== -1);

		returnValue += string.substr(endIndex);
		return returnValue;
	};

	var util = {
		stringReplaceAll: stringReplaceAll$1,
		stringEncaseCRLFWithFirstIndex: stringEncaseCRLFWithFirstIndex$1
	};

	const TEMPLATE_REGEX = /(?:\\(u(?:[a-f\d]{4}|\{[a-f\d]{1,6}\})|x[a-f\d]{2}|.))|(?:\{(~)?(\w+(?:\([^)]*\))?(?:\.\w+(?:\([^)]*\))?)*)(?:[ \t]|(?=\r?\n)))|(\})|((?:.|[\r\n\f])+?)/gi;
	const STYLE_REGEX = /(?:^|\.)(\w+)(?:\(([^)]*)\))?/g;
	const STRING_REGEX = /^(['"])((?:\\.|(?!\1)[^\\])*)\1$/;
	const ESCAPE_REGEX = /\\(u(?:[a-f\d]{4}|{[a-f\d]{1,6}})|x[a-f\d]{2}|.)|([^\\])/gi;

	const ESCAPES = new Map([
		['n', '\n'],
		['r', '\r'],
		['t', '\t'],
		['b', '\b'],
		['f', '\f'],
		['v', '\v'],
		['0', '\0'],
		['\\', '\\'],
		['e', '\u001B'],
		['a', '\u0007']
	]);

	function unescape(c) {
		const u = c[0] === 'u';
		const bracket = c[1] === '{';

		if ((u && !bracket && c.length === 5) || (c[0] === 'x' && c.length === 3)) {
			return String.fromCharCode(parseInt(c.slice(1), 16));
		}

		if (u && bracket) {
			return String.fromCodePoint(parseInt(c.slice(2, -1), 16));
		}

		return ESCAPES.get(c) || c;
	}

	function parseArguments(name, arguments_) {
		const results = [];
		const chunks = arguments_.trim().split(/\s*,\s*/g);
		let matches;

		for (const chunk of chunks) {
			const number = Number(chunk);
			if (!Number.isNaN(number)) {
				results.push(number);
			} else if ((matches = chunk.match(STRING_REGEX))) {
				results.push(matches[2].replace(ESCAPE_REGEX, (m, escape, character) => escape ? unescape(escape) : character));
			} else {
				throw new Error(`Invalid Chalk template style argument: ${chunk} (in style '${name}')`);
			}
		}

		return results;
	}

	function parseStyle(style) {
		STYLE_REGEX.lastIndex = 0;

		const results = [];
		let matches;

		while ((matches = STYLE_REGEX.exec(style)) !== null) {
			const name = matches[1];

			if (matches[2]) {
				const args = parseArguments(name, matches[2]);
				results.push([name].concat(args));
			} else {
				results.push([name]);
			}
		}

		return results;
	}

	function buildStyle(chalk, styles) {
		const enabled = {};

		for (const layer of styles) {
			for (const style of layer.styles) {
				enabled[style[0]] = layer.inverse ? null : style.slice(1);
			}
		}

		let current = chalk;
		for (const [styleName, styles] of Object.entries(enabled)) {
			if (!Array.isArray(styles)) {
				continue;
			}

			if (!(styleName in current)) {
				throw new Error(`Unknown Chalk style: ${styleName}`);
			}

			current = styles.length > 0 ? current[styleName](...styles) : current[styleName];
		}

		return current;
	}

	var templates = (chalk, temporary) => {
		const styles = [];
		const chunks = [];
		let chunk = [];

		// eslint-disable-next-line max-params
		temporary.replace(TEMPLATE_REGEX, (m, escapeCharacter, inverse, style, close, character) => {
			if (escapeCharacter) {
				chunk.push(unescape(escapeCharacter));
			} else if (style) {
				const string = chunk.join('');
				chunk = [];
				chunks.push(styles.length === 0 ? string : buildStyle(chalk, styles)(string));
				styles.push({inverse, styles: parseStyle(style)});
			} else if (close) {
				if (styles.length === 0) {
					throw new Error('Found extraneous } in Chalk template literal');
				}

				chunks.push(buildStyle(chalk, styles)(chunk.join('')));
				chunk = [];
				styles.pop();
			} else {
				chunk.push(character);
			}
		});

		chunks.push(chunk.join(''));

		if (styles.length > 0) {
			const errMessage = `Chalk template literal is missing ${styles.length} closing bracket${styles.length === 1 ? '' : 's'} (\`}\`)`;
			throw new Error(errMessage);
		}

		return chunks.join('');
	};

	const ansiStyles = ansiStyles$1.exports;
	const {stdout: stdoutColor, stderr: stderrColor} = supportsColor_1;
	const {
		stringReplaceAll,
		stringEncaseCRLFWithFirstIndex
	} = util;

	const {isArray: isArray$2} = Array;

	// `supportsColor.level` → `ansiStyles.color[name]` mapping
	const levelMapping = [
		'ansi',
		'ansi',
		'ansi256',
		'ansi16m'
	];

	const styles = Object.create(null);

	const applyOptions = (object, options = {}) => {
		if (options.level && !(Number.isInteger(options.level) && options.level >= 0 && options.level <= 3)) {
			throw new Error('The `level` option should be an integer from 0 to 3');
		}

		// Detect level if not set manually
		const colorLevel = stdoutColor ? stdoutColor.level : 0;
		object.level = options.level === undefined ? colorLevel : options.level;
	};

	class ChalkClass {
		constructor(options) {
			// eslint-disable-next-line no-constructor-return
			return chalkFactory(options);
		}
	}

	const chalkFactory = options => {
		const chalk = {};
		applyOptions(chalk, options);

		chalk.template = (...arguments_) => chalkTag(chalk.template, ...arguments_);

		Object.setPrototypeOf(chalk, Chalk.prototype);
		Object.setPrototypeOf(chalk.template, chalk);

		chalk.template.constructor = () => {
			throw new Error('`chalk.constructor()` is deprecated. Use `new chalk.Instance()` instead.');
		};

		chalk.template.Instance = ChalkClass;

		return chalk.template;
	};

	function Chalk(options) {
		return chalkFactory(options);
	}

	for (const [styleName, style] of Object.entries(ansiStyles)) {
		styles[styleName] = {
			get() {
				const builder = createBuilder(this, createStyler(style.open, style.close, this._styler), this._isEmpty);
				Object.defineProperty(this, styleName, {value: builder});
				return builder;
			}
		};
	}

	styles.visible = {
		get() {
			const builder = createBuilder(this, this._styler, true);
			Object.defineProperty(this, 'visible', {value: builder});
			return builder;
		}
	};

	const usedModels = ['rgb', 'hex', 'keyword', 'hsl', 'hsv', 'hwb', 'ansi', 'ansi256'];

	for (const model of usedModels) {
		styles[model] = {
			get() {
				const {level} = this;
				return function (...arguments_) {
					const styler = createStyler(ansiStyles.color[levelMapping[level]][model](...arguments_), ansiStyles.color.close, this._styler);
					return createBuilder(this, styler, this._isEmpty);
				};
			}
		};
	}

	for (const model of usedModels) {
		const bgModel = 'bg' + model[0].toUpperCase() + model.slice(1);
		styles[bgModel] = {
			get() {
				const {level} = this;
				return function (...arguments_) {
					const styler = createStyler(ansiStyles.bgColor[levelMapping[level]][model](...arguments_), ansiStyles.bgColor.close, this._styler);
					return createBuilder(this, styler, this._isEmpty);
				};
			}
		};
	}

	const proto = Object.defineProperties(() => {}, {
		...styles,
		level: {
			enumerable: true,
			get() {
				return this._generator.level;
			},
			set(level) {
				this._generator.level = level;
			}
		}
	});

	const createStyler = (open, close, parent) => {
		let openAll;
		let closeAll;
		if (parent === undefined) {
			openAll = open;
			closeAll = close;
		} else {
			openAll = parent.openAll + open;
			closeAll = close + parent.closeAll;
		}

		return {
			open,
			close,
			openAll,
			closeAll,
			parent
		};
	};

	const createBuilder = (self, _styler, _isEmpty) => {
		const builder = (...arguments_) => {
			if (isArray$2(arguments_[0]) && isArray$2(arguments_[0].raw)) {
				// Called as a template literal, for example: chalk.red`2 + 3 = {bold ${2+3}}`
				return applyStyle(builder, chalkTag(builder, ...arguments_));
			}

			// Single argument is hot path, implicit coercion is faster than anything
			// eslint-disable-next-line no-implicit-coercion
			return applyStyle(builder, (arguments_.length === 1) ? ('' + arguments_[0]) : arguments_.join(' '));
		};

		// We alter the prototype because we must return a function, but there is
		// no way to create a function with a different prototype
		Object.setPrototypeOf(builder, proto);

		builder._generator = self;
		builder._styler = _styler;
		builder._isEmpty = _isEmpty;

		return builder;
	};

	const applyStyle = (self, string) => {
		if (self.level <= 0 || !string) {
			return self._isEmpty ? '' : string;
		}

		let styler = self._styler;

		if (styler === undefined) {
			return string;
		}

		const {openAll, closeAll} = styler;
		if (string.indexOf('\u001B') !== -1) {
			while (styler !== undefined) {
				// Replace any instances already present with a re-opening code
				// otherwise only the part of the string until said closing code
				// will be colored, and the rest will simply be 'plain'.
				string = stringReplaceAll(string, styler.close, styler.open);

				styler = styler.parent;
			}
		}

		// We can move both next actions out of loop, because remaining actions in loop won't have
		// any/visible effect on parts we add here. Close the styling before a linebreak and reopen
		// after next line to fix a bleed issue on macOS: https://github.com/chalk/chalk/pull/92
		const lfIndex = string.indexOf('\n');
		if (lfIndex !== -1) {
			string = stringEncaseCRLFWithFirstIndex(string, closeAll, openAll, lfIndex);
		}

		return openAll + string + closeAll;
	};

	let template;
	const chalkTag = (chalk, ...strings) => {
		const [firstString] = strings;

		if (!isArray$2(firstString) || !isArray$2(firstString.raw)) {
			// If chalk() was called by itself or with a string,
			// return the string itself as a string.
			return strings.join(' ');
		}

		const arguments_ = strings.slice(1);
		const parts = [firstString.raw[0]];

		for (let i = 1; i < firstString.length; i++) {
			parts.push(
				String(arguments_[i - 1]).replace(/[{}\\]/g, '\\$&'),
				String(firstString.raw[i])
			);
		}

		if (template === undefined) {
			template = templates;
		}

		return template(chalk, parts.join(''));
	};

	Object.defineProperties(Chalk.prototype, styles);

	const chalk = Chalk(); // eslint-disable-line new-cap
	chalk.supportsColor = stdoutColor;
	chalk.stderr = Chalk({level: stderrColor ? stderrColor.level : 0}); // eslint-disable-line new-cap
	chalk.stderr.supportsColor = stderrColor;

	var source = chalk;

	function noop(){}

	var console$1 = global.console ? global.console : {
	  log: noop,
	  info: noop,
	  warn: noop,
	  error: noop,
	  dir: noop,
	  assert: noop,
	  time: noop,
	  timeEnd: noop,
	  trace: noop
	};

	var console$2 = /*#__PURE__*/Object.freeze({
		__proto__: null,
		'default': console$1
	});

	var require$$1 = /*@__PURE__*/getAugmentedNamespace(console$2);

	var __importDefault$1 = (commonjsGlobal && commonjsGlobal.__importDefault) || function (mod) {
	    return (mod && mod.__esModule) ? mod : { "default": mod };
	};
	Object.defineProperty(debug$1, "__esModule", { value: true });
	debug$1.DebugLogger = debug$1.newDebugLogger = void 0;
	const chalk_1 = __importDefault$1(source);
	function stringIsBoolean(str) {
	    if (!str) {
	        return false;
	    }
	    switch (str.toLocaleLowerCase()) {
	        case "true":
	        case "yes":
	        case "1":
	            return true;
	        case "false":
	        case "no":
	        case "0":
	            return false;
	        default:
	            return undefined;
	    }
	}
	function indentString(indentLevel) {
	    let str = "";
	    for (let i = 0; i < indentLevel; i++) {
	        str += chalk_1.default.blackBright("⎸ ");
	    }
	    return str;
	}
	function isEnabled(name) {
	    const v = process.env.APOLLO_FEDERATION_DEBUG;
	    const bool = stringIsBoolean(v);
	    if (bool !== undefined) {
	        return bool;
	    }
	    const enabledNames = v.split(',').map(n => n.trim());
	    return enabledNames.includes(name);
	}
	let currentIndentLevel = 0;
	let currentIdentation = '';
	let maxLoggerNameLength = 0;
	let createdLoggers = [];
	function newDebugLogger(name) {
	    const enabled = isEnabled(name);
	    const created = new DebugLogger(name, enabled);
	    if (enabled) {
	        commonjsGlobal.console = require$$1;
	        createdLoggers.push(created);
	        maxLoggerNameLength = Math.max(maxLoggerNameLength, name.length);
	        for (const logger of createdLoggers) {
	            DebugLogger.prototype['updateHeader'].call(logger, maxLoggerNameLength);
	        }
	    }
	    return created;
	}
	debug$1.newDebugLogger = newDebugLogger;
	function increaseIndentation() {
	    currentIndentLevel++;
	    currentIdentation = indentString(currentIndentLevel);
	}
	function decreaseIndentation() {
	    if (currentIndentLevel > 0) {
	        currentIndentLevel--;
	        currentIdentation = indentString(currentIndentLevel);
	    }
	}
	class DebugLogger {
	    constructor(name, enabled) {
	        this.name = name;
	        this.enabled = enabled;
	        this.header = chalk_1.default.blackBright(`[${name}] `);
	    }
	    updateHeader(maxLength) {
	        let padding = "";
	        if (maxLength > this.name.length) {
	            const toPad = maxLength - this.name.length;
	            for (let i = 0; i < toPad; i++) {
	                padding += " ";
	            }
	        }
	        this.header = chalk_1.default.blackBright('[' + padding + this.name + '] ');
	    }
	    doLog(str) {
	        const indent = this.header + currentIdentation;
	        const withIndentedNewlines = str.replace(/\n/g, '\n' + indent + '  ');
	        console.log(indent + withIndentedNewlines);
	    }
	    log(message, prefix = chalk_1.default.yellow('• ')) {
	        if (!this.enabled)
	            return this;
	        if (typeof message !== 'string') {
	            message = message();
	        }
	        this.doLog(prefix + message);
	        return this;
	    }
	    groupedValues(values, printFn, initialMessage) {
	        if (!this.enabled)
	            return this;
	        this.group(initialMessage);
	        for (const value of values) {
	            this.doLog('- ' + printFn(value));
	        }
	        return this.groupEnd();
	    }
	    groupedEntries(map, keyPrintFn, valuePrintFn) {
	        if (!this.enabled)
	            return this;
	        this.group();
	        for (const [k, v] of map.entries()) {
	            this.doLog('- ' + keyPrintFn(k) + ': ' + valuePrintFn(v));
	        }
	        return this.groupEnd();
	    }
	    group(openingMessage) {
	        if (this.enabled) {
	            if (openingMessage) {
	                this.log(openingMessage, chalk_1.default.blue('‣ '));
	            }
	            increaseIndentation();
	        }
	        return this;
	    }
	    groupEnd(closingMessage) {
	        if (!this.enabled) {
	            return this;
	        }
	        decreaseIndentation();
	        if (closingMessage) {
	            this.log(closingMessage, chalk_1.default.green('⇒ '));
	        }
	        return this;
	    }
	}
	debug$1.DebugLogger = DebugLogger;

	var joinSpec$1 = {};

	(function (exports) {
	Object.defineProperty(exports, "__esModule", { value: true });
	exports.JOIN_VERSIONS = exports.JoinSpecDefinition = exports.joinIdentity = void 0;
	const coreSpec_1 = coreSpec$1;
	const definitions_1 = definitions;
	const utils_1 = utils;
	exports.joinIdentity = 'https://specs.apollo.dev/join';
	function sanitizeGraphQLName(name) {
	    const alphaNumericUnderscoreOnly = name.replace(/[\W]/g, '_');
	    const noNumericFirstChar = alphaNumericUnderscoreOnly.match(/^\d/)
	        ? '_' + alphaNumericUnderscoreOnly
	        : alphaNumericUnderscoreOnly;
	    const noUnderscoreNumericEnding = noNumericFirstChar.match(/_\d+$/)
	        ? noNumericFirstChar + '_'
	        : noNumericFirstChar;
	    const toUpper = noUnderscoreNumericEnding.toLocaleUpperCase();
	    return toUpper;
	}
	class JoinSpecDefinition extends coreSpec_1.FeatureDefinition {
	    constructor(version) {
	        super(new coreSpec_1.FeatureUrl(exports.joinIdentity, 'join', version));
	    }
	    isV01() {
	        return this.version.equals(new coreSpec_1.FeatureVersion(0, 1));
	    }
	    addElementsToSchema(schema) {
	        const joinGraph = this.addDirective(schema, 'graph').addLocations("ENUM_VALUE");
	        joinGraph.addArgument('name', new definitions_1.NonNullType(schema.stringType()));
	        joinGraph.addArgument('url', new definitions_1.NonNullType(schema.stringType()));
	        const graphEnum = this.addEnumType(schema, 'Graph');
	        const joinFieldSet = this.addScalarType(schema, 'FieldSet');
	        const joinType = this.addDirective(schema, 'type').addLocations("OBJECT", "INTERFACE", "UNION", "ENUM", "INPUT_OBJECT", "SCALAR");
	        if (!this.isV01()) {
	            joinType.repeatable = true;
	        }
	        joinType.addArgument('graph', new definitions_1.NonNullType(graphEnum));
	        joinType.addArgument('key', joinFieldSet);
	        if (!this.isV01()) {
	            joinType.addArgument('extension', new definitions_1.NonNullType(schema.booleanType()), false);
	        }
	        const joinField = this.addDirective(schema, 'field').addLocations("FIELD_DEFINITION", "INPUT_FIELD_DEFINITION");
	        joinField.repeatable = true;
	        joinField.addArgument('graph', new definitions_1.NonNullType(graphEnum));
	        joinField.addArgument('requires', joinFieldSet);
	        joinField.addArgument('provides', joinFieldSet);
	        if (!this.isV01()) {
	            joinField.addArgument('type', schema.stringType());
	            joinField.addArgument('external', schema.booleanType());
	        }
	        if (!this.isV01()) {
	            const joinImplements = this.addDirective(schema, 'implements').addLocations("OBJECT", "INTERFACE");
	            joinImplements.repeatable = true;
	            joinImplements.addArgument('graph', new definitions_1.NonNullType(graphEnum));
	            joinImplements.addArgument('interface', new definitions_1.NonNullType(schema.stringType()));
	        }
	        if (this.isV01()) {
	            const joinOwner = this.addDirective(schema, 'owner').addLocations("OBJECT");
	            joinOwner.addArgument('graph', new definitions_1.NonNullType(graphEnum));
	        }
	    }
	    populateGraphEnum(schema, subgraphs) {
	        const sanitizedNameToSubgraphs = new utils_1.MultiMap();
	        for (const subgraph of subgraphs) {
	            const sanitized = sanitizeGraphQLName(subgraph.name);
	            sanitizedNameToSubgraphs.add(sanitized, subgraph);
	        }
	        const subgraphToEnumName = new Map();
	        for (const [sanitizedName, subgraphsForName] of sanitizedNameToSubgraphs) {
	            if (subgraphsForName.length === 1) {
	                subgraphToEnumName.set(subgraphsForName[0].name, sanitizedName);
	            }
	            else {
	                for (const [index, subgraph] of subgraphsForName.entries()) {
	                    subgraphToEnumName.set(subgraph.name, `${sanitizedName}_${index + 1}`);
	                }
	            }
	        }
	        const graphEnum = this.graphEnum(schema);
	        const graphDirective = this.graphDirective(schema);
	        for (const subgraph of subgraphs) {
	            const enumValue = graphEnum.addValue(subgraphToEnumName.get(subgraph.name));
	            enumValue.applyDirective(graphDirective, { name: subgraph.name, url: subgraph.url });
	        }
	        return subgraphToEnumName;
	    }
	    fieldSetScalar(schema) {
	        return this.type(schema, 'FieldSet');
	    }
	    graphEnum(schema) {
	        return this.type(schema, 'Graph');
	    }
	    graphDirective(schema) {
	        return this.directive(schema, 'graph');
	    }
	    typeDirective(schema) {
	        return this.directive(schema, 'type');
	    }
	    implementsDirective(schema) {
	        return this.directive(schema, 'implements');
	    }
	    fieldDirective(schema) {
	        return this.directive(schema, 'field');
	    }
	    ownerDirective(schema) {
	        return this.directive(schema, 'owner');
	    }
	}
	exports.JoinSpecDefinition = JoinSpecDefinition;
	exports.JOIN_VERSIONS = new coreSpec_1.FeatureDefinitions(exports.joinIdentity)
	    .add(new JoinSpecDefinition(new coreSpec_1.FeatureVersion(0, 1)))
	    .add(new JoinSpecDefinition(new coreSpec_1.FeatureVersion(0, 2)));

	}(joinSpec$1));

	var supergraphs = {};

	var extractSubgraphsFromSupergraph$1 = {};

	Object.defineProperty(extractSubgraphsFromSupergraph$1, "__esModule", { value: true });
	extractSubgraphsFromSupergraph$1.extractSubgraphsFromSupergraph = extractSubgraphsFromSupergraph$1.extractSubgraphsNamesAndUrlsFromSupergraph = void 0;
	const definitions_1$1 = definitions;
	const federation_1 = federation;
	const coreSpec_1$1 = coreSpec$1;
	const federation_2 = federation;
	const utils_1 = utils;
	const supergraphs_1 = supergraphs;
	const buildSchema_1$1 = buildSchema$1;
	const graphql_1$4 = require$$2$1;
	const operations_1 = operations;
	const types_1 = types;
	function filteredTypes(supergraph, joinSpec, coreSpec) {
	    return supergraph.types().filter(t => !joinSpec.isSpecType(t) && !coreSpec.isSpecType(t));
	}
	function extractSubgraphsNamesAndUrlsFromSupergraph(supergraph) {
	    const [_, joinSpec] = (0, supergraphs_1.validateSupergraph)(supergraph);
	    const [subgraphs] = collectEmptySubgraphs(supergraph, joinSpec);
	    return subgraphs.values().map(subgraph => { return { name: subgraph.name, url: subgraph.url }; });
	}
	extractSubgraphsFromSupergraph$1.extractSubgraphsNamesAndUrlsFromSupergraph = extractSubgraphsNamesAndUrlsFromSupergraph;
	function collectEmptySubgraphs(supergraph, joinSpec) {
	    const subgraphs = new federation_2.Subgraphs();
	    const graphDirective = joinSpec.graphDirective(supergraph);
	    const graphEnum = joinSpec.graphEnum(supergraph);
	    const graphEnumNameToSubgraphName = new Map();
	    for (const value of graphEnum.values) {
	        const graphApplications = value.appliedDirectivesOf(graphDirective);
	        if (!graphApplications.length) {
	            throw new Error(`Value ${value} of join__Graph enum has no @join__graph directive`);
	        }
	        const info = graphApplications[0].arguments();
	        const subgraph = new federation_2.Subgraph(info.name, info.url, new definitions_1$1.Schema(federation_1.federationBuiltIns), false);
	        subgraphs.add(subgraph);
	        graphEnumNameToSubgraphName.set(value.name, info.name);
	    }
	    return [subgraphs, graphEnumNameToSubgraphName];
	}
	function extractSubgraphsFromSupergraph(supergraph) {
	    const [coreFeatures, joinSpec] = (0, supergraphs_1.validateSupergraph)(supergraph);
	    const isFed1 = joinSpec.version.equals(new coreSpec_1$1.FeatureVersion(0, 1));
	    const [subgraphs, graphEnumNameToSubgraphName] = collectEmptySubgraphs(supergraph, joinSpec);
	    const typeDirective = joinSpec.typeDirective(supergraph);
	    const implementsDirective = joinSpec.implementsDirective(supergraph);
	    for (const type of filteredTypes(supergraph, joinSpec, coreFeatures.coreDefinition)) {
	        const typeApplications = type.appliedDirectivesOf(typeDirective);
	        if (!typeApplications.length) {
	            subgraphs.values().map(sg => sg.schema).forEach(schema => schema.addType((0, definitions_1$1.newNamedType)(type.kind, type.name)));
	        }
	        else {
	            for (const application of typeApplications) {
	                const args = application.arguments();
	                const subgraphName = graphEnumNameToSubgraphName.get(args.graph);
	                const schema = subgraphs.get(subgraphName).schema;
	                let subgraphType = schema.type(type.name);
	                if (!subgraphType) {
	                    subgraphType = schema.addType((0, definitions_1$1.newNamedType)(type.kind, type.name));
	                }
	                if (args.key) {
	                    const directive = subgraphType.applyDirective('key', { 'fields': args.key });
	                    if (args.extension) {
	                        directive.setOfExtension(subgraphType.newExtension());
	                    }
	                }
	            }
	        }
	    }
	    const ownerDirective = joinSpec.ownerDirective(supergraph);
	    const fieldDirective = joinSpec.fieldDirective(supergraph);
	    for (const type of filteredTypes(supergraph, joinSpec, coreFeatures.coreDefinition)) {
	        switch (type.kind) {
	            case 'ObjectType':
	            case 'InterfaceType':
	                const addedInterfaces = [];
	                const implementsApplications = implementsDirective ? type.appliedDirectivesOf(implementsDirective) : [];
	                for (const application of implementsApplications) {
	                    const args = application.arguments();
	                    const subgraph = subgraphs.get(graphEnumNameToSubgraphName.get(args.graph));
	                    const schema = subgraph.schema;
	                    schema.type(type.name).addImplementedInterface(args.interface);
	                    addedInterfaces.push(args.interface);
	                }
	                for (const implementations of type.interfaceImplementations()) {
	                    const name = implementations.interface.name;
	                    if (!addedInterfaces.includes(name)) {
	                        for (const subgraph of subgraphs) {
	                            const subgraphType = subgraph.schema.type(type.name);
	                            const subraphItf = subgraph.schema.type(name);
	                            if (subgraphType && subraphItf) {
	                                subgraphType.addImplementedInterface(name);
	                            }
	                        }
	                    }
	                }
	            case 'InputObjectType':
	                for (const field of type.fields()) {
	                    const fieldApplications = field.appliedDirectivesOf(fieldDirective);
	                    if (!fieldApplications.length) {
	                        const ownerApplications = ownerDirective ? type.appliedDirectivesOf(ownerDirective) : [];
	                        if (!ownerApplications.length) {
	                            const fieldBaseType = (0, definitions_1$1.baseType)(field.type);
	                            for (const subgraph of subgraphs) {
	                                if (subgraph.schema.type(fieldBaseType.name)) {
	                                    addSubgraphField(field, subgraph);
	                                }
	                            }
	                        }
	                        else {
	                            (0, utils_1.assert)(ownerApplications.length == 1, () => `Found multiple join__owner directives on type ${type}`);
	                            const subgraph = subgraphs.get(graphEnumNameToSubgraphName.get(ownerApplications[0].arguments().graph));
	                            const subgraphField = addSubgraphField(field, subgraph);
	                            (0, utils_1.assert)(subgraphField, () => `Found join__owner directive on ${type} but no corresponding join__type`);
	                        }
	                    }
	                    else {
	                        for (const application of fieldApplications) {
	                            const args = application.arguments();
	                            const subgraph = subgraphs.get(graphEnumNameToSubgraphName.get(args.graph));
	                            const subgraphField = addSubgraphField(field, subgraph, args.type);
	                            (0, utils_1.assert)(subgraphField, () => `Found join__field directive for graph ${subgraph.name} on field ${field.coordinate} but no corresponding join__type on ${type}`);
	                            if (args.requires) {
	                                subgraphField.applyDirective('requires', { 'fields': args.requires });
	                            }
	                            if (args.provides) {
	                                subgraphField.applyDirective('provides', { 'fields': args.provides });
	                            }
	                            if (args.external) {
	                                subgraphField.applyDirective('external');
	                            }
	                        }
	                    }
	                }
	                break;
	            case 'EnumType':
	                for (const subgraph of subgraphs) {
	                    const subgraphEnum = subgraph.schema.type(type.name);
	                    if (!subgraphEnum) {
	                        continue;
	                    }
	                    (0, utils_1.assert)((0, definitions_1$1.isEnumType)(subgraphEnum), () => `${subgraphEnum} should be an enum but found a ${subgraphEnum.kind}`);
	                    for (const value of type.values) {
	                        subgraphEnum.addValue(value.name);
	                    }
	                }
	                break;
	            case 'UnionType':
	                for (const subgraph of subgraphs) {
	                    const subgraphUnion = subgraph.schema.type(type.name);
	                    if (!subgraphUnion) {
	                        continue;
	                    }
	                    (0, utils_1.assert)((0, definitions_1$1.isUnionType)(subgraphUnion), () => `${subgraphUnion} should be an enum but found a ${subgraphUnion.kind}`);
	                    for (const memberType of type.types()) {
	                        const subgraphType = subgraph.schema.type(memberType.name);
	                        if (subgraphType) {
	                            subgraphUnion.addType(subgraphType);
	                        }
	                    }
	                }
	                break;
	        }
	    }
	    for (const subgraph of subgraphs) {
	        if (isFed1) {
	            addExternalFields(subgraph, supergraph, isFed1);
	        }
	        removeNeedlessProvides(subgraph);
	        for (const type of subgraph.schema.types()) {
	            switch (type.kind) {
	                case 'ObjectType':
	                case 'InterfaceType':
	                case 'InputObjectType':
	                    if (!type.hasFields()) {
	                        type.remove();
	                    }
	                    break;
	                case 'UnionType':
	                    if (type.membersCount() === 0) {
	                        type.remove();
	                    }
	                    break;
	            }
	        }
	    }
	    if (isFed1) {
	        for (const subgraph of subgraphs) {
	            for (const itf of subgraph.schema.types('InterfaceType')) {
	                const implementations = itf.possibleRuntimeTypes();
	                for (const field of itf.fields()) {
	                    if (!implementations.every(implem => implem.field(field.name))) {
	                        field.remove();
	                    }
	                }
	                if (!itf.hasFields()) {
	                    itf.remove();
	                }
	            }
	        }
	    }
	    for (const subgraph of subgraphs) {
	        try {
	            subgraph.schema.validate();
	        }
	        catch (e) {
	            const details = e instanceof graphql_1$4.GraphQLError ? (0, federation_1.addSubgraphToError)(e, subgraph.name).toString() : String(e);
	            throw new Error(`Unexpected error extracting subgraph information from the supergraph. This is either a bug, or the supergraph has been corrupted.\nCaused by: ${details}`);
	        }
	    }
	    return subgraphs;
	}
	extractSubgraphsFromSupergraph$1.extractSubgraphsFromSupergraph = extractSubgraphsFromSupergraph;
	function addSubgraphField(supergraphField, subgraph, encodedType) {
	    if (supergraphField instanceof definitions_1$1.FieldDefinition) {
	        return addSubgraphObjectOrInterfaceField(supergraphField, subgraph, encodedType);
	    }
	    else {
	        return addSubgraphInputField(supergraphField, subgraph, encodedType);
	    }
	}
	function addSubgraphObjectOrInterfaceField(supergraphField, subgraph, encodedType) {
	    const subgraphType = subgraph.schema.type(supergraphField.parent.name);
	    if (subgraphType) {
	        const copiedType = encodedType
	            ? decodeType(encodedType, subgraph.schema, subgraph.name)
	            : copyType(supergraphField.type, subgraph.schema, subgraph.name);
	        const field = subgraphType.addField(supergraphField.name, copiedType);
	        for (const arg of supergraphField.arguments()) {
	            field.addArgument(arg.name, copyType(arg.type, subgraph.schema, subgraph.name), arg.defaultValue);
	        }
	        return field;
	    }
	    else {
	        return undefined;
	    }
	}
	function addSubgraphInputField(supergraphField, subgraph, encodedType) {
	    const subgraphType = subgraph.schema.type(supergraphField.parent.name);
	    if (subgraphType) {
	        const copiedType = encodedType
	            ? decodeType(encodedType, subgraph.schema, subgraph.name)
	            : copyType(supergraphField.type, subgraph.schema, subgraph.name);
	        return subgraphType.addField(supergraphField.name, copiedType);
	    }
	    else {
	        return undefined;
	    }
	}
	function decodeType(encodedType, subgraph, subgraphName) {
	    try {
	        return (0, buildSchema_1$1.builtTypeReference)(encodedType, subgraph);
	    }
	    catch (e) {
	        (0, utils_1.assert)(false, () => `Cannot parse type "${encodedType}" in subgraph ${subgraphName}: ${e}`);
	    }
	}
	function copyType(type, subgraph, subgraphName) {
	    switch (type.kind) {
	        case 'ListType':
	            return new definitions_1$1.ListType(copyType(type.ofType, subgraph, subgraphName));
	        case 'NonNullType':
	            return new definitions_1$1.NonNullType(copyType(type.ofType, subgraph, subgraphName));
	        default:
	            const subgraphType = subgraph.type(type.name);
	            (0, utils_1.assert)(subgraphType, () => `Cannot find type ${type.name} in subgraph ${subgraphName}`);
	            return subgraphType;
	    }
	}
	function addExternalFields(subgraph, supergraph, isFed1) {
	    for (const type of subgraph.schema.types()) {
	        if (!(0, definitions_1$1.isObjectType)(type) && !(0, definitions_1$1.isInterfaceType)(type)) {
	            continue;
	        }
	        for (const keyApplication of type.appliedDirectivesOf(federation_1.federationBuiltIns.keyDirective(subgraph.schema))) {
	            const forceNonExternal = isFed1 || !!keyApplication.ofExtension();
	            addExternalFieldsFromDirectiveFieldSet(subgraph, type, keyApplication, supergraph, forceNonExternal);
	        }
	        for (const field of type.fields()) {
	            for (const requiresApplication of field.appliedDirectivesOf(federation_1.federationBuiltIns.requiresDirective(subgraph.schema))) {
	                addExternalFieldsFromDirectiveFieldSet(subgraph, type, requiresApplication, supergraph);
	            }
	            const fieldBaseType = (0, definitions_1$1.baseType)(field.type);
	            for (const providesApplication of field.appliedDirectivesOf(federation_1.federationBuiltIns.providesDirective(subgraph.schema))) {
	                (0, utils_1.assert)((0, definitions_1$1.isObjectType)(fieldBaseType) || (0, definitions_1$1.isInterfaceType)(fieldBaseType), () => `Found @provides on field ${field.coordinate} whose type ${field.type} (${fieldBaseType.kind}) is not an object or interface `);
	                addExternalFieldsFromDirectiveFieldSet(subgraph, fieldBaseType, providesApplication, supergraph);
	            }
	        }
	        addExternalFieldsFromInterface(type);
	    }
	}
	function addExternalFieldsFromDirectiveFieldSet(subgraph, parentType, directive, supergraph, forceNonExternal = false) {
	    const external = federation_1.federationBuiltIns.externalDirective(subgraph.schema);
	    let accessor = function (type, fieldName) {
	        const field = type.field(fieldName);
	        if (field) {
	            if (forceNonExternal && field.hasAppliedDirective(external)) {
	                field.appliedDirectivesOf(external).forEach(d => d.remove());
	            }
	            return field;
	        }
	        (0, utils_1.assert)(!(0, definitions_1$1.isUnionType)(type), () => `Shouldn't select field ${fieldName} from union type ${type}`);
	        const supergraphType = supergraph.type(type.name);
	        const supergraphField = supergraphType.field(fieldName);
	        (0, utils_1.assert)(supergraphField, () => `No field named ${fieldName} found on type ${type.name} in the supergraph`);
	        const created = addSubgraphObjectOrInterfaceField(supergraphField, subgraph);
	        if (!forceNonExternal) {
	            created.applyDirective(external);
	        }
	        return created;
	    };
	    (0, federation_1.parseFieldSetArgument)(parentType, directive, accessor);
	}
	function addExternalFieldsFromInterface(type) {
	    for (const itf of type.interfaces()) {
	        for (const field of itf.fields()) {
	            const typeField = type.field(field.name);
	            if (!typeField) {
	                copyFieldAsExternal(field, type);
	            }
	            else if (typeField.hasAppliedDirective(federation_1.externalDirectiveName)) {
	                maybeUpdateFieldForInterface(typeField, field);
	            }
	        }
	    }
	}
	function copyFieldAsExternal(field, type) {
	    const newField = type.addField(field.name, field.type);
	    for (const arg of field.arguments()) {
	        newField.addArgument(arg.name, arg.type, arg.defaultValue);
	    }
	    newField.applyDirective(federation_1.externalDirectiveName);
	}
	function maybeUpdateFieldForInterface(toModify, itfField) {
	    if (!(0, types_1.isSubtype)(itfField.type, toModify.type)) {
	        (0, utils_1.assert)((0, types_1.isSubtype)(toModify.type, itfField.type), () => `For ${toModify.coordinate}, expected ${itfField.type} and ${toModify.type} to be in a subtyping relationship`);
	        toModify.type = itfField.type;
	    }
	}
	function removeNeedlessProvides(subgraph) {
	    for (const type of subgraph.schema.types()) {
	        if (!(0, definitions_1$1.isObjectType)(type) && !(0, definitions_1$1.isInterfaceType)(type)) {
	            continue;
	        }
	        const providesDirective = federation_1.federationBuiltIns.providesDirective(subgraph.schema);
	        for (const field of type.fields()) {
	            const fieldBaseType = (0, definitions_1$1.baseType)(field.type);
	            for (const providesApplication of field.appliedDirectivesOf(providesDirective)) {
	                const selection = (0, federation_1.parseFieldSetArgument)(fieldBaseType, providesApplication);
	                if (selectsNonExternalLeafField(selection)) {
	                    providesApplication.remove();
	                    const updated = withoutNonExternalLeafFields(selection);
	                    if (!updated.isEmpty()) {
	                        field.applyDirective(providesDirective, { fields: updated.toString(true, false) });
	                    }
	                }
	            }
	        }
	    }
	}
	function selectsNonExternalLeafField(selection) {
	    return selection.selections().some(s => {
	        if (s.kind === 'FieldSelection') {
	            if (s.field.definition.hasAppliedDirective(federation_1.externalDirectiveName)) {
	                return false;
	            }
	            return !s.selectionSet || selectsNonExternalLeafField(s.selectionSet);
	        }
	        else {
	            return selectsNonExternalLeafField(s.selectionSet);
	        }
	    });
	}
	function withoutNonExternalLeafFields(selectionSet) {
	    const newSelectionSet = new operations_1.SelectionSet(selectionSet.parentType);
	    for (const selection of selectionSet.selections()) {
	        if (selection.kind === 'FieldSelection') {
	            if (selection.field.definition.hasAppliedDirective(federation_1.externalDirectiveName)) {
	                newSelectionSet.add(selection);
	                continue;
	            }
	        }
	        if (selection.selectionSet) {
	            const updated = withoutNonExternalLeafFields(selection.selectionSet);
	            if (!updated.isEmpty()) {
	                newSelectionSet.add((0, operations_1.selectionOfElement)(selection.element(), updated));
	            }
	        }
	    }
	    return newSelectionSet;
	}

	Object.defineProperty(supergraphs, "__esModule", { value: true });
	supergraphs.isFed1Supergraph = supergraphs.validateSupergraph = supergraphs.buildSupergraphSchema = supergraphs.ErrForUnsupported = supergraphs.ErrUnsupportedFeature = void 0;
	const graphql_1$3 = require$$2$1;
	const core_schema_1 = dist$1;
	const coreSpec_1 = coreSpec$1;
	const definitions_1 = definitions;
	const joinSpec_1 = joinSpec$1;
	const buildSchema_1 = buildSchema$1;
	const extractSubgraphsFromSupergraph_1 = extractSubgraphsFromSupergraph$1;
	const SUPPORTED_FEATURES = new Set([
	    'https://specs.apollo.dev/core/v0.1',
	    'https://specs.apollo.dev/core/v0.2',
	    'https://specs.apollo.dev/join/v0.1',
	    'https://specs.apollo.dev/join/v0.2',
	    'https://specs.apollo.dev/tag/v0.1',
	    'https://specs.apollo.dev/inaccessible/v0.1',
	]);
	function ErrUnsupportedFeature(feature) {
	    return (0, core_schema_1.err)('UnsupportedFeature', {
	        message: `feature ${feature.url} is for: ${feature.purpose} but is unsupported`,
	        feature,
	        nodes: feature.directive.sourceAST,
	    });
	}
	supergraphs.ErrUnsupportedFeature = ErrUnsupportedFeature;
	function ErrForUnsupported(core, ...features) {
	    return (0, core_schema_1.err)('ForUnsupported', {
	        message: `the \`for:\` argument is unsupported by version ${core.url.version} ` +
	            `of the core spec. Please upgrade to at least @core v0.2 (https://specs.apollo.dev/core/v0.2).`,
	        features,
	        nodes: [core.directive.sourceAST, ...features.map(f => f.directive.sourceAST)].filter(n => !!n)
	    });
	}
	supergraphs.ErrForUnsupported = ErrForUnsupported;
	const coreVersionZeroDotOneUrl = coreSpec_1.FeatureUrl.parse('https://specs.apollo.dev/core/v0.1');
	function buildSupergraphSchema(supergraphSdl) {
	    const schema = typeof supergraphSdl === 'string'
	        ? (0, buildSchema_1.buildSchema)(supergraphSdl, definitions_1.graphQLBuiltIns, false)
	        : (0, buildSchema_1.buildSchemaFromAST)(supergraphSdl, definitions_1.graphQLBuiltIns, false);
	    const [coreFeatures] = validateSupergraph(schema);
	    checkFeatureSupport(coreFeatures);
	    schema.validate();
	    return [schema, (0, extractSubgraphsFromSupergraph_1.extractSubgraphsNamesAndUrlsFromSupergraph)(schema)];
	}
	supergraphs.buildSupergraphSchema = buildSupergraphSchema;
	function checkFeatureSupport(coreFeatures) {
	    const errors = [];
	    if (coreFeatures.coreItself.url.equals(coreVersionZeroDotOneUrl)) {
	        const purposefulFeatures = [...coreFeatures.allFeatures()].filter(f => f.purpose);
	        if (purposefulFeatures.length > 0) {
	            errors.push(ErrForUnsupported(coreFeatures.coreItself, ...purposefulFeatures));
	        }
	    }
	    for (const feature of coreFeatures.allFeatures()) {
	        if (feature.url.equals(coreVersionZeroDotOneUrl) || feature.purpose === 'EXECUTION' || feature.purpose === 'SECURITY') {
	            if (!SUPPORTED_FEATURES.has(feature.url.base.toString())) {
	                errors.push(ErrUnsupportedFeature(feature));
	            }
	        }
	    }
	    if (errors.length > 0) {
	        throw (0, coreSpec_1.ErrCoreCheckFailed)(errors);
	    }
	}
	function validateSupergraph(supergraph) {
	    const coreFeatures = supergraph.coreFeatures;
	    if (!coreFeatures) {
	        throw new graphql_1$3.GraphQLError("Invalid supergraph: must be a core schema");
	    }
	    const joinFeature = coreFeatures.getByIdentity(joinSpec_1.joinIdentity);
	    if (!joinFeature) {
	        throw new graphql_1$3.GraphQLError("Invalid supergraph: must use the join spec");
	    }
	    const joinSpec = joinSpec_1.JOIN_VERSIONS.find(joinFeature.url.version);
	    if (!joinSpec) {
	        throw new graphql_1$3.GraphQLError(`Invalid supergraph: uses unsupported join spec version ${joinFeature.url.version} (supported versions: ${joinSpec_1.JOIN_VERSIONS.versions().join(', ')})`);
	    }
	    return [coreFeatures, joinSpec];
	}
	supergraphs.validateSupergraph = validateSupergraph;
	function isFed1Supergraph(supergraph) {
	    return validateSupergraph(supergraph)[1].version.equals(new coreSpec_1.FeatureVersion(0, 1));
	}
	supergraphs.isFed1Supergraph = isFed1Supergraph;

	(function (exports) {
	var __createBinding = (commonjsGlobal && commonjsGlobal.__createBinding) || (Object.create ? (function(o, m, k, k2) {
	    if (k2 === undefined) k2 = k;
	    Object.defineProperty(o, k2, { enumerable: true, get: function() { return m[k]; } });
	}) : (function(o, m, k, k2) {
	    if (k2 === undefined) k2 = k;
	    o[k2] = m[k];
	}));
	var __exportStar = (commonjsGlobal && commonjsGlobal.__exportStar) || function(m, exports) {
	    for (var p in m) if (p !== "default" && !Object.prototype.hasOwnProperty.call(exports, p)) __createBinding(exports, m, p);
	};
	Object.defineProperty(exports, "__esModule", { value: true });
	__exportStar(definitions, exports);
	__exportStar(buildSchema$1, exports);
	__exportStar(print, exports);
	__exportStar(values, exports);
	__exportStar(federation, exports);
	__exportStar(types, exports);
	__exportStar(operations, exports);
	__exportStar(utils, exports);
	__exportStar(debug$1, exports);
	__exportStar(coreSpec$1, exports);
	__exportStar(joinSpec$1, exports);
	__exportStar(tagSpec$1, exports);
	__exportStar(supergraphs, exports);
	__exportStar(extractSubgraphsFromSupergraph$1, exports);
	__exportStar(error$1, exports);

	}(dist$2));

	var dist = {};

	var querygraph = {};

	var transition = {};

	Object.defineProperty(transition, "__esModule", { value: true });
	transition.subgraphEnteringTransition = transition.SubgraphEnteringTransition = transition.DownCast = transition.FieldCollection = transition.QueryResolution = transition.KeyResolution = void 0;
	class KeyResolution {
	    constructor() {
	        this.kind = 'KeyResolution';
	        this.collectOperationElements = false;
	    }
	    toString() {
	        return 'key()';
	    }
	}
	transition.KeyResolution = KeyResolution;
	class QueryResolution {
	    constructor() {
	        this.kind = 'QueryResolution';
	        this.collectOperationElements = false;
	    }
	    toString() {
	        return 'query()';
	    }
	}
	transition.QueryResolution = QueryResolution;
	class FieldCollection {
	    constructor(definition) {
	        this.definition = definition;
	        this.kind = 'FieldCollection';
	        this.collectOperationElements = true;
	    }
	    toString() {
	        return this.definition.name;
	    }
	}
	transition.FieldCollection = FieldCollection;
	class DownCast {
	    constructor(sourceType, castedType) {
	        this.sourceType = sourceType;
	        this.castedType = castedType;
	        this.kind = 'DownCast';
	        this.collectOperationElements = true;
	    }
	    toString() {
	        return '... on ' + this.castedType.name;
	    }
	}
	transition.DownCast = DownCast;
	class SubgraphEnteringTransition {
	    constructor() {
	        this.kind = 'SubgraphEnteringTransition';
	        this.collectOperationElements = false;
	    }
	    toString() {
	        return '∅';
	    }
	}
	transition.SubgraphEnteringTransition = SubgraphEnteringTransition;
	transition.subgraphEnteringTransition = new SubgraphEnteringTransition();

	var structuralSubtyping = {};

	Object.defineProperty(structuralSubtyping, "__esModule", { value: true });
	structuralSubtyping.isStructuralFieldSubtype = structuralSubtyping.isStructuralInputSubType = void 0;
	const federation_internals_1$7 = dist$2;
	function typeComparison(t1, t2, typeTest, test) {
	    if (typeTest(t1)) {
	        return typeTest(t2) ? test(t1, t2) : false;
	    }
	    return typeTest(t2) ? false : undefined;
	}
	function isSubset(set, maybeSubset) {
	    return maybeSubset.every(v => set.includes(v));
	}
	function isAccessible(element) {
	    return element.hasAppliedDirective('inaccessible');
	}
	function accessibleEnumValues(enumType) {
	    return enumType
	        .values
	        .filter(v => isAccessible(v))
	        .map(v => v.name);
	}
	function isEnumInputSubtype(enumType, maybeSubType) {
	    if (enumType.name != maybeSubType.name) {
	        return false;
	    }
	    return isSubset(accessibleEnumValues(maybeSubType), accessibleEnumValues(enumType));
	}
	function isObjectInputSubtype(objectInputType, maybeSubType) {
	    if (objectInputType.name != maybeSubType.name) {
	        return false;
	    }
	    return maybeSubType.fields()
	        .filter(isAccessible)
	        .every(subtypeField => {
	        const field = objectInputType.field(subtypeField.name);
	        return field && isAccessible(field) ? isStructuralInputSubType(field.type, subtypeField.type) : false;
	    });
	}
	function isStructuralInputSubType(inputType, maybeSubType) {
	    if ((0, federation_internals_1$7.isNonNullType)(inputType)) {
	        return (0, federation_internals_1$7.isNonNullType)(maybeSubType) ? isStructuralInputSubType(inputType.ofType, maybeSubType.ofType) : false;
	    }
	    if ((0, federation_internals_1$7.isNonNullType)(maybeSubType)) {
	        return isStructuralInputSubType(inputType, maybeSubType.ofType);
	    }
	    let c = typeComparison(inputType, maybeSubType, federation_internals_1$7.isListType, (l1, l2) => isStructuralInputSubType(l1.ofType, l2.ofType));
	    if (c != undefined) {
	        return c;
	    }
	    c = typeComparison(inputType, maybeSubType, federation_internals_1$7.isScalarType, (l1, l2) => l1.name == l2.name);
	    if (c != undefined) {
	        return c;
	    }
	    c = typeComparison(inputType, maybeSubType, federation_internals_1$7.isEnumType, (l1, l2) => isEnumInputSubtype(l1, l2));
	    if (c != undefined) {
	        return c;
	    }
	    c = typeComparison(inputType, maybeSubType, federation_internals_1$7.isInputObjectType, (l1, l2) => isObjectInputSubtype(l1, l2));
	    return c !== null && c !== void 0 ? c : false;
	}
	structuralSubtyping.isStructuralInputSubType = isStructuralInputSubType;
	function getArg(field, argName) {
	    const arg = field.argument(argName);
	    return arg && isAccessible(arg) ? arg : undefined;
	}
	function isStructuralFieldSubtype(fieldDef, maybeSubType, allowedRules = federation_internals_1$7.DEFAULT_SUBTYPING_RULES, unionMembershipTester = (u, m) => u.hasTypeMember(m), implementsInterfaceTester = (m, i) => m.implementsInterface(i)) {
	    if (fieldDef.name !== maybeSubType.name) {
	        return false;
	    }
	    if (!(0, federation_internals_1$7.isSubtype)(maybeSubType.type, fieldDef.type, allowedRules, unionMembershipTester, implementsInterfaceTester)) {
	        return false;
	    }
	    for (const argDef of maybeSubType.arguments().filter(isAccessible)) {
	        const providedArgDef = getArg(fieldDef, argDef.name);
	        if (!providedArgDef || !isStructuralInputSubType(providedArgDef.type, argDef.type)) {
	            return false;
	        }
	    }
	    return true;
	}
	structuralSubtyping.isStructuralFieldSubtype = isStructuralFieldSubtype;

	Object.defineProperty(querygraph, "__esModule", { value: true });
	querygraph.simpleTraversal = querygraph.buildFederatedQueryGraph = querygraph.buildSupergraphAPIQueryGraph = querygraph.buildQueryGraph = querygraph.QueryGraphState = querygraph.QueryGraph = querygraph.Edge = querygraph.isRootVertex = querygraph.RootVertex = querygraph.Vertex = querygraph.isFederatedGraphRootType = querygraph.federatedGraphRootTypeName = void 0;
	const federation_internals_1$6 = dist$2;
	const util_1 = require$$0$1;
	const transition_1 = transition;
	const structuralSubtyping_1 = structuralSubtyping;
	const FEDERATED_GRAPH_ROOT_SOURCE = federation_internals_1$6.FEDERATION_RESERVED_SUBGRAPH_NAME;
	const FEDERATED_GRAPH_ROOT_SCHEMA = new federation_internals_1$6.Schema();
	function federatedGraphRootTypeName(rootKind) {
	    return `[${rootKind}]`;
	}
	querygraph.federatedGraphRootTypeName = federatedGraphRootTypeName;
	function isFederatedGraphRootType(type) {
	    return type.name.startsWith('[') && type.name.endsWith(']');
	}
	querygraph.isFederatedGraphRootType = isFederatedGraphRootType;
	class Vertex {
	    constructor(index, type, source) {
	        this.index = index;
	        this.type = type;
	        this.source = source;
	    }
	    toString() {
	        return `${this.type}(${this.source})`;
	    }
	}
	querygraph.Vertex = Vertex;
	class RootVertex extends Vertex {
	    constructor(rootKind, index, type, source) {
	        super(index, type, source);
	        this.rootKind = rootKind;
	    }
	    toString() {
	        return super.toString() + '*';
	    }
	}
	querygraph.RootVertex = RootVertex;
	function toRootVertex(vertex, rootKind) {
	    return new RootVertex(rootKind, vertex.index, vertex.type, vertex.source);
	}
	function isRootVertex(vertex) {
	    return vertex instanceof RootVertex;
	}
	querygraph.isRootVertex = isRootVertex;
	class Edge {
	    constructor(index, head, tail, transition, conditions) {
	        this.index = index;
	        this.head = head;
	        this.tail = tail;
	        this.transition = transition;
	        this._conditions = conditions;
	    }
	    get conditions() {
	        return this._conditions;
	    }
	    isEdgeForField(name) {
	        return this.transition.kind === 'FieldCollection' && this.transition.definition.name === name;
	    }
	    matchesSupergraphTransition(supergraph, otherTransition) {
	        const transition = this.transition;
	        switch (transition.kind) {
	            case 'FieldCollection':
	                if (otherTransition.kind === 'FieldCollection') {
	                    return (0, structuralSubtyping_1.isStructuralFieldSubtype)(transition.definition, otherTransition.definition, federation_internals_1$6.ALL_SUBTYPING_RULES, (union, maybeMember) => supergraph.type(union.name).hasTypeMember(maybeMember.name), (maybeImplementer, itf) => supergraph.type(maybeImplementer.name).implementsInterface(itf));
	                }
	                else {
	                    return false;
	                }
	            case 'DownCast':
	                return otherTransition.kind === 'DownCast' && transition.castedType.name === otherTransition.castedType.name;
	            default:
	                return transition.kind === otherTransition.kind;
	        }
	    }
	    label() {
	        if (this.transition instanceof transition_1.SubgraphEnteringTransition && !this._conditions) {
	            return "";
	        }
	        return this._conditions ? `${this._conditions} ⊢ ${this.transition}` : this.transition.toString();
	    }
	    withNewHead(newHead) {
	        return new Edge(this.index, newHead, this.tail, this.transition, this._conditions);
	    }
	    addToConditions(newConditions) {
	        if (!this._conditions) {
	            this._conditions = new federation_internals_1$6.SelectionSet(this.head.type);
	        }
	        this._conditions.mergeIn(newConditions);
	    }
	    toString() {
	        return `${this.head} -> ${this.tail} (${this.label()})`;
	    }
	}
	querygraph.Edge = Edge;
	class QueryGraph {
	    constructor(name, vertices, adjacencies, typesToVertices, rootVertices, sources) {
	        this.name = name;
	        this.vertices = vertices;
	        this.adjacencies = adjacencies;
	        this.typesToVertices = typesToVertices;
	        this.rootVertices = rootVertices;
	        this.sources = sources;
	    }
	    verticesCount() {
	        return this.vertices.length;
	    }
	    edgesCount() {
	        return this.adjacencies.reduce((acc, v) => acc + v.length, 0);
	    }
	    rootKinds() {
	        return this.rootVertices.keys();
	    }
	    roots() {
	        return this.rootVertices.values();
	    }
	    root(kind) {
	        return this.rootVertices.get(kind);
	    }
	    outEdges(vertex) {
	        return this.adjacencies[vertex.index];
	    }
	    outEdge(vertex, edgeIndex) {
	        return this.adjacencies[vertex.index][edgeIndex];
	    }
	    isTerminal(vertex) {
	        return this.outEdges(vertex).length == 0;
	    }
	    verticesForType(typeName) {
	        const indexes = this.typesToVertices.get(typeName);
	        return indexes == undefined ? [] : indexes.map(i => this.vertices[i]);
	    }
	}
	querygraph.QueryGraph = QueryGraph;
	class QueryGraphState {
	    constructor(graph) {
	        this.graph = graph;
	        this.verticesStates = new Array(graph.verticesCount());
	        this.adjacenciesStates = new Array(graph.verticesCount());
	    }
	    setVertexState(vertex, state) {
	        this.verticesStates[vertex.index] = state;
	    }
	    removeVertexState(vertex) {
	        this.verticesStates[vertex.index] = undefined;
	    }
	    getVertexState(vertex) {
	        return this.verticesStates[vertex.index];
	    }
	    setEdgeState(edge, state) {
	        if (!this.adjacenciesStates[edge.head.index]) {
	            this.adjacenciesStates[edge.head.index] = new Array(this.graph.outEdges(edge.head).length);
	        }
	        this.adjacenciesStates[edge.head.index][edge.index] = state;
	    }
	    removeEdgeState(edge) {
	        this.adjacenciesStates[edge.head.index][edge.index] = undefined;
	    }
	    getEdgeState(edge) {
	        const forEdge = this.adjacenciesStates[edge.head.index];
	        return forEdge ? forEdge[edge.index] : undefined;
	    }
	    toDebugString(vertexMapper, edgeMapper) {
	        const vs = this.verticesStates.map((state, idx) => ` ${idx}: ${!state ? "<null>" : vertexMapper(state)}`).join("\n");
	        const es = this.adjacenciesStates.map((adj, vIdx) => adj.map((state, eIdx) => ` ${vIdx}[${eIdx}]: ${!state ? "<null>" : edgeMapper(state)}`).join("\n")).join("\n");
	        return `vertices = {${vs}\n}, edges = {${es}\n}`;
	    }
	}
	querygraph.QueryGraphState = QueryGraphState;
	function buildQueryGraph(name, schema) {
	    return buildGraphInternal(name, schema, false);
	}
	querygraph.buildQueryGraph = buildQueryGraph;
	function buildGraphInternal(name, schema, addAdditionalAbstractTypeEdges, supergraphSchema) {
	    const builder = new GraphBuilderFromSchema(name, schema, supergraphSchema);
	    for (const rootType of schema.schemaDefinition.roots()) {
	        builder.addRecursivelyFromRoot(rootType.rootKind, rootType.type);
	    }
	    if (addAdditionalAbstractTypeEdges) {
	        builder.addAdditionalAbstractTypeEdges();
	    }
	    return builder.build();
	}
	function buildSupergraphAPIQueryGraph(supergraph) {
	    return buildQueryGraph("supergraph", supergraph);
	}
	querygraph.buildSupergraphAPIQueryGraph = buildSupergraphAPIQueryGraph;
	function buildFederatedQueryGraph(supergraph, forQueryPlanning) {
	    const subgraphs = (0, federation_internals_1$6.extractSubgraphsFromSupergraph)(supergraph);
	    let graphs = [];
	    for (let subgraph of subgraphs) {
	        graphs.push(buildGraphInternal(subgraph.name, subgraph.schema, forQueryPlanning, supergraph));
	    }
	    return federateSubgraphs(graphs);
	}
	querygraph.buildFederatedQueryGraph = buildFederatedQueryGraph;
	function federatedProperties(subgraphs) {
	    let vertices = 0;
	    const rootKinds = new Set();
	    const schemas = [];
	    for (let subgraph of subgraphs) {
	        vertices += subgraph.verticesCount();
	        subgraph.rootKinds().forEach(k => rootKinds.add(k));
	        (0, federation_internals_1$6.assert)(subgraph.sources.size === 1, () => `Subgraphs should only have one sources, got ${subgraph.sources.size} ([${(0, federation_internals_1$6.mapKeys)(subgraph.sources).join(', ')}])`);
	        schemas.push((0, federation_internals_1$6.firstOf)(subgraph.sources.values()));
	    }
	    return [vertices + rootKinds.size, rootKinds, schemas];
	}
	function federateSubgraphs(subgraphs) {
	    const [verticesCount, rootKinds, schemas] = federatedProperties(subgraphs);
	    const builder = new GraphBuilder(verticesCount);
	    rootKinds.forEach(k => builder.createRootVertex(k, new federation_internals_1$6.ObjectType(federatedGraphRootTypeName(k)), FEDERATED_GRAPH_ROOT_SOURCE, FEDERATED_GRAPH_ROOT_SCHEMA));
	    const copyPointers = new Array(subgraphs.length);
	    for (let [i, subgraph] of subgraphs.entries()) {
	        copyPointers[i] = builder.copyGraph(subgraph);
	    }
	    for (let [i, subgraph] of subgraphs.entries()) {
	        const copyPointer = copyPointers[i];
	        subgraph.rootKinds().forEach(k => builder.addEdge(builder.root(k), copyPointer.copiedVertex(subgraph.root(k)), transition_1.subgraphEnteringTransition));
	        const queryRoot = subgraph.root("query");
	        if (queryRoot) {
	            for (let [j, otherSubgraph] of subgraphs.entries()) {
	                if (i === j) {
	                    continue;
	                }
	                const otherQueryRoot = otherSubgraph.root("query");
	                if (otherQueryRoot) {
	                    const otherCopyPointer = copyPointers[j];
	                    builder.addEdge(copyPointer.copiedVertex(queryRoot), otherCopyPointer.copiedVertex(otherQueryRoot), new transition_1.QueryResolution());
	                }
	            }
	        }
	    }
	    for (let [i, subgraph] of subgraphs.entries()) {
	        const subgraphSchema = schemas[i];
	        const keyDirective = federation_internals_1$6.federationBuiltIns.keyDirective(subgraphSchema);
	        const requireDirective = federation_internals_1$6.federationBuiltIns.requiresDirective(subgraphSchema);
	        simpleTraversal(subgraph, v => {
	            const type = v.type;
	            for (const keyApplication of type.appliedDirectivesOf(keyDirective)) {
	                (0, federation_internals_1$6.assert)((0, federation_internals_1$6.isInterfaceType)(type) || (0, federation_internals_1$6.isObjectType)(type), () => `Invalid "@key" application on non Object || Interface type "${type}"`);
	                const conditions = (0, federation_internals_1$6.parseFieldSetArgument)(type, keyApplication);
	                for (let [j, otherSubgraph] of subgraphs.entries()) {
	                    if (i == j) {
	                        continue;
	                    }
	                    const otherVertices = otherSubgraph.verticesForType(type.name);
	                    if (otherVertices.length == 0) {
	                        continue;
	                    }
	                    (0, federation_internals_1$6.assert)(otherVertices.length == 1, () => `Subgraph ${j} should have a single vertex for type ${type.name} but got ${otherVertices.length}: ${(0, util_1.inspect)(otherVertices)}`);
	                    const head = copyPointers[j].copiedVertex(otherVertices[0]);
	                    const tail = copyPointers[i].copiedVertex(v);
	                    builder.addEdge(head, tail, new transition_1.KeyResolution(), conditions);
	                }
	            }
	        }, e => {
	            if (e.transition.kind === 'FieldCollection') {
	                const type = e.head.type;
	                const field = e.transition.definition;
	                (0, federation_internals_1$6.assert)((0, federation_internals_1$6.isCompositeType)(type), () => `Non composite type "${type}" should not have field collection edge ${e}`);
	                for (const requiresApplication of field.appliedDirectivesOf(requireDirective)) {
	                    const conditions = (0, federation_internals_1$6.parseFieldSetArgument)(type, requiresApplication);
	                    const head = copyPointers[i].copiedVertex(e.head);
	                    const copiedEdge = builder.edge(head, e.index);
	                    copiedEdge.addToConditions(conditions);
	                }
	            }
	            return true;
	        });
	    }
	    for (let [i, subgraph] of subgraphs.entries()) {
	        const subgraphSchema = schemas[i];
	        const providesDirective = federation_internals_1$6.federationBuiltIns.providesDirective(subgraphSchema);
	        simpleTraversal(subgraph, _ => { }, e => {
	            if (e.transition.kind === 'FieldCollection') {
	                const type = e.head.type;
	                const field = e.transition.definition;
	                (0, federation_internals_1$6.assert)((0, federation_internals_1$6.isCompositeType)(type), () => `Non composite type "${type}" should not have field collection edge ${e}`);
	                for (const providesApplication of field.appliedDirectivesOf(providesDirective)) {
	                    const fieldType = (0, federation_internals_1$6.baseType)(field.type);
	                    (0, federation_internals_1$6.assert)((0, federation_internals_1$6.isInterfaceType)(fieldType) || (0, federation_internals_1$6.isObjectType)(fieldType), () => `Invalid @provide on field "${field}" whose type "${fieldType}" is not an object or interface`);
	                    const provided = (0, federation_internals_1$6.parseFieldSetArgument)(fieldType, providesApplication);
	                    const head = copyPointers[i].copiedVertex(e.head);
	                    const tail = copyPointers[i].copiedVertex(e.tail);
	                    const copiedEdge = builder.edge(head, e.index);
	                    const copiedTail = builder.makeCopy(tail);
	                    builder.updateEdgeTail(copiedEdge, copiedTail);
	                    addProvidesEdges(subgraphSchema, builder, copiedTail, provided);
	                }
	            }
	            return true;
	        });
	    }
	    return builder.build(FEDERATED_GRAPH_ROOT_SOURCE);
	}
	function addProvidesEdges(schema, builder, from, provided) {
	    const stack = [[from, provided]];
	    const source = from.source;
	    while (stack.length > 0) {
	        const [v, selectionSet] = stack.pop();
	        for (const selection of selectionSet.selections(true)) {
	            const element = selection.element();
	            if (element.kind == 'Field') {
	                const fieldDef = element.definition;
	                if (!fieldDef.hasAppliedDirective(federation_internals_1$6.externalDirectiveName)) {
	                    continue;
	                }
	                const fieldType = (0, federation_internals_1$6.baseType)(fieldDef.type);
	                if (selection.selectionSet) {
	                    const newVertex = builder.createNewVertex(fieldType, source, schema);
	                    builder.addEdge(v, newVertex, new transition_1.FieldCollection(fieldDef));
	                    stack.push([newVertex, selection.selectionSet]);
	                }
	                else {
	                    const existing = builder.verticesForType(fieldType.name).find(v => v.source === source);
	                    const vertex = existing ? existing : builder.createNewVertex(fieldType, v.source, schema);
	                    builder.addEdge(v, vertex, new transition_1.FieldCollection(fieldDef));
	                }
	            }
	            else {
	                const typeCondition = element.typeCondition;
	                let newVertex = v;
	                if (typeCondition) {
	                    newVertex = builder.createNewVertex(typeCondition, source, schema);
	                    builder.addEdge(v, newVertex, new transition_1.DownCast(element.parentType, typeCondition));
	                }
	                stack.push([newVertex, selection.selectionSet]);
	            }
	        }
	    }
	}
	class GraphBuilder {
	    constructor(verticesCount) {
	        this.nextIndex = 0;
	        this.typesToVertices = new federation_internals_1$6.MultiMap();
	        this.rootVertices = new federation_internals_1$6.MapWithCachedArrays();
	        this.sources = new Map();
	        this.vertices = verticesCount ? new Array(verticesCount) : [];
	        this.adjacencies = verticesCount ? new Array(verticesCount) : [];
	    }
	    verticesForType(typeName) {
	        const indexes = this.typesToVertices.get(typeName);
	        return indexes == undefined ? [] : indexes.map(i => this.vertices[i]);
	    }
	    root(kind) {
	        return this.rootVertices.get(kind);
	    }
	    addEdge(head, tail, transition, conditions) {
	        const edges = this.adjacencies[head.index];
	        const edge = new Edge(edges.length, head, tail, transition, conditions);
	        edges.push(edge);
	    }
	    createNewVertex(type, source, schema, index) {
	        if (!index) {
	            index = this.nextIndex++;
	        }
	        const vertex = new Vertex(index, type, source);
	        const previous = this.vertices[index];
	        (0, federation_internals_1$6.assert)(!previous, () => `Overriding existing vertex ${previous} with ${vertex}`);
	        this.vertices[index] = vertex;
	        this.typesToVertices.add(type.name, index);
	        this.adjacencies[index] = [];
	        if (!this.sources.has(source)) {
	            this.sources.set(source, schema);
	        }
	        return vertex;
	    }
	    createRootVertex(kind, type, source, schema) {
	        const vertex = this.createNewVertex(type, source, schema);
	        (0, federation_internals_1$6.assert)(!this.rootVertices.has(kind), () => `Root vertex for ${kind} (${this.rootVertices.get(kind)}) already exists: cannot replace by ${vertex}`);
	        this.setAsRoot(kind, vertex.index);
	    }
	    setAsRoot(kind, index) {
	        const vertex = this.vertices[index];
	        (0, federation_internals_1$6.assert)(vertex, () => `Cannot set non-existing vertex at index ${index} as root ${kind}`);
	        const rootVertex = toRootVertex(vertex, kind);
	        this.vertices[vertex.index] = rootVertex;
	        this.rootVertices.set(kind, rootVertex);
	        const rootEdges = this.adjacencies[vertex.index];
	        for (let i = 0; i < rootEdges.length; i++) {
	            rootEdges[i] = rootEdges[i].withNewHead(rootVertex);
	        }
	    }
	    copyGraph(graph) {
	        const offset = this.nextIndex;
	        simpleTraversal(graph, v => {
	            this.getOrCopyVertex(v, offset, graph);
	        }, e => {
	            const newHead = this.getOrCopyVertex(e.head, offset, graph);
	            const newTail = this.getOrCopyVertex(e.tail, offset, graph);
	            this.addEdge(newHead, newTail, e.transition, e.conditions);
	            return true;
	        });
	        this.nextIndex += graph.verticesCount();
	        const that = this;
	        return {
	            copiedVertex(original) {
	                const vertex = that.vertices[original.index + offset];
	                (0, federation_internals_1$6.assert)(vertex, () => `Vertex ${original} has no copy for offset ${offset}`);
	                return vertex;
	            }
	        };
	    }
	    vertex(index) {
	        return this.vertices[index];
	    }
	    edge(head, index) {
	        return this.adjacencies[head.index][index];
	    }
	    makeCopy(vertex) {
	        const newVertex = this.createNewVertex(vertex.type, vertex.source, this.sources.get(vertex.source));
	        for (const edge of this.adjacencies[vertex.index]) {
	            this.addEdge(newVertex, edge.tail, edge.transition, edge.conditions);
	        }
	        return newVertex;
	    }
	    updateEdgeTail(edge, newTail) {
	        const newEdge = new Edge(edge.index, edge.head, newTail, edge.transition, edge.conditions);
	        this.adjacencies[edge.head.index][edge.index] = newEdge;
	        return newEdge;
	    }
	    getOrCopyVertex(toCopy, indexOffset, graph) {
	        const index = toCopy.index + indexOffset;
	        let v = this.vertices[index];
	        if (!v) {
	            v = this.createNewVertex(toCopy.type, toCopy.source, graph.sources.get(toCopy.source), index);
	        }
	        return v;
	    }
	    build(name) {
	        return new QueryGraph(name, this.vertices, this.adjacencies, this.typesToVertices, this.rootVertices, this.sources);
	    }
	}
	class GraphBuilderFromSchema extends GraphBuilder {
	    constructor(name, schema, supergraphSchema) {
	        super();
	        this.name = name;
	        this.schema = schema;
	        this.supergraphSchema = supergraphSchema;
	        this.isFederatedSubgraph = (0, federation_internals_1$6.isFederationSubgraphSchema)(schema);
	        (0, federation_internals_1$6.assert)(!this.isFederatedSubgraph || supergraphSchema, `Missing supergraph schema for building the federated subgraph graph`);
	        this.forceTypeExplosion = supergraphSchema !== undefined && (0, federation_internals_1$6.isFed1Supergraph)(supergraphSchema);
	    }
	    addRecursivelyFromRoot(kind, root) {
	        this.setAsRoot(kind, this.addTypeRecursively(root).index);
	    }
	    addTypeRecursively(type) {
	        const namedType = (0, federation_internals_1$6.baseType)(type);
	        const existing = this.verticesForType(namedType.name);
	        if (existing.length > 0) {
	            (0, federation_internals_1$6.assert)(existing.length == 1, () => `Only one vertex should have been created for type ${namedType.name}, got ${existing.length}: ${(0, util_1.inspect)(this)}`);
	            return existing[0];
	        }
	        const vertex = this.createNewVertex(namedType, this.name, this.schema);
	        if ((0, federation_internals_1$6.isObjectType)(namedType)) {
	            this.addObjectTypeEdges(namedType, vertex);
	        }
	        else if ((0, federation_internals_1$6.isInterfaceType)(namedType)) {
	            if (this.isFederatedSubgraph && !this.forceTypeExplosion) {
	                this.maybeAddInterfaceFieldsEdges(namedType, vertex);
	            }
	            this.addAbstractTypeEdges(namedType, vertex);
	        }
	        else if ((0, federation_internals_1$6.isUnionType)(namedType)) {
	            this.addEdgeForField(namedType.typenameField(), vertex);
	            this.addAbstractTypeEdges(namedType, vertex);
	        }
	        return vertex;
	    }
	    addObjectTypeEdges(type, head) {
	        for (const field of type.allFields()) {
	            if (field.isSchemaIntrospectionField() || field.hasAppliedDirective(federation_internals_1$6.externalDirectiveName)) {
	                continue;
	            }
	            this.addEdgeForField(field, head);
	        }
	    }
	    addEdgeForField(field, head) {
	        const tail = this.addTypeRecursively(field.type);
	        this.addEdge(head, tail, new transition_1.FieldCollection(field));
	    }
	    isDirectlyProvidedByType(type, fieldName) {
	        const field = type.field(fieldName);
	        return field && !field.hasAppliedDirective(federation_internals_1$6.externalDirectiveName) && !field.hasAppliedDirective(federation_internals_1$6.requiresDirectiveName);
	    }
	    maybeAddInterfaceFieldsEdges(type, head) {
	        (0, federation_internals_1$6.assert)(this.supergraphSchema, 'Missing supergraph schema when building a subgraph');
	        const supergraphType = this.supergraphSchema.type(type.name);
	        if (!supergraphType) {
	            return;
	        }
	        const supergraphRuntimeTypes = supergraphType.possibleRuntimeTypes().map(t => t.name);
	        const localRuntimeTypes = supergraphRuntimeTypes.map(t => this.schema.type(t)).filter(t => t !== undefined);
	        for (const field of type.allFields()) {
	            if (field.hasAppliedDirective(federation_internals_1$6.externalDirectiveName) || localRuntimeTypes.some(t => !this.isDirectlyProvidedByType(t, field.name))) {
	                continue;
	            }
	            this.addEdgeForField(field, head);
	        }
	    }
	    addAbstractTypeEdges(type, head) {
	        const implementations = (0, federation_internals_1$6.isInterfaceType)(type) ? type.possibleRuntimeTypes() : type.types();
	        for (const implementationType of implementations) {
	            const tail = this.addTypeRecursively(implementationType);
	            this.addEdge(head, tail, new transition_1.DownCast(type, implementationType));
	        }
	    }
	    addAdditionalAbstractTypeEdges() {
	        const abstractTypesWithTheirRuntimeTypes = [];
	        for (const type of this.schema.types()) {
	            if ((0, federation_internals_1$6.isAbstractType)(type)) {
	                abstractTypesWithTheirRuntimeTypes.push([type, (0, federation_internals_1$6.possibleRuntimeTypes)(type)]);
	            }
	        }
	        for (let i = 0; i < abstractTypesWithTheirRuntimeTypes.length - 1; i++) {
	            const [t1, t1Runtimes] = abstractTypesWithTheirRuntimeTypes[i];
	            const t1Vertex = this.addTypeRecursively(t1);
	            for (let j = i; j < abstractTypesWithTheirRuntimeTypes.length; j++) {
	                const [t2, t2Runtimes] = abstractTypesWithTheirRuntimeTypes[j];
	                if ((0, federation_internals_1$6.isInterfaceType)(t1) && (0, federation_internals_1$6.isInterfaceType)(t2) && (t1.implementsInterface(t2) || t2.implementsInterface(t1))) {
	                    continue;
	                }
	                const intersecting = t1Runtimes.filter(o1 => t2Runtimes.includes(o1));
	                if (intersecting.length >= 2) {
	                    const t2Vertex = this.addTypeRecursively(t2);
	                    this.addEdge(t1Vertex, t2Vertex, new transition_1.DownCast(t1, t2));
	                    this.addEdge(t2Vertex, t1Vertex, new transition_1.DownCast(t2, t1));
	                }
	            }
	        }
	    }
	    build() {
	        return super.build(this.name);
	    }
	}
	function simpleTraversal(graph, onVertex, onEdges) {
	    const marked = new Array(graph.verticesCount());
	    const stack = [];
	    const maybeAdd = function (vertex) {
	        if (!marked[vertex.index]) {
	            stack.push(vertex);
	            marked[vertex.index] = true;
	        }
	    };
	    graph.roots().forEach(maybeAdd);
	    while (stack.length > 0) {
	        const vertex = stack.pop();
	        onVertex(vertex);
	        for (const edge of graph.outEdges(vertex)) {
	            const shouldTraverse = onEdges(edge);
	            if (shouldTraverse) {
	                maybeAdd(edge.tail);
	            }
	        }
	    }
	}
	querygraph.simpleTraversal = simpleTraversal;

	var graphPath = {};

	var pathTree = {};

	var pathContext = {};

	var toStr$8 = Object.prototype.toString;

	var isArguments$2 = function isArguments(value) {
		var str = toStr$8.call(value);
		var isArgs = str === '[object Arguments]';
		if (!isArgs) {
			isArgs = str !== '[object Array]' &&
				value !== null &&
				typeof value === 'object' &&
				typeof value.length === 'number' &&
				value.length >= 0 &&
				toStr$8.call(value.callee) === '[object Function]';
		}
		return isArgs;
	};

	var keysShim$1;
	if (!Object.keys) {
		// modified from https://github.com/es-shims/es5-shim
		var has$2 = Object.prototype.hasOwnProperty;
		var toStr$7 = Object.prototype.toString;
		var isArgs$1 = isArguments$2; // eslint-disable-line global-require
		var isEnumerable$1 = Object.prototype.propertyIsEnumerable;
		var hasDontEnumBug = !isEnumerable$1.call({ toString: null }, 'toString');
		var hasProtoEnumBug = isEnumerable$1.call(function () {}, 'prototype');
		var dontEnums = [
			'toString',
			'toLocaleString',
			'valueOf',
			'hasOwnProperty',
			'isPrototypeOf',
			'propertyIsEnumerable',
			'constructor'
		];
		var equalsConstructorPrototype = function (o) {
			var ctor = o.constructor;
			return ctor && ctor.prototype === o;
		};
		var excludedKeys = {
			$applicationCache: true,
			$console: true,
			$external: true,
			$frame: true,
			$frameElement: true,
			$frames: true,
			$innerHeight: true,
			$innerWidth: true,
			$onmozfullscreenchange: true,
			$onmozfullscreenerror: true,
			$outerHeight: true,
			$outerWidth: true,
			$pageXOffset: true,
			$pageYOffset: true,
			$parent: true,
			$scrollLeft: true,
			$scrollTop: true,
			$scrollX: true,
			$scrollY: true,
			$self: true,
			$webkitIndexedDB: true,
			$webkitStorageInfo: true,
			$window: true
		};
		var hasAutomationEqualityBug = (function () {
			/* global window */
			if (typeof window === 'undefined') { return false; }
			for (var k in window) {
				try {
					if (!excludedKeys['$' + k] && has$2.call(window, k) && window[k] !== null && typeof window[k] === 'object') {
						try {
							equalsConstructorPrototype(window[k]);
						} catch (e) {
							return true;
						}
					}
				} catch (e) {
					return true;
				}
			}
			return false;
		}());
		var equalsConstructorPrototypeIfNotBuggy = function (o) {
			/* global window */
			if (typeof window === 'undefined' || !hasAutomationEqualityBug) {
				return equalsConstructorPrototype(o);
			}
			try {
				return equalsConstructorPrototype(o);
			} catch (e) {
				return false;
			}
		};

		keysShim$1 = function keys(object) {
			var isObject = object !== null && typeof object === 'object';
			var isFunction = toStr$7.call(object) === '[object Function]';
			var isArguments = isArgs$1(object);
			var isString = isObject && toStr$7.call(object) === '[object String]';
			var theKeys = [];

			if (!isObject && !isFunction && !isArguments) {
				throw new TypeError('Object.keys called on a non-object');
			}

			var skipProto = hasProtoEnumBug && isFunction;
			if (isString && object.length > 0 && !has$2.call(object, 0)) {
				for (var i = 0; i < object.length; ++i) {
					theKeys.push(String(i));
				}
			}

			if (isArguments && object.length > 0) {
				for (var j = 0; j < object.length; ++j) {
					theKeys.push(String(j));
				}
			} else {
				for (var name in object) {
					if (!(skipProto && name === 'prototype') && has$2.call(object, name)) {
						theKeys.push(String(name));
					}
				}
			}

			if (hasDontEnumBug) {
				var skipConstructor = equalsConstructorPrototypeIfNotBuggy(object);

				for (var k = 0; k < dontEnums.length; ++k) {
					if (!(skipConstructor && dontEnums[k] === 'constructor') && has$2.call(object, dontEnums[k])) {
						theKeys.push(dontEnums[k]);
					}
				}
			}
			return theKeys;
		};
	}
	var implementation$b = keysShim$1;

	var slice$1 = Array.prototype.slice;
	var isArgs = isArguments$2;

	var origKeys = Object.keys;
	var keysShim = origKeys ? function keys(o) { return origKeys(o); } : implementation$b;

	var originalKeys = Object.keys;

	keysShim.shim = function shimObjectKeys() {
		if (Object.keys) {
			var keysWorksWithArguments = (function () {
				// Safari 5.0 bug
				var args = Object.keys(arguments);
				return args && args.length === arguments.length;
			}(1, 2));
			if (!keysWorksWithArguments) {
				Object.keys = function keys(object) { // eslint-disable-line func-name-matching
					if (isArgs(object)) {
						return originalKeys(slice$1.call(object));
					}
					return originalKeys(object);
				};
			}
		} else {
			Object.keys = keysShim;
		}
		return Object.keys || keysShim;
	};

	var objectKeys$1 = keysShim;

	/* eslint complexity: [2, 18], max-statements: [2, 33] */
	var shams = function hasSymbols() {
		if (typeof Symbol !== 'function' || typeof Object.getOwnPropertySymbols !== 'function') { return false; }
		if (typeof Symbol.iterator === 'symbol') { return true; }

		var obj = {};
		var sym = Symbol('test');
		var symObj = Object(sym);
		if (typeof sym === 'string') { return false; }

		if (Object.prototype.toString.call(sym) !== '[object Symbol]') { return false; }
		if (Object.prototype.toString.call(symObj) !== '[object Symbol]') { return false; }

		// temp disabled per https://github.com/ljharb/object.assign/issues/17
		// if (sym instanceof Symbol) { return false; }
		// temp disabled per https://github.com/WebReflection/get-own-property-symbols/issues/4
		// if (!(symObj instanceof Symbol)) { return false; }

		// if (typeof Symbol.prototype.toString !== 'function') { return false; }
		// if (String(sym) !== Symbol.prototype.toString.call(sym)) { return false; }

		var symVal = 42;
		obj[sym] = symVal;
		for (sym in obj) { return false; } // eslint-disable-line no-restricted-syntax, no-unreachable-loop
		if (typeof Object.keys === 'function' && Object.keys(obj).length !== 0) { return false; }

		if (typeof Object.getOwnPropertyNames === 'function' && Object.getOwnPropertyNames(obj).length !== 0) { return false; }

		var syms = Object.getOwnPropertySymbols(obj);
		if (syms.length !== 1 || syms[0] !== sym) { return false; }

		if (!Object.prototype.propertyIsEnumerable.call(obj, sym)) { return false; }

		if (typeof Object.getOwnPropertyDescriptor === 'function') {
			var descriptor = Object.getOwnPropertyDescriptor(obj, sym);
			if (descriptor.value !== symVal || descriptor.enumerable !== true) { return false; }
		}

		return true;
	};

	var origSymbol = typeof Symbol !== 'undefined' && Symbol;
	var hasSymbolSham = shams;

	var hasSymbols$7 = function hasNativeSymbols() {
		if (typeof origSymbol !== 'function') { return false; }
		if (typeof Symbol !== 'function') { return false; }
		if (typeof origSymbol('foo') !== 'symbol') { return false; }
		if (typeof Symbol('bar') !== 'symbol') { return false; }

		return hasSymbolSham();
	};

	/* eslint no-invalid-this: 1 */

	var ERROR_MESSAGE = 'Function.prototype.bind called on incompatible ';
	var slice = Array.prototype.slice;
	var toStr$6 = Object.prototype.toString;
	var funcType = '[object Function]';

	var implementation$a = function bind(that) {
	    var target = this;
	    if (typeof target !== 'function' || toStr$6.call(target) !== funcType) {
	        throw new TypeError(ERROR_MESSAGE + target);
	    }
	    var args = slice.call(arguments, 1);

	    var bound;
	    var binder = function () {
	        if (this instanceof bound) {
	            var result = target.apply(
	                this,
	                args.concat(slice.call(arguments))
	            );
	            if (Object(result) === result) {
	                return result;
	            }
	            return this;
	        } else {
	            return target.apply(
	                that,
	                args.concat(slice.call(arguments))
	            );
	        }
	    };

	    var boundLength = Math.max(0, target.length - args.length);
	    var boundArgs = [];
	    for (var i = 0; i < boundLength; i++) {
	        boundArgs.push('$' + i);
	    }

	    bound = Function('binder', 'return function (' + boundArgs.join(',') + '){ return binder.apply(this,arguments); }')(binder);

	    if (target.prototype) {
	        var Empty = function Empty() {};
	        Empty.prototype = target.prototype;
	        bound.prototype = new Empty();
	        Empty.prototype = null;
	    }

	    return bound;
	};

	var implementation$9 = implementation$a;

	var functionBind = Function.prototype.bind || implementation$9;

	var bind$1 = functionBind;

	var src = bind$1.call(Function.call, Object.prototype.hasOwnProperty);

	var undefined$1;

	var $SyntaxError = SyntaxError;
	var $Function = Function;
	var $TypeError$3 = TypeError;

	// eslint-disable-next-line consistent-return
	var getEvalledConstructor = function (expressionSyntax) {
		try {
			return $Function('"use strict"; return (' + expressionSyntax + ').constructor;')();
		} catch (e) {}
	};

	var $gOPD$2 = Object.getOwnPropertyDescriptor;
	if ($gOPD$2) {
		try {
			$gOPD$2({}, '');
		} catch (e) {
			$gOPD$2 = null; // this is IE 8, which has a broken gOPD
		}
	}

	var throwTypeError = function () {
		throw new $TypeError$3();
	};
	var ThrowTypeError = $gOPD$2
		? (function () {
			try {
				// eslint-disable-next-line no-unused-expressions, no-caller, no-restricted-properties
				arguments.callee; // IE 8 does not throw here
				return throwTypeError;
			} catch (calleeThrows) {
				try {
					// IE 8 throws on Object.getOwnPropertyDescriptor(arguments, '')
					return $gOPD$2(arguments, 'callee').get;
				} catch (gOPDthrows) {
					return throwTypeError;
				}
			}
		}())
		: throwTypeError;

	var hasSymbols$6 = hasSymbols$7();

	var getProto$1 = Object.getPrototypeOf || function (x) { return x.__proto__; }; // eslint-disable-line no-proto

	var needsEval = {};

	var TypedArray = typeof Uint8Array === 'undefined' ? undefined$1 : getProto$1(Uint8Array);

	var INTRINSICS = {
		'%AggregateError%': typeof AggregateError === 'undefined' ? undefined$1 : AggregateError,
		'%Array%': Array,
		'%ArrayBuffer%': typeof ArrayBuffer === 'undefined' ? undefined$1 : ArrayBuffer,
		'%ArrayIteratorPrototype%': hasSymbols$6 ? getProto$1([][Symbol.iterator]()) : undefined$1,
		'%AsyncFromSyncIteratorPrototype%': undefined$1,
		'%AsyncFunction%': needsEval,
		'%AsyncGenerator%': needsEval,
		'%AsyncGeneratorFunction%': needsEval,
		'%AsyncIteratorPrototype%': needsEval,
		'%Atomics%': typeof Atomics === 'undefined' ? undefined$1 : Atomics,
		'%BigInt%': typeof BigInt === 'undefined' ? undefined$1 : BigInt,
		'%Boolean%': Boolean,
		'%DataView%': typeof DataView === 'undefined' ? undefined$1 : DataView,
		'%Date%': Date,
		'%decodeURI%': decodeURI,
		'%decodeURIComponent%': decodeURIComponent,
		'%encodeURI%': encodeURI,
		'%encodeURIComponent%': encodeURIComponent,
		'%Error%': Error,
		'%eval%': eval, // eslint-disable-line no-eval
		'%EvalError%': EvalError,
		'%Float32Array%': typeof Float32Array === 'undefined' ? undefined$1 : Float32Array,
		'%Float64Array%': typeof Float64Array === 'undefined' ? undefined$1 : Float64Array,
		'%FinalizationRegistry%': typeof FinalizationRegistry === 'undefined' ? undefined$1 : FinalizationRegistry,
		'%Function%': $Function,
		'%GeneratorFunction%': needsEval,
		'%Int8Array%': typeof Int8Array === 'undefined' ? undefined$1 : Int8Array,
		'%Int16Array%': typeof Int16Array === 'undefined' ? undefined$1 : Int16Array,
		'%Int32Array%': typeof Int32Array === 'undefined' ? undefined$1 : Int32Array,
		'%isFinite%': isFinite,
		'%isNaN%': isNaN,
		'%IteratorPrototype%': hasSymbols$6 ? getProto$1(getProto$1([][Symbol.iterator]())) : undefined$1,
		'%JSON%': typeof JSON === 'object' ? JSON : undefined$1,
		'%Map%': typeof Map === 'undefined' ? undefined$1 : Map,
		'%MapIteratorPrototype%': typeof Map === 'undefined' || !hasSymbols$6 ? undefined$1 : getProto$1(new Map()[Symbol.iterator]()),
		'%Math%': Math,
		'%Number%': Number,
		'%Object%': Object,
		'%parseFloat%': parseFloat,
		'%parseInt%': parseInt,
		'%Promise%': typeof Promise === 'undefined' ? undefined$1 : Promise,
		'%Proxy%': typeof Proxy === 'undefined' ? undefined$1 : Proxy,
		'%RangeError%': RangeError,
		'%ReferenceError%': ReferenceError,
		'%Reflect%': typeof Reflect === 'undefined' ? undefined$1 : Reflect,
		'%RegExp%': RegExp,
		'%Set%': typeof Set === 'undefined' ? undefined$1 : Set,
		'%SetIteratorPrototype%': typeof Set === 'undefined' || !hasSymbols$6 ? undefined$1 : getProto$1(new Set()[Symbol.iterator]()),
		'%SharedArrayBuffer%': typeof SharedArrayBuffer === 'undefined' ? undefined$1 : SharedArrayBuffer,
		'%String%': String,
		'%StringIteratorPrototype%': hasSymbols$6 ? getProto$1(''[Symbol.iterator]()) : undefined$1,
		'%Symbol%': hasSymbols$6 ? Symbol : undefined$1,
		'%SyntaxError%': $SyntaxError,
		'%ThrowTypeError%': ThrowTypeError,
		'%TypedArray%': TypedArray,
		'%TypeError%': $TypeError$3,
		'%Uint8Array%': typeof Uint8Array === 'undefined' ? undefined$1 : Uint8Array,
		'%Uint8ClampedArray%': typeof Uint8ClampedArray === 'undefined' ? undefined$1 : Uint8ClampedArray,
		'%Uint16Array%': typeof Uint16Array === 'undefined' ? undefined$1 : Uint16Array,
		'%Uint32Array%': typeof Uint32Array === 'undefined' ? undefined$1 : Uint32Array,
		'%URIError%': URIError,
		'%WeakMap%': typeof WeakMap === 'undefined' ? undefined$1 : WeakMap,
		'%WeakRef%': typeof WeakRef === 'undefined' ? undefined$1 : WeakRef,
		'%WeakSet%': typeof WeakSet === 'undefined' ? undefined$1 : WeakSet
	};

	var doEval = function doEval(name) {
		var value;
		if (name === '%AsyncFunction%') {
			value = getEvalledConstructor('async function () {}');
		} else if (name === '%GeneratorFunction%') {
			value = getEvalledConstructor('function* () {}');
		} else if (name === '%AsyncGeneratorFunction%') {
			value = getEvalledConstructor('async function* () {}');
		} else if (name === '%AsyncGenerator%') {
			var fn = doEval('%AsyncGeneratorFunction%');
			if (fn) {
				value = fn.prototype;
			}
		} else if (name === '%AsyncIteratorPrototype%') {
			var gen = doEval('%AsyncGenerator%');
			if (gen) {
				value = getProto$1(gen.prototype);
			}
		}

		INTRINSICS[name] = value;

		return value;
	};

	var LEGACY_ALIASES = {
		'%ArrayBufferPrototype%': ['ArrayBuffer', 'prototype'],
		'%ArrayPrototype%': ['Array', 'prototype'],
		'%ArrayProto_entries%': ['Array', 'prototype', 'entries'],
		'%ArrayProto_forEach%': ['Array', 'prototype', 'forEach'],
		'%ArrayProto_keys%': ['Array', 'prototype', 'keys'],
		'%ArrayProto_values%': ['Array', 'prototype', 'values'],
		'%AsyncFunctionPrototype%': ['AsyncFunction', 'prototype'],
		'%AsyncGenerator%': ['AsyncGeneratorFunction', 'prototype'],
		'%AsyncGeneratorPrototype%': ['AsyncGeneratorFunction', 'prototype', 'prototype'],
		'%BooleanPrototype%': ['Boolean', 'prototype'],
		'%DataViewPrototype%': ['DataView', 'prototype'],
		'%DatePrototype%': ['Date', 'prototype'],
		'%ErrorPrototype%': ['Error', 'prototype'],
		'%EvalErrorPrototype%': ['EvalError', 'prototype'],
		'%Float32ArrayPrototype%': ['Float32Array', 'prototype'],
		'%Float64ArrayPrototype%': ['Float64Array', 'prototype'],
		'%FunctionPrototype%': ['Function', 'prototype'],
		'%Generator%': ['GeneratorFunction', 'prototype'],
		'%GeneratorPrototype%': ['GeneratorFunction', 'prototype', 'prototype'],
		'%Int8ArrayPrototype%': ['Int8Array', 'prototype'],
		'%Int16ArrayPrototype%': ['Int16Array', 'prototype'],
		'%Int32ArrayPrototype%': ['Int32Array', 'prototype'],
		'%JSONParse%': ['JSON', 'parse'],
		'%JSONStringify%': ['JSON', 'stringify'],
		'%MapPrototype%': ['Map', 'prototype'],
		'%NumberPrototype%': ['Number', 'prototype'],
		'%ObjectPrototype%': ['Object', 'prototype'],
		'%ObjProto_toString%': ['Object', 'prototype', 'toString'],
		'%ObjProto_valueOf%': ['Object', 'prototype', 'valueOf'],
		'%PromisePrototype%': ['Promise', 'prototype'],
		'%PromiseProto_then%': ['Promise', 'prototype', 'then'],
		'%Promise_all%': ['Promise', 'all'],
		'%Promise_reject%': ['Promise', 'reject'],
		'%Promise_resolve%': ['Promise', 'resolve'],
		'%RangeErrorPrototype%': ['RangeError', 'prototype'],
		'%ReferenceErrorPrototype%': ['ReferenceError', 'prototype'],
		'%RegExpPrototype%': ['RegExp', 'prototype'],
		'%SetPrototype%': ['Set', 'prototype'],
		'%SharedArrayBufferPrototype%': ['SharedArrayBuffer', 'prototype'],
		'%StringPrototype%': ['String', 'prototype'],
		'%SymbolPrototype%': ['Symbol', 'prototype'],
		'%SyntaxErrorPrototype%': ['SyntaxError', 'prototype'],
		'%TypedArrayPrototype%': ['TypedArray', 'prototype'],
		'%TypeErrorPrototype%': ['TypeError', 'prototype'],
		'%Uint8ArrayPrototype%': ['Uint8Array', 'prototype'],
		'%Uint8ClampedArrayPrototype%': ['Uint8ClampedArray', 'prototype'],
		'%Uint16ArrayPrototype%': ['Uint16Array', 'prototype'],
		'%Uint32ArrayPrototype%': ['Uint32Array', 'prototype'],
		'%URIErrorPrototype%': ['URIError', 'prototype'],
		'%WeakMapPrototype%': ['WeakMap', 'prototype'],
		'%WeakSetPrototype%': ['WeakSet', 'prototype']
	};

	var bind = functionBind;
	var hasOwn$3 = src;
	var $concat = bind.call(Function.call, Array.prototype.concat);
	var $spliceApply = bind.call(Function.apply, Array.prototype.splice);
	var $replace = bind.call(Function.call, String.prototype.replace);
	var $strSlice = bind.call(Function.call, String.prototype.slice);

	/* adapted from https://github.com/lodash/lodash/blob/4.17.15/dist/lodash.js#L6735-L6744 */
	var rePropName = /[^%.[\]]+|\[(?:(-?\d+(?:\.\d+)?)|(["'])((?:(?!\2)[^\\]|\\.)*?)\2)\]|(?=(?:\.|\[\])(?:\.|\[\]|%$))/g;
	var reEscapeChar = /\\(\\)?/g; /** Used to match backslashes in property paths. */
	var stringToPath = function stringToPath(string) {
		var first = $strSlice(string, 0, 1);
		var last = $strSlice(string, -1);
		if (first === '%' && last !== '%') {
			throw new $SyntaxError('invalid intrinsic syntax, expected closing `%`');
		} else if (last === '%' && first !== '%') {
			throw new $SyntaxError('invalid intrinsic syntax, expected opening `%`');
		}
		var result = [];
		$replace(string, rePropName, function (match, number, quote, subString) {
			result[result.length] = quote ? $replace(subString, reEscapeChar, '$1') : number || match;
		});
		return result;
	};
	/* end adaptation */

	var getBaseIntrinsic = function getBaseIntrinsic(name, allowMissing) {
		var intrinsicName = name;
		var alias;
		if (hasOwn$3(LEGACY_ALIASES, intrinsicName)) {
			alias = LEGACY_ALIASES[intrinsicName];
			intrinsicName = '%' + alias[0] + '%';
		}

		if (hasOwn$3(INTRINSICS, intrinsicName)) {
			var value = INTRINSICS[intrinsicName];
			if (value === needsEval) {
				value = doEval(intrinsicName);
			}
			if (typeof value === 'undefined' && !allowMissing) {
				throw new $TypeError$3('intrinsic ' + name + ' exists, but is not available. Please file an issue!');
			}

			return {
				alias: alias,
				name: intrinsicName,
				value: value
			};
		}

		throw new $SyntaxError('intrinsic ' + name + ' does not exist!');
	};

	var getIntrinsic = function GetIntrinsic(name, allowMissing) {
		if (typeof name !== 'string' || name.length === 0) {
			throw new $TypeError$3('intrinsic name must be a non-empty string');
		}
		if (arguments.length > 1 && typeof allowMissing !== 'boolean') {
			throw new $TypeError$3('"allowMissing" argument must be a boolean');
		}

		var parts = stringToPath(name);
		var intrinsicBaseName = parts.length > 0 ? parts[0] : '';

		var intrinsic = getBaseIntrinsic('%' + intrinsicBaseName + '%', allowMissing);
		var intrinsicRealName = intrinsic.name;
		var value = intrinsic.value;
		var skipFurtherCaching = false;

		var alias = intrinsic.alias;
		if (alias) {
			intrinsicBaseName = alias[0];
			$spliceApply(parts, $concat([0, 1], alias));
		}

		for (var i = 1, isOwn = true; i < parts.length; i += 1) {
			var part = parts[i];
			var first = $strSlice(part, 0, 1);
			var last = $strSlice(part, -1);
			if (
				(
					(first === '"' || first === "'" || first === '`')
					|| (last === '"' || last === "'" || last === '`')
				)
				&& first !== last
			) {
				throw new $SyntaxError('property names with quotes must have matching quotes');
			}
			if (part === 'constructor' || !isOwn) {
				skipFurtherCaching = true;
			}

			intrinsicBaseName += '.' + part;
			intrinsicRealName = '%' + intrinsicBaseName + '%';

			if (hasOwn$3(INTRINSICS, intrinsicRealName)) {
				value = INTRINSICS[intrinsicRealName];
			} else if (value != null) {
				if (!(part in value)) {
					if (!allowMissing) {
						throw new $TypeError$3('base intrinsic for ' + name + ' exists, but the property is not available.');
					}
					return void undefined$1;
				}
				if ($gOPD$2 && (i + 1) >= parts.length) {
					var desc = $gOPD$2(value, part);
					isOwn = !!desc;

					// By convention, when a data property is converted to an accessor
					// property to emulate a data property that does not suffer from
					// the override mistake, that accessor's getter is marked with
					// an `originalValue` property. Here, when we detect this, we
					// uphold the illusion by pretending to see that original data
					// property, i.e., returning the value rather than the getter
					// itself.
					if (isOwn && 'get' in desc && !('originalValue' in desc.get)) {
						value = desc.get;
					} else {
						value = value[part];
					}
				} else {
					isOwn = hasOwn$3(value, part);
					value = value[part];
				}

				if (isOwn && !skipFurtherCaching) {
					INTRINSICS[intrinsicRealName] = value;
				}
			}
		}
		return value;
	};

	var callBind$4 = {exports: {}};

	(function (module) {

	var bind = functionBind;
	var GetIntrinsic = getIntrinsic;

	var $apply = GetIntrinsic('%Function.prototype.apply%');
	var $call = GetIntrinsic('%Function.prototype.call%');
	var $reflectApply = GetIntrinsic('%Reflect.apply%', true) || bind.call($call, $apply);

	var $gOPD = GetIntrinsic('%Object.getOwnPropertyDescriptor%', true);
	var $defineProperty = GetIntrinsic('%Object.defineProperty%', true);
	var $max = GetIntrinsic('%Math.max%');

	if ($defineProperty) {
		try {
			$defineProperty({}, 'a', { value: 1 });
		} catch (e) {
			// IE 8 has a broken defineProperty
			$defineProperty = null;
		}
	}

	module.exports = function callBind(originalFunction) {
		var func = $reflectApply(bind, $call, arguments);
		if ($gOPD && $defineProperty) {
			var desc = $gOPD(func, 'length');
			if (desc.configurable) {
				// original length, plus the receiver, minus any additional arguments (after the receiver)
				$defineProperty(
					func,
					'length',
					{ value: 1 + $max(0, originalFunction.length - (arguments.length - 1)) }
				);
			}
		}
		return func;
	};

	var applyBind = function applyBind() {
		return $reflectApply(bind, $apply, arguments);
	};

	if ($defineProperty) {
		$defineProperty(module.exports, 'apply', { value: applyBind });
	} else {
		module.exports.apply = applyBind;
	}
	}(callBind$4));

	var GetIntrinsic$3 = getIntrinsic;

	var callBind$3 = callBind$4.exports;

	var $indexOf$1 = callBind$3(GetIntrinsic$3('String.prototype.indexOf'));

	var callBound$8 = function callBoundIntrinsic(name, allowMissing) {
		var intrinsic = GetIntrinsic$3(name, !!allowMissing);
		if (typeof intrinsic === 'function' && $indexOf$1(name, '.prototype.') > -1) {
			return callBind$3(intrinsic);
		}
		return intrinsic;
	};

	var hasToStringTag$7 = typeof Symbol === 'function' && typeof Symbol.toStringTag === 'symbol';
	var callBound$7 = callBound$8;

	var $toString$4 = callBound$7('Object.prototype.toString');

	var isStandardArguments = function isArguments(value) {
		if (hasToStringTag$7 && value && typeof value === 'object' && Symbol.toStringTag in value) {
			return false;
		}
		return $toString$4(value) === '[object Arguments]';
	};

	var isLegacyArguments = function isArguments(value) {
		if (isStandardArguments(value)) {
			return true;
		}
		return value !== null &&
			typeof value === 'object' &&
			typeof value.length === 'number' &&
			value.length >= 0 &&
			$toString$4(value) !== '[object Array]' &&
			$toString$4(value.callee) === '[object Function]';
	};

	var supportsStandardArguments = (function () {
		return isStandardArguments(arguments);
	}());

	isStandardArguments.isLegacyArguments = isLegacyArguments; // for tests

	var isArguments$1 = supportsStandardArguments ? isStandardArguments : isLegacyArguments;

	var keys$1 = objectKeys$1;
	var hasSymbols$5 = typeof Symbol === 'function' && typeof Symbol('foo') === 'symbol';

	var toStr$5 = Object.prototype.toString;
	var concat = Array.prototype.concat;
	var origDefineProperty = Object.defineProperty;

	var isFunction = function (fn) {
		return typeof fn === 'function' && toStr$5.call(fn) === '[object Function]';
	};

	var arePropertyDescriptorsSupported = function () {
		var obj = {};
		try {
			origDefineProperty(obj, 'x', { enumerable: false, value: obj });
			// eslint-disable-next-line no-unused-vars, no-restricted-syntax
			for (var _ in obj) { // jscs:ignore disallowUnusedVariables
				return false;
			}
			return obj.x === obj;
		} catch (e) { /* this is IE 8. */
			return false;
		}
	};
	var supportsDescriptors$2 = origDefineProperty && arePropertyDescriptorsSupported();

	var defineProperty$1 = function (object, name, value, predicate) {
		if (name in object && (!isFunction(predicate) || !predicate())) {
			return;
		}
		if (supportsDescriptors$2) {
			origDefineProperty(object, name, {
				configurable: true,
				enumerable: false,
				value: value,
				writable: true
			});
		} else {
			object[name] = value;
		}
	};

	var defineProperties$1 = function (object, map) {
		var predicates = arguments.length > 2 ? arguments[2] : {};
		var props = keys$1(map);
		if (hasSymbols$5) {
			props = concat.call(props, Object.getOwnPropertySymbols(map));
		}
		for (var i = 0; i < props.length; i += 1) {
			defineProperty$1(object, props[i], map[props[i]], predicates[props[i]]);
		}
	};

	defineProperties$1.supportsDescriptors = !!supportsDescriptors$2;

	var defineProperties_1 = defineProperties$1;

	var numberIsNaN = function (value) {
		return value !== value;
	};

	var implementation$8 = function is(a, b) {
		if (a === 0 && b === 0) {
			return 1 / a === 1 / b;
		}
		if (a === b) {
			return true;
		}
		if (numberIsNaN(a) && numberIsNaN(b)) {
			return true;
		}
		return false;
	};

	var implementation$7 = implementation$8;

	var polyfill$4 = function getPolyfill() {
		return typeof Object.is === 'function' ? Object.is : implementation$7;
	};

	var getPolyfill$5 = polyfill$4;
	var define$3 = defineProperties_1;

	var shim$5 = function shimObjectIs() {
		var polyfill = getPolyfill$5();
		define$3(Object, { is: polyfill }, {
			is: function testObjectIs() {
				return Object.is !== polyfill;
			}
		});
		return polyfill;
	};

	var define$2 = defineProperties_1;
	var callBind$2 = callBind$4.exports;

	var implementation$6 = implementation$8;
	var getPolyfill$4 = polyfill$4;
	var shim$4 = shim$5;

	var polyfill$3 = callBind$2(getPolyfill$4(), Object);

	define$2(polyfill$3, {
		getPolyfill: getPolyfill$4,
		implementation: implementation$6,
		shim: shim$4
	});

	var objectIs = polyfill$3;

	var callBound$6 = callBound$8;
	var hasSymbols$4 = shams();
	var hasToStringTag$6 = hasSymbols$4 && !!Symbol.toStringTag;
	var has$1;
	var $exec;
	var isRegexMarker;
	var badStringifier;

	if (hasToStringTag$6) {
		has$1 = callBound$6('Object.prototype.hasOwnProperty');
		$exec = callBound$6('RegExp.prototype.exec');
		isRegexMarker = {};

		var throwRegexMarker = function () {
			throw isRegexMarker;
		};
		badStringifier = {
			toString: throwRegexMarker,
			valueOf: throwRegexMarker
		};

		if (typeof Symbol.toPrimitive === 'symbol') {
			badStringifier[Symbol.toPrimitive] = throwRegexMarker;
		}
	}

	var $toString$3 = callBound$6('Object.prototype.toString');
	var gOPD$3 = Object.getOwnPropertyDescriptor;
	var regexClass = '[object RegExp]';

	var isRegex$1 = hasToStringTag$6
		// eslint-disable-next-line consistent-return
		? function isRegex(value) {
			if (!value || typeof value !== 'object') {
				return false;
			}

			var descriptor = gOPD$3(value, 'lastIndex');
			var hasLastIndexDataProperty = descriptor && has$1(descriptor, 'value');
			if (!hasLastIndexDataProperty) {
				return false;
			}

			try {
				$exec(value, badStringifier);
			} catch (e) {
				return e === isRegexMarker;
			}
		}
		: function isRegex(value) {
			// In older browsers, typeof regex incorrectly returns 'function'
			if (!value || (typeof value !== 'object' && typeof value !== 'function')) {
				return false;
			}

			return $toString$3(value) === regexClass;
		};

	var $Object = Object;
	var $TypeError$2 = TypeError;

	var implementation$5 = function flags() {
		if (this != null && this !== $Object(this)) {
			throw new $TypeError$2('RegExp.prototype.flags getter called on non-object');
		}
		var result = '';
		if (this.global) {
			result += 'g';
		}
		if (this.ignoreCase) {
			result += 'i';
		}
		if (this.multiline) {
			result += 'm';
		}
		if (this.dotAll) {
			result += 's';
		}
		if (this.unicode) {
			result += 'u';
		}
		if (this.sticky) {
			result += 'y';
		}
		return result;
	};

	var implementation$4 = implementation$5;

	var supportsDescriptors$1 = defineProperties_1.supportsDescriptors;
	var $gOPD$1 = Object.getOwnPropertyDescriptor;
	var $TypeError$1 = TypeError;

	var polyfill$2 = function getPolyfill() {
		if (!supportsDescriptors$1) {
			throw new $TypeError$1('RegExp.prototype.flags requires a true ES5 environment that supports property descriptors');
		}
		if ((/a/mig).flags === 'gim') {
			var descriptor = $gOPD$1(RegExp.prototype, 'flags');
			if (descriptor && typeof descriptor.get === 'function' && typeof (/a/).dotAll === 'boolean') {
				return descriptor.get;
			}
		}
		return implementation$4;
	};

	var supportsDescriptors = defineProperties_1.supportsDescriptors;
	var getPolyfill$3 = polyfill$2;
	var gOPD$2 = Object.getOwnPropertyDescriptor;
	var defineProperty = Object.defineProperty;
	var TypeErr = TypeError;
	var getProto = Object.getPrototypeOf;
	var regex = /a/;

	var shim$3 = function shimFlags() {
		if (!supportsDescriptors || !getProto) {
			throw new TypeErr('RegExp.prototype.flags requires a true ES5 environment that supports property descriptors');
		}
		var polyfill = getPolyfill$3();
		var proto = getProto(regex);
		var descriptor = gOPD$2(proto, 'flags');
		if (!descriptor || descriptor.get !== polyfill) {
			defineProperty(proto, 'flags', {
				configurable: true,
				enumerable: false,
				get: polyfill
			});
		}
		return polyfill;
	};

	var define$1 = defineProperties_1;
	var callBind$1 = callBind$4.exports;

	var implementation$3 = implementation$5;
	var getPolyfill$2 = polyfill$2;
	var shim$2 = shim$3;

	var flagsBound = callBind$1(implementation$3);

	define$1(flagsBound, {
		getPolyfill: getPolyfill$2,
		implementation: implementation$3,
		shim: shim$2
	});

	var regexp_prototype_flags = flagsBound;

	var toString$1 = {}.toString;

	var isarray = Array.isArray || function (arr) {
	  return toString$1.call(arr) == '[object Array]';
	};

	var getDay = Date.prototype.getDay;
	var tryDateObject = function tryDateGetDayCall(value) {
		try {
			getDay.call(value);
			return true;
		} catch (e) {
			return false;
		}
	};

	var toStr$4 = Object.prototype.toString;
	var dateClass = '[object Date]';
	var hasToStringTag$5 = typeof Symbol === 'function' && typeof Symbol.toStringTag === 'symbol';

	var isDateObject = function isDateObject(value) {
		if (typeof value !== 'object' || value === null) {
			return false;
		}
		return hasToStringTag$5 ? tryDateObject(value) : toStr$4.call(value) === dateClass;
	};

	var strValue = String.prototype.valueOf;
	var tryStringObject = function tryStringObject(value) {
		try {
			strValue.call(value);
			return true;
		} catch (e) {
			return false;
		}
	};
	var toStr$3 = Object.prototype.toString;
	var strClass = '[object String]';
	var hasToStringTag$4 = typeof Symbol === 'function' && !!Symbol.toStringTag;

	var isString$2 = function isString(value) {
		if (typeof value === 'string') {
			return true;
		}
		if (typeof value !== 'object') {
			return false;
		}
		return hasToStringTag$4 ? tryStringObject(value) : toStr$3.call(value) === strClass;
	};

	var numToStr = Number.prototype.toString;
	var tryNumberObject = function tryNumberObject(value) {
		try {
			numToStr.call(value);
			return true;
		} catch (e) {
			return false;
		}
	};
	var toStr$2 = Object.prototype.toString;
	var numClass = '[object Number]';
	var hasToStringTag$3 = typeof Symbol === 'function' && typeof Symbol.toStringTag === 'symbol';

	var isNumberObject = function isNumberObject(value) {
		if (typeof value === 'number') {
			return true;
		}
		if (typeof value !== 'object') {
			return false;
		}
		return hasToStringTag$3 ? tryNumberObject(value) : toStr$2.call(value) === numClass;
	};

	var callBound$5 = callBound$8;
	var $boolToStr = callBound$5('Boolean.prototype.toString');
	var $toString$2 = callBound$5('Object.prototype.toString');

	var tryBooleanObject = function booleanBrandCheck(value) {
		try {
			$boolToStr(value);
			return true;
		} catch (e) {
			return false;
		}
	};
	var boolClass = '[object Boolean]';
	var hasToStringTag$2 = typeof Symbol === 'function' && typeof Symbol.toStringTag === 'symbol';

	var isBooleanObject = function isBoolean(value) {
		if (typeof value === 'boolean') {
			return true;
		}
		if (value === null || typeof value !== 'object') {
			return false;
		}
		return hasToStringTag$2 && Symbol.toStringTag in value ? tryBooleanObject(value) : $toString$2(value) === boolClass;
	};

	var isSymbol$2 = {exports: {}};

	var toStr$1 = Object.prototype.toString;
	var hasSymbols$3 = hasSymbols$7();

	if (hasSymbols$3) {
		var symToStr = Symbol.prototype.toString;
		var symStringRegex = /^Symbol\(.*\)$/;
		var isSymbolObject = function isRealSymbolObject(value) {
			if (typeof value.valueOf() !== 'symbol') {
				return false;
			}
			return symStringRegex.test(symToStr.call(value));
		};

		isSymbol$2.exports = function isSymbol(value) {
			if (typeof value === 'symbol') {
				return true;
			}
			if (toStr$1.call(value) !== '[object Symbol]') {
				return false;
			}
			try {
				return isSymbolObject(value);
			} catch (e) {
				return false;
			}
		};
	} else {

		isSymbol$2.exports = function isSymbol(value) {
			// this environment does not support Symbols.
			return false ;
		};
	}

	var isBigint = {exports: {}};

	if (typeof BigInt === 'function') {
		var bigIntValueOf$1 = BigInt.prototype.valueOf;
		var tryBigInt = function tryBigIntObject(value) {
			try {
				bigIntValueOf$1.call(value);
				return true;
			} catch (e) {
			}
			return false;
		};

		isBigint.exports = function isBigInt(value) {
			if (
				value === null
				|| typeof value === 'undefined'
				|| typeof value === 'boolean'
				|| typeof value === 'string'
				|| typeof value === 'number'
				|| typeof value === 'symbol'
				|| typeof value === 'function'
			) {
				return false;
			}
			if (typeof value === 'bigint') {
				return true;
			}

			return tryBigInt(value);
		};
	} else {
		isBigint.exports = function isBigInt(value) {
			return false ;
		};
	}

	var isString$1 = isString$2;
	var isNumber$1 = isNumberObject;
	var isBoolean$1 = isBooleanObject;
	var isSymbol$1 = isSymbol$2.exports;
	var isBigInt$1 = isBigint.exports;

	// eslint-disable-next-line consistent-return
	var whichBoxedPrimitive$1 = function whichBoxedPrimitive(value) {
		// eslint-disable-next-line eqeqeq
		if (value == null || (typeof value !== 'object' && typeof value !== 'function')) {
			return null;
		}
		if (isString$1(value)) {
			return 'String';
		}
		if (isNumber$1(value)) {
			return 'Number';
		}
		if (isBoolean$1(value)) {
			return 'Boolean';
		}
		if (isSymbol$1(value)) {
			return 'Symbol';
		}
		if (isBigInt$1(value)) {
			return 'BigInt';
		}
	};

	var $Map$2 = typeof Map === 'function' && Map.prototype ? Map : null;
	var $Set$2 = typeof Set === 'function' && Set.prototype ? Set : null;

	var exported$3;

	if (!$Map$2) {
		// eslint-disable-next-line no-unused-vars
		exported$3 = function isMap(x) {
			// `Map` is not present in this environment.
			return false;
		};
	}

	var $mapHas$5 = $Map$2 ? Map.prototype.has : null;
	var $setHas$4 = $Set$2 ? Set.prototype.has : null;
	if (!exported$3 && !$mapHas$5) {
		// eslint-disable-next-line no-unused-vars
		exported$3 = function isMap(x) {
			// `Map` does not have a `has` method
			return false;
		};
	}

	var isMap$2 = exported$3 || function isMap(x) {
		if (!x || typeof x !== 'object') {
			return false;
		}
		try {
			$mapHas$5.call(x);
			if ($setHas$4) {
				try {
					$setHas$4.call(x);
				} catch (e) {
					return true;
				}
			}
			return x instanceof $Map$2; // core-js workaround, pre-v2.5.0
		} catch (e) {}
		return false;
	};

	var $Map$1 = typeof Map === 'function' && Map.prototype ? Map : null;
	var $Set$1 = typeof Set === 'function' && Set.prototype ? Set : null;

	var exported$2;

	if (!$Set$1) {
		// eslint-disable-next-line no-unused-vars
		exported$2 = function isSet(x) {
			// `Set` is not present in this environment.
			return false;
		};
	}

	var $mapHas$4 = $Map$1 ? Map.prototype.has : null;
	var $setHas$3 = $Set$1 ? Set.prototype.has : null;
	if (!exported$2 && !$setHas$3) {
		// eslint-disable-next-line no-unused-vars
		exported$2 = function isSet(x) {
			// `Set` does not have a `has` method
			return false;
		};
	}

	var isSet$2 = exported$2 || function isSet(x) {
		if (!x || typeof x !== 'object') {
			return false;
		}
		try {
			$setHas$3.call(x);
			if ($mapHas$4) {
				try {
					$mapHas$4.call(x);
				} catch (e) {
					return true;
				}
			}
			return x instanceof $Set$1; // core-js workaround, pre-v2.5.0
		} catch (e) {}
		return false;
	};

	var $WeakMap$2 = typeof WeakMap === 'function' && WeakMap.prototype ? WeakMap : null;
	var $WeakSet$1 = typeof WeakSet === 'function' && WeakSet.prototype ? WeakSet : null;

	var exported$1;

	if (!$WeakMap$2) {
		// eslint-disable-next-line no-unused-vars
		exported$1 = function isWeakMap(x) {
			// `WeakMap` is not present in this environment.
			return false;
		};
	}

	var $mapHas$3 = $WeakMap$2 ? $WeakMap$2.prototype.has : null;
	var $setHas$2 = $WeakSet$1 ? $WeakSet$1.prototype.has : null;
	if (!exported$1 && !$mapHas$3) {
		// eslint-disable-next-line no-unused-vars
		exported$1 = function isWeakMap(x) {
			// `WeakMap` does not have a `has` method
			return false;
		};
	}

	var isWeakmap = exported$1 || function isWeakMap(x) {
		if (!x || typeof x !== 'object') {
			return false;
		}
		try {
			$mapHas$3.call(x, $mapHas$3);
			if ($setHas$2) {
				try {
					$setHas$2.call(x, $setHas$2);
				} catch (e) {
					return true;
				}
			}
			return x instanceof $WeakMap$2; // core-js workaround, pre-v3
		} catch (e) {}
		return false;
	};

	var $WeakMap$1 = typeof WeakMap === 'function' && WeakMap.prototype ? WeakMap : null;
	var $WeakSet = typeof WeakSet === 'function' && WeakSet.prototype ? WeakSet : null;

	var exported;

	if (!$WeakMap$1) {
		// eslint-disable-next-line no-unused-vars
		exported = function isWeakSet(x) {
			// `WeakSet` is not present in this environment.
			return false;
		};
	}

	var $mapHas$2 = $WeakMap$1 ? $WeakMap$1.prototype.has : null;
	var $setHas$1 = $WeakSet ? $WeakSet.prototype.has : null;
	if (!exported && !$setHas$1) {
		// eslint-disable-next-line no-unused-vars
		isWeakset = function isWeakSet(x) {
			// `WeakSet` does not have a `has` method
			return false;
		};
	}

	var isWeakset = exported || function isWeakSet(x) {
		if (!x || typeof x !== 'object') {
			return false;
		}
		try {
			$setHas$1.call(x, $setHas$1);
			if ($mapHas$2) {
				try {
					$mapHas$2.call(x, $mapHas$2);
				} catch (e) {
					return true;
				}
			}
			return x instanceof $WeakSet; // core-js workaround, pre-v3
		} catch (e) {}
		return false;
	};

	var isMap$1 = isMap$2;
	var isSet$1 = isSet$2;
	var isWeakMap$1 = isWeakmap;
	var isWeakSet$1 = isWeakset;

	var whichCollection$1 = function whichCollection(value) {
		if (value && typeof value === 'object') {
			if (isMap$1(value)) {
				return 'Map';
			}
			if (isSet$1(value)) {
				return 'Set';
			}
			if (isWeakMap$1(value)) {
				return 'WeakMap';
			}
			if (isWeakSet$1(value)) {
				return 'WeakSet';
			}
		}
		return false;
	};

	// this should only run in node >= 13.2, so it
	// does not need any of the intense fallbacks that old node/browsers do

	var $iterator = Symbol.iterator;
	var node = function getIterator(iterable) {
		// alternatively, `iterable[$iterator]?.()`
		if (iterable != null && typeof iterable[$iterator] !== 'undefined') {
			return iterable[$iterator]();
		}
	};

	var util_inspect = require$$0$1.inspect;

	var hasMap = typeof Map === 'function' && Map.prototype;
	var mapSizeDescriptor = Object.getOwnPropertyDescriptor && hasMap ? Object.getOwnPropertyDescriptor(Map.prototype, 'size') : null;
	var mapSize = hasMap && mapSizeDescriptor && typeof mapSizeDescriptor.get === 'function' ? mapSizeDescriptor.get : null;
	var mapForEach = hasMap && Map.prototype.forEach;
	var hasSet = typeof Set === 'function' && Set.prototype;
	var setSizeDescriptor = Object.getOwnPropertyDescriptor && hasSet ? Object.getOwnPropertyDescriptor(Set.prototype, 'size') : null;
	var setSize = hasSet && setSizeDescriptor && typeof setSizeDescriptor.get === 'function' ? setSizeDescriptor.get : null;
	var setForEach = hasSet && Set.prototype.forEach;
	var hasWeakMap = typeof WeakMap === 'function' && WeakMap.prototype;
	var weakMapHas = hasWeakMap ? WeakMap.prototype.has : null;
	var hasWeakSet = typeof WeakSet === 'function' && WeakSet.prototype;
	var weakSetHas = hasWeakSet ? WeakSet.prototype.has : null;
	var hasWeakRef = typeof WeakRef === 'function' && WeakRef.prototype;
	var weakRefDeref = hasWeakRef ? WeakRef.prototype.deref : null;
	var booleanValueOf = Boolean.prototype.valueOf;
	var objectToString = Object.prototype.toString;
	var functionToString = Function.prototype.toString;
	var match = String.prototype.match;
	var bigIntValueOf = typeof BigInt === 'function' ? BigInt.prototype.valueOf : null;
	var gOPS = Object.getOwnPropertySymbols;
	var symToString = typeof Symbol === 'function' && typeof Symbol.iterator === 'symbol' ? Symbol.prototype.toString : null;
	var hasShammedSymbols = typeof Symbol === 'function' && typeof Symbol.iterator === 'object';
	var isEnumerable = Object.prototype.propertyIsEnumerable;

	var gPO$1 = (typeof Reflect === 'function' ? Reflect.getPrototypeOf : Object.getPrototypeOf) || (
	    [].__proto__ === Array.prototype // eslint-disable-line no-proto
	        ? function (O) {
	            return O.__proto__; // eslint-disable-line no-proto
	        }
	        : null
	);

	var inspectCustom = util_inspect.custom;
	var inspectSymbol = inspectCustom && isSymbol(inspectCustom) ? inspectCustom : null;
	var toStringTag = typeof Symbol === 'function' && typeof Symbol.toStringTag !== 'undefined' ? Symbol.toStringTag : null;

	var objectInspect = function inspect_(obj, options, depth, seen) {
	    var opts = options || {};

	    if (has(opts, 'quoteStyle') && (opts.quoteStyle !== 'single' && opts.quoteStyle !== 'double')) {
	        throw new TypeError('option "quoteStyle" must be "single" or "double"');
	    }
	    if (
	        has(opts, 'maxStringLength') && (typeof opts.maxStringLength === 'number'
	            ? opts.maxStringLength < 0 && opts.maxStringLength !== Infinity
	            : opts.maxStringLength !== null
	        )
	    ) {
	        throw new TypeError('option "maxStringLength", if provided, must be a positive integer, Infinity, or `null`');
	    }
	    var customInspect = has(opts, 'customInspect') ? opts.customInspect : true;
	    if (typeof customInspect !== 'boolean' && customInspect !== 'symbol') {
	        throw new TypeError('option "customInspect", if provided, must be `true`, `false`, or `\'symbol\'`');
	    }

	    if (
	        has(opts, 'indent')
	        && opts.indent !== null
	        && opts.indent !== '\t'
	        && !(parseInt(opts.indent, 10) === opts.indent && opts.indent > 0)
	    ) {
	        throw new TypeError('options "indent" must be "\\t", an integer > 0, or `null`');
	    }

	    if (typeof obj === 'undefined') {
	        return 'undefined';
	    }
	    if (obj === null) {
	        return 'null';
	    }
	    if (typeof obj === 'boolean') {
	        return obj ? 'true' : 'false';
	    }

	    if (typeof obj === 'string') {
	        return inspectString(obj, opts);
	    }
	    if (typeof obj === 'number') {
	        if (obj === 0) {
	            return Infinity / obj > 0 ? '0' : '-0';
	        }
	        return String(obj);
	    }
	    if (typeof obj === 'bigint') {
	        return String(obj) + 'n';
	    }

	    var maxDepth = typeof opts.depth === 'undefined' ? 5 : opts.depth;
	    if (typeof depth === 'undefined') { depth = 0; }
	    if (depth >= maxDepth && maxDepth > 0 && typeof obj === 'object') {
	        return isArray$1(obj) ? '[Array]' : '[Object]';
	    }

	    var indent = getIndent(opts, depth);

	    if (typeof seen === 'undefined') {
	        seen = [];
	    } else if (indexOf(seen, obj) >= 0) {
	        return '[Circular]';
	    }

	    function inspect(value, from, noIndent) {
	        if (from) {
	            seen = seen.slice();
	            seen.push(from);
	        }
	        if (noIndent) {
	            var newOpts = {
	                depth: opts.depth
	            };
	            if (has(opts, 'quoteStyle')) {
	                newOpts.quoteStyle = opts.quoteStyle;
	            }
	            return inspect_(value, newOpts, depth + 1, seen);
	        }
	        return inspect_(value, opts, depth + 1, seen);
	    }

	    if (typeof obj === 'function') {
	        var name = nameOf(obj);
	        var keys = arrObjKeys(obj, inspect);
	        return '[Function' + (name ? ': ' + name : ' (anonymous)') + ']' + (keys.length > 0 ? ' { ' + keys.join(', ') + ' }' : '');
	    }
	    if (isSymbol(obj)) {
	        var symString = hasShammedSymbols ? String(obj).replace(/^(Symbol\(.*\))_[^)]*$/, '$1') : symToString.call(obj);
	        return typeof obj === 'object' && !hasShammedSymbols ? markBoxed(symString) : symString;
	    }
	    if (isElement(obj)) {
	        var s = '<' + String(obj.nodeName).toLowerCase();
	        var attrs = obj.attributes || [];
	        for (var i = 0; i < attrs.length; i++) {
	            s += ' ' + attrs[i].name + '=' + wrapQuotes(quote(attrs[i].value), 'double', opts);
	        }
	        s += '>';
	        if (obj.childNodes && obj.childNodes.length) { s += '...'; }
	        s += '</' + String(obj.nodeName).toLowerCase() + '>';
	        return s;
	    }
	    if (isArray$1(obj)) {
	        if (obj.length === 0) { return '[]'; }
	        var xs = arrObjKeys(obj, inspect);
	        if (indent && !singleLineValues(xs)) {
	            return '[' + indentedJoin(xs, indent) + ']';
	        }
	        return '[ ' + xs.join(', ') + ' ]';
	    }
	    if (isError(obj)) {
	        var parts = arrObjKeys(obj, inspect);
	        if (parts.length === 0) { return '[' + String(obj) + ']'; }
	        return '{ [' + String(obj) + '] ' + parts.join(', ') + ' }';
	    }
	    if (typeof obj === 'object' && customInspect) {
	        if (inspectSymbol && typeof obj[inspectSymbol] === 'function') {
	            return obj[inspectSymbol]();
	        } else if (customInspect !== 'symbol' && typeof obj.inspect === 'function') {
	            return obj.inspect();
	        }
	    }
	    if (isMap(obj)) {
	        var mapParts = [];
	        mapForEach.call(obj, function (value, key) {
	            mapParts.push(inspect(key, obj, true) + ' => ' + inspect(value, obj));
	        });
	        return collectionOf('Map', mapSize.call(obj), mapParts, indent);
	    }
	    if (isSet(obj)) {
	        var setParts = [];
	        setForEach.call(obj, function (value) {
	            setParts.push(inspect(value, obj));
	        });
	        return collectionOf('Set', setSize.call(obj), setParts, indent);
	    }
	    if (isWeakMap(obj)) {
	        return weakCollectionOf('WeakMap');
	    }
	    if (isWeakSet(obj)) {
	        return weakCollectionOf('WeakSet');
	    }
	    if (isWeakRef(obj)) {
	        return weakCollectionOf('WeakRef');
	    }
	    if (isNumber(obj)) {
	        return markBoxed(inspect(Number(obj)));
	    }
	    if (isBigInt(obj)) {
	        return markBoxed(inspect(bigIntValueOf.call(obj)));
	    }
	    if (isBoolean(obj)) {
	        return markBoxed(booleanValueOf.call(obj));
	    }
	    if (isString(obj)) {
	        return markBoxed(inspect(String(obj)));
	    }
	    if (!isDate$1(obj) && !isRegExp(obj)) {
	        var ys = arrObjKeys(obj, inspect);
	        var isPlainObject = gPO$1 ? gPO$1(obj) === Object.prototype : obj instanceof Object || obj.constructor === Object;
	        var protoTag = obj instanceof Object ? '' : 'null prototype';
	        var stringTag = !isPlainObject && toStringTag && Object(obj) === obj && toStringTag in obj ? toStr(obj).slice(8, -1) : protoTag ? 'Object' : '';
	        var constructorTag = isPlainObject || typeof obj.constructor !== 'function' ? '' : obj.constructor.name ? obj.constructor.name + ' ' : '';
	        var tag = constructorTag + (stringTag || protoTag ? '[' + [].concat(stringTag || [], protoTag || []).join(': ') + '] ' : '');
	        if (ys.length === 0) { return tag + '{}'; }
	        if (indent) {
	            return tag + '{' + indentedJoin(ys, indent) + '}';
	        }
	        return tag + '{ ' + ys.join(', ') + ' }';
	    }
	    return String(obj);
	};

	function wrapQuotes(s, defaultStyle, opts) {
	    var quoteChar = (opts.quoteStyle || defaultStyle) === 'double' ? '"' : "'";
	    return quoteChar + s + quoteChar;
	}

	function quote(s) {
	    return String(s).replace(/"/g, '&quot;');
	}

	function isArray$1(obj) { return toStr(obj) === '[object Array]' && (!toStringTag || !(typeof obj === 'object' && toStringTag in obj)); }
	function isDate$1(obj) { return toStr(obj) === '[object Date]' && (!toStringTag || !(typeof obj === 'object' && toStringTag in obj)); }
	function isRegExp(obj) { return toStr(obj) === '[object RegExp]' && (!toStringTag || !(typeof obj === 'object' && toStringTag in obj)); }
	function isError(obj) { return toStr(obj) === '[object Error]' && (!toStringTag || !(typeof obj === 'object' && toStringTag in obj)); }
	function isString(obj) { return toStr(obj) === '[object String]' && (!toStringTag || !(typeof obj === 'object' && toStringTag in obj)); }
	function isNumber(obj) { return toStr(obj) === '[object Number]' && (!toStringTag || !(typeof obj === 'object' && toStringTag in obj)); }
	function isBoolean(obj) { return toStr(obj) === '[object Boolean]' && (!toStringTag || !(typeof obj === 'object' && toStringTag in obj)); }

	// Symbol and BigInt do have Symbol.toStringTag by spec, so that can't be used to eliminate false positives
	function isSymbol(obj) {
	    if (hasShammedSymbols) {
	        return obj && typeof obj === 'object' && obj instanceof Symbol;
	    }
	    if (typeof obj === 'symbol') {
	        return true;
	    }
	    if (!obj || typeof obj !== 'object' || !symToString) {
	        return false;
	    }
	    try {
	        symToString.call(obj);
	        return true;
	    } catch (e) {}
	    return false;
	}

	function isBigInt(obj) {
	    if (!obj || typeof obj !== 'object' || !bigIntValueOf) {
	        return false;
	    }
	    try {
	        bigIntValueOf.call(obj);
	        return true;
	    } catch (e) {}
	    return false;
	}

	var hasOwn$2 = Object.prototype.hasOwnProperty || function (key) { return key in this; };
	function has(obj, key) {
	    return hasOwn$2.call(obj, key);
	}

	function toStr(obj) {
	    return objectToString.call(obj);
	}

	function nameOf(f) {
	    if (f.name) { return f.name; }
	    var m = match.call(functionToString.call(f), /^function\s*([\w$]+)/);
	    if (m) { return m[1]; }
	    return null;
	}

	function indexOf(xs, x) {
	    if (xs.indexOf) { return xs.indexOf(x); }
	    for (var i = 0, l = xs.length; i < l; i++) {
	        if (xs[i] === x) { return i; }
	    }
	    return -1;
	}

	function isMap(x) {
	    if (!mapSize || !x || typeof x !== 'object') {
	        return false;
	    }
	    try {
	        mapSize.call(x);
	        try {
	            setSize.call(x);
	        } catch (s) {
	            return true;
	        }
	        return x instanceof Map; // core-js workaround, pre-v2.5.0
	    } catch (e) {}
	    return false;
	}

	function isWeakMap(x) {
	    if (!weakMapHas || !x || typeof x !== 'object') {
	        return false;
	    }
	    try {
	        weakMapHas.call(x, weakMapHas);
	        try {
	            weakSetHas.call(x, weakSetHas);
	        } catch (s) {
	            return true;
	        }
	        return x instanceof WeakMap; // core-js workaround, pre-v2.5.0
	    } catch (e) {}
	    return false;
	}

	function isWeakRef(x) {
	    if (!weakRefDeref || !x || typeof x !== 'object') {
	        return false;
	    }
	    try {
	        weakRefDeref.call(x);
	        return true;
	    } catch (e) {}
	    return false;
	}

	function isSet(x) {
	    if