// this file is auto-generated by hap-codegen

use serde::ser::{Serialize, SerializeStruct, Serializer};

use crate::{
    service::HapService,
    characteristic::{
        HapCharacteristic,
		current_position::CurrentPositionCharacteristic,
		position_state::PositionStateCharacteristic,
		target_position::TargetPositionCharacteristic,
		current_horizontal_tilt_angle::CurrentHorizontalTiltAngleCharacteristic,
		target_horizontal_tilt_angle::TargetHorizontalTiltAngleCharacteristic,
		name::NameCharacteristic,
		obstruction_detected::ObstructionDetectedCharacteristic,
		hold_position::HoldPositionCharacteristic,
		current_vertical_tilt_angle::CurrentVerticalTiltAngleCharacteristic,
		target_vertical_tilt_angle::TargetVerticalTiltAngleCharacteristic,
	},
    HapType,
};

/// Window Covering service.
#[derive(Debug, Default)]
pub struct WindowCoveringService {
    /// Instance ID of the Window Covering service.
    id: u64,
    /// [`HapType`](HapType) of the Window Covering service.
    hap_type: HapType,
    /// When set to true, this service is not visible to user.
    hidden: bool,
    /// When set to true, this is the primary service on the accessory.
    primary: bool,
    /// An array of numbers containing the instance IDs of the services that this service links to.
    linked_services: Vec<u64>,

	/// Current Position characteristic (required).
	pub current_position: CurrentPositionCharacteristic,
	/// Position State characteristic (required).
	pub position_state: PositionStateCharacteristic,
	/// Target Position characteristic (required).
	pub target_position: TargetPositionCharacteristic,

	/// Current Horizontal Tilt Angle characteristic (optional).
	pub current_horizontal_tilt_angle: Option<CurrentHorizontalTiltAngleCharacteristic>,
	/// Target Horizontal Tilt Angle characteristic (optional).
	pub target_horizontal_tilt_angle: Option<TargetHorizontalTiltAngleCharacteristic>,
	/// Name characteristic (optional).
	pub name: Option<NameCharacteristic>,
	/// Obstruction Detected characteristic (optional).
	pub obstruction_detected: Option<ObstructionDetectedCharacteristic>,
	/// Hold Position characteristic (optional).
	pub hold_position: Option<HoldPositionCharacteristic>,
	/// Current Vertical Tilt Angle characteristic (optional).
	pub current_vertical_tilt_angle: Option<CurrentVerticalTiltAngleCharacteristic>,
	/// Target Vertical Tilt Angle characteristic (optional).
	pub target_vertical_tilt_angle: Option<TargetVerticalTiltAngleCharacteristic>,
}

impl WindowCoveringService {
    /// Creates a new Window Covering service.
    pub fn new(id: u64, accessory_id: u64) -> Self {
        Self {
            id,
            hap_type: HapType::WindowCovering,
			current_position: CurrentPositionCharacteristic::new(id + 1 + 0, accessory_id),
			position_state: PositionStateCharacteristic::new(id + 1 + 1, accessory_id),
			target_position: TargetPositionCharacteristic::new(id + 1 + 2, accessory_id),
			current_horizontal_tilt_angle: Some(CurrentHorizontalTiltAngleCharacteristic::new(id + 1 + 0 + 3, accessory_id)),
			target_horizontal_tilt_angle: Some(TargetHorizontalTiltAngleCharacteristic::new(id + 1 + 1 + 3, accessory_id)),
			name: Some(NameCharacteristic::new(id + 1 + 2 + 3, accessory_id)),
			obstruction_detected: Some(ObstructionDetectedCharacteristic::new(id + 1 + 3 + 3, accessory_id)),
			hold_position: Some(HoldPositionCharacteristic::new(id + 1 + 4 + 3, accessory_id)),
			current_vertical_tilt_angle: Some(CurrentVerticalTiltAngleCharacteristic::new(id + 1 + 5 + 3, accessory_id)),
			target_vertical_tilt_angle: Some(TargetVerticalTiltAngleCharacteristic::new(id + 1 + 6 + 3, accessory_id)),
			..Default::default()
        }
    }
}

impl HapService for WindowCoveringService {
    fn get_id(&self) -> u64 {
        self.id
    }

    fn set_id(&mut self, id: u64) {
        self.id = id;
    }

    fn get_type(&self) -> HapType {
        self.hap_type
    }

    fn set_type(&mut self, hap_type: HapType) {
        self.hap_type = hap_type;
    }

    fn get_hidden(&self) -> bool {
        self.hidden
    }

    fn set_hidden(&mut self, hidden: bool) {
        self.hidden = hidden;
    }

    fn get_primary(&self) -> bool {
        self.primary
    }

    fn set_primary(&mut self, primary: bool) {
        self.primary = primary;
    }

    fn get_linked_services(&self) -> Vec<u64> {
        self.linked_services.clone()
    }

    fn set_linked_services(&mut self, linked_services: Vec<u64>) {
        self.linked_services = linked_services;
    }

    fn get_characteristic(&self, hap_type: HapType) -> Option<&dyn HapCharacteristic> {
        for characteristic in self.get_characteristics() {
            if characteristic.get_type() == hap_type {
                return Some(characteristic);
            }
        }
        None
    }

    fn get_mut_characteristic(&mut self, hap_type: HapType) -> Option<&mut dyn HapCharacteristic> {
        for characteristic in self.get_mut_characteristics() {
            if characteristic.get_type() == hap_type {
                return Some(characteristic);
            }
        }
        None
    }

    fn get_characteristics(&self) -> Vec<&dyn HapCharacteristic> {
        #[allow(unused_mut)]
        let mut characteristics: Vec<&dyn HapCharacteristic> = vec![
			&self.current_position,
			&self.position_state,
			&self.target_position,
		];
		if let Some(c) = &self.current_horizontal_tilt_angle {
		    characteristics.push(c);
		}
		if let Some(c) = &self.target_horizontal_tilt_angle {
		    characteristics.push(c);
		}
		if let Some(c) = &self.name {
		    characteristics.push(c);
		}
		if let Some(c) = &self.obstruction_detected {
		    characteristics.push(c);
		}
		if let Some(c) = &self.hold_position {
		    characteristics.push(c);
		}
		if let Some(c) = &self.current_vertical_tilt_angle {
		    characteristics.push(c);
		}
		if let Some(c) = &self.target_vertical_tilt_angle {
		    characteristics.push(c);
		}
		characteristics
    }

    fn get_mut_characteristics(&mut self) -> Vec<&mut dyn HapCharacteristic> {
        #[allow(unused_mut)]
        let mut characteristics: Vec<&mut dyn HapCharacteristic> = vec![
			&mut self.current_position,
			&mut self.position_state,
			&mut self.target_position,
		];
		if let Some(c) = &mut self.current_horizontal_tilt_angle {
		    characteristics.push(c);
		}
		if let Some(c) = &mut self.target_horizontal_tilt_angle {
		    characteristics.push(c);
		}
		if let Some(c) = &mut self.name {
		    characteristics.push(c);
		}
		if let Some(c) = &mut self.obstruction_detected {
		    characteristics.push(c);
		}
		if let Some(c) = &mut self.hold_position {
		    characteristics.push(c);
		}
		if let Some(c) = &mut self.current_vertical_tilt_angle {
		    characteristics.push(c);
		}
		if let Some(c) = &mut self.target_vertical_tilt_angle {
		    characteristics.push(c);
		}
		characteristics
    }
}

impl Serialize for WindowCoveringService {
    fn serialize<S: Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        let mut state = serializer.serialize_struct("HapService", 5)?;
        state.serialize_field("iid", &self.get_id())?;
        state.serialize_field("type", &self.get_type())?;
        state.serialize_field("hidden", &self.get_hidden())?;
        state.serialize_field("primary", &self.get_primary())?;
        state.serialize_field("characteristics", &self.get_characteristics())?;
        // linked services left out for now
        state.end()
    }
}
