// this file is auto-generated by hap-codegen

use serde::ser::{Serialize, SerializeStruct, Serializer};

use crate::{
    service::HapService,
    characteristic::{
        HapCharacteristic,
		current_heating_cooling_state::CurrentHeatingCoolingStateCharacteristic,
		target_heating_cooling_state::TargetHeatingCoolingStateCharacteristic,
		current_temperature::CurrentTemperatureCharacteristic,
		target_temperature::TargetTemperatureCharacteristic,
		temperature_display_units::TemperatureDisplayUnitsCharacteristic,
		name::NameCharacteristic,
		current_relative_humidity::CurrentRelativeHumidityCharacteristic,
		target_relative_humidity::TargetRelativeHumidityCharacteristic,
		cooling_threshold_temperature::CoolingThresholdTemperatureCharacteristic,
		heating_threshold_temperature::HeatingThresholdTemperatureCharacteristic,
	},
    HapType,
};

/// Thermostat service.
#[derive(Debug, Default)]
pub struct ThermostatService {
    /// Instance ID of the Thermostat service.
    id: u64,
    /// [`HapType`](HapType) of the Thermostat service.
    hap_type: HapType,
    /// When set to true, this service is not visible to user.
    hidden: bool,
    /// When set to true, this is the primary service on the accessory.
    primary: bool,
    /// An array of numbers containing the instance IDs of the services that this service links to.
    linked_services: Vec<u64>,

	/// Current Heating Cooling State characteristic (required).
	pub current_heating_cooling_state: CurrentHeatingCoolingStateCharacteristic,
	/// Target Heating Cooling State characteristic (required).
	pub target_heating_cooling_state: TargetHeatingCoolingStateCharacteristic,
	/// Current Temperature characteristic (required).
	pub current_temperature: CurrentTemperatureCharacteristic,
	/// Target Temperature characteristic (required).
	pub target_temperature: TargetTemperatureCharacteristic,
	/// Temperature Display Units characteristic (required).
	pub temperature_display_units: TemperatureDisplayUnitsCharacteristic,

	/// Name characteristic (optional).
	pub name: Option<NameCharacteristic>,
	/// Current Relative Humidity characteristic (optional).
	pub current_relative_humidity: Option<CurrentRelativeHumidityCharacteristic>,
	/// Target Relative Humidity characteristic (optional).
	pub target_relative_humidity: Option<TargetRelativeHumidityCharacteristic>,
	/// Cooling Threshold Temperature characteristic (optional).
	pub cooling_threshold_temperature: Option<CoolingThresholdTemperatureCharacteristic>,
	/// Heating Threshold Temperature characteristic (optional).
	pub heating_threshold_temperature: Option<HeatingThresholdTemperatureCharacteristic>,
}

impl ThermostatService {
    /// Creates a new Thermostat service.
    pub fn new(id: u64, accessory_id: u64) -> Self {
        Self {
            id,
            hap_type: HapType::Thermostat,
			current_heating_cooling_state: CurrentHeatingCoolingStateCharacteristic::new(id + 1 + 0, accessory_id),
			target_heating_cooling_state: TargetHeatingCoolingStateCharacteristic::new(id + 1 + 1, accessory_id),
			current_temperature: CurrentTemperatureCharacteristic::new(id + 1 + 2, accessory_id),
			target_temperature: TargetTemperatureCharacteristic::new(id + 1 + 3, accessory_id),
			temperature_display_units: TemperatureDisplayUnitsCharacteristic::new(id + 1 + 4, accessory_id),
			name: Some(NameCharacteristic::new(id + 1 + 0 + 5, accessory_id)),
			current_relative_humidity: Some(CurrentRelativeHumidityCharacteristic::new(id + 1 + 1 + 5, accessory_id)),
			target_relative_humidity: Some(TargetRelativeHumidityCharacteristic::new(id + 1 + 2 + 5, accessory_id)),
			cooling_threshold_temperature: Some(CoolingThresholdTemperatureCharacteristic::new(id + 1 + 3 + 5, accessory_id)),
			heating_threshold_temperature: Some(HeatingThresholdTemperatureCharacteristic::new(id + 1 + 4 + 5, accessory_id)),
			..Default::default()
        }
    }
}

impl HapService for ThermostatService {
    fn get_id(&self) -> u64 {
        self.id
    }

    fn set_id(&mut self, id: u64) {
        self.id = id;
    }

    fn get_type(&self) -> HapType {
        self.hap_type
    }

    fn set_type(&mut self, hap_type: HapType) {
        self.hap_type = hap_type;
    }

    fn get_hidden(&self) -> bool {
        self.hidden
    }

    fn set_hidden(&mut self, hidden: bool) {
        self.hidden = hidden;
    }

    fn get_primary(&self) -> bool {
        self.primary
    }

    fn set_primary(&mut self, primary: bool) {
        self.primary = primary;
    }

    fn get_linked_services(&self) -> Vec<u64> {
        self.linked_services.clone()
    }

    fn set_linked_services(&mut self, linked_services: Vec<u64>) {
        self.linked_services = linked_services;
    }

    fn get_characteristic(&self, hap_type: HapType) -> Option<&dyn HapCharacteristic> {
        for characteristic in self.get_characteristics() {
            if characteristic.get_type() == hap_type {
                return Some(characteristic);
            }
        }
        None
    }

    fn get_mut_characteristic(&mut self, hap_type: HapType) -> Option<&mut dyn HapCharacteristic> {
        for characteristic in self.get_mut_characteristics() {
            if characteristic.get_type() == hap_type {
                return Some(characteristic);
            }
        }
        None
    }

    fn get_characteristics(&self) -> Vec<&dyn HapCharacteristic> {
        #[allow(unused_mut)]
        let mut characteristics: Vec<&dyn HapCharacteristic> = vec![
			&self.current_heating_cooling_state,
			&self.target_heating_cooling_state,
			&self.current_temperature,
			&self.target_temperature,
			&self.temperature_display_units,
		];
		if let Some(c) = &self.name {
		    characteristics.push(c);
		}
		if let Some(c) = &self.current_relative_humidity {
		    characteristics.push(c);
		}
		if let Some(c) = &self.target_relative_humidity {
		    characteristics.push(c);
		}
		if let Some(c) = &self.cooling_threshold_temperature {
		    characteristics.push(c);
		}
		if let Some(c) = &self.heating_threshold_temperature {
		    characteristics.push(c);
		}
		characteristics
    }

    fn get_mut_characteristics(&mut self) -> Vec<&mut dyn HapCharacteristic> {
        #[allow(unused_mut)]
        let mut characteristics: Vec<&mut dyn HapCharacteristic> = vec![
			&mut self.current_heating_cooling_state,
			&mut self.target_heating_cooling_state,
			&mut self.current_temperature,
			&mut self.target_temperature,
			&mut self.temperature_display_units,
		];
		if let Some(c) = &mut self.name {
		    characteristics.push(c);
		}
		if let Some(c) = &mut self.current_relative_humidity {
		    characteristics.push(c);
		}
		if let Some(c) = &mut self.target_relative_humidity {
		    characteristics.push(c);
		}
		if let Some(c) = &mut self.cooling_threshold_temperature {
		    characteristics.push(c);
		}
		if let Some(c) = &mut self.heating_threshold_temperature {
		    characteristics.push(c);
		}
		characteristics
    }
}

impl Serialize for ThermostatService {
    fn serialize<S: Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        let mut state = serializer.serialize_struct("HapService", 5)?;
        state.serialize_field("iid", &self.get_id())?;
        state.serialize_field("type", &self.get_type())?;
        state.serialize_field("hidden", &self.get_hidden())?;
        state.serialize_field("primary", &self.get_primary())?;
        state.serialize_field("characteristics", &self.get_characteristics())?;
        // linked services left out for now
        state.end()
    }
}
