// this file is auto-generated by hap-codegen

use serde::ser::{Serialize, SerializeStruct, Serializer};

use crate::{
    service::HapService,
    characteristic::{
        HapCharacteristic,
		current_door_state::CurrentDoorStateCharacteristic,
		target_door_state::TargetDoorStateCharacteristic,
		obstruction_detected::ObstructionDetectedCharacteristic,
		lock_current_state::LockCurrentStateCharacteristic,
		lock_target_state::LockTargetStateCharacteristic,
		name::NameCharacteristic,
	},
    HapType,
};

/// Garage Door Opener service.
#[derive(Debug, Default)]
pub struct GarageDoorOpenerService {
    /// Instance ID of the Garage Door Opener service.
    id: u64,
    /// [`HapType`](HapType) of the Garage Door Opener service.
    hap_type: HapType,
    /// When set to true, this service is not visible to user.
    hidden: bool,
    /// When set to true, this is the primary service on the accessory.
    primary: bool,
    /// An array of numbers containing the instance IDs of the services that this service links to.
    linked_services: Vec<u64>,

	/// Current Door State characteristic (required).
	pub current_door_state: CurrentDoorStateCharacteristic,
	/// Target Door State characteristic (required).
	pub target_door_state: TargetDoorStateCharacteristic,
	/// Obstruction Detected characteristic (required).
	pub obstruction_detected: ObstructionDetectedCharacteristic,

	/// Lock Current State characteristic (optional).
	pub lock_current_state: Option<LockCurrentStateCharacteristic>,
	/// Lock Target State characteristic (optional).
	pub lock_target_state: Option<LockTargetStateCharacteristic>,
	/// Name characteristic (optional).
	pub name: Option<NameCharacteristic>,
}

impl GarageDoorOpenerService {
    /// Creates a new Garage Door Opener service.
    pub fn new(id: u64, accessory_id: u64) -> Self {
        Self {
            id,
            hap_type: HapType::GarageDoorOpener,
			current_door_state: CurrentDoorStateCharacteristic::new(id + 1 + 0, accessory_id),
			target_door_state: TargetDoorStateCharacteristic::new(id + 1 + 1, accessory_id),
			obstruction_detected: ObstructionDetectedCharacteristic::new(id + 1 + 2, accessory_id),
			lock_current_state: Some(LockCurrentStateCharacteristic::new(id + 1 + 0 + 3, accessory_id)),
			lock_target_state: Some(LockTargetStateCharacteristic::new(id + 1 + 1 + 3, accessory_id)),
			name: Some(NameCharacteristic::new(id + 1 + 2 + 3, accessory_id)),
			..Default::default()
        }
    }
}

impl HapService for GarageDoorOpenerService {
    fn get_id(&self) -> u64 {
        self.id
    }

    fn set_id(&mut self, id: u64) {
        self.id = id;
    }

    fn get_type(&self) -> HapType {
        self.hap_type
    }

    fn set_type(&mut self, hap_type: HapType) {
        self.hap_type = hap_type;
    }

    fn get_hidden(&self) -> bool {
        self.hidden
    }

    fn set_hidden(&mut self, hidden: bool) {
        self.hidden = hidden;
    }

    fn get_primary(&self) -> bool {
        self.primary
    }

    fn set_primary(&mut self, primary: bool) {
        self.primary = primary;
    }

    fn get_linked_services(&self) -> Vec<u64> {
        self.linked_services.clone()
    }

    fn set_linked_services(&mut self, linked_services: Vec<u64>) {
        self.linked_services = linked_services;
    }

    fn get_characteristic(&self, hap_type: HapType) -> Option<&dyn HapCharacteristic> {
        for characteristic in self.get_characteristics() {
            if characteristic.get_type() == hap_type {
                return Some(characteristic);
            }
        }
        None
    }

    fn get_mut_characteristic(&mut self, hap_type: HapType) -> Option<&mut dyn HapCharacteristic> {
        for characteristic in self.get_mut_characteristics() {
            if characteristic.get_type() == hap_type {
                return Some(characteristic);
            }
        }
        None
    }

    fn get_characteristics(&self) -> Vec<&dyn HapCharacteristic> {
        #[allow(unused_mut)]
        let mut characteristics: Vec<&dyn HapCharacteristic> = vec![
			&self.current_door_state,
			&self.target_door_state,
			&self.obstruction_detected,
		];
		if let Some(c) = &self.lock_current_state {
		    characteristics.push(c);
		}
		if let Some(c) = &self.lock_target_state {
		    characteristics.push(c);
		}
		if let Some(c) = &self.name {
		    characteristics.push(c);
		}
		characteristics
    }

    fn get_mut_characteristics(&mut self) -> Vec<&mut dyn HapCharacteristic> {
        #[allow(unused_mut)]
        let mut characteristics: Vec<&mut dyn HapCharacteristic> = vec![
			&mut self.current_door_state,
			&mut self.target_door_state,
			&mut self.obstruction_detected,
		];
		if let Some(c) = &mut self.lock_current_state {
		    characteristics.push(c);
		}
		if let Some(c) = &mut self.lock_target_state {
		    characteristics.push(c);
		}
		if let Some(c) = &mut self.name {
		    characteristics.push(c);
		}
		characteristics
    }
}

impl Serialize for GarageDoorOpenerService {
    fn serialize<S: Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        let mut state = serializer.serialize_struct("HapService", 5)?;
        state.serialize_field("iid", &self.get_id())?;
        state.serialize_field("type", &self.get_type())?;
        state.serialize_field("hidden", &self.get_hidden())?;
        state.serialize_field("primary", &self.get_primary())?;
        state.serialize_field("characteristics", &self.get_characteristics())?;
        // linked services left out for now
        state.end()
    }
}
