// this file is auto-generated by hap-codegen

use serde::{
    de::{self, Deserialize, Deserializer},
    ser::{Serialize, Serializer},
};
use std::str::FromStr;
use uuid::Uuid;

use crate::Error;

/// HAP service and characteristic type representation.
#[derive(Debug, Copy, Clone, Eq, PartialEq, Hash)]
pub enum HapType {
    Unknown,
    Custom(Uuid),
	AccessCodeControlPoint,
	AccessCodeSupportedConfiguration,
	AccessControlLevel,
	AccessoryFlags,
	AccessoryIdentifier,
	Active,
	ActiveIdentifier,
	ActivityInterval,
	AdministratorOnlyAccess,
	AirParticulateDensity,
	AirParticulateSize,
	AirplayEnable,
	ApplicationMatchingIdentifier,
	AssetUpdateReadiness,
	AudioFeedback,
	BatteryLevel,
	Brightness,
	ButtonEvent,
	CcaEnergyDetectThreshold,
	CcaSignalDetectThreshold,
	CameraOperatingModeIndicator,
	CarbonDioxideDetected,
	CarbonDioxideLevel,
	CarbonDioxidePeakLevel,
	CarbonMonoxideDetected,
	CarbonMonoxideLevel,
	CarbonMonoxidePeakLevel,
	CharacteristicValueActiveTransitionCount,
	CharacteristicValueTransitionControl,
	ChargingState,
	ClosedCaptions,
	CloudRelayControlPoint,
	CloudRelayCurrentState,
	CloudRelayEnableStatus,
	ColorTemperature,
	ConfigurationState,
	ConfiguredName,
	ContactSensorState,
	CoolingThresholdTemperature,
	CurrentAirPurifierState,
	CurrentAirQuality,
	CurrentDoorState,
	CurrentFanState,
	CurrentHeaterCoolerState,
	CurrentHeatingCoolingState,
	CurrentHorizontalTiltAngle,
	CurrentHumidifierDehumidifierState,
	CurrentLightLevel,
	CurrentMediaState,
	CurrentPosition,
	CurrentRelativeHumidity,
	CurrentSlatState,
	CurrentTemperature,
	CurrentTiltAngle,
	CurrentTransport,
	CurrentVerticalTiltAngle,
	CurrentVisibilityState,
	CurrentWaterLevel,
	DataStreamHapTransport,
	DataStreamHapTransportInterrupt,
	DigitalZoom,
	DisplayOrder,
	EventRetransmissionMaximum,
	EventSnapshotsActive,
	EventTransmissionCounters,
	FilterChangeIndication,
	FilterLifeLevel,
	FilterResetChangeIndication,
	FirmwareRevision,
	FirmwareUpdateReadiness,
	FirmwareUpdateStatus,
	HardwareFinish,
	HardwareRevision,
	HeartBeat,
	HeatingThresholdTemperature,
	HoldPosition,
	HomekitCameraActive,
	Hue,
	Identifier,
	Identify,
	ImageMirroring,
	ImageRotation,
	InUse,
	InputDeviceType,
	InputSourceType,
	IsConfigured,
	LabelIndex,
	LabelNamespace,
	LeakDetected,
	ListPairings,
	LockControlPoint,
	LockCurrentState,
	LockLastKnownAction,
	LockManagementAutoSecurityTimeout,
	LockPhysicalControls,
	LockTargetState,
	Logs,
	MacRetransmissionMaximum,
	MacTransmissionCounters,
	ManagedNetworkEnable,
	ManuallyDisabled,
	Manufacturer,
	MaximumTransmitPower,
	Model,
	MotionDetected,
	MultifunctionButton,
	Mute,
	NfcAccessControlPoint,
	NfcAccessSupportedConfiguration,
	Name,
	NetworkAccessViolationControl,
	NetworkClientControl,
	NetworkClientStatusControl,
	NightVision,
	NitrogenDioxideDensity,
	ObstructionDetected,
	OccupancyDetected,
	OperatingStateResponse,
	OpticalZoom,
	OutletInUse,
	OzoneDensity,
	Pm10Density,
	Pm2_5Density,
	PairSetup,
	PairVerify,
	PairingFeatures,
	PasswordSetting,
	PeriodicSnapshotsActive,
	PictureMode,
	Ping,
	PositionState,
	PowerModeSelection,
	PowerState,
	ProductData,
	ProgramMode,
	ProgrammableSwitchEvent,
	ProgrammableSwitchOutputState,
	ReceivedSignalStrengthIndication,
	ReceiverSensitivity,
	RelativeHumidityDehumidifierThreshold,
	RelativeHumidityHumidifierThreshold,
	RemainingDuration,
	RemoteKey,
	RotationDirection,
	RotationSpeed,
	RouterStatus,
	Saturation,
	SecuritySystemAlarmType,
	SecuritySystemCurrentState,
	SecuritySystemTargetState,
	SelectedAudioStreamConfiguration,
	SelectedCameraRecordingConfiguration,
	SelectedDiagnosticsModes,
	SelectedStreamConfiguration,
	SerialNumber,
	ServiceSignature,
	SetDuration,
	SetupDataStreamTransport,
	SetupEndpoint,
	SetupTransferTransport,
	SignalToNoiseRatio,
	SiriEnable,
	SiriEndpointSessionStatus,
	SiriEngineVersion,
	SiriInputType,
	SiriLightOnUse,
	SiriListening,
	SiriTouchToUse,
	SlatType,
	SleepDiscoveryMode,
	SleepInterval,
	SmokeDetected,
	SoftwareRevision,
	StagedFirmwareVersion,
	StatusActive,
	StatusFault,
	StatusJammed,
	StatusLowBattery,
	StatusTampered,
	StreamingStatus,
	SulphurDioxideDensity,
	SupportedAssetTypes,
	SupportedAudioRecordingConfiguration,
	SupportedAudioStreamConfiguration,
	SupportedCameraRecordingConfiguration,
	SupportedCharacteristicValueTransitionConfiguration,
	SupportedDataStreamTransportConfiguration,
	SupportedDiagnosticsModes,
	SupportedDiagnosticsSnapshot,
	SupportedFirmwareUpdateConfiguration,
	SupportedRtpConfiguration,
	SupportedRouterConfiguration,
	SupportedTargetConfiguration,
	SupportedTransferTransportConfiguration,
	SupportedVideoRecordingConfiguration,
	SupportedVideoStreamConfiguration,
	SwingMode,
	TargetAirPurifierState,
	TargetDoorState,
	TargetFanState,
	TargetHeaterCoolerState,
	TargetHeatingCoolingState,
	TargetHorizontalTiltAngle,
	TargetHumidifierDehumidifierState,
	TargetListConfiguration,
	TargetMediaState,
	TargetPosition,
	TargetRelativeHumidity,
	TargetTemperature,
	TargetTiltAngle,
	TargetVerticalTiltAngle,
	TargetVisibilityState,
	TemperatureDisplayUnits,
	ThirdPartyCameraActive,
	ThreadControlPoint,
	ThreadNodeCapabilities,
	ThreadOpenthreadVersion,
	ThreadStatus,
	TransmitPower,
	ValveType,
	Version,
	VideoAnalysisActive,
	VolatileOrganicCompoundDensity,
	Volume,
	VolumeControlType,
	VolumeSelector,
	WanConfigurationList,
	WanStatusList,
	WakeConfiguration,
	WiFiCapabilities,
	WiFiConfigurationControl,
	WiFiSatelliteStatus,
	RecordingAudioActive,
	AccessCode,
	AccessControl,
	AccessoryInformation,
	AccessoryMetrics,
	AccessoryRuntimeInformation,
	AirPurifier,
	AirQualitySensor,
	AssetUpdate,
	Assistant,
	AudioStreamManagement,
	Battery,
	CameraOperatingMode,
	CameraRecordingManagement,
	CameraStreamManagement,
	CarbonDioxideSensor,
	CarbonMonoxideSensor,
	CloudRelay,
	ContactSensor,
	DataStreamTransportManagement,
	Diagnostics,
	Door,
	Doorbell,
	Fan,
	FanV2,
	Faucet,
	FilterMaintenance,
	GarageDoorOpener,
	HeaterCooler,
	HumidifierDehumidifier,
	HumiditySensor,
	InputSource,
	IrrigationSystem,
	Label,
	LeakSensor,
	LightSensor,
	Lightbulb,
	LockManagement,
	LockMechanism,
	Microphone,
	MotionSensor,
	NfcAccessService,
	OccupancySensor,
	Outlet,
	Pairing,
	PowerManagement,
	ProtocolInformation,
	SecuritySystem,
	Siri,
	SiriEndpoint,
	Slats,
	SmartSpeaker,
	SmokeSensor,
	Speaker,
	StatefulProgrammableSwitch,
	StatelessProgrammableSwitch,
	Switch,
	TargetControl,
	TargetControlManagement,
	Television,
	TemperatureSensor,
	Thermostat,
	ThreadTransport,
	TransferTransportManagement,
	Valve,
	WiFiRouter,
	WiFiSatellite,
	WiFiTransport,
	Window,
	WindowCovering,
}

impl ToString for HapType {
    fn to_string(&self) -> String {
        match self {
            HapType::Unknown => "unknown".into(),
            HapType::Custom(uuid) => uuid.to_hyphenated().to_string(),
			HapType::AccessCodeControlPoint => "262".into(),
			HapType::AccessCodeSupportedConfiguration => "261".into(),
			HapType::AccessControlLevel => "E5".into(),
			HapType::AccessoryFlags => "A6".into(),
			HapType::AccessoryIdentifier => "57".into(),
			HapType::Active => "B0".into(),
			HapType::ActiveIdentifier => "E7".into(),
			HapType::ActivityInterval => "23B".into(),
			HapType::AdministratorOnlyAccess => "1".into(),
			HapType::AirParticulateDensity => "64".into(),
			HapType::AirParticulateSize => "65".into(),
			HapType::AirplayEnable => "25B".into(),
			HapType::ApplicationMatchingIdentifier => "A4".into(),
			HapType::AssetUpdateReadiness => "269".into(),
			HapType::AudioFeedback => "5".into(),
			HapType::BatteryLevel => "68".into(),
			HapType::Brightness => "8".into(),
			HapType::ButtonEvent => "126".into(),
			HapType::CcaEnergyDetectThreshold => "246".into(),
			HapType::CcaSignalDetectThreshold => "245".into(),
			HapType::CameraOperatingModeIndicator => "21D".into(),
			HapType::CarbonDioxideDetected => "92".into(),
			HapType::CarbonDioxideLevel => "93".into(),
			HapType::CarbonDioxidePeakLevel => "94".into(),
			HapType::CarbonMonoxideDetected => "69".into(),
			HapType::CarbonMonoxideLevel => "90".into(),
			HapType::CarbonMonoxidePeakLevel => "91".into(),
			HapType::CharacteristicValueActiveTransitionCount => "24B".into(),
			HapType::CharacteristicValueTransitionControl => "143".into(),
			HapType::ChargingState => "8F".into(),
			HapType::ClosedCaptions => "DD".into(),
			HapType::CloudRelayControlPoint => "5E".into(),
			HapType::CloudRelayCurrentState => "5C".into(),
			HapType::CloudRelayEnableStatus => "5B".into(),
			HapType::ColorTemperature => "CE".into(),
			HapType::ConfigurationState => "263".into(),
			HapType::ConfiguredName => "E3".into(),
			HapType::ContactSensorState => "6A".into(),
			HapType::CoolingThresholdTemperature => "D".into(),
			HapType::CurrentAirPurifierState => "A9".into(),
			HapType::CurrentAirQuality => "95".into(),
			HapType::CurrentDoorState => "E".into(),
			HapType::CurrentFanState => "AF".into(),
			HapType::CurrentHeaterCoolerState => "B1".into(),
			HapType::CurrentHeatingCoolingState => "F".into(),
			HapType::CurrentHorizontalTiltAngle => "6C".into(),
			HapType::CurrentHumidifierDehumidifierState => "B3".into(),
			HapType::CurrentLightLevel => "6B".into(),
			HapType::CurrentMediaState => "E0".into(),
			HapType::CurrentPosition => "6D".into(),
			HapType::CurrentRelativeHumidity => "10".into(),
			HapType::CurrentSlatState => "AA".into(),
			HapType::CurrentTemperature => "11".into(),
			HapType::CurrentTiltAngle => "C1".into(),
			HapType::CurrentTransport => "22B".into(),
			HapType::CurrentVerticalTiltAngle => "6E".into(),
			HapType::CurrentVisibilityState => "135".into(),
			HapType::CurrentWaterLevel => "B5".into(),
			HapType::DataStreamHapTransport => "138".into(),
			HapType::DataStreamHapTransportInterrupt => "139".into(),
			HapType::DigitalZoom => "11D".into(),
			HapType::DisplayOrder => "136".into(),
			HapType::EventRetransmissionMaximum => "23D".into(),
			HapType::EventSnapshotsActive => "223".into(),
			HapType::EventTransmissionCounters => "23E".into(),
			HapType::FilterChangeIndication => "AC".into(),
			HapType::FilterLifeLevel => "AB".into(),
			HapType::FilterResetChangeIndication => "AD".into(),
			HapType::FirmwareRevision => "52".into(),
			HapType::FirmwareUpdateReadiness => "234".into(),
			HapType::FirmwareUpdateStatus => "235".into(),
			HapType::HardwareFinish => "26C".into(),
			HapType::HardwareRevision => "53".into(),
			HapType::HeartBeat => "24A".into(),
			HapType::HeatingThresholdTemperature => "12".into(),
			HapType::HoldPosition => "6F".into(),
			HapType::HomekitCameraActive => "21B".into(),
			HapType::Hue => "13".into(),
			HapType::Identifier => "E6".into(),
			HapType::Identify => "14".into(),
			HapType::ImageMirroring => "11F".into(),
			HapType::ImageRotation => "11E".into(),
			HapType::InUse => "D2".into(),
			HapType::InputDeviceType => "DC".into(),
			HapType::InputSourceType => "DB".into(),
			HapType::IsConfigured => "D6".into(),
			HapType::LabelIndex => "CB".into(),
			HapType::LabelNamespace => "CD".into(),
			HapType::LeakDetected => "70".into(),
			HapType::ListPairings => "50".into(),
			HapType::LockControlPoint => "19".into(),
			HapType::LockCurrentState => "1D".into(),
			HapType::LockLastKnownAction => "1C".into(),
			HapType::LockManagementAutoSecurityTimeout => "1A".into(),
			HapType::LockPhysicalControls => "A7".into(),
			HapType::LockTargetState => "1E".into(),
			HapType::Logs => "1F".into(),
			HapType::MacRetransmissionMaximum => "247".into(),
			HapType::MacTransmissionCounters => "248".into(),
			HapType::ManagedNetworkEnable => "215".into(),
			HapType::ManuallyDisabled => "227".into(),
			HapType::Manufacturer => "20".into(),
			HapType::MaximumTransmitPower => "243".into(),
			HapType::Model => "21".into(),
			HapType::MotionDetected => "22".into(),
			HapType::MultifunctionButton => "26B".into(),
			HapType::Mute => "11A".into(),
			HapType::NfcAccessControlPoint => "264".into(),
			HapType::NfcAccessSupportedConfiguration => "265".into(),
			HapType::Name => "23".into(),
			HapType::NetworkAccessViolationControl => "21F".into(),
			HapType::NetworkClientControl => "20C".into(),
			HapType::NetworkClientStatusControl => "20D".into(),
			HapType::NightVision => "11B".into(),
			HapType::NitrogenDioxideDensity => "C4".into(),
			HapType::ObstructionDetected => "24".into(),
			HapType::OccupancyDetected => "71".into(),
			HapType::OperatingStateResponse => "232".into(),
			HapType::OpticalZoom => "11C".into(),
			HapType::OutletInUse => "26".into(),
			HapType::OzoneDensity => "C3".into(),
			HapType::Pm10Density => "C7".into(),
			HapType::Pm2_5Density => "C6".into(),
			HapType::PairSetup => "4C".into(),
			HapType::PairVerify => "4E".into(),
			HapType::PairingFeatures => "4F".into(),
			HapType::PasswordSetting => "E4".into(),
			HapType::PeriodicSnapshotsActive => "225".into(),
			HapType::PictureMode => "E2".into(),
			HapType::Ping => "23C".into(),
			HapType::PositionState => "72".into(),
			HapType::PowerModeSelection => "DF".into(),
			HapType::PowerState => "25".into(),
			HapType::ProductData => "220".into(),
			HapType::ProgramMode => "D1".into(),
			HapType::ProgrammableSwitchEvent => "73".into(),
			HapType::ProgrammableSwitchOutputState => "74".into(),
			HapType::ReceivedSignalStrengthIndication => "23F".into(),
			HapType::ReceiverSensitivity => "244".into(),
			HapType::RelativeHumidityDehumidifierThreshold => "C9".into(),
			HapType::RelativeHumidityHumidifierThreshold => "CA".into(),
			HapType::RemainingDuration => "D4".into(),
			HapType::RemoteKey => "E1".into(),
			HapType::RotationDirection => "28".into(),
			HapType::RotationSpeed => "29".into(),
			HapType::RouterStatus => "20E".into(),
			HapType::Saturation => "2F".into(),
			HapType::SecuritySystemAlarmType => "8E".into(),
			HapType::SecuritySystemCurrentState => "66".into(),
			HapType::SecuritySystemTargetState => "67".into(),
			HapType::SelectedAudioStreamConfiguration => "128".into(),
			HapType::SelectedCameraRecordingConfiguration => "209".into(),
			HapType::SelectedDiagnosticsModes => "24D".into(),
			HapType::SelectedStreamConfiguration => "117".into(),
			HapType::SerialNumber => "30".into(),
			HapType::ServiceSignature => "A5".into(),
			HapType::SetDuration => "D3".into(),
			HapType::SetupDataStreamTransport => "131".into(),
			HapType::SetupEndpoint => "118".into(),
			HapType::SetupTransferTransport => "201".into(),
			HapType::SignalToNoiseRatio => "241".into(),
			HapType::SiriEnable => "255".into(),
			HapType::SiriEndpointSessionStatus => "254".into(),
			HapType::SiriEngineVersion => "25A".into(),
			HapType::SiriInputType => "132".into(),
			HapType::SiriLightOnUse => "258".into(),
			HapType::SiriListening => "256".into(),
			HapType::SiriTouchToUse => "257".into(),
			HapType::SlatType => "C0".into(),
			HapType::SleepDiscoveryMode => "E8".into(),
			HapType::SleepInterval => "23A".into(),
			HapType::SmokeDetected => "76".into(),
			HapType::SoftwareRevision => "54".into(),
			HapType::StagedFirmwareVersion => "249".into(),
			HapType::StatusActive => "75".into(),
			HapType::StatusFault => "77".into(),
			HapType::StatusJammed => "78".into(),
			HapType::StatusLowBattery => "79".into(),
			HapType::StatusTampered => "7A".into(),
			HapType::StreamingStatus => "120".into(),
			HapType::SulphurDioxideDensity => "C5".into(),
			HapType::SupportedAssetTypes => "268".into(),
			HapType::SupportedAudioRecordingConfiguration => "207".into(),
			HapType::SupportedAudioStreamConfiguration => "115".into(),
			HapType::SupportedCameraRecordingConfiguration => "205".into(),
			HapType::SupportedCharacteristicValueTransitionConfiguration => "144".into(),
			HapType::SupportedDataStreamTransportConfiguration => "130".into(),
			HapType::SupportedDiagnosticsModes => "24C".into(),
			HapType::SupportedDiagnosticsSnapshot => "238".into(),
			HapType::SupportedFirmwareUpdateConfiguration => "233".into(),
			HapType::SupportedRtpConfiguration => "116".into(),
			HapType::SupportedRouterConfiguration => "210".into(),
			HapType::SupportedTargetConfiguration => "123".into(),
			HapType::SupportedTransferTransportConfiguration => "202".into(),
			HapType::SupportedVideoRecordingConfiguration => "206".into(),
			HapType::SupportedVideoStreamConfiguration => "114".into(),
			HapType::SwingMode => "B6".into(),
			HapType::TargetAirPurifierState => "A8".into(),
			HapType::TargetDoorState => "32".into(),
			HapType::TargetFanState => "BF".into(),
			HapType::TargetHeaterCoolerState => "B2".into(),
			HapType::TargetHeatingCoolingState => "33".into(),
			HapType::TargetHorizontalTiltAngle => "7B".into(),
			HapType::TargetHumidifierDehumidifierState => "B4".into(),
			HapType::TargetListConfiguration => "124".into(),
			HapType::TargetMediaState => "137".into(),
			HapType::TargetPosition => "7C".into(),
			HapType::TargetRelativeHumidity => "34".into(),
			HapType::TargetTemperature => "35".into(),
			HapType::TargetTiltAngle => "C2".into(),
			HapType::TargetVerticalTiltAngle => "7D".into(),
			HapType::TargetVisibilityState => "134".into(),
			HapType::TemperatureDisplayUnits => "36".into(),
			HapType::ThirdPartyCameraActive => "21C".into(),
			HapType::ThreadControlPoint => "704".into(),
			HapType::ThreadNodeCapabilities => "702".into(),
			HapType::ThreadOpenthreadVersion => "706".into(),
			HapType::ThreadStatus => "703".into(),
			HapType::TransmitPower => "242".into(),
			HapType::ValveType => "D5".into(),
			HapType::Version => "37".into(),
			HapType::VideoAnalysisActive => "229".into(),
			HapType::VolatileOrganicCompoundDensity => "C8".into(),
			HapType::Volume => "119".into(),
			HapType::VolumeControlType => "E9".into(),
			HapType::VolumeSelector => "EA".into(),
			HapType::WanConfigurationList => "211".into(),
			HapType::WanStatusList => "212".into(),
			HapType::WakeConfiguration => "222".into(),
			HapType::WiFiCapabilities => "22C".into(),
			HapType::WiFiConfigurationControl => "22D".into(),
			HapType::WiFiSatelliteStatus => "21E".into(),
			HapType::RecordingAudioActive => "226".into(),
			HapType::AccessCode => "260".into(),
			HapType::AccessControl => "DA".into(),
			HapType::AccessoryInformation => "3E".into(),
			HapType::AccessoryMetrics => "270".into(),
			HapType::AccessoryRuntimeInformation => "239".into(),
			HapType::AirPurifier => "BB".into(),
			HapType::AirQualitySensor => "8D".into(),
			HapType::AssetUpdate => "267".into(),
			HapType::Assistant => "26A".into(),
			HapType::AudioStreamManagement => "127".into(),
			HapType::Battery => "96".into(),
			HapType::CameraOperatingMode => "21A".into(),
			HapType::CameraRecordingManagement => "204".into(),
			HapType::CameraStreamManagement => "110".into(),
			HapType::CarbonDioxideSensor => "97".into(),
			HapType::CarbonMonoxideSensor => "7F".into(),
			HapType::CloudRelay => "5A".into(),
			HapType::ContactSensor => "80".into(),
			HapType::DataStreamTransportManagement => "129".into(),
			HapType::Diagnostics => "237".into(),
			HapType::Door => "81".into(),
			HapType::Doorbell => "121".into(),
			HapType::Fan => "40".into(),
			HapType::FanV2 => "B7".into(),
			HapType::Faucet => "D7".into(),
			HapType::FilterMaintenance => "BA".into(),
			HapType::GarageDoorOpener => "41".into(),
			HapType::HeaterCooler => "BC".into(),
			HapType::HumidifierDehumidifier => "BD".into(),
			HapType::HumiditySensor => "82".into(),
			HapType::InputSource => "D9".into(),
			HapType::IrrigationSystem => "CF".into(),
			HapType::Label => "CC".into(),
			HapType::LeakSensor => "83".into(),
			HapType::LightSensor => "84".into(),
			HapType::Lightbulb => "43".into(),
			HapType::LockManagement => "44".into(),
			HapType::LockMechanism => "45".into(),
			HapType::Microphone => "112".into(),
			HapType::MotionSensor => "85".into(),
			HapType::NfcAccessService => "266".into(),
			HapType::OccupancySensor => "86".into(),
			HapType::Outlet => "47".into(),
			HapType::Pairing => "55".into(),
			HapType::PowerManagement => "221".into(),
			HapType::ProtocolInformation => "A2".into(),
			HapType::SecuritySystem => "7E".into(),
			HapType::Siri => "133".into(),
			HapType::SiriEndpoint => "253".into(),
			HapType::Slats => "B9".into(),
			HapType::SmartSpeaker => "228".into(),
			HapType::SmokeSensor => "87".into(),
			HapType::Speaker => "113".into(),
			HapType::StatefulProgrammableSwitch => "88".into(),
			HapType::StatelessProgrammableSwitch => "89".into(),
			HapType::Switch => "49".into(),
			HapType::TargetControl => "125".into(),
			HapType::TargetControlManagement => "122".into(),
			HapType::Television => "D8".into(),
			HapType::TemperatureSensor => "8A".into(),
			HapType::Thermostat => "4A".into(),
			HapType::ThreadTransport => "701".into(),
			HapType::TransferTransportManagement => "203".into(),
			HapType::Valve => "D0".into(),
			HapType::WiFiRouter => "20A".into(),
			HapType::WiFiSatellite => "20F".into(),
			HapType::WiFiTransport => "22A".into(),
			HapType::Window => "8B".into(),
			HapType::WindowCovering => "8C".into(),
		}
    }
}

impl FromStr for HapType {
    type Err = Error;

    fn from_str(s: &str) -> Result<Self, Self::Err> {
        if let Ok(uuid) = Uuid::parse_str(s) {
            return Ok(HapType::Custom(uuid));
        }

        match s {
            "unknown" => Ok(HapType::Unknown),
			"262" => Ok(HapType::AccessCodeControlPoint),
			"261" => Ok(HapType::AccessCodeSupportedConfiguration),
			"E5" => Ok(HapType::AccessControlLevel),
			"A6" => Ok(HapType::AccessoryFlags),
			"57" => Ok(HapType::AccessoryIdentifier),
			"B0" => Ok(HapType::Active),
			"E7" => Ok(HapType::ActiveIdentifier),
			"23B" => Ok(HapType::ActivityInterval),
			"1" => Ok(HapType::AdministratorOnlyAccess),
			"64" => Ok(HapType::AirParticulateDensity),
			"65" => Ok(HapType::AirParticulateSize),
			"25B" => Ok(HapType::AirplayEnable),
			"A4" => Ok(HapType::ApplicationMatchingIdentifier),
			"269" => Ok(HapType::AssetUpdateReadiness),
			"5" => Ok(HapType::AudioFeedback),
			"68" => Ok(HapType::BatteryLevel),
			"8" => Ok(HapType::Brightness),
			"126" => Ok(HapType::ButtonEvent),
			"246" => Ok(HapType::CcaEnergyDetectThreshold),
			"245" => Ok(HapType::CcaSignalDetectThreshold),
			"21D" => Ok(HapType::CameraOperatingModeIndicator),
			"92" => Ok(HapType::CarbonDioxideDetected),
			"93" => Ok(HapType::CarbonDioxideLevel),
			"94" => Ok(HapType::CarbonDioxidePeakLevel),
			"69" => Ok(HapType::CarbonMonoxideDetected),
			"90" => Ok(HapType::CarbonMonoxideLevel),
			"91" => Ok(HapType::CarbonMonoxidePeakLevel),
			"24B" => Ok(HapType::CharacteristicValueActiveTransitionCount),
			"143" => Ok(HapType::CharacteristicValueTransitionControl),
			"8F" => Ok(HapType::ChargingState),
			"DD" => Ok(HapType::ClosedCaptions),
			"5E" => Ok(HapType::CloudRelayControlPoint),
			"5C" => Ok(HapType::CloudRelayCurrentState),
			"5B" => Ok(HapType::CloudRelayEnableStatus),
			"CE" => Ok(HapType::ColorTemperature),
			"263" => Ok(HapType::ConfigurationState),
			"E3" => Ok(HapType::ConfiguredName),
			"6A" => Ok(HapType::ContactSensorState),
			"D" => Ok(HapType::CoolingThresholdTemperature),
			"A9" => Ok(HapType::CurrentAirPurifierState),
			"95" => Ok(HapType::CurrentAirQuality),
			"E" => Ok(HapType::CurrentDoorState),
			"AF" => Ok(HapType::CurrentFanState),
			"B1" => Ok(HapType::CurrentHeaterCoolerState),
			"F" => Ok(HapType::CurrentHeatingCoolingState),
			"6C" => Ok(HapType::CurrentHorizontalTiltAngle),
			"B3" => Ok(HapType::CurrentHumidifierDehumidifierState),
			"6B" => Ok(HapType::CurrentLightLevel),
			"E0" => Ok(HapType::CurrentMediaState),
			"6D" => Ok(HapType::CurrentPosition),
			"10" => Ok(HapType::CurrentRelativeHumidity),
			"AA" => Ok(HapType::CurrentSlatState),
			"11" => Ok(HapType::CurrentTemperature),
			"C1" => Ok(HapType::CurrentTiltAngle),
			"22B" => Ok(HapType::CurrentTransport),
			"6E" => Ok(HapType::CurrentVerticalTiltAngle),
			"135" => Ok(HapType::CurrentVisibilityState),
			"B5" => Ok(HapType::CurrentWaterLevel),
			"138" => Ok(HapType::DataStreamHapTransport),
			"139" => Ok(HapType::DataStreamHapTransportInterrupt),
			"11D" => Ok(HapType::DigitalZoom),
			"136" => Ok(HapType::DisplayOrder),
			"23D" => Ok(HapType::EventRetransmissionMaximum),
			"223" => Ok(HapType::EventSnapshotsActive),
			"23E" => Ok(HapType::EventTransmissionCounters),
			"AC" => Ok(HapType::FilterChangeIndication),
			"AB" => Ok(HapType::FilterLifeLevel),
			"AD" => Ok(HapType::FilterResetChangeIndication),
			"52" => Ok(HapType::FirmwareRevision),
			"234" => Ok(HapType::FirmwareUpdateReadiness),
			"235" => Ok(HapType::FirmwareUpdateStatus),
			"26C" => Ok(HapType::HardwareFinish),
			"53" => Ok(HapType::HardwareRevision),
			"24A" => Ok(HapType::HeartBeat),
			"12" => Ok(HapType::HeatingThresholdTemperature),
			"6F" => Ok(HapType::HoldPosition),
			"21B" => Ok(HapType::HomekitCameraActive),
			"13" => Ok(HapType::Hue),
			"E6" => Ok(HapType::Identifier),
			"14" => Ok(HapType::Identify),
			"11F" => Ok(HapType::ImageMirroring),
			"11E" => Ok(HapType::ImageRotation),
			"D2" => Ok(HapType::InUse),
			"DC" => Ok(HapType::InputDeviceType),
			"DB" => Ok(HapType::InputSourceType),
			"D6" => Ok(HapType::IsConfigured),
			"CB" => Ok(HapType::LabelIndex),
			"CD" => Ok(HapType::LabelNamespace),
			"70" => Ok(HapType::LeakDetected),
			"50" => Ok(HapType::ListPairings),
			"19" => Ok(HapType::LockControlPoint),
			"1D" => Ok(HapType::LockCurrentState),
			"1C" => Ok(HapType::LockLastKnownAction),
			"1A" => Ok(HapType::LockManagementAutoSecurityTimeout),
			"A7" => Ok(HapType::LockPhysicalControls),
			"1E" => Ok(HapType::LockTargetState),
			"1F" => Ok(HapType::Logs),
			"247" => Ok(HapType::MacRetransmissionMaximum),
			"248" => Ok(HapType::MacTransmissionCounters),
			"215" => Ok(HapType::ManagedNetworkEnable),
			"227" => Ok(HapType::ManuallyDisabled),
			"20" => Ok(HapType::Manufacturer),
			"243" => Ok(HapType::MaximumTransmitPower),
			"21" => Ok(HapType::Model),
			"22" => Ok(HapType::MotionDetected),
			"26B" => Ok(HapType::MultifunctionButton),
			"11A" => Ok(HapType::Mute),
			"264" => Ok(HapType::NfcAccessControlPoint),
			"265" => Ok(HapType::NfcAccessSupportedConfiguration),
			"23" => Ok(HapType::Name),
			"21F" => Ok(HapType::NetworkAccessViolationControl),
			"20C" => Ok(HapType::NetworkClientControl),
			"20D" => Ok(HapType::NetworkClientStatusControl),
			"11B" => Ok(HapType::NightVision),
			"C4" => Ok(HapType::NitrogenDioxideDensity),
			"24" => Ok(HapType::ObstructionDetected),
			"71" => Ok(HapType::OccupancyDetected),
			"232" => Ok(HapType::OperatingStateResponse),
			"11C" => Ok(HapType::OpticalZoom),
			"26" => Ok(HapType::OutletInUse),
			"C3" => Ok(HapType::OzoneDensity),
			"C7" => Ok(HapType::Pm10Density),
			"C6" => Ok(HapType::Pm2_5Density),
			"4C" => Ok(HapType::PairSetup),
			"4E" => Ok(HapType::PairVerify),
			"4F" => Ok(HapType::PairingFeatures),
			"E4" => Ok(HapType::PasswordSetting),
			"225" => Ok(HapType::PeriodicSnapshotsActive),
			"E2" => Ok(HapType::PictureMode),
			"23C" => Ok(HapType::Ping),
			"72" => Ok(HapType::PositionState),
			"DF" => Ok(HapType::PowerModeSelection),
			"25" => Ok(HapType::PowerState),
			"220" => Ok(HapType::ProductData),
			"D1" => Ok(HapType::ProgramMode),
			"73" => Ok(HapType::ProgrammableSwitchEvent),
			"74" => Ok(HapType::ProgrammableSwitchOutputState),
			"23F" => Ok(HapType::ReceivedSignalStrengthIndication),
			"244" => Ok(HapType::ReceiverSensitivity),
			"C9" => Ok(HapType::RelativeHumidityDehumidifierThreshold),
			"CA" => Ok(HapType::RelativeHumidityHumidifierThreshold),
			"D4" => Ok(HapType::RemainingDuration),
			"E1" => Ok(HapType::RemoteKey),
			"28" => Ok(HapType::RotationDirection),
			"29" => Ok(HapType::RotationSpeed),
			"20E" => Ok(HapType::RouterStatus),
			"2F" => Ok(HapType::Saturation),
			"8E" => Ok(HapType::SecuritySystemAlarmType),
			"66" => Ok(HapType::SecuritySystemCurrentState),
			"67" => Ok(HapType::SecuritySystemTargetState),
			"128" => Ok(HapType::SelectedAudioStreamConfiguration),
			"209" => Ok(HapType::SelectedCameraRecordingConfiguration),
			"24D" => Ok(HapType::SelectedDiagnosticsModes),
			"117" => Ok(HapType::SelectedStreamConfiguration),
			"30" => Ok(HapType::SerialNumber),
			"A5" => Ok(HapType::ServiceSignature),
			"D3" => Ok(HapType::SetDuration),
			"131" => Ok(HapType::SetupDataStreamTransport),
			"118" => Ok(HapType::SetupEndpoint),
			"201" => Ok(HapType::SetupTransferTransport),
			"241" => Ok(HapType::SignalToNoiseRatio),
			"255" => Ok(HapType::SiriEnable),
			"254" => Ok(HapType::SiriEndpointSessionStatus),
			"25A" => Ok(HapType::SiriEngineVersion),
			"132" => Ok(HapType::SiriInputType),
			"258" => Ok(HapType::SiriLightOnUse),
			"256" => Ok(HapType::SiriListening),
			"257" => Ok(HapType::SiriTouchToUse),
			"C0" => Ok(HapType::SlatType),
			"E8" => Ok(HapType::SleepDiscoveryMode),
			"23A" => Ok(HapType::SleepInterval),
			"76" => Ok(HapType::SmokeDetected),
			"54" => Ok(HapType::SoftwareRevision),
			"249" => Ok(HapType::StagedFirmwareVersion),
			"75" => Ok(HapType::StatusActive),
			"77" => Ok(HapType::StatusFault),
			"78" => Ok(HapType::StatusJammed),
			"79" => Ok(HapType::StatusLowBattery),
			"7A" => Ok(HapType::StatusTampered),
			"120" => Ok(HapType::StreamingStatus),
			"C5" => Ok(HapType::SulphurDioxideDensity),
			"268" => Ok(HapType::SupportedAssetTypes),
			"207" => Ok(HapType::SupportedAudioRecordingConfiguration),
			"115" => Ok(HapType::SupportedAudioStreamConfiguration),
			"205" => Ok(HapType::SupportedCameraRecordingConfiguration),
			"144" => Ok(HapType::SupportedCharacteristicValueTransitionConfiguration),
			"130" => Ok(HapType::SupportedDataStreamTransportConfiguration),
			"24C" => Ok(HapType::SupportedDiagnosticsModes),
			"238" => Ok(HapType::SupportedDiagnosticsSnapshot),
			"233" => Ok(HapType::SupportedFirmwareUpdateConfiguration),
			"116" => Ok(HapType::SupportedRtpConfiguration),
			"210" => Ok(HapType::SupportedRouterConfiguration),
			"123" => Ok(HapType::SupportedTargetConfiguration),
			"202" => Ok(HapType::SupportedTransferTransportConfiguration),
			"206" => Ok(HapType::SupportedVideoRecordingConfiguration),
			"114" => Ok(HapType::SupportedVideoStreamConfiguration),
			"B6" => Ok(HapType::SwingMode),
			"A8" => Ok(HapType::TargetAirPurifierState),
			"32" => Ok(HapType::TargetDoorState),
			"BF" => Ok(HapType::TargetFanState),
			"B2" => Ok(HapType::TargetHeaterCoolerState),
			"33" => Ok(HapType::TargetHeatingCoolingState),
			"7B" => Ok(HapType::TargetHorizontalTiltAngle),
			"B4" => Ok(HapType::TargetHumidifierDehumidifierState),
			"124" => Ok(HapType::TargetListConfiguration),
			"137" => Ok(HapType::TargetMediaState),
			"7C" => Ok(HapType::TargetPosition),
			"34" => Ok(HapType::TargetRelativeHumidity),
			"35" => Ok(HapType::TargetTemperature),
			"C2" => Ok(HapType::TargetTiltAngle),
			"7D" => Ok(HapType::TargetVerticalTiltAngle),
			"134" => Ok(HapType::TargetVisibilityState),
			"36" => Ok(HapType::TemperatureDisplayUnits),
			"21C" => Ok(HapType::ThirdPartyCameraActive),
			"704" => Ok(HapType::ThreadControlPoint),
			"702" => Ok(HapType::ThreadNodeCapabilities),
			"706" => Ok(HapType::ThreadOpenthreadVersion),
			"703" => Ok(HapType::ThreadStatus),
			"242" => Ok(HapType::TransmitPower),
			"D5" => Ok(HapType::ValveType),
			"37" => Ok(HapType::Version),
			"229" => Ok(HapType::VideoAnalysisActive),
			"C8" => Ok(HapType::VolatileOrganicCompoundDensity),
			"119" => Ok(HapType::Volume),
			"E9" => Ok(HapType::VolumeControlType),
			"EA" => Ok(HapType::VolumeSelector),
			"211" => Ok(HapType::WanConfigurationList),
			"212" => Ok(HapType::WanStatusList),
			"222" => Ok(HapType::WakeConfiguration),
			"22C" => Ok(HapType::WiFiCapabilities),
			"22D" => Ok(HapType::WiFiConfigurationControl),
			"21E" => Ok(HapType::WiFiSatelliteStatus),
			"226" => Ok(HapType::RecordingAudioActive),
			"260" => Ok(HapType::AccessCode),
			"DA" => Ok(HapType::AccessControl),
			"3E" => Ok(HapType::AccessoryInformation),
			"270" => Ok(HapType::AccessoryMetrics),
			"239" => Ok(HapType::AccessoryRuntimeInformation),
			"BB" => Ok(HapType::AirPurifier),
			"8D" => Ok(HapType::AirQualitySensor),
			"267" => Ok(HapType::AssetUpdate),
			"26A" => Ok(HapType::Assistant),
			"127" => Ok(HapType::AudioStreamManagement),
			"96" => Ok(HapType::Battery),
			"21A" => Ok(HapType::CameraOperatingMode),
			"204" => Ok(HapType::CameraRecordingManagement),
			"110" => Ok(HapType::CameraStreamManagement),
			"97" => Ok(HapType::CarbonDioxideSensor),
			"7F" => Ok(HapType::CarbonMonoxideSensor),
			"5A" => Ok(HapType::CloudRelay),
			"80" => Ok(HapType::ContactSensor),
			"129" => Ok(HapType::DataStreamTransportManagement),
			"237" => Ok(HapType::Diagnostics),
			"81" => Ok(HapType::Door),
			"121" => Ok(HapType::Doorbell),
			"40" => Ok(HapType::Fan),
			"B7" => Ok(HapType::FanV2),
			"D7" => Ok(HapType::Faucet),
			"BA" => Ok(HapType::FilterMaintenance),
			"41" => Ok(HapType::GarageDoorOpener),
			"BC" => Ok(HapType::HeaterCooler),
			"BD" => Ok(HapType::HumidifierDehumidifier),
			"82" => Ok(HapType::HumiditySensor),
			"D9" => Ok(HapType::InputSource),
			"CF" => Ok(HapType::IrrigationSystem),
			"CC" => Ok(HapType::Label),
			"83" => Ok(HapType::LeakSensor),
			"84" => Ok(HapType::LightSensor),
			"43" => Ok(HapType::Lightbulb),
			"44" => Ok(HapType::LockManagement),
			"45" => Ok(HapType::LockMechanism),
			"112" => Ok(HapType::Microphone),
			"85" => Ok(HapType::MotionSensor),
			"266" => Ok(HapType::NfcAccessService),
			"86" => Ok(HapType::OccupancySensor),
			"47" => Ok(HapType::Outlet),
			"55" => Ok(HapType::Pairing),
			"221" => Ok(HapType::PowerManagement),
			"A2" => Ok(HapType::ProtocolInformation),
			"7E" => Ok(HapType::SecuritySystem),
			"133" => Ok(HapType::Siri),
			"253" => Ok(HapType::SiriEndpoint),
			"B9" => Ok(HapType::Slats),
			"228" => Ok(HapType::SmartSpeaker),
			"87" => Ok(HapType::SmokeSensor),
			"113" => Ok(HapType::Speaker),
			"88" => Ok(HapType::StatefulProgrammableSwitch),
			"89" => Ok(HapType::StatelessProgrammableSwitch),
			"49" => Ok(HapType::Switch),
			"125" => Ok(HapType::TargetControl),
			"122" => Ok(HapType::TargetControlManagement),
			"D8" => Ok(HapType::Television),
			"8A" => Ok(HapType::TemperatureSensor),
			"4A" => Ok(HapType::Thermostat),
			"701" => Ok(HapType::ThreadTransport),
			"203" => Ok(HapType::TransferTransportManagement),
			"D0" => Ok(HapType::Valve),
			"20A" => Ok(HapType::WiFiRouter),
			"20F" => Ok(HapType::WiFiSatellite),
			"22A" => Ok(HapType::WiFiTransport),
			"8B" => Ok(HapType::Window),
			"8C" => Ok(HapType::WindowCovering),
			_ => Err(Error::InvalidHapTypeString(s.to_string())),
		}
    }
}

impl Default for HapType {
    fn default() -> HapType { HapType::Unknown }
}

impl<'de> Deserialize<'de> for HapType {
    fn deserialize<D>(deserializer: D) -> Result<HapType, D::Error>
    where
        D: Deserializer<'de>,
    {
        let s = String::deserialize(deserializer)?;
        let hap_type = HapType::from_str(&s).map_err(de::Error::custom)?;
        Ok(hap_type)
    }
}

impl Serialize for HapType {
    fn serialize<S: Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        serializer.serialize_str(&self.to_string())
    }
}
