// this file is auto-generated by hap-codegen

use serde::ser::{Serialize, SerializeStruct, Serializer};

use crate::{
    service::HapService,
    characteristic::{
        HapCharacteristic,
		siri_endpoint_session_status::SiriEndpointSessionStatusCharacteristic,
		version::VersionCharacteristic,
		active_identifier::ActiveIdentifierCharacteristic,
		manually_disabled::ManuallyDisabledCharacteristic,
	},
    HapType,
};

/// Siri Endpoint service.
#[derive(Debug, Default)]
pub struct SiriEndpointService {
    /// Instance ID of the Siri Endpoint service.
    id: u64,
    /// [`HapType`](HapType) of the Siri Endpoint service.
    hap_type: HapType,
    /// When set to true, this service is not visible to user.
    hidden: bool,
    /// When set to true, this is the primary service on the accessory.
    primary: bool,
    /// An array of numbers containing the instance IDs of the services that this service links to.
    linked_services: Vec<u64>,

	/// Siri Endpoint Session Status characteristic (required).
	pub siri_endpoint_session_status: SiriEndpointSessionStatusCharacteristic,
	/// Version characteristic (required).
	pub version: VersionCharacteristic,

	/// Active Identifier characteristic (optional).
	pub active_identifier: Option<ActiveIdentifierCharacteristic>,
	/// Manually disabled characteristic (optional).
	pub manually_disabled: Option<ManuallyDisabledCharacteristic>,
}

impl SiriEndpointService {
    /// Creates a new Siri Endpoint service.
    pub fn new(id: u64, accessory_id: u64) -> Self {
        Self {
            id,
            hap_type: HapType::SiriEndpoint,
			siri_endpoint_session_status: SiriEndpointSessionStatusCharacteristic::new(id + 1 + 0, accessory_id),
			version: VersionCharacteristic::new(id + 1 + 1, accessory_id),
			active_identifier: Some(ActiveIdentifierCharacteristic::new(id + 1 + 0 + 2, accessory_id)),
			manually_disabled: Some(ManuallyDisabledCharacteristic::new(id + 1 + 1 + 2, accessory_id)),
			..Default::default()
        }
    }
}

impl HapService for SiriEndpointService {
    fn get_id(&self) -> u64 {
        self.id
    }

    fn get_type(&self) -> HapType {
        self.hap_type
    }

    fn get_hidden(&self) -> bool {
        self.hidden
    }

    fn set_hidden(&mut self, hidden: bool) {
        self.hidden = hidden;
    }

    fn get_primary(&self) -> bool {
        self.primary
    }

    fn set_primary(&mut self, primary: bool) {
        self.primary = primary;
    }

    fn get_linked_services(&self) -> Vec<u64> {
        self.linked_services.clone()
    }

    fn set_linked_services(&mut self, linked_services: Vec<u64>) {
        self.linked_services = linked_services;
    }

    fn get_characteristic(&self, hap_type: HapType) -> Option<&dyn HapCharacteristic> {
        for characteristic in self.get_characteristics() {
            if characteristic.get_type() == hap_type {
                return Some(characteristic);
            }
        }
        None
    }

    fn get_mut_characteristic(&mut self, hap_type: HapType) -> Option<&mut dyn HapCharacteristic> {
        for characteristic in self.get_mut_characteristics() {
            if characteristic.get_type() == hap_type {
                return Some(characteristic);
            }
        }
        None
    }

    fn get_characteristics(&self) -> Vec<&dyn HapCharacteristic> {
        #[allow(unused_mut)]
        let mut characteristics: Vec<&dyn HapCharacteristic> = vec![
			&self.siri_endpoint_session_status,
			&self.version,
		];
		if let Some(c) = &self.active_identifier {
		    characteristics.push(c);
		}
		if let Some(c) = &self.manually_disabled {
		    characteristics.push(c);
		}
		characteristics
    }

    fn get_mut_characteristics(&mut self) -> Vec<&mut dyn HapCharacteristic> {
        #[allow(unused_mut)]
        let mut characteristics: Vec<&mut dyn HapCharacteristic> = vec![
			&mut self.siri_endpoint_session_status,
			&mut self.version,
		];
		if let Some(c) = &mut self.active_identifier {
		    characteristics.push(c);
		}
		if let Some(c) = &mut self.manually_disabled {
		    characteristics.push(c);
		}
		characteristics
    }
}

impl Serialize for SiriEndpointService {
    fn serialize<S: Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        let mut state = serializer.serialize_struct("HapService", 5)?;
        state.serialize_field("iid", &self.get_id())?;
        state.serialize_field("type", &self.get_type())?;
        state.serialize_field("hidden", &self.get_hidden())?;
        state.serialize_field("primary", &self.get_primary())?;
        state.serialize_field("characteristics", &self.get_characteristics())?;
        // linked services left out for now
        state.end()
    }
}
