// this file is auto-generated by hap-codegen

use serde::ser::{Serialize, SerializeStruct, Serializer};

use crate::{
    service::HapService,
    characteristic::{
        HapCharacteristic,
		list_pairings::ListPairingsCharacteristic,
		pair_setup::PairSetupCharacteristic,
		pair_verify::PairVerifyCharacteristic,
		pairing_features::PairingFeaturesCharacteristic,
	},
    HapType,
};

/// Pairing service.
#[derive(Debug, Default)]
pub struct PairingService {
    /// Instance ID of the Pairing service.
    id: u64,
    /// [`HapType`](HapType) of the Pairing service.
    hap_type: HapType,
    /// When set to true, this service is not visible to user.
    hidden: bool,
    /// When set to true, this is the primary service on the accessory.
    primary: bool,
    /// An array of numbers containing the instance IDs of the services that this service links to.
    linked_services: Vec<u64>,

	/// List Pairings characteristic (required).
	pub list_pairings: ListPairingsCharacteristic,
	/// Pair Setup characteristic (required).
	pub pair_setup: PairSetupCharacteristic,
	/// Pair Verify characteristic (required).
	pub pair_verify: PairVerifyCharacteristic,
	/// Pairing Features characteristic (required).
	pub pairing_features: PairingFeaturesCharacteristic,

}

impl PairingService {
    /// Creates a new Pairing service.
    pub fn new(id: u64, accessory_id: u64) -> Self {
        Self {
            id,
            hap_type: HapType::Pairing,
			list_pairings: ListPairingsCharacteristic::new(id + 1 + 0, accessory_id),
			pair_setup: PairSetupCharacteristic::new(id + 1 + 1, accessory_id),
			pair_verify: PairVerifyCharacteristic::new(id + 1 + 2, accessory_id),
			pairing_features: PairingFeaturesCharacteristic::new(id + 1 + 3, accessory_id),
			..Default::default()
        }
    }
}

impl HapService for PairingService {
    fn get_id(&self) -> u64 {
        self.id
    }

    fn get_type(&self) -> HapType {
        self.hap_type
    }

    fn get_hidden(&self) -> bool {
        self.hidden
    }

    fn set_hidden(&mut self, hidden: bool) {
        self.hidden = hidden;
    }

    fn get_primary(&self) -> bool {
        self.primary
    }

    fn set_primary(&mut self, primary: bool) {
        self.primary = primary;
    }

    fn get_linked_services(&self) -> Vec<u64> {
        self.linked_services.clone()
    }

    fn set_linked_services(&mut self, linked_services: Vec<u64>) {
        self.linked_services = linked_services;
    }

    fn get_characteristic(&self, hap_type: HapType) -> Option<&dyn HapCharacteristic> {
        for characteristic in self.get_characteristics() {
            if characteristic.get_type() == hap_type {
                return Some(characteristic);
            }
        }
        None
    }

    fn get_mut_characteristic(&mut self, hap_type: HapType) -> Option<&mut dyn HapCharacteristic> {
        for characteristic in self.get_mut_characteristics() {
            if characteristic.get_type() == hap_type {
                return Some(characteristic);
            }
        }
        None
    }

    fn get_characteristics(&self) -> Vec<&dyn HapCharacteristic> {
        #[allow(unused_mut)]
        let mut characteristics: Vec<&dyn HapCharacteristic> = vec![
			&self.list_pairings,
			&self.pair_setup,
			&self.pair_verify,
			&self.pairing_features,
		];
		characteristics
    }

    fn get_mut_characteristics(&mut self) -> Vec<&mut dyn HapCharacteristic> {
        #[allow(unused_mut)]
        let mut characteristics: Vec<&mut dyn HapCharacteristic> = vec![
			&mut self.list_pairings,
			&mut self.pair_setup,
			&mut self.pair_verify,
			&mut self.pairing_features,
		];
		characteristics
    }
}

impl Serialize for PairingService {
    fn serialize<S: Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        let mut state = serializer.serialize_struct("HapService", 5)?;
        state.serialize_field("iid", &self.get_id())?;
        state.serialize_field("type", &self.get_type())?;
        state.serialize_field("hidden", &self.get_hidden())?;
        state.serialize_field("primary", &self.get_primary())?;
        state.serialize_field("characteristics", &self.get_characteristics())?;
        // linked services left out for now
        state.end()
    }
}
