// this file is auto-generated by hap-codegen

use serde::ser::{Serialize, SerializeStruct, Serializer};

use crate::{
    service::HapService,
    characteristic::{
        HapCharacteristic,
		siri_input_type::SiriInputTypeCharacteristic,
		multifunction_button::MultifunctionButtonCharacteristic,
		siri_enable::SiriEnableCharacteristic,
		siri_engine_version::SiriEngineVersionCharacteristic,
		siri_light_on_use::SiriLightOnUseCharacteristic,
		siri_listening::SiriListeningCharacteristic,
		siri_touch_to_use::SiriTouchToUseCharacteristic,
	},
    HapType,
};

/// Siri service.
#[derive(Debug, Default)]
pub struct SiriService {
    /// Instance ID of the Siri service.
    id: u64,
    /// [`HapType`](HapType) of the Siri service.
    hap_type: HapType,
    /// When set to true, this service is not visible to user.
    hidden: bool,
    /// When set to true, this is the primary service on the accessory.
    primary: bool,
    /// An array of numbers containing the instance IDs of the services that this service links to.
    linked_services: Vec<u64>,

	/// Siri Input Type characteristic (required).
	pub siri_input_type: SiriInputTypeCharacteristic,

	/// Multifunction Button characteristic (optional).
	pub multifunction_button: Option<MultifunctionButtonCharacteristic>,
	/// Siri Enable characteristic (optional).
	pub siri_enable: Option<SiriEnableCharacteristic>,
	/// Siri Engine Version characteristic (optional).
	pub siri_engine_version: Option<SiriEngineVersionCharacteristic>,
	/// Siri Light On Use characteristic (optional).
	pub siri_light_on_use: Option<SiriLightOnUseCharacteristic>,
	/// Siri Listening characteristic (optional).
	pub siri_listening: Option<SiriListeningCharacteristic>,
	/// Siri Touch To Use characteristic (optional).
	pub siri_touch_to_use: Option<SiriTouchToUseCharacteristic>,
}

impl SiriService {
    /// Creates a new Siri service.
    pub fn new(id: u64, accessory_id: u64) -> Self {
        Self {
            id,
            hap_type: HapType::Siri,
			siri_input_type: SiriInputTypeCharacteristic::new(id + 1 + 0, accessory_id),
			multifunction_button: Some(MultifunctionButtonCharacteristic::new(id + 1 + 0 + 1, accessory_id)),
			siri_enable: Some(SiriEnableCharacteristic::new(id + 1 + 1 + 1, accessory_id)),
			siri_engine_version: Some(SiriEngineVersionCharacteristic::new(id + 1 + 2 + 1, accessory_id)),
			siri_light_on_use: Some(SiriLightOnUseCharacteristic::new(id + 1 + 3 + 1, accessory_id)),
			siri_listening: Some(SiriListeningCharacteristic::new(id + 1 + 4 + 1, accessory_id)),
			siri_touch_to_use: Some(SiriTouchToUseCharacteristic::new(id + 1 + 5 + 1, accessory_id)),
			..Default::default()
        }
    }
}

impl HapService for SiriService {
    fn get_id(&self) -> u64 {
        self.id
    }

    fn get_type(&self) -> HapType {
        self.hap_type
    }

    fn get_hidden(&self) -> bool {
        self.hidden
    }

    fn set_hidden(&mut self, hidden: bool) {
        self.hidden = hidden;
    }

    fn get_primary(&self) -> bool {
        self.primary
    }

    fn set_primary(&mut self, primary: bool) {
        self.primary = primary;
    }

    fn get_linked_services(&self) -> Vec<u64> {
        self.linked_services.clone()
    }

    fn set_linked_services(&mut self, linked_services: Vec<u64>) {
        self.linked_services = linked_services;
    }

    fn get_characteristic(&self, hap_type: HapType) -> Option<&dyn HapCharacteristic> {
        for characteristic in self.get_characteristics() {
            if characteristic.get_type() == hap_type {
                return Some(characteristic);
            }
        }
        None
    }

    fn get_mut_characteristic(&mut self, hap_type: HapType) -> Option<&mut dyn HapCharacteristic> {
        for characteristic in self.get_mut_characteristics() {
            if characteristic.get_type() == hap_type {
                return Some(characteristic);
            }
        }
        None
    }

    fn get_characteristics(&self) -> Vec<&dyn HapCharacteristic> {
        #[allow(unused_mut)]
        let mut characteristics: Vec<&dyn HapCharacteristic> = vec![
			&self.siri_input_type,
		];
		if let Some(c) = &self.multifunction_button {
		    characteristics.push(c);
		}
		if let Some(c) = &self.siri_enable {
		    characteristics.push(c);
		}
		if let Some(c) = &self.siri_engine_version {
		    characteristics.push(c);
		}
		if let Some(c) = &self.siri_light_on_use {
		    characteristics.push(c);
		}
		if let Some(c) = &self.siri_listening {
		    characteristics.push(c);
		}
		if let Some(c) = &self.siri_touch_to_use {
		    characteristics.push(c);
		}
		characteristics
    }

    fn get_mut_characteristics(&mut self) -> Vec<&mut dyn HapCharacteristic> {
        #[allow(unused_mut)]
        let mut characteristics: Vec<&mut dyn HapCharacteristic> = vec![
			&mut self.siri_input_type,
		];
		if let Some(c) = &mut self.multifunction_button {
		    characteristics.push(c);
		}
		if let Some(c) = &mut self.siri_enable {
		    characteristics.push(c);
		}
		if let Some(c) = &mut self.siri_engine_version {
		    characteristics.push(c);
		}
		if let Some(c) = &mut self.siri_light_on_use {
		    characteristics.push(c);
		}
		if let Some(c) = &mut self.siri_listening {
		    characteristics.push(c);
		}
		if let Some(c) = &mut self.siri_touch_to_use {
		    characteristics.push(c);
		}
		characteristics
    }
}

impl Serialize for SiriService {
    fn serialize<S: Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        let mut state = serializer.serialize_struct("HapService", 5)?;
        state.serialize_field("iid", &self.get_id())?;
        state.serialize_field("type", &self.get_type())?;
        state.serialize_field("hidden", &self.get_hidden())?;
        state.serialize_field("primary", &self.get_primary())?;
        state.serialize_field("characteristics", &self.get_characteristics())?;
        // linked services left out for now
        state.end()
    }
}
