// this file is auto-generated by hap-codegen

use serde::ser::{Serialize, SerializeStruct, Serializer};

use crate::{
    service::HapService,
    characteristic::{
        HapCharacteristic,
		event_snapshots_active::EventSnapshotsActiveCharacteristic,
		homekit_camera_active::HomekitCameraActiveCharacteristic,
		camera_operating_mode_indicator::CameraOperatingModeIndicatorCharacteristic,
		manually_disabled::ManuallyDisabledCharacteristic,
		night_vision::NightVisionCharacteristic,
		periodic_snapshots_active::PeriodicSnapshotsActiveCharacteristic,
		third_party_camera_active::ThirdPartyCameraActiveCharacteristic,
	},
    HapType,
};

/// Camera Operating Mode service.
#[derive(Debug, Default)]
pub struct CameraOperatingModeService {
    /// Instance ID of the Camera Operating Mode service.
    id: u64,
    /// [`HapType`](HapType) of the Camera Operating Mode service.
    hap_type: HapType,
    /// When set to true, this service is not visible to user.
    hidden: bool,
    /// When set to true, this is the primary service on the accessory.
    primary: bool,
    /// An array of numbers containing the instance IDs of the services that this service links to.
    linked_services: Vec<u64>,

	/// Event Snapshots Active characteristic (required).
	pub event_snapshots_active: EventSnapshotsActiveCharacteristic,
	/// HomeKit Camera Active characteristic (required).
	pub homekit_camera_active: HomekitCameraActiveCharacteristic,

	/// Camera Operating Mode Indicator characteristic (optional).
	pub camera_operating_mode_indicator: Option<CameraOperatingModeIndicatorCharacteristic>,
	/// Manually disabled characteristic (optional).
	pub manually_disabled: Option<ManuallyDisabledCharacteristic>,
	/// Night Vision characteristic (optional).
	pub night_vision: Option<NightVisionCharacteristic>,
	/// Periodic Snapshots Active characteristic (optional).
	pub periodic_snapshots_active: Option<PeriodicSnapshotsActiveCharacteristic>,
	/// Third Party Camera Active characteristic (optional).
	pub third_party_camera_active: Option<ThirdPartyCameraActiveCharacteristic>,
}

impl CameraOperatingModeService {
    /// Creates a new Camera Operating Mode service.
    pub fn new(id: u64, accessory_id: u64) -> Self {
        Self {
            id,
            hap_type: HapType::CameraOperatingMode,
			event_snapshots_active: EventSnapshotsActiveCharacteristic::new(id + 1 + 0, accessory_id),
			homekit_camera_active: HomekitCameraActiveCharacteristic::new(id + 1 + 1, accessory_id),
			camera_operating_mode_indicator: Some(CameraOperatingModeIndicatorCharacteristic::new(id + 1 + 0 + 2, accessory_id)),
			manually_disabled: Some(ManuallyDisabledCharacteristic::new(id + 1 + 1 + 2, accessory_id)),
			night_vision: Some(NightVisionCharacteristic::new(id + 1 + 2 + 2, accessory_id)),
			periodic_snapshots_active: Some(PeriodicSnapshotsActiveCharacteristic::new(id + 1 + 3 + 2, accessory_id)),
			third_party_camera_active: Some(ThirdPartyCameraActiveCharacteristic::new(id + 1 + 4 + 2, accessory_id)),
			..Default::default()
        }
    }
}

impl HapService for CameraOperatingModeService {
    fn get_id(&self) -> u64 {
        self.id
    }

    fn get_type(&self) -> HapType {
        self.hap_type
    }

    fn get_hidden(&self) -> bool {
        self.hidden
    }

    fn set_hidden(&mut self, hidden: bool) {
        self.hidden = hidden;
    }

    fn get_primary(&self) -> bool {
        self.primary
    }

    fn set_primary(&mut self, primary: bool) {
        self.primary = primary;
    }

    fn get_linked_services(&self) -> Vec<u64> {
        self.linked_services.clone()
    }

    fn set_linked_services(&mut self, linked_services: Vec<u64>) {
        self.linked_services = linked_services;
    }

    fn get_characteristic(&self, hap_type: HapType) -> Option<&dyn HapCharacteristic> {
        for characteristic in self.get_characteristics() {
            if characteristic.get_type() == hap_type {
                return Some(characteristic);
            }
        }
        None
    }

    fn get_mut_characteristic(&mut self, hap_type: HapType) -> Option<&mut dyn HapCharacteristic> {
        for characteristic in self.get_mut_characteristics() {
            if characteristic.get_type() == hap_type {
                return Some(characteristic);
            }
        }
        None
    }

    fn get_characteristics(&self) -> Vec<&dyn HapCharacteristic> {
        #[allow(unused_mut)]
        let mut characteristics: Vec<&dyn HapCharacteristic> = vec![
			&self.event_snapshots_active,
			&self.homekit_camera_active,
		];
		if let Some(c) = &self.camera_operating_mode_indicator {
		    characteristics.push(c);
		}
		if let Some(c) = &self.manually_disabled {
		    characteristics.push(c);
		}
		if let Some(c) = &self.night_vision {
		    characteristics.push(c);
		}
		if let Some(c) = &self.periodic_snapshots_active {
		    characteristics.push(c);
		}
		if let Some(c) = &self.third_party_camera_active {
		    characteristics.push(c);
		}
		characteristics
    }

    fn get_mut_characteristics(&mut self) -> Vec<&mut dyn HapCharacteristic> {
        #[allow(unused_mut)]
        let mut characteristics: Vec<&mut dyn HapCharacteristic> = vec![
			&mut self.event_snapshots_active,
			&mut self.homekit_camera_active,
		];
		if let Some(c) = &mut self.camera_operating_mode_indicator {
		    characteristics.push(c);
		}
		if let Some(c) = &mut self.manually_disabled {
		    characteristics.push(c);
		}
		if let Some(c) = &mut self.night_vision {
		    characteristics.push(c);
		}
		if let Some(c) = &mut self.periodic_snapshots_active {
		    characteristics.push(c);
		}
		if let Some(c) = &mut self.third_party_camera_active {
		    characteristics.push(c);
		}
		characteristics
    }
}

impl Serialize for CameraOperatingModeService {
    fn serialize<S: Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        let mut state = serializer.serialize_struct("HapService", 5)?;
        state.serialize_field("iid", &self.get_id())?;
        state.serialize_field("type", &self.get_type())?;
        state.serialize_field("hidden", &self.get_hidden())?;
        state.serialize_field("primary", &self.get_primary())?;
        state.serialize_field("characteristics", &self.get_characteristics())?;
        // linked services left out for now
        state.end()
    }
}
