// this file is auto-generated by hap-codegen

use serde::ser::{Serialize, SerializeStruct, Serializer};

use crate::{
    service::HapService,
    characteristic::{
        HapCharacteristic,
		current_air_quality::CurrentAirQualityCharacteristic,
		nitrogen_dioxide_density::NitrogenDioxideDensityCharacteristic,
		ozone_density::OzoneDensityCharacteristic,
		pm10_density::Pm10DensityCharacteristic,
		pm2_5_density::Pm2_5DensityCharacteristic,
		sulphur_dioxide_density::SulphurDioxideDensityCharacteristic,
		volatile_organic_compound_density::VolatileOrganicCompoundDensityCharacteristic,
		name::NameCharacteristic,
		status_active::StatusActiveCharacteristic,
		status_fault::StatusFaultCharacteristic,
		status_low_battery::StatusLowBatteryCharacteristic,
		status_tampered::StatusTamperedCharacteristic,
	},
    HapType,
};

/// Air Quality Sensor service.
#[derive(Debug, Default)]
pub struct AirQualitySensorService {
    /// Instance ID of the Air Quality Sensor service.
    id: u64,
    /// [`HapType`](HapType) of the Air Quality Sensor service.
    hap_type: HapType,
    /// When set to true, this service is not visible to user.
    hidden: bool,
    /// When set to true, this is the primary service on the accessory.
    primary: bool,
    /// An array of numbers containing the instance IDs of the services that this service links to.
    linked_services: Vec<u64>,

	/// Current Air Quality characteristic (required).
	pub current_air_quality: CurrentAirQualityCharacteristic,

	/// Nitrogen dioxide Density characteristic (optional).
	pub nitrogen_dioxide_density: Option<NitrogenDioxideDensityCharacteristic>,
	/// Ozone Density characteristic (optional).
	pub ozone_density: Option<OzoneDensityCharacteristic>,
	/// PM10 Density characteristic (optional).
	pub pm10_density: Option<Pm10DensityCharacteristic>,
	/// PM2.5 Density characteristic (optional).
	pub pm2_5_density: Option<Pm2_5DensityCharacteristic>,
	/// Sulphur dioxide Density characteristic (optional).
	pub sulphur_dioxide_density: Option<SulphurDioxideDensityCharacteristic>,
	/// Volatile Organic Compound Density characteristic (optional).
	pub volatile_organic_compound_density: Option<VolatileOrganicCompoundDensityCharacteristic>,
	/// Name characteristic (optional).
	pub name: Option<NameCharacteristic>,
	/// Status Active characteristic (optional).
	pub status_active: Option<StatusActiveCharacteristic>,
	/// Status Fault characteristic (optional).
	pub status_fault: Option<StatusFaultCharacteristic>,
	/// Status Low Battery characteristic (optional).
	pub status_low_battery: Option<StatusLowBatteryCharacteristic>,
	/// Status Tampered characteristic (optional).
	pub status_tampered: Option<StatusTamperedCharacteristic>,
}

impl AirQualitySensorService {
    /// Creates a new Air Quality Sensor service.
    pub fn new(id: u64, accessory_id: u64) -> Self {
        Self {
            id,
            hap_type: HapType::AirQualitySensor,
			current_air_quality: CurrentAirQualityCharacteristic::new(id + 1 + 0, accessory_id),
			nitrogen_dioxide_density: Some(NitrogenDioxideDensityCharacteristic::new(id + 1 + 0 + 1, accessory_id)),
			ozone_density: Some(OzoneDensityCharacteristic::new(id + 1 + 1 + 1, accessory_id)),
			pm10_density: Some(Pm10DensityCharacteristic::new(id + 1 + 2 + 1, accessory_id)),
			pm2_5_density: Some(Pm2_5DensityCharacteristic::new(id + 1 + 3 + 1, accessory_id)),
			sulphur_dioxide_density: Some(SulphurDioxideDensityCharacteristic::new(id + 1 + 4 + 1, accessory_id)),
			volatile_organic_compound_density: Some(VolatileOrganicCompoundDensityCharacteristic::new(id + 1 + 5 + 1, accessory_id)),
			name: Some(NameCharacteristic::new(id + 1 + 6 + 1, accessory_id)),
			status_active: Some(StatusActiveCharacteristic::new(id + 1 + 7 + 1, accessory_id)),
			status_fault: Some(StatusFaultCharacteristic::new(id + 1 + 8 + 1, accessory_id)),
			status_low_battery: Some(StatusLowBatteryCharacteristic::new(id + 1 + 9 + 1, accessory_id)),
			status_tampered: Some(StatusTamperedCharacteristic::new(id + 1 + 10 + 1, accessory_id)),
			..Default::default()
        }
    }
}

impl HapService for AirQualitySensorService {
    fn get_id(&self) -> u64 {
        self.id
    }

    fn get_type(&self) -> HapType {
        self.hap_type
    }

    fn get_hidden(&self) -> bool {
        self.hidden
    }

    fn set_hidden(&mut self, hidden: bool) {
        self.hidden = hidden;
    }

    fn get_primary(&self) -> bool {
        self.primary
    }

    fn set_primary(&mut self, primary: bool) {
        self.primary = primary;
    }

    fn get_linked_services(&self) -> Vec<u64> {
        self.linked_services.clone()
    }

    fn set_linked_services(&mut self, linked_services: Vec<u64>) {
        self.linked_services = linked_services;
    }

    fn get_characteristic(&self, hap_type: HapType) -> Option<&dyn HapCharacteristic> {
        for characteristic in self.get_characteristics() {
            if characteristic.get_type() == hap_type {
                return Some(characteristic);
            }
        }
        None
    }

    fn get_mut_characteristic(&mut self, hap_type: HapType) -> Option<&mut dyn HapCharacteristic> {
        for characteristic in self.get_mut_characteristics() {
            if characteristic.get_type() == hap_type {
                return Some(characteristic);
            }
        }
        None
    }

    fn get_characteristics(&self) -> Vec<&dyn HapCharacteristic> {
        #[allow(unused_mut)]
        let mut characteristics: Vec<&dyn HapCharacteristic> = vec![
			&self.current_air_quality,
		];
		if let Some(c) = &self.nitrogen_dioxide_density {
		    characteristics.push(c);
		}
		if let Some(c) = &self.ozone_density {
		    characteristics.push(c);
		}
		if let Some(c) = &self.pm10_density {
		    characteristics.push(c);
		}
		if let Some(c) = &self.pm2_5_density {
		    characteristics.push(c);
		}
		if let Some(c) = &self.sulphur_dioxide_density {
		    characteristics.push(c);
		}
		if let Some(c) = &self.volatile_organic_compound_density {
		    characteristics.push(c);
		}
		if let Some(c) = &self.name {
		    characteristics.push(c);
		}
		if let Some(c) = &self.status_active {
		    characteristics.push(c);
		}
		if let Some(c) = &self.status_fault {
		    characteristics.push(c);
		}
		if let Some(c) = &self.status_low_battery {
		    characteristics.push(c);
		}
		if let Some(c) = &self.status_tampered {
		    characteristics.push(c);
		}
		characteristics
    }

    fn get_mut_characteristics(&mut self) -> Vec<&mut dyn HapCharacteristic> {
        #[allow(unused_mut)]
        let mut characteristics: Vec<&mut dyn HapCharacteristic> = vec![
			&mut self.current_air_quality,
		];
		if let Some(c) = &mut self.nitrogen_dioxide_density {
		    characteristics.push(c);
		}
		if let Some(c) = &mut self.ozone_density {
		    characteristics.push(c);
		}
		if let Some(c) = &mut self.pm10_density {
		    characteristics.push(c);
		}
		if let Some(c) = &mut self.pm2_5_density {
		    characteristics.push(c);
		}
		if let Some(c) = &mut self.sulphur_dioxide_density {
		    characteristics.push(c);
		}
		if let Some(c) = &mut self.volatile_organic_compound_density {
		    characteristics.push(c);
		}
		if let Some(c) = &mut self.name {
		    characteristics.push(c);
		}
		if let Some(c) = &mut self.status_active {
		    characteristics.push(c);
		}
		if let Some(c) = &mut self.status_fault {
		    characteristics.push(c);
		}
		if let Some(c) = &mut self.status_low_battery {
		    characteristics.push(c);
		}
		if let Some(c) = &mut self.status_tampered {
		    characteristics.push(c);
		}
		characteristics
    }
}

impl Serialize for AirQualitySensorService {
    fn serialize<S: Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        let mut state = serializer.serialize_struct("HapService", 5)?;
        state.serialize_field("iid", &self.get_id())?;
        state.serialize_field("type", &self.get_type())?;
        state.serialize_field("hidden", &self.get_hidden())?;
        state.serialize_field("primary", &self.get_primary())?;
        state.serialize_field("characteristics", &self.get_characteristics())?;
        // linked services left out for now
        state.end()
    }
}
