// this file is auto-generated by hap-codegen

use serde::ser::{Serialize, SerializeStruct, Serializer};

use crate::{
    service::HapService,
    characteristic::{
        HapCharacteristic,
		accessory_identifier::AccessoryIdentifierCharacteristic,
		tunnel_connection_timeout::TunnelConnectionTimeoutCharacteristic,
		tunneled_accessory_advertising_status::TunneledAccessoryAdvertisingStatusCharacteristic,
		tunneled_accessory_connection_status::TunneledAccessoryConnectionStatusCharacteristic,
		tunneled_accessory_state_number::TunneledAccessoryStateNumberCharacteristic,
	},
    HapType,
};

/// Tunnel service.
#[derive(Debug, Default)]
pub struct TunnelService {
    /// Instance ID of the Tunnel service.
    id: u64,
    /// [`HapType`](HapType) of the Tunnel service.
    hap_type: HapType,
    /// When set to true, this service is not visible to user.
    hidden: bool,
    /// When set to true, this is the primary service on the accessory.
    primary: bool,
    /// An array of numbers containing the instance IDs of the services that this service links to.
    linked_services: Vec<u64>,

	/// Accessory Identifier characteristic (required).
	pub accessory_identifier: AccessoryIdentifierCharacteristic,
	/// Tunnel Connection Timeout characteristic (required).
	pub tunnel_connection_timeout: TunnelConnectionTimeoutCharacteristic,
	/// Tunneled Accessory Advertising Status characteristic (required).
	pub tunneled_accessory_advertising_status: TunneledAccessoryAdvertisingStatusCharacteristic,
	/// Tunneled Accessory Connection Status characteristic (required).
	pub tunneled_accessory_connection_status: TunneledAccessoryConnectionStatusCharacteristic,
	/// Tunneled Accessory State Number characteristic (required).
	pub tunneled_accessory_state_number: TunneledAccessoryStateNumberCharacteristic,

}

impl TunnelService {
    /// Creates a new Tunnel service.
    pub fn new(id: u64, accessory_id: u64) -> Self {
        Self {
            id,
            hap_type: HapType::Tunnel,
			accessory_identifier: AccessoryIdentifierCharacteristic::new(id + 1 + 0, accessory_id),
			tunnel_connection_timeout: TunnelConnectionTimeoutCharacteristic::new(id + 1 + 1, accessory_id),
			tunneled_accessory_advertising_status: TunneledAccessoryAdvertisingStatusCharacteristic::new(id + 1 + 2, accessory_id),
			tunneled_accessory_connection_status: TunneledAccessoryConnectionStatusCharacteristic::new(id + 1 + 3, accessory_id),
			tunneled_accessory_state_number: TunneledAccessoryStateNumberCharacteristic::new(id + 1 + 4, accessory_id),
			..Default::default()
        }
    }
}

impl HapService for TunnelService {
    fn get_id(&self) -> u64 {
        self.id
    }

    fn get_type(&self) -> HapType {
        self.hap_type
    }

    fn get_hidden(&self) -> bool {
        self.hidden
    }

    fn set_hidden(&mut self, hidden: bool) {
        self.hidden = hidden;
    }

    fn get_primary(&self) -> bool {
        self.primary
    }

    fn set_primary(&mut self, primary: bool) {
        self.primary = primary;
    }

    fn get_linked_services(&self) -> Vec<u64> {
        self.linked_services.clone()
    }

    fn set_linked_services(&mut self, linked_services: Vec<u64>) {
        self.linked_services = linked_services;
    }

    fn get_characteristic(&self, hap_type: HapType) -> Option<&dyn HapCharacteristic> {
        for characteristic in self.get_characteristics() {
            if characteristic.get_type() == hap_type {
                return Some(characteristic);
            }
        }
        None
    }

    fn get_mut_characteristic(&mut self, hap_type: HapType) -> Option<&mut dyn HapCharacteristic> {
        for characteristic in self.get_mut_characteristics() {
            if characteristic.get_type() == hap_type {
                return Some(characteristic);
            }
        }
        None
    }

    fn get_characteristics(&self) -> Vec<&dyn HapCharacteristic> {
        #[allow(unused_mut)]
        let mut characteristics: Vec<&dyn HapCharacteristic> = vec![
			&self.accessory_identifier,
			&self.tunnel_connection_timeout,
			&self.tunneled_accessory_advertising_status,
			&self.tunneled_accessory_connection_status,
			&self.tunneled_accessory_state_number,
		];
		characteristics
    }

    fn get_mut_characteristics(&mut self) -> Vec<&mut dyn HapCharacteristic> {
        #[allow(unused_mut)]
        let mut characteristics: Vec<&mut dyn HapCharacteristic> = vec![
			&mut self.accessory_identifier,
			&mut self.tunnel_connection_timeout,
			&mut self.tunneled_accessory_advertising_status,
			&mut self.tunneled_accessory_connection_status,
			&mut self.tunneled_accessory_state_number,
		];
		characteristics
    }
}

impl Serialize for TunnelService {
    fn serialize<S: Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        let mut state = serializer.serialize_struct("HapService", 5)?;
        state.serialize_field("iid", &self.get_id())?;
        state.serialize_field("type", &self.get_type())?;
        state.serialize_field("hidden", &self.get_hidden())?;
        state.serialize_field("primary", &self.get_primary())?;
        state.serialize_field("characteristics", &self.get_characteristics())?;
        // linked services left out for now
        state.end()
    }
}
