// this file is auto-generated by hap-codegen

use serde::ser::{Serialize, SerializeStruct, Serializer};

use crate::{
    service::HapService,
    characteristic::{
        HapCharacteristic,
		current_media_state::CurrentMediaStateCharacteristic,
		target_media_state::TargetMediaStateCharacteristic,
		configured_name::ConfiguredNameCharacteristic,
		mute::MuteCharacteristic,
		name::NameCharacteristic,
		volume::VolumeCharacteristic,
	},
    HapType,
};

/// Smart Speaker service.
#[derive(Debug, Default)]
pub struct SmartSpeakerService {
    /// Instance ID of the Smart Speaker service.
    id: u64,
    /// [`HapType`](HapType) of the Smart Speaker service.
    hap_type: HapType,
    /// When set to true, this service is not visible to user.
    hidden: bool,
    /// When set to true, this is the primary service on the accessory.
    primary: bool,
    /// An array of numbers containing the instance IDs of the services that this service links to.
    linked_services: Vec<u64>,

	/// Current Media State characteristic (required).
	pub current_media_state: CurrentMediaStateCharacteristic,
	/// Target Media State characteristic (required).
	pub target_media_state: TargetMediaStateCharacteristic,

	/// Configured Name characteristic (optional).
	pub configured_name: Option<ConfiguredNameCharacteristic>,
	/// Mute characteristic (optional).
	pub mute: Option<MuteCharacteristic>,
	/// Name characteristic (optional).
	pub name: Option<NameCharacteristic>,
	/// Volume characteristic (optional).
	pub volume: Option<VolumeCharacteristic>,
}

impl SmartSpeakerService {
    /// Creates a new Smart Speaker service.
    pub fn new(id: u64, accessory_id: u64) -> Self {
        Self {
            id,
            hap_type: HapType::SmartSpeaker,
			current_media_state: CurrentMediaStateCharacteristic::new(id + 1 + 0, accessory_id),
			target_media_state: TargetMediaStateCharacteristic::new(id + 1 + 1, accessory_id),
			configured_name: Some(ConfiguredNameCharacteristic::new(id + 1 + 0 + 2, accessory_id)),
			mute: Some(MuteCharacteristic::new(id + 1 + 1 + 2, accessory_id)),
			name: Some(NameCharacteristic::new(id + 1 + 2 + 2, accessory_id)),
			volume: Some(VolumeCharacteristic::new(id + 1 + 3 + 2, accessory_id)),
			..Default::default()
        }
    }
}

impl HapService for SmartSpeakerService {
    fn get_id(&self) -> u64 {
        self.id
    }

    fn get_type(&self) -> HapType {
        self.hap_type
    }

    fn get_hidden(&self) -> bool {
        self.hidden
    }

    fn set_hidden(&mut self, hidden: bool) {
        self.hidden = hidden;
    }

    fn get_primary(&self) -> bool {
        self.primary
    }

    fn set_primary(&mut self, primary: bool) {
        self.primary = primary;
    }

    fn get_linked_services(&self) -> Vec<u64> {
        self.linked_services.clone()
    }

    fn set_linked_services(&mut self, linked_services: Vec<u64>) {
        self.linked_services = linked_services;
    }

    fn get_characteristic(&self, hap_type: HapType) -> Option<&dyn HapCharacteristic> {
        for characteristic in self.get_characteristics() {
            if characteristic.get_type() == hap_type {
                return Some(characteristic);
            }
        }
        None
    }

    fn get_mut_characteristic(&mut self, hap_type: HapType) -> Option<&mut dyn HapCharacteristic> {
        for characteristic in self.get_mut_characteristics() {
            if characteristic.get_type() == hap_type {
                return Some(characteristic);
            }
        }
        None
    }

    fn get_characteristics(&self) -> Vec<&dyn HapCharacteristic> {
        #[allow(unused_mut)]
        let mut characteristics: Vec<&dyn HapCharacteristic> = vec![
			&self.current_media_state,
			&self.target_media_state,
		];
		if let Some(c) = &self.configured_name {
		    characteristics.push(c);
		}
		if let Some(c) = &self.mute {
		    characteristics.push(c);
		}
		if let Some(c) = &self.name {
		    characteristics.push(c);
		}
		if let Some(c) = &self.volume {
		    characteristics.push(c);
		}
		characteristics
    }

    fn get_mut_characteristics(&mut self) -> Vec<&mut dyn HapCharacteristic> {
        #[allow(unused_mut)]
        let mut characteristics: Vec<&mut dyn HapCharacteristic> = vec![
			&mut self.current_media_state,
			&mut self.target_media_state,
		];
		if let Some(c) = &mut self.configured_name {
		    characteristics.push(c);
		}
		if let Some(c) = &mut self.mute {
		    characteristics.push(c);
		}
		if let Some(c) = &mut self.name {
		    characteristics.push(c);
		}
		if let Some(c) = &mut self.volume {
		    characteristics.push(c);
		}
		characteristics
    }
}

impl Serialize for SmartSpeakerService {
    fn serialize<S: Serializer>(&self, serializer: S) -> Result<S::Ok, S::Error> {
        let mut state = serializer.serialize_struct("HapService", 5)?;
        state.serialize_field("iid", &self.get_id())?;
        state.serialize_field("type", &self.get_type())?;
        state.serialize_field("hidden", &self.get_hidden())?;
        state.serialize_field("primary", &self.get_primary())?;
        state.serialize_field("characteristics", &self.get_characteristics())?;
        // linked services left out for now
        state.end()
    }
}
