# The halo2 Book

[halo2](README.md)
- [Concepts](concepts.md)
  - [Proof systems](concepts/proofs.md)
  - [PLONKish Arithmetization](concepts/arithmetization.md)
  - [Chips](concepts/chips.md)
  - [Gadgets](concepts/gadgets.md)
- [User Documentation](user.md)
  - [Developer tools](user/dev-tools.md)
  - [A simple example](user/simple-example.md)
  - [Lookup tables](user/lookup-tables.md)
  - [Gadgets](user/gadgets.md)
  - [Tips and tricks](user/tips-and-tricks.md)
- [Design](design.md)
  - [Proving system](design/proving-system.md)
    - [Lookup argument](design/proving-system/lookup.md)
    - [Permutation argument](design/proving-system/permutation.md)
    - [Circuit commitments](design/proving-system/circuit-commitments.md)
    - [Vanishing argument](design/proving-system/vanishing.md)
    - [Multipoint opening argument](design/proving-system/multipoint-opening.md)
    - [Inner product argument](design/proving-system/inner-product.md)
    - [Comparison to other work](design/proving-system/comparison.md)
  - [Protocol Description](design/protocol.md)
  - [Implementation](design/implementation.md)
    - [Proofs](design/implementation/proofs.md)
    - [Fields](design/implementation/fields.md)
  - [Gadgets](design/gadgets.md)
    - [SHA-256](design/gadgets/sha256.md)
      - [16-bit table chip](design/gadgets/sha256/table16.md)
- [Background Material](background.md)
  - [Fields](background/fields.md)
  - [Polynomials](background/polynomials.md)
  - [Cryptographic groups](background/groups.md)
  - [Elliptic curves](background/curves.md)
  - [Polynomial commitment using inner product argument](background/pc-ipa.md)
  - [Recursion](background/recursion.md)
