require 'yaml'

$functions = YAML.load_file "functions.yaml"


def analyze_function(lock_order, name_stack, acquired_locks, lock_stack, function_name)
	raise "Undefined function #{function_name}"  if not $functions[function_name]
	$functions[function_name]["steps"].each { |step|
		raise "no command"  if !step["call"] && !step["lock-shared"] && !step["unlock-shared"] && !step["lock-exclusive"] && !step["unlock-exclusive"]
		if step["call"]
			analyze_function(lock_order, name_stack + [step["call"]], acquired_locks, lock_stack, step["call"])
		end
		if step["lock-shared"]
			raise :trivial_deadlock  if acquired_locks[["write", step["lock-shared"]]] > 0
			new_key = ["shared", step["lock-shared"]]
			acquired_locks[new_key] += 1
			lock_order[[lock_stack[-1], new_key]] << :x
			lock_stack << new_key
		end
		if step["unlock-shared"]
			key = ["shared", step["unlock-shared"]]
			acquired_locks[key] -= 1
			i = lock_stack.reverse.find_index { |item| item == key }
			raise if not i
			lock_stack.delete_at(lock_stack.size - i - 1)
		end
		if step["lock-exclusive"]
			raise :trivial_deadlock  if acquired_locks[["read", step["lock-exclusive"]]] > 0
			raise :trivial_deadlock  if acquired_locks[["write", step["lock-exclusive"]]] > 0
			new_key = ["exclusive", step["lock-exclusive"]]
			acquired_locks[new_key] += 1
			lock_order[[lock_stack[-1], new_key]] << :x
			lock_stack << new_key
		end
		if step["unlock-exclusive"]
			key = ["exclusive", step["unlock-exclusive"]]
			acquired_locks[key] -= 1
			i = lock_stack.reverse.find_index { |item| item == key }
			raise if not i
			lock_stack.delete_at(lock_stack.size - i - 1)
		end
	}
end

lock_order = Hash.new { |h,k| h[k] = [] }
$functions.to_a.select { |function_name, function_info| function_info["pub"] }.each { |function_name, function_info|
	analyze_function(lock_order, [function_name], Hash.new(0), [], function_name)
}

out = ["digraph x {"]
lock_order.to_a.each { |((lock1mode, lock1name), (lock2mode, lock2name)), locations|
	next if not lock1name
	out << "\t\"#{lock1name}\" -> \"#{lock2name}\";"
}
out << "}"

#open("out.dot","w") { |file| file.write out.join("\n") }
open("| dot -Tsvg -o lock-order.svg","w") { |dot| dot.write(out.join("\n")) }
