#![allow(clippy::not_unsafe_ptr_arg_deref)]

use log::{error, Level};
use wasm_bindgen::prelude::*;

#[cfg(feature = "console_error_panic_hook")]
extern crate console_error_panic_hook;


#[cfg(feature = "console_log")]
#[wasm_bindgen]
pub fn hakuban_logger_initialize(default_log_level: String) -> u8 {
	use log::trace;

	#[cfg(feature = "console_error_panic_hook")]
	std::panic::set_hook(Box::new(console_error_panic_hook::hook));

	if console_log::init_with_level(match default_log_level.as_str() {
		"error" => Level::Error,
		"warn" => Level::Warn,
		"info" => Level::Info,
		"debug" => Level::Debug,
		"trace" => Level::Trace,
		other => {
			if console_log::init_with_level(Level::Warn).is_err() {
				return 3;
			}
			error!("Invalid log level: {:?}. Valid levels are: error, warn, info, debug, trace.", other);
			return 2;
		}
	})
	.is_ok()
	{
		trace!("Logger initialized");
		0
	} else {
		1
	}
}
