use std::{collections::hash_map::DefaultHasher, hash::Hasher};

use log::error;
use wasm_bindgen::prelude::*;

use super::WasmError;
use crate::hash_serde_json_value;


//well, this is stupid, but simple

#[wasm_bindgen]
pub struct WasmHashResult {
	pub error: WasmError,
	pub hash: u64,
}


#[wasm_bindgen]
pub fn hakuban_json_hash(json_string: String) -> WasmHashResult {
	match serde_json::from_str::<serde_json::Value>(json_string.as_str()) {
		Ok(json) => {
			let mut hasher = DefaultHasher::new();
			hash_serde_json_value(&json, &mut hasher);
			WasmHashResult { error: WasmError::None, hash: hasher.finish() }
		}
		Err(error) => {
			error!("Invalid object descriptor json: {:?}", error);
			WasmHashResult { error: WasmError::InvalidJSON, hash: 0 }
		}
	}
}
