use std::hash::{Hash, Hasher};

use crate::contract::Contract;


pub(crate) trait ObserveContract: Send + Sync + Contract + std::fmt::Debug {}


impl Eq for dyn ObserveContract {}

impl PartialEq for dyn ObserveContract {
	fn eq(&self, other: &Self) -> bool {
		self.id() == other.id()
	}
}

impl Hash for dyn ObserveContract {
	fn hash<H: Hasher>(&self, state: &mut H) {
		self.id().hash(state)
	}
}
