import { base64 } from 'rollup-plugin-base64';
import coffee from 'rollup-plugin-coffee-script';
import commonjs from 'rollup-plugin-commonjs';
import nodeResolve from 'rollup-plugin-node-resolve';
import { terser } from "rollup-plugin-terser";

const lib_with_wasm = () => ({
  input: "coffee/hakuban-with-wasm.coffee",
  plugins: [
    base64({ include: "**/*.wasm" }),
    coffee(),
  ],
  output: [
    { format: "es", file: `hakuban-with-wasm.js`, sourcemap: true },
    { format: "es", file: `hakuban-with-wasm.min.js`, plugins: [terser()], sourcemap: true },
  ],
});

const lib_without_wasm = (fmt) => ({
  input: "coffee/hakuban.coffee",
  plugins: [
    coffee(),
  ],
  output: [
    { format: "es", file: `hakuban.js`, sourcemap: true },
    { format: "es", file: `hakuban.min.js`, plugins: [terser()], sourcemap: true },
  ],
});


const all_top = ()=> ({
  input: "coffee/all-top.coffee",
  output: { dir: `./`, format: 'esm', name: "hakuban-all-top" },
  plugins: [
    coffee(),
    nodeResolve({extensions: ['.js']}),
    commonjs({extensions: ['.js']}),
    {
      generateBundle(opts, bundle) {
        this.emitFile({
          type: "asset",
            fileName: "all-top.html",
          source: '<html><head><meta charset="utf-8" /></head><body><script type="module">'+bundle["all-top.js"].code+"</script></body></html>"
        });
      }
    }
  ],
});


export default [lib_with_wasm(), lib_without_wasm(), all_top()];
