
class Queue

	constructor: ->
		@queue = []
		@wake = null
	
	push: (value)->
		@queue.push(value)
		if @wake?
			@wake()
			@wake = null
	
	shift: ->
		loop
			value = @queue.shift()
			if value?
				return value
			else
				throw "2 concurrent shifts on a single queue"  if @wake?
				await new Promise (@wake)=> null
	
	clear: ->
		@queue = []



export class ObjectManager
	constructor: (@contract, @object_class, @block)->
		@_objects = {}
		@running_handlers = {}
		@event_queue = new Queue()

		#TODO: make one loop out of following two

		event_loop_stop_requested = new Promise (@event_loop_stop)=> null
		@event_loop_stopped = new Promise (resolve, reject)=>
			events = @contract.events()
			while event = await Promise.race([events.next(), event_loop_stop_requested])
				break  if not event?
				@event_queue.push(event)
			events.drop()
			resolve()

		@async_loop_stopped = new Promise (resolve, reject)=>
			while (event = await @event_queue.shift())?
				switch event.action
					when "Insert" 
						throw "Double insert"  if @_objects[event.descriptor.hash()]?
						@_objects[event.descriptor.hash()] = new @object_class(@contract, event.descriptor)
						@event_queue.push({action: "HandlerStart", descriptor: event.descriptor})  if @block?
					when "Change"
						throw "Uh, oh, object missing :("  if not @_objects[event.descriptor.hash()]?
						@_objects[event.descriptor.hash()].do_change("change")
					when "Remove"
						throw "Trying to remove non-existing object. Sad."  if not @_objects[event.descriptor.hash()]?
						@_objects[event.descriptor.hash()].do_change("remove")
						delete @_objects[event.descriptor.hash()]
					when "HandlerStart"
						if (object = @_objects[event.descriptor.hash()])? and !object.handler_already_run and !@running_handlers[event.descriptor.hash()]?
							#wrapped to avoid weird capture effects
							@running_handlers[event.descriptor.hash()] = ((descriptor, object, block, event_queue)->new Promise (handler_resolve, handler_reject)->
								await object.run(block)
								event_queue.push({action: "HandlerFinished", descriptor: descriptor})
								handler_resolve()
								)(event.descriptor, object, @block, @event_queue)
					when "HandlerFinished"
						throw "Handler finished but it was not running. That sucks."  if not @running_handlers[event.descriptor.hash()]?
						delete @running_handlers[event.descriptor.hash()]
						@event_queue.push({action: "HandlerStart", descriptor: event.descriptor})  if @_objects[event.descriptor.hash()]?
					when "Drop"
						@event_loop_stop()
						await @event_loop_stopped
						object.do_change("remove")  for _key, object of @_objects
						while Object.keys(@running_handlers).length > 0
							event = await @event_queue.shift()
							if event.action == "HandlerFinished"
								delete @running_handlers[event.descriptor.hash()]
						@event_queue.clear()
						delete @_objects[key] for key,_value of @_objects
						@contract.drop()
						@contract = null
						@event_queue = null
						resolve()
						return 
					else
						throw "Unknown action: " + event.action
			reject("Queue died unexpectedly")
		
	objects: ()=> Object.values(@_objects)
	object: ()=> Object.values(@_objects)[0]

	drop: ()=>
		if @contract
			@event_queue.push(action: 'Drop')
			await @async_loop_stopped




export class ManagedObject
	constructor: (@contract, @descriptor)->
		@_changes = new Queue()
		@handler_already_run = false

	run: (handler)=>
		@handler_already_run = true
		await handler(@)

	next_event: ()=> @next_change()
	next_change: ()=>
		loop
			switch await @_changes.shift()
				when "change" then return true
				when "remove" then return false

	do_change: (change)=>
		@_changes.push(change)


