import * as hakuban from "../hakuban-with-wasm.js"
import m from "mithril"

window.hakuban = hakuban
window.onload = ()->
	await hakuban.initialize()
	await hakuban.logger_initialize("debug")
	@local_node = new hakuban.LocalNode("all-top.html")
	conn = new hakuban.WebsocketConnector(@local_node, "ws://127.0.0.1:3001")

	state = 
		utilizations: @local_node.tag("utilizations").observe()

	events = state.utilizations.events()
	loop
		event = await events.next()
		m.render(document.body, m(Page, {state: state}))


class Page
	view: (vnode)->
		m "div", style: { display: "grid", "grid-template-columns": "max-content auto", margin: "2em" },
			for object_descriptor in vnode.attrs.state.utilizations.object_descriptors().sort((d1,d2)->d1.json.id.localeCompare(d2.json.id))
				state = vnode.attrs.state.utilizations.object_state(object_descriptor)
				if state? and state.data.percentage?
					[
						m "div", style: { "padding-right": "2em" }, object_descriptor.json.id
						m "div", style: { display: "flex" },
							for load in state.data.percentage
								m "div", style: { width: "1em" },
									m "div", style: { width: "100%", background: "#008", height: (100-load)+"%" }
									m "div", style: { width: "100%", background: "#FF0", height: (load)+"%" }
					]

