#![allow(clippy::not_unsafe_ptr_arg_deref)]

use log::trace;
use wasm_bindgen::prelude::*;

use crate::LocalNode;


#[wasm_bindgen]
#[derive(Copy, Clone, Debug)]
pub enum WasmError {
	None = 0,
	InvalidString = 1,
	InvalidJSON = 2,
	InvalidURL = 3,
	ObjectNotFound = 4,
}


#[wasm_bindgen]
pub struct WasmLocalNodeNewResult {
	pub error: WasmError,
	pub local_node_pointer: *mut LocalNode,
}

//TODO: capacity, limit

#[wasm_bindgen]
pub fn hakuban_local_node_new(name_str: String) -> WasmLocalNodeNewResult {
	trace!("Constructing local node {:?}", name_str);
	WasmLocalNodeNewResult { error: WasmError::None, local_node_pointer: Box::into_raw(Box::new(LocalNode::builder().with_name(&name_str).build())) }
}


#[wasm_bindgen]
pub fn hakuban_local_node_drop(local_node: *mut LocalNode) {
	let local_node = unsafe { Box::from_raw(local_node) };
	trace!("Dropping local node {:?}", local_node);
	drop(local_node);
}
