use std::{collections::hash_map::DefaultHasher, hash::{Hash, Hasher}};

use log::error;
use wasm_bindgen::prelude::*;

use super::WasmError;
use crate::{ObjectDescriptor, TagDescriptor};


//well, this is stupid, but simple

#[wasm_bindgen]
pub struct WasmHashResult {
	pub error: WasmError,
	pub hash1: u64,
	//space for more
}


#[wasm_bindgen]
pub fn hakuban_object_descriptor_hash(descriptor: String) -> WasmHashResult {
	let descriptor: ObjectDescriptor = match serde_json::from_str::<ObjectDescriptor>(&descriptor) {
		Ok(descriptor) => descriptor,
		Err(error) => {
			error!("Invalid object descriptor json: {:?}", error);
			return WasmHashResult { error: WasmError::InvalidJSON, hash1: 0 };
		}
	};
	let mut hasher1 = DefaultHasher::new();
	descriptor.hash(&mut hasher1);
	WasmHashResult { error: WasmError::None, hash1: hasher1.finish() }
}

#[wasm_bindgen]
pub fn hakuban_tag_descriptor_hash(descriptor: String) -> WasmHashResult {
	let descriptor: TagDescriptor = match serde_json::from_str::<TagDescriptor>(&descriptor) {
		Ok(descriptor) => descriptor,
		Err(error) => {
			error!("Invalid tag descriptor json: {:?}", error);
			return WasmHashResult { error: WasmError::InvalidJSON, hash1: 0 };
		}
	};
	let mut hasher1 = DefaultHasher::new();
	descriptor.hash(&mut hasher1);
	WasmHashResult { error: WasmError::None, hash1: hasher1.finish() }
}
