import { wasm } from "@rollup/plugin-wasm";
import coffee from 'rollup-plugin-coffee-script';
import commonjs from 'rollup-plugin-commonjs';
import nodeResolve from 'rollup-plugin-node-resolve';


const lib = (fmt) => ({
  input: "coffee/hakuban.coffee",
  output: {
    dir: `dist/${fmt}`,
    format: fmt,
    name: "hakuban",
  },
  plugins: [
    wasm({ maxFileSize: 4000000 }),
    coffee(),
    nodeResolve({extensions: ['.js', '.coffee']}),
    commonjs({extensions: ['.js', '.coffee']})
  ],
});

const all_top = ()=> ({
  input: "coffee/all-top.coffee",
  output: {
    dir: `dist/es`,
    format: 'esm',
    name: "hakuban-all-top",
  },
  plugins: [
    wasm({ maxFileSize: 4000000 }),
    coffee(),
    nodeResolve({extensions: ['.js', '.coffee']}),
    commonjs({extensions: ['.js', '.coffee']}),
    {
      generateBundle(opts, bundle) {
        this.emitFile({
          type: "asset",
          fileName: "all-top.html",
          source: '<html><head><meta charset="utf-8" /></head><body><script type="module">'+bundle["all-top.js"].code+"</script></body></html>"
        });
      }
    }
  ],
});


export default [lib("es"), all_top()];