extern crate hakuban;
use std::{process::Stdio, sync::{atomic::Ordering, Arc}, time::Duration};

use tokio::{io::{AsyncBufReadExt, BufReader}, sync::mpsc, task::JoinHandle};

use crate::scene::{Order, Scene, TestAction};


pub struct ServerProcess {
	//	port: u16,
}



impl ServerProcess {
	pub fn spawn(scene: Arc<Scene>, name: String) -> (mpsc::Sender<Order>, JoinHandle<()>) {
		let server_port = crate::director::PORT.fetch_add(1, Ordering::SeqCst);
		{
			scene.ports.write().unwrap().insert(name.clone(), server_port);
		};
		let mut process = None;
		let (tx, mut rx) = mpsc::channel::<Order>(1000);
		let join_handle = tokio::spawn(async move {
			while let Some(order) = rx.recv().await {
				match order {
					Order::Event(_frame, event, done) => {
						match event {
							TestAction::Listen { diff_produce, diff_request, timeout } => {
								//println!("starting");
								let mut address = format!("ws://127.0.0.1:{}#", server_port);
								address += format!("timeout={:.3}", timeout).as_str();
								if let Some(diff_request) = diff_request {
									address += ",diff-request=";
									address += if diff_request { "true" } else { "false" };
								}
								if let Some(diff_produce) = diff_produce {
									address += ",diff-produce=";
									address += if diff_produce { "true" } else { "false" };
								}
								println!("{:?}", address);
								process = Some(
									tokio::process::Command::new("target/debug/hakuban-router")
										//tokio::process::Command::new("sleep").arg("600")
										.arg("-b")
										.arg(address.clone())
										.stdout(Stdio::piped())
										.kill_on_drop(true)
										.spawn()
										.unwrap(),
								); //FIXME hardcoded path
								let name_for_lambda = name.clone();
								let mut reader = BufReader::new(process.as_mut().unwrap().stdout.take().unwrap()).lines();
								tokio::spawn(async move {
									while let Some(line) = reader.next_line().await.unwrap() {
										println!("{} | {}", name_for_lambda, line);
									}
								});
								loop {
									match tokio::net::TcpStream::connect(format!("127.0.0.1:{}", server_port)).await {
										Err(_error) => {
											//println!(". {}", error);
											//dbg!(&(process.as_ref().unwrap().));
											tokio::time::sleep(Duration::from_millis(100)).await;
										}
										Ok(connection) => {
											drop(connection); //.//shutdown(std::net::Shutdown::Both).unwrap();
											break;
										}
									}
								}
							}
							TestAction::EnsureRssBelow(bytes) => {
								//hardcoded page size
								let rss = std::fs::read_to_string(format!("/proc/{}/stat", process.as_ref().unwrap().id().unwrap()))
									.unwrap()
									.as_str()
									.split(' ')
									.nth(23)
									.unwrap()
									.parse::<usize>()
									.unwrap() * 4096;
								dbg!(rss);
								if rss > bytes {
									panic!("❌ rss limit exceeded. rss: {}, limit: {}", rss, bytes);
								}
							}
							_ => panic!("MockClient can't do: {:?}", event),
						}
						done.send(Ok(())).unwrap();
					}
					Order::Exit => {
						if let Some(mut process) = process {
							process.kill().await.unwrap();
							process.wait().await.unwrap();
						}
						return;
					}
				}
			}
		});
		(tx, join_handle)
	}
}
