pub mod test_director;
use std::{collections::HashMap, sync::{atomic::AtomicU16, Arc}};

pub use test_director::*;
use tokio::{sync::mpsc, task::JoinHandle};

use crate::scene::{Order, Scene};

pub static PORT: AtomicU16 = AtomicU16::new(10000);

pub type TypeMap = HashMap<&'static str, fn(Arc<Scene>, String) -> (mpsc::Sender<Order>, JoinHandle<()>)>;
