use crate::LocalNode;


#[must_use = "Call .build() at the end of the build chain."]
pub struct LocalNodeBuilder {
	name: Option<String>,
}

impl LocalNodeBuilder {
	pub fn new() -> LocalNodeBuilder {
		LocalNodeBuilder { name: None }
	}

	pub fn with_name(mut self, name: &str) -> LocalNodeBuilder {
		self.name = Some(name.to_string());
		self
	}

	pub fn build(self) -> LocalNode {
		LocalNode::new(self.name, None, None)
	}

	//TODO: capacity, limit
}

impl Default for LocalNodeBuilder {
	fn default() -> Self {
		Self::new()
	}
}
