//! Iterator functionalities
//!
//! Most iterators in this module are implemented as generic functions. This allow to not just use them
//! with the collections in `std::collections`, but also to apply them to custom data structures.
//!
//! # Resolution handling
//!
//! * [`change_resolution`]
//! * [`change_resolution_tuple`]
//!
//! # Grid traversal
//!
//! * [`KRingBuilder`]
//! * [`neighbors_within_distance_window_or_default`]
//! * [`neighbors_within_distance_window`]
//! * [`neighbors_within_distance`]
//!
//! # Edges
//!
//! * [`H3EdgesBuilder`]
//! * [`continuous_cells_to_edges`]
//!
//! # Cell boundaries
//!
//! * [`GeoBoundaryBuilder`]
//! * [`GeoBoundaryIter`]
//!

pub use boundary::{GeoBoundaryBuilder, GeoBoundaryIter};
pub use edge::{continuous_cells_to_edges, CellsToEdgesIter, H3EdgesBuilder};
pub use kring::KRingBuilder;
pub use neighbor::*;
pub use resolution::{change_resolution, change_resolution_tuple};

mod boundary;
mod edge;
mod kring;
mod neighbor;
mod resolution;
