#[derive(Debug, PartialEq, Eq)]
pub enum GameError {
    DoubleMove,
    InvalidMove(MoveError),
    InvalidPlacement(PlacementError),
    MissingPiece,
}

#[derive(Debug, PartialEq, Eq)]
pub enum MoveError {
    CantClimb,
    GrasshopperBadHop,
    Inconsistent,
    InvalidTargetPosition,
    MissingPiece,
    NoFreedomToMove,
    NoMovement,
    NotAdjacentToAnotherPiece,
    OneHiveRuleViolation,
    SpiderBacktracking,
    SpiderNotThreeSpaces,
    QueenBeeNotPlaced,
    TooLong,
    WrongPlayer,
}

#[derive(Debug, PartialEq, Eq)]
pub enum PlacementError {
    EnemyNeighbors,
    MustPlaceQueenBee,
    NotAdjacentToAnotherPiece,
    Topping,
}

impl From<MoveError> for GameError {
    fn from(err: MoveError) -> Self {
        Self::InvalidMove(err)
    }
}

impl From<PlacementError> for GameError {
    fn from(err: PlacementError) -> Self {
        Self::InvalidPlacement(err)
    }
}
