use super::{Color, Piece, Species};

#[derive(Debug, PartialEq, Eq)]
pub struct Player {
    pub color: Color,
    pub pieces: Vec<Piece>,
}

impl Player {
    pub fn new(color: Color) -> Self {
        let mut pieces = Vec::with_capacity(11);
        for (species, count) in [
            (Species::QueenBee, 1),
            (Species::Beetle, 2),
            (Species::Spider, 2),
            (Species::Grasshopper, 3),
            (Species::SoldierAnt, 3),
        ] {
            for _ in 0..count {
                pieces.push(Piece::new(color, species));
            }
        }

        Self { color, pieces }
    }
}
