use super::Color;

#[derive(Debug, Clone, Copy, Hash, PartialEq, Eq)]
#[non_exhaustive] // remove once all species are implemented
pub enum Species {
    Beetle,
    Grasshopper,
    QueenBee,
    SoldierAnt,
    Spider,
    // Mosquito,
    // Pillbug,
    // Ladybug,
}

#[derive(Debug, Clone, PartialEq, Eq)]
pub struct Piece {
    pub color: Color,
    pub species: Species,
}

impl Piece {
    pub const fn new(color: Color, species: Species) -> Self {
        Self { color, species }
    }
}
