use std::ops::Not;

mod error;
mod game;
mod hex;
mod hive;
mod piece;
mod player;

pub use error::*;
pub use game::*;
pub use hex::*;
pub use hive::*;
pub use piece::*;
pub use player::*;

#[derive(Debug, Clone, Copy, PartialEq, Eq)]
pub enum Color {
    White,
    Black,
}

impl Not for Color {
    type Output = Self;

    fn not(self) -> Self::Output {
        match self {
            Self::White => Self::Black,
            Self::Black => Self::White,
        }
    }
}
