// This file was generated by gir (https://github.com/gtk-rs/gir)
// from gir-files (https://github.com/gtk-rs/gir-files.git)
// DO NOT EDIT

use crate::ColorMap;
use crate::PixelFormat;
use glib::object::IsA;
use glib::translate::*;
use std::fmt;

glib::wrapper! {
    #[doc(alias = "VncFramebuffer")]
    pub struct Framebuffer(Interface<ffi::VncFramebuffer, ffi::VncFramebufferInterface>);

    match fn {
        type_ => || ffi::vnc_framebuffer_get_type(),
    }
}

pub const NONE_FRAMEBUFFER: Option<&Framebuffer> = None;

pub trait FramebufferExt: 'static {
    #[doc(alias = "vnc_framebuffer_copyrect")]
    fn copyrect(&self, srcx: u16, srcy: u16, dstx: u16, dsty: u16, width: u16, height: u16);

    //#[doc(alias = "vnc_framebuffer_fill")]
    //fn fill(&self, src: &[u8], x: u16, y: u16, width: u16, height: u16);

    #[doc(alias = "vnc_framebuffer_get_height")]
    #[doc(alias = "get_height")]
    fn height(&self) -> u16;

    #[doc(alias = "vnc_framebuffer_get_local_format")]
    #[doc(alias = "get_local_format")]
    fn local_format(&self) -> Option<PixelFormat>;

    #[doc(alias = "vnc_framebuffer_get_remote_format")]
    #[doc(alias = "get_remote_format")]
    fn remote_format(&self) -> Option<PixelFormat>;

    #[doc(alias = "vnc_framebuffer_get_rowstride")]
    #[doc(alias = "get_rowstride")]
    fn rowstride(&self) -> i32;

    #[doc(alias = "vnc_framebuffer_get_width")]
    #[doc(alias = "get_width")]
    fn width(&self) -> u16;

    #[doc(alias = "vnc_framebuffer_perfect_format_match")]
    fn perfect_format_match(&self) -> bool;

    //#[doc(alias = "vnc_framebuffer_rgb24_blt")]
    //fn rgb24_blt(&self, src: &[u8], rowstride: i32, x: u16, y: u16, width: u16, height: u16);

    #[doc(alias = "vnc_framebuffer_set_color_map")]
    fn set_color_map(&self, map: &mut ColorMap);

    //#[doc(alias = "vnc_framebuffer_set_pixel_at")]
    //fn set_pixel_at(&self, src: &[u8], x: u16, y: u16);
}

impl<O: IsA<Framebuffer>> FramebufferExt for O {
    fn copyrect(&self, srcx: u16, srcy: u16, dstx: u16, dsty: u16, width: u16, height: u16) {
        unsafe {
            ffi::vnc_framebuffer_copyrect(
                self.as_ref().to_glib_none().0,
                srcx,
                srcy,
                dstx,
                dsty,
                width,
                height,
            );
        }
    }

    //fn fill(&self, src: &[u8], x: u16, y: u16, width: u16, height: u16) {
    //    unsafe { TODO: call ffi:vnc_framebuffer_fill() }
    //}

    fn height(&self) -> u16 {
        unsafe { ffi::vnc_framebuffer_get_height(self.as_ref().to_glib_none().0) }
    }

    fn local_format(&self) -> Option<PixelFormat> {
        unsafe {
            from_glib_none(ffi::vnc_framebuffer_get_local_format(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    fn remote_format(&self) -> Option<PixelFormat> {
        unsafe {
            from_glib_none(ffi::vnc_framebuffer_get_remote_format(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    fn rowstride(&self) -> i32 {
        unsafe { ffi::vnc_framebuffer_get_rowstride(self.as_ref().to_glib_none().0) }
    }

    fn width(&self) -> u16 {
        unsafe { ffi::vnc_framebuffer_get_width(self.as_ref().to_glib_none().0) }
    }

    fn perfect_format_match(&self) -> bool {
        unsafe {
            from_glib(ffi::vnc_framebuffer_perfect_format_match(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    //fn rgb24_blt(&self, src: &[u8], rowstride: i32, x: u16, y: u16, width: u16, height: u16) {
    //    unsafe { TODO: call ffi:vnc_framebuffer_rgb24_blt() }
    //}

    fn set_color_map(&self, map: &mut ColorMap) {
        unsafe {
            ffi::vnc_framebuffer_set_color_map(
                self.as_ref().to_glib_none().0,
                map.to_glib_none_mut().0,
            );
        }
    }

    //fn set_pixel_at(&self, src: &[u8], x: u16, y: u16) {
    //    unsafe { TODO: call ffi:vnc_framebuffer_set_pixel_at() }
    //}
}

impl fmt::Display for Framebuffer {
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        f.write_str("Framebuffer")
    }
}
