// This file was generated by gir (https://github.com/gtk-rs/gir)
// from gir-files (https://github.com/gtk-rs/gir-files.git)
// DO NOT EDIT

use crate::Audio;
use crate::AudioFormat;
use crate::ConnectionPowerAction;
use crate::ConnectionResizeStatus;
use crate::Cursor;
use crate::Framebuffer;
use crate::PixelFormat;
use glib::object::Cast;
use glib::object::IsA;
use glib::object::ObjectType as ObjectType_;
use glib::signal::connect_raw;
use glib::signal::SignalHandlerId;
use glib::translate::*;
use glib::StaticType;
use glib::ToValue;
use std::boxed::Box as Box_;
use std::fmt;
use std::mem::transmute;

glib::wrapper! {
    #[doc(alias = "VncConnection")]
    pub struct Connection(Object<ffi::VncConnection, ffi::VncConnectionClass>);

    match fn {
        type_ => || ffi::vnc_connection_get_type(),
    }
}

impl Connection {
    #[doc(alias = "vnc_connection_new")]
    pub fn new() -> Connection {
        assert_initialized_main_thread!();
        unsafe { from_glib_full(ffi::vnc_connection_new()) }
    }

    // rustdoc-stripper-ignore-next
    /// Creates a new builder-pattern struct instance to construct [`Connection`] objects.
    ///
    /// This method returns an instance of [`ConnectionBuilder`] which can be used to create [`Connection`] objects.
    pub fn builder() -> ConnectionBuilder {
        ConnectionBuilder::default()
    }

    #[doc(alias = "vnc_connection_audio_disable")]
    pub fn audio_disable(&self) -> Result<(), glib::error::BoolError> {
        unsafe {
            glib::result_from_gboolean!(
                ffi::vnc_connection_audio_disable(self.to_glib_none().0),
                "Failed to disable audio"
            )
        }
    }

    #[doc(alias = "vnc_connection_audio_enable")]
    pub fn audio_enable(&self) -> Result<(), glib::error::BoolError> {
        unsafe {
            glib::result_from_gboolean!(
                ffi::vnc_connection_audio_enable(self.to_glib_none().0),
                "Failed to enable audio"
            )
        }
    }

    #[doc(alias = "vnc_connection_framebuffer_update_request")]
    pub fn framebuffer_update_request(
        &self,
        incremental: bool,
        x: u16,
        y: u16,
        width: u16,
        height: u16,
    ) -> Result<(), glib::error::BoolError> {
        unsafe {
            glib::result_from_gboolean!(
                ffi::vnc_connection_framebuffer_update_request(
                    self.to_glib_none().0,
                    incremental.into_glib(),
                    x,
                    y,
                    width,
                    height
                ),
                "Failed to update framebuffer"
            )
        }
    }

    #[doc(alias = "vnc_connection_get_abs_pointer")]
    #[doc(alias = "get_abs_pointer")]
    pub fn is_abs_pointer(&self) -> bool {
        unsafe { from_glib(ffi::vnc_connection_get_abs_pointer(self.to_glib_none().0)) }
    }

    #[doc(alias = "vnc_connection_get_audio_format")]
    #[doc(alias = "get_audio_format")]
    pub fn audio_format(&self) -> Option<AudioFormat> {
        unsafe { from_glib_none(ffi::vnc_connection_get_audio_format(self.to_glib_none().0)) }
    }

    #[doc(alias = "vnc_connection_get_cursor")]
    #[doc(alias = "get_cursor")]
    pub fn cursor(&self) -> Option<Cursor> {
        unsafe { from_glib_none(ffi::vnc_connection_get_cursor(self.to_glib_none().0)) }
    }

    #[doc(alias = "vnc_connection_get_ext_key_event")]
    #[doc(alias = "get_ext_key_event")]
    pub fn is_ext_key_event(&self) -> bool {
        unsafe { from_glib(ffi::vnc_connection_get_ext_key_event(self.to_glib_none().0)) }
    }

    #[doc(alias = "vnc_connection_get_height")]
    #[doc(alias = "get_height")]
    pub fn height(&self) -> i32 {
        unsafe { ffi::vnc_connection_get_height(self.to_glib_none().0) }
    }

    #[doc(alias = "vnc_connection_get_ledstate")]
    #[doc(alias = "get_ledstate")]
    pub fn ledstate(&self) -> i32 {
        unsafe { ffi::vnc_connection_get_ledstate(self.to_glib_none().0) }
    }

    #[doc(alias = "vnc_connection_get_name")]
    #[doc(alias = "get_name")]
    pub fn name(&self) -> Option<glib::GString> {
        unsafe { from_glib_none(ffi::vnc_connection_get_name(self.to_glib_none().0)) }
    }

    #[doc(alias = "vnc_connection_get_pixel_format")]
    #[doc(alias = "get_pixel_format")]
    pub fn pixel_format(&self) -> Option<PixelFormat> {
        unsafe { from_glib_none(ffi::vnc_connection_get_pixel_format(self.to_glib_none().0)) }
    }

    #[doc(alias = "vnc_connection_get_power_control")]
    #[doc(alias = "get_power_control")]
    pub fn is_power_control(&self) -> bool {
        unsafe { from_glib(ffi::vnc_connection_get_power_control(self.to_glib_none().0)) }
    }

    #[doc(alias = "vnc_connection_get_shared")]
    #[doc(alias = "get_shared")]
    pub fn is_shared(&self) -> bool {
        unsafe { from_glib(ffi::vnc_connection_get_shared(self.to_glib_none().0)) }
    }

    #[doc(alias = "vnc_connection_get_width")]
    #[doc(alias = "get_width")]
    pub fn width(&self) -> i32 {
        unsafe { ffi::vnc_connection_get_width(self.to_glib_none().0) }
    }

    #[doc(alias = "vnc_connection_has_error")]
    pub fn has_error(&self) -> bool {
        unsafe { from_glib(ffi::vnc_connection_has_error(self.to_glib_none().0)) }
    }

    #[doc(alias = "vnc_connection_is_initialized")]
    pub fn is_initialized(&self) -> bool {
        unsafe { from_glib(ffi::vnc_connection_is_initialized(self.to_glib_none().0)) }
    }

    #[doc(alias = "vnc_connection_is_open")]
    pub fn is_open(&self) -> bool {
        unsafe { from_glib(ffi::vnc_connection_is_open(self.to_glib_none().0)) }
    }

    #[doc(alias = "vnc_connection_key_event")]
    pub fn key_event(
        &self,
        down_flag: bool,
        key: u32,
        scancode: u16,
    ) -> Result<(), glib::error::BoolError> {
        unsafe {
            glib::result_from_gboolean!(
                ffi::vnc_connection_key_event(
                    self.to_glib_none().0,
                    down_flag.into_glib(),
                    key,
                    scancode
                ),
                "Failed to send key event"
            )
        }
    }

    #[doc(alias = "vnc_connection_open_addr")]
    pub fn open_addr(
        &self,
        addr: &impl IsA<gio::SocketAddress>,
        hostname: Option<&str>,
    ) -> Result<(), glib::error::BoolError> {
        unsafe {
            glib::result_from_gboolean!(
                ffi::vnc_connection_open_addr(
                    self.to_glib_none().0,
                    addr.as_ref().to_glib_none().0,
                    hostname.to_glib_none().0
                ),
                "Connection was already opened"
            )
        }
    }

    #[doc(alias = "vnc_connection_open_fd")]
    pub fn open_fd(&self, fd: i32) -> Result<(), glib::error::BoolError> {
        unsafe {
            glib::result_from_gboolean!(
                ffi::vnc_connection_open_fd(self.to_glib_none().0, fd),
                "Connection was already opened"
            )
        }
    }

    #[doc(alias = "vnc_connection_open_fd_with_hostname")]
    pub fn open_fd_with_hostname(
        &self,
        fd: i32,
        hostname: Option<&str>,
    ) -> Result<(), glib::error::BoolError> {
        unsafe {
            glib::result_from_gboolean!(
                ffi::vnc_connection_open_fd_with_hostname(
                    self.to_glib_none().0,
                    fd,
                    hostname.to_glib_none().0
                ),
                "Connection was already opened"
            )
        }
    }

    #[doc(alias = "vnc_connection_open_host")]
    pub fn open_host(&self, host: &str, port: &str) -> Result<(), glib::error::BoolError> {
        unsafe {
            glib::result_from_gboolean!(
                ffi::vnc_connection_open_host(
                    self.to_glib_none().0,
                    host.to_glib_none().0,
                    port.to_glib_none().0
                ),
                "Connection was already opened"
            )
        }
    }

    #[doc(alias = "vnc_connection_pointer_event")]
    pub fn pointer_event(
        &self,
        button_mask: u8,
        x: u16,
        y: u16,
    ) -> Result<(), glib::error::BoolError> {
        unsafe {
            glib::result_from_gboolean!(
                ffi::vnc_connection_pointer_event(self.to_glib_none().0, button_mask, x, y),
                "Failed to send pointer event"
            )
        }
    }

    #[doc(alias = "vnc_connection_power_control")]
    pub fn power_control(
        &self,
        action: ConnectionPowerAction,
    ) -> Result<(), glib::error::BoolError> {
        unsafe {
            glib::result_from_gboolean!(
                ffi::vnc_connection_power_control(self.to_glib_none().0, action.into_glib()),
                "Failed to send power control"
            )
        }
    }

    #[doc(alias = "vnc_connection_set_audio")]
    pub fn set_audio(&self, audio: &impl IsA<Audio>) -> Result<(), glib::error::BoolError> {
        unsafe {
            glib::result_from_gboolean!(
                ffi::vnc_connection_set_audio(
                    self.to_glib_none().0,
                    audio.as_ref().to_glib_none().0
                ),
                "Failed to set audio"
            )
        }
    }

    #[doc(alias = "vnc_connection_set_audio_format")]
    pub fn set_audio_format(&self, fmt: &AudioFormat) -> Result<(), glib::error::BoolError> {
        unsafe {
            glib::result_from_gboolean!(
                ffi::vnc_connection_set_audio_format(self.to_glib_none().0, fmt.to_glib_none().0),
                "Failed to set audio format"
            )
        }
    }

    #[doc(alias = "vnc_connection_set_auth_subtype")]
    pub fn set_auth_subtype(&self, type_: u32) -> Result<(), glib::error::BoolError> {
        unsafe {
            glib::result_from_gboolean!(
                ffi::vnc_connection_set_auth_subtype(self.to_glib_none().0, type_),
                "Failed to set auth subtype"
            )
        }
    }

    #[doc(alias = "vnc_connection_set_auth_type")]
    pub fn set_auth_type(&self, type_: u32) -> Result<(), glib::error::BoolError> {
        unsafe {
            glib::result_from_gboolean!(
                ffi::vnc_connection_set_auth_type(self.to_glib_none().0, type_),
                "Failed to set auth type"
            )
        }
    }

    #[doc(alias = "vnc_connection_set_credential")]
    pub fn set_credential(&self, type_: i32, data: &str) -> Result<(), glib::error::BoolError> {
        unsafe {
            glib::result_from_gboolean!(
                ffi::vnc_connection_set_credential(
                    self.to_glib_none().0,
                    type_,
                    data.to_glib_none().0
                ),
                "Failed to set credential"
            )
        }
    }

    #[doc(alias = "vnc_connection_set_encodings")]
    pub fn set_encodings(&self, encoding: &[i32]) -> Result<(), glib::error::BoolError> {
        let n_encoding = encoding.len() as i32;
        unsafe {
            glib::result_from_gboolean!(
                ffi::vnc_connection_set_encodings(
                    self.to_glib_none().0,
                    n_encoding,
                    encoding.to_glib_none().0
                ),
                "Failed to set encodings"
            )
        }
    }

    #[doc(alias = "vnc_connection_set_framebuffer")]
    pub fn set_framebuffer(
        &self,
        fb: &impl IsA<Framebuffer>,
    ) -> Result<(), glib::error::BoolError> {
        unsafe {
            glib::result_from_gboolean!(
                ffi::vnc_connection_set_framebuffer(
                    self.to_glib_none().0,
                    fb.as_ref().to_glib_none().0
                ),
                "Failed to set framebuffer"
            )
        }
    }

    #[doc(alias = "vnc_connection_set_pixel_format")]
    pub fn set_pixel_format(&self, fmt: &PixelFormat) -> Result<(), glib::error::BoolError> {
        unsafe {
            glib::result_from_gboolean!(
                ffi::vnc_connection_set_pixel_format(self.to_glib_none().0, fmt.to_glib_none().0),
                "Failed to set pixel format"
            )
        }
    }

    #[doc(alias = "vnc_connection_set_shared")]
    pub fn set_shared(&self, shared: bool) -> Result<(), glib::error::BoolError> {
        unsafe {
            glib::result_from_gboolean!(
                ffi::vnc_connection_set_shared(self.to_glib_none().0, shared.into_glib()),
                "Failed to set shared"
            )
        }
    }

    #[doc(alias = "vnc_connection_set_size")]
    pub fn set_size(&self, width: u32, height: u32) -> ConnectionResizeStatus {
        unsafe {
            from_glib(ffi::vnc_connection_set_size(
                self.to_glib_none().0,
                width,
                height,
            ))
        }
    }

    #[doc(alias = "vnc_connection_shutdown")]
    pub fn shutdown(&self) {
        unsafe {
            ffi::vnc_connection_shutdown(self.to_glib_none().0);
        }
    }

    pub fn framebuffer(&self) -> Option<Framebuffer> {
        unsafe {
            let mut value = glib::Value::from_type(<Framebuffer as StaticType>::static_type());
            glib::gobject_ffi::g_object_get_property(
                self.as_ptr() as *mut glib::gobject_ffi::GObject,
                b"framebuffer\0".as_ptr() as *const _,
                value.to_glib_none_mut().0,
            );
            value
                .get()
                .expect("Return Value for property `framebuffer` getter")
        }
    }

    #[doc(alias = "vnc-auth-choose-subtype")]
    pub fn connect_vnc_auth_choose_subtype<F: Fn(&Self, u32, &glib::ValueArray) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn vnc_auth_choose_subtype_trampoline<
            F: Fn(&Connection, u32, &glib::ValueArray) + 'static,
        >(
            this: *mut ffi::VncConnection,
            object: libc::c_uint,
            p0: *mut glib::gobject_ffi::GValueArray,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this), object, &from_glib_borrow(p0))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"vnc-auth-choose-subtype\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    vnc_auth_choose_subtype_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "vnc-auth-choose-type")]
    pub fn connect_vnc_auth_choose_type<F: Fn(&Self, &glib::ValueArray) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn vnc_auth_choose_type_trampoline<
            F: Fn(&Connection, &glib::ValueArray) + 'static,
        >(
            this: *mut ffi::VncConnection,
            object: *mut glib::gobject_ffi::GValueArray,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this), &from_glib_borrow(object))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"vnc-auth-choose-type\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    vnc_auth_choose_type_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "vnc-auth-credential")]
    pub fn connect_vnc_auth_credential<F: Fn(&Self, &glib::ValueArray) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn vnc_auth_credential_trampoline<
            F: Fn(&Connection, &glib::ValueArray) + 'static,
        >(
            this: *mut ffi::VncConnection,
            object: *mut glib::gobject_ffi::GValueArray,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this), &from_glib_borrow(object))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"vnc-auth-credential\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    vnc_auth_credential_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "vnc-auth-failure")]
    pub fn connect_vnc_auth_failure<F: Fn(&Self, &str) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn vnc_auth_failure_trampoline<F: Fn(&Connection, &str) + 'static>(
            this: *mut ffi::VncConnection,
            object: *mut libc::c_char,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(
                &from_glib_borrow(this),
                &glib::GString::from_glib_borrow(object),
            )
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"vnc-auth-failure\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    vnc_auth_failure_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "vnc-auth-unsupported")]
    pub fn connect_vnc_auth_unsupported<F: Fn(&Self, u32) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn vnc_auth_unsupported_trampoline<F: Fn(&Connection, u32) + 'static>(
            this: *mut ffi::VncConnection,
            object: libc::c_uint,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this), object)
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"vnc-auth-unsupported\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    vnc_auth_unsupported_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "vnc-bell")]
    pub fn connect_vnc_bell<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn vnc_bell_trampoline<F: Fn(&Connection) + 'static>(
            this: *mut ffi::VncConnection,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"vnc-bell\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    vnc_bell_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "vnc-connected")]
    pub fn connect_vnc_connected<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn vnc_connected_trampoline<F: Fn(&Connection) + 'static>(
            this: *mut ffi::VncConnection,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"vnc-connected\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    vnc_connected_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "vnc-cursor-changed")]
    pub fn connect_vnc_cursor_changed<F: Fn(&Self, Option<&Cursor>) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn vnc_cursor_changed_trampoline<
            F: Fn(&Connection, Option<&Cursor>) + 'static,
        >(
            this: *mut ffi::VncConnection,
            cursor: *mut ffi::VncCursor,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(
                &from_glib_borrow(this),
                Option::<Cursor>::from_glib_borrow(cursor).as_ref().as_ref(),
            )
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"vnc-cursor-changed\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    vnc_cursor_changed_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "vnc-desktop-rename")]
    pub fn connect_vnc_desktop_rename<F: Fn(&Self, &str) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn vnc_desktop_rename_trampoline<F: Fn(&Connection, &str) + 'static>(
            this: *mut ffi::VncConnection,
            object: *mut libc::c_char,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(
                &from_glib_borrow(this),
                &glib::GString::from_glib_borrow(object),
            )
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"vnc-desktop-rename\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    vnc_desktop_rename_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "vnc-desktop-resize")]
    pub fn connect_vnc_desktop_resize<F: Fn(&Self, i32, i32) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn vnc_desktop_resize_trampoline<
            F: Fn(&Connection, i32, i32) + 'static,
        >(
            this: *mut ffi::VncConnection,
            object: libc::c_int,
            p0: libc::c_int,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this), object, p0)
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"vnc-desktop-resize\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    vnc_desktop_resize_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "vnc-disconnected")]
    pub fn connect_vnc_disconnected<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn vnc_disconnected_trampoline<F: Fn(&Connection) + 'static>(
            this: *mut ffi::VncConnection,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"vnc-disconnected\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    vnc_disconnected_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "vnc-error")]
    pub fn connect_vnc_error<F: Fn(&Self, &str) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn vnc_error_trampoline<F: Fn(&Connection, &str) + 'static>(
            this: *mut ffi::VncConnection,
            object: *mut libc::c_char,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(
                &from_glib_borrow(this),
                &glib::GString::from_glib_borrow(object),
            )
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"vnc-error\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    vnc_error_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "vnc-framebuffer-update")]
    pub fn connect_vnc_framebuffer_update<F: Fn(&Self, i32, i32, i32, i32) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn vnc_framebuffer_update_trampoline<
            F: Fn(&Connection, i32, i32, i32, i32) + 'static,
        >(
            this: *mut ffi::VncConnection,
            object: libc::c_int,
            p0: libc::c_int,
            p1: libc::c_int,
            p2: libc::c_int,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this), object, p0, p1, p2)
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"vnc-framebuffer-update\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    vnc_framebuffer_update_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "vnc-initialized")]
    pub fn connect_vnc_initialized<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn vnc_initialized_trampoline<F: Fn(&Connection) + 'static>(
            this: *mut ffi::VncConnection,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"vnc-initialized\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    vnc_initialized_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "vnc-led-state")]
    pub fn connect_vnc_led_state<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn vnc_led_state_trampoline<F: Fn(&Connection) + 'static>(
            this: *mut ffi::VncConnection,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"vnc-led-state\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    vnc_led_state_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "vnc-pixel-format-changed")]
    pub fn connect_vnc_pixel_format_changed<F: Fn(&Self, &PixelFormat) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn vnc_pixel_format_changed_trampoline<
            F: Fn(&Connection, &PixelFormat) + 'static,
        >(
            this: *mut ffi::VncConnection,
            object: *mut ffi::VncPixelFormat,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this), &from_glib_borrow(object))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"vnc-pixel-format-changed\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    vnc_pixel_format_changed_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "vnc-pointer-mode-changed")]
    pub fn connect_vnc_pointer_mode_changed<F: Fn(&Self, bool) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn vnc_pointer_mode_changed_trampoline<
            F: Fn(&Connection, bool) + 'static,
        >(
            this: *mut ffi::VncConnection,
            object: glib::ffi::gboolean,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this), from_glib(object))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"vnc-pointer-mode-changed\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    vnc_pointer_mode_changed_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "vnc-power-control-failed")]
    pub fn connect_vnc_power_control_failed<F: Fn(&Self) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn vnc_power_control_failed_trampoline<F: Fn(&Connection) + 'static>(
            this: *mut ffi::VncConnection,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"vnc-power-control-failed\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    vnc_power_control_failed_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "vnc-power-control-initialized")]
    pub fn connect_vnc_power_control_initialized<F: Fn(&Self) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn vnc_power_control_initialized_trampoline<
            F: Fn(&Connection) + 'static,
        >(
            this: *mut ffi::VncConnection,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"vnc-power-control-initialized\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    vnc_power_control_initialized_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "vnc-server-cut-text")]
    pub fn connect_vnc_server_cut_text<F: Fn(&Self, &str) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn vnc_server_cut_text_trampoline<F: Fn(&Connection, &str) + 'static>(
            this: *mut ffi::VncConnection,
            object: *mut libc::c_char,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(
                &from_glib_borrow(this),
                &glib::GString::from_glib_borrow(object),
            )
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"vnc-server-cut-text\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    vnc_server_cut_text_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "framebuffer")]
    pub fn connect_framebuffer_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_framebuffer_trampoline<F: Fn(&Connection) + 'static>(
            this: *mut ffi::VncConnection,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::framebuffer\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_framebuffer_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }
}

impl Default for Connection {
    fn default() -> Self {
        Self::new()
    }
}

#[derive(Clone, Default)]
// rustdoc-stripper-ignore-next
/// A [builder-pattern] type to construct [`Connection`] objects.
///
/// [builder-pattern]: https://doc.rust-lang.org/1.0.0/style/ownership/builders.html
pub struct ConnectionBuilder {
    framebuffer: Option<Framebuffer>,
}

impl ConnectionBuilder {
    // rustdoc-stripper-ignore-next
    /// Create a new [`ConnectionBuilder`].
    pub fn new() -> Self {
        Self::default()
    }

    // rustdoc-stripper-ignore-next
    /// Build the [`Connection`].
    pub fn build(self) -> Connection {
        let mut properties: Vec<(&str, &dyn ToValue)> = vec![];
        if let Some(ref framebuffer) = self.framebuffer {
            properties.push(("framebuffer", framebuffer));
        }
        glib::Object::new::<Connection>(&properties)
            .expect("Failed to create an instance of Connection")
    }

    pub fn framebuffer(mut self, framebuffer: &impl IsA<Framebuffer>) -> Self {
        self.framebuffer = Some(framebuffer.clone().upcast());
        self
    }
}

impl fmt::Display for Connection {
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        f.write_str("Connection")
    }
}
