// This file was generated by gir (https://github.com/gtk-rs/gir)
// from gir-files (https://github.com/gtk-rs/gir-files.git)
// DO NOT EDIT

use glib::translate::*;
use std::mem;

glib::wrapper! {
    #[derive(Debug, PartialEq, Eq, PartialOrd, Ord, Hash)]
    pub struct ColorMap(Boxed<ffi::VncColorMap>);

    match fn {
        copy => |ptr| ffi::vnc_color_map_copy(mut_override(ptr)),
        free => |ptr| ffi::vnc_color_map_free(ptr),
        type_ => || ffi::vnc_color_map_get_type(),
    }
}

impl ColorMap {
    #[doc(alias = "vnc_color_map_new")]
    pub fn new(offset: u16, size: u16) -> ColorMap {
        assert_initialized_main_thread!();
        unsafe { from_glib_full(ffi::vnc_color_map_new(offset, size)) }
    }

    #[doc(alias = "vnc_color_map_lookup")]
    pub fn lookup(&mut self, idx: u16) -> Option<(u16, u16, u16)> {
        unsafe {
            let mut red = mem::MaybeUninit::uninit();
            let mut green = mem::MaybeUninit::uninit();
            let mut blue = mem::MaybeUninit::uninit();
            let ret = from_glib(ffi::vnc_color_map_lookup(
                self.to_glib_none_mut().0,
                idx,
                red.as_mut_ptr(),
                green.as_mut_ptr(),
                blue.as_mut_ptr(),
            ));
            let red = red.assume_init();
            let green = green.assume_init();
            let blue = blue.assume_init();
            if ret {
                Some((red, green, blue))
            } else {
                None
            }
        }
    }

    #[doc(alias = "vnc_color_map_set")]
    pub fn set(&mut self, idx: u16, red: u16, green: u16, blue: u16) -> bool {
        unsafe {
            from_glib(ffi::vnc_color_map_set(
                self.to_glib_none_mut().0,
                idx,
                red,
                green,
                blue,
            ))
        }
    }
}
