// This file was generated by gir (https://github.com/gtk-rs/gir)
// from gir-files (https://github.com/gtk-rs/gir-files.git)
// DO NOT EDIT

use crate::ColorMap;
use crate::Framebuffer;
use crate::PixelFormat;
use glib::object::Cast;
use glib::object::IsA;
use glib::signal::connect_raw;
use glib::signal::SignalHandlerId;
use glib::translate::*;
use glib::StaticType;
use glib::ToValue;
use std::boxed::Box as Box_;
use std::fmt;
use std::mem::transmute;

glib::wrapper! {
    #[doc(alias = "VncBaseFramebuffer")]
    pub struct BaseFramebuffer(Object<ffi::VncBaseFramebuffer, ffi::VncBaseFramebufferClass>) @implements Framebuffer;

    match fn {
        type_ => || ffi::vnc_base_framebuffer_get_type(),
    }
}

impl BaseFramebuffer {
    //#[doc(alias = "vnc_base_framebuffer_new")]
    //pub fn new(buffer: &[u8], width: u16, height: u16, rowstride: i32, localFormat: &PixelFormat, remoteFormat: &PixelFormat) -> BaseFramebuffer {
    //    unsafe { TODO: call ffi:vnc_base_framebuffer_new() }
    //}

    // rustdoc-stripper-ignore-next
    /// Creates a new builder-pattern struct instance to construct [`BaseFramebuffer`] objects.
    ///
    /// This method returns an instance of [`BaseFramebufferBuilder`] which can be used to create [`BaseFramebuffer`] objects.
    pub fn builder() -> BaseFramebufferBuilder {
        BaseFramebufferBuilder::default()
    }
}

impl Default for BaseFramebuffer {
    fn default() -> Self {
        glib::object::Object::new::<Self>(&[])
            .expect("Can't construct BaseFramebuffer object with default parameters")
    }
}

#[derive(Clone, Default)]
// rustdoc-stripper-ignore-next
/// A [builder-pattern] type to construct [`BaseFramebuffer`] objects.
///
/// [builder-pattern]: https://doc.rust-lang.org/1.0.0/style/ownership/builders.html
pub struct BaseFramebufferBuilder {
    //buffer: /*Unknown type*/,
    color_map: Option<ColorMap>,
    height: Option<i32>,
    local_format: Option<PixelFormat>,
    remote_format: Option<PixelFormat>,
    rowstride: Option<i32>,
    width: Option<i32>,
}

impl BaseFramebufferBuilder {
    // rustdoc-stripper-ignore-next
    /// Create a new [`BaseFramebufferBuilder`].
    pub fn new() -> Self {
        Self::default()
    }

    // rustdoc-stripper-ignore-next
    /// Build the [`BaseFramebuffer`].
    pub fn build(self) -> BaseFramebuffer {
        let mut properties: Vec<(&str, &dyn ToValue)> = vec![];
        if let Some(ref color_map) = self.color_map {
            properties.push(("color-map", color_map));
        }
        if let Some(ref height) = self.height {
            properties.push(("height", height));
        }
        if let Some(ref local_format) = self.local_format {
            properties.push(("local-format", local_format));
        }
        if let Some(ref remote_format) = self.remote_format {
            properties.push(("remote-format", remote_format));
        }
        if let Some(ref rowstride) = self.rowstride {
            properties.push(("rowstride", rowstride));
        }
        if let Some(ref width) = self.width {
            properties.push(("width", width));
        }
        glib::Object::new::<BaseFramebuffer>(&properties)
            .expect("Failed to create an instance of BaseFramebuffer")
    }

    pub fn color_map(mut self, color_map: &ColorMap) -> Self {
        self.color_map = Some(color_map.clone());
        self
    }

    pub fn height(mut self, height: i32) -> Self {
        self.height = Some(height);
        self
    }

    pub fn local_format(mut self, local_format: &PixelFormat) -> Self {
        self.local_format = Some(local_format.clone());
        self
    }

    pub fn remote_format(mut self, remote_format: &PixelFormat) -> Self {
        self.remote_format = Some(remote_format.clone());
        self
    }

    pub fn rowstride(mut self, rowstride: i32) -> Self {
        self.rowstride = Some(rowstride);
        self
    }

    pub fn width(mut self, width: i32) -> Self {
        self.width = Some(width);
        self
    }
}

pub const NONE_BASE_FRAMEBUFFER: Option<&BaseFramebuffer> = None;

pub trait BaseFramebufferExt: 'static {
    //fn buffer(&self) -> /*Unimplemented*/Fundamental: Pointer;

    #[doc(alias = "color-map")]
    fn color_map(&self) -> Option<ColorMap>;

    fn height(&self) -> i32;

    fn width(&self) -> i32;

    #[doc(alias = "color-map")]
    fn connect_color_map_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;
}

impl<O: IsA<BaseFramebuffer>> BaseFramebufferExt for O {
    //fn buffer(&self) -> /*Unimplemented*/Fundamental: Pointer {
    //    unsafe {
    //        let mut value = glib::Value::from_type(</*Unknown type*/ as StaticType>::static_type());
    //        glib::gobject_ffi::g_object_get_property(self.to_glib_none().0 as *mut glib::gobject_ffi::GObject, b"buffer\0".as_ptr() as *const _, value.to_glib_none_mut().0);
    //        value.get().expect("Return Value for property `buffer` getter")
    //    }
    //}

    fn color_map(&self) -> Option<ColorMap> {
        unsafe {
            let mut value = glib::Value::from_type(<ColorMap as StaticType>::static_type());
            glib::gobject_ffi::g_object_get_property(
                self.to_glib_none().0 as *mut glib::gobject_ffi::GObject,
                b"color-map\0".as_ptr() as *const _,
                value.to_glib_none_mut().0,
            );
            value
                .get()
                .expect("Return Value for property `color-map` getter")
        }
    }

    fn height(&self) -> i32 {
        unsafe {
            let mut value = glib::Value::from_type(<i32 as StaticType>::static_type());
            glib::gobject_ffi::g_object_get_property(
                self.to_glib_none().0 as *mut glib::gobject_ffi::GObject,
                b"height\0".as_ptr() as *const _,
                value.to_glib_none_mut().0,
            );
            value
                .get()
                .expect("Return Value for property `height` getter")
        }
    }

    fn width(&self) -> i32 {
        unsafe {
            let mut value = glib::Value::from_type(<i32 as StaticType>::static_type());
            glib::gobject_ffi::g_object_get_property(
                self.to_glib_none().0 as *mut glib::gobject_ffi::GObject,
                b"width\0".as_ptr() as *const _,
                value.to_glib_none_mut().0,
            );
            value
                .get()
                .expect("Return Value for property `width` getter")
        }
    }

    fn connect_color_map_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_color_map_trampoline<
            P: IsA<BaseFramebuffer>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::VncBaseFramebuffer,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(BaseFramebuffer::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::color-map\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_color_map_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }
}

impl fmt::Display for BaseFramebuffer {
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        f.write_str("BaseFramebuffer")
    }
}
