// This file was generated by gir (https://github.com/gtk-rs/gir)
// from gir-files (https://github.com/gtk-rs/gir-files.git)
// DO NOT EDIT

#![allow(non_camel_case_types, non_upper_case_globals, non_snake_case)]
#![allow(
    clippy::approx_constant,
    clippy::type_complexity,
    clippy::unreadable_literal,
    clippy::upper_case_acronyms
)]
#![cfg_attr(feature = "dox", feature(doc_cfg))]

#[allow(unused_imports)]
use libc::{
    c_char, c_double, c_float, c_int, c_long, c_short, c_uchar, c_uint, c_ulong, c_ushort, c_void,
    intptr_t, size_t, ssize_t, uintptr_t, FILE,
};

#[allow(unused_imports)]
use glib::{gboolean, gconstpointer, gpointer, GType};

// Enums
pub type VncAudioFormatType = c_int;
pub const VNC_AUDIO_FORMAT_RAW_U8: VncAudioFormatType = 0;
pub const VNC_AUDIO_FORMAT_RAW_S8: VncAudioFormatType = 1;
pub const VNC_AUDIO_FORMAT_RAW_U16: VncAudioFormatType = 2;
pub const VNC_AUDIO_FORMAT_RAW_S16: VncAudioFormatType = 3;
pub const VNC_AUDIO_FORMAT_RAW_U32: VncAudioFormatType = 4;
pub const VNC_AUDIO_FORMAT_RAW_S32: VncAudioFormatType = 5;

pub type VncConnectionAuth = c_int;
pub const VNC_CONNECTION_AUTH_INVALID: VncConnectionAuth = 0;
pub const VNC_CONNECTION_AUTH_NONE: VncConnectionAuth = 1;
pub const VNC_CONNECTION_AUTH_VNC: VncConnectionAuth = 2;
pub const VNC_CONNECTION_AUTH_RA2: VncConnectionAuth = 5;
pub const VNC_CONNECTION_AUTH_RA2NE: VncConnectionAuth = 6;
pub const VNC_CONNECTION_AUTH_TIGHT: VncConnectionAuth = 16;
pub const VNC_CONNECTION_AUTH_ULTRA: VncConnectionAuth = 17;
pub const VNC_CONNECTION_AUTH_TLS: VncConnectionAuth = 18;
pub const VNC_CONNECTION_AUTH_VENCRYPT: VncConnectionAuth = 19;
pub const VNC_CONNECTION_AUTH_SASL: VncConnectionAuth = 20;
pub const VNC_CONNECTION_AUTH_ARD: VncConnectionAuth = 30;
pub const VNC_CONNECTION_AUTH_MSLOGONII: VncConnectionAuth = 113;
pub const VNC_CONNECTION_AUTH_MSLOGON: VncConnectionAuth = -6;

pub type VncConnectionAuthVencrypt = c_int;
pub const VNC_CONNECTION_AUTH_VENCRYPT_PLAIN: VncConnectionAuthVencrypt = 256;
pub const VNC_CONNECTION_AUTH_VENCRYPT_TLSNONE: VncConnectionAuthVencrypt = 257;
pub const VNC_CONNECTION_AUTH_VENCRYPT_TLSVNC: VncConnectionAuthVencrypt = 258;
pub const VNC_CONNECTION_AUTH_VENCRYPT_TLSPLAIN: VncConnectionAuthVencrypt = 259;
pub const VNC_CONNECTION_AUTH_VENCRYPT_X509NONE: VncConnectionAuthVencrypt = 260;
pub const VNC_CONNECTION_AUTH_VENCRYPT_X509VNC: VncConnectionAuthVencrypt = 261;
pub const VNC_CONNECTION_AUTH_VENCRYPT_X509PLAIN: VncConnectionAuthVencrypt = 262;
pub const VNC_CONNECTION_AUTH_VENCRYPT_X509SASL: VncConnectionAuthVencrypt = 263;
pub const VNC_CONNECTION_AUTH_VENCRYPT_TLSSASL: VncConnectionAuthVencrypt = 264;

pub type VncConnectionCredential = c_int;
pub const VNC_CONNECTION_CREDENTIAL_PASSWORD: VncConnectionCredential = 0;
pub const VNC_CONNECTION_CREDENTIAL_USERNAME: VncConnectionCredential = 1;
pub const VNC_CONNECTION_CREDENTIAL_CLIENTNAME: VncConnectionCredential = 2;

pub type VncConnectionEncoding = c_int;
pub const VNC_CONNECTION_ENCODING_RAW: VncConnectionEncoding = 0;
pub const VNC_CONNECTION_ENCODING_COPY_RECT: VncConnectionEncoding = 1;
pub const VNC_CONNECTION_ENCODING_RRE: VncConnectionEncoding = 2;
pub const VNC_CONNECTION_ENCODING_CORRE: VncConnectionEncoding = 4;
pub const VNC_CONNECTION_ENCODING_HEXTILE: VncConnectionEncoding = 5;
pub const VNC_CONNECTION_ENCODING_TIGHT: VncConnectionEncoding = 7;
pub const VNC_CONNECTION_ENCODING_ZRLE: VncConnectionEncoding = 16;
pub const VNC_CONNECTION_ENCODING_TIGHT_JPEG0: VncConnectionEncoding = -32;
pub const VNC_CONNECTION_ENCODING_TIGHT_JPEG1: VncConnectionEncoding = -31;
pub const VNC_CONNECTION_ENCODING_TIGHT_JPEG2: VncConnectionEncoding = -30;
pub const VNC_CONNECTION_ENCODING_TIGHT_JPEG3: VncConnectionEncoding = -29;
pub const VNC_CONNECTION_ENCODING_TIGHT_JPEG4: VncConnectionEncoding = -28;
pub const VNC_CONNECTION_ENCODING_TIGHT_JPEG5: VncConnectionEncoding = -27;
pub const VNC_CONNECTION_ENCODING_TIGHT_JPEG6: VncConnectionEncoding = -26;
pub const VNC_CONNECTION_ENCODING_TIGHT_JPEG7: VncConnectionEncoding = -25;
pub const VNC_CONNECTION_ENCODING_TIGHT_JPEG8: VncConnectionEncoding = -24;
pub const VNC_CONNECTION_ENCODING_TIGHT_JPEG9: VncConnectionEncoding = -23;
pub const VNC_CONNECTION_ENCODING_DESKTOP_RESIZE: VncConnectionEncoding = -223;
pub const VNC_CONNECTION_ENCODING_LAST_RECT: VncConnectionEncoding = -224;
pub const VNC_CONNECTION_ENCODING_WMVi: VncConnectionEncoding = 1464686185;
pub const VNC_CONNECTION_ENCODING_CURSOR_POS: VncConnectionEncoding = -232;
pub const VNC_CONNECTION_ENCODING_RICH_CURSOR: VncConnectionEncoding = -239;
pub const VNC_CONNECTION_ENCODING_XCURSOR: VncConnectionEncoding = -240;
pub const VNC_CONNECTION_ENCODING_POINTER_CHANGE: VncConnectionEncoding = -257;
pub const VNC_CONNECTION_ENCODING_EXT_KEY_EVENT: VncConnectionEncoding = -258;
pub const VNC_CONNECTION_ENCODING_AUDIO: VncConnectionEncoding = -259;
pub const VNC_CONNECTION_ENCODING_LED_STATE: VncConnectionEncoding = -261;
pub const VNC_CONNECTION_ENCODING_DESKTOP_NAME: VncConnectionEncoding = -307;
pub const VNC_CONNECTION_ENCODING_EXTENDED_DESKTOP_RESIZE: VncConnectionEncoding = -308;
pub const VNC_CONNECTION_ENCODING_XVP: VncConnectionEncoding = -309;
pub const VNC_CONNECTION_ENCODING_ALPHA_CURSOR: VncConnectionEncoding = -314;

pub type VncConnectionPowerAction = c_int;
pub const VNC_CONNECTION_POWER_ACTION_SHUTDOWN: VncConnectionPowerAction = 2;
pub const VNC_CONNECTION_POWER_ACTION_REBOOT: VncConnectionPowerAction = 3;
pub const VNC_CONNECTION_POWER_ACTION_RESET: VncConnectionPowerAction = 4;

pub type VncConnectionResizeStatus = c_int;
pub const VNC_CONNECTION_RESIZE_STATUS_UNSUPPORTED: VncConnectionResizeStatus = -1;
pub const VNC_CONNECTION_RESIZE_STATUS_OK: VncConnectionResizeStatus = 0;
pub const VNC_CONNECTION_RESIZE_STATUS_ADMIN_PROHIBITED: VncConnectionResizeStatus = 1;
pub const VNC_CONNECTION_RESIZE_STATUS_OUT_OF_RESOURCES: VncConnectionResizeStatus = 2;
pub const VNC_CONNECTION_RESIZE_STATUS_INVALID_LAOUT: VncConnectionResizeStatus = 3;
pub const VNC_CONNECTION_RESIZE_STATUS_FORWARDED: VncConnectionResizeStatus = 4;

// Constants
pub const VNC_LEDSTATE_CAPS_LOCK: c_int = 4;
pub const VNC_LEDSTATE_NUM_LOCK: c_int = 2;
pub const VNC_LEDSTATE_SCROLL_LOCK: c_int = 1;
pub const VNC_MAJOR_VERSION: c_int = 1;
pub const VNC_MICRO_VERSION: c_int = 0;
pub const VNC_MINOR_VERSION: c_int = 2;
pub const VNC_PADDING: c_int = 4;
pub const VNC_PADDING_LARGE: c_int = 20;

// Records
#[derive(Copy, Clone)]
#[repr(C)]
pub struct VncAudioFormat {
    pub format: u8,
    pub nchannels: u8,
    pub frequency: u32,
}

impl ::std::fmt::Debug for VncAudioFormat {
    fn fmt(&self, f: &mut ::std::fmt::Formatter) -> ::std::fmt::Result {
        f.debug_struct(&format!("VncAudioFormat @ {:p}", self))
            .field("format", &self.format)
            .field("nchannels", &self.nchannels)
            .field("frequency", &self.frequency)
            .finish()
    }
}

#[derive(Copy, Clone)]
#[repr(C)]
pub struct VncAudioInterface {
    pub parent: gobject::GTypeInterface,
    pub playback_start:
        Option<unsafe extern "C" fn(*mut VncAudio, *mut VncAudioFormat) -> gboolean>,
    pub playback_stop: Option<unsafe extern "C" fn(*mut VncAudio) -> gboolean>,
    pub playback_data: Option<unsafe extern "C" fn(*mut VncAudio, *mut VncAudioSample) -> gboolean>,
}

impl ::std::fmt::Debug for VncAudioInterface {
    fn fmt(&self, f: &mut ::std::fmt::Formatter) -> ::std::fmt::Result {
        f.debug_struct(&format!("VncAudioInterface @ {:p}", self))
            .field("parent", &self.parent)
            .field("playback_start", &self.playback_start)
            .field("playback_stop", &self.playback_stop)
            .field("playback_data", &self.playback_data)
            .finish()
    }
}

#[derive(Copy, Clone)]
#[repr(C)]
pub struct VncAudioSample {
    pub data: *mut u8,
    pub length: u32,
    pub capacity: u32,
}

impl ::std::fmt::Debug for VncAudioSample {
    fn fmt(&self, f: &mut ::std::fmt::Formatter) -> ::std::fmt::Result {
        f.debug_struct(&format!("VncAudioSample @ {:p}", self))
            .field("data", &self.data)
            .field("length", &self.length)
            .field("capacity", &self.capacity)
            .finish()
    }
}

#[derive(Copy, Clone)]
#[repr(C)]
pub struct VncBaseAudioClass {
    pub parent_class: gobject::GObjectClass,
    pub playback_start:
        Option<unsafe extern "C" fn(*mut VncBaseAudio, *mut VncAudioFormat) -> gboolean>,
    pub playback_stop: Option<unsafe extern "C" fn(*mut VncBaseAudio) -> gboolean>,
    pub playback_data:
        Option<unsafe extern "C" fn(*mut VncBaseAudio, *mut VncAudioSample) -> gboolean>,
}

impl ::std::fmt::Debug for VncBaseAudioClass {
    fn fmt(&self, f: &mut ::std::fmt::Formatter) -> ::std::fmt::Result {
        f.debug_struct(&format!("VncBaseAudioClass @ {:p}", self))
            .field("parent_class", &self.parent_class)
            .field("playback_start", &self.playback_start)
            .field("playback_stop", &self.playback_stop)
            .field("playback_data", &self.playback_data)
            .finish()
    }
}

#[repr(C)]
pub struct _VncBaseAudioPrivate {
    _data: [u8; 0],
    _marker: core::marker::PhantomData<(*mut u8, core::marker::PhantomPinned)>,
}

pub type VncBaseAudioPrivate = *mut _VncBaseAudioPrivate;

#[derive(Copy, Clone)]
#[repr(C)]
pub struct VncBaseFramebufferClass {
    pub parent_class: gobject::GObjectClass,
    pub _vnc_reserved: [gpointer; 4],
}

impl ::std::fmt::Debug for VncBaseFramebufferClass {
    fn fmt(&self, f: &mut ::std::fmt::Formatter) -> ::std::fmt::Result {
        f.debug_struct(&format!("VncBaseFramebufferClass @ {:p}", self))
            .field("parent_class", &self.parent_class)
            .field("_vnc_reserved", &self._vnc_reserved)
            .finish()
    }
}

#[repr(C)]
pub struct _VncBaseFramebufferPrivate {
    _data: [u8; 0],
    _marker: core::marker::PhantomData<(*mut u8, core::marker::PhantomPinned)>,
}

pub type VncBaseFramebufferPrivate = *mut _VncBaseFramebufferPrivate;

#[derive(Copy, Clone)]
#[repr(C)]
pub struct VncColorMap {
    pub offset: u16,
    pub size: u16,
    pub colors: *mut VncColorMapEntry,
}

impl ::std::fmt::Debug for VncColorMap {
    fn fmt(&self, f: &mut ::std::fmt::Formatter) -> ::std::fmt::Result {
        f.debug_struct(&format!("VncColorMap @ {:p}", self))
            .field("offset", &self.offset)
            .field("size", &self.size)
            .field("colors", &self.colors)
            .finish()
    }
}

#[derive(Copy, Clone)]
#[repr(C)]
pub struct VncColorMapEntry {
    pub red: u16,
    pub green: u16,
    pub blue: u16,
}

impl ::std::fmt::Debug for VncColorMapEntry {
    fn fmt(&self, f: &mut ::std::fmt::Formatter) -> ::std::fmt::Result {
        f.debug_struct(&format!("VncColorMapEntry @ {:p}", self))
            .field("red", &self.red)
            .field("green", &self.green)
            .field("blue", &self.blue)
            .finish()
    }
}

#[derive(Copy, Clone)]
#[repr(C)]
pub struct VncConnectionClass {
    pub parent_class: gobject::GObjectClass,
    pub vnc_cursor_changed: Option<unsafe extern "C" fn(*mut VncConnection, *mut VncCursor)>,
    pub vnc_pointer_mode_changed: Option<unsafe extern "C" fn(*mut VncConnection, gboolean)>,
    pub vnc_bell: Option<unsafe extern "C" fn(*mut VncConnection)>,
    pub vnc_server_cut_text: Option<unsafe extern "C" fn(*mut VncConnection, *const glib::GString)>,
    pub vnc_framebuffer_update:
        Option<unsafe extern "C" fn(*mut VncConnection, u16, u16, u16, u16)>,
    pub vnc_desktop_resize: Option<unsafe extern "C" fn(*mut VncConnection, u16, u16)>,
    pub vnc_pixel_format_changed:
        Option<unsafe extern "C" fn(*mut VncConnection, *mut VncPixelFormat)>,
    pub vnc_auth_failure: Option<unsafe extern "C" fn(*mut VncConnection, *const c_char)>,
    pub vnc_auth_unsupported: Option<unsafe extern "C" fn(*mut VncConnection, c_uint)>,
    pub vnc_auth_credential:
        Option<unsafe extern "C" fn(*mut VncConnection, *mut gobject::GValueArray)>,
    pub vnc_auth_choose_type:
        Option<unsafe extern "C" fn(*mut VncConnection, *mut gobject::GValueArray)>,
    pub vnc_auth_choose_subtype:
        Option<unsafe extern "C" fn(*mut VncConnection, c_uint, *mut gobject::GValueArray)>,
    pub vnc_connected: Option<unsafe extern "C" fn(*mut VncConnection)>,
    pub vnc_initialized: Option<unsafe extern "C" fn(*mut VncConnection)>,
    pub vnc_disconnected: Option<unsafe extern "C" fn(*mut VncConnection)>,
    pub vnc_led_state: Option<unsafe extern "C" fn(*mut VncConnection)>,
    pub vnc_error: Option<unsafe extern "C" fn(*mut VncConnection, *const c_char)>,
    pub vnc_power_control_initialized: Option<unsafe extern "C" fn(*mut VncConnection)>,
    pub vnc_power_control_failed: Option<unsafe extern "C" fn(*mut VncConnection)>,
    pub vnc_desktop_rename: Option<unsafe extern "C" fn(*mut VncConnection, *const c_char)>,
    pub _vnc_reserved: [gpointer; 15],
}

impl ::std::fmt::Debug for VncConnectionClass {
    fn fmt(&self, f: &mut ::std::fmt::Formatter) -> ::std::fmt::Result {
        f.debug_struct(&format!("VncConnectionClass @ {:p}", self))
            .field("parent_class", &self.parent_class)
            .field("vnc_cursor_changed", &self.vnc_cursor_changed)
            .field("vnc_pointer_mode_changed", &self.vnc_pointer_mode_changed)
            .field("vnc_bell", &self.vnc_bell)
            .field("vnc_server_cut_text", &self.vnc_server_cut_text)
            .field("vnc_framebuffer_update", &self.vnc_framebuffer_update)
            .field("vnc_desktop_resize", &self.vnc_desktop_resize)
            .field("vnc_pixel_format_changed", &self.vnc_pixel_format_changed)
            .field("vnc_auth_failure", &self.vnc_auth_failure)
            .field("vnc_auth_unsupported", &self.vnc_auth_unsupported)
            .field("vnc_auth_credential", &self.vnc_auth_credential)
            .field("vnc_auth_choose_type", &self.vnc_auth_choose_type)
            .field("vnc_auth_choose_subtype", &self.vnc_auth_choose_subtype)
            .field("vnc_connected", &self.vnc_connected)
            .field("vnc_initialized", &self.vnc_initialized)
            .field("vnc_disconnected", &self.vnc_disconnected)
            .field("vnc_led_state", &self.vnc_led_state)
            .field("vnc_error", &self.vnc_error)
            .field(
                "vnc_power_control_initialized",
                &self.vnc_power_control_initialized,
            )
            .field("vnc_power_control_failed", &self.vnc_power_control_failed)
            .field("vnc_desktop_rename", &self.vnc_desktop_rename)
            .field("_vnc_reserved", &self._vnc_reserved)
            .finish()
    }
}

#[repr(C)]
pub struct _VncConnectionPrivate {
    _data: [u8; 0],
    _marker: core::marker::PhantomData<(*mut u8, core::marker::PhantomPinned)>,
}

pub type VncConnectionPrivate = *mut _VncConnectionPrivate;

#[derive(Copy, Clone)]
#[repr(C)]
pub struct VncCursorClass {
    pub parent_class: gobject::GObjectClass,
    pub _vnc_reserved: [gpointer; 4],
}

impl ::std::fmt::Debug for VncCursorClass {
    fn fmt(&self, f: &mut ::std::fmt::Formatter) -> ::std::fmt::Result {
        f.debug_struct(&format!("VncCursorClass @ {:p}", self))
            .field("parent_class", &self.parent_class)
            .field("_vnc_reserved", &self._vnc_reserved)
            .finish()
    }
}

#[repr(C)]
pub struct _VncCursorPrivate {
    _data: [u8; 0],
    _marker: core::marker::PhantomData<(*mut u8, core::marker::PhantomPinned)>,
}

pub type VncCursorPrivate = *mut _VncCursorPrivate;

#[derive(Copy, Clone)]
#[repr(C)]
pub struct VncFramebufferInterface {
    pub parent: gobject::GTypeInterface,
    pub get_width: Option<unsafe extern "C" fn(*mut VncFramebuffer) -> u16>,
    pub get_height: Option<unsafe extern "C" fn(*mut VncFramebuffer) -> u16>,
    pub get_rowstride: Option<unsafe extern "C" fn(*mut VncFramebuffer) -> c_int>,
    pub get_buffer: Option<unsafe extern "C" fn(*mut VncFramebuffer) -> *mut u8>,
    pub get_local_format:
        Option<unsafe extern "C" fn(*mut VncFramebuffer) -> *const VncPixelFormat>,
    pub get_remote_format:
        Option<unsafe extern "C" fn(*mut VncFramebuffer) -> *const VncPixelFormat>,
    pub perfect_format_match: Option<unsafe extern "C" fn(*mut VncFramebuffer) -> gboolean>,
    pub set_pixel_at: Option<unsafe extern "C" fn(*mut VncFramebuffer, *mut u8, u16, u16)>,
    pub fill: Option<unsafe extern "C" fn(*mut VncFramebuffer, *mut u8, u16, u16, u16, u16)>,
    pub copyrect: Option<unsafe extern "C" fn(*mut VncFramebuffer, u16, u16, u16, u16, u16, u16)>,
    pub blt: Option<unsafe extern "C" fn(*mut VncFramebuffer, *mut u8, c_int, u16, u16, u16, u16)>,
    pub rgb24_blt:
        Option<unsafe extern "C" fn(*mut VncFramebuffer, *mut u8, c_int, u16, u16, u16, u16)>,
    pub set_color_map: Option<unsafe extern "C" fn(*mut VncFramebuffer, *mut VncColorMap)>,
}

impl ::std::fmt::Debug for VncFramebufferInterface {
    fn fmt(&self, f: &mut ::std::fmt::Formatter) -> ::std::fmt::Result {
        f.debug_struct(&format!("VncFramebufferInterface @ {:p}", self))
            .field("parent", &self.parent)
            .field("get_width", &self.get_width)
            .field("get_height", &self.get_height)
            .field("get_rowstride", &self.get_rowstride)
            .field("get_buffer", &self.get_buffer)
            .field("get_local_format", &self.get_local_format)
            .field("get_remote_format", &self.get_remote_format)
            .field("perfect_format_match", &self.perfect_format_match)
            .field("set_pixel_at", &self.set_pixel_at)
            .field("fill", &self.fill)
            .field("copyrect", &self.copyrect)
            .field("blt", &self.blt)
            .field("rgb24_blt", &self.rgb24_blt)
            .field("set_color_map", &self.set_color_map)
            .finish()
    }
}

#[derive(Copy, Clone)]
#[repr(C)]
pub struct VncPixelFormat {
    pub bits_per_pixel: u8,
    pub depth: u8,
    pub byte_order: u16,
    pub true_color_flag: u8,
    pub red_max: u16,
    pub green_max: u16,
    pub blue_max: u16,
    pub red_shift: u8,
    pub green_shift: u8,
    pub blue_shift: u8,
}

impl ::std::fmt::Debug for VncPixelFormat {
    fn fmt(&self, f: &mut ::std::fmt::Formatter) -> ::std::fmt::Result {
        f.debug_struct(&format!("VncPixelFormat @ {:p}", self))
            .field("bits_per_pixel", &self.bits_per_pixel)
            .field("depth", &self.depth)
            .field("byte_order", &self.byte_order)
            .field("true_color_flag", &self.true_color_flag)
            .field("red_max", &self.red_max)
            .field("green_max", &self.green_max)
            .field("blue_max", &self.blue_max)
            .field("red_shift", &self.red_shift)
            .field("green_shift", &self.green_shift)
            .field("blue_shift", &self.blue_shift)
            .finish()
    }
}

// Classes
#[derive(Copy, Clone)]
#[repr(C)]
pub struct VncBaseAudio {
    pub parent: gobject::GObject,
    pub priv_: *mut VncBaseAudioPrivate,
}

impl ::std::fmt::Debug for VncBaseAudio {
    fn fmt(&self, f: &mut ::std::fmt::Formatter) -> ::std::fmt::Result {
        f.debug_struct(&format!("VncBaseAudio @ {:p}", self))
            .field("parent", &self.parent)
            .field("priv_", &self.priv_)
            .finish()
    }
}

#[derive(Copy, Clone)]
#[repr(C)]
pub struct VncBaseFramebuffer {
    pub parent: gobject::GObject,
    pub priv_: *mut VncBaseFramebufferPrivate,
}

impl ::std::fmt::Debug for VncBaseFramebuffer {
    fn fmt(&self, f: &mut ::std::fmt::Formatter) -> ::std::fmt::Result {
        f.debug_struct(&format!("VncBaseFramebuffer @ {:p}", self))
            .field("parent", &self.parent)
            .field("priv_", &self.priv_)
            .finish()
    }
}

#[derive(Copy, Clone)]
#[repr(C)]
pub struct VncConnection {
    pub parent: gobject::GObject,
    pub priv_: *mut VncConnectionPrivate,
}

impl ::std::fmt::Debug for VncConnection {
    fn fmt(&self, f: &mut ::std::fmt::Formatter) -> ::std::fmt::Result {
        f.debug_struct(&format!("VncConnection @ {:p}", self))
            .field("parent", &self.parent)
            .field("priv_", &self.priv_)
            .finish()
    }
}

#[derive(Copy, Clone)]
#[repr(C)]
pub struct VncCursor {
    pub parent: gobject::GObject,
    pub priv_: *mut VncCursorPrivate,
}

impl ::std::fmt::Debug for VncCursor {
    fn fmt(&self, f: &mut ::std::fmt::Formatter) -> ::std::fmt::Result {
        f.debug_struct(&format!("VncCursor @ {:p}", self))
            .field("parent", &self.parent)
            .field("priv_", &self.priv_)
            .finish()
    }
}

// Interfaces
#[repr(C)]
pub struct VncAudio {
    _data: [u8; 0],
    _marker: core::marker::PhantomData<(*mut u8, core::marker::PhantomPinned)>,
}

impl ::std::fmt::Debug for VncAudio {
    fn fmt(&self, f: &mut ::std::fmt::Formatter) -> ::std::fmt::Result {
        write!(f, "VncAudio @ {:p}", self)
    }
}

#[repr(C)]
pub struct VncFramebuffer {
    _data: [u8; 0],
    _marker: core::marker::PhantomData<(*mut u8, core::marker::PhantomPinned)>,
}

impl ::std::fmt::Debug for VncFramebuffer {
    fn fmt(&self, f: &mut ::std::fmt::Formatter) -> ::std::fmt::Result {
        write!(f, "VncFramebuffer @ {:p}", self)
    }
}

#[link(name = "gvnc-1.0")]
extern "C" {

    //=========================================================================
    // VncConnectionAuth
    //=========================================================================
    pub fn vnc_connection_auth_get_type() -> GType;

    //=========================================================================
    // VncConnectionAuthVencrypt
    //=========================================================================
    pub fn vnc_connection_auth_vencrypt_get_type() -> GType;

    //=========================================================================
    // VncConnectionCredential
    //=========================================================================
    pub fn vnc_connection_credential_get_type() -> GType;

    //=========================================================================
    // VncConnectionEncoding
    //=========================================================================
    pub fn vnc_connection_encoding_get_type() -> GType;

    //=========================================================================
    // VncConnectionPowerAction
    //=========================================================================
    pub fn vnc_connection_power_action_get_type() -> GType;

    //=========================================================================
    // VncConnectionResizeStatus
    //=========================================================================
    pub fn vnc_connection_resize_status_get_type() -> GType;

    //=========================================================================
    // VncAudioFormat
    //=========================================================================
    pub fn vnc_audio_format_get_type() -> GType;
    pub fn vnc_audio_format_new() -> *mut VncAudioFormat;
    pub fn vnc_audio_format_copy(format: *mut VncAudioFormat) -> *mut VncAudioFormat;
    pub fn vnc_audio_format_free(format: *mut VncAudioFormat);

    //=========================================================================
    // VncAudioSample
    //=========================================================================
    pub fn vnc_audio_sample_get_type() -> GType;
    pub fn vnc_audio_sample_new(capacity: u32) -> *mut VncAudioSample;
    pub fn vnc_audio_sample_copy(sample: *mut VncAudioSample) -> *mut VncAudioSample;
    pub fn vnc_audio_sample_free(sample: *mut VncAudioSample);

    //=========================================================================
    // VncColorMap
    //=========================================================================
    pub fn vnc_color_map_get_type() -> GType;
    pub fn vnc_color_map_new(offset: u16, size: u16) -> *mut VncColorMap;
    pub fn vnc_color_map_copy(map: *mut VncColorMap) -> *mut VncColorMap;
    pub fn vnc_color_map_free(map: *mut VncColorMap);
    pub fn vnc_color_map_lookup(
        map: *mut VncColorMap,
        idx: u16,
        red: *mut u16,
        green: *mut u16,
        blue: *mut u16,
    ) -> gboolean;
    pub fn vnc_color_map_set(
        map: *mut VncColorMap,
        idx: u16,
        red: u16,
        green: u16,
        blue: u16,
    ) -> gboolean;

    //=========================================================================
    // VncPixelFormat
    //=========================================================================
    pub fn vnc_pixel_format_get_type() -> GType;
    pub fn vnc_pixel_format_new() -> *mut VncPixelFormat;
    pub fn vnc_pixel_format_copy(format: *mut VncPixelFormat) -> *mut VncPixelFormat;
    pub fn vnc_pixel_format_free(format: *mut VncPixelFormat);
    pub fn vnc_pixel_format_match(
        format: *const VncPixelFormat,
        other: *const VncPixelFormat,
    ) -> gboolean;

    //=========================================================================
    // VncBaseAudio
    //=========================================================================
    pub fn vnc_base_audio_get_type() -> GType;
    pub fn vnc_base_audio_new() -> *mut VncBaseAudio;

    //=========================================================================
    // VncBaseFramebuffer
    //=========================================================================
    pub fn vnc_base_framebuffer_get_type() -> GType;
    pub fn vnc_base_framebuffer_new(
        buffer: *mut u8,
        width: u16,
        height: u16,
        rowstride: c_int,
        localFormat: *const VncPixelFormat,
        remoteFormat: *const VncPixelFormat,
    ) -> *mut VncBaseFramebuffer;

    //=========================================================================
    // VncConnection
    //=========================================================================
    pub fn vnc_connection_get_type() -> GType;
    pub fn vnc_connection_new() -> *mut VncConnection;
    pub fn vnc_connection_audio_disable(conn: *mut VncConnection) -> gboolean;
    pub fn vnc_connection_audio_enable(conn: *mut VncConnection) -> gboolean;
    pub fn vnc_connection_client_cut_text(
        conn: *mut VncConnection,
        data: *mut c_void,
        length: size_t,
    ) -> gboolean;
    pub fn vnc_connection_framebuffer_update_request(
        conn: *mut VncConnection,
        incremental: gboolean,
        x: u16,
        y: u16,
        width: u16,
        height: u16,
    ) -> gboolean;
    pub fn vnc_connection_get_abs_pointer(conn: *mut VncConnection) -> gboolean;
    pub fn vnc_connection_get_audio_format(conn: *mut VncConnection) -> *const VncAudioFormat;
    pub fn vnc_connection_get_cursor(conn: *mut VncConnection) -> *mut VncCursor;
    pub fn vnc_connection_get_ext_key_event(conn: *mut VncConnection) -> gboolean;
    pub fn vnc_connection_get_height(conn: *mut VncConnection) -> c_int;
    pub fn vnc_connection_get_ledstate(conn: *mut VncConnection) -> c_int;
    pub fn vnc_connection_get_name(conn: *mut VncConnection) -> *const c_char;
    pub fn vnc_connection_get_pixel_format(conn: *mut VncConnection) -> *const VncPixelFormat;
    pub fn vnc_connection_get_power_control(conn: *mut VncConnection) -> gboolean;
    pub fn vnc_connection_get_shared(conn: *mut VncConnection) -> gboolean;
    pub fn vnc_connection_get_width(conn: *mut VncConnection) -> c_int;
    pub fn vnc_connection_has_error(conn: *mut VncConnection) -> gboolean;
    pub fn vnc_connection_is_initialized(conn: *mut VncConnection) -> gboolean;
    pub fn vnc_connection_is_open(conn: *mut VncConnection) -> gboolean;
    pub fn vnc_connection_key_event(
        conn: *mut VncConnection,
        down_flag: gboolean,
        key: u32,
        scancode: u16,
    ) -> gboolean;
    pub fn vnc_connection_open_addr(
        conn: *mut VncConnection,
        addr: *mut gio::GSocketAddress,
        hostname: *const c_char,
    ) -> gboolean;
    pub fn vnc_connection_open_fd(conn: *mut VncConnection, fd: c_int) -> gboolean;
    pub fn vnc_connection_open_fd_with_hostname(
        conn: *mut VncConnection,
        fd: c_int,
        hostname: *const c_char,
    ) -> gboolean;
    pub fn vnc_connection_open_host(
        conn: *mut VncConnection,
        host: *const c_char,
        port: *const c_char,
    ) -> gboolean;
    pub fn vnc_connection_pointer_event(
        conn: *mut VncConnection,
        button_mask: u8,
        x: u16,
        y: u16,
    ) -> gboolean;
    pub fn vnc_connection_power_control(
        conn: *mut VncConnection,
        action: VncConnectionPowerAction,
    ) -> gboolean;
    pub fn vnc_connection_set_audio(conn: *mut VncConnection, audio: *mut VncAudio) -> gboolean;
    pub fn vnc_connection_set_audio_format(
        conn: *mut VncConnection,
        fmt: *const VncAudioFormat,
    ) -> gboolean;
    pub fn vnc_connection_set_auth_subtype(conn: *mut VncConnection, type_: c_uint) -> gboolean;
    pub fn vnc_connection_set_auth_type(conn: *mut VncConnection, type_: c_uint) -> gboolean;
    pub fn vnc_connection_set_credential(
        conn: *mut VncConnection,
        type_: c_int,
        data: *const c_char,
    ) -> gboolean;
    pub fn vnc_connection_set_encodings(
        conn: *mut VncConnection,
        n_encoding: c_int,
        encoding: *mut i32,
    ) -> gboolean;
    pub fn vnc_connection_set_framebuffer(
        conn: *mut VncConnection,
        fb: *mut VncFramebuffer,
    ) -> gboolean;
    pub fn vnc_connection_set_pixel_format(
        conn: *mut VncConnection,
        fmt: *const VncPixelFormat,
    ) -> gboolean;
    pub fn vnc_connection_set_shared(conn: *mut VncConnection, shared: gboolean) -> gboolean;
    pub fn vnc_connection_set_size(
        conn: *mut VncConnection,
        width: c_uint,
        height: c_uint,
    ) -> VncConnectionResizeStatus;
    pub fn vnc_connection_shutdown(conn: *mut VncConnection);

    //=========================================================================
    // VncCursor
    //=========================================================================
    pub fn vnc_cursor_get_type() -> GType;
    pub fn vnc_cursor_new(
        data: *mut u8,
        hotx: u16,
        hoty: u16,
        width: u16,
        height: u16,
    ) -> *mut VncCursor;
    pub fn vnc_cursor_get_data(cursor: *mut VncCursor) -> *const u8;
    pub fn vnc_cursor_get_height(cursor: *mut VncCursor) -> u16;
    pub fn vnc_cursor_get_hotx(cursor: *mut VncCursor) -> u16;
    pub fn vnc_cursor_get_hoty(cursor: *mut VncCursor) -> u16;
    pub fn vnc_cursor_get_width(cursor: *mut VncCursor) -> u16;

    //=========================================================================
    // VncAudio
    //=========================================================================
    pub fn vnc_audio_get_type() -> GType;
    pub fn vnc_audio_playback_data(aud: *mut VncAudio, sample: *mut VncAudioSample);
    pub fn vnc_audio_playback_start(aud: *mut VncAudio, format: *mut VncAudioFormat);
    pub fn vnc_audio_playback_stop(aud: *mut VncAudio);

    //=========================================================================
    // VncFramebuffer
    //=========================================================================
    pub fn vnc_framebuffer_get_type() -> GType;
    pub fn vnc_framebuffer_blt(
        fb: *mut VncFramebuffer,
        src: *mut u8,
        rowstride: c_int,
        x: u16,
        y: u16,
        width: u16,
        height: u16,
    );
    pub fn vnc_framebuffer_copyrect(
        fb: *mut VncFramebuffer,
        srcx: u16,
        srcy: u16,
        dstx: u16,
        dsty: u16,
        width: u16,
        height: u16,
    );
    pub fn vnc_framebuffer_fill(
        fb: *mut VncFramebuffer,
        src: *mut u8,
        x: u16,
        y: u16,
        width: u16,
        height: u16,
    );
    pub fn vnc_framebuffer_get_buffer(fb: *mut VncFramebuffer) -> *mut u8;
    pub fn vnc_framebuffer_get_height(fb: *mut VncFramebuffer) -> u16;
    pub fn vnc_framebuffer_get_local_format(fb: *mut VncFramebuffer) -> *const VncPixelFormat;
    pub fn vnc_framebuffer_get_remote_format(fb: *mut VncFramebuffer) -> *const VncPixelFormat;
    pub fn vnc_framebuffer_get_rowstride(fb: *mut VncFramebuffer) -> c_int;
    pub fn vnc_framebuffer_get_width(fb: *mut VncFramebuffer) -> u16;
    pub fn vnc_framebuffer_perfect_format_match(fb: *mut VncFramebuffer) -> gboolean;
    pub fn vnc_framebuffer_rgb24_blt(
        fb: *mut VncFramebuffer,
        src: *mut u8,
        rowstride: c_int,
        x: u16,
        y: u16,
        width: u16,
        height: u16,
    );
    pub fn vnc_framebuffer_set_color_map(fb: *mut VncFramebuffer, map: *mut VncColorMap);
    pub fn vnc_framebuffer_set_pixel_at(fb: *mut VncFramebuffer, src: *mut u8, x: u16, y: u16);

    //=========================================================================
    // Other functions
    //=========================================================================
    pub fn vnc_util_check_version(major: c_int, minor: c_int, micro: c_int) -> gboolean;
    pub fn vnc_util_get_debug() -> gboolean;
    pub fn vnc_util_get_version() -> c_int;
    pub fn vnc_util_get_version_string() -> *const c_char;
    pub fn vnc_util_set_debug(enabled: gboolean);

}
