// This file was generated by gir (https://github.com/gtk-rs/gir)
// from gir-files (https://github.com/gtk-rs/gir-files.git)
// DO NOT EDIT

use gvnc_sys::*;
use std::env;
use std::error::Error;
use std::ffi::OsString;
use std::mem::{align_of, size_of};
use std::path::Path;
use std::process::Command;
use std::str;
use tempfile::Builder;

static PACKAGES: &[&str] = &["gvnc-1.0"];

#[derive(Clone, Debug)]
struct Compiler {
    pub args: Vec<String>,
}

impl Compiler {
    pub fn new() -> Result<Self, Box<dyn Error>> {
        let mut args = get_var("CC", "cc")?;
        args.push("-Wno-deprecated-declarations".to_owned());
        // For _Generic
        args.push("-std=c11".to_owned());
        // For %z support in printf when using MinGW.
        args.push("-D__USE_MINGW_ANSI_STDIO".to_owned());
        args.extend(get_var("CFLAGS", "")?);
        args.extend(get_var("CPPFLAGS", "")?);
        args.extend(pkg_config_cflags(PACKAGES)?);
        Ok(Self { args })
    }

    pub fn compile(&self, src: &Path, out: &Path) -> Result<(), Box<dyn Error>> {
        let mut cmd = self.to_command();
        cmd.arg(src);
        cmd.arg("-o");
        cmd.arg(out);
        let status = cmd.spawn()?.wait()?;
        if !status.success() {
            return Err(format!("compilation command {:?} failed, {}", &cmd, status).into());
        }
        Ok(())
    }

    fn to_command(&self) -> Command {
        let mut cmd = Command::new(&self.args[0]);
        cmd.args(&self.args[1..]);
        cmd
    }
}

fn get_var(name: &str, default: &str) -> Result<Vec<String>, Box<dyn Error>> {
    match env::var(name) {
        Ok(value) => Ok(shell_words::split(&value)?),
        Err(env::VarError::NotPresent) => Ok(shell_words::split(default)?),
        Err(err) => Err(format!("{} {}", name, err).into()),
    }
}

fn pkg_config_cflags(packages: &[&str]) -> Result<Vec<String>, Box<dyn Error>> {
    if packages.is_empty() {
        return Ok(Vec::new());
    }
    let pkg_config = env::var_os("PKG_CONFIG").unwrap_or_else(|| OsString::from("pkg-config"));
    let mut cmd = Command::new(pkg_config);
    cmd.arg("--cflags");
    cmd.args(packages);
    let out = cmd.output()?;
    if !out.status.success() {
        return Err(format!("command {:?} returned {}", &cmd, out.status).into());
    }
    let stdout = str::from_utf8(&out.stdout)?;
    Ok(shell_words::split(stdout.trim())?)
}

#[derive(Copy, Clone, Debug, Eq, PartialEq)]
struct Layout {
    size: usize,
    alignment: usize,
}

#[derive(Copy, Clone, Debug, Default, Eq, PartialEq)]
struct Results {
    /// Number of successfully completed tests.
    passed: usize,
    /// Total number of failed tests (including those that failed to compile).
    failed: usize,
}

impl Results {
    fn record_passed(&mut self) {
        self.passed += 1;
    }
    fn record_failed(&mut self) {
        self.failed += 1;
    }
    fn summary(&self) -> String {
        format!("{} passed; {} failed", self.passed, self.failed)
    }
    fn expect_total_success(&self) {
        if self.failed == 0 {
            println!("OK: {}", self.summary());
        } else {
            panic!("FAILED: {}", self.summary());
        };
    }
}

#[test]
fn cross_validate_constants_with_c() {
    let mut c_constants: Vec<(String, String)> = Vec::new();

    for l in get_c_output("constant").unwrap().lines() {
        let mut words = l.trim().split(';');
        let name = words.next().expect("Failed to parse name").to_owned();
        let value = words
            .next()
            .and_then(|s| s.parse().ok())
            .expect("Failed to parse value");
        c_constants.push((name, value));
    }

    let mut results = Results::default();

    for ((rust_name, rust_value), (c_name, c_value)) in
        RUST_CONSTANTS.iter().zip(c_constants.iter())
    {
        if rust_name != c_name {
            results.record_failed();
            eprintln!("Name mismatch:\nRust: {:?}\nC:    {:?}", rust_name, c_name,);
            continue;
        }

        if rust_value != c_value {
            results.record_failed();
            eprintln!(
                "Constant value mismatch for {}\nRust: {:?}\nC:    {:?}",
                rust_name, rust_value, &c_value
            );
            continue;
        }

        results.record_passed();
    }

    results.expect_total_success();
}

#[test]
fn cross_validate_layout_with_c() {
    let mut c_layouts = Vec::new();

    for l in get_c_output("layout").unwrap().lines() {
        let mut words = l.trim().split(';');
        let name = words.next().expect("Failed to parse name").to_owned();
        let size = words
            .next()
            .and_then(|s| s.parse().ok())
            .expect("Failed to parse size");
        let alignment = words
            .next()
            .and_then(|s| s.parse().ok())
            .expect("Failed to parse alignment");
        c_layouts.push((name, Layout { size, alignment }));
    }

    let mut results = Results::default();

    for ((rust_name, rust_layout), (c_name, c_layout)) in RUST_LAYOUTS.iter().zip(c_layouts.iter())
    {
        if rust_name != c_name {
            results.record_failed();
            eprintln!("Name mismatch:\nRust: {:?}\nC:    {:?}", rust_name, c_name,);
            continue;
        }

        if rust_layout != c_layout {
            results.record_failed();
            eprintln!(
                "Layout mismatch for {}\nRust: {:?}\nC:    {:?}",
                rust_name, rust_layout, &c_layout
            );
            continue;
        }

        results.record_passed();
    }

    results.expect_total_success();
}

fn get_c_output(name: &str) -> Result<String, Box<dyn Error>> {
    let tmpdir = Builder::new().prefix("abi").tempdir()?;
    let exe = tmpdir.path().join(name);
    let c_file = Path::new("tests").join(name).with_extension("c");

    let cc = Compiler::new().expect("configured compiler");
    cc.compile(&c_file, &exe)?;

    let mut abi_cmd = Command::new(exe);
    let output = abi_cmd.output()?;
    if !output.status.success() {
        return Err(format!("command {:?} failed, {:?}", &abi_cmd, &output).into());
    }

    Ok(String::from_utf8(output.stdout)?)
}

const RUST_LAYOUTS: &[(&str, Layout)] = &[
    (
        "VncAudioFormat",
        Layout {
            size: size_of::<VncAudioFormat>(),
            alignment: align_of::<VncAudioFormat>(),
        },
    ),
    (
        "VncAudioFormatType",
        Layout {
            size: size_of::<VncAudioFormatType>(),
            alignment: align_of::<VncAudioFormatType>(),
        },
    ),
    (
        "VncAudioInterface",
        Layout {
            size: size_of::<VncAudioInterface>(),
            alignment: align_of::<VncAudioInterface>(),
        },
    ),
    (
        "VncAudioSample",
        Layout {
            size: size_of::<VncAudioSample>(),
            alignment: align_of::<VncAudioSample>(),
        },
    ),
    (
        "VncBaseAudio",
        Layout {
            size: size_of::<VncBaseAudio>(),
            alignment: align_of::<VncBaseAudio>(),
        },
    ),
    (
        "VncBaseAudioClass",
        Layout {
            size: size_of::<VncBaseAudioClass>(),
            alignment: align_of::<VncBaseAudioClass>(),
        },
    ),
    (
        "VncBaseFramebuffer",
        Layout {
            size: size_of::<VncBaseFramebuffer>(),
            alignment: align_of::<VncBaseFramebuffer>(),
        },
    ),
    (
        "VncBaseFramebufferClass",
        Layout {
            size: size_of::<VncBaseFramebufferClass>(),
            alignment: align_of::<VncBaseFramebufferClass>(),
        },
    ),
    (
        "VncColorMap",
        Layout {
            size: size_of::<VncColorMap>(),
            alignment: align_of::<VncColorMap>(),
        },
    ),
    (
        "VncColorMapEntry",
        Layout {
            size: size_of::<VncColorMapEntry>(),
            alignment: align_of::<VncColorMapEntry>(),
        },
    ),
    (
        "VncConnection",
        Layout {
            size: size_of::<VncConnection>(),
            alignment: align_of::<VncConnection>(),
        },
    ),
    (
        "VncConnectionAuth",
        Layout {
            size: size_of::<VncConnectionAuth>(),
            alignment: align_of::<VncConnectionAuth>(),
        },
    ),
    (
        "VncConnectionAuthVencrypt",
        Layout {
            size: size_of::<VncConnectionAuthVencrypt>(),
            alignment: align_of::<VncConnectionAuthVencrypt>(),
        },
    ),
    (
        "VncConnectionClass",
        Layout {
            size: size_of::<VncConnectionClass>(),
            alignment: align_of::<VncConnectionClass>(),
        },
    ),
    (
        "VncConnectionCredential",
        Layout {
            size: size_of::<VncConnectionCredential>(),
            alignment: align_of::<VncConnectionCredential>(),
        },
    ),
    (
        "VncConnectionEncoding",
        Layout {
            size: size_of::<VncConnectionEncoding>(),
            alignment: align_of::<VncConnectionEncoding>(),
        },
    ),
    (
        "VncConnectionPowerAction",
        Layout {
            size: size_of::<VncConnectionPowerAction>(),
            alignment: align_of::<VncConnectionPowerAction>(),
        },
    ),
    (
        "VncConnectionResizeStatus",
        Layout {
            size: size_of::<VncConnectionResizeStatus>(),
            alignment: align_of::<VncConnectionResizeStatus>(),
        },
    ),
    (
        "VncCursor",
        Layout {
            size: size_of::<VncCursor>(),
            alignment: align_of::<VncCursor>(),
        },
    ),
    (
        "VncCursorClass",
        Layout {
            size: size_of::<VncCursorClass>(),
            alignment: align_of::<VncCursorClass>(),
        },
    ),
    (
        "VncFramebufferInterface",
        Layout {
            size: size_of::<VncFramebufferInterface>(),
            alignment: align_of::<VncFramebufferInterface>(),
        },
    ),
    (
        "VncPixelFormat",
        Layout {
            size: size_of::<VncPixelFormat>(),
            alignment: align_of::<VncPixelFormat>(),
        },
    ),
];

const RUST_CONSTANTS: &[(&str, &str)] = &[
    ("(gint) VNC_AUDIO_FORMAT_RAW_S16", "3"),
    ("(gint) VNC_AUDIO_FORMAT_RAW_S32", "5"),
    ("(gint) VNC_AUDIO_FORMAT_RAW_S8", "1"),
    ("(gint) VNC_AUDIO_FORMAT_RAW_U16", "2"),
    ("(gint) VNC_AUDIO_FORMAT_RAW_U32", "4"),
    ("(gint) VNC_AUDIO_FORMAT_RAW_U8", "0"),
    ("(gint) VNC_CONNECTION_AUTH_ARD", "30"),
    ("(gint) VNC_CONNECTION_AUTH_INVALID", "0"),
    ("(gint) VNC_CONNECTION_AUTH_MSLOGON", "-6"),
    ("(gint) VNC_CONNECTION_AUTH_MSLOGONII", "113"),
    ("(gint) VNC_CONNECTION_AUTH_NONE", "1"),
    ("(gint) VNC_CONNECTION_AUTH_RA2", "5"),
    ("(gint) VNC_CONNECTION_AUTH_RA2NE", "6"),
    ("(gint) VNC_CONNECTION_AUTH_SASL", "20"),
    ("(gint) VNC_CONNECTION_AUTH_TIGHT", "16"),
    ("(gint) VNC_CONNECTION_AUTH_TLS", "18"),
    ("(gint) VNC_CONNECTION_AUTH_ULTRA", "17"),
    ("(gint) VNC_CONNECTION_AUTH_VENCRYPT", "19"),
    ("(gint) VNC_CONNECTION_AUTH_VENCRYPT_PLAIN", "256"),
    ("(gint) VNC_CONNECTION_AUTH_VENCRYPT_TLSNONE", "257"),
    ("(gint) VNC_CONNECTION_AUTH_VENCRYPT_TLSPLAIN", "259"),
    ("(gint) VNC_CONNECTION_AUTH_VENCRYPT_TLSSASL", "264"),
    ("(gint) VNC_CONNECTION_AUTH_VENCRYPT_TLSVNC", "258"),
    ("(gint) VNC_CONNECTION_AUTH_VENCRYPT_X509NONE", "260"),
    ("(gint) VNC_CONNECTION_AUTH_VENCRYPT_X509PLAIN", "262"),
    ("(gint) VNC_CONNECTION_AUTH_VENCRYPT_X509SASL", "263"),
    ("(gint) VNC_CONNECTION_AUTH_VENCRYPT_X509VNC", "261"),
    ("(gint) VNC_CONNECTION_AUTH_VNC", "2"),
    ("(gint) VNC_CONNECTION_CREDENTIAL_CLIENTNAME", "2"),
    ("(gint) VNC_CONNECTION_CREDENTIAL_PASSWORD", "0"),
    ("(gint) VNC_CONNECTION_CREDENTIAL_USERNAME", "1"),
    ("(gint) VNC_CONNECTION_ENCODING_ALPHA_CURSOR", "-314"),
    ("(gint) VNC_CONNECTION_ENCODING_AUDIO", "-259"),
    ("(gint) VNC_CONNECTION_ENCODING_COPY_RECT", "1"),
    ("(gint) VNC_CONNECTION_ENCODING_CORRE", "4"),
    ("(gint) VNC_CONNECTION_ENCODING_CURSOR_POS", "-232"),
    ("(gint) VNC_CONNECTION_ENCODING_DESKTOP_NAME", "-307"),
    ("(gint) VNC_CONNECTION_ENCODING_DESKTOP_RESIZE", "-223"),
    (
        "(gint) VNC_CONNECTION_ENCODING_EXTENDED_DESKTOP_RESIZE",
        "-308",
    ),
    ("(gint) VNC_CONNECTION_ENCODING_EXT_KEY_EVENT", "-258"),
    ("(gint) VNC_CONNECTION_ENCODING_HEXTILE", "5"),
    ("(gint) VNC_CONNECTION_ENCODING_LAST_RECT", "-224"),
    ("(gint) VNC_CONNECTION_ENCODING_LED_STATE", "-261"),
    ("(gint) VNC_CONNECTION_ENCODING_POINTER_CHANGE", "-257"),
    ("(gint) VNC_CONNECTION_ENCODING_RAW", "0"),
    ("(gint) VNC_CONNECTION_ENCODING_RICH_CURSOR", "-239"),
    ("(gint) VNC_CONNECTION_ENCODING_RRE", "2"),
    ("(gint) VNC_CONNECTION_ENCODING_TIGHT", "7"),
    ("(gint) VNC_CONNECTION_ENCODING_TIGHT_JPEG0", "-32"),
    ("(gint) VNC_CONNECTION_ENCODING_TIGHT_JPEG1", "-31"),
    ("(gint) VNC_CONNECTION_ENCODING_TIGHT_JPEG2", "-30"),
    ("(gint) VNC_CONNECTION_ENCODING_TIGHT_JPEG3", "-29"),
    ("(gint) VNC_CONNECTION_ENCODING_TIGHT_JPEG4", "-28"),
    ("(gint) VNC_CONNECTION_ENCODING_TIGHT_JPEG5", "-27"),
    ("(gint) VNC_CONNECTION_ENCODING_TIGHT_JPEG6", "-26"),
    ("(gint) VNC_CONNECTION_ENCODING_TIGHT_JPEG7", "-25"),
    ("(gint) VNC_CONNECTION_ENCODING_TIGHT_JPEG8", "-24"),
    ("(gint) VNC_CONNECTION_ENCODING_TIGHT_JPEG9", "-23"),
    ("(gint) VNC_CONNECTION_ENCODING_WMVi", "1464686185"),
    ("(gint) VNC_CONNECTION_ENCODING_XCURSOR", "-240"),
    ("(gint) VNC_CONNECTION_ENCODING_XVP", "-309"),
    ("(gint) VNC_CONNECTION_ENCODING_ZRLE", "16"),
    ("(gint) VNC_CONNECTION_POWER_ACTION_REBOOT", "3"),
    ("(gint) VNC_CONNECTION_POWER_ACTION_RESET", "4"),
    ("(gint) VNC_CONNECTION_POWER_ACTION_SHUTDOWN", "2"),
    ("(gint) VNC_CONNECTION_RESIZE_STATUS_ADMIN_PROHIBITED", "1"),
    ("(gint) VNC_CONNECTION_RESIZE_STATUS_FORWARDED", "4"),
    ("(gint) VNC_CONNECTION_RESIZE_STATUS_INVALID_LAOUT", "3"),
    ("(gint) VNC_CONNECTION_RESIZE_STATUS_OK", "0"),
    ("(gint) VNC_CONNECTION_RESIZE_STATUS_OUT_OF_RESOURCES", "2"),
    ("(gint) VNC_CONNECTION_RESIZE_STATUS_UNSUPPORTED", "-1"),
    ("VNC_LEDSTATE_CAPS_LOCK", "4"),
    ("VNC_LEDSTATE_NUM_LOCK", "2"),
    ("VNC_LEDSTATE_SCROLL_LOCK", "1"),
    ("VNC_MAJOR_VERSION", "1"),
    ("VNC_MICRO_VERSION", "0"),
    ("VNC_MINOR_VERSION", "2"),
    ("VNC_PADDING", "4"),
    ("VNC_PADDING_LARGE", "20"),
];
